#ifndef INCU_PIPE
#define INCU_PIPE
#include <iostream>

namespace incu {

  int move_fd(int to, int from);

  class Pipe {
  public:
    Pipe();
    ~Pipe();

    // Set delete_buffer to false if the buffers should not be deleted,
    // e.g. if we are working on a vfork.
    void closeReader(bool delete_buffer = true);
    void closeWriter(bool delete_buffer = true);

    // deprecated - use the filebuffs to create streams instead
    int reader() const { return filedesc[0]; }
    int writer() const { return filedesc[1]; }

    // These buffers will be deleted when the Socket is closed!
    // Be sure to be rid of all streams using them before that!
    std::streambuf* getReadBuf();
    std::streambuf* getWriteBuf();
    
  private:
    int filedesc[2];
    std::streambuf *inbuf, *outbuf;
  };

};

#endif
