/************************************************************************/
/* File		webpublish.cpp						*/
/*									*/
/* Purpose	This C++ program file contains the implementation for	*/
/*		the WebPublish class. The WebPublish class can be used	*/
/*		to publish one or more websites to one or more servers.	*/
/*									*/
/* Author	This C++ program file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ program file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	0.1.0 (Prototype)					*/
/*									*/
/* Date		Sunday, July 7, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

/* Include	These are the header files used by program file.	*/

#include "webpublish.h"			// WebPublish header file.

/* The following variable is the error message array that is specific	*/
/* to the WebPublish class. The default UtilityModule error values are	*/
/* overwritten by the WebPublish object constructor.			*/

      static char *errormessages[] =
         {
             "No error",				// NoError
	     "Default constructor used",		// Default
	     "Bad command line option",			// BadCmd
	     "Repeated command line option",		// RepeatCmd
	     "Only one action at a time",		// OneAct
	     "No action requested",			// NoAct
	     "Missing command line argument",		// MissingCmd
	     "Unknown $HOME directory",			// NoHome
	     "Could not make WebPublish directory",	// NoDir
	     "Could not make DataBase files",		// DataMake
	     "Could not open DataBase files",		// DataOpen
	     "Could not close DataBase files",		// DataClose
	     "Error initializing WebPublish object",	// BadInit
	     "WebPublish object is not initialized",	// NotInit
	     "Could not get database record",		// BadGet
	     "Required information is missing",		// Required
	     "Record exists in database",		// Exist
	     "Record does not exist in database",	// NoExist
	     "Could not store record in database",	// BadStore
	     "Could not remove record in database",	// BadDel
	     "Account does not exist",			// BadAccount
	     "Could not establish FTP connection",	// BadHost
	     "Could not logon to FTP server",		// BadLogon
	     "Could not close FTP connection",		// FTPClose
	     "Unknown action requested",		// BadCase
	     "Illegal file transfer mode",		// NotMode
	     "Shell program crashed and burned",	// BadShell
	     "Shell program returned error",		// ShellVal
	     "Unknown shell program return value",	// NotShell
	     "Could not change server directory",	// ChangeDir
	     "Could not transfer file",			// PutFile
	     "Could not get stats",			// BadStat
	     "Could not get mod time from server",	// NoMod
	     "Could not open local directory",		// DirOpen
	     "Could not read local directory",		// DirRead
	     "Could not make server directory",		// DirMake
	     "Unknown database file",			// BadDBFile
	     "Cannot change database record",		// BadChange
         };

/************************************************************************/
/* Function	WebPublish()						*/
/*									*/
/* Purpose	This is the default constructor for a WebPublish	*/
/*		object. This constructor should not be used. Use	*/
/*		WebPublish(int, char**) instead.			*/
/************************************************************************/

WebPublish::WebPublish()
   {
      /* Reimplement the UtilityModule error variables .		*/

      itsmodulename	= "WebPublish";
      itsmaxerror	= WebPublishErrors;
      itserrormessages	= errormessages;

      // The default constructor should not be used.

      itserror		= WebPublishDefault;
      Report_Error();
   }

/************************************************************************/
/* Function	WebPublish(int argc, char** argv)			*/
/*									*/
/* Purpose	This is the constructor that should be used to create a	*/
/*		new WebPublish object. It accepts 'argc' and 'argv' as	*/
/*		input.							*/
/*									*/
/* Input	'argc' and 'argv' represent the standard C++ command	*/
/*		line arguments passed to the main program function.	*/
/************************************************************************/

WebPublish::WebPublish(int argc, char** argv)
   {
      /* Reimplement the UtilityModule error variables .		*/

      itsmodulename	= "WebPublish";
      itsmaxerror	= WebPublishErrors;
      itserrormessages	= errormessages;

      itshelpflag	= false;
      itsversionflag	= false;
      itsverboseflag	= false;
      itsinitflag	= false;
      itsdbopenflag	= false;
      itsloggedonflag	= false;
      itsforceflag	= false;
      itspromptflag	= false;
      itsdepth		= -1;
      itsmode		= FTPBinary;
      itsoperation	= WebPublishNoCommand;
      itsfileitem	= -1;
      itssinglecount	= 0;
      itssingles	= (String*)0;
      if (parse_command_line_arguments(argc, argv) == ERROR)
         {
	    /* Error initializing WebPublish object.			*/

	    itserror	= WebPublishBadInit;
	    Report_Error();
	 }
      else if (initialize_webpublish_database() == ERROR)
         {
	    /* Error initializing WebPublish object.			*/

	    itserror	= WebPublishBadInit;
	    Report_Error();
         }
      else
         {
	    itsinitflag	= true;
	 }
   }

/************************************************************************/
/* Function	~WebPublish()						*/
/*									*/
/* Purpose	This is the default destructor for a WebPublish object.	*/
/*		This destructor will free up all allocated memory.	*/
/************************************************************************/

WebPublish::~WebPublish()
   {
      if (itsdbopenflag == true)
         {
	    itsdatabase.Close_DataBase_Files();
	 }
      if (itssingles != (String*)0)
         {
	    delete [] itssingles;
	 }
   }

/************************************************************************/
/* Function	Process(void)						*/
/*									*/
/* Purpose	This public member function is responsible for		*/
/*		processing the command that was passed to the object's	*/
/*		constructor when the object was created.		*/
/*									*/
/* Input	This function expects the member variable		*/
/*		'itsoperation' to contain a code representing the	*/
/*		command to execute. 'itsoperation' is set by the	*/
/*		objects constructor.					*/
/*									*/
/* Output	This function will return the value of 'itserror'. If	*/
/*		the return value is equal to WEBPUBERR_NOERROR then	*/
/*		the command was executed correctly. If the return value	*/
/*		is not WEBPUBERR_NOERR then it contains the WebPublish	*/
/*		error code representing the problem. All WebPublish	*/
/*		errors are reported to stderr as soon as they occur.	*/
/************************************************************************/

status WebPublish::Process(void)
   {
      status		result		= OK;

      if (itsinitflag == false)
         {
	    itserror	= WebPublishNotInit;
	    result	= ERROR;
	    Report_Error();
	 }
      else
         {
            if (itsverboseflag == true || itshelpflag == true ||
               itsversionflag == true)
               {
                  print_webpublish_copyright();
               }
            if (itshelpflag == true)
               {
                  print_webpublish_help();
               }
            if (itsversionflag == true)
               {
                  print_webpublish_version();
               }
            switch(itsoperation)
               {
                  case WebPublishNoCommand:	// No command
                     if (itsversionflag == false && itshelpflag == false)
                        {
			   /* No action requested.			*/

                           itserror	= WebPublishNoAct;
			   result	= ERROR;
			   Report_Error();
                        }
                     break;
		  case WebPublishDoPublish:
		     result		= publish();
		     break;
		  case WebPublishDoSynch:
		     result		= synchronize();
		     break;
		  case WebPublishDoAdd:
		     switch(itsfileitem)
		        {
			   case WebPublishAccounts:
			      result	= add_account();
			      break;
			   case WebPublishShell:
			      result	= add_shell();
			      break;
			   case WebPublishSynch:
			      result	= add_synch();
			      break;
			   case WebPublishPublish:
			      result	= add_publish();
			      break;
			   case WebPublishModes:
			      result	= add_mode();
			      break;
			   default:
			      itserrorinfo	= "You must specify the "
						  "database file (-F)";
			      itserror	= WebPublishBadDBFile;
			      result	= ERROR;
			      Report_Error();
			}
		     break;
		  case WebPublishDoChange:
		     switch(itsfileitem)
		        {
			   case WebPublishAccounts:
			      result	= change_account();
			      break;
			   case WebPublishShell:
			      result	= change_shell();
			      break;
			   case WebPublishSynch:
			      itserrorinfo	= "Synch records cannot "
						  "be changed";
			      itserror	= WebPublishBadChange;
			      result	= ERROR;
			      Report_Error();
			      break;
			   case WebPublishPublish:
			      itserrorinfo	= "Publish records "
						  "cannot be changed";
			      itserror	= WebPublishBadChange;
			      result	= ERROR;
			      Report_Error();
			      break;
			   case WebPublishModes:
			      result	= change_mode();
			      break;
			   default:
			      itserrorinfo	= "You must specify the "
						  "database file (-F)";
			      itserror	= WebPublishBadDBFile;
			      result	= ERROR;
			      Report_Error();
			}
		     break;
		  case WebPublishDoRemove:
		     switch(itsfileitem)
		        {
			   case WebPublishAccounts:
			      result	= delete_account();
			      break;
			   case WebPublishShell:
			      result	= delete_shell();
			      break;
			   case WebPublishSynch:
			      result	= delete_synch();
			      break;
			   case WebPublishPublish:
			      result	= delete_publish();
			      break;
			   case WebPublishModes:
			      result	= delete_mode();
			      break;
			   default:
			      itserrorinfo	= "You must specify the "
						  "database file (-F)";
			      itserror	= WebPublishBadDBFile;
			      result	= ERROR;
			      Report_Error();
			}
		     break;
		  case WebPublishDoList:
		     switch(itsfileitem)
		        {
			   case WebPublishAccounts:
			      result	= list_account();
			      break;
			   case WebPublishShell:
			      result	= list_shell();
			      break;
			   case WebPublishSynch:
			      result	= list_synch();
			      break;
			   case WebPublishPublish:
			      result	= list_publish();
			      break;
			   case WebPublishModes:
			      result	= list_mode();
			      break;
			   default:
			      itserrorinfo	= "You must specify the "
						  "database file (-F)";
			      itserror	= WebPublishBadDBFile;
			      result	= ERROR;
			      Report_Error();
			}
		     break;
		  default:
		     itserror	= WebPublishBadCase;
		     result	= ERROR;
		     Report_Error();
              }
         }
      return(result);
   }
