/************************************************************************/
/* File		ftp.h							*/
/*									*/
/* Purpose	This C++ header file contains the definition for the	*/
/*		FTP class. The C++ interface provides File Transfer	*/
/*		Protocol (FTP) functions.				*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00 (Prototype)					*/
/*									*/
/* Date		Monday, May 20, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef FTP_H				// If not defined...
#define FTP_H				// Then process the header file.

/* Headers	The following headers are required by ftp.h.		*/

#include "utilitymodule.h"
#include "ftplib.h"

/* Enumeration	The following enumeration defines the values for the	*/
/*		FTPMode. The FTPMode is used to designate binary or	*/
/*		text mode when transferring a file.			*/

enum FTPMode
   {
      FTPBinary		= 'I',		// Binary mode.
      FTPText		= 'A'		// Text mode.
   };

/* Constant	The following constant defines the name of a temporary	*/
/*		file that is used by this library. The temporary file	*/
/*		is used to get a directory from the server.		*/

const char FTPTempFile[]	= "/tmp/FTPdirectory";

/* Constants	The following constants define the error values that	*/
/*		are used by the FTP library. These values are used to	*/
/*		specify a specific library error.			*/

const int FTPErrors		= 20;	// Number of error constants.
const int FTPNoError		= 0;	// No error.
const int FTPConnected		= 1;	// Already connected to a host.
const int FTPNotConnected	= 2;	// Not connected to a host.
const int FTPBadConnect		= 3;	// Could not make connection.
const int FTPBadLogon		= 4;	// Could not log onto server.
const int FTPBadWorkDir		= 5;	// Could not get server's CWD.
const int FTPGetDir		= 6;	// Could not get dir from server.
const int FTPNotDir		= 7;	// Directory does not exist.
const int FTPDirExist		= 8;	// Directory exists on server.
const int FTPMakeDir		= 9;	// Could not create directory.
const int FTPDelDir		= 10;	// Could not remove directory.
const int FTPNoType		= 11;	// Could not get system type.
const int FTPParentDir		= 12;	// Could not change to parent.
const int FTPBadSize		= 13;	// Could not get size of file.
const int FTPBadMod		= 14;	// Could not get mod date.
const int FTPBadGet		= 15;	// Could not get file.
const int FTPBadPut		= 16;	// Could not put file.
const int FTPBadRename		= 17;	// Could not rename file.
const int FTPBadDel		= 18;	// Could not delete file.
const int FTPPathBuff		= 19;	// File path buffer overflow.

/* Class	This is the definition for the FTP class. The FTP class	*/
/*		provides a C++ interface for the File Transfer Protocol	*/
/*		(FTP) functions.					*/

class FTP : public UtilityModule
   {
      public:
         FTP();
	 ~FTP();

	 // Connection functions.

	 status Connect_To_Host(const char*);
	 status Connect_To_Host(const String&);
	 status Logon_To_Host(const char*, const char*);
	 status Logon_To_Host(const String&, const String&);
	 status Close_Connection_To_Host(void);
	 status Get_System_Type(String&);

	 // Directory functions.

	 condition Does_Directory_Exist(const String&);
	 status Get_Work_Directory(String&);
	 status Get_Directory(const String&, int&, String*&);
	 status Create_Directory(const String&);
	 status Create_Recursive_Directory(const String&);
	 status Remove_Directory(const String&);
	 status Purge_Directory(const String&);
	 status Change_Work_Directory(const String&);
	 status Change_To_Parent_Directory(void);

	 // File functions.

	 condition Does_File_Exist(const String&);
	 status Get_File_Size(const String&, int&, const FTPMode);
	 status Get_Modification_Time(const String&, String&);
	 status Get_File(const String&, const String&, const FTPMode);
	 status Put_File(const String&, const String&, const FTPMode);
	 status Rename_File(const String&, const String&);
	 status Remove_File(const String&);

      private:
         condition		itschangedirflag;
         String			itshostname;
         netbuf*		itsnetbuf;
	 String			itsbasecwd;

	 void get_time_from_entry(const String&, String&);
	 condition is_item_in_list(const String&, const String&);
	 status get_modification_time(const String&, String&);
   };

#endif					// FTP_H
