/************************************************************************/
/* File		datarecord.h						*/
/*									*/
/* Purpose	This C++ header file contains the definition for the	*/
/*		DataRecord class. The DataRecord class defines the	*/
/*		record structure of the records that are managed by the	*/
/*		DataBase class.						*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00 (Prototype)					*/
/*									*/
/* Date		Sunday, June 23, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef DATARECORD_H			// If not defined...
#define DATARECORD_H			// Then process the header file.

/* Headers	The following headers are required by datarecord.h.	*/

#include "file.h"			// File class.
#include "dataelement.h"		// DataElement class.

/* Class	The following class defines the DataRecord class. The	*/
/*		DataRecord class defines the record structure for the	*/
/*		records that are managed by the DataBase class.		*/

class DataRecord
   {
      public:
	 DataRecord();
	 DataRecord(const int, const DataElementType*);
	 DataRecord(const DataRecord&);
	 ~DataRecord();

	 int Record_Size(void);
	 status Read_From_File(File&, const int);
	 status Write_To_File(File&, const int);

	 void Set_Record_Elements(const int, const DataElementType*);
	 DataElementType Get_Element_Type(const int) const;
	 void Clear_Record(void);
	 void Copy_Record(const DataRecord&);

	 void Set_Data(const int, const String&);
	 void Set_Data(const int, const int);
	 void Set_Data(const int, const float);
	 void Set_Data(const int, const DataElementTimeType&);
	 void Set_Data(const int, const DataElementDateType&);

	 void Get_Data(const int, String&);
	 void Get_Data(const int, int&);
	 void Get_Data(const int, float&);
	 void Get_Data(const int, DataElementTimeType&);
	 void Get_Data(const int, DataElementDateType&);

	 void Get_Key(String& key);

      private:
	 int			itselementcount;
	 DataElement*		itselements;

	 void set_record_elements(const int, const DataElementType*);
   };

#endif					// DATARECORD_H
