/************************************************************************/
/* File		database.h						*/
/*									*/
/* Purpose	This C++ header file contains the definition for the	*/
/*		DataBase class. The DataBase class manages manages an	*/
/*		array of DataFile objects. Each DataFile object stores	*/
/*		DataRecord records in a file and the DataFile object	*/
/*		indexes the DataRecord records with a DataIndex file.	*/
/*		Each DataRecord record is an array of DataElement	*/
/*		objects.						*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00 (Prototype)					*/
/*									*/
/* Date		Sunday, June 23, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef DATABASE_H			// If not defined...
#define DATABASE_H			// Then process the header file.

/* Headers	The following headers are required by database.h.	*/

#include "datafile.h"			// DataFile class.

const int DataBaseDirMode	= PhysicalOSOwnRead | PhysicalOSOwnWrite |
				  PhysicalOSGrpRead | PhysicalOSGrpWrite;

const int DataBaseErrors	= 15;	// Max error messages.
const int DataBaseNoError	= 0;	// No error.
const int DataBaseBadDir	= 1;	// Could not create directory.
const int DataBaseCanOpen	= 2;	// DataBase object not prepared.
const int DataBaseNotOpen	= 3;	// DataBase is not open.
const int DataBaseRange		= 4;	// DataFile index is out of range.
const int DataBaseNoMake	= 5;	// Could not create files.
const int DataBaseNoOpen	= 6;	// Could not open files.
const int DataBaseNoClose	= 7;	// Could not close files.
const int DataBaseStore		= 8;	// Could not store record.
const int DataBaseRemove	= 9;	// Could not remove record.
const int DataBaseGet		= 10;	// Could not get record.
const int DataBaseFirst		= 11;	// Could not get first record.
const int DataBaseNext		= 12;	// Could not get next record.
const int DataBaseLast		= 13;	// Could not get last record.
const int DataBasePrevious	= 14;	// Could not get previous record.

/* Class	The following class defines the DataBase class. The	*/
/*		DataBase class manages an array of DataFile objects.	*/

class DataBase : public UtilityModule
   {
      public:
	 DataBase();
	 DataBase(const String&, const int, const String*, const int*,
	    const DataElementType*, const int = DataBaseDirMode);
	 ~DataBase();

	 int Record_Size(void);
	 status Read_From_File(File&, const int);
	 status Write_To_File(File&, const int);

	 void Prepare_DataBase(const String&, const int, const String*,
	    const int*, const DataElementType*,
	    const int = DataBaseDirMode);
	 void Format_Record(const int, DataRecord&);

	 status Create_DataBase_Files(void);
	 status Open_DataBase_Files(void);
	 status Close_DataBase_Files(void);
	 status Store_Record(const int, DataRecord&);
	 status Remove_Record(const int, DataRecord&);
	 status Get_Record(const int, DataRecord&);
	 status Get_First_Record(const int, DataRecord&);
	 status Get_Next_Record(const int, DataRecord&);
	 status Get_Last_Record(const int, DataRecord&);
	 status Get_Previous_Record(const int, DataRecord&);

      private:
	 Dir				itsdir;
	 condition			itscanopenflag;
	 condition			itsisopenflag;
	 String				itsdirectory;
	 int				itsfilecount;
	 DataFile*			itsfiles;
   };

#endif					// DATABASE_H

