// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_4_4_autogen.cpp:
//   Defines the GL 4.4 entry points.

#include "libGL/entry_points_gl_4_4_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils_autogen.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL44_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BindBuffersBase(GLenum target, GLuint first, GLsizei count, const GLuint *buffers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindBuffersBase",
          "context = %d, GLenum target = %s, GLuint first = %u, GLsizei count = %d, const GLuint "
          "*buffers = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target), first, count,
          (uintptr_t)buffers);

    if (context)
    {
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindBuffersBase(context, target, first, count, buffersPacked));
        if (isCallValid)
        {
            context->bindBuffersBase(target, first, count, buffersPacked);
        }
        ANGLE_CAPTURE(BindBuffersBase, isCallValid, context, target, first, count, buffersPacked);
    }
}

void GL_APIENTRY BindBuffersRange(GLenum target,
                                  GLuint first,
                                  GLsizei count,
                                  const GLuint *buffers,
                                  const GLintptr *offsets,
                                  const GLsizeiptr *sizes)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindBuffersRange",
          "context = %d, GLenum target = %s, GLuint first = %u, GLsizei count = %d, const GLuint "
          "*buffers = 0x%016" PRIxPTR ", const GLintptr *offsets = 0x%016" PRIxPTR
          ", const GLsizeiptr *sizes = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::BufferTargetARB, target), first, count,
          (uintptr_t)buffers, (uintptr_t)offsets, (uintptr_t)sizes);

    if (context)
    {
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindBuffersRange(context, target, first, count,
                                                                   buffersPacked, offsets, sizes));
        if (isCallValid)
        {
            context->bindBuffersRange(target, first, count, buffersPacked, offsets, sizes);
        }
        ANGLE_CAPTURE(BindBuffersRange, isCallValid, context, target, first, count, buffersPacked,
                      offsets, sizes);
    }
}

void GL_APIENTRY BindImageTextures(GLuint first, GLsizei count, const GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindImageTextures",
          "context = %d, GLuint first = %u, GLsizei count = %d, const GLuint *textures = "
          "0x%016" PRIxPTR "",
          CID(context), first, count, (uintptr_t)textures);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBindImageTextures(context, first, count, textures));
        if (isCallValid)
        {
            context->bindImageTextures(first, count, textures);
        }
        ANGLE_CAPTURE(BindImageTextures, isCallValid, context, first, count, textures);
    }
}

void GL_APIENTRY BindSamplers(GLuint first, GLsizei count, const GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindSamplers",
          "context = %d, GLuint first = %u, GLsizei count = %d, const GLuint *samplers = "
          "0x%016" PRIxPTR "",
          CID(context), first, count, (uintptr_t)samplers);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindSamplers(context, first, count, samplers));
        if (isCallValid)
        {
            context->bindSamplers(first, count, samplers);
        }
        ANGLE_CAPTURE(BindSamplers, isCallValid, context, first, count, samplers);
    }
}

void GL_APIENTRY BindTextures(GLuint first, GLsizei count, const GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindTextures",
          "context = %d, GLuint first = %u, GLsizei count = %d, const GLuint *textures = "
          "0x%016" PRIxPTR "",
          CID(context), first, count, (uintptr_t)textures);

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindTextures(context, first, count, textures));
        if (isCallValid)
        {
            context->bindTextures(first, count, textures);
        }
        ANGLE_CAPTURE(BindTextures, isCallValid, context, first, count, textures);
    }
}

void GL_APIENTRY BindVertexBuffers(GLuint first,
                                   GLsizei count,
                                   const GLuint *buffers,
                                   const GLintptr *offsets,
                                   const GLsizei *strides)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBindVertexBuffers",
          "context = %d, GLuint first = %u, GLsizei count = %d, const GLuint *buffers = "
          "0x%016" PRIxPTR ", const GLintptr *offsets = 0x%016" PRIxPTR
          ", const GLsizei *strides = 0x%016" PRIxPTR "",
          CID(context), first, count, (uintptr_t)buffers, (uintptr_t)offsets, (uintptr_t)strides);

    if (context)
    {
        const BufferID *buffersPacked                 = FromGL<const BufferID *>(buffers);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBindVertexBuffers(context, first, count, buffersPacked, offsets, strides));
        if (isCallValid)
        {
            context->bindVertexBuffers(first, count, buffersPacked, offsets, strides);
        }
        ANGLE_CAPTURE(BindVertexBuffers, isCallValid, context, first, count, buffersPacked, offsets,
                      strides);
    }
}

void GL_APIENTRY BufferStorage(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags)
{
    Context *context = GetValidGlobalContext();
    EVENT("glBufferStorage",
          "context = %d, GLenum target = %s, GLsizeiptr size = %llu, const void *data = "
          "0x%016" PRIxPTR ", GLbitfield flags = %s",
          CID(context), GLenumToString(GLenumGroup::BufferStorageTarget, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLbitfieldToString(GLenumGroup::MapBufferUsageMask, flags).c_str());

    if (context)
    {
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                              = (context->skipValidation() ||
                            ValidateBufferStorage(context, target, size, data, flags));
        if (isCallValid)
        {
            context->bufferStorage(target, size, data, flags);
        }
        ANGLE_CAPTURE(BufferStorage, isCallValid, context, target, size, data, flags);
    }
}

void GL_APIENTRY
ClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearTexImage",
          "context = %d, GLuint texture = %u, GLint level = %d, GLenum format = %s, GLenum type = "
          "%s, const void *data = 0x%016" PRIxPTR "",
          CID(context), texture, level, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateClearTexImage(context, texturePacked, level, format, type, data));
        if (isCallValid)
        {
            context->clearTexImage(texturePacked, level, format, type, data);
        }
        ANGLE_CAPTURE(ClearTexImage, isCallValid, context, texturePacked, level, format, type,
                      data);
    }
}

void GL_APIENTRY ClearTexSubImage(GLuint texture,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLint zoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLsizei depth,
                                  GLenum format,
                                  GLenum type,
                                  const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT("glClearTexSubImage",
          "context = %d, GLuint texture = %u, GLint level = %d, GLint xoffset = %d, GLint yoffset "
          "= %d, GLint zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, "
          "GLenum format = %s, GLenum type = %s, const void *data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
          GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked                       = FromGL<TextureID>(texture);
        std::unique_lock<std::mutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateClearTexSubImage(context, texturePacked, level, xoffset, yoffset, zoffset,
                                      width, height, depth, format, type, data));
        if (isCallValid)
        {
            context->clearTexSubImage(texturePacked, level, xoffset, yoffset, zoffset, width,
                                      height, depth, format, type, data);
        }
        ANGLE_CAPTURE(ClearTexSubImage, isCallValid, context, texturePacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, type, data);
    }
}
}  // namespace gl
