// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_3_1_autogen.cpp:
//   Capture functions for the OpenGL ES 3.1 entry points.

#include "libANGLE/capture_gles_3_1_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/gl_enum_utils_autogen.h"
#include "libANGLE/validationES31.h"

using namespace angle;

namespace gl
{

CallCapture CaptureActiveShaderProgram(const Context *context,
                                       bool isCallValid,
                                       ProgramPipelineID pipelinePacked,
                                       ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(gl::EntryPoint::ActiveShaderProgram, std::move(paramBuffer));
}

CallCapture CaptureBindImageTexture(const Context *context,
                                    bool isCallValid,
                                    GLuint unit,
                                    TextureID texturePacked,
                                    GLint level,
                                    GLboolean layered,
                                    GLint layer,
                                    GLenum access,
                                    GLenum format)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("unit", ParamType::TGLuint, unit);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("layered", ParamType::TGLboolean, layered);
    paramBuffer.addValueParam("layer", ParamType::TGLint, layer);
    paramBuffer.addEnumParam("access", GLenumGroup::BufferAccessARB, ParamType::TGLenum, access);
    paramBuffer.addEnumParam("format", GLenumGroup::InternalFormat, ParamType::TGLenum, format);

    return CallCapture(gl::EntryPoint::BindImageTexture, std::move(paramBuffer));
}

CallCapture CaptureBindProgramPipeline(const Context *context,
                                       bool isCallValid,
                                       ProgramPipelineID pipelinePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    return CallCapture(gl::EntryPoint::BindProgramPipeline, std::move(paramBuffer));
}

CallCapture CaptureBindVertexBuffer(const Context *context,
                                    bool isCallValid,
                                    GLuint bindingindex,
                                    BufferID bufferPacked,
                                    GLintptr offset,
                                    GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(gl::EntryPoint::BindVertexBuffer, std::move(paramBuffer));
}

CallCapture CaptureCreateShaderProgramv(const Context *context,
                                        bool isCallValid,
                                        ShaderType typePacked,
                                        GLsizei count,
                                        const GLchar *const *strings,
                                        GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TShaderType, typePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture stringsParam("strings", ParamType::TGLcharConstPointerPointer);
    InitParamValue(ParamType::TGLcharConstPointerPointer, strings, &stringsParam.value);
    CaptureCreateShaderProgramv_strings(context, isCallValid, typePacked, count, strings,
                                        &stringsParam);
    paramBuffer.addParam(std::move(stringsParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::CreateShaderProgramv, std::move(paramBuffer));
}

CallCapture CaptureDeleteProgramPipelines(const Context *context,
                                          bool isCallValid,
                                          GLsizei n,
                                          const ProgramPipelineID *pipelinesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture pipelinesPackedParam("pipelinesPacked", ParamType::TProgramPipelineIDConstPointer);
    InitParamValue(ParamType::TProgramPipelineIDConstPointer, pipelinesPacked,
                   &pipelinesPackedParam.value);
    CaptureDeleteProgramPipelines_pipelinesPacked(context, isCallValid, n, pipelinesPacked,
                                                  &pipelinesPackedParam);
    paramBuffer.addParam(std::move(pipelinesPackedParam));

    return CallCapture(gl::EntryPoint::DeleteProgramPipelines, std::move(paramBuffer));
}

CallCapture CaptureDispatchCompute(const Context *context,
                                   bool isCallValid,
                                   GLuint num_groups_x,
                                   GLuint num_groups_y,
                                   GLuint num_groups_z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_groups_x", ParamType::TGLuint, num_groups_x);
    paramBuffer.addValueParam("num_groups_y", ParamType::TGLuint, num_groups_y);
    paramBuffer.addValueParam("num_groups_z", ParamType::TGLuint, num_groups_z);

    return CallCapture(gl::EntryPoint::DispatchCompute, std::move(paramBuffer));
}

CallCapture CaptureDispatchComputeIndirect(const Context *context,
                                           bool isCallValid,
                                           GLintptr indirect)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("indirect", ParamType::TGLintptr, indirect);

    return CallCapture(gl::EntryPoint::DispatchComputeIndirect, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysIndirect(const Context *context,
                                      bool isCallValid,
                                      PrimitiveMode modePacked,
                                      const void *indirect)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
    CaptureDrawArraysIndirect_indirect(context, isCallValid, modePacked, indirect, &indirectParam);
    paramBuffer.addParam(std::move(indirectParam));

    return CallCapture(gl::EntryPoint::DrawArraysIndirect, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsIndirect(const Context *context,
                                        bool isCallValid,
                                        PrimitiveMode modePacked,
                                        DrawElementsType typePacked,
                                        const void *indirect)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
    CaptureDrawElementsIndirect_indirect(context, isCallValid, modePacked, typePacked, indirect,
                                         &indirectParam);
    paramBuffer.addParam(std::move(indirectParam));

    return CallCapture(gl::EntryPoint::DrawElementsIndirect, std::move(paramBuffer));
}

CallCapture CaptureFramebufferParameteri(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum pname,
                                         GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::FramebufferParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(gl::EntryPoint::FramebufferParameteri, std::move(paramBuffer));
}

CallCapture CaptureGenProgramPipelines(const Context *context,
                                       bool isCallValid,
                                       GLsizei n,
                                       ProgramPipelineID *pipelinesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture pipelinesPackedParam("pipelinesPacked", ParamType::TProgramPipelineIDPointer);
    InitParamValue(ParamType::TProgramPipelineIDPointer, pipelinesPacked,
                   &pipelinesPackedParam.value);
    CaptureGenProgramPipelines_pipelinesPacked(context, isCallValid, n, pipelinesPacked,
                                               &pipelinesPackedParam);
    paramBuffer.addParam(std::move(pipelinesPackedParam));

    return CallCapture(gl::EntryPoint::GenProgramPipelines, std::move(paramBuffer));
}

CallCapture CaptureGetBooleani_v(const Context *context,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::BufferTargetARB, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
    InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
    CaptureGetBooleani_v_data(context, isCallValid, target, index, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetBooleani_v, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferParameteriv(const Context *context,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferParameteriv_params(context, isCallValid, target, pname, params,
                                            &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFramebufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefv(const Context *context,
                                    bool isCallValid,
                                    GLenum pname,
                                    GLuint index,
                                    GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture valParam("val", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
    CaptureGetMultisamplefv_val(context, isCallValid, pname, index, val, &valParam);
    paramBuffer.addParam(std::move(valParam));

    return CallCapture(gl::EntryPoint::GetMultisamplefv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramInterfaceiv(const Context *context,
                                         bool isCallValid,
                                         ShaderProgramID programPacked,
                                         GLenum programInterface,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addEnumParam("pname", GLenumGroup::ProgramInterfacePName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramInterfaceiv_params(context, isCallValid, programPacked, programInterface,
                                        pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetProgramInterfaceiv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramPipelineInfoLog(const Context *context,
                                             bool isCallValid,
                                             ProgramPipelineID pipelinePacked,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramPipelineInfoLog_length(context, isCallValid, pipelinePacked, bufSize, length,
                                            infoLog, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
    CaptureGetProgramPipelineInfoLog_infoLog(context, isCallValid, pipelinePacked, bufSize, length,
                                             infoLog, &infoLogParam);
    paramBuffer.addParam(std::move(infoLogParam));

    return CallCapture(gl::EntryPoint::GetProgramPipelineInfoLog, std::move(paramBuffer));
}

CallCapture CaptureGetProgramPipelineiv(const Context *context,
                                        bool isCallValid,
                                        ProgramPipelineID pipelinePacked,
                                        GLenum pname,
                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::PipelineParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramPipelineiv_params(context, isCallValid, pipelinePacked, pname, params,
                                       &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetProgramPipelineiv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceIndex(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLenum programInterface,
                                           const GLchar *name,
                                           GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetProgramResourceIndex_name(context, isCallValid, programPacked, programInterface, name,
                                        &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetProgramResourceIndex, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceLocation(const Context *context,
                                              bool isCallValid,
                                              ShaderProgramID programPacked,
                                              GLenum programInterface,
                                              const GLchar *name,
                                              GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetProgramResourceLocation_name(context, isCallValid, programPacked, programInterface,
                                           name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetProgramResourceLocation, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceName(const Context *context,
                                          bool isCallValid,
                                          ShaderProgramID programPacked,
                                          GLenum programInterface,
                                          GLuint index,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramResourceName_length(context, isCallValid, programPacked, programInterface,
                                         index, bufSize, length, name, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
    CaptureGetProgramResourceName_name(context, isCallValid, programPacked, programInterface, index,
                                       bufSize, length, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::GetProgramResourceName, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceiv(const Context *context,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        GLenum programInterface,
                                        GLuint index,
                                        GLsizei propCount,
                                        const GLenum *props,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("propCount", ParamType::TGLsizei, propCount);

    ParamCapture propsParam("props", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, props, &propsParam.value);
    CaptureGetProgramResourceiv_props(context, isCallValid, programPacked, programInterface, index,
                                      propCount, props, bufSize, length, params, &propsParam);
    paramBuffer.addParam(std::move(propsParam));

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramResourceiv_length(context, isCallValid, programPacked, programInterface, index,
                                       propCount, props, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramResourceiv_params(context, isCallValid, programPacked, programInterface, index,
                                       propCount, props, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetProgramResourceiv, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfv(const Context *context,
                                          bool isCallValid,
                                          TextureTarget targetPacked,
                                          GLint level,
                                          GLenum pname,
                                          GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterfv_params(context, isCallValid, targetPacked, level, pname, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexLevelParameterfv, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameteriv(const Context *context,
                                          bool isCallValid,
                                          TextureTarget targetPacked,
                                          GLint level,
                                          GLenum pname,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameteriv_params(context, isCallValid, targetPacked, level, pname, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexLevelParameteriv, std::move(paramBuffer));
}

CallCapture CaptureIsProgramPipeline(const Context *context,
                                     bool isCallValid,
                                     ProgramPipelineID pipelinePacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsProgramPipeline, std::move(paramBuffer));
}

CallCapture CaptureMemoryBarrier(const Context *context, bool isCallValid, GLbitfield barriers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("barriers", GLenumGroup::MemoryBarrierMask, ParamType::TGLbitfield,
                             barriers);

    return CallCapture(gl::EntryPoint::MemoryBarrier, std::move(paramBuffer));
}

CallCapture CaptureMemoryBarrierByRegion(const Context *context,
                                         bool isCallValid,
                                         GLbitfield barriers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("barriers", GLenumGroup::MemoryBarrierMask, ParamType::TGLbitfield,
                             barriers);

    return CallCapture(gl::EntryPoint::MemoryBarrierByRegion, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1f(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLfloat v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);

    return CallCapture(gl::EntryPoint::ProgramUniform1f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1fv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniform1fv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform1fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1i(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);

    return CallCapture(gl::EntryPoint::ProgramUniform1i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1iv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureProgramUniform1iv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform1iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1ui(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLuint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);

    return CallCapture(gl::EntryPoint::ProgramUniform1ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1uiv(const Context *context,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureProgramUniform1uiv_value(context, isCallValid, programPacked, location, count, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform1uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2f(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLfloat v0,
                                    GLfloat v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);

    return CallCapture(gl::EntryPoint::ProgramUniform2f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2fv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniform2fv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2i(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLint v0,
                                    GLint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);

    return CallCapture(gl::EntryPoint::ProgramUniform2i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2iv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureProgramUniform2iv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform2iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2ui(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLuint v0,
                                     GLuint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);

    return CallCapture(gl::EntryPoint::ProgramUniform2ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2uiv(const Context *context,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureProgramUniform2uiv_value(context, isCallValid, programPacked, location, count, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform2uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3f(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLfloat v0,
                                    GLfloat v1,
                                    GLfloat v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);

    return CallCapture(gl::EntryPoint::ProgramUniform3f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3fv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniform3fv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform3fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3i(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLint v0,
                                    GLint v1,
                                    GLint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);

    return CallCapture(gl::EntryPoint::ProgramUniform3i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3iv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureProgramUniform3iv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform3iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3ui(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLuint v0,
                                     GLuint v1,
                                     GLuint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);

    return CallCapture(gl::EntryPoint::ProgramUniform3ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3uiv(const Context *context,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureProgramUniform3uiv_value(context, isCallValid, programPacked, location, count, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform3uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4f(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLfloat v0,
                                    GLfloat v1,
                                    GLfloat v2,
                                    GLfloat v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLfloat, v3);

    return CallCapture(gl::EntryPoint::ProgramUniform4f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4fv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniform4fv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4i(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLint v0,
                                    GLint v1,
                                    GLint v2,
                                    GLint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLint, v3);

    return CallCapture(gl::EntryPoint::ProgramUniform4i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4iv(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureProgramUniform4iv_value(context, isCallValid, programPacked, location, count, value,
                                   &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform4iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4ui(const Context *context,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLint location,
                                     GLuint v0,
                                     GLuint v1,
                                     GLuint v2,
                                     GLuint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLuint, v3);

    return CallCapture(gl::EntryPoint::ProgramUniform4ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4uiv(const Context *context,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
    CaptureProgramUniform4uiv_value(context, isCallValid, programPacked, location, count, value,
                                    &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniform4uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2fv(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix2fv_value(context, isCallValid, programPacked, location, count,
                                         transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x3fv(const Context *context,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix2x3fv_value(context, isCallValid, programPacked, location, count,
                                           transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix2x3fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x4fv(const Context *context,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix2x4fv_value(context, isCallValid, programPacked, location, count,
                                           transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix2x4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3fv(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix3fv_value(context, isCallValid, programPacked, location, count,
                                         transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix3fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x2fv(const Context *context,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix3x2fv_value(context, isCallValid, programPacked, location, count,
                                           transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix3x2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x4fv(const Context *context,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix3x4fv_value(context, isCallValid, programPacked, location, count,
                                           transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix3x4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4fv(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix4fv_value(context, isCallValid, programPacked, location, count,
                                         transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x2fv(const Context *context,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix4x2fv_value(context, isCallValid, programPacked, location, count,
                                           transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix4x2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x3fv(const Context *context,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureProgramUniformMatrix4x3fv_value(context, isCallValid, programPacked, location, count,
                                           transpose, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::ProgramUniformMatrix4x3fv, std::move(paramBuffer));
}

CallCapture CaptureSampleMaski(const Context *context,
                               bool isCallValid,
                               GLuint maskNumber,
                               GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("maskNumber", ParamType::TGLuint, maskNumber);
    paramBuffer.addEnumParam("mask", GLenumGroup::DefaultGroup, ParamType::TGLbitfield, mask);

    return CallCapture(gl::EntryPoint::SampleMaski, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DMultisample(const Context *context,
                                           bool isCallValid,
                                           TextureType targetPacked,
                                           GLsizei samples,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(gl::EntryPoint::TexStorage2DMultisample, std::move(paramBuffer));
}

CallCapture CaptureUseProgramStages(const Context *context,
                                    bool isCallValid,
                                    ProgramPipelineID pipelinePacked,
                                    GLbitfield stages,
                                    ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addEnumParam("stages", GLenumGroup::UseProgramStageMask, ParamType::TGLbitfield,
                             stages);
    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(gl::EntryPoint::UseProgramStages, std::move(paramBuffer));
}

CallCapture CaptureValidateProgramPipeline(const Context *context,
                                           bool isCallValid,
                                           ProgramPipelineID pipelinePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    return CallCapture(gl::EntryPoint::ValidateProgramPipeline, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribBinding(const Context *context,
                                       bool isCallValid,
                                       GLuint attribindex,
                                       GLuint bindingindex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);

    return CallCapture(gl::EntryPoint::VertexAttribBinding, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribFormat(const Context *context,
                                      bool isCallValid,
                                      GLuint attribindex,
                                      GLint size,
                                      VertexAttribType typePacked,
                                      GLboolean normalized,
                                      GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(gl::EntryPoint::VertexAttribFormat, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribIFormat(const Context *context,
                                       bool isCallValid,
                                       GLuint attribindex,
                                       GLint size,
                                       VertexAttribType typePacked,
                                       GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(gl::EntryPoint::VertexAttribIFormat, std::move(paramBuffer));
}

CallCapture CaptureVertexBindingDivisor(const Context *context,
                                        bool isCallValid,
                                        GLuint bindingindex,
                                        GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(gl::EntryPoint::VertexBindingDivisor, std::move(paramBuffer));
}

}  // namespace gl
