// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// frame_capture_replay_autogen.cpp:
//   Util function to dispatch captured GL calls through Context and replay them.

#include "angle_gl.h"

#include "common/debug.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/FrameCapture.h"

using namespace gl;

namespace angle
{

void FrameCapture::ReplayCall(gl::Context *context,
                              ReplayContext *replayContext,
                              const CallCapture &call)
{
    const ParamBuffer &params = call.params;
    switch (call.entryPoint)
    {
        case gl::EntryPoint::ActiveShaderProgram:
            context->activeShaderProgram(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("programPacked", ParamType::TShaderProgramID, 1)
                    .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::ActiveTexture:
            context->activeTexture(
                params.getParam("texture", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::AlphaFunc:
            context->alphaFunc(
                params.getParam("funcPacked", ParamType::TAlphaTestFunc, 0).value.AlphaTestFuncVal,
                params.getParam("ref", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::AlphaFuncx:
            context->alphaFuncx(
                params.getParam("funcPacked", ParamType::TAlphaTestFunc, 0).value.AlphaTestFuncVal,
                params.getParam("ref", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case gl::EntryPoint::AttachShader:
            context->attachShader(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("shaderPacked", ParamType::TShaderProgramID, 1)
                                      .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::BeginQuery:
            context->beginQuery(
                params.getParam("targetPacked", ParamType::TQueryType, 0).value.QueryTypeVal,
                params.getParam("idPacked", ParamType::TQueryID, 1).value.QueryIDVal);
            break;
        case gl::EntryPoint::BeginTransformFeedback:
            context->beginTransformFeedback(
                params.getParam("primitiveModePacked", ParamType::TPrimitiveMode, 0)
                    .value.PrimitiveModeVal);
            break;
        case gl::EntryPoint::BindAttribLocation:
            context->bindAttribLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case gl::EntryPoint::BindBuffer:
            context->bindBuffer(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 1).value.BufferIDVal);
            break;
        case gl::EntryPoint::BindBufferBase:
            context->bindBufferBase(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 2).value.BufferIDVal);
            break;
        case gl::EntryPoint::BindBufferRange:
            context->bindBufferRange(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 2).value.BufferIDVal,
                params.getParam("offset", ParamType::TGLintptr, 3).value.GLintptrVal,
                params.getParam("size", ParamType::TGLsizeiptr, 4).value.GLsizeiptrVal);
            break;
        case gl::EntryPoint::BindFragDataLocation:
            context->bindFragDataLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("color", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case gl::EntryPoint::BindFragDataLocationIndexed:
            context->bindFragDataLocationIndexed(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("colorNumber", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("index", ParamType::TGLuint, 2).value.GLuintVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 3)));
            break;
        case gl::EntryPoint::BindFramebuffer:
            context->bindFramebuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("framebufferPacked", ParamType::TFramebufferID, 1)
                    .value.FramebufferIDVal);
            break;
        case gl::EntryPoint::BindImageTexture:
            context->bindImageTexture(
                params.getParam("unit", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("texturePacked", ParamType::TTextureID, 1).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("layered", ParamType::TGLboolean, 3).value.GLbooleanVal,
                params.getParam("layer", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("access", ParamType::TGLenum, 5).value.GLenumVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal);
            break;
        case gl::EntryPoint::BindProgramPipeline:
            context->bindProgramPipeline(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal);
            break;
        case gl::EntryPoint::BindRenderbuffer:
            context->bindRenderbuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("renderbufferPacked", ParamType::TRenderbufferID, 1)
                    .value.RenderbufferIDVal);
            break;
        case gl::EntryPoint::BindSampler:
            context->bindSampler(
                params.getParam("unit", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("samplerPacked", ParamType::TSamplerID, 1).value.SamplerIDVal);
            break;
        case gl::EntryPoint::BindTexture:
            context->bindTexture(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("texturePacked", ParamType::TTextureID, 1).value.TextureIDVal);
            break;
        case gl::EntryPoint::BindTransformFeedback:
            context->bindTransformFeedback(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("idPacked", ParamType::TTransformFeedbackID, 1)
                    .value.TransformFeedbackIDVal);
            break;
        case gl::EntryPoint::BindVertexArray:
            context->bindVertexArray(params.getParam("arrayPacked", ParamType::TVertexArrayID, 0)
                                         .value.VertexArrayIDVal);
            break;
        case gl::EntryPoint::BindVertexBuffer:
            context->bindVertexBuffer(
                params.getParam("bindingindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 1).value.BufferIDVal,
                params.getParam("offset", ParamType::TGLintptr, 2).value.GLintptrVal,
                params.getParam("stride", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::BlendColor:
            context->blendColor(params.getParam("red", ParamType::TGLfloat, 0).value.GLfloatVal,
                                params.getParam("green", ParamType::TGLfloat, 1).value.GLfloatVal,
                                params.getParam("blue", ParamType::TGLfloat, 2).value.GLfloatVal,
                                params.getParam("alpha", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case gl::EntryPoint::BlendEquation:
            context->blendEquation(params.getParam("mode", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::BlendEquationSeparate:
            context->blendEquationSeparate(
                params.getParam("modeRGB", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("modeAlpha", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case gl::EntryPoint::BlendFunc:
            context->blendFunc(params.getParam("sfactor", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("dfactor", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case gl::EntryPoint::BlendFuncSeparate:
            context->blendFuncSeparate(
                params.getParam("sfactorRGB", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("dfactorRGB", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("sfactorAlpha", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("dfactorAlpha", ParamType::TGLenum, 3).value.GLenumVal);
            break;
        case gl::EntryPoint::BlitFramebuffer:
            context->blitFramebuffer(
                params.getParam("srcX0", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("srcY0", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("srcX1", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("srcY1", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("dstX0", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("dstY0", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("dstX1", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("dstY1", ParamType::TGLint, 7).value.GLintVal,
                params.getParam("mask", ParamType::TGLbitfield, 8).value.GLbitfieldVal,
                params.getParam("filter", ParamType::TGLenum, 9).value.GLenumVal);
            break;
        case gl::EntryPoint::BufferData:
            context->bufferData(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("size", ParamType::TGLsizeiptr, 1).value.GLsizeiptrVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 2)),
                params.getParam("usagePacked", ParamType::TBufferUsage, 3).value.BufferUsageVal);
            break;
        case gl::EntryPoint::BufferSubData:
            context->bufferSubData(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("offset", ParamType::TGLintptr, 1).value.GLintptrVal,
                params.getParam("size", ParamType::TGLsizeiptr, 2).value.GLsizeiptrVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 3)));
            break;
        case gl::EntryPoint::CheckFramebufferStatus:
            context->checkFramebufferStatus(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::Clear:
            context->clear(params.getParam("mask", ParamType::TGLbitfield, 0).value.GLbitfieldVal);
            break;
        case gl::EntryPoint::ClearBufferfi:
            context->clearBufferfi(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("depth", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("stencil", ParamType::TGLint, 3).value.GLintVal);
            break;
        case gl::EntryPoint::ClearBufferfv:
            context->clearBufferfv(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::ClearBufferiv:
            context->clearBufferiv(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::ClearBufferuiv:
            context->clearBufferuiv(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case gl::EntryPoint::ClearColor:
            context->clearColor(params.getParam("red", ParamType::TGLfloat, 0).value.GLfloatVal,
                                params.getParam("green", ParamType::TGLfloat, 1).value.GLfloatVal,
                                params.getParam("blue", ParamType::TGLfloat, 2).value.GLfloatVal,
                                params.getParam("alpha", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case gl::EntryPoint::ClearColorx:
            context->clearColorx(params.getParam("red", ParamType::TGLfixed, 0).value.GLfixedVal,
                                 params.getParam("green", ParamType::TGLfixed, 1).value.GLfixedVal,
                                 params.getParam("blue", ParamType::TGLfixed, 2).value.GLfixedVal,
                                 params.getParam("alpha", ParamType::TGLfixed, 3).value.GLfixedVal);
            break;
        case gl::EntryPoint::ClearDepthf:
            context->clearDepthf(params.getParam("d", ParamType::TGLfloat, 0).value.GLfloatVal);
            break;
        case gl::EntryPoint::ClearDepthx:
            context->clearDepthx(params.getParam("depth", ParamType::TGLfixed, 0).value.GLfixedVal);
            break;
        case gl::EntryPoint::ClearStencil:
            context->clearStencil(params.getParam("s", ParamType::TGLint, 0).value.GLintVal);
            break;
        case gl::EntryPoint::ClientActiveTexture:
            context->clientActiveTexture(
                params.getParam("texture", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::ClientWaitSync:
            context->clientWaitSync(
                params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal,
                params.getParam("flags", ParamType::TGLbitfield, 1).value.GLbitfieldVal,
                params.getParam("timeout", ParamType::TGLuint64, 2).value.GLuint64Val);
            break;
        case gl::EntryPoint::ClipPlanef:
            context->clipPlanef(params.getParam("p", ParamType::TGLenum, 0).value.GLenumVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("eqn", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::ClipPlanex:
            context->clipPlanex(params.getParam("plane", ParamType::TGLenum, 0).value.GLenumVal,
                                replayContext->getAsConstPointer<const GLfixed *>(params.getParam(
                                    "equation", ParamType::TGLfixedConstPointer, 1)));
            break;
        case gl::EntryPoint::Color4f:
            context->color4f(params.getParam("red", ParamType::TGLfloat, 0).value.GLfloatVal,
                             params.getParam("green", ParamType::TGLfloat, 1).value.GLfloatVal,
                             params.getParam("blue", ParamType::TGLfloat, 2).value.GLfloatVal,
                             params.getParam("alpha", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case gl::EntryPoint::Color4ub:
            context->color4ub(params.getParam("red", ParamType::TGLubyte, 0).value.GLubyteVal,
                              params.getParam("green", ParamType::TGLubyte, 1).value.GLubyteVal,
                              params.getParam("blue", ParamType::TGLubyte, 2).value.GLubyteVal,
                              params.getParam("alpha", ParamType::TGLubyte, 3).value.GLubyteVal);
            break;
        case gl::EntryPoint::Color4x:
            context->color4x(params.getParam("red", ParamType::TGLfixed, 0).value.GLfixedVal,
                             params.getParam("green", ParamType::TGLfixed, 1).value.GLfixedVal,
                             params.getParam("blue", ParamType::TGLfixed, 2).value.GLfixedVal,
                             params.getParam("alpha", ParamType::TGLfixed, 3).value.GLfixedVal);
            break;
        case gl::EntryPoint::ColorMask:
            context->colorMask(
                params.getParam("red", ParamType::TGLboolean, 0).value.GLbooleanVal,
                params.getParam("green", ParamType::TGLboolean, 1).value.GLbooleanVal,
                params.getParam("blue", ParamType::TGLboolean, 2).value.GLbooleanVal,
                params.getParam("alpha", ParamType::TGLboolean, 3).value.GLbooleanVal);
            break;
        case gl::EntryPoint::ColorPointer:
            context->colorPointer(
                params.getParam("size", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 1)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 3)));
            break;
        case gl::EntryPoint::CompileShader:
            context->compileShader(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                       .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::CompressedTexImage2D:
            context->compressedTexImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("imageSize", ParamType::TGLsizei, 6).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 7)));
            break;
        case gl::EntryPoint::CompressedTexImage3D:
            context->compressedTexImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("imageSize", ParamType::TGLsizei, 7).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 8)));
            break;
        case gl::EntryPoint::CompressedTexSubImage2D:
            context->compressedTexSubImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal,
                params.getParam("imageSize", ParamType::TGLsizei, 7).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 8)));
            break;
        case gl::EntryPoint::CompressedTexSubImage3D:
            context->compressedTexSubImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 7).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 8).value.GLenumVal,
                params.getParam("imageSize", ParamType::TGLsizei, 9).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 10)));
            break;
        case gl::EntryPoint::CopyBufferSubData:
            context->copyBufferSubData(
                params.getParam("readTargetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("writeTargetPacked", ParamType::TBufferBinding, 1)
                    .value.BufferBindingVal,
                params.getParam("readOffset", ParamType::TGLintptr, 2).value.GLintptrVal,
                params.getParam("writeOffset", ParamType::TGLintptr, 3).value.GLintptrVal,
                params.getParam("size", ParamType::TGLsizeiptr, 4).value.GLsizeiptrVal);
            break;
        case gl::EntryPoint::CopyTexImage2D:
            context->copyTexImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("x", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 7).value.GLintVal);
            break;
        case gl::EntryPoint::CopyTexSubImage2D:
            context->copyTexSubImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("x", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 7).value.GLsizeiVal);
            break;
        case gl::EntryPoint::CopyTexSubImage3D:
            context->copyTexSubImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("x", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 7).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 8).value.GLsizeiVal);
            break;
        case gl::EntryPoint::CreateProgram:
            context->createProgram();
            break;
        case gl::EntryPoint::CreateShader:
            context->createShader(
                params.getParam("typePacked", ParamType::TShaderType, 0).value.ShaderTypeVal);
            break;
        case gl::EntryPoint::CreateShaderProgramv:
            context->createShaderProgramv(
                params.getParam("typePacked", ParamType::TShaderType, 0).value.ShaderTypeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("strings", ParamType::TGLcharConstPointerPointer, 2)));
            break;
        case gl::EntryPoint::CullFace:
            context->cullFace(
                params.getParam("modePacked", ParamType::TCullFaceMode, 0).value.CullFaceModeVal);
            break;
        case gl::EntryPoint::DebugMessageCallback:
            context->debugMessageCallback(
                params.getParam("callback", ParamType::TGLDEBUGPROC, 0).value.GLDEBUGPROCVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("userParam", ParamType::TvoidConstPointer, 1)));
            break;
        case gl::EntryPoint::DebugMessageControl:
            context->debugMessageControl(
                params.getParam("source", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("severity", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("count", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("ids", ParamType::TGLuintConstPointer, 4)),
                params.getParam("enabled", ParamType::TGLboolean, 5).value.GLbooleanVal);
            break;
        case gl::EntryPoint::DebugMessageInsert:
            context->debugMessageInsert(
                params.getParam("source", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("id", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("severity", ParamType::TGLenum, 3).value.GLenumVal,
                params.getParam("length", ParamType::TGLsizei, 4).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("buf", ParamType::TGLcharConstPointer, 5)));
            break;
        case gl::EntryPoint::DeleteBuffers:
            context->deleteBuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const BufferID *>(
                    params.getParam("buffersPacked", ParamType::TBufferIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteFencesNV:
            context->deleteFencesNV(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const FenceNVID *>(
                    params.getParam("fencesPacked", ParamType::TFenceNVIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteFramebuffers:
            context->deleteFramebuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const FramebufferID *>(params.getParam(
                    "framebuffersPacked", ParamType::TFramebufferIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteProgram:
            context->deleteProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                       .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::DeleteProgramPipelines:
            context->deleteProgramPipelines(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const ProgramPipelineID *>(params.getParam(
                    "pipelinesPacked", ParamType::TProgramPipelineIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteQueries:
            context->deleteQueries(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const QueryID *>(
                    params.getParam("idsPacked", ParamType::TQueryIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteRenderbuffers:
            context->deleteRenderbuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const RenderbufferID *>(params.getParam(
                    "renderbuffersPacked", ParamType::TRenderbufferIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteSamplers:
            context->deleteSamplers(
                params.getParam("count", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const SamplerID *>(
                    params.getParam("samplersPacked", ParamType::TSamplerIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteShader:
            context->deleteShader(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::DeleteSync:
            context->deleteSync(params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal);
            break;
        case gl::EntryPoint::DeleteTextures:
            context->deleteTextures(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const TextureID *>(
                    params.getParam("texturesPacked", ParamType::TTextureIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteTransformFeedbacks:
            context->deleteTransformFeedbacks(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const TransformFeedbackID *>(
                    params.getParam("idsPacked", ParamType::TTransformFeedbackIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DeleteVertexArrays:
            context->deleteVertexArrays(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const VertexArrayID *>(
                    params.getParam("arraysPacked", ParamType::TVertexArrayIDConstPointer, 1)));
            break;
        case gl::EntryPoint::DepthFunc:
            context->depthFunc(params.getParam("func", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::DepthMask:
            context->depthMask(
                params.getParam("flag", ParamType::TGLboolean, 0).value.GLbooleanVal);
            break;
        case gl::EntryPoint::DepthRangef:
            context->depthRangef(params.getParam("n", ParamType::TGLfloat, 0).value.GLfloatVal,
                                 params.getParam("f", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::DepthRangex:
            context->depthRangex(params.getParam("n", ParamType::TGLfixed, 0).value.GLfixedVal,
                                 params.getParam("f", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case gl::EntryPoint::DetachShader:
            context->detachShader(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("shaderPacked", ParamType::TShaderProgramID, 1)
                                      .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::Disable:
            context->disable(params.getParam("cap", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::DisableClientState:
            context->disableClientState(
                params.getParam("arrayPacked", ParamType::TClientVertexArrayType, 0)
                    .value.ClientVertexArrayTypeVal);
            break;
        case gl::EntryPoint::DisableVertexAttribArray:
            context->disableVertexAttribArray(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal);
            break;
        case gl::EntryPoint::DispatchCompute:
            context->dispatchCompute(
                params.getParam("num_groups_x", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("num_groups_y", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("num_groups_z", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case gl::EntryPoint::DispatchComputeIndirect:
            context->dispatchComputeIndirect(
                params.getParam("indirect", ParamType::TGLintptr, 0).value.GLintptrVal);
            break;
        case gl::EntryPoint::DrawArrays:
            context->drawArrays(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("first", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal);
            break;
        case gl::EntryPoint::DrawArraysIndirect:
            context->drawArraysIndirect(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indirect", ParamType::TvoidConstPointer, 1)));
            break;
        case gl::EntryPoint::DrawArraysInstanced:
            context->drawArraysInstanced(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("first", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("instancecount", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::DrawArraysInstancedBaseInstance:
            context->drawArraysInstancedBaseInstance(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("first", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("instancecount", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("baseinstance", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case gl::EntryPoint::DrawBuffers:
            context->drawBuffers(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLenum *>(
                                     params.getParam("bufs", ParamType::TGLenumConstPointer, 1)));
            break;
        case gl::EntryPoint::DrawElements:
            context->drawElements(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)));
            break;
        case gl::EntryPoint::DrawElementsIndirect:
            context->drawElementsIndirect(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 1)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indirect", ParamType::TvoidConstPointer, 2)));
            break;
        case gl::EntryPoint::DrawElementsInstanced:
            context->drawElementsInstanced(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)),
                params.getParam("instancecount", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case gl::EntryPoint::DrawElementsInstancedBaseVertexBaseInstance:
            context->drawElementsInstancedBaseVertexBaseInstance(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)),
                params.getParam("instancecount", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("basevertex", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("baseinstance", ParamType::TGLuint, 6).value.GLuintVal);
            break;
        case gl::EntryPoint::DrawRangeElements:
            context->drawRangeElements(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("start", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("end", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("count", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 4)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 5)));
            break;
        case gl::EntryPoint::Enable:
            context->enable(params.getParam("cap", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::EnableClientState:
            context->enableClientState(
                params.getParam("arrayPacked", ParamType::TClientVertexArrayType, 0)
                    .value.ClientVertexArrayTypeVal);
            break;
        case gl::EntryPoint::EnableVertexAttribArray:
            context->enableVertexAttribArray(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal);
            break;
        case gl::EntryPoint::EndQuery:
            context->endQuery(
                params.getParam("targetPacked", ParamType::TQueryType, 0).value.QueryTypeVal);
            break;
        case gl::EntryPoint::EndTransformFeedback:
            context->endTransformFeedback();
            break;
        case gl::EntryPoint::FenceSync:
            context->fenceSync(
                params.getParam("condition", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("flags", ParamType::TGLbitfield, 1).value.GLbitfieldVal);
            break;
        case gl::EntryPoint::Finish:
            context->finish();
            break;
        case gl::EntryPoint::FinishFenceNV:
            context->finishFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal);
            break;
        case gl::EntryPoint::Flush:
            context->flush();
            break;
        case gl::EntryPoint::FlushMappedBufferRange:
            context->flushMappedBufferRange(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("offset", ParamType::TGLintptr, 1).value.GLintptrVal,
                params.getParam("length", ParamType::TGLsizeiptr, 2).value.GLsizeiptrVal);
            break;
        case gl::EntryPoint::Fogf:
            context->fogf(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                          params.getParam("param", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::Fogfv:
            context->fogfv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                           replayContext->getAsConstPointer<const GLfloat *>(
                               params.getParam("params", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::Fogx:
            context->fogx(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                          params.getParam("param", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case gl::EntryPoint::Fogxv:
            context->fogxv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                           replayContext->getAsConstPointer<const GLfixed *>(
                               params.getParam("param", ParamType::TGLfixedConstPointer, 1)));
            break;
        case gl::EntryPoint::FramebufferParameteri:
            context->framebufferParameteri(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::FramebufferRenderbuffer:
            context->framebufferRenderbuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("renderbuffertarget", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("renderbufferPacked", ParamType::TRenderbufferID, 3)
                    .value.RenderbufferIDVal);
            break;
        case gl::EntryPoint::FramebufferTexture:
            context->framebufferTexture(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("texturePacked", ParamType::TTextureID, 2).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 3).value.GLintVal);
            break;
        case gl::EntryPoint::FramebufferTexture2D:
            context->framebufferTexture2D(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("textargetPacked", ParamType::TTextureTarget, 2)
                    .value.TextureTargetVal,
                params.getParam("texturePacked", ParamType::TTextureID, 3).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 4).value.GLintVal);
            break;
        case gl::EntryPoint::FramebufferTexture3D:
            context->framebufferTexture3D(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("textargetPacked", ParamType::TTextureTarget, 2)
                    .value.TextureTargetVal,
                params.getParam("texturePacked", ParamType::TTextureID, 3).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 5).value.GLintVal);
            break;
        case gl::EntryPoint::FramebufferTextureLayer:
            context->framebufferTextureLayer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("texturePacked", ParamType::TTextureID, 2).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("layer", ParamType::TGLint, 4).value.GLintVal);
            break;
        case gl::EntryPoint::FrontFace:
            context->frontFace(params.getParam("mode", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::Frustumf:
            context->frustumf(params.getParam("l", ParamType::TGLfloat, 0).value.GLfloatVal,
                              params.getParam("r", ParamType::TGLfloat, 1).value.GLfloatVal,
                              params.getParam("b", ParamType::TGLfloat, 2).value.GLfloatVal,
                              params.getParam("t", ParamType::TGLfloat, 3).value.GLfloatVal,
                              params.getParam("n", ParamType::TGLfloat, 4).value.GLfloatVal,
                              params.getParam("f", ParamType::TGLfloat, 5).value.GLfloatVal);
            break;
        case gl::EntryPoint::Frustumx:
            context->frustumx(params.getParam("l", ParamType::TGLfixed, 0).value.GLfixedVal,
                              params.getParam("r", ParamType::TGLfixed, 1).value.GLfixedVal,
                              params.getParam("b", ParamType::TGLfixed, 2).value.GLfixedVal,
                              params.getParam("t", ParamType::TGLfixed, 3).value.GLfixedVal,
                              params.getParam("n", ParamType::TGLfixed, 4).value.GLfixedVal,
                              params.getParam("f", ParamType::TGLfixed, 5).value.GLfixedVal);
            break;
        case gl::EntryPoint::GenBuffers:
            context->genBuffers(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                replayContext->getReadBufferPointer<BufferID *>(params.getParam(
                                    "buffersPacked", ParamType::TBufferIDPointer, 1)));
            break;
        case gl::EntryPoint::GenFencesNV:
            context->genFencesNV(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getReadBufferPointer<FenceNVID *>(params.getParam(
                                     "fencesPacked", ParamType::TFenceNVIDPointer, 1)));
            break;
        case gl::EntryPoint::GenFramebuffers:
            context->genFramebuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<FramebufferID *>(
                    params.getParam("framebuffersPacked", ParamType::TFramebufferIDPointer, 1)));
            break;
        case gl::EntryPoint::GenProgramPipelines:
            context->genProgramPipelines(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<ProgramPipelineID *>(
                    params.getParam("pipelinesPacked", ParamType::TProgramPipelineIDPointer, 1)));
            break;
        case gl::EntryPoint::GenQueries:
            context->genQueries(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                replayContext->getReadBufferPointer<QueryID *>(
                                    params.getParam("idsPacked", ParamType::TQueryIDPointer, 1)));
            break;
        case gl::EntryPoint::GenRenderbuffers:
            context->genRenderbuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<RenderbufferID *>(
                    params.getParam("renderbuffersPacked", ParamType::TRenderbufferIDPointer, 1)));
            break;
        case gl::EntryPoint::GenSamplers:
            context->genSamplers(params.getParam("count", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getReadBufferPointer<SamplerID *>(params.getParam(
                                     "samplersPacked", ParamType::TSamplerIDPointer, 1)));
            break;
        case gl::EntryPoint::GenTextures:
            context->genTextures(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getReadBufferPointer<TextureID *>(params.getParam(
                                     "texturesPacked", ParamType::TTextureIDPointer, 1)));
            break;
        case gl::EntryPoint::GenTransformFeedbacks:
            context->genTransformFeedbacks(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<TransformFeedbackID *>(
                    params.getParam("idsPacked", ParamType::TTransformFeedbackIDPointer, 1)));
            break;
        case gl::EntryPoint::GenVertexArrays:
            context->genVertexArrays(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<VertexArrayID *>(
                    params.getParam("arraysPacked", ParamType::TVertexArrayIDPointer, 1)));
            break;
        case gl::EntryPoint::GenerateMipmap:
            context->generateMipmap(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal);
            break;
        case gl::EntryPoint::GetActiveAttrib:
            context->getActiveAttrib(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("size", ParamType::TGLintPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("type", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 6)));
            break;
        case gl::EntryPoint::GetActiveUniform:
            context->getActiveUniform(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("size", ParamType::TGLintPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("type", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 6)));
            break;
        case gl::EntryPoint::GetActiveUniformBlockName:
            context->getActiveUniformBlockName(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformBlockIndex", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("uniformBlockName", ParamType::TGLcharPointer, 4)));
            break;
        case gl::EntryPoint::GetActiveUniformBlockiv:
            context->getActiveUniformBlockiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformBlockIndex", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case gl::EntryPoint::GetActiveUniformsiv:
            context->getActiveUniformsiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformCount", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("uniformIndices", ParamType::TGLuintConstPointer, 2)),
                params.getParam("pname", ParamType::TGLenum, 3).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 4)));
            break;
        case gl::EntryPoint::GetAttachedShaders:
            context->getAttachedShaders(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("maxCount", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("count", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<ShaderProgramID *>(
                    params.getParam("shadersPacked", ParamType::TShaderProgramIDPointer, 3)));
            break;
        case gl::EntryPoint::GetAttribLocation:
            context->getAttribLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case gl::EntryPoint::GetBooleani_v:
            context->getBooleani_v(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                                   replayContext->getReadBufferPointer<GLboolean *>(
                                       params.getParam("data", ParamType::TGLbooleanPointer, 2)));
            break;
        case gl::EntryPoint::GetBooleanv:
            context->getBooleanv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLboolean *>(
                                     params.getParam("data", ParamType::TGLbooleanPointer, 1)));
            break;
        case gl::EntryPoint::GetBufferParameteri64v:
            context->getBufferParameteri64v(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint64 *>(
                    params.getParam("params", ParamType::TGLint64Pointer, 2)));
            break;
        case gl::EntryPoint::GetBufferParameteriv:
            context->getBufferParameteriv(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetBufferPointerv:
            context->getBufferPointerv(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<void **>(
                    params.getParam("params", ParamType::TvoidPointerPointer, 2)));
            break;
        case gl::EntryPoint::GetClipPlanef:
            context->getClipPlanef(params.getParam("plane", ParamType::TGLenum, 0).value.GLenumVal,
                                   replayContext->getReadBufferPointer<GLfloat *>(
                                       params.getParam("equation", ParamType::TGLfloatPointer, 1)));
            break;
        case gl::EntryPoint::GetClipPlanex:
            context->getClipPlanex(params.getParam("plane", ParamType::TGLenum, 0).value.GLenumVal,
                                   replayContext->getReadBufferPointer<GLfixed *>(
                                       params.getParam("equation", ParamType::TGLfixedPointer, 1)));
            break;
        case gl::EntryPoint::GetDebugMessageLog:
            context->getDebugMessageLog(
                params.getParam("count", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("sources", ParamType::TGLenumPointer, 2)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("types", ParamType::TGLenumPointer, 3)),
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("ids", ParamType::TGLuintPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("severities", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("lengths", ParamType::TGLsizeiPointer, 6)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("messageLog", ParamType::TGLcharPointer, 7)));
            break;
        case gl::EntryPoint::GetError:
            context->getError();
            break;
        case gl::EntryPoint::GetFenceivNV:
            context->getFenceivNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetFixedv:
            context->getFixedv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                               replayContext->getReadBufferPointer<GLfixed *>(
                                   params.getParam("params", ParamType::TGLfixedPointer, 1)));
            break;
        case gl::EntryPoint::GetFloatv:
            context->getFloatv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                               replayContext->getReadBufferPointer<GLfloat *>(
                                   params.getParam("data", ParamType::TGLfloatPointer, 1)));
            break;
        case gl::EntryPoint::GetFragDataIndex:
            context->getFragDataIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case gl::EntryPoint::GetFragDataLocation:
            context->getFragDataLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case gl::EntryPoint::GetFramebufferAttachmentParameteriv:
            context->getFramebufferAttachmentParameteriv(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case gl::EntryPoint::GetFramebufferParameteriv:
            context->getFramebufferParameteriv(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetGraphicsResetStatus:
            context->getGraphicsResetStatus();
            break;
        case gl::EntryPoint::GetInteger64i_v:
            context->getInteger64i_v(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getReadBufferPointer<GLint64 *>(
                    params.getParam("data", ParamType::TGLint64Pointer, 2)));
            break;
        case gl::EntryPoint::GetInteger64v:
            context->getInteger64v(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                   replayContext->getReadBufferPointer<GLint64 *>(
                                       params.getParam("data", ParamType::TGLint64Pointer, 1)));
            break;
        case gl::EntryPoint::GetIntegeri_v:
            context->getIntegeri_v(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                                   replayContext->getReadBufferPointer<GLint *>(
                                       params.getParam("data", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetIntegerv:
            context->getIntegerv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("data", ParamType::TGLintPointer, 1)));
            break;
        case gl::EntryPoint::GetInternalformativ:
            context->getInternalformativ(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("internalformat", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("bufSize", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 4)));
            break;
        case gl::EntryPoint::GetLightfv:
            context->getLightfv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                    .value.LightParameterVal,
                                replayContext->getReadBufferPointer<GLfloat *>(
                                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetLightxv:
            context->getLightxv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                    .value.LightParameterVal,
                                replayContext->getReadBufferPointer<GLfixed *>(
                                    params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case gl::EntryPoint::GetMaterialfv:
            context->getMaterialfv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                       .value.MaterialParameterVal,
                                   replayContext->getReadBufferPointer<GLfloat *>(
                                       params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetMaterialxv:
            context->getMaterialxv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                       .value.MaterialParameterVal,
                                   replayContext->getReadBufferPointer<GLfixed *>(
                                       params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case gl::EntryPoint::GetMultisamplefv:
            context->getMultisamplefv(
                params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("val", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetObjectLabel:
            context->getObjectLabel(
                params.getParam("identifier", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("name", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("label", ParamType::TGLcharPointer, 4)));
            break;
        case gl::EntryPoint::GetObjectPtrLabel:
            context->getObjectPtrLabel(
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("ptr", ParamType::TvoidConstPointer, 0)),
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("label", ParamType::TGLcharPointer, 3)));
            break;
        case gl::EntryPoint::GetPointerv:
            context->getPointerv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 replayContext->getReadBufferPointer<void **>(
                                     params.getParam("params", ParamType::TvoidPointerPointer, 1)));
            break;
        case gl::EntryPoint::GetProgramBinary:
            context->getProgramBinary(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("binaryFormat", ParamType::TGLenumPointer, 3)),
                replayContext->getReadBufferPointer<void *>(
                    params.getParam("binary", ParamType::TvoidPointer, 4)));
            break;
        case gl::EntryPoint::GetProgramInfoLog:
            context->getProgramInfoLog(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("infoLog", ParamType::TGLcharPointer, 3)));
            break;
        case gl::EntryPoint::GetProgramInterfaceiv:
            context->getProgramInterfaceiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case gl::EntryPoint::GetProgramPipelineInfoLog:
            context->getProgramPipelineInfoLog(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("infoLog", ParamType::TGLcharPointer, 3)));
            break;
        case gl::EntryPoint::GetProgramPipelineiv:
            context->getProgramPipelineiv(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetProgramResourceIndex:
            context->getProgramResourceIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case gl::EntryPoint::GetProgramResourceLocation:
            context->getProgramResourceLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case gl::EntryPoint::GetProgramResourceLocationIndex:
            context->getProgramResourceLocationIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case gl::EntryPoint::GetProgramResourceName:
            context->getProgramResourceName(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 4)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 5)));
            break;
        case gl::EntryPoint::GetProgramResourceiv:
            context->getProgramResourceiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("propCount", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLenum *>(
                    params.getParam("props", ParamType::TGLenumConstPointer, 4)),
                params.getParam("bufSize", ParamType::TGLsizei, 5).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 6)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 7)));
            break;
        case gl::EntryPoint::GetProgramiv:
            context->getProgramiv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                  replayContext->getReadBufferPointer<GLint *>(
                                      params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetQueryObjecti64v:
            context->getQueryObjecti64v(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint64 *>(
                    params.getParam("params", ParamType::TGLint64Pointer, 2)));
            break;
        case gl::EntryPoint::GetQueryObjectiv:
            context->getQueryObjectiv(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetQueryObjectui64v:
            context->getQueryObjectui64v(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint64 *>(
                    params.getParam("params", ParamType::TGLuint64Pointer, 2)));
            break;
        case gl::EntryPoint::GetQueryObjectuiv:
            context->getQueryObjectuiv(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case gl::EntryPoint::GetQueryiv:
            context->getQueryiv(
                params.getParam("targetPacked", ParamType::TQueryType, 0).value.QueryTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetRenderbufferParameteriv:
            context->getRenderbufferParameteriv(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetSamplerParameterIiv:
            context->getSamplerParameterIiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetSamplerParameterIuiv:
            context->getSamplerParameterIuiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case gl::EntryPoint::GetSamplerParameterfv:
            context->getSamplerParameterfv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetSamplerParameteriv:
            context->getSamplerParameteriv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetShaderInfoLog:
            context->getShaderInfoLog(
                params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("infoLog", ParamType::TGLcharPointer, 3)));
            break;
        case gl::EntryPoint::GetShaderPrecisionFormat:
            context->getShaderPrecisionFormat(
                params.getParam("shadertype", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("precisiontype", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("range", ParamType::TGLintPointer, 2)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("precision", ParamType::TGLintPointer, 3)));
            break;
        case gl::EntryPoint::GetShaderSource:
            context->getShaderSource(
                params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("source", ParamType::TGLcharPointer, 3)));
            break;
        case gl::EntryPoint::GetShaderiv:
            context->getShaderiv(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                     .value.ShaderProgramIDVal,
                                 params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetString:
            context->getString(params.getParam("name", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::GetStringi:
            context->getStringi(params.getParam("name", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case gl::EntryPoint::GetSynciv:
            context->getSynciv(params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal,
                               params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                               params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                               replayContext->getReadBufferPointer<GLsizei *>(
                                   params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                               replayContext->getReadBufferPointer<GLint *>(
                                   params.getParam("values", ParamType::TGLintPointer, 4)));
            break;
        case gl::EntryPoint::GetTexEnvfv:
            context->getTexEnvfv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                     .value.TextureEnvTargetVal,
                                 params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                     .value.TextureEnvParameterVal,
                                 replayContext->getReadBufferPointer<GLfloat *>(
                                     params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetTexEnviv:
            context->getTexEnviv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                     .value.TextureEnvTargetVal,
                                 params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                     .value.TextureEnvParameterVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetTexEnvxv:
            context->getTexEnvxv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                     .value.TextureEnvTargetVal,
                                 params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                     .value.TextureEnvParameterVal,
                                 replayContext->getReadBufferPointer<GLfixed *>(
                                     params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case gl::EntryPoint::GetTexGenfv:
            context->getTexGenfv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLfloat *>(
                                     params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetTexGeniv:
            context->getTexGeniv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetTexLevelParameterfv:
            context->getTexLevelParameterfv(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 3)));
            break;
        case gl::EntryPoint::GetTexLevelParameteriv:
            context->getTexLevelParameteriv(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case gl::EntryPoint::GetTexParameterIiv:
            context->getTexParameterIiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetTexParameterIuiv:
            context->getTexParameterIuiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case gl::EntryPoint::GetTexParameterfv:
            context->getTexParameterfv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetTexParameteriv:
            context->getTexParameteriv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetTexParameterxv:
            context->getTexParameterxv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfixed *>(
                    params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case gl::EntryPoint::GetTransformFeedbackVarying:
            context->getTransformFeedbackVarying(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("size", ParamType::TGLsizeiPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("type", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 6)));
            break;
        case gl::EntryPoint::GetUniformBlockIndex:
            context->getUniformBlockIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("uniformBlockName", ParamType::TGLcharConstPointer, 1)));
            break;
        case gl::EntryPoint::GetUniformIndices:
            context->getUniformIndices(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformCount", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("uniformNames", ParamType::TGLcharConstPointerPointer, 2)),
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("uniformIndices", ParamType::TGLuintPointer, 3)));
            break;
        case gl::EntryPoint::GetUniformLocation:
            context->getUniformLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case gl::EntryPoint::GetUniformfv:
            context->getUniformfv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                                  replayContext->getReadBufferPointer<GLfloat *>(
                                      params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetUniformiv:
            context->getUniformiv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                                  replayContext->getReadBufferPointer<GLint *>(
                                      params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetUniformuiv:
            context->getUniformuiv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                       .value.ShaderProgramIDVal,
                                   params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                                   replayContext->getReadBufferPointer<GLuint *>(
                                       params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case gl::EntryPoint::GetVertexAttribIiv:
            context->getVertexAttribIiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetVertexAttribIuiv:
            context->getVertexAttribIuiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case gl::EntryPoint::GetVertexAttribPointerv:
            context->getVertexAttribPointerv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<void **>(
                    params.getParam("pointer", ParamType::TvoidPointerPointer, 2)));
            break;
        case gl::EntryPoint::GetVertexAttribfv:
            context->getVertexAttribfv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case gl::EntryPoint::GetVertexAttribiv:
            context->getVertexAttribiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case gl::EntryPoint::GetnUniformfv:
            context->getnUniformfv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 3)));
            break;
        case gl::EntryPoint::GetnUniformiv:
            context->getnUniformiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case gl::EntryPoint::Hint:
            context->hint(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                          params.getParam("mode", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case gl::EntryPoint::InvalidateFramebuffer:
            context->invalidateFramebuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("numAttachments", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLenum *>(
                    params.getParam("attachments", ParamType::TGLenumConstPointer, 2)));
            break;
        case gl::EntryPoint::InvalidateSubFramebuffer:
            context->invalidateSubFramebuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("numAttachments", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLenum *>(
                    params.getParam("attachments", ParamType::TGLenumConstPointer, 2)),
                params.getParam("x", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal);
            break;
        case gl::EntryPoint::IsBuffer:
            context->isBuffer(
                params.getParam("bufferPacked", ParamType::TBufferID, 0).value.BufferIDVal);
            break;
        case gl::EntryPoint::IsEnabled:
            context->isEnabled(params.getParam("cap", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::IsFenceNV:
            context->isFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal);
            break;
        case gl::EntryPoint::IsFramebuffer:
            context->isFramebuffer(
                params.getParam("framebufferPacked", ParamType::TFramebufferID, 0)
                    .value.FramebufferIDVal);
            break;
        case gl::EntryPoint::IsProgram:
            context->isProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                   .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::IsProgramPipeline:
            context->isProgramPipeline(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal);
            break;
        case gl::EntryPoint::IsQuery:
            context->isQuery(params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal);
            break;
        case gl::EntryPoint::IsRenderbuffer:
            context->isRenderbuffer(
                params.getParam("renderbufferPacked", ParamType::TRenderbufferID, 0)
                    .value.RenderbufferIDVal);
            break;
        case gl::EntryPoint::IsSampler:
            context->isSampler(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal);
            break;
        case gl::EntryPoint::IsShader:
            context->isShader(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                  .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::IsSync:
            context->isSync(params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal);
            break;
        case gl::EntryPoint::IsTexture:
            context->isTexture(
                params.getParam("texturePacked", ParamType::TTextureID, 0).value.TextureIDVal);
            break;
        case gl::EntryPoint::IsTransformFeedback:
            context->isTransformFeedback(
                params.getParam("idPacked", ParamType::TTransformFeedbackID, 0)
                    .value.TransformFeedbackIDVal);
            break;
        case gl::EntryPoint::IsVertexArray:
            context->isVertexArray(params.getParam("arrayPacked", ParamType::TVertexArrayID, 0)
                                       .value.VertexArrayIDVal);
            break;
        case gl::EntryPoint::LightModelf:
            context->lightModelf(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("param", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::LightModelfv:
            context->lightModelfv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                  replayContext->getAsConstPointer<const GLfloat *>(params.getParam(
                                      "params", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::LightModelx:
            context->lightModelx(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("param", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case gl::EntryPoint::LightModelxv:
            context->lightModelxv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                  replayContext->getAsConstPointer<const GLfixed *>(params.getParam(
                                      "param", ParamType::TGLfixedConstPointer, 1)));
            break;
        case gl::EntryPoint::Lightf:
            context->lightf(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                            params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                .value.LightParameterVal,
                            params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::Lightfv:
            context->lightfv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                 .value.LightParameterVal,
                             replayContext->getAsConstPointer<const GLfloat *>(
                                 params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::Lightx:
            context->lightx(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                            params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                .value.LightParameterVal,
                            params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case gl::EntryPoint::Lightxv:
            context->lightxv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                 .value.LightParameterVal,
                             replayContext->getAsConstPointer<const GLfixed *>(
                                 params.getParam("params", ParamType::TGLfixedConstPointer, 2)));
            break;
        case gl::EntryPoint::LineWidth:
            context->lineWidth(params.getParam("width", ParamType::TGLfloat, 0).value.GLfloatVal);
            break;
        case gl::EntryPoint::LineWidthx:
            context->lineWidthx(params.getParam("width", ParamType::TGLfixed, 0).value.GLfixedVal);
            break;
        case gl::EntryPoint::LinkProgram:
            context->linkProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                     .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::LoadIdentity:
            context->loadIdentity();
            break;
        case gl::EntryPoint::LoadMatrixf:
            context->loadMatrixf(replayContext->getAsConstPointer<const GLfloat *>(
                params.getParam("m", ParamType::TGLfloatConstPointer, 0)));
            break;
        case gl::EntryPoint::LoadMatrixx:
            context->loadMatrixx(replayContext->getAsConstPointer<const GLfixed *>(
                params.getParam("m", ParamType::TGLfixedConstPointer, 0)));
            break;
        case gl::EntryPoint::LogicOp:
            context->logicOp(params.getParam("opcodePacked", ParamType::TLogicalOperation, 0)
                                 .value.LogicalOperationVal);
            break;
        case gl::EntryPoint::MapBuffer:
            context->mapBuffer(params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                                   .value.BufferBindingVal,
                               params.getParam("access", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case gl::EntryPoint::MapBufferRange:
            context->mapBufferRange(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("offset", ParamType::TGLintptr, 1).value.GLintptrVal,
                params.getParam("length", ParamType::TGLsizeiptr, 2).value.GLsizeiptrVal,
                params.getParam("access", ParamType::TGLbitfield, 3).value.GLbitfieldVal);
            break;
        case gl::EntryPoint::Materialf:
            context->materialf(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                   .value.MaterialParameterVal,
                               params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::Materialfv:
            context->materialfv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                    .value.MaterialParameterVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::Materialx:
            context->materialx(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                   .value.MaterialParameterVal,
                               params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case gl::EntryPoint::Materialxv:
            context->materialxv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                    .value.MaterialParameterVal,
                                replayContext->getAsConstPointer<const GLfixed *>(
                                    params.getParam("param", ParamType::TGLfixedConstPointer, 2)));
            break;
        case gl::EntryPoint::MatrixMode:
            context->matrixMode(
                params.getParam("modePacked", ParamType::TMatrixType, 0).value.MatrixTypeVal);
            break;
        case gl::EntryPoint::MemoryBarrier:
            context->memoryBarrier(
                params.getParam("barriers", ParamType::TGLbitfield, 0).value.GLbitfieldVal);
            break;
        case gl::EntryPoint::MemoryBarrierByRegion:
            context->memoryBarrierByRegion(
                params.getParam("barriers", ParamType::TGLbitfield, 0).value.GLbitfieldVal);
            break;
        case gl::EntryPoint::MultMatrixf:
            context->multMatrixf(replayContext->getAsConstPointer<const GLfloat *>(
                params.getParam("m", ParamType::TGLfloatConstPointer, 0)));
            break;
        case gl::EntryPoint::MultMatrixx:
            context->multMatrixx(replayContext->getAsConstPointer<const GLfixed *>(
                params.getParam("m", ParamType::TGLfixedConstPointer, 0)));
            break;
        case gl::EntryPoint::MultiDrawArrays:
            context->multiDrawArrays(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("first", ParamType::TGLintConstPointer, 1)),
                replayContext->getAsConstPointer<const GLsizei *>(
                    params.getParam("count", ParamType::TGLsizeiConstPointer, 2)),
                params.getParam("drawcount", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::MultiDrawElements:
            context->multiDrawElements(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const GLsizei *>(
                    params.getParam("count", ParamType::TGLsizeiConstPointer, 1)),
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsPointerConstPointer<const void *const *>(
                    params.getParam("indices", ParamType::TvoidConstPointerPointer, 3)),
                params.getParam("drawcount", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case gl::EntryPoint::MultiTexCoord4f:
            context->multiTexCoord4f(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("s", ParamType::TGLfloat, 1).value.GLfloatVal,
                params.getParam("t", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("r", ParamType::TGLfloat, 3).value.GLfloatVal,
                params.getParam("q", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case gl::EntryPoint::MultiTexCoord4x:
            context->multiTexCoord4x(
                params.getParam("texture", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("s", ParamType::TGLfixed, 1).value.GLfixedVal,
                params.getParam("t", ParamType::TGLfixed, 2).value.GLfixedVal,
                params.getParam("r", ParamType::TGLfixed, 3).value.GLfixedVal,
                params.getParam("q", ParamType::TGLfixed, 4).value.GLfixedVal);
            break;
        case gl::EntryPoint::Normal3f:
            context->normal3f(params.getParam("nx", ParamType::TGLfloat, 0).value.GLfloatVal,
                              params.getParam("ny", ParamType::TGLfloat, 1).value.GLfloatVal,
                              params.getParam("nz", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::Normal3x:
            context->normal3x(params.getParam("nx", ParamType::TGLfixed, 0).value.GLfixedVal,
                              params.getParam("ny", ParamType::TGLfixed, 1).value.GLfixedVal,
                              params.getParam("nz", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case gl::EntryPoint::NormalPointer:
            context->normalPointer(
                params.getParam("typePacked", ParamType::TVertexAttribType, 0)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 2)));
            break;
        case gl::EntryPoint::ObjectLabel:
            context->objectLabel(
                params.getParam("identifier", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("name", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("length", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("label", ParamType::TGLcharConstPointer, 3)));
            break;
        case gl::EntryPoint::ObjectPtrLabel:
            context->objectPtrLabel(
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("ptr", ParamType::TvoidConstPointer, 0)),
                params.getParam("length", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("label", ParamType::TGLcharConstPointer, 2)));
            break;
        case gl::EntryPoint::Orthof:
            context->orthof(params.getParam("l", ParamType::TGLfloat, 0).value.GLfloatVal,
                            params.getParam("r", ParamType::TGLfloat, 1).value.GLfloatVal,
                            params.getParam("b", ParamType::TGLfloat, 2).value.GLfloatVal,
                            params.getParam("t", ParamType::TGLfloat, 3).value.GLfloatVal,
                            params.getParam("n", ParamType::TGLfloat, 4).value.GLfloatVal,
                            params.getParam("f", ParamType::TGLfloat, 5).value.GLfloatVal);
            break;
        case gl::EntryPoint::Orthox:
            context->orthox(params.getParam("l", ParamType::TGLfixed, 0).value.GLfixedVal,
                            params.getParam("r", ParamType::TGLfixed, 1).value.GLfixedVal,
                            params.getParam("b", ParamType::TGLfixed, 2).value.GLfixedVal,
                            params.getParam("t", ParamType::TGLfixed, 3).value.GLfixedVal,
                            params.getParam("n", ParamType::TGLfixed, 4).value.GLfixedVal,
                            params.getParam("f", ParamType::TGLfixed, 5).value.GLfixedVal);
            break;
        case gl::EntryPoint::PauseTransformFeedback:
            context->pauseTransformFeedback();
            break;
        case gl::EntryPoint::PixelStorei:
            context->pixelStorei(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("param", ParamType::TGLint, 1).value.GLintVal);
            break;
        case gl::EntryPoint::PointParameterf:
            context->pointParameterf(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                params.getParam("param", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::PointParameterfv:
            context->pointParameterfv(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::PointParameterx:
            context->pointParameterx(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                params.getParam("param", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case gl::EntryPoint::PointParameterxv:
            context->pointParameterxv(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                replayContext->getAsConstPointer<const GLfixed *>(
                    params.getParam("params", ParamType::TGLfixedConstPointer, 1)));
            break;
        case gl::EntryPoint::PointSize:
            context->pointSize(params.getParam("size", ParamType::TGLfloat, 0).value.GLfloatVal);
            break;
        case gl::EntryPoint::PointSizex:
            context->pointSizex(params.getParam("size", ParamType::TGLfixed, 0).value.GLfixedVal);
            break;
        case gl::EntryPoint::PolygonOffset:
            context->polygonOffset(
                params.getParam("factor", ParamType::TGLfloat, 0).value.GLfloatVal,
                params.getParam("units", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::PolygonOffsetx:
            context->polygonOffsetx(
                params.getParam("factor", ParamType::TGLfixed, 0).value.GLfixedVal,
                params.getParam("units", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case gl::EntryPoint::PopDebugGroup:
            context->popDebugGroup();
            break;
        case gl::EntryPoint::PopMatrix:
            context->popMatrix();
            break;
        case gl::EntryPoint::ProgramBinary:
            context->programBinary(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("binaryFormat", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("binary", ParamType::TvoidConstPointer, 2)),
                params.getParam("length", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::ProgramParameteri:
            context->programParameteri(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("value", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::ProgramUniform1f:
            context->programUniform1f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::ProgramUniform1fv:
            context->programUniform1fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform1i:
            context->programUniform1i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::ProgramUniform1iv:
            context->programUniform1iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform1ui:
            context->programUniform1ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case gl::EntryPoint::ProgramUniform1uiv:
            context->programUniform1uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform2f:
            context->programUniform2f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("v1", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case gl::EntryPoint::ProgramUniform2fv:
            context->programUniform2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform2i:
            context->programUniform2i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("v1", ParamType::TGLint, 3).value.GLintVal);
            break;
        case gl::EntryPoint::ProgramUniform2iv:
            context->programUniform2iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform2ui:
            context->programUniform2ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("v1", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case gl::EntryPoint::ProgramUniform2uiv:
            context->programUniform2uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform3f:
            context->programUniform3f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("v1", ParamType::TGLfloat, 3).value.GLfloatVal,
                params.getParam("v2", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case gl::EntryPoint::ProgramUniform3fv:
            context->programUniform3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform3i:
            context->programUniform3i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("v1", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("v2", ParamType::TGLint, 4).value.GLintVal);
            break;
        case gl::EntryPoint::ProgramUniform3iv:
            context->programUniform3iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform3ui:
            context->programUniform3ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("v1", ParamType::TGLuint, 3).value.GLuintVal,
                params.getParam("v2", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case gl::EntryPoint::ProgramUniform3uiv:
            context->programUniform3uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform4f:
            context->programUniform4f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("v1", ParamType::TGLfloat, 3).value.GLfloatVal,
                params.getParam("v2", ParamType::TGLfloat, 4).value.GLfloatVal,
                params.getParam("v3", ParamType::TGLfloat, 5).value.GLfloatVal);
            break;
        case gl::EntryPoint::ProgramUniform4fv:
            context->programUniform4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform4i:
            context->programUniform4i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("v1", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("v2", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("v3", ParamType::TGLint, 5).value.GLintVal);
            break;
        case gl::EntryPoint::ProgramUniform4iv:
            context->programUniform4iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniform4ui:
            context->programUniform4ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("v1", ParamType::TGLuint, 3).value.GLuintVal,
                params.getParam("v2", ParamType::TGLuint, 4).value.GLuintVal,
                params.getParam("v3", ParamType::TGLuint, 5).value.GLuintVal);
            break;
        case gl::EntryPoint::ProgramUniform4uiv:
            context->programUniform4uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix2fv:
            context->programUniformMatrix2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix2x3fv:
            context->programUniformMatrix2x3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix2x4fv:
            context->programUniformMatrix2x4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix3fv:
            context->programUniformMatrix3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix3x2fv:
            context->programUniformMatrix3x2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix3x4fv:
            context->programUniformMatrix3x4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix4fv:
            context->programUniformMatrix4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix4x2fv:
            context->programUniformMatrix4x2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProgramUniformMatrix4x3fv:
            context->programUniformMatrix4x3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("location", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case gl::EntryPoint::ProvokingVertex:
            context->provokingVertex(
                params.getParam("modePacked", ParamType::TProvokingVertexConvention, 0)
                    .value.ProvokingVertexConventionVal);
            break;
        case gl::EntryPoint::PushDebugGroup:
            context->pushDebugGroup(
                params.getParam("source", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("id", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("length", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("message", ParamType::TGLcharConstPointer, 3)));
            break;
        case gl::EntryPoint::PushMatrix:
            context->pushMatrix();
            break;
        case gl::EntryPoint::QueryCounter:
            context->queryCounter(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("targetPacked", ParamType::TQueryType, 1).value.QueryTypeVal);
            break;
        case gl::EntryPoint::ReadBuffer:
            context->readBuffer(params.getParam("src", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case gl::EntryPoint::ReadPixels:
            context->readPixels(params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                                params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                                params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal,
                                params.getParam("format", ParamType::TGLenum, 4).value.GLenumVal,
                                params.getParam("type", ParamType::TGLenum, 5).value.GLenumVal,
                                replayContext->getReadBufferPointer<void *>(
                                    params.getParam("pixels", ParamType::TvoidPointer, 6)));
            break;
        case gl::EntryPoint::ReadnPixels:
            context->readnPixels(
                params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 4).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 5).value.GLenumVal,
                params.getParam("bufSize", ParamType::TGLsizei, 6).value.GLsizeiVal,
                replayContext->getReadBufferPointer<void *>(
                    params.getParam("data", ParamType::TvoidPointer, 7)));
            break;
        case gl::EntryPoint::ReleaseShaderCompiler:
            context->releaseShaderCompiler();
            break;
        case gl::EntryPoint::RenderbufferStorage:
            context->renderbufferStorage(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("internalformat", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::RenderbufferStorageMultisample:
            context->renderbufferStorageMultisample(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("samples", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case gl::EntryPoint::ResumeTransformFeedback:
            context->resumeTransformFeedback();
            break;
        case gl::EntryPoint::Rotatef:
            context->rotatef(params.getParam("angle", ParamType::TGLfloat, 0).value.GLfloatVal,
                             params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                             params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal,
                             params.getParam("z", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case gl::EntryPoint::Rotatex:
            context->rotatex(params.getParam("angle", ParamType::TGLfixed, 0).value.GLfixedVal,
                             params.getParam("x", ParamType::TGLfixed, 1).value.GLfixedVal,
                             params.getParam("y", ParamType::TGLfixed, 2).value.GLfixedVal,
                             params.getParam("z", ParamType::TGLfixed, 3).value.GLfixedVal);
            break;
        case gl::EntryPoint::SampleCoverage:
            context->sampleCoverage(
                params.getParam("value", ParamType::TGLfloat, 0).value.GLfloatVal,
                params.getParam("invert", ParamType::TGLboolean, 1).value.GLbooleanVal);
            break;
        case gl::EntryPoint::SampleCoveragex:
            context->sampleCoveragex(
                params.getParam("value", ParamType::TGLclampx, 0).value.GLclampxVal,
                params.getParam("invert", ParamType::TGLboolean, 1).value.GLbooleanVal);
            break;
        case gl::EntryPoint::SampleMaski:
            context->sampleMaski(
                params.getParam("maskNumber", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("mask", ParamType::TGLbitfield, 1).value.GLbitfieldVal);
            break;
        case gl::EntryPoint::SamplerParameterIiv:
            context->samplerParameterIiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("param", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::SamplerParameterIuiv:
            context->samplerParameterIuiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("param", ParamType::TGLuintConstPointer, 2)));
            break;
        case gl::EntryPoint::SamplerParameterf:
            context->samplerParameterf(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::SamplerParameterfv:
            context->samplerParameterfv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("param", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::SamplerParameteri:
            context->samplerParameteri(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::SamplerParameteriv:
            context->samplerParameteriv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("param", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::Scalef:
            context->scalef(params.getParam("x", ParamType::TGLfloat, 0).value.GLfloatVal,
                            params.getParam("y", ParamType::TGLfloat, 1).value.GLfloatVal,
                            params.getParam("z", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::Scalex:
            context->scalex(params.getParam("x", ParamType::TGLfixed, 0).value.GLfixedVal,
                            params.getParam("y", ParamType::TGLfixed, 1).value.GLfixedVal,
                            params.getParam("z", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case gl::EntryPoint::Scissor:
            context->scissor(params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                             params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                             params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                             params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::SetFenceNV:
            context->setFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal,
                params.getParam("condition", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case gl::EntryPoint::ShadeModel:
            context->shadeModel(
                params.getParam("modePacked", ParamType::TShadingModel, 0).value.ShadingModelVal);
            break;
        case gl::EntryPoint::ShaderBinary:
            context->shaderBinary(
                params.getParam("count", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const ShaderProgramID *>(
                    params.getParam("shadersPacked", ParamType::TShaderProgramIDConstPointer, 1)),
                params.getParam("binaryformat", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("binary", ParamType::TvoidConstPointer, 3)),
                params.getParam("length", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case gl::EntryPoint::ShaderSource:
            context->shaderSource(
                params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("string", ParamType::TGLcharConstPointerPointer, 2)),
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("length", ParamType::TGLintConstPointer, 3)));
            break;
        case gl::EntryPoint::StencilFunc:
            context->stencilFunc(params.getParam("func", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("ref", ParamType::TGLint, 1).value.GLintVal,
                                 params.getParam("mask", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case gl::EntryPoint::StencilFuncSeparate:
            context->stencilFuncSeparate(
                params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("func", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("ref", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("mask", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case gl::EntryPoint::StencilMask:
            context->stencilMask(params.getParam("mask", ParamType::TGLuint, 0).value.GLuintVal);
            break;
        case gl::EntryPoint::StencilMaskSeparate:
            context->stencilMaskSeparate(
                params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("mask", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case gl::EntryPoint::StencilOp:
            context->stencilOp(params.getParam("fail", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("zfail", ParamType::TGLenum, 1).value.GLenumVal,
                               params.getParam("zpass", ParamType::TGLenum, 2).value.GLenumVal);
            break;
        case gl::EntryPoint::StencilOpSeparate:
            context->stencilOpSeparate(
                params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("sfail", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("dpfail", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("dppass", ParamType::TGLenum, 3).value.GLenumVal);
            break;
        case gl::EntryPoint::TestFenceNV:
            context->testFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal);
            break;
        case gl::EntryPoint::TexCoordPointer:
            context->texCoordPointer(
                params.getParam("size", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 1)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 3)));
            break;
        case gl::EntryPoint::TexEnvf:
            context->texEnvf(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                 .value.TextureEnvTargetVal,
                             params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                 .value.TextureEnvParameterVal,
                             params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::TexEnvfv:
            context->texEnvfv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                  .value.TextureEnvTargetVal,
                              params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                  .value.TextureEnvParameterVal,
                              replayContext->getAsConstPointer<const GLfloat *>(
                                  params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::TexEnvi:
            context->texEnvi(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                 .value.TextureEnvTargetVal,
                             params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                 .value.TextureEnvParameterVal,
                             params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::TexEnviv:
            context->texEnviv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                  .value.TextureEnvTargetVal,
                              params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                  .value.TextureEnvParameterVal,
                              replayContext->getAsConstPointer<const GLint *>(
                                  params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::TexEnvx:
            context->texEnvx(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                 .value.TextureEnvTargetVal,
                             params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                 .value.TextureEnvParameterVal,
                             params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case gl::EntryPoint::TexEnvxv:
            context->texEnvxv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                  .value.TextureEnvTargetVal,
                              params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                  .value.TextureEnvParameterVal,
                              replayContext->getAsConstPointer<const GLfixed *>(
                                  params.getParam("params", ParamType::TGLfixedConstPointer, 2)));
            break;
        case gl::EntryPoint::TexGenf:
            context->texGenf(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                             params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::TexGenfv:
            context->texGenfv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                              params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                              replayContext->getAsConstPointer<const GLfloat *>(
                                  params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::TexGeni:
            context->texGeni(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                             params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::TexGeniv:
            context->texGeniv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                              params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                              replayContext->getAsConstPointer<const GLint *>(
                                  params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::TexImage2D:
            context->texImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 7).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 8)));
            break;
        case gl::EntryPoint::TexImage3D:
            context->texImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("format", ParamType::TGLenum, 7).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 8).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 9)));
            break;
        case gl::EntryPoint::TexParameterIiv:
            context->texParameterIiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::TexParameterIuiv:
            context->texParameterIuiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("params", ParamType::TGLuintConstPointer, 2)));
            break;
        case gl::EntryPoint::TexParameterf:
            context->texParameterf(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::TexParameterfv:
            context->texParameterfv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::TexParameteri:
            context->texParameteri(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::TexParameteriv:
            context->texParameteriv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::TexParameterx:
            context->texParameterx(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case gl::EntryPoint::TexParameterxv:
            context->texParameterxv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLfixed *>(
                    params.getParam("params", ParamType::TGLfixedConstPointer, 2)));
            break;
        case gl::EntryPoint::TexStorage1D:
            context->texStorage1D(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("levels", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::TexStorage2D:
            context->texStorage2D(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("levels", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case gl::EntryPoint::TexStorage2DMultisample:
            context->texStorage2DMultisample(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("samples", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("fixedsamplelocations", ParamType::TGLboolean, 5)
                    .value.GLbooleanVal);
            break;
        case gl::EntryPoint::TexStorage3D:
            context->texStorage3D(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("levels", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal);
            break;
        case gl::EntryPoint::TexStorage3DMultisample:
            context->texStorage3DMultisample(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("samples", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("fixedsamplelocations", ParamType::TGLboolean, 6)
                    .value.GLbooleanVal);
            break;
        case gl::EntryPoint::TexSubImage2D:
            context->texSubImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 7).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 8)));
            break;
        case gl::EntryPoint::TexSubImage3D:
            context->texSubImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 7).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 8).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 9).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 10)));
            break;
        case gl::EntryPoint::TransformFeedbackVaryings:
            context->transformFeedbackVaryings(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("varyings", ParamType::TGLcharConstPointerPointer, 2)),
                params.getParam("bufferMode", ParamType::TGLenum, 3).value.GLenumVal);
            break;
        case gl::EntryPoint::Translatef:
            context->translatef(params.getParam("x", ParamType::TGLfloat, 0).value.GLfloatVal,
                                params.getParam("y", ParamType::TGLfloat, 1).value.GLfloatVal,
                                params.getParam("z", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::Translatex:
            context->translatex(params.getParam("x", ParamType::TGLfixed, 0).value.GLfixedVal,
                                params.getParam("y", ParamType::TGLfixed, 1).value.GLfixedVal,
                                params.getParam("z", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case gl::EntryPoint::Uniform1f:
            context->uniform1f(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::Uniform1fv:
            context->uniform1fv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform1i:
            context->uniform1i(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal);
            break;
        case gl::EntryPoint::Uniform1iv:
            context->uniform1iv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform1ui:
            context->uniform1ui(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case gl::EntryPoint::Uniform1uiv:
            context->uniform1uiv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform2f:
            context->uniform2f(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal,
                               params.getParam("v1", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::Uniform2fv:
            context->uniform2fv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform2i:
            context->uniform2i(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal,
                               params.getParam("v1", ParamType::TGLint, 2).value.GLintVal);
            break;
        case gl::EntryPoint::Uniform2iv:
            context->uniform2iv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform2ui:
            context->uniform2ui(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal,
                                params.getParam("v1", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case gl::EntryPoint::Uniform2uiv:
            context->uniform2uiv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform3f:
            context->uniform3f(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal,
                               params.getParam("v1", ParamType::TGLfloat, 2).value.GLfloatVal,
                               params.getParam("v2", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case gl::EntryPoint::Uniform3fv:
            context->uniform3fv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform3i:
            context->uniform3i(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal,
                               params.getParam("v1", ParamType::TGLint, 2).value.GLintVal,
                               params.getParam("v2", ParamType::TGLint, 3).value.GLintVal);
            break;
        case gl::EntryPoint::Uniform3iv:
            context->uniform3iv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform3ui:
            context->uniform3ui(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal,
                                params.getParam("v1", ParamType::TGLuint, 2).value.GLuintVal,
                                params.getParam("v2", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case gl::EntryPoint::Uniform3uiv:
            context->uniform3uiv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform4f:
            context->uniform4f(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal,
                               params.getParam("v1", ParamType::TGLfloat, 2).value.GLfloatVal,
                               params.getParam("v2", ParamType::TGLfloat, 3).value.GLfloatVal,
                               params.getParam("v3", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case gl::EntryPoint::Uniform4fv:
            context->uniform4fv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform4i:
            context->uniform4i(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal,
                               params.getParam("v1", ParamType::TGLint, 2).value.GLintVal,
                               params.getParam("v2", ParamType::TGLint, 3).value.GLintVal,
                               params.getParam("v3", ParamType::TGLint, 4).value.GLintVal);
            break;
        case gl::EntryPoint::Uniform4iv:
            context->uniform4iv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case gl::EntryPoint::Uniform4ui:
            context->uniform4ui(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal,
                                params.getParam("v1", ParamType::TGLuint, 2).value.GLuintVal,
                                params.getParam("v2", ParamType::TGLuint, 3).value.GLuintVal,
                                params.getParam("v3", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case gl::EntryPoint::Uniform4uiv:
            context->uniform4uiv(params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case gl::EntryPoint::UniformBlockBinding:
            context->uniformBlockBinding(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformBlockIndex", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("uniformBlockBinding", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case gl::EntryPoint::UniformMatrix2fv:
            context->uniformMatrix2fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix2x3fv:
            context->uniformMatrix2x3fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix2x4fv:
            context->uniformMatrix2x4fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix3fv:
            context->uniformMatrix3fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix3x2fv:
            context->uniformMatrix3x2fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix3x4fv:
            context->uniformMatrix3x4fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix4fv:
            context->uniformMatrix4fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix4x2fv:
            context->uniformMatrix4x2fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UniformMatrix4x3fv:
            context->uniformMatrix4x3fv(
                params.getParam("location", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case gl::EntryPoint::UnmapBuffer:
            context->unmapBuffer(params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                                     .value.BufferBindingVal);
            break;
        case gl::EntryPoint::UseProgram:
            context->useProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                    .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::UseProgramStages:
            context->useProgramStages(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("stages", ParamType::TGLbitfield, 1).value.GLbitfieldVal,
                params.getParam("programPacked", ParamType::TShaderProgramID, 2)
                    .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::ValidateProgram:
            context->validateProgram(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal);
            break;
        case gl::EntryPoint::ValidateProgramPipeline:
            context->validateProgramPipeline(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal);
            break;
        case gl::EntryPoint::VertexAttrib1f:
            context->vertexAttrib1f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case gl::EntryPoint::VertexAttrib1fv:
            context->vertexAttrib1fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::VertexAttrib2f:
            context->vertexAttrib2f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                                    params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case gl::EntryPoint::VertexAttrib2fv:
            context->vertexAttrib2fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::VertexAttrib3f:
            context->vertexAttrib3f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                                    params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal,
                                    params.getParam("z", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case gl::EntryPoint::VertexAttrib3fv:
            context->vertexAttrib3fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::VertexAttrib4f:
            context->vertexAttrib4f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                                    params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal,
                                    params.getParam("z", ParamType::TGLfloat, 3).value.GLfloatVal,
                                    params.getParam("w", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case gl::EntryPoint::VertexAttrib4fv:
            context->vertexAttrib4fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case gl::EntryPoint::VertexAttribBinding:
            context->vertexAttribBinding(
                params.getParam("attribindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("bindingindex", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case gl::EntryPoint::VertexAttribDivisor:
            context->vertexAttribDivisor(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("divisor", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case gl::EntryPoint::VertexAttribFormat:
            context->vertexAttribFormat(
                params.getParam("attribindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("normalized", ParamType::TGLboolean, 3).value.GLbooleanVal,
                params.getParam("relativeoffset", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case gl::EntryPoint::VertexAttribI4i:
            context->vertexAttribI4i(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("x", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("z", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("w", ParamType::TGLint, 4).value.GLintVal);
            break;
        case gl::EntryPoint::VertexAttribI4iv:
            context->vertexAttribI4iv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("v", ParamType::TGLintConstPointer, 1)));
            break;
        case gl::EntryPoint::VertexAttribI4ui:
            context->vertexAttribI4ui(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("x", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("y", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("z", ParamType::TGLuint, 3).value.GLuintVal,
                params.getParam("w", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case gl::EntryPoint::VertexAttribI4uiv:
            context->vertexAttribI4uiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("v", ParamType::TGLuintConstPointer, 1)));
            break;
        case gl::EntryPoint::VertexAttribIFormat:
            context->vertexAttribIFormat(
                params.getParam("attribindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("relativeoffset", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case gl::EntryPoint::VertexAttribIPointer:
            context->vertexAttribIPointer(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 4)));
            break;
        case gl::EntryPoint::VertexAttribPointer:
            context->vertexAttribPointer(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("normalized", ParamType::TGLboolean, 3).value.GLbooleanVal,
                params.getParam("stride", ParamType::TGLsizei, 4).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 5)));
            break;
        case gl::EntryPoint::VertexBindingDivisor:
            context->vertexBindingDivisor(
                params.getParam("bindingindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("divisor", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case gl::EntryPoint::VertexPointer:
            context->vertexPointer(
                params.getParam("size", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 1)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 3)));
            break;
        case gl::EntryPoint::Viewport:
            context->viewport(params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                              params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                              params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                              params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case gl::EntryPoint::WaitSync:
            context->waitSync(
                params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal,
                params.getParam("flags", ParamType::TGLbitfield, 1).value.GLbitfieldVal,
                params.getParam("timeout", ParamType::TGLuint64, 2).value.GLuint64Val);
            break;
        default:
            UNREACHABLE();
    }
}

}  // namespace angle
