// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_1_0_autogen.cpp:
//   Capture functions for the OpenGL ES 1.0 entry points.

#include "libANGLE/capture_gles_1_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/gl_enum_utils_autogen.h"
#include "libANGLE/validationES1.h"

using namespace angle;

namespace gl
{

CallCapture CaptureAlphaFunc(const Context *context,
                             bool isCallValid,
                             AlphaTestFunc funcPacked,
                             GLfloat ref)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("funcPacked", ParamType::TAlphaTestFunc, funcPacked);
    paramBuffer.addValueParam("ref", ParamType::TGLfloat, ref);

    return CallCapture(gl::EntryPoint::AlphaFunc, std::move(paramBuffer));
}

CallCapture CaptureAlphaFuncx(const Context *context,
                              bool isCallValid,
                              AlphaTestFunc funcPacked,
                              GLfixed ref)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("funcPacked", ParamType::TAlphaTestFunc, funcPacked);
    paramBuffer.addValueParam("ref", ParamType::TGLfixed, ref);

    return CallCapture(gl::EntryPoint::AlphaFuncx, std::move(paramBuffer));
}

CallCapture CaptureClearColorx(const Context *context,
                               bool isCallValid,
                               GLfixed red,
                               GLfixed green,
                               GLfixed blue,
                               GLfixed alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfixed, red);
    paramBuffer.addValueParam("green", ParamType::TGLfixed, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfixed, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfixed, alpha);

    return CallCapture(gl::EntryPoint::ClearColorx, std::move(paramBuffer));
}

CallCapture CaptureClearDepthx(const Context *context, bool isCallValid, GLfixed depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("depth", ParamType::TGLfixed, depth);

    return CallCapture(gl::EntryPoint::ClearDepthx, std::move(paramBuffer));
}

CallCapture CaptureClientActiveTexture(const Context *context, bool isCallValid, GLenum texture)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", GLenumGroup::TextureUnit, ParamType::TGLenum, texture);

    return CallCapture(gl::EntryPoint::ClientActiveTexture, std::move(paramBuffer));
}

CallCapture CaptureClipPlanef(const Context *context,
                              bool isCallValid,
                              GLenum p,
                              const GLfloat *eqn)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("p", GLenumGroup::ClipPlaneName, ParamType::TGLenum, p);

    ParamCapture eqnParam("eqn", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, eqn, &eqnParam.value);
    CaptureClipPlanef_eqn(context, isCallValid, p, eqn, &eqnParam);
    paramBuffer.addParam(std::move(eqnParam));

    return CallCapture(gl::EntryPoint::ClipPlanef, std::move(paramBuffer));
}

CallCapture CaptureClipPlanex(const Context *context,
                              bool isCallValid,
                              GLenum plane,
                              const GLfixed *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", GLenumGroup::ClipPlaneName, ParamType::TGLenum, plane);

    ParamCapture equationParam("equation", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, equation, &equationParam.value);
    CaptureClipPlanex_equation(context, isCallValid, plane, equation, &equationParam);
    paramBuffer.addParam(std::move(equationParam));

    return CallCapture(gl::EntryPoint::ClipPlanex, std::move(paramBuffer));
}

CallCapture CaptureColor4f(const Context *context,
                           bool isCallValid,
                           GLfloat red,
                           GLfloat green,
                           GLfloat blue,
                           GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture(gl::EntryPoint::Color4f, std::move(paramBuffer));
}

CallCapture CaptureColor4ub(const Context *context,
                            bool isCallValid,
                            GLubyte red,
                            GLubyte green,
                            GLubyte blue,
                            GLubyte alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLubyte, red);
    paramBuffer.addValueParam("green", ParamType::TGLubyte, green);
    paramBuffer.addValueParam("blue", ParamType::TGLubyte, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLubyte, alpha);

    return CallCapture(gl::EntryPoint::Color4ub, std::move(paramBuffer));
}

CallCapture CaptureColor4x(const Context *context,
                           bool isCallValid,
                           GLfixed red,
                           GLfixed green,
                           GLfixed blue,
                           GLfixed alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfixed, red);
    paramBuffer.addValueParam("green", ParamType::TGLfixed, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfixed, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfixed, alpha);

    return CallCapture(gl::EntryPoint::Color4x, std::move(paramBuffer));
}

CallCapture CaptureColorPointer(const Context *context,
                                bool isCallValid,
                                GLint size,
                                VertexAttribType typePacked,
                                GLsizei stride,
                                const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureColorPointer_pointer(context, isCallValid, size, typePacked, stride, pointer,
                                &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::ColorPointer, std::move(paramBuffer));
}

CallCapture CaptureDepthRangex(const Context *context, bool isCallValid, GLfixed n, GLfixed f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLfixed, n);
    paramBuffer.addValueParam("f", ParamType::TGLfixed, f);

    return CallCapture(gl::EntryPoint::DepthRangex, std::move(paramBuffer));
}

CallCapture CaptureDisableClientState(const Context *context,
                                      bool isCallValid,
                                      ClientVertexArrayType arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TClientVertexArrayType, arrayPacked);

    return CallCapture(gl::EntryPoint::DisableClientState, std::move(paramBuffer));
}

CallCapture CaptureEnableClientState(const Context *context,
                                     bool isCallValid,
                                     ClientVertexArrayType arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TClientVertexArrayType, arrayPacked);

    return CallCapture(gl::EntryPoint::EnableClientState, std::move(paramBuffer));
}

CallCapture CaptureFogf(const Context *context, bool isCallValid, GLenum pname, GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::FogParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::Fogf, std::move(paramBuffer));
}

CallCapture CaptureFogfv(const Context *context,
                         bool isCallValid,
                         GLenum pname,
                         const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::FogParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureFogfv_params(context, isCallValid, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::Fogfv, std::move(paramBuffer));
}

CallCapture CaptureFogx(const Context *context, bool isCallValid, GLenum pname, GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::FogPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::Fogx, std::move(paramBuffer));
}

CallCapture CaptureFogxv(const Context *context,
                         bool isCallValid,
                         GLenum pname,
                         const GLfixed *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::FogPName, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, param, &paramParam.value);
    CaptureFogxv_param(context, isCallValid, pname, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::Fogxv, std::move(paramBuffer));
}

CallCapture CaptureFrustumf(const Context *context,
                            bool isCallValid,
                            GLfloat l,
                            GLfloat r,
                            GLfloat b,
                            GLfloat t,
                            GLfloat n,
                            GLfloat f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfloat, l);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);
    paramBuffer.addValueParam("b", ParamType::TGLfloat, b);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("n", ParamType::TGLfloat, n);
    paramBuffer.addValueParam("f", ParamType::TGLfloat, f);

    return CallCapture(gl::EntryPoint::Frustumf, std::move(paramBuffer));
}

CallCapture CaptureFrustumx(const Context *context,
                            bool isCallValid,
                            GLfixed l,
                            GLfixed r,
                            GLfixed b,
                            GLfixed t,
                            GLfixed n,
                            GLfixed f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfixed, l);
    paramBuffer.addValueParam("r", ParamType::TGLfixed, r);
    paramBuffer.addValueParam("b", ParamType::TGLfixed, b);
    paramBuffer.addValueParam("t", ParamType::TGLfixed, t);
    paramBuffer.addValueParam("n", ParamType::TGLfixed, n);
    paramBuffer.addValueParam("f", ParamType::TGLfixed, f);

    return CallCapture(gl::EntryPoint::Frustumx, std::move(paramBuffer));
}

CallCapture CaptureGetClipPlanef(const Context *context,
                                 bool isCallValid,
                                 GLenum plane,
                                 GLfloat *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", GLenumGroup::ClipPlaneName, ParamType::TGLenum, plane);

    ParamCapture equationParam("equation", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, equation, &equationParam.value);
    CaptureGetClipPlanef_equation(context, isCallValid, plane, equation, &equationParam);
    paramBuffer.addParam(std::move(equationParam));

    return CallCapture(gl::EntryPoint::GetClipPlanef, std::move(paramBuffer));
}

CallCapture CaptureGetClipPlanex(const Context *context,
                                 bool isCallValid,
                                 GLenum plane,
                                 GLfixed *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", GLenumGroup::ClipPlaneName, ParamType::TGLenum, plane);

    ParamCapture equationParam("equation", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, equation, &equationParam.value);
    CaptureGetClipPlanex_equation(context, isCallValid, plane, equation, &equationParam);
    paramBuffer.addParam(std::move(equationParam));

    return CallCapture(gl::EntryPoint::GetClipPlanex, std::move(paramBuffer));
}

CallCapture CaptureGetFixedv(const Context *context,
                             bool isCallValid,
                             GLenum pname,
                             GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
    CaptureGetFixedv_params(context, isCallValid, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFixedv, std::move(paramBuffer));
}

CallCapture CaptureGetLightfv(const Context *context,
                              bool isCallValid,
                              GLenum light,
                              LightParameter pnamePacked,
                              GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLenumGroup::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetLightfv_params(context, isCallValid, light, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetLightfv, std::move(paramBuffer));
}

CallCapture CaptureGetLightxv(const Context *context,
                              bool isCallValid,
                              GLenum light,
                              LightParameter pnamePacked,
                              GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLenumGroup::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
    CaptureGetLightxv_params(context, isCallValid, light, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetLightxv, std::move(paramBuffer));
}

CallCapture CaptureGetMaterialfv(const Context *context,
                                 bool isCallValid,
                                 GLenum face,
                                 MaterialParameter pnamePacked,
                                 GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::MaterialFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetMaterialfv_params(context, isCallValid, face, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetMaterialfv, std::move(paramBuffer));
}

CallCapture CaptureGetMaterialxv(const Context *context,
                                 bool isCallValid,
                                 GLenum face,
                                 MaterialParameter pnamePacked,
                                 GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::MaterialFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
    CaptureGetMaterialxv_params(context, isCallValid, face, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetMaterialxv, std::move(paramBuffer));
}

CallCapture CaptureGetPointerv(const Context *context,
                               bool isCallValid,
                               GLenum pname,
                               void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPointervPName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetPointerv_params(context, isCallValid, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetPointerv, std::move(paramBuffer));
}

CallCapture CaptureGetTexEnvfv(const Context *context,
                               bool isCallValid,
                               TextureEnvTarget targetPacked,
                               TextureEnvParameter pnamePacked,
                               GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexEnvfv_params(context, isCallValid, targetPacked, pnamePacked, params,
                              &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexEnvfv, std::move(paramBuffer));
}

CallCapture CaptureGetTexEnviv(const Context *context,
                               bool isCallValid,
                               TextureEnvTarget targetPacked,
                               TextureEnvParameter pnamePacked,
                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexEnviv_params(context, isCallValid, targetPacked, pnamePacked, params,
                              &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexEnviv, std::move(paramBuffer));
}

CallCapture CaptureGetTexEnvxv(const Context *context,
                               bool isCallValid,
                               TextureEnvTarget targetPacked,
                               TextureEnvParameter pnamePacked,
                               GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
    CaptureGetTexEnvxv_params(context, isCallValid, targetPacked, pnamePacked, params,
                              &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexEnvxv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterxv(const Context *context,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
    CaptureGetTexParameterxv_params(context, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterxv, std::move(paramBuffer));
}

CallCapture CaptureLightModelf(const Context *context,
                               bool isCallValid,
                               GLenum pname,
                               GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::LightModelParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::LightModelf, std::move(paramBuffer));
}

CallCapture CaptureLightModelfv(const Context *context,
                                bool isCallValid,
                                GLenum pname,
                                const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::LightModelParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureLightModelfv_params(context, isCallValid, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::LightModelfv, std::move(paramBuffer));
}

CallCapture CaptureLightModelx(const Context *context,
                               bool isCallValid,
                               GLenum pname,
                               GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::LightModelParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::LightModelx, std::move(paramBuffer));
}

CallCapture CaptureLightModelxv(const Context *context,
                                bool isCallValid,
                                GLenum pname,
                                const GLfixed *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::LightModelParameter, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, param, &paramParam.value);
    CaptureLightModelxv_param(context, isCallValid, pname, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::LightModelxv, std::move(paramBuffer));
}

CallCapture CaptureLightf(const Context *context,
                          bool isCallValid,
                          GLenum light,
                          LightParameter pnamePacked,
                          GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLenumGroup::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::Lightf, std::move(paramBuffer));
}

CallCapture CaptureLightfv(const Context *context,
                           bool isCallValid,
                           GLenum light,
                           LightParameter pnamePacked,
                           const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLenumGroup::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureLightfv_params(context, isCallValid, light, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::Lightfv, std::move(paramBuffer));
}

CallCapture CaptureLightx(const Context *context,
                          bool isCallValid,
                          GLenum light,
                          LightParameter pnamePacked,
                          GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLenumGroup::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::Lightx, std::move(paramBuffer));
}

CallCapture CaptureLightxv(const Context *context,
                           bool isCallValid,
                           GLenum light,
                           LightParameter pnamePacked,
                           const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLenumGroup::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
    CaptureLightxv_params(context, isCallValid, light, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::Lightxv, std::move(paramBuffer));
}

CallCapture CaptureLineWidthx(const Context *context, bool isCallValid, GLfixed width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("width", ParamType::TGLfixed, width);

    return CallCapture(gl::EntryPoint::LineWidthx, std::move(paramBuffer));
}

CallCapture CaptureLoadIdentity(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::LoadIdentity, std::move(paramBuffer));
}

CallCapture CaptureLoadMatrixf(const Context *context, bool isCallValid, const GLfloat *m)
{
    ParamBuffer paramBuffer;

    ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, m, &mParam.value);
    CaptureLoadMatrixf_m(context, isCallValid, m, &mParam);
    paramBuffer.addParam(std::move(mParam));

    return CallCapture(gl::EntryPoint::LoadMatrixf, std::move(paramBuffer));
}

CallCapture CaptureLoadMatrixx(const Context *context, bool isCallValid, const GLfixed *m)
{
    ParamBuffer paramBuffer;

    ParamCapture mParam("m", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, m, &mParam.value);
    CaptureLoadMatrixx_m(context, isCallValid, m, &mParam);
    paramBuffer.addParam(std::move(mParam));

    return CallCapture(gl::EntryPoint::LoadMatrixx, std::move(paramBuffer));
}

CallCapture CaptureLogicOp(const Context *context, bool isCallValid, LogicalOperation opcodePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("opcodePacked", ParamType::TLogicalOperation, opcodePacked);

    return CallCapture(gl::EntryPoint::LogicOp, std::move(paramBuffer));
}

CallCapture CaptureMaterialf(const Context *context,
                             bool isCallValid,
                             GLenum face,
                             MaterialParameter pnamePacked,
                             GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::MaterialFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::Materialf, std::move(paramBuffer));
}

CallCapture CaptureMaterialfv(const Context *context,
                              bool isCallValid,
                              GLenum face,
                              MaterialParameter pnamePacked,
                              const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::MaterialFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureMaterialfv_params(context, isCallValid, face, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::Materialfv, std::move(paramBuffer));
}

CallCapture CaptureMaterialx(const Context *context,
                             bool isCallValid,
                             GLenum face,
                             MaterialParameter pnamePacked,
                             GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::MaterialFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::Materialx, std::move(paramBuffer));
}

CallCapture CaptureMaterialxv(const Context *context,
                              bool isCallValid,
                              GLenum face,
                              MaterialParameter pnamePacked,
                              const GLfixed *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::MaterialFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, param, &paramParam.value);
    CaptureMaterialxv_param(context, isCallValid, face, pnamePacked, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::Materialxv, std::move(paramBuffer));
}

CallCapture CaptureMatrixMode(const Context *context, bool isCallValid, MatrixType modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TMatrixType, modePacked);

    return CallCapture(gl::EntryPoint::MatrixMode, std::move(paramBuffer));
}

CallCapture CaptureMultMatrixf(const Context *context, bool isCallValid, const GLfloat *m)
{
    ParamBuffer paramBuffer;

    ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, m, &mParam.value);
    CaptureMultMatrixf_m(context, isCallValid, m, &mParam);
    paramBuffer.addParam(std::move(mParam));

    return CallCapture(gl::EntryPoint::MultMatrixf, std::move(paramBuffer));
}

CallCapture CaptureMultMatrixx(const Context *context, bool isCallValid, const GLfixed *m)
{
    ParamBuffer paramBuffer;

    ParamCapture mParam("m", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, m, &mParam.value);
    CaptureMultMatrixx_m(context, isCallValid, m, &mParam);
    paramBuffer.addParam(std::move(mParam));

    return CallCapture(gl::EntryPoint::MultMatrixx, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4f(const Context *context,
                                   bool isCallValid,
                                   GLenum target,
                                   GLfloat s,
                                   GLfloat t,
                                   GLfloat r,
                                   GLfloat q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);
    paramBuffer.addValueParam("q", ParamType::TGLfloat, q);

    return CallCapture(gl::EntryPoint::MultiTexCoord4f, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4x(const Context *context,
                                   bool isCallValid,
                                   GLenum texture,
                                   GLfixed s,
                                   GLfixed t,
                                   GLfixed r,
                                   GLfixed q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", GLenumGroup::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addValueParam("s", ParamType::TGLfixed, s);
    paramBuffer.addValueParam("t", ParamType::TGLfixed, t);
    paramBuffer.addValueParam("r", ParamType::TGLfixed, r);
    paramBuffer.addValueParam("q", ParamType::TGLfixed, q);

    return CallCapture(gl::EntryPoint::MultiTexCoord4x, std::move(paramBuffer));
}

CallCapture CaptureNormal3f(const Context *context,
                            bool isCallValid,
                            GLfloat nx,
                            GLfloat ny,
                            GLfloat nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLfloat, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLfloat, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLfloat, nz);

    return CallCapture(gl::EntryPoint::Normal3f, std::move(paramBuffer));
}

CallCapture CaptureNormal3x(const Context *context,
                            bool isCallValid,
                            GLfixed nx,
                            GLfixed ny,
                            GLfixed nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLfixed, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLfixed, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLfixed, nz);

    return CallCapture(gl::EntryPoint::Normal3x, std::move(paramBuffer));
}

CallCapture CaptureNormalPointer(const Context *context,
                                 bool isCallValid,
                                 VertexAttribType typePacked,
                                 GLsizei stride,
                                 const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureNormalPointer_pointer(context, isCallValid, typePacked, stride, pointer, &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::NormalPointer, std::move(paramBuffer));
}

CallCapture CaptureOrthof(const Context *context,
                          bool isCallValid,
                          GLfloat l,
                          GLfloat r,
                          GLfloat b,
                          GLfloat t,
                          GLfloat n,
                          GLfloat f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfloat, l);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);
    paramBuffer.addValueParam("b", ParamType::TGLfloat, b);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("n", ParamType::TGLfloat, n);
    paramBuffer.addValueParam("f", ParamType::TGLfloat, f);

    return CallCapture(gl::EntryPoint::Orthof, std::move(paramBuffer));
}

CallCapture CaptureOrthox(const Context *context,
                          bool isCallValid,
                          GLfixed l,
                          GLfixed r,
                          GLfixed b,
                          GLfixed t,
                          GLfixed n,
                          GLfixed f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfixed, l);
    paramBuffer.addValueParam("r", ParamType::TGLfixed, r);
    paramBuffer.addValueParam("b", ParamType::TGLfixed, b);
    paramBuffer.addValueParam("t", ParamType::TGLfixed, t);
    paramBuffer.addValueParam("n", ParamType::TGLfixed, n);
    paramBuffer.addValueParam("f", ParamType::TGLfixed, f);

    return CallCapture(gl::EntryPoint::Orthox, std::move(paramBuffer));
}

CallCapture CapturePointParameterf(const Context *context,
                                   bool isCallValid,
                                   PointParameter pnamePacked,
                                   GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::PointParameterf, std::move(paramBuffer));
}

CallCapture CapturePointParameterfv(const Context *context,
                                    bool isCallValid,
                                    PointParameter pnamePacked,
                                    const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CapturePointParameterfv_params(context, isCallValid, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::PointParameterfv, std::move(paramBuffer));
}

CallCapture CapturePointParameterx(const Context *context,
                                   bool isCallValid,
                                   PointParameter pnamePacked,
                                   GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::PointParameterx, std::move(paramBuffer));
}

CallCapture CapturePointParameterxv(const Context *context,
                                    bool isCallValid,
                                    PointParameter pnamePacked,
                                    const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
    CapturePointParameterxv_params(context, isCallValid, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::PointParameterxv, std::move(paramBuffer));
}

CallCapture CapturePointSize(const Context *context, bool isCallValid, GLfloat size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLfloat, size);

    return CallCapture(gl::EntryPoint::PointSize, std::move(paramBuffer));
}

CallCapture CapturePointSizex(const Context *context, bool isCallValid, GLfixed size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLfixed, size);

    return CallCapture(gl::EntryPoint::PointSizex, std::move(paramBuffer));
}

CallCapture CapturePolygonOffsetx(const Context *context,
                                  bool isCallValid,
                                  GLfixed factor,
                                  GLfixed units)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLfixed, factor);
    paramBuffer.addValueParam("units", ParamType::TGLfixed, units);

    return CallCapture(gl::EntryPoint::PolygonOffsetx, std::move(paramBuffer));
}

CallCapture CapturePopMatrix(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::PopMatrix, std::move(paramBuffer));
}

CallCapture CapturePushMatrix(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::PushMatrix, std::move(paramBuffer));
}

CallCapture CaptureRotatef(const Context *context,
                           bool isCallValid,
                           GLfloat angle,
                           GLfloat x,
                           GLfloat y,
                           GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("angle", ParamType::TGLfloat, angle);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(gl::EntryPoint::Rotatef, std::move(paramBuffer));
}

CallCapture CaptureRotatex(const Context *context,
                           bool isCallValid,
                           GLfixed angle,
                           GLfixed x,
                           GLfixed y,
                           GLfixed z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("angle", ParamType::TGLfixed, angle);
    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);

    return CallCapture(gl::EntryPoint::Rotatex, std::move(paramBuffer));
}

CallCapture CaptureSampleCoveragex(const Context *context,
                                   bool isCallValid,
                                   GLclampx value,
                                   GLboolean invert)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLclampx, value);
    paramBuffer.addValueParam("invert", ParamType::TGLboolean, invert);

    return CallCapture(gl::EntryPoint::SampleCoveragex, std::move(paramBuffer));
}

CallCapture CaptureScalef(const Context *context, bool isCallValid, GLfloat x, GLfloat y, GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(gl::EntryPoint::Scalef, std::move(paramBuffer));
}

CallCapture CaptureScalex(const Context *context, bool isCallValid, GLfixed x, GLfixed y, GLfixed z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);

    return CallCapture(gl::EntryPoint::Scalex, std::move(paramBuffer));
}

CallCapture CaptureShadeModel(const Context *context, bool isCallValid, ShadingModel modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TShadingModel, modePacked);

    return CallCapture(gl::EntryPoint::ShadeModel, std::move(paramBuffer));
}

CallCapture CaptureTexCoordPointer(const Context *context,
                                   bool isCallValid,
                                   GLint size,
                                   VertexAttribType typePacked,
                                   GLsizei stride,
                                   const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureTexCoordPointer_pointer(context, isCallValid, size, typePacked, stride, pointer,
                                   &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::TexCoordPointer, std::move(paramBuffer));
}

CallCapture CaptureTexEnvf(const Context *context,
                           bool isCallValid,
                           TextureEnvTarget targetPacked,
                           TextureEnvParameter pnamePacked,
                           GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::TexEnvf, std::move(paramBuffer));
}

CallCapture CaptureTexEnvfv(const Context *context,
                            bool isCallValid,
                            TextureEnvTarget targetPacked,
                            TextureEnvParameter pnamePacked,
                            const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureTexEnvfv_params(context, isCallValid, targetPacked, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexEnvfv, std::move(paramBuffer));
}

CallCapture CaptureTexEnvi(const Context *context,
                           bool isCallValid,
                           TextureEnvTarget targetPacked,
                           TextureEnvParameter pnamePacked,
                           GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(gl::EntryPoint::TexEnvi, std::move(paramBuffer));
}

CallCapture CaptureTexEnviv(const Context *context,
                            bool isCallValid,
                            TextureEnvTarget targetPacked,
                            TextureEnvParameter pnamePacked,
                            const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexEnviv_params(context, isCallValid, targetPacked, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexEnviv, std::move(paramBuffer));
}

CallCapture CaptureTexEnvx(const Context *context,
                           bool isCallValid,
                           TextureEnvTarget targetPacked,
                           TextureEnvParameter pnamePacked,
                           GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::TexEnvx, std::move(paramBuffer));
}

CallCapture CaptureTexEnvxv(const Context *context,
                            bool isCallValid,
                            TextureEnvTarget targetPacked,
                            TextureEnvParameter pnamePacked,
                            const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
    CaptureTexEnvxv_params(context, isCallValid, targetPacked, pnamePacked, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexEnvxv, std::move(paramBuffer));
}

CallCapture CaptureTexParameterx(const Context *context,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::TexParameterx, std::move(paramBuffer));
}

CallCapture CaptureTexParameterxv(const Context *context,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
    CaptureTexParameterxv_params(context, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterxv, std::move(paramBuffer));
}

CallCapture CaptureTranslatef(const Context *context,
                              bool isCallValid,
                              GLfloat x,
                              GLfloat y,
                              GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(gl::EntryPoint::Translatef, std::move(paramBuffer));
}

CallCapture CaptureTranslatex(const Context *context,
                              bool isCallValid,
                              GLfixed x,
                              GLfixed y,
                              GLfixed z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);

    return CallCapture(gl::EntryPoint::Translatex, std::move(paramBuffer));
}

CallCapture CaptureVertexPointer(const Context *context,
                                 bool isCallValid,
                                 GLint size,
                                 VertexAttribType typePacked,
                                 GLsizei stride,
                                 const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureVertexPointer_pointer(context, isCallValid, size, typePacked, stride, pointer,
                                 &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::VertexPointer, std::move(paramBuffer));
}

}  // namespace gl
