/*-
 ***********************************************************************
 *
 * $Id: webjob-dsvtool.h,v 1.21 2012/05/01 06:34:20 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2006-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _WEBJOB_DSVTOOL_H_INCLUDED
#define _WEBJOB_DSVTOOL_H_INCLUDED

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define PROGRAM_NAME "webjob-dsvtool"
#define VERSION "1.3.2"

#define ER -1
#define ER_OK 0
#define ER_SignatureVerificationFailed 5
#define ER_SignatureVerificationMixed 11

#define XER_OK 0
#define XER_Usage 1
#define XER_BootStrap 2
#define XER_ProcessArguments 3
#define XER_PayloadSigningError 4
#define XER_SignatureVerificationFailed 5
#define XER_SignatureVerificationError 6
#define XER_RunMode 7
#define XER_Shutdown 8
#define XER_KeyGenerationError 9
#define XER_PasswordGenerationError 10
#define XER_SignatureVerificationMixed 11

#define DSV_SIGN    0x00000001
#define DSV_VERIFY  0x00000002
#define DSV_KEYGEN  0x00000003
#define DSV_PASSGEN 0x00000004

#define DSV_KEY_TYPE_DSA 1
#define DSV_KEY_TYPE_RSA 2

#define DSV_VERIFY_VIA_FILE 0x00000001
#define DSV_VERIFY_VIA_TREE 0x00000002

#define DSV_DEFAULT_PASSWORD_LENGTH 8
#define DSV_MIN_CHARACTER_SET_LENGTH 1
#define DSV_MAX_CHARACTER_SET_LENGTH 255
#define DSV_MIN_PASSWORD_LENGTH 1
#define DSV_MAX_PASSWORD_LENGTH 1048576 /* 1 MB */

#define DSV_MAX_TRIES_MULTIPLIER 2
#define DSV_MAX_TRIES_CONSTANT 5

typedef enum _DSV_OPTION_IDS
{
  OPT_Bits,
  OPT_CertFile,
  OPT_CertTree,
  OPT_CharacterClass,
  OPT_CharacterSet,
  OPT_Key,
  OPT_Length,
  OPT_Type,
} DSV_OPTION_IDS;

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _DSV_PROPERTIES
{
  char               *pcCertFile;
  char               *pcCertTree;
  char               *pcCharacterSet;
  char               *pcKeyFile;
  char              **ppcFileVector;
  DSV_CERT_NODE      *psCertList;
  int                 iCharacterSetLength;
  int                 iFileCount;
  int                 iFileType;
  int                 iKeyBits;
  int                 iKeyType;
  int                 iRunMode;
  int                 iPasswordLength;
  int                 iVerifyMode;
} DSV_PROPERTIES;

/*-
 ***********************************************************************
 *
 * Function Prototypes
 *
 ***********************************************************************
 */
int                 DsvBootStrap(char *pcError);
void                DsvFreeProperties(DSV_PROPERTIES *psProperties);
DSV_PROPERTIES     *DsvGetPropertiesReference(void);
DSV_PROPERTIES     *DsvNewProperties(char *pcError);
int                 DsvOptionHandler(OPTIONS_TABLE *psOption, char *pcValue, DSV_PROPERTIES *psProperties, char *pcError);
int                 DsvProcessArguments(int iArgumentCount, char *ppcArgumentVector[], DSV_PROPERTIES *psProperties, char *pcError);
void                DsvSetPropertiesReference(DSV_PROPERTIES *psProperties);
void                DsvShutdown(int iError);
int                 DsvSign(DSV_PROPERTIES *psProperties, char *pcError);
void                DsvUsage(void);
int                 DsvVerify(DSV_PROPERTIES *psProperties, char *pcError);
void                DsvVersion(void);
int                 DsvWorkHorse(DSV_PROPERTIES *psProperties, char *pcError);

#endif /* !_WEBJOB_DSVTOOL_H_INCLUDED */
