########################################################################
#
# $Id: Makefile.vs,v 1.6 2011/02/12 18:23:44 mavrik Exp $
#
########################################################################
#
# Purpose: Makefile for Visual Studio.
#
########################################################################

BUILD_TYPE		= RELEASE	# [RELEASE|DEBUG]
USE_STATIC_SSL_LIBS	= Y		# [Y|N]

INSTALL_DIR		= C:\WebJob
SOURCE_DIR		= .
OBJECT_DIR		= build

SSL_DIR			= C:\OpenSSL
SSL_LIB_DIR		= $(SSL_DIR)\lib
SSL_INC_DIR		= $(SSL_DIR)\include
SSL_DLL1		= $(SSL_DIR)\bin\libeay32.dll
SSL_DLL2		= $(SSL_DIR)\bin\ssleay32.dll
SSL_COMPILER_FLAGS	= /D USE_SSL /I"$(SSL_INC_DIR)"
!IF "$(USE_STATIC_SSL_LIBS)" == "Y" || "$(USE_STATIC_SSL_LIBS)" == "y"
SSL_LINKER_FLAGS	= /libpath:"$(SSL_LIB_DIR)" user32.lib advapi32.lib libeay32.lib ssleay32.lib gdi32.lib wsock32.lib
!ELSE
SSL_LINKER_FLAGS	= /libpath:"$(SSL_LIB_DIR)" user32.lib advapi32.lib libeay32.lib ssleay32.lib wsock32.lib
!ENDIF

COMPILER		= cl.exe

COMPILER_FLAGS		=\
			/nologo\
			/D _MBCS\
			/D _CONSOLE\
			/D _CRT_SECURE_NO_DEPRECATE\
			/D WIN32\
			$(SSL_COMPILER_FLAGS)\
			/I"."\
			/Fo"$(OBJECT_DIR)\\"\
			/Fd"$(OBJECT_DIR)\\"\
			/Fp"$(OBJECT_DIR)\webjob-dsvtool.pch"\
			/c /W3 /EHsc /FD\
!IF "$(BUILD_TYPE)" == "DEBUG" || "$(BUILD_TYPE)" == "debug"
			/D _DEBUG\
			/MTd /Od /Zi /Gm
!ELSE
			/D NDEBUG\
			/MT /O2
!ENDIF

INCLUDES		=\
			"$(SOURCE_DIR)\all-includes.h"\
			"$(SOURCE_DIR)\dsv.h"\
			"$(SOURCE_DIR)\dsv-pool.h"\
			"$(SOURCE_DIR)\options.h"\
			"$(SOURCE_DIR)\ssl.h"\
			"$(SOURCE_DIR)\ssl-pool.h"\
			"$(SOURCE_DIR)\webjob-dsvtool.h"

OBJECTS			=\
			"$(OBJECT_DIR)\dsv.obj"\
			"$(OBJECT_DIR)\options.obj"\
			"$(OBJECT_DIR)\ssl.obj"\
			"$(OBJECT_DIR)\webjob-dsvtool.obj"

EXECUTEABLE		= $(OBJECT_DIR)\webjob-dsvtool.exe

LINKER			= link.exe

LINKER_FLAGS		=\
			/nologo\
			/subsystem:console\
			/machine:I386\
			$(SSL_LINKER_FLAGS)\
			/out:"$(EXECUTEABLE)"\
			/pdb:"$(OBJECT_DIR)\webjob-dsvtool.pdb"\
!IF "$(BUILD_TYPE)" == "DEBUG" || "$(BUILD_TYPE)" == "debug"
			/incremental:yes\
			/debug\
			/pdbtype:sept
!ELSE
			/incremental:no
!ENDIF

all: "$(EXECUTEABLE)"

install: "$(EXECUTEABLE)"
	if not exist "$(INSTALL_DIR)" mkdir "$(INSTALL_DIR)"
	if not exist "$(INSTALL_DIR)\bin" mkdir "$(INSTALL_DIR)\bin"
	if not exist "$(INSTALL_DIR)\doc" mkdir "$(INSTALL_DIR)\doc"
	copy "$(EXECUTEABLE)" "$(INSTALL_DIR)\bin"
	copy ..\..\doc\webjob-dsvtool.html "$(INSTALL_DIR)\doc"
!IF "$(USE_STATIC_SSL_LIBS)" == "N" || "$(USE_STATIC_SSL_LIBS)" == "n"
	if not exist "$(INSTALL_DIR)\bin\$(SSL_DLL1)" copy "$(SSL_DLL1)" "$(INSTALL_DIR)\bin"
	if not exist "$(INSTALL_DIR)\bin\$(SSL_DLL2)" copy "$(SSL_DLL2)" "$(INSTALL_DIR)\bin"
!ENDIF

clean:
	if exist "$(OBJECT_DIR)" rd /Q /S "$(OBJECT_DIR)"

clean-all: clean

test: all

"$(EXECUTEABLE)": "$(OBJECT_DIR)" $(OBJECTS)
	$(LINKER) $(LINKER_FLAGS) $(OBJECTS)
!IF "$(USE_STATIC_SSL_LIBS)" == "N" || "$(USE_STATIC_SSL_LIBS)" == "n"
	copy "$(SSL_DLL1)" "$(OBJECT_DIR)"
	copy "$(SSL_DLL2)" "$(OBJECT_DIR)"
!ENDIF

{$(SOURCE_DIR)}.c{$(OBJECT_DIR)}.obj::
	$(COMPILER) $(COMPILER_FLAGS) $<

"$(OBJECT_DIR)":
	if not exist "$(OBJECT_DIR)" mkdir "$(OBJECT_DIR)"

"$(OBJECT_DIR)\dsv.obj": "$(SOURCE_DIR)\dsv.c" $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\options.obj": "$(SOURCE_DIR)\options.c" $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\ssl.obj": "$(SOURCE_DIR)\ssl.c" $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\webjob-dsvtool.obj": "$(SOURCE_DIR)\webjob-dsvtool.c" $(INCLUDES) "$(OBJECT_DIR)"

