#!/usr/bin/perl
######################################################################
#
# $Id: pmcf-builder.cgi,v 1.20 2012/01/07 08:01:14 mavrik Exp $
#
######################################################################
#
# Copyright 2003-2012 The WebJob Project, All Rights Reserved.
#
######################################################################

use strict;
use CGI;
use File::Basename;

######################################################################
#
# Main Routine
#
######################################################################

  ####################################################################
  #
  # Punch in and go to work.
  #
  ####################################################################

  my (%hProperties);

  $hProperties{'Program'} = basename(__FILE__);
  $hProperties{'Version'} = sprintf("%s %s", __FILE__, ('$Revision: 1.20 $' =~ /^.Revision: ([\d.]+)/));
  $hProperties{'MaxRecords'} = 100;
  $hProperties{'BasePath'} = "/home/groups/w/we/webjob";

  ####################################################################
  #
  # Determine the current special.
  #
  ####################################################################

  if (open(FH, "< $hProperties{'BasePath'}/builder/SPECIAL"))
  {
    my $sLine = <FH>;
    if ($sLine =~ /^((?:ftimes|webjob)-[1-3].[0-9].[0-9](?:.(?:alpha|beta|gamma|delta|rc[1-5]))?.tgz)$/)
    {
      $hProperties{'Special'} = $1;
    }
    close(FH);
  }

  ####################################################################
  #
  # Preprocess the query string (i.e., unencode it).
  #
  ####################################################################

  my $sPathInfo = $ENV{'PATH_INFO'};
  if ($sPathInfo =~ /^\/((?:ftimes|webjob)-[1-3].[0-9].[0-9](?:.(?:alpha|beta|gamma|delta|rc[1-5]))?.tgz)$/)
  {
    SendDataFile(\%hProperties, $1);
    exit(0);
  }
  elsif ($sPathInfo =~ /^\/(README\.PMCF|pmcf-builder)$/)
  {
    SendTextFile(\%hProperties, $1);
    exit(0);
  }

  my $sQueryString = $ENV{'QUERY_STRING'};
  $sQueryString =~ s/\+/ /g;
  $sQueryString =~ s/%([0-9a-fA-F]{2})/pack("c", hex($1))/ge;
  if ($sQueryString =~ /^group=([\w+.:-]{1,1024})$/)
  {
    SendRawData(\%hProperties, $1);
    exit(0);
  }
  else
  {
    SendReport(\%hProperties);
    exit(0);
  }

  1;


######################################################################
#
# MakeReport
#
######################################################################

sub MakeReport
{
  my ($phProperties, @aInput) = @_;

  my $sDate = localtime;
  my @aHFields=();
  my @aRFields=();
  my %hData;
  my $sBGColor = "#cccccc";
  my $sCellColor = "#cccccc";
  my $sCellColorString = "";
  my $sAlignmentString = "";

  my $sReportType = "build";
  my $sTitle = "Build";

  $sBGColor = "#cccccc";

  my $sOHandle = \*stdout;

  GenerateHeader($phProperties);
  print $sOHandle $$phProperties{'Header'};
  print $sOHandle "<center><h2>Poor Man's Compile Farm (PMCF) $sTitle Report</h2></center>\n";
  print $sOHandle "<center><p>Download the current builder script, and donate some CPU cycles. Get started <a href=\"http://webjob.sourceforge.net/cgi-bin/pmcf-builder.cgi/README.PMCF\">here</a>.</p></center>\n";
  if (defined($$phProperties{'Special'}))
  {
    my $sBuilder = "<a href=\"http://webjob.sourceforge.net/cgi-bin/pmcf-builder.cgi/pmcf-builder\">pmcf-builder</a>";
    my $sSpecial = "<a href=\"http://webjob.sourceforge.net/cgi-bin/pmcf-builder.cgi/" . $$phProperties{'Special'} . ".pad\">" . $$phProperties{'Special'} . ".pad</a>";
    print $sOHandle "<center><h3>Today's Special</h3></center>\n";
    print $sOHandle "<center><p>\$ sh $sBuilder -s -d /usr/local/webjob/dsv -f $sSpecial -T</p></center>\n";
  }
  print $sOHandle "<table align=\"center\" width=\"98%\" cellspacing=\"1\">\n";

  ##################################################################
  #
  # DateTime|Hostname|Arch|SystemOS|TarBall|Duration|Bits|Errors|Warnings|Results
  #
  ##################################################################

  my $sHeader = shift(@aInput);
  if ($sHeader)
  {
    $sHeader =~ s/[\r\n]+$//;
    @aHFields = split(/\|/, $sHeader, -1);
    print $sOHandle "<tr>";
    foreach my $sField (@aHFields)
    {
      if ($sField =~ /^(Errors|Warnings)$/)
      {
        $sField = substr($sField, 0, 1);
      }
      print $sOHandle "<th><p class=\"TableHeader\">$sField</p></th>";
    }
    print $sOHandle "</tr>\n";

    foreach my $sLine (@aInput)
    {
      $sLine =~ s/[\r\n]+$//;

      $sBGColor = $sCellColor = "#cccccc";

      @aRFields = split(/\|/, $sLine, -1);

      my $sIndex = 0;
      $hData{'DateTime'} = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'Hostname'} = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'Arch'}     = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'SystemOS'} = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'TarBall'}  = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'Duration'} = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'Bits'}     = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'Errors'}   = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'Warnings'} = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;
      $hData{'Results'}  = (length($aRFields[$sIndex]) && $aRFields[$sIndex] ne "NULL") ? $aRFields[$sIndex] : "&nbsp;"; $sIndex++;

# Table row color
      if ($hData{'TarBall'} =~ /^webjob/)
      {
        print $sOHandle "<tr class=\"TableRecordA\">";
      }
      elsif ($hData{'TarBall'} =~ /^ftimes/)
      {
        print $sOHandle "<tr class=\"TableRecordB\">";
      }
      else
      {
        print $sOHandle "<tr class=\"TableRecord\">";
      }

      foreach my $sField (@aHFields)
      {
        my $sOutput;
# Alignment
        if ($sField =~ /^(DateTime|Bits|Results)$/)
        {
          $sAlignmentString = " align=\"center\"";
        }
        elsif ($sField =~ /^[EW]$/)
        {
          $sAlignmentString = " align=\"right\"";
        }
        else
        {
          $sAlignmentString = ($hData{$sField} =~ /^\d+(?:[.]\d+)?$/) ? " align=\"right\"" : "";
        }
# Output + HREFs
        if ($sField =~ /^Results$/ && $sReportType =~ /^build$/i)
        {
          $sOutput = "<a href=\"/cgi-bin/pmcf-builder.cgi?group=" . $hData{$sField} . "\">" . "env,err,out" . "</a>";
        }
        elsif ($sField =~ /^E$/)
        {
          $sOutput = $hData{'Errors'};
        }
        elsif ($sField =~ /^W$/)
        {
          $sOutput = $hData{'Warnings'};
        }
        else
        {
          $sOutput = $hData{$sField};
        }
# Color
        if ($sField =~ /^E$/)
        {
          $sCellColorString = ($hData{'Errors'} !~ /^0$/) ? " bgcolor=\"orange\"" : "";
        }
        elsif ($sField =~ /^W$/)
        {
          $sCellColorString = ($hData{'Warnings'} !~ /^0$/) ? " bgcolor=\"#ffff66\"" : "";
        }
        elsif ($sField =~ /^Results$/)
        {
          $sCellColorString = ($hData{'Bits'} !~ /^(?:32|64)$/) ? " bgcolor=\"#ff6060\"" : "";
        }
        else
        {
          $sCellColorString = "";
        }
        print $sOHandle "<td$sAlignmentString$sCellColorString><p><tt>$sOutput</tt></p></td>";
      }
      print $sOHandle "</tr>\n";
    }
  }

  print $sOHandle "</table>\n";
  PrintFoot($sOHandle, $$phProperties{'Program'}, $sDate);
  print $sOHandle "</body></html>\n";

  ####################################################################
  #
  # Cleanup and go home.
  #
  ####################################################################

  1;
}

######################################################################
#
# GenerateHeader
#
######################################################################

sub GenerateHeader
{
  my ($phProperties) = @_;

  my $sRefreshRate = 3600;

  $$phProperties{'Header'} = <<EOF;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN">
<html>
<head>
  <title>Poor Man's Compile Farm</title>
  <style type="text/css">
    p { clear: left; margin: 5px;}
    .FloatLeft { float: left; }
    .Level5 { background-color: #ff6060; }
    .Level4 { background-color: orange; }
    .Level3 { background-color: yellow; }
    .Level2 { background-color: springgreen; }
    .Level1 { background-color: aqua; }
    .Level0 { background-color: gainsboro; }
    .TableHeader { font: 14px monaco; font-weight: bold; }
    .TableRecord { font: 13px monaco; background-color: gainsboro; }
    .TableRecordA { font: 13px monaco; background-color: lavender; }
    .TableRecordB { font: 13px monaco; background-color: gainsboro; }
    .ReportNormal { background-color: lavender; }
    .ReportActive { background-color: blanchedalmond; }
  </style>
  <meta http-equiv="refresh" content="$sRefreshRate">
</head>
<body>
EOF
}


######################################################################
#
# PrintFoot
#
######################################################################

sub PrintFoot
{
  my ($sOHandle, $sProgram, $sDate) = @_;

  print "<center>\n";
  print $sOHandle "<p>Report automatically generated by $sProgram on $sDate</p>\n";
  print "</center>\n";
}


######################################################################
#
# SendDataFile
#
######################################################################

sub SendDataFile
{
  my ($phProperties, $sFile) = @_;

  ####################################################################
  #
  # Set response head content type.
  #
  ####################################################################

  print "Content-Type: application/octet\r\n";
  print "\r\n";

  ####################################################################
  #
  # Open the file and deliver the content.
  #
  ####################################################################

  open(FH, "< $$phProperties{'BasePath'}/builder/$sFile") || exit;
  while (<FH>)
  {
    print;
  }

  close(FH);
  1;
}


######################################################################
#
# SendTextFile
#
######################################################################

sub SendTextFile
{
  my ($phProperties, $sFile) = @_;

  ####################################################################
  #
  # Set response head content type.
  #
  ####################################################################

  print "Content-Type: text/plain\r\n";
  print "\r\n";

  ####################################################################
  #
  # Open the file and deliver the content.
  #
  ####################################################################

  open(FH, "< $$phProperties{'BasePath'}/builder/$sFile") || exit;
  while (<FH>)
  {
    print;
  }

  close(FH);
  1;
}


######################################################################
#
# SendRawData
#
######################################################################

sub SendRawData
{
  my ($phProperties, $sBaseName) = @_;

  ####################################################################
  #
  # Set response head content type.
  #
  ####################################################################

  print "Content-Type: text/html\r\n";
  print "\r\n";

  ####################################################################
  #
  # Open the .env, .err, and .out files and deliver their (slightly
  # sanitized) content.
  #
  ####################################################################

  print "<html><body>\n";
  foreach my $sExt ("env", "err", "out")
  {
    my $sFile = $$phProperties{'BasePath'} . "/webjob/incoming/" . $sBaseName . "." . $sExt;
    print "<hr>Raw Data (std$sExt) <hr>\n";
    print "<pre>\n";
    open(RAW, "< $sFile") || print "File read error ($!).\n";
    while (my $sLine = <RAW>)
    {
      if ($sLine =~ /(^make.+error|abort|^fail )/i)
      {
        $sLine =~ s/^/<b style="color:black;background-color:#ffff66">/;
        $sLine =~ s/$/<\/b>/;
      }
      if ($sLine =~ /^Hostname=/) # Sanatize hostnames...
      {
        $sLine =~ s/\..*$//;
      }
      if ($sLine =~ /: (Entering|Leaving) directory/) # Get rid of annoying make stuff...
      {
        next;
      }
#FILTER1 BEGIN
#     $sLine =~ s/private/public/g;
#FILTER1 END
      print $sLine;
    }
    close(RAW);
    print "</pre>\n";
  }
  print "</body></html>\n";

  1;
}


######################################################################
#
# SendReport
#
######################################################################

sub SendReport
{
  my ($phProperties) = @_;

  ####################################################################
  #
  # Set response head content type.
  #
  ####################################################################

  print "Content-Type: text/html\r\n";
  print "\r\n";

  ####################################################################
  #
  # Open the incoming directory and create a list of input files.
  #
  ####################################################################

  my (@aOutFiles);

  my $sDir = "/tmp/persistent/webjob/incoming";
  if (!opendir(DIR, $sDir))
  {
    print "<html><body><p>No uploads found.</p></body></html>\n";
    exit;
  }
  @aOutFiles = sort(grep(/builder_.*\.rdy$/, map("$sDir/$_", readdir(DIR))));
  closedir(DIR);

  ####################################################################
  #
  # Generate a header record.
  #
  ####################################################################

  my @aInput = ();
  push(@aInput, "DateTime|Hostname|Arch|SystemOS|TarBall|Duration|Bits|Errors|Warnings|Results");

  ####################################################################
  #
  # Generate data records.
  #
  ####################################################################

  my $sLimit = (scalar(@aOutFiles) > $$phProperties{'MaxRecords'}) ? $$phProperties{'MaxRecords'} - 1 : $#aOutFiles;
  foreach my $sRdyFile ((reverse(@aOutFiles))[0..$sLimit])
  {
    my $sBasename = basename($sRdyFile, ".rdy");
    my $sOutFile = $sRdyFile;
    my $sErrFile = $sRdyFile;
    my $sEnvFile = $sRdyFile;
    $sOutFile =~ s/\.rdy$/.out/;
    $sErrFile =~ s/\.rdy$/.err/;
    $sEnvFile =~ s/\.rdy$/.env/;
    my $sDateInfo = (split(/_/, $sBasename))[1];
    my $sPutDate = "xx-xx-xx";
    my $sPutTime = "xx:xx:xx";
    if ($sDateInfo =~ /(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/)
    {
      $sPutDate = "$1-$2-$3";
      $sPutTime = "$4:$5:$6";
    }
    if (!open(RH, "< $sEnvFile"))
    {
      print "<html><body><p>Processing error. Try again later.</p></body></html>\n";
      exit;
    }

    my %h;

    while (my $sLine = <RH>)
    {
      $sLine =~ s/[\r\n]+$//; # Remove CRs and LFs.
      $sLine =~ s/#.*$//; # Remove comments.
      if ($sLine !~ /^\s*$/)
      {
        my ($sKey, $sValue) = ($sLine =~ /^([^=]*)=(.*)$/);
        $sKey =~ s/^\s+//; # Remove leading whitespace.
        $sKey =~ s/\s+$//; # Remove trailing whitespace.
        $sValue =~ s/^\s+//; # Remove leading whitespace.
        $sValue =~ s/\s+$//; # Remove trailing whitespace.
        $h{$sKey} = $sValue;
      }
    }
    my $sHostname = $h{'Hostname'};
    $sHostname =~ s/[.].*$//;
    $sHostname =~ s/^(usf-cf-)//;
    my $sRunEpoch = $h{'RunEpoch'};
    $sRunEpoch =~ s/^.*[(]//;
    $sRunEpoch =~ s/[)].*$//;
    my $sPutEpoch = $h{'PutEpoch'};
    $sPutEpoch =~ s/^.*[(]//;
    $sPutEpoch =~ s/[)].*$//;
    my $sDuration = sprintf("%.2f", $sPutEpoch - $sRunEpoch);
    close(RH);

    if (!open(RH, "< $sOutFile"))
    {
      print "<html><body><p>Processing error. Try again later.</p></body></html>\n";
      exit;
    }
    my $sTool = "";
    my $sVersion = "";
    my $sBits = "";
    my $sWarnings = 0;
    my $sErrors = 0;
    while (my $sLine = <RH>)
    {
      $sLine =~ s/[\r\n]+$//; # Remove CRs and LFs.
      if ($sLine =~ /warning/i)
      {
        $sWarnings++;
      }
      elsif ($sLine =~ /(^make.+error|abort|^fail )/i)
      {
        $sErrors++;
      }
      elsif ($sLine =~ /^(ftimes|webjob) ([0-9]{1,}\.){2}[0-9]{1,} .* ([0-9]{2})[ -]bit/)
      {
        $sTool = $1;
        $sVersion = $2;
        $sBits = $3;
      }
    }
    close(RH);
    my $sResults = $sBasename;
    my $sDateTime = "$sPutDate $sPutTime";
    my $sSystemOs = $h{'SystemOS'};
    $sSystemOs =~ s/Windows NT/WinNT/;
    $sSystemOs =~ s/Service Pack/SP/;
    $sSystemOs =~ s/^(i[36]86|i86pc|sun4[mu]|INTEL|ppc|amd(?:64)?) +//;
    my $sArch = $1 || "unknown";
    my $sTarBall = $h{'Command'};
    $sTarBall =~ s/(?:\.exe)?\.pad$//;

    my $sRecord = join("|", $sDateTime, $sHostname, $sArch, $sSystemOs, $sTarBall, $sDuration, $sBits, $sErrors, $sWarnings, $sResults);
# FILTER2 BEGIN
#   $sRecord =~ s/private/public/g;
# FILTER2 END
    push(@aInput, $sRecord);
  }

  ####################################################################
  #
  # Build and output the report.
  #
  ####################################################################

  MakeReport($phProperties, @aInput);

  1;
}
