/*-
 ***********************************************************************
 *
 * $Id: options.h,v 1.4 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2006-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _OPTIONS_H_INCLUDED
#define _OPTIONS_H_INCLUDED

#ifdef UNIX
  #ifndef TCHAR
    #define TCHAR char
  #endif
  #ifndef _tcscmp
    #define _tcscmp strcmp
  #endif
  #ifndef _sntprintf
    #define _sntprintf snprintf
  #endif
  #ifndef _T
    #define _T(x) x
  #endif
#endif

/*-
 ***********************************************************************
 *
 * Defines.
 *
 ***********************************************************************
 */
#define OPTIONS_NICKNAME_SIZE (3 * sizeof(TCHAR))
#define OPTIONS_FULLNAME_SIZE (256 * sizeof(TCHAR))

#define OPTIONS_ER   -1
#define OPTIONS_OK    0
#define OPTIONS_USAGE 1

#ifndef MESSAGE_SIZE
#define MESSAGE_SIZE (1024 * sizeof(TCHAR))
#endif

/*-
 ***********************************************************************
 *
 * Typedefs.
 *
 ***********************************************************************
 */
typedef struct _OPTIONS_TABLE
{
  int                 iId;
  TCHAR               atcNickName[OPTIONS_NICKNAME_SIZE];
  TCHAR               atcFullName[OPTIONS_FULLNAME_SIZE];
  int                 iAllowRepeats;
  int                 iFound;
  int                 iNArguments; /* 0, 1, or possibly more */
  int                 iRequired;
  int               (*piHandler)();
} OPTIONS_TABLE;

typedef struct _OPTIONS_CONTEXT
{
  TCHAR             **pptcArgumentVector;
  int                 iArgumentCount;
  int                 iArgumentIndex;
  int                 iNOptions;
  OPTIONS_TABLE      *psOptions;
} OPTIONS_CONTEXT;

/*-
 ***********************************************************************
 *
 * Function Prototypes.
 *
 ***********************************************************************
 */
void                  OptionsFreeOptionsContext(OPTIONS_CONTEXT *psOptionsContext);
int                   OptionsGetArgumentIndex(OPTIONS_CONTEXT *psOptionsContext);
int                   OptionsGetArgumentsLeft(OPTIONS_CONTEXT *psOptionsContext);
TCHAR                *OptionsGetCommand(OPTIONS_CONTEXT *psOptionsContext);
TCHAR                *OptionsGetCurrentArgument(OPTIONS_CONTEXT *psOptionsContext);
TCHAR                *OptionsGetFirstArgument(OPTIONS_CONTEXT *psOptionsContext);
TCHAR                *OptionsGetNextArgument(OPTIONS_CONTEXT *psOptionsContext);
int                   OptionsHaveRequiredOptions(OPTIONS_CONTEXT *psOptionsContext);
int                   OptionsHaveSpecifiedOption(OPTIONS_CONTEXT *psOptionsContext, int iId);
OPTIONS_CONTEXT      *OptionsNewOptionsContext(int iArgumentCount, TCHAR *pptcArgumentVector[], TCHAR *ptcError);
int                   OptionsProcessOptions(OPTIONS_CONTEXT *psOptionsContext, void *pvProperties, TCHAR *ptcError);
void                  OptionsSetOptions(OPTIONS_CONTEXT *psOptionsContext, OPTIONS_TABLE *psOptions, int iNOptions);

#endif /* !_OPTIONS_H_INCLUDED */
