/*-
 ***********************************************************************
 *
 * $Id: dsv.h,v 1.10 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2006-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _DSV_H_INCLUDED
#define _DSV_H_INCLUDED

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define DSV_CHOP 0x00000001
#define DSV_FILE_TYPE_CERT 1
#define DSV_FILE_TYPE_PUBKEY 2
#define DSV_MAX_PASSPHRASE_LENGTH 64
#define DSV_READ_SIZE 8192
#define DSV_SEED_LENGTH 1024
#define DSV_SIGNATURE_EXTENSION "sig"
#define DSV_SIGNATURE_VERIFICATION_NOFLY -2
#define DSV_SIGNATURE_VERIFICATION_ERROR -1
#define DSV_SIGNATURE_VERIFICATION_FAILED 0
#define DSV_SIGNATURE_VERIFICATION_PASSED 1
#define DSV_VERIFY_VIA_FILE 0x00000001
#define DSV_VERIFY_VIA_TREE 0x00000002

#ifdef WIN32
  #define DSV_SLASHCHAR '\\'
  #ifdef MAX_PATH
    #define DSV_MAX_PATH MAX_PATH
  #else
    #define DSV_MAX_PATH 260
  #endif
#else
  #define DSV_SLASHCHAR '/'
  #ifdef MAX_PATH
    #define DSV_MAX_PATH MAX_PATH
  #else
    #define DSV_MAX_PATH 4096
  #endif
#endif

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _DSV_CERT_NODE
{
  char               *pcFile;
  char               *pcCommonName;
  EVP_PKEY           *psPublicKey;
  X509               *psX509Cert;
  struct _DSV_CERT_NODE *psNext;
} DSV_CERT_NODE;

typedef struct _DSV_SIGNATURE
{
  char               *pcCommonName;
  EVP_MD_CTX          sMdRsaCtx;
  EVP_MD_CTX          sMdDsaCtx;
  int                 iBase64Length;
  int                 iBinaryLength;
  unsigned char      *pucBase64Signature;
  unsigned char      *pucBinarySignature;
} DSV_SIGNATURE;

/*-
 ***********************************************************************
 *
 * Function Prototypes
 *
 ***********************************************************************
 */
DSV_CERT_NODE      *DsvAddCertNode(DSV_CERT_NODE *psHead, DSV_CERT_NODE *psNode);
int                 DsvChopTrailingEquals(char *pcData, int iFlags);
int                 DsvChopTrailingSlashes(char *pcData, int iFlags);
int                 DsvChopTrailingWhitespace(char *pcData, int iFlags);
int                 DsvDecodeSignature(DSV_SIGNATURE *psSignature, char *pcError);
int                 DsvEncodeSignature(DSV_SIGNATURE *psSignature, char *pcError);
void                DsvFreeCertNode(DSV_CERT_NODE *psCertNode);
void                DsvFreeSignature(DSV_SIGNATURE *psSignature);
unsigned char      *DsvGenerateSeed(unsigned char *pucSeed, unsigned long iLength);
char               *DsvGetEnvValue(char *pcName);
EVP_PKEY           *DsvLoadPrivateKey(char *pcFile, char *pcError);
DSV_CERT_NODE      *DsvLoadPublicKey(char *pcFile, int iType, char *pcError);
DSV_CERT_NODE      *DsvLoadPublicKeys(char *pcTree, int iType, char *pcError);
DSV_SIGNATURE      *DsvLoadSignature(char *pcFile, char *pcError);
DSV_CERT_NODE      *DsvNewCertNode(char *pcFile, char *pcError);
DSV_SIGNATURE      *DsvNewSignature(char *pcError);
int                 DsvProcessPayloadFile(char *pcFile, DSV_SIGNATURE *psSignature, char *pcError);
int                 DsvProcessPayloadStream(FILE *pFile, DSV_SIGNATURE *psSignature, char *pcError);
int                 DsvSetDynamicString(char **ppcValue, char *pcNewValue, char *pcError);
int                 DsvSignPayload(char *pcFile, EVP_PKEY *psPrivateKey, DSV_SIGNATURE *psSignature, char *pcError);
int                 DsvVerifySignature(DSV_CERT_NODE *psCertList, int iVerifyMode, DSV_SIGNATURE *psSignature, char *pcError);
int                 DsvWriteSignature(char *pcFile, char *pcExtension, char *pcSignature, char *pcError);

#endif /* !_DSV_H_INCLUDED */
