/*-
 ***********************************************************************
 *
 * $Id: app-includes.h,v 1.41 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2001-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _APP_INCLUDES_H_INCLUDED
#define _APP_INCLUDES_H_INCLUDED

typedef char APP_SI8;
typedef unsigned char APP_UI8;
typedef short APP_SI16;
typedef unsigned short APP_UI16;
typedef int APP_SI32;
typedef unsigned int APP_UI32;
#if defined(UNIX)
  #if defined(APP_CPU_ALPHA) || defined(APP_CPU_IA64) || defined(APP_CPU_X86_64) || defined(APP_CPU_AMD64)
    typedef long APP_SI64;
    typedef unsigned long APP_UI64;
  #else
    typedef long long APP_SI64;
    typedef unsigned long long APP_UI64;
  #endif
#elif defined(WIN32)
    typedef __int64 APP_SI64;
    typedef unsigned __int64 APP_UI64;
#endif

#ifdef USE_SSL
#include "ssl.h"
#include "ssl-pool.h"
#endif

#ifdef USE_DSV
#include "dsv.h"
#include "dsv-pool.h"
#endif

#ifdef USE_EMBEDDED_LUA
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
#endif

#include "base64.h"
#include "socket.h"
#include "hook.h"
#include "http.h"
#include "http-pool.h"
#include "md5.h"
#include "options.h"
#include "sha1.h"
#include "sha256.h"
#include "version.h"
#include "webjob.h"

#ifdef USE_AP_SNPRINTF
#include "ap_snprintf.h"
#define snprintf ap_snprintf
#endif

#ifdef WIN32
#define chdir _chdir
#define chmod _chmod
#define getcwd _getcwd
#define fdopen _fdopen
#ifndef WEBJOB_MINGW32
#define fileno _fileno
#endif
#define fstat _fstat
#define getpid _getpid
#define mkdir _mkdir
#define open _open
#define rmdir _rmdir
#define snprintf _snprintf
#define stat _stat
#define strcasecmp _stricmp
#define strncasecmp _strnicmp
#define unlink _unlink
#endif

#endif /* !_APP_INCLUDES_H_INCLUDED */
