/*-
 ***********************************************************************
 *
 * $Id: pad-make-binary-guts.h,v 1.10 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2002-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _PAD_MAKE_BINARY_GUTS_H_INCLUDED
#define _PAD_MAKE_BINARY_GUTS_H_INCLUDED


/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define XER                 -1
#define XER_OK               0
#define XER_Usage            1
#define XER_BootStrap        2
#define XER_ProcessArguments 3
#define XER_Delimiter        4
#define XER_WorkHorse        5

#define CREATE_MODE 0x00000001
#define EXPORT_MODE 0x00000002

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _PAD_MAKE_PROPERTIES
{
  char               *pcDelimiter;
  char               *pcPayload;
  FILE               *pFilePaD;
  FILE               *pFilePayload;
  int                 iRunMode;
} PAD_MAKE_PROPERTIES;

/*-
 ***********************************************************************
 *
 * Function Prototypes
 *
 ***********************************************************************
 */
int                 main(int iArgumentCount, char *ppcArgumentVector[]);
int                 PaDBootStrap(char *pcError);
int                 PaDProcessArguments(int iArgumentCount, char *ppcArgumentVector[], PAD_MAKE_PROPERTIES *psProperties, char *pcError);
void                PaDShutdown(int iError);
void                PaDUsage(char *pcProgram);
int                 PaDWorkHorse(PAD_MAKE_PROPERTIES *psProperties, char *pcError);

#endif /* !_PAD_MAKE_BINARY_GUTS_H_INCLUDED */
