/*-
 ***********************************************************************
 *
 * $Id: pad-binary-guts.h,v 1.13 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2002-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _PAD_BINARY_GUTS_H_INCLUDED
#define _PAD_BINARY_GUTS_H_INCLUDED

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define XER                 -1
#define XER_OK               0
#define XER_BootStrap        1
#define XER_ProcessArguments 2
#define XER_Suffix           3
#define XER_Basename         4
#define XER_Delimiter        5
#define XER_Extract          6
#define XER_Deliver          7

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _PAD_GUTS_PROPERTIES
{
  char               *pcCmdLine;
  char               *pcDelimiter;
  char               *pcPayload;
  FILE               *pFilePaD;
  FILE               *pFilePayload;
  int                 iMute;
  int                 iOverwritePayload;
  int                 iUnlinkPayload;
  unsigned long       ulUmask;
} PAD_GUTS_PROPERTIES;

/*-
 ***********************************************************************
 *
 * Function Prototypes (pad-program.c)
 *
 ***********************************************************************
 */
int                 main(int iArgumentCount, char *ppcArgumentVector[]);
int                 PaDBootStrap(char *pcError);
int                 PaDBuildCmdLine(int iArgumentCount, char *ppcArgumentVector[], char *pcPayload, char *pcCmdLine);
int                 PaDCalculateCmdLineLength(int iArgumentCount, char *ppcArgumentVector[]);
int                 PaDCheckBasename(char *pcPath, char *pcError);
int                 PaDCheckSuffix(char *pcName, char *pcSuffix, char *pcError);
int                 PaDDeliverPayload(char *pcPayload, int iNeedXBit, char *pcCmdLine, char *pcError);
int                 PaDExtractPayload(PAD_GUTS_PROPERTIES *psProperties, char *pcError);
int                 PaDProcessArguments(int iArgumentCount, char *ppcArgumentVector[], PAD_GUTS_PROPERTIES *psProperties, char *pcError);
void                PaDShutdown(int iError);

#endif /* !_PAD_BINARY_GUTS_H_INCLUDED */
