#!/usr/bin/perl -w
######################################################################
#
# $Id: WebJob-ValidationRoutines.t,v 1.6 2012/01/07 07:56:13 mavrik Exp $
#
######################################################################
#
# Copyright 2007-2012 The WebJob Project, All Rights Reserved.
#
######################################################################
#
# Purpose: Tests for WebJob::ValidationRoutines.
#
######################################################################

use 5.008;
use strict;
use Test;

BEGIN
{
  my %hPlan =
  (
    'tests' => 1 + 15 + 28,
  );
  plan(%hPlan);
};

######################################################################
#
# Tests
#
######################################################################

  my (@aTuples);

  ####################################################################
  #
  # Test: The target module must load without error.
  #
  ####################################################################

  use WebJob::ValidationRoutines;
  ok(1);

  ####################################################################
  #
  # Test: Combinations of undefined arguments.
  #
  ####################################################################

  @aTuples =
  (
    ##################################################################
    #
    # Taken 1 at a time.
    #
    ##################################################################

    "undef" . ":" . "key"   . ":" . "value" . ":" . "value" . ":" . "3"     . ":" . "undef",
    "hash"  . ":" . "undef" . ":" . "value" . ":" . "value" . ":" . "3"     . ":" . "undef",
    "hash"  . ":" . "key"   . ":" . "value" . ":" . "undef" . ":" . "3"     . ":" . "undef",
    "hash"  . ":" . "key"   . ":" . "value" . ":" . "value" . ":" . "undef" . ":" . "1",
#    ^^^^^           ^^^^^           ^^^^^           ^^^^^           ^^^^^           ^^^^^
#    |               |               |               |               |               |
#    |               |               |               |               |               +--> ExpectedResult
#    |               |               |               |               +------------------> AnchorFlag
#    |               |               |               +----------------------------------> ValueRegex
#    |               |               +--------------------------------------------------> Value
#    |               +------------------------------------------------------------------> Key
#    +----------------------------------------------------------------------------------> Hash

    ##################################################################
    #
    # Taken 2 at a time.
    #
    ##################################################################

    "undef" . ":" . "undef" . ":" . "value" . ":" . "value" . ":" . "3"     . ":" . "undef",
    "undef" . ":" . "key"   . ":" . "value" . ":" . "undef" . ":" . "3"     . ":" . "undef",
    "undef" . ":" . "key"   . ":" . "value" . ":" . "value" . ":" . "undef" . ":" . "undef",
    "hash"  . ":" . "undef" . ":" . "value" . ":" . "undef" . ":" . "3"     . ":" . "undef",
    "hash"  . ":" . "undef" . ":" . "value" . ":" . "value" . ":" . "undef" . ":" . "undef",
    "hash"  . ":" . "key"   . ":" . "value" . ":" . "undef" . ":" . "undef" . ":" . "undef",

    ##################################################################
    #
    # Taken 3 at a time.
    #
    ##################################################################

    "undef" . ":" . "undef" . ":" . "value" . ":" . "undef" . ":" . "3"     . ":" . "undef",
    "undef" . ":" . "undef" . ":" . "value" . ":" . "value" . ":" . "undef" . ":" . "undef",
    "undef" . ":" . "key"   . ":" . "value" . ":" . "undef" . ":" . "undef" . ":" . "undef",
    "hash"  . ":" . "undef" . ":" . "value" . ":" . "undef" . ":" . "undef" . ":" . "undef",

    ##################################################################
    #
    # Taken 4 at a time.
    #
    ##################################################################

    "undef" . ":" . "undef" . ":" . "value" . ":" . "undef" . ":" . "undef" . ":" . "undef",
  );

  TestLoop(\@aTuples);

  ####################################################################
  #
  # Test: Simple pattern checks.
  #
  ####################################################################

  @aTuples =
  (
    ##################################################################
    #
    # Value is not defined.
    #
    ##################################################################

    "hash:key:undef:\\d{3}:undef:0",
    "hash:key:undef:\\d{3}:a:0",
    "hash:key:undef:\\d{3}:0:0",
    "hash:key:undef:\\d{3}:1:0",
    "hash:key:undef:\\d{3}:2:0",
    "hash:key:undef:\\d{3}:3:0",
    "hash:key:undef:\\d{3}:4:0",

    ##################################################################
    #
    # Partial value match (head) using different anchor flags.
    #
    ##################################################################

    "hash:key:123abc:\\d{3}:undef:0",
    "hash:key:123abc:\\d{3}:a:0",
    "hash:key:123abc:\\d{3}:0:1",
    "hash:key:123abc:\\d{3}:1:1",
    "hash:key:123abc:\\d{3}:2:0",
    "hash:key:123abc:\\d{3}:3:0",
    "hash:key:123abc:\\d{3}:4:0",

    ##################################################################
    #
    # Partial value match (tail) using different anchor flags.
    #
    ##################################################################

    "hash:key:abc123:\\d{3}:undef:0",
    "hash:key:abc123:\\d{3}:a:0",
    "hash:key:abc123:\\d{3}:0:1",
    "hash:key:abc123:\\d{3}:1:0",
    "hash:key:abc123:\\d{3}:2:1",
    "hash:key:abc123:\\d{3}:3:0",
    "hash:key:abc123:\\d{3}:4:0",

    ##################################################################
    #
    # Full value match using different anchor flags.
    #
    ##################################################################

    "hash:key:123456:\\d{6}:undef:1",
    "hash:key:123456:\\d{6}:a:1",
    "hash:key:123456:\\d{6}:0:1",
    "hash:key:123456:\\d{6}:1:1",
    "hash:key:123456:\\d{6}:2:1",
    "hash:key:123456:\\d{6}:3:1",
    "hash:key:123456:\\d{6}:4:1",
  );

  TestLoop(\@aTuples);


######################################################################
#
# TestLoop
#
######################################################################

sub TestLoop
{
  my ($paTuples) = @_;

  my %hKvps = ();

  foreach my $sTuple (@$paTuples)
  {
    my ($sHash, $sKey, $sValue, $sValueRegex, $sAnchorFlag, $sExpectedResult) = split(/:/, $sTuple);
    if ($sKey eq "undef")
    {
      %hKvps = ();
    }
    else
    {
      $hKvps{$sKey} = ($sValue eq "undef") ? undef : $sValue;
    }
    my $sResult = VerifyHashKeyValue
    (
      ($sHash eq "undef") ? undef : \%hKvps,
      ($sKey eq "undef") ? undef : $sKey,
      ($sValueRegex eq "undef") ? undef : $sValueRegex,
      ($sAnchorFlag eq "undef") ? undef : $sAnchorFlag,
    );
    ($sExpectedResult eq "undef") ? ok(!defined($sResult)) : ok((defined($sResult) && $sResult == $sExpectedResult));
  }

  1;
}
