#!/usr/bin/perl -w
######################################################################
#
# $Id: WebJob-EadRoutines.t,v 1.3 2012/01/07 07:56:13 mavrik Exp $
#
######################################################################
#
# Copyright 2010-2012 The WebJob Project, All Rights Reserved.
#
######################################################################
#
# Purpose: Tests for WebJob::EadRoutines.
#
######################################################################

use 5.008;
use strict;
use Test;
use Digest::MD5 qw(md5_hex);

BEGIN
{
  my %hPlan =
  (
    'tests' => 1 + (256 * 2) + (2 * 2),
  );
  plan(%hPlan);
};

######################################################################
#
# Tests
#
######################################################################

  ####################################################################
  #
  # Test: The target module must load without error.
  #
  ####################################################################

  use WebJob::EadRoutines;
  ok(1);

  ####################################################################
  #
  # Common variables.
  #
  ####################################################################

  my %hActualPayloads = ();

  my %hTargetPayloads =
  (
    '0x00' => chr(0x00) x 256,
    '0x01' => chr(0x01) x 256,
    '0x02' => chr(0x02) x 256,
    '0x03' => chr(0x03) x 256,
    '0x04' => chr(0x04) x 256,
    '0x05' => chr(0x05) x 256,
    '0x06' => chr(0x06) x 256,
    '0x07' => chr(0x07) x 256,
    '0x08' => chr(0x08) x 256,
    '0x09' => chr(0x09) x 256,
    '0x0a' => chr(0x0a) x 256,
    '0x0b' => chr(0x0b) x 256,
    '0x0c' => chr(0x0c) x 256,
    '0x0d' => chr(0x0d) x 256,
    '0x0e' => chr(0x0e) x 256,
    '0x0f' => chr(0x0f) x 256,
    '0x10' => chr(0x10) x 256,
    '0x11' => chr(0x11) x 256,
    '0x12' => chr(0x12) x 256,
    '0x13' => chr(0x13) x 256,
    '0x14' => chr(0x14) x 256,
    '0x15' => chr(0x15) x 256,
    '0x16' => chr(0x16) x 256,
    '0x17' => chr(0x17) x 256,
    '0x18' => chr(0x18) x 256,
    '0x19' => chr(0x19) x 256,
    '0x1a' => chr(0x1a) x 256,
    '0x1b' => chr(0x1b) x 256,
    '0x1c' => chr(0x1c) x 256,
    '0x1d' => chr(0x1d) x 256,
    '0x1e' => chr(0x1e) x 256,
    '0x1f' => chr(0x1f) x 256,
    '0x20' => chr(0x20) x 256,
    '0x21' => chr(0x21) x 256,
    '0x22' => chr(0x22) x 256,
    '0x23' => chr(0x23) x 256,
    '0x24' => chr(0x24) x 256,
    '0x25' => chr(0x25) x 256,
    '0x26' => chr(0x26) x 256,
    '0x27' => chr(0x27) x 256,
    '0x28' => chr(0x28) x 256,
    '0x29' => chr(0x29) x 256,
    '0x2a' => chr(0x2a) x 256,
    '0x2b' => chr(0x2b) x 256,
    '0x2c' => chr(0x2c) x 256,
    '0x2d' => chr(0x2d) x 256,
    '0x2e' => chr(0x2e) x 256,
    '0x2f' => chr(0x2f) x 256,
    '0x30' => chr(0x30) x 256,
    '0x31' => chr(0x31) x 256,
    '0x32' => chr(0x32) x 256,
    '0x33' => chr(0x33) x 256,
    '0x34' => chr(0x34) x 256,
    '0x35' => chr(0x35) x 256,
    '0x36' => chr(0x36) x 256,
    '0x37' => chr(0x37) x 256,
    '0x38' => chr(0x38) x 256,
    '0x39' => chr(0x39) x 256,
    '0x3a' => chr(0x3a) x 256,
    '0x3b' => chr(0x3b) x 256,
    '0x3c' => chr(0x3c) x 256,
    '0x3d' => chr(0x3d) x 256,
    '0x3e' => chr(0x3e) x 256,
    '0x3f' => chr(0x3f) x 256,
    '0x40' => chr(0x40) x 256,
    '0x41' => chr(0x41) x 256,
    '0x42' => chr(0x42) x 256,
    '0x43' => chr(0x43) x 256,
    '0x44' => chr(0x44) x 256,
    '0x45' => chr(0x45) x 256,
    '0x46' => chr(0x46) x 256,
    '0x47' => chr(0x47) x 256,
    '0x48' => chr(0x48) x 256,
    '0x49' => chr(0x49) x 256,
    '0x4a' => chr(0x4a) x 256,
    '0x4b' => chr(0x4b) x 256,
    '0x4c' => chr(0x4c) x 256,
    '0x4d' => chr(0x4d) x 256,
    '0x4e' => chr(0x4e) x 256,
    '0x4f' => chr(0x4f) x 256,
    '0x50' => chr(0x50) x 256,
    '0x51' => chr(0x51) x 256,
    '0x52' => chr(0x52) x 256,
    '0x53' => chr(0x53) x 256,
    '0x54' => chr(0x54) x 256,
    '0x55' => chr(0x55) x 256,
    '0x56' => chr(0x56) x 256,
    '0x57' => chr(0x57) x 256,
    '0x58' => chr(0x58) x 256,
    '0x59' => chr(0x59) x 256,
    '0x5a' => chr(0x5a) x 256,
    '0x5b' => chr(0x5b) x 256,
    '0x5c' => chr(0x5c) x 256,
    '0x5d' => chr(0x5d) x 256,
    '0x5e' => chr(0x5e) x 256,
    '0x5f' => chr(0x5f) x 256,
    '0x60' => chr(0x60) x 256,
    '0x61' => chr(0x61) x 256,
    '0x62' => chr(0x62) x 256,
    '0x63' => chr(0x63) x 256,
    '0x64' => chr(0x64) x 256,
    '0x65' => chr(0x65) x 256,
    '0x66' => chr(0x66) x 256,
    '0x67' => chr(0x67) x 256,
    '0x68' => chr(0x68) x 256,
    '0x69' => chr(0x69) x 256,
    '0x6a' => chr(0x6a) x 256,
    '0x6b' => chr(0x6b) x 256,
    '0x6c' => chr(0x6c) x 256,
    '0x6d' => chr(0x6d) x 256,
    '0x6e' => chr(0x6e) x 256,
    '0x6f' => chr(0x6f) x 256,
    '0x70' => chr(0x70) x 256,
    '0x71' => chr(0x71) x 256,
    '0x72' => chr(0x72) x 256,
    '0x73' => chr(0x73) x 256,
    '0x74' => chr(0x74) x 256,
    '0x75' => chr(0x75) x 256,
    '0x76' => chr(0x76) x 256,
    '0x77' => chr(0x77) x 256,
    '0x78' => chr(0x78) x 256,
    '0x79' => chr(0x79) x 256,
    '0x7a' => chr(0x7a) x 256,
    '0x7b' => chr(0x7b) x 256,
    '0x7c' => chr(0x7c) x 256,
    '0x7d' => chr(0x7d) x 256,
    '0x7e' => chr(0x7e) x 256,
    '0x7f' => chr(0x7f) x 256,
    '0x80' => chr(0x80) x 256,
    '0x81' => chr(0x81) x 256,
    '0x82' => chr(0x82) x 256,
    '0x83' => chr(0x83) x 256,
    '0x84' => chr(0x84) x 256,
    '0x85' => chr(0x85) x 256,
    '0x86' => chr(0x86) x 256,
    '0x87' => chr(0x87) x 256,
    '0x88' => chr(0x88) x 256,
    '0x89' => chr(0x89) x 256,
    '0x8a' => chr(0x8a) x 256,
    '0x8b' => chr(0x8b) x 256,
    '0x8c' => chr(0x8c) x 256,
    '0x8d' => chr(0x8d) x 256,
    '0x8e' => chr(0x8e) x 256,
    '0x8f' => chr(0x8f) x 256,
    '0x90' => chr(0x90) x 256,
    '0x91' => chr(0x91) x 256,
    '0x92' => chr(0x92) x 256,
    '0x93' => chr(0x93) x 256,
    '0x94' => chr(0x94) x 256,
    '0x95' => chr(0x95) x 256,
    '0x96' => chr(0x96) x 256,
    '0x97' => chr(0x97) x 256,
    '0x98' => chr(0x98) x 256,
    '0x99' => chr(0x99) x 256,
    '0x9a' => chr(0x9a) x 256,
    '0x9b' => chr(0x9b) x 256,
    '0x9c' => chr(0x9c) x 256,
    '0x9d' => chr(0x9d) x 256,
    '0x9e' => chr(0x9e) x 256,
    '0x9f' => chr(0x9f) x 256,
    '0xa0' => chr(0xa0) x 256,
    '0xa1' => chr(0xa1) x 256,
    '0xa2' => chr(0xa2) x 256,
    '0xa3' => chr(0xa3) x 256,
    '0xa4' => chr(0xa4) x 256,
    '0xa5' => chr(0xa5) x 256,
    '0xa6' => chr(0xa6) x 256,
    '0xa7' => chr(0xa7) x 256,
    '0xa8' => chr(0xa8) x 256,
    '0xa9' => chr(0xa9) x 256,
    '0xaa' => chr(0xaa) x 256,
    '0xab' => chr(0xab) x 256,
    '0xac' => chr(0xac) x 256,
    '0xad' => chr(0xad) x 256,
    '0xae' => chr(0xae) x 256,
    '0xaf' => chr(0xaf) x 256,
    '0xb0' => chr(0xb0) x 256,
    '0xb1' => chr(0xb1) x 256,
    '0xb2' => chr(0xb2) x 256,
    '0xb3' => chr(0xb3) x 256,
    '0xb4' => chr(0xb4) x 256,
    '0xb5' => chr(0xb5) x 256,
    '0xb6' => chr(0xb6) x 256,
    '0xb7' => chr(0xb7) x 256,
    '0xb8' => chr(0xb8) x 256,
    '0xb9' => chr(0xb9) x 256,
    '0xba' => chr(0xba) x 256,
    '0xbb' => chr(0xbb) x 256,
    '0xbc' => chr(0xbc) x 256,
    '0xbd' => chr(0xbd) x 256,
    '0xbe' => chr(0xbe) x 256,
    '0xbf' => chr(0xbf) x 256,
    '0xc0' => chr(0xc0) x 256,
    '0xc1' => chr(0xc1) x 256,
    '0xc2' => chr(0xc2) x 256,
    '0xc3' => chr(0xc3) x 256,
    '0xc4' => chr(0xc4) x 256,
    '0xc5' => chr(0xc5) x 256,
    '0xc6' => chr(0xc6) x 256,
    '0xc7' => chr(0xc7) x 256,
    '0xc8' => chr(0xc8) x 256,
    '0xc9' => chr(0xc9) x 256,
    '0xca' => chr(0xca) x 256,
    '0xcb' => chr(0xcb) x 256,
    '0xcc' => chr(0xcc) x 256,
    '0xcd' => chr(0xcd) x 256,
    '0xce' => chr(0xce) x 256,
    '0xcf' => chr(0xcf) x 256,
    '0xd0' => chr(0xd0) x 256,
    '0xd1' => chr(0xd1) x 256,
    '0xd2' => chr(0xd2) x 256,
    '0xd3' => chr(0xd3) x 256,
    '0xd4' => chr(0xd4) x 256,
    '0xd5' => chr(0xd5) x 256,
    '0xd6' => chr(0xd6) x 256,
    '0xd7' => chr(0xd7) x 256,
    '0xd8' => chr(0xd8) x 256,
    '0xd9' => chr(0xd9) x 256,
    '0xda' => chr(0xda) x 256,
    '0xdb' => chr(0xdb) x 256,
    '0xdc' => chr(0xdc) x 256,
    '0xdd' => chr(0xdd) x 256,
    '0xde' => chr(0xde) x 256,
    '0xdf' => chr(0xdf) x 256,
    '0xe0' => chr(0xe0) x 256,
    '0xe1' => chr(0xe1) x 256,
    '0xe2' => chr(0xe2) x 256,
    '0xe3' => chr(0xe3) x 256,
    '0xe4' => chr(0xe4) x 256,
    '0xe5' => chr(0xe5) x 256,
    '0xe6' => chr(0xe6) x 256,
    '0xe7' => chr(0xe7) x 256,
    '0xe8' => chr(0xe8) x 256,
    '0xe9' => chr(0xe9) x 256,
    '0xea' => chr(0xea) x 256,
    '0xeb' => chr(0xeb) x 256,
    '0xec' => chr(0xec) x 256,
    '0xed' => chr(0xed) x 256,
    '0xee' => chr(0xee) x 256,
    '0xef' => chr(0xef) x 256,
    '0xf0' => chr(0xf0) x 256,
    '0xf1' => chr(0xf1) x 256,
    '0xf2' => chr(0xf2) x 256,
    '0xf3' => chr(0xf3) x 256,
    '0xf4' => chr(0xf4) x 256,
    '0xf5' => chr(0xf5) x 256,
    '0xf6' => chr(0xf6) x 256,
    '0xf7' => chr(0xf7) x 256,
    '0xf8' => chr(0xf8) x 256,
    '0xf9' => chr(0xf9) x 256,
    '0xfa' => chr(0xfa) x 256,
    '0xfb' => chr(0xfb) x 256,
    '0xfc' => chr(0xfc) x 256,
    '0xfd' => chr(0xfd) x 256,
    '0xfe' => chr(0xfe) x 256,
    '0xff' => chr(0xff) x 256,
  );

  my %hActualHashes = # MD5 hash of 0xHH.dat.
  (
    '0x00' => "348a9791dc41b89796ec3808b5b5262f",
    '0x01' => "25e29eca666fc2836841f42fce5f3cc2",
    '0x02' => "315de78f9351a1824ce1b08f177e14d9",
    '0x03' => "6e60e91fd58300d2f3ef1cb8e662041d",
    '0x04' => "dac27d29ee9103058a4fb4ab7e93a203",
    '0x05' => "4dc2ca0ea9f82fef07b074d713086bed",
    '0x06' => "b754977ad6aefa84cbfede6d089e0e4f",
    '0x07' => "fdbcadf44ae6dfbfb3b07be5f8512652",
    '0x08' => "f765353f6482962e08e204e686546a8c",
    '0x09' => "f967663d50fa345751645a7955c5d32c",
    '0x0a' => "450caed20307eb30d5d3c954706e546f",
    '0x0b' => "8f145d672273b10874416937fdbf705a",
    '0x0c' => "bd4d1b2e828b4f22accb4777c10fbedd",
    '0x0d' => "85320be958e09258aef42954bf20e2e5",
    '0x0e' => "40c05ba3b5a63c535bae691784c2eb8a",
    '0x0f' => "52ae0d08006009057dd067982f3cbc26",
    '0x10' => "16f4a03161b4ce6fe7a896bded480693",
    '0x11' => "cf087ba96f70028bde90a07c9056091e",
    '0x12' => "b2defdf06a08fae68d72e017dbf23d56",
    '0x13' => "cd715b548607d55627e91078f0412df6",
    '0x14' => "83f72cbe3cba63fd6b2df22a15f13763",
    '0x15' => "81ea08c9de803576f7c110f6d6334820",
    '0x16' => "06bccc2a92ae1e8f95efe28945185bf0",
    '0x17' => "ded055a5c9e8a96dc7af5fafd824b638",
    '0x18' => "9b06fc869798e4c61b525493856c2e68",
    '0x19' => "fcdf777882c355ff6a569cff5c43935c",
    '0x1a' => "3209f327b2cdf2d739da748b9a61702c",
    '0x1b' => "24d405414005e55b4fcab0aaeb4911cb",
    '0x1c' => "2523d4ad19217f8ae1112111dd488467",
    '0x1d' => "1320d9cd2cd4f8d7c5495b1bd826add4",
    '0x1e' => "fe64c450bfe0af18934edee51c0cde76",
    '0x1f' => "c5237692f8d9d37963b1eb31a90ee52c",
    '0x20' => "2235af6d0b9d22368e3cd3e6664fb8ef",
    '0x21' => "e93ed30f68e32d17c483740758d1d18f",
    '0x22' => "68b48fcebfae767170329569c16b2fde",
    '0x23' => "ca2d3263229ff5962d1622c78cbb9cb7",
    '0x24' => "626b4836e22cb31b3c0b2ec7f3b4cea3",
    '0x25' => "d92ede9d94265e0618df03caf6d0cb19",
    '0x26' => "839beaaf8994f7d034d2be94614d5417",
    '0x27' => "dc27b50ad3d1c70b6760d5a1e3d19b29",
    '0x28' => "644a70318e05899683b95e38e835217d",
    '0x29' => "e1b8669bbcccdca91b08b0a9837f5a77",
    '0x2a' => "5f5fbe797c66c0d3daed5f8a3a973ee5",
    '0x2b' => "33ce5ff9c6740ec3a3213ccd161c48c5",
    '0x2c' => "6dab0dd0eccc4beb891884f22ab1165e",
    '0x2d' => "6a173e34f85340f4bd8a5ee9221b2486",
    '0x2e' => "aa7e17b38eec06c9badbc1bf5ddb7cb5",
    '0x2f' => "d095883e02bdd0b1d91fefda2476214c",
    '0x30' => "5b85554da1606b2582ebe938a45dd3bd",
    '0x31' => "cb63280c6142bddf58025800093901ca",
    '0x32' => "7490c42f7f5a2dd8e801021dadbeebe8",
    '0x33' => "6a7c28db067c700c031f3ef3503c5e1b",
    '0x34' => "5a2c4b26dc5c949fa4d961ac2d388200",
    '0x35' => "8a5f7ebb07756adda755bbe475bf23f7",
    '0x36' => "c3a92b47890964e13e3a3ea837551e8d",
    '0x37' => "d048c1001f7b0d2f302dc2b6d640c461",
    '0x38' => "5aae86eb17409e461d535b61d6045e33",
    '0x39' => "e9123414746cde5a22847bee987aa7ff",
    '0x3a' => "036a665dc05b18474c6cccecdba61c42",
    '0x3b' => "10865188328a1054e5d156a3df09b3cb",
    '0x3c' => "421c52d419ee981e9cd873dc4b29dd5d",
    '0x3d' => "d6d699ff4220b78b6b758ce73e24d7ea",
    '0x3e' => "abe5d580a5f66bbecfa02fa1baf7893e",
    '0x3f' => "9261a5c648cef3a36ecb0a589fdd4ccb",
    '0x40' => "a7acdccf6f87e631c69390024f69577b",
    '0x41' => "b3efb0eba6fbc059abb5a59e8e78e4fe",
    '0x42' => "03af7b93bc40f80dd209b53596eb1390",
    '0x43' => "180d6516ccbad363924640205c613f55",
    '0x44' => "4b048d4f8d02cf2feaed523ab483531e",
    '0x45' => "a9a6ab1a9ea54d7f0f3db3a9eadf8086",
    '0x46' => "d0bf5c8b03676fa1e6f62c9e60fa7b19",
    '0x47' => "e82f06b5f932e8f46d808b536489f0ec",
    '0x48' => "685627dd6633b77068941e4415b02f5d",
    '0x49' => "efd82db6d9fe0cdf8850469894b03518",
    '0x4a' => "36aa49ccec215aa810742904b3250b0c",
    '0x4b' => "a8e4141a7083106409ed83da78b3f338",
    '0x4c' => "a74ad66a579e6f051d411d0185431e7a",
    '0x4d' => "12c49a5c226005c3c6e9a006d82fcab6",
    '0x4e' => "a2d7e3cd29c19584673c42d367f6ef58",
    '0x4f' => "7a1535615792d42e8d8ecba851520119",
    '0x50' => "e759ca6e05135f9158356bc832a350b6",
    '0x51' => "b975df8fc4fe79e1d459b4a5af8800a8",
    '0x52' => "afa1a260947401f972567f68103aa87a",
    '0x53' => "4b8def03fab07480b357d3d2627a2626",
    '0x54' => "9baf7e5b0b1390a8086607a23041e8f6",
    '0x55' => "778c681e92110805c6f27c16ef0ec598",
    '0x56' => "3d66c52a494ce5d6df0cfc0c51e9bbf0",
    '0x57' => "33bf5b580b10e7ea8beb503413a16da3",
    '0x58' => "71325c7bcf69044f0e83de42f79b36f5",
    '0x59' => "03aebe52b7b471b9cf8a36360d7c5021",
    '0x5a' => "e9ef2bb7d2a04e528bb45ebeb9fc74f8",
    '0x5b' => "c6a8c02016c6613dbe3dc2bb50be71ac",
    '0x5c' => "95bee697056917787244ecde8786e0b3",
    '0x5d' => "54aca95dbea90e13c5de604638ffd56d",
    '0x5e' => "888583c408a144cac9f288607f1eed5e",
    '0x5f' => "a38d87cfab637b0d65ec5ba31f6f79ba",
    '0x60' => "1b271404c54135abcb694b5dc543dd32",
    '0x61' => "81109eec5aa1a284fb5327b10e9c16b9",
    '0x62' => "91bfe9a0d83cfafac19af2adcffeec7a",
    '0x63' => "08f039a4a6326f23069f3f592225f2fa",
    '0x64' => "494574e620952e1e30d0f498f2aa664d",
    '0x65' => "7a6511e21f0c4f425565fb7c6e6f97b2",
    '0x66' => "1e62a56b8f64dd1cb9129e3a30c73923",
    '0x67' => "2b6a2fed1f0d2f44add29e9651c467c9",
    '0x68' => "d44a23bde7599d5fd9e490c8274264d8",
    '0x69' => "e3662b653671f6a6b739bb05ba12d9c6",
    '0x6a' => "0f63e575e70a9963fdd8367b9930daf4",
    '0x6b' => "e2ebd1a42d61bbbc708b0c137383cfa1",
    '0x6c' => "4b0d8b191980f033c05f7d55321c181b",
    '0x6d' => "1ad9692ca2a96eb029eb5f723e011552",
    '0x6e' => "5cd8782e888893d2ca30af0370849cce",
    '0x6f' => "8ca73a598dad55dd6ea2e3e89e72c41c",
    '0x70' => "0183f44267b2f68571a7a4fb9cc80b2a",
    '0x71' => "598dceb74d43a544a01450422b18651b",
    '0x72' => "77a78da7809c6917958b5ee4a529c086",
    '0x73' => "360830813624189741168ff8c6254b9c",
    '0x74' => "0e2a4872d6fefeb09d9698638d481fd3",
    '0x75' => "1dfa0bf5d8e62172da89d544878b09e5",
    '0x76' => "a127c6f0b3b54ff9577b4343a548677c",
    '0x77' => "c31abd92e53518252cd7aa9daf556a8a",
    '0x78' => "c7a139a2b8e92164276f778917ba10b9",
    '0x79' => "7cd1ed5082489fa5e004d714d67df7a8",
    '0x7a' => "422e2b4e027b430225b3cff67247be64",
    '0x7b' => "855b3242e52dbe77c9c85f64ef4127c2",
    '0x7c' => "27653f5b820663ff6582f796680c1b31",
    '0x7d' => "dc79f32bdf19532ae5457c81e75dd946",
    '0x7e' => "7a7dcd0d36db2075bb7f4b105a0b4723",
    '0x7f' => "ec80de131f5b3e9dc3f3306856a66a4b",
    '0x80' => "b031e074f57a105f0d91cca34e902c82",
    '0x81' => "c54a2d44c8a73ab63d892b8b3d1c336f",
    '0x82' => "66a08f6932bd49de2f427eee757c7f99",
    '0x83' => "cda3c9b8e662395166b628411a176085",
    '0x84' => "37e980024a9c3f07df30d90ec6d4a7ad",
    '0x85' => "4ab09be4fe035f27875f4e60c5fcc0eb",
    '0x86' => "ebecc2a2ec0787455b07780f7b34f3e1",
    '0x87' => "5f7179fa5f34bf6d5f47f1ef1fb9ce6e",
    '0x88' => "db478e2e3bee745ca1343c12597a79de",
    '0x89' => "7ee669501e566e3fa6053285c1d36090",
    '0x8a' => "c598f9cd615f78bd0223aab43ee975b0",
    '0x8b' => "3b3af6be4f87f544f08df716495251db",
    '0x8c' => "432755ace00e00cc086f8cc1c02275cf",
    '0x8d' => "9dbbf3805d93885ddc0c0bf2275928a0",
    '0x8e' => "9f5cff74af677e9f5e6406b0e822d661",
    '0x8f' => "5abd081d55521750b5c24e5e913faed3",
    '0x90' => "3aba51886305cc0f5f98510cf381a633",
    '0x91' => "3f40d35720011a0853d6ed84d08a5ba3",
    '0x92' => "912fad794f6b116d1c7b5d912872ede7",
    '0x93' => "9a0682bf7578588303d455f7802a601b",
    '0x94' => "68f2d7bffc9c574462cf84d94ba157de",
    '0x95' => "a7c6ac6a1308b4eabb9713239064a9cf",
    '0x96' => "0851112ec06796bfee643cacdb8a1054",
    '0x97' => "d53aacb3c94e59145926f26e1284acc2",
    '0x98' => "cd2c8a4ab697ab2e8866bada755249b3",
    '0x99' => "278028e2778f54884b399491c81570ea",
    '0x9a' => "2f24386eeadb85d47a79d44e3efd6725",
    '0x9b' => "d4c1918ae950a9daeb8a3c57f1d8d467",
    '0x9c' => "ee4a897963c2f7fff953b084b93c18e0",
    '0x9d' => "bdb008e6c42738dcd69ccbefb6212240",
    '0x9e' => "dde5fb7e82c4839a070bbf456517428e",
    '0x9f' => "0ad38c9c6f38e3f1297be5b57d110f35",
    '0xa0' => "30b33e3bdbb69e1efdca4d6779624544",
    '0xa1' => "698d12d994f7a2644267cf2444a3d3fa",
    '0xa2' => "83dd08be3fd0fae1495c443d9264de31",
    '0xa3' => "735b07c073792eb6186d6756f2e7b7b8",
    '0xa4' => "68d4975fd78a833e0d860ed1993b44c7",
    '0xa5' => "5259d466b53d300cd9bb69f9a3c1af36",
    '0xa6' => "2e68b5e5178e37e43aa904848d0435ad",
    '0xa7' => "9acd3950463b839b76122b61f95476d2",
    '0xa8' => "02e2ad20475bd685d0afe943ed7f5747",
    '0xa9' => "a02509b28cf33e65ea380c62ee51d78b",
    '0xaa' => "1af3c6f5ab9068e01114c58bf6549142",
    '0xab' => "6fee337f60809cf03c1b4b7a8ad57eae",
    '0xac' => "e7397432968abd744350a2af75cc603d",
    '0xad' => "740b3d7f7e382f943308ea1e39f3fa53",
    '0xae' => "157f1929bd29ff200c315e91ebe4db46",
    '0xaf' => "26357f7ec2643c8f4c85599ce93640de",
    '0xb0' => "ae9a48dcb9400018f7f7ecf4b4109aca",
    '0xb1' => "e02045dd1d7e7b0d72f570060f3f0ce6",
    '0xb2' => "fd3640b4dfaec10c3f13e7831fbe173a",
    '0xb3' => "56d0d8645c26b38b36f1ff908be38439",
    '0xb4' => "7a0bbc282b29a9b9446ff3d290ab08ec",
    '0xb5' => "5fd8acd366e9c8beea235f3da5b98792",
    '0xb6' => "9f4ce3a6f9ae38c7e6341931a49edfca",
    '0xb7' => "4cc42ee71b3c3227f9ce6f35a0c7d595",
    '0xb8' => "ed1e4b14e40a4bf817f45cedfcb2df29",
    '0xb9' => "f4d3918d8347973438113aa3ca5fdafe",
    '0xba' => "0043a8cfe3828dd89243e6137d4c53fe",
    '0xbb' => "d9e16d1296a65b246332bef1c397f221",
    '0xbc' => "a7877c711ec1d2c73f0a6e1402dc6c73",
    '0xbd' => "3efdf88c7fc9404ed1d8bcd32278aaec",
    '0xbe' => "a5bab081dce17d971dfa7dc2ea6de8db",
    '0xbf' => "fef2e34e99d64d1f7aa8417c2a009b51",
    '0xc0' => "3aef53f852cecde2a92ace54c2ac8e13",
    '0xc1' => "a3f44c8c9e855caf329aa9a5fc51e614",
    '0xc2' => "7e54f74d96471bb65eefa7c222920ed8",
    '0xc3' => "d14d293974c0bf32df4641b84aa71321",
    '0xc4' => "a8ec2178af7f3f335287e3a9aefad54e",
    '0xc5' => "a50bba44fd2176af4f64830cf6428b18",
    '0xc6' => "6438338c202f9a5af215fdd0bb3885b8",
    '0xc7' => "195360bc07b20ca8c017f6714ba1e6a5",
    '0xc8' => "fd5d3a14052259fe4a53bd4d9221389c",
    '0xc9' => "7f07525931b70a1c39525d4e538a8693",
    '0xca' => "66ace09f7394a38d531114fd34c41cae",
    '0xcb' => "d2e2694210433dd4c2df618eb5107bd6",
    '0xcc' => "26626028e895c2b521c7d30015fa9a7a",
    '0xcd' => "92ebf92bc0bf4035f2e7b928413ed424",
    '0xce' => "e5b623a2ca403e224fdbf7191a63bedd",
    '0xcf' => "ff1d293362dc0ef3f0304d09e5b4ea48",
    '0xd0' => "7a4a166bb2e02b6679399da6316ca891",
    '0xd1' => "318f910d3dd35025bc71af1d74cd6134",
    '0xd2' => "c1b02cac99e828dc26fbda7239cde108",
    '0xd3' => "cdf39fc72f85a83b72a17e1ddd45d0aa",
    '0xd4' => "2238c354a401e8f3e4597207814ca5eb",
    '0xd5' => "b40df45aefdb14b75070ac637883d8b7",
    '0xd6' => "79cb87e00fdf3b6668b6539288344d5d",
    '0xd7' => "d0ac2c3801baaafca17c785b64f236c3",
    '0xd8' => "ffea8ff270f4bd5f9a12d94abcc75750",
    '0xd9' => "154c494cecde5e59db410b9e3d45d13c",
    '0xda' => "562a8580e6a354c823abb23790b92f08",
    '0xdb' => "32136916a0a33136afec38412f01bd5e",
    '0xdc' => "c2cffd9463d7b321c6574dabcb548a2e",
    '0xdd' => "3893f3566991c4ff6f9c6c3e9e079802",
    '0xde' => "591ae70fc722209a5815ba74575c853f",
    '0xdf' => "62278bf8daffdb4863ddc6754c3efe32",
    '0xe0' => "413763230c1197522fba3ea3ab975ccc",
    '0xe1' => "dce16c60054134c09234404d9e9bc560",
    '0xe2' => "08a6687bf69e486b5ce45bcf91591e48",
    '0xe3' => "ce14c1b19acfdf615e4b240b19bb4e44",
    '0xe4' => "37a7f3e7f8742fd5df931733946f3a1e",
    '0xe5' => "acd45c805ed59db2c7c8fb319375d10d",
    '0xe6' => "a4e4b0f9a6563583e285c5648847d4a9",
    '0xe7' => "edc9d5892796b063ce4d51f4d82ca96a",
    '0xe8' => "5b6720986554e69c083ce4a20254fb75",
    '0xe9' => "81051e4b50d1a4de23db1c05174f7634",
    '0xea' => "75deaf4a08aacf58e1ead29e0325f937",
    '0xeb' => "9fd4f705fb0bb51e0fe1019ee1b2fa8e",
    '0xec' => "878afe1590e36a9f0fd7ef206a6c1ca8",
    '0xed' => "4c54e582a0c63673bc2746f3d40c9a57",
    '0xee' => "1a0a458f87e079118e1c608a4759ea91",
    '0xef' => "419d963e5610cec7afd7d53295c09062",
    '0xf0' => "3cd3ce6011efc781dd63c363d17b8deb",
    '0xf1' => "910da59d88fd6120f14c6e4f61291555",
    '0xf2' => "f97d82ce6cb90d4ec724dcbbd463cb6b",
    '0xf3' => "a47b77d9e24d1265fd60634557dded39",
    '0xf4' => "5f353cb41d22b0724b26b2272e26bd84",
    '0xf5' => "b40acb0f2896f572ddeed9ca2fde4984",
    '0xf6' => "f52a34e44daeed9a7719a77696e3cf59",
    '0xf7' => "da8f13b140344e8c0fcff4a0b049120e",
    '0xf8' => "2b3d45e8dbd2366e517a8cae4163f557",
    '0xf9' => "78eab92b01641a357a659da50df1a2f3",
    '0xfa' => "7096e677a4b789da8fea92b4cae64f5b",
    '0xfb' => "ba9904ebeaaf46383c1174cbffcca0a0",
    '0xfc' => "a3219704dda1bd78107ce0dda9cf7103",
    '0xfd' => "b22783b153da72e782d10f1a9be0a561",
    '0xfe' => "d9fe59632b9e9267b80b620ce5b9d0e8",
    '0xff' => "827f263ef9fb63d05499d14fcef32f60",
  );

  my %hTargetHashes = # MD5 hash of 0xHH.uue.
  (
    '0x00' => "c5388c348fb1d4c6776ec07016e80fd8",
    '0x01' => "d27d879bf7f5a746422e1dad86c46d15",
    '0x02' => "5e2b1d7ff00868b64102dafff03a708c",
    '0x03' => "7d89fc0fde6a699aa9fbc590129599cb",
    '0x04' => "606a268bd7e036371918e21d3476e259",
    '0x05' => "92085c691f7d63f4d373c7e011186496",
    '0x06' => "58f1980a71dbef3cea57085886d57a35",
    '0x07' => "dae13b32db55b9d0684c170f883023e4",
    '0x08' => "f314981ca2920eb80df50b16cf2ea9c6",
    '0x09' => "c860b3fe6670365fcfe62f2db13e4124",
    '0x0a' => "6c5f0994dc242197caf4a3ab60c0c97e",
    '0x0b' => "1e8cbad784202ff43b05c67031edf79a",
    '0x0c' => "c01f33750b8b444668730bf20f70900e",
    '0x0d' => "a71176e4a4aab9cc3f7bb4f0e2d6c5bc",
    '0x0e' => "cacf8f43c578a3d4b6d70d161bab4c0d",
    '0x0f' => "b9c91409b73f71a20a7548cff142cebd",
    '0x10' => "7bcaee26c564879939e00545c094427b",
    '0x11' => "67a38e80f0573ed244d05007a7e1734f",
    '0x12' => "9dd46188bb08b8689a9ac32760885171",
    '0x13' => "59ba99efcde1ba97f826e5126be6082d",
    '0x14' => "cec1ce74dd669625817aff79054fd33f",
    '0x15' => "92f72da0fadb3c52876f1a105a1a2c46",
    '0x16' => "03119f3af70a42e7b98079b54b2ad51e",
    '0x17' => "7086a50f0b600a704dd064dc32dc35ca",
    '0x18' => "874c1e6c9f9456e9a1d5821393ae38be",
    '0x19' => "c71996412969259329b6fafafec96737",
    '0x1a' => "7e7d1754045df96a4908d781e1a42c37",
    '0x1b' => "a0966bc5db7f310c19970f24e6a3d95b",
    '0x1c' => "a5e7fbed1f7efcb3fcebe97221d1dc8c",
    '0x1d' => "d5727458616c4fe4b4517a4ec571f4e4",
    '0x1e' => "8d0d7bb2f13945e6ae60becf72be2210",
    '0x1f' => "c186c43a26491b8c374368e85f85420f",
    '0x20' => "7e31b6ab3e25ba0f2b79cb0ded0237f2",
    '0x21' => "471887f9ea73a1368ef88685f1645306",
    '0x22' => "1dadb03b4dc1ad1ca6b197a54d09a1f4",
    '0x23' => "f3e55cfc4e3b7badd31c9cb8a4cd994b",
    '0x24' => "43db5dbab6277dd68d984c06e0216acc",
    '0x25' => "43d40805291b2f8401ad0b4b57ebf89b",
    '0x26' => "bccdbb43f3e567beb1d6d5c75883a0b6",
    '0x27' => "300c8b22ac8a9f82f46a72978e5c33be",
    '0x28' => "5df8d6b7b9f2b1ae74aee02e7c32bd3e",
    '0x29' => "e4f99d9bcb1629535fb19f0e8d3c502f",
    '0x2a' => "355844559a251a797cc9e5b99d6be954",
    '0x2b' => "7c0b700df400d1834bce1a3bbeccba12",
    '0x2c' => "46f84899fa8a1f8eacb6ddca926aa907",
    '0x2d' => "e59f32bbf82f879a67114392e6e524e4",
    '0x2e' => "3edc1d36d5294ddaaa96325ee8223788",
    '0x2f' => "7bde92258e9e04b24b5075ede087c130",
    '0x30' => "d98f23289a136d2dee42863fd1dafd37",
    '0x31' => "a6a55f48837963059646e73d81e11cf8",
    '0x32' => "e7983fe8ea1d1971c5b85e3fe2a29f60",
    '0x33' => "0f93c7c1f6b5aef9b3e006cded381df5",
    '0x34' => "d3a99144af142e52ed01e7aa4cfa3934",
    '0x35' => "24d0ea1be187e5383981bd0e65359c0c",
    '0x36' => "4cae145e47c25418e7e88355e3f96f1b",
    '0x37' => "8c21f3425704dd0404dcdd2252b2def8",
    '0x38' => "9711c6e6de9fe1f196af1267a142cd89",
    '0x39' => "a38f6f800cf574f6a643335a106e428a",
    '0x3a' => "331399a72d6ed7effc7315ee2a559fa1",
    '0x3b' => "da3a376ec882b93a263a3cefaac43485",
    '0x3c' => "1e24a8193e1e96896be5ad19b5d617a3",
    '0x3d' => "3801ff59f64accdd6b95af862346fa2f",
    '0x3e' => "1ce28822a6eecd20f2b6515c07794586",
    '0x3f' => "6a878668ac97521181efaed345da857e",
    '0x40' => "8c2cd6708bd53b23bec647b66201d6c4",
    '0x41' => "3dff0e7bf23808a07e179d92a43a4e3d",
    '0x42' => "35c0911e23888502bbf2086af26d491e",
    '0x43' => "41a950498ded827b35c1ad93c2f145aa",
    '0x44' => "e7df7606c5158f00fa797004a1c6e221",
    '0x45' => "f43edced16f49f408664b26de7323d91",
    '0x46' => "c0704b2b099bd8dc9d0d4f44d4b3c20a",
    '0x47' => "7c16e69e08905ae6f961a68ed3b31626",
    '0x48' => "b5e3b5f8ac8ab7ed66425ed805000499",
    '0x49' => "e8a9aa6451e676eab9ac7866a93447eb",
    '0x4a' => "66d55888490a79df14e2d21861a0b80e",
    '0x4b' => "66e59c7e080aba085fad3099dbf184e4",
    '0x4c' => "4e57e09f59829020755bdb0d97e42a45",
    '0x4d' => "1d2efe7e336add85e0325ddcf58a5fee",
    '0x4e' => "325a01eeac36007884000bd2370d545d",
    '0x4f' => "a2d26ea3c16742b2ee1c6c0c41929660",
    '0x50' => "89f215d89dfccbe2a76190c89eba90b6",
    '0x51' => "4f5a3a5c90e281b0cae79b2a8a99487d",
    '0x52' => "0ca9c52c2158865966df53b8912fadad",
    '0x53' => "bbe28405af935e70e3fb04df855e3d0f",
    '0x54' => "33684b96997f9f4e311b4b6bbfab5a5c",
    '0x55' => "ede03aa390ff9718a5df4d66755cc28b",
    '0x56' => "ccd095c91b4407dd312fc4ba7345ee07",
    '0x57' => "90f309828a18dacea75aa34ecd85e190",
    '0x58' => "b37426ec59a8c6f54fc56d08ae5ad167",
    '0x59' => "e6fc65ee21390e7194f4da223f45b340",
    '0x5a' => "819270e6118e618ea402d777c6bd0faf",
    '0x5b' => "cd8b8677c678db3aaec51785f1de89d7",
    '0x5c' => "b76fe8a2800929bab74439c75dc97a1e",
    '0x5d' => "3470f358026e900eb44633036e6ae39a",
    '0x5e' => "dc1b474073335d5a09fce3c355dee03c",
    '0x5f' => "aebcb057758d1a58e6a51b610ee55976",
    '0x60' => "c756f76110247021242087b011eaf63a",
    '0x61' => "2c6a20899ca248eb970549881d8502c5",
    '0x62' => "d593eec07130dc7cf2b3578a641dc645",
    '0x63' => "ce07d21e81ebdcf55d7f3a523731f1f7",
    '0x64' => "d2a5f81d90ed251e0bc43553ac4e9ee4",
    '0x65' => "b187e31342e4677dbddac822d7aad31d",
    '0x66' => "9192a04ee00486bce8b568011f49f42a",
    '0x67' => "ff29d14008a9e9e03de177e4dc84d245",
    '0x68' => "e9c53e4ada00c2aaedd60aa0c49f5fbe",
    '0x69' => "1b7b266b7134a2db943d6c68eb9bbd54",
    '0x6a' => "6191d2da63b0b05d85eab88a145ef04a",
    '0x6b' => "aa4ee03c1baefefe50fd259a7c8affe3",
    '0x6c' => "bca1567532396991e20ff4811a6475b6",
    '0x6d' => "4fe2859c9914a996ac1291c4608ccfd8",
    '0x6e' => "532e4d0282685efcce95da8ee44f13a1",
    '0x6f' => "8c93bc02a5e27c1dff0e09a02f67ac8c",
    '0x70' => "d34f045b389a89b1d1bf140609d6d351",
    '0x71' => "91f018f76b0c526ddd3d1e719c9b44e8",
    '0x72' => "09af3ee71e74b49a54ed2eb9528cf85a",
    '0x73' => "6783b974a8338d0dc1d4ad3e8c278e99",
    '0x74' => "0c6d905546ccc0434a9c106549a1065d",
    '0x75' => "3fd0a834e12f4945b28236a437f3abfe",
    '0x76' => "145e479f9a3b41f0fd6388bbe12d780b",
    '0x77' => "9acf481b81d270d36f914fe3c1f00aca",
    '0x78' => "8b2f967d74c297835394c32ccddcc575",
    '0x79' => "9ae0da5b8faed00f9c6bad77aee69c94",
    '0x7a' => "2976a9a6769224024fbcef56ccd50bbd",
    '0x7b' => "e867623cc008300e4dc46e6e95111030",
    '0x7c' => "80807884e2faf18097750893b00073c7",
    '0x7d' => "a4acf0403efae97a870d755504ce60db",
    '0x7e' => "183d2fa968f38cc00f36a6f7ad4d7efd",
    '0x7f' => "b28a8509306aef3774f40976bc392147",
    '0x80' => "938225a5de662aff59b2313d555ba906",
    '0x81' => "4d565c89ff9dda7e3c4488caee9f1d05",
    '0x82' => "4e70d768b2e402b14753870d46a82cf0",
    '0x83' => "ab098305a5c5be0bda1ae53e73570536",
    '0x84' => "6a29feeadd70fbafb9156b164a902fb7",
    '0x85' => "2fd1372d92a6af04e7cf08236f32a9f5",
    '0x86' => "01726543a81b6b97662cf47b283592f1",
    '0x87' => "f2e8318364027afc4c9155263af0d9bc",
    '0x88' => "6883ed7bb0568b7a66addba0a9e0c16f",
    '0x89' => "82ef82dc89fd3a8ba6990dce3eb2f430",
    '0x8a' => "700fe2a1777ffe4482d5561394c7d215",
    '0x8b' => "5f37d26acf7499fb5e7a44a5206e74e5",
    '0x8c' => "6b03bd54249a63588d4d336f9468fe28",
    '0x8d' => "8f6bba15f73a342a8117331b92554ae0",
    '0x8e' => "b719a90ae8c1b8be52105cdc222eb91b",
    '0x8f' => "b24cedcabd4b2c99252cbee17e99642a",
    '0x90' => "37e78596c608ed5173a41f09f60efe8d",
    '0x91' => "fe55840b4d6013afa276980c58d17406",
    '0x92' => "15e979b17e577f57bc2af70eda6604a0",
    '0x93' => "bc078cb47a0c04e6bc9f8078a3ce1ca1",
    '0x94' => "eae70171cf8428c2629aef4fe1590897",
    '0x95' => "787bae5c5b1bedba11e601db2c2848c0",
    '0x96' => "bb470b41d66590b20ed399fafa2dec7f",
    '0x97' => "113556074487c9c61e2a13603c3baf1a",
    '0x98' => "2eb488f0035b722239265e5a88a5e4fe",
    '0x99' => "9be95ccf9eafea0c0625c9d7f13ea12d",
    '0x9a' => "e1f22f932b0ae359b8cc8e77308f3fb7",
    '0x9b' => "f9ed9856e7ee60c63782059d26116f80",
    '0x9c' => "9d83c8358fde55fe6d263dc1c5121492",
    '0x9d' => "f4e2e1b448d6651b132dd19e9488e587",
    '0x9e' => "6dc2c806eb7b2bdc979a04c63b95c106",
    '0x9f' => "2506a0f59e8e051b3fcc96c961f63981",
    '0xa0' => "20668d237441c3ee3365bd8989a9a5c3",
    '0xa1' => "4daf479dd53dc3bbb2e4c91c7f23e7dc",
    '0xa2' => "20a026d375e15b40783a911f35b0e244",
    '0xa3' => "6148c5604e84f31e40c329c145641c26",
    '0xa4' => "9f256ac7abd3dc0db191a82d98b63591",
    '0xa5' => "5e27d26b0d6f89a897b98732498964cd",
    '0xa6' => "5d34708998fa4e511822591f1de1b7c7",
    '0xa7' => "f47db9dfaefc24ba03a3841c8b3aa269",
    '0xa8' => "0d36df66df2c983cb9952bee10cec8f8",
    '0xa9' => "446115cff54761ee52983669a722ebde",
    '0xaa' => "de50101942d5abf4161bf8ef8c49e6fe",
    '0xab' => "f2673dada9bf369f8f09fcefa4bcbf08",
    '0xac' => "7620c173b1042dd0c5619ea5d834f07c",
    '0xad' => "9fdac19e7fbdf58dbcd337dd011b6899",
    '0xae' => "800085341b328628300560d59735d878",
    '0xaf' => "217cd3d33fa32991e9b79c00e5ddc84f",
    '0xb0' => "c1f1f95af3e399fb491292d3b40ca0e0",
    '0xb1' => "5cc87e9e38b9fbd9383af8156c7b0259",
    '0xb2' => "4fd3a529308be4650a75c6acf3ec8cba",
    '0xb3' => "44792d4a2b6183e21c0b8b0a455e819c",
    '0xb4' => "7e83f2f40c9d436a79dd0222a4a4fdb0",
    '0xb5' => "41fe6cdc1414643dd75f575492b5c928",
    '0xb6' => "40b5bd8ab7dfba4190638704f7722beb",
    '0xb7' => "17d333e4b4c7d43e0141172fcc2e63a1",
    '0xb8' => "15fce7da4edd76b6cf245ce3e66468da",
    '0xb9' => "c2b1ace9e6dd5a6cd2cf491792b3b9bc",
    '0xba' => "f4c0b163e239684099d2bbbba1124ce9",
    '0xbb' => "3d0ca11528f6f974f4e039bc1a20c963",
    '0xbc' => "66a415eb787590acbaaf3c4c837ac5a7",
    '0xbd' => "74559db6d59a8de77a0b9cc2c411f4d9",
    '0xbe' => "65ed3b39aed5b1b2ab35496e9841d18f",
    '0xbf' => "cf8f92c5e37756cadbe4d8c66c00edcd",
    '0xc0' => "20bbb09a590062c54efd9c23a1bc4e31",
    '0xc1' => "c783e0ba065454493dd5c9735973257c",
    '0xc2' => "e774e6152f36c67b1a4bf7978e730fd1",
    '0xc3' => "3aa31a7b0966c9a8d2b5f1f4376e52d0",
    '0xc4' => "eabeb48188dc6caf74ea4e0794ce0b82",
    '0xc5' => "2a2db50036ffce0ff6c376484988db90",
    '0xc6' => "e56d4f996d6230884d4d35039bb33c07",
    '0xc7' => "d3b712a19529ce45d16eef82a2feb4ce",
    '0xc8' => "5101c386fe677a953f1d930f2f31e265",
    '0xc9' => "4bc819e646387b80883cddc7c9241c68",
    '0xca' => "d83a893d48b4bdb8973816d3af6ea62a",
    '0xcb' => "42f3034b5e08399274028c3766f4e5ef",
    '0xcc' => "703c19bca1af6450fcdffe5039123b61",
    '0xcd' => "5fa590ac471976ead40cb6348e7201e1",
    '0xce' => "f71c579a8c072d7550a2a2045e5b3248",
    '0xcf' => "7d583c85bc4b3fa0b29cd6c80ad72dad",
    '0xd0' => "8f0299646449ae92b4fa21da2d4f19a6",
    '0xd1' => "a4876cf820e628258a15ebf973ca67f0",
    '0xd2' => "e3415ce32c7d3752805e2d824aea48dc",
    '0xd3' => "ae8a88171783b7be3864494ab54aa8c7",
    '0xd4' => "49ccf022915f52fc0cd00186a3426016",
    '0xd5' => "7e253f35b7da50d909fdec6723ec23b5",
    '0xd6' => "02885f6fb71b4cdbdf5fbfec2a2cdfe1",
    '0xd7' => "6f19479c9f10ffe9acd5dc3ab44a2431",
    '0xd8' => "53686f38d3d45b7e1c50aea9a89ffb30",
    '0xd9' => "e8308d5021694f992718f2d982f914fe",
    '0xda' => "4561cb943772b6584da5ebcd691653e9",
    '0xdb' => "af814ddc9ec5088010e1a6f95b9ee3ef",
    '0xdc' => "3e7cce831553bf39760b4654d7b6ed8e",
    '0xdd' => "18bd59a3b25af53902505a685b5b94e2",
    '0xde' => "3a63938fe3d92114df6c2ab8f32be5bc",
    '0xdf' => "bbe7b17051f878a110127ddf0b777fd0",
    '0xe0' => "22da965d73a9a6bb4aac152b02c17935",
    '0xe1' => "2621416a8d0b6b4db460db146d17b81b",
    '0xe2' => "6b79f240a0387c0467b9c66ec91d5641",
    '0xe3' => "9b6d7164e61c07887d4dd1771410451f",
    '0xe4' => "0f679f921fc88e186a36660497e2ed7c",
    '0xe5' => "c417be2f40be38b9752702f9a956389f",
    '0xe6' => "26d96522b8893153e01e670156442726",
    '0xe7' => "c3905157162f9918e5857fbb36957735",
    '0xe8' => "e4127bba377cbe1396d06df36fb0a326",
    '0xe9' => "1dbe092eb2c464fd7a5150655e52cbd5",
    '0xea' => "ba64e7ef616a7697f80d5c5c4f7aba3a",
    '0xeb' => "3662f8942eaf7ff86317f694cc89034f",
    '0xec' => "c62f6d944f1b4a90748b0280abcd6a94",
    '0xed' => "2e3ee21f9071824156d000abf32c3a8b",
    '0xee' => "9da1b683434fa3d2b0136b378fc94a0f",
    '0xef' => "9f1d622405ce89f591115232174980ce",
    '0xf0' => "a378544816bda75aab9792ab9bef5b7f",
    '0xf1' => "e6c8223a1d197760cc6770c99940e2ba",
    '0xf2' => "c5afb4d51e43afb96a8796a3247882e1",
    '0xf3' => "a0334bfff31b064bf915027d7476675e",
    '0xf4' => "dd2d25d7f4a58ca22e0c95ac545ef569",
    '0xf5' => "ada2492ba628e8051fee43b0cdd41e99",
    '0xf6' => "a0d4f541b1234d459bcd4f0777b8a0a1",
    '0xf7' => "ba4cf299e57d8ac9ef8a43c781edaf7f",
    '0xf8' => "34189efb35cd5cbb57becdfb92753e73",
    '0xf9' => "021cb6b63f1ab8da5af5d06730a70036",
    '0xfa' => "35c7831a8eb34470b8770a45b8eeb0c3",
    '0xfb' => "9fc9b053a437de487b1e38b2c55f052b",
    '0xfc' => "10fcb2186fa9a583dc8c68a0932d5bdf",
    '0xfd' => "44e1fc67def2c9a92a284c4ec1420257",
    '0xfe' => "4a11185bc4cc0d861100e591975f3763",
    '0xff' => "2d6ccda2892e6071f63f6ea0a856b8aa",
  );

  ####################################################################
  #
  # Test: Uuencode blocks consisting of a single byte value in the
  #       range 0x00 to 0xff.
  #
  ####################################################################

  foreach my $sNumber (0..255)
  {
    my $sHexNumber = sprintf("0x%02x", $sNumber);
    my $sDataDst;
    my $sDataSrc = $hTargetPayloads{$sHexNumber};
    my $sName = "$sHexNumber.dat";
    my %hPArgs =
    (
      'DataDst' => \$sDataDst,
      'DataSrc' => \$sDataSrc,
      'Mode'    => "644",
      'Name'    => $sName,
    );
    my $sStatus = EadUuEncode(\%hPArgs);
    my $sHashDst = md5_hex($sDataDst);
    $hActualPayloads{$sHexNumber} = $sDataDst;
    ok($sHashDst eq $hTargetHashes{$sHexNumber});
  }

  ####################################################################
  #
  # Test: Uudecode the results created by the previous test.
  #
  ####################################################################

  foreach my $sNumber (0..255)
  {
    my $sHexNumber = sprintf("0x%02x", $sNumber);
    my $sDataDst;
    my $sDataSrc = $hActualPayloads{$sHexNumber};
    my $sName = "$sHexNumber.dat";
    my %hPArgs =
    (
      'DataSrc' => \$sDataSrc,
    );
    my $sStatus = EadUuDecode(\%hPArgs);
    my $sHashDst = HashFile($sName);
    ok($sHashDst eq $hActualHashes{$sHexNumber});
    unlink($sName);
  }

  ####################################################################
  #
  # Test: Uuencode a block consisting of all byte values in the range
  #       0x00 to 0xff.
  #
  ####################################################################

  my $sTestData0x00;
  my $sTestData0x01;

  for (my $sValue = 0; $sValue < 256; $sValue++)
  {
    $sTestData0x00 .= pack("C", ($sValue % 256));
  }

  for (my $sValue = 255; $sValue >= 0; $sValue--)
  {
    $sTestData0x01 .= pack("C", ($sValue % 256));
  }

  %hActualPayloads = ();

  %hTargetPayloads =
  (
    '0x00' => $sTestData0x00,
    '0x01' => $sTestData0x01,
  );

  %hActualHashes = # MD5 hash of 0xHH.dat.
  (
    '0x00' => "e2c865db4162bed963bfaa9ef6ac18f0",
    '0x01' => "ec6df70f2569891eae50321a9179eb82",
  );

  %hTargetHashes = # MD5 hash of 0xHH.uue.
  (
    '0x00' => "14b560e983136e07568649040ad175e9",
    '0x01' => "31b9208f69c3193d6e547a030e6dc326",
  );

  foreach my $sNumber (0..1)
  {
    my $sHexNumber = sprintf("0x%02x", $sNumber);
    my $sDataDst;
    my $sDataSrc = $hTargetPayloads{$sHexNumber};
    my $sName = "$sHexNumber.dat";
    my %hPArgs =
    (
      'DataDst' => \$sDataDst,
      'DataSrc' => \$sDataSrc,
      'Mode'    => "644",
      'Name'    => $sName,
    );
    my $sStatus = EadUuEncode(\%hPArgs);
    my $sHashDst = md5_hex($sDataDst);
    $hActualPayloads{$sHexNumber} = $sDataDst;
    ok($sHashDst eq $hTargetHashes{$sHexNumber});
  }

  ####################################################################
  #
  # Test: Uudecode the results created by the previous test.
  #
  ####################################################################

  foreach my $sNumber (0..1)
  {
    my $sHexNumber = sprintf("0x%02x", $sNumber);
    my $sDataDst;
    my $sDataSrc = $hActualPayloads{$sHexNumber};
    my $sName = "$sHexNumber.dat";
    my %hPArgs =
    (
      'DataSrc' => \$sDataSrc,
    );
    my $sStatus = EadUuDecode(\%hPArgs);
    my $sHashDst = HashFile($sName);
    ok($sHashDst eq $hActualHashes{$sHexNumber});
    unlink($sName);
  }

  1;


######################################################################
#
# HashFile
#
######################################################################

sub HashFile
{
  my ($sFile) = @_;

  if (!-f $sFile)
  {
    return "";
  }
  if (!open(FH, "< $sFile"))
  {
    return "";
  }
  my @aData = <FH>;
  close(FH);

  return md5_hex(join("", @aData));
}
