########################################################################
#
# $Id: Makefile.vs,v 1.40 2012/05/01 03:31:24 mavrik Exp $
#
########################################################################
#
# Copyright 2000-2012 The WebJob Project, All Rights Reserved.
#
########################################################################
#
# Purpose: Makefile for Visual Studio.
#
########################################################################

BUILD_TYPE		= RELEASE	# [RELEASE|DEBUG]
PERL_TYPE_VERSION_BUILD	= AP_5_8_8_822	# [AP_5_8_8_822|CUSTOM]
USE_CGI			= N		# [Y|N]
USE_DSV			= Y		# [Y|N]
USE_PERL		= N		# [Y|N]
USE_PERL_XSUB		= N		# [Y|N]
USE_SSL			= Y		# [Y|N]
USE_STATIC_SSL_LIBS	= Y		# [Y|N]

INSTALL_DIR		= C:\WebJob
SOURCE_DIR		= src
OBJECT_DIR		= b

!IF "$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y"
DSV_COMPILER_FLAGS	= /D USE_DSV
!ELSE
!IF "$(USE_DSV)" == "Y" || "$(USE_DSV)" == "y"
USE_DSV			= N
!ENDIF
!ENDIF

########################################################################
#
# NOTE: The following settings are specific to ActivePerl 5.8.8 (822).
#       Be prepared to modify them to work with other versions and/or
#       builds. Use the following command to determine which settings
#       are required for your environment:
#
#         perl -MExtUtils::Embed -e ccopts -e ldopts
#
########################################################################

!IF "$(USE_PERL)" == "Y" || "$(USE_PERL)" == "y"
PERL_DIR		= C:\Perl
PERL_DLL		= $(PERL_DIR)\bin\perl58.dll
PERL5LIB_PREFIX		= C:/WebJob/lib/perl5
PERL5LIB		= $(PERL5LIB_PREFIX)/site_perl;$(PERL5LIB_PREFIX)
!IF "$(PERL_TYPE_VERSION_BUILD)" == "AP_5_8_8_822"
PERL_LIB_DIR		= $(PERL_DIR)\lib\CORE
PERL_INC_DIR		= $(PERL_DIR)\lib\CORE
PERL_COMPILER_FLAGS	= /D PERL5LIB="""$(PERL5LIB)""" /D USE_EMBEDDED_PERL /D NO_STRICT /D HAVE_DES_FCRYPT /D NO_HASH_SEED /D USE_SITECUSTOMIZE /D PRIVLIB_LAST_IN_INC /D PERL_IMPLICIT_CONTEXT /D PERL_IMPLICIT_SYS /D USE_PERLIO /D PERL_MSVCRT_READFIX /I"$(PERL_INC_DIR)"
!ELSE
PERL_LIB_DIR		= $(PERL_DIR)\lib\perl5\5.8.9\CORE
PERL_INC_DIR		= $(PERL_DIR)\lib\perl5\5.8.9\CORE
PERL_COMPILER_FLAGS	= /D PERL5LIB="""$(PERL5LIB)""" /D USE_EMBEDDED_PERL /D NO_STRICT /D HAVE_DES_FCRYPT /D _CRT_SECURE_NO_DEPRECATE /D _CRT_NONSTDC_NO_DEPRECATE /D NO_HASH_SEED /D USE_SITECUSTOMIZE /D PERL_IMPLICIT_CONTEXT /D PERL_IMPLICIT_SYS /D USE_PERLIO /I"$(PERL_INC_DIR)"
!ENDIF
!IF "$(USE_PERL_XSUB)" == "Y" || "$(USE_PERL_XSUB)" == "y"
PERL_COMPILER_FLAGS	= /D USE_EMBEDDED_PERL_XSUB $(PERL_COMPILER_FLAGS)
!ENDIF
PERL_LINKER_FLAGS	= /libpath:"$(PERL_LIB_DIR)" perl58.lib
!ENDIF

!IF "$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y"
SSL_DIR			= C:\OpenSSL
SSL_LIB_DIR		= $(SSL_DIR)\lib
SSL_INC_DIR		= $(SSL_DIR)\include
SSL_DLL1		= $(SSL_DIR)\bin\libeay32.dll
SSL_DLL2		= $(SSL_DIR)\bin\ssleay32.dll
SSL_COMPILER_FLAGS	= /D USE_SSL /I"$(SSL_INC_DIR)"
!IF "$(USE_STATIC_SSL_LIBS)" == "Y" || "$(USE_STATIC_SSL_LIBS)" == "y"
SSL_LINKER_FLAGS	= /libpath:"$(SSL_LIB_DIR)" user32.lib advapi32.lib libeay32.lib ssleay32.lib gdi32.lib
!ELSE
SSL_LINKER_FLAGS	= /libpath:"$(SSL_LIB_DIR)" user32.lib advapi32.lib libeay32.lib ssleay32.lib
!ENDIF
!ENDIF

COMPILER		= cl.exe

COMPILER_FLAGS		=\
			/nologo\
			/D _MBCS\
			/D _CONSOLE\
			/D _CRT_SECURE_NO_DEPRECATE\
			/D WIN32\
			$(DSV_COMPILER_FLAGS)\
			$(PERL_COMPILER_FLAGS)\
			$(SSL_COMPILER_FLAGS)\
			/Fo"$(OBJECT_DIR)\\"\
			/Fd"$(OBJECT_DIR)\\"\
			/Fp"$(OBJECT_DIR)\webjob.pch"\
			/c /W3 /EHsc /FD\
!IF "$(BUILD_TYPE)" == "DEBUG" || "$(BUILD_TYPE)" == "debug"
			/D _DEBUG\
			/MTd /Od /Zi /Gm
!ELSE
			/D NDEBUG\
			/MT /O2
!ENDIF

INCLUDES		=\
			src\all-includes.h\
			src\app-includes.h\
			src\base64.h\
			src\dsv.h\
			src\dsv-pool.h\
			src\hook.h\
			src\http.h\
			src\http-pool.h\
			src\md5.h\
			src\options.h\
			src\sha1.h\
			src\sha256.h\
			src\socket.h\
			src\ssl.h\
			src\ssl-pool.h\
			src\sys-includes.h\
			src\version.h\
			src\webjob.h

OBJECTS			=\
			"$(OBJECT_DIR)\base64.obj"\
!IF "$(USE_DSV)" == "Y" || "$(USE_DSV)" == "y"
			"$(OBJECT_DIR)\dsv.obj"\
!ENDIF
			"$(OBJECT_DIR)\hook.obj"\
			"$(OBJECT_DIR)\http.obj"\
			"$(OBJECT_DIR)\properties.obj"\
			"$(OBJECT_DIR)\md5.obj"\
			"$(OBJECT_DIR)\options.obj"\
			"$(OBJECT_DIR)\sha1.obj"\
			"$(OBJECT_DIR)\sha256.obj"\
			"$(OBJECT_DIR)\socket.obj"\
!IF "$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y"
			"$(OBJECT_DIR)\ssl.obj"\
!ENDIF
			"$(OBJECT_DIR)\version.obj"\
			"$(OBJECT_DIR)\webjob.obj"

EXECUTEABLE		= $(OBJECT_DIR)\webjob.exe

LINKER			= link.exe

LINKER_FLAGS		=\
			/nologo\
			/subsystem:console\
			/machine:x86\
			$(SSL_LINKER_FLAGS)\
			$(PERL_LINKER_FLAGS)\
			wsock32.lib\
			/out:"$(EXECUTEABLE)"\
			/pdb:"$(OBJECT_DIR)\webjob.pdb"\
!IF "$(BUILD_TYPE)" == "DEBUG" || "$(BUILD_TYPE)" == "debug"
			/incremental:yes\
			/debug\
			/pdbtype:sept
!ELSE
			/incremental:no
!ENDIF

all: "$(EXECUTEABLE)"

test: "$(EXECUTEABLE)"
	utils\test_windows.bat

install: "$(EXECUTEABLE)"
	if not exist "$(INSTALL_DIR)" mkdir "$(INSTALL_DIR)"
	if not exist "$(INSTALL_DIR)\bin" mkdir "$(INSTALL_DIR)\bin"
!IF "$(USE_CGI)" == "Y" || "$(USE_CGI)" == "y"
	if not exist "$(INSTALL_DIR)\cgi" mkdir "$(INSTALL_DIR)\cgi"
	if not exist "$(INSTALL_DIR)\cgi\cgi-client" mkdir "$(INSTALL_DIR)\cgi\cgi-client"
!ENDIF
	if not exist "$(INSTALL_DIR)\doc" mkdir "$(INSTALL_DIR)\doc"
	if not exist "$(INSTALL_DIR)\etc" mkdir "$(INSTALL_DIR)\etc"
	if not exist "$(INSTALL_DIR)\log" mkdir "$(INSTALL_DIR)\log"
	if not exist "$(INSTALL_DIR)\run" mkdir "$(INSTALL_DIR)\run"
	copy "$(EXECUTEABLE)" "$(INSTALL_DIR)\bin"
!IF "$(USE_CGI)" == "Y" || "$(USE_CGI)" == "y"
	copy cgi\nph-webjob.cgi "$(INSTALL_DIR)\cgi\cgi-client"
!ENDIF
	if exist doc\webjob.html copy doc\webjob.html "$(INSTALL_DIR)\doc"
	if exist etc\webjob-execute.cfg\webjob-execute.cfg.sample copy etc\webjob-execute.cfg\webjob-execute.cfg.sample "$(INSTALL_DIR)\etc"
!IF ("$(USE_PERL)" == "Y" || "$(USE_PERL)" == "y") && ("$(PERL_TYPE_VERSION_BUILD)" == "CUSTOM" || "$(PERL_TYPE_VERSION_BUILD)" == "custom")
        copy "$(PERL_DLL)" "$(INSTALL_DIR)\bin"
!ENDIF
!IF ("$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y") && ("$(USE_STATIC_SSL_LIBS)" == "N" || "$(USE_STATIC_SSL_LIBS)" == "n")
	copy "$(SSL_DLL1)" "$(INSTALL_DIR)\bin"
	copy "$(SSL_DLL2)" "$(INSTALL_DIR)\bin"
!ENDIF

clean:
	if exist "$(OBJECT_DIR)" rd /Q /S "$(OBJECT_DIR)"

clean-all: clean

"$(EXECUTEABLE)": "$(OBJECT_DIR)" $(OBJECTS)
	$(LINKER) $(LINKER_FLAGS) $(OBJECTS)
!IF ("$(USE_PERL)" == "Y" || "$(USE_PERL)" == "y") && ("$(PERL_TYPE_VERSION_BUILD)" == "CUSTOM" || "$(PERL_TYPE_VERSION_BUILD)" == "custom")
        copy "$(PERL_DLL)" "$(OBJECT_DIR)"
!ENDIF
!IF ("$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y") && ("$(USE_STATIC_SSL_LIBS)" == "N" || "$(USE_STATIC_SSL_LIBS)" == "n")
	copy "$(SSL_DLL1)" "$(OBJECT_DIR)"
	copy "$(SSL_DLL2)" "$(OBJECT_DIR)"
!ENDIF

{$(SOURCE_DIR)}.c{$(OBJECT_DIR)}.obj::
	$(COMPILER) $(COMPILER_FLAGS) $<

"$(OBJECT_DIR)":
	if not exist "$(OBJECT_DIR)" mkdir "$(OBJECT_DIR)"

"$(OBJECT_DIR)\base64.obj": src\base64.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\dsv.obj": src\dsv.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\hook.obj": src\hook.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\http.obj": src\http.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\properties.obj": src\properties.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\md5.obj": src\md5.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\options.obj": src\options.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\sha1.obj": src\sha1.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\sha256.obj": src\sha256.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\socket.obj": src\socket.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\ssl.obj": src\ssl.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\version.obj": src\version.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\webjob.obj": src\webjob.c $(INCLUDES) "$(OBJECT_DIR)"

