/*-
 ***********************************************************************
 *
 * $Id: hook.h,v 1.5 2004/04/09 17:06:51 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2003-2004 Klayton Monroe, All Rights Reserved.
 *
 ***********************************************************************
 */

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#ifndef MESSAGE_SIZE
#define MESSAGE_SIZE 1024
#endif

#define HOOK_DEFAULT_STATUS -1

#define HOOK_PID_SIZE 16

#define HOOK_TOKEN_PREFIX_C '%'
#define HOOK_TOKEN_PREFIX_S "%"

#define HOOK_MODIFIED_FILENAME_TOKEN "%vp"
#define HOOK_ORIGINAL_FILENAME_TOKEN "%tp"
#define HOOK_PID_TOKEN "%pid"
#define HOOK_SUFFIX_TOKEN "%s"
#define HOOK_MAX_TOKEN_COUNT 4

#define HOOK_VALUE_EXPANDED_COMMAND_LINE 0
#define HOOK_VALUE_ORIGINAL_COMMAND_LINE 1
#define HOOK_VALUE_MODIFIED_FILENAME 2
#define HOOK_VALUE_MODIFIED_FILENAME_TOKEN 3
#define HOOK_VALUE_ORIGINAL_FILENAME 4
#define HOOK_VALUE_ORIGINAL_FILENAME_TOKEN 5
#define HOOK_VALUE_PID 6
#define HOOK_VALUE_PID_TOKEN 7
#define HOOK_VALUE_SUFFIX 8
#define HOOK_VALUE_SUFFIX_TOKEN 9

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _HOOK
{
  char               *pcExpandedCommandLine;
  char               *pcOriginalCommandLine;
  char               *pcModifiedFilename;
  char               *pcModifiedFilenameToken;
  char               *pcOriginalFilename;
  char               *pcOriginalFilenameToken;
  char               *pcPid;
  char               *pcPidToken;
  char               *pcSuffix;
  char               *pcSuffixToken;
  int                 iActive;
  int                 iActualStatus;
  int                 iTargetStatus;
} HOOK;

/*-
 ***********************************************************************
 *
 * Function Prototypes
 *
 ***********************************************************************
 */
int                   HookCalculateCommandLineLength(HOOK *psHook);
char                 *HookExpandCommandLine(HOOK *psHook, char *pcError);
void                  HookFreeHook(HOOK *psHook);
HOOK                 *HookNewHook(char *pcError);
int                   HookRunSystemCommand(HOOK *psHook, char *pcError);
int                   HookSetDynamicString(char **ppcValue, char *pcNewValue, char *pcError);
int                   HookSetToken(HOOK *psHook, int iTokenType, char *pcNewValue, char *pcError);
int                   HookSetValue(HOOK *psHook, int iValueType, char *pcNewValue, char *pcError);
