# -*- coding: iso-8859-1 -*-
# Copyright (C) 2005  Bastian Kleineidam
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""
Test Host: HTTP header.
"""

from wc.proxy.ftests import ProxyTest, make_suite

class NoHostTest (ProxyTest):

    def get_request_uri (self):
        port = self.server.socket.getsockname()[1]
        return "http://localhost:%d/" % port

    def check_request_uri (self, request):
        self.assertEquals(request.uri, "/")

    def get_request_headers (self, content):
        return [
           "Proxy-Connection: close",
        ]


class test_nohost_1_0 (NoHostTest):

    def test_nohost_1_0 (self):
        self.start_test()

    def get_request_version (self):
        return (1, 0)

    def check_request_headers (self, request):
        self.assert_(request.has_header("Host"))

    def check_request_version (self, request):
        self.assertEquals(request.version, (1, 1))


class test_nohost_1_1 (NoHostTest):

    def test_nohost_1_1 (self):
        self.start_test()

    def check_response_status (self, response):
        self.assertEqual(response.status, 400)

    def check_response_message (self, response):
        self.assertEquals(response.msg, "Bad Request")


def test_suite ():
    """
    Build and return a TestSuite.
    """
    prefix = __name__.split(".")[-1]
    return make_suite(prefix, globals())

