//
// The original WDSP comes with a file named "calculus" that contains
// data for the noise reduction filters and is read in file emnr.c.
//
// Here we just provide the data contained in this file in the double
// arrays GG and GGS, each with size 241 * 241 (about 1 mega-byte of
// static data).
//
// The numbers are all non-negative, and the smallest non-zero value is larger
// than 0.001. So printing with 25 digits is more than enough, since the
// 64-bit "double" data type has about 15 significant digits.
//
// To this end the contents of the file "calculus" have just been read
// and printed.
//
// What follows can be generated from the file "calculus" using the program
// coded in "make_calculus.c".
//
double GG[241*241]={
0.7256541811540769826294195
,0.7050388220982234388500842
,0.6850082175848438703624765
,0.6655457759273262219323897
,0.6466353762941576821532408
,0.6282613553716653864711361
,0.6104084944078433938585704
,0.5930620066264107315134879
,0.5762075250003897419759369
,0.5598310903744644351220927
,0.5439191399252407688180710
,0.5284584959481926080826497
,0.5134363549594921360963440
,0.4988402771000392532663170
,0.4846889699676750762336042
,0.4709098145348102892882025
,0.4575214719128880003218285
,0.4445128527199000978420429
,0.4318731821990897667973286
,0.4195919912955285990818766
,0.4076591079864002598043271
,0.3960646488578815072045813
,0.3847990109217075960224008
,0.3738528636647284186800277
,0.3632171413249647984322621
,0.3528830353878621428620477
,0.3428419872966379511325385
,0.3330856813707896990628399
,0.3236060379270034870202721
,0.3143952065968492748382346
,0.3054455598357783685514732
,0.2967496866180328596307447
,0.2872066315928171187366047
,0.2789918433671152442343555
,0.2721137183555480953955907
,0.2643629487133419275757262
,0.2568319369277951569330298
,0.2495144484101166348910539
,0.2424044256997908708406442
,0.2354959834413068719971562
,0.2287834034884938805287646
,0.2222611301256196825182343
,0.2159237653923777311426591
,0.2097660644974280730323812
,0.2037829313021974619868359
,0.1979694138532188119050659
,0.1923206999374238723721220
,0.1868321126306278223694335
,0.1814991058051312056154103
,0.1763172595582217228038502
,0.1712822755198083191086056
,0.1663899719949990252398919
,0.1616362788968601360561905
,0.1570172324266815022664190
,0.1525289694647518068393310
,0.1481677216448997191911019
,0.1439298091018162972787309
,0.1398116339022521525947695
,0.1358096732000991235800313
,0.1319204721912489719493067
,0.1281406369865059347024072
,0.1244668275685883312986491
,0.1208957510504445331811496
,0.1174241555039736012444607
,0.1140488246772264763206906
,0.1107665739600434545719665
,0.1075742479881888757908825
,0.1044687202895418637327296
,0.1014468953682164248375486
,0.0951186212967445876564909
,0.0956421591691190564610281
,0.0928532714754088522868258
,0.0901361597437876777005883
,0.0874880211456109946333015
,0.0849061619963948077671745
,0.0823880217018374549908799
,0.0799311988534044115528587
,0.0775334787006532744069176
,0.0751928610576248629415730
,0.0729075875565869252481477
,0.0706761670550925535927433
,0.0684973979415715722440794
,0.0663703860786682975358985
,0.0642945571780669106187744
,0.0622696625185238661348563
,0.0602957770998253303473824
,0.0583732895653654923484588
,0.0565028835172362089989129
,0.0546855101787379963007574
,0.0529223527154283404638768
,0.0512147828898997861668541
,0.0495643110783498264115821
,0.0479725309988991502341271
,0.0464410607733943547881239
,0.0449714821489518301600441
,0.0435652798289859199964980
,0.0422237828967113384970311
,0.0409481102533988117198049
,0.0397391218412614308230779
,0.0385973771850154148688183
,0.0375231024806065363574881
,0.0365161671024850087441393
,0.0355760700133092577779337
,0.0347019361645666338245242
,0.0338925225953651404475764
,0.0331462335895455414980226
,0.0324611439547574237574068
,0.0318350292532526904509815
,0.0312654016498969886117543
,0.0307495499503015051745436
,0.0302845823784297155101264
,0.0298674706820743346424862
,0.0294950942468653991290761
,0.0291642830337802486107002
,0.0288718583195180442113603
,0.0286146704017819532295253
,0.0283896326215964632522226
,0.0281937512428477657366876
,0.0280241509076147483903174
,0.0278780955487864384734209
,0.0277530047850123827435365
,0.0222011636050665657482472
,0.0216568236582778718413156
,0.0210424040404148492144909
,0.0204454772046426189180401
,0.0198655490310913826479400
,0.0193021395045929779199501
,0.0187547823163010038416409
,0.0182230244751804756897506
,0.0177064259283936133171355
,0.0172045591894200225469014
,0.0167170089725209407294226
,0.0162433718318902332866660
,0.0157832558035301724619348
,0.0153362800475583468950980
,0.0149020744883063827046499
,0.0144802794492372433055039
,0.0140705452794190281201603
,0.0136725319680972758756843
,0.0132859087438623440363683
,0.0129103536550862624254776
,0.0125455531287825255287727
,0.0121912015059080208051467
,0.0118470005524591286832914
,0.0115126589475811683116468
,0.0111878917523542398271275
,0.0108724198659416373263786
,0.0105659694793394584588775
,0.0102682715409324627070520
,0.0099790612522539894058138
,0.0096980776165022913176683
,0.0094250630661477895200218
,0.0091597631989844430916436
,0.0089019266538097573115973
,0.0086513051571372734382948
,0.0084076537705659194071872
,0.0081707313643466783492642
,0.0079403013361153389898517
,0.0077161325846781311094125
,0.0074980007373104552020893
,0.0072856896156271687414741
,0.0070789929102783380465702
,0.0068777160192734975927009
,0.0066816779895462015056995
,0.0064907134874434670515631
,0.0063046747122006054769860
,0.0061234331581452748280436
,0.0059468811272580853616310
,0.0057749328945116895281386
,0.0056075254345768236682868
,0.0054446186301816265271092
,0.0052861948994531744033809
,0.0051322582014192742738690
,0.0049828324046023893256763
,0.0048379590320705365136256
,0.0046976944259407788298533
,0.0045621064034768732398106
,0.0044312705038380695299338
,0.0043052659475190805174472
,0.0041841714480576157331182
,0.0040680610261951194103758
,0.0039569999803424488193926
,0.0038510411622258372901784
,0.0037502216946617254744734
,0.0036545602492337081641793
,0.0035640549768777450220791
,0.0034786821555634860059225
,0.0033983955882060591820182
,0.0033231267526192998125467
,0.0032527856756282089861765
,0.0031872624800262342077695
,0.0031264295241854546045235
,0.0030701440455511625794716
,0.0030182512107222235313297
,0.0029705874624380156252823
,0.0029269840694809466999371
,0.0028872707883105743105479
,0.0028512795621146295489690
,0.0028188482035048406833255
,0.0027898240314292487365688
,0.0027640674609303284535444
,0.0027414555759957687230965
,0.0027218857510291219817256
,0.0027052794259093963964713
,0.0026915861841510743159012
,0.0026807883346605569999110
,0.0026729062565907383067221
,0.0026680049288798956055868
,0.0026662020600963357887248
,0.0026676783094935021568850
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0516227766016837952278706
,0.1032455532033675904557413
,0.1548683298050513856836119
,0.2064911064067351809114825
,0.2581138830084189761393532
,0.3097366596101027713672238
,0.3613594362117865665950944
,0.4129822128134703618229651
,0.4646049894151541570508357
,0.7467934311179947881598196
,0.7255784623181625869747791
,0.7049652615701440527828936
,0.6849367543907647348788714
,0.6654763508307593999901997
,0.6465679317468669973223427
,0.6281958354659874510517170
,0.6103448448303665507808091
,0.5930001746129949236063794
,0.5761474592924881177324892
,0.5597727411767264849018488
,0.5438624588643753421379756
,0.5284034360330753798962178
,0.5133828705425100835668673
,0.4987883238396766949485084
,0.4846385069947559132153003
,0.4708607978864576271149645
,0.4574738609483769979924261
,0.4444666079629137622752921
,0.4318282653050061759003597
,0.4195483650196445979396742
,0.4076167361530681487735706
,0.3960234963305282462897594
,0.3847590435737133218729866
,0.3738140483511430134377918
,0.3631794458550328119628148
,0.3528464284983410803597792
,0.3428064386258808382557106
,0.3330511614335752712534600
,0.3235725180900934083716436
,0.3143626590552507371612023
,0.3054139575896968050727764
,0.2967190034504984530450145
,0.2871768924595258787313412
,0.2789629739693006427181388
,0.2720856426282112217052145
,0.2643356946002361484993060
,0.2568054818131281225035423
,0.2494887703401688361370958
,0.2423795033650036345740375
,0.2354717961590133690208404
,0.2287599311863219853080409
,0.2222383533255862519961710
,0.2159016651957111065929240
,0.2097446225701584399114807
,0.2037621298615593934400181
,0.1979492356549129583598301
,0.1923011282637832608521933
,0.1868131312797255971780430
,0.1814806990808468523113106
,0.1762994122612597802657319
,0.1712649729396168440942461
,0.1663731999024800345399200
,0.1616200235376903382444880
,0.1570014805149679004703245
,0.1525137081766436697449763
,0.1481529386116581525900671
,0.1439154924017240766431769
,0.1397977720506324850191504
,0.1357962551366212466952277
,0.1319074872636401274395013
,0.1281280749297921961460389
,0.1244546784790572374612694
,0.1208840053536845565718139
,0.1174128039166053016906233
,0.1140378581623068404704568
,0.1107559836765905358912931
,0.1075640252358242149322010
,0.1044588564498588612039498
,0.1014373818451107106541897
,0.0951082430089951191831688
,0.0956333202958859623921128
,0.0928447567151174241173450
,0.0901279600813469361497710
,0.0874801273885592312051784
,0.0848985647808008780934586
,0.0823807115212903812162537
,0.0799241661130388747480424
,0.0775267137969553737919526
,0.0751863544833372005049554
,0.0729013300284580417764957
,0.0706701496605806889217405
,0.0684916122990228415368108
,0.0663648245040507761549620
,0.0642892128501672266427391
,0.0622645296337021869614858
,0.0602908510070627595700543
,0.0583685668724883005564763
,0.0564983621598938792751632
,0.0546811894449499916182056
,0.0529182332202539490451088
,0.0512108664969578644687864
,0.0495606007674080709102249
,0.0479690306814321426598369
,0.0464377750607175635022550
,0.0449684160801118865125048
,0.0435624385678590117509934
,0.0422211714095867760021541
,0.0409457329795805957672883
,0.0397369823698259308497605
,0.0385954779507749617950552
,0.0375214444915609526831624
,0.0365147497096448420128567
,0.0355748907318486906614652
,0.0347009905529332488005601
,0.0338918041963933297511247
,0.0331457339349444518594723
,0.0324608526317281056994268
,0.0318349340295685442892015
,0.0312654886516706143062549
,0.0307498038849397629934668
,0.0302849867939986201748059
,0.0298680082534729628152004
,0.0294957470788331406474914
,0.0291650329708021786856431
,0.0288726872530978354025599
,0.0286155605662629826391186
,0.0283905668706635749831690
,0.0281947132999730495916957
,0.0280251255849599846536879
,0.0278790689303905700469066
,0.0228550522524377276722962
,0.0222039063841009583211150
,0.0216597867056030277121970
,0.0210455850202142386029536
,0.0204488788785967962047252
,0.0198691743560254763245609
,0.0193059916360252166456224
,0.0187588646122191227139098
,0.0182273405000373256434898
,0.0177109794573058615396732
,0.0172093542125444365353815
,0.0167220496995709247411988
,0.0162486626967405373145326
,0.0157888014688407490870858
,0.0153420854093287949149182
,0.0149081446802526319111992
,0.0144866198468624040457398
,0.0140771615036354123817741
,0.0136794298882491806995665
,0.0132930944800061633798149
,0.0129178335794123376467635
,0.0125533338661209525888296
,0.0121992899333581098636481
,0.0118554037983285669166644
,0.0115213843900259828301191
,0.0111969470183808806479364
,0.0108818128317697895846017
,0.0105757082735256080496811
,0.0102783645521072018735875
,0.0099895171438086575316229
,0.0097089053510394495577485
,0.0094362719429403468796025
,0.0091713629080152729577957
,0.0089139273501239631170012
,0.0086637175591665841617450
,0.0084204892857145247075934
,0.0081840022444043189486784
,0.0079540208639477683744134
,0.0077303152921219704662992
,0.0075126626522847355857393
,0.0073008485342202621842800
,0.0070946686870668558208552
,0.0068939308665100290304806
,0.0066984567732802915637769
,0.0065080840063086713848106
,0.0063226679427203563363391
,0.0061420834491955891495940
,0.0059662263259767219988894
,0.0057950143866321805058428
,0.0056283880840148460891759
,0.0054663106057650946018045
,0.0053087673809517985784590
,0.0051557649623851699999255
,0.0050073292757759893176206
,0.0048635032559661587822641
,0.0047243439203337352083611
,0.0045899189584655301563099
,0.0044603029435227098051242
,0.0043355732927299909726382
,0.0042158061202073179515870
,0.0041010721350615356173286
,0.0039914327383822507944178
,0.0038869364666928160265136
,0.0037876159152160845944302
,0.0036934852535983127459762
,0.0036045384207593609594833
,0.0035207480559535124162163
,0.0034420651918802922658580
,0.0033684197047681137607289
,0.0032997214917145759917327
,0.0032358623109475749199393
,0.0031767182109443000380400
,0.0031221524627023052901598
,0.0030720188896570491295102
,0.0030261655071642462946913
,0.0029844383814338782540121
,0.0029466856341563087313962
,0.0029127615399868467260802
,0.0028825306900893831081600
,0.0028558722263297897300816
,0.0028326841875600788228651
,0.0028128880521422904188722
,0.0027964336103217797384335
,0.0027833043577574988723666
,0.0027735236695212587068604
,0.0027671620946951441810668
,0.0027643463184066621382562
,0.0027652703555529020186532
,0.0027702096570822467257178
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0490068119869315477199478
,0.0980136239738630954398957
,0.1470204359607946431598435
,0.1960272479477261908797914
,0.2450340599346577385997392
,0.2940408719215892863196871
,0.3430476839085208062840593
,0.3920544958954523817595827
,0.4410613078823839572351062
,0.4900681198693155327106297
,0.7685428160242724349160426
,0.7467109261159338151614406
,0.7254983090222592023721404
,0.7048873935430509662936061
,0.6848611070881804874233012
,0.6654028615479349317851643
,0.6464965395666452119272094
,0.6281264812083260373754001
,0.6102774710033103122697185
,0.5929347253650609772535063
,0.5760838803664318774622188
,0.5597109798646645595354698
,0.5438024639642425883678811
,0.5283451578063966813658681
,0.5133262606734901867255871
,0.4987333353955912818022966
,0.4845850967197726233415267
,0.4708089192490055863160592
,0.4574234709347614336039101
,0.4444176647925500156510736
,0.4317807283957957320552623
,0.4195021949543483175126823
,0.4075718946466382885951418
,0.3959799461983813939625065
,0.3847167487009126030095274
,0.3737729736624633147812347
,0.3631395572858894804646468
,0.3528076929665513450373737
,0.3427688240042402467722127
,0.3330146365232241612019948
,0.3235370525946518749371705
,0.3143282235557033343908984
,0.3053805235200072187851106
,0.2966865430739379361213537
,0.2871454321651939478599047
,0.2789324351652073818996769
,0.2720559448632063892503652
,0.2643068674252221916809447
,0.2567775013068380185465855
,0.2494616132829044485852421
,0.2423531472196859271051039
,0.2354462190529222898049966
,0.2287351118935408433863188
,0.2222142712501820049908474
,0.2158783003556849211523883
,0.2097219555822083525420396
,0.2037401419267023949810635
,0.1979279085450173225613213
,0.1922804443090567472207653
,0.1867930733571977752749405
,0.1814612506038663086727070
,0.1762805571699953277597928
,0.1712466956925076666529151
,0.1663554854685214967613405
,0.1616028573893582842568861
,0.1569848486214933946936156
,0.1524975969972329759016816
,0.1481373350881315387184145
,0.1439003839499203574181507
,0.1397831465498056979779307
,0.1357821009159605463167964
,0.1318937930849875816985417
,0.1281148299656344746733083
,0.1244418722849473524227903
,0.1208716278344217354145940
,0.1174008452857838169514082
,0.1140263088952311321122579
,0.1107448344570535897490871
,0.1075532668978295136597012
,0.1044484799160114441018976
,0.1014273780640713301659517
,0.0950973338423312941625198
,0.0956240346740309943296410
,0.0928358162760495458920573
,0.0901193553499316235555483
,0.0874718487102698616375562
,0.0848906023296437939329451
,0.0823730553322330055765477
,0.0799168061409210317425078
,0.0775196400025673221234612
,0.0751795569458233170490047
,0.0728947990815216606552696
,0.0706638760482287964226344
,0.0684855873449023710985983
,0.0663590402869126821938650
,0.0642836623767674142371220
,0.0622592069996144026333695
,0.0602857515355320616734502
,0.0583636872216563365456388
,0.0564937003895124370544956
,0.0546767450350655118129772
,0.0529140070362464215447673
,0.0512068606976749732262455
,0.0495568186558271658870289
,0.0479654765001637922727795
,0.0464344537375655230793114
,0.0449653329316440850127456
,0.0435595989713531486775544
,0.0422185804556280755428510
,0.0409433951188862832459847
,0.0397349010684588110908777
,0.0385936553677533183970283
,0.0375198811919808319914615
,0.0365134444248717063286058
,0.0355738401762100003855593
,0.0347001893037972714006756
,0.0338912446417122120712051
,0.0331454062894435130814941
,0.0324607450201025368730079
,0.0318350326324509727560219
,0.0312657779078769904046453
,0.0307502667416742099526505
,0.0302856049953511598238354
,0.0298687626566938001226870
,0.0294966179875027108281405
,0.0291660004740962354452538
,0.0288737315608217533224877
,0.0286166623301290050374046
,0.0283917074833434888991857
,0.0281958751647060426592795
,0.0280262923498680593947796
,0.0236152862098516803934789
,0.0228580409420892534388958
,0.0222071291520541148900580
,0.0216632527882249723005792
,0.0210492916748507667701329
,0.0204528293386494718075763
,0.0198733720725713866595008
,0.0193104402820809678553715
,0.0187635680872754416481651
,0.0182323029348558096618405
,0.0177162052189616843478337
,0.0172148479096881773520167
,0.0167278161878697886888467
,0.0162547070844428036273666
,0.0157951291223885660619519
,0.0153487019589231710875454
,0.0149150560252523378679257
,0.0144938321608777901522425
,0.0140846812391617962068047
,0.0136872637806776005497955
,0.0133012495508587087061914
,0.0129263171386823604025462
,0.0125621535136655731318411
,0.0122084535594018574883313
,0.0118649195833040056041741
,0.0115312608042092406418488
,0.0112071928220842786244615
,0.0108924370772329245221632
,0.0105867203100946279115124
,0.0102897740367962082369546
,0.0100013340598711399087595
,0.0097211400377035985659324
,0.0094489351399300071376874
,0.0091844658188254772041015
,0.0089274817281775834670876
,0.0086777358208728980898394
,0.0084349846540112596166017
,0.0081989889255331595968590
,0.0079695142589489287310300
,0.0077463322428241694964091
,0.0075292217194359170942541
,0.0073179703029139803877046
,0.0071123760918771344874401
,0.0069122495259017228616538
,0.0067174153201000957533195
,0.0065277143986995226146441
,0.0063430057378717798199919
,0.0061631680211776986022532
,0.0059881010087222460297474
,0.0058177265241084333627364
,0.0056519889718835451472567
,0.0054908553124192868363784
,0.0053343144407055238798154
,0.0051823759396223351494926
,0.0050350682058334468235716
,0.0048924359760828418225431
,0.0047545373117558464848287
,0.0046214401283185164992506
,0.0044932183819280111305994
,0.0043699480457930935106692
,0.0042517030243316910817497
,0.0041385511593735211863243
,0.0040305504826573732013451
,0.0039277458600993891274511
,0.0038301661573345419618819
,0.0037378220337834608573424
,0.0036507044453696828149869
,0.0035687839058632549182892
,0.0034920105256575286085952
,0.0034203148221717770936789
,0.0033536092556371351752764
,0.0032917904344037982565518
,0.0032347419198435482974585
,0.0031823375325692373344344
,0.0031344450825730521548174
,0.0030909304381954048543402
,0.0030516618649275737903959
,0.0030165145866110649325309
,0.0029853755497115793890450
,0.0029581484067470334778371
,0.0029347587781406716742061
,0.0029151599036026450313674
,0.0028993388561129969024921
,0.0028873235659918152808123
,0.0028791909925823516019916
,0.0028750768907236106015912
,0.0028751878823497787132646
,0.0028798165974036993124130
,0.0028893608258467491645138
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0466072505979881063220560
,0.0932145011959762126441120
,0.1398217517939643328439558
,0.1864290023919524252882240
,0.2330362529899405177324923
,0.2796435035879286101767605
,0.3262507541859167026210287
,0.3728580047839047950652969
,0.4194652553818928875095651
,0.4660725059798809799538333
,0.5126797565778691279092527
,0.7909195296919822038006487
,0.7684529194795493012293264
,0.7466235919256972719537657
,0.7254134647983087047506956
,0.7048049689598204770035750
,0.6847810338244534333895785
,0.6653250732302261605255467
,0.6464209717142009870016750
,0.6280530711796923348799737
,0.6102061579444381100856276
,0.5928654501589042391529460
,0.5760165855840143622756955
,0.5596456097175760424633495
,0.5437389642585502835814282
,0.5282834758979541023293791
,0.5132663454246269019165538
,0.4986751371332023285987134
,0.4845285696641661865591288
,0.4707540141520847876144273
,0.4573701422734909871614661
,0.4443658683497389016991974
,0.4317304212234605031994761
,0.4194533353381197926523782
,0.4075244420711944259849702
,0.3959338613138690954329491
,0.3846719932903350791519870
,0.3737295106100048669439673
,0.3630973505461506656288861
,0.3527667075346693770221407
,0.3427290258868712080619900
,0.3329759927103619343569108
,0.3234995310322613115694423
,0.3142917931191483993380587
,0.3053451539882512943968607
,0.2966522051045000774038840
,0.2871121536600827472973663
,0.2789001329979523546853670
,0.2720245339511488391615046
,0.2642763790158176862021833
,0.2567479101001585162222796
,0.2494328947224556947137586
,0.2423252774723684555002734
,0.2354191749897188712381535
,0.2287088710709528072140273
,0.2221888118924429111888941
,0.2158536013377910511845670
,0.2096979964138073748713964
,0.2037169027368940510402950
,0.1979053700681136507277813
,0.1922585878713553853014417
,0.1867718808648055339727279
,0.1814407045315948319164079
,0.1762606405513154617104021
,0.1712273921105071095016825
,0.1663367790477384422498375
,0.1615847327882884709726596
,0.1569672910254587550049621
,0.1524805921111851703120266
,0.1481208691288329326596340
,0.1438844436368086066035943
,0.1397677190937273161708276
,0.1357671740048550512725001
,0.1318793548655481928655320
,0.1281008690199739730175565
,0.1244283776013865444598494
,0.1208585887717056606138755
,0.1173882515303274615137141
,0.1140141504114183662599302
,0.1107331014311368627689447
,0.1075419496766022858791345
,0.1044375689421099678844129
,0.1014168638104630260077244
,0.0950858724791005527343657
,0.0956142850919579484481048
,0.0928264344194250079489450
,0.0901103312653278171184823
,0.0874631722637853603607994
,0.0848822632171798291400577
,0.0823650431157774559620677
,0.0799091103128424795620788
,0.0775122500785268148115748
,0.0751724625852748934429215
,0.0728879902329783030401344
,0.0706573431146195196639326
,0.0684793213625587843251807
,0.0663530331101287590422899
,0.0642779068585914853395380
,0.0622536971586834173009173
,0.0602804826984271041601104
,0.0583586561305248982534088
,0.0564889052655921583556697
,0.0546721855902523035108942
,0.0529096844269301910812509
,0.0512027774176242664316838
,0.0495529783678142904390640
,0.0479618838091216831420738
,0.0464311139111740420193364
,0.0449622515771667188855254
,0.0435567816800928112042079
,0.0422160324283814905599321
,0.0409411207871080151665666
,0.0397329037264132281515039
,0.0385919368306935628432086
,0.0375184414943673244513533
,0.0365122815708987871752278
,0.0355729499525664974446393
,0.0346995651617998113191987
,0.0338908776528952515594284
,0.0331452851755526800570095
,0.0324608562553961935148727
,0.0318353606134242766989573
,0.0312663051831127344892813
,0.0307509742925852411210563
,0.0302864725571637127821134
,0.0298697690681456670680483
,0.0294977415573784464142282
,0.0291672193528519953231726
,0.0288750241061040205381438
,0.0286180074558931400730000
,0.0283930849834551253529913
,0.0281972660032849889444329
,0.0243074850926081782731547
,0.0236185480221995543204105
,0.0228615526284025212533368
,0.0222108990229831319840326
,0.0216672916343010717177275
,0.0210535962941160240124994
,0.0204574035058825466626420
,0.0198782198058416216535083
,0.0193155658478714326031778
,0.0187689760059289341420641
,0.0182379979863364384551350
,0.0177221924489160582993907
,0.0172211326357787145036049
,0.0167344040063380182503661
,0.0162616038768429137240101
,0.0158023410624103521904260
,0.0153562355192007823911915
,0.0149229179840305748588891
,0.0145020296083857372360093
,0.0140932215835261696185166
,0.0136961547532024989493049
,0.0133104992105104041888453
,0.0129359338756575570350549
,0.0125721460519994613497241
,0.0122188309587001574241238
,0.0118756912398734690294866
,0.0115424364521240305908600
,0.0112187825350687480491230
,0.0109044512726667493229815
,0.0105991697569474442597315
,0.0103026698698590619268645
,0.0100146878032421737109159
,0.0097349636410616977727495
,0.0094632410316362533531098
,0.0091992669802585767813152
,0.0089427917938592407787191
,0.0086935692087912620068524
,0.0084513567300301354473513
,0.0082159162048183673188184
,0.0079870146459112556502902
,0.0077644253091628413071534
,0.0075479290174982078404087
,0.0073373157088429084848880
,0.0071323861700240860639344
,0.0069329539029051694132288
,0.0067388470540866596963925
,0.0065499103264893675929725
,0.0063660067811238015000885
,0.0061870194313438852881659
,0.0060128525307272901942457
,0.0058434324600060471091578
,0.0056787081284987526302865
,0.0055186508212004981716037
,0.0053632534435905836536773
,0.0052125291415476438655618
,0.0050665093022663771488157
,0.0049252409722890114554539
,0.0047887837589964737591841
,0.0046572063104057988269791
,0.0045305824920864054897174
,0.0044089874008868216309631
,0.0042924933663760203236825
,0.0041811660971072441700391
,0.0040750611256929140241434
,0.0039742206959680077132946
,0.0038786712177454863402504
,0.0037884213908963813854935
,0.0037034610724147021786068
,0.0036237609296915426759789
,0.0035492729000272896927592
,0.0034799314300027746164889
,0.0034156554603796160200779
,0.0033563511066921438742716
,0.0033019149474433607226176
,0.0032522378585143987307637
,0.0032072093181878592350886
,0.0031667221235171763744909
,0.0031306774814728070485681
,0.0030989904691644124326566
,0.0030715958978865757350585
,0.0030484546668564449847794
,0.0030295607558423463291641
,0.0030149490838342831063035
,0.0030047045570566243213873
,0.0029989727489294227408267
,0.0029979728035131616124820
,0.0030020134907788064738965
,0.0030115134541342232325778
,0.0030270269631838464183260
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0444061906804197881193375
,0.0888123813608395762386749
,0.1332185720412593643580124
,0.1776247627216791524773498
,0.2220309534020989405966873
,0.2664371440825187287160247
,0.3108433347629385168353622
,0.3552495254433583049546996
,0.3996557161237780930740371
,0.4440619068041978811933745
,0.4884680974846176693127120
,0.5328742881650374574320495
,0.8139412128579011085349748
,0.7908215826522861924274821
,0.7683577642191288248341152
,0.7465311495750308612429080
,0.7253236587352140940510026
,0.7047177247459527338335761
,0.6846962791436187467652985
,0.6652427378284531123142642
,0.6463409873415209005997895
,0.6279753715335874009184636
,0.6101306786149111038852766
,0.5927921285751346358594560
,0.5759453609625609926681022
,0.5595764230121025306630145
,0.5436717581110440677960582
,0.5282181945914222742644029
,0.5132029348372635357833360
,0.4986135446940250792735583
,0.4844687469247991873366743
,0.4706959089918376082373186
,0.4573137065160393643914460
,0.4443110552016134584540907
,0.4316771852352699889721066
,0.4194016323668878221120337
,0.4074742292437780188940621
,0.3958850969914270434557579
,0.3846246370338180509129700
,0.3736835231466379969589298
,0.3630526937368802053995864
,0.3527233443425492054323911
,0.3426869203463584478974724
,0.3329351098975008582669943
,0.3234598370357307239864042
,0.3142532550121484025140717
,0.3053077398012112309011457
,0.2966158837985832796846353
,0.2870769547337809757259208
,0.2788659685363266138580229
,0.2719913139818692093818697
,0.2642441365769044314681935
,0.2567166184359955805049935
,0.2494025278652441668381101
,0.2422958102209340214283628
,0.2353905828890905660433219
,0.2286811303927329674934299
,0.2221618996160035497400287
,0.2158274951323305712591605
,0.2096726746213201098001377
,0.2036923443561007296409571
,0.1978815547394103813161337
,0.1922354958628316734525754
,0.1867494930593724955514290
,0.1814190024152457503259228
,0.1762396062025055609723267
,0.1712070081905869289862210
,0.1663170287923134149643545
,0.1615655999992808844467618
,0.1569487600635466606480151
,0.1524626478881634938922218
,0.1481034970993043431430891
,0.1438676297884743937594010
,0.1397514499354131078945329
,0.1357514365513050602629619
,0.1318641366179611751352496
,0.1280861579412618800333235
,0.1244141620852341895142601
,0.1208448576047090605722900
,0.1173749938468141434944059
,0.1140013556409952277803654
,0.1107207592395753614766818
,0.1075300499013323168862044
,0.1044261015243183599032761
,0.1014058187265355348571916
,0.0950738375537757834932151
,0.0956040544236592404470088
,0.0928165956061405839072620
,0.0901008738571020401098011
,0.0874540856302363500685004
,0.0848735365605005065425814
,0.0823566655113443374380822
,0.0799010707794446800589228
,0.0775045376787277390251418
,0.0751650665546636093106159
,0.0728809001351494734066705
,0.0706505490167506911003414
,0.0684728140245622757253940
,0.0663468041786711426599510
,0.0642719490559415518315944
,0.0622480044554761663411213
,0.0602750504591323676972792
,0.0583534812207431863306795
,0.0564839861113088717581299
,0.0546675221808491790254081
,0.0529052782560286288804363
,0.0511986313586157912314256
,0.0495490964840810954594730
,0.0479582711022858015903481
,0.0464277760140450398984591
,0.0449591944011709723771908
,0.0435540110296693747105046
,0.0422135535969326361471765
,0.0409389381504605409656250
,0.0397310203502808170772376
,0.0385903541082958170815864
,0.0375171588291778948520694
,0.0365112961175462838459005
,0.0355722564263264498518602
,0.0346991557240626177782694
,0.0338907418766695583967063
,0.0331454100916628441320100
,0.0324612264767487473937635
,0.0318359585317216711719546
,0.0312671112298161246734196
,0.0307519672538700099273523
,0.0302876299311250866963530
,0.0298710674516126720168252
,0.0294991570493622276560863
,0.0291687279618426248406493
,0.0288766021490702538832007
,0.0286196319378562713531267
,0.0283947339478162162629271
,0.0250198964266618792406938
,0.0243110387854161523468743
,0.0236223805921540637442479
,0.0228656604335191679377992
,0.0222152918305791764741475
,0.0216719820076138533493371
,0.0210585805139255483053873
,0.0204626859683217747487571
,0.0198838051795390893805582
,0.0193214590801082351789741
,0.0187751823291832826978709
,0.0182445229252105566020159
,0.0177290418274300420886647
,0.0172283125850039749160647
,0.0167419209723263587297204
,0.0162694646287882653534762
,0.0158105527009571450447467
,0.0153648054847874571821054
,0.0149318540651309783484635
,0.0145113399494867043731938
,0.0141029146926624545516082
,0.0137062395088650354479931
,0.0133209848677603263922276
,0.0129468300713254484690662
,0.0125834628089402690565013
,0.0122305786892211131033914
,0.0118878807486694649392378
,0.0115550789393527569143272
,0.0112318896005852517788748
,0.0109180349229141774453078
,0.0106132424165604217353165
,0.0103172444006582996606225
,0.0100297775339493223933918
,0.0097505824116936208600936
,0.0094794032570824672545573
,0.0092159877379290079668639
,0.0089600869404243815158351
,0.0087114555308372126213312
,0.0084698521328338480240738
,0.0082350399423494723138983
,0.0080067875935465743220121
,0.0077848702784556467193511
,0.0075690711097189883674319
,0.0073591827009946500504078
,0.0071550089237778858111683
,0.0069563667835982802983841
,0.0067630883438099071922056
,0.0065750226126352817254683
,0.0063920372998496595776108
,0.0062140203445035990456602
,0.0060408811151695870900191
,0.0058725511899371607774101
,0.0057089846349786281184957
,0.0055501577177491422457334
,0.0053960680133176910922010
,0.0052467328888988881349653
,0.0051021873811259218362002
,0.0049624815113973050687002
,0.0048276771150858937761696
,0.0046978442871150848103579
,0.0045730575722992376774823
,0.0044533920443816585321706
,0.0043389194300963943723426
,0.0042297044371612593782750
,0.0041258014400099556756585
,0.0040272516643836487118535
,0.0039340809922796815545354
,0.0038462984836772919593206
,0.0037638956827291307830063
,0.0036868467558781622787911
,0.0036151094566805957140898
,0.0035486269077105456540289
,0.0034873301742619784021615
,0.0034311415547871402381697
,0.0033799785486477284396356
,0.0033337584401260081552743
,0.0032924034550458557667196
,0.0032558464710561872863803
,0.0032240372973568352452101
,0.0031969495867460841556640
,0.0031745885043007416800864
,0.0031569993553506557615318
,0.0031442774745244592322913
,0.0031365798031450058125369
,0.0031341387420773694598430
,0.0031372790721391902168946
,0.0031464391719815158407481
,0.0031621979723850785447270
,0.0031853095156779654903434
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0423872113856833890310760
,0.0847744227713667780621520
,0.1271616341570501740321220
,0.1695488455427335561243041
,0.2119360569284169382164862
,0.2543232683141003480642439
,0.2967104796997837579120016
,0.3390976910854671677597594
,0.3814849024711505776075171
,0.4238721138568339874552748
,0.4662593252425173973030326
,0.5086465366282008071507903
,0.5510337480138841614873968
,0.8376259613971025475009924
,0.8138344981187152216151048
,0.7907179095533013457597349
,0.7682570468321433532210563
,0.7464333044203387279580397
,0.7252286047124241186168092
,0.7046253830667820183819572
,0.6846065732665993497363388
,0.6651555933955005661672999
,0.6462563321163145024783603
,0.6278931353417148697459993
,0.6100507932857299753237612
,0.5927145278853139798158622
,0.5758699805812602656729382
,0.5595032004477631382144409
,0.5436006326597592197558129
,0.5281491072868765845882422
,0.5131358284022243809729957
,0.4985483634933929875110437
,0.4844054396886707802849514
,0.4706344205621968979080805
,0.4572539859113680105195954
,0.4442530529047734044745255
,0.4316208531524693969849693
,0.4193469237878281186127083
,0.4074210988029430269286024
,0.3958335006304862235815278
,0.3845745319651110438741171
,0.3736348678177103255215741
,0.3630054477960413250592353
,0.3526774686054220953046467
,0.3426423767633969830193053
,0.3328918615224455423984296
,0.3234178479949784690283821
,0.3142124904750138725262332
,0.3052681659510533274115573
,0.2965774678047822798809818
,0.2870397277791181256390018
,0.2788298376501062714183377
,0.2719561840305683153573568
,0.2642100424879165743163867
,0.2566835319169854523480012
,0.2493704214587450784801348
,0.2422646572819399657383599
,0.2353603575634630462598551
,0.2286518075964487917151047
,0.2221334550152730957783831
,0.2157999051246318744645691
,0.2096459163173957362946709
,0.2036663955629724187534890
,0.1978563939444708263959427
,0.1922111022190660933883777
,0.1867258463717548777616173
,0.1813960831283294716786969
,0.1762173953891940370031222
,0.1711854875420174282307784
,0.1662961806087115412822186
,0.1615454071815535241896100
,0.1569292061052640629981170
,0.1524437168674480924668302
,0.1480851736700016518799572
,0.1438498991698296258778811
,0.1397342978993426354517027
,0.1357348494062426136341770
,0.1318481011881972031485333
,0.1280706615407089798974738
,0.1243991924846533925208547
,0.1208304029916550392798058
,0.1173610427778979392599012
,0.1139878969865423252727510
,0.1107077821213575674619278
,0.1075175436247514521026503
,0.1044140555071916831586520
,0.1013942224274156644892031
,0.0950612077944574668242339
,0.0955933257642702094436515
,0.0928062846422638976218167
,0.0900909696241697088847644
,0.0874445769846485115861512
,0.0848644121957764646646538
,0.0823479140035821705057018
,0.0798926806640992415164959
,0.0774964975591019150646943
,0.0751573652406228170930191
,0.0728735268085203141685824
,0.0706434934177668366617198
,0.0684660666517152016741221
,0.0663403564925548472341887
,0.0642657936762876802472277
,0.0622421353396948387470822
,0.0602694630504046410801600
,0.0583481725541298221204833
,0.0564789548674802591166078
,0.0546627686788878491830346
,0.0529008043792467338994889
,0.0511944404103561317986859
,0.0495451929738750171394734
,0.0479546604663361464293558
,0.0464244642775710758542118
,0.0449561877934755785291010
,0.0435513155656450240416078
,0.0422111746409272320379458
,0.0409368799798198318429243
,0.0397292857363771845236045
,0.0385889439324052577195978
,0.0375160717492079090473744
,0.0365105282994375099359097
,0.0355718013510952432709722
,0.0346990040781070888109561
,0.0338908815293360171638781
,0.0331458261603813503226590
,0.0324619014765015340140408
,0.0318368726023864692664667
,0.0312682424321731877725483
,0.0307532919228775993014668
,0.0302891230735092796544361
,0.0298727031738971332552879
,0.0295009090021577068119196
,0.0291705697864711455125075
,0.0288785079133417853236576
,0.0286215765489597276372002
,0.0257531114136326545749345
,0.0250237679581381440574450
,0.0243152142736547914603218
,0.0236268637124002825466995
,0.0228704469809763374921197
,0.0222203932373239917974495
,0.0216774128576093447207107
,0.0210643365068923608951490
,0.0204687722137087170504177
,0.0198902270926893422198223
,0.0193282223896639564209021
,0.0187822930849585595369788
,0.0182519875065294268079441
,0.0177368669519170213400017
,0.0172365053177996434274899
,0.0167504887356841533629925
,0.0162784152119863322061288
,0.0158198942704349532206720
,0.0153745465943888465210065
,0.0149420036663074941307716
,0.0145219074012894987235622
,0.0141139097713332915123852
,0.0137176724168341437892771
,0.0133328662418796019262235
,0.0129591709902227587153378
,0.0125962747994857737765528
,0.0122438737322666663098758
,0.0119016712844693273859464
,0.0115693778734124105844749
,0.0112467103111216302352426
,0.0109333912716463622916141
,0.0106291487651741650699577
,0.0103337156359778262193494
,0.0100468291055657490268294
,0.0097682303864855338226825
,0.0094976643956480848868251
,0.0092348795983450172875084
,0.0089796280148597817233336
,0.0087316654202852662242096
,0.0084907517644955115415639
,0.0082566518329390322511463
,0.0080291361599590035935670
,0.0075687132584045515790172
,0.0075929757071018328870582
,0.0073839124022935017505054
,0.0071805997035326099564578
,0.0069828586382124262568749
,0.0067905257548417597909807
,0.0066034549829804538995104
,0.0064215193408387839443807
,0.0062446123912638052885771
,0.0060726493483620564914349
,0.0059055677443778445412370
,0.0057433275796886160136090
,0.0055859108978049167026914
,0.0054333207512188477078530
,0.0052855795518632437898776
,0.0051427268304256937292429
,0.0050048164603221116306098
,0.0048719134305785271113476
,0.0047440902824000819038019
,0.0046214233431540749710842
,0.0045039889099879343997701
,0.0043918595434540678990043
,0.0042851006322095902545399
,0.0041837673827266686280013
,0.0040879023731499822963409
,0.0039975337891930123185302
,0.0039126744338736953177094
,0.0038333215873285614305743
,0.0037594577335044519587892
,0.0036910521718773090481258
,0.0036280635181865513415322
,0.0035704430348840899417384
,0.0035181387806129844897374
,0.0034711005380637168123148
,0.0034292854993089394791128
,0.0033926647158246058498532
,0.0033612303607811408467931
,0.0033350039074818991005622
,0.0033140454032987939382571
,0.0032984641173429353651347
,0.0032884309685861780152283
,0.0032841933082813829815338
,0.0032860928494582706572980
,0.0032945878259074421259833
,0.0033102810481757459319663
,0.0033339559006802244045531
,0.0033666230271497837346628
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0405352502645714568574320
,0.0810705005291429137148640
,0.1216057507937143705722960
,0.1621410010582858274297280
,0.2026762513228572704093722
,0.2432115015874287133890164
,0.2837467518520001563686606
,0.3242820021165715993483047
,0.3648172523811430423279489
,0.4053525026457144853075931
,0.4458877529102859282872373
,0.4864230031748573712668815
,0.5269582534394288142465257
,0.5674935037040003127373211
,0.8619923343747567523465136
,0.8375096984269683186852262
,0.8137215488900875204336671
,0.7906081804509628163657453
,0.7681504469084349251417621
,0.7463297453197933473134640
,0.7251280005985464294226972
,0.7045276505509183717634869
,0.6845116313388294182473714
,0.6650633633575059322495804
,0.6461667375161603832367518
,0.6278061019105001250295572
,0.6099662488760591028125191
,0.5926324024115405819657099
,0.5757902059614751211213957
,0.5594257105474754743212884
,0.5435253632372617493828670
,0.5280759959402634429181944
,0.5130648145180589647651459
,0.4984793881970216444798893
,0.4843384487273930116835174
,0.4705693555668362670907356
,0.4571907929349368071569870
,0.4441916795509706084033041
,0.4315612485322625202499580
,0.4192890384772803846757938
,0.4073648848022556889780788
,0.3957789113242179412921473
,0.3845215220835427327727984
,0.3735833933993240596471708
,0.3629554661510802082702298
,0.3526289382805027905476436
,0.3425952575071445904697498
,0.3328461142521247362324743
,0.3233734347640920270272602
,0.3141693744418428968501189
,0.3052263113481200051957387
,0.2965368399092072615452764
,0.2870003595501789406263526
,0.2787916307801814319589084
,0.2719190379394922918443456
,0.2641739940962614108244111
,0.2566485513104853066757016
,0.2493364796078878509177912
,0.2422317260182751119668154
,0.2353284095567732825404761
,0.2286208163328111164780410
,0.2221033947760436277896190
,0.2157707509663988054704475
,0.2096176440529503026688474
,0.2036389817433590099238216
,0.1978298158421745445156859
,0.1921853378123951627820531
,0.1867008743304642559568407
,0.1813718828005048133711341
,0.1761939467893816335664070
,0.1711627713405249884282000
,0.1662741781219308767614251
,0.1615241003630557004022705
,0.1569085775372957014539566
,0.1524237497523190654202807
,0.1480658518206996732136105
,0.1438312069990418939902099
,0.1397162204059232415431779
,0.1357173721580468561676014
,0.1318312103001489099529664
,0.1280543436469788465270625
,0.1243834347039453613881221
,0.1208151928848320288967244
,0.1173463682975513094897124
,0.1139737464186172111180184
,0.1106941440195869930107619
,0.1075044067393992885950382
,0.1044014087104185029009074
,0.1013820546384101711767656
,0.0950479621896712645323646
,0.0955820825887972597145747
,0.0927954868486640799263299
,0.0900806057154883016435676
,0.0874346352878898752658543
,0.0848548808816902699891926
,0.0823387811375637657107518
,0.0798839342902000759671921
,0.0774881258173984732717798
,0.0751493565161724524914533
,0.0728658699079399868603346
,0.0706361777672363105873288
,0.0684590825080837322991201
,0.0663336951573677974236531
,0.0642594477011046300019004
,0.0622360987101784127184523
,0.0602637313364329241238693
,0.0583427430136998909082635
,0.0564738264934595696198372
,0.0546579421797152159578914
,0.0528962820874155636996505
,0.0511902261158059812551357
,0.0495412916831051847177392
,0.0479510780919291459967191
,0.0464212072666421518563062
,0.0449532627071071513857881
,0.0435487286243897847581863
,0.0422089312537657218582510
,0.0409349842753801151928883
,0.0397277401156626297495933
,0.0385877486616961751231258
,0.0375152246102445352526900
,0.0365100243115520500802873
,0.0355716325768066568557835
,0.0346991595200227403994475
,0.0338913471222510448432885
,0.0331465848584641328833378
,0.0324629334316230561130467
,0.0318381554261881194456407
,0.0312697515315241772460020
,0.0307550008960564072446608
,0.0302910041528106806218990
,0.0298747276994282134898739
,0.0295030479113147330039180
,0.0291727941039233440445599
,0.0288807892272061467187072
,0.0265077385816824481756804
,0.0257573290263743981398648
,0.0250283168563257205074812
,0.0243200984778281538434275
,0.0236320875449373031529365
,0.0228760056052145326066505
,0.0222262999866183960651078
,0.0216836846182274708971782
,0.0210709683275585209216718
,0.0204757700231032666038367
,0.0198975971637045181972248
,0.0193359713483189435412335
,0.0187904279198826754115892
,0.0182605155790150526506910
,0.0177457960065322099818541
,0.0172458434935358201345323
,0.0167602445775950695261436
,0.0162885976832513983125761
,0.0158305127647529013390493
,0.0153856109485781978457597
,0.0149535241729600466148442
,0.0145338948212966161122051
,0.0141263753460874087741761
,0.0137306278799074425039928
,0.0133463238300096653787818
,0.0129731434535027157634035
,0.0126107754107807733950919
,0.0122589162960736689639285
,0.0119172701457208232017626
,0.0115855479271087229847792
,0.0112634670141692778272402
,0.0109507506588810438891146
,0.0106471274722434797177506
,0.0103523309325228018984433
,0.0100660989429267877515173
,0.0097881734649033300815768
,0.0095183002565518270293721
,0.0092562287477237752825188
,0.0090017120837935227228854
,0.0087545073683676366549378
,0.0085143761310177232953800
,0.0082810850392560000216013
,0.0080544068643925836176178
,0.0075980681174049246803803
,0.0076200184079480235560533
,0.0074118962847494725479369
,0.0072095668578800601103418
,0.0070128557895628110957498
,0.0068216047845406054331296
,0.0066356734204938185028855
,0.0064549408028031695847004
,0.0062793069440744923165321
,0.0061086937720093003462152
,0.0059430456782503830390207
,0.0057823295360840722134643
,0.0056265341356551709997569
,0.0054756690110120591688525
,0.0053297626626716016612351
,0.0051888602112578454186864
,0.0050530205468351432201990
,0.0049223130734384759957245
,0.0047968141695214940034564
,0.0046766035095240137894890
,0.0045617604051929067782156
,0.0044523603318123144284568
,0.0043484718032600951781452
,0.0042501537503894107686286
,0.0041574535405749088110006
,0.0040704057536995290333959
,0.0039890318208318032225379
,0.0039133405649180823260291
,0.0038433296924936842867138
,0.0037789882748315039608100
,0.0037203001777407233505168
,0.0036672484659710643736807
,0.0036198207690066514820304
,0.0035780156190584853914682
,0.0035418498057968260915584
,0.0035113668412806776399082
,0.0034866466981375836969859
,0.0034678170795863069372778
,0.0034550666082858020634883
,0.0034486604923208790361711
,0.0034489594559207197195516
,0.0034564430322098615294690
,0.0034717387392182380914663
,0.0034956594734618659861547
,0.0035292521279819775298359
,0.0035738616323697991114527
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0388364908948980111502713
,0.0776729817897960223005427
,0.1165094726846940265119201
,0.1553459635795920446010854
,0.1941824544744900626902506
,0.2330189453693880807794159
,0.2718554362642860988685811
,0.3106919271591840892021708
,0.3495284180540820795357604
,0.3883649089489800698693500
,0.4272013998438780602029397
,0.4660378907387760505365293
,0.5048743816336740408701189
,0.5437108725285720867148598
,0.5825473634234701325596006
,0.8870593618906068567042666
,0.8618656738097859593139560
,0.8373866479062697099067236
,0.8136020064276873187125716
,0.7904920469669920457533863
,0.7680376261470224230620829
,0.7462201437693064542955312
,0.7250215274140994203833088
,0.7044242174790871224843158
,0.6844111526445165738508081
,0.6649657557528880769126545
,0.6460719200916689164415629
,0.6277139960677786678644452
,0.6098767782628451428195149
,0.5925454928584327207730098
,0.5757057854205300806427203
,0.5593437090326176530652447
,0.5434457127664608089290255
,0.5279986304794692664188460
,0.5129896699268795545734179
,0.4984064021761451801495468
,0.4842675638712051200407416
,0.4705005101115942167666617
,0.4571239297991219752148595
,0.4441267432951158111720247
,0.4314981853130108180316427
,0.4192277960027658290087516
,0.4073054122887670991381981
,0.3957211594541120147638935
,0.3844654429643689086404379
,0.3735289405241288274162059
,0.3629025943598571113390960
,0.3525776037227567050180710
,0.3425454176055403032741253
,0.3327977276671885698000608
,0.3233264613599385883802029
,0.3141237752529018600888833
,0.3051820485468358379321785
,0.2964938767746903569566541
,0.2869587309149804199570610
,0.2787512327041051785059267
,0.2718797640957878458678465
,0.2641358835076716982115386
,0.2566115723512523705274191
,0.2493006015898966420962779
,0.2421969191660088560613673
,0.2352946449831808672925604
,0.2285880660161178912215263
,0.2220716315375393379305535
,0.2157399484492502073074149
,0.2095877767020927762153804
,0.2036100247865282597548031
,0.1978017452721410329719021
,0.1921581303704633925111267
,0.1866745074912802004885037
,0.1813463347581966422783495
,0.1761691964450121383745085
,0.1711387982907782989716594
,0.1662509626488723191162222
,0.1615016234246993420686778
,0.1568868207585853158381184
,0.1524026954159815039346881
,0.1480454828572657643981358
,0.1438115069751702002065485
,0.1396971735100063782830659
,0.1356989631819695008019266
,0.1318134246159992362112945
,0.1280371671775430986173205
,0.1243668538859373645655282
,0.1207991946240699471237789
,0.1173309399156907267824934
,0.1139588755915941220564491
,0.1106798187086094065190167
,0.1074906151161182654707460
,0.1043881390787729096514269
,0.1013692953565156901207800
,0.0950340801839020810071190
,0.0955703089371087027847906
,0.0927841882579686361154359
,0.0900697701391669630632819
,0.0874242505081597037763785
,0.0848449345335732657558125
,0.0823292607658938774273238
,0.0798748274416246489826321
,0.0774794201674505328414355
,0.0751410400293184704834104
,0.0728579310261599777387431
,0.0706286056203185574897674
,0.0684518671365635794634485
,0.0663268277370843289952873
,0.0642529207568503513137159
,0.0622299063050199760538383
,0.0602578692231065179973903
,0.0583372087351111470732157
,0.0564686194207746558482164
,0.0546530634787968788712575
,0.0528917346073526292715705
,0.0511860141968739010276401
,0.0495374208854904435339606
,0.0479475548507288171218299
,0.0464180384827575231998509
,0.0449504552874283799801525
,0.0435462889878688655387329
,0.0422068648223783496331585
,0.0409332949704162216142400
,0.0397264298801546025807774
,0.0385868170290626436025327
,0.0375146683374394523946549
,0.0365098370922814149941438
,0.0355718048468858724642239
,0.0346996783629217181443849
,0.0338921962785595845546460
,0.0331477448386631248777867
,0.0324643817274072460365986
,0.0318398668118612601651840
,0.0312716984438402914592281
,0.0307571538784249080833444
,0.0302933323480743220412759
,0.0298771993744724288777359
,0.0295056309965376663273506
,0.0291754567310223110465639
,0.0272844042905453047775932
,0.0265123330000303775166870
,0.0257622845086586949037155
,0.0250336378015147409392682
,0.0243257896155647523883658
,0.0235508451552918322835506
,0.0228824417173432784200493
,0.0222331213173218196488268
,0.0216909106759130658470536
,0.0210785934336520756893218
,0.0204838010477276545595604
,0.0199060413653048308424420
,0.0193448363844110071685378
,0.0187997218584949957187469
,0.0182702469108314731471854
,0.0177559736577306073734839
,0.0172564768393022489878508
,0.0167713434562719414244736
,0.0163001724110537690726197
,0.0158425741509572344523082
,0.0153981703110567750419913
,0.0149665933539021214077058
,0.0145474862029303254190582
,0.0141405018661999049706113
,0.0137453030469646270139705
,0.0133615617377124355075191
,0.0129889587946988641076196
,0.0126271834907969119493609
,0.0122759330457580494166958
,0.0119349121348124084102116
,0.0116038323789846471723042
,0.0112824118235796064246834
,0.0109703744149541419783400
,0.0106674494898216943444824
,0.0103733712957334960058642
,0.0100878785657556521715428
,0.0098107141743424674390495
,0.0095416249045535937722828
,0.0092803613585950156528170
,0.0090266780437023384081607
,0.0087803336631925733152260
,0.0085410916377533334375993
,0.0083087208745301083939738
,0.0080829967913250439642825
,0.0076312388796983222569170
,0.0076506307622121816694460
,0.0074435847813300376127343
,0.0072423809444926287234856
,0.0070468502800741777275517
,0.0068568404486800960118131
,0.0066722175420549636667977
,0.0064928676819092680239098
,0.0063186983193256772081692
,0.0061496391401873974277836
,0.0059856424933295206830541
,0.0058266832752659489594316
,0.0056727582281558943180788
,0.0055238846352251248436604
,0.0053800984293020191057133
,0.0052414517586301303392338
,0.0051080100932310778735768
,0.0049798489771879879059457
,0.0048570505626081049779796
,0.0047397000793066102267148
,0.0046278824064975689414614
,0.0045216789176549532225380
,0.0044211647661213486493192
,0.0043264067676375946372436
,0.0042374620177738648446608
,0.0041543773818113680085240
,0.0040771899192292839972374
,0.0040059283259483427150349
,0.0039406154730713526673780
,0.0038812720228876226337411
,0.0038279211942899519366401
,0.0037805947007047355223897
,0.0037393399148058443018372
,0.0037042283571379992432315
,0.0036753656679032278321861
,0.0036529033107538231607558
,0.0036370523829136599744394
,0.0036281000786508865729729
,0.0036264295898108056884213
,0.0036325445532497855315179
,0.0036470996097566817789604
,0.0036709392835482424106985
,0.0037051485729959559266289
,0.0037511198411118128193120
,0.0038106426580949391558217
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0372782598050786437293702
,0.0745565196101572874587404
,0.1118347794152359242492167
,0.1491130392203145749174809
,0.1863912990253932255857450
,0.2236695588304718762540091
,0.2609478186355504991666976
,0.2982260784406291498349617
,0.3355043382457078005032258
,0.3727825980507864511714899
,0.4100608578558651018397541
,0.4473391176609437525080182
,0.4846173774660224031762823
,0.5218956372711009983333952
,0.5591738970761795934905081
,0.5964521568812581886476210
,0.9128465526739809599021669
,0.8869213795633880126345616
,0.8617316241622438033331832
,0.8372564198377200339606929
,0.8134754920032942759888783
,0.7903691413283273625722813
,0.7679182274251796780362156
,0.7461041530004841604295507
,0.7249088484575931801145998
,0.7043147569376161376553114
,0.6843048197868236703911293
,0.6648624624385482961841376
,0.6459715806980484975596823
,0.6276165274190864673542478
,0.6097820995612240890793032
,0.5924535256170387897967089
,0.5756164533985627107526284
,0.5592569381722547472435281
,0.5433614311316745659752314
,0.5279167681966996372722178
,0.5129101591275512239676004
,0.4983291769410351790270397
,0.4841925634623748808671451
,0.4704276691772815155445642
,0.4570531879449903356338325
,0.4440580418655951100426194
,0.4314314673426918322896029
,0.4191630061691930531075911
,0.4072424968665917521803976
,0.3956600662705655468975863
,0.3844061213560224232743678
,0.3734713412948995614470959
,0.3628466697402298324348635
,0.3525233073301851094427661
,0.3424927044059955516530636
,0.3327465539378228753797373
,0.3232767846528380450976670
,0.3140755543598945931371702
,0.3051352434653324396940377
,0.2964484486745337377122667
,0.2869147166035049267840407
,0.2787085222978158416395900
,0.2718382452063315968260326
,0.2640955973743435714062855
,0.2565724855427100048466116
,0.2492626816685226398551123
,0.2421601346614342675778175
,0.2352589653667804814318743
,0.2285534616765001192373319
,0.2220380737570742391007173
,0.2157074093816795934408503
,0.2095562293512835128073135
,0.2035794429864305754573905
,0.1977721036680205324298498
,0.1921294044014670299169723
,0.1866466733743866457384541
,0.1813193694735714400767534
,0.1761430777227470656498554
,0.1711135045989294611867848
,0.1662264731826249564150544
,0.1614779180963764049216991
,0.1568638801880812838618340
,0.1523805009210456862245309
,0.1480240164428913429706114
,0.1437907513211692522858698
,0.1396771119556998452804208
,0.1356795797067941178326578
,0.1317947038147779248440372
,0.1280190942291888345216933
,0.1243494145145051660295010
,0.1207823750513465216327447
,0.1173147268049409136514427
,0.1139432559826696750304720
,0.1106647799453493868915288
,0.1074761447678186515597432
,0.1043742248584169224345786
,0.1013559250393787219968189
,0.0950195419057262152806587
,0.0955579896286446045516882
,0.0927723758424128935873298
,0.0900584520036780827867418
,0.0874134138758224932264085
,0.0848345664921771325239774
,0.0823193483317909563412584
,0.0798653576605684312195166
,0.0774703802522828943732947
,0.0751324175320370324371311
,0.0728497140393899178523185
,0.0706207830006783388032687
,0.0684444287400316486724705
,0.0663197646544195218432094
,0.0642462255355654016097944
,0.0622235731435152039647818
,0.0602518941224580786841791
,0.0583315895947624854511737
,0.0564633560660278074894158
,0.0546481576105125113618222
,0.0528871896675572397694687
,0.0511818351478836031098751
,0.0495336139044958018162745
,0.0479441269462915764520972
,0.0464149970440803777416150
,0.0449478075812886623818798
,0.0435440416214901426794626
,0.0422050231930202468522140
,0.0409318627239100979453568
,0.0397254084008973815111965
,0.0385862049830730594046635
,0.0375144612880339151095299
,0.0365100272048754850851005
,0.0355723806955667368190355
,0.0347006248470151171248155
,0.0338934946527039496211309
,0.0331493728551797359194175
,0.0324663138852788676902428
,0.0318420747026234712828696
,0.0312741511813264469465956
,0.0307598185967011168717722
,0.0302961747501177512675863
,0.0298801843131867271574631
,0.0295087230695252576706533
,0.0280837532508355358640273
,0.0272894089344276127850897
,0.0265177311546549755727487
,0.0257680809878366653964399
,0.0250398377814083673842394
,0.0243323986420057869484168
,0.0235578577327983061662220
,0.0228898743485190861446377
,0.0222409805630815436694458
,0.0216992190303174695142907
,0.0210873444080493105401430
,0.0204930025949836558396555
,0.0199157018775682655153947
,0.0193549647060947752064131
,0.0188103273001080338600044
,0.0182813392636765187360126
,0.0177675632094712217246002
,0.0172685743903848894220676
,0.0167839603371674715714956
,0.0163133205002554231011214
,0.0158562658936416064903163
,0.0154124187382804634510736
,0.0149814121021738209937890
,0.0145628895339707676442886
,0.0141565046866877347619962
,0.0137619209280757052310529
,0.0133788109343060367117939
,0.0130068562641037950566858
,0.0126457469113216633416208
,0.0122951808353117097299956
,0.0119548634703958104458232
,0.0116245072183084486444615
,0.0113038309306954711658255
,0.0109925593925421279800636
,0.0106904228216421794128710
,0.0103971564036858879487291
,0.0101124998869286594760375
,0.0098361972643091020312989
,0.0095679965738549536263813
,0.0093076498497542022036999
,0.0090549132560884156017966
,0.0088095474324966158152783
,0.0085713180756454183939486
,0.0083399967721727204239546
,0.0081153620878041520664281
,0.0076687404846446380682345
,0.0076853099777059218425390
,0.0074794976850462184178592
,0.0072795858900613413453029
,0.0070854118683712687815079
,0.0068968301992887032225710
,0.0067137145321341977835528
,0.0065359591274110522343688
,0.0063634800741273816679366
,0.0061962160917439649057692
,0.0060341288384400219857451
,0.0058772026668773994298456
,0.0057254437937647017359266
,0.0055788788799292360343074
,0.0054375530442621611282306
,0.0053015273783692884804197
,0.0051708760500632066497984
,0.0050456831201467931477533
,0.0049260392195229155826164
,0.0048120382514120901840116
,0.0047037742945870136129782
,0.0046013388861435508547792
,0.0045048188567844340418622
,0.0044142948785823596727362
,0.0043298408956514208151267
,0.0042515245230460860584309
,0.0041794085350020590552411
,0.0041135535686585532333392
,0.0040540220493818293623356
,0.0040008834680444011963618
,0.0039542210814687084666219
,0.0039141401498608207817909
,0.0038807778825231181371591
,0.0038543153459870242716345
,0.0038349917091677720830389
,0.0038231213717286466335921
,0.0038191147632924381249975
,0.0038235039406587841698260
,0.0038369745914635859478092
,0.0038604067445795089801031
,0.0038949275003960942033443
,0.0039419808856679724312633
,0.0040034220605946156668065
,0.0040816467194535153983903
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0358489319246111243222330
,0.0716978638492222486444660
,0.1075467957738333729666991
,0.1433957276984444972889321
,0.1792446596230556354889529
,0.2150935915476667736889738
,0.2509425234722779118889946
,0.2867914553968890500890154
,0.3226403873215001882890363
,0.3584893192461113264890571
,0.3943382511707224646890779
,0.4301871830953336028890988
,0.4660361150199447410891196
,0.5018850469445558237779892
,0.5377339788691669619780100
,0.5735829107937781001780309
,0.6094318427183892383780517
,0.9393739013833554141186255
,0.9126962431394680663743202
,0.8867753539921983119143079
,0.8615897615296049805166945
,0.8371186025675151354263903
,0.8133416058706349760498711
,0.7902390753649070065378623
,0.7677918738273220577994493
,0.7459814070398087526569952
,0.7247896083942316769466174
,0.7041989239358972252347257
,0.6841922978333656590876899
,0.6647531582626927670887085
,0.6458654036945653542645118
,0.6275133895730974353810439
,0.6096819153752826014880384
,0.5923562120403204067642378
,0.5755219297581122273044230
,0.5591651261062582367600271
,0.5432722545247191670014786
,0.5278301531169953264566175
,0.5128260337661131318398589
,0.4982474715528179554091537
,0.4841132137879556318615926
,0.4703506060728795401537639
,0.4569783475154843843668573
,0.4439853620570078929219449
,0.4313608878907663757296120
,0.4190944685494514265755583
,0.4071759442458354194549486
,0.3955954434597721558475314
,0.3843433747646050058222045
,0.3734104188862865658649071
,0.3627875209887330143487816
,0.3524658831791147584056034
,0.3424369572269913009066045
,0.3326924374913682869170373
,0.3232242540499241090223848
,0.3140245660248053294338888
,0.3050857550995240141666898
,0.2964004192215767830020923
,0.2868681849519304494222638
,0.2786633722944180102665257
,0.2717943580704856310070738
,0.2640530166818580992682541
,0.2565311759578638994838684
,0.2492226089087852536341217
,0.2421212654694833710244950
,0.2352212674835467975942294
,0.2285169038152682075004662
,0.2220026255786793079050057
,0.2156730414708527832079454
,0.2095229131942045464054303
,0.2035471509495570818781829
,0.1977408089782614619700496
,0.1920990811277684395808052
,0.1866172964107768172947743
,0.1812909145236903385445260
,0.1761155212858332430592156
,0.1710868239571736171278360
,0.1662006463897057473300123
,0.1614529239668769378113211
,0.1568396982873414280401647
,0.1523571115548388588134543
,0.1480014006461360387412185
,0.1437688908447071201024414
,0.1396559892500035815476878
,0.1356591779013478493709499
,0.1317750066918114415503993
,0.1280000861904801723323288
,0.1243310805401247054469138
,0.1207647006495143754412069
,0.1172976979526329510683524
,0.1139268590572318773368465
,0.1106490016481582600027522
,0.1074609720419237024469084
,0.1043596448030714302079858
,0.1013419248253374649326730
,0.0950043284328714321418374
,0.0955451105107130854721120
,0.0927600377765767092341775
,0.0900466417952900666232807
,0.0874021181758447424092751
,0.0848237718314765326566018
,0.0823090411926874765402573
,0.0798555245874531943739427
,0.0774610080009243556764531
,0.0751234932546854250468016
,0.0728412255001011227362184
,0.0706127188125800914209051
,0.0684367786137330125217915
,0.0663125196446063686073202
,0.0642393782712237793042220
,0.0622171180263386483511034
,0.0602458274779615263194721
,0.0583259097615258376157144
,0.0564580634103540035528823
,0.0546432544565743638642630
,0.0528826801367189291980253
,0.0511777249051527730050459
,0.0495299098147641073119907
,0.0479408366478885281103395
,0.0464121284518995008694375
,0.0449453683360440878202802
,0.0435420385052381619939155
,0.0422034615336857391043601
,0.0409307458130064999446418
,0.0397247369488074875132355
,0.0385859766351458258193396
,0.0375146702224127895353156
,0.0365106638295580598896350
,0.0355734314579224247809819
,0.0347020721641283225178398
,0.0338953169657624300836751
,0.0331515448059929163093784
,0.0324688066081665061002326
,0.0318448562206034013755129
,0.0312771868919327969416067
,0.0307630718300068647930168
,0.0302996073796759322893646
,0.0298837573996447690427569
,0.0289064490579011498794237
,0.0280892044673927629427901
,0.0272952890146755389189082
,0.0265240453672802266316122
,0.0257748349986867686389758
,0.0250470376616938918135080
,0.0243400508771678646124936
,0.0235659560532412611089104
,0.0228984378955469150551671
,0.0222500169622878649078324
,0.0217087541748807733021920
,0.0210973709100390552362292
,0.0205035296537459388321878
,0.0199267391908282513746098
,0.0193665224856662820940301
,0.0188224162886505980152307
,0.0182939707525277828192856
,0.0177807490575687572598174
,0.0172823270442740289931649
,0.0167982928520682660289420
,0.0163282465621339134553835
,0.0158717998421975224621061
,0.0154285755907289986316178
,0.0149982075776650455173344
,0.0145803400784640328075037
,0.0141746274980877277199776
,0.0137807339814536838201731
,0.0133983330070895269997555
,0.0130271069612386894420730
,0.0126667466906130767034799
,0.0123169510334557134878519
,0.0119774263306428076225618
,0.0116478859212665857708613
,0.0113280496304944272578652
,0.0110176432614281054334082
,0.0107163981070385345290008
,0.0104240505027848977259719
,0.0101403414449086383408716
,0.0098650163032025593029539
,0.0095978246598144526663399
,0.0093385203068421379635211
,0.0090868614346216475957663
,0.0088426110392826468009631
,0.0086055375720528563820988
,0.0083754158438158702454368
,0.0081520281867265027148095
,0.0079351658605622023279214
,0.0077246306756671746784892
,0.0075202367876524445905462
,0.0073218126026192344862897
,0.0071292027166007347627197
,0.0069422698007506342468553
,0.0067608963358331639753596
,0.0065849860960845241555917
,0.0064144652857148166599788
,0.0062492832404033252929887
,0.0060894126219569449237623
,0.0059348490564991663101524
,0.0057856101954348272339845
,0.0056417342018588315447070
,0.0055032777133671847633045
,0.0053703133507382915315387
,0.0052429268843852475101563
,0.0051212141967171432438422
,0.0050052782014883253139392
,0.0048952258986698230294743
,0.0047911657524907259875224
,0.0046932055811865231592650
,0.0046014511399833464208586
,0.0045160056028079919102081
,0.0044369700519125542664822
,0.0043644451392852246299214
,0.0042985341023064546628341
,0.0042393471704336299632487
,0.0041870075671530306710144
,0.0041416592428494694924646
,0.0041034765347601406815237
,0.0040726760308015330994125
,0.0040495310296043592057647
,0.0040343891579377368777903
,0.0040276939506249057748599
,0.0040300115481760896002372
,0.0040420641713849111975598
,0.0040647727652071436593717
,0.0040993122870259116399816
,0.0041471847443154581658309
,0.0042103178968700269088621
,0.0042912012708820335138427
,0.0043930774633701361042704
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0345378438560766110043687
,0.0690756877121532220087374
,0.1036135315682298330131061
,0.1381513754243064440174749
,0.1726892192803830550218436
,0.2072270631364596660262123
,0.2417649069925362770305810
,0.2763027508486128880349497
,0.3108405947046894990393184
,0.3453784385607661100436871
,0.3799162824168427210480559
,0.4144541262729193320524246
,0.4489919701289959430567933
,0.4835298139850725540611620
,0.5180676578411491650655307
,0.5526055016972257760698994
,0.5871433455533023870742682
,0.6216811894093789980786369
,0.9666618955603807350485113
,0.9392101709016285049358430
,0.9125371790684484452071956
,0.8866208245025771761405053
,0.8614396385486230434125332
,0.8369727616728405150681169
,0.8131999261872702167153193
,0.7901014394650307526291044
,0.7676581676329824466264995
,0.7458515197283952513629401
,0.7246634323066329930185248
,0.7040763544872865598023282
,0.6840732334265282599261582
,0.6646375002038285018102215
,0.6457530561115036871200346
,0.6274042593358529762426201
,0.6095759120188997126632557
,0.5922532476899459163988126
,0.5754219190562525065857358
,0.5590679861421734564430608
,0.5431779047659215375887243
,0.5277385153428335584635533
,0.5127370320034202455516947
,0.4981610320136336533813903
,0.4840292684919935695120330
,0.4702690818692704666226234
,0.4568991768102110828664308
,0.4439084792055590922288388
,0.4312862291437395412252442
,0.4190219719997238523312433
,0.4071055497772581022175586
,0.3955270926973482592536868
,0.3842770110261068405854701
,0.3733459871352749481765443
,0.3627249677889357593052466
,0.3524051566501293364375158
,0.3423780070012758525166419
,0.3326352146724837477442804
,0.3231687111719954708100033
,0.3139706570131706730997223
,0.3050334352325395070870684
,0.2963496450935539927584728
,0.2868189976440734811902189
,0.2786156490410962582870980
,0.2717479733519062023994195
,0.2640080165360808583940866
,0.2564875230411125528462435
,0.2491802669935329339612196
,0.2420801994148833458098125
,0.2351814432069485316656454
,0.2284782882648533908209743
,0.2219651867072574003003638
,0.2156367482108722533062917
,0.2094877354340426989232071
,0.2035130595111581119915911
,0.1977077755961982874488569
,0.1920670784297936195539336
,0.1865862978999169585758722
,0.1812608945619045841546324
,0.1760864550792071991924814
,0.1710586875425508801562557
,0.1661734166225593001264826
,0.1614265785100984229583077
,0.1568142156004747600483995
,0.1523324708831099438821610
,0.1479775820084429094336542
,0.1437458750195423073936496
,0.1396337577581139022253609
,0.1356377129838053641197604
,0.1317542912821096090514317
,0.1279801038793172140994869
,0.1243118155317021189532056
,0.1207461377085100179273880
,0.1172798223415038310069036
,0.1139096564641720876753794
,0.1106324581068696133456797
,0.1074450738453094217339512
,0.1043443784139943958377827
,0.1013272767886089498201585
,0.0949884220990575983689652
,0.0955316587446995574284259
,0.0927471637394699094381068
,0.0900343316963304052258366
,0.0873903580825888676164581
,0.0848125477104153535634623
,0.0822983389894271638587142
,0.0798453303481607562508415
,0.0774513080343651322268173
,0.0751142743314764105289072
,0.0728324750829260764151130
,0.0706044253082384054565068
,0.0684289316352218318639800
,0.0663051102691761123919534
,0.0642323992786956593503689
,0.0622105641011069313006665
,0.0602396953581632033092319
,0.0583201983199275325597810
,0.0564527736536116486742998
,0.0546383894326169239352708
,0.0528782447439789179965963
,0.0511737256020286593316548
,0.0495263542328057831953814
,0.0479377331174542231639890
,0.0464094854541178200579843
,0.0449431938994998003700232
,0.0435403395695794226405440
,0.0422022433050541559418356
,0.0409300111376275366215083
,0.0397244857311303128932778
,0.0385862053255734416268297
,0.0375153713969916188797349
,0.0365118258801725714679520
,0.0355750384068077366017668
,0.0347041036111705586408860
,0.0338977481714290082570606
,0.0331543469071481147758540
,0.0324719469587861075954294
,0.0318482988447594123071482
,0.0312808930325753284384938
,0.0307670005741502473883831
,0.0303037163386622211691535
,0.0297531747404643845400507
,0.0289123863722713751733817
,0.0280956091633717021383010
,0.0273021668598512658177047
,0.0265314025646686685311337
,0.0257826781959310455394352
,0.0250553739610144612925957
,0.0243488878461071457659504
,0.0235752865622984864035772
,0.0229082840971577619826327
,0.0222603877085776960531582
,0.0217196792288448098373621
,0.0211088418891346406291998
,0.0205155571939996811403617
,0.0199393344954470544405645
,0.0193796973440906461494393
,0.0188361830969047266970406
,0.0183083425349101179546718
,0.0177957394897133337752226
,0.0172979504775945085170985
,0.0168145643395725408186792
,0.0163451818855674321784299
,0.0158894155404404741060986
,0.0154468889893360529497190
,0.0150172368194035742855474
,0.0146001041546823997346882
,0.0141951462807402128268874
,0.0138020282556361329612260
,0.0134204245040169985181411
,0.0130500183917435143982066
,0.0126905017794821158710894
,0.0123415745552827704062393
,0.0120029441483669972734472
,0.0116743250292160091058369
,0.0113554382045619479263410
,0.0110460107199616026918410
,0.0107457751871017932049357
,0.0104544693575831029730416
,0.0101718357692920334522935
,0.0098976214951591919705143
,0.0096315780266080126825745
,0.0093734613248019713754866
,0.0091230320714074004950778
,0.0088800561465945393457844
,0.0086443053551226202435576
,0.0084155584116101193187243
,0.0081936021835303605304057
,0.0079782331757044175346572
,0.0077692592237083649142626
,0.0075665013467709632891123
,0.0073697956942654395742776
,0.0071789955055389237381647
,0.0069939729920097384527344
,0.0068146210431599459761420
,0.0066408546574818674151919
,0.0064726120043175558449455
,0.0063098550344578537354967
,0.0061525695762727778542756
,0.0060007648811620231329989
,0.0058544726007702160147650
,0.0057137452324465595049352
,0.0055786540827514330409542
,0.0054492868478153632869065
,0.0053257449385205237607499
,0.0052081407062386118542174
,0.0050965947487059517009844
,0.0049912334915270771540374
,0.0048921872487052483341463
,0.0047995889654720083616901
,0.0047135738871569828403740
,0.0046342802887161423097684
,0.0045618514779725682223299
,0.0044964393230423511937932
,0.0044382093793568118400561
,0.0043873479154982724520506
,0.0043440710612290874687025
,0.0043086363891840671544453
,0.0042813573586983622032420
,0.0042626212173306086625213
,0.0042529112007206716986052
,0.0042528342296823135743056
,0.0042631558265968476362229
,0.0042848447418086512902824
,0.0043191309236556719303168
,0.0043675821930068007073467
,0.0044322076437143193353152
,0.0045156003045607124093963
,0.0046211381018391286049085
,0.0047532732228351970427127
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0333352143216332358344189
,0.0666704286432664716688379
,0.1000056429648997075032568
,0.1333408572865329433376758
,0.1666760716081661652943069
,0.2000112859297993872509380
,0.2333465002514326092075692
,0.2666817145730658311642003
,0.3000169288946990531208314
,0.3333521432163322750774626
,0.3666873575379654970340937
,0.4000225718595987189907248
,0.4333577861812319409473560
,0.4666930005028651629039871
,0.5000282148244984403717694
,0.5333634291461316623284006
,0.5666986434677648842850317
,0.6000338577893981062416628
,0.6333690721110313281982940
,0.9947315221838608501059298
,0.9664835544932838251597218
,0.9390369125884462375708495
,0.9123688599176936753210043
,0.8864573050144933796801183
,0.8612807831995977769778960
,0.8368184388031163489785058
,0.8130500078918506678959943
,0.7899558014876972844575675
,0.7675166892633336068740846
,0.7457140837018126910962224
,0.7245299247071116388596579
,0.7039466646530282423199765
,0.6839472538582344052215944
,0.6645151264756135045530527
,0.6456341867843552462247203
,0.6272887958735777758079166
,0.6094637587064876127485036
,0.5921443115542941448836700
,0.5753161097892023345679036
,0.5589652160258066215803296
,0.5430780886000904361665675
,0.5276415703748900121183851
,0.5126428778601384017576947
,0.4980695906353221902307382
,0.4839404679674045861581533
,0.4701828448137808091900069
,0.4568154317221594928888351
,0.4438271566474872309449040
,0.4312072616848506845244060
,0.4189452941600029234336944
,0.4070310979732051359647471
,0.3954548051892819993113903
,0.3842068278669942826830663
,0.3732778501210424759726436
,0.3626588204102222934288591
,0.3523409440454429164546468
,0.3423156759115104086355075
,0.3325747133967655866371160
,0.3231099895248186748553110
,0.3139136662827904378225696
,0.3049781281405916644189347
,0.2962959757558727424964218
,0.2867670094512336231851179
,0.2785652122554166942869358
,0.2716989553507292987077903
,0.2639604659514211970616770
,0.2564414004124045409760413
,0.2491355340433362708374432
,0.2420368190176372114041925
,0.2351393793588801295335600
,0.2284375060550683789184490
,0.2219256522900609485127177
,0.2155984287793754339279673
,0.2094505991951216561375304
,0.2034770756618398956927507
,0.1976729143015505951730404
,0.1920333108023885015924748
,0.1865535959809239141549142
,0.1812292313038311175610318
,0.1760558043302593023149427
,0.1710290240325019472944490
,0.1661447159499195858067822
,0.1613988171302395413508890
,0.1567873708142055455549979
,0.1523065208250172497539410
,0.1479525056341075561761045
,0.1437216520905490457771236
,0.1396103688235887096968924
,0.1356151393570859120529803
,0.1317325150110987275198227
,0.1279591077091172535151742
,0.1242915828583237847215770
,0.1207266525228003900549467
,0.1172610691629772938782139
,0.1138916202651465287010168
,0.1106151242281964985902931
,0.1074284279060050417697880
,0.1043284062181670940328004
,0.1013119642341609727420604
,0.0949718068480509963746883
,0.0955176231350201992986726
,0.0927337452609533346992166
,0.0900215159494224537173324
,0.0873781305422775683711123
,0.0848008937740848955932904
,0.0822872440667297977423544
,0.0798347799944604391564340
,0.0774412881267335651003236
,0.0751047712833128738862953
,0.0728234760901892153039938
,0.0705959186172134267600597
,0.0684209068189203656329411
,0.0662975584970993681022122
,0.0642253135629945043350020
,0.0622039395013393586753025
,0.0602335291270153921905361
,0.0583144899735302882359811
,0.0564475249524591590755129
,0.0546336042625357662383401
,0.0528739288909638033286953
,0.0511698864198575978368133
,0.0495230002078943382093357
,0.0479348733410909499941255
,0.0464071290176862674692337
,0.0449413492331846020633179
,0.0435390137490407128084691
,0.0422014413533563434444140
,0.0409297353511160408312541
,0.0397247350578488894745632
,0.0385869748231930792536915
,0.0375166517941759730669915
,0.0365136032610226674011145
,0.0355772940327853670616776
,0.0347068138890211652647366
,0.0339008847694681134110617
,0.0331578770161965463714182
,0.0324758336883621614998852
,0.0318525017401398782834754
,0.0312853686942271488891087
,0.0307717033579472006021849
,0.0306246333242631528503974
,0.0297596411271991434510653
,0.0289193621051529042853545
,0.0281031005573237659123098
,0.0273101807073091763788941
,0.0265399461459049947065214
,0.0257917592902284810441049
,0.0250650008587369327317518
,0.0243590693617252024294473
,0.0235860146143523977113610
,0.0229195842739580747660089
,0.0222722702766569094490201
,0.0217321783574309645992173
,0.0211219481002233033795079
,0.0205292827818251942539884
,0.0199536924018533547153798
,0.0193947011816970084352452
,0.0188518471738837109508147
,0.0183246818814435559474862
,0.0178127698861791847195768
,0.0173156884845185946031343
,0.0168330273293550644608807
,0.0163643880759643881028786
,0.0159093840297459196420071
,0.0154676397931759277565300
,0.0150387909090204073547792
,0.0146224834965704344330595
,0.0142183738774939189691837
,0.0138261281879168886760345
,0.0134454219736425822917525
,0.0130759397660854034123323
,0.0127173746376426349130595
,0.0123694277369424329715564
,0.0120318078067661055757798
,0.0117042306904776502451959
,0.0113864188364805399289459
,0.0110781008144569433071513
,0.0107790108617359815107450
,0.0104888884827916330916286
,0.0102074781291999362037304
,0.0099345289909165915981371
,0.0096697949319432142251118
,0.0094130346038049945295301
,0.0091640117682670989285310
,0.0089224958559528267515448
,0.0086882627798995411966265
,0.0084610960123676394462056
,0.0082407879199276629772486
,0.0080271413363527267109676
,0.0076167962343813375852841
,0.0076191071543990308498340
,0.0074243941822135966004947
,0.0072356959548866553108559
,0.0070528960379611146253032
,0.0068758997133007921168102
,0.0067046353675524463996971
,0.0065390554934558805383338
,0.0063791372298238700061512
,0.0062248823910223431352118
,0.0060763169489558219171776
,0.0059334899918461313922391
,0.0057964721893612259143169
,0.0056653538500339682693063
,0.0055402426882270646574247
,0.0054212614500853345891884
,0.0053085455782593930773583
,0.0052022411182302465831873
,0.0051025030846575990597924
,0.0050094945139587294946626
,0.0049233864898485073247070
,0.0048443593049790813903632
,0.0047726050298847952357839
,0.0047083318234842352900671
,0.0046517701114714990820453
,0.0046031810557981426082486
,0.0045628676601000804635699
,0.0045311889860609856975349
,0.0045085781293534776467680
,0.0044955648517724317372868
,0.0044928041312494526940413
,0.0045011124305503824941099
,0.0045215142843644589784602
,0.0045553029987711627854519
,0.0046041210664211741979135
,0.0046700686882775212238617
,0.0047558531705728128088917
,0.0048649993384996953471600
,0.0050021523780100244846447
,0.0051735238409048563482107
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0322320711904993187357782
,0.0644641423809986374715564
,0.0966962135714979631462285
,0.1289282847619972749431128
,0.1611603559524965867399970
,0.1933924271429958985368813
,0.2256244983334952103337656
,0.2578565695239945498862255
,0.2900886407144938616831098
,0.3223207119049931734799941
,0.3545527830954924852768784
,0.3867848542859917970737627
,0.4190169254764911088706469
,0.4512489966669904206675312
,0.4834810678574897324644155
,0.5157131390479890997724510
,0.5479452102384884115693353
,0.5801772814289877233662196
,0.6124093526194870351631039
,0.6446414238099863469599882
,1.0236042737645387745715198
,0.9945372767595440643972893
,0.9662948450285845369833737
,0.9388535826882353774180956
,0.9121907576434321596181576
,0.8862842827583395921564602
,0.8611126975621075096967161
,0.8366551504744248468625756
,0.8128913815362418526788701
,0.7898017056314641237690921
,0.7673669961858295973655686
,0.7455686693296199596403540
,0.7243886685112191914370783
,0.7038094495489498614304580
,0.6838139661089776000224560
,0.6643856555974216870907867
,0.6455084254551503031294146
,0.6271666398440286505078234
,0.6093451067136415044700470
,0.5920290652377070417244909
,0.5752041736095103718895416
,0.5588564971856997409815904
,0.5429724969676422707820507
,0.5275390184092199064025408
,0.5125432805393939084126487
,0.4979728653869782695196022
,0.4838465387279365370609696
,0.4700916297259878362524432
,0.4567268551568557377606794
,0.4437411451610836499170887
,0.4311237439584941766312909
,0.4188642009404728860921807
,0.4069523620155213738946998
,0.3953783612009729164782357
,0.3841326124539810038527321
,0.3732058017350929346456212
,0.3625888792979325980780914
,0.3522730521987031959696424
,0.3422497770194147248545846
,0.3325107527989270006507638
,0.3230479141660496655852342
,0.3138534246691182527655428
,0.3049196702965709104837799
,0.2962392531831675723807962
,0.2867120679718618281306419
,0.2785119147824973162563822
,0.2716471617776813340938702
,0.2639102276420669523915308
,0.2563926756754273950100753
,0.2490882824414691054659698
,0.2419910013346552868362949
,0.2350949575678114022991849
,0.2283944432876593710890489
,0.2218839128075438260623287
,0.2155579779445961907669016
,0.2094114034460984596908162
,0.2034391024868315023255150
,0.1976361322157134947641310
,0.1919976893260967598653366
,0.1865191056198078067840385
,0.1811958435305540127124857
,0.1760234915679979306180059
,0.1709977596400132082710144
,0.1661144742079670721945917
,0.1613695732290137407893837
,0.1567591008412018427353729
,0.1522792017526390651038781
,0.1479261153060573985573711
,0.1436961692058581763209446
,0.1395857729169541205926919
,0.1355914107740453511397050
,0.1317096348765237068256795
,0.1279370578875647923577930
,0.1242703459049998571117612
,0.1207062116242750282602003
,0.1172414080673691988421226
,0.1138727232022673091504927
,0.1105969758210932352149314
,0.1074110130764227011290757
,0.1043117100896052973357797
,0.1012959720373420163808120
,0.0949544686410126320685876
,0.0955029945062157159529903
,0.0927197761180615226406232
,0.0900081912734412431520425
,0.0873654352090590946566806
,0.0847888126104590494902524
,0.0822757619512584081888917
,0.0798238820041823893269850
,0.0774309597284773276637537
,0.0750949985650178897245155
,0.0728142460243706990397072
,0.0705872193454413904278866
,0.0684127279431934604003729
,0.0662898913615161677892473
,0.0642181515073930314629891
,0.0621972780677796099890742
,0.0602273662002823229055792
,0.0583088258383163485221168
,0.0564423622525733956201144
,0.0546289478513076534604842
,0.0528697855668223970493358
,0.0511662645466370094582409
,0.0495199092254504230625756
,0.0479323231779567038302048
,0.0464051294233654015863877
,0.0449399090529007325112154
,0.0435381401679641524826714
,0.0422011391402244973036773
,0.0409300061325244685095370
,0.0397255766542066873769912
,0.0385883806754009350825640
,0.0375186105066134950591916
,0.0365160982816371618153717
,0.0355803034852611929639288
,0.0347103105655380758665096
,0.0339048362858188692681161
,0.0331622461244145336212163
,0.0324805787358626307792520
,0.0318575772589976061177630
,0.0312907260998223010761699
,0.0315215484108760171655383
,0.0306316755009405812526513
,0.0297672383676314405986929
,0.0289275213249027482453890
,0.0281118291957647946366361
,0.0273194867392247964232865
,0.0265498380940438448438723
,0.0258022462388757811702078
,0.0250760924683669159107602
,0.0243707758848050251576645
,0.0235983269195771255821725
,0.0229325318704524210022822
,0.0222858650639898049627963
,0.0217464595231126357754992
,0.0211369049654840900076547
,0.0205449295578606534740107
,0.0199700440418935504238718
,0.0194117734092474035489939
,0.0188696565129790327919324
,0.0183432456890106898583781
,0.0178321063865925499847265
,0.0173358168064142795228300
,0.0168539675447457182322353
,0.0163861612416678105452750
,0.0159320122311073474052900
,0.0154911461900305753858209
,0.0150631997838157147967530
,0.0146478203045545089799884
,0.0142446652988929105265736
,0.0138534021820852330797447
,0.0134737078352991004187578
,0.0131052681839710031402868
,0.0127477777562790689502847
,0.0124009392226651238982926
,0.0120644629198703671330017
,0.0117380663661731058505788
,0.0114214737783923329234037
,0.0111144156056260830223170
,0.0108166280994072758203650
,0.0105278529446630082777592
,0.0102478369801345704781514
,0.0099763320402493672889310
,0.0097130949522988667410583
,0.0094578877226153892920912
,0.0092104779427133048885779
,0.0089706394409251755811541
,0.0087381531963553159270131
,0.0085128085205026533116568
,0.0082944044977104995630679
,0.0080827516596510811525134
,0.0076809010178644941332915
,0.0076790102308020883811746
,0.0074866173244524086144436
,0.0073003710571524034131374
,0.0071201686554218353644718
,0.0069459303298934228082517
,0.0067776006416608372551202
,0.0066151494704932986903878
,0.0064585725257660098197476
,0.0063078913447005089537578
,0.0061631527932731865887517
,0.0060244280789248936050506
,0.0058918113492492599908568
,0.0057654179835094476053170
,0.0056453827200475207442887
,0.0055318577997011649308168
,0.0054250113359828981696165
,0.0053250261469045294046576
,0.0052320993003227749332251
,0.0051464427095265522990597
,0.0050682849762817864733289
,0.0049978748234732065305885
,0.0049354865570125317983385
,0.0048814277533038765571893
,0.0048360497599152351549945
,0.0047997615250484444368584
,0.0047730474651872644570316
,0.0047564903414732927211528
,0.0047508004895442977957853
,0.0047568533009060224442388
,0.0047757376785741668598351
,0.0048088194275987539150208
,0.0048578254197308105150066
,0.0049249572646935559083747
,0.0050130477549884628826748
,0.0051257806005079271580160
,0.0052680061841171264835904
,0.0054462056211080321632689
,0.0056691894105747190138467
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0312201845430196411879109
,0.0624403690860392823758218
,0.0936605536290589235637327
,0.1248807381720785647516436
,0.1561009227150982059395545
,0.1873211072581178471274654
,0.2185412918011374883153763
,0.2497614763441571295032873
,0.2809816608871767984467738
,0.3122018454301964673902603
,0.3434220299732161363337468
,0.3746422145162358052772333
,0.4058623990592554742207199
,0.4370825836022751431642064
,0.4683027681452948121076929
,0.4995229526883144810511794
,0.5307431372313341499946659
,0.5619633217743538189381525
,0.5931835063173734878816390
,0.6244036908603931568251255
,0.6556238754034128257686120
,1.0533021539165323687825548
,1.0233927171607417605514456
,0.9943317494042251958319412
,0.9660951765905130272926726
,0.9386596076898984231107192
,0.9120023153239230628841483
,0.8861012169401649707367596
,0.8609348565217833648688384
,0.8364823868167603482248751
,0.8127235520722118078396079
,0.7896386712595572232586960
,0.7672086217767857263538644
,0.7454148236144525485613599
,0.7242392239724343427909048
,0.7036642823148722136750166
,0.6836729558510924453784696
,0.6642486854306565158267972
,0.6453753818410105091984974
,0.6270374124965167883516415
,0.6092195885078853789806885
,0.5919071521212324604732657
,0.5750857645161044917614390
,0.5587414939518094980641649
,0.5428608042512695908143883
,0.5274305436112877165655277
,0.5124379337275619672453786
,0.4978705592219217490601579
,0.4837471927607949750971272
,0.4699951573754330147458802
,0.4566331764346463484294247
,0.4436501823930520949090806
,0.4310354217201780580026593
,0.4187784459946117254780518
,0.4068691032513606087306357
,0.3952975295753286544275795
,0.3840541409340149647810847
,0.3731296252427509507754166
,0.3625149346559995433558754
,0.3522012780784294916358590
,0.3421801138896756189211601
,0.3324431428768632179604481
,0.3229823013691632827004696
,0.3137897545687757250298944
,0.3048578900728834417677149
,0.2961793115812142440645971
,0.2866540133726940831060404
,0.2784556023547593572864400
,0.2715924435319036489566713
,0.2638571578180600729623961
,0.2563412102317628726844134
,0.2490383786659950138275832
,0.2419426178096301671693880
,0.2350480541363295927670407
,0.2283489810214055504289377
,0.2218398539759247611868886
,0.2155152859853125546507613
,0.2093700429372311877518342
,0.2033990391205236780702847
,0.1975973327735311979580501
,0.1919601216561469536614482
,0.1864827386156681088280607
,0.1811606471120354167059219
,0.1759894366636987617091847
,0.1709648181715404113845125
,0.1660826190755783915431465
,0.1613387782982921014873767
,0.1567293409301887818774190
,0.1522504526186530537934516
,0.1478983536312000468537775
,0.1436693725799952081612076
,0.1395599198167657151170573
,0.1355664805366021408161714
,0.1316856076657951513109168
,0.1279139146523434744651126
,0.1242480683269567565130131
,0.1206847820552845451658186
,0.1172208094558654795092068
,0.1138529390092256343702815
,0.1105779899272409383392812
,0.1073928096834375761625680
,0.1042942736192856573174126
,0.1012792870339285500325133
,0.0949363959239413746082903
,0.0954877661342063976945838
,0.0927052527874376308680837
,0.0899943573375986821671901
,0.0873522749412908028343594
,0.0847763102695239245676362
,0.0822639018943545491380220
,0.0798126488484487278673996
,0.0774203385591250986541567
,0.0750849751848153557087784
,0.0728048072356587416820162
,0.0705783532523783785350702
,0.0684044242587644318875917
,0.0662821417012566110882332
,0.0642109496500087029158266
,0.0621906201621097026732699
,0.0602212508985063982303032
,0.0583032543370452654984959
,0.0564373382264965056664963
,0.0546244772683202248209078
,0.0528658763788582147791217
,0.0511629262565274078866651
,0.0495171523366953678091384
,0.0479301585409380934144075
,0.0464035674978465137452410
,0.0449389591122184225979730
,0.0435378094747518318285984
,0.0422014321264820163603915
,0.0409309236181463823034399
,0.0397271151375776232494985
,0.0385905317273722153759152
,0.0375213602952214897445771
,0.0365194272495548491463957
,0.0355841861955277852236357
,0.0347147157239853856869338
,0.0339097269412350285633373
,0.0331675800402757431362133
,0.0324863089208036470711960
,0.0318636526373985221050056
,0.0324446647718762623546773
,0.0315292171555758421463977
,0.0306399491134643625622758
,0.0297761244228643071063622
,0.0289370279724985753067035
,0.0281219651731853086118473
,0.0273302613858597276408346
,0.0265612613664806540558772
,0.0258143287273945691573385
,0.0250888454147426102902596
,0.0243842112015063700036777
,0.0236124343225389589362440
,0.0229473453439914994167470
,0.0223013983958220349257395
,0.0217627576183483835425836
,0.0211539558364978626248121
,0.0205627496359753192400888
,0.0199886506118139052612381
,0.0194311846435863272430922
,0.0188898915093075915605514
,0.0183643245095687669687923
,0.0178540501007866843352634
,0.0173586475362130752964074
,0.0168777085130615220331940
,0.0164108368237864156446992
,0.0159576480091969154229137
,0.0155177690107327608676213
,0.0150908378189011614656234
,0.0146765031146241214238257
,0.0142744239001395597371546
,0.0138842691162187805570261
,0.0135057172429049916762001
,0.0131384558818484747239053
,0.0127821813197201497591671
,0.0124365980742198335012860
,0.0121014184269228278895136
,0.0117763619506404647319098
,0.0114611550430525656329994
,0.0111555304829516806902623
,0.0108592270302794603048513
,0.0105719890958759568655445
,0.0102935665110405454719666
,0.0100237144301116003902719
,0.0097621934007291553264674
,0.0095087696356039239087288
,0.0092632155163716034529386
,0.0090253103534840631305691
,0.0087948414166954744231042
,0.0085716052381746184185562
,0.0083554091755706338257026
,0.0081460732051259147207256
,0.0079434318976244443211154
,0.0077473365146018911137071
,0.0075576571453105255080085
,0.0073742847959550302319731
,0.0071971333355715389618057
,0.0070261412032112556189101
,0.0068612727892943840488083
,0.0067025194254570381879876
,0.0065498999102845140846130
,0.0064034605817045314735125
,0.0062632749249645989358948
,0.0061294427807095626728473
,0.0060020892509249617469136
,0.0058813634404232349034425
,0.0057674372157131108262984
,0.0056605042020150776391207
,0.0055607792730056563451635
,0.0054684988158219816067884
,0.0053839221682562407242378
,0.0053073344687483148263141
,0.0052390513506147375413780
,0.0051794260556235508993761
,0.0051288592624286182680704
,0.0050878124389607181851658
,0.0050568254772600804494709
,0.0050365396589303499871870
,0.0050277273950136000188471
,0.0050313307543508253849573
,0.0050485116425313747781645
,0.0050807177689022875455294
,0.0051297704767379317600251
,0.0051979834941740391332510
,0.0052883263290579938381564
,0.0054046534678036444940274
,0.0055520326474802553229360
,0.0057372260386166990323020
,0.0059694124254744606802858
,0.0062612992684150711036883
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0302920052719442764455060
,0.0605840105438885528910120
,0.0908760158158328223976241
,0.1211680210877771057820240
,0.1514600263597213891664239
,0.1817520316316656725508238
,0.2120440369036099559352238
,0.2423360421755542393196237
,0.2726280474474985227040236
,0.3029200527194427783328479
,0.3332120579913870339616722
,0.3635040632633312895904965
,0.3937960685352755452193207
,0.4240880738072198008481450
,0.4543800790791640564769693
,0.4846720843511083121057936
,0.5149640896230526232457692
,0.5452560948949969343857447
,0.5755481001669412455257202
,0.6058401054388855566656957
,0.6361321107108298678056713
,0.6664241159827741789456468
,1.0838476823360192469181129
,1.0530717566101446269755115
,1.0231688859703984562088408
,0.9941142988313697026470095
,0.9658839264225144161102321
,0.9384543828507347917877723
,0.9118029457291296768772781
,0.8859075373559079924490334
,0.8607467064279542556803904
,0.8362996102739751469457019
,0.8125459975925963806986374
,0.7894661916812244495389450
,0.7670410741418914879474755
,0.7452520690507306033723012
,0.7240811275781167122289617
,0.7035107130468911673659704
,0.6835237864164839249880856
,0.6641037921810661881494298
,0.6452346446702273974338482
,0.6269007147409475511068422
,0.6090868168498986268133422
,0.5917781964953033879694999
,0.5749605180176979857264996
,0.5586198527489484311203682
,0.5427426674987472221545204
,0.5273158133674908931709524
,0.5123265148738949115170271
,0.4977623593848263805483612
,0.4836421268607400958394749
,0.4698931338420986869586216
,0.4565341106770238188694577
,0.4435539922701717263642252
,0.4309420274730413336072843
,0.4186877701800921780517228
,0.4067810706780240481705846
,0.3952120672411155166692254
,0.3839711779657334900228705
,0.3730490928373328962663891
,0.3624367660234661947527002
,0.3521254083865253403651252
,0.3421064802101182467097829
,0.3323716841331734173081713
,0.3229129582860257863252684
,0.3137224696228964604394207
,0.3047926074453034539502028
,0.2961159771110485894318742
,0.2865926781332679973424149
,0.2783961133562550815945258
,0.2715346444845652129629343
,0.2638011059883598741215849
,0.2562868591032413378982824
,0.2489856831312627361008083
,0.2418915341335465263306048
,0.2349985399205493930008259
,0.2283009951703310058679364
,0.2217933566641178411149582
,0.2154702386264304991847496
,0.2093264081545644084147995
,0.2033567807192201426502720
,0.1975564157145955623828826
,0.1919205120322945157251837
,0.1864444036290895112539800
,0.1811235550540931660279398
,0.1759535568965081842041087
,0.1709301211112973784000957
,0.1660490761773746326568357
,0.1613063620419982191478425
,0.1566980248067974257342172
,0.1522202111162574977853978
,0.1478691622195528743155535
,0.1436412076923655467552976
,0.1395327588276103203401846
,0.1355403017334300685980963
,0.1316603902135595471900587
,0.1278896385487821862891877
,0.1242247143475671972145946
,0.1206623316870722439908548
,0.1171992448196865349574480
,0.1138322427714305862256339
,0.1105581452024145816537271
,0.1073737999312560087439294
,0.1042760825398073160075185
,0.1012618984669019783773081
,0.0949175801628097531859041
,0.0954719342384204305851370
,0.0926901749608077807351947
,0.0899800173008033082888701
,0.0873386563654209302498543
,0.0847633968524256764531799
,0.0822516774873269240764273
,0.0798010976341237826536812
,0.0774094452780815095449540
,0.0750747254048302475881727
,0.0727951876537002440237245
,0.0705693520157310710816390
,0.0683960312883392096416912
,0.0662743489974376570605941
,0.0642037515595998420359081
,0.0621840135842805855070914
,0.0602152354082776605781469
,0.0582978322068791535159882
,0.0564325143299853684841771
,0.0546202588546943618164065
,0.0528622727128795488749091
,0.0511599481250111162711214
,0.0495148114300465874704216
,0.0479284667252834958861563
,0.0464025360001268372123207
,0.0449385976465405609370229
,0.0435381253429624193174163
,0.0422024293289775601079050
,0.0409326020121394684725402
,0.0397294696792763607495758
,0.0385935518318233916623683
,0.0375250293430681447492958
,0.0365237222639473307905789
,0.0355890777052745854724947
,0.0347201678211790099037870
,0.0339156975335063032295224
,0.0331740212899740774532553
,0.0324931678561838493957126
,0.0333947489584173681786972
,0.0324530152662824977749523
,0.0315382267709875471761727
,0.0306496261487204622875336
,0.0297864778076803449202714
,0.0289480672821366032121393
,0.0281337006443461816462825
,0.0273427039338771868393074
,0.0265744226039046765874829
,0.0258282209840594578764694
,0.0251034817594240865223920
,0.0243996054652819982511147
,0.0236285749619487943362639
,0.0229642714532396867432862
,0.0223191259493237051381165
,0.0217813380391094560395437
,0.0211733757196374758335899
,0.0205830279893147866099312
,0.0200098074284600566108416
,0.0194532409442697042101234
,0.0189128693878981637976899
,0.0183882471819609288887776
,0.0178789419573386586248542
,0.0173845341979134669629925
,0.0169046168915776180707855
,0.0164387951855262011424674
,0.0159866860434926955081281
,0.0155479179022329980219830
,0.0151221303242488318979708
,0.0147089736435157061866796
,0.0143081086009175153378470
,0.0139192059662744272580115
,0.0135419461443866042532624
,0.0131760187635135226497107
,0.0128211222462740973698780
,0.0124769633651819703695773
,0.0121432567879738283894708
,0.0118197246215548459891131
,0.0115060959676860814770993
,0.0112021065083153618935352
,0.0109074981434195798779552
,0.0106220187089735365604248
,0.0103454218067419185383971
,0.0100774667804181088104354
,0.0098179188734666897331316
,0.0095665496029109127473777
,0.0093231373787264031072208
,0.0090874683913619858088850
,0.0088593377793242753664993
,0.0086385510757606264603536
,0.0084249259164818519896034
,0.0082182939747735030133757
,0.0080185030730750804506268
,0.0076580551984865071618591
,0.0076389297670546342511333
,0.0074589437722281104470312
,0.0072853958474911025347542
,0.0071182470308656323881857
,0.0069574864371824982414716
,0.0068031323249290731602912
,0.0066552327729598780362008
,0.0065138659364007258159579
,0.0063791399398561753411596
,0.0062511924991473493545824
,0.0061301904062052115992887
,0.0060163290637319658329951
,0.0059098323045006827605730
,0.0058109527753280121667445
,0.0057199732070993269950065
,0.0056372090427221754199705
,0.0055630127218851818313161
,0.0054977801697976584269223
,0.0054419602424227346906815
,0.0053960675675025267933327
,0.0053606998928690053132784
,0.0053365610494125218996042
,0.0053244910700711205533975
,0.0053255056078855998388799
,0.0053408476707365887953260
,0.0053720560002974357405314
,0.0054210564120269841975608
,0.0054902854729452490664676
,0.0055828606727868429829287
,0.0057028188430374620113139
,0.0058554569137196192663009
,0.0060478295940825411991515
,0.0062894938998012987416142
,0.0065936514706407284985845
,0.0069789506870911802161039
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0294406087628592341709499
,0.0588812175257184683418998
,0.0883218262885777094517437
,0.1177624350514369366837997
,0.1472030438142961639158557
,0.1766436525771553911479117
,0.2060842613400146183799677
,0.2355248701028738456120237
,0.2649654788657330728440797
,0.2944060876285923278317114
,0.3238466963914515828193430
,0.3532873051543108378069746
,0.3827279139171700927946063
,0.4121685226800293477822379
,0.4416091314428886027698695
,0.4710497402057478577575012
,0.5004903489686071127451328
,0.5299309577314663677327644
,0.5593715664943256227203960
,0.5888121752571848777080277
,0.6182527840200441326956593
,0.6476933927829033876832909
,0.6771340015457626426709226
,1.1152638991121717193522045
,1.0835967816630043270009764
,1.0528280062923702775634638
,1.0229320840035849293769843
,0.9938842489675099312051998
,0.9656604380072709714610824
,0.9382372706654842353657386
,0.9115920298374988739453784
,0.8857026429546873691478481
,0.8605476637022648755959153
,0.8361062542565614874590096
,0.8123581680271362293055404
,0.7892837328895387916105619
,0.7668638348949419203393063
,0.7450799024433036876757797
,0.7239138909070820249169742
,0.7033482676929424526335310
,0.6833659977292615428368094
,0.6639505293675670438702241
,0.6450857806864164212257151
,0.6267561261864820210121252
,0.6089463838658920602497915
,0.5916418026650509531805255
,0.5748280502703002614595107
,0.5584912012657810009841342
,0.5426177256227218137496493
,0.5271944775150867457114146
,0.5122086844499372793038106
,0.4976479367000183340330466
,0.4835310219467144343674647
,0.4697852498607574256439534
,0.4564293581781569408839516
,0.4434522843974914030340528
,0.4308432798922067763491839
,0.4185919010088198777275181
,0.4066880004182280017310802
,0.3951217187130200425571047
,0.3838834762439043424286922
,0.3729639651885726658875342
,0.3623541418465250907310349
,0.3520452191535713981629385
,0.3420286594099277155400785
,0.3322961672159860935238385
,0.3228396826100294325634366
,0.3136513744022906280406460
,0.3047236336999101791178646
,0.2960490676174301061251981
,0.2865278867960361908195921
,0.2783332785938589792884557
,0.2714736012706354673085229
,0.2637419147733554569690284
,0.2562294707650368263962548
,0.2489300500414498296120058
,0.2418376101185533422199825
,0.2349462802242090475601799
,0.2282503564179408639400748
,0.2217442968280409487658034
,0.2154227169933124741429964
,0.2092803852942432263350980
,0.2033122184554201627992853
,0.1975132770974963036803018
,0.1918787613130556457541331
,0.1864040062363942207301903
,0.1810844775727232791595611
,0.1759157670479001844832112
,0.1708935877359318566970359
,0.1660137692187169944357805
,0.1612722525315435639914341
,0.1566650848495721448649931
,0.1521884138759008464614197
,0.1478384819018617180041986
,0.1436116195259433681030714
,0.1395042390400607346112594
,0.1355128275213897393047802
,0.1316339397048283677005287
,0.1278641907549173117875085
,0.1242002491055916174600426
,0.1206388295894546131004077
,0.1171766871324750880489773
,0.1138106113413868136774454
,0.1105374223551504331286566
,0.1073539683636879349393212
,0.1042571252116118868391581
,0.1012437984969896120901467
,0.0948980164548827026527178
,0.0954554985422786800297601
,0.0926745461312109553020377
,0.0899651784242635199628779
,0.0873245905156949109304776
,0.0847500871791386084508346
,0.0822391073580851783564327
,0.0797892508305849679217658
,0.0773983062428911933183784
,0.0750642795324003297974258
,0.0727854216137211323944811
,0.0705602540943586903354756
,0.0683875917284648832117355
,0.0662665603166423394787543
,0.0641966088225879860651446
,0.0621775146060249347956805
,0.0602093808649562037271785
,0.0582926256340475304473792
,0.0564279619912936361569855
,0.0546163694697227586338784
,0.0528590570391140740502678
,0.0511574183962963668914625
,0.0495129806616335099711534
,0.0479273479033775970381548
,0.0464021411811404993486008
,0.0449389369975751254426832
,0.0435392061599472607325012
,0.0422042550720104908679176
,0.0409351713986545046042309
,0.0397327758745983222743448
,0.0385975817734873563602527
,0.0375297632301672956511851
,0.0365291332360384995991964
,0.0355951317274334211315789
,0.0347268237831445739094427
,0.0339229075619974437816317
,0.0331817312646984913238057
,0.0343725899262999831651477
,0.0334038411584191077818851
,0.0324628256840067061506083
,0.0315487645004360606204585
,0.0306609009765764876920269
,0.0297985002298259520070456
,0.0289608485215535095547157
,0.0281472526704919095985602
,0.0273570394836377545066952
,0.0265895552042344010534869
,0.0258441649764292805113719
,0.0251202523262113661117745
,0.0244172186582469127880124
,0.0236470178698741304024189
,0.0229835890080859681083858
,0.0223393366626953929210408
,0.0218025007694031790206335
,0.0211954755395711916254875
,0.0206060869035884809685744
,0.0200338485840499264112324
,0.0194782886825119079532431
,0.0189389493005891230981153
,0.0184153861717405512021806
,0.0179071683026217794154622
,0.0174138776226282730730244
,0.0169351086399584932484785
,0.0164704681021938456608744
,0.0160195746590394497155252
,0.0155820585245241612776246
,0.0151575611356593639017509
,0.0147457348043635739359702
,0.0143462423594486309513796
,0.0139587567757275196611566
,0.0135829607879509317580613
,0.0132185464884233324495133
,0.0128652149089024791378533
,0.0125226755898321662208161
,0.0121906461431524840849372
,0.0118688518188456663265962
,0.0115570250899282803841439
,0.0112549052755844605777646
,0.0109622382271975706696798
,0.0106787761068252405605161
,0.0104042772915975724468129
,0.0101385064397618938208945
,0.0098812347550131275630836
,0.0096322404830808689563115
,0.0093913096697641491178432
,0.0091582372011450325494097
,0.0089328281358062328748604
,0.0087148993234966165566391
,0.0085042812883476953667028
,0.0083008203405218871501203
,0.0081043808580597044566307
,0.0079148476702376301811226
,0.0077321284598274595337153
,0.0075561560955583707485661
,0.0073868908080047734551754
,0.0072243221425389468268174
,0.0070684705864212148476722
,0.0069193888897258713777116
,0.0067771630308853820362502
,0.0066419128831724976239070
,0.0065137926708502104714005
,0.0063929913506017375240953
,0.0062797331148310179746441
,0.0061742782726260389894457
,0.0060769248230912445082885
,0.0059880110939844917450348
,0.0059079200135370773735999
,0.0058370853955920891376064
,0.0057760009390612479171501
,0.0057252329306633244210278
,0.0056854373014054489926528
,0.0056573825666646837886931
,0.0056419802626268122230924
,0.0056403251434055858698491
,0.0056537483212671987148346
,0.0056838878808371778167396
,0.0057327835362227406654223
,0.0058030050298649984638621
,0.0058978288524822357688504
,0.0060214856079997105056667
,0.0061795128866928986446916
,0.0063792692819987133548421
,0.0066307004894008729142807
,0.0070950757635351259164369
,0.0073490019670441886212586
,0.0078630564844950484593156
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0286596432336006512464621
,0.0573192864672013024929242
,0.0859789297008019537393864
,0.1146385729344026049858485
,0.1432982161680032562323106
,0.1719578594016039074787727
,0.2006175026352045587252348
,0.2292771458688052099716970
,0.2579367891024058612181591
,0.2865964323360065124646212
,0.3152560755696071637110833
,0.3439157188032078149575455
,0.3725753620368084662040076
,0.4012350052704091174504697
,0.4298946485040097686969318
,0.4585542917376104199433939
,0.4872139349712110711898561
,0.5158735782048117224363182
,0.5445332214384124291939315
,0.5731928646720130249292424
,0.6018525079056136206645533
,0.6305121511392142163998642
,0.6591717943728148121351751
,0.6878314376064154078704860
,1.1475743682894741226618862
,1.1149906879783326729693727
,1.0833313566097049207570535
,1.0525701473549575748478446
,1.0226815774854718377184781
,0.9936408872631210531523038
,0.9654240194300409694250220
,0.9380075992807512808013826
,0.9113689153001661713560111
,0.8854859003515135329465124
,0.8603371133986512653279988
,0.8359017217477103800504779
,0.8121594837934588140271330
,0.7890907322561856451770268
,0.7666763578953506019786346
,0.7448977936866366666990302
,0.7237369994494561309394953
,0.7031764469123414906803760
,0.6831991052040228273867228
,0.6637884267583544772861615
,0.6449283336215745343622530
,0.6266032041506908178973845
,0.6087978600920334049106941
,0.5914975540292128908248515
,0.5746879571898489968972967
,0.5583551476004362523752889
,0.5424855985786014578309278
,0.5270661675516716826450647
,0.5120840851899478574082991
,0.4975269448422042217750061
,0.4834135423623156513350807
,0.4696711801505754069196996
,0.4563186037630641567197642
,0.4433447534445393301005822
,0.4307388832385238841560238
,0.4184905520877210682861858
,0.4065896151874722197483436
,0.3950262155851574918941083
,0.3837907760186538008717605
,0.3728739909871748858805063
,0.3622668190480137218045797
,0.3519604753329151902718763
,0.3419464242779863827337294
,0.3322163725612369278294977
,0.3227622622420118214670026
,0.3135762640967314496265317
,0.3046507711454822797669806
,0.2959783923641092773237915
,0.2864594557246111783399556
,0.2782669210779461499427612
,0.2714091430915380187549601
,0.2636794197296305486410972
,0.2561688869924034217540054
,0.2488713272591443481651652
,0.2417806995882835208178108
,0.2348911347106434344134129
,0.2281969301507751901603172
,0.2216925454656998861757700
,0.2153725975883586385428714
,0.2092318562605777476637314
,0.2032652395373694964586520
,0.1974678093408787360463208
,0.1918347670383140357586171
,0.1863614490138548462905277
,0.1810433221999933617318845
,0.1758759795293492189660611
,0.1708551352640909348767906
,0.1659766201572966670685361
,0.1612363763995910415083301
,0.1566304523060766396014287
,0.1521549967039171891158844
,0.1478062529909659195137550
,0.1435805528515866624772457
,0.1394743096381764746460874
,0.1354840114564631881055590
,0.1316062140296130056338342
,0.1278375334601036528159312
,0.1241746390580573677908660
,0.1206142464582697360064856
,0.1171531113026307441282725
,0.1137880238162454760164621
,0.1105158046498597307349954
,0.1073333023931935803485516
,0.1042373931783592555522233
,0.1012249827848028943533265
,0.0948777042256944286302556
,0.0954384629103664644533822
,0.0926583742585841835248672
,0.0899498527662069002897027
,0.0873100935588538018539140
,0.0847364015441286061447457
,0.0822262159589223495803623
,0.0797771370909668986470820
,0.0773869543654968627954815
,0.0750536748131238745651572
,0.0727755507883757202236552
,0.0705511057011700970509338
,0.0683791564659492895339454
,0.0662588313735450462615972
,0.0641895821547526362893521
,0.0621711891346188247342575
,0.0602037585715784195894429
,0.0582877115309867119274934
,0.0564237639495667742117746
,0.0546128978933889813740521
,0.0528563243814746952509154
,0.0511554385216112447731795
,0.0495117680644645979937124
,0.0479269168061029759986269
,0.0464025045380313458376342
,0.0449401054405634409194548
,0.0435411869263549120012691
,0.0422070509576754418490374
,0.0409387797808142619992999
,0.0397371878474658268842745
,0.0386027814357293649893954
,0.0375357271576862439044220
,0.0365358301659148149154177
,0.0356025224700766140806252
,0.0347348613701604913561738
,0.0339315376275718394438741
,0.0353789996765100506204149
,0.0343824889620651594213108
,0.0334145227810710085392110
,0.0324742998611970840050489
,0.0315610419606076608722844
,0.0306739932275750075418852
,0.0298124195790788713844588
,0.0289756080979224200921962
,0.0281628664479150955801678
,0.0273735223066913467560024
,0.0266069228157529216738375
,0.0258624340473401458095903
,0.0251394404877527226360723
,0.0244373445367546300588391
,0.0236680670791842191758025
,0.0230056131542209253704190
,0.0223623572072920023812159
,0.0218265850602272597213993
,0.0212206070300529833771996
,0.0206322910930317494904163
,0.0200611523017868859097845
,0.0195067201521905604633123
,0.0189685382095586031747647
,0.0184461637459014567153037
,0.0179391673871164107623155
,0.0174471327687482531676455
,0.0169696561986474175887096
,0.0165063463245199888718151
,0.0160568238040152168333297
,0.0156207209746615921508450
,0.0151976815206871420510515
,0.0147873601336093174474229
,0.0143894221635338659393000
,0.0140035432584630741004172
,0.0136294089896920479071385
,0.0132667144626932072964953
,0.0129151639148518664751419
,0.0125744703041220633882302
,0.0122443548961296642257901
,0.0119245468614628171571956
,0.0116147828997223614283518
,0.0113148069120585954838720
,0.0110243697491681537370400
,0.0107432290665063698287263
,0.0104711493218216985384705
,0.0102079019529590486053960
,0.0099532657728868146468360
,0.0097070276165375276450353
,0.0094689832678053510728322
,0.0092389386865680232785447
,0.0090167115416049711112967
,0.0088021330401684451383293
,0.0085950500328586462717162
,0.0083953273477645803252178
,0.0082028502984948046400371
,0.0080175272938903981156944
,0.0077084686891672011752052
,0.0076681082544995619182382
,0.0075039678302537046045151
,0.0073468973386040092171667
,0.0071969579021038052046855
,0.0070542473743807751138113
,0.0069189018866064218304945
,0.0067910972814655681459306
,0.0066710505774521533517429
,0.0065590216781097696735481
,0.0064553156134140093555529
,0.0063602856766792363260588
,0.0062743379005414136317942
,0.0061979375658253055975111
,0.0061316182394740327554761
,0.0060759942513376507047806
,0.0060317779189802533251763
,0.0059998024836888591906914
,0.0059810528738333422135720
,0.0059767066466695582122037
,0.0059881884413240217893137
,0.0060172426827447018232720
,0.0060660313686586621317876
,0.0061372669693939389812254
,0.0062343954460977232118202
,0.0063618522725531210029737
,0.0065254270734838920250964
,0.0067327935155000471004194
,0.0071711576698552425071509
,0.0073241522036578661850048
,0.0077423226544694077541631
,0.0082775423030825110576325
,0.0089723527744366600444881
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0279432823472428176758697
,0.0558865646944856353517395
,0.0838298470417284530276092
,0.1117731293889712707034789
,0.1397164117362140745015608
,0.1676596940834568782996428
,0.1956029764306996820977247
,0.2235462587779424858958066
,0.2514895411251852896938885
,0.2794328234724280934919705
,0.3073761058196708972900524
,0.3353193881669137010881343
,0.3632626705141565048862162
,0.3912059528613993086842981
,0.4191492352086421124823801
,0.4470925175558849162804620
,0.4750357999031277200785439
,0.5029790822503705793877771
,0.5309223645976134386970102
,0.5588656469448562980062434
,0.5868089292920991573154765
,0.6147522116393420166247097
,0.6426954939865848759339428
,0.6706387763338277352431760
,0.6985820586810705945524091
,1.1808031805943619563237235
,1.1472768829688280156631208
,1.1147016804116380850331325
,1.0830505872912066234192707
,1.0522973836038036488105263
,1.0224165932529303280063004
,0.9933834629452978903785265
,0.9651739416859324016684241
,0.9377646608554842666549689
,0.9111329148532815169758692
,0.8852566422901436693493338
,0.8601144077154581069066808
,0.8356853838634528131024126
,0.8119493344040471516365187
,0.7888865971841122481933439
,0.7664780679453536693657156
,0.7447051845054969421155988
,0.7235499113897989609256456
,0.7029947249003334341921345
,0.6830225986108571234467490
,0.6636169892754184562733144
,0.6447618231392024945591857
,0.6264414826404048897146026
,0.6086407934921839180120173
,0.5913450121339413056986700
,0.5745398135412946860611783
,0.5582112793841278453044197
,0.5423458865219796809498121
,0.5269304958257123860931870
,0.5119523413138641343422819
,0.4973990195912283973633805
,0.4832893351617720267832112
,0.4695505827316673319593576
,0.4562015161341884672552283
,0.4432310785213751103128743
,0.4306285267635779345773983
,0.4183834225522173877465093
,0.4064856237555129481187066
,0.3949252760200963052739098
,0.3836928046116217516647851
,0.3727789064876937952242031
,0.3621745425966465536937733
,0.3518709303958930667555194
,0.3418595365837591160129705
,0.3321320700388961655313835
,0.3226804749615390099926060
,0.3134969242110199338924303
,0.3045738128340950146011323
,0.2959037517787278526171235
,0.2863871928730524207828978
,0.2781968558155584192448373
,0.2713410915317786553657697
,0.2636134491901775955824405
,0.2561049427243433096457181
,0.2488093561923578611594365
,0.2417206502881234786439535
,0.2348329573362369360189916
,0.2281405764149979087385134
,0.2216379685968809520879574
,0.2153197522937917718355294
,0.2091806986919280131331789
,0.2032157272580731310895885
,0.1974199012956346921399131
,0.1917884235247554469694364
,0.1863166316564601743266394
,0.1809999939262507129278390
,0.1758341045481056907906492
,0.1708146790459116326488243
,0.1659375494165086784015273
,0.1611986590774995842245687
,0.1565940575546166946274695
,0.1521198948687517427114102
,0.1477724155927735705251536
,0.1435479525640245834772202
,0.1394429202607820328374544
,0.1354538078806213075022669
,0.1315771721956911777251520
,0.1278096303040081038737696
,0.1241478524458169557798115
,0.1205885551078557799131730
,0.1171284946930768039452531
,0.1137644620852440169311848
,0.1104932784823454694489442
,0.1073117929049051816337013
,0.1042168817999150481901083
,0.1012054511532936434958785
,0.0948566480222565316937633
,0.0954208360715699810405965
,0.0926416725242736882606209
,0.0899340579686014052196441
,0.0872951876140350829791359
,0.0847223665705698486538822
,0.0822130344563723469697436
,0.0797647921791998087970299
,0.0773754300782343445996858
,0.0750429564378429503346268
,0.0727656252380112361644038
,0.0705419618992290387016197
,0.0683707857226221599189486
,0.0662512277273778343866795
,0.0641827426526491162661614
,0.0621651140226479326233999
,0.0601984513704543131029645
,0.0582831789732618441024492
,0.0564200157605047186715197
,0.0546099464040144672027921
,0.0528541839701582236155097
,0.0511541248893427197286243
,0.0495112973582141485673347
,0.0479273046138041780572792
,0.0464037647871616831807273
,0.0449422492394675396343295
,0.0435442213928446952841966
,0.0422109780826317657065339
,0.0409435953752416981199502
,0.0397428806196047784693448
,0.0386093322404863423247257
,0.0375431084540453069431365
,0.0365440057095462178526901
,0.0356114472585777400159834
,0.0347444818478432962405300
,0.0364148139111454202665463
,0.0353897762841140148259989
,0.0343941182645068066481286
,0.0334270157061946349141834
,0.0324876681727288840750845
,0.0315752982791437028509129
,0.0306891510533455480480569
,0.0298284933166121611625154
,0.0289926130827435277192983
,0.0281808189754278945460264
,0.0273924396634072399303594
,0.0266268233130457394886026
,0.0258833370579244735620872
,0.0251613664851024036728244
,0.0244603151376990533838462
,0.0236920663207084852830420
,0.0230307002793545302632428
,0.0223885571157223760285770
,0.0218539748025858016067247
,0.0212491683587753173168000
,0.0206620535936308004354434
,0.0200921471154557884641889
,0.0195389800554315491709634
,0.0190020977003088759049731
,0.0184810591366598234164265
,0.0179754369055945932565077
,0.0174848166665892319759923
,0.0170087968687686712232487
,0.0165469884276579735915558
,0.0160990144050730463187726
,0.0156645096895051023910828
,0.0152431206741116022362892
,0.0148345049293294468234494
,0.0144383308672642162590050
,0.0140542773954842985240088
,0.0136820335587959831386007
,0.0133212981690919440858067
,0.0129717794255949057935506
,0.0126331945307893555446865
,0.0123052693111311110818473
,0.0119877378561826179043104
,0.0116803421948752841202923
,0.0113828320330941618054865
,0.0110949645821633458703248
,0.0108165045119381960508909
,0.0105472240668866810986426
,0.0102869033838934274827093
,0.0100353310505909513322687
,0.0097923049389929076730121
,0.0095576333434376110897990
,0.0093311364394060153371058
,0.0091126480662820884270925
,0.0089020178283484435732831
,0.0086991134807378554111290
,0.0085038235604391783362122
,0.0083160602030105650744884
,0.0081357620755677321350285
,0.0079628973545454381777198
,0.0076980069587954782009409
,0.0076395061098579169350797
,0.0074890896849678515248550
,0.0073463322778653241881819
,0.0072113920447869524210649
,0.0070844730371139733385299
,0.0069658279805784820842840
,0.0068557614882613620438390
,0.0067546340414614304548113
,0.0066628671711446438644111
,0.0065809503821756352298644
,0.0065094506825618837081437
,0.0064490253819198799928314
,0.0064004393574221005516756
,0.0063645885365312361223178
,0.0063425310256398619718210
,0.0063355288333630027305943
,0.0063451036284289637559586
,0.0063731114593356744113528
,0.0064218435330555458800950
,0.0064941634231021208925605
,0.0065936961469400335103530
,0.0067250925607520925519900
,0.0068944054221431435094947
,0.0073101432427884515188876
,0.0073815357141505354154898
,0.0077248452477907923741096
,0.0081601925269531028206416
,0.0087171639956570880214404
,0.0094393750664758524493436
,0.0103931451303181324880009
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0272861817451322818950388
,0.0545723634902645637900775
,0.0818585452353968456851163
,0.1091447269805291275801551
,0.1364309087256614094751939
,0.1637170904707936913702326
,0.1910032722159259732652714
,0.2182894539610582551603102
,0.2455756357061905370553490
,0.2728618174513228189503877
,0.3001479991964550730898509
,0.3274341809415873827404653
,0.3547203626867196923910797
,0.3820065444318520020416940
,0.4092927261769843116923084
,0.4365789079221166213429228
,0.4638650896672489309935372
,0.4911512714123812406441516
,0.5184374531575135502947660
,0.5457236349026458599453804
,0.5730098166477781695959948
,0.6002959983929104792466092
,0.6275821801380427888972235
,0.6548683618831750985478379
,0.6821545436283074081984523
,0.7094407253734397178490667
,1.2149749552326150059400334
,1.1804792875480378810948423
,1.1469622201354157109420839
,1.1143959870268653755687183
,1.0827536100214769643201862
,1.0520088763363011352680587
,1.0221363168917181329931054
,0.9931111852132198380971317
,0.9649094369321683517526367
,0.9375077098685916654474681
,0.9108833046795680177254440
,0.8850141660572261592676568
,0.8598788644608558184856406
,0.8354565783680721891002463
,0.8117270770304287896834694
,0.7886707037192864921948399
,0.7662683594482022630955953
,0.7445014871584646476421199
,0.7233520563548546666865491
,0.7028025481790509676471856
,0.6828359409085029696484526
,0.6634356958689386907224161
,0.6445857437490007946223614
,0.6262704713058122596436306
,0.6084747084505301994994397
,0.5911837157031352152358750
,0.5743831720058403256246038
,0.5580591628845128493452421
,0.5421981689473760468445107
,0.5267870547099567923865493
,0.5118130577346953202777513
,0.4972637780727905965072466
,0.4831580293834021322396666
,0.4694230982306562549588591
,0.4560777472084767691917762
,0.4431109225466400292070546
,0.4305118841081918557023300
,0.4182701964946799466638083
,0.4063757204042937054566664
,0.3948186042358192149315244
,0.3835892759315249200824383
,0.3726784350523051903003591
,0.3620770450786133798359856
,0.3517763259309042989109173
,0.3417677467035063476608059
,0.3320430186060195354436075
,0.3225940881065018639439756
,0.3134131302708672017764968
,0.3044925422930466751836320
,0.2958249372105664631860122
,0.2863108975695040636644251
,0.2781228896194603006364332
,0.2712692603930615398155624
,0.2635438241236729983718590
,0.2560374659479293102393171
,0.2487439717038043562880034
,0.2416573038193756406410984
,0.2347715963094224589369219
,0.2280811499002025344307043
,0.2215804272717572798168106
,0.2152640484050786229275332
,0.2091267860189761074174442
,0.2031635610784758294578012
,0.1973694383530688600814074
,0.1917396219991202577226375
,0.1862694511363778282486692
,0.1809543953839352625756476
,0.1757900503165257255488996
,0.1707721327980552261660563
,0.1658964761463994075363360
,0.1611590250824154468833882
,0.1565558304177260828815577
,0.1520830434411148956996840
,0.1477369099733767676685403
,0.1435137640762454980247753
,0.1394100214234609280694599
,0.1354221723717715375467918
,0.1315467748068754327839258
,0.1277804468835794515779725
,0.1241198598296189420375768
,0.1205617310366339650640199
,0.1171028177167831724192482
,0.1137399114556163215450368
,0.1104698340365681263897102
,0.1072894349447447714940296
,0.1041955909723535078637013
,0.1011852083402229041109166
,0.0948348584142878203717686
,0.0954026324384971841086056
,0.0926244601851270166203989
,0.0899178181468792137032153
,0.0872799016792486781479710
,0.0847080161748773041718863
,0.0821996017353210373102002
,0.0797522600154645378012219
,0.0773637824226660053561488
,0.0750321786771746962463325
,0.0727557045935159629745925
,0.0705328878358348482224827
,0.0683625503438502896136342
,0.0662438261283429807857459
,0.0641761732016028346725633
,0.0621593785414320948445877
,0.0601935551859649753403403
,0.0582791308156889314995297
,0.0564168274896725482903115
,0.0546076325524268504918446
,0.0528527611000355543313667
,0.0511536107705921616606304
,0.0495117099843572008865955
,0.0479286610827839784643167
,0.0464060800830284614360011
,0.0449455349585701005588056
,0.0435484844637857859694918
,0.0422162195324399594498210
,0.0409498091946889353209826
,0.0397500527782618170991036
,0.0386174398970526785990209
,0.0375521194000085906106179
,0.0365538780747625760558783
,0.0356221294965059775972094
,0.0374808927045631665175840
,0.0364265448979419065311802
,0.0354024363194296101675640
,0.0344077193318407734135000
,0.0334415707077538107427905
,0.0325031909531124235668287
,0.0315918036510433875019288
,0.0307066548254043177046402
,0.0298470123235972835396002
,0.0290121652182062303437782
,0.0282014232270391858314884
,0.0274141161511780584447706
,0.0266495933306609353308225
,0.0259072231174430483990889
,0.0251863923653017247883401
,0.0244865059363686861371168
,0.0237194044070804070656333
,0.0230592536448653989689106
,0.0224183546771615609116690
,0.0218851047141183918665064
,0.0212816106147728049957646
,0.0206958425718983471397472
,0.0201273190220503592207102
,0.0195755730236546778011419
,0.0190401518980145394166481
,0.0185206168825659753252033
,0.0180165427953270923522311
,0.0175275177092264894396223
,0.0170531426346973609409208
,0.0165930312085981190861617
,0.0161468093871929840865675
,0.0157141151406373809351624
,0.0152945981462154455277069
,0.0148879194775535031447511
,0.0144937512872687981890785
,0.0141117764811507229172349
,0.0137416883830929724419345
,0.0133831903917846807561265
,0.0130359956326503833440311
,0.0126998266118730617629806
,0.0123744148835389818075203
,0.0120595007457415265977874
,0.0117548329870507343303254
,0.0114601687105242988629072
,0.0111752732669831971595853
,0.0108999203357563762689653
,0.0106338921923555141529905
,0.0103769802050670822968215
,0.0101289856005567068669704
,0.0098897205357655511293036
,0.0096590095025336879241973
,0.0094366910798074164073990
,0.0092226200442484182473457
,0.0090166698189549782105345
,0.0088187352380409700369768
,0.0086287355829974456827847
,0.0084466178359295426142372
,0.0082723600920530503816108
,0.0081059751040530696186703
,0.0079475138210909467700871
,0.0077319133909485252692528
,0.0076547789739829959210216
,0.0075208311413329648198456
,0.0073954661917201847121106
,0.0072789823676019842560447
,0.0071717405865262739625421
,0.0070741706494970241561604
,0.0069867790928506605732662
,0.0069101593653160377564437
,0.0068450054214065142108026
,0.0067921296406406811776990
,0.0067524866754918311251288
,0.0067272055913138815302910
,0.0067176324253414108206295
,0.0067253873124793897911311
,0.0067524412405828180758216
,0.0068012197687896836645338
,0.0068747444179465171457122
,0.0069768276140889512459964
,0.0071123451994739650752764
,0.0072876235897260449245194
,0.0075110000976786788287609
,0.0077936509718260337659101
,0.0081508437847983335883262
,0.0086038807187458106462419
,0.0091831993144970321119036
,0.0099334714155911787991649
,0.0109222562074811398863394
,0.0122551535486992956014429
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0266834391756861424860325
,0.0533668783513722849720651
,0.0800503175270584343969915
,0.1067337567027445699441301
,0.1334171958784307054912688
,0.1601006350541168410384074
,0.1867840742298029765855460
,0.2134675134054891121326847
,0.2401509525811752476798233
,0.2668343917568614109825376
,0.2935178309325475742852518
,0.3202012701082337375879661
,0.3468847092839199008906803
,0.3735681484596060641933946
,0.4002515876352922274961088
,0.4269350268109783907988231
,0.4536184659866645541015373
,0.4803019051623507174042516
,0.5069853443380368807069658
,0.5336687835137230440096801
,0.5603522226894092073123943
,0.5870356618650953706151085
,0.6137191010407815339178228
,0.6404025402164676972205370
,0.6670859793921538605232513
,0.6937694185678400238259655
,0.7204528577435261871286798
,1.2501148406572135662884193
,1.2146223368772732786879942
,1.1801367178928876544574678
,1.1466294152921101545672400
,1.1140726711966628670325008
,1.0824395152667332098417319
,1.0517037423584862931846828
,1.0218398908157544369146308
,0.9928232213779702997058507
,0.9646296966869030153901576
,0.9372359613752557772059504
,0.9106193227206959006636566
,0.8847577318493372589003343
,0.8596297654731788195903164
,0.8352146081464484339562659
,0.8114920350262406767427592
,0.7884423951232839566927169
,0.7660465950290712422443562
,0.7442860831060206239229160
,0.7231428341277206239823272
,0.7025993343566937499033997
,0.6826385670475152434022448
,0.6632439983634424995884160
,0.6443995636950640149009928
,0.6260896543697732630207042
,0.6082991047411276941403457
,0.5910131796473567789007575
,0.5742175622284061420330659
,0.5578983420909248147623316
,0.5420420038104739601791948
,0.5266354157599451024651671
,0.5116658192526171156089276
,0.4971208179874544996756924
,0.4830192353129462712324482
,0.4692883491776705939813041
,0.4559469314474607348763868
,0.4429839316101711332862578
,0.4303886126970400960445318
,0.4181505423905439999820999
,0.4062595843850891341730858
,0.3947058899934429154754412
,0.3834798899920338621782889
,0.3725722866984380043930969
,0.3619740462745922315868086
,0.3516763912494560440080704
,0.3416707932550417381456498
,0.3319489659699121908431607
,0.3225028582644138275270507
,0.3133246475420691790070293
,0.3044067332716803853109866
,0.2957417307048103016775542
,0.2862303603179382482935011
,0.2780448209369464351858880
,0.2711934555498684562557798
,0.2634703580169004411004607
,0.2559662776074805856652006
,0.2486750020467570765347887
,0.2415904956017526084011138
,0.2347068940797876757109464
,0.2280184999551292668318325
,0.2215197776132378781888121
,0.2152053486999566389581418
,0.2090699875604978275056567
,0.2031086167500697481358429
,0.1973163025944551784984782
,0.1916882507748476904829715
,0.1862198019068451448898571
,0.1809064270789034756248270
,0.1757437233110371033184549
,0.1707274088905467168686414
,0.1658533185386354136259257
,0.1611173983606501158849511
,0.1565157005342576179707237
,0.1520443776951125314234048
,0.1476996769895678462969357
,0.1434779337797706388890617
,0.1393755650089755493414856
,0.1353890622647347941054363
,0.1315149846149753498636414
,0.1277499513364417083050029
,0.1240906347053933322932551
,0.1205337530747660479413241
,0.1170760645172945618730509
,0.1137143613665076852248248
,0.1104454660324904191615047
,0.1072662285017739608461440
,0.1041735259454283218927273
,0.1011642648514264608561319
,0.0948123530166092853832538
,0.0953838730346622254430144
,0.0926067635390175614151786
,0.0899011648949099989591716
,0.0872642726770870846841888
,0.0846933926546566406834415
,0.0821859655309429143477118
,0.0797395938541408944022493
,0.0773520702758691003353420
,0.0750214061587928665586489
,0.0727458593875809494955220
,0.0705239601310872210593317
,0.0683545332480487571880090
,0.0662367160320051634458949
,0.0641699700591618349410084
,0.0621540860379003329283520
,0.0601891807593247785135304
,0.0582756855094562278840620
,0.0564143256163539552616726
,0.0546060911567023063439841
,0.0528521992200997742239466
,0.0511540485066856454032802
,0.0495131673945177069873225
,0.0479311569365763051608909
,0.0464096305137663978079843
,0.0449501520626550479797778
,0.0435541749016549600836967
,0.0422229831887822384950404
,0.0409576379557566941369551
,0.0397589294811959911846166
,0.0386273375002752356044411
,0.0375630004152498614411471
,0.0365656942906976908935768
,0.0385781211894814513030383
,0.0374936614505898963001229
,0.0364403258428790607914571
,0.0354172426077747695694065
,0.0344235651181985513602513
,0.0334584711835832701587456
,0.0325211623757637111054031
,0.0316108633752482243162163
,0.0307268213374014172167836
,0.0298683052780922206337344
,0.0290346054783851420522112
,0.0282250329078784639724731
,0.0274389186663165016155652
,0.0266756134431283299657256
,0.0259344869945690482959666
,0.0252149276381624445897423
,0.0245163417641643503752658
,0.0237505214192280378338040
,0.0230917298673441774570225
,0.0224522237336457521073019
,0.0219204674835224121165478
,0.0213184453137904746100606
,0.0207341892169666426604113
,0.0201672197888011807409558
,0.0196170723704512002527611
,0.0190832967001752853986041
,0.0185654565782171591947769
,0.0180631295438920050355769
,0.0175759065636334754767489
,0.0171033917284674173708847
,0.0166452019590655996006401
,0.0162009667162322130995467
,0.0157703277144241107987632
,0.0153529386357755693454097
,0.0149484648421562178743915
,0.0145565830831889276436586
,0.0141769811989403970997614
,0.0138093578174030492955460
,0.0134534220489017520422381
,0.0131088931824470469877930
,0.0127755003928753038677790
,0.0124529824720373428342812
,0.0121410876028234162443686
,0.0118395732007918405570557
,0.0115482058527535506875505
,0.0112667613900185332315163
,0.0109950251356199114188827
,0.0107327923698632629601057
,0.0104798690586436517302449
,0.0102360728893295411384701
,0.0100012346496967507308851
,0.0097751999759270683659773
,0.0095578314980463464911598
,0.0093490113754337560852958
,0.0091486442200986416162234
,0.0089566603813683413892743
,0.0087730195550973014140261
,0.0085977146783762104648163
,0.0084307761092613942716101
,0.0082722759463797982532052
,0.0081223326466560025194141
,0.0079811158408013924830948
,0.0078488514809928588283894
,0.0077215968845235601406007
,0.0076124001184266045297311
,0.0075090014587127886305784
,0.0074161484762487288324717
,0.0073344543761982208124328
,0.0072646430998964499348158
,0.0072075683863245349966564
,0.0071642386639886061414084
,0.0071358499514906697722139
,0.0071238299989040809040430
,0.0071298968484579663615341
,0.0071561377138352807308896
,0.0072051156866667067854570
,0.0075000827077367875073133
,0.0073848431209325871710236
,0.0075247083731612316934156
,0.0077062206759886502094314
,0.0079380649971642468915034
,0.0082318489195873211644594
,0.0086033798034722639563876
,0.0090746381148383327419626
,0.0096769095957279088748848
,0.0104559022047302444674566
,0.0114803601742268848728834
,0.0128569989636945786887212
,0.0147570683797445950657945
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0261305579214982063029904
,0.0522611158429964126059808
,0.0783916737644946154395242
,0.1045222316859928252119616
,0.1306527896074910211066111
,0.1567833475289892308790485
,0.1829139054504874406514858
,0.2090444633719856504239232
,0.2351750212934838601963605
,0.2613055792149820422132223
,0.2874361371364802519856596
,0.3135666950579784617580970
,0.3396972529794766715305343
,0.3658278109009748813029717
,0.3919583688224730910754090
,0.4180889267439713008478464
,0.4442194846654695106202837
,0.4703500425869677203927210
,0.4964806005084659301651584
,0.5226111584299640844264445
,0.5487417163514622941988819
,0.5748722742729605039713192
,0.6010028321944587137437566
,0.6271333901159569235161939
,0.6532639480374551332886313
,0.6793945059589533430610686
,0.7055250638804515528335060
,0.7316556218019497626059433
,1.2862485141990902537401098
,1.2497309800079543506967639
,1.2142494151239566768651912
,1.1797744259970328606357270
,1.1462774530215003032651566
,1.1137307468765931250942458
,1.0821073455383640737892392
,1.0513810519440753843412040
,1.0215264122905869381696675
,0.9925186949487943000036694
,0.9643338699766825783399327
,0.9369485892140683169770909
,0.9103401669426027797982215
,0.8844865610950478629348481
,0.8593663549983573402002435
,0.8349587396354920532104416
,0.8112434964113874880098365
,0.7882009804088875304373119
,0.7658121041209053903031645
,0.7440583216454672577100382
,0.7229216133307040381694719
,0.7023844708572338779717370
,0.6824298827457639937676959
,0.6630413202780859327489793
,0.6442027238199677929841869
,0.6258984895347631249862275
,0.6081134564767993744283103
,0.5908328940538171147878188
,0.5740424898478637683041370
,0.5577283377840496214616905
,0.5418769266364722447804070
,0.5264751288603010115352276
,0.5115101897384892737363771
,0.4969697168307194989900211
,0.4828725437395915420779602
,0.4691459392976599085400835
,0.4558086851832810482143543
,0.4428497343331710411895585
,0.4302583531324388754768506
,0.4180241125252177614157745
,0.4061368793780543162696972
,0.3945868080889674001099365
,0.3833643324352985493064239
,0.3724601576536836211595016
,0.3618652527456781564652033
,0.3515708430027708053522417
,0.3415684027446976300801396
,0.3318496482651663304075385
,0.3224065309792556455192880
,0.3132312307669187223524432
,0.3043161495071494693220870
,0.2956539047974753864345132
,0.2861453626222537072187890
,0.2779624397027584681296730
,0.2711134748309801945076458
,0.2633928567849211921370056
,0.2558911915433126904595440
,0.2486022688323375473551380
,0.2415200548691849857796399
,0.2346386873624070612542880
,0.2279524706405525458219330
,0.2214558708984664947561072
,0.2151435115486211024915519
,0.2090101686623447585500202
,0.2030507664827992941880552
,0.1972603729880226808290899
,0.1916341954783214174273809
,0.1861675761578816812313875
,0.1808559876758409901142954
,0.1756950285875082673481273
,0.1706804186923854549373658
,0.1658079942026661479648197
,0.1610737026947312577895843
,0.1564735977976836889258294
,0.1520038335781828398030058
,0.1476606585908252222694159
,0.1434404095791231570355961
,0.1393395048346781073256295
,0.1353544372520771588153110
,0.1314817671545479849104510
,0.1277181150100830109295202
,0.1240601542084160541223881
,0.1205046041238501397518945
,0.1170482237445321510582730
,0.1136878062014826246128862
,0.1104201745759194192020303
,0.1072421793960335184570098
,0.1041506982491246097177751
,0.1011426379268549752277195
,0.0947891576473467306618303
,0.0953645865421970245767724
,0.0925886170149850806776470
,0.0898841384188494574303263
,0.0872483466337664187451040
,0.0846785479146646563597400
,0.0821721837035900293244595
,0.0797268576099472159324222
,0.0773403637304928281981375
,0.0750107153044348579085110
,0.0727361725520677959710980
,0.0705152684394011186608253
,0.0683468310564887548963497
,0.0662300013018633781936018
,0.0641642446351763789946787
,0.0621493557971227877922971
,0.0601854555986224143415697
,0.0582729791447391398673261
,0.0564126551736921499902166
,0.0546054765445452630623357
,0.0528526622824257233390632
,0.0511556119685489529835820
,0.0495158536234643828488622
,0.0479349865550233872335539
,0.0464146209079252802798266
,0.0449563158421894953908904
,0.0435615183703643646384585
,0.0422315048896958131208201
,0.0409673273538209148370015
,0.0397697658431594644468099
,0.0386392890245877279609132
,0.0375760236551770446244980
,0.0397074102576539245124110
,0.0385920181872938458655931
,0.0375086611931335703329360
,0.0364564427519426387247492
,0.0354344922161622596923358
,0.0344419640999572632122927
,0.0334780373868334563125515
,0.0325419148583206835345649
,0.0316328224432464860660374
,0.0307500085871522076119700
,0.0298927436414288955068841
,0.0290603192717777472631191
,0.0282520478856268103529104
,0.0274672620781642937148881
,0.0267053140966757515673002
,0.0259655753229009328419963
,0.0252474357731529257253822
,0.0245503036159667835380827
,0.0237859158348634469604121
,0.0231286464000313649047591
,0.0224907015390411572919316
,0.0219606220475587268770035
,0.0213602531105966456093093
,0.0207776969206273226520310
,0.0202124766365198577089402
,0.0196641303173306913887330
,0.0191322105877975989773887
,0.0186162843183069401375995
,0.0181159323184577510101878
,0.0176307490431016691823096
,0.0171603423094581278296467
,0.0167043330236218770523671
,0.0162623549145116223779706
,0.0158340542731224415140545
,0.0154190896948802891319730
,0.0150171318231283705546542
,0.0146278630922876181491565
,0.0142509774703280609614575
,0.0138861802017742029524694
,0.0135331875549258035668077
,0.0131917265804205752904865
,0.0128615348922151446348083
,0.0125423604874846383872011
,0.0122339616280039819445902
,0.0119361068097823385530942
,0.0116485748581636669451989
,0.0113711551868819951000011
,0.0111036482672220646050754
,0.0108458663553052132161314
,0.0105976345292748078824596
,0.0103587920801789818564531
,0.0101291942930645407355827
,0.0099087146655603194206341
,0.0096972475691893024463131
,0.0094947113736535658501392
,0.0093010520280632693473910
,0.0091162470840812671879494
,0.0089403101458985327620876
,0.0087732957824449356309948
,0.0086153047511664960361744
,0.0084664897657434779604246
,0.0083270617059427211315015
,0.0081972964596863234776336
,0.0080775426215972650351160
,0.0079682303557827936085767
,0.0078698818896224681518348
,0.0077831242897224792859356
,0.0077889204964218614751781
,0.0077502986193964448075056
,0.0077245555841675634170529
,0.0077125880301886426404501
,0.0077155887841516106184780
,0.0077351167243269137660522
,0.0075850761350908018840200
,0.0076344502585947264516886
,0.0077109410354064180509459
,0.0078187542825172637317444
,0.0079632392123082339219220
,0.0081512968782849592325190
,0.0083919690691290418915749
,0.0086973040039004956974766
,0.0090836567691784057126947
,0.0095736899286899598132683
,0.0101995319616154603986624
,0.0110079029433585232067294
,0.0120686727804428083760113
,0.0134895510057265327619191
,0.0154418930074254126538769
,0.0182065413060897365871149
,0.0000000000000000000000000
,0.0000000000000000000000000
,0.0256234132519034887853770
,0.0512468265038069775707541
,0.0768702397557104732950251
,0.1024936530076139551415082
,0.1281170662595174369879913
,0.1537404795114209188344745
,0.1793638927633244006809576
,0.2049873060152278825274408
,0.2306107192671313643739239
,0.2562341325190348739759827
,0.2818575457709383558224658
,0.3074809590228418376689490
,0.3331043722747453195154321
,0.3587277855266488013619153
,0.3843511987785522832083984
,0.4099746120304557650548816
,0.4355980252823592469013647
,0.4612214385342627287478479
,0.4868448517861662105943310
,0.5124682650380697479519654
,0.5380916782899732853095998
,0.5637150915418768226672341
,0.5893385047937803600248685
,0.6149619180456838973825029
,0.6405853312975874347401373
,0.6662087445494909720977716
,0.6918321578013945094554060
,0.7174555710532980468130404
,0.7430789843052015841706748
,1.3234021804464513039079065
,1.2858306783077460000441761
,1.2493250510686051413244968
,1.2138550567480967945499515
,1.1793913113817593441012832
,1.1459052646787486473556328
,1.1133691763701061283597937
,1.0817560932281462537929428
,1.0510398267381417802823762
,1.0211949314037904734675521
,0.9921966836685315316302081
,0.9640210614352882068089912
,0.9366447241677089419198410
,0.9100449935564800529874674
,0.8841998347347451714384192
,0.8590878380271390613032167
,0.8346882012174081655331292
,0.8109807123199990197548459
,0.7879457328414704031516180
,0.7655641815179708986605078
,0.7438175185154485280492054
,0.7226877300796642478175613
,0.7021573136234608991657069
,0.6822092632391099087385555
,0.6628270556239208577409272
,0.6439946364076282181443389
,0.6256964068703725345699240
,0.6079172110403510131959592
,0.5906423231604222001678295
,0.5738574355130627857590753
,0.5575486465931203117207815
,0.5417024496176615633302731
,0.5263057213619455332320740
,0.5113457113099915130050022
,0.4968100311073945229978222
,0.4827175252079880518607524
,0.4689954527993880351033340
,0.4556626059440636589137341
,0.4427079412294116500525831
,0.4301207285908499322601983
,0.4178905424253849254512261
,0.4060072529578615529999297
,0.3944610178528008548326511
,0.3832422740649519821154456
,0.3723417299218934051197039
,0.3617503574322162851473195
,0.3514593848130242448313254
,0.3414602892306701775737565
,0.3317447897488360331053059
,0.3223048404782282161384899
,0.3131326239223186091997775
,0.3042205445136935137995238
,0.2955612223356799406204232
,0.2860556768375140945792623
,0.2778755272210133853150182
,0.2699271427703775483308846
,0.2633111187141533027222806
,0.2558120144653596161887776
,0.2485255870336662564756836
,0.2414458047045144883924195
,0.2345668072031201478733209
,0.2278829008252097332309916
,0.2213885536854943159035258
,0.2150783910712665003561739
,0.2089471908859982518524845
,0.2029898791648062361669957
,0.1972015256400914684498105
,0.1915773393316280992504375
,0.1861126641309298335169586
,0.1808029743450692561346216
,0.1756438701605392560534113
,0.1706310729836629791478231
,0.1657604206110412092822770
,0.1610278621823212630292943
,0.1564294528690444441298979
,0.1519613482585309982564326
,0.1476197984017186271010758
,0.1434011415097137254193171
,0.1393017973064104575442457
,0.1353182600745819474941101
,0.1314470914705245241371756
,0.1276849132272366849072398
,0.1240283999170677525780704
,0.1204742719997006217269586
,0.1170192894372610176167981
,0.1136602462113728839732119
,0.1103939661224589002808116
,0.1072173002843697792174638
,0.1041271267421817608989087
,0.1011203526326931723122726
,0.0947653076382523051890416
,0.0953448104842745947085092
,0.0925700644026509755768473
,0.0898667888150212756936952
,0.0872321800071863273640105
,0.0846635448470365176154573
,0.0821583256734929739950601
,0.0797141273497808666714803
,0.0773287456467928457914951
,0.0750001959455993405523344
,0.0727267411012635228706458
,0.0705069172046356024141645
,0.0683395559250194600808825
,0.0662238021227470607943388
,0.0641591254922540960015098
,0.0621453251354319169408313
,0.0601825261703395203438660
,0.0582711677463532487508679
,0.0564119821540919816338366
,0.0546059650737906326911641
,0.0528543373827171439338635
,0.0511584993216970540519384
,0.0495199781822593942948174
,0.0479403709985029222173658
,0.0464212839917991434979250
,0.0449642707048114737000688
,0.0435707708609552671341625
,0.0422420519885016443328851
,0.0409791557532310640743489
,0.0397828507544590662114992
,0.0386535932671758231116144
,0.0408673382328612402880630
,0.0397225336930773498256286
,0.0386083429591550786330600
,0.0375262031289424410895883
,0.0364752189016846611879785
,0.0354545208864836328133130
,0.0344632648913094433162918
,0.0335006312337976161486175
,0.0325658240733554468770983
,0.0316580707641270567287428
,0.0307766212283961913820374
,0.0299207473500353975104371
,0.0290897423876396686581725
,0.0282829204070150636018965
,0.0274996157327233453626647
,0.0267391824184178526768729
,0.0260009937357378560773835
,0.0252844416815612947624370
,0.0245889365034476226057336
,0.0238261527672821889212162
,0.0231705901958628585068922
,0.0225343978771582603704005
,0.0220062032136763598144658
,0.0214076939492930072572729
,0.0208270519963020539488951
,0.0202638035723260584441974
,0.0197174899899112167356297
,0.0191876673399217177740095
,0.0186739061911632212020784
,0.0181757913055302193494622
,0.0176929213677424410078309
,0.0172249087284947130505053
,0.0167713791595913257193029
,0.0163319716194390909813627
,0.0159063380271354318229449
,0.0154941430435264655696148
,0.0150950638579094367774935
,0.0147087899799214494311883
,0.0143350230373633438785141
,0.0139734765827854538755570
,0.0136238759147907454588600
,0.0132859579234149340759563
,0.0129594709742718496719993
,0.0126441748522287903538919
,0.0123398407887460349885433
,0.0120462516099666475111185
,0.0117632020427293534220459
,0.0114904992262180264545046
,0.0112279634803412395327449
,0.0109754293893470963178194
,0.0107327472522403752352993
,0.0104997849464203499292303
,0.0102764302725854711484388
,0.0100625937982649227980803
,0.0098582122458736980152860
,0.0096632524425462693745681
,0.0094777158430015152196235
,0.0093016436405551506522160
,0.0091351225482970786068160
,0.0089782910975771592493322
,0.0088313467833909028298356
,0.0086945539621875230634762
,0.0085682527716623348851277
,0.0084528693841003869208217
,0.0083489280082058060783456
,0.0082570652583411115882361
,0.0081780477537724115960627
,0.0081127941207059569433957
,0.0080624029716781179383256
,0.0080281893312877210255873
,0.0080117320927889229542629
,0.0080149367186472704471800
,0.0080401194799172466531889
,0.0080901204341543297982042
,0.0081684575367610822577147
,0.0082795388694886940667006
,0.0084289585658819370789230
,0.0086239155350563995866553
,0.0088738159067804026763904
,0.0091911562166501203918756
,0.0095928454503308429462960
,0.0101022299089582739961557
,0.0107522724450214556685124
,0.0115906771776985578759067
,0.0126883755993010133300558
,0.0141539458771607791487401
,0.0161586333826242642408566
,0.0189801339950588128513420
,0.0231508737792468534399948
,0.0000000000000000000000000
,0.0251582216507230602142720
,0.0503164433014461204285439
,0.0754746649521691737039220
,0.1006328866028922408570878
,0.1257911082536153080102537
,0.1509493299043383751634195
,0.1761075515550614423165854
,0.2012657732057845094697512
,0.2264239948565075766229171
,0.2515822165072306160205073
,0.2767404381579536831736732
,0.3018986598086767503268391
,0.3270568814593998174800049
,0.3522151031101228846331708
,0.3773733247608459517863366
,0.4025315464115690189395025
,0.4276897680622920860926683
,0.4528479897130151532458342
,0.4780062113637382203990001
,0.5031644330144612320410147
,0.5283226546651842436830293
,0.5534808763159072553250439
,0.5786390979666302669670586
,0.6037973196173532786090732
,0.6289555412680762902510878
,0.6541137629187993018931024
,0.6792719845695223135351171
,0.7044302062202453251771317
,0.7295884278709683368191463
,0.7547466495216913484611609
,1.3616025682498811288922980
,1.3229474025520924218568553
,1.2853888599419167615423021
,1.2488958261046751996303783
,1.2134380694924291610448108
,1.1789862162790027966252637
,1.1455117260255531785873018
,1.1129868680369912059546778
,1.0813846983893025122114295
,1.0506790376089369942746998
,1.0208444489857666503951350
,0.9918562175016797377580247
,0.9636903293573952922201897
,0.9363234520805792104880538
,0.9097329151988332585077046
,0.8838966914616022130246620
,0.8587933785955246257515228
,0.8344021815781695883273983
,0.8107028954155918176738282
,0.7876758884095274027004052
,0.7653020859004956433224720
,0.7435629544734770890457298
,0.7224404866132423386204664
,0.7019171857967814176504362
,0.6819760520106759038583277
,0.6626005676815893696840476
,0.6437746840084086485944681
,0.6254828076848494289308178
,0.6077097880016197883890072
,0.5904409043174242421869735
,0.5736618538882284346058782
,0.5573587400442326922345160
,0.5415180607038779792006267
,0.5261266972139273523367820
,0.5111719035041181191658666
,0.4966412955440703824727677
,0.4825537292701026492736105
,0.4688364536659919701300225
,0.4555082717826020588525182
,0.4425581440714868031172102
,0.4299753442261755043141136
,0.4177494502988545188593150
,0.4058703360696398476648028
,0.3943281626613595047814442
,0.3831133703929652800646011
,0.3722166708649193300750824
,0.3616290392700837741379871
,0.3513417069238559675703470
,0.3413461540074709810177467
,0.3316341025185736146596582
,0.3221975094233496816897855
,0.3130285600046345817482063
,0.3041196614005769460753470
,0.2954634363285238984886405
,0.2859610660537030835115502
,0.2777838560816482949000772
,0.2698383356912001374006138
,0.2632249344441425220608721
,0.2557285459675874839113874
,0.2484447650329452972339794
,0.2413675621192991060937061
,0.2344910790911384768087089
,0.2278096243313220969906041
,0.2213176679918543721115043
,0.2150098373498779413814930
,0.2088809122537806650665715
,0.2029258206412850318312024
,0.1971396341078311131855827
,0.1915175634995067432964078
,0.1860549545003117311026131
,0.1807472831788630440730259
,0.1755901514550176067963605
,0.1705792824427703191503269
,0.1657105156227140496660866
,0.1609798017960894778166647
,0.1563831977738973089131491
,0.1519168607596918518787277
,0.1475770423946502485357257
,0.1433600824493558301142571
,0.1392624021694169322849177
,0.1352804973122089804427048
,0.1314109309498880662214759
,0.1276503261589763127403785
,0.1239953587680654861769014
,0.1204427503904597213102434
,0.1169892620248526721171700
,0.1136316885604894966199652
,0.1103668545690109914492183
,0.1071916117981118049540257
,0.1041028387968987167777613
,0.1010974430943303997709748
,0.0947408493153028413713557
,0.0953245925580084446648854
,0.0925511602372082464729175
,0.0898491775087001121047336
,0.0872158411814784595428307
,0.0846484588838892215711951
,0.0821444740340736001549260
,0.0797014929697992952073449
,0.0773173133969827786060591
,0.0749899531391363810550743
,0.0727176780231576641577718
,0.0704990276319801822957345
,0.0683328376019361333204571
,0.0662182571504435907305819
,0.0641547605932605569112326
,0.0621421517521581548426646
,0.0601805603618179446590020
,0.0582704298534589409941375
,0.0564124962125321163797231
,0.0546077579654089123595284
,0.0528574377286505150963514
,0.0511629361349740727216151
,0.0495257793117256164827644
,0.0479475614096069660541310
,0.0464298839418598660588877
,0.0449742938800533550991467
,0.0435822225491066389535533
,0.0422549273635560024287017
,0.0409934383477642549920006
,0.0397985111896471330239500
,0.0420636456785997425722456
,0.0408837952585937164373675
,0.0397402987499879054023033
,0.0386274340717160866165436
,0.0375466390179256120918083
,0.0364970196721995168709363
,0.0354777080700329067175502
,0.0344878614914685965864294
,0.0335266617758011586936107
,0.0325933146579002880338649
,0.0316870491257364439441346
,0.0308071167987235203233887
,0.0299527913265266523823449
,0.0291233678080182571690226
,0.0283181622301018690035512
,0.0275365109261603846491084
,0.0267777700539254745470963
,0.0260413150926036597587743
,0.0253265403591360800661381
,0.0246328585435083638466303
,0.0238718735188275729686147
,0.0232182277734307510042022
,0.0225840056790410081966058
,0.0220579328893426782065568
,0.0214615189357048909146730
,0.0208830362465475018185490
,0.0203220147097307769767927
,0.0197779995541153205684815
,0.0192505510562921595962838
,0.0187392442659485153333421
,0.0182436687494156382638444
,0.0177634283507678743252445
,0.0172981409696285580446240
,0.0168474383546712118409072
,0.0164109659116327827321768
,0.0159883825247784175371812
,0.0155793603908967008553343
,0.0151835848656409720669469
,0.0148007543229126906775273
,0.0144305800297477616889186
,0.0140727860420830457044428
,0.0137271091295708917018326
,0.0133932987429253354955128
,0.0130711170433669525425824
,0.0127603390157306779278956
,0.0124607527029626206915847
,0.0121721595975605705736156
,0.0118943752393650004767212
,0.0116272300736919367847300
,0.0113705706351984216218032
,0.0111242611165678559337344
,0.0108881853779133966342307
,0.0106622494883354679284793
,0.0104463848285578989050215
,0.0102405518300807685250220
,0.0100447443949481258346212
,0.0098589950389820404236252
,0.0096833808114017115575844
,0.0095180301325335728984678
,0.0093631303994911978250126
,0.0092189368150770341359124
,0.0090857823655600741113991
,0.0089640893278385147535658
,0.0088543827433045195485217
,0.0087573064292921411894133
,0.0086736423663198013861431
,0.0086043346276907396036338
,0.0085505194471593298777279
,0.0085135635914617840969143
,0.0084951143944859489054444
,0.0084971652029512331760763
,0.0085221422219293220534642
,0.0085730217314307372716842
,0.0086534885964155445342572
,0.0087681543969110233710529
,0.0089228611050167303681002
,0.0091251099203000195225766
,0.0093846767914324193821107
,0.0097145121230777266296830
,0.0101320826303042035160251
,0.0106614172311387013503126
,0.0113363013806243272119101
,0.0122053910029461636088666
,0.0133406103743582693521574
,0.0148512773378231752174905
,0.0169083130762807606894960
,0.0197859795152154974151593
,0.0239320739552019989826448
,0.0300745202714243001218541
,0.0548060328610391056525231
,0.0795375454506539181220859
,0.1042690580402687305916487
,0.1290005706298835430612115
,0.1537320832194983555307743
,0.1784635958091131680003372
,0.2031951083987279804699000
,0.2279266209883427929394628
,0.2526581335779575776534500
,0.2773896461675723901230128
,0.3021211587571872025925757
,0.3268526713468020150621385
,0.3515841839364168275317013
,0.3763156965260316400012641
,0.4010472091156464524708269
,0.4257787217052612649403898
,0.4505102342948760774099526
,0.4752417468844908898795154
,0.4999732594741057023490782
,0.5247047720637204593074898
,0.5494362846533352717770526
,0.5741677972429500842466155
,0.5988993098325648967161783
,0.6236308224221797091857411
,0.6483623350117945216553039
,0.6730938476014093341248667
,0.6978253601910241465944296
,0.7225568727806389590639924
,0.7472883853702537715335552
,0.7720198979598685840031180
,0.7967514105494833964726809
,1.4008769262235944985661718
,1.3611076285542924590998837
,1.3224665666897017501923983
,1.2849217294562116364886606
,1.2484420138933587374197032
,1.2129971994867014828400897
,1.1785579231319969206737142
,1.1450956548096413722959142
,1.1125826739497286510527374
,1.0809920464677569285072423
,1.0502976024521708531267450
,1.0204739144852352783487959
,0.9914962765793329246832855
,0.9633406837112550302748559
,0.9359838119375875065131254
,0.9094029990747626301939022
,0.8835762259278346908430990
,0.8584820980524947575673878
,0.8340998280352964755479661
,0.8104092182775097796820774
,0.7873906442684357465111589
,0.7650250383344606719404624
,0.7432938738505193709826813
,0.7221791499010388193369181
,0.7016633763778353793938436
,0.6817295595027959009826191
,0.6623611877635370293049277
,0.6435422182505701194088488
,0.6252570633848054670878014
,0.6074905780244840292070307
,0.5902280469408385243923476
,0.5734551726519145908866903
,0.5571580636040106560002982
,0.5413232226900825949655882
,0.5259375360941679344861654
,0.5109882624503663262061082
,0.4964630223040685241819858
,0.4823806837413282533333359
,0.4686684849515925788132620
,0.4553452406128871143842218
,0.4423999152667088541335261
,0.4298217865845130325475054
,0.4176004364876863550470887
,0.4057257425200230249728861
,0.3941878694656192338996448
,0.3829772612053191083170134
,0.3720846328050456675029523
,0.3615009628295595134339635
,0.3512174858753836503844070
,0.3412256853168199044468167
,0.3315172862591697078293862
,0.3220842486934362147721345
,0.3129187608469471970629172
,0.3040132327244677856725730
,0.2953602898344827032417470
,0.2858612840180217440355648
,0.2776871901175368972936042
,0.2697447060944667684978526
,0.2631340869944809313096812
,0.2556405785898115401444386
,0.2483596047182408672604481
,0.2412851381856593313557369
,0.2344113231260855356730133
,0.2277324701369878579004791
,0.2212430515324970980994834
,0.2149376967019371864608956
,0.2088111875585822729828323
,0.2028584540605197494844703
,0.1970745697819279440565765
,0.1914547475089989347907249
,0.1859943348302521559656242
,0.1806888096862639681017271
,0.1755337758391799507506903
,0.1705249582181993794893771
,0.1656581980941041476462772
,0.1609294480345996869452563
,0.1563347665936191399627120
,0.1518703126928772351167396
,0.1475323396639087458748207
,0.1433171889347182315077589
,0.1392212833679185579605075
,0.1352411202875424267588755
,0.1313732642697762742489687
,0.1276143398182783550431907
,0.1239610240963179427220453
,0.1204100399436061896718542
,0.1169581494623340017779967
,0.1136021485106370049189550
,0.1103388624877220808295775
,0.1071651438279740686798647
,0.1040778716360942907082077
,0.1010739538865794290289912
,0.0947158416697902044711910
,0.0953039921353462521347311
,0.0925319713581094077659017
,0.0898313788725609019270024
,0.0871994121474933409077224
,0.0846333797424850542423513
,0.0821307263648378832465724
,0.0796890600795570058778594
,0.0773061808246300052882560
,0.0749801092064458218899858
,0.0727091144035254821620384
,0.0704917399025384722177634
,0.0683268257391834443748024
,0.0662135259260913794365777
,0.0641513198258480410451909
,0.0621400163715125630758962
,0.0601797502478680634840913
,0.0582709694182763360270627
,0.0564144137046244595334876
,0.0546110844878409107394646
,0.0528622059769471713819300
,0.0511691788762000457357892
,0.0495335276417392528225392
,0.0479568428402668556209676
,0.0464407203829257791971585
,0.0449866995907338279581111
,0.0435962021408799957344904
,0.0422704739384480027153401
,0.0410105318544037381056633
,0.0432949080928679563839978
,0.0420815511482479295835013
,0.0409031263741233969133404
,0.0397610737265339103663209
,0.0386496742333933898660980
,0.0375703664517751598217465
,0.0365222580385601500174708
,0.0355044826543225791604108
,0.0345161992604267678363961
,0.0335565914385530655872358
,0.0326248667322420818348583
,0.0317202560100819097588243
,0.0308420128501999436798631
,0.0299894129457598246357719
,0.0291617535312047662654500
,0.0283583528290321101872351
,0.0275785495169286742900283
,0.0268217022151448943045882
,0.0260871889940347476133375
,0.0253744069017405524113506
,0.0246827715120528923264942
,0.0239238066984714982388116
,0.0232723169568631767234468
,0.0226403134343120641946978
,0.0221166332398716122820126
,0.0215225842831582962755288
,0.0209465417632653076729365
,0.0203880399969022518824602
,0.0198466289541587674605250
,0.0193218739958165887371511
,0.0188133556325942134790363
,0.0183206693062748365852244
,0.0178434251925154059581491
,0.0173812480250337859921661
,0.0169337769406954878614879
,0.0165006653452099208423398
,0.0160815807991677856003676
,0.0156762049248649719401794
,0.0152842333349631504663124
,0.0149053755855687048575975
,0.0145393551591714818849166
,0.0141859094849822973960496
,0.0138447900096824033644438
,0.0135157623377483611382122
,0.0131986064605041988895273
,0.0128931171134838932351707
,0.0125991042959116613525472
,0.0123163940039570183465623
,0.0120448292348730185558070
,0.0117842713349523234983574
,0.0115346017580802966823184
,0.0112957243001293988066136
,0.0110675679276913702803187
,0.0108500902411484394932684
,0.0106432816820927738515890
,0.0104471705605478169115452
,0.0102618289831060971462051
,0.0100873797822285827391342
,0.0099240046643333263559628
,0.0097719534367830505894315
,0.0096315549300338594573834
,0.0095032295795156474654819
,0.0093875042006833792768150
,0.0092850295731049404396318
,0.0091966016288965168890002
,0.0091231873982115709725838
,0.0090659573150692202014866
,0.0090263260894679377133176
,0.0090060051728443491630971
,0.0090070714537606316740792
,0.0090320576714761294928602
,0.0090840731725815929142875
,0.0091669679737087939735973
,0.0092855567915834744813219
,0.0094459304884751578434976
,0.0096558948965677193071455
,0.0099255989711761281185654
,0.0102684500320544668666711
,0.0107024735481750146032232
,0.0112523766891476292850705
,0.0119527519115399157717539
,0.0128531702759001366376257
,0.0140264754478881571719828
,0.0155825928051561458931307
,0.0176919075719687464431917
,0.0206249756712871858133074
,0.0248181485620626585131276
,0.0309712615725333990923662
,0.0401484567946039580532691
,0.0644885594310513898808068
,0.0888286620674988286472384
,0.1131687647039462674136701
,0.1375088673403936923023139
,0.1618489699768411171909577
,0.1861890726132885420796015
,0.2105291752497359669682453
,0.2348692778861833918568891
,0.2592093805226308167455329
,0.2835494831590782416341767
,0.3078895857955256665228205
,0.3322296884319730914114643
,0.3565697910684205163001081
,0.3809098937048679411887520
,0.4052499963413153660773958
,0.4295900989777627909660396
,0.4539302016142102158546834
,0.4782703042506576407433272
,0.5026104068871051211431222
,0.5269505095235526015429173
,0.5512906121600000819427123
,0.5756307147964475623425074
,0.5999708174328950427423024
,0.6243109200693425231420974
,0.6486510227057900035418925
,0.6729911253422374839416875
,0.6973312279786849643414826
,0.7216713306151324447412776
,0.7460114332515799251410726
,0.7703515358880274055408677
,0.7946916385244748859406627
,1.4412530166047028412634745
,1.4003383312004487049051704
,1.3605843811940465659660049
,1.3219582333938588725175123
,1.2844278889818456779181588
,1.2479622570040804774293974
,1.2125311286137332444923231
,1.1781051520446079727832966
,1.1446558082952758006456406
,1.1121553875031127134320741
,1.0805769659889041811595689
,1.0498943839530063826259720
,1.0200822238046005629996671
,0.9911157891061235236662696
,0.9629710841154777156702949
,0.9356247939090958087859917
,0.9090542650694682924594758
,0.8832374869211769841115256
,0.8581530732999649302428224
,0.8337802448398214938407591
,0.8100988117634920770981921
,0.7870891571622750104708643
,0.7647322207513668201883661
,0.7430094830874383049490461
,0.7219029502355284177994577
,0.7013951388727142077783583
,0.6814690618164168656178958
,0.6621082139655183329551846
,0.6432965586428510684768867
,0.6250185143278746968675819
,0.6072589417686552470954098
,0.5900031314624543110625154
,0.5732367914943689024553919
,0.5569460357234936598302966
,0.5411173723059810036772888
,0.5257376925440616632911883
,0.5107942600495962715001497
,0.4962747002098850113149808
,0.4821978939659320451127655
,0.4684910680890813639010162
,0.4551730495596567616090056
,0.4422328072478921012766762
,0.4296596230356671264338786
,0.4174430829399684017566585
,0.4055730684887549619688230
,0.3940397483421512747625570
,0.3828335701521005107750284
,0.3719452526538157832725062
,0.3613657779825771299009318
,0.3510863842096088038857715
,0.3410985580909749459443958
,0.3313940280235976865164105
,0.3219647572026910209430639
,0.3128029369750426891272355
,0.3039009803827240618900873
,0.2952515158919109539148451
,0.2857560751024469936076855
,0.2775852844091461490982908
,0.2696460195671015469542908
,0.2630383518440577161889848
,0.2555478979342657441797826
,0.2482699016374878830948347
,0.2411983382278680976273932
,0.2343273542473562898180717
,0.2276512626435269470714928
,0.2211645380253751957955188
,0.2148618120245297247183913
,0.2087378687468137150595737
,0.2027876402960383239726383
,0.1970062023483327429129730
,0.1913887697512203778238415
,0.1859306921171368920386868
,0.1806274493763318500505477
,0.1754746472493979303486356
,0.1704680125954392555520656
,0.1656033885887275014514586
,0.1608767296753255970909180
,0.1562840962625069440861125
,0.1518216490988903710768199
,0.1474856433131663813185241
,0.1432724220952105720350289
,0.1391784100262247192425491
,0.1352001060950008270999945
,0.1313340764756901479781703
,0.1275769471881620376052524
,0.1239253968139581579821495
,0.1203761494968707129737950
,0.1169259685142126081736080
,0.1135716507589148299706139
,0.1103100225188777955276365
,0.1071379369732295971928693
,0.1040522738398301366702370
,0.1010499415993371952193769
,0.0946903582423993112060501
,0.0952830819514210169973722
,0.0925125786616065037826218
,0.0898134820456798765864193
,0.0871829903908912934307196
,0.0846184133854557540832531
,0.0821171972672490313449600
,0.0796769521175676176394376
,0.0772954804445141335778047
,0.0749708060228350958720256
,0.0727012018105960416969324
,0.0704852156597151474626273
,0.0683216924874327086181225
,0.0662097915874238773792371
,0.0641489978377577790835673
,0.0621391257101455776745702
,0.0601803151989505971664052
,0.0582730190632743325074294
,0.0564179811010430062867549
,0.0546162055365769782966368
,0.0528689179855192439849709
,0.0511775188436468173036609
,0.0495435303080041869461247
,0.0479685385588864490746808
,0.0464541328897244490403473
,0.0450018437519915728839415
,0.0436130817712349350134815
,0.0422890797810218307950514
,0.0445621464925847893256972
,0.0433143872049201461571499
,0.0421025831243046141927344
,0.0409257321832420112306394
,0.0397852749513038575490675
,0.0386754960376547649025802
,0.0375978348436768264329011
,0.0365514008211428945149812
,0.0355353294893539090049117
,0.0345487817377532410723084
,0.0335909431514333431390007
,0.0326610233591738269298688
,0.0317582554036899694649421
,0.0308818951338151806429444
,0.0300312206183864921493765
,0.0292055315816511576465508
,0.0284041488600653736773527
,0.0276264138804117424796924
,0.0268716881592213872875785
,0.0261393528235500591239138
,0.0254288081532237295045995
,0.0247394731447381846511924
,0.0239827812096961578980370
,0.0233337206233535793264977
,0.0227042197609202446584309
,0.0221832421736827753444565
,0.0215918677686733548326536
,0.0210185884402133080217645
,0.0204629438803638624699843
,0.0199244898330313280343518
,0.0194027978715632966333349
,0.0188974552028555106697461
,0.0184080644984667939068057
,0.0179342437532439211156365
,0.0174756261717951728862364
,0.0170318600834986517977843
,0.0166026088866596428783584
,0.0161875510232479813410578
,0.0157863799860157340282374
,0.0153988043611830108942096
,0.0150245479128967556609053
,0.0146633497169610590993294
,0.0143149643572443880518152
,0.0139791622045188565492957
,0.0136557297946831926460654
,0.0133444703495411449295505
,0.0130452044722229008877346
,0.0127577710722035688600817
,0.0124820285808326728038686
,0.0122178565391342763141180
,0.0119651576330835358180638
,0.0117238602512564349389379
,0.0114939217154750878552294
,0.0112753322352996156185956
,0.0110681197375717930986294
,0.0108723556837615527997931
,0.0106881620031229716827337
,0.0105157193014959945975839
,0.0103552766598151123333960
,0.0102071629041813050076115
,0.0100718001691609774367331
,0.0099497197854156900487244
,0.0098415812346413535094403
,0.0097481950392842089958556
,0.0096705507034732362398044
,0.0096098513080938377517448
,0.0095675569913920965187115
,0.0095454404043920117184374
,0.0095456584236521188624458
,0.0095708466211059280148721
,0.0096242445807469580165705
,0.0097098646367474832075128
,0.0098327230111817029434285
,0.0099991589047932864786628
,0.0102172831440780122885803
,0.0104976185327276747005776
,0.0108540296395145396957105
,0.0113050985918217768849692
,0.0118762028368994358024091
,0.0126027220630294568837204
,0.0135351011457822030525922
,0.0147470251587346265487177
,0.0163488920614670435460525
,0.0185103425782343102012906
,0.0214979713091209903574885
,0.0257365787259242750906196
,0.0318985929255976574658860
,0.0409946003444283113559266
,0.0543265926327208478752162
,0.0783076643382558112982395
,0.1022887360437907816601566
,0.1262698077493257520220737
,0.1502508794548607085062031
,0.1742319511603956927459080
,0.1982130228659306769856130
,0.2221940945714656612253179
,0.2461751662770006454650229
,0.2701562379825356297047279
,0.2941373096880706139444328
,0.3181183813936055981841378
,0.3420994530991405824238427
,0.3660805248046755666635477
,0.3900615965102105509032526
,0.4140426682157455351429576
,0.4380237399212805193826625
,0.4620048116268155036223675
,0.4859858833323504878620724
,0.5099669550378854721017774
,0.5339480267434204563414823
,0.5579290984489554405811873
,0.5819101701544904248208923
,0.6058912418600254090605972
,0.6298723135655603933003022
,0.6538533852710953775400071
,0.6778344569766303617797121
,0.7018155286821653460194170
,0.7257966003877003302591220
,0.7497776720932353144988269
,0.7737587437987702987385319
,0.7977398155043052829782368
,1.4827591073245636188460139
,1.4406669767473134768920318
,1.3997689907912604923012623
,1.3600312684422424247543404
,1.3214208899524577667250469
,1.2839058695679579358284172
,1.2474551290300011086031873
,1.2120384718285446279395501
,1.1776265581859988174073806
,1.1441908807513030410518695
,1.1117037409836034722587783
,1.0801382262062437789040814
,1.0494681873120359494322429
,1.0196682171013764506284360
,0.9907136292352844986197624
,0.9625804377859668026218287
,0.9352453373680249537613918
,0.9086856838338739361660146
,0.8828794755174549369058923
,0.8578053350107684993375301
,0.8334424914582034826793233
,0.8097707633541023630741051
,0.7867705418293988728350996
,0.7644227744136193880564178
,0.7427089492589316055415338
,0.7216110798133210657567815
,0.7011116899303762028949905
,0.6811937994035320853569715
,0.6618409099129731743005323
,0.6430369913737420395349886
,0.6247664686738947370514552
,0.6070142087918171114324650
,0.5897655082820257854692159
,0.5730060811189032765611273
,0.5567220468878627537279158
,0.5408999193133219307583204
,0.5255265951125931422893700
,0.5105893431642704038964098
,0.4960757939788792980628784
,0.4820048420976204561760881
,0.4683037022149093009382170
,0.4549912143268624586944782
,0.4420563518849714434999498
,0.4294884012274381990259542
,0.4172769527063250327714172
,0.4054118920670111703152827
,0.3938833920728759263596430
,0.3826819043683472032491011
,0.3717981515736595854448865
,0.3612231196048634740414229
,0.3509480502128352608082196
,0.3409644337352161769238990
,0.3312640020553997421970394
,0.3218387217628549956671691
,0.3126807875092277311246391
,0.3037826155548027373676234
,0.2951368375000135158003900
,0.2856451743240462914918965
,0.2774778853443760073815838
,0.2695420336586802356748649
,0.2629374970706343517257153
,0.2554502828450884721611658
,0.2481754452180643111258718
,0.2411069620822247072666755
,0.2342389825345353726593345
,0.2275658220167306733383583
,0.2210819575738420528221440
,0.2147820232182519883945560
,0.2086608053842191889959423
,0.2027132384547660759466225
,0.1969344003392302089316956
,0.1913195080756602273197586
,0.1858639134277001725426004
,0.1805630984408164163568244
,0.1754126709179716636644031
,0.1704083597705773334141099
,0.1655460101973244280149089
,0.1608215786420774673359801
,0.1562311274833084184798793
,0.1517708194126147214220168
,0.1474369114698184379808055
,0.1432257487181048394297989
,0.1391337575656083624942028
,0.1351574387704713442470705
,0.1312933602049303760672672
,0.1275381495000032505693355
,0.1238884867446429782766870
,0.1203410974696663415794973
,0.1168927462042216453008692
,0.1135402309470077558684054
,0.1102803789410303353379916
,0.1071100441740424069614335
,0.1040261070414207067447165
,0.1010254765988806285870183
,0.0946644892453064878967695
,0.0952619500019933340695388
,0.0924930790695589477579119
,0.0897955929763399329779361
,0.0871666910119833493464370
,0.0846036842211918271861038
,0.0821040206497167662780257
,0.0796653127255409349016801
,0.0772853659114017821352149
,0.0749622075867947962324322
,0.0726941149714759315969559
,0.0704796408001041180257928
,0.0683176354093830984215430
,0.0662072639129911294508801
,0.0641480172209363819213479
,0.0621397158104712230008992
,0.0601825053732151019070251
,0.0582768437414543857832960
,0.0564234788254333249901684
,0.0546234176587385086842907
,0.0528778870332615447136249
,0.0511882865889078456089756
,0.0495561355850618057150569
,0.0479830148996436070540916
,0.0464705060576644027325877
,0.0450201292677108386164342
,0.0436332825293262796528815
,0.0458664113755072322398121
,0.0445833349239439374889216
,0.0433372669745053715195660
,0.0421271772712610986788562
,0.0409520655468957120448614
,0.0398133730437247174149817
,0.0387053884960646202295642
,0.0376295522500320125947049
,0.0365849758133661023817851
,0.0355707968401510823963640
,0.0345861784402869618104681
,0.0336303085124498787883418
,0.0327023991002447153575439
,0.0318016857713021988685043
,0.0309274270191244073091585
,0.0300789036875385822067397
,0.0292554184176795108174307
,0.0284562951174858053127181
,0.0276808784537655346025264
,0.0269285333669626626706961
,0.0261986446088368317430817
,0.0254906163033569548026502
,0.0248038715312008870017557
,0.0240497414866333650285135
,0.0234034228716943001891160
,0.0227767505861230408481521
,0.0222588316525366113063367
,0.0216704882465840707739257
,0.0211003448003073690308895
,0.0205479475689611668087764
,0.0200128593704857228596783
,0.0194946594165252388985987
,0.0189929431762652436987970
,0.0185073222745003179712242
,0.0180374244251982757125674
,0.0175828934024410375724923
,0.0171433890504620531358704
,0.0167185873355642639070950
,0.0163081804428652880900597
,0.0159118769221504689770352
,0.0155294018905776654015938
,0.0151604973002952888444517
,0.0148049222857761855753900
,0.0144624536124290988675645
,0.0141328862414699593652578
,0.0138160340601459173670573
,0.0135117308078440065410852
,0.0132198312579529016902447
,0.0129402127214422683204598
,0.0126727769647859631052533
,0.0124174526273330074199741
,0.0121741982236060076322248
,0.0119430059201548217223676
,0.0117239061489676256455628
,0.0115169732586420277276051
,0.0113223323613795764930323
,0.0111401675621454320647130
,0.0109707318055604647472068
,0.0108143587773608350344201
,0.0106714767816570178099456
,0.0105426256774510881952800
,0.0104284770126204535262149
,0.0103298583850130396011302
,0.0102477832515491720094536
,0.0101834877602018699510600
,0.0101384768525058909655057
,0.0101145827733420904520623
,0.0101140403606584088763709
,0.0101395852385155922636972
,0.0101945841467470238450588
,0.0102832094092646167404759
,0.0104106760741042927986832
,0.0105835698473015302895073
,0.0108103052122811345986397
,0.0111017774635390528009671
,0.0114723060348527385737816
,0.0119410243611405824520899
,0.0125339683681326453934535
,0.0132872808078637050233084
,0.0142522342447718060320927
,0.0155032726384452066575870
,0.0171511291744891325450340
,0.0193644954611657260645785
,0.0224057670029868052918864
,0.0266881220672120604564537
,0.0328572801274681428052027
,0.0418727379729892656978762
,0.0550112526292411974093710
,0.0731959184402068280261844
,0.0968476597127552046861965
,0.1204994009853035813462085
,0.1441511422578519718840084
,0.1678028835304003485440205
,0.1914546248029487252040326
,0.2151063660754971018640447
,0.2387581073480454785240568
,0.2624098486205938551840688
,0.2860615898931422318440809
,0.3097133311656906085040930
,0.3333650724382389851641051
,0.3570168137107873618241172
,0.3806685549833357384841293
,0.4043202962558841151441413
,0.4279720375284324918041534
,0.4516237788009808684641655
,0.4752755200735292451241776
,0.4989272613460776217841897
,0.5225790026186259984442017
,0.5462307438911744306153651
,0.5698824851637227517642259
,0.5935342264362710729130868
,0.6171859677088193940619476
,0.6408377089813677152108085
,0.6644894502539160363596693
,0.6881411915264643575085302
,0.7117929327990126786573910
,0.7354446740715609998062519
,0.7590964153441093209551127
,0.7827481566166576421039736
,0.8063998978892059632528344
,1.5254239621381493474672197
,1.4821215132333624975302655
,1.4400475509567136622735006
,1.3991672200103042467134173
,1.3594466540063172566021876
,1.3208529474101540213126782
,1.2833541282797071847454617
,1.2469191317781564976030495
,1.2115177744385743352495410
,1.1771207291584946386109323
,1.1436995009044788051966179
,1.1112264031060048452559386
,1.0796745347193728026269355
,1.0490177579426118725791639
,1.0192306765629592923971813
,0.9902886149190002207376438
,0.9621675974600808478598424
,0.9348443288861052469229662
,0.9082961748513089794698772
,0.8825011432160935198609764
,0.8574378658314391055128567
,0.8330855808409113327783757
,0.8094241154856678388540558
,0.7864338693983449202207225
,0.7640957983720936264049328
,0.7423913985914661894938149
,0.7213026913122452254967243
,0.7008122079776910595683148
,0.6809029757590685516532858
,0.6615585035086652965219400
,0.6427627681138444737385385
,0.6245002012409947012017142
,0.6067556764584923767458235
,0.5895144967280132597409192
,0.5727623822536588304998872
,0.5564854586784061529769474
,0.5406702456172886028795688
,0.5253036455164290519093129
,0.5103729328265426135047278
,0.4958657434787122619823663
,0.4818009864017704924066265
,0.4681058635174867865735848
,0.4547992285916946930690585
,0.4418700599241590643018185
,0.4293076485694499733192231
,0.4171015894679965252400677
,0.4052417728293429832753247
,0.3937183757605261513745631
,0.3825218541327232713022966
,0.3716429346795040444817460
,0.3610726073202494834646359
,0.3508021177024727710325180
,0.3408229599569858048191406
,0.3311268696600303540478194
,0.3217058169966626191005332
,0.3125520001198424657751218
,0.3036578386998111667161027
,0.2950159676584522272513311
,0.2855283074263568199313568
,0.2773647307420579188885768
,0.2694324980471692887462609
,0.2628312835595826291168464
,0.2553475056597611647646318
,0.2480760190611681625938445
,0.2410108044346504496679984
,0.2341460135885345406059344
,0.2274759646118970635164658
,0.2209951371359873406596819
,0.2146981677012890776801157
,0.2085798452151773618723496
,0.2026351064820773040242585
,0.1968590317844101655886391
,0.1912468404884851980174432
,0.1857938866449205250752641
,0.1804956545483485386149880
,0.1753477542163700553246031
,0.1703459167433838405969482
,0.1654859894816378684812008
,0.1607639310003642907354049
,0.1561758057751114481259691
,0.1517177785644182874680297
,0.1473861084409362476321803
,0.1431771424601158970713044
,0.1390873089726349653982851
,0.1351131106175511020772717
,0.1312511170719530551043164
,0.1274979576792450997047013
,0.1238503141308986837954009
,0.1203049134333894210069360
,0.1168585214499427427092826
,0.1135079373615521525220373
,0.1102499894386005097057790
,0.1070815325478898100142189
,0.1039994478343811840082012
,0.1010006450072023359565421
,0.0946383439501525675074944
,0.0952407016740309253499674
,0.0924735877394535776829798
,0.0897778367145388583869803
,0.0871506491042450259776331
,0.0845893375724211943333941
,0.0820913522909148124506729
,0.0796543084117904559571244
,0.0772760147896232180153575
,0.0749545029025835141123224
,0.0726880547753491756957089
,0.0704752286056636173539047
,0.0683148807499740218229789
,0.0662061827401011493421379
,0.0641486320874128240765444
,0.0621420557850686713918797
,0.0601866056402342031184105
,0.0582827448502689221543349
,0.0564312255692198880274724
,0.0546330575791458272760792
,0.0528894685672402706244632
,0.0512018568944018134803109
,0.0495717381025098588476219
,0.0480006867249453544888027
,0.0464902752181278466903080
,0.0450420120043449612179387
,0.0472087834899011307698835
,0.0458894561068685924443145
,0.0446082217046604515009456
,0.0433640211258370933400386
,0.0421558260995024552952870
,0.0409826384071096533334710
,0.0398459000395164353314215
,0.0387399044836327158258804
,0.0376660931553223082834947
,0.0366235799273453913049714
,0.0356115049163033964285674
,0.0346290338006708248164145
,0.0336753571630872411413193
,0.0327496898566978777989078
,0.0318512703953897843844878
,0.0309793603678351452124229
,0.0301332438753218953553237
,0.0293122269934278020797613
,0.0285156372576763558757129
,0.0277428231734029029365018
,0.0269931537501575009863064
,0.0262660180610787309662957
,0.0255608248277884933519211
,0.0248770020314848308573552
,0.0241257654477339544829562
,0.0234825481268382124655503
,0.0228590795049361250601550
,0.0223446294511243925828836
,0.0217597289086019947401685
,0.0211931528995159094985734
,0.0206444557419790189478626
,0.0201132089752640609570111
,0.0195990012620594067360713
,0.0191014383324451843260139
,0.0186201429718951712299901
,0.0181547550566280684047893
,0.0177049316393565435434621
,0.0172703470899712649422320
,0.0168506932956612974494615
,0.0164456799263417649537011
,0.0160550347755518685310960
,0.0156785041860628276966239
,0.0153158535775672153406157
,0.0149668681012867822721635
,0.0146313534347264594115412
,0.0143091367746349673595319
,0.0140000680574346916124062
,0.0137040214741910009593751
,0.0134208973530490893039113
,0.0131506245156010857788598
,0.0128931632046075141107000
,0.0126485086809293104798124
,0.0124166957275091468376749
,0.0121978041347556385304296
,0.0119919654302608601897928
,0.0117993710671820996316317
,0.0116202823313843132263523
,0.0114550423002282592693790
,0.0113040904469280025640421
,0.0111679798778191521901881
,0.0110473986203251921950352
,0.0109431952663931551100740
,0.0108564103938153556916379
,0.0107883154826803485254461
,0.0107404615562530589972789
,0.0107147407188211123835186
,0.0107134650361704712728805
,0.0107394690033364818837480
,0.0107962444346398084987770
,0.0108881210501628501730043
,0.0110205106656321577540680
,0.0112002425635964793920740
,0.0114360321664834195531935
,0.0117391440078801721769164
,0.0121243474761079939039377
,0.0126113187675577151369843
,0.0132267366191510978012946
,0.0140074781941803630513910
,0.0150055927752226012789061
,0.0162961962778481357638771
,0.0179902178043936655793544
,0.0202551999620866202134195
,0.0233491191724917133976103
,0.0276734929358985436154139
,0.0338480459039483538852267
,0.0427835592133911438161853
,0.0556940836228190794265913
,0.0734664140302183077402276
,0.0962243707305437956378569
,0.1195740251221220767918751
,0.1429236795137003579458934
,0.1662733339052786252221239
,0.1896229882968568924983543
,0.2129726426884351597745848
,0.2363222970800134270508153
,0.2596719514715917220826213
,0.2830216058631699893588518
,0.3063712602547482566350823
,0.3297209146463265239113127
,0.3530705690379047911875432
,0.3764202234294830584637737
,0.3997698778210613257400041
,0.4231195322126395930162346
,0.4464691866042178602924650
,0.4698188409957961275686955
,0.4931684953873743948449260
,0.5165181497789527176323077
,0.5398678041705310404196894
,0.5632174585621093632070711
,0.5865671129536876859944527
,0.6099167673452660087818344
,0.6332664217368443315692161
,0.6566160761284226543565978
,0.6799657305200009771439795
,0.7033153849115792999313612
,0.7266650393031576227187429
,0.7500146936947359455061246
,0.7733643480863142682935063
,0.7967140024778925910808880
,0.8200636568694709138682697
,1.5692768286492984053381861
,1.5247303588455765055442725
,1.4814476740034965285275348
,1.4393929174124799885703396
,1.3985312496856561192970503
,1.3588288198968017095324967
,1.3202527375363017902998308
,1.2827710452628557913357099
,1.2463526924283785390912271
,1.2109675093543592616640581
,1.1765861823378473971501990
,1.1431802293671251558038193
,1.1107219765263818267442275
,1.0791845350701034789153709
,1.0485417791481668192687948
,1.0187683241632161657008737
,0.9898395057424297371895250
,0.9617313593062802867805772
,0.9344206002174169078955401
,0.9078846044932783465597481
,0.8821013900664959050956782
,0.8570495985776623859564438
,0.8327084776854349890129470
,0.8090578638794236887576972
,0.7860781657817338397009621
,0.7637503479234449832446785
,0.7420559149827292699796999
,0.7209768964717094830163546
,0.7004958318595450039723005
,0.6805957561196017691074189
,0.6612601856889334106526235
,0.6424731048286272949709996
,0.6242189523738774781236316
,0.6064826088629174938304800
,0.5892493840341624933287790
,0.5725050046810340464986666
,0.5562356028540049734942841
,0.5404277043992808948758011
,0.5250682178232756180946694
,0.5101444234715281078607063
,0.4956439630098908311062189
,0.4815857605867275292865770
,0.4678970046166201490756009
,0.4545965634316512793411391
,0.4416734204621780013333421
,0.4291168717541225530176519
,0.4169165171041601669621457
,0.4050622514469955359750486
,0.3935442564876553972474937
,0.3823529925719386657334553
,0.3714791907883785992972037
,0.3609138452952617148739023
,0.3506482058664626699773237
,0.3406737706500266305020830
,0.3309822791336303748899184
,0.3215657053112115359994050
,0.3124162510452228591617541
,0.3035263396190998053114640
,0.2948886094746462349647231
,0.2854051910310378969981571
,0.2772455500484928836435472
,0.2693171547805389143270816
,0.2627194652915695316508504
,0.2552393325424771597376150
,0.2479714013211924417134924
,0.2409096552464307372520835
,0.2340482490041026764071574
,0.2273815034935573464736080
,0.2209039010920710033314407
,0.2146100810250899104669742
,0.2084948348272030738126404
,0.2025531018757507073502211
,0.1967799649753537438723328
,0.1911706459674847591312385
,0.1857205013345988031669975
,0.1804250177634805496484915
,0.1752798076276097238856977
,0.1702806043439633598701732
,0.1654232575563203966328985
,0.1607037280955963265416386
,0.1561180826689330114476206
,0.1516624882342719471406411
,0.1473332060271117793792683
,0.1431265852222192991316518
,0.1390390562362492088421817
,0.1350671237082445574895218
,0.1312073592340642913534055
,0.1274563939775215370975303
,0.1238109113341497174998196
,0.1202676398808774915760722
,0.1168233469032703975010179
,0.1134748328472513501097296
,0.1102189270893701583675650
,0.1070524854532675235185835
,0.1039723899143206037321008
,0.1009755509242570431505115
,0.0946120533728864593348007
,0.0952194621361701909467712
,0.0924542405434087555260447
,0.0897603599830727461039714
,0.0871350224215530905214067
,0.0845755424442972136844787
,0.0820793727141174433992177
,0.0796441315379864539503174
,0.0772676316592332268484711
,0.0749479092136446367611313
,0.0726832516428638220062908
,0.0704722232586271063459193
,0.0683136871071637757912853
,0.0662068218025061855369628
,0.0641511320855124300699401
,0.0621464520234711950696926
,0.0601929399906708309520020
,0.0582910648565354572170349
,0.0564415831440076148917129
,0.0546455072921292056564724
,0.0529040655453433331101287
,0.0512186543776538133476706
,0.0495907847209610744276809
,0.0480220235823059574120641
,0.0465139328847006261469232
,0.0485903746105567288515736
,0.0472338436884482126831841
,0.0459165223665726277002541
,0.0446373218636241866907888
,0.0433951852119001113550212
,0.0421890864027093109855926
,0.0410180295585606327635197
,0.0398834575166196261819529
,0.0387796692415851990132225
,0.0377081073758365400983017
,0.0366678885247859950857752
,0.0356581556585469500175734
,0.0346780774407039957263343
,0.0337268475823432542504143
,0.0328036842212424961662265
,0.0319078293261956247306443
,0.0310385481265251644833469
,0.0301951285669241967224430
,0.0293768807878654926446504
,0.0285831366319220896154985
,0.0278132491764608580364637
,0.0270665922933000790973068
,0.0263425602360655014555491
,0.0256405672561375516660398
,0.0249600472482537534546498
,0.0242120857531207718527089
,0.0235723838261291812612441
,0.0229525520285109030371729
,0.0224420451545947127747205
,0.0218610651639365334564236
,0.0212985582770265392815734
,0.0207540887800142653807356
,0.0202272390338104207652137
,0.0197176094721410212484702
,0.0192248186532707754370364
,0.0187485033704636490370365
,0.0182883188257903367412993
,0.0178439388740289119061888
,0.0174150563431524837976205
,0.0170013834393862549310139
,0.0166026522504431513216350
,0.0162186153579808797764450
,0.0158490465806018845928982
,0.0154937418772788989412836
,0.0151525204228525126048943
,0.0148252259265319822484352
,0.0145117282217979998854007
,0.0142119252050663009978582
,0.0139257452057293361347146
,0.0136531499119828640675944
,0.0133941379658286691817226
,0.0131487493404566467558592
,0.0129170707982209451852862
,0.0126992425185346487215288
,0.0124954662359747122046816
,0.0123060151742677200553677
,0.0121312461309953205368384
,0.0119716141724289081710308
,0.0118276907347740108111811
,0.0117001852253648536139607
,0.0115899719704121075686265
,0.0114981230675026205312328
,0.0114259491052948192191252
,0.0113750501658702873886142
,0.0113473802745959213150728
,0.0113453298003333286070315
,0.0113718321505062933129970
,0.0114305037471238574164900
,0.0115258301302341038124810
,0.0116634174741587996054770
,0.0118503363660026513060064
,0.0120955992186832523432871
,0.0124108349756183785478347
,0.0128112558765127865223477
,0.0133170693847516497659855
,0.0139555776592735318597516
,0.0147643592244850862388317
,0.0157961843769497331524398
,0.0171267499047923349442257
,0.0188670400781944941348556
,0.0211832540708104359594710
,0.0244252059900625685673337
,0.0286933687039381511707514
,0.0348715740968693621582020
,0.0437277158824142114790234
,0.0563653718906502176899664
,0.0737849309462513813784312
,0.0960722197479456779811713
,0.1217090363829601284972881
,0.1447815937482275772119067
,0.1678541511134950259265253
,0.1909267084787624746411439
,0.2139992658440299233557624
,0.2370718232092973720703810
,0.2601443805745647930294240
,0.2832169379398322694996182
,0.3062894953050997459698124
,0.3293620526703672224400066
,0.3524346100356346989102008
,0.3755071674009021753803950
,0.3985797247661696518505892
,0.4216522821314371283207834
,0.4447248394967046047909776
,0.4677973968619720812611718
,0.4908699542272395577313659
,0.5139425115925070342015601
,0.5370150689577745106717543
,0.5600876263230419871419485
,0.5831601836883094636121427
,0.6062327410535769400823369
,0.6293052984188444165525311
,0.6523778557841118930227253
,0.6754504131493793694929195
,0.6985229705146468459631137
,0.7215955278799143224333079
,0.7446680852451817989035021
,0.7677406426104492753736963
,0.7908131999757167518438905
,0.8138857573409842283140847
,0.8369583147062517047842789
,1.6143474240617667891939391
,1.5685223880766789861240795
,1.5239974156343409905645103
,1.4807356208041584366696952
,1.4387011641819895668703566
,1.3978592231985471627808693
,1.3581759632702850026930719
,1.3196185097688928333781178
,1.2821549207861622221571452
,1.2457541606716699966739270
,1.2103860743215584250265238
,1.1760213621966026931175975
,1.1426315560496147494262686
,1.1101889953415184919549574
,1.0786668043268210492868775
,1.0480388697894758021078587
,1.0182798194107272049535595
,0.9893650007510457200510245
,0.9612704608287714336256613
,0.9339729262786089503123321
,0.9074497840735660236788362
,0.8816790627944408598182235
,0.8566394144314003478157815
,0.8323100967026563212769474
,0.8086709558756851601302174
,0.7857024100768615904044623
,0.7633854330758068629236845
,0.7417015385311553909986060
,0.7206327646848456058847887
,0.7001616594924311431924480
,0.6802712661772817304139949
,0.6609451091968931990550118
,0.6421671806098908641402545
,0.6239219268325747469461362
,0.6061942357741715303731667
,0.5889694243401336626320131
,0.5722332262929987756194805
,0.5559717804603451218881105
,0.5401716192792938020517113
,0.5248196576667405466309901
,0.5099031822039922223765984
,0.4954098406236879803543616
,0.4813585731724600580427875
,0.4676765539823242168182560
,0.4543826667930369045400596
,0.4414659004640137385244714
,0.4289155563232829870834451
,0.4167212393070525711102903
,0.4048728493512392390130117
,0.3933605730279039480734582
,0.3821748754197335506965771
,0.3713064922259228795020647
,0.3607464220930151621580251
,0.3504859191644517091290822
,0.3405164858427751628511260
,0.3308298657586183355583387
,0.3214180369407708681706026
,0.3122732051817874721066914
,0.3033877975937326887390100
,0.2947544563487680679969571
,0.2852755328699622672239400
,0.2771200646173836434904558
,0.2691957386048005052003873
,0.2626017897199615647174653
,0.2551255239104430749819130
,0.2478613651813277585223005
,0.2408033002795702537390810
,0.2339454869454337948564415
,0.2272822490618832957931517
,0.2208080719223232679659930
,0.2145175976042084098338592
,0.2084056204335203166255752
,0.2024670825220232783792085
,0.1966970693555700477883619
,0.1910908054075417528139269
,0.1856436497468757496065450
,0.1803510916052151191735220
,0.1752087458628228955337391
,0.1702123484084438198582490
,0.1653577513248885022534296
,0.1606409178505079637933051
,0.1560579170678738081257109
,0.1516049182759607871773255
,0.1472781850121075153392525
,0.1430740687061782534517107
,0.1389890019726734704530458
,0.1350194915777814252955125
,0.1311621111577591092256512
,0.1274134938121682936174039
,0.1237703247491048763606614
,0.1202293342174294149549141
,0.1167872910198905767042987
,0.1134409969567137521639921
,0.1101872825966804941844046
,0.1070230048063748606868018
,0.1039450464824127062790637
,0.1009503189207300866137018
,0.0945857732899753333999371
,0.0951983790188213468974610
,0.0924351968471056190113089
,0.0897433340594028516878922
,0.0871199943677180427270557
,0.0845624946270369798329014
,0.0820682904091850212724424
,0.0796350036676038292027258
,0.0772604515989702561595820
,0.0749426756290924311887380
,0.0726799693061302570784576
,0.0704709037859437698037013
,0.0683143495526205291046296
,0.0662094930399336062398774
,0.0641558469114625745666203
,0.0621532529195667829413630
,0.0602018764934928937715419
,0.0583021924975879526908962
,0.0564549619406969765966764
,0.0546611997923522191511481
,0.0529221344521113162828740
,0.0512391598048616767058228
,0.0496137811554242455502894
,0.0480475566489535765857255
,0.0500123283191729814389781
,0.0486176225727747227112197
,0.0472632761776446003176844
,0.0459481699976133986518256
,0.0446712176679410280510929
,0.0434313647198790384051925
,0.0422275877334338314850193
,0.0410588935174732855282187
,0.0399267258822304585419438
,0.0388253901101878184931593
,0.0377563302680359036411772
,0.0367186661333109287674858
,0.0357115439984282759255940
,0.0347341360129860762806508
,0.0337856395526284214447799
,0.0328652766145184557777803
,0.0319722932395644435232818
,0.0311059589616432957681624
,0.0302655662841793092476816
,0.0294504301845605956367002
,0.0286598876470159982798869
,0.0278932972247300653423352
,0.0271500386321475301043549
,0.0264295123686142247043662
,0.0257311393747125770337103
,0.0250543607228997933233927
,0.0243101151023017748864508
,0.0236744075016904059749479
,0.0230587146247201238424829
,0.0225527013966247587284375
,0.0219761982545981261749635
,0.0214183461947060789498654
,0.0208787219070926469144389
,0.0203569212701582985536319
,0.0198525594775736669017618
,0.0193652712371966129190071
,0.0188947110483172718564671
,0.0184405535667253976661595
,0.0180024940665763667768662
,0.0175802490097099785304469
,0.0171735567407091289926502
,0.0167821783211822353476528
,0.0164058985301912610421660
,0.0160445270678959521493123
,0.0156978999725909708351512
,0.0153658813398851804010725
,0.0150483653720929529823414
,0.0147452788495436998283949
,0.0144565841198463947148145
,0.0141822827529740746327347
,0.0139224199967547274808810
,0.0136770901658912150816727
,0.0134464433390140917362610
,0.0132306934728339958828869
,0.0130301283718581677184556
,0.0128451218914675119320279
,0.0126761488526729790282666
,0.0125238032943222991899557
,0.0123888211217611631659308
,0.0122721074111487894742201
,0.0121747707694977256448476
,0.0120981656885417281077633
,0.0120439456008372466205847
,0.0120141300384959386765571
,0.0120111903998760000816803
,0.0120381607463807792368637
,0.0120987827381974517165775
,0.0121976977248589146113344
,0.0123407047937613284505076
,0.0125351130490835606379196
,0.0127902285456267424124110
,0.0131180383464872020449210
,0.0135341885658799808422881
,0.0140594038637409639996845
,0.0147215870339284897461152
,0.0155589807887364893479454
,0.0166250162891537350828841
,0.0179958763614765648863880
,0.0197824588510208121405753
,0.0221494311881596274427242
,0.0254376678655735787015768
,0.0297483990980816799531983
,0.0359285179985863664664514
,0.0447058270244898650624954
,0.0571240575652252821625687
,0.0741523072268527733141852
,0.0959648615526107195972116
,0.1212575640511283497913197
,0.1477332254270992129008278
,0.1705516083583636655074400
,0.1933699912896281181140523
,0.2161883742208925707206646
,0.2390067571521570233272769
,0.2618251400834215036894648
,0.2846435230146859840516527
,0.3074619059459504644138406
,0.3302802888772149447760285
,0.3530986718084794251382164
,0.3759170547397439055004043
,0.3987354376710083858625921
,0.4215538206022728662247800
,0.4443722035335373465869679
,0.4671905864648018269491558
,0.4900089693960663073113437
,0.5128273523273307876735316
,0.5356457352585952680357195
,0.5584641181898597483979074
,0.5812825011211242287600953
,0.6041008840523887091222832
,0.6269192669836531894844711
,0.6497376499149176698466590
,0.6725560328461821502088469
,0.6953744157774466305710348
,0.7181927987087111109332227
,0.7410111816399755912954106
,0.7638295645712400716575985
,0.7866479475025045520197864
,0.8094663304337690323819743
,0.8322847133650335127441622
,0.8551030962962979931063501
,1.6606659184782548432934846
,1.6135269155000280250078504
,1.5677252591789410107736558
,1.5232230058683389195550717
,1.4799832884594188442406448
,1.4379702858381786523267465
,1.3971491932089807885830623
,1.3574861932601629543881927
,1.3189484281478314198210455
,1.2815039722746279782228385
,1.2451218058409547762011016
,1.2097717891468509066044135
,1.1754246376228394410645706
,1.1420518975697309116412725
,1.1096259225867508568796893
,1.0781198506687159621719729
,1.0475075819532904120023886
,1.0177637570998834259938803
,0.9888637362823378129661478
,0.9607835787780263370194689
,0.9335000231364891654095572
,0.9069904679112532619456033
,0.8812329529389013593743130
,0.8562061411499765073429558
,0.8318893008967161994959838
,0.8082622887830757107963109
,0.7853055329829217168224886
,0.7630000170326944886056708
,0.7413272640852632822117130
,0.7202693216120741315222631
,0.6998087465411004792770200
,0.6799285908184732329928579
,0.6606123873820217706764879
,0.6418441365353025895856831
,0.6236082927110004892057304
,0.6058897516128497473530956
,0.5886738377254558951534591
,0.5719462921815277045567427
,0.5556932609760856234260018
,0.5399012835171193014360824
,0.5245572815019042822726192
,0.5096485481076900025954046
,0.4951627374846829798826775
,0.4811188069058452421167260
,0.4674439154023156683948059
,0.4541569630102305077379299
,0.4412469443335684249341000
,0.4287031662898667661032448
,0.4165152392544169690502542
,0.4046730684563001889664235
,0.3931668456192066174459399
,0.3819870408401832562184097
,0.3711243946996717335551352
,0.3605699105963895423343502
,0.3503148473008173002796184
,0.3403507117212395405303482
,0.3306692518764661192776089
,0.3212624500695455131982214
,0.3121225162569262190359609
,0.3032418816076745127219283
,0.2946131922474579112325443
,0.2851390321089372070773038
,0.2769879880845530495392381
,0.2690679773900733762204140
,0.2624779982498007813163099
,0.2550058349651938005564489
,0.2477456794377246862559616
,0.2406915217343604529443013
,0.2338375228377466696905174
,0.2271780097989387625645463
,0.2207074710085831503736387
,0.2144205515740929823831351
,0.2083120487878318272123579
,0.2023769076682207235240440
,0.1966102165520241529250711
,0.1910072027118636106557403
,0.1855632279683266661063357
,0.1802737842610927232467333
,0.1751344891385268887074034
,0.1701410811206870987710715
,0.1652894148871997537231238
,0.1605754562397933293826924
,0.1559952767903750869837864
,0.1515450483304896234226788
,0.1472210368480053044315525
,0.1430195961730978126968949
,0.1389371612590917515195343
,0.1349702411352168285318953
,0.1311154116080820164480514
,0.1273693078362495012534339
,0.1237286169564168758494560
,0.1201900709981324200104069
,0.1167504403833842380189267
,0.1134065283635351112367928
,0.1101551667938128198365177
,0.1069932136792681454107168
,0.1039175529399908315397738
,0.1009250968320046099035991
,0.0945596876243847278553645
,0.0951776254170625807260464
,0.0924166426231564086535286
,0.0897269580042822090248933
,0.0871057773458645406838841
,0.0845504201723682596858467
,0.0820583454433023024021665
,0.0796271793191716120707824
,0.0772547440912913219168701
,0.0749390871908950234603353
,0.0726785090495082330974697
,0.0704715884861791819204768
,0.0683172042582293470580623
,0.0662145514385625022502069
,0.0641631513789274326997614
,0.0621628541858302505196399
,0.0602138328708998749050352
,0.0583165686330511176538316
,0.0564718270742192579580987
,0.0546806255284044903652863
,0.0529441920767258419888712
,0.0512639172083661082135464
,0.0496412994468553095406271
,0.0514758207866683054065859
,0.0500419504765250294786583
,0.0486496234269607197298058
,0.0472976894081793414192916
,0.0459850319520750047685986
,0.0447105674556454169010777
,0.0434732443140106172840831
,0.0422720420823123887998918
,0.0411059706656921597378584
,0.0399764750123679166171620
,0.0388778676979427209592366
,0.0378115944642454446245061
,0.0367767787889189054495453
,0.0357725708515825371880403
,0.0347981468932699253282514
,0.0338527086041240585223555
,0.0329354825396011019478237
,0.0320457195655518209398416
,0.0311826943326826491742487
,0.0303457047810455453340506
,0.0295340716753715488984700
,0.0287471381722492688726156
,0.0279842694203573036371147
,0.0272448521951998250123506
,0.0265282945700499872554445
,0.0258340256251218571004191
,0.0251614951973250164374285
,0.0244214765039873597796127
,0.0237903192932218260358113
,0.0231793497013435406683968
,0.0226784716214106750464818
,0.0221070960395468932291330
,0.0215545857707941310166255
,0.0210205330452093719362239
,0.0205045507421751926901976
,0.0200062726942796462181740
,0.0195253540870238412319182
,0.0190614719672556089113957
,0.0186143258723581520031054
,0.0181836385941401730559353
,0.0177691571019007836518266
,0.0173706536412555831438986
,0.0169879270432452232630904
,0.0166208042905923412957403
,0.0162691423498611646702994
,0.0159328303823100328462381
,0.0156117923618830853338402
,0.0153059902116496095170195
,0.0150154275731413152511484
,0.0147401543871818786757277
,0.0144802724492702570430191
,0.0142359420993083737178031
,0.0140073905171327998953057
,0.0137949217606032643185232
,0.0135989291105626710493004
,0.0134199102212637904479875
,0.0132584857175485869296150
,0.0131154220855491492059297
,0.0129916602598868780038543
,0.0128883504195477453097007
,0.0128068961124198181511513
,0.0127490092100572775107858
,0.0127167794369047390534710
,0.0127127632684457328449135
,0.0127400986292639274710670
,0.0128026545908861231343190
,0.0129052292155158367797929
,0.0130538145037777351953334
,0.0132559561196373184438491
,0.0135212496457018209461420
,0.0138620344158162083630925
,0.0142943796604297901353675
,0.0148395109248334582802142
,0.0155259058893441291571147
,0.0163924306038678579966472
,0.0174931129697410703283111
,0.0189045238288899526690745
,0.0207373328577704733877152
,0.0231544942098540901254111
,0.0263995886644267825638099
,0.0308392178829614664603564
,0.0370195113619160090512317
,0.0457184880046482763904514
,0.0579230175339564001824044
,0.0745692461383036242494882
,0.0959052370116141583711311
,0.1208264561416538818150457
,0.1471799403325806665510100
,0.1731178011750992562500784
,0.1957030360146614356153805
,0.2182882708542236149806826
,0.2408735056937857943459846
,0.2634587405333480014668623
,0.2860439753729102085877400
,0.3086292102124724157086177
,0.3312144450520346228294954
,0.3537996798915968299503731
,0.3763849147311590370712509
,0.3989701495707212441921286
,0.4215553844102834513130063
,0.4441406192498456584338840
,0.4667258540894078655547617
,0.4893110889289700726756394
,0.5118963237685322242853658
,0.5344815586080944314062435
,0.5570667934476566385271212
,0.5796520282872188456479989
,0.6022372631267810527688766
,0.6248224979663432598897543
,0.6474077328059054670106320
,0.6699929676454676741315097
,0.6925782024850298812523874
,0.7151634373245920883732651
,0.7377486721641542954941428
,0.7603339070037165026150205
,0.7829191418432787097358982
,0.8055043766828409168567759
,0.8280896115224031239776536
,0.8506748463619653310985314
,0.8732600812015275382194091
,1.7074250450121364330868801
,1.6597736769821698210591876
,1.6126600973417519746533344
,1.5668831460835364044470452
,1.5224049000279276100400239
,1.4791885119550607363692052
,1.4371981800782358540402583
,1.3963991183834842946254184
,1.3567575278107317782172458
,1.3182405682527260637471045
,1.2808163313484834944233626
,1.2444538140488017319285063
,1.2091228929320101403988019
,1.1747942992483051405372407
,1.1414395946726567654394557
,1.1090311477456686883868997
,1.0775421109831448962523837
,1.0469463986353571005594176
,1.0172186650776480210112140
,0.9883342838144740793993037
,0.9602693270795437108233727
,0.9330005460151910012811527
,0.9065053514146187430000623
,0.8807617950111091831288945
,0.8557485512987793585537588
,0.8314448998698903414705796
,0.8078307082541750228088517
,0.7848864152460803822464186
,0.7625930147062215391784434
,0.7409320398237817517639314
,0.7198855478269682306446953
,0.6994361051290397535140642
,0.6795667728977912158683239
,0.6602610930367340813518240
,0.6415030745665601941141176
,0.6232771803957812828400620
,0.6055683144697128206246362
,0.5883618092871827354173320
,0.5716434137745057819657291
,0.5553992815063022447930052
,0.5396159592626644796453661
,0.5242803759119056827842087
,0.5093798316076517673778312
,0.4949019872882264303726174
,0.4808658182329078045746940
,0.4671984675085364413504863
,0.4539188523861129587189112
,0.4410159735476622544503300
,0.4284791438251992490293674
,0.4162979793498237657267680
,0.4044623909525262850372940
,0.3929625758096472742941785
,0.3817890093261434580895752
,0.3709324372500218958137452
,0.3603838680115049597496579
,0.3501345652806872599249743
,0.3401760407376375194843376
,0.3305000470490816466551109
,0.3210985710459743347477968
,0.3119638270964308346400173
,0.3030882506686236044224358
,0.2944644920783688890608687
,0.2849953797753541073767281
,0.2768490268499560480464083
,0.2689335926674126797664144
,0.2623478268313476080564328
,0.2548800163421766629134879
,0.2476241092057391290914836
,0.2405740990129633660732367
,0.2337241501889396888547168
,0.2270685931491957798566972
,0.2206019195745233529848406
,0.2143187777919318692809725
,0.2082139682467530339415873
,0.2022824390478136780124885
,0.1965192815639215384582172
,0.1909197260456576561438169
,0.1854791372417688433138494
,0.1801930099744379898396573
,0.1750569646326937678360025
,0.1700667425386385434027403
,0.1652182011376142345415730
,0.1605073089616917969557619
,0.1559301403169131572390427
,0.1514828696496521576175809
,0.1471617655574920247030235
,0.1429631844263414552909097
,0.1388835636991861688382954
,0.1349194148136473869747931
,0.1310673158856539843863942
,0.1273239042645958885024982
,0.1236858691400048865238759
,0.1201499444388193643673546
,0.1167129023122632502929008
,0.1133715475679683559739885
,0.1101227134509881466772896
,0.1069632592110668356522041
,0.1038900699070761796116713
,0.1009000588874282150486650
,0.0945340122440984920171303
,0.0951574032532780944571016
,0.0923987939374458777663790
,0.0897114622773772796282543
,0.0870926165097321153263366
,0.0845395792878447238649642
,0.0820498135066822509298134
,0.0796209501728707136347651
,0.0772508174005619857593885
,0.0749374694355837700499023
,0.0726792144679840462773157
,0.0704746398988913697047920
,0.0683226336918946741683101
,0.0662224004696535667457979
,0.0641734711176821792655289
,0.0621757048298903491900802
,0.0602292827710644157468423
,0.0583346928322695107427265
,0.0564927053042125065784873
,0.0547043396751753993600964
,0.0529708231553137759428651
,0.0512935419168545694845740
,0.0529820615544817630215846
,0.0515080187767860825376331
,0.0500767383916153607792410
,0.0486870383301207937387645
,0.0473377713095748942073726
,0.0460278239154697441093411
,0.0447561157146406374263137
,0.0435215983988044979868803
,0.0423232549578627312292234
,0.0411600988822421604007573
,0.0400335764731643214964230
,0.0389380087349267198226777
,0.0378748434039053172295297
,0.0368432082953861969598641
,0.0358422581603866433064276
,0.0348711740668874101145569
,0.0339291628115508323015881
,0.0330154563624441496627604
,0.0321293113334436553074624
,0.0312700084911691073008555
,0.0304368522954941086999803
,0.0296291704749014894737513
,0.0288463136382004006752489
,0.0280876549244163144225528
,0.0273525896929694908865649
,0.0266405352566548743464825
,0.0259509306603480441322240
,0.0252832365087723928698260
,0.0245480397043129246192894
,0.0239220812134965793438468
,0.0233165180085748262317491
,0.0228215260243984606469692
,0.0222560428043247458818055
,0.0217096840963852157069258
,0.0211820617348930893830694
,0.0206728101354390833566121
,0.0201815868404693100901515
,0.0197080731984330438655295
,0.0192519751922654476505858
,0.0188130244351508053857192
,0.0183909793661046899737599
,0.0179856266657630430028103
,0.0175967829369520281646011
,0.0172242967098980188922486
,0.0168680507794061046444867
,0.0165279650186296346581205
,0.0162039996992065747638545
,0.0158961594554222172825941
,0.0156044980318675152036745
,0.0153291240334070526935006
,0.0150702078789509610196040
,0.0148279901552014099774812
,0.0146027919654938883459172
,0.0143950274507212826885505
,0.0142052192092893860009273
,0.0140340172750281939884065
,0.0138822225116753458079577
,0.0137508155669186973163454
,0.0136409932431591756490930
,0.0135542131772781685589147
,0.0134922508940676384031621
,0.0134572715639223999123386
,0.0134519216549780305097750
,0.0134794472541151667127624
,0.0135438482611402993133209
,0.0136500816870757293169936
,0.0138043331141748052554030
,0.0140143840567199667868081
,0.0142901161222154429036868
,0.0146442139679999645818231
,0.0150931593697885852584095
,0.0156586602953312330199775
,0.0163697409834857691979249
,0.0172658468408813589589634
,0.0184015350395950426365399
,0.0198536639456725061414488
,0.0217325339691923219431757
,0.0241992118938568964714442
,0.0274921609832783249427468
,0.0319664570565540082092149
,0.0381451811262846565697693
,0.0467662819970243934242227
,0.0587626482510666334202476
,0.0750363329472811951825761
,0.0958959808073957115093222
,0.1204212135270811834253379
,0.1466161777105577102009448
,0.1725975511242210103102224
,0.1974967503194339502048393
,0.2198681240250955903903218
,0.2422394977307572583313799
,0.2646108714364189262724381
,0.2869822451420805942134962
,0.3093536188477422621545543
,0.3317249925534039300956124
,0.3540963662590655980366705
,0.3764677399647272659777286
,0.3988391136703889339187867
,0.4212104873760506018598448
,0.4435818610817122698009030
,0.4659532347873739377419611
,0.4883246084930356056830192
,0.5106959821986972736240773
,0.5330673559043589415651354
,0.5554387296100206095061935
,0.5778101033156822774472516
,0.6001814770213439453883097
,0.6225528507270056133293679
,0.6449242244326672812704260
,0.6672955981383289492114841
,0.6896669718439906171525422
,0.7120383455496522850936003
,0.7344097192553139530346584
,0.7567810929609756209757165
,0.7791524666666372889167747
,0.8015238403722989568578328
,0.8238952140779606247988909
,0.8462665877836222927399490
,0.8686379614892839606810071
,0.8910093351949456286220652
,1.7563350244741007255555587
,1.7064551419568834145223946
,1.6588312112787464425167627
,1.6117444923965777991980985
,1.5659936431953569435648888
,1.5215407621198888676872230
,1.4783490229640721125292657
,1.4363826443617189188017846
,1.3956068601430442477351335
,1.3559878905322746422967839
,1.3174929141625328909981363
,1.2800900408847852851579319
,1.2437482853486463429959485
,1.2084375413323649173236163
,1.1741285568018415830238155
,1.1407929096771629584594621
,1.1084029842869680404504606
,1.0769319484910859774373648
,1.0463537314525248600460827
,1.0166430020404193523830827
,0.9877751478460843337359165
,0.9597262547948181010681878
,0.9324730873366215977426918
,0.9059930691994581009041099
,0.8802642646891826183619401
,0.8552653605207022335932265
,0.8309756481654093640543124
,0.8073750067003463426473786
,0.7844438861450052646873132
,0.7621632912720768260328441
,0.7405147658788795439477326
,0.7194803775066003215243882
,0.6990427025948584560666177
,0.6791848120594917714853977
,0.6598902572818139411481297
,0.6411430564979350155141447
,0.6229276815770592445886678
,0.6052290451779269719878585
,0.5880324882728105162499332
,0.5713237680286148423292047
,0.5550890460346837862459779
,0.5393148768668467596398841
,0.5239881969769751846044414
,0.5090963138968350731872192
,0.4946268957442510050270812
,0.4805989368394475991230763
,0.4669395633741614815015453
,0.4536677108451407924860632
,0.4407723863648994044872609
,0.4282429090234350921306827
,0.4160689010425080991417701
,0.4042402791814954654547876
,0.3927472463877619834882182
,0.3815802836847116408236502
,0.3707301422908760857310995
,0.3601878359636154214307169
,0.3499446335611924863151501
,0.3399920518171781758098859
,0.3303218483213303802159544
,0.3209260147012567010449402
,0.3117967699993414720793794
,0.3029265542395444543721794
,0.2943080221788073047584078
,0.2848442593032216030302095
,0.2767028806806739460455447
,0.2687923002903334634972055
,0.2622110066824082652559014
,0.2547478148930933383731201
,0.2474964167630437361644624
,0.2404508096241022019334821
,0.2336051615567365791203969
,0.2269538065500710244393190
,0.2204912397805811052897695
,0.2142121129970475656989493
,0.2081112299968083390044882
,0.2021835421752287420549266
,0.1964241441266113830099727
,0.1908282692704913185988147
,0.1853912854725125736177205
,0.1801086906240207952123455
,0.1749761081394202999472753
,0.1699892823256909379914248
,0.1651440735748251897874184
,0.1604364533281419924470867
,0.1558624987624262492325045
,0.1514183871527656211064539
,0.1471003898770245899019216
,0.1429048660433374084988145
,0.1388282557458791754978478
,0.1348670729862666561871265
,0.1310178983385010265116932
,0.1272773714839481873362104
,0.1236421837981416943508250
,0.1201090712308252456130830
,0.1166748077812302109013132
,0.1133361999276551457249695
,0.1100900824187087401195839
,0.1069333158672614719764127
,0.1038627866012881151291936
,0.1008754092128233137426463
,0.0945089992208361651115922
,0.0951379470407888588878720
,0.0923819008515314593621426
,0.0896971127849544025423256
,0.0870807939641097816796389
,0.0845302706985622265278835
,0.0820430104452898323330601
,0.0796166497852695970172121
,0.0772490234821602977932642
,0.0749381935114611791304284
,0.0726824768075921973098374
,0.0704804703846965835412064
,0.0683310724549047038278715
,0.0662334982029570001893504
,0.0641872889827305725951589
,0.0621923138797535052235688
,0.0602487628303892755465831
,0.0583571307948653819619445
,0.0565181928353219037441946
,0.0547329703353918242680898
,0.0530026889952157145846634
,0.0545322943113931424274909
,0.0530170533603789642662640
,0.0515458302606285473368430
,0.0501174103534898982004187
,0.0487306148268679406587722
,0.0473842997759736997420710
,0.0460773552965641208789549
,0.0448087046101645625206800
,0.0435773032207565011453276
,0.0423821381023796392439884
,0.0412222269170277530458968
,0.0400990175996102579669689
,0.0390068409092645049240922
,0.0379471469850799145162590
,0.0369190687537509429350102
,0.0359217663706432599468599
,0.0349544266288819363563967
,0.0340162624018617437693379
,0.0331065121200628809106092
,0.0322244392832635243029138
,0.0313693320094714234169686
,0.0305405026221654031515218
,0.0297372872777325394921810
,0.0289590456353465350303189
,0.0282051605718933312560992
,0.0274750379450477665022046
,0.0267681064081093308959503
,0.0260838172806855915497604
,0.0254216444802490351695390
,0.0246919652943274996192979
,0.0240719648686404073811840
,0.0234726103706763590539541
,0.0229843878212117880277532
,0.0224257005199452567889562
,0.0218864530722856429068024
,0.0213662822253494789903616
,0.0208648498792283615399512
,0.0203818439704328766004515
,0.0199169795389905375515571
,0.0194700000019653318705792
,0.0190406786763707425169656
,0.0186288205764228165239871
,0.0182342645428063519774664
,0.0178568857807513692304013
,0.0174965988128150048974696
,0.0171533610325429151932664
,0.0168271768914505896741485
,0.0165181028919688006884048
,0.0162262535595240446617549
,0.0159518086651124664510082
,0.0156950219517658952350647
,0.0154562316112121858613371
,0.0152358732639210330689350
,0.0150344956789060443802519
,0.0148527801717576925927267
,0.0146915645546117478587034
,0.0145518727889241295675449
,0.0144349518840856082257940
,0.0143423185036920652207781
,0.0142758167355917942736854
,0.0142376923415152758373159
,0.0142306870290226789022014
,0.0142581599643485483486227
,0.0143242461214422855952932
,0.0144340646738346650712614
,0.0145939965215910998769244
,0.0148120586790518853764764
,0.0150984162451917314218264
,0.0154660925631651350459217
,0.0159319698917888517841757
,0.0165182200415495729350912
,0.0172543830258383747155992
,0.0181804369727286870006555
,0.0193513982198480448404521
,0.0208443105414624629823095
,0.0227689655278477225130995
,0.0253589478662713807555207
,0.0286237600578851600352515
,0.0331307628365161907502134
,0.0393061621422668913683474
,0.0478993746270290621236398
,0.0596433359452621658647331
,0.0755540555413648090565815
,0.0959394240292370248379683
,0.1200472064246392717157264
,0.1460469878951260458421757
,0.1720482565627206861247345
,0.1970529870472376987589058
,0.2209061455816395402873553
,0.2430813496156590536312336
,0.2652565536496785947306876
,0.2874317576836981080745659
,0.3096069617177176214184442
,0.3317821657517371347623225
,0.3539573697857566481062008
,0.3761325738197761614500791
,0.3983077778537956747939575
,0.4204829818878151881378358
,0.4426581859218347014817141
,0.4648333899558542148255924
,0.4870085939898737281694707
,0.5091837980238932415133490
,0.5313590020579127548572274
,0.5535342060919322682011057
,0.5757094101259517815449840
,0.5978846141599712948888623
,0.6200598181939908082327406
,0.6422350222280103215766189
,0.6644102262620298349204973
,0.6865854302960493482643756
,0.7087606343300688616082539
,0.7309358383640883749521322
,0.7531110423981078882960105
,0.7752862464321274016398888
,0.7974614504661469149837671
,0.8196366545001664283276455
,0.8418118585341859416715238
,0.8639870625682054550154021
,0.8861622666022249683592804
,0.9083374706362444817031587
,1.8065859137862516625716580
,1.7552806288433340231591728
,1.7054307962963792810739960
,1.6578358501180492368121122
,1.6107775066209637504499597
,1.5650542315277484739510783
,1.5206281461271506927346309
,1.4774624464120948985623727
,1.4355213725888997799984281
,1.3947701794516280671132336
,1.3551751075970615012522558
,1.3167033554564695485566972
,1.2793230521209522088099675
,1.2430032309381897626110458
,1.2077138038579151579909876
,1.1734255365059835796159859
,1.1401100239655461709986639
,1.1077396672456247816995756
,1.0762876504175740155488938
,1.0457279184004959482479080
,1.0160351553772426491661918
,0.9871847638231523447416293
,0.9591528441301866436674572
,0.9319161748096244091144058
,0.9054521932569773445820260
,0.8797389770632290106888718
,0.8547552258570068062226710
,0.8304802436627031214655403
,0.8068939217600343827285769
,0.7839767220309460382665634
,0.7617096607801807639503977
,0.7400742930162529376048042
,0.7190526971799713340516291
,0.6986274603080259160137189
,0.6787816636195472819181873
,0.6594988685138997164258967
,0.6407631029683132917185162
,0.6225588483242667781070168
,0.6048710264518196710881170
,0.5876849872813110220448607
,0.5709864966919875328699163
,0.5547617247472031998256625
,0.5389972342657397552656562
,0.5236799697185517965536405
,0.5087972464397758631804436
,0.4943367401400555194435071
,0.4803174652726767135391128
,0.4666665301937335530446660
,0.4534028896717277601347007
,0.4405155576221043145501710
,0.4279938597559036494999418
,0.4158274247395301048690897
,0.4040061756059459274759149
,0.3925203214102463977752677
,0.3813603491227718356171295
,0.3705170157531297858710673
,0.3599813406986964170464205
,0.3497445983113717793422381
,0.3397983106765444238916984
,0.3301342405984154515508067
,0.3207443847860009800143644
,0.3116209672342902803343634
,0.3027564327951863254462239
,0.2941434409329645172093137
,0.2846853472102870430404664
,0.2765492434498404428211416
,0.2686438112362376506858652
,0.2620672651549593723530052
,0.2546089746168114231750224
,0.2473623625457251617998367
,0.2403214302453158812689082
,0.2334803496781306109131293
,0.2268334586296681942840792
,0.2203752559911754116406257
,0.2141003971488399104661227
,0.2080036894644309297675022
,0.2020800878293106950245317
,0.1963246902700075680048286
,0.1907327335792441957984522
,0.1852995889415110786213603
,0.1800207575171593465945818
,0.1748918659438347122936364
,0.1699086617093408801970611
,0.1650670083463089687914049
,0.1603628803971719196663770
,0.1557923580988899991961461
,0.1513516217417794074151516
,0.1470369456669219088151834
,0.1428446918832026735213248
,0.1387713033091377001770894
,0.1348132966770964058511595
,0.1309672551785538152646637
,0.1272298209781678179908226
,0.1235976877804201290445008
,0.1200675936928686793336851
,0.1166363146912685333500548
,0.1133006590493806503561203
,0.1100574631448384271825702
,0.1069035890860421250669887
,0.1038359246176793065918886
,0.1008513857485149461945539
,0.0944849416021120991349136
,0.0951195280945936749716907
,0.0923662517893660689471957
,0.0896842154102109462288084
,0.0870706334674943710494333
,0.0845228365320949970307396
,0.0820382973393584402632683
,0.0796146588741840355307744
,0.0772497634879653616302164
,0.0749416819205582646068464
,0.0726887409612199386632625
,0.0704895483937735822799198
,0.0683430138433592793134608
,0.0662483641825090119326092
,0.0642051522669606772319995
,0.0622132579566626320310974
,0.0602728806305736358739367
,0.0583845227165052937934320
,0.0565489641165189266258650
,0.0547672277976358409801172
,0.0561277976618094823213490
,0.0545703154710135279747973
,0.0530581440631905307259153
,0.0515900354353932069639832
,0.0501647785296340242844337
,0.0487811982723858686417095
,0.0474381546481119145686201
,0.0461345418064109044631316
,0.0448692872023856090257787
,0.0436413507698423519531872
,0.0424497241269066807878296
,0.0412934298135798696915977
,0.0401739177651013329439778
,0.0390855300493457916144457
,0.0380297197312593759921384
,0.0370056257929026605202338
,0.0360124148133213195510649
,0.0350492804134103982938164
,0.0341154427380897032340279
,0.0332101479771698404608316
,0.0323326679265658056827704
,0.0314822995918346559829359
,0.0306583648363656542656930
,0.0298602100769940932700752
,0.0290872060302282443855493
,0.0283387475129088205194616
,0.0276142533017310655429899
,0.0269131660566085013919224
,0.0262349523141121483693627
,0.0255791025580405749495494
,0.0248557584598132833009210
,0.0242426098409610352168997
,0.0236504112350981211820855
,0.0231700026597594400945557
,0.0226191847377919912076560
,0.0220881925887549922238318
,0.0215766948582434212045023
,0.0210843887990883049887714
,0.0206110016253494565674487
,0.0201562921199927268245400
,0.0197200525526576402046697
,0.0193021109378721245075639
,0.0189023337082982467727277
,0.0185206289016364919475244
,0.0181569498657270858577029
,0.0178112997216607997497118
,0.0174837366219374977516221
,0.0171743800223264631021891
,0.0168834181856902625085137
,0.0166111172576492334418408
,0.0163578322374954704399030
,0.0161240201600511140478389
,0.0159102564440314689364619
,0.0157172547311720499363386
,0.0155458914311631703208949
,0.0153972361358078683318817
,0.0152725894488459894987598
,0.0151735303180853906696024
,0.0151019761428066862096742
,0.0150602579402546819103970
,0.0150512175594706316961169
,0.0150783322482589982743706
,0.0151458766492048348129007
,0.0152591358486484501844060
,0.0154246884678303462778981
,0.0156507874167918711871827
,0.0159478787428417034810479
,0.0163293184564096936772781
,0.0168123771878453849570878
,0.0174196701327142579318608
,0.0181812219448858093662214
,0.0191374943936248841092063
,0.0203438908614793564910705
,0.0218775376813050044522146
,0.0238475805804742937987761
,0.0264739295530327552186112
,0.0297951209466927637026235
,0.0343328125822460750171672
,0.0405031131097551566622172
,0.0489696197602784086266858
,0.0605654707902084019077726
,0.0761228266759590432855020
,0.0960376067956548312709586
,0.1197095925355498441389202
,0.1454779146506694764706680
,0.1714717171342051149629526
,0.1965758022664104431864729
,0.2205306332683206471667603
,0.2434562214443130589991426
,0.2654514837592819587186455
,0.2874467460742508584381483
,0.3094420083892197581576511
,0.3314372707041886578771539
,0.3534325330191575575966567
,0.3754277953341264573161595
,0.3974230576490953570356623
,0.4194183199640642567551652
,0.4414135822790331564746680
,0.4634088445940020561941708
,0.4854041069089709559136736
,0.5073993692239398001220252
,0.5293946315389086443303768
,0.5513898938538774885387284
,0.5733851561688463327470799
,0.5953804184838151769554315
,0.6173756807987840211637831
,0.6393709431137528653721347
,0.6613662054287217095804863
,0.6833614677436905537888379
,0.7053567300586593979971894
,0.7273519923736282422055410
,0.7493472546885970864138926
,0.7713425170035659306222442
,0.7933377793185347748305958
,0.8153330416335036190389474
,0.8373283039484724632472989
,0.8593235662634413074556505
,0.8813188285784101516640021
,0.9033140908933789958723537
,0.9253093532083478400807053
,1.8582094727015825430527229
,1.8054398462404543934667345
,1.7541672232550260535077769
,1.7043491298924680066306792
,1.6567847979884684495033298
,1.6097564253925311650306185
,1.5640622750981652000490385
,1.5196644925227393851940860
,1.4765262971068175978928139
,1.4346119518427957739703515
,1.3938867336681237674156364
,1.3543169046986254233644331
,1.3158696842780928104588156
,1.2785132218209593890634324
,1.2422165704258820717598155
,1.2069496612375740784983691
,1.1726832785367862221903579
,1.1393890355369249434147605
,1.1070393508676543703472817
,1.0756074257259498061500835
,1.0450672216757019850064125
,1.0153934390775083418390068
,0.9865614961308092345504406
,0.9585475085110500836904635
,0.9313282695850383374747139
,0.9048812311881567760352141
,0.8791844849475691781037767
,0.8542167441360078994350147
,0.8299573260412028696819675
,0.8063861348364194103766067
,0.7834836449380357947802622
,0.7612308848364917057693901
,0.7396094213873488643073983
,0.7186013445496223228659005
,0.6981892525588992981511183
,0.6783562375231749763671019
,0.6590858714296665699095001
,0.6403621925512217316622809
,0.6221696922412569552562900
,0.6044933021064254896614898
,0.5873183815464516621673852
,0.5706307056507249342303112
,0.5544164534413112965793857
,0.5386621964519564542683838
,0.5233548876324400911386192
,0.5084818505671420130198612
,0.4940307689959431147741498
,0.4800206786577488338174646
,0.4663786690603011209077522
,0.4531237153478364088066144
,0.4402448386322568296691315
,0.4277313716293346113062057
,0.4155729498242877184566169
,0.4037595028886308834437102
,0.3922812463412527206330083
,0.3811286734468933290465031
,0.3702925473453845262028494
,0.3597638934052412307273983
,0.3495339917953724229171542
,0.3395943702688770104991534
,0.3299367971530818288705689
,0.3205532745401397098916618
,0.3114360316726802468956237
,0.3025775185191403870987870
,0.2939703995335206654360150
,0.2845183139232548841235371
,0.2763878040277686909398369
,0.2684878325642969243425284
,0.2619163267629485147836021
,0.2544632377560432368035492
,0.2472217063149151072831700
,0.2401857379606820719342153
,0.2333495087794212052845211
,0.2267073605904222077800370
,0.2202537962333366294842563
,0.2139834749618619302857780
,0.2078912079290312908685934
,0.2019719537460208935719663
,0.1962208140926425536942901
,0.1906330293533456954335747
,0.1852039742477061545766759
,0.1799291534192023755966972
,0.1748041969408508089500742
,0.1698248556914611073764831
,0.1649869965524737025486246
,0.1602865973733978155468805
,0.1557197416547569934763828
,0.1512826129023643884075057
,0.1469714886169296297335762
,0.1427827338997263995068465
,0.1387127946794341482039670
,0.1347581905980976268999427
,0.1309155076356990632380217
,0.1271813906026341700616911
,0.1235525356860289469818071
,0.1200256832968778220038786
,0.1165976115268527041335389
,0.1132651305817004155906957
,0.1100250786069264102851051
,0.1068743193549148012833072
,0.1038097421546428089644820
,0.1008282646300348167622829
,0.0944621787559472569917318
,0.0951024592408665769838194
,0.0923521784225024428005568
,0.0896731210831340774802811
,0.0870625056968091920461816
,0.0845176677896912059706480
,0.0820360861942282665326687
,0.0796154112439748512519699
,0.0772534939426537115014781
,0.0749484149642156011195127
,0.0726985122034800174128932
,0.0705024055116869746706598
,0.0683590172281313690483273
,0.0662675871652947251488897
,0.0642276808242664282166956
,0.0622391898094399598218018
,0.0603023236717721011768134
,0.0584175927291652810624534
,0.0565857817773832705299242
,0.0577698858808279799847973
,0.0561691025499606796933527
,0.0546149615973220425857448
,0.0531061809192785103106438
,0.0516415164956473132784609
,0.0502197614081914128769668
,0.0488397448947801154917059
,0.0475003314388964814618532
,0.0462004198942184418630319
,0.0449389426440354664005206
,0.0437148647952786961745630
,0.0425271834069331708394479
,0.0413749267525579597637453
,0.0402595472467986575937360
,0.0391754000937675414539818
,0.0381239419565288922830959
,0.0371043190301042699608125
,0.0361157055712008345782493
,0.0351573033892544004053171
,0.0342283413799623417728135
,0.0333280751033629071833353
,0.0324557864089036474108951
,0.0316107831103576500386687
,0.0307923987139949451030674
,0.0299999922038959102033040
,0.0292329478890937799473448
,0.0284906753179711320911327
,0.0277726092659414634800097
,0.0270782098041374083563504
,0.0264069624577779431262581
,0.0257583784631528478481499
,0.0250423349272176770652365
,0.0244370956193741273310138
,0.0238531773083553652603506
,0.0233818248878715044536403
,0.0228401593522432402871836
,0.0223187948778611720823672
,0.0218174412821979940568795
,0.0213358416664168604182095
,0.0208737744264960063678149
,0.0204310556490385521188902
,0.0200075419285275640790545
,0.0196031337023197457791746
,0.0192177792299280704446662
,0.0188514792200817557499271
,0.0185042924140082498674076
,0.0181763421694242158221932
,0.0178678243239859847746320
,0.0175790166164777328372537
,0.0173102900948506471801025
,0.0170621229287701049737169
,0.0168351170385296206033487
,0.0166300187553247401373024
,0.0164477439667036207104900
,0.0162894093254513407098560
,0.0161563710780545828626931
,0.0160502735972430712885206
,0.0159731104475343381465802
,0.0159273023523685657021343
,0.0159157955511013415872412
,0.0159421897892301524246594
,0.0160109038001366790759938
,0.0161273923915964054187633
,0.0162984345215868922651659
,0.0165325197052669653485779
,0.0168403727675624330373250
,0.0172356759460325879851350
,0.0177360763605158462674627
,0.0183646117374760484142193
,0.0191517581234246433985469
,0.0201384115855618890666978
,0.0213802887596788622481814
,0.0229544957249721223724315
,0.0249693987713366545577731
,0.0276304852265189977711390
,0.0310070322072942966551423
,0.0355733316994288478740671
,0.0417367328778830148916512
,0.0501263928742378614411557
,0.0615294626308800565728241
,0.0767430065715326986675038
,0.0961922987714641936074500
,0.1194132539026643291535379
,0.1449148903299738444516720
,0.1708706011127165413920892
,0.1960642508165067465775167
,0.2201252503589951614593190
,0.2431306671735975755144210
,0.2652328950494091119871598
,0.2870631011557201461847910
,0.3088933072620311803824222
,0.3307235133683422145800535
,0.3525537194746532487776847
,0.3743839255809642829753159
,0.3962141316872753171729471
,0.4180443377935863513705783
,0.4398745438998973855682095
,0.4617047500062084197658407
,0.4835349561125194539634720
,0.5053651622188305436722544
,0.5271953683251415778698856
,0.5490255744314526120675168
,0.5708557805377636462651481
,0.5926859866440746804627793
,0.6145161927503857146604105
,0.6363463988566967488580417
,0.6581766049630077830556729
,0.6800068110693188172533041
,0.7018370171756298514509353
,0.7236672232819408856485666
,0.7454974293882519198461978
,0.7673276354945629540438290
,0.7891578416008739882414602
,0.8109880477071850224390914
,0.8328182538134960566367226
,0.8546484599198070908343539
,0.8764786660261181250319851
,0.8983088721324291592296163
,0.9201390782387401934272475
,0.9419692843450512276248787
,1.9112377872763532948852117
,1.8569639701529205844110493
,1.8042298387760900002518838
,1.7529917080520949212996129
,1.7032071327025555262935086
,1.6556751313616926424288067
,1.6086784098782369589741847
,1.5630150174165009513416180
,1.5186471248753787843810414
,1.4755379764580129897666438
,1.4336518592209364086897949
,1.3929540734872303264779703
,1.3534109040992181594020849
,1.3149895924868892915782226
,1.2776583095288662761390697
,1.2413861291837680056460158
,1.2061430028693282956453459
,1.1718997345691721800875484
,1.1386279566457540024515538
,1.1063001063398261170078740
,1.0748894029369056024592055
,1.0443698255818711917441988
,1.0147160917233091215194918
,0.9859036361698132466813149
,0.9579085907408989575273495
,0.9307077644957372219991498
,0.9042786245233610520344314
,0.8785992772785089499620881
,0.8536484504476921086890684
,0.8294054753305579730238151
,0.8058502697220301103087081
,0.7829633212811657472229854
,0.7607256713730659036798443
,0.7391188993705993803828846
,0.7181251074030878811527145
,0.6977269055395078911629980
,0.6779073973941206476823140
,0.6586501661428195708580802
,0.6399392609388191432984172
,0.6217591837166289714389222
,0.6040948763735300985899812
,0.5869317083180124461350147
,0.5702554643747878015958008
,0.5540523330360497267221831
,0.5383088950486082380209041
,0.5230121123262765348016501
,0.5081493171764338567797381
,0.4937082018289273843691944
,0.4797078245243728833457908
,0.4660752548547552054358789
,0.4528294895049775892204025
,0.4399595571991517517496106
,0.4274547980632243393550596
,0.4153048547966989301194474
,0.4034996640954710001025774
,0.3920294483187363732135111
,0.3808847073931416749026369
,0.3700562109475576400008379
,0.3595349906720590738018473
,0.3493123328948841144203641
,0.3393797713713558872328235
,0.3297290802789109576131921
,0.3203522674125749425400045
,0.3112415675753757438037894
,0.3023894361583319145836413
,0.2937885429047716878692142
,0.2843428247684819387686161
,0.2762182473429422580046833
,0.2683240685477570330874642
,0.2617579143895940041453230
,0.2543103460784652547488349
,0.2470742085129893350625707
,0.2400435116934421519996334
,0.2332124360866908163725242
,0.2265753277989438763118102
,0.2201266938675205953046543
,0.2138611976593014218916977
,0.2077736543609381147934556
,0.2018590265427339935921935
,0.1961124197743217278944172
,0.1905290782658938253391057
,0.1851043805038354861380867
,0.1798338348443661860454057
,0.1747130750234987817126608
,0.1697378555367134445042154
,0.1649040468378764334733688
,0.1602076303048963479280786
,0.1556446929204731710605358
,0.1512114216211984940585467
,0.1469040972785363718955409
,0.1427190882921166859009787
,0.1386528438004596686106140
,0.1347018865475222149097334
,0.1308628054855789646371278
,0.1271322482454441127330824
,0.1235069136624567243121220
,0.1199835446084731999105699
,0.1165589214426831221604886
,0.1132298564526422884890522
,0.1099931897058924329391161
,0.1068457867657682386353102
,0.1037845387362420490617865
,0.1008063650842022096476569
,0.0944411023545004696400085
,0.0950871000831734064506762
,0.0923400611346979205418251
,0.0896642314540115059617875
,0.0870568341417910646073963
,0.0845152104751273197669192
,0.0820368463190229990633640
,0.0796194004312772291021005
,0.0772607336756546136946611
,0.0749589379823984158779382
,0.0727123637604493999742061
,0.0705196443844549880619610
,0.0683797163618844461296931
,0.0662918338383865213270241
,0.0642555762263515850563067
,0.0622708479417020191459820
,0.0603378695020242369895236
,0.0584571595655553749582012
,0.0594599096506841715004121
,0.0578147490652179338321837
,0.0562176023543147634908834
,0.0546671525574877262276807
,0.0531621219785894869036547
,0.0517012711836972241319366
,0.0502833980364253141370767
,0.0489073367704440237213603
,0.0475719570990539228350080
,0.0462761633617303630439110
,0.0450188937076072479004374
,0.0437991193159063957329735
,0.0426158436533329784690061
,0.0414681017684392430600049
,0.0403573491813763798874426
,0.0392779563904978035182580
,0.0382313845229284784976720
,0.0372167884137168045177724
,0.0362333515480902923489026
,0.0352802856124156266615088
,0.0343568300945781418542779
,0.0334622519367855641991838
,0.0325958452442902182899509
,0.0317569310542099927929804
,0.0309448571691664960081614
,0.0301589980614840359740558
,0.0293987548545824387002945
,0.0286635553888356653384761
,0.0279528543814626870278595
,0.0272661336910842051761694
,0.0266029026976517361802177
,0.0259626988142135431414381
,0.0252551024527345735481987
,0.0246590308800194203675549
,0.0240847356031886304650325
,0.0236239256236130783228599
,0.0230929558916054961104081
,0.0225828765472232059763336
,0.0220934509959477172469366
,0.0216244823049920008306568
,0.0211758161796374647090069
,0.0207473444606153592517650
,0.0203390092665969197949227
,0.0199508079438770018210203
,0.0195827988264490257530603
,0.0192351082021089657414503
,0.0189079385407592628909335
,0.0186015783417731450644084
,0.0183164139582901661085224
,0.0180529439437014070646281
,0.0178117964646047240162563
,0.0175937503252506614870310
,0.0173997611515377403890170
,0.0172309933779820900756619
,0.0170888600947386969097774
,0.0169750728450425783511157
,0.0168917041920346316929979
,0.0168412669011636546845256
,0.0168268155951915958368215
,0.0168520761095603752166561
,0.0169216148554811630921879
,0.0170410597275853364918063
,0.0172173923828391889356837
,0.0174593395093513327476220
,0.0177779024647726040242457
,0.0181870832402716078868288
,0.0187048927298724895762483
,0.0193547702156360891534437
,0.0201676093030943408279665
,0.0211846890843935056758518
,0.0224619662280996258696408
,0.0240764242650422892466633
,0.0261355207378573158039092
,0.0288299377530496538091231
,0.0322603517508661744028764
,0.0368531095356733479073696
,0.0430492292115829122689519
,0.0513207889192008673284739
,0.0625357572498611846700811
,0.0774149262643221702795415
,0.0964050255625690244443149
,0.1191627520313303378873826
,0.1443641198946756798449087
,0.1702484428721511011683987
,0.1955179543041971335082252
,0.2196878599792187747308247
,0.2427808046858764279285481
,0.2649466932974580690718369
,0.2863133033230752522158014
,0.3079921073411978071909800
,0.3296709113593203621661587
,0.3513497153774429171413374
,0.3730285193955654721165160
,0.3947073234136880270916947
,0.4163861274318105820668734
,0.4380649314499331370420521
,0.4597437354680556920172307
,0.4814225394861782469924094
,0.5031013435043008019675881
,0.5247801475224234124539180
,0.5464589515405460229402479
,0.5681377555586686334265778
,0.5898165595767912439129077
,0.6114953635949138543992376
,0.6331741676130364648855675
,0.6548529716311590753718974
,0.6765317756492816858582273
,0.6982105796674042963445572
,0.7198893836855269068308871
,0.7415681877036495173172170
,0.7632469917217721278035469
,0.7849257957398947382898768
,0.8066045997580173487762067
,0.8282834037761399592625366
,0.8499622077942625697488666
,0.8716410118123851802351965
,0.8933198158305077907215264
,0.9149986198486304012078563
,0.9366774238667530116941862
,0.9583562278848756221805161
,1.9657032327436423368993701
,1.9098844591863257669217546
,1.8556492092680809680160792
,1.8029525554838092826770435
,1.7517508437732209891635193
,1.7020016590285629298762160
,1.6545037950654375435988186
,1.6075404935282637808313666
,1.5619095780972540588038555
,1.5175732465771170076607177
,1.4744947693179157877096941
,1.4326384587858724817266420
,1.3919696399975689526939959
,1.3524546217931083802454850
,1.3140606689243883309359262
,1.2767559749354482345751194
,1.2405096358125466959876348
,1.2052916243815696706320750
,1.1710727654325285840286597
,1.1378247115497384100990530
,1.1055199196280354190236039
,1.0741316280555313067424095
,1.0436338345440294705923634
,1.0140012745887565515090500
,0.9852094005396112574857170
,0.9572343612666063261684712
,0.9300529824027278236187044
,0.9036427471478706285878957
,0.8779817776180238730887595
,0.8530488167243115427140765
,0.8288232105669599558694927
,0.8052848913296969390884783
,0.7824143606605231671125011
,0.7601926735252031441802956
,0.7386014225202474081655168
,0.7176227226325485597513421
,0.6972391964332224079115008
,0.6774339596935969876057015
,0.6581906074116280480623686
,0.6394932002373933110916937
,0.6213262512866137843303704
,0.6036747133314406266180185
,0.5865239663579855378117145
,0.5698598054802213042080439
,0.5536684291999699469855045
,0.5379364280026234235165816
,0.5226507732780245607528968
,0.5077988065554760455100336
,0.4933682290411074422564752
,0.4793781227600801275734455
,0.4657555362639235196908771
,0.4525194890071823072830171
,0.4396590177653588726869316
,0.4271634705029563883194044
,0.4150224975517050607365377
,0.4032260430397354711296032
,0.3917643365646534814317192
,0.3806278851037038779558941
,0.3698074651544008273340580
,0.3592941150992138843456303
,0.3490791277880960774560037
,0.3391540433328286141545505
,0.3295106421073478730754402
,0.3201409379483904360519375
,0.3110371715509588907977445
,0.3021918040532534099895656
,0.2935975108058341831451798
,0.2841585411469699784525744
,0.2760402556319977440679736
,0.2681522220001160139446483
,0.2615917506940129699799513
,0.2541500423624809545941616
,0.2469196318299477777014062
,0.2398945338545684091702270
,0.2330689335582228349785794
,0.2264371816040472717990184
,0.2199937894931106308060720
,0.2137334249679222475393203
,0.2076509075078582511331149
,0.2017412038984039701627893
,0.1959994238523045106958875
,0.1904208156562882670037595
,0.1850007618120801944350262
,0.1797347746350971831041932
,0.1746184917688410054292802
,0.1696476715680064195623800
,0.1648181882993549896010421
,0.1601260271073042529277330
,0.1555672786919926331439257
,0.1511381336525034480011698
,0.1468348764583021215379688
,0.1426538790290492186851878
,0.1385915939279844522058482
,0.1346445472078403038374006
,0.1308093309910046686539431
,0.1270825959169047947305842
,0.1234610436478414535743653
,0.1199414196871600307714445
,0.1165205068269523913659924
,0.1131951196015729271815431
,0.1099621001723894986312757
,0.1068183161020912069760769
,0.1037606604872215870782881
,0.1007860548995935245919497
,0.0944221630707480358291050
,0.0950738628906045435407179
,0.0923303351346076994765610
,0.0896580052430751561765021
,0.0870541017056532667739432
,0.0845159724623188723935385
,0.0820411114791489010089620
,0.0796271871624550237056539
,0.0772720716058169221351903
,0.0749738694900366348106147
,0.0727309453242985376464347
,0.0705419476401463324544139
,0.0684058287382374868856871
,0.0663218586480378152758774
,0.0642896320957045963595533
,0.0623090674841161110131260
,0.0603803971655533788798209
,0.0611992567724228136993858
,0.0595086273233620052791615
,0.0578674244335210183343143
,0.0562742955320452153955557
,0.0547279285382333557929968
,0.0532270508393794666845977
,0.0517704283079561261571300
,0.0503568643580232302991995
,0.0489851990408419826761310
,0.0476543081797686091105604
,0.0463631025445933181439173
,0.0451105270655724061024117
,0.0438955600874696774682526
,0.0427172126639726243424455
,0.0415745278928662601036770
,0.0404689652181947356890390
,0.0393949129921391874575853
,0.0383538379238335183640807
,0.0373449052569997524964052
,0.0363673096337558537927137
,0.0354202747237291892812294
,0.0345030529119417228578470
,0.0336149250497218624045281
,0.0327552002737660497011518
,0.0319232158990569170331497
,0.0311183373926738164605421
,0.0303399584365979108069311
,0.0295875010882448580273874
,0.0288604160505910624368031
,0.0281581830649118014520127
,0.0274803114388894459407808
,0.0268263407308018883568046
,0.0261958416087441636754818
,0.0254980622800284571771723
,0.0249126651617118458070799
,0.0243496066815067704891540
,0.0239011292673600821145907
,0.0233827249942961112871842
,0.0228859471413186757460245
,0.0224106294666165488382870
,0.0219566542099974108814830
,0.0215239564199672279987130
,0.0211125290842681286040960
,0.0207224292710243493398359
,0.0203537852849470721205982
,0.0200068053443617117903575
,0.0196817878531924846108314
,0.0193791337259460946795819
,0.0190993612288508363139528
,0.0188431240335881246272809
,0.0186112331977050654563399
,0.0184046838007778795764935
,0.0182246882127075661428339
,0.0180727169127110239010836
,0.0179505495494021692637343
,0.0178603390606221351655236
,0.0178046926769381240462931
,0.0177867750525194275035279
,0.0178104414116988518657081
,0.0178804084338590948966008
,0.0180024793719931776314613
,0.0181838402167597799896637
,0.0184334548146820563496728
,0.0187625982976265190393939
,0.0191855854641286051320836
,0.0197207778420265822383328
,0.0203919941387539181698596
,0.0212305114059536670367834
,0.0222779401319463665753773
,0.0235904028997325106165039
,0.0252446611338586618389357
,0.0273471390677729846163668
,0.0300737079750309777015360
,0.0335874017993017873195960
,0.0382070485532808659656645
,0.0443513285504657586710842
,0.0525535459341844521374831
,0.0635848522330488968856699
,0.0781389108380224628458421
,0.0966771001172870292350581
,0.1189623000646498063304080
,0.1438038179853676767905313
,0.1696096072931166931496705
,0.1949372170320314290314911
,0.2192164055738242411930372
,0.2424041258323099412574919
,0.2646394472385066309882973
,0.2860564405096405748984978
,0.3067513358729352934695100
,0.3282912623989948097680269
,0.3498311889250543260665438
,0.3713711154511138423650607
,0.3929110419771733586635776
,0.4144509685032328749620945
,0.4359908950292923912606113
,0.4575308215553519075591282
,0.4790707480814114238576451
,0.5006106746074708846450108
,0.5221506011335304009435276
,0.5436905276595899172420445
,0.5652304541856494335405614
,0.5867703807117089498390783
,0.6083103072377684661375952
,0.6298502337638279824361121
,0.6513901602898874987346289
,0.6729300868159470150331458
,0.6944700133420065313316627
,0.7160099398680660476301796
,0.7375498663941255639286965
,0.7590897929201850802272133
,0.7806297194462445965257302
,0.8021696459723041128242471
,0.8237095724983636291227640
,0.8452494990244231454212809
,0.8667894255504826617197978
,0.8883293520765421780183146
,0.9098692786026016943168315
,0.9314092051286612106153484
,0.9529491316547207269138653
,0.9744890581807802432123822
,2.0216384362780233097112159
,1.9642330146454245465292843
,1.9084561381878799579681072
,1.8542616025062670370715523
,1.8016045125499093870757861
,1.7504412474445303349313008
,1.7007294239327404028472301
,1.6532675988200355998714031
,1.6063395787308827333816907
,1.5607429496298892424022142
,1.5164399377265098678435606
,1.4733938409746594189186908
,1.4315689986663735489003102
,1.3909307618882411627936335
,1.3514454648161535743611239
,1.3130803968245108315215930
,1.2758037753872770725394048
,1.2395847197472615874858093
,1.2043932253334170834335737
,1.1702001389037557377292842
,1.1369771343937837837501093
,1.1046966894504066658555530
,1.0733320626318827439860115
,1.0428572712549395440362332
,1.0132470698707569667362804
,0.9844769293519916031343087
,0.9565230165735697509532542
,0.9293621746704576747077908
,0.9029719038560967137030389
,0.8773303427856778968774165
,0.8524162504488834724014623
,0.8282089885771676263104268
,0.8046885045511027456655029
,0.7818353147937306957260262
,0.7596304886362909014607681
,0.7380556326430911529001833
,0.7170928753827112700491853
,0.6967248526330876989831609
,0.6769346930084384483805593
,0.6577060039963208426527785
,0.6390228583934832728985498
,0.6208697811294716650820646
,0.6032317364672593607011208
,0.5860941155703757177164448
,0.5694427244262083576131772
,0.5532637721152068310814798
,0.5375438594156792815326185
,0.5222699677336489765266947
,0.5074294483467928218445309
,0.4930100119507459521805970
,0.4790307657081441239377284
,0.4654187359453863526148609
,0.4521929661829028890274174
,0.4393425017114541142326800
,0.4268566987866656003980381
,0.4147252158141419009496076
,0.4029380047853420854231388
,0.3914853029571885301152179
,0.3803576247685970801448718
,0.3695457539873103769423324
,0.3590407360806316394707949
,0.3488338708038500324271070
,0.3389167050003393799606499
,0.3292810256075002217635017
,0.3199188528628897354444405
,0.3108224337050495833523200
,0.3019842353636836840280466
,0.2933969391339661947348816
,0.2839651219139640581090589
,0.2758535098993309953030462
,0.2679719958161639326021941
,0.2614175597385821059326361
,0.2539820721094429578634788
,0.2467577430022262208186845
,0.2397385922299934968293655
,0.2329188098620826596896194
,0.2262927514067250844842505
,0.2198549331129387718331003
,0.2136000273794077808364733
,0.2075228582554371481450062
,0.2016183970158729743538117
,0.1958817577880251625810359
,0.1903081932041678636657878
,0.1848930900481770556176286
,0.1796319648594676410269244
,0.1745204594519277896402798
,0.1695543363004494985535331
,0.1647294737436009459674580
,0.1600418609488041543631454
,0.1554875925871558595137145
,0.1510628631699838797519675
,0.1467639610097149771572589
,0.1425872617849913703835796
,0.1385292217153902272208654
,0.1345863703854167647833151
,0.1307553033009136167486020
,0.1270326743131164337619055
,0.1234151881047531873480949
,0.1198995929961423484444438
,0.1164826743933207592318624
,0.1131612492598318003844682
,0.1099321620430422224989897
,0.1067922825183231783086057
,0.1037385060236825917723280
,0.1007677565376224049220610
,0.0944058780712595108086660
,0.0950632191813594318308134
,0.0923234972942347797975060
,0.0896549653484471076314577
,0.0870548580990965076287225
,0.0845205311940998571529349
,0.0820494879208415184290715
,0.0796394077273223227608767
,0.0772881754901830198001278
,0.0749939103291980546650564
,0.0727549926396255652871758
,0.0705700879424426830155426
,0.0684381661477874991827974
,0.0663585148954031062151770
,0.0643307457801174931155685
,0.0623547924885883078638393
,0.0629893528457801110675973
,0.0612521482574147763111583
,0.0595658254411783327775254
,0.0579289954677491419898772
,0.0563403111714758722539109
,0.0547984661089364194497264
,0.0533021935589314613257450
,0.0518502655639156498357245
,0.0504414920129908073143099
,0.0490747197667081372363107
,0.0477488318240558290428410
,0.0464627465321342039694663
,0.0452154168391432353946158
,0.0440058295914214844812840
,0.0428330048753730596722278
,0.0416959954051915812622831
,0.0405962656188535303547482
,0.0395282247729327185226111
,0.0384933466050970049532332
,0.0374908089715849657252988
,0.0365198200823142471449501
,0.0355796182325376769695069
,0.0346694716058649696210914
,0.0337886781549255540979537
,0.0329365655665520701278481
,0.0321124913201036865650906
,0.0313158428488238618769834
,0.0305460378146772300322898
,0.0298025245114130442336542
,0.0290847824117744097049965
,0.0283923228739890697036596
,0.0277246900336191766378580
,0.0270814619036873448221225
,0.0264622517183755283365354
,0.0257759364543238451983331
,0.0252030297082673701569711
,0.0246531608807543968497900
,0.0242191874695099965131284
,0.0237156305148390096626532
,0.0232346263634547398058139
,0.0227761020312178437408068
,0.0223400452815893241220735
,0.0219265109680526829039060
,0.0215356286414987233013285
,0.0211676114310778880345243
,0.0208227668427000342510347
,0.0205015095765227750579385
,0.0202043769522471002020314
,0.0199320475444104590334593
,0.0196853639210086174549108
,0.0194653604268920886466443
,0.0192732969947467941418395
,0.0191107015119501774669253
,0.0189794220576071509531957
,0.0188816925401925281291504
,0.0188202155484407905594590
,0.0187982676161462212982567
,0.0188198340668300420630565
,0.0188897841071378434774086
,0.0190140974457926985319300
,0.0192001646799647394947552
,0.0194571857796682172458969
,0.0197967059768558023558072
,0.0202333450548717388994824
,0.0207858012051177556966941
,0.0214782497200061602005139
,0.0223423157605887809373790
,0.0234198895978474028178873
,0.0247671863014487445009415
,0.0264606471546534952055119
,0.0286055452332433859941041
,0.0313633094394667119586551
,0.0349158662239808861849077
,0.0395588636619529782079141
,0.0456655155663352602113392
,0.0538254762431132349753682
,0.0646773115614380361693136
,0.0789153016709586152543920
,0.0969163511477976191699213
,0.1188400344411095765906339
,0.1432857223348850961297529
,0.1689592238535874424432137
,0.1943231299308437742823230
,0.2187090559332543759918366
,0.2419980503359981383049160
,0.2643091518435972675504786
,0.2857804554161220145225286
,0.3065122480601153442947293
,0.3265615852109242656098331
,0.3479741227555470106658220
,0.3693866603001697557218108
,0.3907991978447925007777997
,0.4122117353894152458337885
,0.4336242729340379908897773
,0.4550368104786607359457662
,0.4764493480232834810017550
,0.4978618855679062260577439
,0.5192744231125290266248840
,0.5406869606571518271920240
,0.5620994982017746277591641
,0.5835120357463974283263042
,0.6049245732910202288934443
,0.6263371108356430294605843
,0.6477496483802658300277244
,0.6691621859248886305948645
,0.6905747234695114311620046
,0.7119872610141342317291446
,0.7333997985587570322962847
,0.7548123361033798328634248
,0.7762248736480026334305649
,0.7976374111926254339977049
,0.8190499487372482345648450
,0.8404624862818710351319851
,0.8618750238264938356991252
,0.8832875613711166362662652
,0.9047000989157394368334053
,0.9261126364603622374005454
,0.9475251740049850379676855
,0.9689377115496078385348255
,0.9903502490942306391019656
,2.0790762323158848978721380
,2.0200415404734779478701512
,1.9626816254614209977802375
,1.9069489699409853944445103
,1.8527974061628975643856165
,1.8001820746370467141161953
,1.7490593890830998802243812
,1.6993869998610338090117011
,1.6519632139786226687760973
,1.6050724336670318947994929
,1.5595119943451962729596971
,1.5152441522042559007843465
,1.4722322343347502560106932
,1.4304406083444192177012155
,1.3898346528380842723748856
,1.3503807287351989874224500
,1.3120461514012116133187646
,1.2747991635701554358206522
,1.2386089090348475494351987
,1.2034454070845461703953561
,1.1692795276676135607374363
,1.1360829672591716832386055
,1.1038282254136870808025606
,1.0724885819830591859869173
,1.0420380749813920040480753
,1.0124514790781129480734535
,0.9837042847016680413574363
,0.9557726777365163073341137
,0.9286335197966431032057244
,0.9022643290593060916293666
,0.8766432616431865110229182
,0.8517490935155955789070958
,0.8275612029138171843456462
,0.8040595532661203304058972
,0.7812246765984054430731476
,0.7590376574128410158692759
,0.7374801170253064697135414
,0.7165341983488012767011810
,0.6961825511104096086967274
,0.6764083174897772554601261
,0.6571951181674090536333210
,0.6385270387714603312900863
,0.6203886167120048478196281
,0.6027648283920529204138461
,0.5856410767848291287762663
,0.5690031793670019544251204
,0.5528373563976276550135935
,0.5371302195325350359311756
,0.5218687607636685044099067
,0.5070403416724573730789416
,0.4926326829855732780671929
,0.4786649184296142833794363
,0.4650640508584490961929703
,0.4518491492252574848187407
,0.4390092678259334135759673
,0.4265337716852877769646568
,0.4144123277494436985435300
,0.4026348963288115534453482
,0.3911917227846165023841252
,0.3800733294521668192977870
,0.3692705077942613489661028
,0.3587743107783304963298576
,0.3485760454711135380989617
,0.3386672658448568462574713
,0.3290397657892124572143189
,0.3196855723231886714508221
,0.3105969390016667386333893
,0.3017663395111547797178275
,0.2931864614495579002273473
,0.2837622249850128564041540
,0.2756576916085398676337093
,0.2677830947504781233803328
,0.2612350688600703629838051
,0.2538061855058211246927158
,0.2465883148679069991615620
,0.2395754821309845072896394
,0.2327618826238927740579499
,0.2261418770076856210593519
,0.2197099865830769160890412
,0.2134608887050270520369111
,0.2073894122895684477558831
,0.2014905333947354382218009
,0.1957593708535822762950573
,0.1901911819327594399542392
,0.1847813579850285381489527
,0.1795254200586349213608628
,0.1744190144208755122168242
,0.1694579079480217076447701
,0.1646379833295891215172446
,0.1599552340326974297912699
,0.1554057589730064026234402
,0.1509857568437065478139658
,0.1466915200646765060632504
,0.1425194283315647514331914
,0.1384659417704116324276953
,0.1345275937383676734260263
,0.1307009833553208488776676
,0.1269827679042559442912363
,0.1233696552983259003832828
,0.1198583968771356617066814
,0.1164457808596175841797660
,0.1131286268409745776608588
,0.1099037817704408837027330
,0.1067681178784945644766324
,0.1037185330301118313389708
,0.1007519539587444779016323
,0.0943928393982690627783683
,0.0950557070849562257830456
,0.0923201138012276628641573
,0.0896557068058383144215640
,0.0870597281269647194079653
,0.0845295423178400867625371
,0.0820626633803658162014116
,0.0796567833892775911674988
,0.0773098017651896035618009
,0.0750198539742598230484205
,0.0727853383082034816053962
,0.0706049393331522889827312
,0.0684776465990238891734521
,0.0664027672787928929798440
,0.0643799315614263928386762
,0.0648316619093347035196473
,0.0630467621830990976317111
,0.0613142433659805904944129
,0.0596326794306363192066378
,0.0580006874376770842349771
,0.0564169264759235428163819
,0.0548800966464001727107558
,0.0533889380902079560553553
,0.0519422300605627065839265
,0.0505387900394411310189824
,0.0491774728994423329653252
,0.0478571701116446979185071
,0.0465768090004147136684587
,0.0453353520463065998158392
,0.0441317962383673684234608
,0.0429651724773301990634167
,0.0418345450313454478297182
,0.0407413847320612712565868
,0.0396801253952064544860967
,0.0386522496629713094296044
,0.0376569507653145355008384
,0.0366934535110133713819991
,0.0357610141545247964267595
,0.0348589203517003093368842
,0.0339864912126190271690618
,0.0331430774621056314921397
,0.0323280617200155453994093
,0.0315408589137308736916054
,0.0307809168412356490285298
,0.0300477169042222269634834
,0.0293407750291122572383617
,0.0286596428088683706503215
,0.0280039088932442191415273
,0.0273732006718007160606110
,0.0266766584073416489208963
,0.0260943289251859417143820
,0.0255361166229456683363086
,0.0250018181360179940486699
,0.0245850028934454026274814
,0.0240991006364317389421004
,0.0236369268560345582863569
,0.0231985333841029164880787
,0.0227840501040791412745712
,0.0223936943664288581889998
,0.0220277820047964124905437
,0.0216867407703437015120684
,0.0213711263262759687542314
,0.0210816415601725419548540
,0.0208191599996918642878629
,0.0205847544816566870029551
,0.0203797323199327792830893
,0.0202056783036942792797230
,0.0200645087670653123057551
,0.0199585386087012608968827
,0.0198905659084738402342385
,0.0198639793106383903686929
,0.0198828952603550442035374
,0.0199523349032230609689798
,0.0200784551278270773089218
,0.0202688500552041447888563
,0.0205329531114887171849848
,0.0208825746481035579016350
,0.0213326303881412084051394
,0.0219021400427821949508100
,0.0226156116008653026994146
,0.0235049822690179925632759
,0.0246123697073088905373783
,0.0259940091800591466242309
,0.0277259268124592402060546
,0.0299121323740167456561867
,0.0327003349142158117324186
,0.0362892902978862313956299
,0.0409529262286199152720556
,0.0470541172761009401925847
,0.0551374769337396944401952
,0.0658137781516599379427745
,0.0797444768466141762353061
,0.0972822375153803015068732
,0.1187266003512664064301063
,0.1428489897686650300645539
,0.1683030948385713376769246
,0.1936776524459749293516353
,0.2181643578651264736567583
,0.2415599754585960601271921
,0.2639536480650928607083472
,0.2854841227428329131221574
,0.3062573617799603797884345
,0.3263381456323018459109164
,0.3457636647774716687209207
,0.3670593514749886931980427
,0.3883550381725057176751648
,0.4096507248700227421522868
,0.4309464115675397666294089
,0.4522420982650567911065309
,0.4735377849625738155836530
,0.4948334716600908400607750
,0.5161291583576078645378971
,0.5374248450551248890150191
,0.5587205317526419134921412
,0.5800162184501589379692632
,0.6013119051476759624463853
,0.6226075918451929869235073
,0.6439032785427100114006294
,0.6651989652402270358777514
,0.6864946519377440603548735
,0.7077903386352610848319955
,0.7290860253327781093091176
,0.7503817120302951337862396
,0.7716773987278121582633617
,0.7929730854253291827404837
,0.8142687721228462072176058
,0.8355644588203632316947278
,0.8568601455178802561718499
,0.8781558322153972806489719
,0.8994515189129143051260940
,0.9207472056104313296032160
,0.9420428923079483540803380
,0.9633385790054653785574601
,0.9846342657029824030345821
,1.0000000000000000000000000
,2.1380496147227554537550986
,2.0773420956319204044859816
,2.0183568204278294899722823
,1.9610449257908399989247528
,1.9053589343286838619917489
,1.8512527168934234111929982
,1.7986814515280320492252031
,1.7476015884579165771128828
,1.6979708135185511697073935
,1.6505871705143311256591687
,1.6037356894069165758054396
,1.5582134416189050707401975
,1.5139827149815028306534259
,1.4710068673338538847161772
,1.4292502961663062777120103
,1.3886784091250476969037209
,1.3492575953537206956411865
,1.3109551976481685908737518
,1.2737394854017405343427072
,1.2375796283175921619346127
,1.2024456708678019634106704
,1.1683085074768979616521847
,1.1351398584097938115888837
,1.1029122463440748092011745
,1.0715989736072568661029436
,1.0411741000601653084345344
,1.0116124216081594511251751
,0.9828894493224181738710854
,0.9549813891540351873388204
,0.9278651222241601770335251
,0.9015181856738947452356570
,0.8759187540581598874211977
,0.8510456212681686283261229
,0.8268781829676163930287203
,0.8033964195281261266856632
,0.7805808794499200509164893
,0.7584126632541067225545817
,0.7368734078333796233550856
,0.7159452712483265202081384
,0.6956109179569405220888711
,0.6758535044652903556183787
,0.6566566653876946269008386
,0.6380044999050668019791033
,0.6198815586104436947678664
,0.6022728307309764828048060
,0.5851637317159299467306255
,0.5685400911804010526395814
,0.5523881411945498198790006
,0.5366945049081188745532245
,0.5214461854997916034903938
,0.5066305554405345912272196
,0.4922353460593402174616529
,0.4782797191504234435299736
,0.4646906527821801913269439
,0.4514872427814992095207458
,0.4386585529666876537291387
,0.4261939576366710613619659
,0.4140831327711019804738157
,0.4023160474808502584664893
,0.3908829557018527189882207
,0.3797743881255236653160523
,0.3689811443591226591820487
,0.3584942853096893533582090
,0.3483051257853468363201443
,0.3384052273079702355396137
,0.3287863911314042875133623
,0.3194406514595907742304348
,0.3103602688591304281651162
,0.3015377238609558974147262
,0.2929657107459112674874291
,0.2835495091919339460950766
,0.2754524846295319240319088
,0.2675852274576214773205152
,0.2610440108092739186496090
,0.2536221396605305988813939
,0.2464111287040691711247575
,0.2394050088339684523308648
,0.2325979809717182988926254
,0.2259844112600226662124214
,0.2195588263761587555222832
,0.2133159089526358853650123
,0.2072504930902570319251055
,0.2013575599454192621706738
,0.1956322333695728887814624
,0.1900697755741865835332760
,0.1846655827894116141951741
,0.1794151808790769020429678
,0.1743142208689803518417705
,0.1693584743401409520302536
,0.1645438286344184652953970
,0.1598662818175815014676289
,0.1553219373456209695394392
,0.1509069983851625829096577
,0.1466177617496427221244204
,0.1424506114308818349734054
,0.1384020117320639009506067
,0.1344685000437588762167707
,0.1306466793497632616904980
,0.1269332106035569451840672
,0.1233248051774105819022864
,0.1198182176517237629287393
,0.1164102392778909866866144
,0.1130976925085648565616481
,0.1098774270384015733226235
,0.1067463178295202375078787
,0.1037012656023047763031997
,0.1007392002478609688287392
,0.0943837233458337532265858
,0.0950519395774505060359161
,0.0923208287252738207806502
,0.0896609057066531656143837
,0.0870694209811874036963886
,0.0845437493791679206545098
,0.0820814172074424558411820
,0.0796801309704484733709151
,0.0773378066286785903482581
,0.0750525981490414717534065
,0.0728229239825174401445906
,0.0706474900463410354634064
,0.0685253078000176568673751
,0.0664557060925566184250712
,0.0667276870319659515251587
,0.0648939595148107506439317
,0.0631141574230301011239064
,0.0613868169037845370916706
,0.0597105185706244059873349
,0.0580838864266761817356510
,0.0565055868341135386634377
,0.0549743275302150211092389
,0.0534888566904842890914473
,0.0520479620394974432096014
,0.0506504700103473370909057
,0.0492952449537755674202621
,0.0479811883983161796551897
,0.0467072383630280363320253
,0.0454723687246525384852980
,0.0442755886412967564202958
,0.0431159420350375674479970
,0.0419925071361079357834534
,0.0409067630021632822057143
,0.0398531724115124622032091
,0.0388332293497133593240811
,0.0378461458994083232987293
,0.0368911673005947599035537
,0.0359675719973100230242302
,0.0350746717963349510793769
,0.0342118121508804898245337
,0.0333783725840184411493006
,0.0325737672666174885027779
,0.0317974457727195417011679
,0.0310488940361086582231387
,0.0303276355291237816047545
,0.0296332327052126823230260
,0.0289652887385207988280023
,0.0283234496161751704568221
,0.0277074066135751181927382
,0.0270258762937119895175542
,0.0264599311820182953036706
,0.0259191088423912988081277
,0.0254033059801235423791343
,0.0250069198184610930191241
,0.0245421560986929243597388
,0.0241026261745295213023699
,0.0236885507229311551014028
,0.0233002532861051638024552
,0.0229381739367343802371568
,0.0226028859931881077882654
,0.0222951159867364571975923
,0.0220157678560935973766099
,0.0217659523965010523460784
,0.0215470234483129512159660
,0.0213606224763160969237763
,0.0212087333492037254101259
,0.0210937514825515447236537
,0.0210185700215471463203620
,0.0209866891975028155292726
,0.0210023558776059222907850
,0.0210707429758453003432184
,0.0211981821647130239116841
,0.0213924695871694596494006
,0.0216632679248101346625166
,0.0220226457801741687392294
,0.0224858042185478480823324
,0.0230720678834044207183851
,0.0238062522665955164646867
,0.0247205695910881345644938
,0.0258573122836648489064615
,0.0272726640374941209366000
,0.0290421442843715807424765
,0.0312683941958407443650891
,0.0340864376807641228372958
,0.0377092178442847286712336
,0.0423906890687695270258928
,0.0484839686739685846172954
,0.0564905373177974692855408
,0.0669949837184537766443526
,0.0806268689473867983252831
,0.0977137672778820437491376
,0.1186002068034479606239984
,0.1424106661865436052050171
,0.1676475837862580475778884
,0.1930036644907533183168624
,0.2175813899768879455809412
,0.2409279063789604991008275
,0.2635706018963276942024265
,0.2851659133268015233753090
,0.3059853322913053119691540
,0.3261013980252685517946531
,0.3455598572011264191239377
,0.3644065434384366475306649
,0.3855950456658736591464276
,0.4067835478933106707621903
,0.4279720501207476823779530
,0.4491605523481846939937157
,0.4703490545756217056094783
,0.4915375568030587172252410
,0.5127260590304957288410037
,0.5339145612579327959679176
,0.5551030634853698630948315
,0.5762915657128069302217455
,0.5974800679402439973486594
,0.6186685701676810644755733
,0.6398570723951181316024872
,0.6610455746225551987294011
,0.6822340768499922658563150
,0.7034225790774293329832290
,0.7246110813048664001101429
,0.7457995835323034672370568
,0.7669880857597405343639707
,0.7881765879871776014908846
,0.8093650902146146686177985
,0.8305535924420517357447125
,0.8517420946694888028716264
,0.8729305968969258699985403
,0.8941190991243629371254542
,0.9153076013518000042523681
,0.9364961035792370713792820
,0.9576846058066741385061960
,0.9788731080341112056331099
,1.0000000000000000000000000
,1.0000000000000000000000000
,2.1985916895513617497215364
,2.1361668432418658980509463
,2.0755129751823968575763502
,2.0165798352507389168408736
,1.9593186032833491694304939
,1.9036818438414475629372191
,1.8496234685583876622416710
,1.7970986950836649320706329
,1.7460640121579891204106616
,1.6964771430455152234628713
,1.6491358543016676474479709
,1.6023258372946564964678373
,1.5568438853574275704261254
,1.5126523197046097823914579
,1.4697145306185634971996024
,1.4279949471195148014146525
,1.3874590074963275565522736
,1.3480731306734567986893580
,1.3098046883904599368975141
,1.2726219781711833878290463
,1.2364941970594287568019354
,1.2013914161007019920646144
,1.1672845555477575629765852
,1.1341453607699332195579700
,1.1019463788462384723487730
,1.0706609358228202921736738
,1.0402631146160021824442765
,1.0107277335426045894450908
,0.9820303254597977371531670
,0.9541471174972501190225671
,0.9270550113648036161251298
,0.9007315642194381188900820
,0.8751549700757093042113866
,0.8503040417443484821902189
,0.8261581932841163267156048
,0.8026974229524873605257085
,0.7799022966411348622983724
,0.7577539317826156306523444
,0.7362339817150765908237986
,0.7153246204921817064104062
,0.6950085281258630010015054
,0.6752688762498778585197101
,0.6560893141925192573182812
,0.6374539554471647662126088
,0.6193473645296914131819221
,0.6017545442120648679917849
,0.5846609231216587376778193
,0.5680523436960506211690358
,0.5519150504831249470782950
,0.5362356787762907472938423
,0.5210012435744306724672015
,0.5061991288557708967843496
,0.4918170771541773289570187
,0.4778742799160424215010323
,0.4642976890429219016809270
,0.4511064287540866302173015
,0.4382895729363892045604700
,0.4258365056961183614525623
,0.4137369125672718528363703
,0.4019807719699979853267280
,0.3905583469122047013399879
,0.3794601769275323666086308
,0.3686770702431002577625918
,0.3582000961706406361173549
,0.3480205777148293044831462
,0.3381300843928187749298786
,0.3285204252591618634404824
,0.3191836421304988791192159
,0.3101120030045407260921309
,0.3012979956680333359919643
,0.2927343214885175237682802
,0.2833266364137470016970610
,0.2752375774667757402092150
,0.2673781088199760347379197
,0.2608441261856139226082973
,0.2534297011444224811960169
,0.2462259768738561116485641
,0.2392269903380067619380611
,0.2324269484069294844363895
,0.2258202230566039303560899
,0.2194013466885998686617398
,0.2131650075572063263162903
,0.2071060452891250180940119
,0.2012194464775302893411180
,0.1955003403283409046942154
,0.1899439943319121415488127
,0.1845458099281274133574016
,0.1793013181272136713495513
,0.1742061750428267330459420
,0.1692561572885425968948425
,0.1644471571845266821831899
,0.1597751777187545740854802
,0.1552363272078614853111134
,0.1508268136078352028572880
,0.1465429384357917197423404
,0.1423810902824262369925634
,0.1383377379216814695439552
,0.1344094230605945294865222
,0.1305927528183920272031315
,0.1268843920790493629002782
,0.1232810559239331388292626
,0.1197795024177951694888122
,0.1163765260879587037923244
,0.1130689524975598686529210
,0.1098536343627494610286632
,0.1067274496939672884243677
,0.1036873024459580711065243
,0.1007301261340879522387937
,0.0943793009481663225379577
,0.0950526136971305696254930
,0.0923263736130777584731888
,0.0896713291966624997941793
,0.0870847406705622523181987
,0.0845639947135035513481327
,0.0821066317525759592488299
,0.0797103747723582611861559
,0.0773731585349748118840552
,0.0750931579408547072995717
,0.0728688141467462580092018
,0.0706988570074829486555856
,0.0685823224301533584945645
,0.0686789708455450009783050
,0.0667952714314859752331444
,0.0649670888566200172009601
,0.0631929207311924395762404
,0.0614713105681789009904215
,0.0598008466909246139131540
,0.0581801611898975432057846
,0.0566079289290469453432841
,0.0550828666024636148801363
,0.0536037318422659045391576
,0.0521693223788829082976370
,0.0507784752551798806985417
,0.0494300660961665069836890
,0.0481230084363572715999702
,0.0468562531072015606148362
,0.0456287876873671532917953
,0.0444396360190973879755738
,0.0432878577942690245805579
,0.0421725482141888860510015
,0.0410951969636488625980952
,0.0400503011212369822158230
,0.0390393691948550877746094
,0.0380616365280558865968885
,0.0371163736663506632629250
,0.0362028866433545676306593
,0.0353205174125167109533407
,0.0344686444424786367357605
,0.0336466834934919176158807
,0.0328540886036041493434290
,0.0320903533135926677388738
,0.0313550121553486452197212
,0.0306476424561354481024278
,0.0299678664987633215643914
,0.0293153541075476600785699
,0.0286898256950756103123013
,0.0280910558956164423116686
,0.0274272925761378690012737
,0.0268807871682407405200532
,0.0263606781755122109023315
,0.0258669959334186377875042
,0.0254951055234227605406083
,0.0250558437639045276934535
,0.0246437616060710094900710
,0.0242593108786713050617490
,0.0239030818436841950569427
,0.0235758240017858618220448
,0.0232784710353749896283304
,0.0230121711451496610556511
,0.0227783241255723363505314
,0.0225786271017113585046765
,0.0224151311196563833572082
,0.0222903110520929932658607
,0.0222071541784698810173548
,0.0221692712342030327776765
,0.0221810380437626672445184
,0.0222477772743327334437069
,0.0223759935002758210409457
,0.0225736799846292558735517
,0.0228507240013927255539716
,0.0232194438474225481328084
,0.0236953132415709359637201
,0.0242979434757216380957878
,0.0250524308739375721477582
,0.0259912245359157252633242
,0.0271567386872961016863748
,0.0286050347831946390197988
,0.0304110370588261957891518
,0.0326759199611712097821581
,0.0355374815210842409651804
,0.0391772529873149616408412
,0.0438744875380481236248897
,0.0499562645899615243028080
,0.0578857431252517151687442
,0.0682217555498309674577584
,0.0815629796076047935970976
,0.0983796364341111839735277
,0.1186150784747953268460918
,0.1420157662670147313832558
,0.1669994909576518749005913
,0.1923049836290999237142785
,0.2169599098925417968164453
,0.2405777664221764033936068
,0.2631575097775756821860682
,0.2848240049521259531495332
,0.3056946360211555413499696
,0.3258497106525845565805355
,0.3453420638426761279937693
,0.3642174866692248214050665
,0.3825229292989599239049880
,0.4036131137913450683818439
,0.4247032982837302128586998
,0.4457934827761153573355557
,0.4668836672685005018124116
,0.4879738517608856462892675
,0.5090640362532707907661234
,0.5301542207456558797318280
,0.5512444052380409686975327
,0.5723345897304260576632373
,0.5934247742228111466289420
,0.6145149587151962355946466
,0.6356051432075813245603513
,0.6566953276999664135260559
,0.6777855121923515024917606
,0.6988756966847365914574652
,0.7199658811771216804231699
,0.7410560656695067693888745
,0.7621462501618918583545792
,0.7832364346542769473202839
,0.8043266191466620362859885
,0.8254168036390471252516932
,0.8465069881314322142173978
,0.8675971726238173031831025
,0.8886873571162023921488071
,0.9097775416085874811145118
,0.9308677261009725700802164
,0.9519579105933576590459211
,0.9730480950857427480116257
,0.9941382795781278369773304
,1.0000000000000000000000000
,1.0000000000000000000000000
,2.2607356035572392372046124
,2.1965479995388466072370193
,2.1341813892382472950259853
,2.0735841112119004492342356
,2.0147059628950687582005230
,1.9574981696466933200895255
,1.9019133402834889068344637
,1.8479054294463375107682168
,1.7954296965698115506882004
,1.7444426710213789544212659
,1.6949021155461054810587029
,1.6476055047431741318320064
,1.6008392266707522910706984
,1.5553997818142537568064654
,1.5112495266036622965089009
,1.4683518855453117080145375
,1.4266713209203647494405232
,1.3861733033431442585481363
,1.3468242831547769799982461
,1.3085916626291800302084312
,1.2714437689666484576633820
,1.2353498280550105903330405
,1.2002799389748233238606190
,1.1662050492282318714387657
,1.1330969306708822408324977
,1.1009281561269503857403151
,1.0696720766679455039138702
,1.0393027995364723103932647
,1.0097951666967137640540386
,0.9811247339938757860977603
,0.9532677509053713027498134
,0.9262011408670207668336616
,0.8999024821580073885129991
,0.8743499893288207980290849
,0.8495224951568584037531195
,0.8253994331148261087705009
,0.8019608203375019339631535
,0.7791872410728496456400194
,0.7570598306039146851986743
,0.7355602596283096206164487
,0.7146707190825126732036665
,0.6943739053986066611656724
,0.6746530061814390855090551
,0.6554916862945640021465010
,0.6368740743436819284895023
,0.6187847495466078928672005
,0.6012087289791048227982628
,0.5841314551861599424498195
,0.5675387841484819118065275
,0.5514169735940828154241444
,0.5357526716448014481031237
,0.5205329057874341636136251
,0.5057450721587321007532978
,0.4913769251328431453273993
,0.4774476874776616974749288
,0.4638842834751926158531887
,0.4507058673372070223273056
,0.4379015235956265628125550
,0.4254606467271928593731900
,0.4133729323703778657517205
,0.4016283687922514999968371
,0.3902172285983045441071226
,0.3791300606784343552035921
,0.3683576823825129853418048
,0.3578911719191528173489303
,0.3477218609714939345778362
,0.3378413275240187974013395
,0.3282413888945987512357760
,0.3189140949661485313626486
,0.3098517216124335171834048
,0.3010467643127292536320283
,0.2924919319501536607575076
,0.2830932740092877986093356
,0.2750126657958691378524918
,0.2671614625908818596577987
,0.2606351661949421472108668
,0.2532286488607634611369690
,0.2460326658127282573040873
,0.2390412604700791199263676
,0.2322486460319447276745564
,0.2256492006838825836734230
,0.2192374629242784811467004
,0.2130081269983797043199303
,0.2069560384250515583381969
,0.2010761895980202607070453
,0.1953637154393586816691908
,0.1898138890782657406397504
,0.1844221175228833997650213
,0.1791839372871300850587062
,0.1740950099286399377351842
,0.1691511174483682489189107
,0.1643481574979488990528864
,0.1596821383384246229031334
,0.1551491734946723044519246
,0.1507454760550908379190815
,0.1464673525774001783261724
,0.1423111965801949485577182
,0.1382734816275127398554901
,0.1343507540509721598365189
,0.1305396254012423096213524
,0.1268367647769771122678861
,0.1232388912430283367527295
,0.1197427666175688021343859
,0.1163451889752149803758385
,0.1130429872746463310084764
,0.1098330175679641113051233
,0.1067121612780525669039733
,0.1036773260325839635109801
,0.1007254495129797505770242
,0.0943804497135339592883696
,0.0950585208635121303721860
,0.0923375782431750113943281
,0.0896878466957256176295132
,0.0871065977379467532015767
,0.0845912316969943262057186
,0.0821393051918820060741666
,0.0797485600187602255983776
,0.0774169523038183982066585
,0.0751426806275485303920902
,0.0729242117177573007102964
,0.0707603022679664517280429
,0.0706870960075794974031282
,0.0687522704812930512963121
,0.0668746016909987084364531
,0.0650525480191324334544589
,0.0632846152492664709710013
,0.0615693554600598297321667
,0.0599053659714758671150925
,0.0582912883439836229659825
,0.0567258074317003452291530
,0.0552076504907012752254580
,0.0537355863440206887871042
,0.0523084246052004236959831
,0.0509250149626035986116790
,0.0495842465271277635374680
,0.0482850472463950061707827
,0.0470263833889725327286335
,0.0458072591027757283765887
,0.0446267160523642972269620
,0.0434838331404212297126577
,0.0423777263195903308723445
,0.0413098990526124670852326
,0.0402748892307749420393925
,0.0392742240396020889092732
,0.0383071677027877477428319
,0.0373730223073043404946603
,0.0364711284126694595952856
,0.0356008658524325297123347
,0.0347616547483677595931084
,0.0339529567733913226201814
,0.0331742766985316517303062
,0.0324251642528594966052857
,0.0317052163626402455642861
,0.0310140798178240965909946
,0.0303514544535290788085380
,0.0297170968870144533435784
,0.0291108249703449402379096
,0.0285325230324831209671732
,0.0278899235908172983544606
,0.0273666378738692990524317
,0.0268713753879903233245940
,0.0264994105687265425752575
,0.0260620561628620434069248
,0.0256538158723316235543255
,0.0252752963665849039731626
,0.0249272693844508202998256
,0.0246106976457601787922069
,0.0243267660352478078122918
,0.0240769196764623501227920
,0.0238629106593890444321104
,0.0236868559161278503799597
,0.0235513091566049784231218
,0.0234593502122672527276936
,0.0234146987005619082455876
,0.0234218573587499680199731
,0.0234862957989998809293919
,0.0236146876337705625970020
,0.0238152189464689335862690
,0.0240979932694796138148430
,0.0244755695537321633914463
,0.0249636797000826332615375
,0.0255822011875310624529067
,0.0263564828657156975666442
,0.0273191714035118313197437
,0.0285127494893033205103361
,0.0299930867656153232747585
,0.0318344272896774749259663
,0.0341363874034841807691976
,0.0370336793065723299256398
,0.0407092848175369045882199
,0.0454113435982147276015475
,0.0514722982453717295414641
,0.0593242774969151634434361
,0.0694950200640743198654548
,0.0825533904442518201571843
,0.0989631247137642972022675
,0.1188334682717699791743016
,0.1416699238559082363320130
,0.1663659228055572314453059
,0.1915863457784120482685353
,0.2163004866854821850452595
,0.2400290938893086256644693
,0.2627117325959478777441802
,0.2844562949043526467463039
,0.3053835705131969779912993
,0.3255814979942911469024125
,0.3451093573963629479450788
,0.3640140685075810011994690
,0.3823381484574309707724638
,0.4001052816238446774299575
,0.4178724147902583840874513
,0.4356395479566720907449451
,0.4534066811230857974024389
,0.4711738142894995040599326
,0.4889409474559132107174264
,0.5067080806223269728860714
,0.5244752137887407350547164
,0.5422423469551544972233614
,0.5600094801215682593920064
,0.5777766132879820215606514
,0.5955437464543957837292965
,0.6133108796208095458979415
,0.6310780127872233080665865
,0.6488451459536370702352315
,0.6666122791200508324038765
,0.6843794122864645945725215
,0.7021465454528783567411665
,0.7199136786192921189098115
,0.7376808117857058810784565
,0.7554479449521196432471015
,0.7732150781185334054157465
,0.7909822112849471675843915
,0.8087493444513609297530365
,0.8265164776177746919216816
,0.8442836107841884540903266
,0.8620507439506022162589716
,0.8798178771170159784276166
,0.8975850102834297405962616
,0.9153521434498435027649066
,0.9331192766162572649335516
,0.9508864097826710271021966
,2.3245144987851271700662892
,2.2585177615967562125831591
,2.1943933545177771726741867
,2.1320881559240083547024369
,2.0715505543355945405892271
,2.0127303972769077233806456
,1.9555789575573474525782558
,1.9000488923386027462214543
,1.8460941999355480191979950
,1.7936701844130764627038843
,1.7427334179829394589233971
,1.6932417050265127222985484
,1.6459922127962449689420055
,1.5992720629858840908354978
,1.5538774477891614811397858
,1.5097707607756101211293753
,1.4669154625460156804450662
,1.4252760504608137370752274
,1.3848180292274689939802101
,1.3455078823223758366367520
,1.3073130442242841819933119
,1.2702018734345821293629797
,1.2341436262643836752062043
,1.1991084313649231773979409
,1.1650672649809246106400451
,1.1319919269063161149091457
,1.0998550171224175109330190
,1.0686299130992342742985102
,1.0382907477411034147252167
,1.0088123879584280917498518
,0.9801704138477911332216763
,0.9523410984632378895042848
,0.9253013881620039127184896
,0.8990288835084651042350856
,0.8735018207205385021296706
,0.8486990536432371667885377
,0.8246000362345254908191805
,0.8011848055490448095028455
,0.7784339652057332692436376
,0.7563286693257670334489262
,0.7348506069276383723121171
,0.7139819867666394870298063
,0.6937055226063556512272612
,0.6740044189101840332867255
,0.6548623569412506117970452
,0.6362634812594550881570399
,0.6181923866046974413990256
,0.6006341051556347565565375
,0.5835740941535892956082421
,0.5669982238813978669966787
,0.5508927659871203363906034
,0.5352443821425022507654035
,0.5200401130259153514856507
,0.5052673676191111740152451
,0.4909139128064363144510196
,0.4769990044353701330592799
,0.4634495376413504952317624
,0.4502846983140819658864018
,0.4374935822390769724066217
,0.4250655948580586152019123
,0.4129904424950183727816011
,0.4012581238320040988298842
,0.3898589216276441282715837
,0.3787833946716272492949429
,0.3680223699685591376429272
,0.3575669351448257926584517
,0.3474084310722894697320839
,0.3375384447028371703858340
,0.3279488021079924875422762
,0.3186315617179735770747584
,0.3095790077547617147324388
,0.3007836438538821766108811
,0.2922381868697410123303371
,0.2828490975798695350462708
,0.2747774553372883676871652
,0.2669350243824976098849788
,0.2604168957605967338331254
,0.2530187772774039056677964
,0.2458310193853023017940274
,0.2388476723703397419651395
,0.2320629561678457519757757
,0.2254712555760187142617212
,0.2190671155895298205518174
,0.2128452368409340100807725
,0.2068004711349613611304221
,0.2009278170574068100862064
,0.1952224156362642737416735
,0.1896795460279864231623037
,0.1842946211963401859090794
,0.1790631835454622455827689
,0.1739809004626994282105557
,0.1690435597211637774872628
,0.1642470646873508133278818
,0.1595874292766370772245210
,0.1550607726001886621514103
,0.1506633132521999762776233
,0.1463913631979614493605624
,0.1422413212425776007918898
,0.1382096660885144823183168
,0.1342929490284633375907219
,0.1304877863684184846615466
,0.1267908517336033547007190
,0.1231988684749425605469142
,0.1197086024628356559773579
,0.1163168556233421524481741
,0.1130204606336161904378557
,0.1098162772416987620349715
,0.1067011907033304091152459
,0.1036721128282522691455014
,0.1007259860944191148801607
,0.0943881667548077257778871
,0.0950705584405453774099470
,0.0923553826916470588237473
,0.0897114425007515814414205
,0.0871360224392291743411576
,0.0846265385445223033977769
,0.0821805659915824937566953
,0.0797958680385660173994822
,0.0774704250781606540421365
,0.0752024624710254802062437
,0.0729904757395251485574406
,0.0727536855812272592602952
,0.0707665711127133389979349
,0.0688383034168484897463713
,0.0669673009828926635300661
,0.0651520312663368406091990
,0.0633910095714076554651584
,0.0616827979893664543609155
,0.0600260043935861714592406
,0.0584192814926719899970564
,0.0568613259432091538991827
,0.0553508775240747832868671
,0.0538867183746502692587299
,0.0524676722997078556764983
,0.0510926041442603118269972
,0.0497604192422122643124638
,0.0484700629432462323786801
,0.0472205202231689158409722
,0.0460108153836602321029581
,0.0448400118481289064464868
,0.0437072120616195242126523
,0.0426115575036843108325257
,0.0415545695568979578382596
,0.0405308349256120192816155
,0.0395419049225249757961720
,0.0385870798563886369114684
,0.0376657013843159776955716
,0.0367771535600278018374176
,0.0359208641325403504884761
,0.0350963061405694665140231
,0.0343029998456839887999159
,0.0335405150379581781794336
,0.0328084737978832294280629
,0.0321065537723307856121657
,0.0314344920744498435016823
,0.0307920898544662910434333
,0.0301792177448703992370671
,0.0295958222685111238536848
,0.0290419334510959442630096
,0.0284247219295783275228029
,0.0279293740609523090390187
,0.0274641462825212200049574
,0.0271255225931898019675614
,0.0267232755238534583352994
,0.0263531134026583728491300
,0.0260160271842423372612441
,0.0257132376353387398504324
,0.0254462343547340458238537
,0.0252168236041768085986536
,0.0250271872633613147451914
,0.0248799561507834672557937
,0.0247783015778889927072104
,0.0247260496832947020140470
,0.0247278274785606433372465
,0.0247892480946955186260627
,0.0249171494841416846233173
,0.0251199041271709458400530
,0.0254078241722340940345060
,0.0257936962806385103319506
,0.0262934956188522750419878
,0.0269273436401180898958074
,0.0277208113691332115602339
,0.0287067025156180280487384
,0.0299275145845143801526245
,0.0314388569977949727807243
,0.0333142122021991005098585
,0.0356515539985806234613008
,0.0385824493881718605381437
,0.0422842519251120929624221
,0.0469955475930567689868411
,0.0530334574340088488186851
,0.0608074190988524346246358
,0.0708158033182136742444968
,0.0835987702917015962356118
,0.0996172553094821222607891
,0.1190023483249352254098596
,0.1413784391952195573782802
,0.1657541620075273225420887
,0.1908533507607671486638878
,0.2156046104324942924712616
,0.2394396072762408622658370
,0.2622305595933378530304481
,0.2840604176909424238850477
,0.3050502442674926650845180
,0.3252951586339482004106571
,0.3448607322080303738687235
,0.3637960363570523214526986
,0.3821418671266063604718966
,0.3999246335736805213478817
,0.4171515865505012188307887
,0.4343785395273219163136957
,0.4516054925041426137966027
,0.4688324454809633112795098
,0.4860593984577840087624168
,0.5032863514346046507341725
,0.5205133044114254037282308
,0.5377402573882461567222890
,0.5549672103650669097163473
,0.5721941633418876627104055
,0.5894211163187084157044637
,0.6066480692955291686985220
,0.6238750222723499216925802
,0.6411019752491706746866384
,0.6583289282259914276806967
,0.6755558812028121806747549
,0.6927828341796329336688132
,0.7100097871564536866628714
,0.7272367401332744396569296
,0.7444636931100951926509879
,0.7616906460869159456450461
,0.7789175990637366986391044
,0.7961445520405574516331626
,0.8133715050173782046272208
,0.8305984579941989576212791
,0.8478254109710197106153373
,0.8650523639478404636093956
,0.8822793169246612166034538
,0.8995062699014819695975120
,0.9167332228783027225915703
,0.9339601758551234755856285
,0.9511871288319442285796868
,2.3899614383787981530815614
,2.3221082557815471147932840
,2.2561800825683238080898718
,2.1921222994771465408803124
,2.1298818488022237538359605
,2.0694071633610762184218856
,2.0106481462472718391154558
,1.9535561208787877163217672
,1.8980837936524213027666974
,1.8441852106598271010540202
,1.7918157224486142009567402
,1.7409319464027164237052148
,1.6914917308025254616410393
,1.6442919194589136200335133
,1.5976204063633234753183388
,1.5522730592660807236171649
,1.5082123108964446966950845
,1.4654016599135180065616169
,1.4238056406661570019167584
,1.3833897938110086833773948
,1.3441206377641921054788554
,1.3059656409636619667224977
,1.2688931949176418534364075
,1.2328725880190571917438547
,1.1978739801025108935306207
,1.1638683777234770655439888
,1.1308276101391454560030070
,1.0987243059710094517100742
,1.0675318705298972865591622
,1.0372244637846816939230621
,1.0077769789564383628999167
,0.9791650217203626827000562
,0.9513648899982428686072922
,0.9243535543247943797595667
,0.8981086387716394892066774
,0.8726084024131860461537258
,0.8478317213191202128541590
,0.8237580710586683840901401
,0.8003675097022346918151925
,0.7776406613064278383617989
,0.7555586998689255429084710
,0.7341033337400272307249338
,0.7132567904781454970475352
,0.6930018021368770098078471
,0.6733215909716779856708513
,0.6541998555545319726789444
,0.6356207572853567189241630
,0.6175689072892223130395450
,0.6000293536887617573682974
,0.5829875692414079324521481
,0.5664294393312904185577850
,0.5503412503057482085822016
,0.5347096781463988035554280
,0.5195217774645570774083581
,0.5047649708103987276075486
,0.4904270382846207532168137
,0.4765272706652480816380546
,0.4629925323368445644334201
,0.4498420426417956696774070
,0.4370649092614117270372276
,0.4246505492300544637451765
,0.4125886801708750217798638
,0.4008693117810531170164268
,0.3894827375595395491103545
,0.3784195267705385279377595
,0.3676705166361560195298352
,0.3572268047518524780592486
,0.3470797417185360611568967
,0.3372209239853251605545381
,0.3276421868971981510298974
,0.3183355979419305592514888
,0.3092934501908858324625839
,0.3005082559283853704812373
,0.2919727404645105495184509
,0.2825937940920169588743249
,0.2745316650979015560274377
,0.2666985450295659143549187
,0.2601890970195855357083303
,0.2527999000532295537091443
,0.2456208826461607486191241
,0.2386461023915839307907305
,0.2318697863970251571430481
,0.2252863265054720898206142
,0.2188902746367003826488684
,0.2126763382365835231002649
,0.2066393758194426666374710
,0.2007743925850877242389458
,0.1950765360880800380893874
,0.1895410919318959719337414
,0.1841634794551611775670352
,0.1789392473711385322943102
,0.1738640693155024952165633
,0.1689337392516386260332695
,0.1641441666780217301102596
,0.1594913715796267283941745
,0.1549714790660835783686622
,0.1505807136448434058184631
,0.1463153930895742527162895
,0.1421719218839201104298553
,0.1381467842499873865946824
,0.1342365368103496103824313
,0.1304378009821368644693962
,0.1267472552610069136402871
,0.1231616276193618492174053
,0.1196776883135444030648031
,0.1162922434639976493331304
,0.1130021298343251712203994
,0.1098042112827686406228977
,0.1066953773853763498546954
,0.1036725447269049721343848
,0.1007326613171745238739518
,0.0944035834882906571552397
,0.0950897427063604888664017
,0.0923808508833234842683169
,0.0897432299599365823628006
,0.0871741795868485186415953
,0.0846711338736600011012357
,0.0822316892486007477991450
,0.0798536334443877698907599
,0.0775349744070374519155919
,0.0752739677758341163560374
,0.0748804033186958178935910
,0.0728398301181120283454007
,0.0708598455996733989081804
,0.0689388277252153819363301
,0.0670752050597291510358744
,0.0652674556451061510520262
,0.0635141059336353230868610
,0.0618137297825516324190076
,0.0601649475112693357670146
,0.0585664250233032049330895
,0.0570168729953027184076397
,0.0555150461361010177929742
,0.0540597425192023625650783
,0.0526498029927636793101620
,0.0512841106717966677130960
,0.0499615905180378697125754
,0.0486812090139661576837504
,0.0474419739383311681035771
,0.0462429342515099026100778
,0.0450831801006913723828262
,0.0439618429561412851769298
,0.0428780958919326854461573
,0.0418334836651161959264478
,0.0408226516962039015501418
,0.0398471825943996285634974
,0.0389064220509421423987995
,0.0379997616986353300982948
,0.0371266407505638426633787
,0.0362865479912622690417123
,0.0354790241727000743576781
,0.0347036648544277945283021
,0.0339601237937174685321828
,0.0332481169551162927811028
,0.0325674272770055672765466
,0.0319179102499448225094270
,0.0312995005646037396940251
,0.0307122199360466245632306
,0.0301561864071378596396933
,0.0295387943830413488011111
,0.0290451022458934789149954
,0.0285836375534308795298699
,0.0281550218771021189267945
,0.0278571812611286967475976
,0.0274981969569539387576729
,0.0271752380867743489889499
,0.0268898377401665771013750
,0.0266438552574943567086141
,0.0264395363727040061396778
,0.0262795876659952278020516
,0.0261672695444079700388684
,0.0261065128820746443494283
,0.0261020654791741003875050
,0.0261596798928044223242484
,0.0262863530487290678050449
,0.0264906365210882815963700
,0.0267830411803252517455309
,0.0271765692584808211951231
,0.0276874202235007985106741
,0.0283359370066422894263169
,0.0291478809622552799407647
,0.0301561707662498200421819
,0.0314032648302893235836564
,0.0329444452525326780811810
,0.0348523550681708524368041
,0.0372232479397838073031934
,0.0401854965981233366867365
,0.0439108667905374130957519
,0.0486286339386126711947789
,0.0546412179176041581940559
,0.0623365376918003158412951
,0.0721852288592187141258449
,0.0846998789860969603093821
,0.1003277424788267535582520
,0.1192414608398347092288461
,0.1411462547157143476717067
,0.1651715437299192124065428
,0.1901123766022026206901074
,0.2148747717387551880996455
,0.2388081450068478550630147
,0.2617113021684856488668913
,0.2836337728116586909266061
,0.3046925612559769347420513
,0.3249890180955354312963834
,0.3445950720028508329484396
,0.3597521456231107528367374
,0.3819332766165573489480778
,0.3997351918036260443045649
,0.4169840371609712659228819
,0.4336995150136639387561388
,0.4504149928663566115893957
,0.4671304707190492844226526
,0.4838459485717419572559095
,0.5005614264244346856003176
,0.5172769042771273584335745
,0.5339923821298200312668314
,0.5507078599825127041000883
,0.5674233378352053769333452
,0.5841388156878980497666021
,0.6008542935405907225998590
,0.6175697713932833954331159
,0.6342852492459760682663727
,0.6510007270986687410996296
,0.6677162049513614139328865
,0.6844316828040540867661434
,0.7011471606567467595994003
,0.7178626385094394324326572
,0.7345781163621321052659141
,0.7512935942148247780991710
,0.7680090720675174509324279
,0.7847245499202101237656848
,0.8014400277729027965989417
,0.8181555056255954694321986
,0.8348709834782881422654555
,0.8515864613309808150987124
,0.8683019391836734879319692
,0.8850174170363661607652261
,0.9017328948890588335984830
,0.9184483727417515064317399
,0.9351638505944441792649968
,0.9518793284471368520982537
,2.4571093335991713857424656
,2.3873514617606619303558091
,2.3195726475465443527923526
,2.2537167402990805342710701
,2.1897291830476159901763822
,2.1275569740480744229671473
,2.0671486038290622921920203
,2.0084540301200952683302603
,1.9514246299482265190050612
,1.8960131615023887441395800
,1.8421737212477922174258538
,1.7898617087277080006657570
,1.7390337889408273852609454
,1.6896478564407821920667629
,1.6425004147770754237001256
,1.5958801706708525269817756
,1.5505826505489295197293131
,1.5065703284202707212813266
,1.4638067430632082377428560
,1.4222564678186206954535464
,1.3818850812400678140789978
,1.3426591385776478482227958
,1.3045461440694603449941269
,1.2675145240210647923362330
,1.2315336006480834818432868
,1.1965735666613175336436825
,1.1626054605731965807535744
,1.1296011427050933750848571
,1.0975332718756540817395262
,1.0663752827508485854224318
,1.0361013638370037970304338
,1.0066864360986083060112151
,0.9781061321832194010994499
,0.9503367762362827653177533
,0.9233553642891972890183183
,0.8971395452044210738762331
,0.8716676021618925407352663
,0.8469184346714951905354951
,0.8228715410967425425425859
,0.7995070016753028641076639
,0.7768054620223875383899781
,0.7547481171034801095132138
,0.7333166956632607424992898
,0.7124934450979921729540933
,0.6922611167590294600771017
,0.6726029516754888915031074
,0.6535026666844833131975179
,0.6349444409576876502399045
,0.6169129029133293418141193
,0.5993931175030068336795352
,0.5823705738630026162994113
,0.5658311733199524740101083
,0.5497612177408777167642029
,0.5341473982175707346797822
,0.5189767840751861038839365
,0.5042368121945145498230545
,0.4899152766367874112241054
,0.4760315050586537144461374
,0.4625123294092243209085780
,0.4493770043517406609367981
,0.4366146501409863267539890
,0.4242146960665186261607573
,0.4121668716986643388189293
,0.4004611983837647049000452
,0.3890879809816919498999255
,0.3780377998388769200666104
,0.3673015029902816919182840
,0.3568701985839717316650876
,0.3467352475221263663485161
,0.3368882563125296103478945
,0.3273210701247709630834493
,0.3180257660455643176078411
,0.3089946465277680909267133
,0.3002202330278432307331116
,0.2916952598266204788046707
,0.2823270653919450756674792
,0.2742750310125238732972264
,0.2664517943620405837634735
,0.2599515732376108667622816
,0.2525718540934160372124495
,0.2454021260400259529799172
,0.2384364544492748871906684
,0.2316690740682565141650429
,0.2250943842485800816533015
,0.2187069442959924392422266
,0.2125014689281669588716284
,0.2064728238256858250387893
,0.2006160212577964840896527
,0.1949262157603307843434237
,0.1893986998382373720950511
,0.1840288996595639825493151
,0.1788123707016005814463000
,0.1737447933036051217481344
,0.1688219680746011197580714
,0.1640398110999312930591287
,0.1593943488876079228599991
,0.1548817129963134808789960
,0.1504981342926795251369043
,0.1462399367978603759166134
,0.1421035311040260429304993
,0.1380854073716249463821271
,0.1341821279589632542883493
,0.1303903197869430152788794
,0.1267066666026834820257818
,0.1231279013739407235394907
,0.1196507991179956292837616
,0.1162721705388067433561972
,0.1129888569082720534142439
,0.1097977266740791241206310
,0.1066956743001762492051299
,0.1036796218390971940914724
,0.1007465236921314954976481
,0.0944279820964054467102855
,0.0951172234173264935508385
,0.0924151858310908735916200
,0.0897844674372027251596506
,0.0872223852946627242754829
,0.0847263942909188966234879
,0.0822941151849208574198258
,0.0799233636075462328118846
,0.0776121787795305551060920
,0.0770689538325481093838931
,0.0749737469743203127636733
,0.0729409243946289448379261
,0.0709688229309882456785630
,0.0690558317385429748513914
,0.0672003911582487734044378
,0.0654009916492579723712453
,0.0636561727871851196214337
,0.0619645223303190231800563
,0.0603246753562824769567818
,0.0587353134721419062325154
,0.0571951641015358488995268
,0.0557029998530087777641739
,0.0542576379745120240816192
,0.0528579398998391541963926
,0.0515028108936222486780032
,0.0501911998028494732437821
,0.0489220989239223733036077
,0.0476945439954261085624410
,0.0465076143290286542208989
,0.0453604330924824369897230
,0.0442521677615587971654776
,0.0431820307566474770322174
,0.0421515974139312701862714
,0.0411555842212825845338742
,0.0401956145544135889924320
,0.0392710915654775408190069
,0.0383814704286999305860029
,0.0375262608061104757650739
,0.0367050297979168438367026
,0.0359174054233596037888354
,0.0351630807656489116630461
,0.0344418188644088074656935
,0.0337534585276789145247278
,0.0330979211278933788120682
,0.0324752187075240672520238
,0.0318854635239231645749136
,0.0313288794123177602446439
,0.0308058153079551304276418
,0.0302230660111273211065885
,0.0297676422649706222400834
,0.0293476285240597579984101
,0.0289640522114163329048253
,0.0287165770555640152694732
,0.0284114505322471122550354
,0.0281476396658075778134389
,0.0279274525693026555439591
,0.0277536700141043785050599
,0.0276296395259477065020626
,0.0275593933859423073640116
,0.0275477973345013733841302
,0.0276007382908042067648502
,0.0277253660379581240436053
,0.0279304032212083566677485
,0.0282265486290885735110034
,0.0286270055916756326064299
,0.0291481798920580209566467
,0.0298106094146547394296842
,0.0306402140926618042626739
,0.0316699846141685406597510
,0.0329422858728911777115300
,0.0345120069476829577359567
,0.0364508774145108419006966
,0.0388533599619441602501801
,0.0418445938106760534358486
,0.0455908080363644357957398
,0.0503122152419829618552605
,0.0562971368662004006955257
,0.0639130870987833360485908
,0.0736045132241181787602358
,0.0858575681571546595050037
,0.1011046144231883686659401
,0.1195526526695719349291380
,0.1409779443376460716930154
,0.1646253425835819961253748
,0.1893704683829999790845022
,0.2141145057778598981279572
,0.2381342619858094755702638
,0.2611514157708008099234576
,0.2831735681888060129907103
,0.3043082058292576053126766
,0.3246612774379519228418189
,0.3443111231285201356833170
,0.3633137450989770700360282
,0.3817114575635209283710481
,0.3995354276331647414011172
,0.4168065936961322104359340
,0.4335467349869717157417881
,0.4497937935451972180089797
,0.4660408521034227202761713
,0.4822879106616482225433629
,0.4985349692198737248105544
,0.5147820277780992270777460
,0.5310290863363247293449376
,0.5472761448945502316121292
,0.5635232034527757338793208
,0.5797702620110012361465124
,0.5960173205692267384137040
,0.6122643791274522406808956
,0.6285114376856777429480871
,0.6447584962439032452152787
,0.6610055548021287474824703
,0.6772526133603542497496619
,0.6934996719185797520168535
,0.7097467304768052542840451
,0.7259937890350307565512367
,0.7422408475932562588184283
,0.7584879061514817610856198
,0.7747349647097072633528114
,0.7909820232679327656200030
,0.8072290818261582678871946
,0.8234761403843837701543862
,0.8397231989426092724215778
,0.8559702575008347746887694
,0.8722173160590602769559609
,0.8884643746172857792231525
,0.9047114331755112814903441
,0.9209584917337367837575357
,0.9372055502919622860247273
,0.9534526088501877882919189
,2.5259908676730966625711972
,2.4542791363944371774152842
,2.3846019057467811030903704
,2.3169014540447725458705008
,2.2511216958378672536866816
,2.1872081376706322686231942
,2.1251078376236720579584016
,2.0647693468435766028790113
,2.0061426808974913704730625
,1.9491792730476091843883069
,1.8938319361309090549383427
,1.8400548197091608493281001
,1.7878033749566659693641668
,1.7370343170485009753889472
,1.6877055893015553422742414
,1.6406133374392863899515760
,1.5940471231666015761163635
,1.5488021139582217600150216
,1.5048408273264053391926609
,1.4621268443304471507104836
,1.4206247794048765253904776
,1.3803002510436583882835748
,1.3411198533171169167133030
,1.3030511281955790003905804
,1.2660625386601056518998121
,1.2301234425754650203543861
,1.1952040673047978902587829
,1.1612754850447724042084019
,1.1283095888608163370747661
,1.0962790694025732474159440
,1.0651573922803336813558417
,1.0349187760837064153918163
,1.0055381710243551651728922
,0.9769912381851367788598850
,0.9492543293584905228499338
,0.9223044674574052415039205
,0.8961193274828093136008533
,0.8706772180316476594796882
,0.8459570633304099862570524
,0.8219383857793008951730940
,0.7986012889926752400526766
,0.7759264413218064371235982
,0.7538950598464503327633679
,0.7324888948220932283206253
,0.7116902145701682336209615
,0.6914817907989028178405988
,0.6718468843428653247684679
,0.6527692313096270515515585
,0.6342330296223254171295025
,0.6162229259472445930256868
,0.5987240029958433851220434
,0.5817217671909208354108500
,0.5652021366868328344779115
,0.5491514297337942718257864
,0.5335563533763232335616067
,0.5184039924757425366053099
,0.5036817990463057226335764
,0.4893775818938750910014335
,0.4755107076032775714757861
,0.4620079739203479252118711
,0.4488886727950372468320950
,0.4361419377706086675239305
,0.4237572110911484446482689
,0.4117242349584233074288875
,0.4000330430377294632648955
,0.3886739522057716111902437
,0.3776375545338112038606937
,0.3669147094995407476503146
,0.3564965364213360521361551
,0.3463744071087432874200829
,0.3365399387232538841452367
,0.3269849868436023876405727
,0.3177016387300161115447850
,0.3086822067820069181998122
,0.2999192221844610428682643
,0.2914054287369164386589659
,0.2820486321450651479025851
,0.2740073100194852506739096
,0.2661945654212892198309248
,0.2597041531784948231731391
,0.2523345040699487284996394
,0.2451746500787458649117667
,0.2382186648606484102863590
,0.2314607913038708164599200
,0.2248954367670786824717766
,0.2185171684379456913394080
,0.2123207088000654829684777
,0.2063009311932108569287436
,0.2004528554484317215411693
,0.1947716435752162855710168
,0.1892525954729124548769903
,0.1838911446328609644584873
,0.1786828537914333103753250
,0.1736234104877176498415992
,0.1687086224735185047141073
,0.1639344129184155673950585
,0.1592968153499453309862588
,0.1547919682698703225387504
,0.1504161093935448278990918
,0.1461655694722943654717540
,0.1420367656801455324977468
,0.1380261945775942411529513
,0.1341304247072535593687803
,0.1303460889291995772332200
,0.1266698766665421138633008
,0.1230985263016950437275909
,0.1196288180370157494536443
,0.1162575676044514533247209
,0.1129816212708062150849031
,0.1097978526306096769271647
,0.1067031616994451453939163
,0.1036944768096144109392753
,0.1007687597611150037701933
,0.0944628139778742187404603
,0.0951543001845566588370318
,0.0924597467994643928967946
,0.0898365763228073516133421
,0.0872821259018724815437196
,0.0847938743017884744013202
,0.0823694701231695580734282
,0.0800067607852605472418261
,0.0793210826378517031010063
,0.0771700640630682277443242
,0.0750832809505448117715076
,0.0730590284608606671534758
,0.0710956558706200558717114
,0.0691915654388490647397347
,0.0673452113426195320133871
,0.0655550986840204852335035
,0.0638197825710580812774708
,0.0621378672755715441566871
,0.0605080054718535043090100
,0.0589288975603306786066327
,0.0573992910813909962275403
,0.0559179802253911145681897
,0.0544838054458410478431141
,0.0530956531837651068972406
,0.0517524557129664178334316
,0.0504531911171510541458396
,0.0491968834112352648713085
,0.0479826028221169847975958
,0.0468094662460790747471329
,0.0456766379037572556320868
,0.0445833302115464097381548
,0.0435288049021523293369285
,0.0425146774332543705976484
,0.0415357508914516171394382
,0.0405937019853990846418590
,0.0396880071101065184935308
,0.0388182028064230771891019
,0.0379838893751144393573504
,0.0371847351254676675158528
,0.0364204814268438495372671
,0.0356909486635360248540927
,0.0349960433077085020237007
,0.0343357661869931399256650
,0.0337102223569165013183913
,0.0331196327363931647402850
,0.0325643479797892085314537
,0.0320448650183331532059761
,0.0315618466547984560799378
,0.0310214652360351547666362
,0.0306130275180019201242132
,0.0302442020385591640863066
,0.0299165854603761806329576
,0.0297319608779238742091167
,0.0294946286121970102644951
,0.0293058061573218953110853
,0.0291689258780959900785312
,0.0290881185662345796705264
,0.0290683632584030696155430
,0.0291156768734803679532508
,0.0292373548346573225442668
,0.0294422820074448018945468
,0.0297413335438284943956777
,0.0301478985050897957398419
,0.0306785686857445998032556
,0.0313540516715120967661257
,0.0322003904808832175366007
,0.0332506056694210697100011
,0.0345469144304645370269213
,0.0361437483163492279114593
,0.0381118532107606877712414
,0.0405438366943144598564253
,0.0435615746249215229912721
,0.0473258202873526948040173
,0.0520479741747941135332489
,0.0580028447242124725602430
,0.0655385991997691486066202
,0.0750749588680093837833596
,0.0870667615700457808713963
,0.1019513284542470227256317
,0.1199376034781311634036527
,0.1408777138602028966563040
,0.1641226734157399114177878
,0.1886352086012424988936687
,0.2133283976556722416617617
,0.2374183750298806128142814
,0.2605486459186934222742593
,0.2826768846583482264200882
,0.3038946343466118471532411
,0.3243099682946020689833233
,0.3440074708619952903454475
,0.3630477203071674208167963
,0.3814753937530392935428836
,0.3993239748981156633789169
,0.4166182551272999412539377
,0.4333816343995079978235196
,0.4496458223673630572037041
,0.4654434687761863642663229
,0.4812411151850096713289417
,0.4970387615938329783915606
,0.5128364080026562854541794
,0.5286340544114795925167982
,0.5444317008203028995794170
,0.5602293472291262066420359
,0.5760269936379495137046547
,0.5918246400467728207672735
,0.6076222864555961278298923
,0.6234199328644194348925112
,0.6392175792732427419551300
,0.6550152256820660490177488
,0.6708128720908893560803676
,0.6866105184997126631429865
,0.7024081649085359702056053
,0.7182058113173592772682241
,0.7340034577261825843308429
,0.7498011041350058913934618
,0.7655987505438291984560806
,0.7813963969526525055186994
,0.7971940433614758125813182
,0.8129916897702991196439370
,0.8287893361791224267065559
,0.8445869825879457337691747
,0.8603846289967690408317935
,0.8761822754055923478944123
,0.8919799218144156549570312
,0.9077775682232389620196500
,0.9235752146320622690822688
,0.9393728610408855761448876
,0.9551705074497088832075065
,2.5966384122863579442253013
,2.5229227341102111736859115
,2.4512984219115363515584249
,2.3817061401966124201123876
,2.3140882375960623029698127
,2.2483886973224258554182597
,2.1845530927696423795225655
,2.1225285452149624809692341
,2.0622636695501945780506503
,2.0037085415497761786696174
,1.9468146559019325891881635
,1.8915348808210059594614449
,1.8378234225452068084649682
,1.7856357866421794788891475
,1.7349287411484866083810630
,1.6856602807543370481369038
,1.6386261750285637806001660
,1.5921168847864555218052374
,1.5469272001543079575469619
,1.5030196844787571119894665
,1.4603579633663577030944225
,1.4189066945486907833640089
,1.3786315386024428075728565
,1.3394991305011703097704867
,1.3014770519728788844560086
,1.2645338046436698231644868
,1.2286387839427423962490593
,1.1937622537481784590340794
,1.1598753217523616321216196
,1.1269499155266198275882061
,1.0949587592652736400822278
,1.0638753511898668691060266
,1.0336739415948612563767028
,1.0043295115166457343036654
,0.9758177520082259581712947
,0.9481150440024393999394192
,0.9211984387470857349455855
,0.8950456387957900217244855
,0.8696349795389185510785524
,0.8449454112593169918810077
,0.8209564816980685630909420
,0.7976483191159373653533748
,0.7750016158365616858461067
,0.7529976122578870834090026
,0.7316180813187401765773643
,0.7108453134078484003666176
,0.6906621017029783704543888
,0.6710517279282902647352671
,0.6519979485183271528114801
,0.6334849811774593275615075
,0.6154974918239183301338358
,0.5980205819078736606542179
,0.5810397760932782817988596
,0.5645410102934385054851418
,0.5485106200503804263490792
,0.5329353292481378012723781
,0.5178022391499432774963907
,0.5030988177489792434471383
,0.4888128894217169118086019
,0.4749638618366560094408158
,0.4614784966823682887948621
,0.4483761252633998717342934
,0.4356458951658052636268792
,0.4232772623262834876811667
,0.4112599823005404497955340
,0.3995841017803844485989373
,0.3882399503525873485365594
,0.3772181324927795231793937
,0.3665095197878331378937844
,0.3561052433804007266715530
,0.3459966866294816867366535
,0.3361754779810736115663872
,0.3266334840431630026635901
,0.3173628028594944194828997
,0.3083557573767248261020768
,0.2996048890997369262834127
,0.2911029519300172840878815
,0.2817582382353780445782832
,0.2737282846058282093082425
,0.2659266791563356657768225
,0.2594466959654065929541389
,0.2520877474458170230953158
,0.2449383905346100842592705
,0.2379927077136280433311555
,0.2312449505510956460074823
,0.2246895349490639626210964
,0.2183210365116161899567970
,0.2121341860216271468786431
,0.2061238650110220338440570
,0.2002851014059182643833879
,0.1946130652236900682172660
,0.1891030642938567873923006
,0.1837505399688195983909367
,0.1785510627840563857571254
,0.1735003280207694509318372
,0.1685941511177442564406448
,0.1638284628741485671188371
,0.1591993043822926556796205
,0.1547028216303958370048122
,0.1503352597217873787283082
,0.1460929566704872450966235
,0.1419723367554796833456265
,0.1379699034486387421161169
,0.1340822319750550328798511
,0.1303059616193822378704681
,0.1266377879565342146062079
,0.1230744552569004723885371
,0.1196127493909400624216843
,0.1162494916297529268245370
,0.1129815337999123120438227
,0.1098057552945540943367675
,0.1067190624603660542568662
,0.1037183908642278634681944
,0.1008007108878809093832629
,0.0945097204420081160591849
,0.0952024409173446994891776
,0.0925160686688370481611798
,0.0899011613906756240632845
,0.0873550794030572147486069
,0.0848753289006472788624791
,0.0824595903312079492319953
,0.0816385760464405502156993
,0.0794305667523300534815789
,0.0772887016839938906231922
,0.0752112338244360772998576
,0.0731964721620943226110256
,0.0712427805599031849226321
,0.0693485766992613800185907
,0.0675123311015521782030291
,0.0657325662304064500807144
,0.0640078556784861585349233
,0.0623368234432947060374985
,0.0607181432972969531425278
,0.0591505382584969000014929
,0.0576327801687812335540428
,0.0561636893884796054021713
,0.0547421346167431058238328
,0.0533670328495887344444348
,0.0520373494888459117713175
,0.0507520986168273346983426
,0.0495103434554279922541475
,0.0483111970305912380441171
,0.0471538230679970429837233
,0.0460374371422763717376370
,0.0449613081212758766702642
,0.0439247599373353975193979
,0.0429294608558395129893626
,0.0419703202632690508533386
,0.0410490849335504379147288
,0.0401653252927988008158522
,0.0393186828462069037914972
,0.0385088753462716551489997
,0.0377357029329607046586048
,0.0369990553667197824561086
,0.0362989206219158019872673
,0.0356353949329101596377178
,0.0350086948076399409601756
,0.0344191712034260799413232
,0.0338673264556254363655263
,0.0333538345083443515948218
,0.0328795649338954679152813
,0.0324456121245238968131552
,0.0319575268546566648719676
,0.0316073393753372872128082
,0.0313023758605111765418449
,0.0311449054646252623812508
,0.0309397405001869477136900
,0.0307887774301951952504730
,0.0306962422712229975052534
,0.0306672231718874109540618
,0.0307078606261426204082632
,0.0308255892572498399473169
,0.0310294460790940564154372
,0.0313304701725490089558868
,0.0317422202347248591514095
,0.0322814529825841620147564
,0.0329690183175099654766527
,0.0338310486211812894152828
,0.0349005491062858649864431
,0.0362195370667077673476619
,0.0378419239903190485208029
,0.0398374053695440474842648
,0.0422966761078497274772836
,0.0453383278066129269401330
,0.0491177076932796941033388
,0.0538376567863085575549320
,0.0597600377185210432373630
,0.0672146761597820358025146
,0.0765979488984734890877348
,0.0883379349495453242147036
,0.1028658304567443004806648
,0.1203978535266492233546387
,0.1408494101103847373490652
,0.1636704078342919310706804
,0.1879145764637809301600413
,0.2125220484841090773375782
,0.2366618889461047370303959
,0.2599011920388732410636123
,0.2821407657209196728764766
,0.3034490801285646965901321
,0.3239329154886016470804577
,0.3436825166965563616017221
,0.3627635994264636343231700
,0.3812239765790640944054246
,0.3990995686070991088634230
,0.4164180743482732149907122
,0.4332042651877546779459749
,0.4494862908220133013159625
,0.4652921354985209978494254
,0.4806320254147310455650199
,0.4959719153309410932806145
,0.5113118052471511409962091
,0.5266516951633611887118036
,0.5419915850795712364273982
,0.5573314749957812841429927
,0.5726713649119913318585873
,0.5880112548282013795741818
,0.6033511447444114272897764
,0.6186910346606214750053709
,0.6340309245768315227209655
,0.6493708144930415704365601
,0.6647107044092516181521546
,0.6800505943254616658677492
,0.6953904842416717135833437
,0.7107303741578817612989383
,0.7260702640740918090145328
,0.7414101539903018567301274
,0.7567500439065119044457219
,0.7720899338227219521613165
,0.7874298237389319998769110
,0.8027697136551420475925056
,0.8181096035713520953081002
,0.8334494934875621430236947
,0.8487893834037721907392893
,0.8641292733199822384548838
,0.8794691632361922861704784
,0.8948090531524023338860729
,0.9101489430686123816016675
,0.9254888329848224293172620
,0.9408287229010324770328566
,0.9561686128172425247484512
,2.6690839387622276035472169
,2.5933133203285714252217531
,2.5196923808587206039533157
,2.4481601303145024139951147
,2.3786573095308556347049489
,2.3111263411981330939681811
,2.2455112773728487240987306
,2.1817577721008767355215241
,2.1198130030830846237677179
,2.0596256556640817336756299
,2.0011458697868236278338827
,1.9443252025667454585544647
,1.8891165827973515067839116
,1.8354742756640785028565688
,1.7833538440217155951472705
,1.7327121115812551543911013
,1.6835071271406762960509695
,1.6365342650037069116564226
,1.5900849311436373589856430
,1.5449535191560690439160908
,1.5011026406644696340464407
,1.4584959681973332923377029
,1.4170982050920701844631822
,1.3768750562530671643912683
,1.3377931997399661323555620
,1.2998202591610801270860520
,1.2629247768517037897595401
,1.2270761878128455535374997
,1.1922447943898046851529671
,1.1584017416694714075475758
,1.1255189935759486452582223
,1.0935693096447360872502941
,1.0625262224562417312512252
,1.0323640157099536196483314
,1.0030577029211371620220916
,0.9745830067224348081111884
,0.9469163387532626430242999
,0.9200347801203894171351294
,0.8939160624135484844998700
,0.8685385492604247303916054
,0.8438812184057938869941040
,0.8199236443000489371613071
,0.7966459811827859560651177
,0.7740289466475297475156481
,0.7520538056741170596097845
,0.7307023551156542895412827
,0.7099569086273573859102726
,0.6898002820249915512107464
,0.6702157790609998277986392
,0.6511871776067764683304517
,0.6326987162299224642936224
,0.6147350811556346883435253
,0.5972813936017199454298066
,0.5803231974769924583767988
,0.5638464474330407982805013
,0.5478374972595033698397060
,0.5322830886130228700281464
,0.5171703400699523278660763
,0.5024867364925432733357979
,0.4882201186977764839625138
,0.4743899377038400810846497
,0.4609229171990356643817677
,0.4478384300169028775506774
,0.4351256385819760041933080
,0.4227740133024866509003914
,0.4107733238509241324720733
,0.3991136306930477828380788
,0.3877852768584094111936622
,0.3767788799456512904839656
,0.3660853243560551195656672
,0.3556957537490229581678136
,0.3456015637133634799127435
,0.3357943946484654995643382
,0.3262661248496244170702596
,0.3170088637919696306077810
,0.3080149456076238245749721
,0.2992769227508842444507309
,0.2907875598463511290781014
,0.2814556556611308990589748
,0.2734377678593752913904780
,0.2656479896383275862703499
,0.2591790964731220947570023
,0.2518315200432637013250314
,0.2446933241916317003372683
,0.2377586008085599000860810
,0.2310216107220702808078272
,0.2244767789555477677243545
,0.2181186901064025573937499
,0.2119420838334954704240687
,0.2059418504382124204266091
,0.2001130265204474623086384
,0.1944507906863184587553661
,0.1889504592791779458149648
,0.1836074820994661460638042
,0.1784174380723594355302453
,0.1733760308153776408257585
,0.1684790840517151611077651
,0.1637225368099147204681287
,0.1591024383477980252976636
,0.1546149427397512376991529
,0.1502563030732669280276070
,0.1460228652148802541699268
,0.1419110611291101164965767
,0.1379174017681469577301101
,0.1340384695956718108522665
,0.1302709108651756431118685
,0.1266114278400584658434980
,0.1230567712166539678930732
,0.1196037330875465154456094
,0.1162491408549530397253946
,0.1129898525650538110287613
,0.1098227541757487574214380
,0.1067447592840613246334414
,0.1037528118177993285975447
,0.1008438921332901055949449
,0.0945705559426758685104275
,0.0952633026316892922435997
,0.0925858838253116600558457
,0.0899800338568321617094270
,0.0874431397710922347910056
,0.0849727392628284172726438
,0.0840232608928205837450776
,0.0817570833177723582663177
,0.0795590184022559598897573
,0.0774272765115452260564766
,0.0753601260046723453456252
,0.0733558921113732775864946
,0.0714129558903693478777441
,0.0695297532722555788886609
,0.0677047741909134054294483
,0.0659365618080229726194474
,0.0642237118361738412719575
,0.0625648719669360253714530
,0.0609587414112962230894333
,0.0594040705612864372575643
,0.0578996607829783405119173
,0.0564443643523111285298377
,0.0550370845481638337748365
,0.0536767759185946546907076
,0.0523624447379778812372564
,0.0510931496778549501525113
,0.0498680027169104631012964
,0.0486861703218635713530382
,0.0475468749252990832698806
,0.0464493967529452794762435
,0.0453930760383633169485762
,0.0443773156943647884009607
,0.0434038537174408489693889
,0.0424677309927603829908804
,0.0415707867791003382595960
,0.0407127131218190801975609
,0.0398932879027512621306073
,0.0391123822869825360504237
,0.0383699694930457260722001
,0.0376661352192255577397972
,0.0370010898385323347414833
,0.0363751830064210496251675
,0.0357889209226655707896114
,0.0352429869827623129530103
,0.0347382665154723421774285
,0.0342758762255477925084968
,0.0338572000734515612951903
,0.0333880961949129806409786
,0.0330610446247086228743761
,0.0327838324801210528880446
,0.0325594273637165657064863
,0.0324929817709929680269454
,0.0323874499547439145819006
,0.0323479603203879265138632
,0.0323807710090552661186258
,0.0324934470746678430441712
,0.0326951684864310795908260
,0.0329971245138853744305329
,0.0334130265241391957720118
,0.0339597744619095573415102
,0.0346583326399588984023659
,0.0355348873886506613772873
,0.0366223859344008348393196
,0.0379625915930067794890057
,0.0396088369279004315348658
,0.0416297045635676543628989
,0.0441139252414154275916403
,0.0471767938751782717199390
,0.0509683293802883768952583
,0.0556830668972362885504879
,0.0615704722436337045787802
,0.0689429836811501356441667
,0.0781749397138516988192691
,0.0896692974250027086124959
,0.1038489878067081206847178
,0.1209348283914178090459046
,0.1408965367317448480477537
,0.1632751072873923625650150
,0.1872168033750929438951971
,0.2117162085435982665782007
,0.2358672935671940473767449
,0.2592078806131633550435822
,0.2815623346413885785821662
,0.3029685781587031501160823
,0.3235277092592122039071967
,0.3433344554181093633005162
,0.3624600167495440894427361
,0.3809560013162150982068965
,0.3988609909754310955953827
,0.4162051168815944501844228
,0.4330144240690585455411110
,0.4493152402483548413236747
,0.4651328106261518602337901
,0.4804811667214279324866766
,0.4953590188293673923780602
,0.5102368709373068522694439
,0.5251147230452463121608275
,0.5399925751531857720522112
,0.5548704272611252319435948
,0.5697482793690646918349785
,0.5846261314770041517263621
,0.5995039835849436116177458
,0.6143818356928830715091294
,0.6292596878008225314005131
,0.6441375399087619912918967
,0.6590153920167014511832804
,0.6738932441246409110746640
,0.6887710962325803709660477
,0.7036489483405198308574313
,0.7185268004484592907488150
,0.7334046525563987506401986
,0.7482825046643382105315823
,0.7631603567722776704229659
,0.7780382088802171303143496
,0.7929160609881565902057332
,0.8077939130960960500971169
,0.8226717652040355099885005
,0.8375496173119749698798842
,0.8524274694199144297712678
,0.8673053215278538896626515
,0.8821831736357933495540351
,0.8970610257437328094454188
,0.9119388778516722693368024
,0.9268167299596117292281861
,0.9416945820675511891195697
,0.9565724341754906490109533
,2.7433589235349491453064275
,2.6654814796008268196203517
,2.5898135007295617349143413
,2.5162923004143209482208476
,2.4448569713300436490044376
,2.3754483353379445276232218
,2.3080088910944338564945610
,2.2424827696563611745261824
,2.1788156956312061396374702
,2.1169549200389052856507988
,2.0568491973996847477224037
,1.9984487355707747369137905
,1.9417051572504608891733824
,1.8865714550385563885726015
,1.8330019561845773967689865
,1.7809522838602476202396474
,1.7303793203962343216772979
,1.6812411715613861939999651
,1.6343327964852343292534442
,1.5879465943136157335402459
,1.5428765421262800039414742
,1.4990853023812404920533936
,1.4565365970157184705158215
,1.4151951773908093556997301
,1.3750267950901970959165510
,1.3359981735453572149197043
,1.2980769804683531809530450
,1.2612318010657883604608287
,1.2254321120132403155622569
,1.1906482561683877641200979
,1.1568514180018656389847820
,1.1240135997255384925352928
,1.0921075980984094044856647
,1.0611069818909848461174761
,1.0309860699894413116339820
,1.0017199101214797618553121
,0.9732842581862939379533373
,0.9456555581715367919670712
,0.9188109226407151775006810
,0.8927281137748815931232116
,0.8673855249529778266293079
,0.8427621628556457578085315
,0.8188376300777449046108813
,0.7955921082352699347239877
,0.7730063415527810288807586
,0.7510616209178713198468813
,0.7297397683896056364005744
,0.7090231221482723444893281
,0.6888945218741658882422030
,0.6693372945435182019835452
,0.6503352406300609844791438
,0.6318726207010603168612306
,0.6139341423970234856710704
,0.5965049477845824066335467
,0.5795706010723530310357887
,0.5631170766798035964839642
,0.5471307476493140198314791
,0.5315983743916794512784918
,0.5165070937551853313962624
,0.5018444084081119527240844
,0.4875981765239159604341523
,0.4737878948516711097305176
,0.4603402470446467664721979
,0.4472746497508647278706917
,0.4345802810725949982817440
,0.4222466267115733695725055
,0.4102634712624876334174928
,0.3986208897546373308706791
,0.3873092394348322531349993
,0.3763191517848039069349397
,0.3656415247666296441941824
,0.3552675152898494004283236
,0.3451885318941761982003413
,0.3353962276418875898542638
,0.3258824932141793362383453
,0.3166394502059535764892928
,0.3076594446136819427373155
,0.2989350405111598774077208
,0.2904590139080997501785930
,0.2811406899645680912414036
,0.2731356090664642244369986
,0.2653583898331015600291494
,0.2589012912923679965437884
,0.2515658021984368275525412
,0.2444394751985685398931736
,0.2375164122181081249873813
,0.2307908839695903824296153
,0.2242573252215393220243556
,0.2179103301885018661998572
,0.2117446480300688160802736
,0.2057551784436963682178856
,0.1999369673324413454462700
,0.1942852025241803282096242
,0.1887952095134988739211224
,0.1834624471912462417844125
,0.1782825035199823437981337
,0.1732510911065529290997489
,0.1683640426164594028346499
,0.1636173059694418507881153
,0.1590069392530051584078166
,0.1545291052920275409743311
,0.1501800658198939597554045
,0.1459561752117005117845849
,0.1418538737648211700559386
,0.1378696805479749099010434
,0.1340001858876636031681073
,0.1302420436202023634741920
,0.1265919633068780802975795
,0.1230467026858042406400884
,0.1196030607118029609470256
,0.1162578716085535812663210
,0.1130080004174446872688975
,0.1098503405664542770248104
,0.1067818139914648578603362
,0.1037993743141309432864716
,0.1009000135091597666336938
,0.0946474141936861773638512
,0.0953387549746860518684599
,0.0926711469595924292042000
,0.0900752375584759068516405
,0.0875484446321795756196238
,0.0864770040694571723305373
,0.0841514846815532430168716
,0.0818961082519249761180191
,0.0797090421578408730995946
,0.0775885138663698764593946
,0.0755328098252990021155284
,0.0735402744426875698557922
,0.0716093091590605523855118
,0.0697383716170287687452500
,0.0679259749338211871183546
,0.0661706870834490173960418
,0.0644711303961026660491740
,0.0628259811836813786278810
,0.0612339695020921656598567
,0.0596938790625361620501010
,0.0582045473054181652927674
,0.0567648656544019122871525
,0.0553737799697013519106825
,0.0540302912217259651006529
,0.0527334564128550814521290
,0.0514823897780727485207208
,0.0502762643034334946734454
,0.0491143135923818169308319
,0.0479958341461494825130885
,0.0469201881028752029734186
,0.0458868065222042820217041
,0.0448951932792020017015666
,0.0439471787612832481828562
,0.0430379679113800234224740
,0.0421695226852684401652738
,0.0413416935543510777328891
,0.0405544370160385997392538
,0.0398078262118347001030649
,0.0391020635619332354582234
,0.0384374955557195349675759
,0.0378146305009784203243761
,0.0372341595332489339043036
,0.0366969817992268687589785
,0.0362042346968739353618716
,0.0357573299616417428214987
,0.0353579977599039890767685
,0.0350083397211679442362353
,0.0346137233366491728348002
,0.0343701659731444550405222
,0.0341854146252157792273962
,0.0340638479237075630923215
,0.0341142860476808251757319
,0.0341380090417476578235068
,0.0342444187417510620408123
,0.0344428263023071612458637
,0.0347445584698941808965422
,0.0351634609962766728208372
,0.0357165546070669220890537
,0.0364248898021115111167667
,0.0373146714300171683520446
,0.0384187451906225704845177
,0.0397785700782022494381707
,0.0414468407334852365075939
,0.0434909702036786402490343
,0.0459976801046738381639756
,0.0490789638859954538419039
,0.0528795970431449324777873
,0.0575860625296154976515695
,0.0634359601907568543266436
,0.0707252464609656045224639
,0.0797917191914601087177061
,0.0910620810130396279857834
,0.1049017155056729405648852
,0.1215498595064032627544037
,0.1410222744800806171650009
,0.1629429726064084427150647
,0.1865502312900872983192357
,0.2108881245356493405740395
,0.2350075620339446558215712
,0.2584683373693045793650924
,0.2809389381842958277601952
,0.3024500152257086349472104
,0.3230916902846052152220580
,0.3429612520639492290186467
,0.3621354179216221824688660
,0.3806701565024933064940171
,0.3986070251322084145861879
,0.4159784271532515620428683
,0.4328116940031906945129947
,0.4491324538097999918839776
,0.4649645146066752610103379
,0.4803243357685097469911284
,0.4952181672347827356972516
,0.5096551462256708742160072
,0.5240921252165590127347627
,0.5385291042074471512535183
,0.5529660831983352897722739
,0.5674030621892234282910294
,0.5818400411801115668097850
,0.5962770201709997053285406
,0.6107139991618878438472962
,0.6251509781527759823660517
,0.6395879571436641208848073
,0.6540249361345522594035629
,0.6684619151254403979223184
,0.6828988941163285364410740
,0.6973358731072166749598296
,0.7117728520981048134785851
,0.7262098310889929519973407
,0.7406468100798810905160963
,0.7550837890707692290348518
,0.7695207680616573675536074
,0.7839577470525455060723630
,0.7983947260434336445911185
,0.8128317050343217831098741
,0.8272686840252099216286297
,0.8417056630160980601473852
,0.8561426420069861986661408
,0.8705796209978743371848964
,0.8850165999887624757036519
,0.8994535789796506142224075
,0.9138905579705387527411631
,0.9283275369614268912599186
,0.9427645159523150297786742
,0.9572014949432031682974298
,2.8194942478782833994443990
,2.7394572181689684775562910
,2.6616909377511124290549560
,2.5861309809944996729313971
,2.5127147509933465130416153
,2.4413814274719847219330404
,2.3720719167027977114514670
,2.3047287998892898031044751
,2.2392962884911549181765622
,2.1757201825544698614578465
,2.1139478099636179742049080
,2.0539279974708026799135041
,1.9956110268591813472482954
,1.9389485871623381996187163
,1.8838937390890990730696331
,1.8304008752143658966815565
,1.7784256821970974016267064
,1.7279251040695284835635448
,1.6788573065674150530668385
,1.6320168129231724662986380
,1.5856970654795241593149058
,1.5406916039968754361666470
,1.4969631444446143131443705
,1.4544754607714251992689469
,1.4131933548930681876498738
,1.3730826275329217622811484
,1.3341100498879898683668443
,1.2962433361012344334994850
,1.2594511165140085395819369
,1.2237029116778970205814403
,1.1889691071041967873611611
,1.1552209287301340445708320
,1.1224304190814962112199282
,1.0905704141119549888117035
,1.0596145206999207921683137
,1.0295370947842912290326467
,1.0003132201210285234793673
,0.9719186876429861676740529
,0.9443299754059248929394244
,0.9175242291041513231775184
,0.8914792431396795224785023
,0.8661734422292941548704448
,0.8415858635343476112922190
,0.8176961392985554466505960
,0.7944844799795059975267009
,0.7719316578600133871290723
,0.7500189911258582364794734
,0.7287283283968779556971640
,0.7080420336987530705030736
,0.6879429718632438239822591
,0.6684144943450024412001653
,0.6494404254434724688138658
,0.6310050489187365441168254
,0.6130930949905419868883882
,0.5956897277100363652380111
,0.5787805326940539396574081
,0.5623515052120290347303921
,0.5463890386157737033556714
,0.5308799131024457551575324
,0.5158112848009143158733991
,0.5011706751714881669101942
,0.4869459607083734820065501
,0.4731566863926636723469699
,0.4597294937134890902008522
,0.4466838455346111569355116
,0.4340089365211803329458462
,0.4216942685357962794512332
,0.4097296419457137073294462
,0.3981051471779219474989020
,0.3868111565151858277644692
,0.3758383161263422755915542
,0.3651775383243519024212276
,0.3548199940458141576904438
,0.3447571055458548139327490
,0.3349805393024915534105901
,0.3254821991247758838916582
,0.3162542194591999589192710
,0.3072889588890342915661336
,0.2985789938214307159825012
,0.2901171123572655052846869
,0.2808131862349843577142394
,0.2728216998956656813568600
,0.2650578179733867334455510
,0.2586132653091112176824140
,0.2512906255467888816390598
,0.2441769220696616560228875
,0.2372662675130755571828445
,0.2305529431483137603464684
,0.2240313941635374006544623
,0.2176962250662364262154824
,0.2115421951949115475510865
,0.2055642143247130571026560
,0.1997573383479730457779056
,0.1941167650059181237764960
,0.1886378296423063261055830
,0.1833160009433726367333861
,0.1781468766214827081917349
,0.1731261789927037719749592
,0.1682497503917456393995877
,0.1635135483623834373734240
,0.1589136405588352785045458
,0.1544461992952668727419052
,0.1501074956885102840153934
,0.1458938933552124950221440
,0.1418018416508587398183749
,0.1378278684759279004712340
,0.1339685727245425173048687
,0.1302206165129517478895593
,0.1265807173971408294832486
,0.1230456408671727203119062
,0.1196121934851519519327212
,0.1162772171069006710286686
,0.1130375846862592126296221
,0.1098901981964377078115902
,0.1068319892063406273408077
,0.1038599226137506964517954
,0.1009710039563597311351728
,0.0947426575622264538489858
,0.0954309068791637099549163
,0.0927740632293617972781163
,0.0901890787523625947486039
,0.0890017118473511031906398
,0.0866156839437222519917370
,0.0843018934677319531356687
,0.0820584645185918060139585
,0.0798835834988716742000037
,0.0777754980264761808239626
,0.0757325159435574130073476
,0.0737530044272220880463564
,0.0718353892078801153919798
,0.0699781539017071546604498
,0.0681798394655083461746159
,0.0664390437829472935149511
,0.0647544213928428064042109
,0.0631246833723216882461315
,0.0615485973894750806878484
,0.0600249879416619794292309
,0.0585527368007753151735173
,0.0571307836882938846478908
,0.0557581272051804258116370
,0.0544338260503937840240063
,0.0531570005650909421790473
,0.0519268346501915514790149
,0.0507425780915719618069382
,0.0496035493762680135265697
,0.0485091390517206760835123
,0.0474588137362530818053052
,0.0464521208577963820585133
,0.0454886942312435413326988
,0.0445704871445777445204683
,0.0436929110969735690073179
,0.0428580915807417264784540
,0.0420660871094446150997292
,0.0413170899772098421109945
,0.0406114415521788910123924
,0.0399496502002167283573719
,0.0393324128358330943333598
,0.0387606404791190212177909
,0.0382354889522386887090732
,0.0377583958321841967054056
,0.0373311246680024313993052
,0.0369558191507903879835517
,0.0366350684726091599396902
,0.0362746983582142024093997
,0.0360716255189981876982941
,0.0359343225970756019460595
,0.0358681500411923911975087
,0.0358795513492434214875004
,0.0360821100154238225132808
,0.0362759050918376457772752
,0.0365761337515283710408731
,0.0369967591026510098095592
,0.0375548989892941845192276
,0.0382716614085624601271363
,0.0391732344970478277290660
,0.0402923196883258338818479
,0.0416700216351289301486283
,0.0433583433268477300148724
,0.0454234735373600095886815
,0.0479500875323598044208673
,0.0510468802209598712660288
,0.0548534746127860434183887
,0.0595485544229764351964462
,0.0653583663530122177531823
,0.0725632443633551366124479
,0.0814808842938159333391113
,0.0925175480583608489393299
,0.1060249778708064471999251
,0.1222442055753111128657551
,0.1412295034450192221520126
,0.1626798089451060025378837
,0.1859231796180298434961742
,0.2100510859870754754030742
,0.2341476878503247482932181
,0.2576831472688301261086963
,0.2802683131031122876208883
,0.3018902097919363702871465
,0.3226219517822431770426306
,0.3425606203854981157697068
,0.3617880475476384916078132
,0.3803650075752739168066796
,0.3983364156865599192691718
,0.4157370013784905116160928
,0.4325954783678709891781011
,0.4489375065637092321324531
,0.4647863244093320966854321
,0.4801600085637668380300624
,0.4950696996912412051194963
,0.5095270454940962201462185
,0.5235581158712070415361950
,0.5375891862483178629261715
,0.5516202566254286843161481
,0.5656513270025395057061246
,0.5796823973796503270961011
,0.5937134677567611484860777
,0.6077445381338719698760542
,0.6217756085109827912660307
,0.6358066788880936126560073
,0.6498377492652044340459838
,0.6638688196423152554359604
,0.6778998900194260768259369
,0.6919309603965368982159134
,0.7059620307736477196058900
,0.7199931011507585409958665
,0.7340241715278693623858430
,0.7480552419049801837758196
,0.7620863122820910051657961
,0.7761173826592018265557726
,0.7901484530363126479457492
,0.8041795234134234693357257
,0.8182105937905342907257022
,0.8322416641676451121156788
,0.8462727345447559335056553
,0.8603038049218667548956319
,0.8743348752989775762856084
,0.8883659456760883976755849
,0.9023970160531992190655615
,0.9164280864303100404555380
,0.9304591568074208618455145
,0.9444902271845316832354911
,0.9585212975616425046254676
,2.8975200918846888420432606
,2.8152698609501847215597081
,2.7353531861271114244971159
,2.6577038593100446028927308
,2.5822575518918462478268339
,2.5089517612356666553807827
,2.4377257586477600881380567
,2.3685205392257122625210286
,2.3012787709728383944707275
,2.2359447498416096244966411
,2.1724643555497089586481252
,2.1107849966594245394446716
,2.0508555768889080717087836
,1.9926264529329180685834899
,1.9360493864787524653792161
,1.8810775089610272114981626
,1.8276652816903584675145567
,1.7757684581281851787792903
,1.7253440472311933895355196
,1.6763502778352494804181561
,1.6295812157253914964627484
,1.5833313985147254854268795
,1.5383939070087120359886512
,1.4947315134879342046758666
,1.4523080466346247607845044
,1.4110883615672817903430314
,1.3710383107225601051482045
,1.3321247155667716999261074
,1.2943153391085906456225985
,1.2575788591922254511246138
,1.2218848425486306119580604
,1.1872037195832645384285797
,1.1535067598795087917551427
,1.1207660483974823950603650
,1.0889544623485398755491360
,1.0580456487263154574662849
,1.0280140024757384864528831
,0.9988346452819415466350961
,0.9704834049615370661356906
,0.9429367954392192663348737
,0.9161719972931376965163963
,0.8901668388530008524384129
,0.8648997778352703891258102
,0.8403498835003342382066194
,0.8164968193169290788802073
,0.7933208261195585642155947
,0.7708027057450487218304147
,0.7489238051348178215604889
,0.7276660008898306886138130
,0.7070116842656183342441523
,0.6869437465951218069193374
,0.6674455651275245093856370
,0.6485009892715909440852329
,0.6300943272324132093942239
,0.6122103330308097390854982
,0.5948341938949512908152428
,0.5779515180140869512470658
,0.5615483226444997200133002
,0.5456110225579883232782663
,0.5301264188232667207145710
,0.5150816879105907242220042
,0.5004643711096707914265380
,0.4862623642503891008281869
,0.4724952631717507234299092
,0.4590896649729047651611324
,0.4460650812551587018894850
,0.4334107241800216892002595
,0.4211161126862059123077131
,0.4091710638113835174500821
,0.3975656842615217234637726
,0.3862903622208974097063106
,0.3753357593960947591327226
,0.3646928032875098590892549
,0.3543526796820848923097458
,0.3443068253611910600753276
,0.3345469210177941521422440
,0.3250648843772108165239842
,0.3158528635159730257875310
,0.3069032303734834932207320
,0.2982085744513227054675042
,0.2897616966952200612261947
,0.2804730357255854622522406
,0.2724959812092506150627003
,0.2647462645738086206570472
,0.2583150589434628496832147
,0.2510060804855872018670482
,0.2439058053813215054539398
,0.2370083577044401479394509
,0.2303080300139738190168259
,0.2237992786484565010951542
,0.2174767191419954559528094
,0.2113351217498439238440255
,0.2053694070680923411398311
,0.1995746417282157625372463
,0.1939460341424268374765916
,0.1884789302700856650218952
,0.1831688093688466356656619
,0.1780112796870205182919733
,0.1730020740462067385667666
,0.1681370452563136219659157
,0.1634121612996541905715731
,0.1588235002182581678820128
,0.1543672446406149645348194
,0.1500396758927160789642841
,0.1458371676556113327727360
,0.1417561791596494980005616
,0.1377932479456450143295854
,0.1339449822759942732020022
,0.1302080533436722198370461
,0.1265791875018539291986031
,0.1230551588176165833665721
,0.1196327823339083384901471
,0.1163089084971620085218191
,0.1130804192648292849643354
,0.1099442264384159206880298
,0.1068972727644609960195865
,0.1039365363008851184112302
,0.1010590384543017944407595
,0.0948589502025158626263845
,0.0955421368399798631720898
,0.0928971203257235311756546
,0.0915993289559710460734365
,0.0891516356794393310947200
,0.0867783408939273442905815
,0.0844775252221152683773653
,0.0822473339320185931056173
,0.0800859758782443698077458
,0.0779917225496282728869346
,0.0759629072291137796835159
,0.0739979242730297998020816
,0.0720952285172183765515896
,0.0702533348204258528690858
,0.0684708177553047109276108
,0.0667463114599405604732141
,0.0650785096652533034955468
,0.0634661659157989832547031
,0.0619080940030050583255949
,0.0604031686367941175741514
,0.0589503263828091705889278
,0.0575485668948837250646910
,0.0561969544837792253644260
,0.0548946200668368189390378
,0.0536407635567721780001094
,0.0524346567283181935748004
,0.0512756466675436881064165
,0.0501631598640043946391032
,0.0490967070802178426336404
,0.0480758890911818920210763
,0.0471004034275919400420740
,0.0461700523678066354626992
,0.0452869533530196391457601
,0.0444467803826241250608753
,0.0436518781777396613907882
,0.0429025806162453351988439
,0.0421993939859296382510756
,0.0415430186874579041034217
,0.0409343753816561878311475
,0.0403746360596447945168208
,0.0398652614388363274455784
,0.0394080460947645316860388
,0.0390051726169635751273468
,0.0386592781220845768674899
,0.0383735347614379482261704
,0.0381517487176008043836539
,0.0378996157505994413217110
,0.0378187899199751431655869
,0.0378183787292500489529701
,0.0379062583320222482030637
,0.0381980011448375678106970
,0.0384953161723725276188723
,0.0389162518571860086002978
,0.0394780011035642530714540
,0.0402016997785659621622578
,0.0411134841307095322271437
,0.0422458696075515768852959
,0.0436395584754310228436935
,0.0453458102943140525797894
,0.0474295418393155115976967
,0.0499733488619038684896978
,0.0530826391085836776784213
,0.0568919797494253573488798
,0.0615725064775248590032142
,0.0673396078143367188273416
,0.0744405013489158745576546
,0.0832294265506062919124375
,0.0940369961017738370534502
,0.1072197904539772816967513
,0.1230190691628322563477838
,0.1415208305872991401130889
,0.1624910038319292981956465
,0.1853438249464177678405008
,0.2092369648938160742179804
,0.2332639466116702697817686
,0.2568539910515197921547781
,0.2795487683540533452308807
,0.3012860237647180250419865
,0.3221153636849899415395271
,0.3421300060405669807295226
,0.3614159301568199977872098
,0.3800389756664518392526020
,0.3980478346120052135503897
,0.4154797654493170289136117
,0.4323650269370716281436273
,0.4487298050769022439432376
,0.4645973466543575902676366
,0.4799868946369116318173553
,0.4949127657172382455108561
,0.5093885492590848329541586
,0.5234358454976471008990302
,0.5370848275012529704497410
,0.5507338095048588400004519
,0.5643827915084647095511627
,0.5780317735120705791018736
,0.5916807555156764486525844
,0.6053297375192823182032953
,0.6189787195228881877540061
,0.6326277015264940573047170
,0.6462766835300999268554278
,0.6599256655337057964061387
,0.6735746475373116659568495
,0.6872236295409175355075604
,0.7008726115445234050582712
,0.7145215935481292746089821
,0.7281705755517351441596929
,0.7418195575553410137104038
,0.7554685395589468832611146
,0.7691175215625527528118255
,0.7827665035661586223625363
,0.7964154855697644919132472
,0.8100644675733703614639580
,0.8237134495769762310146689
,0.8373624315805821005653797
,0.8510114135841879701160906
,0.8646603955877938396668014
,0.8783093775913997092175123
,0.8919583595950055787682231
,0.9056073415986114483189340
,0.9192563236022173178696448
,0.9329053056058231874203557
,0.9465542876094290569710665
,0.9602032696130349265217774
,2.9774658227291990186813564
,2.8929479429878131035991373
,2.8108279725604989884857332
,2.7310378768688710060530411
,2.6535115528153454533821787
,2.5781847738390939461794460
,2.5049951364477487381066112
,2.4338820082639025521586973
,2.3647864778220655246343540
,2.2976513008941665816564637
,2.2324208726149752379797064
,2.1690411465316516981260975
,2.1074596188979395350315826
,2.0476252748488552590799827
,1.9894885496742982233797647
,1.9330012815213750698717377
,1.8781166762165069084034030
,1.8247892673698591359254806
,1.7729748787099062212746503
,1.7226305874859346722871578
,1.6737146889084384415724571
,1.6270207689259548189397719
,1.5808445145798390996105809
,1.5359785252411168876562897
,1.4923856324280715401897623
,1.4500297224025842091066352
,1.4088757062524106533629720
,1.3688894908195152755325807
,1.3300379504566501864815109
,1.2922888995838657244519254
,1.2556110660243000598512708
,1.2199740650968140531773543
,1.1853483744440220792881746
,1.1517053095748672753018127
,1.1190170001015025125212787
,1.0872563666508003876742805
,1.0563970984314006162918531
,1.0264136314377174663547976
,0.9972811272728876463844472
,0.9689754525731536505261943
,0.9414731590166521835172375
,0.9147514639001073089019656
,0.8887882312673900386812420
,0.8635619535743452868103986
,0.8390517338747836006973557
,0.8152372685129563034678313
,0.7920988303082496795326506
,0.7696172522182993525063921
,0.7477739114670952647045965
,0.7265507141250837630508386
,0.7059300801286666482425858
,0.6858949287268776284776095
,0.6664286643434198520452583
,0.6475151628426153438411461
,0.6291387581881825452612134
,0.6112842294841243084846383
,0.5939367883873329923005713
,0.5770820668818280596568115
,0.5607061054048044779207771
,0.5447953413148542978206024
,0.5293365976928271487977895
,0.5143170724657335490803689
,0.4997243278438741609370766
,0.4855462800608368323374009
,0.4718025785690728723942300
,0.4584197737530452121390567
,0.4454174285988103387801118
,0.4327847737486625878666757
,0.4205113461832116206196019
,0.4085869805585915504053673
,0.3970018007909481005945906
,0.3857462118813137497141952
,0.3748108919742027533850148
,0.3641867846434555522350252
,0.3538650913990805113584770
,0.3438372644090325613852599
,0.3340949994300738135066808
,0.3246302289420591735691346
,0.3154351154801743883915321
,0.3065020451598438055995643
,0.2978236213891969907940904
,0.2893926587641318382004840
,0.2801201831258767760424178
,0.2721584505455780789162645
,0.2644237801334728965585441
,0.2580067760946820887291153
,0.2507123243619710506457920
,0.2436263362153460731995835
,0.2367429479545561932241071
,0.2300564642161571360379213
,0.2235613532824101135076944
,0.2172522425123609712827033
,0.2111239138827298300604696
,0.2051712996230979912937187
,0.1993894779258894300877358
,0.1937736687067183882771104
,0.1883192293847811837892436
,0.1830216506461795344939958
,0.1778765521456120990428929
,0.1728796780942012389914453
,0.1680268926740944579467651
,0.1633141752149772085722645
,0.1587376150652387851724967
,0.1542934060930678807910255
,0.1499778407623208742460719
,0.1457873037467780075182588
,0.1417182650763865181531287
,0.1377672728517352618293756
,0.1339309456188263747211664
,0.1302059645643573460027653
,0.1265890657696372156859610
,0.1230770328444500821829521
,0.1196666903442229895615512
,0.1163548984466445390673073
,0.1131385494181497558541238
,0.1100145664268138978592049
,0.1069799052471904210470655
,0.1040315593472480315551110
,0.1011665687433788013427360
,0.0949992954701909253500958
,0.0956751273969436155653057
,0.0942718373947868532036765
,0.0917613349732014083048881
,0.0893274612483122149031445
,0.0869682532717967055058139
,0.0846818152231885445946347
,0.0824663173899184281934183
,0.0803199952645003434348325
,0.0782411487658752485829794
,0.0762281415937676315452975
,0.0742794007242317533279419
,0.0723934160599334491914547
,0.0705687402466290969460516
,0.0688039886715767490255047
,0.0670978396622517042624523
,0.0654490349063107240690229
,0.0638563801151401239097893
,0.0623187459626351608621420
,0.0608350693315754947887442
,0.0594043549025554673548299
,0.0580256771352792785623187
,0.0566981826959104123764277
,0.0554210934014991163376607
,0.0541937097247514945608238
,0.0530154149907462388102708
,0.0518856803346171083224370
,0.0508040705869129138871898
,0.0497702511981261488949180
,0.0487839963637411860863935
,0.0478451986570325171754803
,0.0469538802763928217465228
,0.0461123790291005156150028
,0.0453167057551084120903262
,0.0445695007921266053707576
,0.0438714656550595882844590
,0.0432235280389819329083245
,0.0426268735167034187871771
,0.0420829832841251166852814
,0.0415936796859804128190241
,0.0411611812976535873520589
,0.0407881692078802191026021
,0.0404778686208152604919519
,0.0402341479374841784477645
,0.0400616409323161087874254
,0.0398668230584541607997018
,0.0398529213403460078057883
,0.0399302957453212606364623
,0.0401085549122176462932821
,0.0403993156122352675696519
,0.0409253700543968576552878
,0.0414891460343802392918278
,0.0422181417627075852849750
,0.0431384059960286114776551
,0.0442822273359691973015906
,0.0456898597819812499198910
,0.0474117711441301645236557
,0.0495115622482507969359666
,0.0520697244573172721149312
,0.0551883946561637500627384
,0.0589971868437683955033179
,0.0636599378341246024959332
,0.0693816550945438870190429
,0.0763967926697156768378605
,0.0850389577575182825652789
,0.0956217625757428135724325
,0.1084872234456978473682298
,0.1238756125095592935947408
,0.1418986160312044053632974
,0.1623815207623350853616273
,0.1848203463842414684403792
,0.2084423434535241648202231
,0.2323631098844419207161138
,0.2559837481856639396227138
,0.2787793732912892119557569
,0.3006345056063673970569994
,0.3215686239342253061046506
,0.3416665792239985677269942
,0.3610168475135176469059672
,0.3796903123331286655783856
,0.3977398505535144068723241
,0.4152055559477236812426781
,0.4321194536169311595230624
,0.4485086163658893454453391
,0.4643966934588306116893364
,0.4798038660392789367392652
,0.4947465554104045759586938
,0.5092398342488119178383954
,0.5233028155659382729680829
,0.5369599358519210330342730
,0.5502301186107735331276558
,0.5635003013696260332210386
,0.5767704841284785333144214
,0.5900406668873310334078042
,0.6033108496461835335011870
,0.6165810324050360335945697
,0.6298512151638885336879525
,0.6431213979227410337813353
,0.6563915806815935338747181
,0.6696617634404460339681009
,0.6829319461992985340614837
,0.6962021289581510341548665
,0.7094723117170035342482493
,0.7227424944758560343416320
,0.7360126772347085344350148
,0.7492828599935610345283976
,0.7625530427524135346217804
,0.7758232255112660347151632
,0.7890934082701185348085460
,0.8023635910289710349019288
,0.8156337737878235349953115
,0.8289039565466760350886943
,0.8421741393055285351820771
,0.8554443220643810352754599
,0.8687145048232335353688427
,0.8819846875820860354622255
,0.8952548703409385355556083
,0.9085250530997910356489911
,0.9217952358586435357423738
,0.9350654186174960358357566
,0.9483356013763485359291394
,0.9616057841352010360225222
,3.0593598772942178776190758
,2.9725190954536468979085839
,2.8881421454978988272443985
,2.8061591218056447516460139
,2.7265021033791567717230464
,2.6491050975328689354171274
,2.5739039849949620908375891
,2.5008364665062718934507302
,2.4298420116545589308998387
,2.3608618051051073472024200
,2.2938387018518686666368467
,2.2287171858746890329427970
,2.1654433031261031139536044
,2.1039646362506188026486598
,2.0442302591093173269598537
,1.9861906861853750871915736
,1.9297978372408230995915801
,1.8750049963222210624991249
,1.8217667730609823362186717
,1.7700390650707680251230158
,1.7197790214110273421255215
,1.6709450070867974957877777
,1.6243301049728093854440658
,1.5782312078114484332758138
,1.5334404102063465824556943
,1.4899206059704577231883604
,1.4476357419180725383256458
,1.4065507879971743676605911
,1.3666317082666887827713254
,1.3278454327004090007591230
,1.2901598297896073042068110
,1.2535436799236461258288955
,1.2179666495261889380685716
,1.1833992659255845314447697
,1.1498128929386417507174656
,1.1171797071475444429466961
,1.0854726748503173983095849
,1.0546655296657327927078995
,1.0247327507741501584348498
,0.9956495417762796229510514
,0.9673918101523898416260749
,0.9399361473049884230235307
,0.9132598091684702712456101
,0.8873406973697308686155338
,0.8621573409241884977660675
,0.8376888784521213660028138
,0.8139150409006654651733470
,0.7908161347572486565837835
,0.7683730257406607977443969
,0.7465671229563756172709077
,0.7253803635031490504303520
,0.7047951975183033290761614
,0.6847945736495212321059967
,0.6653619249413438296869572
,0.6464811551249485255254967
,0.6281366253001599009309075
,0.6103131409989993594322755
,0.5929959396204160793075744
,0.5761706782261670767297801
,0.5598234216880647595715459
,0.5439406311770357271839771
,0.5285091529845249436192489
,0.5135162076667605379753923
,0.4989493795021761601837795
,0.4847966062517870544645859
,0.4710775938715845434501261
,0.4577188436059773102293491
,0.4447399726032954525578589
,0.4321302310247680522614644
,0.4198791749120613370216404
,0.4079766575409147777442342
,0.3964128210217415237970329
,0.3851780881403319423128551
,0.3742631544320059178154736
,0.3636589804827673466647298
,0.3533567844512246480803697
,0.3433480348052422304050424
,0.3336244432674894677681721
,0.3241779579642539155237557
,0.3150007567720723433701835
,0.3060852408569293969797798
,0.2974240284009411761090291
,0.2890099485116026656328359
,0.2797546345324536942733573
,0.2718091703169422945762790
,0.2640904835725212951302865
,0.2576885928406219550268474
,0.2504095904371460568071939
,0.2433388054017461832323477
,0.2364703871133313761720984
,0.2297986531434682566654715
,0.2233180845814891346545750
,0.2170233214822018252831981
,0.2109091584237630379039530
,0.2049705401600515342064313
,0.1992025573477593514137851
,0.1936004423233367022216811
,0.1881595648988104441112768
,0.1828754281384694924117440
,0.1777436640706693271596350
,0.1727600292810865523218666
,0.1679204003264241906734355
,0.1632207689020211127672866
,0.1586572366946385204133918
,0.1542260098548190738743102
,0.1499233930338789433367452
,0.1457457829510638569470160
,0.1416896614887342698008155
,0.1377515883590520184842632
,0.1339281934448810773563565
,0.1302161689893483742519464
,0.1266122618897419227490531
,0.1231132664371330648345193
,0.1197160179262480583783912
,0.1164173876319770650766827
,0.1132142796996986611191005
,0.1101036305163775735893594
,0.1070824111091058100653228
,0.1041476330504671060639410
,0.1012963582320298844274831
,0.0951670782518679453376720
,0.0970212549468868479252137
,0.0944468161592698779438493
,0.0919513080967699902856793
,0.0895327242631504677250476
,0.0871891279265625401828643
,0.0849186511493328216593213
,0.0827194939471706386369121
,0.0805899235861143453663047
,0.0785282740283926999902420
,0.0765329455353203902401305
,0.0746024044458135221491446
,0.0727351831421685773859664
,0.0709298802226482477673031
,0.0691851609027729491652181
,0.0674997576703158796984638
,0.0658724712200823431240693
,0.0643021717071254189646012
,0.0627878003567840514698162
,0.0613283714726561221541878
,0.0599229749029615427202700
,0.0585707790297808478241492
,0.0572710343676822788983038
,0.0560230778195803733043867
,0.0548263377547812680301575
,0.0536803399878232820330304
,0.0525847148641891484754929
,0.0515392055868928167239318
,0.0505436779782439601915733
,0.0495981320606962011732222
,0.0487027155754200663517750
,0.0478598496346587035099596
,0.0470658406208816770810444
,0.0463234647095124504878605
,0.0456336539546259162269948
,0.0449976045042353445246874
,0.0444168149895962718898268
,0.0438931323393001934785040
,0.0434288071523510482707664
,0.0430265608595341020325975
,0.0426896667691078757211898
,0.0424220500665736868772804
,0.0422284096024177768580188
,0.0421143684562397951909318
,0.0420866618100644226951879
,0.0420524454105239073320455
,0.0422215326838304427781168
,0.0425063114820752596667575
,0.0429209513030851599890703
,0.0434826872685715251631855
,0.0443242124416966115640903
,0.0452510677631230082140767
,0.0464043019150785288062799
,0.0478236767088372621836712
,0.0495588234452018633335868
,0.0516719880606681739032560
,0.0542415379152895449355043
,0.0573663635073962674404413
,0.0611712312147544012841394
,0.0658129262478543142211862
,0.0714865347419719743271571
,0.0784148367185193151396305
,0.0869111303166447135559736
,0.0972732316662743706769945
,0.1098284040657512700134291
,0.1248149737283118926312042
,0.1423650008549601497787052
,0.1623559016751473238482362
,0.1843587436933253331794447
,0.2076765118702407209028138
,0.2314531414065616465869368
,0.2550765581714750651620705
,0.2779601401975321794957097
,0.2999330610548167630469152
,0.3209783410951665971744262
,0.3411672425833492394708912
,0.3605883161586357354977395
,0.3793170711340574929870684
,0.3974108996476703459244106
,0.4149131024156867408869687
,0.4318577464289536926855817
,0.4482730869492767000750177
,0.4641834612029474560479514
,0.4796098967677391300412637
,0.4945702784089973103043292
,0.5090808233151276063210844
,0.5231593833084321465420885
,0.5368268036921923780369070
,0.5501009931910992856174403
,0.5629868061434267767495498
,0.5758726190957542678816594
,0.5887584320480817590137690
,0.6016442450004092501458786
,0.6145300579527367412779881
,0.6274158709050642324100977
,0.6403016838573917235422073
,0.6531874968097192146743168
,0.6660733097620467058064264
,0.6789591227143741969385360
,0.6918449356667016880706456
,0.7047307486190291792027551
,0.7176165615713566703348647
,0.7305023745236841614669743
,0.7433881874760116525990838
,0.7562740004283391437311934
,0.7691598133806666348633030
,0.7820456263329941259954126
,0.7949314392853216171275221
,0.8078172522376491082596317
,0.8207030651899765993917413
,0.8335888781423040905238508
,0.8464746910946315816559604
,0.8593605040469590727880700
,0.8722463169992865639201796
,0.8851321299516140550522891
,0.8980179429039415461843987
,0.9109037558562690373165083
,0.9237895688085965284486178
,0.9366753817609240195807274
,0.9495611947132515107128370
,0.9624470076655790018449466
,3.1432296392773095838890640
,3.0540099263329150147683322
,2.9673215592335875356866381
,2.8830927162735897617551473
,2.8012536145937518838877622
,2.7217364525896314830788469
,2.6444753536236169644269012
,2.5694063111803862042847868
,2.4964671355412835218601231
,2.4255974024949216172331035
,2.3567384006171141486163378
,2.2898330860613071990883327
,2.2248260376503981028406542
,2.1616633981438981848555159
,2.1002928422193316571053856
,2.0406635333335305659829828
,1.9827260728414455304147168
,1.9264324650982045383784680
,1.8717360763654771194097748
,1.8185915961797607387495646
,1.7669549998157580983360049
,1.7167835118141236971922581
,1.6680355705436795688001439
,1.6215037317130691629785133
,1.5754861521786174272108383
,1.5307743975830756522071852
,1.4873314272246658251930285
,1.4451212515744285003194136
,1.4041089024576303145863676
,1.3642604040858876679465084
,1.3255427449091776725964564
,1.2879238502672636368373560
,1.2513725558174340068973152
,1.2158585817165226128366839
,1.1813525075358473070963328
,1.1478257478882845088463682
,1.1152505287473133410713899
,1.0835998644384310374277902
,1.0528475352838893019935540
,1.0229680658822724037548824
,0.9939367040049295054515710
,0.9657294000918341669859046
,0.9383227873299050392219556
,0.9116941622973333547719221
,0.8858214661579304483041142
,0.8606832663899746105329314
,0.8362587390344874416214793
,0.8125276514483130707588998
,0.7894703455477970477360827
,0.7670677215293038031518336
,0.7453012220531969322934174
,0.7241528168783378793804673
,0.7036049879345418478493457
,0.6836407148208318851345666
,0.6642434607177125638344251
,0.6453971587020690403591061
,0.6270861984536685307389803
,0.6092954133426051743782637
,0.5920100678873729815876459
,0.5752158455735715270051855
,0.5588988370235328240198669
,0.5430455285073654270178167
,0.5276427907860558041974741
,0.5126778682772370476783408
,0.4981383685340508571393059
,0.4840122520270683792453781
,0.4703192842454185784717424
,0.4569859147660248477329503
,0.4440318178123233150422777
,0.4314462641593092562253275
,0.4192188299852854793670076
,0.4073393882429635626252207
,0.3957981002772237855147353
,0.3845854076826944467626390
,0.3736920243945062725110517
,0.3631089290058143737027763
,0.3528273573058607337493697
,0.3428387950325751942770580
,0.3331349708339033655057904
,0.3237078494322552235651358
,0.3145496249866636118142083
,0.3056527146474289358124565
,0.2970097522982090842980085
,0.2886135824806749794468885
,0.2793764661621447875639035
,0.2714482767687670383693899
,0.2637465714506848635245717
,0.2573607669418799814842203
,0.2500981976795783046085830
,0.2430435936169093869008151
,0.2361911181382840840825565
,0.2295351026834813734645024
,0.2230700420907879844012456
,0.2167905900632350335577314
,0.2106915547454177028985356
,0.2047678943950489716119279
,0.1990147131291521709339776
,0.1934272567195121084182574
,0.1880009084056686874397712
,0.1827311846864100586262936
,0.1776137310426957882647514
,0.1726443175367193827440815
,0.1678188342243008002174776
,0.1631332863122391951815615
,0.1585837889903672359714903
,0.1541665618719179620121906
,0.1498779229878043905976881
,0.1457142823028927669515298
,0.1416721347574244616041028
,0.1377480528857357167105135
,0.1339386791275137267298589
,0.1302407180225002292228709
,0.1266509285643190874104391
,0.1231661170773065694383774
,0.1197831310641376684200665
,0.1164988545422915439120359
,0.1133102054336736497219817
,0.1102141355837629038694203
,0.1072076339554770274542506
,0.1042877334620281176702505
,0.1014515217694450383012494
,0.0998496333634978638915669
,0.0972101512355803831777479
,0.0946519765039716548526982
,0.0921730592799083897626033
,0.0897714222445000209482657
,0.0874451597408664876853734
,0.0851924370097064537210585
,0.0830114895780357381349646
,0.0809006228156991108457774
,0.0788582116657759596423105
,0.0768827005762417747813942
,0.0749726036423574576650353
,0.0731265049848559695044869
,0.0713430593898508463857056
,0.0696209932402678532969986
,0.0679591057690922539791245
,0.0663562706817147213156360
,0.0648114381927753085976818
,0.0633236375257248823578138
,0.0618919799484445101733776
,0.0605156624222931843748441
,0.0591939719698062194463972
,0.0579262908133595030846230
,0.0567121024911538193502558
,0.0555509990394165639737700
,0.0544426894948321013489867
,0.0533870098782704693984869
,0.0523839348933140894204463
,0.0514335918176341694296738
,0.0505362767181551097994685
,0.0496924737062837754142386
,0.0489049549583575396405344
,0.0481705278618885651686909
,0.0474924427727483680627962
,0.0468722122475069141733783
,0.0463117041783372707097755
,0.0458131973399566252980186
,0.0453794486632142293758285
,0.0450137750236809658366255
,0.0447201522078029406470634
,0.0445033372714855254836941
,0.0443690179823399630243408
,0.0443239980000668248871776
,0.0443764283573902032498104
,0.0444348797356418842574577
,0.0447117838135973680313562
,0.0451217861439852235827530
,0.0456821333706234969374016
,0.0464138430161988926880845
,0.0474546229230977736901487
,0.0486150830423972696303636
,0.0500438369503167293506074
,0.0517896379402235998434811
,0.0539133430760300805251184
,0.0564911821942775949079163
,0.0596188293015234363481092
,0.0634163137468316123745993
,0.0680336123427670996788308
,0.0736563330157522094809863
,0.0804964897120370725946970
,0.0888476495626183138121235
,0.0989928426490597479503464
,0.1112445199651734550894133
,0.1258382807569867756214421
,0.1429219366850222605602738
,0.1624143821765816342317379
,0.1839676911767703926248174
,0.2069488369033581076639194
,0.2305818504544205338468998
,0.2541378349610449727258299
,0.2770921886916601351025236
,0.2991796444632850993095019
,0.3203411507137040037385134
,0.3406286608217650724306225
,0.3601275700909638555202719
,0.3789170774565315813475763
,0.3970592562428839067401043
,0.4146010091894752336294516
,0.4315787704614916231449229
,0.4480222533101234638763799
,0.4639567120057775939656608
,0.4794040131660856629558509
,0.4943831444328017354905569
,0.5089112373574395942199544
,0.5230056211256316478497297
,0.5366850080603161599057671
,0.5499664378268647180192374
,0.5628589005022592850480123
,0.5753625553628244349013698
,0.5878662102233895847547274
,0.6003698650839547346080849
,0.6128735199445198844614424
,0.6253771748050850343147999
,0.6378808296656501841681575
,0.6503844845262153340215150
,0.6628881393867804838748725
,0.6753917942473456337282300
,0.6878954491079107835815876
,0.7003991039684759334349451
,0.7129027588290410832883026
,0.7254064136896062331416601
,0.7379100685501713829950177
,0.7504137234107365328483752
,0.7629173782713016827017327
,0.7754210331318668325550902
,0.7879246879924319824084478
,0.8004283428529971322618053
,0.8129319977135622821151628
,0.8254356525741274319685203
,0.8379393074346925818218779
,0.8504429622952577316752354
,0.8629466171558228815285929
,0.8754502720163880313819504
,0.8879539268769531812353080
,0.9004575817375183310886655
,0.9129612365980834809420230
,0.9254648914586486307953805
,0.9379685463192137806487381
,0.9504722011797789305020956
,0.9629758560403440803554531
,3.2291013109546389259207899
,3.1374458959731192919662135
,3.0483909530608293003695053
,2.9618626990457754821761682
,2.8777894447892800044996875
,2.7961015364447541209358405
,2.7167312978583741944760277
,2.6396129743131759859409158
,2.5646826777477280678851912
,2.4918783335149168323141566
,2.4211396289982838325727244
,2.3524079576016871939714292
,2.2856263943574481878329152
,2.2207396056365102943175316
,2.1576938392773596930851454
,2.0964368672554347661218799
,2.0369179468903109153643527
,1.9790877708722443006905678
,1.9228984324344391421135469
,1.8683033842194753937349105
,1.8152573997189378474104160
,1.7637165358061468456440934
,1.7136380963313455616514602
,1.6649805967495283631762959
,1.6185360406519444520512252
,1.5726039095811765733401444
,1.5279752151606524890326000
,1.4846129855028775690328757
,1.4424812979716625793713547
,1.4015452494191382726285156
,1.3617709272716949087111971
,1.3231253814343866270775152
,1.2855765969933123926693952
,1.2490934676928762137038120
,1.2136457701659726371445913
,1.1792041388957434921991307
,1.1457400418881877879329068
,1.1132257570354835429782270
,1.0816343491504580853757034
,1.0509396476532089081956656
,1.0211162248914016359435664
,0.9921393750763319863139600
,0.9639850938173146754905929
,0.9366300582374985639333431
,0.9100516076546676380587542
,0.8842277248110783638423982
,0.8591370176368402500344246
,0.8347587015317984304729748
,0.8110725821513233846360436
,0.7880590386818246972921997
,0.7656990075922638361305417
,0.7439739668483087431383183
,0.7228659205762164585706842
,0.7023573841639030312933301
,0.6824313697870768580244771
,0.6630713723486700850173747
,0.6442613558202131551766456
,0.6259857399741562966610786
,0.6082293874965112312480642
,0.5909775914695398757459088
,0.5742160632145466570008807
,0.5579309204851150560955375
,0.5421086760013714700434662
,0.5267362263159902635578646
,0.5118008410026813059801043
,0.4972901521577164918319625
,0.4831921442046183123864012
,0.4695266453397035633088308
,0.4562200508420117261998428
,0.4432920950632507350874789
,0.4307320705468790089653908
,0.4185295747431033719365701
,0.4066745013985774703790810
,0.3951570321924543494063187
,0.3839676286119717563138920
,0.3730970240609625121486204
,0.3625362161948925687759981
,0.3522764594762394785298909
,0.3423092579442283400759095
,0.3326263581931462876006833
,0.3232197425536634249887413
,0.3140816224717785098974332
,0.3052044320802105303869212
,0.2965808219572342308012480
,0.2882036530681285069199760
,0.2789858338525251779671521
,0.2710759897473936086420565
,0.2633923280175717307471928
,0.2570236482029610303179368
,0.2497785614425092060031375
,0.2427411823957608683066667
,0.2359056894608172194605089
,0.2292664289638814134608680
,0.2228179105225623624075837
,0.2165548025328771497566294
,0.2104719277673343935664008
,0.2045642590680429029337262
,0.1988269151143775559376081
,0.1932551562392400279488669
,0.1878443802613415647417838
,0.1825901182932997413033149
,0.1774880304769679839616003
,0.1725339015888999461001418
,0.1677236364511309196778654
,0.1630532550769355770725610
,0.1585188874797313907105689
,0.1541167680781011795065893
,0.1498432296434907273763315
,0.1456946967620117716624151
,0.1416676788200257053329523
,0.1377587625760610945402362
,0.1339646044490142018368317
,0.1302819227325609785506089
,0.1267074900341826348970642
,0.1232381263277949473566864
,0.1198706930931944386609089
,0.1166020890833065898339882
,0.1134292483007096757896548
,0.1103491407676256419456706
,0.1073587766296785483977061
,0.1044552140372923820788031
,0.1027590561867168378329396
,0.1000534479166340084965725
,0.0974316013238577804944640
,0.0948914234307515203070693
,0.0924308968205417302854698
,0.0900480788062629072809884
,0.0877411007591262226412709
,0.0855081676074999352810124
,0.0833475575265601731356213
,0.0812576218184156706669796
,0.0792367850262458012222666
,0.0772835452844435194519335
,0.0753964749385213212073964
,0.0735742214651081555265577
,0.0718155087275288428472209
,0.0701191386019388573913602
,0.0684839930319527945279390
,0.0669090365652920404659909
,0.0653933194288629504598021
,0.0639359812311803971107693
,0.0625362553848765878594662
,0.0611934743770458991485306
,0.0599070759439580616256826
,0.0586766104076784228427144
,0.0575017492744290745210201
,0.0563822954068552775752643
,0.0553181949638620953924040
,0.0543095513881212271778409
,0.0533566420343557085148589
,0.0524599375820913316204042
,0.0516201251201753794073390
,0.0508381358555432608103963
,0.0501172175381932524795836
,0.0494548373420583761705949
,0.0488548932312826145185625
,0.0483196878165868121124404
,0.0478520088562758919015216
,0.0474552108710552533743510
,0.0471333145887938495532943
,0.0468911275863796370155789
,0.0467343937115063529086356
,0.0466699760501547572522085
,0.0467060840938148327805557
,0.0468525580953601736289293
,0.0471212222498516020152692
,0.0474230018267688402389126
,0.0479798502243398428124266
,0.0487111852540534975841702
,0.0496425663557705232342698
,0.0508053394124276455623423
,0.0523532488804482123989636
,0.0541069632016659904372169
,0.0562382267302830168853589
,0.0588211240795854239937768
,0.0619481484340103707997294
,0.0657347055369092991838897
,0.0703242041580333238082190
,0.0758932001372414066775463
,0.0826436808249769866430157
,0.0908502864938600523947443
,0.1007820992873475623996526
,0.1127274020619147137933780
,0.1269466651344294261249956
,0.1435650804465476160221016
,0.1625681289395927153762500
,0.1836565752588696087688191
,0.2062060536317875669709565
,0.2296833823288159937003883
,0.2531742323276195971715197
,0.2761778799304331899477916
,0.2983729607985903253819515
,0.3196538651884697768146282
,0.3400470295655613761631741
,0.3596315545053602180658459
,0.3784878988734056148857121
,0.3966830025011785498811889
,0.4142677353873134293849034
,0.4312812645039073022878995
,0.4477550451697338007583937
,0.4637154574093109160592974
,0.4791852544954667281196237
,0.4941843459480411704376479
,0.5087306371040176689035661
,0.5228413714412151191979206
,0.5365340925702888341675134
,0.5498252082153927133845173
,0.5627261511736039167885792
,0.5752421170787276327729387
,0.5873793567496561340846029
,0.5995165964205846353962670
,0.6116538360915131367079312
,0.6237910757624416380195953
,0.6359283154333701393312595
,0.6480655551042986406429236
,0.6602027947752271419545878
,0.6723400344461556432662519
,0.6844772741170841445779160
,0.6966145137880126458895802
,0.7087517534589411472012443
,0.7208889931298696485129085
,0.7330262328007981498245726
,0.7451634724717266511362368
,0.7573007121426551524479009
,0.7694379518135836537595651
,0.7815751914845121550712292
,0.7937124311554406563828934
,0.8058496708263691576945575
,0.8179869104972976590062217
,0.8301241501682261603178858
,0.8422613898391546616295500
,0.8543986295100831629412141
,0.8665358691810116642528783
,0.8786731088519401655645424
,0.8908103485228686668762066
,0.9029475881937971681878707
,0.9150848278647256694995349
,0.9272220675356541708111990
,0.9393593072065826721228632
,0.9514965468775111734345273
,0.9636337865484396747461915
,3.3169997798287744750211914
,3.2228511877318797296254616
,3.1313738257119934083050339
,3.0424919035713120507580243
,2.9561317811413778677831488
,2.8722219085696472085089681
,2.7906927675310728709234809
,2.7114768136290186006931435
,2.6345084201813349089604799
,2.5597238235125905347899788
,2.4870610706845566184597374
,2.4164599636607588806214153
,2.3478620146256847789345557
,2.2812104039785974229914700
,2.2164499087517350872644784
,2.1535268797479627522761803
,2.0923891951044746306820343
,2.0329862063150225814922578
,1.9752687035593792241883193
,1.9191888734134681104848141
,1.8647002592413515209557318
,1.8117577227097816372491934
,1.7603174063937467863638631
,1.7103366974425160407236035
,1.6617741922763966666565238
,1.6154213165579551780837164
,1.5695789392604657663810030
,1.5250374920633265052316574
,1.4817600753628934473482559
,1.4397108367900419700902148
,1.3988549415059066127753340
,1.3591585433442516794855237
,1.3205887567709413410454999
,1.2831136296398517604444578
,1.2467021167221719046835915
,1.2113240539871834577922982
,1.1769501336132313085158785
,1.1435518797081707376150916
,1.1111016247192269101873308
,1.0795724865127200864378665
,1.0489383461046963841312163
,1.0191738260240477131901571
,0.9902542692902147614120167
,0.9621557189880964866546265
,0.9348548984232819547557369
,0.9083291918412077503575119
,0.8825566256943178089500179
,0.8575158504417673688280388
,0.8331861228666587182445369
,0.8095472888962399471424192
,0.7865797669109291234690318
,0.7642645315284375406861272
,0.7425830978496940071309496
,0.7215175061536602818534902
,0.7010503070285417637208525
,0.6811645469272773478763838
,0.6618437541355931541531277
,0.6430719251412742032414371
,0.6248335113937042439857805
,0.6071134064430766530406913
,0.5898969334490478111376888
,0.5731698330489408688137587
,0.5569182515759047991110720
,0.5411287296176880978748613
,0.5257881909068421455444309
,0.5108839315332113217849042
,0.4964036094694191381115900
,0.4823352343996479829613122
,0.4686987005508174708445779
,0.4554203461704168787171909
,0.4425199689369869182620221
,0.4299868843804255380547374
,0.4178107124213380485500124
,0.4059813687805561843724433
,0.3944890566347147298209563
,0.3833242585110872013842709
,0.3724777284151031264691767
,0.3619404841841765141374765
,0.3517038000616899973138629
,0.3417591994851819636735968
,0.3320984480829945462154740
,0.3227135468738432377833192
,0.3135967256639708988785742
,0.3047404366367499894963089
,0.2961373481297777665588455
,0.2877803385946960390562310
,0.2785829833958729517817687
,0.2706926233251514823940909
,0.2630281361462582512267261
,0.2566776897449793426453368
,0.2494512050838260386331768
,0.2424321661198266530945489
,0.2356147673649025553466174
,0.2289933711457171894299023
,0.2225625029896687867569938
,0.2163168471353047184191354
,0.2102512421544288911956500
,0.2043606766695987286830416
,0.1986402851461178120651141
,0.1930853437318874321615425
,0.1876912661115686942192582
,0.1824535993335094086198467
,0.1773680195591517405606652
,0.1724303276757861436152552
,0.1676364447056181428141741
,0.1629824069386844043183515
,0.1584643607162054268489015
,0.1540785567969169822521991
,0.1498213442544535922706928
,0.1456891638815354383940104
,0.1416785411186626819635137
,0.1377860785823094291746571
,0.1340084483398193138103949
,0.1303423841628491564037517
,0.1267846740835046059903135
,0.1233321536700615617121457
,0.1199817005230556232753258
,0.1167302305567216313963996
,0.1135746966639416682953723
,0.1105120903543845151117964
,0.1075394468968628586269531
,0.1057516361764631040998097
,0.1029788472892871203923093
,0.1002923550916127587440130
,0.0976900239860777203082520
,0.0951697971309858753441446
,0.0927296957025953716424738
,0.0903678183350923314165470
,0.0880823407506842182002060
,0.0858715156091753306633052
,0.0837336725614213628343663
,0.0816672185809725614813459
,0.0796706385572273773076901
,0.0777424961984817253224378
,0.0758814352796382263210972
,0.0740861812767997646167473
,0.0723555434288555149313638
,0.0706884172971611046687457
,0.0690837878862042842342817
,0.0675407333910860857573155
,0.0660584296795288239412258
,0.0646361556194575970213378
,0.0632732994069433868356001
,0.0619693659548226985500641
,0.0607239856625304413872968
,0.0595369246784939118444235
,0.0584080970375001826133676
,0.0573375789059880555664783
,0.0563256252707172236360300
,0.0553726898038107082089532
,0.0544794480611425074867427
,0.0536468251090590902974142
,0.0528760287383120489157484
,0.0521685879353578768613531
,0.0515283996119127174484476
,0.0509538077820023485586809
,0.0504496015803405084554356
,0.0500191674916840023357167
,0.0496665639600752870097544
,0.0493966420639928502356319
,0.0492151922619864443109172
,0.0491291264104802144485618
,0.0491467011429547531720097
,0.0492777956303278794059075
,0.0495342595611821048806611
,0.0499303460950586142086394
,0.0503795889634419541414090
,0.0511082038976276298303247
,0.0520397015161545434258628
,0.0532050592348865813985270
,0.0546423002803200844046394
,0.0563982927340877585042911
,0.0586493187595135759271336
,0.0612339092178883492856301
,0.0643567545660850975908218
,0.0681287531339249130546420
,0.0726869819964579555460205
,0.0781898355717742937764925
,0.0848584234282574179086822
,0.0929208896516187932146380
,0.1026425798194427752019209
,0.1142981102761315009841425
,0.1281338855725034364674286
,0.1443085034574962677300647
,0.1628171898448381171853327
,0.1834270887619850742833449
,0.2055809016816990131282239
,0.2288043308588934010572302
,0.2521935630937267580620187
,0.2752209099601668484957884
,0.2975126660378653031813201
,0.3189136536738772509380624
,0.3394320646920834794180166
,0.3590858893556475583963561
,0.3780268194949104598734380
,0.3962799967559485492252236
,0.4139115720145795096485131
,0.4309638319221842372996889
,0.4474702827957404704939393
,0.4634586435895619582758798
,0.4789526420573536613645160
,0.4939730430174926190112217
,0.5085384545571570713562437
,0.5226662929314852545914505
,0.5363735560855962258841600
,0.5496762663367866785790739
,0.5625872820211761382580562
,0.5751151156066557357249280
,0.5872678112608018530238496
,0.5990610454733861223175495
,0.6108542796859703916112494
,0.6226475138985546609049493
,0.6344407481111389301986492
,0.6462339823237231994923491
,0.6580272165363074687860490
,0.6698204507488917380797488
,0.6816136849614760073734487
,0.6934069191740602766671486
,0.7052001533866445459608485
,0.7169933875992288152545484
,0.7287866218118130845482483
,0.7405798560243973538419482
,0.7523730902369816231356481
,0.7641663244495658924293480
,0.7759595586621501617230479
,0.7877527928747344310167477
,0.7995460270873187003104476
,0.8113392612999029696041475
,0.8231324955124872388978474
,0.8349257297250715081915473
,0.8467189639376557774852472
,0.8585121981502400467789471
,0.8703054323628243160726470
,0.8820986665754085853663469
,0.8938919007879928546600468
,0.9056851350005771239537466
,0.9174783692131613932474465
,0.9292716034257456625411464
,0.9410648376383299318348463
,0.9528580718509142011285462
,0.9646513060634984704222461
,3.4069484804524488019694672
,3.3102485740175109363292449
,3.2162923053857310762282395
,3.1250018317885084329077472
,3.0363015171015490523132030
,2.9501178713793345664839762
,2.8663794910481557032255751
,2.7850170000759288946312608
,2.7059629923831463038652601
,2.6291519756824226483615803
,2.5545203168556209760708953
,2.4820061894940619318106201
,2.4115495195042742082591758
,2.3430919397108960211539852
,2.2765767431239747331517265
,2.2119488224576646651087231
,2.1491546381892723260875755
,2.0881421752018436421849401
,2.0288608885157972672175219
,1.9712616691328961326945546
,1.9152968016198717027265275
,1.8609199245813479173250471
,1.8080859922530048145006276
,1.7567512371835931617169990
,1.7068731339753826503624623
,1.6584103640532958934272756
,1.6121537484823280639290033
,1.5664056085882249735874439
,1.5219557693174607937436349
,1.4787674069647540608940517
,1.4368047429414811944070607
,1.3960330141369983181220960
,1.3564184441181998952430376
,1.3179282151472659911917162
,1.2805304409937852128109625
,1.2441941405187133540266586
,1.2088892120083050141232661
,1.1745864082367589720234946
,1.1412573122369367162320941
,1.1088743137591010601283870
,1.0774105863981862096778741
,1.0468400653706788627772539
,1.0171374259227252689896659
,0.9882780623516007612039402
,0.9602380676232037393091900
,0.9329942135687184778802816
,0.9065239316440959482790163
,0.8808052942364505977224098
,0.8558169965019606362233162
,0.8315383387202849307939800
,0.8079492091509554718697927
,0.7850300673776493542987964
,0.7627619281266347917025428
,0.7411263455461261084877833
,0.7201053979336667909549874
,0.6996816728990715716918203
,0.6798382529508407712270923
,0.6605587014943634649455362
,0.6418270492305926389065007
,0.6236277809442717368071385
,0.6059458226711661454899627
,0.5887665292341025535804988
,0.5720756721379889331302593
,0.5558594278142794387065351
,0.5401043662056345118216427
,0.5247974396816886821781623
,0.5099259722769156066846108
,0.4954776492414507127470813
,0.4814405068953704902590118
,0.4678345089738539797075134
,0.4545859338563270624078427
,0.4417146458971888400846240
,0.4292099848977293796714605
,0.4170615945145073055755347
,0.4052594136900254939703814
,0.3937936683291763384495709
,0.3826548632146904993511782
,0.3718337741550404862422852
,0.3613214403584655842749385
,0.3511091570269930239867051
,0.3411884681645428463170333
,0.3315511595934139688068854
,0.3221892521736522407849179
,0.3130949952200138275415497
,0.3042608601114360489248156
,0.2956795340881220313100641
,0.2873439142315304950514587
,0.2781682617537792334694302
,0.2702985973329365410045000
,0.2626544892037789846739315
,0.2563234602469154910231453
,0.2491167725893757012300966
,0.2421172650468071396723246
,0.2353191494487700818893927
,0.2287168053448847826469859
,0.2223047754165010936322489
,0.2160777610136798143614101
,0.2100306178046204008680320
,0.2041583515209509092080964
,0.1984561137774919215015501
,0.1929191979390824096540769
,0.1875430349998013224155358
,0.1823231894315117396221382
,0.1772553549495127500623681
,0.1723353501338779347751284
,0.1675591138370061683460222
,0.1629227003026498810100975
,0.1584222739214544983799016
,0.1540541035554330862034078
,0.1498145563816699332715388
,0.1457000912365594424979776
,0.1417072514881142497600308
,0.1378326575261964725971353
,0.1340729990380615799239195
,0.1304250273262531900630989
,0.1268855480220406617419826
,0.1234514146421202690495633
,0.1201195235189905091699458
,0.1168868106946720636374337
,0.1137502513914965263097656
,0.1107068626518771664590801
,0.1088295123066340547302033
,0.1059885210340285877084199
,0.1032364454771979300762297
,0.1005711080722076072868632
,0.0979904134296130796544233
,0.0954923477089566624664840
,0.0930749781917986768187134
,0.0907364530662933266302872
,0.0884750014692946284977637
,0.0862889337366159747677585
,0.0841766419949629557395454
,0.0821366010375717686686770
,0.0801673695578074552159364
,0.0782675917791591235772586
,0.0764359995318064366909283
,0.0746714148214206452358610
,0.0729727529775617556051515
,0.0713390264552921232743543
,0.0697693493666454167545510
,0.0682629428722934389339727
,0.0668191415662353765947401
,0.0654374010406099659853396
,0.0641173066941015112885083
,0.0628585841816234613954606
,0.0616611116286273908126958
,0.0605249340769156082830982
,0.0594502804422487249325080
,0.0584375833848632536549061
,0.0574875029950348837015639
,0.0566009544646127182865314
,0.0557791410904106346735354
,0.0550235940135135950801448
,0.0543362183116272434713068
,0.0537193496029142528169764
,0.0531777751487669467223007
,0.0527110167118179859246929
,0.0523250975156943562427436
,0.0520249033741691721544065
,0.0518162627303758033248116
,0.0517061246735585275380309
,0.0517027799823161979264619
,0.0518161328800520251669504
,0.0520580392702139557736807
,0.0524427305582667174777001
,0.0529873413898721071224607
,0.0536085728716425291562331
,0.0545375670468348089370281
,0.0557027472312934743281509
,0.0571415004539863324861670
,0.0588997203806615327037477
,0.0610339339700200420035792
,0.0637321666882297993561579
,0.0668471634526990599045604
,0.0706008830719277863385841
,0.0751243030695684516073740
,0.0805694290606618485073298
,0.0871428264085657433568599
,0.0950613944212059941429871
,0.1045759466842905299754918
,0.1159478357222081812416548
,0.1294165650386928378967610
,0.1451476507704774210338883
,0.1631646245270524375747812
,0.1832868213991321049149974
,0.2050215062143637412273023
,0.2279549305928575686497339
,0.2512046758216814890118940
,0.2742263553213738491720619
,0.2965995523357139451725573
,0.3181182450184390497760489
,0.3387419617526547521713098
,0.3585039491184414672808600
,0.3775308231105674594552113
,0.3958478416843492775356594
,0.4135306156572211011557272
,0.4306249261323428778602818
,0.4471666692312992186231213
,0.4631851373157989670836798
,0.4787051549043442877362509
,0.4937483500545019055039120
,0.5083340149429355081522885
,0.5224798970612308801619861
,0.5362028453089265900288751
,0.5495187140220986199423692
,0.5624412077628052619715504
,0.5749809851315740294452894
,0.5871476061476479380019100
,0.5989546058048551557817518
,0.6104224617915334771822700
,0.6218903177782117985827881
,0.6333581737648901199833062
,0.6448260297515684413838244
,0.6562938857382467627843425
,0.6677617417249250841848607
,0.6792295977116034055853788
,0.6906974536982817269858970
,0.7021653096849600483864151
,0.7136331656716383697869333
,0.7251010216583166911874514
,0.7365688776449950125879695
,0.7480367336316733339884877
,0.7595045896183516553890058
,0.7709724456050299767895240
,0.7824403015917082981900421
,0.7939081575783866195905603
,0.8053760135650649409910784
,0.8168438695517432623915965
,0.8283117255384215837921147
,0.8397795815250999051926328
,0.8512474375117782265931510
,0.8627152934984565479936691
,0.8741831494851348693941873
,0.8856510054718131907947054
,0.8971188614584915121952235
,0.9085867174451698335957417
,0.9200545734318481549962598
,0.9315224294185264763967780
,0.9429902854052047977972961
,0.9544581413918831191978143
,0.9659259973785614405983324
,3.4989692517907662328013885
,3.3996592780802257216521411
,3.3031670157201666881974234
,3.2094125240564270740151187
,3.1183181260947532287275408
,3.0298083475353556615061734
,2.9438098561655197116238014
,2.8602514019598701544566666
,2.7790637582165365060404838
,2.7001796639900739194217749
,2.6235337679974857216791406
,2.5490625740925656472768424
,2.4767043886621351589383266
,2.4063992629610693185782111
,2.3380889698562081768784537
,2.2717169077858780923406812
,2.2072280942036699435959690
,2.1445691054550470866502110
,2.0836880380726574557570530
,2.0245344558029287895806192
,1.9670593554426545335189758
,1.9112151243844308634578510
,1.8569555011744427464037699
,1.8042355371881140246870245
,1.7530115593923856209812584
,1.7032411341642532676132760
,1.6548830321359007111681194
,1.6087274422542798824053989
,1.5630782052943206217321404
,1.5187245118230294771421995
,1.4756296177924668189263002
,1.4337578220537170459181198
,1.3930744367821925600026134
,1.3535457587396435563675823
,1.3151390413526078404515829
,1.2778224675835347934338415
,1.2415651235721409939571913
,1.2063369730251340961046935
,1.1721088323331303460150821
,1.1388523463941533364618408
,1.1065399651237031175554648
,1.0751449206319656504149407
,1.0446412050492681622415603
,1.0150035489814406286512849
,0.9862074005772675233671976
,0.9582289051907191268497854
,0.9310448856211538393168325
,0.9046328229151681110664640
,0.8789708377142440021145831
,0.8540376721327943565498231
,0.8298126721516722037463865
,0.8062757705126309959453579
,0.7834074700996634943450658
,0.7611888277935621172076708
,0.7396014387864473516032149
,0.7186274213434344915185648
,0.6982494019989791134150892
,0.6784505011758644732466905
,0.6592143192151607156148430
,0.6405249228058867982937841
,0.6223668318034820678974484
,0.6047250064265791147377627
,0.5875848348219414596371735
,0.5709321209877793457110329
,0.5547530730459929726450241
,0.5390342918541769501317162
,0.5237627599484052653977528
,0.5089258308079342985053017
,0.4945112184328384619114161
,0.4805069872252833995673882
,0.4669331740653956397402169
,0.4537159945264594984593032
,0.4408753831433016023844118
,0.4284007053445360035937028
,0.4162816298594698150026261
,0.4045081201713947027798213
,0.3930704262163748352598702
,0.3819590763208087769164933
,0.3711648693712465973959524
,0.3606788672101677861725477
,0.3504923872516383376307658
,0.3405969953109748149522318
,0.3309844986427578072962774
,0.3216469391817516343401451
,0.3125765869814901010137476
,0.3037659338455087620900485
,0.2952076871463939489181882
,0.2868947638280154865952909
,0.2777421292008621089841824
,0.2698944498522949930752191
,0.2622720039144270098852019
,0.2559616572152956237573562
,0.2487760422643468805059541
,0.2417973394515411933447524
,0.2350197792453136147461379
,0.2284377597639915824512258
,0.2220458422167048972983849
,0.2158387464707025860111145
,0.2098113467320625036283133
,0.2039586673228809265978612
,0.1982758785329844508638075
,0.1927582925178668582510966
,0.1874013592068919653588210
,0.1822006621769566014901187
,0.1771519144371951626215633
,0.1722509540607552458446605
,0.1674937395914737614521783
,0.1628763451483275226383540
,0.1583949551512199016567450
,0.1540458586008496832953085
,0.1498254428660940884565633
,0.1457301869672827376867019
,0.1417566543949203838881346
,0.1379014855714134624165013
,0.1341613901467630654007479
,0.1305331394141237000283695
,0.1270135592310370209467862
,0.1235995239278792900972093
,0.1202879517654088792344425
,0.1170758025559462262021881
,0.1139600780755030129398619
,0.1119948462947744777240544
,0.1090846681733527168134401
,0.1062661122591938983594773
,0.1035369598787504175074758
,0.1008950781980661459691362
,0.0983384197309483815141462
,0.0958650220694683558031457
,0.0934730078487699955758217
,0.0911605850226693270599299
,0.0889260473308931681524214
,0.0867677752052415374173222
,0.0846842369711607867444059
,0.0826739904660223901000649
,0.0807356851137933373419031
,0.0788680645156591558775361
,0.0770699696081523499824328
,0.0753403424962280215959609
,0.0736782310471124080031302
,0.0720827943339433646618986
,0.0705533090867172946181185
,0.0690891773092362215802353
,0.0676899352875899446013719
,0.0663552640559664508312920
,0.0650850018114389194945346
,0.0638791584134454221155508
,0.0627379325359015138641183
,0.0616617318092023691811221
,0.0606511964309844400777827
,0.0597072273510735468393662
,0.0588310192163659234632078
,0.0580240997229141616808867
,0.0572883770688364588052899
,0.0566261950731692179084042
,0.0560404009768886435249868
,0.0555344260462035041459039
,0.0551142855987502636172515
,0.0547810992323714343599228
,0.0545426099386040960648181
,0.0544057935689555918767901
,0.0543789611872807290837706
,0.0544720264992683764204706
,0.0546968350331942382291928
,0.0550675739540247358161373
,0.0556012852463372356237592
,0.0563185045053351471255887
,0.0572440667417052975740610
,0.0583018252985553139811081
,0.0597389895261843037466143
,0.0614961373559664153942705
,0.0636283218249833470991916
,0.0662032090566575803780580
,0.0693040401724540761074778
,0.0731536064373201205812691
,0.0776386061047644598920314
,0.0830227148713524043532885
,0.0894991018324055448429633
,0.0972738328568939630835999
,0.1065839542570033576796007
,0.1176779853994688040952354
,0.1307879694913826329472073
,0.1460839616346986946648911
,0.1636131722850299452520773
,0.1832410671906346544268729
,0.2045361377402050151452784
,0.2270980324675751227392340
,0.2502172973636081487747163
,0.2732006659045838059540756
,0.2956357050213517800862917
,0.3172661433752166915134296
,0.3380110045128713047724034
,0.3578808732832313710403582
,0.3769965911463558638772042
,0.3953838547851149520795389
,0.4131227389377892800226277
,0.4302628308876095264423611
,0.4468427779482228023866242
,0.4628937118316346910340542
,0.4784417101490958112997021
,0.4935093239915290808106363
,0.5081165505477495125674636
,0.5222815750932138234574609
,0.5360213501066588559496040
,0.5493517381653341136171775
,0.5622869822595454314395624
,0.5748391225708600060784192
,0.5870189202424339613983761
,0.5988389143710780571083774
,0.6103159061883728364605872
,0.6214680502055038857633917
,0.6326201942226349350661962
,0.6437723382397659843690008
,0.6549244822568970336718053
,0.6660766262740280829746098
,0.6772287702911591322774143
,0.6883809143082901815802188
,0.6995330583254212308830233
,0.7106852023425522801858278
,0.7218373463596833294886324
,0.7329894903768143787914369
,0.7441416343939454280942414
,0.7552937784110764773970459
,0.7664459224282075266998504
,0.7775980664453385760026549
,0.7887502104624696253054594
,0.7999023544796006746082639
,0.8110544984967317239110685
,0.8222066425138627732138730
,0.8333587865309938225166775
,0.8445109305481248718194820
,0.8556630745652559211222865
,0.8668152185823869704250910
,0.8779673625995180197278955
,0.8891195066166490690307000
,0.9002716506337801183335046
,0.9114237946509111676363091
,0.9225759386680422169391136
,0.9337280826851732662419181
,0.9448802267023043155447226
,0.9560323707194353648475271
,0.9671845147365664141503316
,3.5930821905646266323230975
,3.4911028319825385679564533
,3.3920169381360643079403872
,3.2957424256283669450340312
,3.2021995319078313535499092
,3.1113107540661042449414708
,3.0230007876886029194452021
,2.9371964660980505179566080
,2.8538267003660870990700005
,2.7728224204268316910315662
,2.6941165175459214076170156
,2.6176437883075656110065665
,2.5433408811740356725294987
,2.4711462389116372051489634
,2.4010000539841089839399046
,2.3328442240652709216419680
,2.2666222794788821737199669
,2.2022793599280436893650403
,2.1397621683066221365265847
,2.0790189126751754677968620
,2.0199992728098661309843465
,1.9626543564709717504257469
,1.9069366589021368163514580
,1.8528000234771335730243891
,1.8001996034620419973037997
,1.7490918248617375319042822
,1.6994343503203785950006477
,1.6511860440462622356960765
,1.6051364345062908434158544
,1.5595909511841823391620210
,1.5153381217736241470817049
,1.4723412857922786312059316
,1.4305648233351753173536736
,1.3899741255642112935930754
,1.3505355660362825531706221
,1.3122164728454110971256341
,1.2749851015558175681974262
,1.2388106089034793821923586
,1.2036630272444268641152121
,1.1695132397286247538659154
,1.1363329561788604316063811
,1.1040946896547136901745034
,1.0727717336821864790863401
,1.0423381401301530235770088
,1.0127686977153569358733876
,0.9840389111181374603987138
,0.9561249806916567450798539
,0.9290037827478323517738090
,0.9026528504037087952127649
,0.8770503549724368852480438
,0.8521750878835208098394105
,0.8280064431174127825840969
,0.8045244001399960431797354
,0.7817095073229075596898952
,0.7595428658360762197432337
,0.7380061139992692975653199
,0.7170814120798281177115996
,0.6967514275241881716027592
,0.6769993206111600825281016
,0.6578087305153490493836443
,0.6391637617694675421731176
,0.6210489711146918168083175
,0.6034493547285953995995555
,0.5863503358205713889006461
,0.5697377525850242374616528
,0.5535978465029488537751945
,0.5379172509828282766619623
,0.5226829803319941181172226
,0.5078824190497188695303521
,0.4935033114332455506101383
,0.4795337514876683027154058
,0.4659938530384637456194241
,0.4528097658154386362383548
,0.4400014981990122420185685
,0.4275584426764045820057447
,0.4154702944622842841759791
,0.4037270429762729873068849
,0.3923189635657084450848231
,0.3812366094669725757881906
,0.3704708039989181300732923
,0.3600126329821394799424183
,0.3498534373780540773779535
,0.3399848061419712963449058
,0.3303985692845474719803178
,0.3210867911362396687202647
,0.3120417638095890344729355
,0.3032560008543776497447197
,0.2947222311009156658911934
,0.2864333926869115920510467
,0.2773051724475318335905172
,0.2694808507210763037775791
,0.2618814342745061085615532
,0.2555931213455063244488485
,0.2484299415614718287148577
,0.2414734049532560322681718
,0.2347177620829006827740670
,0.2281574311238224184172907
,0.2217869933352229205869577
,0.2156011886642716091078142
,0.2095949114628709308849608
,0.2037632063017198735810354
,0.1981012638590640695390732
,0.1926044168548121104933557
,0.1872681359925834898572106
,0.1820880258628902736983690
,0.1770598207505485188750782
,0.1721793802794824301827248
,0.1674426848198146966506528
,0.1628458305776154246835574
,0.1583850242895839810497449
,0.1540565774563325829316085
,0.1498569000720269828175191
,0.1457824938477120246815844
,0.1418299449825364544341966
,0.1379959166114791135893114
,0.1342771411479776744180015
,0.1306704128402902953531850
,0.1271725809638157844716488
,0.1237805441676785994653542
,0.1204912465704304769253952
,0.1173016762437088245096817
,0.1152498186293172272032237
,0.1122695113082697038198177
,0.1093836237767995267500254
,0.1065898973335811100726644
,0.1038861630527147528191279
,0.1012703414499318138597417
,0.0987404423982714274377059
,0.0962945653007812180090852
,0.0939308996532208367868932
,0.0916477257390984761942221
,0.0894434159208697537879473
,0.0873164362139998845302458
,0.0852653483515800891812120
,0.0832888123748283665248593
,0.0813855898200916694218421
,0.0795545475600088203282922
,0.0777946624310398154866775
,0.0761050267469699781575088
,0.0744848548015567546443094
,0.0729334905503642438873158
,0.0714504166611366203776257
,0.0700352652037395523310082
,0.0686878300467321512012830
,0.0674080815660062088179316
,0.0661961838138140357123973
,0.0650525148363914340610137
,0.0639776905458259159686918
,0.0629725927168822002810700
,0.0620384024570033651424517
,0.0611766393511547212913371
,0.0603892082886031134059124
,0.0596784560050193299551857
,0.0590472368566516414567502
,0.0584989938427530192788240
,0.0580378550849899865760051
,0.0576687503066539638996169
,0.0573993983828101836386359
,0.0572331062602519716198124
,0.0571800273928819366431320
,0.0572500686071445233360500
,0.0574550468051307702821440
,0.0578090856197028893359580
,0.0583291089354134387190420
,0.0590354578558929324327842
,0.0599526573351353286867038
,0.0611103790407287669750325
,0.0624381051746548051961661
,0.0641907250743103119372535
,0.0663172242060379169004136
,0.0688831466433734440624193
,0.0719687481445896448661870
,0.0756721751525886027200940
,0.0801129763976299175132212
,0.0855521284286816924291585
,0.0919295649338292275576379
,0.0995603409445476178474266
,0.1086684576840851318424441
,0.1194900579019086278576012
,0.1322493188705448630138051
,0.1471188118023058211125687
,0.1641652994361335604622809
,0.1832120665609236476178978
,0.2041325900446383234676517
,0.2263372797322784069073975
,0.2492418512804194519194567
,0.2721516052387669137857529
,0.2946246189366173995338727
,0.3163568439080865490886652
,0.3372237536483944086995734
,0.3572249741063765471338343
,0.3764205222926531591021160
,0.3948850452237805952471206
,0.4126855588713435607495228
,0.4298756356268274569920607
,0.4464970360874813692930729
,0.4625830318084639403153346
,0.4781611460406672287071217
,0.4932549532717616092014623
,0.5078852079723746859585276
,0.5220706165232598117142970
,0.5358284004031080849372870
,0.5491745675011601157677887
,0.5621237523478087583228557
,0.5746888996125705251216687
,0.5868816881289516951270002
,0.5987143119344172648155222
,0.6102013510295770659652703
,0.6213586722197819156576770
,0.6321979849652368255163992
,0.6430372977106917353751214
,0.6538766104561466452338436
,0.6647159232016015550925658
,0.6755552359470564649512880
,0.6863945486925113748100102
,0.6972338614379662846687324
,0.7080731741834211945274546
,0.7189124869288761043861768
,0.7297517996743310142448991
,0.7405911124197859241036213
,0.7514304251652408339623435
,0.7622697379106957438210657
,0.7731090506561506536797879
,0.7839483634016055635385101
,0.7947876761470604733972323
,0.8056269888925153832559545
,0.8164663016379702931146767
,0.8273056143834252029733989
,0.8381449271288801128321211
,0.8489842398743350226908433
,0.8598235526197899325495655
,0.8706628653652448424082877
,0.8815021781106997522670099
,0.8923414908561546621257321
,0.9031808036016095719844543
,0.9140201163470644818431765
,0.9248594290925193917018987
,0.9356987418379743015606209
,0.9465380545834292114193431
,0.9573773673288841212780653
,0.9682166800743390311367875
,3.6893055011086204331149929
,3.5845969312556404950953493
,3.4828592710438894819446887
,3.3840082501561772332365763
,3.2879619762555676310000763
,3.1946408737890146234406075
,3.1039676225777670381944517
,3.0158670964642371181696490
,2.9302663024032109539973590
,2.8470943203927272513453772
,2.7662822445792136782927173
,2.6877631257791327890060984
,2.6114719155629133595653002
,2.5373454125525962687959236
,2.4653222067302382747300271
,2.3953426337730565620631751
,2.3273487250657565184042141
,2.2612841475582401429278434
,2.1970941720673304864419606
,2.1347256278025370512807513
,2.0741268457466524033350197
,2.0152476253629898472752302
,1.9580391907419896213582433
,1.9024541501964424838888590
,1.8484464570015046724904551
,1.7959713712476155222930174
,1.7449854227753029967118437
,1.6954463751616286604217976
,1.6473131907286477915164369
,1.6013747082736808913239202
,1.5559380173934942437341533
,1.5117909535757725336679869
,1.4688969439678687400885337
,1.4272204538600321566121920
,1.3867269572455922510556547
,1.3473829082177857241475749
,1.3091557131787001644340762
,1.2720137038372887339221506
,1.2359261109741079831536581
,1.2008630389510632774374699
,1.1667954409450265185199669
,1.1336950948848831810522597
,1.1015345800720288682583714
,1.0702872544650252617515207
,1.0399272326095818641533697
,1.0104293641956321181396561
,0.9817692132237579860642995
,0.9539230377637516467004275
,0.9268677702885743663330231
,0.9005809985674797513155454
,0.8750409471025232255314563
,0.8502264590931379872884577
,0.8261169789139111152564965
,0.8026925350911346956905845
,0.7799337237641125186726754
,0.7578216926176434276030136
,0.7363381252725026415717480
,0.7154652261211394970175093
,0.6951857055962191722642274
,0.6754827658600226492069396
,0.6563400869031098538997071
,0.6377418130410447139055918
,0.6196725397983685601488446
,0.6021173011694067600529934
,0.5850615572458607305250666
,0.5684911822015465965307612
,0.5523924526249712751990728
,0.5367520361907769377296518
,0.5215569806613320480437324
,0.5067947032098817361500664
,0.4924529800566708748199574
,0.4785199364091600182646857
,0.4650157670068260640228175
,0.4518665526029280732345228
,0.4390923792542593684373742
,0.4266826680180613728943229
,0.4146271420878274716059764
,0.4029158182967861878687188
,0.3915389988664342846291788
,0.3804872633934756054330251
,0.3697514610687501757091411
,0.3593227031219460299027446
,0.3491923554861181555608596
,0.3393520316762506650043463
,0.3297935858763255123626834
,0.3205091062295778447932548
,0.3114909083268481149175955
,0.3027315288881586852198780
,0.2942237196328663650923829
,0.2859604413339514872305358
,0.2768581187935526544130482
,0.2690586161092186068266585
,0.2614836865804374133048782
,0.2552188520419500505909127
,0.2480795631197192097072701
,0.2411466491099390485608467
,0.2344143822753691208671256
,0.2278772024919834549017139
,0.2215297127619989259184052
,0.2153666748563813904127073
,0.2093830050734467596029731
,0.2035737700958455964617144
,0.1979341829225708115913562
,0.1924595988454924910815436
,0.1871455114312882139770977
,0.1819875484596971404460675
,0.1769814677583747830613703
,0.1721231528643152319801857
,0.1674086084335474067241734
,0.1628339553169309283919830
,0.1583954252233371051694633
,0.1540893549056404632224826
,0.1499121798331138344373414
,0.1458604273588319510945865
,0.1419307094541178426716499
,0.1381197151635834563521144
,0.1344242030309968638501772
,0.1308409938521941651146108
,0.1273669642176250837994900
,0.1239990414023883491534406
,0.1207342002325064722612069
,0.1185966240587184999943915
,0.1155452923039491097689790
,0.1125912728174455479379645
,0.1097322681991191595241020
,0.1069660750576676006007304
,0.1042905838623825742761397
,0.1017037790753602677362721
,0.0992037395605499111583825
,0.0967886395071156646618959
,0.0944567493426762688768505
,0.0922064375068621239206479
,0.0900361724455222001139987
,0.0879445251917338882696740
,0.0859301725530710741596252
,0.0839919009887537815206571
,0.0821286112404768092742913
,0.0803393238796118874800456
,0.0786231858858202903306278
,0.0769794783763902007445168
,0.0754076257151446854853916
,0.0739072062265291596094841
,0.0724779648394526659904713
,0.0711198277279536383854719
,0.0698329196910841137890813
,0.0686175844330131484705149
,0.0674744085738672172425368
,0.0664042498787822260686298
,0.0654082703840118545590698
,0.0644879760563206033685546
,0.0636452632045469840482710
,0.0628824740771685153362114
,0.0622024640750496182750595
,0.0616086800541509674311591
,0.0611052568910573010163567
,0.0606971326406775188444520
,0.0603901877274873252754439
,0.0601914143278616253773805
,0.0601109067283691206329266
,0.0601549887989732481874405
,0.0603372060214990846294114
,0.0606715976715760871296190
,0.0611749478862203890927596
,0.0618673756314172818004948
,0.0627730700519779777346585
,0.0639212009995834551379090
,0.0653470552504492874223985
,0.0669867457821686357322122
,0.0691037589154738923769017
,0.0716567462845063146703595
,0.0747230304318548255171351
,0.0783967336760780370008561
,0.0827919673790269705637712
,0.0880423353043420231500704
,0.0943177340859099322400994
,0.1019231578709833552220942
,0.1108314202350343807834676
,0.1213856532921872427577270
,0.1338019005265646543811897
,0.1482535446882018714820362
,0.1648232455840532573176915
,0.1833703510325037089323530
,0.2038181449257633337523998
,0.2256371422926893299809592
,0.2482892615708378325489747
,0.2710881421401936663961862
,0.2935712650440215898406393
,0.3153943393266846473288467
,0.3363778330717879794242720
,0.3564990278851526417369655
,0.3757987807837468441363171
,0.3943481026289415991570309
,0.4122164055008611938113461
,0.4294612064365724846126682
,0.4461277032386303798006111
,0.4622516365111755121120041
,0.4778622062053140551185493
,0.4929841470379651147126765
,0.5076390502147165584290178
,0.5218462202689809759093009
,0.5356232636522838541637270
,0.5489864396764397858063944
,0.5619507186425641842575374
,0.5745296676240747579811341
,0.5867356592955978999981426
,0.5985808871629897387478536
,0.6100786785381970833697096
,0.6212432872906318293004801
,0.6320868117122320217760034
,0.6426151878898620495306204
,0.6531435640674920772852374
,0.6636719402451221050398544
,0.6742003164227521327944714
,0.6847286926003821605490884
,0.6952570687780121883037054
,0.7057854449556422160583224
,0.7163138211332722438129395
,0.7268421973109022715675565
,0.7373705734885322993221735
,0.7478989496661623270767905
,0.7584273258437923548314075
,0.7689557020214223825860245
,0.7794840781990524103406415
,0.7900124543766824380952585
,0.8005408305543124658498755
,0.8110692067319424936044925
,0.8215975829095725213591095
,0.8321259590872025491137265
,0.8426543352648325768683435
,0.8531827114424626046229605
,0.8637110876200926323775775
,0.8742394637977226601321945
,0.8847678399753526878868115
,0.8952962161529827156414285
,0.9058245923306127433960455
,0.9163529685082427711506625
,0.9268813446858727989052795
,0.9374097208635028266598965
,0.9479380970411328544145135
,0.9584664732187628821691305
,0.9689948493963929099237475
,3.7876553423780849882973598
,3.6801572868349521350239684
,3.5757092864844124413536974
,3.4742248407829943168678710
,3.3756198840760371915337146
,3.2798127245821566688732673
,3.1867239830016176327376343
,3.0962765308616408965747269
,3.0083954289444276852805160
,2.9230078662274840972656875
,2.8400430997459586990316893
,2.7594323957068942476666962
,2.6811089720820833193215549
,2.6050079428060026742741684
,2.5310662638824155123984383
,2.4592226752602552863891106
,2.3894176745737625289223161
,2.3215934217995153332481095
,2.2556937289885850006498913
,2.1916640105999811716230852
,2.1294512212409109075395008
,2.0690038231967990967063997
,2.0102717413438977445139244
,1.9532063216701300856215084
,1.8977602909708115586084887
,1.8438877176863728291067446
,1.7915439738504033151400563
,1.7406856981170570897177186
,1.6912707598375882334096332
,1.6432582241565496516955136
,1.5974362102025059240162363
,1.5521135412037685430419742
,1.5080773302925600809487605
,1.4652910964630760926041830
,1.4237193943030341802824523
,1.3833277846287628243260315
,1.3440828059540559369366974
,1.3059519467691473870729624
,1.2689036186068356482081754
,1.2329071298734661787932509
,1.1979326604230939867790084
,1.1639512368537918707289691
,1.1309347085056471460262628
,1.0988557241405949582713220
,1.0676877092847711914203046
,1.0374048442146663884244617
,1.0079820425688508223061035
,0.9793949305676027394795824
,0.9516198268232459733795281
,0.9246337227245343681758527
,0.8984142633788577692044441
,0.8729397290965629219172683
,0.8481890174020941808308294
,0.8241416255571430982129755
,0.8007776335813976409383486
,0.7780776877569397509404325
,0.7560229846027272104791450
,0.7345952553060283163333111
,0.7137767505980679993982108
,0.6935502260615369340968073
,0.6738989278580255204431637
,0.6548065788638203210680899
,0.6362573652028972182037592
,0.6182359231663516752064425
,0.6007273265078786339543626
,0.5837170741053366862516327
,0.5671910779788057466177520
,0.5511356516559282603395786
,0.5355374988756711474024996
,0.5203837026219141348448716
,0.5056617144784617545738570
,0.4913593442970723979001946
,0.4774647501698935370129107
,0.4639982118916559095112007
,0.4508857380152049842969575
,0.4381474962750772639274999
,0.4257729378953541976571273
,0.4137518156282370407339499
,0.4020741752854585238097229
,0.3907303475145867399653810
,0.3797109398136359614817081
,0.3690068287776145372625081
,0.3586091525708763882995811
,0.3485093036193556703672414
,0.3386989215169958766793457
,0.3291698861409115273168879
,0.3199143109700448017740371
,0.3109245366023192791438134
,0.3021931244655217119188251
,0.2937128507173735747493026
,0.2854767003304822803322338
,0.2764018513664341369917565
,0.2686287242243245998452039
,0.2610798356361047067863979
,0.2548400241690663148297347
,0.2477261820930463098733298
,0.2408184493677645032772006
,0.2341111217384140574804263
,0.2275986626162168346976244
,0.2212756986362336697471420
,0.2151370153467982437867079
,0.2091775530169703856131491
,0.2033924025438169080892692
,0.1977768014353009640160508
,0.1923261298369327298996012
,0.1870359065610965043635616
,0.1819017850673909919567706
,0.1769195493310628253258443
,0.1720851095259606500231797
,0.1673944974402899188437033
,0.1628438615404853573309651
,0.1584294616039787773065228
,0.1541476628591662845213506
,0.1499949296039478352504659
,0.1459678183255829764242151
,0.1420629704154964811912976
,0.1382771046620684118888533
,0.1346070098084080068900903
,0.1310495375735138134931645
,0.1276015966437721305126729
,0.1242601482346255142852343
,0.1220374665076744968850164
,0.1189142673860499599403084
,0.1158913718977108153751487
,0.1129664455434628705932099
,0.1101372523930577718154211
,0.1074016551537117919457032
,0.1047576155542427334133038
,0.1022031950175034953343101
,0.0997365560502375680940190
,0.0973559633250207639987295
,0.0950597860762027319081469
,0.0928465005591164321829822
,0.0907146932268646510877375
,0.0886630646061642713195994
,0.0866904339711397770029677
,0.0847957448847810602021724
,0.0829780718082075846586676
,0.0812366279098822030579896
,0.0795707742124803635297425
,0.0779800303523636578750811
,0.0764640872200294252625241
,0.0750228218687605807879493
,0.0736563147570853948842284
,0.0723648702312464087160748
,0.0711490404212311022824622
,0.0700096535482655213389336
,0.0689478472286827459569736
,0.0679651075798008014183793
,0.0670633161032209434981866
,0.0662448045830138498857309
,0.0655124209350692876530076
,0.0648696088940232395980701
,0.0643205009794998172623082
,0.0638700332411460958148552
,0.0635240822674970062600153
,0.0632896309283829811009880
,0.0631749702346250663342886
,0.0631899467507882617312021
,0.0633479777359564760752519
,0.0636595705993536903344321
,0.0641430578214518265500743
,0.0648183130561893611210067
,0.0657091612373175426586869
,0.0668442458999125854735013
,0.0682580969960650263406166
,0.0699924511616452360573959
,0.0719911279829340833291695
,0.0745270821751391199239123
,0.0775698601140467763892516
,0.0812096769904822601837679
,0.0855554233155985249803521
,0.0907346835807046614430504
,0.0969071357496091301264585
,0.1042488412973260614169391
,0.1129600852944307315395278
,0.1233664820533381251133065
,0.1354470841441676454142140
,0.1494894979412318691824879
,0.1654966172258253431781583
,0.1836361572782544693271944
,0.2035995570545730271039275
,0.2250073569065117184972991
,0.2473707526942339751663269
,0.2700202999149457494532101
,0.2924821018590757493171850
,0.3143735322562548062386156
,0.3354717037469785445580328
,0.3557160907270980887417977
,0.3751273794684917839425964
,0.3937694046327744890056977
,0.4117122946587869480872257
,0.4290171538343712787089146
,0.4457328457064089199946011
,0.4618979203291743718118312
,0.4775435236683971962357020
,0.4926957238881327638679863
,0.5073770547213882764481241
,0.5216074999991776595109627
,0.5354051421352173933954077
,0.5487865767197480648675878
,0.5617671035661663259119791
,0.5743607572082276568892212
,0.5865804443385143063238729
,0.5984385250619383977976895
,0.6099476924699783753069937
,0.6211211424560202365441341
,0.6319709572708166467336355
,0.6425054019562198570625355
,0.6527283198772121375341726
,0.6629512377982044180058097
,0.6731741557191966984774467
,0.6833970736401889789490838
,0.6936199915611812594207208
,0.7038429094821735398923579
,0.7140658274031658203639950
,0.7242887453241581008356320
,0.7345116632451503813072691
,0.7447345811661426617789061
,0.7549574990871349422505432
,0.7651804170081272227221802
,0.7754033349291195031938173
,0.7856262528501117836654544
,0.7958491707711040641370914
,0.8060720886920963446087285
,0.8162950066130886250803655
,0.8265179245340809055520026
,0.8367408424550731860236397
,0.8469637603760654664952767
,0.8571866782970577469669138
,0.8674095962180500274385508
,0.8776325141390423079101879
,0.8878554320600345883818250
,0.8980783499810268688534620
,0.9083012679020191493250991
,0.9185241858230114297967361
,0.9287471037440037102683732
,0.9389700216649959907400103
,0.9491929395859882712116473
,0.9594158575069805516832844
,0.9696387754279728321549214
,3.8881456728518091203739004
,3.7777974749630831574620515
,3.6705801848542645160478060
,3.5664050294545588393191338
,3.4651857271737487309337666
,3.3668384271166251764384469
,3.2712816479433519667452401
,3.1784362162208790181239237
,3.0882252044900226906065654
,3.0005738694648691478050750
,2.9154095908292179117893284
,2.8326618110472243650121982
,2.7522619765075742037652162
,2.6741434802082428845437789
,2.5982416070225760051926045
,2.5244934750058405370509718
,2.4528379906410693322982297
,2.3832157993067695223032842
,2.3155692172389215066630186
,2.2498422034223275467468284
,2.1859803153246137874532451
,2.1239306462365146188631115
,2.0636417935781143917495228
,2.0050638135725131760978002
,1.9481481798750006628750953
,1.8928477433739554491864965
,1.8391166931309606002997725
,1.7869105184285090093254666
,1.7361859718944454566980085
,1.6869010336729064469807327
,1.6390148766123289192364609
,1.5933148693903276260641633
,1.5481116444511535679140479
,1.5041915616338592531775475
,1.4615182361510192787790174
,1.4200563161422243840803503
,1.3797714533867926345322985
,1.3406302748480924957874549
,1.3026003550259059871052614
,1.2656501890939393373258781
,1.2297491668002249465274645
,1.1948675471088254784746141
,1.1609764335618411035255804
,1.1280477503413273154819763
,1.0960542190113153893094022
,1.0649693359206959808460624
,1.0347673502482666041402126
,1.0054232426717897297407944
,0.9769127046434260552842943
,0.9492121182544116519963495
,0.9222985366723409628164632
,0.8961496651349108999440318
,0.8707438424844263780144615
,0.8460600232278492338622300
,0.8220777601075941465325059
,0.7987771871687310287768469
,0.7761390033086619233415604
,0.7541444562957624331289708
,0.7327753272438943810129786
,0.7120139155300738709186703
,0.6918430241430107985323161
,0.6722459454505890219522257
,0.6532064473747912769496793
,0.6347087599629296361669617
,0.6167375623444663057526327
,0.5992779700630986861042970
,0.5823155227741948491981816
,0.5658361722980665975413217
,0.5498262710199671721156278
,0.5342725606280557260063802
,0.5191621611809003056237088
,0.5044825604962700493771877
,0.4902216038530536335038335
,0.4763674839979351594010382
,0.4629405700988920568939022
,0.4498667952003041481390255
,0.4371664128913101965423493
,0.4248289062508855407074293
,0.4128440592624254557030383
,0.4012019483752565229828235
,0.3898929343109505674114246
,0.3789076541079108850773594
,0.3682370133979347981423302
,0.3578721789086874993657261
,0.3478045711862454703044989
,0.3380258575321037906036281
,0.3285279451492747471164080
,0.3193029744923420731872454
,0.3103433128165813958965202
,0.3016415479214976103072843
,0.2931904820843817538467135
,0.2849831261797240444799684
,0.2759374255016032173593032
,0.2681923322105300155904217
,0.2606711422102158670632832
,0.2544580061110997548645685
,0.2473712748558897778217158
,0.2404903924620142297019498
,0.2338096801396390145288962
,0.2273236268816737626341506
,0.2210268850738226487084859
,0.2149142662389527114186194
,0.2089807369019449911906605
,0.2032214145562923068855099
,0.1976315637072373065930009
,0.1922065919580538129185499
,0.1869420460961442043146263
,0.1818336081243233370852153
,0.1768770911707753523689490
,0.1720684352001978778545777
,0.1674037024408081830717521
,0.1628790724401711076385624
,0.1584908366708535076838871
,0.1542353926285935095119584
,0.1501092374046068822490696
,0.1461089607724229966212448
,0.1422312379089805955967307
,0.1384728219677173743917820
,0.1348305368328936715283106
,0.1313012705008189118238704
,0.1278819696431781893775081
,0.1255745533871553964999634
,0.1223787016105582492464521
,0.1192862478961778938124638
,0.1162948225405398133824875
,0.1134021593279453676839097
,0.1106060958507030511643876
,0.1079045741850202383416146
,0.1052956418483760037130281
,0.1027774538146405403082895
,0.1003482736418868509487012
,0.0980064767003464148986680
,0.0957505531316423796894810
,0.0935791117110540970891464
,0.0914908845157678118908962
,0.0894847325158908135644964
,0.0875596521633031088516219
,0.0857147832243437962640442
,0.0839494180072423434868512
,0.0822630121429078348116448
,0.0806551972485695933823280
,0.0791257957929259181373283
,0.0776748386228532650132905
,0.0763025852141723803789830
,0.0750095477472909472060891
,0.0737965191934520509109419
,0.0726646066050934263946814
,0.0716152703105819715689861
,0.0706503699668577372916545
,0.0697722198417496664024640
,0.0689836535831329089596409
,0.0682881019980766390542470
,0.0676896872515608816200938
,0.0671933329040096394280113
,0.0668048997943209293959299
,0.0665313484440103602990391
,0.0663809356097373737259915
,0.0663634537507173521975190
,0.0664905244257876365532312
,0.0667759568345293458291323
,0.0672361854850918039261387
,0.0678924443572074126640459
,0.0687649037968744852866720
,0.0698832895869111042630450
,0.0712813552390510890566233
,0.0729997503419543003477798
,0.0750875256234012078415674
,0.0774973164766507155443165
,0.0805122906862799636584782
,0.0841139762745487518103005
,0.0884041677972244172023508
,0.0935107767110585907932574
,0.0995779109246326815663153
,0.1067743498387501294155655
,0.1152892877243803099185371
,0.1253248855901847869098731
,0.1370809037470118729729052
,0.1507287172341897074634431
,0.1663738230147432384242734
,0.1840130124603669981020460
,0.2034830546492967517924200
,0.2244572284190011479676485
,0.2464976554384407103626131
,0.2689589729028070141936269
,0.2913650296581384857574903
,0.3133015761050558789513332
,0.3344980072679842875160716
,0.3548731204128460214874963
,0.3744023019730843837571399
,0.3931450505383636273570858
,0.4111699102420153795200974
,0.4285407996128443031125244
,0.4453103064979402891943039
,0.4615201099016122965323916
,0.4772036034510550583931376
,0.4923883995625590870304222
,0.5070981082153603880513515
,0.5213534848397236576289515
,0.5351731695672242716810274
,0.5485741668440424767538843
,0.5615721260226418376504398
,0.5741814741711511738131435
,0.5864155486754717427899664
,0.5982869489319641020941276
,0.6098081130235936120342899
,0.6209916025939108408238098
,0.6318493432863386827236241
,0.6423909240259997321942365
,0.6526227291788796458504862
,0.6625502051800193914488091
,0.6724776811811591370471319
,0.6824051571822988826454548
,0.6923326331834386282437777
,0.7022601091845783738421005
,0.7121875851857181194404234
,0.7221150611868578650387462
,0.7320425371879976106370691
,0.7419700131891373562353920
,0.7518974891902771018337148
,0.7618249651914168474320377
,0.7717524411925565930303605
,0.7816799171936963386286834
,0.7916073931948360842270063
,0.8015348691959758298253291
,0.8114623451971155754236520
,0.8213898211982553210219749
,0.8313172971993950666202977
,0.8412447732005348122186206
,0.8511722492016745578169434
,0.8610997252028143034152663
,0.8710272012039540490135892
,0.8809546772050937946119120
,0.8908821532062335402102349
,0.9008096292073732858085577
,0.9107371052085130314068806
,0.9206645812096527770052035
,0.9305920572107925226035263
,0.9405195332119322682018492
,0.9504470092130720138001720
,0.9603744852142117593984949
,0.9703019612153515049968178
,3.9907880941980105049537997
,3.8775287858517875072550396
,3.7674829484561316306212575
,3.6605594951560642691390512
,3.5566698868979678138657619
,3.4557280717253213708772819
,3.3576504240271991541533225
,3.2623556831815787582229405
,3.1697648915914644618396778
,3.0798013324464896811605286
,2.9923904676907850941347533
,2.9074598766887391754210057
,2.8249391960056042805149445
,2.7447600606056803407284406
,2.6668560466514086293443597
,2.5911626164466787791695879
,2.5176170559301231932636256
,2.4461584591000731236931642
,2.3767276110634871777449462
,2.3092669926374522759715546
,2.2437207266634109359415561
,2.1800345109082890360241436
,2.1181555869443893236336862
,2.0580326936444417462723777
,1.9996160247218370820121436
,1.9428571874730298230105063
,1.8877091626885742492447662
,1.8341262657004406833038956
,1.7820641085341355491777904
,1.7314795631347559279333836
,1.6823307256369108841909110
,1.6345768816473051909810010
,1.5890046178559620315695611
,1.5439264535259953348145245
,1.5001279634988600175660167
,1.4575728637353266847753730
,1.4162259003348747210537795
,1.3760528203296753524398355
,1.3370203433079663746241295
,1.2990961338432933658282309
,1.2622487747067865360151018
,1.2264477408403040570306075
,1.1916633740688966636156465
,1.1578668585316558292674927
,1.1250301968106179995032790
,1.0931261867379724606053060
,1.0621283988623788641092460
,1.0320111545557710819309705
,1.0027495047425232232995995
,0.9743192092334067577752421
,0.9466967166472612937866415
,0.9198591449037875067418213
,0.8937842622713525475575125
,0.8684504689541867605839798
,0.8438367792037666514914918
,0.8199228039396589950982275
,0.7966887338655136430176640
,0.7741153230663290196744697
,0.7521838730735181943742873
,0.7308762173847200838139315
,0.7101747064256936914361518
,0.6900621929420364120133513
,0.6705220178088555638140633
,0.6515379962469203256603123
,0.6330944044342122767332626
,0.6151759665022010770130123
,0.5977678419065750592409358
,0.5808556131625812746221982
,0.5644252739355388737152452
,0.5484632174775101454144988
,0.5329562254015109967753006
,0.5178914567849696171109031
,0.5032564375943994194884112
,0.4890390504233385060572914
,0.4752275245354793953289629
,0.4618423229706440924502431
,0.4488092998810638833973030
,0.4361487990676571890880098
,0.4238503372500621591001391
,0.4119037314148626394150199
,0.4002990904096297986036745
,0.3890268067817505004413192
,0.3780775488555951913127728
,0.3674422530418030019561115
,0.3571121163727061786907768
,0.3470785892581442766413602
,0.3373333684561622969333428
,0.3278683902533257032985148
,0.3186758238496416595353367
,0.3097480649433234645151458
,0.3010777295108990614380673
,0.2926576477784297858342200
,0.2844808583798575374324002
,0.2754660863250333324714347
,0.2677507943089988406981661
,0.2602590718204823017067895
,0.2540743792256488498004785
,0.2470165391806835586407942
,0.2401642953761687904190580
,0.2335119967015809872012966
,0.2270541600254959713200975
,0.2207854658669159697570450
,0.2147007542043155026156853
,0.2087950204083242333741310
,0.2030634112786941225525794
,0.1975012211592247213243212
,0.1921038880954560879033011
,0.1868669899892362873394802
,0.1817862406921477991250669
,0.1768574859672487342709957
,0.1720766992373771175905972
,0.1674399770309687174307811
,0.1629435340363537543240113
,0.1585836976868202075063863
,0.1543569022255250333675036
,0.1502596822452499647493340
,0.1462886657653286737179599
,0.1424405669968782650602890
,0.1387121790547069521970514
,0.1351003669933799611335701
,0.1316020616656205510786037
,0.1292100892673349599171218
,0.1259408626720303070456453
,0.1227782359986595434042655
,0.1197198065549039958099797
,0.1167632804482969383075286
,0.1139064731974298999572781
,0.1111473107442790680954303
,0.1084838307055041167759057
,0.1059141852586344967335208
,0.1034366420636566863411332
,0.1010495886462835224417489
,0.0987515358703286438846192
,0.0965411225865067529339214
,0.0944171212101443946274060
,0.0923784443654756537434025
,0.0904241526759581720762426
,0.0885534640025643221550311
,0.0867657643012868101672908
,0.0850606202821998641505630
,0.0834377942637930525293655
,0.0818972616001651526618232
,0.0804392312252039387576730
,0.0790641693713169113610917
,0.0777728277931811484702251
,0.0765662766937131589184418
,0.0754459437727668380535562
,0.0744136602344245001727785
,0.0734717148778320228164063
,0.0726229191026250830987010
,0.0718706831061100698265776
,0.0712191074748177721520648
,0.0706730941718900496084643
,0.0702384763274168794078278
,0.0699221785324734002031732
,0.0697324085323699077720860
,0.0696788892226438832944169
,0.0697731412352298602241873
,0.0700288288044499246387531
,0.0704621818470044097848515
,0.0710925102010279558184536
,0.0719428392140331190995894
,0.0730406840448924593589553
,0.0744205323463104084780184
,0.0761188633600409086943372
,0.0781847658690859870223022
,0.0806754565597338907378955
,0.0835534670673608037549940
,0.0871110499100764545943321
,0.0913457030563299410275135
,0.0963735634350670750114531
,0.1023329036055356938694771
,0.1093831748584464386153670
,0.1177030889371214195104898
,0.1274842742036396969762535
,0.1389180840776700065486438
,0.1521731146253009481217333
,0.1673623020599211419501273
,0.1845041391430995436628848
,0.2034743523289555822142205
,0.2239955635959896551590020
,0.2456399103734841493640317
,0.2679157212954347278000000
,0.2902294416246592456687381
,0.3121826159867294725458464
,0.3334707556014192553206499
,0.3539677671193789953996145
,0.3736196652295205034022274
,0.3924709282362526807652614
,0.4105856027533041352484133
,0.4280291463464566126262412
,0.4448576719051354766421014
,0.4611162372708144108202077
,0.4766435746512253657236613
,0.4923249216591227828132560
,0.5068009987692978501883090
,0.5210831164260631975793103
,0.5349264066870399458863972
,0.5483483506529391870998325
,0.5613649816449836071896584
,0.5739910933844293294825434
,0.5862403953357424590819846
,0.5981257543696069101102353
,0.6096595776569848634807158
,0.6208540973996441447724237
,0.6317210802501306288192495
,0.6422708352892535499378823
,0.6525114191245485750769717
,0.6624496182262448185085191
,0.6720941798908621755970216
,0.6817387415554795326855242
,0.6913833032200968897740267
,0.7010278648847142468625293
,0.7106724265493316039510319
,0.7203169882139489610395344
,0.7299615498785663181280370
,0.7396061115431836752165395
,0.7492506732078010323050421
,0.7588952348724183893935447
,0.7685397965370357464820472
,0.7781843582016531035705498
,0.7878289198662704606590523
,0.7974734815308878177475549
,0.8071180431955051748360574
,0.8167626048601225319245600
,0.8264071665247398890130626
,0.8360517281893572461015651
,0.8456962898539746031900677
,0.8553408515185919602785702
,0.8649854131832093173670728
,0.8746299748478266744555754
,0.8842745365124440315440779
,0.8939190981770613886325805
,0.9035636598416787457210830
,0.9132082215062961028095856
,0.9228527831709134598980881
,0.9324973448355308169865907
,0.9421419065001481740750933
,0.9517864681647655311635958
,0.9614310298293828882520984
,0.9710755914940002453406009
,4.0955916946991273164258018
,3.9793600720049582264437049
,3.8664261947074760605858046
,3.7566966218622526163528619
,3.6500805166146470526200574
,3.5464895851482314270697316
,3.4458380162926842693593699
,3.3480424206750853954872582
,3.2530217690542801989295185
,3.1606973299890621653673861
,3.0709926072749480496781871
,2.9838332776855804873150646
,2.8991471295277237985033025
,2.8168640024183950743008609
,2.7369157285640803856097136
,2.6592360770619358767419271
,2.5837606918040529890845391
,2.5104270481755288635383749
,2.4391744044723244755346059
,2.3699437230431819045861630
,2.3026776501641865735336978
,2.2373204698504189913421669
,2.1738180359948864328600848
,2.1121177424212813633630503
,2.0521684759890592708586610
,1.9939205742556258549313952
,1.9373257843371602948678856
,1.8823372229348802608939195
,1.8289093374946139292092084
,1.7769978684682119496329733
,1.7265598126459726913140003
,1.6775533875300330244328961
,1.6307599899229547890655567
,1.5844994126450386850990526
,1.5395521209578826304920085
,1.4958808790619351203332599
,1.4534495083544862747970683
,1.4122228574575728110573891
,1.3721667730970565912684833
,1.3332480718087449389486210
,1.2954345124481190243415085
,1.2586947694809058617693154
,1.2229984070323898226462234
,1.1883158536739821808936313
,1.1546183779261725010911732
,1.1218780644576067384576845
,1.0900677909605811510829199
,1.0591612056838386468626823
,1.0291327056040771026346192
,0.9999574152181246455839414
,0.9716111659382524745609544
,0.9440704760736020606515240
,0.9173125313811925085616394
,0.8913151661704542538799956
,0.8660568449456983453060843
,0.8415166445713916365534146
,0.8176742369455488601559523
,0.7945098721669736629991121
,0.7720043621825281032755584
,0.7501390649009985756023866
,0.7288958687605529007669247
,0.7082571777371635679543260
,0.6882058967817936689925773
,0.6687254176745066613918311
,0.6497996052840789849014413
,0.6314127842220778052961805
,0.6135497258807841580718900
,0.5961956358447481063578266
,0.5793361416662011764699969
,0.5629572809949751066582735
,0.5470454900540273612818964
,0.5315875924520796491634655
,0.5165707883252615983948886
,0.5019826437999254098443203
,0.4878110807689404748721529
,0.4740443669736926768365493
,0.4607030640086197670335366
,0.4477129436853038990662412
,0.4350944445586709119488944
,0.4228371188797547253201969
,0.4109308185175802874411488
,0.3993656865884610551731271
,0.3881321493301760905403341
,0.3772209082146663061685388
,0.3666229322931272571750583
,0.3563294507676174616150888
,0.3463319457835450365656982
,0.3366221454376439603528581
,0.3271920169963080660124888
,0.3180337603194096085523768
,0.3091398014850052500257505
,0.3005027866106037559568165
,0.2921155758669620738920969
,0.2839712376806498572712201
,0.2749892876037939304367796
,0.2673056813544102960911175
,0.2598453149288464936184084
,0.2536909587847349101252803
,0.2466639159930892888361598
,0.2398422279781178001467623
,0.2332202737914078061187695
,0.2267926007587849346336384
,0.2205539202238979423764675
,0.2144991034338224189514932
,0.2086231775523384179837905
,0.2029213217808452929258323
,0.1973888635593010476565468
,0.1920212748099389132860892
,0.1868141681749156679526180
,0.1817632931860404532642406
,0.1768645322915419204612419
,0.1721138966535349645869957
,0.1675075216234431507711378
,0.1630416618049685684166406
,0.1587126856297016441743608
,0.1545170694034856961884827
,0.1504513908358424689737376
,0.1465123221419185883807046
,0.1426966229056778057149302
,0.1390011330100685560395846
,0.1354227660663427090792510
,0.1329462688856916097179806
,0.1296030140181232692686564
,0.1263696729189614786914575
,0.1232438124692693259820686
,0.1202231140926455776885007
,0.1173053747013063086157558
,0.1144885080948049860261051
,0.1117705464897679329405733
,0.1091496446654005303411594
,0.1066240802059276737701055
,0.1041922595472354606815912
,0.1018527219336261280258071
,0.0996041449666518197147980
,0.0974453512237965502329473
,0.0953753161090347828521274
,0.0933931770174995373734461
,0.0914982441842350363581104
,0.0896900134099797990971936
,0.0879681808731842262982781
,0.0863326604972241978819270
,0.0847836043191889099368552
,0.0833214265007035659316159
,0.0819468310314483278089526
,0.0806608447249027027403656
,0.0794648557138153133205805
,0.0783606591274062375118703
,0.0773505109442145927234336
,0.0764371913426710736239045
,0.0756240809078000675302889
,0.0749152499897109830362396
,0.0743155661954474910935176
,0.0738308246763362402420583
,0.0734679006128611117310001
,0.0732349374784229539825375
,0.0731415722127784079242829
,0.0731992075786649099011782
,0.0734213436083137327425874
,0.0738239825230793816901453
,0.0744261216987950197099266
,0.0752503523477511954142827
,0.0763235955033774171596406
,0.0776779928996132740248726
,0.0793519891916029257439291
,0.0813916325314627125964151
,0.0838521244612372290694324
,0.0867996220430931608724734
,0.0902075172637448879919830
,0.0943805369858510129210671
,0.0993260736463583149280510
,0.1051750393950255518804582
,0.1120780800060388604499906
,0.1202040005521423093881594
,0.1297343726481822445695258
,0.1408522238613280630481484
,0.1537226132962767333189902
,0.1684638330554423524265673
,0.1851107806744076711424896
,0.2035786728636762021871220
,0.2236306252385174830887848
,0.2448893338068461600354198
,0.2669020006572805359112976
,0.2890852776946047919537364
,0.3110133333377902986605079
,0.3323857158576246084713546
,0.3529986182423160423482500
,0.3727759199427257974512884
,0.3917428200674790694790772
,0.4099554117726647017860842
,0.4274788547084015233323839
,0.4443722365859722467362758
,0.4606841089179876114201306
,0.4763484526176919864326464
,0.4918618577817566728249687
,0.5064844052807551122441510
,0.5207952429636736324525259
,0.5346638356189464813539303
,0.5481082101153605945498271
,0.5611448273417464216450412
,0.5737888516172880981613957
,0.5860543388987475843521224
,0.5979544350284863307720684
,0.6095016453254396004979299
,0.6207080814760286280318269
,0.6315854088662983256696748
,0.6421443203367036556272751
,0.6523939363946116287706900
,0.6623421253051856583127233
,0.6719973748917871247954281
,0.6813711659130308184728619
,0.6907449569342745121502958
,0.7001187479555182058277296
,0.7094925389767618995051635
,0.7188663299980055931825973
,0.7282401210192492868600311
,0.7376139120404929805374650
,0.7469877030617366742148988
,0.7563614940829803678923327
,0.7657352851042240615697665
,0.7751090761254677552472003
,0.7844828671467114489246342
,0.7938566581679551426020680
,0.8032304491891988362795018
,0.8126042402104425299569357
,0.8219780312316862236343695
,0.8313518222529299173118034
,0.8407256132741736109892372
,0.8500994042954173046666710
,0.8594731953166609983441049
,0.8688469863379046920215387
,0.8782207773591483856989726
,0.8875945683803920793764064
,0.8969683594016357730538402
,0.9063421504228794667312741
,0.9157159414441231604087079
,0.9250897324653668540861418
,0.9344635234866105477635756
,0.9438373145078542414410094
,0.9532111055290979351184433
,0.9625848965503416287958771
,0.9719586875715853224733110
,4.2025628935620868986688947
,4.0832975972203096048929183
,3.9674160299409497731915053
,3.8548223570731452447546417
,3.7454234048032977177911107
,3.6391285979590231036695513
,3.5358498997040466171881690
,3.4355017512824614911437493
,3.3380010109384570249346780
,3.2432668918541875946459641
,3.1512208994057702149405031
,3.0617867682656929595452766
,2.9748903999317541924085617
,2.8904598011983004823832744
,2.8084250239611234789549599
,2.7287181066072472290784390
,2.6512730178190588858910814
,2.5760255976597083993340220
,2.5029135121417689369138770
,2.4318761962467321247061136
,2.3628547947368363502107513
,2.2957921285164655245125687
,2.2306326492927031068802535
,2.1673223744795064860113598
,2.1058088570936654981835545
,2.0460411387316188580598464
,1.9879697073589623901312962
,1.9315464562950785953887589
,1.8767246443599729932572018
,1.8234588571512964083609631
,1.7717049694201187914899265
,1.7214201085147859959789685
,1.6725626188605149380350667
,1.6259130566768782433229035
,1.5797932595330335114880427
,1.5349828485597938332318790
,1.4914447013764660088241953
,1.4491427496642705907703430
,1.4080419492857894070425573
,1.3681082512530728934052604
,1.3293085735203402641957382
,1.2916107735779429610545321
,1.2549836218248739960756666
,1.2193967756978043581739257
,1.1848207545352256175874572
,1.1512269151558927049450176
,1.1185874281313716860353225
,1.0868752547330520208390681
,1.0560641245345654404275137
,1.0261285136510793769559768
,0.9970436235974922123403985
,0.9687853607480441109345293
,0.9413303163803838913281652
,0.9146557472876142291795531
,0.8887395569423117702712034
,0.8635602771969947966113068
,0.8390970505059509587653110
,0.8153296126537874499717873
,0.7922382759765057569367741
,0.7698039130613019143112297
,0.7480079409117350586200246
,0.7268323055652941011572921
,0.7062594671507875787597186
,0.6862723853734041812302280
,0.6668545054156467255523921
,0.6479897442427700049449868
,0.6296624773017367449057247
,0.6118575256031203446482891
,0.5945601431758136268257431
,0.5777560048848336959892436
,0.5614311946029785227452180
,0.5455721937275463950811627
,0.5301658700337747998077020
,0.5151994668570799573714680
,0.5006605925964837666697349
,0.4865372105318181428224023
,0.4728176289472432736182839
,0.4595225128619784271677418
,0.4465775482470612511853858
,0.4340032731433532964260280
,0.4217892773371118564362803
,0.4099254495750411231291821
,0.3984019692319199501540083
,0.3872092982233353852805635
,0.3763381731572695287901809
,0.3657795977185246405483099
,0.3555248352802301003983132
,0.3455654017369250707858441
,0.3358930585539720570231736
,0.3264998060283267888870284
,0.3173778767559671254439024
,0.3085197293015746189404069
,0.2999180420663621893240247
,0.2915657073502534446518553
,0.2834558256049249935770717
,0.2745087119360465899298163
,0.2668588016893227443659953
,0.2594318086411097623589228
,0.2533098165077359298358317
,0.2463156128231798747130199
,0.2395265374671792235616863
,0.2329370024481455248022144
,0.2265415884659250922439355
,0.2203350407410190336943145
,0.2143122649912567179164569
,0.2084683235413170576677544
,0.2027984315442922791383751
,0.1972979532862115248370571
,0.1919623985339117266946118
,0.1867874188740314411738552
,0.1817688039769378427479296
,0.1769024777055861752383947
,0.1721844939781468353245941
,0.1676110322881941006034623
,0.1631783927917036802757167
,0.1588829908908565013980763
,0.1547213512852714523138076
,0.1506901015251919662141233
,0.1467859651894460326637670
,0.1430057549217073065150885
,0.1393463656856303023445776
,0.1367180397543366066059889
,0.1333674072422803835724636
,0.1300628893621391113377683
,0.1268692552164400189074200
,0.1237841649513518188507888
,0.1208054007989434325276434
,0.1179308689179703883986861
,0.1151586011426275618640958
,0.1124867610066602602314489
,0.1099136424660452915347264
,0.1074376784146172242317974
,0.1050574450224464606584718
,0.1027716683117511770051422
,0.1005792319637720672043102
,0.0984791865469270694122272
,0.0964707602490169763287398
,0.0945533715657760620576511
,0.0927266441614944397775488
,0.0909904241412491515683669
,0.0893448002913771327504477
,0.0877901278145227226268332
,0.0863270563092134735061478
,0.0849565620356000777979588
,0.0836799863797977189205923
,0.0824990807327981301444453
,0.0814160597647715783553579
,0.0804336642710559573954399
,0.0795552351364520460297314
,0.0787848023756804183292957
,0.0781271895593746157349102
,0.0775881394902867421725645
,0.0771744665173749733177999
,0.0768942348835787853333912
,0.0767569787459845831456562
,0.0767739652238213360346819
,0.0769585121663934473845714
,0.0773263741959177020035554
,0.0778962129989404367114147
,0.0786901678014901712066020
,0.0797345448837875475645021
,0.0810606590747151023457207
,0.0827058431983346414861913
,0.0847146588336204070524005
,0.0871403262097850961342971
,0.0900463873190206487429066
,0.0935085717655799592007426
,0.0975118659439730139926183
,0.1023714212462910472245525
,0.1081073265848509212805340
,0.1148619141169071461439088
,0.1227946271184646165330889
,0.1320774456488468806547587
,0.1428852007580737881742294
,0.1553788154416509692534731
,0.1696801612188117980295488
,0.1858393613957911860712358
,0.2037994859705209438338613
,0.2233690031224311034474539
,0.2442162511926362633563059
,0.2658978468367785286119442
,0.2879213114375023252478059
,0.3098248147859049561603229
,0.3312466989722263055462292
,0.3519654390438299307319880
,0.3718680824181008204298848
,0.3909565508372166986461593
,0.4092751200997755134380895
,0.4268862352488492217794658
,0.4438509704308815639883790
,0.4602212712561651319909117
,0.4760391046531315950574026
,0.4914172185201166054291377
,0.5061468842281229285617883
,0.5204886106493450403931433
,0.5343843528487334237908613
,0.5478527590118777990113585
,0.5609107688781260758759117
,0.5735739399966790497131797
,0.5858566727002862961626306
,0.5977724007237324999053385
,0.6093338020039564817409428
,0.6205530059092873029769066
,0.6314416508105811232098858
,0.6420106444385316191159063
,0.6522697701793476188214527
,0.6622277129227488456919559
,0.6718930672084197919247117
,0.6812759819219199597384318
,0.6903888175252558268013559
,0.6995016531285916938642799
,0.7086144887319275609272040
,0.7177273243352634279901281
,0.7268401599385992950530522
,0.7359529955419351621159763
,0.7450658311452710291789003
,0.7541786667486068962418244
,0.7632915023519427633047485
,0.7724043379552786303676726
,0.7815171735586144974305967
,0.7906300091619503644935207
,0.7997428447652862315564448
,0.8088556803686220986193689
,0.8179685159719579656822930
,0.8270813515752938327452171
,0.8361941871786296998081411
,0.8453070227819655668710652
,0.8544198583853014339339893
,0.8635326939886373009969134
,0.8726455295919731680598375
,0.8817583651953090351227615
,0.8908712007986449021856856
,0.8999840364019807692486097
,0.9090968720053166363115338
,0.9182097076086525033744579
,0.9273225432119883704373819
,0.9364353788153242375003060
,0.9455482144186601045632301
,0.9546610500219959716261542
,0.9637738856253318386890783
,0.9728867212286677057520023
,4.3117052873701657844662805
,4.1893448874048866414909753
,4.0704559048321273806436693
,3.9549400718952436584174848
,3.8427018396846612802164600
,3.7336483135422771084677152
,3.6276891922397482836970539
,3.5247367081955278678151444
,3.4247055671699824230813647
,3.3275128868203203147402292
,3.2330781341623628932779866
,3.1413230623814545339200777
,3.0521716476023836861486416
,2.9655500262296721203369998
,2.8813864333691259211889246
,2.7996111426959684465032296
,2.7201564079866313861089111
,2.6429564065743478273873279
,2.5679471794764396896937342
,2.4950666021138991901295867
,2.4242542847468775413233288
,2.3554515629079326721750931
,2.2886014494661388596341567
,2.2236485607461085045599702
,2.1605390888919195901962667
,2.0992207532766569144655477
,2.0396427571995601191190417
,1.9817557458084920085639169
,1.9255117652139772665975670
,1.8708642227621512521551495
,1.8177678484346133647164834
,1.7661786573437918690387960
,1.7160539132931347250377030
,1.6673520933701562185547118
,1.6208528798666692605223716
,1.5748802382858011483790506
,1.5302129120873468881569579
,1.4868138974534479412881183
,1.4446472413559066083621474
,1.4036780117713594240314023
,1.3638722687424715829251909
,1.3251970362612064402441092
,1.2876202749508802725131318
,1.2511108555243963813552455
,1.2156385329966798991563337
,1.1811739216299943500132485
,1.1476884705913799056276048
,1.1151544403020978712959277
,1.0835448794595055055367538
,1.0528336027123657014925584
,1.0229951689711325180098811
,0.9940048603352840128621892
,0.9658386616202985219814536
,0.9384732404673621353197177
,0.9118859280193931660107864
,0.8860547001474364803286221
,0.8609581592119595061518567
,0.8365755163440181663148110
,0.8128865742317139542194582
,0.7898717103977893616573169
,0.7675118609546315306957354
,0.7457885048233681146712115
,0.7246836484041364601083046
,0.7041798106850217786600865
,0.6842600087775325690131467
,0.6649077438668919981523686
,0.6461069875658154160191771
,0.6278421686608428586851005
,0.6100981602407212767147371
,0.5928602671967498904948002
,0.5761142140854832449647915
,0.5598461333446286269932557
,0.5440425538534939819967917
,0.5286903898298040971326373
,0.5137769300551613405048101
,0.4992898274217972276467492
,0.4852170887934873499958144
,0.4715470651735178542196536
,0.4583005300662874037520567
,0.4454030800674364520830295
,0.4328753576299451677478203
,0.4207069922013937368632241
,0.4088879115272641695533196
,0.3974083333603851686532948
,0.3862587574158816705605091
,0.3754299575654908016630884
,0.3649129742653735575252938
,0.3546991072118053645034763
,0.3447799082194009656632261
,0.3351471743168028538661929
,0.3257929410550471915897219
,0.3167094760241251361065906
,0.3078892725735670743425487
,0.2993250437332053426331413
,0.2910097163306181733410938
,0.2829364253020926200932195
,0.2740262923596477051546572
,0.2664122235876031363766003
,0.2590207600154597611386009
,0.2529333048033576281099499
,0.2459741290858964146703869
,0.2392198747832079697150931
,0.2326649900187066910550726
,0.2263040921747862810331497
,0.2201319638239956355540983
,0.2141435488145486121247529
,0.2083339484953000697586845
,0.2026984180585287009801476
,0.1972323629697639579827495
,0.1919313354423246853475149
,0.1867910309004892077666682
,0.1818072843602366317483643
,0.1769760666421796302394398
,0.1722934803205974363393693
,0.1677557553094657649683796
,0.1633592439959421771522585
,0.1591004158591199924011050
,0.1549758515616710685680602
,0.1509822365771600338746339
,0.1471163545166977171252398
,0.1433750804415547253078955
,0.1406622949991606086328488
,0.1371689708438205979046387
,0.1338602017021516543682225
,0.1305985414820918510958592
,0.1274489357899982466815203
,0.1244091565958882344977710
,0.1214771074657941402064054
,0.1186508253951721603147718
,0.1159284897011449433357200
,0.1133084177860739366616727
,0.1107890774013190748892299
,0.1083690911400550238585794
,0.1060472441819741568069801
,0.1038224934525207726609963
,0.1016939784197277568678075
,0.0996610336088347981142732
,0.0977232033861433757593318
,0.0958802592512379980860260
,0.0941322199112476359905699
,0.0924793747953369382752697
,0.0909223116282358856388157
,0.0894619489361128811255597
,0.0880995735151124392814381
,0.0868368851360878518663711
,0.0856760487071803605862996
,0.0846197562135261732718661
,0.0836712998183817419084463
,0.0828346579251097864249331
,0.0821145988316733660417057
,0.0815168022904675382278583
,0.0810480058266945802003534
,0.0807161819836824806495557
,0.0805307458683847954272750
,0.0805028108470696446286041
,0.0806454939179561264284146
,0.0809742838482803428679091
,0.0815074871999067473993250
,0.0822667695253603975524825
,0.0832778084784262379036690
,0.0845710779161975706452736
,0.0861827955796928280030045
,0.0881560458956276854491918
,0.0905421035914371064023953
,0.0934019595099685739914008
,0.0968080348694517894836409
,0.1008460037625659999616090
,0.1055128093564265956416648
,0.1111328598021134317352931
,0.1177376130713834317953470
,0.1254776658883508255737382
,0.1345158595196010165029321
,0.1450189963467269083086109
,0.1571434002448511280114474
,0.1710130149293695722700903
,0.1866903545802586494861686
,0.2041438992471314717302988
,0.2232201599964500626782637
,0.2436326374419945095528561
,0.2649795160034371099833095
,0.2867937949824482801730596
,0.3086150871854492772072831
,0.3300592418712243181211363
,0.3508693928441331544298976
,0.3708939869507773545720397
,0.3901081776767951203588325
,0.4085403463680825630888194
,0.4262472624015832822763628
,0.4432904921202227566112697
,0.4597249742328019528336824
,0.4755959519738420793188993
,0.4909759485389094124663245
,0.5057868533535464505845880
,0.5201618525190805364388780
,0.5340867606428363334458709
,0.5475809338630315270535220
,0.5606618503594165137116079
,0.5733454963981922114513168
,0.5856466311745676112110459
,0.5975789889627013407036316
,0.6091554659087452527899131
,0.6203882989908156009306595
,0.6312891694702265077410175
,0.6418691291226339412645530
,0.6521383767206507808822380
,0.6621061874257841983748563
,0.6717814125768194477572592
,0.6811735390936979328557754
,0.6902934328764753768581386
,0.6991524641468465084415129
,0.7080114954172176400248873
,0.7168705266875887716082616
,0.7257295579579599031916359
,0.7345885892283310347750103
,0.7434476204987021663583846
,0.7523066517690732979417589
,0.7611656830394444295251333
,0.7700247143098155611085076
,0.7788837455801866926918819
,0.7877427768505578242752563
,0.7966018081209289558586306
,0.8054608393913000874420050
,0.8143198706616712190253793
,0.8231789019320423506087536
,0.8320379332024134821921280
,0.8408969644727846137755023
,0.8497559957431557453588766
,0.8586150270135268769422510
,0.8674740582838980085256253
,0.8763330895542691401089996
,0.8851921208246402716923740
,0.8940511520950114032757483
,0.9029101833653825348591226
,0.9117692146357536664424970
,0.9206282459061247980258713
,0.9294872771764959296092456
,0.9383463084468670611926200
,0.9472053397172381927759943
,0.9560643709876093243593687
,0.9649234022579804559427430
,0.9737824335283515875261173
,4.4230195000544192396318977
,4.2975025844545031716847916
,4.1755464725930169223033772
,4.0570504237166877814502186
,3.9419164763601624024147441
,3.8300493795544947595033136
,3.7213565304625619845069195
,3.6157479146587454543748663
,3.5131360466241066120574033
,3.4134359092021653303561379
,3.3165648916617271879658801
,3.2224427266150832416258254
,3.1309914263648761512115470
,3.0421352193564397126124277
,2.9558004873634136089322055
,2.8719157039003757603268241
,2.7904113741932619063845777
,2.7112199778514716186350597
,2.6342759072890258309485034
,2.5595154234441377383291183
,2.4868765968318062853370520
,2.4162992434265895269618341
,2.3477248949538145339488437
,2.2810967524490091129507618
,2.2163596157718297163796706
,2.1534598558053317240990054
,2.0923453656621098240009360
,2.0329655175242220543907479
,1.9752711207044915120434325
,1.9192143808958161965705358
,1.8647488605759332536138118
,1.8118294405356829557263154
,1.7604122824995307450279824
,1.7104547928047408866802925
,1.6619155871229873699945756
,1.6155734398879979529795037
,1.5697545294119672476540472
,1.5252366873496931987119751
,1.4819830337527910568695688
,1.4399577360491946365073090
,1.3991259793583494808189016
,1.3594539376497265514842638
,1.3209087457207495663880081
,1.2834584719709591915659530
,1.2470720919498625711696604
,1.2117194626565981341315137
,1.1773712975701287053453825
,1.1439991423893169919523416
,1.1115753514628194942304162
,1.0800730648892882257428028
,1.0494661862689704800999380
,1.0197293610883007008993673
,0.9908379557196295150944820
,0.9627680370187478020582716
,0.9354963525033603843894525
,0.9090003110961534238398940
,0.8832579644165767795982447
,0.8582479886059291018796102
,0.8339496666707756356018422
,0.8103428713301819019676486
,0.7874080483526665341642570
,0.7651262003692032021007208
,0.7434788711490093460199091
,0.7224481303252717756535617
,0.7020165585583347800380238
,0.6821672331243063824857131
,0.6628837139173890946608481
,0.6441500298546742886429683
,0.6259506656725273288088829
,0.6082705491041127121576437
,0.5910950384280627689648213
,0.5744099103787569937651369
,0.5582013484091840060941081
,0.5424559312978652902970111
,0.5271606220918534368991004
,0.5123027573783014432251548
,0.4978700368775105244978363
,0.4838505133506591504577443
,0.4702325828154660936064602
,0.4570371325145512475529586
,0.4441896661182450634086649
,0.4317109356165693134776973
,0.4195906123771823703627604
,0.4078186654025185431393652
,0.3963853530850254269779498
,0.3852812152085082209040934
,0.3744970651895940805253815
,0.3640239825536042417297722
,0.3538533056393947107132192
,0.3439766245280120315896966
,0.3343857741903037417152689
,0.3250728278489325440148150
,0.3160300905505653012994571
,0.3072500929443553463471517
,0.2987255852631960917342724
,0.2904495315046062842156971
,0.2824151038084913856174296
,0.2735442354680329701821506
,0.2659682992895259778798334
,0.2586146710979173035660494
,0.2525640828532736414935300
,0.2456422833421439133605446
,0.2389252231500107459538640
,0.2324073900981638574059218
,0.2260834420191354665607975
,0.2199482028097855257353643
,0.2139966586474240095583355
,0.2082239543538599857441795
,0.2026253898847646672809475
,0.1971964169116638410095277
,0.1919326354511052268314586
,0.1868297904805430453833992
,0.1818837684644809549183719
,0.1770905936997648200126321
,0.1724464243791782869230644
,0.1679475482723548074304176
,0.1635903779379835609741889
,0.1593714454169029015595527
,0.1552873964163512809921741
,0.1513349840839623150490212
,0.1475110625848793932668457
,0.1447136393481177618625111
,0.1411447938228755916156842
,0.1376965155746871782849183
,0.1344340605509777020198925
,0.1312199182634886662768281
,0.1281192426402437689603175
,0.1251299402854521569672386
,0.1222500594171917476238320
,0.1194778032026167502444025
,0.1168115201675317543772437
,0.1142497222309119681016298
,0.1117910889230536441996122
,0.1094344764565499394937120
,0.1071789284201885988911940
,0.1050236883566181833593589
,0.1029682142971953401344720
,0.1010121959243115430382431
,0.0991555746237207519255819
,0.0973985667388116704845658
,0.0957416908019092655068860
,0.0941857994677897658597487
,0.0927321171603407434780308
,0.0913822834488350332904361
,0.0901384048406941723596830
,0.0890031152138995862443949
,0.0879796475879853767665395
,0.0870719188518444264790475
,0.0862846295284507569522958
,0.0856233839559678577835200
,0.0850948311826912884292540
,0.0847068345193707633589142
,0.0844686767358738405109264
,0.0843913002115781046841292
,0.0844876022149484845469303
,0.0847727868923757038599476
,0.0852647883198738854026999
,0.0859847810749259644502729
,0.0869577963871861064903968
,0.0882134604914571462952466
,0.0897868729590803188456150
,0.0917196546891886899111057
,0.0940611686801757079789965
,0.0968699253431714868423086
,0.1002151478658956235134880
,0.1041784424426326627344253
,0.1088554245279752391573069
,0.1142548256706270443094908
,0.1207082039148336671807726
,0.1282559091166368403502673
,0.1370520827451886525238933
,0.1472556965613242563328811
,0.1590181283314316962318458
,0.1724641248264224269171052
,0.1876661017667986264267910
,0.2046143182380736613712457
,0.2231893524303737441627504
,0.2431471628120668304617880
,0.2641279170467151771184433
,0.2856945072958403386564896
,0.3073951573024532035738332
,0.3288305981294933344472042
,0.3497132247558890072447468
,0.3698525445975870962200815
,0.3891942171616204482198498
,0.4077466808090305927514407
,0.4255576189067681314170954
,0.4426870558967176405573696
,0.4591921361256608435930104
,0.4751213407668259947058687
,0.4905141128843623632427295
,0.5054025717497239167386169
,0.5198134745314110238822991
,0.5337697566787581449077038
,0.5472915845849066762696111
,0.5603970446666778348898674
,0.5731025978089075989529988
,0.5854233888058438806112349
,0.5973734711692941790062150
,0.6089659914230974857574097
,0.6202133535875316017182968
,0.6311273400254711063439572
,0.6417191286161191277059856
,0.6519991924009195249922755
,0.6619772255450427911327438
,0.6716623695932869564373391
,0.6810638523844813052576797
,0.6901916275440106440797194
,0.6990561487103716942215215
,0.7076667525277253734117267
,0.7162773563450790526019318
,0.7248879601624327317921370
,0.7334985639797864109823422
,0.7421091677971400901725474
,0.7507197716144937693627526
,0.7593303754318474485529578
,0.7679409792492011277431629
,0.7765515830665548069333681
,0.7851621868839084861235733
,0.7937727907012621653137785
,0.8023833945186158445039837
,0.8109939983359695236941889
,0.8196046021533232028843940
,0.8282152059706768820745992
,0.8368258097880305612648044
,0.8454364136053842404550096
,0.8540470174227379196452148
,0.8626576212400915988354200
,0.8712682250574452780256252
,0.8798788288747989572158303
,0.8884894326921526364060355
,0.8971000365095063155962407
,0.9057106403268599947864459
,0.9143212441442136739766511
,0.9229318479615673531668563
,0.9315424517789210323570614
,0.9401530555962747115472666
,0.9487636594136283907374718
,0.9573742632309820699276770
,0.9659848670483357491178822
,0.9745954708656894283080874
,4.5365030378705908375991385
,4.4077683045550815066349060
,4.2826854511694607552385605
,4.1611512226123954505396796
,4.0430652075184640992233653
,3.9283297628644886501092515
,3.8168499485235805046556834
,3.7085334668158602688947667
,3.6032906035827805268922930
,3.5010341687024957302298844
,3.4016794351175492217009833
,3.3051440762898889325072105
,3.2113481025241372712741850
,3.1202137968480250229674766
,3.0316656511760848857761630
,2.9456303033846662486894274
,2.8620364757624292550985956
,2.7808149151245666885756691
,2.7018983349764429391370868
,2.6252213528683649990114191
,2.5507204662960512031588678
,2.4783339397494237310581866
,2.4080018040666244516501138
,2.3396658073166207714166376
,2.2732693339289844480788361
,2.2087573800636652876505650
,2.1460765031586173101629811
,2.0851747776668614342554520
,2.0260017520453059702845167
,1.9685084069610216950252379
,1.9126471146818704305303527
,1.8583715996190068864279965
,1.8056368999892693505415764
,1.7543993305661866877187549
,1.7046164464865316556796415
,1.6562470080939388772378607
,1.6100688475155067180821788
,1.5644104423214810761777471
,1.5200486776883137540750113
,1.4769468030054442309051410
,1.4350691114805009807042779
,1.3943809105589977104244781
,1.3548484931844995138305876
,1.3164391098754579800811371
,1.2791209415956104056277809
,1.2428630733955030596149527
,1.2076354688033026363314093
,1.1734089449437388186225917
,1.1401551483645704365699203
,1.1078465315506007549117840
,1.0764563301058163169443560
,1.0459585405847879879814855
,1.0163278989550186270918175
,0.9875398596724511701694382
,0.9595705753528518400230496
,0.9323968770223031166111127
,0.9059962549305131673804681
,0.8803468399111251674327150
,0.8554273852736896666115740
,0.8312172492123847122869051
,0.8076963777170363956159349
,0.7848452879724027164698441
,0.7626450522321217562193851
,0.7410772821541151689217486
,0.7201241135846566665534851
,0.6997681917787080818627032
,0.6799926570445122830932405
,0.6607811308008320061446739
,0.6421177020356226838870839
,0.6239869141553219256124407
,0.6063737522143983760258834
,0.5892636305152166853460471
,0.5726423805688130030944194
,0.5564962394076574669909974
,0.5408118382420599168369790
,0.5255761914524257338854341
,0.5107766859100988376951591
,0.4964010706200068789861746
,0.4824374466786415793784215
,0.4688742575410416169034988
,0.4557325096357044968975458
,0.4429376101665244425120704
,0.4305104259886648465638359
,0.4184406727930803371329205
,0.4067183632471904619620773
,0.3953337988004592684632144
,0.3842775617369411644830279
,0.3735405074689891469219560
,0.3631137570666046476830502
,0.3529886900172048980195427
,0.3431569372108847493230144
,0.3336103741465700767143687
,0.3243411143547931252406613
,0.3153415030331797042073561
,0.3066041108911141677140222
,0.2981217282004581248244790
,0.2898873590496239271985246
,0.2818942157987422425513557
,0.2730650461337795764649172
,0.2655296907650492865826664
,0.2582163658190223531896379
,0.2522051446885629766292425
,0.2453232427133519022444119
,0.2386459289500687253049449
,0.2321677349982162186226020
,0.2258833634472747764476708
,0.2197876840761212591246476
,0.2138757302264938930935756
,0.2081426953351768194266924
,0.2025839296012313939243654
,0.1971949367533853414435896
,0.1919713708685573949619396
,0.1869090331761316670089457
,0.1820038687656246323420817
,0.1772519631007567209035614
,0.1726495382348473828226787
,0.1681929486263748774188542
,0.1638786764755571223606267
,0.1597033265484274489054428
,0.1556636205287288965415371
,0.1517563910412103034275333
,0.1488741444624817611419587
,0.1452294556417273174719895
,0.1417091448907896455988720
,0.1383106903818131783179268
,0.1350995827949811045609607
,0.1319382446977430956014388
,0.1288920758765827456748809
,0.1259591423161696976951163
,0.1231376803591879981469859
,0.1204260778702267165041206
,0.1178229012143345577623421
,0.1153268984526915896804411
,0.1129370099141684680166264
,0.1106523806254291336648166
,0.1084723749038068035810412
,0.1063965931741661374854147
,0.1044248918217220295501235
,0.1025574063658708373614203
,0.1007945783096603487027920
,0.0991371865736328933271793
,0.0975863843608424930131662
,0.0961437426158829600009170
,0.0948113000776313746831292
,0.0935916230817217115189877
,0.0924878753312445706091793
,0.0915039007558609285286622
,0.0906443213363688771178062
,0.0899146522810091858302073
,0.0893214407509797664319606
,0.0888724283856325014685495
,0.0885767467527746460431715
,0.0884451535399906341172738
,0.0884903086534571253762849
,0.0887271127778960222443061
,0.0891731098206105937675758
,0.0898489685821555195133215
,0.0907790609928737085576600
,0.0919921548893604668073465
,0.0935222364185405719005928
,0.0954094763243810983777138
,0.0977013633252794833072841
,0.1004539939339203630241926
,0.1037335085024837511014084
,0.1076176115954027845411645
,0.1121970644929746185880504
,0.1175769126430905447966424
,0.1237768106964135805814209
,0.1311322483582366971166522
,0.1396886887768402085718833
,0.1495974942800719076352323
,0.1610048479315999980787666
,0.1740352396966715065040887
,0.1887688154673705098751668
,0.2052143141197464992764310
,0.2232825357460295478961854
,0.2427688388454961598839077
,0.2633548560017657802490021
,0.2846365661525895318639812
,0.3061771512573700504411534
,0.3275696762345015056183684
,0.3485013949342079531135141
,0.3687439918098124325140930
,0.3882119007031100688109859
,0.4068898655289786003841357
,0.4248127782466604718258907
,0.4420365593996269382159880
,0.4586193142938309041944933
,0.4746124592067283431973124
,0.4900585187979981660610918
,0.5049921157616400479994923
,0.5194418384770002061756600
,0.5334319215554048643213036
,0.5469834642661743906444372
,0.5601152440709206148383714
,0.5728442525326493672821471
,0.5851860567406786950428454
,0.5971550548203511388223319
,0.6087646712424771289207115
,0.6200275188922024227622387
,0.6309555274670549662729968
,0.6415600088049603355599970
,0.6518516382349412996433102
,0.6618404117491909488535384
,0.6715357416677296686913223
,0.6809468206626171360440480
,0.6900831000799014791624586
,0.6989543631624037800520455
,0.7075698932468467150513902
,0.7159369653800978783309006
,0.7243040375133490416104109
,0.7326711096466002048899213
,0.7410381817798513681694317
,0.7494052539131025314489420
,0.7577723260463536947284524
,0.7661393981796048580079628
,0.7745064703128560212874731
,0.7828735424461071845669835
,0.7912406145793583478464939
,0.7996076867126095111260042
,0.8079747588458606744055146
,0.8163418309791118376850250
,0.8247089031123630009645353
,0.8330759752456141642440457
,0.8414430473788653275235561
,0.8498101195121164908030664
,0.8581771916453676540825768
,0.8665442637786188173620872
,0.8749113359118699806415975
,0.8832784080451211439211079
,0.8916454801783723072006183
,0.9000125523116234704801286
,0.9083796244448746337596390
,0.9167466965781257970391493
,0.9251137687113769603186597
,0.9334808408446281235981701
,0.9418479129778792868776804
,0.9502149851111304501571908
,0.9585820572443816134367012
,0.9669491293776327767162115
,0.9753162015108839399957219
,4.6521501509541325347640850
,4.5201365023580102331379749
,4.3918674907725376854727983
,4.2672373026984589117205360
,4.1461430388361497634264197
,4.0284846290284441749918187
,3.9141647616027595013576956
,3.8030888209265634181122095
,3.6951648285047906661304751
,3.5903033845142795499327804
,3.4884176080749687010040816
,3.3894230756696104300829120
,3.2932377578925642325202716
,3.1997819551469701693235947
,3.1089782330749868854979923
,3.0207513584762444303066786
,2.9350282363258446416409697
,2.8517378483142934442184924
,2.7708111943650410857742372
,2.6921812284057340391996149
,2.6157828155132225589341033
,2.5415526698832735519317794
,2.4694292873509913199825405
,2.3993529186597224445165466
,2.3312655224409306597976865
,2.2651106886386678240796755
,2.2008336135989958748382378
,2.1383810493510209127521193
,2.0777012595036596920294869
,2.0187439763897154776373100
,1.9614603594235293648750940
,1.9058029546392023512169089
,1.8517256553769032567657860
,1.7991836640855125573068563
,1.7481334552066172260964549
,1.6985327391263591589876114
,1.6503404271240198486481177
,1.6043333741003948933467882
,1.5588424447829591912295655
,1.5146435427188751354776741
,1.4717000522639067661145873
,1.4299763978855739576800943
,1.3894380146919358409718370
,1.3500513197978933899179310
,1.3117836845053141292538612
,1.2746034072739456100009647
,1.2384796874607684191715862
,1.2033825998060467821204611
,1.1692830696449916239032518
,1.1361528488245120627198048
,1.1039644923051668001789949
,1.0726913354289577817723966
,1.0423074718341935884780014
,1.0127877319991707150137472
,0.9841076623969677861225591
,0.9562435052441399241374143
,0.9291721788266186221605381
,0.9028712583865904361957178
,0.8773189575546301854913622
,0.8524941103117823493207084
,0.8283761534667881676341494
,0.8049451096340500821924024
,0.7821815706983802352070256
,0.7600666817529957430821241
,0.7385821254976179250917312
,0.7177101070839621010932774
,0.6974333393962698357526619
,0.6777350287549527285690942
,0.6585988610317917713032898
,0.6400089881655458556863891
,0.6219500150672298000031901
,0.6044069869047647980409010
,0.5873653767571697104088457
,0.5708110736289826459000096
,0.5547303708161391844200239
,0.5391099546151462140741728
,0.5239368933679755535592903
,0.5091986268356948341917700
,0.4948829558943651507618711
,0.4809780325471165740580659
,0.4674723502465047975107382
,0.4543870402506923200647293
,0.4416474097931313846920887
,0.4292744461298544367267027
,0.4172579118362478856063547
,0.4055878658172194506370545
,0.3942546551683447919600667
,0.3832489072851634759331318
,0.3725615222150317484839377
,0.3621836652462548378217377
,0.3521067597295208795316057
,0.3423224801270056683044629
,0.3328227452848518952421841
,0.3235997119251017850594110
,0.3146457683535566207666534
,0.3059535283804638017279842
,0.2975158254513912137184661
,0.2893257069861298047541709
,0.2813764289239820692856142
,0.2725915539545292198830850
,0.2650993973385178392732087
,0.2578290189055481573809914
,0.2518598494320599678886197
,0.2450205546476937334965385
,0.2383857351567247040424746
,0.2319499710012185578200672
,0.2257080144691303857928943
,0.2196547864699927576914718
,0.2137853730985679601150906
,0.2080950223709522872717059
,0.2025791411082863424653056
,0.1972332919306519216640083
,0.1920531903080838209696424
,0.1870347015978179872064402
,0.1821738379791584816480565
,0.1774667551831974332543496
,0.1729097489092183137504577
,0.1684992508291824064858844
,0.1642318241124464672786587
,0.1601041584611594126297263
,0.1561130647360057799311051
,0.1531458266249619282195482
,0.1494250694965449099971266
,0.1458326386535724605852948
,0.1423660007761214929544735
,0.1390227737299966070949608
,0.1358687225051659341890087
,0.1327662032511959244729383
,0.1297809004448972902689974
,0.1269110944948124153341951
,0.1241552212369367302891021
,0.1215119127852310326742824
,0.1189799984654966585884139
,0.1165585170796235442436384
,0.1142467312936377016319156
,0.1120441445033597133162928
,0.1099505202197576109179877
,0.1079659049539100357240073
,0.1060906549071971849418361
,0.1043254668686611208450188
,0.1026714143799633827125461
,0.1011299901528402711559096
,0.0997031560675356309797479
,0.0983934007316263486986330
,0.0972038082829395910788861
,0.0961381386413964200698956
,0.0952009227916672945424281
,0.0943975752543242119241285
,0.0937345264585730114648143
,0.0932193820937081557564952
,0.0928611095929466473508640
,0.0926702621295416029134628
,0.0926592487402804615426177
,0.0928426494668256607756263
,0.0932376004117298345930109
,0.0938642496384957530919380
,0.0947462997732095579817013
,0.0959116547963340670968080
,0.0973931876350597608427151
,0.0992296400977518838759650
,0.1014666628381253876689527
,0.1041580073771382203284830
,0.1073668390058165750255981
,0.1111671286642142431055902
,0.1156450114490100294917241
,0.1208999264396950906741424
,0.1270451949645448608272602
,0.1341096802328154979910835
,0.1424283605531750096506727
,0.1520466936501873311815558
,0.1631055023180207064203984
,0.1757281429004792505654819
,0.1900006097596291521067968
,0.2059471504743424496997051
,0.2235051283400843469273411
,0.2425060390951106759072076
,0.2626716955776425832524978
,0.2836332038688823553584939
,0.3049740836457230375167171
,0.3262869242248900847336301
,0.3472401507325628688960251
,0.3675701116336687612751177
,0.3871594451356676347408836
,0.4059660165195647096858522
,0.4240081308587555497524590
,0.4413345810770190058569540
,0.4580018324724307032802528
,0.4740661552360462827060417
,0.4895705849224424865973049
,0.5045533502177241835795485
,0.5190451411484874322255223
,0.5330717037277333814060398
,0.5466552175257120005369416
,0.5598152503892075415592444
,0.5725693920075425324967000
,0.5849336777316980207075403
,0.5969228825228863888341380
,0.6085507366219051750277913
,0.6198300947190676923881369
,0.6307730708075223180486546
,0.6413911294902023829678228
,0.6516951185941681767843647
,0.6616952636611960203438798
,0.6714012125274506637140348
,0.6808222354102447804180542
,0.6899675519353151154078319
,0.6988465064743837329430676
,0.7074682075834601846509031
,0.7158405856910552422789351
,0.7239695389092929422858447
,0.7320984921275306422927542
,0.7402274453457683422996638
,0.7483563985640060423065734
,0.7564853517822437423134829
,0.7646143050004814423203925
,0.7727432582187191423273021
,0.7808722114369568423342116
,0.7890011646551945423411212
,0.7971301178734322423480307
,0.8052590710916699423549403
,0.8133880243099076423618499
,0.8215169775281453423687594
,0.8296459307463830423756690
,0.8377748839646207423825786
,0.8459038371828584423894881
,0.8540327904010961423963977
,0.8621617436193338424033072
,0.8702906968375715424102168
,0.8784196500558092424171264
,0.8865486032740469424240359
,0.8946775564922846424309455
,0.9028065097105223424378551
,0.9109354629287600424447646
,0.9190644161469977424516742
,0.9271933693652354424585837
,0.9353223225834731424654933
,0.9434512758017108424724029
,0.9515802290199485424793124
,0.9597091822381862424862220
,0.9678381354564239424931316
,0.9759670886746616425000411
,4.7699517030851517063183564
,4.6345983425567096603003847
,4.5030840481531662078396039
,4.3753003997301833649657965
,4.2511419702655919294898013
,4.1305062274101977948248532
,4.0132934548334793234403151
,3.8994066859544895820022248
,3.7887516440767958769697543
,3.6812366846168149692175575
,3.5767727367449606568072795
,3.4752732431510988675427143
,3.3766540976931871398392104
,3.2808335813648286105603802
,3.1877322973588642085474021
,3.0972731060835965166688766
,3.0093810608936899519960662
,2.9239833451129229047182889
,2.8410092107184223841898074
,2.7603899191630656417828504
,2.6820586764787592848335862
,2.6059506126186753327544920
,2.5320026575891065867551788
,2.4601535479880838330757342
,2.3903437777740208503018948
,2.3225155093009339779541733
,2.2566125525164744125561356
,2.1925803124381415543098228
,2.1303657439385412786236884
,2.0699173078084029953060963
,2.0111849280626237224112174
,1.9541199504559114696888855
,1.8986751021750436496660086
,1.8448044526752394034474491
,1.7924633756288039787563093
,1.7416085119517785706477753
,1.6921977338919278466278229
,1.6441901101146714214706890
,1.5983614829711012550461646
,1.5530451935504714366942380
,1.5090161282098422113051583
,1.4662378120578680729124699
,1.4246748064568059977119674
,1.3842926796651369159008027
,1.3450579783146345835831426
,1.3069381996982871729784392
,1.2699017648461354834665826
,1.2339179923667653593355453
,1.1989570730328100722772433
,1.1649900450894368209020513
,1.1319887702654261030232874
,1.0999259104669916187191347
,1.0687749051350963203077526
,1.0385099492475637905641861
,1.0091059719478081557753057
,0.9805386157825650705888165
,0.9527842165314842626244740
,0.9258197836119629320350555
,0.8996229810430832474210661
,0.8741721089529813637497568
,0.8494460856144445681792376
,0.8254244299939875739724471
,0.8020872448000855303718026
,0.7794152000166827409799453
,0.7573895169085095302463628
,0.7359919524851495920003686
,0.7152047844111970587022142
,0.6950107963502502039787601
,0.6753932637308632802586317
,0.6563359399229771184991478
,0.6378230428137559027135239
,0.6198392417721583225187487
,0.6023696449920393769517091
,0.5853997872040478389621398
,0.5689156177471341724327658
,0.5529034889910642291965814
,0.5373501451019744301618175
,0.5222427111436470648087038
,0.5075686825078274955203028
,0.4933159146674621076122946
,0.4794726132471786028688143
,0.4660273244055832542187545
,0.4530013100714833651494473
,0.4403197740744134169865731
,0.4280038298191648493684625
,0.4160432894999988584494588
,0.4044282610130275346094209
,0.3931491398789579427841545
,0.3821966014155613322600402
,0.3715615931545379613254454
,0.3612353274977810335677475
,0.3512092746083780858690204
,0.3414751555320620357569794
,0.3320249355451930783900139
,0.3228508177257807254534328
,0.3139452367444864333556609
,0.3053008528730432047382237
,0.2969105462080447455086585
,0.2887674111086204198350913
,0.2808647508470974440974999
,0.2721269415531780144767993
,0.2646807853280532807360714
,0.2574561869841097139222086
,0.2515319539056681819033656
,0.2447381812659480959659675
,0.2381488175841109944386176
,0.2317584966961153403186557
,0.2255620262784608920370033
,0.2195543844368765540320254
,0.2137307165005350451103538
,0.2080863320061653309878125
,0.2026167018458811253101004
,0.1973174555384371031685475
,0.1921843785662614156883876
,0.1872134097014224729527143
,0.1824006382254305391743543
,0.1777423009349819171820428
,0.1732347788245122144346055
,0.1688745933531386744785863
,0.1646584022460868268478151
,0.1605829948542144003376109
,0.1575306354834886402027649
,0.1537336873088592237301953
,0.1500691565964507867558808
,0.1465345037332868305401945
,0.1431273495590266731092299
,0.1398454795477684087234849
,0.1367549793774612831853688
,0.1337181344872489519026715
,0.1308010001752394346752340
,0.1280020690976317598863687
,0.1253200514975844059861743
,0.1227538718951835389203708
,0.1203026832551197800036391
,0.1179658835753740614427088
,0.1157431353070903223834165
,0.1136343876198981500680318
,0.1116399026905341290705209
,0.1097602863375409382173942
,0.1079965234560382458806060
,0.1063500194838254558904467
,0.1048226490393404375378594
,0.1034168132380815646742533
,0.1021355056421302531788342
,0.1009823911143189895112116
,0.0999618977552816090348387
,0.0990793260041838569351924
,0.0983409773576845308573624
,0.0977543057593080882972103
,0.0973280996632712724903058
,0.0970726947545779705883717
,0.0970002290025537700079994
,0.0971249493766991184307003
,0.0974635686324306221850478
,0.0980356992531612320140866
,0.0988643644835181523156109
,0.0999766021014906192121430
,0.1014041774839052612033896
,0.1031844194300100547856402
,0.1053611840374958225075019
,0.1079859437936864230422884
,0.1111189968566779484593354
,0.1148307367814100365954744
,0.1192028982216608995470253
,0.1243296024597220217344784
,0.1303179302123706195803976
,0.1371913130631947086435218
,0.1452738962317307036542502
,0.1546057157272979210027586
,0.1653221381725960559272437
,0.1775446688772256975674679
,0.1913635306673372449282056
,0.2068158259998920389666210
,0.2238620509710226302857450
,0.2423664866041514154293424
,0.2620892488170752931964103
,0.2826975620844380809870700
,0.3037996092443255857773465
,0.3249941639275697458089098
,0.3459375315474428336237622
,0.3663344111404069902704350
,0.3860363222751352352268839
,0.4049718799890990594825269
,0.4231391568646091783101326
,0.4405764553532424687709579
,0.4573393168510589412711909
,0.4734789052350064642027405
,0.4890474207254456584514912
,0.5040838948650000483908684
,0.5186213891534140474348646
,0.5326874012824097670559809
,0.5463053669023963943018884
,0.5594957641268747394747152
,0.5722768619472894391364548
,0.5846652197764961034209819
,0.5966760288105933396352043
,0.6083233558254559358857705
,0.6196203269983561190414889
,0.6305792717412123105091837
,0.6412118300116650404518737
,0.6515290165610426731390703
,0.6615412476207210845657869
,0.6712583740630028161788800
,0.6806897932625222136238108
,0.6898446604806679482990717
,0.6987320702038833930558326
,0.7073609512569691837313712
,0.7157395351612549916353601
,0.7238746886118757606354279
,0.7317718475024502788883751
,0.7396690063930247971413223
,0.7475661652835993153942695
,0.7554633241741738336472167
,0.7633604830647483519001639
,0.7712576419553228701531111
,0.7791548008458973884060583
,0.7870519597364719066590055
,0.7949491186270464249119527
,0.8028462775176209431648999
,0.8107434364081954614178471
,0.8186405952987699796707943
,0.8265377541893444979237415
,0.8344349130799190161766887
,0.8423320719704935344296359
,0.8502292308610680526825831
,0.8581263897516425709355303
,0.8660235486422170891884775
,0.8739207075327916074414247
,0.8818178664233661256943719
,0.8897150253139406439473191
,0.8976121842045151622002663
,0.9055093430950896804532135
,0.9134065019856641987061607
,0.9213036608762387169591079
,0.9292008197668132352120551
,0.9370979786573877534650023
,0.9449951375479622717179495
,0.9528922964385367899708967
,0.9607894553291113082238439
,0.9686866142196858264767911
,0.9765837731102603447297383
,4.8900630846539749896351168
,4.7511415804409971030963789
,4.6163232690903317489983237
,4.4853290363009934438309756
,4.3580508844608321084024283
,4.2343837831061224008522004
,4.1142255787974013614416435
,3.9974769225577100328905544
,3.8840412075361716581767269
,3.7738245112272714720802469
,3.6667355383769706378416231
,3.5626855623693605146229402
,3.4615883642382359042244389
,3.3633601694069152898691755
,3.2679195828284353098069914
,3.1751875234345670051538946
,3.0850871587946278040703874
,2.9975438407295378340222669
,2.9124850424075381383204331
,2.8298402986419572968657121
,2.7495411392253448212841249
,2.6715210476301054498549092
,2.5957153942127750845259015
,2.5220613682988979320498402
,2.4504979523690328946372574
,2.3809658753082740823003860
,2.3134075290395692547917861
,2.2477669471285488533851549
,2.1839897519660134150853992
,2.1220231097312334256344002
,2.0618156866281385219963340
,2.0033176063603099770205063
,1.9464804088114389113428615
,1.8912570098982512956098390
,1.8376016625636333312598936
,1.7854699188735838610853079
,1.7348185932074218218446049
,1.6856057264609267676291893
,1.6377905513007213755827252
,1.5921478618817879180369346
,1.5470135660082477979671012
,1.5031614969500963763238133
,1.4605553265107575899861558
,1.4191597587341875374988831
,1.3789405006662007746598420
,1.3398642339470754336616665
,1.3018985872119239743938124
,1.2650121092760064911431073
,1.2291742430828027643485711
,1.1943553003933038425543600
,1.1605264371955958946358578
,1.1276596298144088148518449
,1.0957276517009004734859445
,1.0647040508834897387657747
,1.0345631280611418123527301
,1.0052799153210090210563976
,0.9768301554628910920996532
,0.9491902819134525604027885
,0.9223373992136834065291850
,0.8962492640635126850412462
,0.8709042669080111487289741
,0.8462814140500494186625247
,0.8223603102747490956048182
,0.7991211419714765451516314
,0.7765446607395906086779291
,0.7546121674645486221422175
,0.7333054968514003402191292
,0.7126070024030841665307889
,0.6924995418313518724673372
,0.6729664628885209110009669
,0.6539915896086498925399155
,0.6355592089471437944325771
,0.6176540578082038157603506
,0.6002613104500024165943728
,0.5833665662579760047279365
,0.5669558378771855089439669
,0.5510155396953325679376690
,0.5355324766686910820112644
,0.5204938334839269709064524
,0.5058871640494573274082768
,0.4917003813106164411550481
,0.4779217473833943796712731
,0.4645398640018362224068937
,0.4515761298042443860900619
,0.4389556418923821756727932
,0.4266996457845934620500827
,0.4147980062194036587897017
,0.4032408830382931963498550
,0.3920187231770200231295576
,0.3811222529087313071194387
,0.3705424703338485170611705
,0.3602706381120704404175115
,0.3502982764322215003538474
,0.3406171562160674737285149
,0.3312192925526550313364282
,0.3220969383601969826536049
,0.3132425782730298702283278
,0.3046489227517328868266588
,0.2963089024150981076743960
,0.2882156625932925653188477
,0.2803625581022420321097854
,0.2716747748847825882911877
,0.2642776198765522388534066
,0.2571018420806312487769674
,0.2512256478320640251666873
,0.2444805365497142446429280
,0.2379398242547128838886294
,0.2315982047377593278092434
,0.2254505476382137330038091
,0.2194918952908795906076023
,0.2137174598004501491210760
,0.2081226203279246955712978
,0.2027029205613342932590371
,0.1974540663272094653812871
,0.1923719232800869261001964
,0.1874525145868292108630726
,0.1826920185044116073935783
,0.1780867657397619818748780
,0.1736332364843012621147267
,0.1693280570431027753919295
,0.1651679960356333687343522
,0.1620304421126539107245179
,0.1581572875633324437583127
,0.1544207902577250934861297
,0.1508184100135465111058863
,0.1473477771364012922639120
,0.1440066974044797165621645
,0.1407931580998382503633337
,0.1377736053045969244479352
,0.1348103186345070148011160
,0.1319697137215864735093618
,0.1292505924448054399622521
,0.1266519896941968592596339
,0.1241731896719781430560303
,0.1218137449460005711232569
,0.1195734987294143486513676
,0.1174526103622310496676917
,0.1154515854045061185040311
,0.1135713106758875906576733
,0.1118130947522538443106299
,0.1101787153414522379968332
,0.1086704748525612884701985
,0.1072912658537321650698004
,0.1060446463425088192700230
,0.1049349297482812803927743
,0.1039672898002012568774433
,0.1031478848716195495516246
,0.1024840045597419230238856
,0.1019842418914310988586891
,0.1016587001115861199629364
,0.1015192337553626616974967
,0.1015797369785354786753118
,0.1018564890294171298990022
,0.1023685544834628396992926
,0.1031382672100991659824842
,0.1041917963047869488679709
,0.1055598083938198983311452
,0.1072782404317373233793020
,0.1093891909553897368034825
,0.1119419253928378432672019
,0.1149939771917765224396035
,0.1186123157807648237360709
,0.1228744841532369708181349
,0.1278695679816813646212381
,0.1336987446344496677230751
,0.1404750437086617342874462
,0.1482282153985113870575674
,0.1572771049508946139550147
,0.1676569145664867921396990
,0.1794867194513227182106618
,0.1928595856794726726146649
,0.2078231180661904986539668
,0.2243577695448293607416446
,0.2423572626049443068385614
,0.2616176999190787944016279
,0.2818425058785722359111503
,0.3026677739578046422153079
,0.3237043808260585686653599
,0.3446033047051330622245757
,0.3650422413146786060345050
,0.3848435095028961416829816
,0.4039051110891173634875884
,0.4222016439660684627988019
,0.4397573921817894970764939
,0.4566227022356854070572751
,0.4728465658280744388086703
,0.4884857851024890229574282
,0.5035810865887874188118190
,0.5181683688795464259868595
,0.5322771398770175244052894
,0.5459322966682130795490480
,0.5591553720700773721929977
,0.5719654124742793444013955
,0.5843795685828639951964192
,0.5964134951837162246235380
,0.6080816309660099783229725
,0.6193974035639102648787002
,0.6303733862173542812357141
,0.6410214178342014124112325
,0.6513526876862528736111813
,0.6613777867518115805012258
,0.6711067464867428444819097
,0.6805491093585670503429697
,0.6897140633384638563896374
,0.6986105928015863275604147
,0.7072474948394524840722397
,0.7156331175119624576907995
,0.7237749033180165270096040
,0.7316791631132161244366330
,0.7393516129646214851689479
,0.7470240628160268459012627
,0.7546965126674322066335776
,0.7623689625188375673658925
,0.7700414123702429280982074
,0.7777138622216482888305222
,0.7853863120730536495628371
,0.7930587619244590102951520
,0.8007312117758643710274669
,0.8084036616272697317597817
,0.8160761114786750924920966
,0.8237485613300804532244115
,0.8314210111814858139567264
,0.8390934610328911746890412
,0.8467659108842965354213561
,0.8544383607357018961536710
,0.8621108105871072568859859
,0.8697832604385126176183007
,0.8774557102899179783506156
,0.8851281601413233390829305
,0.8928006099927286998152454
,0.9004730598441340605475602
,0.9081455096955394212798751
,0.9158179595469447820121900
,0.9234904093983501427445049
,0.9311628592497555034768197
,0.9388353091011608642091346
,0.9465077589525662249414495
,0.9541802088039715856737644
,0.9618526586553769464060792
,0.9695251085067823071383941
,0.9771975583581876678707090
,5.0121724464263168741240406
,4.8697504530243156395385995
,4.7315698806008876786677320
,4.5973084160449575463758265
,4.4668554436374119376296221
,4.3401033968734070711548156
,4.2169476527070566262977991
,4.0972864495352814273587683
,3.9810208202713806002748242
,3.8680545333783808992222930
,3.7582940366142310040231678
,3.6516484001380442592221698
,3.5480292572868949996234278
,3.4473507426104301742952885
,3.3495294275978109155289530
,3.2544842549782218021903191
,3.1621364726023681868127824
,3.0724095678201086556668997
,2.9852292030594562710632545
,2.9005231530673896145344770
,2.8182212443082508279701415
,2.7382552887824251897086469
,2.6605590635339710914308853
,2.5850681807508424370212197
,2.5117200979571041585813873
,2.4404540703035415560862020
,2.3712110523258966843229700
,2.3039336818866820166817888
,2.2385662253325442350160301
,2.1750545313394487045854930
,2.1133459860610797065305633
,2.0533894695454932843858842
,1.9951353133862608224546875
,1.9385352595747584736329827
,1.8835424205205439918131560
,1.8301112402039729776248578
,1.7781974564497102786475580
,1.7277580642340191197092736
,1.6787512800763668696646391
,1.6311365074196997326794190
,1.5856874563308946957107537
,1.5407426926600453764848453
,1.4970749604365078955225954
,1.4546480842523457077675175
,1.4134269167691415614029893
,1.3733773096030557070434952
,1.3344660850378677885430534
,1.2966610085425922527235798
,1.2599307620709450095120019
,1.2242449181205850017306602
,1.1895739145306796213930056
,1.1558890299969675208302533
,1.1231623602840936637647928
,1.0913667951155714419542164
,1.0604759957222835708989805
,1.0304643730310101279457058
,1.0013070664749867955123364
,0.9729799234090327209045768
,0.9454594791123015484757275
,0.9187229373621806916005994
,0.8927481515633947095622602
,0.8675136064167916494227484
,0.8429984001127954762466743
,0.8191822270349234935693516
,0.7960453609592343937606529
,0.7735686387359893556592283
,0.7517334444402239412852396
,0.7305216939783459872970184
,0.7099158201382734789675055
,0.6898987580710024269947667
,0.6704539311919112121174180
,0.6515652374904666865873537
,0.6332170362374289762641411
,0.6153941350790588238339751
,0.5980817775083242526790173
,0.5812656307036155878265049
,0.5649317737261033700590929
,0.5490666860675226246257807
,0.5336572365409302243222101
,0.5186906725077102819909669
,0.5041546094348675621787947
,0.4900370207772922204192412
,0.4763262281802486119985929
,0.4630108919977430348424718
,0.4501125538146760196589469
,0.4375562008362088306512305
,0.4253632168810617120158213
,0.4135235223686202221671238
,0.4020273322624750567122476
,0.3908651481384367576410455
,0.3800277505069991068609170
,0.3695061913856110824561085
,0.3592917871165306475944590
,0.3493761114264422595887538
,0.3397509887244792858851383
,0.3304084876357766820120787
,0.3213409147682148581104400
,0.3125408087105989163312358
,0.3040009342611689757696070
,0.2957142768860391845997526
,0.2876740374079271300722382
,0.2798736269263478182445226
,0.2712390357268525398204417
,0.2638940991789053280847099
,0.2567704077511871463279647
,0.2509455918954779374274722
,0.2442525266748681589401571
,0.2377639182301718723255846
,0.2314745274230288474281991
,0.2253792934760059374355023
,0.2194733311328642411108802
,0.2137519280743258864863066
,0.2082105425736678061543472
,0.2028448013627937029923487
,0.1976504976615815201146376
,0.1926235893022327227974699
,0.1877601968589534264797436
,0.1830566016765899362006564
,0.1785092436850793939928650
,0.1741147188998269090820514
,0.1698697765487790500849030
,0.1666470264287276681347549
,0.1626977624357655027864666
,0.1588895497934241229920360
,0.1552198540177991137323232
,0.1516863219734921885972767
,0.1482867877546405754873859
,0.1450192797406504863211296
,0.1418820054698488875022377
,0.1389419218542589651299579
,0.1360612043031298457052003
,0.1333067740780932708410944
,0.1306777929032297558276099
,0.1281736947198695852900840
,0.1257942074904873364094016
,0.1235393786676748234532042
,0.1214096042521450175000197
,0.1194056631194320428068778
,0.1175287569545823140870766
,0.1157805563666678139167487
,0.1141632548161738980319058
,0.1126796318621515191615856
,0.1113331276197046248999101
,0.1101279283128249464329684
,0.1090690685487780142715053
,0.1081625503769628182659801
,0.1074154842957911332179677
,0.1068362552646629076713580
,0.1064347174323944794638308
,0.1062224274859741440790728
,0.1062129158879301094042802
,0.1064220102154552621831485
,0.1068682207857192117961276
,0.1075731849766515535460343
,0.1085622006001695366572690
,0.1098648439042163166279309
,0.1115156839842988412137004
,0.1135551033214749899746820
,0.1160302239451170558393045
,0.1189959209366090453485754
,0.1225158839757625045541189
,0.1266636663980770793891395
,0.1315235781349535226780745
,0.1371912211461699393488800
,0.1437733330045904422966885
,0.1512943652262918603490505
,0.1600635355925460745485367
,0.1701121121423534721106563
,0.1815562797321451926624292
,0.1944907720564890141190517
,0.2089716259185998292746689
,0.2249963430781007078795852
,0.2424848278428717307519946
,0.2612665552203793928320863
,0.2810804650169482776789209
,0.3015925598174784560967510
,0.3224314846351655217127075
,0.3432341086505752980606587
,0.3637008492961378292029906
,0.3835837033918208516247716
,0.4027645593202454077363939
,0.4211919444307852811171244
,0.4388728710718136083457352
,0.4558464050425126701249212
,0.4721646450152520158027869
,0.4878820535364936650246648
,0.5030419391134424156319938
,0.5176836115176099983870017
,0.5318388461649433684996779
,0.5455342333730136550329348
,0.5587925327572000888665116
,0.5716336868628675293990682
,0.5840755188182185086986919
,0.5961342036894228257892792
,0.6078245934205335210265275
,0.6191604496695508608183900
,0.6301546176976828839144673
,0.6408191594442093075301159
,0.6511654532800353889498979
,0.6612042637544185419429255
,0.6709457915975560737820160
,0.6803997293591350636887682
,0.6895753508517747931705344
,0.6984816260281657696040725
,0.7071272832170376609894902
,0.7155207083441107451804442
,0.7236696692550187437475984
,0.7315810781481287827787696
,0.7392611696015700673001447
,0.7467163101886904463810879
,0.7541714507758108254620311
,0.7616265913629312045429742
,0.7690817319500515836239174
,0.7765368725371719627048606
,0.7839920131242923417858037
,0.7914471537114127208667469
,0.7989022942985330999476901
,0.8063574348856534790286332
,0.8138125754727738581095764
,0.8212677160598942371905196
,0.8287228566470146162714627
,0.8361779972341349953524059
,0.8436331378212553744333491
,0.8510882784083757535142922
,0.8585434189954961325952354
,0.8659985595826165116761786
,0.8734537001697368907571217
,0.8809088407568572698380649
,0.8883639813439776489190081
,0.8958191219310980279999512
,0.9032742625182184070808944
,0.9107294031053387861618376
,0.9181845436924591652427807
,0.9256396842795795443237239
,0.9330948248666999234046671
,0.9405499654538203024856102
,0.9480051060409406815665534
,0.9554602466280610606474966
,0.9629153872151814397284397
,0.9703705278023018188093829
,0.9778256683894221978903261
,5.1361383906717765768235040
,4.9905983157181319498363337
,4.8488050943880054433066107
,4.7112203282698201789457926
,4.5775379961914293147628996
,4.4476479542879836515112402
,4.3214430764149911468052778
,4.1988191587971064322459824
,4.0796748457119997866016092
,3.9639115675932270477233033
,3.8514334847722753174537047
,3.7421474321422927289404470
,3.6359628619790909098696829
,3.5327917837738436190875291
,3.4325487011047455254697525
,3.3351505462883990205114060
,3.2405166138655459029394024
,3.1485684939902949253109909
,3.0592300066204307640305160
,2.9724271371512669404069129
,2.8880879753747925597906487
,2.8061426468411880819076032
,2.7265232730224737700552851
,2.6491638975046765125398451
,2.5740004142550980681392048
,2.5009705784373914561058427
,2.4300138830708122306134555
,2.3610715462951969989546797
,2.2940864550753508055436214
,2.2290031179098566127549930
,2.1657676188741135092641343
,2.1043275729613495350633912
,2.0446320826872996789802528
,1.9866316959249319396008104
,1.9302783649357548867442347
,1.8755254065649062944487468
,1.8223274635623030182074444
,1.7706404670221016495190725
,1.7204215998510892227102431
,1.6716292613154559720811676
,1.6242230325730067086453801
,1.5789755035504122737677335
,1.5342279902688029658008873
,1.4907521111920172263154427
,1.4485118499426445914934902
,1.4074722138810529248331704
,1.3675992051193512910600703
,1.3288597923599012595730073
,1.2912218835351192414151456
,1.2546542992259177573544093
,1.2191267468368367499209626
,1.1846097955065093554338773
,1.1510748517327424877976227
,1.1184941356920858890333648
,1.0868406582343363986353779
,1.0560881985330041743509355
,1.0262112823733064992381969
,0.9971851610598049253653130
,0.9689857909263102087038533
,0.9415898134312009615243255
,0.9149745358217939994460721
,0.8891179123518886395771688
,0.8639985260370890429726387
,0.8395955709329542271390778
,0.8158888349214931112740601
,0.7928586829919568312874389
,0.7704860410023056660477891
,0.7487523799081547970502015
,0.7276397004464068007933975
,0.7071305182611724582386614
,0.6872078494599891396177327
,0.6678551965887027375146090
,0.6490565350138050026984615
,0.6307962997013858430506161
,0.6130593723823383189852620
,0.5958310690939070397575961
,0.5790971280882666327727293
,0.5628436980994357963226093
,0.5470573269605857325004195
,0.5317249505645709195533755
,0.5168338821613422950917993
,0.5023718019866868500500345
,0.4883267472174456780287244
,0.4746871022489860258986027
,0.4614415892912302474826447
,0.4486118993113483721657531
,0.4361229066563772627240780
,0.4239961398600458064578334
,0.4122215783937063782182975
,0.4007894957678824754410130
,0.3896904516864331258219067
,0.3789152844585469415150669
,0.3684551036643987087515484
,0.3583012830707432150312286
,0.3484454537932029083435737
,0.3388794977025120780389500
,0.3295955410725479040046082
,0.3205859484685932292435950
,0.3118433168749613626502537
,0.3033604700618748872820163
,0.2951304531923160112683036
,0.2871465276704739943980371
,0.2794021662343776357673164
,0.2708241565579579401834565
,0.2635348913421604599705006
,0.2564667981160819731911715
,0.2506969589668634479373566
,0.2440595938392607910927268
,0.2376268243032315374829722
,0.2313934865364415116584240
,0.2253545982038859807339293
,0.2195053559996759662276133
,0.2138411334792565954288079
,0.2083574791664536962620957
,0.2030501149041634423308977
,0.1979149343973438668342624
,0.1929480018742391334019004
,0.1881455507707104901626849
,0.1835039823270683823075444
,0.1790198639878426145610746
,0.1746899275200984869016452
,0.1713820640068206835326947
,0.1673569042572762288756394
,0.1634773500553619585140552
,0.1597408794430925371710117
,0.1561451635550418493014746
,0.1526880734962683117128535
,0.1493676885363567630182757
,0.1461822688923647139969120
,0.1431304295370121049124634
,0.1402108824456751445808322
,0.1374917794237114354594098
,0.1348346729606876293061646
,0.1323078132363102732416138
,0.1299111260451074056909704
,0.1276448883486270835518894
,0.1255097612923626870795601
,0.1235068292206038531588774
,0.1216376450229060268704018
,0.1199042824488978919994508
,0.1183093972556004680463104
,0.1168562989049114902995186
,0.1155490348997830069022186
,0.1143924875939836688365503
,0.1133924898624005112024449
,0.1125559595895037623414225
,0.1118910587011900381604335
,0.1114073800717296502948983
,0.1111161662950200523791722
,0.1110305711260697186792967
,0.1111659622205161401797824
,0.1115402804908138811867957
,0.1121744661949388294219787
,0.1130929463818835523092332
,0.1143242147186627338806275
,0.1159014953799502173348301
,0.1178634983753743814549608
,0.1202552691697297698736335
,0.1231291200739947078179881
,0.1265456064330761909442202
,0.1305744810951497414386324
,0.1352955274781002803496932
,0.1407990734173635849479922
,0.1471859149711835512697178
,0.1545662337325287571943022
,0.1629678179303725160664840
,0.1726901415287728780434406
,0.1837554332695447156797997
,0.1962591037065576637932196
,0.2102638127570708448388359
,0.2257814746748236234274998
,0.2427550570893000358996261
,0.2610446170580076885592291
,0.2804233088985555455430188
,0.3005885233439126724697132
,0.3211900497855020852888686
,0.3418701663234435250693366
,0.3623193582724808514683446
,0.3822614799246162320400799
,0.4015505423572937049314646
,0.4201072205465760101006367
,0.4379180274317655552351880
,0.4550096027552095745427607
,0.4714294263864509670902692
,0.4872321974649344022978426
,0.5024631034062144729901433
,0.5171643538047975274807300
,0.5313702162063657086221724
,0.5451092223724296470521722
,0.5584055591816714514408204
,0.5712802084409819292076804
,0.5837517639648117651063330
,0.5958369891500999715461262
,0.6075511979488078528888195
,0.6177136164257415185119271
,0.6299221111861389443831172
,0.6406042728387263407441310
,0.6509665938242974458916024
,0.6610200202494059817937000
,0.6707749203861280706817638
,0.6802411389026095100973635
,0.6894280636601746170555316
,0.6983447118497740913056759
,0.7069998015814267233736246
,0.7154017374225710712565274
,0.7235584673526327392778512
,0.7314772970960004006002464
,0.7391648970027111520408880
,0.7466277254430360166281844
,0.7538727960043990483640641
,0.7611178665657620800999439
,0.7683629371271251118358236
,0.7756080076884881435717034
,0.7828530782498511753075832
,0.7900981488112142070434629
,0.7973432193725772387793427
,0.8045882899339402705152224
,0.8118333604953033022511022
,0.8190784310566663339869820
,0.8263235016180293657228617
,0.8335685721793923974587415
,0.8408136427407554291946212
,0.8480587133021184609305010
,0.8553037838634814926663807
,0.8625488544248445244022605
,0.8697939249862075561381403
,0.8770389955475705878740200
,0.8842840661089336196098998
,0.8915291366702966513457795
,0.8987742072316596830816593
,0.9060192777930227148175391
,0.9132643483543857465534188
,0.9205094189157487782892986
,0.9277544894771118100251783
,0.9349995600384748417610581
,0.9422446305998378734969378
,0.9494897011612009052328176
,0.9567347717225639369686974
,0.9639798422839269687045771
,0.9712249128452900004404569
,0.9784699834066530321763366
,5.2623946495616316099130927
,5.1133211578622361770385396
,4.9681824201346271863144466
,4.8270430644452666513188888
,4.6900774944120184883900038
,4.5569970453702026702558214
,4.4276920523974059307192874
,4.3020558399277648575775856
,4.1799846365170223450036247
,4.0613775076187064172472674
,3.9461362979671315009966293
,3.8341655772840206317653156
,3.7253725852240848759322489
,3.6196671734372900530729567
,3.5169617441609415386949422
,3.4171711857909716769654551
,3.3202128064427736120478585
,3.2260062666858910773726166
,3.1344735125427880539916714
,3.0455387096000174906862412
,2.9591281787910732603563702
,2.8751703342505834370967932
,2.7935956173032732152705648
,2.7143364711893123164543340
,2.6373272126624445199638558
,2.5625040403363379404311218
,2.4898049906937411712704034
,2.4191698294238599409311519
,2.3505400410391579235636073
,2.2838587714457845301296857
,2.2190707808640173226422121
,2.1561223980767620922449623
,2.0949614759710537548187403
,2.0355373483386185462507001
,1.9778007879017678316557749
,1.9217039655315615309660870
,1.8672004106176534055094862
,1.8142449725921407921447326
,1.7627937834918965265273982
,1.7128042216419732124421671
,1.6642348763404095635110025
,1.6170455135533392532209973
,1.5720075669459234735114705
,1.5274651954322668867547463
,1.4841888555053239784342622
,1.4421426962035042151910602
,1.4012918858080136708110786
,1.3616025829910078925877315
,1.3230419087847802295243582
,1.2855779193488010569978997
,1.2491795795121158896279212
,1.2138167370692229951600893
,1.1794600978082137032743049
,1.1460812012505570134379695
,1.1136523970824863116746428
,1.0821468222585843843575049
,1.0515383787586451980189395
,1.0218017119795328451203886
,0.9929121897442124700106092
,0.9648458819107041950502435
,0.9375795405642061153272948
,0.9110905807761126018462505
,0.8853570619141698516685324
,0.8603576694884598197177183
,0.8360716975183773991275871
,0.8124790314062205753842250
,0.7895601313034438240023860
,0.7672960159560758830465943
,0.7456682470161962728028016
,0.7246589138067984769975283
,0.7042506185277476182804435
,0.6844264618909349229269878
,0.6651700291731157399510721
,0.6464653766753052366311749
,0.6282970185780170080391827
,0.6106499141820783682632623
,0.5935094555252734549455340
,0.5768614553656681298576814
,0.5606921355231552217546209
,0.5449881155715720071341934
,0.5297364018745712721525365
,0.5149243769593241371040904
,0.5005397892229450640400046
,0.4865707429673103434630832
,0.4730056887586218117291992
,0.4598334141087640491996069
,0.4470757660019920587401998
,0.4346575032326858711861917
,0.4226003056988163475438114
,0.4108942155561661202511914
,0.3995295685645161021248839
,0.3884969863390065891728398
,0.3777873688636018134623384
,0.3673918872630561049952291
,0.3573019768302767573686651
,0.3475093303065359129355727
,0.3380058914125589342170031
,0.3287838486291876916034482
,0.3198356292270266298949366
,0.3111538935452986542884446
,0.3027315295210294410210849
,0.2945616474706692633489524
,0.2866375751273355088066808
,0.2789528529380078114563446
,0.2704350580621766031441666
,0.2632051741521574395044070
,0.2561964601105304328854118
,0.2504854788450910363373225
,0.2439077639861024771050779
,0.2375348800080576416871025
,0.2313617479850505753713463
,0.2253834743523659978059470
,0.2195953489133590785797878
,0.2139928431804254960191258
,0.2085716090346894646678777
,0.2033274776709900755200522
,0.1982564587724269244972675
,0.1933547398355807411807206
,0.1886186855455819766369530
,0.1840448370912947939626036
,0.1796299113221827281616783
,0.1762371123621481738830141
,0.1721363913747610829840795
,0.1681859959924975889133947
,0.1643834241825623265764733
,0.1607263796907184849604988
,0.1572127800237174410913354
,0.1538407659032687280209473
,0.1506086552489461216630673
,0.1475152072130918867731708
,0.1445592193673348180293914
,0.1417398605729930649577142
,0.1391259502713042550681166
,0.1365790938689369071745716
,0.1341682942003886158666148
,0.1318940847956439066379630
,0.1297574224089589056685412
,0.1277597311985669004119615
,0.1259029540227097898608122
,0.1241896115563728558717216
,0.1226228713431846695236516
,0.1212066287281468451864086
,0.1199456019539383855310177
,0.1188454411900515955702318
,0.1179128586895901165121359
,0.1171557798791075660771455
,0.1165835216599750978616612
,0.1162070014802546735754873
,0.1160389813700918176797572
,0.1160943585516724524397958
,0.1163905003361901530078981
,0.1169476395057829631873858
,0.1177893397202459252470774
,0.1189430230427514501023722
,0.1204405903038763964163493
,0.1223191205436843370657485
,0.1246216503187914242944956
,0.1273980259433220296738654
,0.1307058000799361519028707
,0.1346111118407322670975645
,0.1391894505482065003132419
,0.1445261576695462124586555
,0.1507164100046809451782792
,0.1578643438770997442510691
,0.1659929061676782002798802
,0.1753935510530961749964263
,0.1860863753976053081018449
,0.1981666362706787087866189
,0.2117020461487161275826452
,0.2267165638572658237226420
,0.2431732836167352085343651
,0.2609599808893334205173176
,0.2798822513072785622689764
,0.2996692616688199639618517
,0.3199949031947770250461360
,0.3405124974414174832126889
,0.3608958359548686267714857
,0.3808833886369042964759046
,0.4002650222344044106392857
,0.4189459548121780008145265
,0.4368889102030280580102328
,0.4541047901800092101431972
,0.4706356015649621471474973
,0.4865317842155944538795609
,0.5018408338398837598148816
,0.5166074963363479488620555
,0.5308686788249087351587718
,0.5446550996312401471399767
,0.5579925979927971013694332
,0.5709033651029906675233860
,0.5834068844809231491055357
,0.5955205899898183830032394
,0.6072603155594212820389544
,0.6178512519154821802658262
,0.6296749473891279924586684
,0.6403759209417485553927918
,0.6507553426964941545307397
,0.6608243540234165491753515
,0.6705934963269002402341812
,0.6800727700490520888365609
,0.6892716928845235013767478
,0.6981993675473601168590676
,0.7068645486877266348457738
,0.7152756690507852121996279
,0.7234407828076426794083886
,0.7313674463656204549621975
,0.7390626648988815050600465
,0.7465330824827267619525628
,0.7537854639898580177970189
,0.7608272142051730746459270
,0.7678689644204881314948352
,0.7749107146358031883437434
,0.7819524648511182451926516
,0.7889942150664333020415597
,0.7960359652817483588904679
,0.8030777154970634157393761
,0.8101194657123784725882842
,0.8171612159276935294371924
,0.8242029661430085862861006
,0.8312447163583236431350088
,0.8382864665736386999839169
,0.8453282167889537568328251
,0.8523699670042688136817333
,0.8594117172195838705306414
,0.8664534674348989273795496
,0.8734952176502139842284578
,0.8805369678655290410773659
,0.8875787180808440979262741
,0.8946204682961591547751823
,0.9016622185114742116240905
,0.9087039687267892684729986
,0.9157457189421043253219068
,0.9227874691574193821708150
,0.9298292193727344390197231
,0.9368709695880494958686313
,0.9439127198033645527175395
,0.9509544700186796095664477
,0.9579962202339946664153558
,0.9650379704493097232642640
,0.9720797206646247801131722
,0.9791214708799398369620803
,5.3907050937127047873786978
,5.2377585409368583313494128
,5.0893665547843021101925842
,4.9447513479395599489407687
,4.8044494246068918386072255
,4.6681268959097756976461824
,4.5356715188548761830134026
,4.4069741154062036514460488
,4.2819284720560775170383749
,4.1604312641594090038665854
,4.0423819949952735086640132
,3.9276829415520366772796024
,3.8162391013934149341935154
,3.7079581372443470854705083
,3.6027503178548618834042827
,3.5005284551092734623978231
,3.4012078382184935954057892
,3.3047061662269356929755304
,3.2109434800981344615422586
,3.1198420954479377797952111
,3.0313265366943147327560837
,2.9453234744999532424003519
,2.8617616559118794761218396
,2.7805718655952547102572225
,2.7016868423134039467470302
,2.6250412155175570916298966
,2.5505715167867824000325072
,2.4782160442814267220512647
,2.4079148573016668777313498
,2.3396097170473200144158454
,2.2732440383987135845700323
,2.2087628430562893377953060
,2.1461127140026752257995213
,2.0852417512529060061865493
,2.0260995288588961038556135
,1.9686370531342485268311293
,1.9128067220661149061555761
,1.8585622858750050490073136
,1.8058588087173270686491833
,1.7546526314331332141449593
,1.7049013353984041607702693
,1.6565637073796382061630084
,1.6095997053932755704863666
,1.5647795707486573668631991
,1.5204503983619692686346525
,1.4773814463655208228942683
,1.4355370357370182965439653
,1.3948825020364958859886428
,1.3553841666941104371346682
,1.3170093091153169950757729
,1.2797261395803769534751382
,1.2435037729158087138614519
,1.2083122029160320298757370
,1.1741222774941033613060881
,1.1409056745410195432555156
,1.1086348784737005690459455
,1.0772831574523047404312592
,1.0468245412481262945902927
,1.0172337997438463119692642
,0.9884864220484654850906736
,0.9605585962097645813528857
,0.9334271895076331482243859
,0.9070697293121313675712258
,0.8814643844906134839689571
,0.8565899473487280646466502
,0.8324258160905682046859511
,0.8089519777837146374821486
,0.7861489918153271583278752
,0.7639979738259177199921623
,0.7424805801078067091225421
,0.7215789924557246548530998
,0.7012759034573678995627688
,0.6815545022121458629271729
,0.6623984604667045861248198
,0.6437919191562184728638840
,0.6257194753408593657084680
,0.6081661695273028467312315
,0.5911174733656925361913181
,0.5745592777131306450044690
,0.5584778810555038885965473
,0.5428599782803413820175820
,0.5276926497942975302635205
,0.5129633509797949519892768
,0.4986599019862311688022771
,0.4847704778519619783772043
,0.4712835989540858361301900
,0.4581881217839519626622291
,0.4455060561783137917934994
,0.4331620430186685077877939
,0.4211779204594537362460471
,0.4095437972656482683575518
,0.3982500754600760695112172
,0.3872874426849055029542512
,0.3766468648306101618672415
,0.3663195789294719229012287
,0.3562970863112920882898038
,0.3465711460195927684502237
,0.3371337684873001450114316
,0.3279772094716525976387800
,0.3190939642489484806553435
,0.3104767620707014619263475
,0.3021185608838480307625218
,0.2940125423188334474744465
,0.2861521069506808290228150
,0.2785308698395381754586708
,0.2700771895340341455238331
,0.2629106780618739591659505
,0.2559654193121220777662472
,0.2503174869181648554139485
,0.2438036988835469986991455
,0.2374950914728077844273457
,0.2313866818175784045852339
,0.2254736771935334227467962
,0.2197514735948928876752007
,0.2142156546975197417559400
,0.2088619911952462604443070
,0.2036864404736155875763615
,0.1986851465621292944785381
,0.1938544402799259325220760
,0.1891908394735590803747982
,0.1846910492451506735633870
,0.1812135967712670270302056
,0.1770377734826092397391051
,0.1730171674495562528228731
,0.1691493045426407659803658
,0.1654319300971058837035343
,0.1618630181142815538386515
,0.1584407821045473729881792
,0.1551636004752266484452150
,0.1520304142164803917758320
,0.1490401079444990672939753
,0.1461920082066497927897331
,0.1434857684392210896984210
,0.1409909945569154943179058
,0.1385694182070859592492695
,0.1362909409526649739952120
,0.1341568475528244208661022
,0.1321689384458750449180542
,0.1303295875467769537880969
,0.1286418087771369067606742
,0.1271093337098084807834653
,0.1257367025170329222216736
,0.1245293706873112776767343
,0.1234938311934399290947795
,0.1226377601511042525483930
,0.1219701855591453637517318
,0.1215016859221306894101033
,0.1212446224640529868210592
,0.1212134092166216037256277
,0.1214248332381175493610570
,0.1218984214051432451997314
,0.1226568705181725754682631
,0.1237265490197771988789555
,0.1251380589538765297774603
,0.1269268873349359283420057
,0.1291341258691177662498717
,0.1318072506674776156465612
,0.1350009419338281113631695
,0.1387778946663860701882243
,0.1432095305484500646908685
,0.1483764725341834012084519
,0.1543685864498307858116988
,0.1612842735189627951797320
,0.1692286130063597182626722
,0.1782250366990728307481362
,0.1885514251536700991440654
,0.2002154891864424968161984
,0.2132886361250432849523406
,0.2278047589252608362553332
,0.2437443508184820306627927
,0.2610200520305668847598213
,0.2794677869130661740371124
,0.2988481553263185319657680
,0.3188614611785290930967562
,0.3391762653805874827561695
,0.3594664963236205434959913
,0.3794481650523363058802317
,0.3989120885971768060151987
,0.4177077933591822889169975
,0.4357824587258706805492636
,0.4531284728106731996000178
,0.4697778610945309019086835
,0.4857760069054814500155715
,0.5011709670972516184050960
,0.5160095628942779066861135
,0.5303313547077879164248770
,0.5441694583285564545960256
,0.5575516044169914753325656
,0.5705013907756374402779898
,0.5830393338449408879853308
,0.5951836374719265965183013
,0.6069507250716887902797225
,0.6178507243691292449838670
,0.6301315985711063438756696
,0.6401332053908398433961224
,0.6505308801496310078249508
,0.6606165150556740917053844
,0.6704008355823766196479596
,0.6798940048114899825648649
,0.6891056811143756455351195
,0.6980450766532335649117158
,0.7067210170103969124610899
,0.7151419832419668720646655
,0.7233161057731396503811538
,0.7312511031067541189543135
,0.7389542244887643551720657
,0.7464323160699841697152124
,0.7536920954310298848000116
,0.7607405445732200455211114
,0.7675851091840968365431763
,0.7744296737949736275652413
,0.7812742384058504185873062
,0.7881188030167272096093711
,0.7949633676276040006314361
,0.8018079322384807916535010
,0.8086524968493575826755659
,0.8154970614602343736976309
,0.8223416260711111647196958
,0.8291861906819879557417607
,0.8360307552928647467638257
,0.8428753199037415377858906
,0.8497198845146183288079555
,0.8565644491254951198300205
,0.8634090137363719108520854
,0.8702535783472487018741504
,0.8770981429581254928962153
,0.8839427075690022839182802
,0.8907872721798790749403452
,0.8976318367907558659624101
,0.9044764014016326569844750
,0.9113209660125094480065400
,0.9181655306233862390286049
,0.9250100952342630300506698
,0.9318546598451398210727348
,0.9386992244560166120947997
,0.9455437890668934031168646
,0.9523883536777701941389296
,0.9592329182886469851609945
,0.9660774828995237761830595
,0.9729220475104005672051244
,0.9797666121212773582271893
,5.5209801913762248659622855
,5.3643988686466990145618183
,5.2124671464916652041665657
,5.0645146236277209794707233
,4.9206257509190489685124703
,4.7810103116933388989195919
,4.6453550950499691296613491
,4.5135483875205313353262682
,4.3854815071521100477980326
,4.2610487155230254430193781
,4.1401471508321163739196891
,4.0226767722508007807391550
,3.9085403081271246072958547
,3.7976432031743643236154639
,3.6898935620789004019570712
,3.5852020887828079942494242
,3.4834820219376294581081766
,3.3846490677054577034255090
,3.2886213313014227566100089
,3.1953192485671646494438392
,3.1046655185809286514597716
,3.0165850379678933457228140
,2.9310048370543397844301126
,2.8478540159475196347216297
,2.7670637095662424798092616
,2.6885669627222941180377802
,2.6122987453833363957755864
,2.5381958988926589526613498
,2.4661970240347241833944736
,2.3962424755331057646401405
,2.3282743017768963156299833
,2.2622361968354742778331001
,2.1980734538254473875440453
,2.1357329195948553390849156
,2.0751629506906019706491406
,2.0163133705750229118791594
,1.9591354280580983715509547
,1.9035817569030621942971493
,1.8496063366117883042250014
,1.7971644542624956031318106
,1.7462126674975861906347063
,1.6967087685281843079110331
,1.6486117491698519810228163
,1.6018817668726834657633162
,1.5572878346239269475859146
,1.5131800766165659499762342
,1.4703265163491436862130968
,1.4286916533944642448972218
,1.3882409970797875420345235
,1.3489410379198458755922729
,1.3107592198634834268489158
,1.2736639133309852756070768
,1.2376243890198377339828539
,1.2026107924573030683035313
,1.1685941192788120712720001
,1.1355461912117894573981403
,1.1034396327451281294429464
,1.0722478484650941332745333
,1.0419450010390272076676865
,1.0125059898287231963109889
,0.9839064301159493597381811
,0.9561226329230481102428030
,0.9291315854120987260955644
,0.9029109318466113087708891
,0.8774389551002046427896630
,0.8526945586972084489829626
,0.8286572493705913755590586
,0.8053071201230644904356382
,0.7826248337776836594414931
,0.7605916070046724319908549
,0.7391891948116396937606964
,0.7183998754847554790714526
,0.6982064359688571197892770
,0.6785921576748196182293782
,0.6595408027029259212525858
,0.6410366004713387022562188
,0.6230642347392277846651609
,0.6056333162030012040588645
,0.5886811420472789491142862
,0.5722174715125428745565728
,0.5562020191998888751783170
,0.5406741336130517217029023
,0.5255950488861076408397821
,0.5109522970407941455661671
,0.4967337737865050173446946
,0.4829277287380890903989439
,0.4695227559651690696362891
,0.4565077848720162645435039
,0.4439049951871585908413920
,0.4316389079281260365839046
,0.4197315266518374388127199
,0.4081730309852300009332282
,0.3969538935786387501281069
,0.3860648725926233426619660
,0.3754970044589296951365043
,0.3652415969135084372609867
,0.3552902223001793147183491
,0.3456347111442684694182503
,0.3362671459963609277288299
,0.3271798555472298364321659
,0.3183654090160217831062539
,0.3098166108149414399441923
,0.3015264954949582465459912
,0.2934883229784820968255588
,0.2856955740864971504677783
,0.2781419463693045601715426
,0.2697565725003931991210493
,0.2626577327634393443922534
,0.2557803297574873790942718
,0.2501999772069427585563517
,0.2437547530867908707197245
,0.2375151947123131934702656
,0.2314764283060103677858166
,0.2256337761217038218042319
,0.2199827557124745813776912
,0.2145190796545295708330769
,0.2092386557116820700041870
,0.2041375874040239901674454
,0.1992121749160669086364805
,0.1944589162587947450688830
,0.1898745085906356211413737
,0.1863127957233843834394804
,0.1820624565159205954234523
,0.1779724034533128051993600
,0.1740401988680679856713596
,0.1702636393007588844206168
,0.1666407660412498881186139
,0.1631698774966562071053744
,0.1598494118967128674313471
,0.1566785406562790916584760
,0.1536562318022861861610551
,0.1507819891981079241105590
,0.1480556723445936861960348
,0.1454775275168979087325738
,0.1431180888687839380946087
,0.1408393155476673486159456
,0.1387121832580371916243678
,0.1367389071867501915136245
,0.1349223355575535077122140
,0.1332660241833033554215149
,0.1317743233786801693163682
,0.1304524796777493944599513
,0.1293067549821421968747615
,0.1283445627069088879057546
,0.1275746298305154846630671
,0.1270071841453362937457428
,0.1266541739719766468397211
,0.1265295240818802569027213
,0.1266494320412832885747179
,0.1270327176422093029550808
,0.1277012201464193252853363
,0.1286802601642919041680102
,0.1299991723896756490308491
,0.1316918932171216027882110
,0.1337976293429493646058859
,0.1363615768561802221725543
,0.1394356704576326655420360
,0.1430793262036994806241097
,0.1473601041896921703955314
,0.1523541679124036929415809
,0.1581463596789884629156830
,0.1648296455933574988783619
,0.1725035617151775280131432
,0.1811874467360520823966397
,0.1911530396405077270038930
,0.2024078653750570333524905
,0.2150258693659915232299085
,0.2290490079892671115846525
,0.2444726684968749619297768
,0.2612315783777595656900417
,0.2791896570038648883738119
,0.2981379959588306149953496
,0.3178045807525039512242415
,0.3378768894440052905636662
,0.3580344361433354660739781
,0.3779842378614173825646105
,0.3974902923284747147114615
,0.4163898766076855051387895
,0.4345941906356591277749146
,0.4520758988151539758959530
,0.4688509849996195244514752
,0.4849597537360474386325393
,0.5004489224918479139958549
,0.5153666661531811632457334
,0.5297550133244249837005668
,0.5436496103278537495029354
,0.5570803121969881699371285
,0.5700723430802240310200091
,0.5826474219273043431144288
,0.5948246430288022246202218
,0.6066211032213085774245087
,0.6180523355133358265334209
,0.6295945686375604699591690
,0.6398751602548897743361067
,0.6502923273661996850236733
,0.6603957008277756557390603
,0.6701962050989367369879801
,0.6797041761807619542068437
,0.6889294230697948773212147
,0.6978812835741420306234772
,0.7065686787175717853415335
,0.7150001593186853243722112
,0.7231839265479933498426135
,0.7311278125882408884805841
,0.7388392419868173854879956
,0.7463252432869462715814279
,0.7535925899262170268855243
,0.7606480654612228775590665
,0.7674986897815625486174440
,0.7741516354646145181561678
,0.7808045811476664876948917
,0.7874575268307184572336155
,0.7941104725137704267723393
,0.8007634181968223963110631
,0.8074163638798743658497870
,0.8140693095629263353885108
,0.8207222552459783049272346
,0.8273752009290302744659584
,0.8340281466120822440046823
,0.8406810922951342135434061
,0.8473340379781861830821299
,0.8539869836612381526208537
,0.8606399293442901221595775
,0.8672928750273420916983014
,0.8739458207103940612370252
,0.8805987663934460307757490
,0.8872517120764980003144728
,0.8939046577595499698531967
,0.9005576034426019393919205
,0.9072105491256539089306443
,0.9138634948087058784693681
,0.9205164404917578480080920
,0.9271693861748098175468158
,0.9338223318578617870855396
,0.9404752775409137566242634
,0.9471282232239657261629873
,0.9537811689070176957017111
,0.9604341145900696652404349
,0.9670870602731216347791587
,0.9737400059561736043178826
,0.9803929516392255738566064
,5.6532877383123789627461520
,5.4929169521247489527127073
,5.3371288837916202041355973
,5.1859499596258000764237295
,5.0385748740422018343565469
,4.8956166367855979970613589
,4.7567130399595063394713179
,4.6217497979785724382395529
,4.4906157330147333794911901
,4.3632026700457906542851561
,4.2394053605695356523597184
,4.1191214233719648518672329
,4.0022512930104507944406578
,3.8886981693819371308507016
,3.7783679644005991882238504
,3.6711692440633894030099782
,3.5670131658476562641624241
,3.4658134124194224234827288
,3.3674861231015675855360314
,3.2719498245919376167023529
,3.1791253621905686266302382
,3.0889358324398692445811321
,3.0013065188164822494343298
,2.9161648216891951079787759
,2.8334402198673580564047825
,2.7530641744559369854528086
,2.6749700805692335769947476
,2.5990932745083079602466114
,2.5253708862948966995531919
,2.4537418427936987797011170
,2.3841468051268832617495264
,2.3165281195484364040737546
,2.2508297697008634585813525
,2.1869973302182543761773559
,2.1249779216415474181189893
,2.0647201666118153440265814
,2.0061741473072656205545172
,1.9492913640837348232537352
,1.8940246953227162229893565
,1.8403283583505425369253317
,1.7881578715464190310058257
,1.7374700174845298938919314
,1.6882228071335283470233435
,1.6403754450744023607455802
,1.5938882957077347146679358
,1.5495291079660191702060956
,1.5056511285266964694784519
,1.4630211102036709824858463
,1.4216037379465011891710446
,1.3813647014623571251945577
,1.3422706667999899643461958
,1.3042892487434338821827851
,1.2673889839926688605231675
,1.2315393051090950393700041
,1.1967105152043493454527834
,1.1628737633515855431909358
,1.1300010206989694605539398
,1.0980650572657233432494195
,1.0670394194016443734085442
,1.0368984078915655100416870
,1.0076170566867896916107838
,0.9791711122460662330979630
,0.9515370134691916170766035
,0.9246918722068380169787361
,0.8986134543307017219504473
,0.8732801613485726699437350
,0.8486710125493792666873105
,0.8247656276637620464953216
,0.8015442100261696012353241
,0.7789875302249229527262742
,0.7570769102271508455004323
,0.7357942079658887912785303
,0.7151218023770815612749630
,0.6950425788745795419032447
,0.6755399152516339267293688
,0.6565976679977408858590593
,0.6382001590200993002000018
,0.6203560213344854190609112
,0.6030034523335019436274251
,0.5861512672616624453070244
,0.5697855241957754390824675
,0.5538926858512084328012293
,0.5384321112456486035924286
,0.5234452680739359875516925
,0.5088930259838473357802968
,0.4947633602902440919102389
,0.4810445992761594458109187
,0.4677254148523887211652550
,0.4547948135536361569108976
,0.4422751522499544507560643
,0.4300908306344420894973268
,0.4182640250807591053572310
,0.4067849906997408893083445
,0.3956442755296848967638823
,0.3848327131663594746768808
,0.3743414156754265587068176
,0.3641617667862157015079561
,0.3542854153665775385206871
,0.3447042691794128810300890
,0.3354104889224510110956601
,0.3263964825539438230350697
,0.3176548999081845736647267
,0.3091786276061487814814654
,0.3009607842681114031613276
,0.2929947160368036596089780
,0.2852739924215369482496385
,0.2777924024757408294483696
,0.2694798479221041653808300
,0.2624533177573410425154066
,0.2556485282180536722229647
,0.2501406603183629062669979
,0.2437690363812751170868864
,0.2376037230398274635589928
,0.2316399708587468242448892
,0.2258732336621564196210699
,0.2202991686485128441930215
,0.2149136370441908916451013
,0.2097127052831599114401939
,0.2046926466715854875388914
,0.1998499434735951651997965
,0.1951812893389240077812730
,0.1915358261060582101276140
,0.1872116872108818830255927
,0.1830530860936326054133616
,0.1790576306833536746054847
,0.1752231789726386990135865
,0.1715478510255235011783270
,0.1680300430126552280185592
,0.1646682472569965249853396
,0.1614619287500481947805753
,0.1584101279961391550710204
,0.1555125470532879305984864
,0.1527692746325785555505661
,0.1501808211550690608238057
,0.1477481592855953707044137
,0.1454727709586356443338673
,0.1434274277967780286680011
,0.1414739426853830750463459
,0.1396858332192115192960102
,0.1380672477770217010384357
,0.1366232122167400364620704
,0.1353597430644673249577892
,0.1342839798207497992166282
,0.1334043357979733945839484
,0.1327306772666490275458528
,0.1322745298095767130241995
,0.1320493195163392474711372
,0.1320706526402911917816851
,0.1323566376443816583474700
,0.1329282623902355853218182
,0.1338098189326703268964280
,0.1350293922244106548102849
,0.1366194158591284013581912
,0.1386172729463076014333467
,0.1410659633878185437172448
,0.1440147952759826821544920
,0.1475200650444136174499477
,0.1516456697562140465418423
,0.1564635496215298904321145
,0.1620538010467925671420630
,0.1685042369380873872319881
,0.1759091017931457279210861
,0.1842837900578890297786927
,0.1938938210714433452164229
,0.2047460732684502626721468
,0.2169160401806941584901267
,0.2304521063594892893444666
,0.2453622713574045710593907
,0.2616006955777382958494570
,0.2790568411856977903973132
,0.2975508827404225176138652
,0.3168389694235801967714394
,0.3366302924376597394129362
,0.3566146835377626556073949
,0.3764956221314332829308569
,0.3960208942386151398373784
,0.4150033781883908923227011
,0.4333277474548724583769399
,0.4509435708290953082055807
,0.4678500125425837929959982
,0.4840777248540444888114109
,0.4996697334368685461392090
,0.5146744871090913608924211
,0.5291360314391447827730985
,0.5430925435128585165855952
,0.5565761981434348415476165
,0.5696140764025242608781241
,0.5822292950038567838078052
,0.5944419832273863946170422
,0.6062700130486021743436709
,0.6177295122628737589209891
,0.6291227127101951532850421
,0.6396007453422308808299590
,0.6500387403572458477896134
,0.6601610511411647452817419
,0.6699788192901536820755837
,0.6795025671550057877468021
,0.6887422653613840539676971
,0.6977073902059853782731125
,0.7064069760639469786056566
,0.7148496626027571743122735
,0.7230437280535969568617816
,0.7309970966775218847999440
,0.7387173230588661709816733
,0.7462115879481314717480700
,0.7534867632811002025050584
,0.7605495748630738406248497
,0.7674067951341260185316173
,0.7740652925405456796781323
,0.7805317635544899435018351
,0.7869982345684342073255380
,0.7934647055823784711492408
,0.7999311765963227349729436
,0.8063976476102669987966465
,0.8128641186242112626203493
,0.8193305896381555264440522
,0.8257970606520997902677550
,0.8322635316660440540914578
,0.8387300026799883179151607
,0.8451964736939325817388635
,0.8516629447078768455625664
,0.8581294157218211093862692
,0.8645958867357653732099720
,0.8710623577497096370336749
,0.8775288287636539008573777
,0.8839952997775981646810806
,0.8904617707915424285047834
,0.8969282418054866923284862
,0.9033947128194309561521891
,0.9098611838333752199758919
,0.9163276548473194837995948
,0.9227941258612637476232976
,0.9292605968752080114470004
,0.9357270678891522752707033
,0.9421935389030965390944061
,0.9486600099170408029181090
,0.9551264809309850667418118
,0.9615929519449293305655146
,0.9680594229588735943892175
,0.9745258939728178582129203
,0.9809923649867621220366232
,5.7876265878436568002030072
,5.6233689669406023980968712
,5.4638972109829326839758323
,5.3091795021404939447506877
,5.1584823868958107340176866
,5.0119117269369128919720424
,4.8697122252556290789016202
,4.7315462011590225799295695
,4.5972999512397736410207472
,4.4668628411117001775210156
,4.3401272155553050069443088
,4.2169883328322876892002569
,4.0973443118154850850487492
,3.9810960833164537042705433
,3.8681473399339796337415009
,3.7584044814305039849955392
,3.6517765547762284228383578
,3.5481751894569435457071904
,3.4475145294379556659691843
,3.3497111634279495007149308
,3.2546840549572313427972858
,3.1623544734452768700805336
,3.0726459303750219831385948
,2.9854840968227911446319922
,2.9007967773946536915730121
,2.8185138230657957869595975
,2.7385670449515671087681312
,2.6608902114133252680971964
,2.5854190001957766398277272
,2.5120908763162579369065952
,2.4408450932723178006256148
,2.3716226297235909470373372
,2.3043661406236783939505131
,2.2390199097276348716434313
,2.1755298034404684237586025
,2.1138432259725843387343502
,2.0539090757677458398688941
,1.9956777031695636104302594
,1.9391008692828040071987061
,1.8841317060388336201981474
,1.8307246773285812402320971
,1.7788355413123497772431847
,1.7284213137620847433595372
,1.6794402324551425120802151
,1.6318517225810651449791067
,1.5856163631326578578040198
,1.5415006035982372623038827
,1.4978609060375118744445899
,1.4554627168608504916846869
,1.4142709132950250783267165
,1.3742513721574243223955136
,1.3353709415968317841816315
,1.2975974136399492930848965
,1.2608994975210479072558201
,1.2252467937727131719327645
,1.1906097690563766100524390
,1.1569597317118687218595596
,1.1242688080059106692232263
,1.0925099190599858456351967
,1.0616567584386675804353217
,1.0316837703800001424525590
,1.0025661286501048596875307
,0.9742797160047087512424469
,0.9468011042408244204438006
,0.9201075348223081151743941
,0.8941769000635549913269529
,0.8689877248560438083302415
,0.8445191489229667558547021
,0.8207509095876269755720500
,0.7976633250417619613870102
,0.7752372781004116530922943
,0.7534542004303779183516099
,0.7322960572397592127202870
,0.7117453324164485506386768
,0.6917850141038613953625713
,0.6723985807025465444297652
,0.6535699872866922444103466
,0.6352836524249447780476885
,0.6175483784272398635195600
,0.6003023087664284274111992
,0.5835544227782033521734206
,0.5672908685107186377294397
,0.5514981972333872217717499
,0.5361357709638411295216542
,0.5212453097603988450003953
,0.5067876859937999745042703
,0.4927509588915897076333295
,0.4791235397747943824953154
,0.4658941828401788054492272
,0.4530519762866824229341489
,0.4406194615984544982190130
,0.4285209162603894617049605
,0.4167786971653771321832949
,0.4053831399467734408759156
,0.3943248732395820965734856
,0.3835948114746707271471848
,0.3731841479656164417555431
,0.3630843482883667205918243
,0.3532871439548309622225020
,0.3437845263825612951436028
,0.3345687411638514352496543
,0.3256322826389078661790677
,0.3169678887792521937427637
,0.3085685363891989552165285
,0.3004274366351384895068577
,0.2925380309144144375110841
,0.2848939870778524618977201
,0.2774891960224488696162837
,0.2692543273888622357148392
,0.2623051173884042297501651
,0.2555780934670774939831972
,0.2501480269051991056628026
,0.2438554823838350038567313
,0.2377700813640767352197258
,0.2318872166321189476345666
,0.2262024930871240346874629
,0.2207117288898065299296292
,0.2154109572543525252807939
,0.2102964288679026461093002
,0.2053646149002461007704312
,0.2006122105478555239788108
,0.1968836282435528495238231
,0.1924865374531651296408086
,0.1882604241229730579476609
,0.1842029514774864706883051
,0.1803120498241063962563402
,0.1765859301596656716348832
,0.1730231000202600288861987
,0.1696220929168289481836496
,0.1663827498520356051869840
,0.1633041627031723841412258
,0.1603862538259284986619235
,0.1576293655589384445914192
,0.1550342995517809685512844
,0.1526023621516417738686044
,0.1503354169800790451905215
,0.1482359442072696820158484
,0.1463781589505760705183235
,0.1446245168786129131621720
,0.1430502611861882711341565
,0.1416611516765941825024555
,0.1404640399679517037689891
,0.1394670155605793604447484
,0.1386795719030889939560325
,0.1381128030878613910381603
,0.1377796295491310329950352
,0.1376950606317406400336267
,0.1378764973222695588983555
,0.1383440785033765718647913
,0.1391210831590051766326610
,0.1402343780750890112063445
,0.1417149260847077596459087
,0.1435983537058782011364144
,0.1459255488321989924216382
,0.1487433029616921642546146
,0.1521049414553364842461747
,0.1560708885149610924969465
,0.1607090872778510481921899
,0.1660951422532604970783154
,0.1723119873166014948129288
,0.1794488170360948875448059
,0.1875172420098478731631531
,0.1967765283699485501234250
,0.2072325393166657703236666
,0.2189614836611227799423318
,0.2320167407214075994126290
,0.2464168762797123157781698
,0.2621329809916048692031154
,0.2790775713028644244850796
,0.2970981526771384606533388
,0.3159788451056517177839567
,0.3354524920418089917184545
,0.3552232462307902682852045
,0.3749962425672834775980391
,0.3945080061619833378117050
,0.4135503349538459105794175
,0.4319823221460442619346054
,0.4497291187840598558622673
,0.4667704804027457132775680
,0.4831246022266790784982504
,0.4988281198179616016119553
,0.5139282772942525001624858
,0.5284703589895769493267608
,0.5424948773833746518135968
,0.5560364415237977198103181
,0.5691242097007453981660774
,0.5817829116255126553625132
,0.5940338817702704998779950
,0.6058958901861598578264534
,0.6173857459463376606834117
,0.6286913283185279199827278
,0.6393088388237585517615003
,0.6497691034733958925784236
,0.6599116424869708730227558
,0.6697478357434862861197189
,0.6792884082518834132358165
,0.6885435051533898009878953
,0.6975227533424973591635876
,0.7062353147971460742837735
,0.7146899341289121299070075
,0.7228949775840534108795055
,0.7308584560880546643346634
,0.7385880288389192749320955
,0.7460910015235276970813061
,0.7533743546975862903636312
,0.7604448360773372606047360
,0.7673091017233765187555150
,0.7739738108190485910142797
,0.7804455357105385404636877
,0.7867304233504539556776081
,0.7930153109903693708915284
,0.7993001986302847861054488
,0.8055850862702002013193692
,0.8118699739101156165332895
,0.8181548615500310317472099
,0.8244397491899464469611303
,0.8307246368298618621750506
,0.8370095244697772773889710
,0.8432944121096926926028914
,0.8495792997496081078168118
,0.8558641873895235230307321
,0.8621490750294389382446525
,0.8684339626693543534585729
,0.8747188503092697686724932
,0.8810037379491851838864136
,0.8872886255891005991003340
,0.8935735132290160143142543
,0.8998584008689314295281747
,0.9061432885088468447420951
,0.9124281761487622599560154
,0.9187130637886776751699358
,0.9249979514285930903838562
,0.9312828390685085055977765
,0.9375677267084239208116969
,0.9438526143483393360256173
,0.9501375019882547512395377
,0.9564223896281701664534580
,0.9627072772680855816673784
,0.9689921649080009968812988
,0.9752770525479164120952191
,0.9815619401878318273091395
,5.9237991181400246887278627
,5.7556698184065977486056909
,5.5924037964312507398290109
,5.4338068718159631131925380
,5.2799179309300310336539042
,5.1298579390851175574539411
,4.9843161235435458067399850
,4.8429021518730150930309719
,4.7054997616812404004349446
,4.5719958355111600667441962
,4.4422802924280508918286614
,4.3162460122302572784747099
,4.1937887789289689521865512
,4.0748072327202713438509818
,3.9592028227928892647469183
,3.8468797563942933592784357
,3.7377449422008268697936728
,3.6317079279754524989698439
,3.5286808336951747122611778
,3.4285782818660828219492487
,3.3313173267763596108181900
,3.2368173841541172386371272
,3.1450001622717875804369214
,3.0557895956116949420788842
,2.9691117678665106538460350
,2.8848949129777263777896223
,2.8030692229657598879555280
,2.7235669027478537351782961
,2.6463221268651211381950361
,2.5712708892725784082244900
,2.4983510159459827448813485
,2.4275020986182656024254811
,2.3586654447725639016653076
,2.2917840290403139746899797
,2.2268024459690880512141575
,2.1636668641261329604219554
,2.1023249815033238085959510
,2.0427259821896108782368628
,1.9848204942629386060559682
,1.9285605489284769475943904
,1.8738995407229330769638409
,1.8207921889509095514370074
,1.7691945001637323642285082
,1.7190637317174866094404706
,1.6703583563680519663563473
,1.6230380278737239763131583
,1.5770635475768863820178467
,1.5332000305886628321871967
,1.4898072466871918884123716
,1.4476493006057071788461599
,1.4066912688598580682963757
,1.3668992222179825457573088
,1.3282401976047071290309987
,1.2906821708062004017136815
,1.2541940299546041615030845
,1.2187455497697816664270931
,1.1843073665371817160263390
,1.1508509538012445805321704
,1.1183485987543748674255539
,1.0867733793020899479842001
,1.0560991417855527529923165
,1.0263004793432366490435470
,0.9973527108940420937699400
,0.9692318607247036865715017
,0.9419146386648623581194784
,0.9153784208337025773971618
,0.8896012309425316288979957
,0.8645617221382118078309986
,0.8402391593728169016941365
,0.8166134022853773766215113
,0.7936648885820478671604405
,0.7713746179014978610055664
,0.7497241361527574587952927
,0.7286955203131942893080009
,0.7082713636746886809447687
,0.6884347615264647668453790
,0.6691692972633966896012225
,0.6504590289089821064649755
,0.6323117973510529177261219
,0.6146666175150449218378412
,0.5975315414148287818107974
,0.5808923984082026148456634
,0.5647354308796127542180443
,0.5490472830435009221616838
,0.5338149900997829488957791
,0.5189975288646822004778869
,0.5046387818881008513471897
,0.4906992283060692128238145
,0.4771673671557126183984110
,0.4640320396940341707292532
,0.4512824206713234032051218
,0.4389412439029707901916311
,0.4269326644452986485589463
,0.4152792277294680700627794
,0.4039713554214384716445352
,0.3929997624703418512837061
,0.3823554500916800935605977
,0.3720296990557196981086463
,0.3620140632827913984570500
,0.3523003637483103078764657
,0.3428806827015898894828183
,0.3337473582039404140786587
,0.3248929789931613854037096
,0.3163103796833602876503733
,0.3079926363110889186991415
,0.2999330622410686930656709
,0.2921252044472804620944828
,0.2845628401879267688201480
,0.2772399740958231273424417
,0.2690880487749667815400301
,0.2622215808779372325787449
,0.2555779111362819766561927
,0.2502314173040979250473015
,0.2440239240614804072659894
,0.2380246282301801408198827
,0.2322290858089441079048498
,0.2266330757299593046116826
,0.2212326022718948126399852
,0.2160238982389129369643399
,0.2110034288979175109979280
,0.2061678966479290886493203
,0.2023569509193888782405679
,0.1978878885498378814578047
,0.1935954364141548311728513
,0.1894773232764396797556117
,0.1855315632142308379659568
,0.1817564709598789296496335
,0.1781506797165028355145466
,0.1747127413786051519650755
,0.1714429807176852671446454
,0.1683405060455205881631002
,0.1654054833009588609815665
,0.1626385340712511173855148
,0.1600407795492362894584915
,0.1576138911604278991518413
,0.1553601491124053934900218
,0.1532825082035376984546104
,0.1513846752037063259077598
,0.1496711980696104060672980
,0.1482195864695917131292902
,0.1468930162326109178927425
,0.1457706193241123659998237
,0.1448615078887084961500875
,0.1441763352973645662125080
,0.1437275105184336876362750
,0.1435294429517294245712833
,0.1435988256505531246443041
,0.1439549596289489974410003
,0.1446201217031331809348416
,0.1456199874527705495630414
,0.1469840951694110220415723
,0.1487463637123903892334198
,0.1509456575041616954724333
,0.1536263602732061694933208
,0.1568389632009177248050946
,0.1606405943783746348429986
,0.1650954157544717582073446
,0.1702747829292378389798301
,0.1762570034546639408112867
,0.1831264624045224054249559
,0.1908911498456132005419050
,0.1998040852471379691390752
,0.2098698255496212750070839
,0.2211645971217089667870681
,0.2337455357939917099940885
,0.2476399380824678697621266
,0.2628335117117531205543912
,0.2792593632493008959372105
,0.2967903423871076640239153
,0.3152377925734036745453182
,0.3343593529315622148168075
,0.3538767108950234274722391
,0.3735013940532654341808438
,0.3929637318785553223854379
,0.4120384383122322469183985
,0.4305609519477294755418484
,0.4484316119478075624016356
,0.4656087134418597228702197
,0.4820952738297646367193749
,0.4979186096925006799196467
,0.5131228938741341227824933
,0.5277535001397930525257607
,0.5418528211202006117375163
,0.5554578795736635488111688
,0.5686000887584339302804892
,0.5813060135547748474849072
,0.5935983877981977352433773
,0.6054970265254264738530310
,0.6170195248907083263034679
,0.6282810934961842175283664
,0.6389982289247856384051261
,0.6494823223038613813073994
,0.6596464819060312567700066
,0.6695023501782749741906287
,0.6790608738759880136370839
,0.6883323877515129529669480
,0.6973266821244309410232631
,0.7060530593687379674605609
,0.7145203828736729212423029
,0.7227371190113452970038566
,0.7307113687569313231762180
,0.7384508849812801978274024
,0.7459630792323581616187766
,0.7532550367937617119551419
,0.7603335670184501182689019
,0.7672052970168011798435259
,0.7738767661674074149757985
,0.7803544290762575164066561
,0.7866444858347582114177499
,0.7927525686453917863616425
,0.7988606514560253613055352
,0.8049687342666589362494278
,0.8110768170772925111933205
,0.8171848998879260861372131
,0.8232929826985596610811058
,0.8294010655091932360249984
,0.8355091483198268109688911
,0.8416172311304603859127837
,0.8477253139410939608566764
,0.8538333967517275358005691
,0.8599414795623611107444617
,0.8660495623729946856883544
,0.8721576451836282606322470
,0.8782657279942618355761397
,0.8843738108048954105200323
,0.8904818936155289854639250
,0.8965899764261625604078176
,0.9026980592367961353517103
,0.9088061420474297102956029
,0.9149142248580632852394956
,0.9210223076686968601833883
,0.9271303904793304351272809
,0.9332384732899640100711736
,0.9393465561005975850150662
,0.9454546389112311599589589
,0.9515627217218647349028515
,0.9576708045324983098467442
,0.9637788873431318847906368
,0.9698869701537654597345295
,0.9759950529643990346784221
,0.9821031357750326096223148
,6.0618288295768136819674510
,5.8898687788771830753375980
,5.7227106956535749304748606
,5.5604358756725131840426002
,5.4030166084053261599251528
,5.2496566581465637923997747
,5.1004848126740007785429043
,4.9557789084116983246985910
,4.8151775649164987314065911
,4.6785651558032901320416386
,4.5458291556607202110740218
,4.4168600496919028230990989
,4.2915512705043186159059587
,4.1697991490199690645113151
,4.0515028696238362115877862
,3.9365644230712901752156085
,3.8248885537852568283767596
,3.7163827006410370401567889
,3.6109569320113394930160666
,3.5085238767454001163059729
,3.4089986530214999582710789
,3.3122987968371391254152059
,3.2183441914877817247031544
,3.1270570015397973762105721
,3.0383615918516677645300206
,2.9521845012000049734979257
,2.8684543353355405059801342
,2.7871016966973001238727647
,2.7080592345333553971897800
,2.6312614525075228577577491
,2.5566447296795424826143517
,2.4841472520111529398434413
,2.4137089612066136012913375
,2.3452715049883221531956679
,2.2787781887707558858835455
,2.2141739286987140999940493
,2.1514052060157604628898298
,2.0904200227280296253695724
,2.0311678585193488899562908
,1.9735996289394044378440185
,1.9176676446757818794708328
,1.8633255721011163785760800
,1.8105283948776536018243632
,1.7592323766681732255534598
,1.7093950249083240677805406
,1.6609750556101507967809994
,1.6139323591675878155626833
,1.5682279671356487149580516
,1.5246256258878208011964261
,1.4814885044355519116976438
,1.4395793311230553612745098
,1.3988633888695884976982597
,1.3593069493379179579761740
,1.3208772450068919646071208
,1.2835424420414829338454865
,1.2472716139379618205396127
,1.2120347159225179911601344
,1.1778025600822761287389540
,1.1445467912082889494485016
,1.1122398633306795900921315
,1.0808550169267081564328237
,1.0503662567831200114198964
,1.0207483304946831648152283
,0.9919767075813841206155530
,0.9640275592072911070573582
,0.9368777384846196376599892
,0.9105047613470503842236781
,0.8848867879768765876136172
,0.8600026047710401799761826
,0.8358316068316193891973853
,0.8123537809668346376668069
,0.7895496891890874113784093
,0.7674004526970497064297660
,0.7458877363292409912176595
,0.7249937334769827046443424
,0.7047011514450097768857972
,0.6849931972483866982059908
,0.6658535638347570229100825
,0.6472664167212976993326379
,0.6292397807650279561997309
,0.6117126196456641462617654
,0.5946931639298924654468692
,0.5781673433850021970314970
,0.5621214993313247143547073
,0.5465423735682919392786516
,0.5314170976554859482376969
,0.5167046517131995697624802
,0.5024491943150994899269790
,0.4886112081343976787373151
,0.4751792849451579314745686
,0.4621423582064573265526519
,0.4494896945029334678345379
,0.4372442279796449615680842
,0.4253299917878313185504169
,0.4137697282734216219779455
,0.4025539511796572544888306
,0.3916734680655495348666761
,0.3811193735072764821047997
,0.3708830426201913388339904
,0.3609561249050008968630721
,0.3513305384230164252201689
,0.3419984643069002849813387
,0.3329523416150629300247488
,0.3241848625398398575647718
,0.3156889679818124516685884
,0.3074578435051374403208513
,0.2994849156915220245167575
,0.2917638489135008228458901
,0.2842885425510492392042750
,0.2770531286792962122333961
,0.2689898368805135331349732
,0.2622119879435858003091653
,0.2556577448293068099971492
,0.2504010981011623448999615
,0.2442851770134262523459512
,0.2383787665568469771315563
,0.2326776106143310374196886
,0.2271776892037399020463084
,0.2218752224285618079857585
,0.2167666753518972255765362
,0.2118487638023583141677619
,0.2079563365268976560251701
,0.2034164155739313639692512
,0.1990589354314076797614064
,0.1948817011649209285373274
,0.1908828226369644887050470
,0.1870607317223293708519094
,0.1834142022441558605994061
,0.1799417683174301119120031
,0.1766443791973896781932751
,0.1735211062522664104967873
,0.1705723834106385172759701
,0.1677991382414104337694738
,0.1652028409000596276268169
,0.1627855603803716744160113
,0.1605500294477070766241411
,0.1584997173850750118440089
,0.1566389154423172280772292
,0.1549728351263670311777076
,0.1535077203845920390534729
,0.1523233440403759242354198
,0.1512843657488747162176423
,0.1504727041588470870525640
,0.1499002504553580694679482
,0.1495808122396927730690663
,0.1495303767426754415481582
,0.1497674132385526934996278
,0.1503132164386586089310782
,0.1511922919856574232255753
,0.1524327941770930727738431
,0.1540669972511204965925913
,0.1561318100380400253346380
,0.1586693201507932970972803
,0.1617273186139916718584431
,0.1653597997633668992278899
,0.1696273446962832387452380
,0.1745972921126349719500581
,0.1803435662495415370276675
,0.1868652438002565141506039
,0.1944090381072312023746917
,0.2029795876451764014003487
,0.2126606423569224468828054
,0.2235278668309726435303730
,0.2356410875685876482599213
,0.2490347093400932521056745
,0.2637069252878287972663429
,0.2796090608896713569642145
,0.2966371775881143091346814
,0.3146286569471679062104386
,0.3333663693723458165685258
,0.3525919494460149627990120
,0.3720274560539842956252699
,0.3914019679857805300571272
,0.4104775647391531445684620
,0.4290688258444684821668602
,0.4470518581878192287959450
,0.4643621487673364467418935
,0.4809851083041917219063066
,0.4969357158632549675836287
,0.5122528776583504805941516
,0.5269805190291422247739206
,0.5411621404137061386308005
,0.5548369619450070899802085
,0.5680387433371906213963598
,0.5807960911613514465301478
,0.5931333496776964864238835
,0.6050463909236218906784188
,0.6166292015079122279530566
,0.6278771400772553690217137
,0.6386676044330183987796090
,0.6491772157435412582415779
,0.6593645002164929547205929
,0.6692413907324366029172324
,0.6788190777859616220624162
,0.6881081032255907947714491
,0.6971184351135174539493278
,0.7058595290262424937210994
,0.7143403798068849175351147
,0.7225695659604617349103250
,0.7305552861744215586980999
,0.7383053854979840791017409
,0.7458273710604441664173692
,0.7531284256882282424072628
,0.7602154370090328239228938
,0.7670950562808219741484095
,0.7737737746076023270802580
,0.7802579641548582634058562
,0.7865538150416042650903137
,0.7926671456370386614764811
,0.7986031757107422413000108
,0.8045392057844458211235406
,0.8104752358581494009470703
,0.8164112659318529807706000
,0.8223472960055565605941297
,0.8282833260792601404176594
,0.8342193561529637202411891
,0.8401553862266673000647188
,0.8460914163003708798882485
,0.8520274463740744597117782
,0.8579634764477780395353079
,0.8638995065214816193588376
,0.8698355365951851991823673
,0.8757715666688887790058970
,0.8817075967425923588294268
,0.8876436268162959386529565
,0.8935796568899995184764862
,0.8995156869637030983000159
,0.9054517170374066781235456
,0.9113877471111102579470753
,0.9173237771848138377706050
,0.9232598072585174175941347
,0.9291958373322209974176644
,0.9351318674059245772411941
,0.9410678974796281570647238
,0.9470039275533317368882535
,0.9529399576270353167117833
,0.9588759877007388965353130
,0.9648120177744424763588427
,0.9707480478481460561823724
,0.9766840779218496360059021
,0.9826201079955532158294318
,6.2016645980233766621836367
,6.0257426597490644226695622
,5.8547207468834621124642581
,5.6886549295973027895456653
,5.5273416939784585366624015
,5.3708316863266025720236030
,5.2181749968159625296948434
,5.0701344515408219848495719
,4.9262925799232064605348569
,4.7865312172508538424153812
,4.6507353741329326979325742
,4.5187931262843665791706371
,4.3905955407832797376954659
,4.2660366235317628280654390
,4.1450132756226008012845341
,4.0274252499253684334235004
,3.9131751027668775222423392
,3.8021681386044869910278976
,3.6943123478092663170002652
,3.5895183390268958767421736
,3.4876992681636260762445545
,3.3887707660431134470968573
,3.2926508664209492849295202
,3.1992599355325124221849364
,3.1085206034434849087233488
,3.0203576961003548717599188
,2.9346982042736011742078972
,2.8514711251456184015751205
,2.7706075090363948554283979
,2.6920404047031505356812886
,2.6157047076371484628509734
,2.5415371797133050613126670
,2.4694763790614873144591002
,2.3994626092072040002278754
,2.3314378696392483725219336
,2.2653458077699171191454752
,2.2011316722540343882030811
,2.1387422676322032089046843
,2.0781259102638771629756320
,2.0192323855008913469077925
,1.9620129061304589779268781
,1.9064200718998740580190088
,1.8524078302986337618563084
,1.7999314383983007203937632
,1.7489474257914645605183068
,1.6994135585858418657778657
,1.6512888044235756179745067
,1.6045332984967968226186485
,1.5591083105313690015947259
,1.5157761844937871487104530
,1.4729035790563642649431131
,1.4312518121429615991502260
,1.3907863802856403889762760
,1.3514737630797017953199202
,1.3132813954315334381561797
,1.2761776405996467786962967
,1.2401317640067188730057524
,1.2051139078011394722977911
,1.1710950661471652978207203
,1.1380470612234259153439098
,1.1059425199101287073943922
,1.0747548511458990816436199
,1.0444582239357818043146153
,1.0150275459924722465387958
,0.9864384429934337505940789
,0.9586672384370644728335265
,0.9316909340816409423879918
,0.9054871909512649530427097
,0.8800343108935784197655039
,0.8553112186744972200713732
,0.8312974445957479474600405
,0.8079731076214632379262071
,0.7853188990005978142860954
,0.7633160663724004590946492
,0.7419463983426253239628068
,0.7211922095186075187811525
,0.7010363259917099520990291
,0.6814620712560215398667651
,0.6624532525525441695180007
,0.6440169509200631692280581
,0.6260929730095176060089557
,0.6086886399602631225747018
,0.5917895653305473846472751
,0.5753817841078316952518890
,0.5594517414042474712232433
,0.5439862815172721299816772
,0.5289726373490903910123961
,0.5143697947229021183446207
,0.5002221988093260574004262
,0.4864903383528610403274683
,0.4731629032672989843000266
,0.4602289247667560312393675
,0.4476777669981863994053128
,0.4355325727758469489536708
,0.4237172546762026925648570
,0.4122547607536893310431481
,0.4011357034808011312598808
,0.3903509899807777738800496
,0.3798918154816787184913096
,0.3697496571099146978056638
,0.3599162680290580729192129
,0.3503836719313876968406873
,0.3411441578914770067498807
,0.3321902755932618633849529
,0.3235148309444392800138246
,0.3151108820947856048455549
,0.3069717358780290616948605
,0.2990909447002544352400832
,0.2914623039015402095053275
,0.2840798496216175306194884
,0.2769378572050703590790022
,0.2689693696400746181218722
,0.2622865206614732325185457
,0.2558283142282805067146967
,0.2506683464528880467270255
,0.2446511314465024122810632
,0.2388450441118346589952637
,0.2332460452414841234336507
,0.2278503478326013298449482
,0.2226544229138932573519583
,0.2176550065039625780904942
,0.2136821065024646082441961
,0.2090725719430897022732552
,0.2046515108835197660486216
,0.2004168159343606703259866
,0.1963667052742161245326713
,0.1924997418798795878469576
,0.1888148557371563118767455
,0.1853105093262608082937959
,0.1819884595811357419492538
,0.1788476633982395980204672
,0.1758888481410026127793600
,0.1731132750877040493708847
,0.1705227937220012701668992
,0.1681199039822671159605250
,0.1659078279695155033746090
,0.1638905899988018222135366
,0.1620731105062426513629958
,0.1604613137809186296234287
,0.1590622505730500957366047
,0.1578842398915448752561019
,0.1569370325245751929266191
,0.1563053769934534542596083
,0.1558564163431192806097414
,0.1556781338463714692288420
,0.1557881756116846205806326
,0.1562068684946991137252326
,0.1569575789489187911396328
,0.1580671107562955091108137
,0.1595661496014098013063176
,0.1614897303521391214164993
,0.1638777326651648935662564
,0.1667753825477160944945609
,0.1702336984847892531469427
,0.1743098643750069232094546
,0.1790674174896838832804491
,0.1845761322598259979166357
,0.1908318865190497537476233
,0.1980746141786319247657389
,0.2063063108677005152991057
,0.2156078601009080442096888
,0.2260538885405566911224184
,0.2377060021247585641646083
,0.2506042862796051817753096
,0.2647574881273069280496202
,0.2801328896635284504412766
,0.2966475843693555103364190
,0.3141634727000508497951614
,0.3324884838442372370082012
,0.3513858415178927607769310
,0.3705915853496565270930319
,0.3898381660837743623027052
,0.4088796951640972787700434
,0.4275133945906394727920485
,0.4455926663538742338310783
,0.4630296698873165861520818
,0.4797902708063940258043090
,0.4958741686180794805416383
,0.5113125825486039000011829
,0.5261460806902483744451615
,0.5404181414238834468832806
,0.5541697088484419664311531
,0.5674368408908117000777338
,0.5802503431503481801101429
,0.5926363834998036317358583
,0.6046055123935335506857314
,0.6162129744338061820840835
,0.6274681666935802981655002
,0.6383155437298880796603839
,0.6488525069962909341825252
,0.6590645444489716675562363
,0.6689639115529341095722771
,0.6785620677865222827307434
,0.6878697821824937275181355
,0.6968972167960045815959802
,0.7056539941492564471658966
,0.7141492530765306545603721
,0.7223916960052834124184074
,0.7303896288856340790474064
,0.7381509930590697265984090
,0.7456833882150932790722209
,0.7529940894083998470520669
,0.7600900679150389693816692
,0.7669780285224246929587366
,0.7736644649666740702897982
,0.7801557092550016614396213
,0.7864579269969808050788629
,0.7925770209729287030242517
,0.7985184677315689816268218
,0.8042872020247399111880782
,0.8100559363179108407493345
,0.8158246706110817703105909
,0.8215934049042526998718472
,0.8273621391974236294331035
,0.8331308734905945589943599
,0.8388996077837654885556162
,0.8446683420769364181168726
,0.8504370763701073476781289
,0.8562058106632782772393853
,0.8619745449564492068006416
,0.8677432792496201363618979
,0.8735120135427910659231543
,0.8792807478359619954844106
,0.8850494821291329250456670
,0.8908182164223038546069233
,0.8965869507154747841681797
,0.9023556850086457137294360
,0.9081244193018166432906924
,0.9138931535949875728519487
,0.9196618878881585024132050
,0.9254306221813294319744614
,0.9311993564745003615357177
,0.9369680907676712910969741
,0.9427368250608422206582304
,0.9485055593540131502194868
,0.9542742936471840797807431
,0.9600430279403550093419994
,0.9658117622335259389032558
,0.9715804965266968684645121
,0.9773492308198677980257685
,0.9831179651130387275870248
,6.3432515007931717931910498
,6.1633175081939253203699991
,5.9884875123540544095135374
,5.8185325588254475093208384
,5.6535552935835777788042833
,5.4935310623678477170983570
,5.3376027996765644800802875
,5.1859235199696103180144746
,5.0388008774679207135704928
,4.8958513797876763717908943
,4.7569575521491032077392447
,4.6220050463741859658739486
,4.4908825519314632401801646
,4.3634817368009635174530558
,4.2396972033375313060332701
,4.1194264479659343791695392
,4.0025698174793742367683080
,3.8890304582936252586478076
,3.7787142578254968583451046
,3.6715297790481224993186515
,3.5673881902576725089204501
,3.4662031923351395157339994
,3.3678909455375909409724500
,3.2723699973445166122587580
,3.1795612137952793396777906
,3.0893877020558138113415225
,3.0017747816088649059906857
,2.9166498542357857104434515
,2.8339423729461383771877081
,2.7535838709262141499323207
,2.6755077575950716450847722
,2.5996493529945645661882736
,2.5259458144368793774958704
,2.4543360844984385416012174
,2.3847608404696307715653347
,2.3171624452250751957649300
,2.2514848994810017224210696
,2.1876737954055798240915465
,2.1256762715482944159361978
,2.0654409690332280469249326
,2.0069179890701103197159227
,1.9500588515347794249521485
,1.8948164548740886736766242
,1.8411450370727560077455109
,1.7890001377485784672671798
,1.7383385613270836422827870
,1.6891183412649541928374219
,1.6412987052925436248784763
,1.5948400416468151430393618
,1.5504990286951210176624727
,1.5066510878539112194829386
,1.4640519438105863425647613
,1.4226663084101824896521293
,1.3824598990922090102628772
,1.3433994105087259107733644
,1.3054524869539312348365456
,1.2685876955825508005659685
,1.2327745003950527635794288
,1.1979832369683469650567531
,1.1641850879112485284139211
,1.1313520590246386454680305
,1.0994569561468332530296266
,1.0684733626652864746375826
,1.0383756176763205836266479
,1.0091387947751517817351896
,0.9807386814590404178204608
,0.9531517591269206279847026
,0.9263551836594409172320752
,0.9003267665638295946806124
,0.8750449566685631896945097
,0.8504888223533192403991166
,0.8266380343002063257884515
,0.8034728487527862395012335
,0.7809740912698986958773162
,0.7591231409617864578365243
,0.7379019151964727463166582
,0.7172928547647871022618915
,0.6972789094927974717919028
,0.6778435242907833169212495
,0.6589706256282171770166656
,0.6406674942026282515428193
,0.6228738888111430282990000
,0.6055973246496906270408545
,0.5888235270800735721152819
,0.5725386413838923216346188
,0.5567292216021507700318693
,0.5413822197441253702976383
,0.5264849753596267944999454
,0.5120252054694028887027457
,0.4979614846621892576550295
,0.4843404786977484888232937
,0.4711222588165853153441276
,0.4582959600018421952860592
,0.4458510501925751490226446
,0.4338108896475272868720197
,0.4220992725334901662925802
,0.4107393619123491657063596
,0.3997218763287293530339639
,0.3890378301754412460056187
,0.3786785274409222301628120
,0.3686355558191158343639415
,0.3589007811903788813800986
,0.3494663424839920540243554
,0.3403246469351342562426055
,0.3314683657517852322094143
,0.3228904302099965817340887
,0.3145840281993105835844915
,0.3065426012437875158411771
,0.2987598420282286393323545
,0.2912296924636504913408430
,0.2839463423312035827983379
,0.2769042285492349653175381
,0.2690372505373316291965580
,0.2624563422857928984832654
,0.2561013809971693921951896
,0.2510455430640966545396964
,0.2451348538499060203399438
,0.2394372648558481253555641
,0.2339489879415765916093051
,0.2286665066984759631107949
,0.2235865845829285991630542
,0.2195343472052388444915039
,0.2148565744041860958724044
,0.2103735137399071475350354
,0.2060831570478227903198132
,0.2019838438164448524148042
,0.1980742825730217593349636
,0.1943535755224320427103635
,0.1908200366080071708196897
,0.1874764678432362385862575
,0.1843216029883747997253352
,0.1813564892201508516045294
,0.1785827501045286480607643
,0.1760026455744807538650321
,0.1736191405294008616166934
,0.1714359836765907696420896
,0.1694577952069811488389206
,0.1676901694804867060106801
,0.1661397924690808935999087
,0.1648145749746482147113369
,0.1637238062054978127157767
,0.1628783302222881201881677
,0.1622907491409317226604969
,0.1619756501654319447158770
,0.1619498697160186850840802
,0.1623078111217641783525778
,0.1629223572712631129544292
,0.1638933502104705230983939
,0.1652499344183749607761769
,0.1670253439450141152988749
,0.1692573518175573832333924
,0.1719887277263910108082712
,0.1752676716476977702985351
,0.1791481483575047550793613
,0.1836109714740286336098762
,0.1888804348594596838051274
,0.1949487832251256269611162
,0.2018917742543436255608924
,0.2097877165354294914934030
,0.2187145199267337691839685
,0.2287453860782852899102835
,0.2399429269349624693763445
,0.2523516611326618308552838
,0.2659891514736761330972570
,0.2808365239980596950175595
,0.2968297192490376157358867
,0.3138534235836116237372551
,0.3317399441284732963808324
,0.3502750239093157524905564
,0.3692114037635304546469683
,0.3882890479228862101734876
,0.4072587548544217561641290
,0.4259043951864702193255141
,0.4440590371450806039810288
,0.4616119264400180832730314
,0.4785059621319355804835993
,0.4947292007609228048359284
,0.5102963619081506418950767
,0.5252445373645906467885425
,0.5396156819057772446868171
,0.5534516798180466601309035
,0.5667906401884238443145136
,0.5796656313893882028764892
,0.5921048357849785226392214
,0.6041274895327246596821169
,0.6157688670145700093883079
,0.6270328053077426355699231
,0.6379405019789697872667489
,0.6485068132478358782222472
,0.6587453692968041618627240
,0.6686687855957296200415385
,0.6782888196727334673141740
,0.6876164907658702807324858
,0.6966621734402749233083796
,0.7054356724291367397583485
,0.7139462837462215993866721
,0.7222028456734815859974219
,0.7302137818488543263839574
,0.7379871371312939354325522
,0.7455306059312966082686103
,0.7528515538157266595575834
,0.7599570371039848781791193
,0.7668538291142645846321102
,0.7735484592264318948195978
,0.7800472570394638704982526
,0.7863563739891324955166851
,0.7924817479112823415121625
,0.7984290033517720264200079
,0.8042033415670895024618403
,0.8098095313640705228408478
,0.8154157211610515432198554
,0.8210219109580325635988629
,0.8266281007550135839778704
,0.8322342905519946043568780
,0.8378404803489756247358855
,0.8434466701459566451148930
,0.8490528599429376654939006
,0.8546590497399186858729081
,0.8602652395368997062519156
,0.8658714293338807266309232
,0.8714776191308617470099307
,0.8770838089278427673889382
,0.8826899987248237877679458
,0.8882961885218048081469533
,0.8939023783187858285259608
,0.8995085681157668489049684
,0.9051147579127478692839759
,0.9107209477097288896629834
,0.9163271375067099100419910
,0.9219333273036909304209985
,0.9275395171006719508000060
,0.9331457068976529711790135
,0.9387518966946339915580211
,0.9443580864916150119370286
,0.9499642762885960323160361
,0.9555704660855770526950437
,0.9611766558825580730740512
,0.9667828456795390934530587
,0.9723890354765201138320663
,0.9779952252735011342110738
,0.9836014150704821545900813
,6.4865309012856560144655305
,6.3025360541377768441861917
,6.1237623562738123794702005
,5.9499600240337109369193058
,5.7812034908712472969227747
,5.6172795450177774867484004
,5.4582493795568085559466454
,5.3030976626691277431291383
,5.1526554295717090781181469
,5.0064799953563436929471209
,4.8644513752043945231662292
,4.7264527821967421417070909
,4.5923705176232099134381315
,4.4620939012869937911887064
,4.3355152244546752982046200
,4.2125297115882087695126756
,4.0930354811902249778654550
,3.9769335001980183896819199
,3.8641275298111392721978063
,3.7545240631305976108933464
,3.6480322564657448047853450
,3.5445638567522732564896160
,3.4440331274541522432741658
,3.3463567748595566264668832
,3.2514538760656912508295591
,3.1592458077533418503435314
,3.0696561906346619963414923
,2.9826108128000243802091518
,2.8980375134670630643540790
,2.8158662896939192776812888
,2.7360290481988327471185585
,2.6584596500535710994483907
,2.5830938351003220887491807
,2.5098691687873664335484136
,2.4387249904900896169124280
,2.3696023632802325487034523
,2.3024440251101299104163900
,2.2371943413783688114904180
,2.1737992588418917350168158
,2.1122062608259799532106626
,2.0523643237767204006161137
,1.9942238748998404318513167
,1.9377367511719043591256195
,1.8828561594251149724499328
,1.8295366375887001098021756
,1.7777340170344668734969673
,1.7274053859949634048831513
,1.6785090540239013812140456
,1.6310045174694685066185684
,1.5848524259320297957742696
,1.5408080016582426097215830
,1.4972503302200339536653928
,1.4549336711253313403346965
,1.4138229707101628296328499
,1.3738841746921783837365183
,1.3350841999817262273353435
,1.2973909072997640290481058
,1.2607730745801506433423356
,1.2252003711345067493709848
,1.1906433325584793170293096
,1.1570733363589054132347655
,1.1244625782819714920890419
,1.0927840493230873697427796
,1.0620115133997869438786665
,1.0321194856695450337014108
,1.0030832114749763661620818
,0.9748786458994453951731884
,0.9474824339166665332356843
,0.9208718911184059496832788
,0.8950249850049646349603449
,0.8699203168236183669748129
,0.8455371039407613142913078
,0.8218551627339988341347521
,0.7988548919909799206351408
,0.7765172568022710164470368
,0.7548237729360651737664512
,0.7337564916829854011481871
,0.7132979851596684683912031
,0.6934313320601839247814269
,0.6741401038446804827586334
,0.6554306562550584747128823
,0.6372435631144315326679362
,0.6195854492388027656701865
,0.6024417272250981447712093
,0.5857982395320293633744768
,0.5696412470981239151157638
,0.5539574183399131879212973
,0.5387338185245234001286008
,0.5239578995115666826265510
,0.5096174898599383773500904
,0.4956711735790163553261323
,0.4821659279241836681961786
,0.4690618347993782411009533
,0.4563481394890901987615450
,0.4440144205223431894680175
,0.4320842649591637441019998
,0.4204813515235521492741100
,0.4092290682184992478553909
,0.3983182477905923835059809
,0.3877400204647499792898202
,0.3774858080330467657859117
,0.3675473183339331706420694
,0.3579165401338145202636554
,0.3485857384253964741382958
,0.3395474501600047601002075
,0.3307944804343025957393820
,0.3223198991554779291313082
,0.3141170382130071270232463
,0.3061794891896733039615697
,0.2985011016494187874315003
,0.2910759820452236135146507
,0.2838984932959535689711572
,0.2769632550897229150699275
,0.2692050879152040887554165
,0.2627336837968723970426765
,0.2564898433446747283426248
,0.2515462747848027369457213
,0.2457506994476776618352432
,0.2401706123428229422422930
,0.2348025166017266296414334
,0.2296432108005831695951571
,0.2255128964140369340896086
,0.2207683886040528731253829
,0.2162250408001351875686424
,0.2118809561238576000263834
,0.2077346087655457806953052
,0.2037848676640092726586317
,0.2000310237230443211053910
,0.1964711358712193101094812
,0.1931093570619737964655371
,0.1899440496845042625206901
,0.1869766079114058565657785
,0.1842090468534205993655917
,0.1816440685463965032386824
,0.1792851372223181194431874
,0.1771365655986047726866417
,0.1752036104326645249429362
,0.1734925842177324206705435
,0.1720109824852535940209464
,0.1707676276537571369296131
,0.1697728342381926991411234
,0.1690385978275920353386397
,0.1685788115319365731981094
,0.1684095061550880956247056
,0.1685491276548925221323572
,0.1690188439232984951576810
,0.1698428865896895179066206
,0.1710489263769621737232285
,0.1726684722295110940848417
,0.1747372965220039819911335
,0.1772958549610595957446435
,0.1803896833543468247729180
,0.1840697320277410453659428
,0.1883925608705439291856720
,0.1934203262686654822832821
,0.1992204202926505240967003
,0.2058646077415056674375649
,0.2134274594038606531753999
,0.2219838438095347865619544
,0.2316052284003951577950886
,0.2423545794117762108843550
,0.2542797662603768493738698
,0.2674056159972080792819327
,0.2817251463908755915177551
,0.2971910214695211993607415
,0.3137088309857657963952704
,0.3311341972568758174055858
,0.3492756744340203556298263
,0.3679046961006535165772391
,0.3867722907548090116591766
,0.4056303843539099118764568
,0.4242537876628173498794183
,0.4424583445581600771312480
,0.4601116161296964768290252
,0.4771345482352429834271845
,0.4934968745805349277233631
,0.5091988129809605911901826
,0.5242700687258828873282823
,0.5387492203297673531992018
,0.5526779621097803740781274
,0.5660959502711250257434017
,0.5790384329801536722470701
,0.5915338810778913991583750
,0.6036137513848999214260971
,0.6152947012993604802844061
,0.6265979826974235056269436
,0.6375407959991427064849745
,0.6481386336800455394424603
,0.6584056273486496024816006
,0.6683547964885795389378131
,0.6779982303780813790439197
,0.6873472249043699466852786
,0.6964123882799132525533992
,0.7052037246578120033291270
,0.7137307016496421407936168
,0.7220023059459236280943628
,0.7300270899322435225187178
,0.7378132109377255609672375
,0.7453684636354286352499798
,0.7527003059439115739692738
,0.7598158804870469573700120
,0.7667220366906924988725791
,0.7734253595373730139073132
,0.7799322051817922929473070
,0.7862487304987343383899656
,0.7923808921819482931070411
,0.7983343975174679307826864
,0.8041146232800273629948151
,0.8097265677820891793814440
,0.8151749244313311049126014
,0.8206232810805730304437589
,0.8260716377298149559749163
,0.8315199943790568815060738
,0.8369683510282988070372312
,0.8424167076775407325683886
,0.8478650643267826580995461
,0.8533134209760245836307035
,0.8587617776252665091618610
,0.8642101342745084346930184
,0.8696584909237503602241759
,0.8751068475729922857553333
,0.8805552042222342112864908
,0.8860035608714761368176482
,0.8914519175207180623488057
,0.8969002741699599878799631
,0.9023486308192019134111206
,0.9077969874684438389422780
,0.9132453441176857644734355
,0.9186937007669276900045929
,0.9241420574161696155357504
,0.9295904140654115410669078
,0.9350387707146534665980653
,0.9404871273638953921292227
,0.9459354840131373176603802
,0.9513838406623792431915376
,0.9568321973116211687226951
,0.9622805539608630942538525
,0.9677289106101050197850100
,0.9731772672593469453161674
,0.9786256239085888708473249
,0.9840739805578307963784823
,6.6314405514751744163959302
,6.4433374741185449607883129
,6.2605747211357165582512607
,6.0829957950282382839191087
,5.9103616135650609564322622
,5.7427957115112304720128122
,5.5802750972457815237248724
,5.4218858736729114156105425
,5.2678061752691807129167501
,5.1183684708193695200861839
,4.9731696706761576720623452
,4.8320905327845773413741881
,4.6950149604956941118416580
,4.5618299174915470928226569
,4.4324253746465727132886059
,4.3066942721282179817876568
,4.1845324843210702780993415
,4.0658387797130508545251359
,3.9505147719720441479296369
,3.8384648616084411365534379
,3.7295961696859021294869763
,3.6238184660652601465358202
,3.5210440948562018448342315
,3.4211878993919575542292932
,3.3241671484135384417868408
,3.2299014643712431471556101
,3.1383127472469518615127981
,3.0493251625750570354966840
,2.9628649430734737002524071
,2.8788604486158386741578852
,2.7972421435545458123783646
,2.7179423895869292415738983
,2.6408954930617620782129507
,2.5660376267300120112224704
,2.4933067769271026747901487
,2.4226426922310033695850962
,2.3539868335626685791339696
,2.2872823256959802229459910
,2.2224739101428112597602649
,2.1595078993787457655173512
,2.0983321323533736801891791
,2.0388959313384731331098010
,1.9811500598646560877824641
,1.9250466820029041858930441
,1.8705393227243345410926167
,1.8175828294073053115198491
,1.7661333344413261414729277
,1.7161482188966448170219792
,1.6675860772294974765372899
,1.6204066829938583715886580
,1.5745709555314553185212390
,1.5308326302701218413204742
,1.4875745426861546327756969
,1.4455494560152650773687810
,1.4047225586957683418631859
,1.3650600321605572684546814
,1.3265290228479935663585820
,1.2890976150149484613649520
,1.2527348043296993029827036
,1.2174104722230913999680979
,1.1830953609770049617111454
,1.1497610495298040689249319
,1.1173799299790914130170449
,1.0859251847626787412792737
,1.0553707644992935676953039
,1.0256913664711324596368058
,0.9968624137309373134385737
,0.9688600348168451281694047
,0.9416610440588170094500242
,0.9152429224610099112169337
,0.8895837991449897508289268
,0.8646624333392576300383325
,0.8404581969010783693008193
,0.8169510573571837630524328
,0.7941215614504271158580195
,0.7719508191800396046389210
,0.7504204883236116341294064
,0.7295127594294008588349243
,0.7092103412679832130649515
,0.6894964467326151202897222
,0.6703547791780044562415242
,0.6517919107243425047570895
,0.6337483715254214056145088
,0.6162309970268943226656688
,0.5992253240300043914956518
,0.5827173176797509901447825
,0.5666933602524089064189639
,0.5511402403287946061283264
,0.5360451423483570954076072
,0.5213956365399182724118532
,0.5071796692256863581249604
,0.4933558381075842103058449
,0.4799714429342625821028889
,0.4669865808500978654471680
,0.4543906145578177624422267
,0.4421732406202770193637264
,0.4303582830557033944707257
,0.4188693087828596062216491
,0.4077299415040998575854303
,0.3969311371948970323941808
,0.3864641514538738609196855
,0.3763205339896470991156718
,0.3664921235319968939592172
,0.3569710431834500763415008
,0.3477496962303641692138001
,0.3388207624360574099497967
,0.3301771948424949698619457
,0.3218122171114368712530052
,0.3137193214410152752869010
,0.3058922670990962822124004
,0.2983250796209319100071866
,0.2910120507246287124836215
,0.2839477390074180984669283
,0.2771269714938991435282389
,0.2694855819142290553891428
,0.2631319389917615159113495
,0.2570078401498092635080184
,0.2521854478432994373093834
,0.2465144365385257274603248
,0.2410617864078109795489269
,0.2358243392041741159914636
,0.2316173306166315060128369
,0.2268077154321338495535088
,0.2222059200144138324528598
,0.2178101711497926473715125
,0.2136190914449615230186197
,0.2096317254352289827235012
,0.2058475695217644174661586
,0.2022642837073277410908645
,0.1988877633118618648566667
,0.1957158014964943959501653
,0.1927501672622567718828890
,0.1899932970006151244923842
,0.1874483667806978448577837
,0.1851193745709469318239115
,0.1830112342318608587010687
,0.1811298791227095028588678
,0.1794823829309605267567918
,0.1780770968353646288573344
,0.1769238038127582679504002
,0.1760338950776942634757205
,0.1754205708624683168750380
,0.1750990689056067806106398
,0.1750869159133219277180160
,0.1754042156254177753371692
,0.1760739634533505237889983
,0.1771223918624227899876189
,0.1785793424625026215579737
,0.1804786510063183524454899
,0.1828585430603826555984170
,0.1857620013672062198040180
,0.1892370784759846713551923
,0.1933371037057830255090352
,0.1981206935743209107680940
,0.2036514804438857850765743
,0.2099974034349029738955039
,0.2172293932179086839440174
,0.2254192436857570813746321
,0.2346364450428185532970815
,0.2449437730573499338859733
,0.2563915150175897772477640
,0.2690103886664186871868765
,0.2828035191640036472016106
,0.2977382637458004244201959
,0.3137391741924066002056293
,0.3306838198234814951703697
,0.3484033329925884103772660
,0.3666891307382152409566345
,0.3853062005380676335875023
,0.4040116561979502085577565
,0.4225756077550013589672062
,0.4408003043906876250446203
,0.4585336939500376240985702
,0.4756750335888140779339039
,0.4921723697376363948485789
,0.5080150744503540982677237
,0.5232168813013330366246123
,0.5378129133554540031170177
,0.5518431893044413172333407
,0.5653481024105649899169634
,0.5783647935784348437238123
,0.5909251994199951063535536
,0.6030589072370026171299173
,0.6147905586005910638647265
,0.6261339058535199120214543
,0.6371145862164089290757829
,0.6477463354061276934459102
,0.6580438578129440552189067
,0.6680206292608380502784371
,0.6776891102176550996105675
,0.6870609037736034041543576
,0.6961468759951253693074591
,0.7049572499902165834129164
,0.7135016810606032988673064
,0.7217893179358230160147514
,0.7298288535735332205334203
,0.7376285678422401792531105
,0.7451963633561874411626036
,0.7525397950733734298012223
,0.7596660946553063231689862
,0.7665821922867227522502276
,0.7732947403281705822664094
,0.7798101417028063808700722
,0.7861345788667455369846948
,0.7922740292574329545871592
,0.7982342500047907574156625
,0.8040207296024610705842406
,0.8096386372695099087337667
,0.8150928316020448205492244
,0.8203879851338736761690029
,0.8256831386657025317887815
,0.8309782921975313874085600
,0.8362734457293602430283386
,0.8415685992611890986481171
,0.8468637527930179542678957
,0.8521589063248468098876742
,0.8574540598566756655074528
,0.8627492133885045211272313
,0.8680443669203333767470099
,0.8733395204521622323667884
,0.8786346739839910879865670
,0.8839298275158199436063455
,0.8892249810476487992261241
,0.8945201345794776548459026
,0.8998152881113065104656812
,0.9051104416431353660854597
,0.9104055951749642217052383
,0.9157007487067930773250168
,0.9209959022386219329447954
,0.9262910557704507885645739
,0.9315862093022796441843525
,0.9368813628341084998041310
,0.9421765163659373554239096
,0.9474716698977662110436881
,0.9527668234295950666634667
,0.9580619769614239222832452
,0.9633571304932527779030238
,0.9686522840250816335228023
,0.9739474375569104891425809
,0.9792425910887393447623595
,0.9845377446205682003821380
,6.7779147113365132426565651
,6.5856575096491765108908112
,6.3988618850778422597613826
,6.2173664613983836702004737
,6.0409101165506520203507534
,5.8695854667333042797849885
,5.7031693316287359607485996
,5.5417316612180016477395839
,5.3842001027158072901102059
,5.2314653465016371924889427
,5.0830624834847810689097969
,4.9388697972766930632815274
,4.7987687834711501011497603
,4.6626440435089087088726956
,4.5303832214496981833917744
,4.4018769640892108085949985
,4.2770188890047835528207543
,4.1557055499979060897430827
,4.0378363941056596431167236
,3.9233137082391724703711589
,3.8120425562510789063708216
,3.7039307087939352669536675
,3.5988885688758878167448074
,3.4968290958348529073873578
,3.3976677298535640225907173
,3.3013223208855171364461967
,3.2077130422476933802045096
,3.1167623750046478114938964
,3.0283949519021358121051435
,2.9425375285900141619777060
,2.8591190461334670125381763
,2.7780703724375537255752988
,2.6993243649999620892288021
,2.6228157889508589839522301
,2.5484812630869861926896647
,2.4762592074093912053456279
,2.4060897921303334712206379
,2.3379148881172309160092482
,2.2716780187401255375334586
,2.2073243130891713192909265
,2.1448004604985388965587845
,2.0840546664634915785541125
,2.0250366096207836896780918
,1.9676974001547118398036673
,1.9119895392784591603430044
,1.8578668798937947315152996
,1.8052845883720727293564323
,1.7541991074246561232996555
,1.7045681200319886539062963
,1.6563505144015535641699444
,1.6095063499258561723337380
,1.5639968241123589631769164
,1.5205741560326724304275103
,1.4776250146537157625914460
,1.4359006369989748552740139
,1.3953664612745755313483187
,1.3559889121222481467299303
,1.3177353728370655439050552
,1.2805741583825420715214705
,1.2444744891810479714422399
,1.2094064656581369199273013
,1.1753410435200488670659524
,1.1422500097442895850008426
,1.1101059592638247153217890
,1.0788822723260071967388285
,1.0485530925080166486651478
,1.0190933053711166422772294
,0.9904785177366681736543796
,0.9626850375673845494617353
,0.9356898544378817739186616
,0.9094706205791575071017974
,0.8840056324821757849363735
,0.8592738130463123402691394
,0.8352546942589804679357712
,0.8119284003933272542141708
,0.7892756317114562047976278
,0.7672776486611792012837441
,0.7459162565548226320188974
,0.7251737907190589638162237
,0.7050331021051479130079542
,0.6854775433493004443974428
,0.6664909552732135589181439
,0.6480801350237479496740889
,0.6301855686517738863727800
,0.6128143110149046890455793
,0.5959520289346706967137379
,0.5795848161577279444856003
,0.5636991823303547644030687
,0.5482820423656545871793355
,0.5333207061995457465286563
,0.5188028689324634123991586
,0.5047166013545987262034487
,0.4910205198391272007896191
,0.4777622577853760654775783
,0.4649019329434196379224886
,0.4524290332129038416653088
,0.4403333813729645163093096
,0.4286390496763629598397927
,0.4172694972649763633931741
,0.4062485953993458798194638
,0.3955674333339135873011116
,0.3852174027012170154371518
,0.3751901924635061558177540
,0.3654777843297818407108934
,0.3560724486593613291596228
,0.3469667408767892480270234
,0.3381534984271802324329315
,0.3296258383058492391626260
,0.3213771552016705390641960
,0.3134011202995141687210889
,0.3056916807938966917923551
,0.2982430601722754204274679
,0.2910497593369172353305885
,0.2841065586424889599648225
,0.2774085209415986241765495
,0.2698926197973782192818248
,0.2636657689485524813655104
,0.2576708655886407739465938
,0.2529794127344151544178885
,0.2474433838471650215495856
,0.2421291544159275277436905
,0.2378469532682815912316698
,0.2329739783235756644952374
,0.2283156967564696493422360
,0.2238704716401560268490556
,0.2196370879486056471030508
,0.2156147812211764713818951
,0.2118032703543940020729508
,0.2081996257455359100596581
,0.2048119823455038790438465
,0.2016373047805797291687213
,0.1986777651832267177489655
,0.1959362512125499555803998
,0.1934164448911819267351575
,0.1911229120014262261584292
,0.1890612039634991248249207
,0.1872379695689778134060077
,0.1856610849364218329693443
,0.1843398003639862559044360
,0.1832849046957008565250646
,0.1825089122954792475450603
,0.1820262745207039956074624
,0.1818536185609203881252682
,0.1820100077164313046029775
,0.1825172365555375320056442
,0.1834001484933419079403905
,0.1846869779769311492589878
,0.1864097101267996048346021
,0.1886044393591796430875718
,0.1913117193844597052621026
,0.1945768572521015538079325
,0.1984501156325546300518425
,0.2029867601844961011448021
,0.2082468476828492620622768
,0.2142946545027145099915344
,0.2211975772005430329603115
,0.2290243300801792225573905
,0.2378422396332287303000186
,0.2477134410111338502780143
,0.2586898395326877597710791
,0.2708068367060639247689835
,0.2840760508660855609974760
,0.2984776219452660028785829
,0.3139531179598983312573068
,0.3304004893094887318483188
,0.3476727628409421178012906
,0.3655820107675878394282165
,0.3839093892817828090890941
,0.4024207547644783056206563
,0.4208857449335461353712162
,0.4390969711532974883994029
,0.4568855610898335806169257
,0.4741301220138189886910141
,0.4907579849254505299782636
,0.5067411668091508225586495
,0.5220794672492307109123999
,0.5368007700572220430856873
,0.5509416012758411307359552
,0.5645419447838224691338382
,0.5776401321252130349748199
,0.5902711530920988769466362
,0.6024646295127918937950540
,0.6142471226236758674588145
,0.6256382641892730411825596
,0.6366598549437453291588440
,0.6473281367837503408324551
,0.6576584733613308753064075
,0.6676648596866614493450243
,0.6773601740638092172375195
,0.6867563623842822817522347
,0.6958645764427255908657344
,0.7046952805907851224986871
,0.7132583359784417931237499
,0.7215630684821605633771924
,0.7296183244938830858572487
,0.7374325174606275457023230
,0.7450136670527821580733985
,0.7523694320437875893148316
,0.7595071377143919333363442
,0.7664337992436119906258796
,0.7731561438360974314321084
,0.7796806346444898894176845
,0.7860134965823899477754821
,0.7921607375390012917293348
,0.7981281527497045003016751
,0.8039213035899285264562764
,0.8095454803686404909868202
,0.8150056850206481851017770
,0.8203066824643704402220123
,0.8254531448836870399787813
,0.8305996073030036397355502
,0.8357460697223202394923192
,0.8408925321416368392490881
,0.8460389945609534390058570
,0.8511854569802700387626260
,0.8563319193995866385193949
,0.8614783818189032382761638
,0.8666248442382198380329328
,0.8717713066575364377897017
,0.8769177690768530375464707
,0.8820642314961696373032396
,0.8872106939154862370600085
,0.8923571563348028368167775
,0.8975036187541194365735464
,0.9026500811734360363303153
,0.9077965435927526360870843
,0.9129430060120692358438532
,0.9180894684313858356006222
,0.9232359308507024353573911
,0.9283823932700190351141600
,0.9335288556893356348709290
,0.9386753181086522346276979
,0.9438217805279688343844668
,0.9489682429472854341412358
,0.9541147053666020338980047
,0.9592611677859186336547737
,0.9644076302052352334115426
,0.9695540926245518331683115
,0.9747005550438684329250805
,0.9798470174631850326818494
,0.9849934798825016324386183
,6.9258842841586352179206187
,6.7294286025337219925290810
,6.5385578789671656707582770
,6.3531056091628457238584815
,6.1729127980506381945247085
,5.9977309282984982985453826
,5.8277031512236945332006144
,5.6628063905301022629146246
,5.5017813475271282186440658
,5.3457163902677429234699957
,5.1940771666271183804042266
,5.0467394624995334240225020
,4.9035823548209984679147055
,4.7644880778561571332829772
,4.6293419450161108485986006
,4.4980323038785554601304284
,4.3704505058167253395140506
,4.2464908766874724932449681
,4.1260506802796594882920544
,4.0090300708481203528776859
,3.8953320345560493720427075
,3.7848623218503441023585765
,3.6775293737973604457636156
,3.5732442454814923316064323
,3.4719205290568417865415540
,3.3734742782686875095521373
,3.2778239334210135247360540
,3.1848902659188391695010978
,3.0945962966752662559599685
,3.0068671564493918424432195
,2.9216302478893032557039078
,2.8388149312250003930557796
,2.7583526004467495695848811
,2.6801765988207297830570042
,2.6042221637660301070127389
,2.5304263732637304329387007
,2.4587280937615356712910852
,2.3890679295423011829768711
,2.3213881735240509129880593
,2.2556327594566236705020401
,2.1917472154614272561445887
,2.1296786189856939941478231
,2.0693755528369184304438022
,2.0107880626958096748069238
,1.9538676157121370735580967
,1.8985670603084034979701755
,1.8448405871297057778690487
,1.7926436911070040558513483
,1.7419331346023052553562138
,1.6926669116053600916416144
,1.6448042129523474663699290
,1.5983053925379357984581929
,1.5531319344928775638692287
,1.5100345132744954490533473
,1.4674037124899765860419620
,1.4259892142827830241458287
,1.3857567143359212913367173
,1.3466728880400624657198705
,1.3087053629252929365378577
,1.2718226918854209639420105
,1.2359943271730000624586410
,1.2011905951439081352560834
,1.1673826717309661038513013
,1.1345425586267472439772064
,1.1026430601563210753823796
,1.0716577608213349037669104
,1.0415610034974174258337598
,1.0123278682674863304669088
,0.9839341518741542280679369
,0.9563563477749789099036093
,0.9295716267848996849920695
,0.9035578182907807454071758
,0.8782933920235590496972122
,0.8537574403740714190647054
,0.8299296612392517147327453
,0.8067903413859629502269399
,0.7843203403203364842966039
,0.7625010746510433312650434
,0.7413145029354575310520659
,0.7207431109980975136863890
,0.7007698977111390670202695
,0.6813783612270891687501262
,0.6625744028887262659921475
,0.6442993020753634558772660
,0.6265592522850184087346292
,0.6093396196526157382322708
,0.5926262071693436661590226
,0.5764052434591235840599666
,0.5606633719600431220442260
,0.5453876405071087507536731
,0.5305654913135637862353633
,0.5161847513490093186661056
,0.5022336231135902107070024
,0.4887006758086586133416063
,0.4755441026066016263484926
,0.4628138333413708838115497
,0.4504695612322308639896562
,0.4385012443069040699583638
,0.4269332159019708639036139
,0.4156888313070981610941601
,0.4047922226962455405363528
,0.3942346238200454267008865
,0.3840075742832163574469462
,0.3741029150395600022527276
,0.3645127844020285556858596
,0.3552296145950989969541922
,0.3462461288812677118187366
,0.3375553392986126999275598
,0.3291505450525006315487531
,0.3210253316109805132860799
,0.3131735705609059450260645
,0.3055894202884104071671345
,0.2982673275591366524039927
,0.2912020300817801943260577
,0.2843885601550505959345116
,0.2778222495079322174049707
,0.2704413804111304164834451
,0.2643512167067906815098866
,0.2584958951709653840467240
,0.2539461017659204178364973
,0.2485565620259941321812391
,0.2442007841949873914177971
,0.2392663117107671211236664
,0.2345536212506398876520564
,0.2300612249574215950609357
,0.2257880842628973150354454
,0.2217336412274590329296586
,0.2178978543077502161295911
,0.2142769558955828212987171
,0.2108819473968438773514578
,0.2077086304036515618243186
,0.2047596087482939641866153
,0.2020382513403737589907649
,0.1995487777494326375737899
,0.1972963549309505182360880
,0.1952872070829267392433337
,0.1935287354638171031240290
,0.1920296573148242424977639
,0.1908001620327918479436136
,0.1898520849423397938160463
,0.1891991037802924491284529
,0.1888569593351419884097453
,0.1888437024122357754674084
,0.1891799597937174337580757
,0.1898892321423164830651586
,0.1909982085900666926026048
,0.1925370977327343635643331
,0.1945399642137926043972129
,0.1970450471297633399103688
,0.2000950465365871344669557
,0.2037373218250267126183672
,0.2080239563177578299146830
,0.2130116128022072896630590
,0.2187610635171954864830468
,0.2253362817106406845724109
,0.2328029200044104962685765
,0.2412260031627581624569245
,0.2506666564448267187081854
,0.2611777249445562665286502
,0.2727982383990972259368846
,0.2855468615512198882200323
,0.2994147440733219145414523
,0.3143585672368035544010922
,0.3302949723071022525289209
,0.3470978592663436224086126
,0.3646000632090002913088256
,0.3826004691631439413868065
,0.4008766372835636526694714
,0.4192016600350218502590849
,0.4373625902976387425091787
,0.4551770555120228101131374
,0.4725048824415663539788568
,0.4892528216863482048992751
,0.5053722900479993285216551
,0.5208529172780408389442641
,0.5357068673594809204985268
,0.5499671559462201431145445
,0.5636718471591141144116932
,0.5768599946099030040258526
,0.5895679417349292128491811
,0.6018273824061602939039517
,0.6136664882123205044806014
,0.6251084951551996171659198
,0.6361743801206896087307996
,0.6468820874186202996014572
,0.6572477446067390705053413
,0.6672859419121472956959451
,0.6770100312341229553680932
,0.6864323431581164092207814
,0.6955643475505076667175786
,0.7044167755841056477450479
,0.7129997148909389403925729
,0.7213226854522741815500808
,0.7293947013088769582012105
,0.7372243215934194404681534
,0.7448196932927863000983848
,0.7521885873056868287989118
,0.7593384288112305924300927
,0.7662763229634933503930938
,0.7730090775829259186480158
,0.7795432252035439102400005
,0.7858850460526288772555858
,0.7920405900302155410841465
,0.7980156907248676656507769
,0.8038159628434750070269388
,0.8094467821479226499192805
,0.8149132646412581282291399
,0.8202202788386648846241656
,0.8253725227292293409320223
,0.8303746622589986969842357
,0.8353768017887680530364491
,0.8403789413185374090886626
,0.8453810808483067651408760
,0.8503832203780761211930894
,0.8553853599078454772453028
,0.8603874994376148332975163
,0.8653896389673841893497297
,0.8703917784971535454019431
,0.8753939180269229014541565
,0.8803960575566922575063700
,0.8853981970864616135585834
,0.8904003366162309696107968
,0.8954024761460003256630102
,0.9004046156757696817152237
,0.9054067552055390377674371
,0.9104088947353083938196505
,0.9154110342650777498718639
,0.9204131737948471059240774
,0.9254153133246164619762908
,0.9304174528543858180285042
,0.9354195923841551740807176
,0.9404217319139245301329311
,0.9454238714436938861851445
,0.9504260109734632422373579
,0.9554281505032325982895713
,0.9604302900330019543417848
,0.9654324295627713103939982
,0.9704345690925406664462116
,0.9754367086223100224984250
,0.9804388481520793785506385
,0.9854409876818487346028519
,7.0752769665967640833059704
,6.8745800459993420261639585
,6.6795936355890273006252755
,6.4901458595892247416259124
,6.3060728057281494329799898
,6.1271028202202968415690520
,5.9534312307644521311544850
,5.7845686765666943784935938
,5.6208475518809821735999321
,5.4610647068769164746981915
,5.3061584863391395572307374
,5.1556459045748912473072778
,5.0094036067177087900859078
,4.8673114553178296048940865
,4.7292524314650137284843368
,4.5951125807760213604069577
,4.4647809824012956170236066
,4.3381497241835251799102480
,4.2151138727849568610395181
,4.0955714329478345447910215
,3.9794232943632423804558584
,3.8665731675674512857199261
,3.7569275118584775086105765
,3.6503954586589557607112511
,3.5468887333980179121795118
,3.4463215782154734689868292
,3.3486106767785042137575147
,3.2536750735630581843338405
,3.1614361717666179529828696
,3.0718174975556014061339738
,2.9847447894077392405165483
,2.9001459877828041911129731
,2.8179509775595068532538789
,2.7380916666104413437210496
,2.6605018978300325471764154
,2.5851173944075656052632439
,2.5118757066218364570886479
,2.4407161601258025029892451
,2.3715798056900472268182511
,2.3044093703712835718988572
,2.2391492100714720514531564
,2.1757452634242753219950828
,2.1141450070887173318112673
,2.0542974121337289616917587
,1.9961529018581032346446591
,1.9396633107057921208138396
,1.8847818443767638818542309
,1.8314630410755443623571637
,1.7796627338652082350733963
,1.7293380140956935431262309
,1.6804471958763467220876464
,1.6329497815634186341782197
,1.5868064282341565185419086
,1.5419789151198992627200823
,1.4992163452015125901795045
,1.4569132951690897392893476
,1.4158178650080159854951489
,1.3758960156200699120887521
,1.3371146807214193685808823
,1.2994417394957544775735414
,1.2628459900351218792025065
,1.2272971235468832507109482
,1.1927656993058601830881571
,1.1592231203314171672502653
,1.1266416097698643827840215
,1.0949941879632036911829118
,1.0642546501858691776476462
,1.0343975450317115516440936
,1.0053981534341143166955135
,0.9772324683026717417888563
,0.9498771747605211368536970
,0.9233096309669531764896533
,0.8975078495105598408443370
,0.8724504793587651851893838
,0.8481167883501983251193224
,0.8244866462170052923141839
,0.8015405081248034857566154
,0.7792593987186273718492657
,0.7576248966637663118106616
,0.7366191196709295230249381
,0.7162247099956073892457198
,0.6964248204018409493798458
,0.6772031005809494574876339
,0.6585656951560032723591576
,0.6404538449086967233370160
,0.6228739809764350932042021
,0.6058116135374551625147888
,0.5892526882704244295396734
,0.5731835753514125109120414
,0.5575910588651070698418266
,0.5424623266278892907976683
,0.5277849604214189804807233
,0.5135469266365105811544822
,0.4997365673282788134379473
,0.4863425916848626573418812
,0.4733232224686890199372158
,0.4607287506322746417630754
,0.4485189035089528486466293
,0.4366837843923265793932842
,0.4252480027503030557411989
,0.4141348130514972414317754
,0.4033686237931893292518737
,0.3929408257705706564166803
,0.3828431199585366484505755
,0.3730675136424941862323124
,0.3636063171241022962121292
,0.3544521410366455183016399
,0.3455978943102104294915478
,0.3370367828335293913788462
,0.3287623088663930714936612
,0.3207682712648171063918312
,0.3130487665879905234689318
,0.3055981911694135577661768
,0.2984112442426339883994046
,0.2914829322302132097455285
,0.2848085743136471448266889
,0.2783838094093040727017296
,0.2722046047447161942756111
,0.2652058329340337139434780
,0.2595015240531140521262898
,0.2551051802529317735768188
,0.2506775503123451764864171
,0.2456835508073507701176652
,0.2409186373517520629583544
,0.2363814840097803182672465
,0.2320712427945843814303117
,0.2279875777896304966940733
,0.2241307039977349924164685
,0.2204956969978844605329016
,0.2170972084471157192986368
,0.2139294514422429849265228
,0.2109954901192675758014872
,0.2082992043364831902252376
,0.2058453821334179922875052
,0.2036398238596943133238426
,0.2016894599976219448755899
,0.2000024788875332804050089
,0.1985884742839213179532720
,0.1974586102570318746352029
,0.1966258034346154981442112
,0.1961049276141374475557200
,0.1959130415886393417057576
,0.1960696414493656170030533
,0.1965969283977186676803939
,0.1975201042016644925602975
,0.1988676758531834065646393
,0.2006717662039848304456058
,0.2029684155716710014516480
,0.2057978447146044387316977
,0.2092046587354365605460060
,0.2132379265081023600458821
,0.2179510801383393037156111
,0.2234015478275906130267714
,0.2296499938353518399658526
,0.2367590442635413017224977
,0.2447913249207662178541511
,0.2538066527937534733183611
,0.2638582392503195928057380
,0.2749878298298074064121010
,0.2872198459813903870241347
,0.3005548218607564936455390
,0.3149627281570397951959706
,0.3303771491880053701173381
,0.3466915836246386994901059
,0.3637592773070916218891568
,0.3813977757813765134820017
,0.3993986920214427360775744
,0.4175420596634313308292974
,0.4356133803860901543281159
,0.4534204510867578252764076
,0.4708068607325104348859668
,0.4876597427580914856370953
,0.5039108488972858790333476
,0.5195316883868104085308914
,0.5345256279844871061257550
,0.5489137031721534887296343
,0.5627319023592072255723906
,0.5760185506052014625666402
,0.5888110945310551791465059
,0.6011432300662231664745150
,0.6130448151585868865609541
,0.6245417435804078154504282
,0.6356557036210578326418386
,0.6464060440299403964559133
,0.6568097815932868455135463
,0.6668821939354887540218897
,0.6766371738007952441051884
,0.6860874862986979794143849
,0.6952449572510407405090405
,0.7041206142166706039020596
,0.7127247949057177178744382
,0.7210672325980784780341537
,0.7291571248787201975360972
,0.7370031899551789944524671
,0.7446137135094956782666031
,0.7519965881111058125796376
,0.7591593465436764498477373
,0.7661091900551590949675074
,0.7728530126785816412038344
,0.7793974232615131780832485
,0.7857487669258695905938339
,0.7919131462166322243945160
,0.7978964389072061846874817
,0.8037043064169145933917093
,0.8093421884196188020865748
,0.8148152887224910934094169
,0.8201285718048335615648625
,0.8252867970903866590148823
,0.8302946051652917436314283
,0.8351566330871290633197646
,0.8400186610089663830081008
,0.8448806889308037026964371
,0.8497427168526410223847734
,0.8546047447744783420731096
,0.8594667726963156617614459
,0.8643288006181529814497821
,0.8691908285399903011381184
,0.8740528564618276208264547
,0.8789148843836649405147909
,0.8837769123055022602031272
,0.8886389402273395798914635
,0.8935009681491768995797997
,0.8983629960710142192681360
,0.9032250239928515389564723
,0.9080870519146888586448085
,0.9129490798365261783331448
,0.9178111077583634980214811
,0.9226731356802008177098173
,0.9275351636020381373981536
,0.9323971915238754570864899
,0.9372592194457127767748261
,0.9421212473675500964631624
,0.9469832752893874161514987
,0.9518453032112247358398349
,0.9567073311330620555281712
,0.9615693590548993752165075
,0.9664313869767366949048437
,0.9712934148985740145931800
,0.9761554428204113342815162
,0.9810174707422486539698525
,0.9858794986640859736581888
,7.2260174122460227863484761
,7.0210381503840366690383235
,6.8218971543028352755300148
,6.6284169459121740075602247
,6.4404284425785895962235372
,6.2576344419107234884336322
,6.0801859397165456400102812
,5.9078355910512190263261800
,5.7406941164467344407285054
,5.5774508621939258290467478
,5.4192487414949104262973378
,5.2655331041722890361711507
,5.1161781468914453441243495
,4.9710613554168752159512223
,4.8300633784408297799473075
,4.6930679597379931777823003
,4.5599619036002376759597610
,4.4306350531377196588778133
,4.3049802669847476721542989
,4.1828933859653609772522032
,4.0642731864321532952999405
,3.9490213207701696518370227
,3.8370422478170329583235798
,3.7282431568531819721101783
,3.6225338887082045857823687
,3.5198268568187049964990365
,3.4200369732056947746912101
,3.3230815546207432831238293
,3.2288803208559149204859295
,3.1373552013671144322870532
,3.0484303268283525767401443
,2.9620321181507192065396339
,2.8780889662373887460944388
,2.7965313307830514943930211
,2.7172916477331869877787085
,2.6403042734143880032604557
,2.5655054302123789788936392
,2.4928331537653432015133603
,2.4222272416426307017900399
,2.3536292034764345615371894
,2.2869822125134944279523097
,2.2222310585141715755241876
,2.1593221021211461696509559
,2.0982032302803683698755322
,2.0388238131924594220834024
,1.9811346623487120499618186
,1.9250879897954789043978963
,1.8706373685608441714833816
,1.8177376942104983559289622
,1.7663451475009939173332896
,1.7164171580996483434944366
,1.6679123693412249984646678
,1.6207906039924238061900041
,1.5750128309960411687740134
,1.5305411331674874109154416
,1.4881230166586336682854608
,1.4461571267131136941941350
,1.4053899553847768455483447
,1.3657877365581831963226023
,1.3273176698780404514366182
,1.2899478936312764876248593
,1.2536474584119567943218954
,1.2183863015477218727511399
,1.1841352222670846749963403
,1.1508658575875927443377122
,1.1185506589055238535479475
,1.0871628692684105477184175
,1.0566765013123320393617632
,1.0270663158465200837099474
,0.9983078010684606207192360
,0.9703771523932549492030830
,0.9432512528816456853775207
,0.9169076542516859662512729
,0.8913245584596831694312868
,0.8664807998366549357527333
,0.8423558277672026362026259
,0.8189296898983545736072642
,0.7961830158666018952828836
,0.7740970015320020047866478
,0.7526533937087905856699876
,0.7318344753824775894557320
,0.7116230514037982235464597
,0.6920024346502301471062424
,0.6729564326461391354783359
,0.6544914427154033820244194
,0.6365486673966900266208313
,0.6191347851549010572469456
,0.6022354569694474690777497
,0.5858367781326536682939832
,0.5699252674913316552007814
,0.5544878571139223444319555
,0.5395118823823308318310410
,0.5249850725087609193408866
,0.5108955414791642724026133
,0.4972317794263190759984639
,0.4839826444371138070010829
,0.4711063962710216324047963
,0.4586536999370974254652822
,0.4465843257300194379944003
,0.4348885333769652028479413
,0.4235912265569733436976207
,0.4126155598782491606968392
,0.4019862363972059315919694
,0.3916948180193770001622511
,0.3817331821539015068722733
,0.3720935185886558582701866
,0.3627683270123402414775171
,0.3537504152270476431851876
,0.3450328981021165142273333
,0.3366091973276520987745641
,0.3284730420352423019281218
,0.3206184703604244012886682
,0.3130398320368008024949802
,0.3057317921194601106904543
,0.2986893359555912730307625
,0.2919077755282208364029373
,0.2853827573034680153973852
,0.2791102717959644263778785
,0.2730866650097397707597224
,0.2662488132648084260267751
,0.2607081184804089235562685
,0.2572756778229391971812845
,0.2522242229011643077640770
,0.2474093728691931226570944
,0.2428299765339274052244889
,0.2384853905308371990745542
,0.2343755163190250068172560
,0.2305008421979098665044461
,0.2268548832042877883008458
,0.2234569132982589245717264
,0.2202990227881994611536243
,0.2173847644996991512744700
,0.2147185583494039817775700
,0.2123057907328902149668437
,0.2101529260330481374552392
,0.2082676322753796993580977
,0.2066589164313470949885243
,0.2053372800823347610332803
,0.2043148922140007039960352
,0.2036057786850302697700954
,0.2032260332009971914857260
,0.2031940498712562492844569
,0.2035307774748096043548884
,0.2042599845915966383369522
,0.2054085465776043228913750
,0.2070067323825749427967935
,0.2090884845840879913136945
,0.2116916729715352940566220
,0.2148582858282434837615682
,0.2186345313539947432524002
,0.2230707747436725674194946
,0.2282212461288984362006715
,0.2341434230056551879517457
,0.2408969544494558856495559
,0.2485420029042933465213139
,0.2571368398198592974956966
,0.2667345629773576476395647
,0.2773788462730121806565364
,0.2890987331503395152410008
,0.3019026630124164167767731
,0.3157721775037174993805422
,0.3306560537908291297348740
,0.3464659427651963774508204
,0.3630747735432032774482991
,0.3803191360871490123152228
,0.3980064102146493865141963
,0.4159265446589880954597618
,0.4338672493737796842516730
,0.4516303145591874512732034
,0.4690461644716029665502788
,0.4859840283351314904614071
,0.5023561318928059238331230
,0.5181158198777884305030739
,0.5332509258873506796660990
,0.5477745438559958879309875
,0.5617157874974859632644097
,0.5751100099576339497176036
,0.5879954543884906570383464
,0.6004075588583310807422322
,0.6123780723198694042608281
,0.6239348150173349427660696
,0.6351010934088437975830743
,0.6458976412627511765052191
,0.6563425115245922203399687
,0.6664517803795221295715123
,0.6762399629382054300208438
,0.6857203186995002308634639
,0.6949050742823172921447394
,0.7038055881092495358331007
,0.7124324751441963865516982
,0.7207957038404968486133839
,0.7289046732566357711391447
,0.7367682756172738711697434
,0.7443949479223098686375693
,0.7517927151087671067131168
,0.7589692264963309176195594
,0.7659317867278975233702454
,0.7726873822218959242391634
,0.7792427043195390146124168
,0.7856041705524640095248401
,0.7917779450520138206925935
,0.7977699573949934563898978
,0.8035859166048061608123021
,0.8092313159993136384429135
,0.8147114283476871721134671
,0.8200313001068165741358484
,0.8251957631745521215549388
,0.8302094822518193417693055
,0.8350770371424636184798374
,0.8398030057927177161047894
,0.8445289744429718137297414
,0.8492549430932259113546934
,0.8539809117434800089796454
,0.8587068803937341066045974
,0.8634328490439882042295494
,0.8681588176942423018545014
,0.8728847863444963994794534
,0.8776107549947504971044054
,0.8823367236450045947293574
,0.8870626922952586923543095
,0.8917886609455127899792615
,0.8965146295957668876042135
,0.9012405982460209852291655
,0.9059665668962750828541175
,0.9106925355465291804790695
,0.9154185041967832781040215
,0.9201444728470373757289735
,0.9248704414972914733539255
,0.9295964101475455709788775
,0.9343223787977996686038296
,0.9390483474480537662287816
,0.9437743160983078638537336
,0.9485002847485619614786856
,0.9532262533988160591036376
,0.9579522220490701567285896
,0.9626781906993242543535416
,0.9674041593495783519784936
,0.9721301279998324496034456
,0.9768560966500865472283976
,0.9815820653003406448533497
,0.9863080339505947424783017
,7.3780274074859608646193010
,7.1687264220310078499664996
,6.9653936798159943322161780
,6.7678458893005384311436501
,6.5759085489380000311143704
,6.3894154929295190470384114
,6.2080857574997176939746169
,6.0321349551943068689752181
,5.8615524196525754518916074
,5.6951804769122196248076762
,5.5332878966985834523484300
,5.3763427748854786258903005
,5.2238493828802399221444830
,5.0756828230023440795548595
,4.9317214123678239090509123
,4.7918465955285149959763658
,4.6559429025778360511367282
,4.5238979286293430348564470
,4.3956023165736919366963775
,4.2709497316046602932715359
,4.1498368220141115259025355
,4.0321631654450902360053988
,3.9178312028520521081986772
,3.8067461639094486436363241
,3.6988159878488096055093592
,3.5939512431228610722655503
,3.4920650483240627259817757
,3.3930729926634586313127784
,3.2968930869263859406714801
,3.2034456566734301752319425
,3.1126532062017262525444039
,3.0244406247945789800724015
,2.9387347982636167209591349
,2.8554647261164789462384306
,2.7745614256772923589267066
,2.6959578750681276737566350
,2.6195889577647979429286806
,2.5453914086925313320364239
,2.4733037618326352280462288
,2.4032662993094433545593347
,2.3352210019266617102573491
,2.2691115010687945563461199
,2.2048830321440022750323351
,2.1424823890236033285816575
,2.0818578801244003173565034
,2.0229592855566420617208223
,1.9657378155349221060532727
,1.9101460699762500272669286
,1.8561379992513180603452838
,1.8036688660564310637823837
,1.7526952083746913935158318
,1.7031748034959692805756504
,1.6550666330661105707378056
,1.6083308491366539172418015
,1.5629287411871979340816097
,1.5188227040933792721943973
,1.4767586234452521054549834
,1.4351392852809532474367415
,1.3947095495652981345102717
,1.3554359309411760925456747
,1.3172859026015648620244747
,1.2802278694083131238556916
,1.2442311417889071467612894
,1.2092659103902130279806215
,1.1753032214687768597372042
,1.1423149529980192173894693
,1.1102737914732550006391421
,1.0791532093961635485612760
,1.0489274434209412412144502
,1.0195714731450231660403460
,0.9910610005278763789959839
,0.9633724299219927900139737
,0.9364828487008338697705767
,0.9103700084691201954711914
,0.8850123068414939009329601
,0.8603887697762631070474981
,0.8364790344516247477812954
,0.8132633326724593159084975
,0.7907224747965067024324526
,0.7688378341693858919470017
,0.7475913320585232391124464
,0.7269654230765348890130895
,0.7069430810850054758276428
,0.6875077855699416318202566
,0.6686650696292134599119095
,0.6503569095532834021256008
,0.6325891538362438115683517
,0.6153471771765641751272824
,0.5986167985294296167708694
,0.5823842701807315780371255
,0.5666362672607699879634424
,0.5513598776972795656448056
,0.5365425926086705432638269
,0.5221722971397581014585398
,0.5082372617437632689174620
,0.4947261339160289317362640
,0.4816279303867094241375924
,0.4689009557266410332942996
,0.4565962633778360424408049
,0.4446736765041098271566966
,0.4331236237874967476280119
,0.4219713253022017718230074
,0.4111398330284266600109788
,0.4006541666833068338071655
,0.3905060750767241906089566
,0.3806876290157138464920195
,0.3711912190510732179049569
,0.3620095539570534759477027
,0.3531356599990068678707189
,0.3445628810519661966438321
,0.3362848796431708864318466
,0.3282956389986496636979041
,0.3205894661916703358706116
,0.3131609964982683402823227
,0.3060051990877129535206791
,0.2991173841824916745935070
,0.2924932118227487887196503
,0.2861287024720557958801237
,0.2800202496242578664720213
,0.2741646347004546568904004
,0.2675011479532823921445583
,0.2639932860438995998464407
,0.2588865403213467253351610
,0.2540241316154350781353344
,0.2494050961598137383656848
,0.2450290090471398674054626
,0.2408960241719080852540458
,0.2370069194782495336504269
,0.2333531444101523411038812
,0.2299597907952991571178814
,0.2268161630288658692222725
,0.2239263305187683128494314
,0.2212952814371525189773848
,0.2189290289994565985587371
,0.2168347302189394254501309
,0.2150208191252225287115607
,0.2134971491477627714150600
,0.2122751561505683282060630
,0.2113680380203175335207533
,0.2107909497944552013048991
,0.2105612188298605080838399
,0.2106985791465798008026411
,0.2112254236938778118037874
,0.2121670615778442903209822
,0.2135519897225577889976478
,0.2154121530594688693760475
,0.2177831828009003656276832
,0.2207045881001431786305744
,0.2242198587530447595472793
,0.2283764441377099385643845
,0.2332255253612709466892738
,0.2388215076772761125134537
,0.2452211295081856423649924
,0.2524820534857509790604979
,0.2606608190227132637595275
,0.2698100127288731164831859
,0.2799745635155581058306495
,0.2911871401635635070448416
,0.3034627615440744774488735
,0.3167929375562992255765948
,0.3311399293730523107903707
,0.3464319929366332373454895
,0.3625607249018716338184731
,0.3793816676117303665627389
,0.3967190918040061076155212
,0.4143752519470857431649335
,0.4321434611483950249954944
,0.4498232876955306491773001
,0.4672354185541879312282276
,0.4842335453810701073606992
,0.5007112707449614674715122
,0.5166032177885647724835394
,0.5318809184495344455356758
,0.5465451342632613451755219
,0.5606167179838424940996333
,0.5741279271953396712291351
,0.5871154634684253581511371
,0.5996155887740973744470807
,0.6116618958823171192662471
,0.6232841245439512123382997
,0.6345074993147973296814257
,0.6453542565848970902209203
,0.6558436518313859320272741
,0.6659926918449279309442090
,0.6758166128055357324555530
,0.6853292410472526796638704
,0.6945432576243548705718922
,0.7034703924408324260397762
,0.7121215692770193061988948
,0.7205070168667733199185932
,0.7286363561110656972275024
,0.7365186700604324787633459
,0.7441625611120525896069466
,0.7515761984844343546185996
,0.7587673581120697452462309
,0.7657434564636544926941042
,0.7725115793968698740812329
,0.7790785070582416649287438
,0.7854507359543492217568428
,0.7916344993073489710866397
,0.7976357860897747009687464
,0.8034603574861249875027625
,0.8091137578933975671446888
,0.8146013181716668105636359
,0.8199281536295179861895122
,0.8250991670003433586799702
,0.8301190715056431246310353
,0.8349924429035419093381165
,0.8397237889006853306383960
,0.8443175978356082245213088
,0.8489114067705311184042216
,0.8535052157054540122871344
,0.8580990246403769061700473
,0.8626928335752998000529601
,0.8672866425102226939358729
,0.8718804514451455878187858
,0.8764742603800684817016986
,0.8810680693149913755846114
,0.8856618782499142694675243
,0.8902556871848371633504371
,0.8948494961197600572333499
,0.8994433050546829511162628
,0.9040371139896058449991756
,0.9086309229245287388820884
,0.9132247318594516327650012
,0.9178185407943745266479141
,0.9224123497292974205308269
,0.9270061586642203144137397
,0.9315999675991432082966526
,0.9361937765340661021795654
,0.9407875854689889960624782
,0.9453813944039118899453911
,0.9499752033388347838283039
,0.9545690122737576777112167
,0.9591628212086805715941296
,0.9637566301436034654770424
,0.9683504390785263593599552
,0.9729442480134492532428681
,0.9775380569483721471257809
,0.9821318658832950410086937
,0.9867256748182179348916065
,7.5312260583399552871242122
,7.3175657539846259425075914
,7.1100058936251837593545133
,6.9083571882736913849498706
,6.7124394796249484684835807
,6.5220814172867935809563278
,6.3369754449900419501773285
,6.1572908545177931216585421
,5.9827692008553441382900928
,5.8135250827630216008401476
,5.6482137283778044434257026
,5.4880145040768848474499464
,5.3323586582369797426395053
,5.1811189003266457930862998
,5.0341712167790575449544122
,4.8913947575594596273163006
,4.7526717823318955780109718
,4.6178876384365521445829472
,4.4869307486586800237660100
,4.3596925937709132270470036
,4.2360676816556992463347342
,4.1159535004692440196549796
,3.9992504572773612814273747
,3.8858618058016500818041550
,3.7756935676151153202795285
,3.6686544507593379371712672
,3.5646557688028139843083864
,3.4636113612983883136564600
,3.3654375169086025998410605
,3.2700529604699726249350533
,3.1773785861511205652618628
,3.0873376156544600767972497
,2.9998555440861913723438192
,2.9148598582801947820541955
,2.8322801460459996469865018
,2.7520479967148205879823308
,2.6740969445685300875936719
,2.5983624138324725727500208
,2.5247816652038537199587154
,2.4532937438868804846947569
,2.3838394291016551385098410
,2.3163611850022212124144971
,2.2508031131456101014975957
,2.1871109059799702656334830
,2.1252318020339378001892783
,2.0651145421732834961403569
,2.0067093271516909247509375
,1.9499677763739260427655609
,1.8948428878364633742847900
,1.8412889992122272175834041
,1.7892617500474108371832926
,1.7387180450392711872353857
,1.6896160183647381813898392
,1.6419149990305750286267994
,1.5955754772166494959151350
,1.5505590715847370475444222
,1.5068284975261019287273712
,1.4651279980615892206685658
,1.4238645687866062772286568
,1.3837814151425147368712487
,1.3448453403073130640876798
,1.3070240986491632462218604
,1.2702863690898689164043844
,1.2346017292415469857047583
,1.1999406302957520420449100
,1.1662743726449753545182375
,1.1335750822171521967618446
,1.1018156875044393672169463
,1.0709698972682137885215070
,1.0410121789028758954032128
,1.0119177374416954418023806
,0.9836624951885724055244964
,0.9562230719602282658087233
,0.9295767659239960734041119
,0.9037015350170356509096337
,0.8785759789334829372720037
,0.8541793216667644683681715
,0.8304913945950467279999430
,0.8074926200985420576827778
,0.7851639956981247836509397
,0.7634870787054183205455615
,0.7424439713750631275601677
,0.7220173065503739939785532
,0.7021902337939535110322709
,0.6829464059952258248031853
,0.6642916287895295202048374
,0.6461678473189625959705040
,0.6285811773859421025534289
,0.6115171603259277333108912
,0.5949617807074593089922132
,0.5789014556950607959251442
,0.5633230248665579420475069
,0.5482137404863109964026080
,0.5335612582373484569231437
,0.5193536284169883998629302
,0.5055792876023169624133402
,0.4922270507938298900185714
,0.4792861040476881218097560
,0.4667148045438410663976470
,0.4545646109222308273167812
,0.4427954100754564192854446
,0.4313978137643295629466422
,0.4203973860652782668090310
,0.4097170676179530679483776
,0.3993822221305975972427404
,0.3893848030773162660622688
,0.3797170937894425724046243
,0.3703717062218644939797230
,0.3613415805559865301432865
,0.3526199857069806098408549
,0.3442005208139420902035965
,0.3360771177985260593779060
,0.3282440450981483626158308
,0.3206959126866715248382889
,0.3134276785210994842323373
,0.3064346565578894843184798
,0.2997125264774636588249734
,0.2932573453784481642969695
,0.2870655616007862231953141
,0.2811340309943040072226950
,0.2754600360859624230691622
,0.2708281830016649460723954
,0.2656683952300320505912623
,0.2607608873442196495417988
,0.2561048954389477660953389
,0.2517002265628062729341252
,0.2475473016621534128045568
,0.2436472040971565389266829
,0.2399886930491793302078207
,0.2366041365286785658206270
,0.2334792389575303106497017
,0.2306186134315956204332565
,0.2280278433230149837118717
,0.2257135953104215664311027
,0.2236837451232218665353457
,0.2219475179037988243901935
,0.2205156369904088253797170
,0.2194004933596241102566893
,0.2186163306318847365794511
,0.2181794439540154784129555
,0.2181083967872404216770121
,0.2184242536050456651164353
,0.2191508256223931028205953
,0.2203149142449338515614699
,0.2219465598610384504674187
,0.2240792658680016979921845
,0.2267501833295360869069413
,0.2300002262958788512570152
,0.2338740689254318327883198
,0.2384199825590698207378182
,0.2436894221970048457492908
,0.2497362831227898372077334
,0.2566157200354799994279631
,0.2643823976805336761763954
,0.2730880637942732502843057
,0.2827783311564567858553687
,0.2934886265936497706796615
,0.3052393633133180794736461
,0.3180305525685471201846610
,0.3318362966580396533622377
,0.3465998689740811267157028
,0.3622303113321334588903255
,0.3786016330718066646987552
,0.3955555772916825030272037
,0.4129085134871759432684257
,0.4304622723200969836021557
,0.4480177979205737792689490
,0.4653896305836925373355939
,0.4824188039418522144785584
,0.4989819181492031741065318
,0.5149950395666230695823629
,0.5304122885779792850868830
,0.5452201639105239694416127
,0.5594293985997418339195519
,0.5730662823393181115605444
,0.5861649997689694080449385
,0.5987617912860837554589466
,0.6108914888665843978543535
,0.6225856442354924524806847
,0.6338715031475261607596394
,0.6447729687145846710905062
,0.6553106776465467131487230
,0.6655027199848752017530273
,0.6753651713152960534003455
,0.6849125126693800247323907
,0.6941579442654294274106519
,0.7031136158544752934318467
,0.7117907970505289450002806
,0.7202000059181060676039010
,0.7283511085046721067470799
,0.7362533977288558961760145
,0.7439156571929262939946170
,0.7513462136915369793399577
,0.7585529810386216764683809
,0.7655434970621132206858306
,0.7723249550943597219188064
,0.7789042309944933517584786
,0.7852879066740057201201353
,0.7914822911256841342364510
,0.7974934397307564815093883
,0.8033271717671284228856621
,0.8089890847030127840611158
,0.8144845631704350497059863
,0.8198187822268556690374908
,0.8249967093310435206632292
,0.8300231149868070312791701
,0.8349026026094377161967941
,0.8396396584785427164021598
,0.8442387034913200194452543
,0.8487041104908904509684930
,0.8531695174904608824917318
,0.8576349244900313140149706
,0.8621003314896017455382093
,0.8665657384891721770614481
,0.8710311454887426085846869
,0.8754965524883130401079256
,0.8799619594878834716311644
,0.8844273664874539031544032
,0.8888927734870243346776419
,0.8933581804865947662008807
,0.8978235874861651977241195
,0.9022889944857356292473582
,0.9067544014853060607705970
,0.9112198084848764922938358
,0.9156852154844469238170745
,0.9201506224840173553403133
,0.9246160294835877868635521
,0.9290814364831582183867908
,0.9335468434827286499100296
,0.9380122504822990814332684
,0.9424776574818695129565072
,0.9469430644814399444797459
,0.9514084714810103760029847
,0.9558738784805808075262235
,0.9603392854801512390494622
,0.9648046924797216705727010
,0.9692700994792921020959398
,0.9737355064788625336191785
,0.9782009134784329651424173
,0.9826663204780033966656561
,0.9871317274775738281888948
,7.6855299871115629883888687
,7.4674746270572667228293540
,7.2556541166033392542544789
,7.0498730200417334401663538
,6.8499453016785194492399569
,6.6556941733866468169367181
,6.4669515476823136168604833
,6.2834288244331473194392856
,6.1053580733421979331865259
,5.9327235801522997249435321
,5.7639619830436314984467572
,5.6004859054024072051447547
,5.4416453999354494897033874
,5.2873107698723371683513506
,5.1373556709906651462915761
,4.9916569647196453729520726
,4.8500946468797385691118507
,4.7125518207021013239454987
,4.5789146879769031528439882
,4.4490725393893253425403600
,4.3229177326619261378937153
,4.2003456537682124505295178
,4.0812546614568825376068162
,3.9655460183784918548610676
,3.8531238133955030278343656
,3.7438948796053823642182579
,3.6377687117377162095976928
,3.5346573880316261018208479
,3.4344754732500457627963897
,3.3371400283097703010071200
,3.2425703654313369206363404
,3.1506880895540652076647348
,3.0614171957835090154276259
,2.9746836844256052678758806
,2.8904157036865480989717980
,2.8085434443004113624908769
,2.7289990818275700057427002
,2.6517167205406275698464924
,2.5766323388693881391020568
,2.5036837363780519716272011
,2.4328104822435867582441915
,2.3639538652029621346173371
,2.2970568448877841660760168
,2.2320640047014466134100985
,2.1689215057403661290891250
,2.1075770423451154478300396
,2.0479797987455472529916278
,1.9900804069832187526145617
,1.9338309060357623536674510
,1.8791847021090584135549761
,1.8260965300644520503681179
,1.7745224159493118154529157
,1.7244196406001610633040855
,1.6757467042885538788254962
,1.6284632923806798832089271
,1.5825302419825919564289052
,1.5379095095437773643709534
,1.4953395410805041532142923
,1.4532367117992828209338541
,1.4123384969635672803178750
,1.3726110251941767703698360
,1.3340213959722717618205934
,1.2965376524661873514077115
,1.2601287551478610460264917
,1.2247645561777142919623884
,1.1904157745375874011273254
,1.1570539718919661265061904
,1.1246515291584830986693078
,1.0931816237693117166429602
,1.0626182076057615333297690
,1.0329359855890465347272311
,1.0041103949108447501714636
,0.9761175848879410921199451
,0.9489343974258956926348674
,0.9225383480773717836953551
,0.8969076076814412878945859
,0.8720209845709360196863713
,0.8478579073356669049132961
,0.8243984081301486410708890
,0.8016231065152521484407089
,0.7795131938240080771151952
,0.7580504180424393334547517
,0.7372170691968989997278072
,0.7169959652398188998390083
,0.6973704384261928401755881
,0.6783454533864412550059342
,0.6598637049183327940582444
,0.6419305020528042193816987
,0.6245311073957094949449242
,0.6076512368099261651721577
,0.5912770486302411088175290
,0.5753951333481864827135155
,0.5599925037689795770390333
,0.5450565856442952661353729
,0.5305752087863118138244545
,0.5165365986703742695596020
,0.5029293685356787113605037
,0.4897425119956854699942994
,0.4769653961725009438943346
,0.4645564379199972893097481
,0.4525675217397189808998803
,0.4409586097854096276016378
,0.4297205129258888089971435
,0.4188791738076284021374818
,0.4083574042601906262106581
,0.3981809462711411451429910
,0.3883419779712071195909573
,0.3788330167997764896803403
,0.3696469194642294509023372
,0.3607768828589257847916372
,0.3522164460281411169084720
,0.3439594932638083135678642
,0.3360002584527024827032449
,0.3283333307937017497835086
,0.3209536620348926172496817
,0.3138565753834559046708819
,0.3070377762293779455582410
,0.3004933649720725741261163
,0.2942198521051174742169110
,0.2882141759042389228540060
,0.2824737232254627694594262
,0.2777778629132638399390487
,0.2725673563707968760638778
,0.2676172797247448054136498
,0.2629270809982800494175592
,0.2584968122235897225458245
,0.2543271754163756170896704
,0.2504195743674669238920671
,0.2467593135459429098954587
,0.2433878013294047959469424
,0.2402861530495328801215749
,0.2374595514993166900374888
,0.2349142005911852848498711
,0.2326574448849577092524044
,0.2306979019307242584346795
,0.2290456091928118054212860
,0.2277121783568872848135811
,0.2267109699800248234780042
,0.2260572822511730251004991
,0.2257685513814188527081939
,0.2258645670302108776628103
,0.2263676994514324525287208
,0.2273031336102029620338527
,0.2286990923934477948353816
,0.2305870543676860895399017
,0.2330019315414957881138491
,0.2359821881327685000329097
,0.2395698650297245213547370
,0.2438104548097189405719831
,0.2487525789961480826573137
,0.2544473710408823863282635
,0.2609474819490617547579348
,0.2683056010338404906434562
,0.2765723705874356119771562
,0.2857936046469205515485612
,0.2960067392676028474873817
,0.3072365333873640635964364
,0.3194901628172735486010936
,0.3327520289942410558481356
,0.3469788338833824647977622
,0.3620957086082865483689375
,0.3779943345367171025905861
,0.3945340330825898300659560
,0.4115465302917815648697797
,0.4288445651054225704612577
,0.4462337158391559421843908
,0.4635259672897747429409776
,0.4805529157332588119366790
,0.4971764017637919086389786
,0.5132948279593874119086649
,0.5288444349908661967774037
,0.5437959412683934790067042
,0.5581478886880041345719405
,0.5719184806635956297427015
,0.5851375999564919494488890
,0.5978401719310850737088003
,0.6100615614906342853984711
,0.6218348547564295225598130
,0.6331892653329865838784940
,0.6441505097217242736817866
,0.6547407829182902982978476
,0.6649794273503892849674912
,0.6748834969815136197723859
,0.6844682335363111436166150
,0.6937474348922541000916908
,0.7027337288083788102710514
,0.7114387746110366617102727
,0.7198734136230919844479104
,0.7280477839083197011404991
,0.7359714099755950700298968
,0.7436532744976652731239142
,0.7511018767534090034843075
,0.7583252810163484403105372
,0.7635272630128547843852971
,0.7721268150216751280368044
,0.7787192339275502694917463
,0.7851150879888383338212066
,0.7913207684300846977976107
,0.7973424035708044366188574
,0.8031858769992856750263854
,0.8088568435615195451049431
,0.8143607418831841915363157
,0.8197028022549195380719311
,0.8248880510093737905563671
,0.8299213166996834978306197
,0.8348072465007851938878503
,0.8395503386257310296514333
,0.8441549854934937702211073
,0.8486255066055986562290059
,0.8529661405969648502178870
,0.8573067745883310442067682
,0.8616474085796972381956493
,0.8659880425710634321845305
,0.8703286765624296261734116
,0.8746693105537958201622928
,0.8790099445451620141511739
,0.8833505785365282081400551
,0.8876912125278944021289362
,0.8920318465192605961178174
,0.8963724805106267901066985
,0.9007131145019929840955797
,0.9050537484933591780844608
,0.9093943824847253720733420
,0.9137350164760915660622231
,0.9180756504674577600511043
,0.9224162844588239540399854
,0.9267569184501901480288666
,0.9310975524415563420177477
,0.9354381864329225360066289
,0.9397788204242887299955100
,0.9441194544156549239843912
,0.9484600884070211179732723
,0.9528007223983873119621535
,0.9571413563897535059510346
,0.9614819903811196999399158
,0.9658226243724858939287969
,0.9701632583638520879176781
,0.9745038923552182819065592
,0.9788445263465844758954404
,0.9831851603379506698843215
,0.9875257943293168638732027
,7.8408535375961019298074461
,7.6183693198372139931962010
,7.4022565211716102595573830
,7.1923134521661982176965466
,6.9883480030970872576290276
,6.7901777033958996554474652
,6.5976293004008681464256370
,6.4103868058320783163139822
,6.2287466138792701997317636
,6.0521044526352172354677350
,5.8809097792927431669340876
,5.7136927821045278008682544
,5.5516472761034014737901998
,5.3941979070826429065732555
,5.2412159982931747492784780
,5.0925761293778188942837915
,4.9481560413168974577047265
,4.8078366002052188576953995
,4.6715017894790555885720096
,4.5390387073647939786269490
,4.4103375544857508216978204
,4.2852916041912507694178203
,4.1637971542305081129597966
,4.0457534624162203584774034
,3.9310626709360891872790944
,3.8196297243510386465459305
,3.7113622856152042039923344
,3.6061706532234318878238355
,3.5039676761853559838755245
,3.4046687213734627697192536
,3.3081915091731755040882490
,3.2144560274418902956483635
,3.1233847557006613193664180
,3.0349021992908067346661483
,2.9489350575541020127445790
,2.8654121136238113187744148
,2.7842641755894650401614854
,2.7054240192730607539317589
,2.6288263325866512154505017
,2.5544076614464357177780585
,2.4821063572146631059922584
,2.4118625256397208111991404
,2.3436179771991416664889130
,2.2773161790646985203068198
,2.2129022080407541039903663
,2.1503227052608981928472076
,2.0895258319502185706539876
,2.0304612265015675731660849
,1.9730799627785402527990755
,1.9173345096101193085758041
,1.8631786914435237711984428
,1.8105676501228991082115272
,1.7594578077625036005571246
,1.7098068306839750984948978
,1.6615735943881020375556545
,1.6147181495324616218312030
,1.5692016888870932156407889
,1.5249865152412551694283138
,1.4828094061450496354837014
,1.4410910731275694551811739
,1.4005673098292985567780988
,1.3612045568289101726833223
,1.3229702176605986352342370
,1.2858326319073689614214118
,1.2497610490789499149144604
,1.2147256032535258540860923
,1.1806972884632445097707887
,1.1476479348040964367783090
,1.1155501852515352645411895
,1.0843774731638249342324798
,1.0541040004558466236517233
,1.0247047164267291119443826
,0.9961552972253706617067337
,0.9684321259385944014042025
,0.9415122732873673072617748
,0.9153734789172293107029077
,0.8899941332698327878247824
,0.8653532600232773930315489
,0.8414304990897673031113868
,0.8182060901599769175973620
,0.7956608567843728163637707
,0.7737761909825272566010312
,0.7525340383721474957212649
,0.7319168838100974516791553
,0.7119077375381518413277604
,0.6924901218267441871390133
,0.6736692947508452489202568
,0.6553879282281992457726005
,0.6376516197604674696108873
,0.6204458156855997552625581
,0.6037564148088784277135233
,0.5875697579586072194501867
,0.5718726180305707673667825
,0.5566521905257656444021563
,0.5418960845877545118298713
,0.5275923145479886056108398
,0.5137292919896689902259368
,0.5002958183431553962350335
,0.4872810780286365162083939
,0.4746746321647856703407342
,0.4624664128654277783780913
,0.4506144062256673965549680
,0.4391730124713401073321961
,0.4281018094912099614113288
,0.4174271617006486967405010
,0.4070717225284870011137173
,0.3970616555979983863799987
,0.3873893862183894198913947
,0.3780476903070244532045763
,0.3690296957424258339486300
,0.3603288848242313657799230
,0.3519390979359475757348719
,0.3438545385339095150634137
,0.3360697795906321116987669
,0.3285797716540070911861449
,0.3213798526847561620733984
,0.3144657598140800369712622
,0.3078336433414511352779641
,0.3014800831200207809068559
,0.2954021077047583876407089
,0.2895972168276353397864398
,0.2848395056528360003156308
,0.2795806678845989545756368
,0.2745906124758029642762835
,0.2698690109582245200137152
,0.2654161727661319969406861
,0.2612330942442832037997391
,0.2573215136893370891257860
,0.2536623546972905374197182
,0.2503081828440500977706051
,0.2472343342107811425822916
,0.2444465858799754476304855
,0.2419517856829494772963329
,0.2397579778489581647793472
,0.2378745414107287514671185
,0.2363123429361367322520948
,0.2350838952813591731239029
,0.2342035360048729253357180
,0.2336876179317019519565690
,0.2335547084673457729486756
,0.2338258002903996213284188
,0.2345245285993176054262221
,0.2356773880597627379707149
,0.2373139288251099321414017
,0.2394669346335620008225931
,0.2421725438654093731649652
,0.2454702900563308365367021
,0.2494030213442149923608326
,0.2540166379776911398380435
,0.2593595940745235806090818
,0.2654820632436205030124654
,0.2724346842720085093425553
,0.2802667842337985826262070
,0.2890239742719195592535186
,0.2987450556284546587804130
,0.3094582130023750266012428
,0.3211765830536801868966279
,0.3338934292639774148447884
,0.3475773427985184294009002
,0.3621681066756603506462397
,0.3775740498377847531585871
,0.3936717789724045735155755
,0.4103090924082093970959306
,0.4273114790988007949401606
,0.4444919856099321386899703
,0.4616634566181092025338728
,0.4786514520794906135670033
,0.4953057786783561233789897
,0.5115087491905246919188244
,0.5271789501339219086162302
,0.5422703393374711522412213
,0.5567674776011506398987194
,0.5706783789137649387512852
,0.5840266519139375445135443
,0.5968443337045770125115496
,0.6091663159306301977835574
,0.6210266098311572058321417
,0.6324564723004953981089216
,0.6434832121507656488290650
,0.6541308348803299699270042
,0.6644201111072508547650273
,0.6743692309120365990793289
,0.6839943226711631130143587
,0.6933098769703996966384807
,0.7023290700060977886920455
,0.7110640033747848143264036
,0.7195258816966839665596467
,0.7277251463108161955162245
,0.7356715782817861981612850
,0.7433743796785916568836683
,0.7508422390795372880489822
,0.7580833853133828181825038
,0.7638799753858555030561206
,0.7719164163175356030421881
,0.7785228290246701821075703
,0.7849316441318402448601432
,0.7911493417979622577718146
,0.7971821296591089511807127
,0.8030359617857815157648815
,0.8087165557029428741842025
,0.8142294069878388551586568
,0.8195798004867314023869085
,0.8247728178858028114106560
,0.8298133437943996382202272
,0.8347060756518611679410924
,0.8394555436754739252691593
,0.8440661423489239645334692
,0.8485421642036189426860915
,0.8528878152112432386999785
,0.8571071889583551373092973
,0.8613265627054670359186161
,0.8655459364525789345279350
,0.8697653101996908331372538
,0.8739846839468027317465726
,0.8782040576939146303558914
,0.8824234314410265289652102
,0.8866428051881384275745290
,0.8908621789352503261838478
,0.8950815526823622247931667
,0.8993009264294741234024855
,0.9035203001765860220118043
,0.9077396739236979206211231
,0.9119590476708098192304419
,0.9161784214179217178397607
,0.9203977951650336164490795
,0.9246171689121455150583984
,0.9288365426592574136677172
,0.9330559164063693122770360
,0.9372752901534812108863548
,0.9414946639005931094956736
,0.9457140376477050081049924
,0.9499334113948169067143112
,0.9541527851419288053236301
,0.9583721588890407039329489
,0.9625915326361526025422677
,0.9668109063832645011515865
,0.9710302801303763997609053
,0.9752496538774882983702241
,0.9794690276246001969795429
,0.9836884013717120955888618
,0.9879077751188239941981806
,7.9971089877137249146699105
,7.7701641262309042446077001
,7.5497293514847392259525805
,7.3355966628909010651682365
,7.1275677109234738537679732
,6.9254541121759931598944604
,6.7290771923793908371180805
,6.5380909206396431443408801
,6.3527303983483447424873702
,6.1727098524868946327615049
,5.9981820360360194044346827
,5.8275693000463650861320275
,5.6623003631047641448503782
,5.5017182420524815000817398
,5.3456919227408628003672675
,5.1940937096589108179500727
,5.0467990998637262123338587
,4.9036867323712440835947746
,4.7646383784273149686327997
,4.6295389448520376518558805
,4.4982764712351297475834144
,4.3707421103171846255008859
,4.2468300880872522640174793
,4.1264376452372637515964016
,4.0094649644921034337130550
,3.8958150892766130191091634
,3.7853938387394285847165065
,3.6781097229478807442148991
,3.5738738576448154660170076
,3.4725999044508983892853848
,3.3742039987507634890562258
,3.2786044888787819751030383
,3.1857223301878345722570884
,3.0954805262674041088644117
,3.0078043191822780855204655
,2.9226210762842534940375572
,2.8398602302405939745710839
,2.7594532206987554268096119
,2.6813334375538624421153600
,2.6054361657956088826892938
,2.5316985319086193761961567
,2.4600594518000891142150977
,2.3904595801425538859064091
,2.3228412614308484585023962
,2.2571484819184779446743505
,2.1933268234638005900194457
,2.1313234184023626127668649
,2.0710869057720371344544219
,2.0125673887899222513908626
,1.9557163935449857206094748
,1.9004868288722118752076540
,1.8468329473752396197028247
,1.7947103075655648218855731
,1.7440757370872916887094561
,1.6948872969973072244442847
,1.6471042470716925620877191
,1.6006870121100160719862515
,1.5555971492100353348320141
,1.5117973159861985976704091
,1.4700226053040670315397165
,1.4286981223653387740313292
,1.3885579625415966908974497
,1.3495688862276749020452371
,1.3116986087336370836453625
,1.2749157736532590323719205
,1.2391899270122654908021786
,1.2044914921759088954900108
,1.1707917454962029069065466
,1.1380627926798358995341687
,1.1062775458585054622062671
,1.0754097013441217267626371
,1.0454337180520207883915873
,1.0163247965760382474087464
,0.9880588588999686949776446
,0.9606125287306777060791774
,0.9339631124388315663864546
,0.9080885805939894472871288
,0.8829675500816072108989374
,0.8585792667903668906603798
,0.8349035888591561649363371
,0.8119209704739551725083402
,0.7896124462057863002684144
,0.7679596158816779372102701
,0.7469446299812902978487728
,0.7265501755523885440979370
,0.7067594626389385181752800
,0.6875562112163009498289057
,0.6689459836444663354271256
,0.6508714310839996963764520
,0.6333384509069232004563332
,0.6163326818533791939813682
,0.5998402146704733262083664
,0.5838475820481335842870863
,0.5683417490661833992859897
,0.5533101041599161051820488
,0.5387404506135821113943507
,0.5246209985935561537218064
,0.5109403577355497994005873
,0.4976875303031227382177804
,0.4848519049379339529437516
,0.4724232510257292405597696
,0.4603917137059824749023562
,0.4487153288752209756573563
,0.4374490340225171136623317
,0.4265524989232483688006425
,0.4160525632242527138693333
,0.4058716764963255507758788
,0.3960364788802249180754700
,0.3865396682447020948458771
,0.3773743065044866673574120
,0.3685338226003243011774657
,0.3600120167512228519512973
,0.3518030661112653834088349
,0.3439015319663769609803694
,0.3363023686445057447436113
,0.3290009343110328332571157
,0.3219930037902060671051174
,0.3152747837670349939642733
,0.3088429305049857909182265
,0.3026945704862976094240423
,0.2968273246009166532743961
,0.2920099782789999931509328
,0.2867052502796840207643925
,0.2816778537582773078717935
,0.2769276947263498156459605
,0.2724553516902901151297556
,0.2682621276663694209752009
,0.2643501084100144393751464
,0.2606947252226896050153471
,0.2573622204431506022004328
,0.2543207320686082240079884
,0.2515766543201343741209541
,0.2491375000074895207369252
,0.2470120317915839303068992
,0.2452104059640779487594386
,0.2437443300536464851901997
,0.2426272247395752090781684
,0.2418744043412035249485115
,0.2415032669509849794220457
,0.2415334897646032319418197
,0.2419872313054152457301171
,0.2428893340313559856546988
,0.2442675181533369432873570
,0.2461525431449764489411081
,0.2485783372735128060604382
,0.2515820514331418844555799
,0.2552040093218725935741986
,0.2594875085875986697736550
,0.2644784071944943915077886
,0.2702244370962725850127129
,0.2767741435457700127642511
,0.2841753691634216205663677
,0.2924731901680501233720122
,0.3017072232316068136626086
,0.3119082753674247143749199
,0.3230943707946508092199167
,0.3352663152668121093746834
,0.3484031146903686648741427
,0.3624577508927648850090009
,0.3773540072226708175229248
,0.3929851630476203228070631
,0.4092153388350585063726328
,0.4258840759892783545126349
,0.4428142343282523429870423
,0.4598226394417532225666889
,0.4767322103936020294412401
,0.4933837840562771415164889
,0.5096457397086042728773236
,0.5254199290250161080706448
,0.5406431947257819281560387
,0.5552847474534848837279810
,0.5693404674261226539044856
,0.5828256376686076212223497
,0.5957676059100875942675657
,0.6081994821774691084570463
,0.6201555208318740852746487
,0.6316682912836920626986625
,0.6427669542838375660309680
,0.6534773225448117228708611
,0.6638217600401193907444508
,0.6738197629789844933512200
,0.6834884920677595232518797
,0.6928432445270966688610770
,0.7018978304222732722550404
,0.7106648571114806411941345
,0.7191559402728788796821391
,0.7273818612547998663231397
,0.7353526866164284969684672
,0.7430778611149978507555147
,0.7505662817141978138124614
,0.7578263576711209426051141
,0.7640523996096270087363678
,0.7716929636954396043435622
,0.7783142814876728987627530
,0.7847368952996159885415750
,0.7909673814736317698503854
,0.7970120335348729323499128
,0.8028768822225916812485025
,0.8085677134283778544343591
,0.8140900841023267497931215
,0.8194493356615347723348464
,0.8246506043524711726533383
,0.8296988290561460033245567
,0.8345987592286046030665148
,0.8393549676541549597885705
,0.8439718718260014185261753
,0.8484537620342675889872908
,0.8528048249455777440886095
,0.8570291445321803758261581
,0.8611306657657654684001614
,0.8652321869993505609741646
,0.8693337082329356535481679
,0.8734352294665207461221712
,0.8775367507001058386961745
,0.8816382719336909312701778
,0.8857397931672760238441811
,0.8898413144008611164181843
,0.8939428356344462089921876
,0.8980443568680313015661909
,0.9021458781016163941401942
,0.9062473993352014867141975
,0.9103489205687865792882008
,0.9144504418023716718622040
,0.9185519630359567644362073
,0.9226534842695418570102106
,0.9267550055031269495842139
,0.9308565267367120421582172
,0.9349580479702971347322205
,0.9390595692038822273062237
,0.9431610904374673198802270
,0.9472626116710524124542303
,0.9513641329046375050282336
,0.9554656541382225976022369
,0.9595671753718076901762402
,0.9636686966053927827502434
,0.9677702178389778753242467
,0.9718717390725629678982500
,0.9759732603061480604722533
,0.9800747815397331530462566
,0.9841763027733182456202599
,0.9882778240069033381942631
,8.1542067684645349601169073
,7.9227715791732054029239407
,7.6979871500726897437516527
,7.4796391684752716599859923
,7.2675229169731201395165954
,7.0614438893308442146690140
,6.8612177391450144270379496
,6.6666697295547807655680117
,6.4774778974876072723532161
,6.2939518162220320363076098
,6.1160818883496341769046012
,5.9420481693557611890810222
,5.7735393208979015611248542
,5.6098083291494145186106834
,5.4507218335394735930776733
,5.2961498690171806558169010
,5.1459657009434067731490359
,5.0000457540812179857425690
,4.8582695970898832626971853
,4.7205199499392200834790856
,4.5866826904234221373712899
,4.4566468453408010219618518
,4.3303045602597309837733519
,4.2075510480929789736137536
,4.0882845205878242111907639
,3.9724061084853405922956426
,3.8598197760365615671673822
,3.7504322344542804223976873
,3.6441528579066391202445629
,3.5408935907603935611120960
,3.4405689615841366091331111
,3.3430957723083638555294783
,3.2483932278246667735288611
,3.1563830128309113831619470
,3.0669888453985039156179937
,2.9801366697582669651467313
,2.8957545360192464833914983
,2.8137725407212204054019367
,2.7341227690105829317701591
,2.6567392384171251151769866
,2.5815578442087012689398762
,2.5085163062941511213921331
,2.4375541175962740503280202
,2.3686124941286208489543696
,2.3016343259875786664281350
,2.2365641303144747631392875
,2.1733480052792226722147007
,2.1119335854498024751535468
,2.0522699984388754756992057
,1.9943078227904107446732951
,1.9379990470712546990483816
,1.8832970301340017371671820
,1.8301564625185999801715298
,1.7785333289610998352969773
,1.7283848719788865722080118
,1.6796695565026338314851273
,1.6323470355261024966608829
,1.5863781167458173015916145
,1.5417247301634930956026892
,1.4983498966249277906115367
,1.4569870101612949486735715
,1.4160656226685608416460127
,1.3763181166769549168549247
,1.3377115802113448417287600
,1.3002140480453712179098602
,1.2637944753541630049653577
,1.2284227121421031903025778
,1.1940694784256333793592830
,1.1607063401518245004950813
,1.1283056858341777850540666
,1.0968407038878453807484448
,1.0662853606471840439695598
,1.0366143790492683418591469
,1.0078032179677156587871423
,0.9798280521818985011606173
,0.9526657529673594471120168
,0.9262938692940274609810558
,0.9006906096196458655356309
,0.8758348242667198801925110
,0.8517059883722332136457567
,0.8282841854003742954049017
,0.8055500912095151511138624
,0.7834849586655974196247598
,0.7620706027949064598203677
,0.7412893864698857360195916
,0.7211242066223111368827858
,0.7015584809789080500408431
,0.6825969661400412835661200
,0.6641830474942712614350171
,0.6463218506553705111628005
,0.6289987539262170690435028
,0.6121995977126672983104072
,0.5959106743547407658567749
,0.5801187184874423419245204
,0.5648108979394814710417450
,0.5499748051804028703415383
,0.5355984493291440218243338
,0.5216702487397866239149380
,0.5081790241833402665960762
,0.4951139926477790553782654
,0.4824647617823358825006608
,0.4702213250162368685103331
,0.4583740573867144951769603
,0.4468810322147480085241966
,0.4357977963440244906223597
,0.4250841143872882144094660
,0.4147673662642433756175819
,0.4047697325888309216601613
,0.3951183991235249215456804
,0.3858063648987838378801030
,0.3768270088956993113527005
,0.3681740949104839732974881
,0.3598417779031961027946807
,0.3518246119727660436993233
,0.3441175601439691034144630
,0.3367160061472804777338297
,0.3296157683286368156316826
,0.3228131160819613376666837
,0.3163047889224601671998016
,0.3100880186411150707392892
,0.3041605552328096595537943
,0.2992858386734600362188985
,0.2939377036153148492481080
,0.2888756388961761234490666
,0.2840997952482242072669294
,0.2796110310332428072754851
,0.2754109672065268021867723
,0.2715020486331823357240012
,0.2678528926855376912641304
,0.2645463936758205014676548
,0.2615418150303928102040629
,0.2588461888876258942815412
,0.2564677114256126988500739
,0.2544158790929397229163555
,0.2527016369159343356365355
,0.2513375398638187374622532
,0.2503379164296403724954132
,0.2497190492665964656193722
,0.2494993623836826990292082
,0.2496996092853589477300602
,0.2503430626716435791756510
,0.2514556973370745129869874
,0.2530663545982971829317876
,0.2552068617502898373317066
,0.2579121040578167822765465
,0.2612200010632432234380929
,0.2651713550239497840799174
,0.2698095218595241151504638
,0.2751798351672528064604251
,0.2813287230761131740841563
,0.2883024180060562713379113
,0.2961451853923081634079040
,0.3048969941716948017784716
,0.3145905771103766346286079
,0.3252478944859688025914579
,0.3368760966213016350145892
,0.3494632182624194949305263
,0.3629739985714353633916573
,0.3773463918517281912023975
,0.3924894820021681551835968
,0.4082835661684470207610786
,0.4245830367840994767902885
,0.4412223966769571736890043
,0.4580251785505785044882998
,0.4748149091437913749125244
,0.4914266765583693574725999
,0.5077175483724636340099323
,0.5235741997701249816898894
,0.5389166716608556617629233
,0.5536979910320598552431193
,0.5679002627822664628354232
,0.5815284432742015008344083
,0.5946032379910671794576160
,0.6071544133260725617518005
,0.6192153449325528136171215
,0.6308193417581204887056856
,0.6419971089557106047607249
,0.6527763013882317277847278
,0.6631810049760394898399340
,0.6732321913772206789516872
,0.6829482151295196423745892
,0.6923453137861670381170143
,0.7014380342935870871201587
,0.7102395668022842833977393
,0.7187619955680558669897096
,0.7270164855840842710321681
,0.7350134227766231820311305
,0.7427625215005891901043356
,0.7502729089178956645156404
,0.7575531926932741466629295
,0.7646115163308709883338565
,0.7714556051196359565125249
,0.7780928047805928393643171
,0.7845301143293537116107927
,0.7907742142824338849038668
,0.7968314910958560481901714
,0.8027080585811113833116792
,0.8084097769080830220289613
,0.8139422695591022050010110
,0.8193109382072631952098618
,0.8245209751663929997889113
,0.8295773732791478227710513
,0.8344849342738551722931106
,0.8392482783882398988950513
,0.8438718589233575873009841
,0.8483599832890305059152070
,0.8527168362350985297837269
,0.8569464937575511642720016
,0.8610529133487853092887576
,0.8650398937266327026307522
,0.8690268741044800959727468
,0.8730138544823274893147413
,0.8770008348601748826567359
,0.8809878152380222759987305
,0.8849747956158696693407251
,0.8889617759937170626827196
,0.8929487563715644560247142
,0.8969357367494118493667088
,0.9009227171272592427087034
,0.9049096975051066360506979
,0.9088966778829540293926925
,0.9128836582608014227346871
,0.9168706386386488160766817
,0.9208576190164962094186762
,0.9248445993943436027606708
,0.9288315797721909961026654
,0.9328185601500383894446600
,0.9368055405278857827866545
,0.9407925209057331761286491
,0.9447795012835805694706437
,0.9487664816614279628126383
,0.9527534620392753561546328
,0.9567404424171227494966274
,0.9607274227949701428386220
,0.9647144031728175361806166
,0.9687013835506649295226111
,0.9726883639285123228646057
,0.9766753443063597162066003
,0.9806623246842071095485949
,0.9846493050620545028905894
,0.9886362854399018962325840
,8.3120556881615783595407265
,8.0761026791920862422102800
,7.8469429894167461725373869
,7.6243560558719778441627568
,7.4081307094821307046572656
,7.1980661377774639575477522
,6.9939720828298357346852754
,6.7956684437081795735480227
,6.6028026442687934860487076
,6.4156231250958004608264673
,6.2338328773383206993230488
,6.0575792107241896999880737
,5.8852975755139285141126493
,5.7184035234582433204764129
,5.5562429559632482423126021
,5.3986836420657766666408861
,5.2455966282741561812485998
,5.0968561402855714348447691
,4.9523395570575914348410151
,4.8119274197928891823039521
,4.6755034470347220931785159
,4.5429545371361452765768263
,4.4141707488617125676455544
,4.2890452584576470584920571
,4.1674742965572084685277332
,4.0493570707875603531533670
,3.9345956803834587489632213
,3.8230950281902069676220890
,3.7147627398667975029411537
,3.6095090421031077454472324
,3.5072468190583756530998016
,3.4078912892985009364110738
,3.3113600614747427108852662
,3.2175733296976010144874181
,3.1264533346652441103685760
,3.0379245910049377243922208
,2.9519137599623497258960469
,2.8683495888419416885994906
,2.7871628520910496362716913
,2.7082862940048233468814942
,2.6316545730320486384812284
,2.5572042076553316292120144
,2.4848735238165886585193221
,2.4146026037840844225002002
,2.3463332367098281849848718
,2.2800088701552532199912093
,2.2155745634680452660347783
,2.1529769422332463157943039
,2.0921641540858209040720794
,2.0330858257877180150785534
,1.9756930215334898015555609
,1.9199382024501034926800003
,1.8657751872577870155822666
,1.8131591140597416167423717
,1.7620464032294813616630336
,1.7123947213655053012359986
,1.6641629462838993802620280
,1.6173111330203782110004340
,1.5718004808141459172077248
,1.5275933010468329964481882
,1.4846529861106161352068966
,1.4437112191937047089851376
,1.4032020474014941235907372
,1.3638561279989287466918313
,1.3256408844021316806305322
,1.2885246784936790209741275
,1.2524767845689419587529301
,1.2174673640529716234226498
,1.1834674409683587636976654
,1.1504488781352419923820207
,1.1183843540854276898954822
,1.0872473406732681144859498
,1.0570120813667605030872210
,1.0276535702030014096663990
,0.9991475313929290003045480
,0.9714703995610161069151900
,0.9445993006063684305217976
,0.9185120331725370457220947
,0.8931870507142215531715124
,0.8686034441500488645360178
,0.8447409250916363410155441
,0.8215798096402203709587297
,0.7991010027431906248551741
,0.7772859831037889355442871
,0.7561167886380857350303586
,0.7355760024741017089056072
,0.7156467394888178512601939
,0.6963126333799752876174693
,0.6775787676132358772207454
,0.6593885171575094572560261
,0.6417473305876556510796149
,0.6246407978645643899184847
,0.6080549709846404526913943
,0.5919763542587768156977290
,0.5763918951491083797478154
,0.5612889756752108549875402
,0.5466554044040390358816239
,0.5324794090408258018243259
,0.5187496296413990348739276
,0.5054551124699709907517331
,0.4925853045304560140493777
,0.4801300488038102165511134
,0.4680795802288352791542536
,0.4564245224693416758121600
,0.4451229620274295695203648
,0.4342311560102790068960132
,0.4237089593445061974641419
,0.4135486066956509665359931
,0.4037792099643194299041227
,0.3943212983899848089741624
,0.3852039671158571931819381
,0.3764209472294378633350220
,0.3679663755564954730203908
,0.3598348034363965108894945
,0.3520212074082926800855375
,0.3445210019977253401712858
,0.3373300547336304799905804
,0.3304447038312112727709291
,0.3238617786352068761424050
,0.3175786232995575497639607
,0.3115931244674107758463322
,0.3066633413144418396356627
,0.3012743129307126621618806
,0.2961802754660354253246624
,0.2913816337644191123423809
,0.2868795358043647047985303
,0.2826759305194525007109974
,0.2787736320596284067541148
,0.2751328859429695850025155
,0.2718567244360179935291910
,0.2688935722838899922138012
,0.2662511179289673846071196
,0.2639382563008865201226172
,0.2619652292298413898130605
,0.2603437772750656908904432
,0.2590873035509368982332035
,0.2582110372794617081382285
,0.2577322124158774596658361
,0.2576702491501198788448335
,0.2580469313848264834021506
,0.2588865795875336939246836
,0.2602162086676564900500352
,0.2620656565683359140450648
,0.2644676540733602587707196
,0.2674578304522700622491982
,0.2710746024726393699211258
,0.2753589107836491023384440
,0.2803537506648041133239246
,0.2861034255038795159897802
,0.2926524625943303092867609
,0.3000440964062276449908495
,0.3083182565363745131215012
,0.3175090037445443824637437
,0.3276413974135894968675586
,0.3387278536387834937393393
,0.3507641526996077563360643
,0.3637253969580827028806880
,0.3775623761040784454046104
,0.3921989416064666222894175
,0.4075310870388894057825269
,0.4234284044579694206156262
,0.4397383596600440425206102
,0.4562934619408223757552889
,0.4729208184656327196293546
,0.4894529948861050527852967
,0.5057386696290216976379384
,0.5216514565849708073841384
,0.5370955643703781978715028
,0.5520076149841894874725767
,0.5663547298894113790623805
,0.5801297281844037811993076
,0.5933446948627771888595817
,0.6060242480241784246430825
,0.6181995215040752000845714
,0.6299036950409998558697566
,0.6411685039160986976369827
,0.6520233384794151820784691
,0.6624940640017870085998197
,0.6726032752977052497911359
,0.6823706887090328354616986
,0.6918136336773099692720734
,0.7009475162793885605339028
,0.7097862026957343362099095
,0.7183423154749486450043605
,0.7266274556241602011752434
,0.7346523685081975951760569
,0.7424270694599018893811149
,0.7499609409633549717000278
,0.7572628095893458866072478
,0.7643410081784562937201599
,0.7712034269911741679592865
,0.7778575564034216904829577
,0.7843105229837764591493965
,0.7905691202947349172092117
,0.7966398354332905329400205
,0.8025288721189139939937718
,0.8082421709970032397407635
,0.8137854276707432443771495
,0.8191641087248258124020595
,0.8243834656900401736123740
,0.8294485467594037153560294
,0.8343642064843080907721173
,0.8391351147987848868581295
,0.8437657679498535845397100
,0.8482605038275686792914598
,0.8526235213713693195103360
,0.8568588983761553645734921
,0.8609705971287684445059085
,0.8649624478593725962483063
,0.8688381096752111343306524
,0.8727137714910496724129985
,0.8765894333068882104953445
,0.8804650951227267485776906
,0.8843407569385652866600367
,0.8882164187544038247423828
,0.8920920805702423628247288
,0.8959677423860809009070749
,0.8998434042019194389894210
,0.9037190660177579770717671
,0.9075947278335965151541131
,0.9114703896494350532364592
,0.9153460514652735913188053
,0.9192217132811121294011514
,0.9230973750969506674834975
,0.9269730369127892055658435
,0.9308486987286277436481896
,0.9347243605444662817305357
,0.9386000223603048198128818
,0.9424756841761433578952278
,0.9463513459919818959775739
,0.9502270078078204340599200
,0.9541026696236589721422661
,0.9579783314394975102246121
,0.9618539932553360483069582
,0.9657296550711745863893043
,0.9696053168870131244716504
,0.9734809787028516625539964
,0.9773566405186902006363425
,0.9812323023345287387186886
,0.9851079641503672768010347
,0.9889836259662058148833808
,8.4705631609492790801141382
,8.2300671265744611559966870
,7.9965087069907321293271707
,7.7696612191237974798241339
,7.5493070089604552563855577
,7.3352388070968856936815428
,7.1272602212517472963781984
,6.9251855321126338793646937
,6.7288389824757315338388253
,6.5378955972958365805425274
,6.3526707905884114424566178
,6.1731428655769535751574040
,5.9975075074297912181009451
,5.8274381628798463950147379
,5.6621915276750547363349142
,5.5016331055698852736668414
,5.3456317369099624059458620
,5.1940594653801417379668237
,5.0467914961636992643434496
,4.9037062032688947255110179
,4.7646851519332393820604921
,4.6296131125512900439389341
,4.4983780531494437227024719
,4.3708711063406342489656708
,4.2469865129979247342362214
,4.1266215483943398112387513
,4.0096764376431064391681502
,3.8960542666412871781744798
,3.7856608931604629475486945
,3.6784048542352492106033424
,3.5741973401288706924106009
,3.4729520087580008080863081
,3.3745848534828422060627418
,3.2790145730399089529782941
,3.1861619263981917349326523
,3.0959499929690270647597572
,3.0083040396733227161973900
,2.9231514592705725164023534
,2.8404217103521358644968586
,2.7600462589738743446332592
,2.6819585219110688711907642
,2.6060938115126703884527615
,2.5323892821298934485696464
,2.4607838779965955922079957
,2.3912182828983410409762200
,2.3236348707031329041683421
,2.2579776579084143151021635
,2.1941922572138845559663878
,2.1322258324967426901253020
,2.0720270550761124006555747
,2.0135460612297864102515632
,1.9567344109281761266316835
,1.9015450477516881999662246
,1.8479322599587761910555628
,1.7958516426728825532421752
,1.7452600611574149436222569
,1.6961156151488361309986885
,1.6483776042188480470684908
,1.6020064941375873335260849
,1.5569638842105804066306973
,1.5132124755631313206549748
,1.4707160403466132958527623
,1.4302045411035246846864766
,1.3901165639980530563946104
,1.3511810308215039810875169
,1.3133657080825955620895229
,1.2766392923696532335497977
,1.2409713846003649351246167
,1.2063324650378302038689071
,1.1726938690537940246372273
,1.1400277636207742926188757
,1.1083071245155284856309663
,1.0775057142170867408026425
,1.0475980604833443621259903
,1.0185594355909650676750289
,0.9903658362241433144035341
,0.9629939639985484189921294
,0.9364212066076467166908515
,0.9106256195794992791547884
,0.8855859086331115959112026
,0.8612814126245222912103827
,0.8376920870739356095313610
,0.8147984882663429351268292
,0.7925817579191721806708415
,0.7710236084114585608517700
,0.7501063085699588572907714
,0.7298126700086141616097279
,0.7101260340190720388164891
,0.6910302590116647047935317
,0.6725307671952295285322521
,0.6545709267271996312231863
,0.6371565218247691175790237
,0.6202733642948370373915168
,0.6039077283862471778874692
,0.5880463415694039408521121
,0.5726763759068580483813093
,0.5577854400304839144197899
,0.5433615717439482795114714
,0.5293932312726005173786348
,0.5158692951866948872563512
,0.5027790510281017200000520
,0.4901121926753372326501790
,0.4778588164870046228749345
,0.4660094182694969888736125
,0.4545548911210739451149720
,0.4434532941380343040727041
,0.4327617349146314906782607
,0.4224401426142985749301317
,0.4124810970397945752985436
,0.4029143236117758153369550
,0.3936600056482845721994579
,0.3847479689202280006554702
,0.3761723361015850142230477
,0.3679276600952098852381766
,0.3600089356369565729565352
,0.3524116131068741886167572
,0.3451316146664719641812269
,0.3381653532045588717025453
,0.3315097541554903326499470
,0.3251622807033283102384758
,0.3191209632125857065254593
,0.3141384451806925603989384
,0.3087110559208874893677432
,0.3035877507627144367141625
,0.2987691970884727710178197
,0.2942568411029172215087613
,0.2900529683826468807517074
,0.2861607708973019636999879
,0.2825303012316220385713450
,0.2792887829527715970456825
,0.2763715198557866181694465
,0.2737868723718002716971398
,0.2715444462421478521996221
,0.2696552361869150038486964
,0.2681317800894259528732277
,0.2669883238076172782271556
,0.2662409828096236052985546
,0.2659079164195729538811008
,0.2660095006464305300575290
,0.2665684913092412067214809
,0.2676101755169834062186851
,0.2691624990596170885481797
,0.2712561526716732451802727
,0.2739245847266001399056279
,0.2772039321436500780571066
,0.2811328131881629110999654
,0.2857519429767892416016650
,0.2911035164006172681894213
,0.2972302864164532709700950
,0.3041742795344101191190589
,0.3119750622867641931534877
,0.3206675112151591289233465
,0.3302790551637577176613547
,0.3408264129503407735555243
,0.3523119338140640599554843
,0.3647197611073073608700668
,0.3780121797623759993811632
,0.3921266496359027131646258
,0.4069741352487097341139588
,0.4224393769982559554421186
,0.4383836445858720343160542
,0.4546502095614635696740891
,0.4710723624867091396950514
,0.4874832302331930655725500
,0.5037261753455434254433953
,0.5196642839747680486794934
,0.5351875138222789152209202
,0.5502165002236477642227896
,0.5647027089976353053657476
,0.5786253392050618726827338
,0.5919859632734066900994208
,0.6048021377983282542700749
,0.6171011613016259556019349
,0.6289147707966420419722908
,0.6402754043065266298384586
,0.6512134648080383225732248
,0.6617566856841492484164746
,0.6719293814394781128029877
,0.6817527881774625431177128
,0.6912454902269236090006643
,0.7004238938443736461891831
,0.7093026528223794757721521
,0.7178950125598917431091195
,0.7262130734299961920541477
,0.7342679881497363725273431
,0.7420701100064771571496181
,0.7496291060037109099667418
,0.7569540451626612931335103
,0.7640534689849112215398463
,0.7709354487952104761916416
,0.7776076331843783107089507
,0.7840772878060762174357023
,0.7903513291482463509751710
,0.7964363534770400043782956
,0.8023386618702817996151566
,0.8080642820740157050707353
,0.8136189877760116040406047
,0.8190083157250566125995306
,0.8242375808927638880518884
,0.8293118896494329206348084
,0.8342361509415007203571690
,0.8390150859758445101022062
,0.8436532378731337322719241
,0.8481549834349551009182733
,0.8525245483667663881632848
,0.8567660242232094658376695
,0.8608833809101081868675465
,0.8648804659106712477978363
,0.8687609844583882301449762
,0.8725284653497039633052168
,0.8762959462410196964654574
,0.8800634271323354296256980
,0.8838309080236511627859386
,0.8875983889149668959461792
,0.8913658698062826291064198
,0.8951333506975983622666604
,0.8989008315889140954269010
,0.9026683124802298285871416
,0.9064357933715455617473822
,0.9102032742628612949076228
,0.9139707551541770280678634
,0.9177382360454927612281040
,0.9215057169368084943883446
,0.9252731978281242275485852
,0.9290406787194399607088258
,0.9328081596107556938690664
,0.9365756405020714270293070
,0.9403431213933871601895476
,0.9441106022847028933497882
,0.9478780831760186265100288
,0.9516455640673343596702694
,0.9554130449586500928305099
,0.9591805258499658259907505
,0.9629480067412815591509911
,0.9667154876325972923112317
,0.9704829685239130254714723
,0.9742504494152287586317129
,0.9780179303065444917919535
,0.9817854111978602249521941
,0.9855528920891759581124347
,0.9893203729804916912726753
,8.6296354386597187158258748
,8.3845735559435894401758560
,8.1465951423627611660549519
,7.9154675979077158132213299
,7.6909668065683014503974846
,7.4728789299328486350759704
,7.2610012405956938508211351
,7.0551421544137857821965554
,6.8551206550131018602201038
,6.6605810143673460643753970
,6.4719131041832618222997553
,6.2891086956404738117498709
,6.1101006445570407166201221
,5.9368457546658257584226703
,5.7685029792794155767410302
,5.6049355534712228532612244
,5.4460101231283069012079068
,5.2915965682693206773024031
,5.1415679389562889411990909
,4.9958004569629910207595458
,4.8541735436154640481731803
,4.7165698449592152741161044
,4.5828752369578831249441464
,4.4529788036945570084412793
,4.3267727892431144809393118
,4.2041525285507868048284763
,4.0850163645621160313226028
,3.9692655585978755539144913
,3.8568041995317106085394698
,3.7475391116854219752951849
,3.6413797925199276050989283
,3.5382383506617518520442900
,3.4380291433046137328233272
,3.3406693690702056187546987
,3.2460783025907757881611815
,3.1541775833302869713747896
,3.0648910792778929490509654
,2.9781448241666486076439924
,2.8938669563781442839456304
,2.8119876595036874533661830
,2.7324391045473808148358330
,2.6551553937521652493103375
,2.5800725060288982604106423
,2.5071282438431174988124894
,2.4362621820045977649726865
,2.3674156171826976624572580
,2.3005315196324507276415261
,2.2355544858835241228689483
,2.1724306928752885603728373
,2.1111078534060441214137427
,2.0515351728584394486176734
,1.9936633071652101190096573
,1.9374443219808339389231833
,1.8828316530257562799732796
,1.8297800675708364437355158
,1.7782456270306412626780457
,1.7281856506350952162875956
,1.6795586801500015372567987
,1.6323244456178165329163221
,1.5864438320909817203840930
,1.5418788473310167663754555
,1.4985925904474139969124735
,1.4565492214512869573184162
,1.4164769746983385534377931
,1.3768190144560403798124071
,1.3383025191079072069300082
,1.3008956058905649655343950
,1.2645673136413093651242434
,1.2292875773615119516790628
,1.1950272035423596950209912
,1.1617578462343693956881907
,1.1294519838429231128884567
,1.0980828966328435303267952
,1.0676246449258346427058086
,1.0380520479754018481344247
,1.0093406635046635599906040
,0.9814667678932873506880696
,0.9544073370006445067303957
,0.9281400276131841486915164
,0.9026431595050551370817971
,0.8778956981020943350912944
,0.8538772377404929558863955
,0.8305679855126832933365222
,0.8079487456941759626616317
,0.7860009047461987696792107
,0.7647064168900472580503447
,0.7440477902501981821714594
,0.7240080735647094201112850
,0.7045708434633738415087123
,0.6857407535522159758301086
,0.6674618934348331977801649
,0.6497393125242618694414887
,0.6325585827368201963238903
,0.6159057486592769414812665
,0.5997673182760486776388120
,0.5841302543093558341524840
,0.5689819661893089630666509
,0.5543103026741444949720972
,0.5401035451444367030404692
,0.5263504015990888573739426
,0.5130400013853841922895072
,0.5001618907002887137736025
,0.4877060289057710273930013
,0.4756627857069565812331291
,0.4640229392485359372066966
,0.4527776751926659848379586
,0.4418849630458147603739860
,0.4314029532350061590939561
,0.4212916162325349711537115
,0.4115439175416558681419588
,0.4021902303000866041315930
,0.3931503477383885281071230
,0.3844549238206102503845329
,0.3760985171997641152152880
,0.3680761453197454180497061
,0.3603832992642175825359629
,0.3530159610209992471219209
,0.3459706236962061254303080
,0.3392443147028747496563028
,0.3328346224768712890984546
,0.3267397276427478902682822
,0.3217068237534849717285113
,0.3162436128307222760192019
,0.3110937416170115321634171
,0.3062581473854369962239730
,0.3017385819024879789473914
,0.2975376745413116919003471
,0.2936590018334526153154229
,0.2900403119422151898554318
,0.2868376976589470661593850
,0.2839707107828565724183534
,0.2814483964247102010247659
,0.2792810795858359229626444
,0.2774805110153041876053237
,0.2760600224311425820999943
,0.2750346906723890594292925
,0.2744214953519202859766324
,0.2742394861659299132305989
,0.2745099438867854013679448
,0.2752565252785816873881686
,0.2765053885566829960929169
,0.2782852847870468382396325
,0.2806275954291399532536389
,0.2835662807829261167213986
,0.2871377284343712976699692
,0.2913804420963827523927137
,0.2963345292751051740509638
,0.3020409315248386294960881
,0.3085403268410205623872855
,0.3158716508642441245235943
,0.3240701628907030618087504
,0.3331650284896434111026053
,0.3431764169181289458876449
,0.3541121791168858057297086
,0.3659642620324215500637877
,0.3787051366637573246443083
,0.3922846476985907826495747
,0.4066278111834674691138503
,0.4216341509011375943138944
,0.4371791356874958345279936
,0.4531181045451999622741823
,0.4692927054991076207812739
,0.4855394479734716495222813
,0.5016994461580117636856357
,0.5176280725656959846858740
,0.5332031212353084415056514
,0.5483302921153859754710425
,0.5629453196088800570606736
,0.5770127474279186374772621
,0.5905219686128555522941497
,0.6034815838640181784313654
,0.6159132360171043485408404
,0.6278459296593866811875273
,0.6393115297979595768040895
,0.6503411442708516565502919
,0.6609640958616889161447716
,0.6712064266639268250713712
,0.6810910157281190313582897
,0.6906378640495451914915748
,0.6998645338401807691752765
,0.7087865970632071244139638
,0.7174180237793313930083627
,0.7257714906181147451746938
,0.7338586154639268332999791
,0.7416901336042663883674209
,0.7492760308372290456446763
,0.7565435519840414402281681
,0.7637477511222676707092205
,0.7706506171371741986675374
,0.7773420660438802309855078
,0.7838295155075568620972604
,0.7901200159696950553467332
,0.7962202823438551124723972
,0.8021367212804465518516395
,0.8078754548312373495733141
,0.8134423411779856394332455
,0.8188429929503829862724729
,0.8240827934934563669955310
,0.8291669112443592615235843
,0.8341003122413932491241439
,0.8388877709162659845887333
,0.8435338798549739669496716
,0.8480430599401633795508815
,0.8524195724771996829360887
,0.8566675336306379673345646
,0.8607909285204263794000212
,0.8647936190140108614343717
,0.8686793385230340280855899
,0.8724516717974099000443289
,0.8761140278675685344467183
,0.8797763839377271688491078
,0.8834387400078858032514972
,0.8871010960780444376538867
,0.8907634521482030720562761
,0.8944258082183617064586656
,0.8980881642885203408610550
,0.9017505203586789752634445
,0.9054128764288376096658340
,0.9090752324989962440682234
,0.9127375885691548784706129
,0.9163999446393135128730023
,0.9200623007094721472753918
,0.9237246567796307816777812
,0.9273870128497894160801707
,0.9310493689199480504825601
,0.9347117249901066848849496
,0.9383740810602653192873390
,0.9420364371304239536897285
,0.9456987932005825880921179
,0.9493611492707412224945074
,0.9530235053408998568968968
,0.9566858614110584912992863
,0.9603482174812171257016757
,0.9640105735513757601040652
,0.9676729296215343945064546
,0.9713352856916930289088441
,0.9749976417618516633112336
,0.9786599978320102977136230
,0.9823223539021689321160125
,0.9859847099723275665184019
,0.9896470660424862009207914
,8.7891778450949438195038965
,8.5395297721220142506126649
,8.2971123750264350604766150
,8.0616874167231280523537862
,7.8330244033886842203173728
,7.6109028597404346783150686
,7.3951135499785323190735653
,7.1854587913142040633829311
,6.9817520531592522914365873
,6.7836040069712355560227479
,6.5913291979347894411489506
,6.4046011577072112785913305
,6.2235960092405893107070369
,6.0465591651361023650679272
,5.8751121179078804601658703
,5.7085276747853423984224719
,5.5466702970402597117072219
,5.3894077200205758870765749
,5.2366108596535489994039381
,5.0881538036565459037774417
,4.9439138422859443267043389
,4.8037715040716273406928849
,4.6676105743452538376914163
,4.5353180859796760060476117
,4.4067842809378943158549191
,4.2819025472222511652375943
,4.1605693386691307011915342
,4.0426840853707552980722539
,3.9281491012168094911771732
,3.8168694941010552490467944
,3.7087530607958503203747114
,3.6037103363198119687638155
,3.5016541790837445446982201
,3.4024999802889013267304108
,3.3061657910608359678406032
,3.2125717248341523202270764
,3.1216402469217991999528294
,3.0332960283849801363942333
,2.9474658838523324355662680
,2.8640787110118135494474245
,2.7830654317622052218439421
,2.7043589350096457479821765
,2.6278940210840153746119086
,2.5536073476821563588146091
,2.4814373776749909517036485
,2.4113243276995257602379752
,2.3432101190175358418343876
,2.2770383293269493840682571
,2.2127541460544004614519054
,2.1503043209871064433968968
,2.0896371262050212891381307
,2.0307023112764865935275793
,1.9734510616823670581254646
,1.9178359584347173250051810
,1.8638109388570898161674450
,1.8113312584945442385020442
,1.7603534541223679887878006
,1.7108353078234881383679067
,1.6627358121054780504266546
,1.6160151360289769506550783
,1.5706345923202842396193546
,1.5265566054417325503322900
,1.4837446805943661498616848
,1.4429212663978570052591976
,1.4025391854796664947713225
,1.3633198926413088170050969
,1.3252309244787097153306377
,1.2882407565208016109181699
,1.2523187773397377320350188
,1.2174352634386718108316927
,1.1835613548982997222935865
,1.1506690317641883325450181
,1.1187310911577221794743764
,1.0877211250943348286313039
,1.0576134989934964369950876
,1.0283833308657597260804550
,1.0000064711630167746392317
,0.9724594832789571485776037
,0.9457196246876953260596110
,0.9197648287094959407284023
,0.8945736868937046448735373
,0.8701254320101640127305132
,0.8463999216417213977692313
,0.8233776223717210740460359
,0.8010395945616031188052375
,0.7793674777149601773373888
,0.7583434764256814508698312
,0.7379503469094728096422386
,0.7181713841202971293498081
,0.6989904094560025482607557
,0.6804124396696317189636716
,0.6623815702452924281118385
,0.6449032114434197771046797
,0.6279631787227324402067552
,0.6115477612139793572865187
,0.5956437130346643460399036
,0.5802382452574839089010084
,0.5653190185542484869074542
,0.5508741365408185153285103
,0.5368921398527919386367557
,0.5233620009863494404456219
,0.5102731199438336195939314
,0.4976153207294895519652300
,0.4853788487471680235252336
,0.4735543691586818204619647
,0.4621329662698379081575695
,0.4511061440198056993189368
,0.4404658276561804752802232
,0.4301690650293396589454176
,0.4202782163806373372239023
,0.4107525437852151406481482
,0.4016230774133930370162204
,0.3928092034487742356674289
,0.3843425045017294650051554
,0.3762180250295358852063998
,0.3684313014192647228739474
,0.3609783803797745882491199
,0.3538558404220657482852630
,0.3470608164039628573682705
,0.3405910277328499935478590
,0.3344448112362179981182919
,0.3293638770559290662731655
,0.3238673785084258960331738
,0.3186936265078888497193077
,0.3138438343952860143382111
,0.3093200654476827016203799
,0.3051252983525080675342167
,0.3012634990155417247237324
,0.2976576820779648357984115
,0.2944981689321370943446254
,0.2916857493847203053327632
,0.2892301626556213478558277
,0.2871424575879640839204399
,0.2854351394932626573286427
,0.2841223249444402854102520
,0.2832199034683001159784510
,0.2827456889927910110849041
,0.2827195775064975102885967
,0.2831636929112312794920570
,0.2841025097674325095020720
,0.2855629480482277937625213
,0.2875744231163857578259524
,0.2901688284093253966666737
,0.2933804130316011726797853
,0.2972455409329441966548302
,0.3018022695064857541247250
,0.3070897046473816116574085
,0.3131470766082012913145149
,0.3200124699782590509400393
,0.3277211619901186923087266
,0.3363035108040079990132654
,0.3457823882859093478359114
,0.3561701878799022336075097
,0.3674655173109401262721008
,0.3796497779275802564313835
,0.3926839572433379332849768
,0.4065060749440774778840080
,0.4210298109291926160757669
,0.4361448593450714117381040
,0.4517194628038144754711425
,0.4676053460110838333463334
,0.4836448720595765693452961
,0.4996798312783638507106332
,0.5155608224097005809483107
,0.5311559517434106814093298
,0.5463575976465478989396729
,0.5610863118903253177194301
,0.5752914814253693442935855
,0.5889490070584558756294769
,0.6020567612354958964004936
,0.6146288832847072169940361
,0.6266899621585557689229518
,0.6382699469966973682133471
,0.6494002711559794249751576
,0.6601109562873354041911966
,0.6704298212551917934831636
,0.6803814434478683281781741
,0.6899873807396896818744381
,0.6992665123646504277132863
,0.7082354757486456486859083
,0.7169090860601964321219270
,0.7253006891513037457386304
,0.7334224382127428887301335
,0.7412855035221420640922929
,0.7489002303461895770908541
,0.7562296580921851196777084
,0.7634226183433567847202994
,0.7703477990731336655372274
,0.7770598141626655630531673
,0.7835662478395311048018357
,0.7898742968474253833832677
,0.7959908053148645468155564
,0.8019222945762949361636629
,0.8076749889138372662245047
,0.8132548379736734833755918
,0.8186675364578226421485851
,0.8239185415551774083198211
,0.8290130884191942994831948
,0.8339562038388739217964485
,0.8387527181901051065437969
,0.8434072759514478212494737
,0.8479243455571571219664406
,0.8523082298347254281978280
,0.8565630780623471052237505
,0.8606928991603843837054910
,0.8647015729003842965383342
,0.8685928538544988031233629
,0.8723703636273923978095013
,0.8760375724450563117429169
,0.8795977802571276482623830
,0.8831579880691989847818490
,0.8867181958812703213013151
,0.8902784036933416578207812
,0.8938386115054129943402472
,0.8973988193174843308597133
,0.9009590271295556673791793
,0.9045192349416270038986454
,0.9080794427536983404181115
,0.9116396505657696769375775
,0.9151998583778410134570436
,0.9187600661899123499765096
,0.9223202740019836864959757
,0.9258804818140550230154417
,0.9294406896261263595349078
,0.9330008974381976960543739
,0.9365611052502690325738399
,0.9401213130623403690933060
,0.9436815208744117056127720
,0.9472417286864830421322381
,0.9508019364985543786517042
,0.9543621443106257151711702
,0.9579223521226970516906363
,0.9614825599347683882101023
,0.9650427677468397247295684
,0.9686029755589110612490344
,0.9721631833709823977685005
,0.9757233911830537342879666
,0.9792835989951250708074326
,0.9828438068071964073268987
,0.9864040146192677438463647
,0.9899642224313390803658308
,8.9490950118484402509011488
,8.6948429862144660518197270
,8.4479699617086438934165926
,8.2082324233024710480322028
,7.9753936490419485849656667
,7.7492265082443667623124384
,7.5295151162189881688391324
,7.3160554751887509894459072
,7.1086552899555677242915408
,6.9071331782099996132728847
,6.7111341428747497417361956
,6.5210450204259053919031430
,6.3368407153230750239458757
,6.1565108113073092610534331
,5.9819533126200976624886607
,5.8123457332002450570485053
,5.6475503567884484112937571
,5.4874327930067172687245147
,5.3318618465057046051924772
,5.1807094921070824256048581
,5.0338509052318860526042954
,4.8911645070168452420489302
,4.7525319964734373812120793
,4.6178383549387618245418707
,4.4869718188013720805429330
,4.3598238239405002758530827
,4.2362889293067134133252694
,4.1162647281133786236750893
,3.9996517541122238448281223
,3.8863533883843142113789781
,3.7762757577038388312473671
,3.6693277593640876155234309
,3.5654207068481715836583135
,3.4644684126876388319260514
,3.3663874696301885336424675
,3.2710965365339319532722584
,3.1785166731593745836903508
,3.0885711850920447574253558
,3.0011855604802670782760288
,2.9162874084612093739110605
,2.8338063992623387932212609
,2.7536742059681711403129611
,2.6758244479314789998625201
,2.6001926358039311182324127
,2.5267161180585424595790300
,2.4553340293502707858408485
,2.3859872397617860606544582
,2.3186183061241134595320545
,2.2531714243847513756691114
,2.1895923834206123537171607
,2.1278285201753805999658198
,2.0678286760837050195505071
,2.0095431547464612798137296
,1.9529236808225916011139134
,1.8979233601040346179900098
,1.8444966407413034836793031
,1.7925992755881636764314635
,1.7421882856349022450359598
,1.6932219245005835084327828
,1.6456596439556516742186432
,1.5994620604471754266029393
,1.5545909225999139380292036
,1.5110090796673143476169798
,1.4686804509073974056576617
,1.4283257616223590247273023
,1.3884024791529088194153019
,1.3496303186104829929803373
,1.3119771913338758029254905
,1.2754119386342976927295467
,1.2399043062449890406639952
,1.2054249195446740117176887
,1.1719452595366539604526679
,1.1394376395661847123363941
,1.1078751827596557966160162
,1.0772318001699032752327412
,1.0474821696128691073113259
,1.0186017151816681991505220
,0.9905665874250114688592816
,0.9633536441778800529789351
,0.9369404320333578617407966
,0.9113051684456763279484903
,0.8864267244557477720690031
,0.8622846080318277151022244
,0.8388589480193107128513930
,0.8161304786950075440543628
,0.7940805249226037254572930
,0.7726909879074184139824411
,0.7519443315504441560648274
,0.7318235694041962391409584
,0.7123122522362009823027051
,0.6933944562093030672400573
,0.6750755744005118019757106
,0.6572997134886999770486682
,0.6400726588357845692200954
,0.6233804814730752319462681
,0.6072097277627420686130222
,0.5915474113697812841294876
,0.5763810059351978098973746
,0.5616984384776831928931529
,0.5474880835554478686333368
,0.5337387582247586914618864
,0.5204397178371363841264952
,0.5075806527232890053014103
,0.4951516858185456837482263
,0.4831433712917017619936644
,0.4715466942480548429017517
,0.4603530715864385114421964
,0.4495543540964399009673969
,0.4391428298989469292123999
,0.4290751967177905967787410
,0.4194157075978336979282801
,0.4101234422051742711801126
,0.4012300546137891887887861
,0.3926545605357552037872892
,0.3844295655684222823289531
,0.3765506557151924726944969
,0.3690139469600850485875299
,0.3618161080046984334757099
,0.3549543861449281911824016
,0.3484266369234912952279615
,0.3422313586600144175164928
,0.3371047456415294241161007
,0.3315774765299406845464603
,0.3263824998801432286654745
,0.3215213100107608412692173
,0.3169962861707366075236791
,0.3128107601335249343676992
,0.3089690899421312364481196
,0.3053767833322006408636184
,0.3022644866385200690395152
,0.2995108095602420084091477
,0.2971261913573927104792460
,0.2951224052158556987457416
,0.2935127047542620548625791
,0.2923119767903381571727550
,0.2915368986353548685919179
,0.2912060809814756012769976
,0.2913402130763492747789201
,0.2919621900405671155454002
,0.2930972094479041833992028
,0.2947728307443456818859318
,0.2970189785694067885479797
,0.2998678648582271399902766
,0.3033537896946909562245764
,0.3075128055654908210136966
,0.3123821811565269390698063
,0.3179996214916629981850349
,0.3244021909911167234064067
,0.3316248788180127804459119
,0.3396987708889160351155567
,0.3486487889932036732254517
,0.3584910170172976862090763
,0.3692296790713491816404712
,0.3808539225881155121378185
,0.3933346496415917048494748
,0.4066217619233391533661859
,0.4206422753389214008734598
,0.4352998128471906036374151
,0.4504759493084193322509634
,0.4660337366692695604264429
,0.4818234579419119478771449
,0.4976902498471061364604395
,0.5134828569654125152155189
,0.5290624183748788844638966
,0.5443100763826204113726703
,0.5591323388656910253757815
,0.5734635268026706533817105
,0.5872651948578624381269719
,0.6005229759714593162911456
,0.6132416934240747519169190
,0.6254397592787278581383248
,0.6371437922443444756837039
,0.6483840761483705694701030
,0.6591913460416828351995377
,0.6695944198845467099090456
,0.6796196546229686941131831
,0.6892902550566064601156313
,0.6986265673916173257751439
,0.7076464517807397047732820
,0.7163657067416611123888970
,0.7247984582729528613143088
,0.7329574798935531987353897
,0.7408544410731596752128780
,0.7485000953224980602129790
,0.7558790928766624395152007
,0.7630767370819683259597355
,0.7700976750638501844292705
,0.7767597584653146425281989
,0.7832864558844246927193922
,0.7896132238026518646023533
,0.7957470473840032587631299
,0.8016945727926697573550996
,0.8074621353157384051613121
,0.8130557837190832692897402
,0.8184813015218841414366580
,0.8237442257326422767604868
,0.8288498634575988122108470
,0.8338033066508301338615183
,0.8386094451558046003469826
,0.8432729781901010523981199
,0.8477984246519346678283569
,0.8521901330295914567258819
,0.8564522919254506927444481
,0.8605889417008316666368728
,0.8646039861705671070168933
,0.8685012011404434906225447
,0.8722842354892281768741213
,0.8759566024375016191072518
,0.8795216643853440707800928
,0.8829826222489390863401582
,0.8864435801125341019002235
,0.8899045379761291174602889
,0.8933654958397241330203542
,0.8968264537033191485804196
,0.9002874115669141641404849
,0.9037483694305091797005502
,0.9072093272941041952606156
,0.9106702851576992108206809
,0.9141312430212942263807463
,0.9175922008848892419408116
,0.9210531587484842575008770
,0.9245141166120792730609423
,0.9279750744756742886210077
,0.9314360323392693041810730
,0.9348969902028643197411384
,0.9383579480664593353012037
,0.9418189059300543508612691
,0.9452798637936493664213344
,0.9487408216572443819813998
,0.9522017795208393975414651
,0.9556627373844344131015305
,0.9591236952480294286615958
,0.9625846531116244442216612
,0.9660456109752194597817265
,0.9695065688388144753417919
,0.9729675267024094909018572
,0.9764284845660045064619226
,0.9798894424295995220219879
,0.9833504002931945375820533
,0.9868113581567895531421186
,0.9902723160203845687021840
,9.1092911147935584637025386
,8.8504200509007251440607433
,8.5990771719814116380575797
,8.3550141249122944486771303
,8.1179881781755440783854283
,7.8877655810431335225985094
,7.6641236971950039702505819
,7.4468520197960348383503515
,7.2357522474390005839950391
,7.0306376437853348448925317
,6.8311199375681930234804895
,6.6376678605374044295217573
,6.4502686124069770201572283
,6.2666328531562118797637595
,6.0889606804019269503669420
,5.9163257472054002761296942
,5.7485881632011102126966762
,5.5856114304369883782896977
,5.4272622664933471980930335
,5.2734105571396350242707740
,5.1239293824782272679385642
,4.9786950696889977763248680
,4.8375872387573952693173851
,4.7004888216418283519715260
,4.5672860476598264867220678
,4.4378683969213978954826416
,4.3121285289336759305456326
,4.1899621954122236999751294
,4.0712681457576884724858246
,3.9559480316667046118084272
,3.8439063047283346108429214
,3.7350502158806420105463530
,3.6292895495635724145699896
,3.5265365232014929119941371
,3.4267062705508033459977923
,3.3297159952774904034811243
,3.2354853495847213373792783
,3.1439362716232697181339972
,3.0549929211525581607133972
,2.9685816169055740942894772
,2.8846307756431066593449941
,2.8030708528914862753822490
,2.7238342853480910221719569
,2.6468554349349169285687822
,2.5720705343491561123414613
,2.4994176345671474948062496
,2.4288365530940474457111122
,2.3602688244870746459014299
,2.2936576518584348427509667
,2.2289478598681200516296030
,2.1660858490654857355650620
,2.1050195515410425883828793
,2.0456983878519894304304216
,1.9880732251863646453671208
,1.9320963367318315651033345
,1.8777213622160624506562954
,1.8249032695866924669303444
,1.7735983177997833859507182
,1.7237640206867499426124368
,1.6753591118705923879161901
,1.6283435107032990796227523
,1.5826782891971777900153029
,1.5383256399237816847147542
,1.4952488448550280697446624
,1.4534122451219786409382095
,1.4135348421010385244755980
,1.3740787723009093568293792
,1.3357620101895337771935601
,1.2985528493212938894174613
,1.2624205042032141665941936
,1.2273350850954627411226738
,1.1932675735824083140812490
,1.1601897988967266872606388
,1.1280744149798875852752644
,1.0968948782632621519184113
,1.0666254261549508175477285
,1.0372410562183398408109269
,1.0087175060292834505304427
,0.9810312336997849547159944
,0.9541593990570508276860551
,0.9280798454679528575184122
,0.9027710823001775519713874
,0.8782122680127147917872321
,0.8543831938697767913737380
,0.8312642682736633981122054
,0.8088365017135384915647478
,0.7870814923286221231890636
,0.7659814120863345232592678
,0.7455189935787902566488583
,0.7256775174449016097000253
,0.7064408004297364485069011
,0.6878135058218811659358494
,0.6697404516736303881074832
,0.6522267271733469540251349
,0.6352581861240791383238502
,0.6188211680904082134802024
,0.6029024903787979505764838
,0.5874894407452461164709234
,0.5725697708592656365311768
,0.5581316905577800024929047
,0.5441638629276334127027326
,0.5306554002610112119597829
,0.5175958609344906147242682
,0.5049752472693861404806626
,0.4927840044384487194761846
,0.4810130204934067732480685
,0.4696536275972193474892435
,0.4586976045508582289222943
,0.4481371807231206982891081
,0.4379650414997532381633505
,0.4281373886473666678931238
,0.4187208303354996163925250
,0.4096741238285950825748216
,0.4009922570264806696016535
,0.3927055753585200204014427
,0.3847362088323855178195743
,0.3771175379407541439213958
,0.3698463259163931038386863
,0.3629199369666334384909590
,0.3563363673267858633408878
,0.3500942813902136463433123
,0.3449243264179387424839263
,0.3393687752777648225510632
,0.3341551885478089012337932
,0.3292853450859473118939036
,0.3247619429993603423767468
,0.3205886690795509696982890
,0.3167702741210761119283745
,0.3131916156606865953015983
,0.3101305513476884101464748
,0.3074396569627693143189617
,0.3051300740372455133631036
,0.3032142963511501587703378
,0.3017063146613913615645686
,0.3006217657249793395735082
,0.2999780831403722758388142
,0.2997946292188222727759239
,0.3000928247587772990101485
,0.3008962543981377746327155
,0.3022307330735737318505585
,0.3041243256271333739171325
,0.3066072985594104349793554
,0.3097119763892123844861715
,0.3134724607870830181965971
,0.3179241956048736161832835
,0.3231033132487088899154060
,0.3290457202297455419071071
,0.3357858724669010030972061
,0.3433551880106647802293196
,0.3517800742106584332979935
,0.3610795512381512750721413
,0.3712625193487381070056585
,0.3823247693152712067821142
,0.3942459299583715992554289
,0.4069866307468890109788617
,0.4204862716407319900291384
,0.4346618544399182271220639
,0.4494083438096372895564912
,0.4646009427875381070371930
,0.4800994753151688332337699
,0.4957547599672723626085258
,0.5114164588139471501193611
,0.5269415628447216004559550
,0.5422024095673581012277964
,0.5570931304803005135184435
,0.5715336628129039642232101
,0.5854709029254461238878093
,0.5988771105708711184334447
,0.6117461534820874957674164
,0.6240884664626574762635869
,0.6359256737494198841176285
,0.6472856678832752397312333
,0.6581987787333500872222203
,0.6686944901484146441816847
,0.6788006892381492907162510
,0.6885422314888219874617903
,0.6979410445403694263077909
,0.7070163655455812268257887
,0.7157851278259320659813625
,0.7242623666229165424468306
,0.7324615778856325976065023
,0.7403950082002647148371466
,0.7480655419601942579532761
,0.7554954970903112743130237
,0.7627086665471162207907696
,0.7697241037319548784267909
,0.7764406943074647626801266
,0.7829890336818798868279146
,0.7893357791950537105662988
,0.7954880703206441694419482
,0.8014526893892622849691065
,0.8072360924512773650008057
,0.8128444358561525140416393
,0.8182835993434183219363831
,0.8235592062693295467568078
,0.8286766414601154373542613
,0.8336410670582651283311293
,0.8384574366053577643143058
,0.8431305075240312918438690
,0.8476648522072381952696674
,0.8520648681482357877925438
,0.8563347878399762969081621
,0.8604786891900241263542171
,0.8645005065052715487183832
,0.8684040406117440324962331
,0.8721929650970334790827110
,0.8758708254854046248993882
,0.8794410308105090612329491
,0.8829068425144828147210774
,0.8862713714099867967632917
,0.8896359003054907788055061
,0.8930004292009947608477205
,0.8963649580964987428899349
,0.8997294869920027249321492
,0.9030940158875067069743636
,0.9064585447830106890165780
,0.9098230736785146710587924
,0.9131876025740186531010067
,0.9165521314695226351432211
,0.9199166603650266171854355
,0.9232811892605305992276499
,0.9266457181560345812698642
,0.9300102470515385633120786
,0.9333747759470425453542930
,0.9367393048425465273965074
,0.9401038337380505094387217
,0.9434683626335544914809361
,0.9468328915290584735231505
,0.9501974204245624555653649
,0.9535619493200664376075792
,0.9569264782155704196497936
,0.9602910071110744016920080
,0.9636555360065783837342224
,0.9670200649020823657764367
,0.9703845937975863478186511
,0.9737491226930903298608655
,0.9771136515885943119030799
,0.9804781804840982939452942
,0.9838427093796022759875086
,0.9872072382751062580297230
,0.9905717671706102400719374
,9.2696701103714751468487520
,9.0061676939779324868595722
,8.7503432210845648597796753
,8.5019440213082262403077038
,8.2607216434610268862570592
,8.0264358098876442682012566
,7.7988570722508043786547205
,7.5777682475208321122295274
,7.3629647994935467636423709
,7.1542543876515454215336831
,6.9512125532083164358709837
,6.7542190756611946156340309
,6.5629169998868865931740402
,6.3775046221721147787775408
,6.1960682715542123588647883
,6.0204036695939349144168773
,5.8497215137860756328791467
,5.6838832151951086402164037
,5.5227534293097555462281889
,5.3661999790133458887453344
,5.2140938717229223797744453
,5.0663093573933730695557642
,4.9227239873336872122422392
,4.7832186488762005183161818
,4.6476775648520520789475086
,4.5159882575803527160474005
,4.3880414838489576467850384
,4.2637311503205079787903742
,4.1429542187828580779296317
,4.0256106088179244295588433
,3.9116030961218801742518281
,3.8008372717097200776947830
,3.6932214138590770957648601
,3.5886661267154633669917985
,3.4870850845023757536011999
,3.3883940367820728489789417
,3.2925112270674694592287324
,3.1993572249610351398985131
,3.1088548607441413018648291
,3.0209291616867628427200998
,2.9355072900585783557403374
,2.8525184828397023295565305
,2.7718939931207522420208988
,2.6935670331793275522613840
,2.6174727190534254894771493
,2.5435480172019770961355789
,2.4717316917372049722700922
,2.4019642541638903665557336
,2.3341879140129764280686686
,2.2683465310134995895907650
,2.2043855686378486247178898
,2.1422520489807097554546544
,2.0818945089344302878942017
,2.0232629576251239811313098
,1.9663088350749267085859628
,1.9109849720568812259102742
,1.8572455511098526770297212
,1.8050460686819616018539136
,1.7543432983719418061241413
,1.7050952552388323191223662
,1.6572611611514171947590057
,1.6108014111497053200139362
,1.5656775407917571385496558
,1.5218521944600238438027873
,1.4792890946023222742411463
,1.4379530118834522589565950
,1.3985612255154449279359596
,1.3595805604892412521422784
,1.3217272520706360161568682
,1.2849699834088055272474094
,1.2492783495433545937203235
,1.2146228325677981274566264
,1.1809747775608907538469339
,1.1483063692690140822350031
,1.1165906095237332351644000
,1.0858012953795384003541358
,1.0559129979577304148108396
,1.0269010419833168867853601
,0.9987414860027831187139213
,0.9714111032716046256751952
,0.9448873633015465456352899
,0.9191484140590194806819113
,0.8941730648071909426377601
,0.8699407695859801004090173
,0.8464316113255898610390204
,0.8236262865907183483571430
,0.8015060909542283118511818
,0.7800529050012204868025378
,0.7592491809675617764341382
,0.7390779300213985436585062
,0.7195227102016200637635279
,0.7005676150319115613740450
,0.6822177106869325990956554
,0.6644178415222806721729398
,0.6471734994695985676571581
,0.6304708183563714207764406
,0.6142964202730821776654579
,0.5986374083201233542439468
,0.5834813601391413140362374
,0.5688163222643337624262472
,0.5546308053345199162720291
,0.5409137802125999483493501
,0.5276546750657173934229149
,0.5148433734666185701556174
,0.5024702135843183148367075
,0.4905259885421668353266966
,0.4790019480311584199050401
,0.4678898012716383170150891
,0.4571817214372527748977859
,0.4468703516619535465181912
,0.4369488127744536321017677
,0.4274107128719567549879343
,0.4182113517288581494568689
,0.4094232011870064247283096
,0.4010038123424094491653591
,0.3929826345178403790292521
,0.3852838500443138691764489
,0.3779412051531336191878552
,0.3709521848729392945465122
,0.3643149300356775532883091
,0.3580282749332708291944982
,0.3528172901677835704425945
,0.3472359058315016566709232
,0.3420062700351160778211579
,0.3371304483208140689853849
,0.3326114588931020632500690
,0.3284533435783556498677171
,0.3246612443111541734808156
,0.3210958311656589292404362
,0.3180898990251642133308962
,0.3154656748445183178652940
,0.3132350007970934879786284
,0.3114110831401920576055886
,0.3100086336241745788022683
,0.3090440129569849703194961
,0.3085353730457791598951189
,0.3085027753281096574156095
,0.3089683021952024932765823
,0.3099561369727695803177880
,0.3114925964193079876984882
,0.3136061062922210207482010
,0.3163270970613185073538887
,0.3196877900757733592662646
,0.3237218310650311625664699
,0.3284637531706171564849228
,0.3339482053674660555486753
,0.3402089065029433867515252
,0.3472772813047273476882992
,0.3551807364889472684588156
,0.3639405688243478875776304
,0.3735695105977248076101205
,0.3840689881874985722731708
,0.3954262268470268293363290
,0.4076114322734346040455478
,0.4205753532537097050258978
,0.4342476310363401204028833
,0.4485363709859296332815859
,0.4633293464605383604748567
,0.4784971175051812020129205
,0.4938981189208702105020166
,0.5093854520460914248047857
,0.5248147407767347338847230
,0.5400521566270563011968875
,0.5549815483741417088126013
,0.5695097125433231655122768
,0.5835691462403901352828939
,0.5971180811685361522478388
,0.6101380847342876556638203
,0.6226299067120919517037692
,0.6346084372207904111817811
,0.6460976355925887038011979
,0.6571260936641986072359600
,0.6677237110265573649670046
,0.6779190024272312431463661
,0.6877385260918293941045931
,0.6972058378108539899997709
,0.7063416825661700260141629
,0.7151642831453670634545006
,0.7236897284681572672937477
,0.7319323570816859136911603
,0.7399050867088255989401091
,0.7476156530789936915937233
,0.7550869306877066033933943
,0.7623168473614517770542420
,0.7693411354200293539307154
,0.7761013232278088924687154
,0.7826727910839065271986215
,0.7890408694817760970607878
,0.7952128671817346727834774
,0.8011957153974839096477467
,0.8069960018350281760746157
,0.8126199998289901360593035
,0.8180736935153467559445062
,0.8233627997645014406913333
,0.8284927874437478800828671
,0.8334688944539819788204227
,0.8382961428706775519614780
,0.8429793524163813334126871
,0.8475231524442499164706533
,0.8519319926839067358415036
,0.8562101532016952454284819
,0.8603617542102227622180521
,0.8643907662092019661415065
,0.8683010201573132524899279
,0.8720962160726591916315442
,0.8757799274380426712838243
,0.8793555993329514874901065
,0.8828265412270376311099085
,0.8861959202267823965115667
,0.8894667646210664413430891
,0.8927376090153504861746114
,0.8960084534096345310061338
,0.8992792978039185758376561
,0.9025501421982026206691785
,0.9058209865924866655007008
,0.9090918309867707103322232
,0.9123626753810547551637455
,0.9156335197753387999952679
,0.9189043641696228448267902
,0.9221752085639068896583126
,0.9254460529581909344898349
,0.9287168973524749793213573
,0.9319877417467590241528796
,0.9352585861410430689844020
,0.9385294305353271138159243
,0.9418002749296111586474467
,0.9450711193238952034789691
,0.9483419637181792483104914
,0.9516128081124632931420138
,0.9548836525067473379735361
,0.9581544969010313828050585
,0.9614253412953154276365808
,0.9646961856895994724681032
,0.9679670300838835172996255
,0.9712378744781675621311479
,0.9745087188724516069626702
,0.9777795632667356517941926
,0.9810504076610196966257149
,0.9843212520553037414572373
,0.9875920964495877862887596
,0.9908629408438718311202820
,9.4301359708078589250135337
,9.1619927492351695974548420
,8.9016774989433002929217764
,8.6489338332049072732843342
,8.4035079438365674064925770
,8.1651531802680246130421438
,7.9336332682121852855061661
,7.7087242126657589125215964
,7.4902150312452651093053646
,7.2779075343122290320252432
,7.0716154067208636391228538
,6.8709562471535585714832450
,6.6763830544038951231300416
,6.4878611065321383222226359
,6.3032102532917182458049865
,6.1245155652072336138758146
,5.9508883149758800001905001
,5.7821878369307420086897764
,5.6182767496039467403079470
,5.4590208410668248362185295
,5.3042890715811328306017458
,5.1539536338410041338420342
,5.0078900239255119686276885
,4.8659770919838685188096861
,4.7280970571332936458475160
,4.5941354835963821301447751
,4.4639812235118201400041471
,4.3375263360335143403290203
,4.2146659930385599324154100
,4.0952983801727951274074258
,3.9793245978532225670676326
,3.8666485566863815215299383
,3.7571770520079885713471413
,3.6508192125967915409034958
,3.5474868635044729536787145
,3.4470946556588231146633916
,3.3495593129724841041650052
,3.2548000362300237853219187
,3.1627383259635131196318980
,3.0732979177139361226522851
,2.9864047190046449919975657
,2.9019867480281416050047483
,2.8199740740420384810249743
,2.7402987594691374795274896
,2.6628948034884687423584637
,2.5876980878678925712677028
,2.5146463231561959617010871
,2.4436789976536190671652093
,2.3747373271723621890316736
,2.3077642063873571309784438
,2.2427041615851552869287389
,2.1795033047700114181566278
,2.1181092890891477509285323
,2.0584712655408479164975688
,2.0005398409302728168768226
,1.9442670370389094625096504
,1.8896062509745972235464251
,1.8365122166700302841491066
,1.7849409674987279927904638
,1.7348497999783827339115305
,1.6861972385325307843828568
,1.6389430012824561799789080
,1.5930479668421793082444538
,1.5484741420903418429588783
,1.5051846308937268936745113
,1.4631436037580758391385416
,1.4223162683827899055444277
,1.3834181859544485426738447
,1.3449208840933966069286498
,1.3075388627112061179502689
,1.2712412018376770816985299
,1.2359978843064067799417671
,1.2017797712940923027247209
,1.1685585786255967555291591
,1.1363068538288085829179863
,1.1049979539242231751927648
,1.0746060239351589160605727
,1.0451059761054679597691575
,1.0164734698126038914267610
,0.9886848921649430410596437
,0.9617173392734224002253995
,0.9355485981887985413862907
,0.9101571294972458092686907
,0.8855220505684965326409497
,0.8616231194522463443519200
,0.8384407194200939050787724
,0.8159558441519573213085437
,0.7941500835681306602609197
,0.7730056103114759658012645
,0.7525051668892576151037588
,0.7326320534906589632129226
,0.7133701165025658763596539
,0.6947037377491606102708488
,0.6766384012228239264175045
,0.6591189845629904509038965
,0.6421513987574357651411106
,0.6257220719104265027610268
,0.6098179237731199409111582
,0.5944263593467956630078675
,0.5795352633362559346963394
,0.5651329954963081325658436
,0.5512083869202212271787289
,0.5377507373259953205035799
,0.5247498134036961969783874
,0.5121958482948579804983069
,0.5000795422855490723890171
,0.4883920648047578305650518
,0.4771250578242430817610398
,0.4662706407789732887536616
,0.4558214171332530817437600
,0.4457704827432100724848851
,0.4361114361241583692319068
,0.4268383908459142950242438
,0.4179061192150130832345667
,0.4093904479535098173137442
,0.4012482698305489536849677
,0.3934765344071767811939822
,0.3860952860965881638932728
,0.3790456669058151484286157
,0.3723568482998241835346676
,0.3660278374933617073772041
,0.3607781006067989348906622
,0.3551732815038575186150638
,0.3499300926810647860421000
,0.3450508870387283266722989
,0.3405390024145598659721657
,0.3363988337156459951238219
,0.3326359101257309602850398
,0.3290827610530979718816980
,0.3261357289512806234554887
,0.3235818932991836871515545
,0.3214337913066509511139657
,0.3197053291577744427165442
,0.3184119184777777777917152
,0.3175706123458139074067219
,0.3172002367269128320081961
,0.3173214927074165525588967
,0.3179570466280661755753556
,0.3191315813719087790545359
,0.3208717912539113537029323
,0.3232063096624260278844076
,0.3261655448153845116010530
,0.3297813921222106925412731
,0.3340867793424984188987992
,0.3391150265025467680501947
,0.3448989580213752126347515
,0.3514697310664758322928947
,0.3588553440038844688508846
,0.3670787955093164911524184
,0.3761559028203989574201671
,0.3860928094662889331623035
,0.3968832863962450385741931
,0.4085059909639116026980332
,0.4209219452804030536796631
,0.4340725549417259188089702
,0.4478785736640344405934400
,0.4622404150159333258152117
,0.4770401487635451132085507
,0.4921453547548919060794503
,0.5074147556856160035110292
,0.5227052336333618542951740
,0.5378795021563712586143424
,0.5528135232741754334639950
,0.5674026805945523443952538
,0.5815659012032838859340700
,0.5952472677966905711954837
,0.6084151111351643326230487
,0.6210590023833456596591418
,0.6331853710858736938860147
,0.6448125774233904872190237
,0.6559661992953068621048374
,0.6666750752678290981023679
,0.6769684473628871934636209
,0.6868737772376971584264993
,0.6964163292049271314354542
,0.7056184350753292866542665
,0.7144997480674966094937872
,0.7230775630483929905523155
,0.7313671979453236771107072
,0.7393812974067974774783352
,0.7471336455607890947305805
,0.7546376881944573122851239
,0.7618995884183789035759560
,0.7689425233310868135205851
,0.7757402435910620841497121
,0.7823364457072599087439357
,0.7887273182287607431462106
,0.7949203561948032792372487
,0.8009226540318323817047030
,0.8067409433067513901960410
,0.8123816248227461178643694
,0.8178507961843799467516192
,0.8231542756847932684749480
,0.8282976231759499041729100
,0.8332861584417796674273404
,0.8381249774787730144609554
,0.8428189669846739562331095
,0.8473728172730528029887864
,0.8517910338100082023871096
,0.8560779476520875563849700
,0.8602377252262290996398519
,0.8642743779695395422990600
,0.8681917720703296037498831
,0.8719936377581122277646841
,0.8756835765320858389060277
,0.8792650642059531840288855
,0.8827414487175507806782093
,0.8861159447328069704852282
,0.8893916311270857466553252
,0.8925714598485716688713865
,0.8957512885700575910874477
,0.8989311172915435133035089
,0.9021109460130294355195701
,0.9052907747345153577356314
,0.9084706034560012799516926
,0.9116504321774872021677538
,0.9148302608989731243838150
,0.9180100896204590465998763
,0.9211899183419449688159375
,0.9243697470634308910319987
,0.9275495757849168132480600
,0.9307294045064027354641212
,0.9339092332278886576801824
,0.9370890619493745798962436
,0.9402688906708605021123049
,0.9434487193923464243283661
,0.9466285481138323465444273
,0.9498083768353182687604885
,0.9529882055568041909765498
,0.9561680342782901131926110
,0.9593478629997760354086722
,0.9625276917212619576247334
,0.9657075204427478798407947
,0.9688873491642338020568559
,0.9720671778857197242729171
,0.9752470066072056464889783
,0.9784268353286915687050396
,0.9816066640501774909211008
,0.9847864927716634131371620
,0.9879663214931493353532233
,0.9911461502146352575692845
,9.5905929173782400454228991
,9.3178023837803038986749016
,9.0529897944380852692347617
,8.7958957252201077636755144
,8.5462614468444275672709409
,8.3038341530561687875433563
,8.0683707796778723064790029
,7.8396404194093252115749237
,7.6174254535990213454965669
,7.4015216073831275878092129
,7.1917371862235786039718732
,6.9876545365695958977880764
,6.7898146323949575275946700
,6.5981932913854466349334871
,6.4103210904107488232739342
,6.2285977858296384113145905
,6.0520267515741279495955496
,5.8804652563903108131171393
,5.7137739065008856798044690
,5.5518164846855340144315960
,5.3944599322061073110035068
,5.2415744075838182070015137
,5.0930333682188333455087559
,4.9487136372839310993754225
,4.8084954352388855625122233
,4.6722623697090792660446823
,4.5399013876655551769090380
,4.4113026994350903464692237
,4.2863596856640828747231353
,4.1649687971477256098751241
,4.0470294547550587083151186
,3.9324439351601419012638416
,3.8211174491246544526745765
,3.7129576170792022438149615
,3.6078747221119633614705435
,3.5057820037732261297946934
,3.4065947667667995091278499
,3.3102308436298146787635233
,3.2166104056878843664435408
,3.1256558972761223635927763
,3.0372919716816513258095256
,2.9514454288108185053829402
,2.8680451545832741366837126
,2.7870220620383507892370289
,2.7083090340328555001292443
,2.6318408680748661687687218
,2.5575542216395792394223463
,2.4853875602936708055779036
,2.4152811065982415783537363
,2.3471767906385845314787275
,2.2810182019770683936599198
,2.2167505429868517019542651
,2.1543205835275340831458379
,2.0936766169257396974501262
,2.0347684172249858036707337
,1.9775471976702192478114739
,1.9219655703934332979798683
,1.8679775072677913261287586
,1.8155383018987367726992943
,1.7646045327215349463045868
,1.7151340271757686828379974
,1.6670858269282324837234910
,1.6204201541167035927060169
,1.5750983785879979492960956
,1.5310829861046864053264471
,1.4883375474957993844782322
,1.4468266887277758669938521
,1.4072602671458063205989220
,1.3681195166060748924508061
,1.3301132921560610000710767
,1.2932101593366047698197008
,1.2573796022525292048754864
,1.2225919987208446748638835
,1.1888185961994928163676377
,1.1560314884805513724330694
,1.1242035931327507558563639
,1.0933086296791880709378120
,1.0633210984970828949514043
,1.0342162604274789394764866
,1.0059701170838211137237295
,0.9785593918495157916837002
,0.9519615115558449636168348
,0.9261545888329989484333282
,0.9011174051284863706356987
,0.8768293943887259800362699
,0.8532706274011470082285769
,0.8304217967958086310531485
,0.8082642027077463486861575
,0.7867797391047209876191459
,0.7659508807904888971762603
,0.7457606711013637923457509
,0.7261927103223229096329305
,0.7072311448547204948411604
,0.6888807692058275256030697
,0.6710871648477271245170073
,0.6538555866103606950545668
,0.6371722699225289554547658
,0.6210239525628625800734994
,0.6053978683388846482316126
,0.5902817416465329092289949
,0.5756637829551188856314070
,0.5615326852688249381628793
,0.5478776216230326623346514
,0.5346882436813722438984087
,0.5219546815072337864194196
,0.5096675445946835525390384
,0.4978179242540640148106945
,0.4863973974509908093644128
,0.4753980322230360044954978
,0.4648123948031578911432860
,0.4546335586068044887220196
,0.4448551151863957553445061
,0.4354711873884905548592883
,0.4264764448721611866943704
,0.4178661222794811669345449
,0.4095968604785354960640120
,0.4017477331757800529388192
,0.3942754901017201385471367
,0.3871785050854347765003638
,0.3804564770536290607694241
,0.3740872899133019791051424
,0.3688010348007081384835715
,0.3631751188352588810559496
,0.3579207973111478979788558
,0.3530407096492509944063443
,0.3485385111146047099062173
,0.3444189457348412752857314
,0.3406879237440266217085139
,0.3371454453737828815818034
,0.3342609345618791083509791
,0.3317810215759574021809897
,0.3297189290120860483135345
,0.3280892459872384869790096
,0.3269080579769624295138897
,0.3261930734300677037218463
,0.3259637421481272889778324
,0.3262413388768732325218025
,0.3270490292708866375548382
,0.3284118893130568150873216
,0.3303568592149587201944883
,0.3329126196822708716460681
,0.3361093644513912237492548
,0.3399784361807688948253769
,0.3445517818654059705174575
,0.3498612102566444614915042
,0.3559373915559365664229574
,0.3628085685829223194787119
,0.3704989524210709483931225
,0.3790267872437945162467088
,0.3884021107340758782733303
,0.3986242659035105218023887
,0.4096792952979519952805276
,0.4215374098510970557462940
,0.4341508179380357268506430
,0.4474522420856955617907147
,0.4613545155826498933571145
,0.4757516122726462293179850
,0.4905213645126003108032364
,0.5055299307175160627991772
,0.5206378111696708943512135
,0.5357069117273183245231394
,0.5506078728096772678668458
,0.5652267730794143796302365
,0.5794703208085069112698307
,0.5932688887737890270912544
,0.6065771188437125704950859
,0.6193722449216557679463335
,0.6316506482290916713040474
,0.6434233842915862977562824
,0.6547114535069715746118391
,0.6655414739121070510918798
,0.6759421852074782854913337
,0.6859420108163283291702328
,0.6955673227452002782555951
,0.7048421605577231963124518
,0.7137876823771571732635266
,0.7224224343854764862626894
,0.7307629793094738701597635
,0.7388238518016452260894766
,0.7466181524299871918870508
,0.7541587859698211104841903
,0.7614550515292664023547786
,0.7685235054367726137414252
,0.7753559399013288944146893
,0.7819786138183791868172534
,0.7883938582488928537017614
,0.7946093739148271106742527
,0.8006324346887404574957259
,0.8064699297353496998397304
,0.8121283990614368564209258
,0.8176140638463101906197039
,0.8229328525729847632064207
,0.8280904237373596377125295
,0.8330921857404066654950725
,0.8379433144393469978794542
,0.8426487687273804816356915
,0.8472133044191904049924347
,0.8516414866547959983122951
,0.8559377010316524536648330
,0.8601061637567796180903201
,0.8641509312260347019929441
,0.8680759094230605654729516
,0.8718848631759067435709198
,0.8755814245639087500805431
,0.8791690989762186436706770
,0.8826512672471951148622793
,0.8860311837029724024716870
,0.8893119728838170257034790
,0.8924966308706602236000549
,0.8955880381389168531924838
,0.8986794454071734827849127
,0.9017708526754301123773416
,0.9048622599436867419697705
,0.9079536672119433715621994
,0.9110450744802000011546284
,0.9141364817484566307470573
,0.9172278890167132603394862
,0.9203192962849698899319151
,0.9234107035532265195243440
,0.9265021108214831491167729
,0.9295935180897397787092018
,0.9326849253579964083016307
,0.9357763326262530378940596
,0.9388677398945096674864885
,0.9419591471627662970789174
,0.9450505544310229266713463
,0.9481419616992795562637752
,0.9512333689675361858562042
,0.9543247762357928154486331
,0.9574161835040494450410620
,0.9605075907723060746334909
,0.9635989980405627042259198
,0.9666904053088193338183487
,0.9697818125770759634107776
,0.9728732198453325930032065
,0.9759646271135892225956354
,0.9790560343818458521880643
,0.9821474416501024817804932
,0.9852388489183591113729221
,0.9883302561866157409653511
,0.9914216634548723705577800
,9.7509456508296832311089020
,9.4735043209714788758901705
,9.2041905140536943719098417
,8.9427425223488352656886491
,8.6888972040260803453293192
,8.4423958790721087552810786
,8.2029887823736160612497770
,7.9704380331595032771474507
,7.7445192116160352924225663
,7.5250217340160308054919369
,7.3117482835821574482793039
,7.1042430153160402994672040
,6.9031428068816094167914343
,6.7084341532799829366240374
,6.5180258929143279900131347
,6.3325871411909577801679916
,6.1530754524025468299441854
,5.9786558660223851902060233
,5.8091869994644325103649862
,5.6445306606832881257673762
,5.4845518024027821724075693
,5.3291185750289367106802274
,5.1781024169101570464590623
,5.0313781372625241417040343
,4.8888239653118956695720954
,4.7503215554745628068644692
,4.6157559505124465815129042
,4.4850155117842049889986811
,4.3579918283798964040443025
,4.2345796162350346492075914
,4.1146766157064096347539817
,3.9981834759266745571437696
,3.8850038111899549697625389
,3.7750437551874407304808301
,3.6682120362942862712429815
,3.5644204863586628206917339
,3.4635829934471291657871461
,3.3656160232536720400275954
,3.2704384192484687865487558
,3.1779713358670749201451144
,3.0881381734299733210491468
,3.0008645147958197263449165
,2.9160780637569208018078371
,2.8337085851688650350865828
,2.7536878467988796792553785
,2.6759495627180727161942286
,2.6004293387856480812558857
,2.5270646188020902123128053
,2.4557946331452038535303473
,2.3865603483578623489336223
,2.3193044183057121010449464
,2.2539711367394525964868990
,2.1905063912218101229711920
,2.1288576183815552944622596
,2.0689737604583453567386186
,2.0108052231032593759607607
,1.9543038344009100448772642
,1.8994228050801027496419238
,1.8461166898809788783353270
,1.7943413500476816935247371
,1.7440539169165709676434517
,1.6952127565710390921793760
,1.6477774355349947832394264
,1.6017086874780237515381032
,1.5569683809062639934239769
,1.5135194878139619500956314
,1.4713260532716641026951265
,1.4303531659279231647019515
,1.3913089935713378597625933
,1.3526794907345287555244795
,1.3151718045965885561798814
,1.2787549213614590737364551
,1.2433987363159135774992592
,1.2090740293831729879059367
,1.1757524414556750347315983
,1.1434064514918025334822005
,1.1120093543624001153347081
,1.0815352394339605712758612
,1.0519589698763989193963653
,1.0232561626844227653521102
,0.9954031694026792553842142
,0.9683770575461276841622293
,0.9421555927084838133467315
,0.9167172213530802027392497
,0.8920410542820064181412931
,0.8681068507809086565174539
,0.8448950034384251628338802
,0.8223865236413594459463638
,0.8005630277501567526599047
,0.7794067239650177558729638
,0.7589003999016474821814882
,0.7390274109061465424019843
,0.7197716691475167793967671
,0.7011176335272494286598999
,0.6830705457714354444931359
,0.6655760376150899881864120
,0.6486398136481122955743217
,0.6322484311170950554981118
,0.6163889541345691780449556
,0.6010489483479560801626462
,0.5862164765662356558095780
,0.5718800953975717860089389
,0.5580288529585420986833810
,0.5446522877233829218468486
,0.5317404285895195314992634
,0.5192837962475026492015218
,0.5072734059540273676702782
,0.4957007718088026204661389
,0.4845579126645797596317777
,0.4738373598029554378818773
,0.4635321665390628731451272
,0.4536359198523498559296740
,0.4441427542916837611919334
,0.4350473683086382714613194
,0.4263450433212145340711174
,0.4180316657315584216725313
,0.4101037517070214577508125
,0.4025256885690441377434468
,0.3953710667812989076885799
,0.3886001404081790844280420
,0.3822128076191570467123881
,0.3768802047467008087267004
,0.3712354598431032437488852
,0.3659723402609031395193995
,0.3610937695677594594378945
,0.3566037164879172771669857
,0.3525072681897998272404493
,0.3488107074477573288362464
,0.3452766652136041725107418
,0.3424581368592866659206209
,0.3400554830890578639213118
,0.3380825981715279149319997
,0.3365547327657321674543311
,0.3354886153998449804802817
,0.3349025677139044754326846
,0.3348166075434761412843443
,0.3352525113658257893689552
,0.3362338533279451424640172
,0.3377859898274708783105780
,0.3399359693806739413091123
,0.3427123545734416798502764
,0.3461449288579473981819490
,0.3502642543396128349542096
,0.3551010374214736420306338
,0.3606852861106528140844318
,0.3670452033023414717405331
,0.3742057917494812646630464
,0.3821871543106783453147557
,0.3910024896728490628738939
,0.4006558286585333306106804
,0.4111395921675931597327747
,0.4224321266703552346655215
,0.4344954327215560518915538
,0.4472733883699703816283488
,0.4606907910010726858729413
,0.4746535844574214513258426
,0.4890505659602957799769740
,0.5037567394055796343721454
,0.5186382681754007073493540
,0.5335587184140089256345618
,0.5483860131378407443136780
,0.5629992921051635290652371
,0.5772948359475117419137291
,0.5911902860045307184222452
,0.6046266769892411074849292
,0.6175681728080155696858355
,0.6299997802566436044813258
,0.6419236147828923932934231
,0.6533544452974685556867485
,0.6643152209325051682498042
,0.6748331385257021475254646
,0.6849365801300993927824834
,0.6946530221392471782237976
,0.7040078398662483749603780
,0.7130237589972642231472832
,0.7217209311562396978345646
,0.7301170713672092693613536
,0.7382278411263631934247087
,0.7460672101152228119502752
,0.7536479927149990487578179
,0.7609829176723533761261820
,0.7680803014340141787741345
,0.7749467705011191531738746
,0.7815977999426693134665811
,0.7880391227105139062558692
,0.7942786675350265168660258
,0.8003239062393053826482969
,0.8061819011260762390946866
,0.8118593445985161638489558
,0.8173625927123780998684310
,0.8226976938979455589162626
,0.8278704137791155215353456
,0.8328862568003340127731349
,0.8377504852166028914695062
,0.8424681358835174327381878
,0.8470440351866947992220958
,0.8514828123691619010671161
,0.8557889114662265983568545
,0.8599666020667438015578909
,0.8640199891917376140426654
,0.8679530226489761135511003
,0.8717695061341135254195933
,0.8754731059566240869429521
,0.8790673586125907768007437
,0.8825556758992023631549273
,0.8859413465377297125513678
,0.8892275348565513715115571
,0.8924172797136425971942231
,0.8955134991096720398218167
,0.8985190057591578849383041
,0.9015245124086437300547914
,0.9045300190581295751712787
,0.9075355257076154202877660
,0.9105410323571012654042534
,0.9135465390065871105207407
,0.9165520456560729556372280
,0.9195575523055588007537153
,0.9225630589550446458702027
,0.9255685656045304909866900
,0.9285740722540163361031773
,0.9315795789035021812196646
,0.9345850855529880263361520
,0.9375905922024738714526393
,0.9405960988519597165691266
,0.9436016055014455616856139
,0.9466071121509314068021013
,0.9496126188004172519185886
,0.9526181254499030970350759
,0.9556236320993889421515632
,0.9586291387488747872680506
,0.9616346453983606323845379
,0.9646401520478464775010252
,0.9676456586973323226175125
,0.9706511653468181677339999
,0.9736566719963040128504872
,0.9766621786457898579669745
,0.9796676852952757030834618
,0.9826731919447615481999492
,0.9856786985942473933164365
,0.9886842052437332384329238
,0.9916897118932190835494112
,9.9110995780536512711478281
,9.6290070581345155176222761
,9.3551908940994401575608208
,9.0893879191168114317633808
,8.8313311584508937812643126
,8.5807564055654790280414090
,8.3374073384814675335974243
,8.1010390841531965122612746
,7.8714202855442305661881619
,7.6483338424474540673259071
,7.4315765780898788150921064
,7.2206515154671677692022058
,7.0160732623730428514363666
,6.8174305504903909280756125
,6.6249790206669372238934557
,6.4364210650942155211851059
,6.2539736512068726526081264
,6.0767006459508712268302588
,5.9044586996264039058246453
,5.7371076762470920584746636
,5.5745105724063908070320394
,5.4165335592257664032445064
,5.2630460786401762618424982
,5.1139209417648485711538342
,4.9690343964496372919370515
,4.8282661492555565274642504
,4.6914993412350121104736900
,4.5586204858563608155463953
,4.4295193813399942328601355
,4.3040890096578836576668436
,4.1822254320039657926599830
,4.0638276732142877278874948
,3.9487977420847948373250347
,3.8370403110183102235453134
,3.7284625394365233930216164
,3.6229748553365808128035042
,3.5204897342564960283084474
,3.4209222772767970965901441
,3.3241900021633590256442403
,3.2302127755337708414629105
,3.1389127467631463552777404
,3.0502142836302184036867402
,2.9640439097185717898241819
,2.8803302435721236385290922
,2.7990039395972949876068014
,2.7199976305050075353619832
,2.6432458719902198751583455
,2.5686850878827818256411319
,2.4962535180386420385900692
,2.4258911670818728012477550
,2.3575397547684651122779087
,2.2911426677785353689387193
,2.2266449128960297265678037
,2.1639930715375372827224965
,2.1031352555934414993998871
,2.0440210645457672633540369
,1.9866015438281083849147990
,1.9308291443940783782551307
,1.8766576834617780811242937
,1.8240423064028363775435082
,1.7729394497456079093922199
,1.7233068052631625999282505
,1.6751032851177143356835586
,1.6282889880341537836017096
,1.5828251664763126616009004
,1.5386741948006406044413552
,1.4957995383628774899165137
,1.4541657235543630211083155
,1.4137383087455541730292907
,1.3752237832175018272806710
,1.3371128212819265446142936
,1.3001108731044739297288970
,1.2641873525540692213553484
,1.2293125731248997212219365
,1.1954577239101598085113665
,1.1625948463544142352787958
,1.1306968117703948273344849
,1.0997372996071106410198581
,1.0696907764572567423044802
,1.0405324757929990120430830
,1.0122383784204305179343919
,0.9847851936442465481391650
,0.9581503411356029342726970
,0.9323119334976115446522726
,0.9072487595244278502093493
,0.8829402681513356387910108
,0.8593665530947346420376221
,0.8365083381828688491310686
,0.8143469633814821584394394
,0.7928643715245199397045894
,0.7720430957694882634356759
,0.7518662478096327372867336
,0.7323175068874460125201153
,0.7133811096594925293956635
,0.6950418409517554740872924
,0.6773054069780373165343690
,0.6601174979542373533192290
,0.6434842873730702850210150
,0.6273926711962288793600351
,0.6118300579156542573500133
,0.5967843643242848328256400
,0.5822440123318946003649899
,0.5681979268889321144087035
,0.5546355350891263302770540
,0.5415467665294432242362177
,0.5289220550184908775648296
,0.5167523417351866932278881
,0.5050290799399135277525374
,0.4937442413723142631276630
,0.4828903244713979026059292
,0.4724603645871411905510229
,0.4624479462724086498148779
,0.4528472179170840439255130
,0.4436529088720079228025384
,0.4348603493764343630445524
,0.4264654935115945177948049
,0.4184649449147622157774151
,0.4108559864233347069806257
,0.4036366129097890831367579
,0.3968055682197445532821689
,0.3903655907962544913125669
,0.3850095799132262630593004
,0.3793481953082547541988845
,0.3740785175211279733886727
,0.3692037503470431691887654
,0.3647281702370273603897033
,0.3606571995090538940154090
,0.3569974826788803179411502
,0.3534689769606351728015170
,0.3507197200025214400831430
,0.3483974527058675829671586
,0.3465167232662287322142447
,0.3450934181993955962575171
,0.3441448737109227828945279
,0.3436899775926444133844484
,0.3437492547994739355843308
,0.3443449063360810025180569
,0.3455008187377560657793651
,0.3472425111043035972357984
,0.3495969982936078523927392
,0.3525925562017480641152645
,0.3562583611099266467370228
,0.3606239688231013262864622
,0.3657185919242210703217211
,0.3715701610924919129352872
,0.3782041200452734841519487
,0.3856419375394288806546683
,0.3938993318339402693872842
,0.4029842242631213600212448
,0.4128944859118824362020916
,0.4236155826722864392586132
,0.4351182965129075097543421
,0.4473567562336688840929355
,0.4602670877634231216823935
,0.4737669936499806500052046
,0.4877565926758622993908432
,0.5021207475046033374965759
,0.5167329567388480038303555
,0.5314606637154801749289845
,0.5461715831078466365511304
,0.5607404124570517511827461
,0.5750551293404714270351974
,0.5890221037963591088626458
,0.6025693844370600960047568
,0.6156478280739789976649945
,0.6282301040688142990120468
,0.6403079435717046186127277
,0.6518882393637062122593306
,0.6629886917875140728284578
,0.6736336283556259019178469
,0.6838504614353846378094204
,0.6936670263336175423773966
,0.7031098380429093852583833
,0.7122031567318010125688943
,0.7209686167813136314919120
,0.7294253751677904906713934
,0.7375903021628260614050987
,0.7454783595887293223825054
,0.7531028574046358947668978
,0.7604766498868150703671631
,0.7676097285612296650114672
,0.7745109532829659304553616
,0.7811923849304059919163024
,0.7876616350191225635057890
,0.7939268862025092854395325
,0.7999958295008924302749165
,0.8058757180403097741816509
,0.8115734115256139080685216
,0.8170954135811236973552241
,0.8224479034859013548697249
,0.8276367634261223571456867
,0.8326676021104769676028923
,0.8375457754004531629732355
,0.8422764044663205718066479
,0.8468643918711334928062229
,0.8513144358961205471203471
,0.8556310433509722868095082
,0.8598185410761768343590461
,0.8638810863599905021104064
,0.8678226765492403904644902
,0.8716471581559618320156346
,0.8753582356200492187170425
,0.8789594794910342567817452
,0.8824543332494085845496556
,0.8858461177034684386200070
,0.8891380324280224733968225
,0.8923331553382954917097436
,0.8954344437252269583993325
,0.8984447415149671156697764
,0.9013667964138151189601444
,0.9042888513126631222505125
,0.9072109062115111255408806
,0.9101329611103591288312487
,0.9130550160092071321216167
,0.9159770709080551354119848
,0.9188991258069031387023529
,0.9218211807057511419927209
,0.9247432356045991452830890
,0.9276652905034471485734571
,0.9305873454022951518638251
,0.9335094003011431551541932
,0.9364314551999911584445613
,0.9393535100988391617349293
,0.9422755649976871650252974
,0.9451976198965351683156655
,0.9481196747953831716060336
,0.9510417296942311748964016
,0.9539637845930791781867697
,0.9568858394919271814771378
,0.9598078943907751847675058
,0.9627299492896231880578739
,0.9656520041884711913482420
,0.9685740590873191946386100
,0.9714961139861671979289781
,0.9744181688850152012193462
,0.9773402237838632045097143
,0.9802622786827112078000823
,0.9831843335815592110904504
,0.9861063884804072143808185
,0.9890284433792552176711865
,0.9919504982781032209615546
,10.0709610340947790518839611
,9.7842200782740587072794369
,9.5059032057537748983122583
,9.2357466806529000535874729
,8.9734803435654946213162475
,8.7188348737278484890111940
,8.4715475929861749904148382
,8.2313666622802088568278123
,7.9980536834353026520716412
,7.7713848515835666219686573
,7.5511509003948402707351306
,7.3371561403769742781832974
,7.1289588336853677574822541
,6.9271597439361638492982820
,6.7317161542657251160903797
,6.5400377757554180035981517
,6.3546613419470263650623565
,6.1745413144753822365373708
,5.9995323957701600647851592
,5.8294925366587779791416324
,5.6642828115615726503051519
,5.5037674436815118284016535
,5.3478139040880474652794874
,5.1962930244826175396610779
,5.0490790836809065211809866
,4.9060498477759226787497937
,4.7670865602123848603355327
,4.6320738889067634147522767
,4.5008998429283302300518699
,4.3734556720876307522871684
,4.2496357606203343237893932
,4.1293375135358560967802077
,4.0124613232985790745033228
,3.8989104322464229746003639
,3.7885904149426323783700354
,3.6814102993379371753235318
,3.5772811541985727323833544
,3.4761167190360642287316750
,3.3778331888530885862564901
,3.2823491452963247105856226
,3.1895854895587443245119630
,3.0994653770266933356936079
,3.0119141536923077495657708
,2.9268592943382865101398238
,2.8442303424968309322196092
,2.7639588519379327813396685
,2.6859783305629361116473319
,2.6102241845304838818719873
,2.5366336654217116475251714
,2.4651458181341006081765954
,2.3957014304530379611435364
,2.3282429840757696837272306
,2.2627146070456563009543061
,2.1990620275575762931907775
,2.1372325290971407873996668
,2.0771749068775742230741344
,2.0188394255391166609570064
,1.9621777780769489307743925
,1.9071430459646065980194862
,1.8536896604410018074560185
,1.8017733649301963527733506
,1.7513511785641364681964660
,1.7023813607795947877576737
,1.6548233769616080834907734
,1.6086378651066792766499702
,1.5637866034800911307911520
,1.5202324792425989663513519
,1.4779394580228546463018802
,1.4368725544128628790474522
,1.3969978033647880710788058
,1.3590200289914129427870648
,1.3214346194399622103077263
,1.2849453410542037712360752
,1.2495220422737072230034983
,1.2151354617523302259485263
,1.1817572047678113200674943
,1.1493597204104479825303997
,1.1179162795377688421893936
,1.0874009534832280721161624
,1.0577885935081237089860906
,1.0290548109871275883620001
,1.0011759583191419675785028
,0.9741291105565789143483357
,0.9478920477476686645701420
,0.9224432379878738652578818
,0.8977618211778725099136977
,0.8738275934868895422624746
,0.8506209925218729539508900
,0.8281230832060444413400546
,0.8063155443762787255579383
,0.7851806561188794386652035
,0.7647012878777662558960060
,0.7448608873849916767184709
,0.7256434704740555297064475
,0.7070336118311323359009180
,0.6890363702586930205740146
,0.6715981338097708475132208
,0.6547244610990626823010530
,0.6384020815204373144879924
,0.6226182480292703491642214
,0.6073607330587393882126435
,0.5926178255149461282513812
,0.5783783289158872520374643
,0.5646315607472521813647859
,0.5513673531156757512405875
,0.5385760547933093889128031
,0.5262485347583591988041007
,0.5143761873346309743126881
,0.5029509390688120529233629
,0.4919652574836814173941946
,0.4814121618823167247924744
,0.4712852362816661311306632
,0.4615786447518134272272050
,0.4522871493005419796240574
,0.4434061306285513315295077
,0.4349316119764319865659274
,0.4268602857133005912260160
,0.4191895439534579770324285
,0.4119175122936885036217802
,0.4050430876338548258353001
,0.3985659819378751245189108
,0.3931830105233057315317069
,0.3875070888718404882311575
,0.3822329897639679674448132
,0.3773641917642058252191362
,0.3729052715699577857932923
,0.3688619766756516815675582
,0.3652413002982683454256119
,0.3617147482465189467504274
,0.3590378686545960262854749
,0.3567988958648167230336412
,0.3550130103036052142684298
,0.3536967045203084913929104
,0.3528678826999048223633793
,0.3525459472662531568154520
,0.3527518648063259210090337
,0.3535081791087859026667672
,0.3548389886902073020458204
,0.3567698538862292823026223
,0.3593276111849927900721013
,0.3625400801174698539597330
,0.3664356343040399699440002
,0.3710426025200842525819667
,0.3763884603370781234410458
,0.3824988012457974928537396
,0.3893960431940891586677367
,0.3970978627709867980755121
,0.4056153651921576841488104
,0.4149510237141139645800081
,0.4250964709500978933043314
,0.4360302698481906547023357
,0.4477158603307924145120467
,0.4600999267262590453064774
,0.4731114960548050141220244
,0.4866620538071086410347732
,0.5006469636866365258143219
,0.5149483478314548223764291
,0.5294394156179448307497637
,0.5439900032957638575936699
,0.5584728550126961676980386
,0.5727699837437697505393430
,0.5867783422894070621822493
,0.6004141204009710852673720
,0.6136151551570633300158875
,0.6263412639390804059758011
,0.6385726480361750834191525
,0.6503068049002636019650936
,0.6615545631189231334801093
,0.6723358908675798328857809
,0.6826760282599637630340794
,0.6926023211636940235536031
,0.7021419243847191182794631
,0.7113203623281768583908047
,0.7201608102338017403099002
,0.7286838891657980710192533
,0.7369078184455840618838351
,0.7448487687957935365901108
,0.7525208163405138206414335
,0.7599370262716503843236637
,0.7671089158454610368309545
,0.7740465489212755567649538
,0.7807606121297026025018795
,0.7872597972197685756157171
,0.7935525711515021285435978
,0.7996468687451623313933169
,0.8055501542172459616963920
,0.8112694715112949150892518
,0.8168114861424080608287568
,0.8221825204688034682831699
,0.8273885837701103751484766
,0.8324353981535848046036108
,0.8373284210626150692036163
,0.8420728649870712345659740
,0.8466737148466939588686841
,0.8511357434190988113797971
,0.8554635251034000686942704
,0.8596614482504858489875232
,0.8637337262643397517436483
,0.8676844076954567386295025
,0.8715173855856556128784973
,0.8752364063072910482787847
,0.8788450779629843889750873
,0.8823468780357751617415829
,0.8857451595606351535394651
,0.8890431550142078309661997
,0.8922439778238766550089167
,0.8953506229638253932634484
,0.8983659698996599995979295
,0.9012927918394365578436123
,0.9041337734801295766828844
,0.9069747551208225955221565
,0.9098157367615156143614286
,0.9126567184022086332007007
,0.9154977000429016520399728
,0.9183386816835946708792449
,0.9211796633242876897185170
,0.9240206449649807085577891
,0.9268616266056737273970612
,0.9297026082463667462363333
,0.9325435898870597650756054
,0.9353845715277527839148775
,0.9382255531684458027541496
,0.9410665348091388215934217
,0.9439075164498318404326938
,0.9467484980905248592719659
,0.9495894797312178781112380
,0.9524304613719108969505101
,0.9552714430126039157897821
,0.9581124246532969346290542
,0.9609534062939899534683263
,0.9637943879346829723075984
,0.9666353695753759911468705
,0.9694763512160690099861426
,0.9723173328567620288254147
,0.9751583144974550476646868
,0.9779992961381480665039589
,0.9808402777788410853432310
,0.9836812594195341041825031
,0.9865222410602271230217752
,0.9893632227009201418610473
,0.9922042043416131607003194
,10.2304374985753199212012987
,9.9390540550131767361108359
,9.6562409522447421039714754
,9.3817348350061049444548189
,9.1152630726591450383011761
,8.8565517064746543951514468
,8.6053319602113109709762284
,8.3613451022423355141199863
,8.1243456244104770291869499
,7.8941028516536135839487542
,7.6704012097790750246417701
,7.4530394521369220939277511
,7.2415364160299802165354777
,7.0365929720609852182633404
,6.8381746313165283623902724
,6.6433764295187840431822224
,6.4550794276710332653124169
,6.2721204723305126194077275
,6.0943523342283247856698836
,5.9216310810770043104867000
,5.7538159002063480329525191
,5.5907691005281536789084385
,5.4323562105667368982153675
,5.2784461040944128384921896
,5.1289111057481999722540422
,4.9836270506304929384100433
,4.8424732903391118910008117
,4.7053326508789323767700807
,4.5720913549391735131166570
,4.4426389228789693319754406
,4.3168680650240656149208007
,4.1946745722842218029313699
,4.0759571961504983406143765
,3.9606177908118249675339939
,3.8485605424823652320753808
,3.7396925299655716656843651
,3.6339239259019806560502275
,3.5311669545657173863162370
,3.4313364919152906651333979
,3.3343498382272205304843737
,3.2401266500060441622110829
,3.1485888736417249056387391
,3.0596606808398103538593205
,2.9732684058398359816521861
,2.8893404844347077009558689
,2.8078073945018027224307389
,2.7286015991315579753972997
,2.6516574897039961733469227
,2.5769113323486330102696229
,2.5043012149879513295047673
,2.4337669961188179712507917
,2.3652502550704301853556899
,2.2986942436953579083080967
,2.2340438394537565081066077
,2.1712454998528065708285339
,2.1102472182047216087141805
,2.0509984806677081792258832
,1.9934502245353604710231821
,1.9375547977410201294645731
,1.8832659195447265521039526
,1.8305386423714864463363483
,1.7793293147706370493921213
,1.7295955454671756434947838
,1.6812961684769307524334181
,1.6343912092585277662237786
,1.5888418518761371345249245
,1.5446104071479753727658135
,1.5016602817566082617162238
,1.4599559482981077085383959
,1.4194629162481302575571362
,1.3801477038240612671415875
,1.3427134855573736871292567
,1.3056603525383407848892148
,1.2696904027803888048708814
,1.2347739261121624121386731
,1.2008820932367962885933821
,1.1679869325942218161173969
,1.1360613080041481737225695
,1.1050788970778107067616247
,1.0750141703877977850112302
,1.0458423713864872794943039
,1.0175394970649742631962908
,0.9900822793457736414879378
,0.9634481672040886568453288
,0.9376153095138998194713054
,0.9125625386164117891496517
,0.8882693546095635772630317
,0.8647159103586301576171991
,0.8418829972306195452702582
,0.8197520315607756957732022
,0.7983050418700143868733221
,0.7775246568682249170834098
,0.7573940942978497625759360
,0.7378971506882704423091468
,0.7190181920927601888493541
,0.7007421458523882540347927
,0.6830745684807100204238850
,0.6659619238669221008564136
,0.6494102744091818646410275
,0.6334067191646374217484095
,0.6179388878683024222127074
,0.6029949381074720671236378
,0.5885635536751632201912798
,0.5746339441775637491005568
,0.5611958459779038399517503
,0.5482395245731219723950289
,0.5357557785104906100670519
,0.5237359449473244499273505
,0.5121719069968124760094952
,0.5010561030000291182773253
,0.4903815379048613865009543
,0.4801417968174841455208934
,0.4703310610179348705273128
,0.4609441265695644607269799
,0.4519764258595798112061459
,0.4434240522899506320442242
,0.4352837876742361444826201
,0.4275531337546803478666391
,0.4202303467450727025855883
,0.4133144759146125113424830
,0.4068054081912105823803927
,0.4013942513617470009279486
,0.3957058017098790680954323
,0.3904293080027719797797658
,0.3855685165991045160183148
,0.3811282952486456654384028
,0.3771147047179303490871405
,0.3735350717155172528549656
,0.3700061951384720493329894
,0.3674046066428198198394739
,0.3652516090519407065961843
,0.3635629895064028671569645
,0.3623558128358557728354583
,0.3616485074931833909595014
,0.3614609349720591113808155
,0.3618144340303091066601837
,0.3627318057541519813469222
,0.3642372569667358672695912
,0.3663562653383439782217579
,0.3691153431754815028575933
,0.3725416848805512826103836
,0.3766626697338849028007246
,0.3815051865810750730823031
,0.3870947439880029206094036
,0.3934543585101193952091592
,0.4006031844070167546867367
,0.4085548867101315151373342
,0.4173157791865449439683289
,0.4268827778801240757644564
,0.4372412702220465630098545
,0.4483630475580273055946634
,0.4602045109579884218931056
,0.4727054010885054502466573
,0.4857883543561454797732324
,0.4993595410185185379248196
,0.5133106208939254289091991
,0.5275221000037327856446723
,0.5418679930192322746762557
,0.5562214766936203202973843
,0.5704610139790201595033636
,0.5844762809739718623092131
,0.5981731750970485927965115
,0.6114773162138419371203213
,0.6243356528587088449810949
,0.6367161064567464778818362
,0.6486054949547244152796566
,0.6600062177878955882448508
,0.6709323065598781221652303
,0.6814054391078575578788445
,0.6914513915908461205717117
,0.7010972279937097706437044
,0.7103693323611188770172475
,0.7192922330589890389518359
,0.7278880678742111198786802
,0.7361764987700494256017691
,0.7441748940923221811161170
,0.7518984805660569037399910
,0.7593611429729337780614173
,0.7665750950521529327730264
,0.7735514409779659095178772
,0.7803005712055472997690231
,0.7868318765915948143074843
,0.7931541444152897524233481
,0.7992755820641647135360586
,0.8052038882610119685523387
,0.8109463105630935197964959
,0.8165096926277903843782724
,0.8219005136779361508914121
,0.8271249218902420041743540
,0.8321887629583282208756145
,0.8370976047628136962330814
,0.8418567588595639028525852
,0.8464712993390927087133946
,0.8509460794928629390199148
,0.8552857466308306788604909
,0.8594947553218611480119193
,0.8635773792773634438546537
,0.8675377220787465759599399
,0.8713797269636036624262942
,0.8751071859046849477081764
,0.8787237481675698180794143
,0.8822329283378355091471690
,0.8856381134710759051031914
,0.8889425687235584794265719
,0.8921494409194200558843590
,0.8952617603138229851467145
,0.8982824422440878198159453
,0.9012142917095257166337774
,0.9040600139917602806605146
,0.9068222322179783079221238
,0.9095844504441963351837330
,0.9123466686704143624453422
,0.9151088868966323897069515
,0.9178711051228504169685607
,0.9206333233490684442301699
,0.9233955415752864714917791
,0.9261577598015044987533884
,0.9289199780277225260149976
,0.9316821962539405532766068
,0.9344444144801585805382160
,0.9372066327063766077998253
,0.9399688509325946350614345
,0.9427310691588126623230437
,0.9454932873850306895846529
,0.9482555056112487168462621
,0.9510177238374667441078714
,0.9537799420636847713694806
,0.9565421602899027986310898
,0.9593043785161208258926990
,0.9620665967423388531543083
,0.9648288149685568804159175
,0.9675910331947749076775267
,0.9703532514209929349391359
,0.9731154696472109622007451
,0.9758776878734289894623544
,0.9786399060996470167239636
,0.9814021243258650439855728
,0.9841643425520830712471820
,0.9869265607783010985087913
,0.9896887790045191257704005
,0.9924509972307371530320097
,10.3894378056177210112309695
,10.0934210500241636765395015
,9.8061190575333512242650613
,9.5272698561144970597069914
,9.2565991183441980183488340
,8.9938287858554115672404805
,8.7386842998475451338435960
,8.4909001582913514738493177
,8.2502237117686689771289821
,8.0164172750902427111441284
,7.7892587621144198095635147
,7.5685411407280884787951436
,7.3537409027159892360714366
,7.1456669375869186211502893
,6.9431570049046973380768577
,6.7471875014922222391078321
,6.5551698622524021686786000
,6.3693817400135976924957504
,6.1888637520304730088582801
,6.0134701117379645296523449
,5.8430581551386708838435879
,5.6774883124358357378014261
,5.5166242005303036677332784
,5.3603327594847511861075873
,5.2084843771354112362814703
,5.0609529692055126304239820
,4.9176160029163780151861829
,4.7783544673432034599613871
,4.6430528026400637031656515
,4.5115988033355129971369024
,4.3838835097265134166377720
,4.2598010978643543467114796
,4.1392487466547764896063200
,4.0221267891121446069746526
,3.9083379666087085801962075
,3.7977878638852957671190325
,3.6903853094335241635803868
,3.5860411601989468088902413
,3.4846689775788730614181077
,3.3861847848205997024706448
,3.2905069979511898381474566
,3.1975563584557447072143077
,3.1072558677330004428540633
,3.0195307233526080814556281
,2.9343082571393970248152527
,2.8515178747437928130636919
,2.7710909980286722031905811
,2.6929610070701306412388476
,2.6170631859345800940275240
,2.5433346688699765003605080
,2.4717143882995564752036444
,2.4021430243164236806308054
,2.3345629556340528054647621
,2.2689182119519348823644123
,2.2051544276977903535907899
,2.1432187971091960498881690
,2.0830600306185362846633780
,2.0246283125062416452522029
,1.9678752597884254793569880
,1.9127538823060414863164169
,1.8592185439838984084559570
,1.8072249252288496990104250
,1.7567299864376628715234574
,1.7076919325860604459421666
,1.6600701788715455098355278
,1.6138253173836396570095530
,1.5689190847762264358067341
,1.5253143309177594755254859
,1.4829749884960967687419497
,1.4418660435558263710476012
,1.4019535069469879484671537
,1.3639349912273390774686277
,1.3263202254422283843382502
,1.2898058015943905108002809
,1.2543615625497550603029140
,1.2199582462685634176580152
,1.1865674623431821110841611
,1.1541616693312559682738083
,1.1227141528723718622018168
,1.0921990045776468480909216
,1.0625911016829483468626449
,1.0338660874578002868418025
,1.0060003523634910571615819
,0.9789710159554065871390094
,0.9527559095260664800974837
,0.9273335594865584896595578
,0.9026831714849994359184393
,0.8787846152616154427050787
,0.8556184102420959503021436
,0.8331657118760087410436199
,0.8114082987376208810914591
,0.7903285604239198569587188
,0.7699094863076023642634027
,0.7501346552247922794265378
,0.7309882261861213592624154
,0.7124549301795416456073440
,0.6945200630695511634371542
,0.6771896985523869760825733
,0.6604103857977903224707461
,0.6441887137710091693065806
,0.6285121711696169954919355
,0.6133687859307720424695276
,0.5987471237972532556170790
,0.5846362881736624217410281
,0.5710259213566619695967574
,0.5579062072379026293589277
,0.5452678755889611705853781
,0.5331022080306833110796561
,0.5214010458340003761890102
,0.5101567996934089910254784
,0.4993624616592471365805750
,0.4890116192791648108695313
,0.4790984722563866315958592
,0.4696178517427210263868176
,0.4605652426156292000847259
,0.4519368089566251911470829
,0.4437294221820506923137373
,0.4359406933806499462313866
,0.4285690085569682783450673
,0.4216135678511602202789277
,0.4150744308384419212210048
,0.4096369858854699286254686
,0.4039379175516655262612176
,0.3986609396366099788977522
,0.3938100578381415473039340
,0.3893904201025377709299846
,0.3854083867034545640706256
,0.3818716005567738269732558
,0.3783354201460225052500164
,0.3758118364755189677595126
,0.3737472611528909194333892
,0.3721580588711325687789611
,0.3710618293119206101415841
,0.3704774778283803082779002
,0.3704252658657483654458531
,0.3709268315633874601999764
,0.3720051449145079236480171
,0.3736844151749566522724422
,0.3759899123489157668487337
,0.3789476792847795150187551
,0.3825841193659215155875586
,0.3869254319557964283404772
,0.3919968634929758000140509
,0.3978217415551643654225700
,0.4044202890030311192681722
,0.4118081898264949192167705
,0.4199949189406070315655484
,0.4289818711684761365354746
,0.4387603567768972312457265
,0.4493095795986071783190141
,0.4605947627473798711150721
,0.4725656409957945669475521
,0.4851555700416994021395567
,0.4982815397817834113247670
,0.5118453098547816049190828
,0.5257358480997964544911838
,0.5398330829995339197324711
,0.5540127992740784268477228
,0.5681522990444329845871607
,0.5821362763388157057775629
,0.5958622499008542350296125
,0.6092448948497393157452962
,0.6222187845774871384207927
,0.6347392724150958676077039
,0.6467815522323504540125327
,0.6583382109403925763757570
,0.6694157785892022038964910
,0.6800308572775868309889802
,0.6902063689596621420818678
,0.6999683246348844534168165
,0.7093433451982608106689554
,0.7183569874815391997913139
,0.7270327955631793459545520
,0.7353919184367891936915385
,0.7434531108609255811714434
,0.7512328355823502112897927
,0.7587459316340434689607264
,0.7660054476147859503498694
,0.7730233120523499756870933
,0.7798101789977914810592097
,0.7863759900019525739267579
,0.7927298958071762324806286
,0.7988804103678613932615349
,0.8048354942228874708831654
,0.8106026208816874412121933
,0.8161888307040074952425357
,0.8216007753991453332886863
,0.8268447553310995790099014
,0.8319267511882849630566739
,0.8368524511573689483867611
,0.8416272744555914897546245
,0.8462563918765514392461569
,0.8507447438608533030190983
,0.8550970564956240638210261
,0.8593178557630876124306951
,0.8634114802929064858005859
,0.8673820928291079423999577
,0.8712336906070814457336837
,0.8749701148456728860836051
,0.8785950595603622126361643
,0.8821120798312811484009899
,0.8855245994606308901353486
,0.8888359176665361349733985
,0.8920492142802114443611572
,0.8951675531441320998737865
,0.8981938842492278585183385
,0.9011310464002535436378594
,0.9039817731229204955667456
,0.9067487040944192111524558
,0.9094344019241134002839999
,0.9121200997538075894155440
,0.9148057975835017785470882
,0.9174914954131959676786323
,0.9201771932428901568101764
,0.9228628910725843459417206
,0.9255485889022785350732647
,0.9282342867319727242048089
,0.9309199845616669133363530
,0.9336056823913611024678971
,0.9362913802210552915994413
,0.9389770780507494807309854
,0.9416627758804436698625295
,0.9443484737101378589940737
,0.9470341715398320481256178
,0.9497198693695262372571619
,0.9524055671992204263887061
,0.9550912650289146155202502
,0.9577769628586088046517943
,0.9604626606883029937833385
,0.9631483585179971829148826
,0.9658340563476913720464267
,0.9685197541773855611779709
,0.9712054520070797503095150
,0.9738911498367739394410592
,0.9765768476664681285726033
,0.9792625454961623177041474
,0.9819482433258565068356916
,0.9846339411555506959672357
,0.9873196389852448850987798
,0.9900053368149390742303240
,0.9926910346446332633618681
,10.5478723463600729814970691
,10.2472347022445564590498179
,9.9554540459213907155344714
,9.6722708369115828475059971
,9.3974098815496898140509074
,9.1305896195666385040112800
,8.8715300819022147038594994
,8.6199591679221079232320335
,8.3756170952632409409943648
,8.1382590569240544908780066
,7.9076562677586439420451825
,7.6835956889884187148709316
,7.4658787809629512111087024
,7.2540471569567719356541602
,7.0487429434940471750792312
,6.8498981162029801694757225
,6.6548757843549877222244504
,6.4662698875723858549235956
,6.2830130027163839656623168
,6.1049575160111668736817592
,5.9319589481199574976244548
,5.7638758877425502191726991
,5.6005700734769501281107296
,5.4419065385390625877448656
,5.2877537538511889536607669
,5.1379837295324790602535359
,4.9924720576510619451937600
,4.8510978967131652694888544
,4.7137439092777793092636784
,4.5802961685783829537399470
,4.4506440495866490536513993
,4.3246801165590440518826654
,4.2022999885368443884203771
,4.0834024677138440750923110
,3.9678888778659051617125897
,3.8556633003839118067901381
,3.7466332277084162249991550
,3.6407081558928631181970559
,3.5378003370044788233883537
,3.4378245223272680952675273
,3.3406978923241874568361709
,3.2463399883479877594538721
,3.1546726461310883316002673
,3.0656199310879066466384302
,2.9791080754360774740518991
,2.8950654169684244543248042
,2.8134223403919635941861088
,2.7341112185564839798246339
,2.6570663574070469969967689
,2.5822239413546648201247535
,2.5095219804851951472812743
,2.4389002592936210866980673
,2.3703002868970863836750596
,2.3036652486850006660290546
,2.2389399593669603305556848
,2.1760708173808680498950707
,2.1150057606246530639282355
,2.0556942234760993137854257
,1.9980870950664055829548715
,1.9421366787741791704036132
,1.8877966529077325752439265
,1.8350220325446060520846459
,1.7837691324984326080027586
,1.7339955313842565498561044
,1.6856600367545686580683650
,1.6387226512793633403930471
,1.5931445399446086952366386
,1.5488879982445906691168602
,1.5059164213446596392032006
,1.4641942741919673487416276
,1.4236870625529236544792866
,1.3843613049571446005359121
,1.3469130150314621019447259
,1.3098565951132536966383668
,1.2738870188622022361357722
,1.2389745935606222282387989
,1.2050905119807375776019853
,1.1722068294099734497848431
,1.1402964414744900523146498
,1.1093330627504607299727013
,1.0792912061539834400747395
,1.0501461631018942366466717
,1.0218739844372384251158792
,0.9944514621147122479527525
,0.9678561116428365806996226
,0.9420661552807912952900438
,0.9170605059885470478064917
,0.8928187521294363993007437
,0.8693211429257086120259146
,0.8465485746719382253999697
,0.8244825777214370710055391
,0.8031053042792135610028481
,0.7823995170612091376582953
,0.7623485789076190899393737
,0.7429364434555155716211061
,0.7241476469646147551273430
,0.7059673013318030765361755
,0.6884008782478495680479114
,0.6713956170237629361707832
,0.6549575349173533123092739
,0.6390739812429521160552781
,0.6237328559343336964460036
,0.6089226083202707862085390
,0.5946322372252120791458196
,0.5808512924800933729940766
,0.5675698779439395380563838
,0.5547786561473563304858203
,0.5424688546587382864672122
,0.5306322743239320072206056
,0.5192612995209113790906486
,0.5083489106206696694911784
,0.4978886986867815389601333
,0.4878748827381108044143332
,0.4783023296786595435214906
,0.4691665772561925407124761
,0.4604638602648968848107813
,0.4521911393281730084936498
,0.4443461339690926714673935
,0.4369273584413452815589096
,0.4299341614501036579198967
,0.4233667719946141994036282
,0.4179048504185248202880132
,0.4121969678100873002435378
,0.4069212946325043156470258
,0.4020820860393795048715049
,0.3976847577239671638338336
,0.3937359539307661027152108
,0.3902436145402430889284062
,0.3866944506035298045887316
,0.3842513792556571661229725
,0.3822774351951485627409966
,0.3807895280786640634929086
,0.3798057516338532169086761
,0.3793454374889589364450160
,0.3794291848917825671350101
,0.3800788559257168297556007
,0.3813174990607028913558452
,0.3831692189919239655004901
,0.3856589532807386810908667
,0.3888121321657436735286240
,0.3926542068571702293056092
,0.3972100194484747825995896
,0.4025029842411956826353503
,0.4085540522676586183692393
,0.4153804612312900768067436
,0.4229942515146553061455847
,0.4314005712687437599228701
,0.4405958194883555223420046
,0.4505657103322694423397365
,0.4612833888396076775784138
,0.4727077768762299458948917
,0.4847823727564115614541151
,0.4974347482557794353219549
,0.5105770086717486000438271
,0.5241073918430680933511212
,0.5379131298047695741715302
,0.5518745151313633190426344
,0.5658699347384706923591580
,0.5797814455447596326820303
,0.5935003252920019178873190
,0.6069319720963866071627990
,0.6199995648393081815186179
,0.6326460951463733772826004
,0.6448346075743367489252478
,0.6565467759410024140009909
,0.6677801807270430378693504
,0.6785448005855861941526541
,0.6888592664695724065992977
,0.6987473593487666390089430
,0.7082350869215450206439755
,0.7173485094410582130208809
,0.7261123260436943560591772
,0.7345491204132200691034882
,0.7426791042001392728622022
,0.7505201850387285267274251
,0.7580880626410768652334582
,0.7653969893452203798744904
,0.7724594653171230618227128
,0.7792871566324122145630326
,0.7858900854493452436955181
,0.7922779677635963802018182
,0.7984596647203283659166573
,0.8044434308630096230885442
,0.8102369916441846120491732
,0.8158476054833022628187678
,0.8212821143896367193093511
,0.8265469859565555132974168
,0.8316483486995298601840432
,0.8365920221530170897139556
,0.8413835427676059630641703
,0.8460281863927496814881124
,0.8505309879501238290444576
,0.8548967587717425375970492
,0.8591301019783945669416880
,0.8632354261970841546869337
,0.8672169578572996861964839
,0.8710787522680432104493775
,0.8748247036646584762209500
,0.8784585544178463711872951
,0.8819839035820108419372332
,0.8854042148714119653263310
,0.8887228239603957025138925
,0.8919429447719523507132067
,0.8950676743410417302015958
,0.8980999961648840068662025
,0.9010427827800295830229516
,0.9038987993497887840632643
,0.9066707105850434489369150
,0.9093610925059306682172178
,0.9119724480119237863817716
,0.9145838035179169045463254
,0.9171951590239100227108793
,0.9198065145299031408754331
,0.9224178700358962590399869
,0.9250292255418893772045408
,0.9276405810478824953690946
,0.9302519365538756135336484
,0.9328632920598687316982023
,0.9354746475658618498627561
,0.9380860030718549680273100
,0.9406973585778480861918638
,0.9433087140838412043564176
,0.9459200695898343225209715
,0.9485314250958274406855253
,0.9511427806018205588500791
,0.9537541361078136770146330
,0.9563654916138067951791868
,0.9589768471197999133437406
,0.9615882026257930315082945
,0.9641995581317861496728483
,0.9668109136377792678374021
,0.9694222691437723860019560
,0.9720336246497655041665098
,0.9746449801557586223310636
,0.9772563356617517404956175
,0.9798676911677448586601713
,0.9824790466737379768247251
,0.9850904021797310949892790
,0.9877017576857242131538328
,0.9903131131917173313183866
,0.9929244686977104494829405
,10.7056532631822101109264622
,10.4004104082080033322199597
,10.1041642120591443898547368
,9.8166586521296981260320536
,9.5376185496200402980093713
,9.2667594961519963447926784
,9.0037965401215167560167174
,8.7484512040259367893213494
,8.5004566220050428171362000
,8.2595607841091656098342355
,8.0255280387799086128097770
,7.7981391290177928254934159
,7.5771901154989631521630145
,7.3621828915744256249809041
,7.1538614119965497906150631
,6.9521630190539083216094696
,6.7541416430772498458168229
,6.5627309563286342353194414
,6.3767476743127238236752419
,6.1960423808272260259855102
,6.0204688169484432691547227
,5.8498837683469719905815509
,5.6841471308071076506962527
,5.5231220600850807755932692
,5.3666751325491919288879217
,5.2146764686674282884837339
,5.0669997963654118677823135
,4.9235224513533824008959527
,4.7841253246512192021100418
,4.6486927736519696452432981
,4.5171125135181124932159946
,4.3892755025672336444131361
,4.2650758077066521778419883
,4.1444106953913841806524943
,4.0271801016919566151841536
,3.9132865940842203045235692
,3.8026363371958495918079279
,3.6951374739832911764381151
,3.5907009531455207351768877
,3.4892402597773402028735745
,3.3906713443770173377345145
,3.2949125536024652660671563
,3.2018845628053873575424859
,3.1115103103857468802573294
,3.0237149339826188132462903
,2.9384257083110942865289417
,2.8555719857470163169921307
,2.7750851364879589588952058
,2.6968984928393169298033172
,2.6209472937369340250768346
,2.5471686311743608754909474
,2.4755013981802220790484625
,2.4058862382972883153797738
,2.3382654965204232588860123
,2.2725831716535500603981745
,2.2087848700474874696908500
,2.1468177606815794788985841
,2.0866305315531836761522300
,2.0281733473401581946404804
,1.9713978083025951448803426
,1.9162569103912696633074120
,1.8627050065312988902377356
,1.8106977690507239930894912
,1.7601921532247855051167562
,1.7111463619077913467236840
,1.6635198112255678015714011
,1.6172730973025650769159256
,1.5723679639988188405652636
,1.5287672716330216182711865
,1.4864349666690770401800137
,1.4453360523446283636417320
,1.4054365602211686958611381
,1.3667035226364938615972733
,1.3298313760587971987803257
,1.2933391713651292143083538
,1.2579202857100706403059576
,1.2235454972912067628243449
,1.1901864603272851450554981
,1.1578156825906433802231277
,1.1264065037421755466340301
,1.0959330744598942963818899
,1.0663703363535761425850978
,1.0376940026595322663638399
,1.0098805397111418891142876
,0.9829071491822470862942396
,0.9567517511016800924039671
,0.9313929676376438981932893
,0.9068101076507457669606538
,0.8829831520150237533783866
,0.8598927397096822744515521
,0.8375201546937633967360171
,0.8158473135949246834996984
,0.7948567542724433998557743
,0.7745316253487528612708957
,0.7548556768304471864539096
,0.7358132519389829484524057
,0.7173892802211848662707894
,0.6995692718952032373991301
,0.6823592529294861819266771
,0.6657065642997689325355282
,0.6496177901658349851388152
,0.6340807040778504433120588
,0.6190836405432694755646139
,0.6046154953663676057118437
,0.5906657274322941741928616
,0.5772243620380377304712738
,0.5642819958827954840430152
,0.5518298038160610596847278
,0.5398595474975288466268353
,0.5283635861098682218184308
,0.5173348893202851517258978
,0.5067670525024742245179254
,0.4966543145611497234170884
,0.4869915784468910047166901
,0.4777744347354496157187498
,0.4689991884849163961135332
,0.4606628885811815399264901
,0.4527633614462855948801234
,0.4452992473363172609701621
,0.4382700404213952793952558
,0.4316761350123368701225957
,0.4261914582190899913882731
,0.4204764565979077772794881
,0.4152037516045333220837676
,0.4103778366014007028539368
,0.4060043810688821475096688
,0.4020902960212139887197225
,0.3986437972375674321234840
,0.3950752769953645993084024
,0.3927150145381942958344723
,0.3908336700029452215332526
,0.3894486622500403782964895
,0.3885785352029345052216058
,0.3882429933146740452798440
,0.3884629090098941639475072
,0.3892602909310842185242052
,0.3906581744278345147414200
,0.3926804525911065102405928
,0.3953516072720238416771110
,0.3986963165833632971590816
,0.4027389248730035564705076
,0.4075027497449957847308610
,0.4130091983935140209638348
,0.4192766701491503211762790
,0.4263192531122604322924019
,0.4341452051116247989881458
,0.4427552529495319411090293
,0.4521407721531794932090520
,0.4622819452098455572652824
,0.4731460402662333586398802
,0.4846859993567783075896216
,0.4968395591730457305779112
,0.5095291360796295743185169
,0.5226627142309467899394804
,0.5361358670485049104925679
,0.5498349787679449596211612
,0.5636415442235748196608824
,0.5774372536742082839822388
,0.5911094035137187674422421
,0.6045560671446376099780196
,0.6176904405621119753533321
,0.6304438517122742391407542
,0.6427671401221057845276619
,0.6546303386223357723139316
,0.6660208570178313136622705
,0.6769405675092514673707456
,0.6874022992705201007268556
,0.6974262516931473143699804
,0.7070367488393329846729785
,0.7162596093146398334994274
,0.7251202500520130822536657
,0.7336425016899723594576699
,0.7418480196664211101520436
,0.7497561305767893591323059
,0.7573838604556174525228585
,0.7647464780897165192996567
,0.7718574138675862172931375
,0.7787290019083585868031605
,0.7853719200516939835665653
,0.7917963375121030988879056
,0.7980115116309959288898312
,0.8040260293140598646388639
,0.8098478985108171768203533
,0.8154846204941457177284292
,0.8209432480345165705770683
,0.8262304330824348230777332
,0.8313524664874311076445679
,0.8363153115397173875678050
,0.8411246326241170745419140
,0.8457858199411957267344064
,0.8503040110196898870853488
,0.8546841095806566590553643
,0.8589308021940157411577843
,0.8630485730775063757391763
,0.8670417173175588576583550
,0.8709143527386059568939913
,0.8746704306142717433303346
,0.8783137454017888590129814
,0.8818479436776313074020095
,0.8852765324235072341707564
,0.8886028867137336639814293
,0.8918302566779358064863459
,0.8949617734375603372853902
,0.8980004537234914652188422
,0.9009492032685996187879596
,0.9038108198468935983171946
,0.9065879976587701838397493
,0.9092833349662119424294815
,0.9118993457931411361627738
,0.9144384740070379269383238
,0.9169776022209347177138739
,0.9195167304348315084894239
,0.9220558586487282992649739
,0.9245949868626250900405239
,0.9271341150765218808160739
,0.9296732432904186715916239
,0.9322123715043154623671740
,0.9347514997182122531427240
,0.9372906279321090439182740
,0.9398297561460058346938240
,0.9423688843599026254693740
,0.9449080125737994162449240
,0.9474471407876962070204740
,0.9499862690015929977960241
,0.9525253972154897885715741
,0.9550645254293865793471241
,0.9576036536432833701226741
,0.9601427818571801608982241
,0.9626819100710769516737741
,0.9652210382849737424493242
,0.9677601664988705332248742
,0.9702992947127673240004242
,0.9728384229266641147759742
,0.9753775511405609055515242
,0.9779166793544576963270742
,0.9804558075683544871026243
,0.9829949357822512778781743
,0.9855340639961480686537243
,0.9880731922100448594292743
,0.9906123204239416502048243
,0.9931514486378384409803743
,10.8626946347954866922691508
,10.5528654928609171292919200
,10.2521697808825855702252738
,9.9603561104310021079299986
,9.6771502431990885639834232
,9.4022656285783483554041595
,9.1354128135531009746728159
,8.8763072151342186089095776
,8.6246749755774434476052193
,8.3802568333243083742445378
,8.1428101250218496431898529
,7.9121091759802615328567299
,7.6879444312771125780159309
,7.4697752230782308302536876
,7.2584550812782051565363872
,7.0539264244927695202136420
,6.8529133148169920630721208
,6.6587123720996714837383479
,6.4700166990545016076907814
,6.2866750990757163108924033
,6.1085395687149324217557478
,5.9354651299890317517338190
,5.7673098732715413206051380
,5.6039351086251629752155168
,5.4452055426388286107908243
,5.2909894242579031953255253
,5.1411586300881602085155464
,4.9955886822579218531359402
,4.8541587074392769096675693
,4.7167513535634491006476310
,4.5832526823032955221037810
,4.4535520526453229450680738
,4.3275419881772192454150172
,4.2051182131277444753436612
,4.0861793107174557704297513
,3.9706263225595876953377683
,3.8583640936693450740335720
,3.7492994231255099002453335
,3.6433419629322898458667623
,3.5404039384592467243351166
,3.4404000765076427903466083
,3.3432475351257355811185334
,3.2488658351982442340499802
,3.1571767938610988402103885
,3.0681044597678028829079722
,2.9815750502230335960973662
,2.8975168898800176542351892
,2.8158603521191998275696733
,2.7365378003828904063254868
,2.6594835330037622789234319
,2.5846337286233183050399020
,2.5119263934161857321214484
,2.4413013098390314858932015
,2.3726999868601650334198894
,2.3060656116292292949765397
,2.2413430025483336294200853
,2.1784785637070935848669251
,2.1174202406451625435579444
,2.0581174774069541655308058
,2.0005211748543714200820887
,1.9445836502045379390324342
,1.8902585977606833900210859
,1.8375010508054461233484744
,1.7862673446270551647074853
,1.7365150806498925728504901
,1.6882030916421482125144848
,1.6412914079743181616777292
,1.5957412249034683693338366
,1.5515148708592685355966978
,1.5085757767089409409067002
,1.4668884459793944952110678
,1.4264184260159868955497586
,1.3871322800584904300080780
,1.3489975602160984013977441
,1.3127071495427653502474641
,1.2767847183395986121468013
,1.2419220711424177050474782
,1.2080904635057712059875712
,1.1752620177025629999434386
,1.1434097007847581206618770
,1.1125073034525914117409684
,1.0825294197249903938029547
,1.0534514274055517546457850
,1.0252494693400633352098339
,0.9979004354631162421185309
,0.9713819456324481738107579
,0.9456723332500097667363548
,0.9207506296682895774452504
,0.8965965493800820418357489
,0.8731904759920291470010056
,0.8505134489906703842976299
,0.8285471513285876943299968
,0.8072738978895299677418507
,0.7866766249313871250947727
,0.7667388806423197644690504
,0.7474448169568245203819856
,0.7287791827392485766168306
,0.7107273183314424258583131
,0.6932751512763319912124871
,0.6764292795115526280014251
,0.6601371610348764074061023
,0.6444059725263979743203890
,0.6292239352171490329723724
,0.6145798433856693998578180
,0.6004630664064730671825032
,0.5868635523793855890417603
,0.5737718334532382336021783
,0.5611790329387402742611357
,0.5490768743676351926197299
,0.5374576926377887531316446
,0.5263144474444528819745415
,0.5156407389853407963187237
,0.5054308263002623702320193
,0.4956796483143278697625078
,0.4863828479715251451587221
,0.4775367996704704687260801
,0.4691386390761544955552154
,0.4611862973641650542688808
,0.4536785378577297689339787
,0.4466149963183718152315294
,0.4399962273923000988240517
,0.4344904232145116451668798
,0.4287698854132517278792136
,0.4235016835587034900179049
,0.4186905366887580526302770
,0.4143423526977801918391719
,0.4104642906255413503657792
,0.4070648194130759844888701
,0.4034698908048490739730596
,0.4011945196931402390916332
,0.3994075013043657529365760
,0.3981267250604826335447228
,0.3973711385501919046703279
,0.3971607632335359960862320
,0.3975166781818409988957796
,0.3984609599727145234915326
,0.4000165389363162238289817
,0.4022069905042711113196674
,0.4050562202821197943514164
,0.4085880197807603142479138
,0.4128254798240561518340996
,0.4177902381074283799655689
,0.4235015361779085329985151
,0.4299750684243827114627834
,0.4372216370401684759627869
,0.4452456131584381915367032
,0.4540432490044329916223376
,0.4636009159420914627069976
,0.4738933796062715364527662
,0.4848822633698733342022535
,0.4965148957173399768549871
,0.5087237594829944198338012
,0.5214267577671085618362667
,0.5345285043743490671630525
,0.5479227216501364461365142
,0.5614957571949757975104944
,0.5751310402856582015829190
,0.5887141397824452448972465
,0.6021379444174416173396480
,0.6153074138865165521039557
,0.6281433653323642563037765
,0.6405848632413746468472482
,0.6525900089631011535828975
,0.6641351442901748391989258
,0.6752127252205709639909514
,0.6858282860859570284617348
,0.6959969859161817540282868
,0.7057402038874951433200522
,0.7150825502145751189075895
,0.7240495117469781805041862
,0.7326658070306831804785475
,0.7409544020800383767877406
,0.7489360615423132916390614
,0.7566292244843946246390942
,0.7640503332359651622596175
,0.7712138722748823616015557
,0.7781329558241717458955122
,0.7848190335426811214958320
,0.7912827958607877576469036
,0.7975339557943719182020459
,0.8035814787843087447782864
,0.8094336915913282748391566
,0.8150983674156763170159934
,0.8205827934926063216281023
,0.8258938257701814444899924
,0.8310379339283255895054481
,0.8360212390251035019517190
,0.8408495453936530861227538
,0.8455283679691454334914624
,0.8500629559242671717811390
,0.8544583132828157401306157
,0.8587192170318435069376051
,0.8628502331429295235665222
,0.8668557308296001018277366
,0.8707398953032311483823946
,0.8745067392419224594490856
,0.8781601131574705565441263
,0.8817037148331364759812345
,0.8851410979948722834720343
,0.8884756803392154234089162
,0.8917107509393871200842341
,0.8948494768947502508993352
,0.8978949089675312134062324
,0.9008499860294061356569273
,0.9037175385584618192424955
,0.9065002921293419113624168
,0.9092008724556361887181311
,0.9118218134676702169016949
,0.9143655686446333641370643
,0.9168345234558049616779840
,0.9193034782669765592189037
,0.9217724330781481567598235
,0.9242413878893197543007432
,0.9267103427004913518416629
,0.9291792975116629493825826
,0.9316482523228345469235023
,0.9341172071340061444644221
,0.9365861619451777420053418
,0.9390551167563493395462615
,0.9415240715675209370871812
,0.9439930263786925346281009
,0.9464619811898641321690206
,0.9489309360010357297099404
,0.9513998908122073272508601
,0.9538688456233789247917798
,0.9563378004345505223326995
,0.9588067552457221198736192
,0.9612757100568937174145390
,0.9637446648680653149554587
,0.9662136196792369124963784
,0.9686825744904085100372981
,0.9711515293015801075782178
,0.9736204841127517051191376
,0.9760894389239233026600573
,0.9785583937350949002009770
,0.9810273485462664977418967
,0.9834963033574380952828164
,0.9859652581686096928237362
,0.9884342129797812903646559
,0.9909031677909528879055756
,0.9933721226021244854464953
,11.0189126513962296627369142
,10.7045193702828882464928029
,10.3993930570649855127385308
,10.1032880955650643528542787
,9.8159321516628299519879874
,9.5370372859740140114581664
,9.2663100760265546540495052
,9.0034601535001588246132087
,8.7482068030722981433200403
,8.5002834969183762581224073
,8.2594404386438551313176504
,8.0254453507809575540932201
,7.7980828526683767520921720
,7.5767668866000956739981120
,7.3624682584778344818232654
,7.1551340669924465842655081
,6.9520434196604927734597368
,6.7541630495664266575772672
,6.5627704545161718030499287
,6.3768074676526280697430593
,6.1961243749326806451449556
,6.0205744746202825012915127
,5.8500140907202533568920444
,5.6843027215779216021473985
,5.5233032311118028800933644
,5.3668820170297246718860151
,5.2149091192659682292287471
,5.0672582570452302519470322
,4.9238068010359663517760964
,4.7844356970149357621835406
,4.6490293602798358207905949
,4.5174755578268834810273802
,4.3896652798321325050778796
,4.2654926396765562301993668
,4.1448550888406803238694920
,4.0276519486431450189911629
,3.9137868128023312053187510
,3.8031651472265424196450567
,3.6956953145898459034413008
,3.5912882876707103996238857
,3.4898575764902770579567459
,3.3913191572013623442671815
,3.2955914027454578096865134
,3.2025950153367821471306343
,3.1122529608108733256699452
,3.0244904048665617324331834
,2.9392346508461200116357759
,2.8564150804125003624278634
,2.7759630938520998277851959
,2.6978120542616386146050900
,2.6218972321515123802271319
,2.5481557519211222029298369
,2.4765265398818834263749977
,2.4069502737826136140597555
,2.3393693337960024258848080
,2.2737277549269663268205477
,2.2099711808049180561397407
,2.1480468188230599224652906
,2.0879033965889628454704052
,2.0294911196518090612528340
,1.9727616304728687879332938
,1.9176679686069406649551183
,1.8641645320636743843323302
,1.8122070398188234729985879
,1.7617524954466441400313670
,1.7127591518457847552525664
,1.6651864770321429531918511
,1.6189951209733379755562055
,1.5741468834405420995636860
,1.5306046828545913918162569
,1.4883325261044422216372141
,1.4472954793172192466954584
,1.4074596395603022891407363
,1.3687921074571189894442114
,1.3312609606995966515796681
,1.2955575545529403047595451
,1.2602101454856242668256527
,1.2259089912669571820202918
,1.1926258312126782890061349
,1.1603332622521347339272779
,1.1290047175401600743072095
,1.0986144458852291627692921
,1.0691374919885103800254456
,1.0405496774902365242354563
,1.0128275828213670894939469
,0.9859485298597420177557638
,0.9598905653900666745670378
,0.9346324453661815079286157
,0.9101536199727496834199769
,0.8864342194841864364107664
,0.8634550409255511427275565
,0.8411975355583118929558850
,0.8196437972468333388320616
,0.7987765518068992154354646
,0.7785791474840207948560078
,0.7590355467343212758635218
,0.7401303194550560293762942
,0.7218486377083493943374037
,0.7041762717906238089327076
,0.6871192704876195600505184
,0.6706257643860475958774714
,0.6547024060674377921031919
,0.6393373049800308294265960
,0.6245191553023284880552524
,0.6102372382456914268189507
,0.5964814259694398712596808
,0.5832421872225164172220957
,0.5705105948020182671243106
,0.5582783349883612133979227
,0.5465377190943692120583819
,0.5352816973324534544076414
,0.5245038749602397576410340
,0.5141985310848258272642397
,0.5043606401732935173853889
,0.4949858966690263151200213
,0.4860707429243983912492411
,0.4776123993758716324009583
,0.4696088992154628383168813
,0.4620591252324236508641775
,0.4549628501601927221820176
,0.4483207831735995241295711
,0.4427953832119690402713275
,0.4370707772896988974054011
,0.4318084830854646560815979
,0.4270134315808331582076107
,0.4226917524068843357021308
,0.4188508324765540802303576
,0.4154993696513892276200863
,0.4118703214899482878408321
,0.4096817083593815578268504
,0.4079905018554312867706813
,0.4068150207532367779172944
,0.4061745674828066143824401
,0.4060894228006363682048629
,0.4065808045704494277927665
,0.4076707781452023060531076
,0.4093820774758126224135424
,0.4117378562574732780987574
,0.4147613271857836791944862
,0.4184752670077901970380196
,0.4229013757613639956645102
,0.4280594690140592240013007
,0.4339664818682625324619551
,0.4406352734974147145052825
,0.4480732525713381764198573
,0.4562808339164290960532355
,0.4652497818356587377941480
,0.4749615266919994804872829
,0.4853855773856769473262318
,0.4964781875081121231829684
,0.5081814735292865536919749
,0.5204231936332527341804166
,0.5331173809751978964754926
,0.5461660051521519676498428
,0.5594616971006434180679889
,0.5728914968490962378311337
,0.5863413951157976367056790
,0.5997012964429201398175451
,0.6128699171704012904626779
,0.6257590915767384798229500
,0.6382970068735345225974243
,0.6504300132842889548001608
,0.6621228874652839158088113
,0.6733576337189833838081654
,0.6841311212761453930397693
,0.6944519862243216934416523
,0.7043372671682349706046011
,0.7138091972009278363131557
,0.7228924656612457644300207
,0.7316121202560593728136951
,0.7399921477326628638238049
,0.7480546640821534865040121
,0.7558195837094657809629439
,0.7633045598623869887333626
,0.7705253505010072334613369
,0.7774959620708428165158921
,0.7842287161632689462820167
,0.7907349217128487595118713
,0.7970248196125229167563475
,0.8031078098215668203962991
,0.8089925815274270348709251
,0.8146872143245516006970774
,0.8201992576430344739080169
,0.8255357941365396579058711
,0.8307034912019929384641159
,0.8357086435788569911409240
,0.8405572091019984926063557
,0.8452548390889565999017918
,0.8498069044438268937469161
,0.8542185182884244332157664
,0.8584945557416305828013492
,0.8626396713314318231979883
,0.8666583144230739499391802
,0.8705547429696401939835937
,0.8743330358318901485148444
,0.8779971038708854758070288
,0.8815506999902716911421408
,0.8849974282915891166112488
,0.8883407524897865004120945
,0.8915840036890108066813809
,0.8947303875184005050869018
,0.8977829904950903605609369
,0.9007447854100327777615576
,0.9036186356642642580894176
,0.9064072989084139830850972
,0.9091134309488594356096769
,0.9117395913022295905747683
,0.9142882514790559023154515
,0.9167618057204521830882982
,0.9191625817482386162637908
,0.9215633577760250494392835
,0.9239641338038114826147762
,0.9263649098315979157902689
,0.9287656858593843489657615
,0.9311664618871707821412542
,0.9335672379149572153167469
,0.9359680139427436484922396
,0.9383687899705300816677322
,0.9407695659983165148432249
,0.9431703420261029480187176
,0.9455711180538893811942103
,0.9479718940816758143697029
,0.9503726701094622475451956
,0.9527734461372486807206883
,0.9551742221650351138961810
,0.9575749981928215470716736
,0.9599757742206079802471663
,0.9623765502483944134226590
,0.9647773262761808465981517
,0.9671781023039672797736443
,0.9695788783317537129491370
,0.9719796543595401461246297
,0.9743804303873265793001224
,0.9767812064151130124756151
,0.9791819824428994456511077
,0.9815827584706858788266004
,0.9839835344984723120020931
,0.9863843105262587451775858
,0.9887850865540451783530784
,0.9911858625818316115285711
,0.9935866386096180447040638
,11.1742257791421515378260665
,10.8552936937828299335251359
,10.5457585636249433491684613
,10.2453816963175974308342120
,9.9538936569422435951537409
,9.6710059134059438434860567
,9.3964216534313163009528580
,9.1298450908782307067212969
,8.8709888298725871891292627
,8.6195790967882093269736288
,8.3753588668892380297847922
,8.1380890913429517752319953
,7.9075483614834540802007723
,7.6831024371521019489250648
,7.4655335940365104008265007
,7.2543152401387329675230831
,7.0497797525272982710475844
,6.8490334875219440746718647
,6.6549608558998709639809022
,6.4663927769169458059650424
,6.2831778583112534164456520
,6.1051677146423184439072429
,5.9322169439373650945412919
,5.7641832688201271039929452
,5.6009277398805750181054464
,5.4423149259945402533844572
,5.2882130469008972184496997
,5.1384940310799267493280240
,4.9930335027081724774689064
,4.8517107136484387552854969
,4.7144084407245312462464426
,4.5810128669975656023893862
,4.4514134609859654645447335
,4.3255028193354432275441468
,4.2031769425639202708566700
,4.0843341084816673358659500
,3.9688757254595947721043103
,3.8567066792234787619975123
,3.7477338199478253955021501
,3.6418668756034127120813082
,3.5390181469770523037254861
,3.4391024356496449065900833
,3.3420369737339341575932394
,3.2477413554379293003648854
,3.1561374705031224330298301
,3.0671494395615761519025000
,2.9807035509971080422531031
,2.8967282009475505688556041
,2.8151538325498699499860322
,2.7359128795114227017393205
,2.6589397098976625954946940
,2.5841705718630034738225731
,2.5115435409524575760542575
,2.4409984689273280800136945
,2.3724769340728393274275732
,2.3059221929479907231552716
,2.2412791335391748503980125
,2.1784942297802634136871802
,2.1175154974029788412792641
,2.0582924510824427422051031
,2.0007760628441260131182844
,1.9449187216994678895076731
,1.8906741944787353038037736
,1.8379975878308023595764098
,1.7868453113607145610330917
,1.7371750418770894874853639
,1.6889456887225202663671553
,1.6421173601613514581032405
,1.5966513308003387194844436
,1.5525100100188706786497050
,1.5096569113866253886158120
,1.4680566230477190003966825
,1.4276747790516421954265525
,1.3884780316125147070493995
,1.3504340242795120907715045
,1.3142287456498926712100683
,1.2783999116634108261791880
,1.2436324667496545526290674
,1.2098977699902042637347677
,1.1771680508510908857999766
,1.1454163875394141047792118
,1.1146166861911814827124090
,1.0847436608853064932134203
,1.0557728144805771375303038
,1.0276804202741269822496406
,1.0004435044811919031104708
,0.9740398295360430669376228
,0.9484478782126387619300090
,0.9236468385612445208820986
,0.8996165896563470543156882
,0.8763376881561328879399753
,0.8537913556907629208936328
,0.8319594671304443300741127
,0.8108245398346846100068319
,0.7903697240405294088816390
,0.7705787945873356914461283
,0.7514361441659180851360134
,0.7329267781876732668067120
,0.7150363111764426182759280
,0.6977509643060251232071778
,0.6810773937342897710323086
,0.6649638676688063299025089
,0.6494176759543861532364417
,0.6344274140241309423160487
,0.6199822761841801144200303
,0.6060720598004141201897710
,0.5926871712410144432681136
,0.5798186336596128365172831
,0.5674580967810961551478499
,0.5555978488240386203855792
,0.5442308307674024181466166
,0.5333506528911527988512375
,0.5229516139912308014814357
,0.5130287232923591567157473
,0.5035777254709350447825500
,0.4945951289978210430042793
,0.4860782365678638083927865
,0.4780251800839285802879886
,0.4704349575625655921484736
,0.4633074733775819908920823
,0.4566435846353096295047180
,0.4511000224062269858826824
,0.4453727002211440577639223
,0.4401175867975237743223715
,0.4353398102279260051261645
,0.4310457040181007171142369
,0.4272428615395124085196699
,0.4239401840063355408894097
,0.4202686722173074040931340
,0.4181684676044910564662871
,0.4165743201785909732848268
,0.4155049346311794344899226
,0.4149799175195994505038755
,0.4150197497770101162650747
,0.4156457194592606541050372
,0.4168798016852562349221500
,0.4187444440097810582912530
,0.4212622772168708173978757
,0.4244557093360617483490671
,0.4283463816279412528231774
,0.4329544766459871851793650
,0.4382978599298235078407515
,0.4443910380288000894211109
,0.4512439281863476203682239
,0.4588604666175461477273245
,0.4672370758648655697520269
,0.4763610567156988939707674
,0.4862090018437431604425569
,0.4967453632665511098487343
,0.5079213351201005144375245
,0.5196742492910229049840609
,0.5319276793307949890987629
,0.5445924220436119123078811
,0.5575684945860721608568156
,0.5707481356397354765874752
,0.5840197223322954878099722
,0.5972723320910100497371786
,0.6104005535428486117766056
,0.6233090630190746272987212
,0.6359164732893295424176472
,0.6481580347356098448230455
,0.6599869105223863385845107
,0.6713739774519469349911560
,0.6823062948429103879988133
,0.6927845694549423782859776
,0.7028200437725927729459841
,0.7124312489294634120895466
,0.7216410005440260233555705
,0.7304739019990311721386433
,0.7389544831230625554496783
,0.7471059822584750209628623
,0.7549496876097108177816608
,0.7625046742972929614268196
,0.7697879532028110149965983
,0.7768145487028806916995904
,0.7835979697539648958226621
,0.7901500512222040528698130
,0.7964817186445757313251192
,0.8026028745076156933890843
,0.8085226232385680500414082
,0.8142493921278591839651995
,0.8197910255925784372976750
,0.8251548594981784612301112
,0.8303477807549518585616966
,0.8353762759763506684507206
,0.8402464718734399262700663
,0.8449641692736059583879182
,0.8495348721188473728460622
,0.8539638124399049345925050
,0.8582559720564952865373698
,0.8624161015809189700931370
,0.8664487371771849577584135
,0.8703582154345262944517003
,0.8741486866428793689465238
,0.8778241267031707817380948
,0.8813883478657748016260598
,0.8848450084658349146238265
,0.8881976218090895658363593
,0.8914495643403504976376439
,0.8946040831747478216939840
,0.8976643029766759873666615
,0.9006332320639447441834591
,0.9035137675866855566653157
,0.9063086998005744909789883
,0.9090207158672762854934035
,0.9116524041258796673403708
,0.9142062600189505561232295
,0.9166846943836653993642472
,0.9190900434365849580586882
,0.9214245778598286751304158
,0.9237591122830723922021434
,0.9260936467063161092738710
,0.9284281811295598263455986
,0.9307627155528035434173262
,0.9330972499760472604890538
,0.9354317843992909775607814
,0.9377663188225346946325089
,0.9401008532457784117042365
,0.9424353876690221287759641
,0.9447699220922658458476917
,0.9471044565155095629194193
,0.9494389909387532799911469
,0.9517735253619969970628745
,0.9541080597852407141346021
,0.9564425942084844312063296
,0.9587771286317281482780572
,0.9611116630549718653497848
,0.9634461974782155824215124
,0.9657807319014592994932400
,0.9681152663247030165649676
,0.9704498007479467336366952
,0.9727843351711904507084228
,0.9751188695944341677801503
,0.9774534040176778848518779
,0.9797879384409216019236055
,0.9821224728641653189953331
,0.9844570072874090360670607
,0.9867915417106527531387883
,0.9891260761338964702105159
,0.9914606105571401872822435
,0.9937951449803839043539710
,11.3285549132813212480641596
,11.0051124949027183674843400
,10.6911931693912443108729349
,10.3865663250790412064361590
,10.0909664456503982421509136
,9.8041052396566819027157180
,9.5256831287661327678506495
,9.2553993219636065958866311
,8.9929599621169771239692636
,8.7380840860892146082505860
,8.4905073729469702215055804
,8.2499838523197297490696656
,8.0162858951371198656943307
,7.7892029043800379284334667
,7.5681885383895437513501747
,7.3541112709549958381671786
,7.1468763497528167150107947
,6.9432758548180162350149658
,6.7465414393087934641357606
,6.5553858913940334929293385
,6.3696561710202663775248766
,6.1892022488657083556518046
,6.0138770384194142337719313
,5.8435365243903012455461976
,5.6780399754935482192763629
,5.5172501562459670410021317
,5.3610334844847642443710356
,5.2092601115952374968287586
,5.0618039259528293527523601
,4.9185424946835256676536119
,4.7793569648174969444198723
,4.6441319442323392152616179
,4.5127553781582783187786845
,4.3851183888434093205432873
,4.2611155382266963087545264
,4.1406437562964457654857142
,4.0236030275841976333595085
,3.9098969896098680898433031
,3.7994312016465903170114871
,3.6921141552680216690873749
,3.5878569501799910668182747
,3.4865732213035336428674782
,3.3881790676076395385507567
,3.2925929827630135982019510
,3.1997357876781702401558505
,3.1095305649789497515200765
,3.0219025949489597415720255
,2.9367792948853161938416179
,2.8540901572585948287041901
,2.7737666926960660163103967
,2.6957423729534726319911897
,2.6199525759061788043879915
,2.5463345321343573424144324
,2.4748272730538234398522945
,2.4053715805495490265286662
,2.3379099380715877565251049
,2.2723864831545013132085842
,2.2087469613225678699564014
,2.1469386813441255767997973
,2.0869104717995505815508750
,2.0286126389286391891175754
,1.9719969257242941917951384
,1.9170164722406910495777765
,1.8636257770852524551230545
,1.8117806600649621895371411
,1.7614382259587506585063466
,1.7125568293888315807294020
,1.6650960407650825523262483
,1.6190166132777401575282283
,1.5742804509148591307621246
,1.5308505774822063205675704
,1.4886911066044703488842060
,1.4477672126879246317088246
,1.4080451028259459711478030
,1.3694919896301300799024148
,1.3320760649711185230614774
,1.2964818589729698583568052
,1.2612516021307942359896970
,1.2270687612654023190827957
,1.1939052012046409423362547
,1.1617336479638749047182955
,1.1305276676954774117689340
,1.1002616464796044493112959
,1.0709107709534706476262045
,1.0424510097782491158113771
,1.0148590959440650927092520
,0.9881125099136625067330897
,0.9621894636036255610278545
,0.9370688851987373224616817
,0.9127304047923748830939417
,0.8891543408485405031171922
,0.8663216874960901758839782
,0.8442141026996112795899307
,0.8228138974057985777221802
,0.8021040258304424908075703
,0.7820680771062999969700513
,0.7626902685208376553305243
,0.7439554404956676414428784
,0.7258490532697864372480012
,0.7083571849510323925613875
,0.6914665302469159557929856
,0.6751843531077448279376085
,0.6594591024340437090955902
,0.6442987261130078691095946
,0.6296923327130216074820623
,0.6156296458437070517888401
,0.6021010103807029611999724
,0.5890974005505812405303345
,0.5766104300399607085481080
,0.5646323642584584190373675
,0.5531561349661663351540142
,0.5421753571609847499601642
,0.5316843486473925572965982
,0.5216781522830167272530844
,0.5121525613278518074267254
,0.5031041481057134667764785
,0.4945302945739155076054772
,0.4864292274997615850296029
,0.4788000552840759316275410
,0.4716428079370781900614418
,0.4649584831558573605470031
,0.4593980930217948510652093
,0.4536692896884539916158019
,0.4484224988287079383120215
,0.4436630298179538578473569
,0.4393974011175542093710078
,0.4356333900351725407773529
,0.4323800744298774145768505
,0.4286571540205060815154070
,0.4266467934417479956898944
,0.4251507175517615921833681
,0.4241879716466212535408431
,0.4237784142197294490195247
,0.4239426663359837088584925
,0.4247020174637887168778150
,0.4260782742871377926086041
,0.4280935100443999385966265
,0.4307697351816875408481167
,0.4341284471360165597708658
,0.4381900393611953270500692
,0.4429730617362402367298557
,0.4484933170254187251302369
,0.4547627803928716572201552
,0.4617883441541734690360954
,0.4695704213188006681534148
,0.4781014383605811102206928
,0.4873642920387762922374009
,0.4973308766308947026502096
,0.5079608210199565432318991
,0.5192005980484403204755495
,0.5309831994821769818315715
,0.5432285554963269813555371
,0.5558448411827099366888660
,0.5687307711324981474021456
,0.5817788261036851427121519
,0.5948792808066855064552669
,0.6079247283743431928826340
,0.6208146918286842064205189
,0.6334598515591840506289145
,0.6457854349040961228212154
,0.6577334087708561760621251
,0.6692632677348501202274633
,0.6803514337056489891253364
,0.6909894560782536832022060
,0.7011813594757009271418724
,0.7109405575609206717757615
,0.7202867432045740869739348
,0.7292430900849441455235933
,0.7378339855827824589340480
,0.7460833860173389231462693
,0.7540137776039963490859463
,0.7616456482327524923903184
,0.7689973079572850478413670
,0.7760850773231989796485664
,0.7829234609869715200147766
,0.7895252403895219872609346
,0.7959020319318614866688222
,0.8020643227668726726875548
,0.8080216967334686861690329
,0.8137829787527901537202979
,0.8193563474330524121214125
,0.8247494231214954618636170
,0.8299693376302931246968342
,0.8350227904061808814617507
,0.8399160945885437712377097
,0.8446552153894141268253293
,0.8492458025199233206947724
,0.8536932179077760807217601
,0.8580025596256896092128841
,0.8621786827270888631247203
,0.8662262175271077113691831
,0.8701495857518050103251994
,0.8739530148922254326748771
,0.8776405510339024829136179
,0.8812160703819192919539205
,0.8846832896654155398152852
,0.8880457755821301590870576
,0.8913069534267896720791668
,0.8944701150213307805358909
,0.8975384260104770639543403
,0.9005149324988697134841686
,0.9034025669234627686776662
,0.9062041530638178521428472
,0.9089224102872537347508342
,0.9115599575131125842375468
,0.9141193177897085631045115
,0.9166029244618545401834808
,0.9190131293095407105653294
,0.9213522116848239518205332
,0.9236223860180911016115601
,0.9258925603513582514025870
,0.9281627346846254011936139
,0.9304329090178925509846408
,0.9327030833511597007756677
,0.9349732576844268505666946
,0.9372434320176940003577215
,0.9395136063509611501487484
,0.9417837806842282999397753
,0.9440539550174954497308022
,0.9463241293507625995218291
,0.9485943036840297493128560
,0.9508644780172968991038829
,0.9531346523505640488949098
,0.9554048266838311986859367
,0.9576750010170983484769636
,0.9599451753503654982679905
,0.9622153496836326480590174
,0.9644855240168997978500443
,0.9667556983501669476410711
,0.9690258726834340974320980
,0.9712960470167012472231249
,0.9735662213499683970141518
,0.9758363956832355468051787
,0.9781065700165026965962056
,0.9803767443497698463872325
,0.9826469186830369961782594
,0.9849170930163041459692863
,0.9871872673495712957603132
,0.9894574416828384455513401
,0.9917276160161055953423670
,0.9939977903493727451333939
,11.4818235193438056285231141
,11.1539023109271600020520054
,10.8356262050859939449765079
,10.5267738249235609515608303
,10.2270846094964955597106382
,9.9362713730387035582225508
,9.6540324350203601255770991
,9.3800624555490141887048594
,9.1140613768825406992846183
,8.8557411387842766004041550
,8.6048300848789516237502539
,8.3610751931843445561298722
,8.1242424335561995718535400
,7.8941156687377223022394901
,7.6701042121664464445984777
,7.4531920149604866665526970
,7.2432856810479062659169358
,7.0368440669084062477622865
,6.8374674359115195088065775
,6.6437433216386674317277539
,6.4555170643617403314351577
,6.2726370301127944983932139
,6.0949544900238734612685221
,5.9223237302832174577815749
,5.7546022711578173058910579
,5.5916510992764605347815632
,5.4333348506635728014657616
,5.2795219147506635692934651
,5.1300844559893707952369368
,4.9848983668849093930930394
,4.8438431741253724638340827
,4.7068019198351738197061422
,4.5736610356264577603724319
,4.4443101805950151472757170
,4.3186424784139880728162098
,4.1965535413967796074530270
,4.0779419246264296816661954
,3.9627100296578614546660901
,3.8507621351884702143308914
,3.7420055054094230051475733
,3.6363500476841430497643159
,3.5337082387526788096465680
,3.4339950526746303438585528
,3.3371278905851626817025135
,3.2430265123379733438468975
,3.1516129701152353348447832
,3.0628115434454232790528749
,2.9765486779429131125596086
,2.8927529223536745384137703
,2.8113548709795010971390639
,2.7322871058338069616411303
,2.6554841408981695316526839
,2.5808823679962564767720323
,2.5084200042349857895374043
,2.4380370409689540167619271
,2.3696751942473257557253419
,2.3032778567038159067692504
,2.2387900508516276332215966
,2.1761583837462490365055601
,2.1153310029802208092064575
,2.0562575539751861697368440
,1.9988891385377656195743157
,1.9431782746470391831650204
,1.8890788574426145007834066
,1.8365461213834801679212205
,1.7855366035490618514813832
,1.7360081080550719967448003
,1.6879196715579876109103452
,1.6412315298231565652287145
,1.5959050853327843011442155
,1.5519028759112627469107792
,1.5091885443465409277763456
,1.4677268089875261658505678
,1.4274834352987888497210633
,1.3884252083551915646353336
,1.3505199062604944515442185
,1.3137362744754079724174289
,1.2787574151122058641050216
,1.2441300288351755387594721
,1.2105361357906956332186610
,1.1779481127096245174357136
,1.1463391885934972602711923
,1.1156834242838846726897373
,1.0859556928856359814261623
,1.0571316610437093697072442
,1.0291877710748613683477970
,1.0021012239556035261500710
,0.9758499631658930084654457
,0.9504126593837548542254012
,0.9257686960215237848004222
,0.9018981555944604044938728
,0.8787818069248911623247977
,0.8564010932180490254239658
,0.8347381211033167991431014
,0.8137756508101006147626322
,0.7934970877186974247408102
,0.7738864755556581487283552
,0.7549284914448844974188546
,0.7366084428442186693430926
,0.7189122660869656789017768
,0.7018265258537216277900939
,0.6853580046121791058411077
,0.6694557806003225142177371
,0.6541273355954171364601279
,0.6393616935050954186436911
,0.6251485051107705803730141
,0.6114780545544441503480471
,0.5983412677008750346629995
,0.5857297225408658603029721
,0.5736356617599461804601901
,0.5620520076857808966508401
,0.5509723794715851719061561
,0.5403911129591438822217242
,0.5303032831876201003140636
,0.5207047299853442279271576
,0.5115920868545297262031113
,0.5029628115622530870609808
,0.4948152213845606883779737
,0.4871485296970015088646733
,0.4799628855145944839044603
,0.4732594190932535860305563
,0.4676834359441928712364245
,0.4619542701335174195165223
,0.4567168132295471583148583
,0.4519765391786433328391581
,0.4477401315558874883571150
,0.4440155281360165795412343
,0.4408119557679617828149787
,0.4370281180871374293595011
,0.4351088243962786816787514
,0.4337116029275426276612393
,0.4328557927570879093615019
,0.4325614510611399121664533
,0.4328492785433813438977779
,0.4337404976724505978324942
,0.4352566699257138238543519
,0.4374194090947999824514625
,0.4402500123651587049522504
,0.4437689672798257323194093
,0.4479953163599772469893878
,0.4529458738498000625050111
,0.4586342826942073624962859
,0.4650699033583742814101925
,0.4722565437031461255124043
,0.4801910700104746743122064
,0.4888619391930237867427422
,0.4982477354607139363729118
,0.5083158255002092618113352
,0.5190212767816925198971489
,0.5303061995989616361768526
,0.5420996989076329874990279
,0.5543185956153691140713136
,0.5668690312404738307350271
,0.5796490203451235556642018
,0.5925518531791162946120721
,0.6054701805496761624070245
,0.6183004509063805276269932
,0.6309472849687052242728669
,0.6433273369022906029712772
,0.6553722317593643209576726
,0.6670302802422990451347573
,0.6782668286092425891098401
,0.6890633151853220450533399
,0.6994152586941617677496197
,0.7093295356274919027939063
,0.7188213505495987254434453
,0.7279112769042875852321117
,0.7366226621279956532362121
,0.7449795766411823061403652
,0.7530053661161058009554381
,0.7607217706535555068469989
,0.7681485086904428216669771
,0.7753031679555473232312579
,0.7822014206398583135992908
,0.7888572199634319437322461
,0.7952828660032662533296843
,0.8014895737730364233541991
,0.8074874842091569471236312
,0.8132858805259730594627854
,0.8188933228408692421851356
,0.8243177532811111207777799
,0.8295665784436219158948234
,0.8346467349735181562309094
,0.8395647426273232794002865
,0.8443267479614724457803732
,0.8489385608669749450072572
,0.8534056855304585909038906
,0.8577333469680495925402397
,0.8619265139840328604492470
,0.8659899192022094682741340
,0.8699280766726559255275220
,0.8737452974503016056573301
,0.8774457034617808570686748
,0.8810332399157128069333567
,0.8845116864648973065143878
,0.8878846672954281427081469
,0.8911556602953247807619164
,0.8943280054368012432775004
,0.8974049124771782404152987
,0.9003894680286461671414600
,0.9032846419694392503529912
,0.9060932931101193243961234
,0.9088181740676122277733384
,0.9114619355064902395113791
,0.9140271302583544699160711
,0.9165162181407879860017829
,0.9189315722504717287577591
,0.9212754868258845597495110
,0.9235501854901317919654957
,0.9257578273002647906153584
,0.9279654691103977892652210
,0.9301731109205307879150837
,0.9323807527306637865649463
,0.9345883945407967852148090
,0.9367960363509297838646717
,0.9390036781610627825145343
,0.9412113199711957811643970
,0.9434189617813287798142596
,0.9456266035914617784641223
,0.9478342454015947771139849
,0.9500418872117277757638476
,0.9522495290218607744137103
,0.9544571708319937730635729
,0.9566648126421267717134356
,0.9588724544522597703632982
,0.9610800962623927690131609
,0.9632877380725257676630235
,0.9654953798826587663128862
,0.9677030216927917649627489
,0.9699106635029247636126115
,0.9721183053130577622624742
,0.9743259471231907609123368
,0.9765335889333237595621995
,0.9787412307434567582120621
,0.9809488725535897568619248
,0.9831565143637227555117875
,0.9853641561738557541616501
,0.9875717979839887528115128
,0.9897794397941217514613754
,0.9919870816042547501112381
,0.9941947234143877487611007
,11.6339577618951413029435571
,11.3015923005683216473471475
,10.9789895678496431941084666
,10.6659385651497373714846617
,10.3621847340331161291260287
,10.0674428853541133577209621
,9.7814099360256516746403577
,9.5037764935421300549478474
,9.2342366002143467795804099
,8.9724952271331730457859521
,8.7182733726832619680635617
,8.4713108547346749332973559
,8.2313670748439680124874940
,7.9982201659975116214695845
,7.7712324296683972235655347
,7.5515105948995939755263862
,7.3389620367446122273236142
,7.1296938529643547610703536
,6.9276958369770218482130986
,6.7314232872419772490957257
,6.5407199498393167047538554
,6.3554326244554175673329155
,6.1754109824805452078066992
,6.0005076523285367784410482
,5.8305784410626992908532884
,5.6654825858078528000305596
,5.5050829626246384762566777
,5.3492462156169020559559613
,5.1978427983792627742332115
,5.0507469398516233738405390
,4.9078365565949990667604652
,4.7689931350726189052124937
,4.6341016035657798255442685
,4.5030501701414875626028333
,4.3757305193554083544427158
,4.2520369798041528497378749
,4.1318666705060165256213622
,4.0151207693272725762767550
,3.9017022858251984018806979
,3.7915172664031140392637553
,3.6844744353826839322607611
,3.5804851203462049191728056
,3.4794631792057115760030683
,3.3813249290741258512582590
,3.2859890770248458835567362
,3.1933766527829106074420906
,3.1034109431075203033856269
,3.0160174293692070257577598
,2.9311237240292915551265196
,2.8486595122460003359776692
,2.7685564932725057474272035
,2.6907483239841831768046632
,2.6151705640468270175347243
,2.5417606226735744989753130
,2.4704577069256257182416903
,2.4012027715152592932668085
,2.3339384700714242981689495
,2.2686091078292691669560099
,2.2051605957061601870350387
,2.1435404057278266698460811
,2.0836975277695768404839782
,2.0255824275787097654699664
,1.9691470060455511514874161
,1.9143445596917239015510859
,1.8611297423455399613345662
,1.8094585279756085771651897
,1.7592881746549760002551466
,1.7105771896293411327150125
,1.6632852954641441645122768
,1.6173733972465187402889342
,1.5728035508193956015787762
,1.5295389320262753329870975
,1.4875438069465025670012892
,1.4467835031021893943403711
,1.4072243816192948617782577
,1.3688338103268375967047632
,1.3315801377796465665426240
,1.2961412436522048441389643
,1.2610731075582157778569581
,1.2270525792135802412019530
,1.1940516891158887702317770
,1.1620433320856167203061204
,1.1310012466158689825590500
,1.1008999950911821930077394
,1.0717149448757008478594344
,1.0434222502728405235217224
,1.0159988353588611520450513
,0.9894223776906154732557752
,0.9636712928826612900579107
,0.9387247200424603255086708
,0.9145625080496251335659963
,0.8911652026743104304529197
,0.8685140345610677936605271
,0.8465909081640837774429542
,0.8253783918036500244497233
,0.8048597091010619708484342
,0.7850187321003818663456286
,0.7658399763498292545094159
,0.7473085980475409062506742
,0.7294103930393077694915860
,0.7121317970255603979623515
,0.6954598858866152255586712
,0.6794020612177397167030790
,0.6639076367659120236908166
,0.6489847903454720734472971
,0.6346231007302624016475079
,0.6208127919609237599374296
,0.6075447419582853392228117
,0.5948104931900454195314865
,0.5826022655086581236716370
,0.5709129713759871771472376
,0.5597362332901225645542809
,0.5490664038809177638356118
,0.5388985886070072339748549
,0.5292286715035208199964245
,0.5200533441913984811222349
,0.5113701363670035693331783
,0.5031774509850536203359184
,0.4954746004613713172837208
,0.4882618456056119771169222
,0.4815404405667381149136475
,0.4759500002135408913694903
,0.4702214752460375235543211
,0.4649942351164755294234965
,0.4602739008630251094089658
,0.4560673005484218167637778
,0.4523825081634273992392536
,0.4492288711401447032223189
,0.4453740859213194402954628
,0.4435468728562756424160796
,0.4422490655091436129175975
,0.4415002487655579344050238
,0.4413206245809079830699773
,0.4417309128197332013243681
,0.4427522014246283443839047
,0.4444057318986783244874061
,0.4467125768711121547305254
,0.4496932325066790858691945
,0.4533670844407618472082788
,0.4577517309485166219218399
,0.4628621604084410812163242
,0.4687097748839854083335865
,0.4753012562661760864735072
,0.4826372912965790629158391
,0.4907112019016552362238315
,0.4995075299640608368356709
,0.5090006672269049570189736
,0.5191536504807695573404658
,0.5299172696362696166616502
,0.5412296449217014471244624
,0.5530164492705545997708327
,0.5651919141463441764727804
,0.5776607032258670448854332
,0.5903206826744287205599448
,0.6030664525166259393174073
,0.6157934399763548283246450
,0.6284022068454960807670773
,0.6408025589534127597346469
,0.6529170326534043944377572
,0.6646833940665155537885767
,0.6760559102547577525754718
,0.6870053093796197885012589
,0.6975175479723408900056825
,0.7075916376773099258912225
,0.7172368914057795086236524
,0.7264699740263066418677340
,0.7353121018619968030094469
,0.7437866459858410994598898
,0.7519172829124762813535199
,0.7597267252132290371591239
,0.7672359801072531348964390
,0.7744640159602441675801288
,0.7814277800416944419481524
,0.7881423419108035677282942
,0.7946210113732491420179826
,0.8008757812721256641452783
,0.8069174424576236459571987
,0.8127558100005299879242671
,0.8183998829798854179884415
,0.8238579702387709424726836
,0.8291377887215803932363656
,0.8342465408873728227590050
,0.8391909765354197414666260
,0.8439774430445282638046933
,0.8486119268963250306114787
,0.8531000885153383617165446
,0.8574472918783663244468585
,0.8616586299523790737353579
,0.8657389467521254822202081
,0.8696928566218777856278166
,0.8735247612120522475720463
,0.8772388645231007364699849
,0.8808391863147488898277970
,0.8843295741216774530357725
,0.8877137140734465692304411
,0.8909951406852921751422514
,0.8941772457645938976256161
,0.8972632865577583327620914
,0.9002563932309188832192604
,0.9031595757244095246107918
,0.9059757299540036612484073
,0.9087076432946835646831119
,0.9113579993449506533309545
,0.9139293821793652572438305
,0.9164242806061766444258865
,0.9188450931650505859593636
,0.9211593678752065805781513
,0.9234736425853626862192414
,0.9256857866084565733544309
,0.9278326711684568017801666
,0.9299795557284570302059024
,0.9321264402884572586316381
,0.9342733248484574870573738
,0.9364202094084577154831095
,0.9385670939684579439088452
,0.9407139785284581723345809
,0.9428608630884584007603166
,0.9450077476484586291860523
,0.9471546322084588576117881
,0.9493015167684590860375238
,0.9514484013284593144632595
,0.9535952858884595428889952
,0.9557421704484597713147309
,0.9578890550084599997404666
,0.9600359395684602281662023
,0.9621828241284604565919381
,0.9643297086884606850176738
,0.9664765932484609134434095
,0.9686234778084611418691452
,0.9707703623684613702948809
,0.9729172469284615987206166
,0.9750641314884618271463523
,0.9772110160484620555720880
,0.9793579006084622839978238
,0.9815047851684625124235595
,0.9836516697284627408492952
,0.9857985542884629692750309
,0.9879454388484631977007666
,0.9900923234084634261265023
,0.9922392079684636545522380
,0.9943860925284638829779738
,11.7848866204469846508118280
,11.4481143475718702973153995
,11.1212178140958251049141836
,10.8039975252931306215486984
,10.4962059758425994004937820
,10.1975608841715263963578764
,9.9077584954867834454717013
,9.6264858980636844876244140
,9.3534315732136708021471350
,9.0882936873123725263212691
,8.8307859136543704892119422
,8.5806408241451030960433854
,8.3376110998033414745123082
,8.1014689620782736056980866
,7.8715270759095439245811576
,7.6486780159749860885654016
,7.4323394820260961779467834
,7.2228533102305023660960615
,7.0171854498300447744441044
,6.8183857710338857671672486
,6.6252259516776250691805217
,6.4375512621417874115081759
,6.2552098168200620520451594
,6.0780526282070059806983409
,5.9059338270560450823154497
,5.7387109311856114857164357
,5.5762450802544485384260042
,5.4184011911342935263746767
,5.2650480208170051810157020
,5.1160581466704488917685012
,4.9713078860988284546351679
,4.8306771806410635505812934
,4.6940494661279217325500213
,4.5613115125915921765908934
,4.4323535633139607980979235
,4.3070687010666466321140433
,4.1853526011407202744862843
,4.0671052298934160518228964
,3.9522283403121143408043281
,3.8406267711621686622436300
,3.7322080735622753522306994
,3.6268824354813808952258114
,3.5245626079507057504258682
,3.4251638330637952378765476
,3.3286037738632532345661730
,3.2348024461707156618217596
,3.1436821520906526039595974
,3.0551674169418188142799409
,2.9691849246560386710314106
,2.8856634588386880224675224
,2.8045338433614777073898949
,2.7257288851660508299801222
,2.6491833187322506582006554
,2.5748337521566182495291741
,2.5026186147950051363864077
,2.4324781064272187336428033
,2.3643541479034886343413291
,2.2981903332337680900820942
,2.2339318830819472339044296
,2.1715255996282385453355346
,2.1109198227642780310020498
,2.0520643875866468874846760
,1.9949105831559099666350221
,1.9394111124894093389769978
,1.8855200537573886254705258
,1.8331928226532194781128737
,1.7823861359097739054391241
,1.7330579759352207069866836
,1.6851675565427908232152276
,1.6386752897502967485365843
,1.5935427536264923364939250
,1.5497326611626094372553553
,1.5072088301487620576324389
,1.4659361540362332299025638
,1.4258805737680360081753861
,1.3870090505616421427959040
,1.3492895396292330367771228
,1.3126909648224576177000245
,1.2778898561323190907756953
,1.2434465708000779216035880
,1.2100365903910703657686554
,1.1776324786444327674672650
,1.1462076547180788388402561
,1.1157363732046088333760281
,1.0861937050321568420940821
,1.0575555192531544967948776
,1.0297984657245959905225163
,1.0028999586811433442079533
,0.9768381611965806232689147
,0.9515919705208085721537259
,0.9271410042736432099985677
,0.9034655874820720633522342
,0.8805467404760047855916127
,0.8583661677179893478850659
,0.8369062477337545491451465
,0.8161500244137068760252873
,0.7960812000303127966560623
,0.7766841303065603607791445
,0.7579438217214652384612350
,0.7398459309209010070773616
,0.7223767656408998094619278
,0.7055232860357246726934477
,0.6892731048934614968004553
,0.6736341859434623602354009
,0.6585562130246873646655104
,0.6440480499966722005567021
,0.6300998613080394106233939
,0.6167024772111088237735999
,0.6038474046597478439579731
,0.5915268403784034179082596
,0.5797336863197412037962408
,0.5684615672804990138544667
,0.5577048511660179785920377
,0.5474586717994883722226973
,0.5377189547366759692081928
,0.5284824462986322801683059
,0.5197467438342897594338865
,0.5115103307103230356744916
,0.5037726119682691683365761
,0.4965339524764205147988605
,0.4897957210385346371595006
,0.4841918612728955961799215
,0.4784648669489519612341155
,0.4732486004535778056911965
,0.4685488117898321536181072
,0.4643724522390821340955824
,0.4607277071417341662851186
,0.4576240155507445561688940
,0.4536877771722765406714473
,0.4519534539914072945876455
,0.4507554047585158873978628
,0.4501134114162438915052178
,0.4500477665468531340842162
,0.4505791491555563021975672
,0.4517284465031728424300184
,0.4535165078775875158179076
,0.4559637869945603605437157
,0.4590898969570659238215171
,0.4629130372944211813113213
,0.4674492789797530245543555
,0.4727117073100777222549596
,0.4787094184097452354009761
,0.4854463707864730137586662
,0.4929201153349883068877091
,0.5011204562408039242527025
,0.5100281003652039624185477
,0.5196133920989043364357940
,0.5298352582763740103999339
,0.5406405116108475850111859
,0.5519636621752277427788158
,0.5637274006706883833217603
,0.5758438687704390268606858
,0.5882167712645897106327197
,0.6007443247400962027526816
,0.6133228734668038084620889
,0.6258509481232751303636519
,0.6382334085682825897123394
,0.6503852680585077150610118
,0.6622348041523445916212154
,0.6737256389809820333880452
,0.6848176031165024157942867
,0.6954863528897573532461251
,0.7057218977644252877468034
,0.7155263092859392992650669
,0.7249109683028632789003609
,0.7338937139291765721083038
,0.7424962055140876815428896
,0.7507417165815480908364066
,0.7586534725061613304575303
,0.7662535418586001734198021
,0.7735622174367975389941421
,0.7805977668943208103158327
,0.7873764900637886254841646
,0.7939128906488139847397179
,0.8002197916001586586176586
,0.8063087694188247889215404
,0.8121902592876282245271113
,0.8178737689999557858300250
,0.8233680286298045158943637
,0.8286811082325675759108208
,0.8338205100600746266792385
,0.8387932414092037491926135
,0.8436058730422096862966441
,0.8482645868520137799606573
,0.8527752154019383468153137
,0.8571432752060001991623039
,0.8613739950888584795407610
,0.8654723406069084745695363
,0.8694430352672098960553626
,0.8732905791094609515567981
,0.8770192650928044786340365
,0.8806331936379930835911978
,0.8841362856062385811029003
,0.8875322939429940438671451
,0.8908248141746044623801026
,0.8940172939165599297339782
,0.8971130415305650362967071
,0.9001152340463053347363598
,0.9030269244311229792643303
,0.9058510482400911056899417
,0.9085904296230220555941060
,0.9112477866469099740953652
,0.9138257359716094319068702
,0.9163267971213928664298010
,0.9187533968586912846987502
,0.9210729420192356187158111
,0.9233924871797800637551745
,0.9255766361240612694061269
,0.9277607850683424750570794
,0.9298486369480571944734493
,0.9319364888277719138898192
,0.9340243407074866333061891
,0.9361121925872013527225590
,0.9382000444669160721389289
,0.9402878963466307915552989
,0.9423757482263455109716688
,0.9444636001060602303880387
,0.9465514519857749498044086
,0.9486393038654896692207785
,0.9507271557452043886371484
,0.9528150076249191080535184
,0.9549028595046338274698883
,0.9569907113843485468862582
,0.9590785632640632663026281
,0.9611664151437779857189980
,0.9632542670234927051353679
,0.9653421189032074245517379
,0.9674299707829221439681078
,0.9695178226626368633844777
,0.9716056745423515828008476
,0.9736935264220663022172175
,0.9757813783017810216335874
,0.9778692301814957410499574
,0.9799570820612104604663273
,0.9820449339409251798826972
,0.9841327858206398992990671
,0.9862206377003546187154370
,0.9883084895800693381318069
,0.9903963414597840575481769
,0.9924841933394987769645468
,0.9945720452192134963809167
,11.9345419922213125119014876
,11.5934031520687028660177020
,11.2622482406484571981764020
,10.9408903676783832992214229
,10.6290901283239733743357647
,10.3265690736496829060797609
,10.0330235344627087812341415
,9.7481376469148024455080304
,9.4715947064706309532766682
,9.2030862734336373875976278
,8.9423187462826891902523130
,8.6890173887776338546018451
,8.4429280255034999669305762
,8.2038167938406427737163540
,7.9714684486954539011094312
,7.7453017732349049850881784
,7.5262764914219362211156295
,7.3142552738983726001720242
,7.1058969448411577474189471
,6.9045925645950001481310210
,6.7089979509054131767697982
,6.5189568803253958861887440
,6.3343159528308143890740212
,6.1549246077131929411052624
,5.9806353377793577408283454
,5.8113039734397267110921348
,5.6467899431667740728357785
,5.4869564561409092107169272
,5.3316705881855819271208929
,5.1808032780236201730872381
,5.0342292556191292618450461
,4.8918269289520219800238010
,4.7534782528524068823116977
,4.6190685731729033136616636
,4.4884866883338840892747612
,4.3616244772031924625821375
,4.2383761626132621103124620
,4.1186405113633481889223731
,4.0023180335965742315806892
,3.8893123711199533154569963
,3.7795299122016641213406274
,3.6728797152390892932771749
,3.5692734341312055690309535
,3.4686252454221437879766654
,3.3708517773263384498250161
,3.2758720407061692192485225
,3.1836073620548037688138265
,3.0939813180348383347961772
,3.0069196733179777147881850
,2.9223503175829828037990410
,2.8402032070771952021459583
,2.7604103063479747959263477
,2.6829055320170986931316293
,2.6076246981868744789778702
,2.5345054634305652641046436
,2.4634872793243900446213956
,2.3945113404804523327129573
,2.3275205360411783672702768
,2.2624594025969817501220405
,2.1992740784899762473969531
,2.1379122594678814373025943
,2.0783231556534662587409912
,2.0204574497962224377545226
,1.9642672567742167633042527
,1.9097060843153068621091961
,1.8567287949082449394211380
,1.8052915688753925493870156
,1.7553518685800875154257028
,1.7068684037429437960753376
,1.6598010978426798178730905
,1.6141110555783348967651136
,1.5697605313710683017092151
,1.5267128988850591220227670
,1.4849326215483913404824534
,1.4443852240562267130741247
,1.4050372648400439867799605
,1.3668563094882595354562227
,1.3298109051051547613297998
,1.2938705555967433546982193
,1.2597104755249330931832219
,1.2258953464079807016418044
,1.1930993166895103030356040
,1.1612954893218581098324194
,1.1304578141438599292456502
,1.1005610685955942162905785
,1.0715808393372439066837387
,1.0434935047769029470288160
,1.0162762185100171485885312
,0.9899068936666683971026259
,0.9643641881528348669405659
,0.9396274907624740935219165
,0.9156769081384096287123953
,0.8924932525845481467996478
,0.8700580307919193456811513
,0.8483534336386042706834587
,0.8273623273422905377572079
,0.8070682463435407960616885
,0.7874553883171130364004853
,0.7685086115835380038419089
,0.7502134348815144848643399
,0.7325560389760714663509589
,0.7155232689996585682123964
,0.6991026359155219083163502
,0.6833017121510627234215463
,0.6680707201634106251475487
,0.6534181353568282446531157
,0.6393340629789269202731816
,0.6258092857523859242618869
,0.6128352749704847335365798
,0.6004042037579128132662731
,0.5885089627158346381463616
,0.5771431776710622685300223
,0.5663012300447048952278806
,0.5559782796962278172969718
,0.5461702907146442909080974
,0.5368740603716153358959673
,0.5280872490292707333026101
,0.5198084148028602191615732
,0.5120370485122834880442610
,0.5047736108781446517923541
,0.4980195756127779316280169
,0.4924032378832586265282600
,0.4866785529891956008086140
,0.4814738943681931004903163
,0.4767951223345275324483339
,0.4726492896181469505201278
,0.4690446675935247000666095
,0.4659907576104337367794983
,0.4619621349645134378292255
,0.4603213120675417324711987
,0.4592231576619069666200801
,0.4586876015701286113390722
,0.4587349729871040282525030
,0.4593858509132273670871882
,0.4606608575872122024463806
,0.4625803808330364863543593
,0.4651641821376304997137652
,0.4684309156716338629067309
,0.4723975188679107040101712
,0.4770784628759501821981814
,0.4824848657937933493755622
,0.4886234685416265821622517
,0.4954954798694623518962032
,0.5030953208424097100603944
,0.5114093268623324251009876
,0.5204144725188100117918566
,0.5300772213448285974379814
,0.5403526278527256421213565
,0.5511838391370028622517907
,0.5625021367609437383805471
,0.5742276684414110432541634
,0.5862709608764865576446823
,0.5985352391768771207480881
,0.6109195158628499822128788
,0.6233222506364672899081825
,0.6356453370665364754898974
,0.6477980529225156880457348
,0.6597005863252836110888211
,0.6712867763349134042627497
,0.6825057972971662056949071
,0.6933226524517882571885252
,0.7037174929825710245623327
,0.7136839500770574273857960
,0.7232267638182369173804886
,0.7323590576764903437023690
,0.7410995985917163686451659
,0.7494703218470289973751619
,0.7574943066094574906088610
,0.7651942859664714324807733
,0.7725916825856178338227664
,0.7797060969620809300906217
,0.7865551303266934413116473
,0.7931544717740047767406963
,0.7995180933940257972381005
,0.8056583636386964730746740
,0.8115864677562545370648195
,0.8173125062243510319248685
,0.8228456965819721524724173
,0.8281945138208380852162804
,0.8333668007649531750402616
,0.8383698547389040189870002
,0.8432104962776449941230794
,0.8478951244490695593469809
,0.8524297621669247870812569
,0.8568200939089867240738840
,0.8610714975584430330712848
,0.8651890716066114039861645
,0.8691776586289431394405369
,0.8730418657220025968612731
,0.8767860824311757284021951
,0.8804144965845941417370568
,0.8839311083638555777142187
,0.8873397428775762207919797
,0.8906440614542220357563451
,0.8938475718330627373120478
,0.8969536374044722037979227
,0.8999654856295387084230697
,0.9028862157465605831063726
,0.9057188058389202822695552
,0.9084661192917384830991523
,0.9111309106196797680254917
,0.9137158306466888202379550
,0.9162234311092797289788336
,0.9186561689490805315827515
,0.9209813035027741845439664
,0.9233064380564678375051813
,0.9254955122021131241893954
,0.9276845863477584108736096
,0.9297769006597544905190489
,0.9318073952545941063263513
,0.9338378898494337221336536
,0.9358683844442733379409560
,0.9378988790391129537482584
,0.9399293736339525695555608
,0.9419598682287921853628632
,0.9439903628236318011701655
,0.9460208574184714169774679
,0.9480513520133110327847703
,0.9500818466081506485920727
,0.9521123412029902643993751
,0.9541428357978298802066774
,0.9561733303926694960139798
,0.9582038249875091118212822
,0.9602343195823487276285846
,0.9622648141771883434358870
,0.9642953087720279592431893
,0.9663258033668675750504917
,0.9683562979617071908577941
,0.9703867925565468066650965
,0.9724172871513864224723989
,0.9744477817462260382797012
,0.9764782763410656540870036
,0.9785087709359052698943060
,0.9805392655307448857016084
,0.9825697601255845015089108
,0.9846002547204241173162131
,0.9866307493152637331235155
,0.9886612439101033489308179
,0.9906917385049429647381203
,0.9927222330997825805454227
,0.9947527276946221963527250
,12.0828587815685448703106886
,11.7373963095785498467193975
,11.4020209541791714968894667
,11.0765594986341042726962769
,10.7607816762933161669479887
,10.4544138041889329571176859
,10.1571530776239402626970332
,9.8686812777616026437499386
,9.5886769231914641409275646
,9.3168252002990410431948476
,9.0528253130082632083031058
,8.7963951790396155416829060
,8.5472736481489519633214513
,8.3052206117511939709174840
,8.0700155013805563442019775
,7.8410325605027901829657822
,7.6193486227555764500607438
,7.4048237793966098507780771
,7.1937928936255923773046561
,6.9900073052491915603923189
,6.7920006211714696320314033
,6.5996151577623853867748949
,6.4126960427077142057328274
,6.2310911854245887298020534
,6.0546514804174043078432987
,5.8832311041632898707121058
,5.7166878007475370182532970
,5.5548830926122025886115807
,5.3976823910138227446964265
,5.2449550098839763379032775
,5.0965741042001440064268536
,4.9524165603606782326551183
,4.8123628641914635295506741
,4.6762969520713921767196553
,4.5441060864081430636929326
,4.4156812462432251109589743
,4.2909149340840020414589162
,4.1697048147846595966825589
,4.0519501705414606718136383
,3.9375534573864539034104837
,3.8264199115783439353322137
,3.7184574724579193549800493
,3.6135767069987685395915378
,3.5116907361097307038733106
,3.4127151628105525382750329
,3.3165680023665675690835997
,3.2231696144531944980826665
,3.1324426368328492920056760
,3.0443119226022012924204319
,2.9587044761656873248512056
,2.8755493942629093417906461
,2.7947778069351847385348719
,2.7163228206123908314850723
,2.6401194628529869312671963
,2.5661046286884365841274303
,2.4942170285285558684051921
,2.4243971375867103823509296
,2.3565871467850336706817416
,2.2907309151009926928566074
,2.2267739233177405999697385
,2.1646632291419711791036207
,2.1043474236542740740674162
,2.0457765890583048395967580
,1.9889022576963717447995350
,1.9336773723003133351738825
,1.8800562474478896834995112
,1.8279945321961141857514122
,1.7774491738643276583786701
,1.7283783829410408472426752
,1.6807415990899288171789294
,1.6344994582316541009703315
,1.5896137606795186503205741
,1.5460474403083321881524625
,1.5037645347372461390733633
,1.4627301565087265089459834
,1.4229104652473960612724113
,1.3842726407839383018227863
,1.3467848572309979449102002
,1.3104162579996625481726369
,1.2758369932831510329407365
,1.2416208128841863533864398
,1.2084368516841681451268187
,1.1762578996689960764143734
,1.1450576050651741777386405
,1.1148104548696142757080452
,1.0854917562994561563982643
,1.0570776191680562039465485
,1.0295449391914357484267839
,1.0028713822225061580439842
,0.9770353693986459919784693
,0.9520160631755277824694872
,0.9277933542164232827431647
,0.9043478491260382723382349
,0.8816608590759831276528757
,0.8597143894713022982401185
,0.8384911309407184765163379
,0.8179744520576324173788407
,0.7981483942499634220979488
,0.7789976692608835406872458
,0.7605076592238366739451294
,0.7426644189121628381045070
,0.7254546790877528517071937
,0.7088658492672457178684908
,0.6928860178523550406026743
,0.6775232489477707176206422
,0.6627283143115602070949421
,0.6485103691158574656938640
,0.6348601485628251328563465
,0.6217690879907405987481184
,0.6092293362861526118123834
,0.5972337716697736498261406
,0.5857760195222417864968634
,0.5748504727910782596822514
,0.5644523147912269278592134
,0.5545775448811746111132948
,0.5452230072323672738221489
,0.5363864202532652170063443
,0.5280664107893263681248186
,0.5202625482078133689611832
,0.5129753804625460933408476
,0.5062064759869767671673912
,0.5005785076366213726117849
,0.4948568030612879864449383
,0.4896642679239445183903001
,0.4850068537906765397949016
,0.4808916927098297322551446
,0.4773271164888271411719245
,0.4743226592779374306552143
,0.4701903486097421813738606
,0.4686434440336280649042067
,0.4676451231273331954341188
,0.4672154143368530965219065
,0.4673746299604561449392293
,0.4681431911095532139022168
,0.4695413928768883971009984
,0.4715890957709568676037293
,0.4743053005605133431998865
,0.4777076331308817147558443
,0.4818117012978222479802071
,0.4866303145177611200189460
,0.4921725725671532436500399
,0.4984428272682553950900797
,0.5054395288207855774231803
,0.5131539938143591106367580
,0.5215691580859380671597592
,0.5306583865989883408431638
,0.5403844462647743318584048
,0.5506987702382666327594052
,0.5615411579115537898942989
,0.5728400407014536677152705
,0.5845134474354346520996728
,0.5964707362851973115880355
,0.6086150904120245508366338
,0.6208467111547830707962703
,0.6330664849882097211519749
,0.6451798663351505647156614
,0.6571006141216715334962828
,0.6687540133499616512580133
,0.6800792555569364905565521
,0.6910307528587561476385304
,0.7015782981126595929666223
,0.7117061274048951391435480
,0.7214110966147394554681682
,0.7307002623995449974714234
,0.7395882048520399099089673
,0.7480944073786541803627870
,0.7562409423299777389004817
,0.7640506181511143024565058
,0.7715456475449548046086079
,0.7787468122923596469675545
,0.7856730451357540889745223
,0.7923413146582987121036012
,0.7987667586465466706968641
,0.8049627755384664018478702
,0.8109413828521045974895287
,0.8167133729180250378831829
,0.8222885306954575979077049
,0.8276757990992277269626243
,0.8328834108855830420381494
,0.8379189923707572873468052
,0.8427896450644998260770535
,0.8475020106183764889706822
,0.8520623233231435778023410
,0.8564764532665054552751371
,0.8607499423746106659294242
,0.8648880349232291875338774
,0.8688957036665743149939090
,0.8727776724333330404803633
,0.8765384358334157299807998
,0.8801822765730271669326612
,0.8837132807695935454717073
,0.8871353515789234256416762
,0.8904522213866108426572055
,0.8936674627693068639899820
,0.8967844983962388605291949
,0.8998066100151275170659915
,0.9027369466455246183045347
,0.9055785320795217696598911
,0.9083342717569788948850373
,0.9110069590396245864383218
,0.9135992808737485315617732
,0.9161138228433056696076164
,0.9185530737128300149407778
,0.9208841364556108466388196
,0.9232151991983917893591638
,0.9254095013856082907466316
,0.9276038035728246811117970
,0.9297008651258112932325162
,0.9317358043734133010715937
,0.9337105693734419897822363
,0.9356853343734706784928790
,0.9376600993734993672035216
,0.9396348643735280559141643
,0.9416096293735567446248069
,0.9435843943735854333354496
,0.9455591593736141220460922
,0.9475339243736428107567349
,0.9495086893736714994673775
,0.9514834543737001881780202
,0.9534582193737288768886629
,0.9554329843737575655993055
,0.9574077493737862543099482
,0.9593825143738149430205908
,0.9613572793738436317312335
,0.9633320443738723204418761
,0.9653068093739010091525188
,0.9672815743739296978631614
,0.9692563393739583865738041
,0.9712311043739870752844467
,0.9732058693740157639950894
,0.9751806343740444527057321
,0.9771553993740731414163747
,0.9791301643741018301270174
,0.9811049293741305188376600
,0.9830796943741592075483027
,0.9850544593741878962589453
,0.9870292243742165849695880
,0.9890039893742452736802306
,0.9909787543742739623908733
,0.9929535193743026511015159
,0.9949282843743313398121586
,12.2297749759453449058810293
,11.8800343776536863060755422
,11.5404789290278753099983078
,11.2109501185474726980828564
,10.8912278396581037043233664
,10.5810441112380004824444768
,10.2800977886598374766435882
,9.9880689214362607941666283
,9.7046316914265844388864934
,9.4294651752896729846042945
,9.1622614922065661602346154
,8.9027312006404866195907744
,8.6506060755758156233241607
,8.4056396124495016408673109
,8.1676057523983356389862820
,7.9358317592377201066256021
,7.7115182940767388330982612
,7.4945221529572751961723043
,7.2808377986787471414231732
,7.0745955047598636511452241
,6.8742004565120788939225349
,6.6794935416921843440718476
,6.4903184571031937721841132
,6.3065216259824650180121353
,6.1279523852623416502183318
,5.9544632924032745435738434
,5.7859104354051114071921802
,5.6221536722952656361940171
,5.4630567675131702642943310
,5.3084874249696980541557423
,5.1583172378351420661601878
,5.0124215834997416507690104
,4.8706794913056166151932302
,4.7329735043118876802736850
,4.5991894820486187711594539
,4.4692170575729530668240841
,4.3429479853232741959345731
,4.2202774595821290759545263
,4.1011046428150876863583107
,3.9853304772054718441154364
,3.8728590583067528108074384
,3.7635972173666703000094458
,3.6574544450746460100276636
,3.5543428170393549514471943
,3.4541769211275452633458372
,3.3568737867658318130281714
,3.2623528162960480081267178
,3.1705357177905955090579937
,3.0813464417371880799123574
,2.9947111159629247190139267
,2.9105579861568595667620230
,2.8288173560728591127144682
,2.7494215299354256565322885
,2.6723047565201860642503107
,2.5974031748587398382710489
,2.5246547615235868100569405
,2.4539992794516285457007143
,2.3853782282660302982435496
,2.3187347960573769789505150
,2.2540138125861526319226869
,2.1911617038699104931254169
,2.1301264481197130784551064
,2.0708575329918326168865406
,2.0133059141219362686570094
,1.9574239749103627961090979
,1.9031654875283585681700060
,1.8504855751164615007553493
,1.7993406751475533589257338
,1.7496885039283902596451981
,1.7014880222147543697985839
,1.6546994019167304834638799
,1.6092839938719241121845016
,1.5652042966658714640004746
,1.5224239264802372773033312
,1.4809075879508970530196166
,1.4406210460194972533543023
,1.4015310987636591111282769
,1.3636055511926776784292770
,1.3268131899972972487233847
,1.2911237592439570587288244
,1.2572061789745769821990962
,1.2236384136798346133900850
,1.1910883510149044006709573
,1.1595293408321560857388022
,1.1289355828209728382915955
,1.0992821077892633852002291
,1.0705447598881008275384374
,1.0427001797855384168656201
,1.0157257887885020597451557
,0.9895997738983021152492370
,0.9643010737692898626249871
,0.9398093655312987904082433
,0.9161050524506695325044348
,0.8931692524594126991743792
,0.8709837876874730877574393
,0.8495311752796282922517435
,0.8287946199281668313574301
,0.8087580086375277810262219
,0.7894059081751066964116603
,0.7707235653836325139920405
,0.7526969100177522964401078
,0.7353125590794143962014573
,0.7185578209242122760258553
,0.7024206969075766915366899
,0.6868898783078593028861292
,0.6719737282202653538831782
,0.6576239326078875402359358
,0.6438502244963566489843743
,0.6306440028361048888427831
,0.6179973914816053737197876
,0.6059032550707439401804777
,0.5943552168697544546560607
,0.5833476791521433613141312
,0.5728758458769691586098816
,0.5629357481579848609953842
,0.5535242727449547484042114
,0.5446391908346094323789544
,0.5362791916720875962099058
,0.5284439156077155308466331
,0.5203169394045489282163430
,0.5135300206228612385217502
,0.5087122210174340741772880
,0.5029940634115293018879811
,0.4978140532965280029564781
,0.4931782141447860201566300
,0.4890937349709735260105958
,0.4855689822881346651151091
,0.4826134935613031196055545
,0.4783658736241263587096739
,0.4769131203019884024385533
,0.4760143834362043913088769
,0.4756897410900555178692173
,0.4759594360040759197794102
,0.4768436751305895060504270
,0.4783623668633100178837481
,0.4805347822833163640154908
,0.4833790980872358922226795
,0.4869118492847368528941843
,0.4911472551604557090776382
,0.4960964122305636103682502
,0.5017663635506822705778518
,0.5081590527195468665055955
,0.5152701791396135932998845
,0.5230879980432641129795002
,0.5315921329831287955869357
,0.5407524789580784307929662
,0.5505283046879683173102649
,0.5608676821659193123537079
,0.5717073829280724384105383
,0.5829733590027870171468294
,0.5945819255607028841481565
,0.6064416878453143811000814
,0.6184561826615080359914600
,0.6305271420466472820365311
,0.6425581348184195018546916
,0.6544583190665129723839755
,0.6661459494633867883806033
,0.6775512930935283506528322
,0.6886186637708766600241006
,0.6993073929303705860149876
,0.7095916921677926092471012
,0.7194594976819658205258179
,0.7289105265383515330768205
,0.7379538368269914494490536
,0.7466052148010845490588849
,0.7548846798171926497644790
,0.7628143266388491827711960
,0.7704166336906491663327756
,0.7777132757096589799061803
,0.7847244038447475089625982
,0.7914683091165479744688582
,0.7979613603119031228771973
,0.8042181499436646952005958
,0.8102516128710843812399389
,0.8160733623892045818237762
,0.8216938458063687278354337
,0.8271225501637661237097632
,0.8323681581402893048249325
,0.8374386721419769807894795
,0.8423415119531769690297551
,0.8470835917912555856901236
,0.8516713818283943027154237
,0.8561109581060408757480218
,0.8604080437134895564810222
,0.8645680432826507999521937
,0.8685960722670459377425800
,0.8724969820722409119539975
,0.8762753818311742604052483
,0.8799356574279145748462838
,0.8834819882382508593465786
,0.8869183619567864163002469
,0.8902485878062438295899028
,0.8934763083681289685955562
,0.8966050102303978475148938
,0.8996380336146472256331208
,0.9025785811202730046787224
,0.9054297257020728073584337
,0.9081944179743007827809720
,0.9108754929022678803463009
,0.9134756759044592167029464
,0.9159975883631141790885977
,0.9184437525643478483772242
,0.9207811046009739541773342
,0.9231184566376001709997468
,0.9253183054259624951143337
,0.9275181542143248192289207
,0.9296202588305509939559101
,0.9316599266292852066229102
,0.9336391197936902974774398
,0.9355597365961034750370118
,0.9374803533985166525965838
,0.9394009702009298301561557
,0.9413215870033430077157277
,0.9432422038057561852752997
,0.9451628206081693628348717
,0.9470834374105825403944436
,0.9490040542129957179540156
,0.9509246710154088955135876
,0.9528452878178220730731596
,0.9547659046202352506327315
,0.9566865214226484281923035
,0.9586071382250616057518755
,0.9605277550274747833114475
,0.9624483718298879608710195
,0.9643689886323011384305914
,0.9662896054347143159901634
,0.9682102222371274935497354
,0.9701308390395406711093074
,0.9720514558419538486688793
,0.9739720726443670262284513
,0.9758926894467802037880233
,0.9778133062491933813475953
,0.9797339230516065589071673
,0.9816545398540197364667392
,0.9835751566564329140263112
,0.9854957734588460915858832
,0.9874163902612592691454552
,0.9893370070636724467050271
,0.9912576238660856242645991
,0.9931782406684988018241711
,0.9950988574709119793837431
,12.3752317084619054554650575
,12.0212609302323834015169268
,11.6775680535529975401232150
,11.3440102609867032867896341
,11.0203786064700892666223808
,10.7064117436239882863446837
,10.4018109952505231063923929
,10.1062553247972584102853943
,9.8194150458521836100089786
,9.5409634198362489598821412
,9.2705856198384406496870724
,9.0079848566563782696903218
,8.7528857497579082291849772
,8.5050352615742887962824170
,8.2642016828576885245638550
,8.0296629020859633385498455
,7.8027499972299931840780118
,7.5833156972386515093376147
,7.3669981147243994712425774
,7.1583245699989586086076088
,6.9555657913333250874643454
,6.7585612671590835631718619
,6.5671533038324474418345744
,6.3811868822305370940739522
,6.2005098233320472544960467
,6.0249731017964602841630040
,5.8544311792523870963123045
,5.6887422729572012514154267
,5.5277685194068046925508497
,5.3713760281652564998466914
,5.2194348444889939742097340
,5.0718188499132628166421455
,4.9284056303189567316280773
,4.7890763349572171847512436
,4.6537154757480037048367194
,4.5222113715800169586600532
,4.3944545537652128786021422
,4.2703388960851835776111329
,4.1497624411056222015758976
,4.0326249458662299929301298
,3.9188293769569435553989933
,3.8082814689197217461469336
,3.7008896472113397280168101
,3.5965649528728884654071862
,3.4952209690452913370961596
,3.3967737494486920368785832
,3.3011417489383974022132406
,3.2082457554587295867065677
,3.1180088261966831808535972
,3.0303562214301709154540276
,2.9452153445762729866430618
,2.8625156816317347541200888
,2.7821887429045002448901869
,2.7041680064414732598265800
,2.6283888631004281855041427
,2.5547885632209914597012812
,2.4833061648527134934738569
,2.4138824834996337465042870
,2.3464600433419025016235082
,2.2809830298961144556812997
,2.2173972440773077607900632
,2.1556500576268646796052053
,2.0956903698719298034802705
,2.0374685657832496410435397
,1.9809364752997051795091465
,1.9260473338891264116767843
,1.8727557443162936579028610
,1.8210176395903834301037705
,1.7707902470654419690987424
,1.7220320536688082935228294
,1.6747027722338008182134672
,1.6287633089143265241460767
,1.5841757316604736516296725
,1.5409032397356041688141204
,1.4989101342568857955228623
,1.4581617897427971985990780
,1.4186246266526656434336928
,1.3802660849050576441499061
,1.3430545983635595597149859
,1.3069595702803360470767302
,1.2719513496898242621568897
,1.2386976633435444750119814
,1.2057806306472327317891313
,1.1738669300312647436612679
,1.1429304770977486427341319
,1.1129460293580020202597325
,1.0838891683061104842522582
,1.0557362824602278816854550
,1.0284645513724515186737563
,1.0020519305934370013488888
,0.9764771375585433732524621
,0.9517196383479207266731237
,0.9277596352805965729260151
,0.9045780553526154843524409
,0.8821565396360090405281085
,0.8604774339138175909269535
,0.8395237810008536749606378
,0.8192793153208097756134975
,0.7997284602868530711816675
,0.7808563287809561215269127
,0.7626487265128737425001759
,0.7450921573065332204066635
,0.7281738285657913811732556
,0.7118816545332831147163688
,0.6962042547754762056300137
,0.6811497100060084353145839
,0.6666700949782125018572287
,0.6527748583625876399594290
,0.6394553621603610293888664
,0.6267037042562866311357084
,0.6145127343436296296630417
,0.6028760717305118310704870
,0.5917881256243270327033201
,0.5812441176090948902199784
,0.5712401068159410622016026
,0.5617730180122817440491190
,0.5528406696708513257121353
,0.5444418068372393060272429
,0.5357707873894416161775212
,0.5284370345500400967253540
,0.5216378676947474035685559
,0.5167991139811988210439608
,0.5110849698901277493590101
,0.5059177773184975190901014
,0.5013036121301763792246220
,0.4972496978663205058346364
,0.4937644100454014473022823
,0.4908572601465298612666288
,0.4864824490157088621167247
,0.4851239026864360148749711
,0.4843243227166172393260979
,0.4841037883409146092006381
,0.4844824212454486023204936
,0.4854801598835848941426718
,0.4871164692735743262375081
,0.4894099729764617157101725
,0.4923779656282076255813251
,0.4960358356826072845358055
,0.5003963636062583875130372
,0.5054688921861106853938850
,0.5112583816619524768043448
,0.5177643622954757329779341
,0.5249798058096387665116822
,0.5328899652730588742954865
,0.5414712550366559407066802
,0.5506902539618712122404531
,0.5605029418116738160193790
,0.5708542950628379131217116
,0.5816783752701542020702163
,0.5928990145971234637656266
,0.6044311980672754103238731
,0.6161831611899041272195632
,0.6280591481080356475175108
,0.6399627147770138302362852
,0.6518003166411405757685316
,0.6634849094212003084436446
,0.6749392169262988794287139
,0.6860983444065947844947573
,0.6969114835316093659045578
,0.7073425679457380210735096
,0.7173698724668331472287264
,0.7269846746544972315717814
,0.7361892215817059659244137
,0.7449942917041886270013151
,0.7534166588895190308505789
,0.7614767249332994314414691
,0.7691965130428684016550278
,0.7765981265078415463065653
,0.7837026929306774025718596
,0.7905297469692629253046334
,0.7970969647049074291444981
,0.8034201467770197835349677
,0.8095133709658780540863177
,0.8153891372071182530589795
,0.8210586782951782014450259
,0.8265321162841634539120150
,0.8318186564783688341506718
,0.8369267345988360418118646
,0.8418641337248419231897856
,0.8466380764111499646062953
,0.8512552975704222868458260
,0.8557221028665472628560451
,0.8600444162620788368656122
,0.8642278193751183890114476
,0.8682775845442430862064498
,0.8721987029639313160345182
,0.8759959088852027342397832
,0.8796737006242927314758617
,0.8832363589466667441740810
,0.8866879632681679002104147
,0.8900324060229803935229143
,0.8932734054788286082171567
,0.8964145172267208305783015
,0.8994591445316842959201153
,0.9024105476996602259731617
,0.9052718525917048397744225
,0.9080460583957924436404596
,0.9107360447430159489101698
,0.9133445782243647670384235
,0.9158743183309995261609515
,0.9183278228245623786563101
,0.9207075525757187905995238
,0.9230158760087340263922329
,0.9252216088138736083124058
,0.9274273416190130792102764
,0.9295347989183653236722193
,0.9315794907512942035765491
,0.9335633947808795740641585
,0.9354884244478058885619021
,0.9373564295161200821127068
,0.9392244345844342756635115
,0.9410924396527484692143162
,0.9429604447210626627651209
,0.9448284497893768563159256
,0.9466964548576910498667303
,0.9485644599260052434175350
,0.9504324649943194369683397
,0.9523004700626336305191444
,0.9541684751309478240699491
,0.9560364801992620176207538
,0.9579044852675762111715585
,0.9597724903358904047223632
,0.9616404954042045982731679
,0.9635085004725187918239726
,0.9653765055408329853747773
,0.9672445106091471789255820
,0.9691125156774613724763867
,0.9709805207457755660271914
,0.9728485258140897595779961
,0.9747165308824039531288008
,0.9765845359507181466796055
,0.9784525410190323402304102
,0.9803205460873465337812149
,0.9821885511556607273320196
,0.9840565562239749208828243
,0.9859245612922891144336290
,0.9877925663606033079844337
,0.9896605714289175015352384
,0.9915285764972316950860431
,0.9933965815655458886368478
,0.9952645866338600821876526
,12.5191733071101936047853087
,12.1610225998514351886115037
,11.8132371652198475686645907
,11.4756908211682819853649562
,11.1481867557010883018620007
,10.8304711818091821129428354
,10.5222487040523482448861614
,10.2231978636271438887206386
,9.9329855995970142146234139
,9.6512796809617533710934367
,9.3777585012414856890927695
,9.1121179598590469339569609
,8.8540754597541830861473500
,8.6033713072545712208238911
,8.3597679909002842180143489
,8.1224916864687219941743024
,7.8930103118206087486896649
,7.6711717070863016942894319
,7.4522422620938071347040932
,7.2411638158981919133339034
,7.0360668129101711087969306
,6.8367893690698595676735749
,6.6431724395211277922612680
,6.4550596064926413220064205
,6.2722972173165807419081830
,6.0947347012169945656978598
,5.9222249244793445654977404
,5.7546244884989778967110396
,5.5917939217951211361423702
,5.4335977561454082973568802
,5.2799045034859943825722439
,5.1305865632135372322863986
,4.9855200912507697807996010
,4.8445848566195008899626373
,4.7076640386540180571728342
,4.5746446463855345854199186
,4.4454160206734014693097379
,4.3198707134332163803946969
,4.1979056628416691054894727
,4.0794194542456700958155125
,3.9643139374249134476713152
,3.8524937620015422545804995
,3.7438662996371903091130662
,3.6383415679118971119976322
,3.5358321560304188935219827
,3.4362531524903308088880749
,3.3395220748487246531510664
,3.2455588008145070944010513
,3.1542855039038841802323532
,3.0656265861851013099226293
,2.9795086178839587098821085
,2.8958602760634342132561869
,2.8146122856878741380626252
,2.7356973624050233695470524
,2.6590501569918636448619509
,2.5846072014183443243950933
,2.5123068564864752261200920
,2.4420892610038698045116234
,2.3738962824519118655075545
,2.3076714691098176857053659
,2.2433600035971834607551045
,2.1809086577988723298915374
,2.1202657491375145326628626
,2.0613810981601887739600443
,2.0042059874072424285884608
,1.9486931215325400401638944
,1.8947965886457800444020450
,1.8424718228488741189607936
,1.7916755679397391443075094
,1.7423658422582197768946344
,1.6945019046502465265291448
,1.6480442215277257833605518
,1.6029544350030862087663763
,1.5591953320788312087330496
,1.5167308148739693240969473
,1.4755258718707100484834882
,1.4355465501664588234831399
,1.3967599287178154021660248
,1.3591340925651049786893054
,1.3226381080278104551695151
,1.2872419988632466392175502
,1.2536085965130741026740679
,1.2203288524626347832935380
,1.1880645995746741405696412
,1.1567894726628504820098442
,1.1264779591276368186925083
,1.0971053808789372752130475
,1.0686478772447161045278108
,1.0410823888688136573676957
,1.0143866425853549362301464
,0.9885391372345594396264801
,0.9635191303646953864259217
,0.9393066257652340489414655
,0.9158823618201150651429998
,0.8932278007761685900689486
,0.8713251191902552372781088
,0.8501572000173325260874435
,0.8297076269597084552387400
,0.8099606817169562322789034
,0.7909013445578203516106441
,0.7725152981281231401311516
,0.7547889336383440950228874
,0.7377093576899432791904587
,0.7212643972244374701574543
,0.7054425997400474157572603
,0.6902332262811166074811808
,0.6756443931766429322749445
,0.6616295879100746457623927
,0.6481986993409789565845358
,0.6353437983154532897600575
,0.6230577180755489941077485
,0.6113340719692144098473818
,0.6001672735739546071798145
,0.5895525588951462392373060
,0.5794860111469620767010724
,0.5699645883464441453725158
,0.5609861505131279457714299
,0.5517534873376017667823135
,0.5438577363638041894944308
,0.5365038689628699453137983
,0.5296932056844755321023399
,0.5248341190362389996337811
,0.5191243594370570368923268
,0.5139701733790299487125708
,0.5093776695466117887534097
,0.5053540836085520515652547
,0.5019077745616105090675774
,0.4990481989477815183420262
,0.4945341118453871476212669
,0.4932696595028537300819949
,0.4925686424478723512976330
,0.4924510934886707214097612
,0.4929369632116101240804085
,0.4940458694393184968518540
,0.4957967802713945659753847
,0.4982076178932282606304227
,0.5012947424106771743268496
,0.5050723470075070276052998
,0.5095517315865655261220013
,0.5147404545920095664257587
,0.5206413791119391953898798
,0.5272516300896308294454684
,0.5345614887628183931056469
,0.5425532795454224288533851
,0.5512003242033486349882310
,0.5604660506875794867553964
,0.5703033666608934293407174
,0.5806544207559783954408772
,0.5914508770663559067415349
,0.6026147932210740298941687
,0.6140601838020547376117975
,0.6256952646305156129358238
,0.6374252999538526642808733
,0.6491559170786711518985612
,0.6607966157688832664618417
,0.6722642006157513172581730
,0.6834858036337350117861433
,0.6944012019924420409111576
,0.7049642124198298720472167
,0.7151430592204612857187840
,0.7249197424844844306335290
,0.7342885485819615754010670
,0.7432539541629838986125378
,0.7518282082580369785063112
,0.7600288823081772227041597
,0.7678766305836173255983113
,0.7753933283726390790491223
,0.7826006704502687094660018
,0.7895192347884556482995322
,0.7961679564998822566934678
,0.8025639256928643883171048
,0.8087223991700500658197370
,0.8146569746728529182178136
,0.8203797416853425561455992
,0.8259015743462438940980519
,0.8312322876341737831751288
,0.8363808200260086644917124
,0.8413553725683448059058378
,0.8461635192624631374158639
,0.8508122941271559769305100
,0.8553082602718180549317140
,0.8596575654270400823619980
,0.8638659873179616033311845
,0.8679389713407684725510194
,0.8718816623031795387532839
,0.8756989314966237003545757
,0.8793954000295264306075183
,0.8829754591187355394765746
,0.8864432878734558318711834
,0.8898028689891901432673649
,0.8930580026830634565726541
,0.8962123191368832619829732
,0.8992692896643504907316924
,0.9022322367803569109767636
,0.9051043433206633626042503
,0.9078886607371789985165833
,0.9105881166733769127574760
,0.9132055219010853930328153
,0.9157435766709884905623085
,0.9182048765006740609351255
,0.9205919174153428530260612
,0.9229071006941724775174407
,0.9251190763794079341408860
,0.9273310520646432797420289
,0.9294441885482649379213171
,0.9314942137687295398151832
,0.9334831235879874622440866
,0.9354128473993739145697646
,0.9372852511137829134568733
,0.9391021372871116712488515
,0.9409190234604404290408297
,0.9427359096337691868328079
,0.9445527958070979446247861
,0.9463696819804267024167643
,0.9481865681537554602087425
,0.9500034543270842180007207
,0.9518203405004129757926989
,0.9536372266737417335846771
,0.9554541128470704913766554
,0.9572709990203992491686336
,0.9590878851937280069606118
,0.9609047713670567647525900
,0.9627216575403855225445682
,0.9645385437137142803365464
,0.9663554298870430381285246
,0.9681723160603717959205028
,0.9699892022337005537124810
,0.9718060884070293115044592
,0.9736229745803580692964374
,0.9754398607536868270884156
,0.9772567469270155848803938
,0.9790736331003443426723720
,0.9808905192736731004643502
,0.9827074054470018582563284
,0.9845242916203306160483066
,0.9863411777936593738402848
,0.9881580639669881316322630
,0.9899749501403168894242413
,0.9917918363136456472162195
,0.9936087224869744050081977
,0.9954256086603031628001759
,12.6615473308818362596639417
,12.2992691079435587653279072
,11.9474380746946593490065425
,11.6059455740913808341474578
,11.2746078701223932938546568
,10.9531796465089890091348934
,10.6413696061745284282551438
,10.3388565460750232460895859
,10.0453045466366290838777786
,9.7603762334198282957231640
,9.4837434135765921183747196
,9.2150947358048078683623316
,8.9541403455699821734015131
,8.7006137847131785889587263
,8.4542715969090167504873534
,8.2148912343277409320307925
,7.9818314114609645315567832
,7.7562110196171865084124875
,7.5378369373300637690249459
,7.3230844710265117214476049
,7.1156755667374813612013895
,6.9141506873144669143016472
,6.7183494745147971372034590
,6.5281141553007460132107553
,6.3432896461559353795678362
,6.1637238692304805454114103
,5.9892681277028714248444885
,5.8197774332130904895166168
,5.6551107273277771980701800
,5.4951309814645696860679891
,5.3397051895178329061764089
,5.1887042830085539080187118
,5.0420030018638071211967144
,4.8994797488711094857194439
,4.7610163864154726454103184
,4.6264986170801956077980321
,4.4958146266255960554758531
,4.3688556430664160501464721
,4.2455175156206221842580817
,4.1256976721772913307972885
,4.0092968582447481296071601
,3.8962186506848901501598448
,3.7863693791634038809945650
,3.6796580492561079545055236
,3.5759962673607765815120274
,3.4752981675656640092597627
,3.3774803406374833691927506
,3.2824617642521278781941874
,3.1901637381860852293868902
,3.1005098159290231940588001
,3.0134257438789817662438963
,2.9288393992628218853724320
,2.8466807305402159755658431
,2.7668816995471181563459595
,2.6893762253226269898220835
,2.6141001295723191866215984
,2.5409910837250464510361780
,2.4699885575419044947409475
,2.4010337692371837015059555
,2.3340696370722322505741886
,2.2690407323844148379521357
,2.2058932340146859552021397
,2.1445748840986746941439378
,2.0850349451875458406391317
,2.0272241586662644863281457
,1.9710947044382753912117323
,1.9166001618469594713900506
,1.8636954718055889212990905
,1.8123369001089406626903155
,1.7624820019010274396720206
,1.7140895872748940220731129
,1.6671196879817788971678283
,1.6215335252284301947867107
,1.5772934785427994430762055
,1.5343630556898359973416746
,1.4927068636207263541137991
,1.4522905804404626639581011
,1.4130809283804388609695479
,1.3750456477645085495709054
,1.3381534719588634718689946
,1.3023741032980462595247673
,1.2676781899815525722630127
,1.2347274601522373327355808
,1.2021168979392102826864175
,1.1705072180897388989251340
,1.1398726411466926222715301
,1.1101882325708514187567744
,1.0814298855164905521775154
,1.0535743046167416192560040
,1.0265989907680019843638775
,1.0004822268770841020568696
,0.9752030645088499705153140
,0.9507413113644548330327666
,0.9270775195565869042368945
,0.9041929747517063464812281
,0.8820696864258614766640676
,0.8606903797022994462295742
,0.8400384894351280440361052
,0.8200981572687985332592575
,0.8008542322254507128675982
,0.7822922748806235837548684
,0.7643985643891199055488528
,0.7471601066552470138404374
,0.7305646410296575687937093
,0.7146006424090961539619116
,0.6992573158163976065893053
,0.6845245815425790025798847
,0.6704101497232897166611565
,0.6568697445706298543299795
,0.6439133924534157227270725
,0.6315339085261413298866273
,0.6197248980337011214913900
,0.6084807762086373861265542
,0.5977967901132823502763358
,0.5876690429415573069249490
,0.5780945210166570369381134
,0.5682828578055573176541770
,0.5598094404291298342712935
,0.5518859052117666141867858
,0.5445127061983401350886425
,0.5376912118513665905794596
,0.5328123748308827289932310
,0.5271072800046620043801227
,0.5219661916830068415507071
,0.5173952318520379511923579
,0.5134016260723188729286903
,0.5099936916020825217188417
,0.5071808015976653205569846
,0.5025152090999164267159927
,0.5013445778735048374841199
,0.5007413740439660143621836
,0.5007255375066819169660448
,0.5013167994100784508049173
,0.5025344072610108403509344
,0.5043967820381820565955877
,0.5069210950903555445989923
,0.5101227251245659122247389
,0.5140146282781634656799952
,0.5186065905047028135044229
,0.5239043650818610009523013
,0.5299087147202657943623194
,0.5366143792203494911063899
,0.5440089992451546674345764
,0.5520720565895342879514374
,0.5607739083540048685705415
,0.5700750055690799733554286
,0.5799254053400161312836758
,0.5902646951110361861481124
,0.6010224458134797442809827
,0.6121192693524895034329347
,0.6234685443874203869540906
,0.6349787838937375195058621
,0.6465565456075896832999206
,0.6581097330669706257921803
,0.6695510062072538293165280
,0.6808010328316619341748606
,0.6917912641542137697214798
,0.7024659665916748174652184
,0.7127833255966939951520089
,0.7227155533860322167427626
,0.7322480563360866945288308
,0.7413778228991472207809466
,0.7501112877985944837888610
,0.7584619493595257111451247
,0.7664480118935053098994103
,0.7740902726354389473684137
,0.7814103975237385313334926
,0.7884296491013481622545100
,0.7951680584540357088485507
,0.8016439800397342496651731
,0.8078739445020973741762305
,0.8138727035405395326961298
,0.8196533735524289543405985
,0.8252276857665673537312045
,0.8306061666341223448384312
,0.8357983408055381646661885
,0.8408128936983589873932488
,0.8456578030747178287285237
,0.8503404434082869611799538
,0.8548676683237950157945306
,0.8592458761853803972385890
,0.8634810630019165156312511
,0.8675788657991176933137467
,0.8715445987427767882138596
,0.8753832836501229675008062
,0.8790996760717051383693388
,0.8826982878142982658076221
,0.8861834065603272359012976
,0.8895591130881654873263642
,0.8928292964885897742277621
,0.8959976676919384486197373
,0.8990677715593965446672087
,0.9020429977447650404798196
,0.9049265904967258578039946
,0.9077216575435264056537221
,0.9104311781796786684495260
,0.9130580106538992435361024
,0.9156048989346099453712213
,0.9180744789023753682499773
,0.9204692839947652416299206
,0.9227917503269842391944167
,0.9545903363904946203888358
,0.9272289522286172314124997
,0.9293481141190964578413514
,0.9314037987546954777684505
,0.9333980233251623070955816
,0.9353327354586152830862034
,0.9372098175135717967876303
,0.9390310890892736850332767
,0.9407983068449859986870365
,0.9425655246006983123407963
,0.9443327423564106259945561
,0.9460999601121229396483159
,0.9478671778678352533020757
,0.9496343956235475669558355
,0.9514016133792598806095953
,0.9531688311349721942633550
,0.9549360488906845079171148
,0.9567032666463968215708746
,0.9584704844021091352246344
,0.9602377021578214488783942
,0.9620049199135337625321540
,0.9637721376692460761859138
,0.9655393554249583898396736
,0.9673065731806707034934334
,0.9690737909363830171471932
,0.9708410086920953308009530
,0.9726082264478076444547128
,0.9743754442035199581084726
,0.9761426619592322717622324
,0.9779098797149445854159922
,0.9796770974706568990697519
,0.9814443152263692127235117
,0.9832115329820815263772715
,0.9849787507377938400310313
,0.9867459684935061536847911
,0.9885131862492184673385509
,0.9902804040049307809923107
,0.9920476217606430946460705
,0.9938148395163554082998303
,0.9955820572720677219535901
,12.8023045930756946830797460
,12.4359532835179926735236222
,12.0801255792674311351220240
,11.7347311827040439169422825
,11.3996003397007275026453499
,11.0744970981310864033275720
,10.7591350736471618176892662
,10.4531940071732538655169265
,10.1563356553008770077894951
,9.8682178729785299253762787
,9.5885060994721111882199693
,9.3168818172100067442897853
,9.0530478934375420152491643
,8.7967310124642459356891777
,8.5476816405197144632666095
,8.3056721202068821696684608
,8.0700159687388346441139220
,7.8419521668383529444668056
,7.6212804820212696199632774
,7.4040596761667503145076807
,7.1943659550958924953079077
,6.9906198653035689360990546
,6.7926597713950007673133769
,6.6003265879095422974387475
,6.4134638435766238018231888
,6.2319179926732513052911600
,6.0555388086034680483749071
,5.8841797404859681464017740
,5.7176981649745792779526710
,5.5559555113953429383855109
,5.3988172715471556273314491
,5.2461529238675428388205546
,5.0978358066891162891920430
,4.9537429709516143105929586
,4.8137549783186193153028398
,4.6777562273739814457940156
,4.5456337868048608541471367
,4.4172775580268801576266924
,4.2925823165631973310496505
,4.1714443478586087366011270
,4.0537633060485642744197321
,3.9394417077428407480965689
,3.8283848527477610801383889
,3.7205007464184429721854031
,3.6157000237915224438722817
,3.5138958756661828886080912
,3.4150039768245297189253051
,3.3189424154005542355605485
,3.2256316276427776656987589
,3.1349943283651735548289707
,3.0469554497651145652525884
,2.9614420785866224505866739
,2.8783833958714377665444317
,2.7977106184713047554168952
,2.7193569422631220788844075
,2.6432574870189453619673259
,2.5693492428873301314240507
,2.4975710184443382644303711
,2.4278633902737127847615284
,2.3601686540367436961673775
,2.2944307769936673757626977
,2.2305953519397587747619127
,2.1686095525206576795085311
,2.1084220898928727194743260
,2.0499831706967825972753872
,1.9932444563108573376553068
,1.9381590233571797110556645
,1.8846813254297620776611666
,1.8327671560185476717919073
,1.7823736126033808968571748
,1.7334590618936798200877547
,1.6859831061909498206574654
,1.6399065508527654877468649
,1.5951913728383246837694287
,1.5518006903171732702162444
,1.5096987333243414575179031
,1.4688508154466992650100110
,1.4292233065271366942994291
,1.3907836063749676736023275
,1.3535001194728497608821272
,1.3173422306725146579964303
,1.2822802818737342178678773
,1.2482855496833664687983401
,1.2160186970967772346341462
,1.1840786775739411407215584
,1.1531251274850951027417523
,1.1231328590340627915367122
,1.0940775222699785640401160
,1.0659355887594579304078479
,1.0386843362807780533074720
,1.0123018345034697773598964
,0.9867669315849992850431249
,0.9620592415999785762537044
,0.9381591327447650341397889
,0.9150477163593528917573394
,0.8927068369909114675664341
,0.8711190639663752843802058
,0.8502676851758348419707545
,0.8301367038833964429045409
,0.8107108392512197836410337
,0.7919755307955941292519242
,0.7739169461762269719429241
,0.7565219906765746626930991
,0.7397783156855736175216975
,0.7236743228121437221389556
,0.7081991602905737259732177
,0.6933427091984388779266624
,0.6791124840543018015281973
,0.6654644298747509623126462
,0.6524084057645208600817455
,0.6399372070397663092578000
,0.6280444285763953082835087
,0.6167244844161579031549536
,0.6059726291768686712302383
,0.5957849817873303033266552
,0.5853771631326835089836891
,0.5763099833634780511104623
,0.5678013333596032552463839
,0.5598508418481727977322748
,0.5524590184142230686603625
,0.5456272752548423365936969
,0.5407292342631301318434112
,0.5350289989357794873114926
,0.5299010078905169729424074
,0.5253513770506385016645368
,0.5213872999105415573239952
,0.5180170272110777851537478
,0.5152498209178563159937880
,0.5104204069467499493839568
,0.5093431733090086899196081
,0.5088368885977372357842796
,0.5089213546576725200054625
,0.5096160367920666844909761
,0.5109397651530512840523102
,0.5129103668970808049820675
,0.5155442175705052809675522
,0.5188556732283027272956133
,0.5228564180184991361244329
,0.5275546986558199424877103
,0.5329544517459980923490548
,0.5390543467751127693077251
,0.5458467696900070054155663
,0.5533167818059936404750943
,0.5614411190790392636174033
,0.5701873110102927411091400
,0.5795130119898582732318459
,0.5893656521292466310413261
,0.5996825206680729269947960
,0.6103913890863312818879649
,0.6214117341120043436220044
,0.6326566070459465063180460
,0.6440351021697119371367535
,0.6554553066922768067570360
,0.6668275661567265588658415
,0.6780677793583523849108019
,0.6891004602046957305816477
,0.6998612676252491393569244
,0.7102987632524860872607064
,0.7203752453331974114902891
,0.7300666224610381505044643
,0.7393614080241391883774327
,0.7482590108708518927826958
,0.7567675792618171470849120
,0.7649016653754917571816918
,0.7726799641201462787165610
,0.7801233238940049607990090
,0.7872531524749355469339207
,0.7940902643708181996018425
,0.8006541505906342726106573
,0.8069626050932504623958152
,0.8130316198612979050608374
,0.8188754735107740545529964
,0.8245068448043452180584723
,0.8299370999622269762241444
,0.8351764479226704285252936
,0.8402341384649316680111042
,0.8451186166889472772822955
,0.8498376476578662908067940
,0.8543984152367557483032101
,0.8588076002966578137431952
,0.8630714431089392402185467
,0.8671957938380283614776545
,0.8711861540674975534770397
,0.8750477114847245996287484
,0.8787853692494842494653540
,0.8824037711519824300765436
,0.8859073233774665823148098
,0.8893002134951655257566472
,0.8925864271485043355269795
,0.8957697628215034457710431
,0.8988538449804427399314477
,0.9018421358322674663554608
,0.9047379458968032306387386
,0.9075444435554446132030648
,0.9102646637122491224403120
,0.9129015156817894549590164
,0.9154577903980599673516849
,0.9076300339132157279919966
,0.9203392189560600789022260
,0.9226694194096396461901577
,0.9479715065312791510976353
,0.9271206871271474581064354
,0.9292462427585160833487521
,0.9313079322497906931133116
,0.9333077970844709803088790
,0.9352478059928814868584368
,0.9371298596623621746104504
,0.9389557946370369334587735
,0.9407273854231408272141834
,0.9424463440959653937056828
,0.9441653027687899601971822
,0.9458842614416145266886815
,0.9476032201144390931801809
,0.9493221787872636596716802
,0.9510411374600882261631796
,0.9527600961329127926546789
,0.9544790548057373591461783
,0.9561980134785619256376776
,0.9579169721513864921291770
,0.9596359308242110586206763
,0.9613548894970356251121757
,0.9630738481698601916036750
,0.9647928068426847580951744
,0.9665117655155093245866738
,0.9682307241883338910781731
,0.9699496828611584575696725
,0.9716686415339830240611718
,0.9733876002068075905526712
,0.9751065588796321570441705
,0.9768255175524567235356699
,0.9785444762252812900271692
,0.9802634348981058565186686
,0.9819823935709304230101679
,0.9837013522437549895016673
,0.9854203109165795559931667
,0.9871392695894041224846660
,0.9888582282622286889761654
,0.9905771869350532554676647
,0.9922961456078778219591641
,0.9940151042807023884506634
,0.9957340629535269549421628
,12.9413991721796346467954208
,12.5710310705895835781120695
,12.2112574659783845731908514
,11.8620071965042583883587213
,11.5231253559521373830420998
,11.1943862275175725073950161
,10.8755091473986773564774921
,10.5661754949740220865805895
,10.2660452534573298777331729
,9.9747719014176965401929920
,9.6920147524288271512205029
,9.4174482301630177971674129
,9.1507679230462350972175045
,8.8916935806126353725176159
,8.6399694699207891801506776
,8.3953626870006896609766045
,8.1571394387393567626531876
,7.9266646437800512003946096
,7.7037301367548982611310748
,7.4840644762877834850200998
,7.2721137292176862843007257
,7.0661733422979562391219588
,6.8660804374675539207828479
,6.6716746589537923028956357
,6.4827981909339511545908863
,6.2992960596943676776504617
,6.1210165431770695576574326
,5.9478115562639493063556984
,5.7795369337048869695649955
,5.6160525818170334844126046
,5.4572225068989439478173153
,5.3029147496084414470374213
,5.1530012615031113298869059
,5.0073577564286511076829811
,4.8658635121249984578639669
,4.7284016246161781893420084
,4.5948580861868064673103618
,4.4651214683086069001660690
,4.3390854878258329208051691
,4.2166453035223678824650051
,4.0976994913930004926783113
,3.9821495206270909328338803
,3.8698996736214148484123143
,3.7608569675971716961271341
,3.6549310779694819117935367
,3.5520342636536264002700136
,3.4520812944223582263703065
,3.3549893799473622379991866
,3.2606781031006084603518502
,3.1690693502822955274211836
,3.0800872493606519242348440
,2.9936581061871829767540021
,2.9097103437022333594086376
,2.8281744428236308408486366
,2.7489828850575515062359955
,2.6720700967824462246369421
,2.5973723951619085426045785
,2.5248279356445411103493370
,2.4543766610098907143822089
,2.3859602519207006032786467
,2.3195220789429145114013409
,2.2550071559962550082900634
,2.1923620951995714811744165
,2.1315350630765821371426227
,2.0724757380890173052989667
,2.0151352694656035069442623
,1.9594662372966924479555928
,1.9054226138658019173988123
,1.8529597261906884941851104
,1.8020342197480647694618483
,1.7526040233574675664129927
,1.7046283152012757788895669
,1.6580674899593279558729364
,1.6128831270381165374772081
,1.5690379598760577639637859
,1.5264958463079394412886813
,1.4852217399732885461105525
,1.4451816627551865579448531
,1.4063426782378438684162347
,1.3686728661731812906054984
,1.3321412979486806360540641
,1.2967180130508380031528759
,1.2623739965210472036005740
,1.2297651931973880845561098
,1.1974991317195911033621769
,1.1662307791253452293744886
,1.1359346976057638212154188
,1.1065862972207978209837620
,1.0781618194572002433773150
,1.0506383218317687511245140
,1.0239936635039628143317714
,0.9982064918244504259092764
,0.9732562297209157442523519
,0.9491230638397499808078805
,0.9257879334547418626044646
,0.9032325203397553181616786
,0.8814392400650226111480379
,0.8603912354490095282244511
,0.8400723730647845499674986
,0.8204672436215152409033635
,0.8015611666084918596197895
,0.7833401987623235251945175
,0.7657911448072024507283118
,0.7489015677382360181013610
,0.7326597950612460108388291
,0.7170549172414971694777819
,0.7020767753139347533419823
,0.6877159365367613297337357
,0.6739788930827218527142008
,0.6608249617961597932591644
,0.6482637183858469542840908
,0.6362887449875296308476891
,0.6248944514960973473094441
,0.6140760964698751545043365
,0.6030550300697384846770888
,0.5933776066444818031442310
,0.5842679875056968619162490
,0.5757249915616493574077595
,0.5677483061443945322466220
,0.5603384928812331633452004
,0.5534970036484085920136522
,0.5485802711432720135675822
,0.5428850098303350524275857
,0.5377700301729282372775742
,0.5332414229174075037676062
,0.5293063279182768088304556
,0.5259729051753211370723307
,0.5232502784295717246365598
,0.5182446974677996642810740
,0.5172602966703119253821797
,0.5168499038967248049303294
,0.5170331393620346549511169
,0.5178291582393620418045543
,0.5192563290938653208783649
,0.5213318421733970087217358
,0.5240712367983774155888455
,0.5274878106878811978575072
,0.5315919477197281750591173
,0.5363903378413330536034209
,0.5418850982578364838815332
,0.5480728219696244796210749
,0.5549435823868679173997975
,0.5624799326102399854576674
,0.5706559685378456148185933
,0.5794365362325615276262170
,0.5887766777305565302214063
,0.5986214193554935114605087
,0.6089060091844821220874451
,0.6195567004732734917027415
,0.6304921258378199944161224
,0.6416252915882478813358603
,0.6528661257444936527605250
,0.6641244458638693171081968
,0.6753131697017653589654174
,0.6863514809490967039096176
,0.6971676960803000477895353
,0.7077015527282363160921363
,0.7179057066427712019418550
,0.7277463164862683075995164
,0.7372027086224326453134381
,0.7462662241230429982508099
,0.7549384345239424920492866
,0.7632289820400213198325901
,0.7711533005627033698914374
,0.7787304531052092748666382
,0.7859812627115123628840365
,0.7929268408177556626270643
,0.7995875445398680225750354
,0.8059823347244642333109255
,0.8121284657195897427328646
,0.8180414200723111761703876
,0.8237350178384653665020210
,0.8292215352325397192956302
,0.8345119903180177045598498
,0.8396162917961681459999568
,0.8445434288676750833602114
,0.8493016181318422397339418
,0.8538984218120586611178169
,0.8583408415113676914742769
,0.8626353925302915337525178
,0.8667881633280319908507749
,0.8708048637935321689695911
,0.8746908650652893690846668
,0.8784512328811302506181846
,0.8820907558825129557433797
,0.8856139699093273920382785
,0.8890251790539333009988354
,0.8923284740577798190841463
,0.8955277485024800698809599
,0.8986267131515277561959465
,0.9016289087274770297497639
,0.9045377173550440685900753
,0.9073563728585724019737313
,0.9100879700697003249487693
,0.9127354732755513788688972
,0.9153017239168917962288674
,0.9101175749114491786428971
,0.9202012606726788224165148
,0.9225396758635546756721624
,0.9425624305936802782568407
,0.9270058784101368187791081
,0.9291382202041628124433714
,0.9312062818040952594245141
,0.9332121315794803528831380
,0.9351577622162835501384848
,0.9370450953390176973556436
,0.9388759859569447696614475
,0.9406522260052322392809288
,0.9423755461114059484017957
,0.9440476150718030146080650
,0.9457196840322000808143343
,0.9473917529925971470206036
,0.9490638219529942132268729
,0.9507358909133912794331422
,0.9524079598737883456394115
,0.9540800288341854118456808
,0.9557520977945824780519501
,0.9574241667549795442582194
,0.9590962357153766104644887
,0.9607683046757736766707581
,0.9624403736361707428770274
,0.9641124425965678090832967
,0.9657845115569648752895660
,0.9674565805173619414958353
,0.9691286494777590077021046
,0.9708007184381560739083739
,0.9724727873985531401146432
,0.9741448563589502063209125
,0.9758169253193472725271818
,0.9774889942797443387334511
,0.9791610632401414049397204
,0.9808331322005384711459897
,0.9825052011609355373522590
,0.9841772701213326035585283
,0.9858493390817296697647976
,0.9875214080421267359710669
,0.9891934770025238021773362
,0.9908655459629208683836055
,0.9925376149233179345898748
,0.9942096838837150007961441
,0.9958817528441120670024134
,13.0787884107873928485332726
,12.7044615247832251014870053
,12.3407945048697484935473767
,11.9877360410133366741547434
,11.6451468977194529941243673
,11.3128124384889954257005229
,10.9904585172732307540854890
,10.6777688488621311790893742
,10.3744022059438396610175914
,10.0800081038197824057078833
,9.7942399945629023960691484
,9.5167653727386056772274969
,9.2472725672713504962985098
,8.9854743317830205739937810
,8.7311086239458841617988583
,8.4839371630816717839707053
,8.2431767865461065269983010
,8.0103240458603011120430892
,7.7851619893555090712311539
,7.5630758063266814161806906
,7.3488964754551062696918962
,7.1407893399214126262108948
,6.9385903116044387317629116
,6.7421378056200547135290435
,6.5512727047217724773986447
,6.3658386476123141051175480
,6.1856824519442419330061966
,6.0106545276155420864938606
,5.8406091913987729924429004
,5.6754048464680950658589609
,5.5149040308446570790579244
,5.3589733632034830534962566
,5.2074834235446365582333783
,5.0603086037171367550513423
,4.9173269148824072516390515
,4.7784201509001791308151041
,4.6434732709200350342371166
,4.5123735125054915684472689
,4.3850135485130943280296378
,4.2612874276067032042192295
,4.1410926611807017394539798
,4.0243296841345514991417076
,3.9109017741945333312969524
,3.8007149728146663036909558
,3.6936780077994204596336658
,3.5897022178482478338423789
,3.4887014791547135139637703
,3.3905921336553088707432835
,3.2952929218366171504328577
,3.2027249119797724929981086
,3.1128114377208455643142315
,3.0254780338277806883695575
,2.9406523746679869013576081
,2.8582642144810375128827218
,2.7782453293928459636674688
,2.7005294611208836563776003
,2.6250522623257874776925291
,2.5517512435669589265785362
,2.4805657218210153125426132
,2.4114367705229078353568184
,2.3443071710908358618041802
,2.2791213658973994427014986
,2.2158254126508780679216670
,2.1543669401519052186699810
,2.0946951053922728824829846
,2.0367605519640035183215332
,1.9805153697482353880587880
,1.9259130558549195644246765
,1.8729084767857551163672269
,1.8214578317942233809390018
,1.7715186174180641565101268
,1.7230495931610048110371736
,1.6760107483020461049960659
,1.6303632698121497401899660
,1.5860695113596907646069667
,1.5430929633876862006047759
,1.5013982242474530615083950
,1.4609509723751090692900334
,1.4217179394991839025408353
,1.3836668848695110600743874
,1.3467665704995848141578563
,1.3109867374166661591061711
,1.2762980829163526053093847
,1.2426722388213915504451279
,1.2107641771649129136534384
,1.1791852657121042469157146
,1.1485894871819961604586524
,1.1189520148042140235133957
,1.0902488630106614841963619
,1.0624568719467233357534042
,1.0355536930169062515005862
,1.0095177753875028692220894
,0.9843283533342613855765535
,0.9599654343290954239265034
,0.9364097878438002453549416
,0.9136429350355506073810830
,0.8916471397588938696543437
,0.8704054016585802688865670
,0.8499014523185292047102735
,0.8301197554221338981150780
,0.8110455114881477411969968
,0.7926646669210286599849269
,0.7749639259457183904089561
,0.7579307626891891302989279
,0.7415534296341317332945664
,0.7258209583098180761595586
,0.7107231486005188836330149
,0.6962505448964619869656190
,0.6823944000986167379707581
,0.6691593916775624428794345
,0.6565097540607364168252502
,0.6444541348732768515361613
,0.6329869368171912036302729
,0.6213354042433324453398313
,0.6110308812182565496584630
,0.6013040662169867323072481
,0.5921529656126288676531999
,0.5835764543056581876712130
,0.5755742747797619740524055
,0.5681470371277356212758036
,0.5612962289471382648642361
,0.5563612854517721029168342
,0.5506710379458872317570695
,0.5455689047349248088636386
,0.5410609326134567798050057
,0.5371541867042494144968146
,0.5338567127037533444067208
,0.5311774699799520771392736
,0.5259834029922830778147613
,0.5250911386369730982082160
,0.5247754888464924993840555
,0.5250558503682114519506285
,0.5259510262415814096925715
,0.5274788821423466167459537
,0.5296559320092026901249938
,0.5324968430533062457854498
,0.5360138244428463982771405
,0.5402159379371440639516777
,0.5451083065554699347288192
,0.5506912335552781589953497
,0.5569592609414143469237501
,0.5639001998261619075236695
,0.5714941747394354232270075
,0.5797127546239887463386253
,0.5885182514380739027259892
,0.5978632810794602958637256
,0.6076906868439765352363224
,0.6179339248492435876514151
,0.6285179974113868084373280
,0.6393609638658196425708979
,0.6503760419047678320580985
,0.6614742153256436552055675
,0.6725672002950987549141360
,0.6835705849574151837799718
,0.6944068555564330003093687
,0.7050080657294908181853543
,0.7153178895999718900355901
,0.7252928724576576113847182
,0.7349027870164770437355628
,0.7441301128727574321075622
,0.7529687592380822636073390
,0.7614222253494080661084809
,0.7695014507357468280801527
,0.7772225997830544130806629
,0.7846049985088195954929802
,0.7916693812382760153667505
,0.7984365338062137107399963
,0.8049263517959585056971150
,0.8111572781302471835118695
,0.8171460487532257177534234
,0.8229076614026086256004078
,0.8284555017646706431833081
,0.8338014658735997119975991
,0.8389562426742924738931606
,0.8439294566162497401862197
,0.8487298495621867777671810
,0.8533654205928487002097427
,0.8578435382938016662279779
,0.8621710298322612375798712
,0.8663542517034423795507792
,0.8703991464930819210721324
,0.8743112890985762497564338
,0.8780959249686507428478421
,0.8817580022122368799131209
,0.8853021989099364441599960
,0.8887329466010177592139030
,0.8920544506706851173305495
,0.8952707081895300289531292
,0.8983855236340438921160967
,0.9014025228271540512992033
,0.9043251653704386106014113
,0.9071567557882758148224411
,0.9099004535643783198040069
,0.9125592822201755716093885
,0.9151361375601266834323155
,0.9120116887545690609329085
,0.9200549173853860285277051
,0.9224020594005537532211747
,0.9381851567499505106795255
,0.9268841228297648449085955
,0.9290236690196020941101551
,0.9310984938269840638369601
,0.9331106947661885753220190
,0.9350622910532845333264618
,0.9369552279774201464235261
,0.9387913813706986188023507
,0.9405725617984955766459620
,0.9423005177765296780378890
,0.9439769372589930096495436
,0.9456034470533327684904634
,0.9472299568476725273313832
,0.9488564666420122861723030
,0.9504829764363520450132228
,0.9521094862306918038541426
,0.9537359960250315626950623
,0.9553625058193713215359821
,0.9569890156137110803769019
,0.9586155254080508392178217
,0.9602420352023905980587415
,0.9618685449967303568996613
,0.9634950547910701157405811
,0.9651215645854098745815008
,0.9667480743797496334224206
,0.9683745841740893922633404
,0.9700010939684291511042602
,0.9716276037627689099451800
,0.9732541135571086687860998
,0.9748806233514484276270196
,0.9765071331457881864679393
,0.9781336429401279453088591
,0.9797601527344677041497789
,0.9813866625288074629906987
,0.9830131723231472218316185
,0.9846396821174869806725383
,0.9862661919118267395134581
,0.9878927017061664983543778
,0.9895192115005062571952976
,0.9911457212948460160362174
,0.9927722310891857748771372
,0.9943987408835255337180570
,0.9960252506778652925589768
,13.2144329030791531920385751
,12.8362067995949757914786460
,12.4687004328262798225068764
,12.1118829985892570988426087
,11.7656317088596189535110170
,11.4297438227021910250869041
,11.1039524946271015437559981
,10.7879444706062237457899755
,10.4813778848285235056891906
,10.1838987187402185696782908
,9.8951548472713426463087671
,9.6148069865902066055696196
,9.3425362449613658100133762
,9.0780483352191776447170923
,8.8210748074787641570537744
,8.5713718818252022657588896
,8.3281050305935089284048445
,8.0929079530105223483360533
,7.8655540320947192611811261
,7.6410724712083348819646744
,7.4246935958659339149789957
,7.2144478432604532969207867
,7.0101699458319330915401224
,6.8116971297150561426292370
,6.6188690191219663461197342
,6.4315279059486769597242528
,6.2495191834690322352230396
,6.0726917867323351174491108
,5.9008985393226138782551971
,5.7339963618856693017278303
,5.5718463419930728264262143
,5.4143136926079655779631139
,5.2612676377684008954815909
,5.1125812627448095071258649
,4.9681313299888483214772350
,4.8277981654936006350453681
,4.6914662361639516419131724
,4.5590209460140256325644259
,4.4303541032394697651852766
,4.3053586636666443254739534
,4.1839310879123967623627323
,4.0659707899910904060902794
,3.9513800559630842812453011
,3.8400639641389471279353529
,3.7319303069721954102533346
,3.6268895148557489527263442
,3.5248545819739312001672715
,3.4257409943324947931841962
,3.3294666592569899243869713
,3.2359518392162538447109910
,3.1451190833497495447090841
,3.0568931653512549928564113
,2.9712010207379795367899078
,2.8879716865151423554891608
,2.8071362426011923218993616
,2.7286277549618747073623126
,2.6523812204078396348450042
,2.5783335130130944357063072
,2.5064233321127726838994931
,2.4365911518397611601471908
,2.3687791721609325890085529
,2.3029312713750886842944965
,2.2389929600361688777354630
,2.1769113362666754341034903
,2.1166350424277471375944515
,2.0581142231137410369967711
,2.0013004844405917204142042
,1.9461468545987230527316569
,1.8926077456426733114369654
,1.8406389164911161060445011
,1.7901974371124111939934664
,1.7412416538723205494676449
,1.6937311560220555950451171
,1.6476267433063453982100555
,1.6028903946727717233500243
,1.5594852380652939327632112
,1.5173755212864752373036481
,1.4765265839147805326803109
,1.4369048302650990756035299
,1.3984777033825981362724633
,1.3612136600620146076323635
,1.3250821468865701113770683
,1.2900535772830905578700822
,1.2560993095929728902149236
,1.2238697251143253463823157
,1.1919845642260642470944276
,1.1610932670324625171076605
,1.1311707731301805512913461
,1.1021928729556937920364135
,1.0741361922029470932216100
,1.0469781773014934511678575
,1.0206970818749068197206498
,0.9952719540551191457211644
,0.9706826245220977478211921
,0.9469096952117240784119190
,0.9239345288198498318266161
,0.9017392395252410430828149
,0.8803066856997696643105655
,0.8596204656506294394802126
,0.8396649174823046513083113
,0.8204251238259021583587582
,0.8018869213700713372006135
,0.7840369139108697149609384
,0.7668624862086750315626205
,0.7503518147219566669647861
,0.7344938707180853620926086
,0.7192784115717677506651739
,0.7046959577964476695299822
,0.6907377561441603308622916
,0.6774082362641330457009303
,0.6646718345907204339440000
,0.6525370945183652793275542
,0.6402375442291158291752140
,0.6292886746964193589448655
,0.6189280665912891832292075
,0.6091528994833084187376926
,0.5999612276168712066137800
,0.5913519780785029267278219
,0.5833249448333583941916913
,0.5758807827688492420037392
,0.5690210113193817642596173
,0.5640683072450106694262217
,0.5583830441884330975099715
,0.5532935198633109896704241
,0.5488057187582731089037225
,0.5449266107427997996026647
,0.5416641044040781949320262
,0.5390269695742864186627230
,0.5336321781677123565756915
,0.5328312318276755554791180
,0.5326090654572279703415916
,0.5329848123943927706847035
,0.5339768839505105724185796
,0.5356026046265975892879396
,0.5378777763679442047717316
,0.5408161628867154124833405
,0.5444288599059113886724504
,0.5487235913724259894763691
,0.5537039101443587130191304
,0.5593683185318358841442432
,0.5657093409270975703506679
,0.5727125841999897160050637
,0.5803558311056016272289071
,0.5886082424611831509508875
,0.5974297488500088793017540
,0.6067707263144382912045671
,0.6165720516367743098129495
,0.6267656287947688253936462
,0.6372754614450646393208899
,0.6480192858927602550522806
,0.6589107621540321035880083
,0.6698621230400230164292452
,0.6807871215785739060777360
,0.6916040859044447763892549
,0.7022387980843292076826856
,0.7126269657475159391424313
,0.7227160478341130289692273
,0.7324662740736503918625999
,0.7418507927570826554486416
,0.7508549869178980928907663
,0.7594750936856722312029433
,0.7677163263620738753445494
,0.7755907461315618700581354
,0.7831151153721713775723856
,0.7903089332499906305429249
,0.7971927932955550355487162
,0.8037871339434801143397635
,0.8101113892932264581858703
,0.8161834982737715682432622
,0.8220196996328917871110775
,0.8276345299430419855113428
,0.8330409632817207254973368
,0.8382505363853710589339130
,0.8432736267221309089947567
,0.8481195893023814047495534
,0.8527969309396359331998383
,0.8573134434227799305361373
,0.8616763103051319205860636
,0.8658921916699303666931087
,0.8699672915892210367516668
,0.8739074123988381792571545
,0.8777179990244747820327120
,0.8814041757553024991622692
,0.8849707771973390757480615
,0.8884223746572683655386982
,0.8917632988724321085882707
,0.8949976597716031712081985
,0.8981293637896977655188380
,0.9011621291441742620520472
,0.9040994993961873893439929
,0.9069448555559919133983726
,0.9097014269433871813674841
,0.9123723009762237934339169
,0.9149604320304993709811470
,0.9134153325830604019941461
,0.9198996651014680336899687
,0.9222560796708610952876484
,0.9346780102189238270682381
,0.9267549907108181272974434
,0.9289021869972171607798828
,0.9309841917409931166815795
,0.9330031336849992085191730
,0.9349610608581779835901671
,0.9368599447544030400791826
,0.9387016846218301235893477
,0.9404881117759871234085267
,0.9422209935453166318453100
,0.9439020361984301610291936
,0.9455328862085341512511150
,0.9471151296633270044722508
,0.9486973731181198576933866
,0.9502796165729127109145224
,0.9518618600277055641356583
,0.9534441034824984173567941
,0.9550263469372912705779299
,0.9566085903920841237990658
,0.9581908338468769770202016
,0.9597730773016698302413374
,0.9613553207564626834624733
,0.9629375642112555366836091
,0.9645198076660483899047449
,0.9661020511208412431258807
,0.9676842945756340963470166
,0.9692665380304269495681524
,0.9708487814852198027892882
,0.9724310249400126560104241
,0.9740132683948055092315599
,0.9755955118495983624526957
,0.9771777553043912156738315
,0.9787599987591840688949674
,0.9803422422139769221161032
,0.9819244856687697753372390
,0.9835067291235626285583749
,0.9850889725783554817795107
,0.9866712160331483350006465
,0.9882534594879411882217823
,0.9898357029427340414429182
,0.9914179463975268946640540
,0.9930001898523197478851898
,0.9945824333071126011063257
,0.9961646767619054543274615
,13.3482964714530094596511844
,12.9662321228388179861212848
,12.5949419285043244798316664
,12.2344161810730973627414642
,11.8845492683433473501963817
,11.5451511273432672055605508
,11.2159629780470293525240777
,10.8966752887115401193796060
,10.5869461330754752736993396
,10.2864184018433295619843193
,9.9947346954062190604872740
,9.7115491220987966158872950
,9.4365356273491389771379545
,9.1693928546011207458832359
,8.9098458606977644080870959
,8.6576452522122462340803395
,8.4119032138850791113782179
,8.1743959025997483536229993
,7.9448861376237642772935033
,7.7180351205383859181097250
,7.4994862836389142302095934
,7.2871305769614522773736098
,7.0808015820645513471731647
,6.8803353750197153715362219
,6.6855703639722765529995741
,6.4963475350072137359802582
,6.3125108935457916459199623
,6.1339079307169050991888071
,5.9603900025076148594393999
,5.7918125683612062815086574
,5.6280352838074358956532706
,5.4689219728226170502694004
,5.3143405194364143895313646
,5.1641627180571569866174286
,5.0182641134184287068364938
,4.8765237457107719620807984
,4.7388249006150768849465749
,4.6050526115472099064618305
,4.4750958275945906805759478
,4.3488479962737933703920135
,4.2262040560093847574307802
,4.1070624135855391401150882
,3.9913243766434072234972064
,3.8788940732081074180825908
,3.7696783728687548453706313
,3.6635868098408406190458209
,3.5605315080825103990491698
,3.4604271086111335620216778
,3.3631906982222345980915179
,3.2687417428673217756340819
,3.1770020181818328097733684
,3.0878955469772821906815352
,3.0013485358203002562049733
,2.9172893140970144187917867
,2.8356482748571876228993460
,2.7563578173847962382581045
,2.6793522914490810471477289
,2.6045679431930288671992457
,2.5319428626174307339624647
,2.4614169326197550269341718
,2.3929317795482161201903182
,2.3264307252328251252038172
,2.2618587404566365961500196
,2.1991623998318208244029393
,2.1382898380467181276287647
,2.0791907074514264230913341
,2.0218161369509548563883072
,1.9661186921764495227904490
,1.9120523369064388319316095
,1.8595723957115608548917862
,1.8086355177977169184089234
,1.7591996420241191589894925
,1.7112239630742320795064870
,1.6646688987591569119928181
,1.6194960584346083098949975
,1.5756682125142451589283610
,1.5331492630638205998394596
,1.4919042154623818330350105
,1.4518991511186061238447564
,1.4131012012322925475160673
,1.3754785215930172004306087
,1.3390002684100248409038159
,1.3036365751697867043645829
,1.2693585305206451785409172
,1.2361381571883491847785308
,1.2046249566507978290275105
,1.1734423746232476304385273
,1.1432389619603002817171955
,1.1139902881929757416656912
,1.0856727675102828545306011
,1.0582636441687855999305157
,1.0317409789077824910918935
,1.0060836362345715322419437
,0.9812712724249175177959614
,0.9572843241449235929252382
,0.9341039977812636285747772
,0.9117122598734385130470059
,0.8900918294218063131495455
,0.8692261731776735889098973
,0.8490995051321817976841544
,0.8296967911395908279459377
,0.8110037588198476532497239
,0.7930069116314862887051618
,0.7756935444624749598219182
,0.7590517566878191013657329
,0.7430704578557483230838443
,0.7277393612510765219525410
,0.7130489621846382020109445
,0.6989905006232889350670234
,0.6855559101033760205368139
,0.6727466908810526557971343
,0.6605343303782911235089159
,0.6481701564940283155635825
,0.6371587630169547322722678
,0.6267431986793844389538322
,0.6169206784306388025029833
,0.6076893000807320754930174
,0.5990480388089971519605115
,0.5909967361734985713539459
,0.5835360880790668725026649
,0.5766676419633410821674602
,0.5716975992701883724222967
,0.5660172277589075040538091
,0.5609400085729463469874645
,0.5564718460351608664282708
,0.5526195948894357945491151
,0.5493910046475415365208050
,0.5467946315152713010476759
,0.5411870099228589525708344
,0.5404764507341640600301957
,0.5403464085649328785265766
,0.5408157154261464816258353
,0.5419023538130951500590982
,0.5436230718375339998615914
,0.5459929274770184415288554
,0.5490247539624747430409002
,0.5527285138090874960781207
,0.5571105832937872648358280
,0.5621729483334528820748233
,0.5679123301796755729498045
,0.5743192760215054537553669
,0.5813772532715004714987117
,0.5890617955535948357947973
,0.5973397786237695239464074
,0.6061689061966331060204993
,0.6154974991667223616076399
,0.6252646785506080773231474
,0.6354010254062675278063921
,0.6458297812985942520924709
,0.6564685891678876394905728
,0.6672317577177865333126761
,0.6780329349809811612104227
,0.6887880217308485208960178
,0.6994181304371396290520124
,0.7098523115509661751687531
,0.7200298293988294240364212
,0.7299017697986348585104110
,0.7394318436952632689340703
,0.7485963457492875727794512
,0.7573833276745359777137878
,0.7657911329367727004679978
,0.7738264951847032557807893
,0.7815024406991536443101154
,0.7888362140359513885456977
,0.7958474109831173981532970
,0.8025564418633092111932115
,0.8089833821272349734243789
,0.8151472077738541877067746
,0.8210653688505594738344939
,0.8267536278757330325817065
,0.8322260828614227445854112
,0.8374953176660615561388568
,0.8425725292167004498722349
,0.8474677998716553251057348
,0.8521902289490042026187666
,0.8567480996392952130591425
,0.8611490059813613484607231
,0.8653999545594197595477226
,0.8695074452910802609295615
,0.8734775358553544810646940
,0.8773158936705849342274632
,0.8810278384653627004041709
,0.8846183776895479855539861
,0.8880922363898721139108261
,0.8914538827257350028787641
,0.8947075499888149652250036
,0.8978572557744524118561458
,0.9009068188015965095161164
,0.9038598737695879847819924
,0.9067198845601951440187349
,0.9094901560331051237895394
,0.9121738446169025404941522
,0.9147739678616217950946066
,0.9144202581220839398667977
,0.9197349452690062321380537
,0.9221012141801491202031116
,0.9318952593854424870656317
,0.9266180242998990346237065
,0.9287733455887944300499726
,0.9308629743268713729875685
,0.9328890725687021268086596
,0.9348537192694192921038621
,0.9367589144216252883268226
,0.9386065831820357141523914
,0.9403985800713257070526652
,0.9421366931288676083156020
,0.9438226476267184139601341
,0.9454581087402341710301812
,0.9470446826373444260127599
,0.9485839159295259559456781
,0.9501231492217074858785963
,0.9516623825138890158115146
,0.9532016158060705457444328
,0.9547408490982520756773511
,0.9562800823904336056102693
,0.9578193156826151355431875
,0.9593585489747966654761058
,0.9608977822669781954090240
,0.9624370155591597253419422
,0.9639762488513412552748605
,0.9655154821435227852077787
,0.9670547154357043151406970
,0.9685939487278858450736152
,0.9701331820200673750065334
,0.9716724153122489049394517
,0.9732116486044304348723699
,0.9747508818966119648052882
,0.9762901151887934947382064
,0.9778293484809750246711246
,0.9793685817731565546040429
,0.9809078150653380845369611
,0.9824470483575196144698793
,0.9839862816497011444027976
,0.9855255149418826743357158
,0.9870647482340642042686341
,0.9886039815262457342015523
,0.9901432148184272641344705
,0.9916824481106087940673888
,0.9932216814027903240003070
,0.9947609146949718539332252
,0.9963001479871533838661435
,13.4803461329435148030597702
,13.0945057638485007345252598
,12.7194885788797868997335172
,12.3553064947828996622547493
,12.0018717532822147830984250
,11.6590077161821934481622520
,11.3264644127339533241638492
,11.0039367166347137327875316
,10.6910832221901994643076250
,10.3875441835856534567028575
,10.0929572455403047115396475
,9.8069700976552969251542891
,9.5292495986520115991424973
,9.2594873101289341121855614
,8.9974017226898883592411948
,8.7427377239277870302203155
,8.4945523697909930405103296
,8.2542608906274264057856271
,8.0210581167990007145363052
,7.7939462184092072050134448
,7.5732574937852898955270575
,7.3588209767392775972894015
,7.1504691243873637063188653
,6.9480369003206270406280964
,6.7513615385338408003690347
,6.5602827603693549818331121
,6.3746432204149217071176281
,6.1942889975086279363836184
,6.0190700063723516777258737
,5.8488402672434673945645045
,5.6834580225708695166986217
,5.5227857245024756238649388
,5.3666899333514432868241784
,5.2150411686571862546202283
,5.0677137462922798860631701
,4.9245855188038021310603654
,4.7855386213832602493312152
,4.6504570078277502886976436
,4.5192284507679341132302397
,4.3917454341530373085333849
,4.2679018454483488298478733
,4.1475950980890692321167990
,4.0307255347629862285430136
,3.9171963462797609878407457
,3.8069134920558540535751035
,3.6997856224572140959594435
,3.5957240031915849165500276
,3.4946424419225867730176560
,3.3964572162114472497762563
,3.3010870064795092559961631
,3.2084528255154332043730392
,3.1184779556052819593503500
,3.0310878844245281449332197
,2.9462102435102579534031975
,2.8637747485322160301279837
,2.7837131413076847685772464
,2.7059591335135282363921760
,2.6304483520519874595322563
,2.5571182860281247428702045
,2.4859082352977459606790944
,2.4167592605459553567470721
,2.3496141348577102014871798
,2.2844172967432916365737583
,2.2211148045830295671976273
,2.1596542924571067167960337
,2.0999849273277471084497847
,2.0420573675425326420906913
,1.9858237226291297616853626
,1.9312375143531423926646085
,1.8782536390123212299840816
,1.8268283309419159898823182
,1.7769191272074382759171840
,1.7284848334626754517984182
,1.6814854909523913040203524
,1.6358823446406978163736312
,1.5916378124477861266683476
,1.5487154555793385402040485
,1.5070799499347800054493973
,1.4666970585823457806640135
,1.4275336052908917938708555
,1.3895574491103608316677764
,1.3527374599948336353349987
,1.3170434954644067993001499
,1.2824463783050852327960456
,1.2489178753101903840416753
,1.2171030267033455807279552
,1.1856334425165251378331277
,1.1551532597741396291013416
,1.1256378302185487960684895
,1.0970633595035743645951243
,1.0694068925339399456220235
,1.0426462998375825019792273
,1.0167602648255049668790662
,0.9917282717606037412139131
,0.9675305943038574607584223
,0.9441482846799787997937869
,0.9215631638203708453360719
,0.8997578132535282158244172
,0.8787155699019953969397534
,0.8584205251266047165259465
,0.8388575291442821324494616
,0.8200122011884621864297173
,0.8018709445018363801693795
,0.7844209636022095866181303
,0.7676502796855162458200539
,0.7515477390194948981161360
,0.7361030090274908177505608
,0.7213065582040617540471317
,0.7071496187164438840255798
,0.6936241328575888376306580
,0.6807312646603236316877883
,0.6676948403785346597416606
,0.6560152235905515327729631
,0.6449425296966451170987966
,0.6344731034099434507922410
,0.6246041903273008566443991
,0.6153339272230428091958743
,0.6066613330014750671281831
,0.5985862927088207996462188
,0.5911095393748373449938072
,0.5849616004924563794631354
,0.5792456583578473594542402
,0.5735700275282805682408593
,0.5685047499279611837863513
,0.5640556324141721145082329
,0.5602293954515182861086942
,0.5570336084219441596943057
,0.5544765909592250796578128
,0.5486442154873925058922168
,0.5480230096409883788766138
,0.5479836434697086255951604
,0.5485446118654587754903673
,0.5497234339946958092681939
,0.5515362494586317776423812
,0.5539973439630095919383734
,0.5571185975621549824055023
,0.5609088247094254908731159
,0.5653730496416059514430685
,0.5705117005081611347705461
,0.5763197436080345070763542
,0.5827857955030677494789870
,0.5898912546094754461023513
,0.5976095026757303196873750
,0.6059052563148732417630526
,0.6147341471997843642682824
,0.6240426227828430594257725
,0.6337682520402977415230339
,0.6438405108146628696985658
,0.6541820990369815458365110
,0.6647107756468664252480494
,0.6753416808951049343789919
,0.6859900191052646922784675
,0.6965739249308577907271456
,0.7070173174029013019037393
,0.7172524705632217223438829
,0.7272220972215608369992879
,0.7368807485693912306956577
,0.7461954173294015335571316
,0.7551453255535027775380286
,0.7637209739177246436980795
,0.7719226084458833403445510
,0.7797583078886570762122687
,0.7872419243819663847716583
,0.7943910836826876264993302
,0.8012254133002009170994029
,0.8077651061858541758908814
,0.8140298643782335474838874
,0.8200382117844793317118501
,0.8258071254563071894594373
,0.8313519122294991126054242
,0.8366862530946500564610346
,0.8418223617764383215344992
,0.8467711135766570196281577
,0.8515423109471613738463702
,0.8561448102909495760926006
,0.8605866818189663591809335
,0.8648753307394677625197232
,0.8690175942361322292128989
,0.8730198185821100853587495
,0.8768879207692834576448604
,0.8806274383613005296567167
,0.8842435704360449566507896
,0.8877412117280560899246211
,0.8911249814973044580668216
,0.8943992482315911152213062
,0.8975681509986566108949546
,0.9006356180624266460910121
,0.9036053832359175475019697
,0.9064810003411591932120928
,0.9092658560709498960505925
,0.9119631814902096067498860
,0.9131959343749729285377725
,0.9171074485193932979143483
,0.9195601622313607226288923
,0.9219369059816445721722289
,0.9297069112203129037652616
,0.9264727359256594851899536
,0.9286366882393949362395347
,0.9307344141160958095326805
,0.9327681111381408429750195
,0.9347398912868701836842433
,0.9366517851891505985761910
,0.9385057462042135645319263
,0.9403036544926153261769741
,0.9420473211210108610558223
,0.9437384920594027448714769
,0.9453788516781169715130773
,0.9469700251932974266466658
,0.9485135796236013883131477
,0.9500110233186125352489171
,0.9515084670136236821846865
,0.9530059107086348291204558
,0.9545033544036459760562252
,0.9560007980986571229919946
,0.9574982417936682699277640
,0.9589956854886794168635333
,0.9604931291836905637993027
,0.9619905728787017107350721
,0.9634880165737128576708415
,0.9649854602687240046066108
,0.9664829039637351515423802
,0.9679803476587462984781496
,0.9694777913537574454139190
,0.9709752350487685923496883
,0.9724726787437797392854577
,0.9739701224387908862212271
,0.9754675661338020331569965
,0.9769650098288131800927658
,0.9784624535238243270285352
,0.9799598972188354739643046
,0.9814573409138466209000740
,0.9829547846088577678358433
,0.9844522283038689147716127
,0.9859496719988800617073821
,0.9874471156938912086431515
,0.9889445593889023555789208
,0.9904420030839135025146902
,0.9919394467789246494504596
,0.9934368904739357963862290
,0.9949343341689469433219983
,0.9964317778639580902577677
,13.6105520561029571524613857
,13.2209989920364954230080912
,12.8423128379700592915924062
,12.4745275983854941870276889
,12.1175739954068006909437827
,11.7712895245178401637531351
,11.4354337440923252700031298
,11.1097066054142992186370975
,10.7937678044102476349053177
,10.4872554215194746518591273
,10.1898024788985903654747744
,9.9010504536463255220724022
,9.6206592114207563071204277
,9.3483132354186899704018288
,9.0837243899624464660291778
,8.8266317474640061391255585
,8.5767992006270716842664115
,8.3334617179705556822000290
,8.0980706759274294626038682
,7.8703452926883992191164907
,7.6459919095223289886575913
,7.4295041567107569235872688
,7.2191581072886599201865465
,7.0147876485100519872162295
,6.8162288814389953017780499
,6.6233203036764924931389942
,6.4359032563676388249973570
,6.2538224382975329262990272
,6.0769263499296437558427897
,5.9050675949197728442641164
,5.7381030221214555098185883
,5.5758937294245480842391771
,5.4183049700359502409696688
,5.2652060048749369514098362
,5.1164699371130284433206725
,4.9719734489116191866742156
,4.8315975332481100323889223
,4.6952250956378742685615180
,4.5627427355888219295820818
,4.4340419908049391040094633
,4.3090157129501225341527970
,4.1875603361947870695303209
,4.0695752519357677456923739
,3.9549627270273917112319850
,3.8436278235891929710987824
,3.7354783206436446008069652
,3.6304246377965463388193257
,3.5283797611598624044404460
,3.4292591705183532724277029
,3.3329807719079624916957982
,3.2394648260801472972048032
,3.1486338853000122028902297
,3.0604127285543385461608068
,2.9747282994397687971854793
,2.8915096458688447356166762
,2.8106878615370636254056080
,2.7321960291035689571970124
,2.6559691650416805686063526
,2.5819441661168531787495795
,2.5100597574506107179104220
,2.4402564421302752606379727
,2.3724764523255146286828676
,2.3066637018743296749789806
,2.2427637403024816009633469
,2.1807237082419090867801970
,2.1204922942151571696456358
,2.0620196927543164022722522
,2.0052575638244847233693235
,1.9501589935232639394513399
,1.8966784560293066252967265
,1.8447717767744864492129864
,1.7943960968158110258485749
,1.7455098383847491572140598
,1.6980726715932459303104451
,1.6520454822773253944490079
,1.6073903409607954717586153
,1.5640704729233207981309306
,1.5220502293588795694745386
,1.4812950596124965230160342
,1.4417714844850759714489641
,1.4034470705981219040836550
,1.3662904058121450034946065
,1.3302710756947786485682172
,1.2953596410374692560196763
,1.2615276164239292988611396
,1.2287474498601871353287152
,1.1976633944175829604716910
,1.1669106299936740089862042
,1.1371324995224774134783274
,1.1083050031124583867381261
,1.0804049891541362971025819
,1.0534101406492744068543743
,1.0272989624483279680333681
,1.0020507691948061790299107
,0.9776456738064146501088203
,0.9540645764867944356169005
,0.9312891545833416051536346
,0.9093018540485986456189949
,0.8880858837076834877422016
,0.8676252137901299121836018
,0.8479045800439684033023013
,0.8289094940367370822897897
,0.8106262589552682973348396
,0.7930419884714465794672833
,0.7761446244906240465866176
,0.7599229483610141500093960
,0.7443665797120773142125927
,0.7294659583514302436668686
,0.7152123072804195125229398
,0.7015975771491069767904492
,0.6886143794463341905043308
,0.6755168623731566679424532
,0.6637698477703319888121314
,0.6526370471623099689395531
,0.6421148200521987758904174
,0.6322004376956497084805164
,0.6228920709585320514278806
,0.6141887778436307954166296
,0.6060904825701629583534213
,0.5985979512793456747132836
,0.5924326516609704773586031
,0.5867092156661256607819155
,0.5810381222200228235053032
,0.5759843691224386663662926
,0.5715536490830349647396247
,0.5677525299119440260753322
,0.5645883807792811959203050
,0.5620692630055319494175592
,0.5560004386400884124341815
,0.5554674587107744088143590
,0.5555172416808282775946282
,0.5561679117332740673873559
,0.5574364928098569649250749
,0.5593384869671771397747762
,0.5618873829361679117511130
,0.5650940890360792723257077
,0.5689662614624780845318242
,0.5735075731572336632524411
,0.5787169091164292566986660
,0.5845875123369053127930783
,0.5911061206543997137430324
,0.5982521386168293542340280
,0.6059968968085309715121412
,0.6143030802117663835559824
,0.6231244023141625509865094
,0.6324056146127203792417504
,0.6420829297377748101638417
,0.6520849238582752116499819
,0.6623339594896109350230518
,0.6727481011500060503749410
,0.6832434812305113736030648
,0.6937369782244544591520707
,0.7041490245972659156592499
,0.7144063489812624290209442
,0.7244443898848430540837739
,0.7342091922589363273132790
,0.7436586098525749255472306
,0.7527627230056859186646534
,0.7615034730310538124697928
,0.7698736046579738312445329
,0.7778750795559050690286540
,0.7855171633771272921009654
,0.7928144105199066427047683
,0.7997847401242385023678594
,0.8064477566387427964755830
,0.8128234085050315416154376
,0.8189310181778819419662341
,0.8247886655198235494879100
,0.8304128709214864123566713
,0.8358185055319995448996906
,0.8410188537897754779137927
,0.8460257545301884674060489
,0.8508498492193729001442648
,0.8555006037219021752804338
,0.8599866670274294300213569
,0.8643159062988603480448546
,0.8684955462666318348752270
,0.8725322618304034438807548
,0.8764322517752557439862926
,0.8802012978124834630122564
,0.8838448124636362202011242
,0.8873678784895059346027324
,0.8907752818495450197744390
,0.8940715396286783578361224
,0.8972609239764465227651158
,0.9003474828311325284246891
,0.9033350580125107942564000
,0.9062273011334351924261910
,0.9090276876840335251728220
,0.9117395295707464430989830
,0.9134371570388964967079914
,0.9169100752606226256702371
,0.9193746804550761986263296
,0.9217625611467002988419495
,0.9279984867067657683392667
,0.9263186059432698682414298
,0.9284917285489451277413764
,0.9305980557079196469061344
,0.9326398229592688382538768
,0.9346191775267181922615123
,0.9365381827857451879637551
,0.9383988224489825391572140
,0.9402030046010750874430073
,0.9419525657054079736951735
,0.9436492746100220152527527
,0.9452948363901580997037399
,0.9468908956434877177699150
,0.9484390387399286304059842
,0.9499407946826462501022093
,0.9513976347418564571967181
,0.9528544748010666642912270
,0.9543113148602768713857358
,0.9557681549194870784802447
,0.9572249949786972855747536
,0.9586818350379074926692624
,0.9601386750971176997637713
,0.9615955151563279068582801
,0.9630523552155381139527890
,0.9645091952747483210472978
,0.9659660353339585281418067
,0.9674228753931687352363156
,0.9688797154523789423308244
,0.9703365555115891494253333
,0.9717933955707993565198421
,0.9732502356300095636143510
,0.9747070756892197707088599
,0.9761639157484299778033687
,0.9776207558076401848978776
,0.9790775958668503919923864
,0.9805344359260605990868953
,0.9819912759852708061814042
,0.9834481160444810132759130
,0.9849049561036912203704219
,0.9863617961629014274649307
,0.9878186362221116345594396
,0.9892754762813218416539485
,0.9907323163405320487484573
,0.9921891563997422558429662
,0.9936459964589524629374750
,0.9951028365181626700319839
,0.9965596765773728771264928
,13.7388875090513380428092205
,13.3456860274375319619366564
,12.9633899783039332476164418
,12.5920558541887483983146012
,12.2316334315243242514270605
,11.8819750085405093642521024
,11.5428503660590155988074912
,11.2139651912612219319953510
,10.8949808599949715670618389
,10.5855337477772408760756662
,10.2852525995181238727127493
,9.9937729017023233524241732
,9.7107476371875129927957460
,9.4358542297477114857429115
,9.1687978703734955843174248
,8.9093117297316979374954826
,8.6571547769774443992218949
,8.4115150070791759873145566
,8.1739700629872729109592910
,7.9442264008130658581308126
,7.7176759047710907779560330
,7.4991668729627445344476655
,7.2868556602410805567160423
,7.0805751121415942961334622
,6.8801602371960663973027295
,6.6854483500654913186167505
,6.4962795160963517915320153
,6.3124970867729812695756664
,6.1339481759148242190349265
,5.9604839938029492429905076
,5.7919600156753290320921224
,5.6282360031235834085805436
,5.4691759191571449605362432
,5.3146477825588682719626377
,5.1645235001586584644428513
,5.0186786013074087264840273
,4.8769929444445203614577622
,4.7393484196314465961563656
,4.6056304562350423026373392
,4.4757296628600604648795525
,4.3495378709618313095575104
,4.2269505497102777269446960
,4.1078661530482190045177049
,3.9921860373035200630909003
,3.8798143803377524996278680
,3.7706581024940355462149455
,3.6646267895777939749279994
,3.5616326180998805206456836
,3.4615902816701358268858257
,3.3644169232234841793172109
,3.2700320624187955154127394
,3.1783575321354864406941942
,3.0893174130008267397329291
,3.0028379707023060696258199
,2.9188475951368113570083551
,2.8372767413378681133906412
,2.7580578721327246860539617
,2.6811254024850850186112439
,2.6064156454808373730713811
,2.5338667599150168641131131
,2.4634186994394866587754223
,2.3950131632320510455258500
,2.3285935481492905374523161
,2.2641049023268302597955426
,2.2014938801922938615973635
,2.1407086988576811137363620
,2.0816990958594230320954921
,2.0244162882158915905961294
,1.9688129327736199059017963
,1.9148430878150686229588473
,1.8624621759023112232966923
,1.8116269479325552982373893
,1.7622954483830466365645862
,1.7144269817244679465773061
,1.6679820799835887168427462
,1.6229224714375920513020901
,1.5792110504241960722282556
,1.5368118482534982582876637
,1.4956900052093291542121278
,1.4558117436298023683605152
,1.4171443420587723771575384
,1.3796561104617832693719492
,1.3433163665023459820702101
,1.3080954128770214683896711
,1.2739645157121037843950262
,1.2408958840314086025102824
,1.2095294404400860344139801
,1.1785083164352752049808259
,1.1484715712236168716486873
,1.1193950023750669497957233
,1.0912552646174802362111222
,1.0640298561218100026337652
,1.0376971057194781522525773
,1.0122361608289676127014900
,0.9876269758826502487281118
,0.9638503011964820732515591
,0.9408876725494326187515526
,0.9187214022084428943770718
,0.8973345726347371487108262
,0.8767110344398784116393131
,0.8568354101000624778450288
,0.8377078406069871086003786
,0.8192857899132000021324984
,0.8015540805818588410147640
,0.7845322465979026604898650
,0.7681935330961935370908122
,0.7525275098491859271376825
,0.7375245858817569555299087
,0.7231759733403131384932294
,0.7094736304269640969621946
,0.6964101902083186246272817
,0.6832414269616366997439627
,0.6714313412196241115381667
,0.6602395987666388466053036
,0.6496656002579509481265063
,0.6397066373945625716856966
,0.6303609100163076739420376
,0.6216275103582747929564789
,0.6135063972962305767211433
,0.6059983659460062010992942
,0.5998161477799970331403756
,0.5940852358551012013521131
,0.5884184294830464567738204
,0.5833757364091816111084654
,0.5789627191810443607167258
,0.5751857754081093343501152
,0.5720520549887272432343366
,0.5695693404397283998719104
,0.5632526443613281585953700
,0.5628066784185802307050039
,0.5629440149617942479309818
,0.5636823761304501356761421
,0.5650382613794930897199720
,0.5670265092423479869054859
,0.5696597902783647748847784
,0.5729480264756664498193572
,0.5768977099622721871341469
,0.5815111678584813370562756
,0.5867857615419047601079683
,0.5927130472386701320886004
,0.5992779404718077129743392
,0.6064579307621105197512179
,0.6142224006272416492180355
,0.6225321313882780094317582
,0.6313390701053764875183560
,0.6405864445704821941163232
,0.6502092979499708436108563
,0.6601354997107274913403785
,0.6702872630274513410242321
,0.6805831284925764057547326
,0.6909403603125907622484192
,0.7012776077980136246736720
,0.7115176453959948243976896
,0.7215899979025134358678883
,0.7314331975410255370917412
,0.7409964993411617406593450
,0.7502408973383626333841789
,0.7591393717365383375650367
,0.7676763861654186671401590
,0.7758467389050074380918431
,0.7836539362260466212717347
,0.7911082881410448353065590
,0.7982249418159481635370867
,0.8050220335996940423939350
,0.8115190988861676890664398
,0.8177358204349212122963309
,0.8236911384407757941161776
,0.8294026983235887051648660
,0.8348865803393616946692646
,0.8401572393037978203622629
,0.8452275825158128697012216
,0.8501091139054477441305835
,0.8548121900587090093992515
,0.8593460203039140488101566
,0.8637190350137960992427111
,0.8679389075864707425722600
,0.8720126901101180605380137
,0.8759469019027703584612254
,0.8797476000820079189423950
,0.8834204362080684269642461
,0.8869707023403234913416782
,0.8904033690573192050266016
,0.8937231173113040494371262
,0.8969343654724974967962225
,0.9000412925510982153909367
,0.9030478583298920947086685
,0.9059578209628129652486450
,0.9087747524690804601377181
,0.9115020524613463015484172
,0.9135297289167969569945171
,0.9167005664414364929371004
,0.9191778215131506390989102
,0.9215775460074854263936572
,0.9266706577447347825682300
,0.9261550804574228967780414
,0.9283379482267224425129371
,0.9304534139299172057491205
,0.9325037537427121048239087
,0.9344911525463750479048031
,0.9364177086815963502175464
,0.9382854383403333997648588
,0.9400962796911892516149578
,0.9418520968605635923509567
,0.9435546838735259234098862
,0.9452057685586123803034297
,0.9468070162399443434608770
,0.9483600328462047368560661
,0.9498663669919149565856742
,0.9513275107742831249169058
,0.9527448995331039283129826
,0.9541622882919247317090594
,0.9555796770507455351051362
,0.9569970658095663385012131
,0.9584144545683871418972899
,0.9598318433272079452933667
,0.9612492320860287486894435
,0.9626666208448495520855204
,0.9640840096036703554815972
,0.9655013983624911588776740
,0.9669187871213119622737509
,0.9683361758801327656698277
,0.9697535646389535690659045
,0.9711709533977743724619813
,0.9725883421565951758580582
,0.9740057309154159792541350
,0.9754231196742367826502118
,0.9768405084330575860462886
,0.9782578971918783894423655
,0.9796752859506991928384423
,0.9810926747095199962345191
,0.9825100634683407996305959
,0.9839274522271616030266728
,0.9853448409859824064227496
,0.9867622297448032098188264
,0.9881796185036240132149032
,0.9895970072624448166109801
,0.9910143960212656200070569
,0.9924317847800864234031337
,0.9938491735389072267992105
,0.9952665622977280301952874
,0.9966839510565488335913642
,13.8653287994219347467605985
,13.4685439838822880176394392
,13.0826980357265512111553107
,12.7078702734037278787582181
,12.3440300484852709672622950
,11.9910450896348965699189648
,11.6486960646966686283576564
,11.3166950386405691375557581
,10.9947056401535245839795607
,10.6823630122815682597092746
,10.3792919781830761394303408
,10.0851222697521762938777101
,9.7995001129495697966831358
,9.5220959061744920859382546
,9.2526081329918330453665476
,8.9907639856742793682542469
,8.7363174148155522402703355
,8.4884078160605369589575275
,8.2487436199274384307500441
,8.0170176712423000253693317
,7.7882975031836751966807242
,7.5677974837575359146057963
,7.3535504690224220425420754
,7.1453882958220962251516539
,6.9431449196212735586186682
,6.7466565126176201161456447
,6.5557619021408983783771873
,6.3703031255476538774473738
,6.1901259381664965886216123
,6.0150801806459055498521593
,5.8450199750505547058310185
,5.6798037649999875142725614
,5.5192942404935427802570302
,5.3633581948762421021115188
,5.2118663551735391337160763
,5.0646931157943022583367565
,4.9217172077056892121049714
,4.7828195397679840183968736
,4.6478843738592479084559272
,4.5168014064074091251654863
,4.3894614646677885261283336
,4.2657590672319729563355395
,4.1455917445786534258900247
,4.0288599560860385295768538
,3.9154670085397063061805056
,3.8053189764059323074718577
,3.6983246241254312813850902
,3.5943953306883855702835717
,3.4934450152570266645568609
,3.3953900690718024080183568
,3.3001492817617008590502792
,3.2076437775701145405093939
,3.1177969492047408195389835
,3.0305343945824110285514053
,2.9457838554296622568529074
,2.8634751576782293547296376
,2.7835401536063248961738736
,2.7059126656811574029859457
,2.6305284320597492886406599
,2.5573250537060046028159377
,2.4862419430831921296487508
,2.4172202743822546189278455
,2.3502029352479039125967120
,2.2851344799659143447456700
,2.2219610840765855463985190
,2.1606305003808348175198262
,2.1010920163069295441005124
,2.0432964126073707156194814
,1.9871959233569842506739178
,1.9327441972248364798758757
,1.8798962599941380080537101
,1.8286084783058955682832902
,1.7788385246036870768193694
,1.7305453432585184980752047
,1.6836891178543975655657050
,1.6382312396169211865526449
,1.5941342769688728875365769
,1.5513619461986500880357198
,1.5098790832291928420971772
,1.4696516164769866108485985
,1.4306465407927044797276039
,1.3928318924769380604544722
,1.3561767253665419907804335
,1.3206510879897486177014798
,1.2862260017922795274358805
,1.2528734404435828420076859
,1.2205663102424595400918861
,1.1899438380586366825752975
,1.1596525900085123961247291
,1.1303309255623810170021670
,1.1019553086483770965031681
,1.0745030553101841963581364
,1.0479523209059420363331583
,1.0222820880231919815628316
,0.9974721548620881783620007
,0.9735031239758410448459358
,0.9503563915808566076037778
,0.9280141381416741053200781
,0.9064593214894351991262056
,0.8856756741436173641091045
,0.8656615571093632111043803
,0.8463751842455309315482737
,0.8278160207021655336845356
,0.8099709555858156662111469
,0.7928276647930103671058077
,0.7763571510310398604559623
,0.7605834453382357418504967
,0.7454800725153561957725401
,0.7310382318730532791306587
,0.7172498879792748027739435
,0.7033779389807393034317329
,0.6908725632070688016383997
,0.6789972242267652280389711
,0.6677476769982422233340458
,0.6571229063013575011353851
,0.6471202188773247376829545
,0.6377378382061678063763566
,0.6289748856710255520141573
,0.6208313500986750721466478
,0.6140210814014521734094387
,0.6071093250205022995302784
,0.6013709152724915352195012
,0.5957081039411703526909037
,0.5906759649680835000395973
,0.5862799154337194895703078
,0.5825261660711441580318137
,0.5794216295081578982362203
,0.5769737902527749540126933
,0.5703981120664347592708054
,0.5700378725195809348491593
,0.5702611078688142320913812
,0.5710851091614495000925444
,0.5725258247315470061522547
,0.5745974066118424428140088
,0.5773116893827636708635964
,0.5806775978735192467183879
,0.5847004584337136545713065
,0.5893812621677371188511074
,0.5947158707731816651431700
,0.6006941944707905323141972
,0.6072993866205079749320817
,0.6145071033781935865292212
,0.6222848837005927613574841
,0.6305917326628323049675373
,0.6393779795862557513430602
,0.6485854947407900805700365
,0.6581483293225329767039966
,0.6679938262973920126697180
,0.6780442217152499173593583
,0.6882186844966270422574439
,0.6984357308369156802640987
,0.7086158582120046789398771
,0.7186842097680210539323298
,0.7285730790269300261030594
,0.7382240119425483859671999
,0.7475893478970008221295984
,0.7566330609931749551222424
,0.7653308507790402837045463
,0.7736695175574518357208831
,0.7816457365332198925500506
,0.7892644023774120221048634
,0.7965367412537159852448099
,0.8034783962693571313096186
,0.8101076550903499873257374
,0.8164439456795682392709068
,0.8225066689948012932376287
,0.8283143831476157403770344
,0.8338843098743859982846516
,0.8392321058137724998360341
,0.8443718280972097867120851
,0.8493160252655420627831973
,0.8540758832605694905737437
,0.8586614399398085906156552
,0.8630818043830045249720229
,0.8673450553293089448914088
,0.8714587287892447964310350
,0.8754297115712901256046052
,0.8792643737339717047163390
,0.8829686362380846365027764
,0.8865480253654512976524416
,0.8900077170763798228847463
,0.8933525737160042945461669
,0.8965871748353312353785327
,0.8997158434075134270102581
,0.9027426683752142189121059
,0.9056715242254083086947958
,0.9085060881209239269651334
,0.9109949714255947128549451
,0.9135091791846418063371971
,0.9164781452226173907860129
,0.9189688607970432077109990
,0.9213811841549214287638847
,0.9256386658323144667193105
,0.9259815688225401242306134
,0.9281747948274411408320361
,0.9302999718003365225982293
,0.9323594195013785723702426
,0.9343553631265569814345895
,0.9362899383847854695162027
,0.9381651961643325821071926
,0.9399831068524340249581428
,0.9417455644015801929924692
,0.9434543902554922700787188
,0.9451113372213646446340363
,0.9467180932725975939234786
,0.9482762850958810219026418
,0.9497874810292614711215720
,0.9512531929995997614923908
,0.9526748772818858235211792
,0.9540539343997763710447657
,0.9554329915176669185683522
,0.9568120486355574660919387
,0.9581911057534480136155253
,0.9595701628713385611391118
,0.9609492199892291086626983
,0.9623282771071196561862848
,0.9637073342250102037098713
,0.9650863913429007512334579
,0.9664654484607912987570444
,0.9678445055786818462806309
,0.9692235626965723938042174
,0.9706026198144629413278039
,0.9719816769323534888513905
,0.9733607340502440363749770
,0.9747397911681345838985635
,0.9761188482860251314221500
,0.9774979054039156789457365
,0.9788769625218062264693231
,0.9802560196396967739929096
,0.9816350767575873215164961
,0.9830141338754778690400826
,0.9843931909933684165636691
,0.9857722481112589640872557
,0.9871513052291495116108422
,0.9885303623470400591344287
,0.9899094194649306066580152
,0.9912884765828211541816017
,0.9926675337007117017051883
,0.9940465908186022492287748
,0.9954256479364927967523613
,0.9968047050543833442759478
,13.9898552069418595777960945
,13.5895528054577070520281268
,13.2002177481340048359470529
,12.8219524559292210597050143
,12.4547463231861712529280339
,12.0984830941388210590048402
,11.7529549575646505843451450
,11.4178809793613815770640940
,11.0929276061330988056852220
,10.7777292222076539474073797
,10.4719070926634927332088409
,10.1750854434108823909355124
,9.8869038840092944298021393
,9.6070258360434053201970528
,9.3351430543835007824782224
,9.0709766863660288294113343
,8.8142755759558628625427446
,8.5641289618522051796389860
,8.3223803915618486115590713
,8.0887082471668296790312525
,7.8578463341056306035170564
,7.6353859067690041939613366
,7.4192327341582009481157911
,7.2092176758109580703148822
,7.0051736725588842347178797
,6.8069357941721317928340795
,6.6143416677723356755791428
,6.4272320500892714534302286
,6.2454513665829223256764635
,6.0688481124978643777012621
,5.8972750775970181891239008
,5.7305894061964401942077529
,5.5686525327313471933621258
,5.4113300420027421466784290
,5.2584914979255170663918761
,5.1100101781039954929042324
,4.9657636924847343706801439
,4.8256320043290132915103641
,4.6894982103763709346821997
,4.5572511115334437548085589
,4.4287805472590688893319566
,4.3039801001247770528834735
,4.1827463912670665990845009
,4.0649789968189038447121675
,3.9505803657951918950175241
,3.8394557397071973348090523
,3.7315130741820730086999447
,3.6266629628817135255758330
,3.5248185623563546009506808
,3.4258955236636303709474305
,3.3298119175670590763616019
,3.2364881705220511776133208
,3.1458469978519443266407052
,3.0578133399335936104534994
,2.9723143002576568605377361
,2.8892790853004686191241035
,2.8086389461574006176647345
,2.7303271218928131247594138
,2.6542787845633246668342053
,2.5804309858721388160063270
,2.5087226054132365504756308
,2.4390943004655647463607693
,2.3714884572988470523569049
,2.3058491439541506373700486
,2.2421220644638681918081602
,2.1802545144773475271904317
,2.1201953382598790476265549
,2.0618948870343518642300751
,2.0053049786363863482563374
,1.9503788584553491958217819
,1.8970711616352413653174835
,1.8453378765110124426485072
,1.7951363092575298718855947
,1.7464250497300064512984363
,1.6991639384763854714321951
,1.6533140349038495386935210
,1.6088375865833395295112496
,1.5656979996777742325519966
,1.5238598104815250788846015
,1.4832886580605995074932935
,1.4439512579849600459880321
,1.4058153771462360559496574
,1.3688498096561081407429583
,1.3330243538230603927985385
,1.2983097902092048947508829
,1.2646778607757007684142536
,1.2321012491359379925626172
,1.2012149830814231599163122
,1.1706733644419087259080925
,1.1411105996794728145715681
,1.1125029647944661981284753
,1.0848275964130866810819498
,1.0580624789687402831361851
,1.0321864326108123322001120
,1.0071791015547482128766887
,0.9830209427067665428623400
,0.9596932147158895309857485
,0.9371779681189170707611424
,0.9154580378492248593502723
,0.8945301571931036921370151
,0.8743529663677830354728826
,0.8549244339807021697552614
,0.8362305743538643865164772
,0.8182581923327637563048143
,0.8009948868948261191391680
,0.7844290563555043060972594
,0.7685322384223258751489993
,0.7533302555042010739683178
,0.7387969029405638821117464
,0.7249241501252833286272903
,0.7109799501708542468492169
,0.6984044349212088498290996
,0.6864697771100527479148923
,0.6751589809733227198762506
,0.6644844085822176893429969
,0.6544388216918997080995268
,0.6450204619027058994262802
,0.6362284744672701553014349
,0.6280628732836623928648123
,0.6212306466899203405418461
,0.6143096441358939507892956
,0.6085636792336676093029268
,0.6029045343067668261127778
,0.5978824078071403036460651
,0.5935025567873777330163421
,0.5897709893315186135964723
,0.5866943638881838563037263
,0.5842798490593835714079773
,0.5774344275945516580250683
,0.5771585597322319571844673
,0.5774659889735012097133904
,0.5783735485215663052471768
,0.5798966115573425117446504
,0.5820486235621183945809776
,0.5848405685844506596282599
,0.5882803670257277239841187
,0.5923721815477028806995463
,0.5971156809786342112289503
,0.6025052551694524138881093
,0.6085292127116140870057848
,0.6151690079548852718716034
,0.6223985473480712071747689
,0.6301836313171642611763446
,0.6384816146632382727332811
,0.6472413537683019413293550
,0.6564035208375668117852797
,0.6659013428099880282928780
,0.6756618035594864624115985
,0.6856073188041326149644306
,0.6956578207491442844556673
,0.7057331796977901472445183
,0.7157558012162600347139119
,0.7256532085755522665238004
,0.7353604248321302661040022
,0.7448219225550234412480677
,0.7539929978281584288524186
,0.7628404478580728120817867
,0.7713425188214139138764835
,0.7794881732857805722858302
,0.7872758000129471689376714
,0.7947115396902811879087380
,0.8018074194994085912568949
,0.8085794930199268204518148
,0.8150461424064922022481028
,0.8212266564052067563395099
,0.8271401423185781309754816
,0.8328047786628846038681218
,0.8382373750821949798250898
,0.8434531809503433841257447
,0.8484658736221173391811590
,0.8532876602643504337919467
,0.8579294247242088555793771
,0.8624009453484391407585008
,0.8667111043479445164905428
,0.8708677772283092144434136
,0.8748783244212265941541773
,0.8787494743845026823336752
,0.8824874538893304753983671
,0.8860980529639035374600553
,0.8895866772455588433743401
,0.8929583907562610445296514
,0.8962179513821824095032298
,0.8993698407266971228679608
,0.9024182895488153111074325
,0.9053672996751179757879413
,0.9082206630479680020684441
,0.9108229940573122629388081
,0.9134028194075414219810227
,0.9162419808438238000292131
,0.9187470239245134617789290
,0.9211727531663318480070757
,0.9248314858071504662717643
,0.9257974409135675264437282
,0.9280016792649322665553768
,0.9301371782757837936017609
,0.9322063045187993779450153
,0.9342113264245429649079711
,0.9361544197064292083254600
,0.9380376723411599781954351
,0.9398630891516529528573187
,0.9416325960571124698006429
,0.9433480440810435574405801
,0.9450112132208470239191911
,0.9466238162494501340304964
,0.9481875024161299236880041
,0.9497038608547432314566095
,0.9511744233658040448275983
,0.9526006662323868168229524
,0.9539840109640819187930560
,0.9553258243475212241335726
,0.9566676377309605294740891
,0.9580094511143998348146056
,0.9593512644978391401551221
,0.9606930778812784454956386
,0.9620348912647177508361551
,0.9633767046481570561766716
,0.9647185180315963615171881
,0.9660603314150356668577047
,0.9674021447984749721982212
,0.9687439581819142775387377
,0.9700857715653535828792542
,0.9714275849487928882197707
,0.9727693983322321935602872
,0.9741112117156714989008037
,0.9754530250991108042413202
,0.9767948384825501095818368
,0.9781366518659894149223533
,0.9794784652494287202628698
,0.9808202786328680256033863
,0.9821620920163073309439028
,0.9835039053997466362844193
,0.9848457187831859416249358
,0.9861875321666252469654523
,0.9875293455500645523059688
,0.9888711589335038576464854
,0.9902129723169431629870019
,0.9915547857003824683275184
,0.9928965990838217736680349
,0.9942384124672610790085514
,0.9955802258507003843490679
,0.9969220392341396896895844
,14.1124489093911673620596048
,13.7086951969147108343349828
,13.3159324887343757382041076
,12.9342865252095080563776719
,12.5637671581300303103034821
,12.2042746890630731115834351
,11.8556134293669561685646840
,11.5175100481738503788164962
,11.1896343649700700240146034
,10.8716204782041252485669247
,10.5630864647654778565311062
,10.2636513042063484135724138
,9.9729481436709317421218657
,9.6906334903662578739158562
,9.4163923618048954722326016
,9.1499398040608515003668799
,8.8910194736755165934027900
,8.6386689682939667989103327
,8.3948710758654669916722924
,8.1592888668415692876578760
,7.9263135858670805689030203
,7.7019235737309923450766291
,7.4838941268562306774470017
,7.2720551571869540552484068
,7.0662386282397031678215171
,6.8662785468450584502875245
,6.6720113776455534093656752
,6.4832766304821172198558088
,6.2999174299671931720467910
,6.1217809506067109026616890
,5.9487186711283079887380154
,5.7805864555309636187985234
,5.6172445003702549115587317
,5.4585571989730068409585328
,5.3043929689739970356754384
,5.1546239895550121090650464
,5.0091267554828551311629781
,4.8677803212868671067781179
,4.7304666206478405143798227
,4.5970735753009304147553848
,4.4674900536846271492663618
,4.3416087170237647185899732
,4.2193252913462515607534442
,4.1005384833521780763021525
,3.9851498976953463326822202
,3.8730639559546236050380230
,3.7641878175922820481957842
,3.6584313032287520961460814
,3.5557068187292779626318406
,3.4559292865689617002544765
,3.3590160698960085383646401
,3.2648869083088087883481876
,3.1734638503617746962959245
,3.0846711892000731047858153
,2.9984354000879829271752897
,2.9146850797653236497808393
,2.8333508875808712801358524
,2.7543654883574002489865507
,2.6776634969448656065083014
,2.6031814244191657792271144
,2.5308576258850097318031658
,2.4606322498427104505935858
,2.3924471890802179174784214
,2.3262460330532359620292482
,2.2619740217177914942681127
,2.1995780007812424372559690
,2.1390063783391557450386244
,2.0802090828671446764985831
,2.0231375225382550731012543
,1.9677445458380711240664596
,1.9139844034513602277769451
,1.8618127113956202123290495
,1.8111864153785872666446721
,1.7620637563583643192544059
,1.7144042372865244683310948
,1.6681685910162280528368228
,1.6233187493591132444237246
,1.5798178132765337000620320
,1.5376300241925580092328119
,1.4967207364180814543885845
,1.4570563906772999729355433
,1.4186044887296458405501198
,1.3813335690821517687254527
,1.3452131837895151544870487
,1.3102138763429220791323360
,1.2763071606554536874256200
,1.2434655011629585086296856
,1.2116622940738905889190846
,1.1815319607153240699659591
,1.1517321044089323667236613
,1.1228963245592979980358450
,1.0950015810893070078435585
,1.0680256900576057255136675
,1.0419473115659683148948034
,1.0167459380863963502861225
,0.9924018829841085853615823
,0.9688962693244846935414216
,0.9462110195815390811802104
,0.9243288475200576170820455
,0.9032461367694852860665833
,0.8829218696114937703356418
,0.8633537007948900443565776
,0.8445275535350401652223695
,0.8264301487942667945318931
,0.8090490087331335677944821
,0.7923724617272956960434271
,0.7763896489844570591998263
,0.7610905324552454942477198
,0.7464500082306337880311276
,0.7324944188038254866413013
,0.7184793373753457501607045
,0.7058349976836911787714257
,0.6938385595224169088979238
,0.6824714132717072390121871
,0.6717479824575881552917167
,0.6616602922909420314567797
,0.6522065968175172478993318
,0.6433860597121036084544698
,0.6351987149074348470989548
,0.6283450115407813729717645
,0.6214147870691806296861159
,0.6156611784795140707160499
,0.6100053396467243205236741
,0.6049926537894272371431725
,0.6006282041428171458719021
,0.5969177812968230467660646
,0.5938677737219496544085473
,0.5914850175369991136520298
,0.5843594741236444178866805
,0.5841665643146199959900855
,0.5845564409555350504632543
,0.5855454549424561339066031
,0.5871483828284701500521692
,0.5893779463281538788521630
,0.5922442675098211761763878
,0.5957542584165781418548136
,0.5999109236115269805367234
,0.6047126269254301522693140
,0.6101523175964923551006791
,0.6162167499797939207439867
,0.6228857448859869139212719
,0.6301315439548419439219629
,0.6379183138464282754043211
,0.6462018828463108599535758
,0.6549297746286579791075155
,0.6640416155640802564619207
,0.6734699660362530870827413
,0.6831416055726562408523250
,0.6929792714858026281277148
,0.7029037779386663187253248
,0.7128364348550496609746574
,0.7227016001908467268677327
,0.7324291754794202136125136
,0.7419568643862327617100050
,0.7512319736814457860063499
,0.7602126280306515937468248
,0.7688682949755432094463004
,0.7771796027707776888249214
,0.7851375128725532892559613
,0.7927419768131110933140349
,0.8000002517196693752055126
,0.8069250625546680044664072
,0.8135327980630513433624174
,0.8198418860353250403605330
,0.8258714499061060587692396
,0.8316402950594862231170623
,0.8371662247603506301629750
,0.8424656487186171771597287
,0.8475534251123593154630953
,0.8524428686668316101915366
,0.8571458616012073150614015
,0.8616730153710939754674314
,0.8660338170584581662936330
,0.8702368840815892792051045
,0.8742901609815014740689776
,0.8782005631092831832162915
,0.8819747593033152588404278
,0.8856188386968759651551863
,0.8891384653442290231240008
,0.8925389286498928154145460
,0.8958251846689206931984018
,0.8990018904392376164480538
,0.9020734329266254514223533
,0.9050439537315261295802316
,0.9078583586578491404495139
,0.9106002583966983365826309
,0.9132310292001287743701710
,0.9159911842794796754674280
,0.9185114828050894297817308
,0.9209514810306973497944227
,0.9241907399721193128172558
,0.9269016296069525484568885
,0.9278179730961673143951884
,0.9299644457774609573874613
,0.9320438591070224765289254
,0.9340585279468964774451933
,0.9360106709085946885551266
,0.9379024156742634676930948
,0.9397358038847176686658713
,0.9415127956424608202112836
,0.9432352736946499893733176
,0.9449050473835692853796786
,0.9465238564589378844615908
,0.9480933748076483258415692
,0.9496152140537478247850345
,0.9510909268345243416931112
,0.9525220094408706206223769
,0.9539099035315075081342684
,0.9552559968797645906235516
,0.9565616235791407628852312
,0.9578672502785169351469108
,0.9591728769778931074085904
,0.9604785036772692796702700
,0.9617841303766454519319495
,0.9630897570760216241936291
,0.9643953837753977964553087
,0.9657010104747739687169883
,0.9670066371741501409786679
,0.9683122638735263132403475
,0.9696178905729024855020270
,0.9709235172722786577637066
,0.9722291439716548300253862
,0.9735347706710310022870658
,0.9748403973704071745487454
,0.9761460240697833468104250
,0.9774516507691595190721046
,0.9787572774685356913337841
,0.9800629041679118635954637
,0.9813685308672880358571433
,0.9826741575666642081188229
,0.9839797842660403803805025
,0.9852854109654165526421821
,0.9865910376647927249038617
,0.9878966643641688971655412
,0.9892022910635450694272208
,0.9905079177629212416889004
,0.9918135444622974139505800
,0.9931191711616735862122596
,0.9944247978610497584739392
,0.9957304245604259307356187
,0.9970360512598021029972983
,14.2330949026812181301693272
,13.8259565486825177771379458
,13.4298281944291311162942293
,13.0448590587110526684000433
,12.6710798130571831165980257
,12.3084078142655926058068871
,11.9566600643603386799895816
,11.6155714153546814060291581
,11.2848156023859509389239975
,10.9640269078563932225733879
,10.6528205946780225588099711
,10.3508106651292166588973487
,10.0576239702737879611049721
,9.7729101785521432788073071
,9.4963475737636233731109314
,9.2276450546398347540844043
,8.9665410170374144627203350
,8.7120200116841903792419544
,8.4662079718351197499259797
,8.2287518146899252258208435
,7.9936919567821451693134804
,7.7674033828657549349827605
,7.5475277427903399996012013
,7.3338940289293121921332386
,7.1263332636151082155606673
,6.9246784295812000564751543
,6.7287648665396933012061709
,6.5384308713286563019551068
,6.3535182970628989451711277
,6.1738730225607563184553328
,5.9993452371406510437168436
,5.8297895437634847937147242
,5.6650649190080040185080179
,5.5050345819539652225671489
,5.3495658209035816810228425
,5.1985297352180221963635631
,5.0518017097245300206509455
,4.9092599282597824128515640
,4.7707851632900126759295745
,4.6362644733887243830849911
,4.5055857730989510301355949
,4.3786408170668655870372277
,4.2553244505373823969307523
,4.1355345246789578794732734
,4.0191718132796427909170234
,3.9061399310913671456546581
,3.7963452541403257534113891
,3.6896968423698295325152685
,3.5861063629621621196008618
,3.4854880214827921314224568
,3.3877584847851345273284096
,3.2928368166094168500990236
,3.2006444094222548102379733
,3.1111049195089126584434780
,3.0241442039781296635680974
,2.9396902596113405614630665
,2.8576731635041356938131685
,2.7780250154541312745948289
,2.7006798820515420800347783
,2.6255737424296130555489981
,2.5526444356331605689547359
,2.4818316095647379171396096
,2.4130766714694265040463961
,2.3463227399208141932263061
,2.2815145982722651041285644
,2.2185986495391532002940949
,2.1575228726793151956542260
,2.0982367802405086365524767
,2.0406913773452659555118771
,1.9848391219851253541861524
,1.9306338865978267538281443
,1.8780309209026730954406048
,1.8269868159709530264223076
,1.7774594695099052987785626
,1.7294080523404764537787059
,1.6827929760507358558641045
,1.6375758618086093676424753
,1.5937195103193628753501798
,1.5511878729151287181764474
,1.5099460237656836536501714
,1.4699601332015816979037481
,1.4311974421425444070621324
,1.3936262376257817496849611
,1.3572158294310503467983153
,1.3219365278027948029659910
,1.2877596222764244870973016
,1.2546573616270724205179476
,1.2226029349749678587500057
,1.1922266958986103002615664
,1.1621937655603102879098287
,1.1331337210435792339779937
,1.1050233482847597876741474
,1.0778402975178251743670899
,1.0515630711843801936566933
,1.0261710122474521078572707
,1.0016442926270836544233589
,0.9779639017767318698304280
,0.9551116359619068463260305
,0.9330700895033534614242399
,0.9118353050731807796225326
,0.8913665926750653500931776
,0.8716613017692852460882591
,0.8527052650963894420144129
,0.8344851201117302608167847
,0.8169883122615136938904357
,0.8002030997901352638024264
,0.7841185601070037591853179
,0.7687245973758711770074115
,0.7540119515233811853249790
,0.7399588936171657138629598
,0.7258742787734426826773415
,0.7131624059417477345945713
,0.7011053478414828177278650
,0.6896977133144815974574726
,0.6789117044662599242954570
,0.6687826802185365959729779
,0.6592942641294063932377867
,0.6504456327064935816650859
,0.6422368347428867307868927
,0.6353621040790965457389916
,0.6284226528412557577496500
,0.6226612848952615131281618
,0.6170083648882401794466546
,0.6120045228785162549911547
,0.6076546552861548100565869
,0.6039643213060158499772001
,0.6009396247519380729329441
,0.5985870540044252452460682
,0.5911714221761825704959392
,0.5910600057052569633597727
,0.5915305497439043991292351
,0.5925989006826513083581176
,0.5942792194696330243530724
,0.5965834895674900772988281
,0.5995209625592020641349222
,0.6030975413098821347190892
,0.6073150810679592837004748
,0.6121706610964600114854761
,0.6176558241799834370056033
,0.6237558202864283973809734
,0.6304489038423850555403760
,0.6377057371322882861619519
,0.6454889568526305243523211
,0.6537529856621375756731140
,0.6624441496427533326851744
,0.6715011739731119311258567
,0.6808561000816710784278030
,0.6904356454845598234371096
,0.7001629967956078948176923
,0.7099599535797690430527496
,0.7197493357128285085266839
,0.7294574839178173952802808
,0.7390166646799641858578411
,0.7483672054165250164814438
,0.7574591509679662326703919
,0.7662533271949344415574501
,0.7747217241162931422593374
,0.7828471958660686569331233
,0.7906225501367586394607656
,0.7980491623156490410551100
,0.8051352882225463192256143
,0.8118942581601154007131527
,0.8183427298075638400831622
,0.8244991347459430519606371
,0.8303824099086380972067900
,0.8360110535088640659751036
,0.8414024993779919414649271
,0.8465727698021209279843902
,0.8515363474603407922813858
,0.8563062008302322336561474
,0.8608939026951973882972879
,0.8653097927972800418316979
,0.8695631187533870987138584
,0.8736622940577761786684619
,0.8776149082355523267651165
,0.8814282302040483685345862
,0.8851082665984381092627586
,0.8886611466430711647745966
,0.8920924131304105442197283
,0.8954072434364924726324375
,0.8986104894435594792057032
,0.9017067107980157869562277
,0.9046798578647757826942666
,0.9075602916098339800754502
,0.9103368826566653471132895
,0.9131037796728136424206923
,0.9157248034544692716352188
,0.9182613513193350618379895
,0.9207165422338434712656863
,0.9236694038378120419352513
,0.9262639522628489663347295
,0.9276230055606712321392138
,0.9297811474878397985932565
,0.9318714971444975736503125
,0.9338964193162696547645396
,0.9358581786800350688082517
,0.9377589454923063172486764
,0.9396008008109641984617610
,0.9413857412948712921618721
,0.9431156836302898582857779
,0.9447924686489592716043262
,0.9464178652217234422039382
,0.9479935740129378229923418
,0.9495212311376650671235211
,0.9510024116626134560448236
,0.9524386327570971699785218
,0.9538313562051895511118005
,0.9551819900358445858401524
,0.9564918892871429045854370
,0.9577623563684320995292865
,0.9590328234497212944731359
,0.9603032905310104894169854
,0.9615737576122996843608348
,0.9628442246935888793046843
,0.9641146917748780742485337
,0.9653851588561672691923832
,0.9666556259374564641362326
,0.9679260930187456590800821
,0.9691965601000348540239315
,0.9704670271813240489677810
,0.9717374942626132439116304
,0.9730079613439024388554799
,0.9742784284251916337993293
,0.9755488955064808287431788
,0.9768193625877700236870282
,0.9780898296690592186308777
,0.9793602967503484135747271
,0.9806307638316376085185766
,0.9819012309129268034624261
,0.9831716979942159984062755
,0.9844421650755051933501250
,0.9857126321567943882939744
,0.9869830992380835832378239
,0.9882535663193727781816733
,0.9895240334006619731255228
,0.9907945004819511680693722
,0.9920649675632403630132217
,0.9933354346445295579570711
,0.9946059017258187529009206
,0.9958763688071079478447700
,0.9971468358883971427886195
,14.3517809157827382904315527
,13.9413248571406072073841642
,13.5418932899013810811084113
,13.1536590145547602759279471
,12.7766738331477025525373392
,12.4108726115580658699855121
,12.0560855759884955062943845
,11.7120563167409450500144885
,11.3784630132875435037931311
,11.0549405968528748900325809
,10.7411018930774311286313605
,10.4365562039655674908544825
,10.1409242620177533211744958
,9.8538489849352171034979619
,9.5750019383870323963492410
,9.3040858378862658639718575
,9.0408337530722082675538331
,8.7841758642305087789736717
,8.5363849253040058329133899
,8.2970908703988310861632272
,8.0599756042204084849345236
,7.8318196494450091904582223
,7.6101280540751332637228188
,7.3947289172452981276251194
,7.1854523549895823464339628
,6.9821303640534040368947899
,6.7845971964919211671940502
,6.5926899700883208055302021
,6.4062492960692107857312294
,6.2251197829508679859600306
,6.0491503525920125028392249
,5.8781943664613214295400212
,5.7121095992616721659373979
,5.5507581131916898797840076
,5.3940060842669881324695780
,5.2417235508252275621998706
,5.0937844323194809703636565
,4.9500671612772606522412389
,4.8104502703245834993595054
,4.6748203306041693494421452
,4.5430643202120792878417888
,4.4150731020587885566897057
,4.2907406550047761939481461
,4.1699639886585693204779091
,4.0526430595057529870928192
,3.9386806886423126883300938
,3.8279824814504634922229798
,3.7204567494395179849675515
,3.6160144337173978357213855
,3.5145690341226738517832473
,3.4160365327723991590858077
,3.3203353286009389400135206
,3.2273861687199016934357587
,3.1371120829763068371676127
,3.0494383204423280986361533
,2.9642922877655819569042706
,2.8816034893266393446253915
,2.8013034691575171564181801
,2.7233257545771345498053506
,2.6476058015006911361410857
,2.5740809413809104810866302
,2.5026903297403593207093309
,2.4333748962555881156788473
,2.3660772963552973990886130
,2.3007418642964188038035900
,2.2373145676835028972107011
,2.1757429633983997874224769
,2.1159761549088149656938640
,2.0579647509258882642768640
,2.0016608253825753926946618
,1.9470178787062097924831505
,1.8939908003602958785904775
,1.8425358326322036628397427
,1.7926105356451618177970886
,1.7441737535745764908767796
,1.6971855820504704315254685
,1.6516073367295369678231509
,1.6074015230221039285396500
,1.5645318069611973132992944
,1.5229629872027334869244442
,1.4826609681478191138381817
,1.4435927341798446832399350
,1.4057263250107439045422097
,1.3690308121327359192065387
,1.3334762763751728531502749
,1.2990337865725978261366436
,1.2656753793616994929749353
,1.2333740401416066756468126
,1.2021036852497093416758389
,1.1724941480876114319187309
,1.1432137221560676465514916
,1.1148914676303287585312773
,1.0875048714686295081577327
,1.0610322808359293755842145
,1.0354528914135101569371500
,1.0107467357615742553633709
,0.9868946716809658958879936
,0.9638783710715105312871742
,0.9416803105285074249053423
,0.9202962004876633628214222
,0.8996856644315359696761902
,0.8798457550075762245711530
,0.8607622151132663379513588
,0.8424215990750787419472090
,0.8248112757318823984320488
,0.8079194330133033785656949
,0.7917350840348197360540894
,0.7762480743409483352479583
,0.7614490904976870533360511
,0.7473296698616438415996299
,0.7331631461664565030389440
,0.7203850085832611549463422
,0.7082684656088741315116408
,0.6968081649971569202506316
,0.6859738480097286039693927
,0.6758042337396682475159082
,0.6662816860413933728324309
,0.6574053885517092687962304
,0.6491753996328948339566978
,0.6422800611689781780100361
,0.6353313527984372210966058
,0.6295620865721266445902415
,0.6239116756504746730271904
,0.6189160606930318442309158
,0.6145799391127266808609875
,0.6109086257618271398328602
,0.6079079262419007090301193
,0.6055839672552777441794092
,0.5978687188724709500320387
,0.5978372873915397400779170
,0.5983866928766069515077675
,0.5995322572400211269538772
,0.6012875092718710234862556
,0.6036636823106587002030210
,0.6066691517224880314529400
,0.6103088132539974397516858
,0.6145833845164957454088039
,0.6194886834097894645623228
,0.6250148828963821845405846
,0.6311457803384059594975497
,0.6378581320360781070633038
,0.6451211063143524881979829
,0.6528959121384845243341033
,0.6611356840094759768078347
,0.6697856799887244028113287
,0.6787838608830458753118364
,0.6880618866932814992054546
,0.6975465432024542389299882
,0.7071615805267138510359359
,0.7168298729204712893547935
,0.7264758067449896827838529
,0.7360277235447149069003103
,0.7454202316761548985368790
,0.7545962191159889531633098
,0.7635083702827430984783064
,0.7721200865603510266055309
,0.7804057380217458428361965
,0.7883502568812272848219891
,0.7959481547532486489515691
,0.8032021031113043552096542
,0.8101212496120815398370496
,0.8167194472356625878362024
,0.8230135644575982123427593
,0.8290220009520631316846107
,0.8347634901806195717455239
,0.8402562204473534857029904
,0.8455172631224096013724534
,0.8505622657574671841018699
,0.8554053507923787824651640
,0.8600591560796615464568049
,0.8645349596095668331940942
,0.8688428424184977405531072
,0.8729918241861985839236127
,0.8769901236048812664947150
,0.8808451546659713526921109
,0.8845637105232274643995538
,0.8881520245840308636076088
,0.8916158228405094421376020
,0.8949603490020895391054978
,0.8981903590120887681536033
,0.9013100787600257790543878
,0.9043231163610628842164374
,0.9072323191369188188915018
,0.9100395665108469422932558
,0.9128022556687720445722789
,0.9154418179600632976544716
,0.9179956805613520565145791
,0.9204670534602096276799443
,0.9232303703329265420762795
,0.9257451315016202997298933
,0.9274160603522830781386688
,0.9295866144030194844205539
,0.9316885933848213507957325
,0.9337244158200720400841988
,0.9356963959107357231559376
,0.9376067496267738166082495
,0.9394576002888388455147606
,0.9412509836947234864723555
,0.9429888528342549314231746
,0.9446730822421953721601540
,0.9463054720534412878052422
,0.9478877518405166568982168
,0.9494215843097300044917120
,0.9509085688857378260152586
,0.9523502451158097903416433
,0.9537480957028311445711211
,0.9551035489018619983880853
,0.9564179800815755250198436
,0.9576927125175233035392353
,0.9589290179095593114055873
,0.9601653233015953192719394
,0.9614016286936313271382915
,0.9626379340856673350046435
,0.9638742394777033428709956
,0.9651105448697393507373476
,0.9663468502617753586036997
,0.9675831556538113664700518
,0.9688194610458473743364038
,0.9700557664378833822027559
,0.9712920718299193900691080
,0.9725283772219553979354600
,0.9737646826139914058018121
,0.9750009880060274136681642
,0.9762372933980634215345162
,0.9774735987900994294008683
,0.9787099041821354372672204
,0.9799462095741714451335724
,0.9811825149662074529999245
,0.9824188203582434608662766
,0.9836551257502794687326286
,0.9848914311423154765989807
,0.9861277365343514844653328
,0.9873640419263874923316848
,0.9886003473184235001980369
,0.9898366527104595080643890
,0.9910729581024955159307410
,0.9923092634945315237970931
,0.9935455688865675316634452
,0.9947818742786035395297972
,0.9960181796706395473961493
,0.9972544850626755552625013
,14.4684973212183365376404254
,14.0547906407872869039010766
,13.6521186079857024253669806
,13.2606776548280027583359697
,12.8805409742824803487337704
,12.5116613512071150893234517
,12.1538827341889668076646558
,11.8069579816514895753698511
,11.4705702303075209869120954
,11.1443555182900020383840456
,10.8279246114252920563103544
,10.5208823948472449671953655
,10.2228436700127289782358275
,9.9334447035258612856978289
,9.6523503700159150042736655
,9.3792571759951233190122366
,9.1138928072146434544720250
,8.8560130791124205273945336
,8.6047706591798380770796939
,8.3618428125398160943859693
,8.1251600920970989960778752
,7.8951680548193543529578164
,7.6716908597576081163538220
,7.4545557374606934430971705
,7.2435919312592522700811060
,7.0386304892081072992482405
,6.8395046126153005161540932
,6.6460502741363791656681315
,6.4581068729104202930102474
,6.2755177728202564679804709
,6.0981306505012620178263205
,5.9257976457163641370584628
,5.7583753495713887460283331
,5.5957246848706532205142139
,5.4377107324694708978540802
,5.2842025452964112020026732
,5.1350728149089324148235391
,4.9901992225689566495816507
,4.8494592158784097790658052
,4.7127384904699169965169858
,4.5799231057381817322493589
,4.4509030477569240247248672
,4.3255714434553196312549517
,4.2038244749064057614873491
,4.0855612949073298878488458
,3.9706839441179728744657496
,3.8590972701157908453239997
,3.7507088486118909109734432
,3.6454289062508036245446874
,3.5431702494108954226703645
,3.4438481867252082047059503
,3.3473804634140589264745813
,3.2536871920049397211016640
,3.1626907863650615126971388
,3.0743158976844360275038071
,2.9884893523355171573996358
,2.9051400915548426517887037
,2.8241991128999144322619941
,2.7455994134371044523845740
,2.6692759346172505452443602
,2.5951655087966565282897591
,2.5232068073623974413521864
,2.4533402904223660101479254
,2.3855081580220147685622578
,2.3196543028513798567757931
,2.2557242644075321535979128
,2.1936651845791916848327219
,2.1334257646218577342267508
,2.0749562234933818238857839
,2.0182082575215374298238658
,1.9631350013767976392387027
,1.9096909903251484408315264
,1.8578321237374786356610912
,1.8075156298337398119713271
,1.7587000316418062162426850
,1.7113451141526359045030858
,1.6654118926551291224313900
,1.6208625822358424528601972
,1.5776605684305760046726164
,1.5357703790167582802439483
,1.4951576569374174230375729
,1.4557891343492328495301535
,1.4176326077887329013549333
,1.3806569144524447612099038
,1.3448319095898393360499767
,1.3101284450141799098332740
,1.2765183487480429302962648
,1.2439744058380646229977629
,1.2124703403933436707262672
,1.1826320487346795307104230
,1.1531351234530864413585505
,1.1246047324686889723466265
,1.0970182020105438969181932
,1.0703537263458022810169723
,1.0445903560935838605416848
,1.0197079865289084832369326
,0.9956873457466348664723910
,0.9725099831116555959553693
,0.9501582592052968401219459
,0.9286275609527036012380563
,0.9078778112062062533027529
,0.8879057741697599093200211
,0.8686971035321900957981711
,0.8502382708743787542715609
,0.8325165685433365547751805
,0.8155201139829735268449440
,0.7992378555368757631072185
,0.7836595793219488514935733
,0.7687759173790364997103097
,0.7545783569089443698629793
,0.7403445001121862212301039
,0.7275013440611536319480024
,0.7153264271538686269735763
,0.7038144377949603347488505
,0.6929604577029682133115784
,0.6827233949768611864783452
,0.6731672808316255807170592
,0.6642637210922506252330777
,0.6567067473736475369250343
,0.6490972232627117977088460
,0.6421392052955789964130418
,0.6363618822915741990442484
,0.6307135524857799824260951
,0.6257255324584227729189934
,0.6214023092369499456921744
,0.6177489413395507167336973
,0.6147709237179862507005623
,0.6124740087567369650756177
,0.6044500765797956587377371
,0.6044970851597829542001250
,0.6051235272386744634687261
,0.6063441824521700329597707
,0.6081719332183664894486697
,0.6106172533663491996946959
,0.6136876389119559904727907
,0.6173869831897949023158390
,0.6217148804498144887276112
,0.6266659128460103644897572
,0.6322289221952827054096247
,0.6383863064820677335475807
,0.6451133927126562195297765
,0.6523779400466271916059213
,0.6601398298583666113259483
,0.6683510220903675635995000
,0.6769558304915852531280507
,0.6858915803696119528609643
,0.6950896778830211175659315
,0.7044770957360013685644162
,0.7139782490001121972866827
,0.7235171628200155469201604
,0.7330198341052386323823953
,0.7424166124405604527680680
,0.7516444167219471506058426
,0.7606486273622925509130255
,0.7693844686553424905284260
,0.7778177943393611570854773
,0.7859252179170618246573099
,0.7936936102195146780502455
,0.8011190543661379503959097
,0.8082054005707010047032668
,0.8149625914722578023940969
,0.8214049289041813750600340
,0.8275494412069762661943173
,0.8334144658367050872982418
,0.8390185194342929531075015
,0.8443794797461635637247923
,0.8495140635412332663634061
,0.8544375563667294670722185
,0.8591637352005320193981674
,0.8637049221474961679945181
,0.8680721142239712362353998
,0.8722751459805045959328140
,0.8763228199953095876040265
,0.8802231686875993110774630
,0.8839834383758629066107915
,0.8876102737335825887399210
,0.8911097747331564455919306
,0.8944875468770302484600165
,0.8977487253810563228029196
,0.9008979701924588745498568
,0.9039394262215717512631841
,0.9068766410913543518645952
,0.9097124319037572792723267
,0.9124817986677091763425551
,0.9151411331998353659855638
,0.9177134535855435704121419
,0.9202020688611148857560806
,0.9228449523849148183884950
,0.9253081732693838601377934
,0.9271963720931846175687951
,0.9293801321182622032779364
,0.9314944805215790157859601
,0.9335418937306961817412798
,0.9355247392505314785182691
,0.9374452821932245383251825
,0.9393056912544692771405153
,0.9411080441948080910208319
,0.9428543328746956664332401
,0.9445464678881684283950904
,0.9461862828450642304289886
,0.9477755383652277654249474
,0.9493159258605782246931426
,0.9508090711729458854861718
,0.9522565380863767803276687
,0.9536598316375569650560351
,0.9550204010379966801380647
,0.9563396419667085091020908
,0.9576188980763784552863171
,0.9588594618244991041322578
,0.9600625751425710951991732
,0.9612656884606430862660886
,0.9624688017787150773330040
,0.9636719150967870683999195
,0.9648750284148590594668349
,0.9660781417329310505337503
,0.9672812550510030416006657
,0.9684843683690750326675811
,0.9696874816871470237344965
,0.9708905950052190148014120
,0.9720937083232910058683274
,0.9732968216413629969352428
,0.9744999349594349880021582
,0.9757030482775069790690736
,0.9769061615955789701359890
,0.9781092749136509612029045
,0.9793123882317229522698199
,0.9805155015497949433367353
,0.9817186148678669344036507
,0.9829217281859389254705661
,0.9841248415040109165374815
,0.9853279548220829076043970
,0.9865310681401548986713124
,0.9877341814582268897382278
,0.9889372947762988808051432
,0.9901404080943708718720586
,0.9913435214124428629389740
,0.9925466347305148540058894
,0.9937497480485868450728049
,0.9949528613666588361397203
,0.9961559746847308272066357
,0.9973590880028028182735511
,14.5832370418129091405035069
,14.1663468529259901629302476
,13.7604973068788769552384110
,13.3659084660855160819892262
,12.9826751258336923200431556
,12.6107683562736028193285165
,12.2500462907991582994782220
,11.9002715591125109995118692
,11.5611327507976273665235567
,11.2322674605265380165519673
,10.9132847708699927125053364
,10.6037854384287246745088851
,10.3033785299579303540440378
,10.0116937713864118109086121
,9.7283893844171149822841471
,9.4531556507017544532800457
,9.1857148223682774101916948
,8.9258182578925797656665964
,8.6725737110303828814039662
,8.4277802847331351188131521
,8.1910379792857259673155568
,7.9574455942342847691861607
,7.7322132351342078848688288
,7.5133716447727341147810876
,7.3007492260475563838895141
,7.0941761147402822018648294
,6.8934844978761447009674157
,6.6985092368105698668045989
,6.5090885485203315852231754
,6.3250645781553007651609732
,6.1462837796136557955151147
,5.9725970909532204444758463
,5.8038599381191442461158658
,5.6399321221114648849948026
,5.4806776458145476382810557
,5.3259645249070084460640828
,5.1756644470577484185014328
,5.0296541475792766462404870
,4.8878100841292644318514249
,4.7500170840761359869475200
,4.6161603061284894877758234
,4.4861288744598839528521239
,4.3598150785582943100848752
,4.2371142870213640563292756
,4.1179248626060225291212191
,4.0021480787887178109940578
,3.8896880382129146447311996
,3.7804515932919748877338861
,3.6743482683444890213309009
,3.5712901880862246706271890
,3.4711919991116459982549713
,3.3739708040449163384266740
,3.2795460916254657313118059
,3.1878396702232922876873999
,3.0987756033238409436592065
,3.0122801469053235301487348
,2.9282816886525440125410569
,2.8467106889599955721337210
,2.7674996236797553272879213
,2.6905829285706093223495827
,2.6158969454058831338727487
,2.5433798696985454590446807
,2.4729717000037760854525004
,2.4046141887606529152776602
,2.3382507946362656170435912
,2.2738266363371515410563006
,2.2112884478545722366504833
,2.1505845351116872343766317
,2.0916647339824030460420090
,2.0344803696531919001699862
,1.9789842173009135617434140
,1.9251304640612831864387999
,1.8728746722643430100418982
,1.8221737439149872095356386
,1.7729858863982914662926760
,1.7252705793911431442211324
,1.6789885429633935043369775
,1.6341017068535621525882107
,1.5905731809059830972330474
,1.5483672266581396392837178
,1.5074492300688306922751281
,1.4677856753794418231962027
,1.4293441201020860020776126
,1.3920931711299104893697631
,1.3560024619675796753170971
,1.3210426310859528786778583
,1.2871853014166727557920922
,1.2544030610209857545811474
,1.2226694449892097082965847
,1.1926064883658933357679643
,1.1628969406632727601191846
,1.1341621525659817404374508
,1.1063792921168882354976404
,1.0795264030587452541709581
,1.0535823931600967195976182
,1.0285270224746316802821866
,1.0043408913250251313087347
,0.9810054283594653590228063
,0.9585028798486397993983132
,0.9368283179205350030827049
,0.9159419508563995115935086
,0.8958402626680024294358873
,0.8765088184750819966239987
,0.8579340075044673552540075
,0.8401030457388635186433135
,0.8230039799823066770656510
,0.8066256933510705939838203
,0.7909579117556122529464346
,0.7759912115851084202233778
,0.7617170283839110878076895
,0.7474269749355429981463317
,0.7345101351267950828827225
,0.7222779322954678837831466
,0.7107152065412805086452863
,0.6998170716815500513874326
,0.6895387946164253101244412
,0.6799496574631463952087529
,0.6710192174051471392104418
,0.6634368043956975213859550
,0.6558121287697059598187366
,0.6488447298886422798247509
,0.6430591755093334471737876
,0.6374124846112882991633342
,0.6324314164407297544912012
,0.6281202370773415477600565
,0.6244837376662469852206527
,0.6215270911783553620111320
,0.6192556643185744835733431
,0.6109144610958505694497944
,0.6110383348705171746573228
,0.6117399763274492530129578
,0.6130336071389107521767414
,0.6149314513820290928336476
,0.6174432163452349131560482
,0.6205755179803099652602327
,0.6243312543327421693106771
,0.6287089128782371583170629
,0.6337018677104043762327024
,0.6392976698220005360440155
,0.6454773720485116328404729
,0.6522149410348166975737172
,0.6594768104908936834362976
,0.6672216318073502794305796
,0.6754002997384638273814517
,0.6839563013426133153416231
,0.6928264473231889875037837
,0.7019420078531638518271052
,0.7112302500813916239508217
,0.7206163435239615333571805
,0.7300255283823492424843948
,0.7393854449674149842408610
,0.7486284486618646205613459
,0.7576937306838299468481068
,0.7665290920550644759856596
,0.7750921969990949289552873
,0.7833512315629689304330441
,0.7912849220839663910709305
,0.7988819467306902399883484
,0.8061398371311366828351197
,0.8130635146048397210449821
,0.8196636290807980396166954
,0.8259548653982701216236251
,0.8319543672400764311447574
,0.8376803842454154658270227
,0.8431512059879060494438363
,0.8483844007351299953967327
,0.8533963391805655662736285
,0.8582019575276347289616297
,0.8628147015570071243217853
,0.8672465917779519362085239
,0.8715083572744777296037455
,0.8756095975974061973445828
,0.8795589452723832080138777
,0.8833641438603168083432138
,0.8870323899891344732182574
,0.8905701493069325680451698
,0.8939833940510503174081691
,0.8972776146315308842815739
,0.9004578432064334059248267
,0.9035286496009191647971193
,0.9064941045410713771346423
,0.9093577034477939857737283
,0.9121411406656250164814992
,0.9148215738821570131023009
,0.9174135795881949162478008
,0.9199205748311397590200045
,0.9224914042185161644482605
,0.9249244872902778746848185
,0.9269631224741006203515781
,0.9291609373172006192120875
,0.9312884459872082798526094
,0.9333481873823897823072571
,0.9353425864402351574966588
,0.9372739611590644726035748
,0.9391445290086862796030687
,0.9409564127991372206594178
,0.9427116460646536300060916
,0.9444121780110418251652504
,0.9460598780713955768817414
,0.9476565401202847738204582
,0.9492038864087164462546298
,0.9507035712915262726241394
,0.9521571848070656818308066
,0.9535662561180231477919733
,0.9549322567311642195875265
,0.9562566033157392508812222
,0.9575406599030472643008238
,0.9587857393489033208666683
,0.9599931042092089139572408
,0.9611639675556759021546327
,0.9623348309021428903520246
,0.9635056942486098785494164
,0.9646765575950768667468083
,0.9658474209415438549442001
,0.9670182842880108431415920
,0.9681891476344778313389838
,0.9693600109809448195363757
,0.9705308743274118077337675
,0.9717017376738787959311594
,0.9728726010203457841285513
,0.9740434643668127723259431
,0.9752143277132797605233350
,0.9763851910597467487207268
,0.9775560544062137369181187
,0.9787269177526807251155105
,0.9798977810991477133129024
,0.9810686444456147015102943
,0.9822395077920816897076861
,0.9834103711385486779050780
,0.9845812344850156661024698
,0.9857520978314826542998617
,0.9869229611779496424972535
,0.9880938245244166306946454
,0.9892646878708836188920372
,0.9904355512173506070894291
,0.9916064145638175952868210
,0.9927772779102845834842128
,0.9939481412567515716816047
,0.9951190046032185598789965
,0.9962898679496855480763884
,0.9974607312961525362737802
,14.6959954543696529327689859
,14.2759887914694498789458521
,13.8670247847320347034383303
,13.4693470775300330188883891
,13.0830722314369598535677142
,12.7081899252142669354270765
,12.3445729034666591417135351
,11.9919940427810285399345958
,11.6501478626621555179099232
,11.3186739539722669434240743
,10.9971800901356129287478325
,10.6852631910728739228488848
,10.3825267928311095744220438
,10.0885942010070124297271832
,9.8031170329844474764513507
,9.5257793393909082624304574
,9.2562978969501870096792118
,8.9944195484170474941265638
,8.7392060003080249686036041
,8.4925813652853658908270518
,8.2541279179564988055517460
,8.0186505237325036432594061
,7.7916934801839676794088518
,7.5711749841476878586377097
,7.3569226290122511358049451
,7.1487656737642888415962261
,6.9465353270900136450904938
,6.7500653726976596047393286
,6.5591928753866604040467791
,6.3737587876556363042368503
,6.1936083633643832513371308
,6.0185913590536781470063943
,5.8485620540816949386453416
,5.6833791453201412124940362
,5.5229055749181465984065653
,5.3670083383137798804796148
,5.2155581368912038442431367
,5.0684305977531938225411068
,4.9255017366825617486369993
,4.7866549983781778720981492
,4.6517748327635990435169333
,4.5207495170689711017075751
,4.3934705178511777035055275
,4.2698324043118578430267007
,4.1497327628343105843100602
,4.0330721129816549108682011
,3.9197538253507517858054143
,3.8096840415735786500306403
,3.7027715957955158465608747
,3.5989279428817435579901485
,3.4980670788477064014898588
,3.4001054748525900706113134
,3.3049620066564804332642780
,3.2125578876268510164493364
,3.1228166037336704263793763
,3.0356638504527251321007952
,2.9510274715197022388224468
,2.8688373994873312966547019
,2.7890255980408187319596891
,2.7115260060278325582316938
,2.6362744831602107353774045
,2.5632087573457220663897260
,2.4922683736097530626807384
,2.4233946445683134385262747
,2.3565306024153969133294595
,2.2916209523893531496696596
,2.2286120276844973986385412
,2.1674517457758675220702571
,2.1080895661265963703101534
,2.0504764492490537008961837
,1.9945648170925507347561734
,1.9403085147320857650754533
,1.8876627733343105397523232
,1.8365841743785900064267480
,1.7870306151127763882868749
,1.7389612752250236393791738
,1.6923365847147311402665082
,1.6471181929475098293380597
,1.6032689388809009400915784
,1.5607528224494346957840207
,1.5195349770995165705755880
,1.4795816434661948068907122
,1.4408601441852673108456884
,1.4033388598354943344048706
,1.3669872060081051934332663
,1.3317756115064185440388655
,1.2976754976900592986055472
,1.2646592589976415332841952
,1.2327002447059143275254200
,1.2017727420015633654770681
,1.1724984019515634070529586
,1.1435629465616585775933345
,1.1155873502621291848413421
,1.0885495086385901242209684
,1.0624281888122688588538267
,1.0372030176684998714620178
,1.0128544696787040724217377
,0.9893638545797537320325432
,0.9667133060260320043255433
,0.9448975900315876863544418
,0.9238771865671481231530038
,0.9036483075744591308975373
,0.8841964302511811091278560
,0.8655078618726418371309705
,0.8475697422001577940875450
,0.8303700472643559260532697
,0.8138975945257282962330692
,0.7981420489439985388457899
,0.7830939301737971369732350
,0.7687446206568251394486424
,0.7543902678928621208243044
,0.7414135032325087637516958
,0.7291218606989567918574835
,0.7175093274635305773401228
,0.7065678323419245510095266
,0.6962927915241909904153772
,0.6866276098148674789101165
,0.6776706519007239526430908
,0.6700632507774124668742388
,0.6624235080135001396683947
,0.6554466411076802501156635
,0.6496526679131308101844411
,0.6440071632081315611273453
,0.6390323969432893935760376
,0.6347324045016156102150262
,0.6311116995596031120641101
,0.6281751228651951679538001
,0.6259276453313762367258732
,0.6172610794945829759683420
,0.6174602198918865969545777
,0.6182352171825072906230503
,0.6195997214285342558071079
,0.6215652885405760219583726
,0.6241408544516190426421076
,0.6273321565757111750727404
,0.6311411069822790986805217
,0.6355651049950865605353556
,0.6405963460747967630481980
,0.6462211319851097757194225
,0.6524192252359178878506896
,0.6591633007206547656409157
,0.6664185489248238836168525
,0.6741424859629630006452317
,0.6822850462665281945362494
,0.6907890016020455936640587
,0.6995907610373079954513287
,0.7086215671687035033698976
,0.7178090785194246592482159
,0.7270792973697073335870300
,0.7363587321327619283906074
,0.7455766893519740756701708
,0.7546675197645672517055004
,0.7635726430284918153645890
,0.7722422063069344089214496
,0.7806362143709409950886879
,0.7887250691310137007405956
,0.7964894853128900997774053
,0.8039198251093356839547255
,0.8110149545832135986600520
,0.8177807675459227709779952
,0.8242285419002373103580794
,0.8303732868323423499390401
,0.8362322225373132189574221
,0.8418234893562622778162563
,0.8471651421995786135354933
,0.8522744423533198387943344
,0.8571674234430514127680567
,0.8618586848334617300793070
,0.8663613548424639043687989
,0.8706871658345096687270370
,0.8748465912699344704250848
,0.8788490065033465192811946
,0.8827028479376236580478121
,0.8864156847529134353180780
,0.8899945638918230761404971
,0.8934458135972042081007771
,0.8967752837560887257950526
,0.8999883547763974922517605
,0.9030899608573714765213936
,0.9060845871585755384458594
,0.9089762364479444523013285
,0.9117789170711031454530371
,0.9144818767593265729232144
,0.9170948874414447393732530
,0.9196214842239518461042280
,0.9221535315659012965738839
,0.9245724108884535441532648
,0.9267154360186308226232654
,0.9289282139290765405448269
,0.9310697284568676401761422
,0.9331425859829999280847801
,0.9351492734000873552346889
,0.9370921656850190739618256
,0.9389735327932255959382246
,0.9407955459549269816577066
,0.9425602834405711893950297
,0.9442697358513377769995145
,0.9459258109823189819564959
,0.9475303383033610860053386
,0.9490850731076920787643303
,0.9505917003892901950834471
,0.9520518385163913022140036
,0.9534670427534134296010393
,0.9548388086314073541771563
,0.9561685750805098971127904
,0.9574577271514048693035193
,0.9587075981316277584198815
,0.9599194709742131514929042
,0.9610945792223090089478887
,0.9622341079648810691082872
,0.9633736367074531292686856
,0.9645131654500251894290841
,0.9656526941925972495894825
,0.9667922229351693097498810
,0.9679317516777413699102794
,0.9690712804203134300706779
,0.9702108091628854902310763
,0.9713503379054575503914748
,0.9724898666480296105518732
,0.9736293953906016707122717
,0.9747689241331737308726701
,0.9759084528757457910330686
,0.9770479816183178511934670
,0.9781875103608899113538655
,0.9793270391034619715142640
,0.9804665678460340316746624
,0.9816060965886060918350609
,0.9827456253311781519954593
,0.9838851540737502121558578
,0.9850246828163222723162562
,0.9861642115588943324766547
,0.9873037403014663926370531
,0.9884432690440384527974516
,0.9895827977866105129578500
,0.9907223265291825731182485
,0.9918618552717546332786469
,0.9930013840143266934390454
,0.9941409127568987535994438
,0.9952804414994708137598423
,0.9964199702420428739202407
,0.9975594989846149340806392
,14.8067702909098546371069460
,14.3837140064371507008900153
,13.9716985921430190131786730
,13.5709911773436289195160498
,13.1817302081775746813718797
,12.8039242531490042864561474
,12.4374610584469404983565255
,12.0821241949364921453025090
,11.7376145693945073134045742
,11.4035741971702417885126124
,11.0796099127554406038598245
,10.7653150934016164086415301
,10.4602879549412133286523385
,10.1641455120315473692471642
,9.8765328362723359134633938
,9.5971277505234500182496049
,9.3256415222446076285223171
,9.0618164255759001690648802
,8.8046670521528547226353112
,8.5562455113144331164676260
,8.3161156372849749374154271
,8.0787823064234611791789575
,7.8501310673900244196943277
,7.6279652396273558423445138
,7.4121116365803851877558373
,7.2023986749301531773426177
,6.9986566203790294693476426
,6.8007182123958722641532404
,6.6084193935850068513104816
,6.4215999500068212668679735
,6.2401039583571824564955932
,6.0637800140084960887065790
,5.8924812684227543257975412
,5.7260653320882912709066659
,5.5643941036850010917191867
,5.4073335754258708973907233
,5.2547534800745232530516660
,5.1065285129045134837610931
,4.9625345331097898693428760
,4.8226518441081971388939564
,4.6867663007691016119338201
,4.5547645947819574985260260
,4.4265373842865010090008582
,4.3019784531713547437448142
,4.1809846251159656915774576
,4.0634556790429572359357735
,3.9492942663923256141345064
,3.8384058305330648330766508
,3.7306985285844054267556658
,3.6260831543967935175487582
,3.5244730678451801075823369
,3.4257841187634401336481460
,3.3299345807418143650124875
,3.2368450826404537856717525
,3.1464385431032435569420613
,3.0586401069953921272315256
,2.9733770837058868252711363
,2.8905788872664679445279035
,2.8101769782421950338857641
,2.7321048073495810548649843
,2.6562977607592634932132114
,2.5826931070412499913402371
,2.5112299457123379298195687
,2.4418491573468039668171059
,2.3744933552131808340845964
,2.3091068384014761250000447
,2.2456355464068535887633971
,2.1840270151374392426646409
,2.1242303343155164441213856
,2.0661961062430309610249424
,2.0098764059040359342134252
,1.9552247423783370994243569
,1.9021960215423494577891006
,1.8507465100348925446382964
,1.8008338004673491994367396
,1.7524167778594081923415615
,1.7054555872832952712059296
,1.6599116027012719154498654
,1.6157473969829347915094786
,1.5729267130907957916718942
,1.5314144364244122176188512
,1.4911765683149329486667511
,1.4521802006631989723217657
,1.4143934917156553154882204
,1.3777856429743791100150929
,1.3423268772428156303533342
,1.3079884178202980660188359
,1.2747424688784800839158606
,1.2425621970789575421179052
,1.2114217145131627173526567
,1.1819389399736486279124392
,1.1528065342071269760992891
,1.1246417828371557678934778
,1.0974224356526072199358168
,1.0711271213220137088484307
,1.0457353356044252201684230
,1.0212274290280947131037692
,0.9975845942109241581974288
,0.9747888538756009912944478
,0.9528346765575543830806282
,0.9316828004104776850269332
,0.9113291732887156548770236
,0.8917591851243471534615992
,0.8729590616572561190267265
,0.8549158665886067431927131
,0.8376175050661455179223935
,0.8210527284970147166021093
,0.8052111401849456617796363
,0.7900832020157948498706446
,0.7756602419424492023125595
,0.7612428668376063356504346
,0.7482046123847476692958480
,0.7358508674917522141001314
,0.7241958321874415460683849
,0.7132117476770964970000932
,0.7029004447363862428943548
,0.6932001105932068529824619
,0.6842169800968177506561574
,0.6765850174358311042155378
,0.6689302768419592704063348
,0.6619438418778584853896518
,0.6561412526244810861086876
,0.6504964743616649114343886
,0.6455273569430168834060169
,0.6412376961120613838573945
,0.6376317189104884208816770
,0.6347139246872672835309004
,0.6324888796664064338770572
,0.6234893677519167676237544
,0.6237621583127616053943143
,0.6246086671057307082577381
,0.6260419608969105542684019
,0.6280729196411367620811461
,0.6307097051772218021525873
,0.6339571799694315723527893
,0.6378162813940488895525505
,0.6422833410166346457259579
,0.6473494065285633203288285
,0.6529995729912032587094473
,0.6592123676403305321258586
,0.6659592415330372050519259
,0.6732042223131903257993258
,0.6809037823308297099345054
,0.6890069958538479477638816
,0.6974560244705648726082359
,0.7061869807747536142983336
,0.7151311790818180025297579
,0.7242167561914911733111921
,0.7333706150905097143066769
,0.7425205755305316346337463
,0.7515976242073032498325347
,0.7605380897169633502841180
,0.7692855716938895582757141
,0.7777924872516304155567468
,0.7860210835525379691191006
,0.7939438658796481584900562
,0.8015434190802690483934612
,0.8088116737553457946674484
,0.8157487247443709899030750
,0.8223613480932557839864216
,0.8286613780065362755422598
,0.8346640958281825728448666
,0.8403867644863987074188572
,0.8458473971358430043565590
,0.8510638086868219653879919
,0.8560529570968865575864015
,0.8608305482608478165218457
,0.8654108569873504297476074
,0.8698067073275267402365785
,0.8740295562772630866277268
,0.8780896332924378322459802
,0.8819960996999729463396989
,0.8857572044917702003274940
,0.8893803504694551831377680
,0.8928724405279296894022423
,0.8962396714539516695552379
,0.8994877758726967931224294
,0.9026220289886772718546126
,0.9056472718186162618181356
,0.9085679099114225554245650
,0.9113936574769521126171412
,0.9141206824924498208773116
,0.9167561184809747132362645
,0.9193036299260772814534448
,0.9218194436373866595957338
,0.9242358207044398810126040
,0.9264523754230441499046833
,0.9286810889124146317641362
,0.9308375140221166743614845
,0.9329243301320074843729913
,0.9349440910539479343555058
,0.9368992332247119136923175
,0.9387920831420010214785066
,0.9406248641365484441934086
,0.9423997025585238995759596
,0.9441186334437350335946348
,0.9457836057143433894367490
,0.9473964869611651851144529
,0.9489590678525312572588746
,0.9504730662196773094407831
,0.9519401308780830461842015
,0.9533618452479334370863739
,0.9547397308188643183513022
,0.9560752504514329341844814
,0.9573698114258244462604353
,0.9586247680729506059904566
,0.9598414238164382217277648
,0.9610210325758509197768831
,0.9621647997432835053288613
,0.9632738832715946886153802
,0.9643829667999058719018990
,0.9654920503282170551884178
,0.9666011338565282384749366
,0.9677102173848394217614555
,0.9688193009131506050479743
,0.9699283844414617883344931
,0.9710374679697729716210119
,0.9721465514980841549075308
,0.9732556350263953381940496
,0.9743647185547065214805684
,0.9754738020830177047670873
,0.9765828856113288880536061
,0.9776919691396400713401249
,0.9788010526679512546266437
,0.9799101361962624379131626
,0.9810192197245736211996814
,0.9821283032528848044862002
,0.9832373867811959877727190
,0.9843464703095071710592379
,0.9854555538378183543457567
,0.9865646373661295376322755
,0.9876737208944407209187943
,0.9887828044227519042053132
,0.9898918879510630874918320
,0.9910009714793742707783508
,0.9921100550076854540648696
,0.9932191385359966373513885
,0.9943282220643078206379073
,0.9954373055926190039244261
,0.9965463891209301872109450
,0.9976554726492413704974638
,14.9155615380822119675485737
,14.4895222056940635724231470
,14.0745183430439038119175166
,13.6708404276183159709034953
,13.2786488646015250481013936
,12.8979713521754799643304068
,12.5287109926491826428218701
,12.1706624698871532785915406
,11.8235335146552156260213451
,11.4869689825061573884568134
,11.1605751339814212030887575
,10.8439420985408574438224605
,10.5366629876719830605225070
,10.2383486626578825706701537
,9.9486377171816702258411169
,9.6672017586940128808237205
,9.3937465193710707467289467
,9.1280096578075688995568271
,8.8689576512538152996967256
,8.6187734018139448011197601
,8.3770016072688235908572096
,8.1378415583816998690736000
,7.9075265892031749714874422
,7.6837429832906067872499989
,7.4663168023503825310172033
,7.2550756542177072816457439
,7.0498488963164653853255004
,6.8504682569729951069348317
,6.6567685865160450831012895
,6.4685885308633430668123765
,6.2857710125601595763100704
,6.1081634862930034302053173
,5.9356179944155051941834245
,5.7679910788299810775470178
,5.6051436120279776176289488
,5.4469406000032565273727414
,5.2932508246041329869058245
,5.1439480599808504734937742
,4.9989073154586360914208854
,4.8580079234578494862262232
,4.7211349976072947143279634
,4.5881743805678292247307581
,4.4590159365642954014674615
,4.3335526782439641735322766
,4.2116806802408959242711717
,4.0932989940987392074589479
,3.9783095649790856107586023
,3.8666171504951614146250449
,3.7581292419735512488898621
,3.6527559867823575778800205
,3.5504101173762938614686391
,3.4510068742954254084054355
,3.3544639397590305662788523
,3.2607013686046686373742887
,3.1696415223291145579764816
,3.0812090050685383424422525
,2.9953306014573777282805622
,2.9119352163169760494554339
,2.8309538161288223534484132
,2.7523193722481447132111043
,2.6759668058146108826633736
,2.6018329343178807633307770
,2.5298564197773538708702290
,2.4599777184969333632125199
,2.3921390323573379355082125
,2.3262842616101049308952042
,2.2623589591390547148819223
,2.2003102861566246062352548
,2.1400869693041553176726666
,2.0816392591268262357573349
,2.0249188898956669291351318
,1.9698790407507220656668778
,1.9164742981412172806443550
,1.8646606195402468664212847
,1.8143952984132980521536638
,1.7656369304216323889988871
,1.7183453808433271081668181
,1.6724817531965450179143318
,1.6280083590514666802562260
,1.5848886890191651310999532
,1.5430873849075179560230708
,1.5025702130358242758489951
,1.4633040387009443872301517
,1.4252568017887055074055525
,1.3883974935260035010742286
,1.3526961343738668208658282
,1.3181237530730460782990576
,1.2846523668742366730555204
,1.2522549630131158959756021
,1.2209054815158686402298827
,1.1912181837692097374770128
,1.1618925284409464815382762
,1.1335421863987269475160247
,1.1061447639874983916996598
,1.0796787536087744108215247
,1.0541235219264677436257216
,1.0294592974209959557185812
,1.0056671573704916156088984
,0.9827290152402379241891595
,0.9606390506570684495457613
,0.9393582467135268565527895
,0.9188822950100965503139605
,0.8991964988810809966679471
,0.8802870029626949088807919
,0.8621407950781309059706814
,0.8447457094099045660229308
,0.8280904309486306624776830
,0.8121645006797619803506905
,0.7969583217392179896876314
,0.7824631662697995038158183
,0.7679840255157719397516303
,0.7548854847729463690697571
,0.7424772985351989484925639
,0.7307739214939208416410565
,0.7197479966247247729072001
,0.7094010474096169582836069
,0.6997286411687335672127119
,0.6906573321250183417063795
,0.6830012117225447987323150
,0.6753315299523390269342826
,0.6683354166524753114941859
,0.6625240071109602668641969
,0.6568794917118191412086503
,0.6519153704383157110768821
,0.6476351912463870208469530
,0.6440428862877248805673958
,0.6411426053750206577319659
,0.6389385023228310034326682
,0.6295989782579767268799742
,0.6299437900458427774808001
,0.6308599702850672397147491
,0.6323599926357231781892665
,0.6344540552328282734251275
,0.6371495450168276342139961
,0.6404504549759951759213550
,0.6443567608335617480364022
,0.6488637483120370808009625
,0.6539613493486534645526831
,0.6596334954483233925515151
,0.6658575335244808490742230
,0.6726037576938463935505297
,0.6798351110042207823269678
,0.6875071101231724490787656
,0.6955680644734884010560449
,0.7039596242966542627428339
,0.7126177032427702950911907
,0.7214737779032388553801525
,0.7304565408126070247263328
,0.7394938540089162071211604
,0.7485148826182443926313681
,0.7574522995284654891534615
,0.7662443876879699855564354
,0.7748368746203666557192946
,0.7831843702582234056919219
,0.7912512677628404933471984
,0.7990120675037207798041550
,0.8064511123197590780620203
,0.8135617929970209161183448
,0.8203453354017357090910423
,0.8268093152803627221558713
,0.8329660584323536065554094
,0.8388310719867521081383188
,0.8444216323028224113755869
,0.8497556105911129309404828
,0.8548505783446137540337872
,0.8597231947778501970347520
,0.8643888475965096906961094
,0.8688614990626668532769372
,0.8731536816175048398847025
,0.8772765890186088322266755
,0.8812402176889028160289286
,0.8850535245055174415895749
,0.8887245792518618792144025
,0.8922607001093565415317244
,0.8956684286179189546928114
,0.8989540583539752383046562
,0.9021231352855217933139897
,0.9051808339362071853528846
,0.9081319066091301239751488
,0.9109837752120687470736016
,0.9137365264942164388983770
,0.9163959184281463832277836
,0.9189836881967783366320646
,0.9214804791178912157789682
,0.9239028857019500051706018
,0.9261729364148205689843962
,0.9284186276168806539743628
,0.9305909319932194057045649
,0.9326926080100718108312208
,0.9347262818610111434480814
,0.9366944563608724516612369
,0.9385995189913715064378152
,0.9404437492060866432552757
,0.9422293250853142065892598
,0.9439583294169694438480178
,0.9456327552674275160882189
,0.9472545110959404990325083
,0.9488254254592014547142753
,0.9503472513509543251331024
,0.9518216702263232464886755
,0.9532502957686241895629564
,0.9546346774576625060504398
,0.9559763039780544424672826
,0.9572766064533293484117848
,0.9585369614145167194152464
,0.9597586933471567993692020
,0.9609430766670705725829293
,0.9620913371051919016352372
,0.9632046527377179367945814
,0.9642841551987790804645329
,0.9653636576598402241344843
,0.9664431601209013678044357
,0.9675226625819625114743872
,0.9686021650430236551443386
,0.9696816675040847988142900
,0.9707611699651459424842415
,0.9718406724262070861541929
,0.9729201748872682298241443
,0.9739996773483293734940958
,0.9750791798093905171640472
,0.9761586822704516608339986
,0.9772381847315128045039501
,0.9783176871925739481739015
,0.9793971896536350918438529
,0.9804766921146962355138044
,0.9815561945757573791837558
,0.9826356970368185228537072
,0.9837151994978796665236587
,0.9847947019589408101936101
,0.9858742044200019538635615
,0.9869537068810630975335130
,0.9880332093421242412034644
,0.9891127118031853848734158
,0.9901922142642465285433673
,0.9912717167253076722133187
,0.9923512191863688158832701
,0.9934307216474299595532216
,0.9945102241084911032231730
,0.9955897265695522468931244
,0.9966692290306133905630759
,0.9977487314916745342330273
,15.0223713353123109470743657
,14.5934151594488543679517534
,14.1754856244524933828188296
,13.7688963783110693839262240
,13.3738298179397485654362754
,12.9903329710903605587191123
,12.6183246152678751883513542
,12.2576109371142010218136420
,11.9079069067048042285250631
,11.5688606218529859148702599
,11.2400781276745771464220525
,10.9211466003629844578881603
,10.6116542672177320838500236
,10.3112059810108327440048015
,10.0194339340924116754649731
,9.7360035396087223347194595
,9.4606149761496105554670066
,9.1930012458521552787260589
,8.9320797820399366884203118
,8.6801668800554701022065274
,8.4367874266256208670711203
,8.1958299944165471373480614
,7.9638817053824686453822324
,7.7385098240979308670262071
,7.5195396873826032546617171
,7.3067981266236552428949835
,7.1001136249677863077067741
,6.8993169323235896683854662
,6.7042418365438800620381699
,6.5147258697344572198062451
,6.3306108234059141892657863
,6.1517430321484791733155362
,5.9779734480723174527838637
,5.8091575623272957429321650
,5.6451552384975141052336767
,5.4858305133388958196860585
,5.3310512355118309102408602
,5.1806902683891502547908203
,5.0346217995761524122144692
,4.8927241976774764609103840
,4.7548818515864681444327289
,4.6209797705600488271215909
,4.4909070393840151425024487
,4.3645559135103511039233126
,4.2418217321610880432558588
,4.1226028327377344240289858
,4.0068004669776859927310397
,3.8943187192218182701708429
,3.7850644271279541008823344
,3.6789471033505085628689812
,3.5758788643628194314771918
,3.4757743525071909118651092
,3.3785506694094067370315315
,3.2841273063481648541994673
,3.1924260778315374231794976
,3.1033710571279988776893788
,3.0168885136897727328175733
,2.9329068524189452205064299
,2.8513565547308927783376475
,2.7721701213706437805228688
,2.6952820169386457749283181
,2.6206286160834504350702900
,2.5481481513203689814872632
,2.4777806624366518484237076
,2.4094679474455023004964005
,2.3431535150527533772901734
,2.2787825386018094597773143
,2.2163018114639947420130284
,2.1556597038431850599238260
,2.0968061209652208987108679
,2.0396924626243135847403209
,1.9842715840603484256376987
,1.9304977581427429367266768
,1.8783266388382211520280407
,1.8277152259416395985169856
,1.7786218310507520001806370
,1.7310060447675408301648758
,1.6848287051105423905994485
,1.6400518671244384005802885
,1.5966387736750000669871952
,1.5545538274193417827007124
,1.5137625639428988755241789
,1.4742316260556638241041583
,1.4359287392409081363098267
,1.3988226882509249282549035
,1.3628832948487048515318065
,1.3280813967054434510117744
,1.2943888274847155095415019
,1.2617783981740637866408861
,1.2302238797538598280567612
,1.1996999873000140368617394
,1.1708207273454007690816070
,1.1422883397974741281899469
,1.1147162531410177432888986
,1.0880828256869321535305062
,1.0623672970242217239444926
,1.0375497754681670681264904
,1.0136112247231707783612364
,0.9905334506606031652609090
,0.9683103524866846223417838
,0.9469031452781548896524555
,0.9263072720575341589821505
,0.9065079502420454460320798
,0.8874912438136709491587339
,0.8692440649230589455598306
,0.8517541767349292580746578
,0.8350101974976354979318671
,0.8190016052624654596669984
,0.8037187434911072791976494
,0.7891528272640839780649458
,0.7746131575198480501143194
,0.7614555145744805741969685
,0.7489939393573237236267914
,0.7372235239934495920621771
,0.7261759225391422045703393
,0.7157939214368286284795317
,0.7060925119454490861414797
,0.6969910060239665750003724
,0.6893111106854431513468739
,0.6816265339892773056362785
,0.6746206243180633554956671
,0.6688001858712303571152802
,0.6631554688782362871890541
,0.6581956945758402621748928
,0.6539241557639655644251775
,0.6503444823378699002347503
,0.6474604674440634921595006
,0.6452758459011419533979392
,0.6355897673116567281326184
,0.6360049639197417059577333
,0.6369889844236473752658867
,0.6385537013536041195393977
,0.6407086269724050486829015
,0.6434603743113049834079220
,0.6468120740705202154074982
,0.6507627549136669742324557
,0.6553066799214164461773180
,0.6604326981802701723722748
,0.6661236211203962476190554
,0.6723556698944939125084375
,0.6790980472768577413944513
,0.6863126875849575592170027
,0.6939542362802615382832983
,0.7019703283421185879831228
,0.7103021952722876619645831
,0.7188856418977767059885764
,0.7276523893086458416590290
,0.7365317543790576015894089
,0.7454526077046527143821208
,0.7543454856179762080259366
,0.7631447463106761919249266
,0.7717905985041234595556148
,0.7802308427405780788532752
,0.7884222043643031030413226
,0.7963311283361131920344178
,0.8039340061941075976648108
,0.8112168326759156000704820
,0.8181743575937096002448357
,0.8248088474990759033644849
,0.8311286024288150331429392
,0.8371463814082680254813340
,0.8428778762025799231594192
,0.8483403512645588673279917
,0.8535515238270787730101574
,0.8585287201743224683170297
,0.8632883061064583474220058
,0.8678453607836665861796632
,0.8722135456199435754598426
,0.8764051135693378125068875
,0.8804310066648477484108071
,0.8843009986600853800098321
,0.8880238510108345861837620
,0.8916074620227478764178386
,0.8950589986606506398558736
,0.8983850075218609010363480
,0.9015912424631052912715745
,0.9046835617268548235259118
,0.9076669031990330926973343
,0.9105475554386329717360127
,0.9133278285662855822124584
,0.9160128283008736049808363
,0.9186166358015448452078999
,0.9211303182832334401908270
,0.9235649941072484603310500
,0.9258760420633336263307456
,0.9281398286671475039710799
,0.9303290502822547658468011
,0.9324465511992870991875293
,0.9344950360206562001152975
,0.9364770793502712464828619
,0.9383951345279512024077917
,0.9402515415338660309529928
,0.9420485341678141999466334
,0.9437882465914959606578805
,0.9454727193080366687283345
,0.9471039046411591222351944
,0.9486836717666272678073369
,0.9502138113420472986803134
,0.9516960397798067683439172
,0.9531320032124043217791609
,0.9545232812061740235165530
,0.9558713902783454452460887
,0.9571777872498493655584184
,0.9584438724138281129327765
,0.9596709924277625480826259
,0.9608604427823437266198425
,0.9620134697183053695823673
,0.9631312715987153660890385
,0.9642149999931315385026664
,0.9652657610062337356637840
,0.9663165220193359328249016
,0.9673672830324381299860192
,0.9684180440455403271471368
,0.9694688050586425243082545
,0.9705195660717447214693721
,0.9715703270848469186304897
,0.9726210880979491157916073
,0.9736718491110513129527249
,0.9747226101241535101138425
,0.9757733711372557072749601
,0.9768241321503579044360777
,0.9778748931634601015971953
,0.9789256541765622987583129
,0.9799764151896644959194305
,0.9810271762027666930805481
,0.9820779372158688902416657
,0.9831286982289710874027833
,0.9841794592420732845639009
,0.9852302202551754817250185
,0.9862809812682776788861361
,0.9873317422813798760472537
,0.9883825032944820732083713
,0.9894332643075842703694889
,0.9904840253206864675306065
,0.9915347863337886646917241
,0.9925855473468908618528417
,0.9936363083599930590139593
,0.9946870693730952561750769
,0.9957378303861974533361945
,0.9967885913992996504973121
,0.9978393524124018476584297
,15.1272038722264081656021517
,14.6953966039987005132161357
,14.2746039055292808228614376
,13.8651623806234400859693778
,13.4672764109104896590451972
,13.0810125148534677208544963
,12.7063054293150106133225563
,12.3429732044529920642617071
,11.9907384429809393822097263
,11.6492528724341237733597154
,11.3181226734561981572824152
,10.9969323620046317557807924
,10.6852655045871678396451898
,10.3827210967614487202581586
,10.0889250142129522913592155
,9.8035365052483225412061074
,9.5262501841225972754045870
,9.2567943616377785787108223
,8.9940365689994816733587868
,8.7404288960951124209941554
,8.4954757680073988979074784
,8.2527503739363350376834205
,8.0191990904291543529325281
,7.7922683568289263789097276
,7.5717828105821576301082132
,7.3575685379396835728016413
,7.1494531810206991551126521
,6.9472665436124776405790726
,6.7508413807175946530492183
,6.5600141369499036514412182
,6.3746254959681847296337764
,6.1945206929367540027442374
,6.0195496086445610117721117
,5.8495667013429315517214491
,5.6844308429751775335603270
,5.5240051180022060606233936
,5.3681564596275155309967886
,5.2167568304437548221130783
,5.0696796248542614904408765
,4.9268022547257830368039322
,4.7880084004180547552209646
,4.6531822534951565728533751
,4.5222121337392513495956337
,4.3949895534139544750473760
,4.2714091299244127952761119
,4.1513684997294184597649291
,4.0347682339597898959482336
,3.9215117561317445193935782
,3.8115052623233114381662290
,3.7046576422098289604889487
,3.6008804076888454304139486
,3.5000876139685659360623049
,3.4021957928270269988502150
,3.3071238824168469605524479
,3.2147931603855548488013483
,3.1251271789657191213507303
,3.0380517019707977688369738
,2.9534946436464895036522194
,2.8713860093318825938979444
,2.7916578378858440956378217
,2.7142441458348844918191389
,2.6390808731997745795183619
,2.5661058309596556092913033
,2.4952586501140054942027291
,2.4264807323044288445146321
,2.3597152019599465511134895
,2.2949068599310571414662263
,2.2320021385795816293295957
,2.1709490582928827606679079
,2.1116971853927779534387810
,2.0541975914111718637400372
,1.9984028137060920737866354
,1.9442668173936288322778410
,1.8917449585729575467496488
,1.8407939488234252856102557
,1.7913718209544111648057196
,1.7434378959904501815714184
,1.6969527513758793091369625
,1.6518781903851080805623042
,1.6081772127264422067582927
,1.5658139863292110938175483
,1.5247538203054196159769162
,1.4849631390781508066822880
,1.4464094576694357385804324
,1.4090613581412452237628941
,1.3728884671871031120105044
,1.3378614348824491298017847
,1.3039519146230660329166540
,1.2711325443125145451261915
,1.2393769288922464877344964
,1.2086596243200251610261375
,1.1795911060262718184077357
,1.1508801962258914386438846
,1.1231368344302901096654068
,1.0963392470265722611344472
,1.0704665485381232858941303
,1.0454987289853052701005254
,1.0214166402517106391201196
,0.9982019822671193143293067
,0.9758483822071644109286126
,0.9543172744920408456792416
,0.9336038610770361900748071
,0.9136932741572436622590203
,0.8945714975291740866936152
,0.8762253679015851171030249
,0.8586425774009261990826758
,0.8418116772476097464661393
,0.8257220819922005405899768
,0.8103640745579631099460016
,0.7957288117835494833940402
,0.7811298299352819052288055
,0.7679142498734190525055965
,0.7554003199783899669128573
,0.7435830722824996463771186
,0.7324950265072249777631441
,0.7220785483906622115313212
,0.7123485806628027106057743
,0.7032174608710271002109948
,0.6955141541578623298747175
,0.6878147204699464056787406
,0.6807988909276198041808925
,0.6749692129507796067855452
,0.6693238317202496734381612
,0.6643677616183666367888350
,0.6601040336820780396465125
,0.6565359690470300435549689
,0.6536669980364662180249979
,0.6515004309747378652417638
,0.6414617826828115099146999
,0.6419457248479868427537554
,0.6429957674643370646450080
,0.6446231756017269942660164
,0.6468367732952128301704420
,0.6496424023098793520958338
,0.6530423397935418705628763
,0.6570346833029783173429905
,0.6616126975442179203312776
,0.6667641823030636683000694
,0.6724708724976840024112335
,0.6787079174366866807233123
,0.6854434926154329144054600
,0.6926385969124416730480220
,0.7002470853290208019359397
,0.7082160038611483576787009
,0.7164862517580825596041905
,0.7249936079921015519289540
,0.7336701124644713356559578
,0.7424457667291500806427962
,0.7512504913392518135495379
,0.7600162122951896748190848
,0.7686789661497827053082688
,0.7771808545870851903103471
,0.7854716942476520635807447
,0.7935102487624776657071379
,0.8012649232205161231590296
,0.8087139008696585529278877
,0.8158447281459840771944414
,0.8226534194489706353081715
,0.8291431985956099204315706
,0.8353230210619201345778606
,0.8412060264901676243098905
,0.8468080548198009260829622
,0.8521463367671014976778565
,0.8572384259203830181306216
,0.8621014029351204976947542
,0.8667513461088185433567332
,0.8712030357183204731796877
,0.8754698436899438496183734
,0.8795637550889332523240682
,0.8834954711505865754261890
,0.8872745527528169695585802
,0.8909095744472463884733315
,0.8944082703551914370621034
,0.8977776624438910113568113
,0.9010241682923846306962901
,0.9041536895302304532862081
,0.9071716842553851911645779
,0.9100840600223636389642934
,0.9128945805223505072234502
,0.9156083836284663046711785
,0.9182300678660938464403785
,0.9207642763153890408389657
,0.9232158665786276419140677
,0.9255901249927442897558194
,0.9278436183027848338511490
,0.9300508703113486985714076
,0.9321852300867624618874174
,0.9342494873100182228853328
,0.9362462943433389472858153
,0.9381781757463053539325415
,0.9400475368574539025701142
,0.9418566715633382990802147
,0.9436077693571552904572286
,0.9453029217728742272797149
,0.9469441282673185522611448
,0.9485333016111817672211259
,0.9500722728406572059611790
,0.9515627958153091148219005
,0.9530065514267787030178170
,0.9544051515070618441072270
,0.9557601424905385334440666
,0.9570730088807727353739097
,0.9583451765488236739898298
,0.9595780158380786684091390
,0.9607728443835589215993309
,0.9619309295082595356873867
,0.9630534900875636905581700
,0.9641416979138095477708248
,0.9651966788339666480922574
,0.9662195141855862701163460
,0.9672423495372058921404346
,0.9682651848888255141645232
,0.9692880202404451361886117
,0.9703108555920647582127003
,0.9713336909436843802367889
,0.9723565262953040022608775
,0.9733793616469236242849661
,0.9744021969985432463090547
,0.9754250323501628683331433
,0.9764478677017824903572318
,0.9774707030534021123813204
,0.9784935384050217344054090
,0.9795163737566413564294976
,0.9805392091082609784535862
,0.9815620444598806004776748
,0.9825848798115002225017633
,0.9836077151631198445258519
,0.9846305505147394665499405
,0.9856533858663590885740291
,0.9866762212179787105981177
,0.9876990565695983326222063
,0.9887218919212179546462949
,0.9897447272728375766703834
,0.9907675626244571986944720
,0.9917903979760768207185606
,0.9928132333276964427426492
,0.9938360686793160647667378
,0.9948589040309356867908264
,0.9958817393825553088149150
,0.9969045747341749308390035
,0.9979274100857945528630921
,15.2300652858458249738760060
,14.7954721451749229288452625
,14.3718784463528557182598888
,13.9596435001802330333475766
,13.5589936284406196165264191
,13.1700149641082973062111705
,12.7926584533446199287709533
,12.4267543415875252321711741
,12.0720332350853105651822261
,11.7281508631639539430580044
,11.3947138843749122827375686
,11.0713044449123358958786412
,10.7575016761260755515650089
,10.4528988732412067008681333
,10.1571156873920127594601581
,9.8698052394586479607596630
,9.5906565759701241091761403
,9.3193932875309588581558273
,9.0548322173545745528144835
,8.7995634496019814463352304
,8.5530703234689653413624910
,8.3086064471116198859590440
,8.0734823813121785462953994
,7.8450221113048215215712844
,7.6230495993605495996803256
,7.4073902168027743186939915
,7.1978707971803324028314819
,6.9943202299759512641230685
,6.7965702667426866057098778
,6.6044562908676027745968895
,6.4178179013726772694781175
,6.2364992547213677909212493
,6.0603491793415296129410308
,5.8892211184447500471605963
,5.7229729695722637572430358
,5.5614668817808068368435670
,5.4045688905337625485003628
,5.2521500673058767461043317
,5.1040830421177920683817320
,4.9602442770925989634633879
,4.8205167599409461942627786
,4.6847838803127270779214086
,4.5529332073681398895814709
,4.4248555241373601631948986
,4.3004447397531393448844028
,4.1795978028815454763389425
,4.0622146168161510360050670
,3.9481979566491172128905873
,3.8374533889217405935312399
,3.7298891920202081884383460
,3.6254162846281725585129152
,3.5239481458409884773175236
,3.4254007482932529171648639
,3.3296924874038733577208404
,3.2367441140485899708778561
,3.1464786692174242510589011
,3.0588214205910175813585283
,2.9736998009849608948229616
,2.8910433486161677407721982
,2.8107836491465185702054441
,2.7328542794598282839046988
,2.6571907531291611981316692
,2.5837304675329497705149606
,2.5124126525800427600643161
,2.4431783210053850119436447
,2.3759702201997652259990446
,2.3107327855386881054755577
,2.2474120951771316967437997
,2.1859558262785898641311633
,2.1263132126485100314994270
,2.0684350037439314107245991
,2.0122734250328635496884999
,1.9577821396786676544365946
,1.9049162115264932637614947
,1.8536320693705543583007511
,1.8038874724828086737460353
,1.7556414773853596944519495
,1.7088544058506929257390539
,1.6634878141156497211028409
,1.6195044632969242126563358
,1.5768682909976237116467246
,1.5355443840958997725465451
,1.4954989527076083533074780
,1.4566993053151695569624735
,1.4191138250554475863651760
,1.3827119471626854174672872
,1.3474641375727287595509551
,1.3133418727161407790759995
,1.2803176205609614335401147
,1.2483648230021868741346225
,1.2174578797123947193625781
,1.1882038084545987199902584
,1.1593178752247546015041735
,1.1314066031549969704173009
,1.1044480888655017203348052
,1.0784213238123738776153004
,1.0533061815789441784119163
,1.0290834039678944389351045
,1.0057345866082771923544215
,0.9832530929223352034185268
,0.9616005643685611170567995
,0.9407719691741194267819992
,0.9207523550223218888888255
,0.9015276260137028430108330
,0.8830845436726807440308562
,0.8654107291009839331152875
,0.8484946662476555712117943
,0.8323257056477566528940315
,0.8168940688847129427685445
,0.8021908534511990040982710
,0.7882080383379265198229291
,0.7742613861854324985856124
,0.7616961184251517247290053
,0.7498329214508067108724276
,0.7386677983055286444979970
,0.7282545626188656751054395
,0.7184964630201303714684968
,0.7094261245092435830272848
,0.7016099377239776169190577
,0.6938956785866973175913586
,0.6868698023138813946175674
,0.6810306743419557440333278
,0.6753841704870769957480547
,0.6704311708110386458514540
,0.6661744387213567319960816
,0.6626169809258900533777137
,0.6597618597030903142552916
,0.6576119564248018578567212
,0.6472152513170998933134115
,0.6477663011522180047663255
,0.6488805644886413981353712
,0.6505686942037117725945450
,0.6528388253313747169315207
,0.6556960325306092629560339
,0.6591417495200194709426000
,0.6631731598781677172738114
,0.6677825550651527164447430
,0.6729567195424270842352144
,0.6786763551326752130776754
,0.6849155923510327204084547
,0.6916416417459237964138197
,0.6988146373230538221932306
,0.7063877205598846353851172
,0.7143074290067904508205743
,0.7225144101706020283160115
,0.7309444932701317787504536
,0.7395301038562158701950011
,0.7482019808184913189919030
,0.7568911286614875555400772
,0.7655308749225110398484162
,0.7740589223168721222378963
,0.7824192292009938265451297
,0.7905635699801504268080521
,0.7984526701941507820237121
,0.8060568061712528598050653
,0.8133558579005129018923981
,0.8203388290301260044046217
,0.8270029104770875161278809
,0.8333522063549387848269134
,0.8393962647576523883330424
,0.8451485585649179954614851
,0.8506250436309454876493419
,0.8558428982056333067518494
,0.8608195046186261079057545
,0.8655716986288277681182990
,0.8701152773905658222020065
,0.8744647319106276794897781
,0.8786331556314999069456917
,0.8826322768162812026915276
,0.8864725662721701926471951
,0.8901633812607184781384717
,0.8937131174706779423999592
,0.8971293517266885064742610
,0.9004189668790968381628659
,0.9035882565292937540490925
,0.9066430110372398765150592
,0.9095885882116073739567241
,0.9124307438262846403631556
,0.9151732321654270085886651
,0.9178210686908099269487593
,0.9203787605802357107975809
,0.9228508507438903940567343
,0.9252420774715218731998334
,0.9275288440960827163195290
,0.9297553213806597494084372
,0.9319076487963103838652046
,0.9339887085072826611309438
,0.9360012372384312051565303
,0.9379478366828315483161305
,0.9398309828516842046042257
,0.9416530345094418219531462
,0.9434162408129918020449622
,0.9451227482544325431135235
,0.9467746069912873485563409
,0.9483737766348812048278205
,0.9499221315565589129903401
,0.9514214657625079674119206
,0.9528734973823890230804068
,0.9542798728161160370930816
,0.9556421705869383442788489
,0.9569619049531272736430765
,0.9582405293255170652955144
,0.9594794395124663921592401
,0.9606799767630072039992228
,0.9618434305169178966110621
,0.9629710407337926936222061
,0.9640639997108574332784769
,0.9651234534437089784830732
,0.9661505028162994390683593
,0.9671462051355443900746423
,0.9681419074547893410809252
,0.9691376097740342920872081
,0.9701333120932792430934910
,0.9711290144125241940997739
,0.9721247167317691451060568
,0.9731204190510140961123398
,0.9741161213702590471186227
,0.9751118236895039981249056
,0.9761075260087489491311885
,0.9771032283279939001374714
,0.9780989306472388511437543
,0.9790946329664838021500373
,0.9800903352857287531563202
,0.9810860