
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH parallel_rl_s2p "n" "" "Wcalc" "Wcalc Commands"
.B parallel_rl_s2p
- Convert Series RL Network into Equivalent Parallel RL Network

.SH SYNOPSIS
parallel_rl_s2p Ls Rs Qs freq flag Ls Rs Qs Lp Rp Qp 

.SH INPUT PARAMETERS

.TP 10
Ls
: Series inductance (Farads)
.TP 10
Rs
: Series resistance (Ohms)
.TP 10
Qs
: Series quality factor
.TP 10
freq
: Analysis frequency (Hertz)
.TP 10
flag
: indicates if Qs or Rs should be used for the loss input
    
.RS
.TP 10
flag=0
: Qs will be calculated from Rs.
.TP 10
flag=1
: Rs will be calculated from Qs.
.RE

.TP 10
Ls
: Series inductance (Farads)
.TP 10
Rs
: Series resistance (Ohms)
.TP 10
Qs
: Series quality factor
.TP 10
Lp
: Parallel inductance (Farads)
.TP 10
Rp
: Parallel resistance (Ohms)
.TP 10
Qp
: Parallel quality factor

.SH OUTPUT VALUES

.SH DESCRIPTION

Function to calculate an equivalent parallel RL network from an input
series RL network.

.SH EXAMPLE
.nf

*
* Series to parallel using Q
*
parallel_rl_s2p 10.0e-9 0.1 100.0 100e6 1


*
* Series to parallel using R
*
parallel_rl_s2p 10.0e-9 0.1 100.0 100e6 0
       
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), bars_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), parallel_rc_p2s(n), parallel_rc_s2p(n), parallel_rl_p2s(n), parallel_rl_s2p(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
