
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH parallel_rc_p2s "n" "" "Wcalc" "Wcalc Commands"
.B parallel_rc_p2s
- Convert Parallel RC Network into Equivalent Series RC Network

.SH SYNOPSIS
parallel_rc_p2s Cp Rp Qp freq flag Cs Rs Qs Cp Rp Qp 

.SH INPUT PARAMETERS

.TP 10
Cp
: Parallel capacitance (Farads)
.TP 10
Rp
: Parallel resistance (Ohms)
.TP 10
Qp
: Parallel quality factor
.TP 10
freq
: Analysis frequency (Hertz)
.TP 10
flag
: indicates if Qs or Rs should be used for the loss input
    
.RS
.TP 10
flag=0
: Qs will be calculated from Rs.
.TP 10
flag=1
: Rs will be calculated from Qs.
.RE

.TP 10
Cs
: Series capacitance (Farads)
.TP 10
Rs
: Series resistance (Ohms)
.TP 10
Qs
: Series quality factor
.TP 10
Cp
: Parallel capacitance (Farads)
.TP 10
Rp
: Parallel resistance (Ohms)
.TP 10
Qp
: Parallel quality factor

.SH OUTPUT VALUES

.SH DESCRIPTION

Function to calculate an equivalent series RC network from an input
parallel RC network.

.SH EXAMPLE
.nf

*
* Parallel to series using Q
*
parallel_rc_p2s 10.0e-12 10e3 100.0 100e6 1


*
* Parallel to series using R
*
parallel_rc_p2s 10.0e-12 10e3 100.0 100e6 0

       
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), bars_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), parallel_rc_p2s(n), parallel_rc_s2p(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
