
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH microstrip_syn "n" "" "Wcalc" "Wcalc Commands"
.B microstrip_syn
- Single microstrip transmission line synthesis

.SH SYNOPSIS
microstrip_syn z0 w h l tmet rho rough er tand f flag 

.SH INPUT PARAMETERS

.TP 10
z0
: desired characteristic impedance (Ohms)
.TP 10
w
: width of microstrip line (meters)
.TP 10
h
: substrate thickness (meters)
.TP 10
l
: lentgh of microstrip line (meters)
.TP 10
tmet
: metal thickness (meters)
.TP 10
rho
: resistivity of the metalization (relative to copper)
.TP 10
rough
: conductor surface roughness (meters-rms)
.TP 10
er
: substrate relative permitivitty
.TP 10
tand
: substrate loss tangent
.TP 10
f
: synthesis frequency (Hz)
.TP 10
flag
: indicates which parameters should be optimized
    
.RS
.TP 10
flag=1
: synthesize the metal width
.TP 10
flag=1
: synthesize the substrate thickness
.TP 10
flag=2
: synthesize the substrate dielectric constant
.TP 10
flag=3
: synthesize the metal length
.RE


.SH OUTPUT VALUES

.TP 10
w_out
: Calculated width of microstrip line (meters)
.TP 10
h_out
: Calculated height of microstrip line (meters)
.TP 10
l_out
: Calculated length of microstrip line (meters)
.TP 10
er_out
: Calculated substrate relative permitivitty of microstrip line
.SH DESCRIPTION

Function to synthesize the physical dimenstions of a single
microstrip transmission line to achieve a desired characteristic
impedance and electrical length.  The desired characteristic
impedance and some of the physical
dimensions of the microstrip line are given as inputs and the
remaining dimensions are calculated.


.NF



                 |<--W-->|
                  _______    
                 | metal | <- rho,rough
    ----------------------------------------------
   (  dielectric                         /|\\     (
    )   er,tand                       H   |       )
   (                                     \\|/     (
    ----------------------------------------------
    XXXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXX




.FI

.SH EXAMPLE
.nf

* Z0 = 30 Ohms, er=2.55, f=1 MHz
microstrip_syn 30.0 90.0 5.678e-3 1e-3 1.0 3e-5 1.72e-8 0.0 2.55 0.0 1e6  0
* Z0 = 30 Ohms, er=2.55, f=10 GHz
microstrip_syn 30.0 90.0 5.558e-3 1e-3 1.0 3e-5 1.72e-8 0.0 2.55 0.0 1e10 0
* Z0 = 30 Ohms, er=9.6, f=1 MHz
microstrip_syn 30.0 90.0 2.395e-3 1e-3 1.0 3e-5 1.72e-8 0.0 9.60 0.0 1e6  0
* Z0 = 30 Ohms, er=9.6, f=10 GHz
microstrip_syn 30.0 90.0  2.201e-3 1e-3 1.0 3e-5 1.72e-8 0.0 9.60 0.0 1e10
*
       
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
