
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH ic_microstrip_syn "n" "" "Wcalc" "Wcalc Commands"
.B ic_microstrip_syn
- Integrated circuit microstrip transmission line synthesis

.SH SYNOPSIS
ic_microstrip_syn z0 w h l tmet rho rough er tand f flag 

.SH INPUT PARAMETERS

.TP 10
z0
: desired characteristic impedance (Ohms)
.TP 10
w
: width of ic_microstrip line (meters)
.TP 10
h
: substrate thickness (meters)
.TP 10
l
: lentgh of ic_microstrip line (meters)
.TP 10
tmet
: metal thickness (meters)
.TP 10
rho
: resistivity of wire (relative to copper)
.TP 10
rough
: conductor surface roughness (meters-rms)
.TP 10
er
: substrate relative permitivitty
.TP 10
tand
: substrate loss tangent
.TP 10
f
: synthesis frequency (Hz)
.TP 10
flag
: indicates which parameters should be optimized
    
.RS
.TP 10
flag=1
: synthesize the metal width
.TP 10
flag=1
: synthesize the substrate thickness
.TP 10
flag=2
: synthesize the oxide thickness
.RE


.SH OUTPUT VALUES

.TP 10
w_out
: calculated metal width
.TP 10
h_out
: calculated substrate thickness
.TP 10
tox_out
: calculated oxide thickness
.TP 10
l_out
: calculated metal length
.SH DESCRIPTION

Function to synthesize the physical dimenstions of a single
ic_microstrip transmission line to achieve a desired characteristic
impedance and electrical length.  The desired characteristic
impedance and some of the physical
dimensions of the ic_microstrip line are given as inputs and the
remaining dimensions are calculated.

The model accounts for dispersion (frequency dependent propagation
velocity).


.NF



                 |<--W-->|
                  _______    
                 | metal | <- tmet,rho,rough
    ----------------------------------------------
   {**************  Oxide (tox,eox) **************
    ----------------------------------------------
   (  substrate                          /|\\     (
    )   es,sigmas                     H   |       )
   (                                     \\|/     (
    ----------------------------------------------
    XXXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXX




.FI

.SH EXAMPLE
.nf

*
ic_microstrip_syn 50.00 90.0 50e-6 1e-3 1.0e-6 4.5 200e-6 9.6 0.1 1.0e-6 3.0e-8 0.1e-6 2.4e9 0
ic_microstrip_syn 50.00 90.0 50e-6 1e-3 1.0e-6 4.5 200e-6 9.6 0.1 1.0e-6 3.0e-8 0.1e-6 2.4e9 1
ic_microstrip_syn 100.0 90.0 50e-6 1e-3 1.0e-6 4.5 200e-6 9.6 0.1 1.0e-6 3.0e-8 0.1e-6 2.4e9 2
*
  
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
