
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH coupled_stripline_syn "n" "" "Wcalc" "Wcalc Commands"
.B coupled_stripline_syn
- Coupled stripline transmission line synthesis

.SH SYNOPSIS
coupled_stripline_syn z0 k z0e z0o w s h l tmet rho rough er tand f flag 

.SH INPUT PARAMETERS

.TP 10
z0
: desired characteristic impedance (Ohms)
.TP 10
k
: desired coupling coefficient
.TP 10
z0e
: desired even mode characteristic impedance (Ohms)
.TP 10
z0o
: desired odd mode characteristic impedance (Ohms)
.TP 10
w
: width of coupled stripline line (meters)
.TP 10
s
: spacing between coupled stripline lines (meters)
.TP 10
h
: substrate thickness (meters)
.TP 10
l
: length of coupled_stripline line (meters)
.TP 10
tmet
: metal thickness (meters)
.TP 10
rho
: resistivity of wire (relative to copper)
.TP 10
rough
: conductor surface roughness (meters-rms)
.TP 10
er
: substrate relative permitivitty
.TP 10
tand
: substrate loss tangent
.TP 10
f
: synthesis frequency (Hz)
.TP 10
flag
: indicates which parameters should be optimized
    
.RS
.TP 10
flag=1
: synthesize based on characteristic impedance and coupling coefficient
.TP 10
flag=0
: synthesize based on even and odd mode characteristic impedances
.RE


.SH OUTPUT VALUES

.TP 10
w_out
: calculated metal width
.TP 10
s_out
: calculated gap
.TP 10
l_out
: calculated metal length
.SH DESCRIPTION

Function to synthesize the physical dimenstions of a
coupled stripline transmission line to achieve a desired characteristic
impedance and electrical length.  The desired characteristic
impedance and some of the physical
dimensions of the coupled_stripline line are given as inputs and the
remaining dimensions are calculated.

The line may be specified either in terms of an even mode and
odd mode characteristic impedance or a characteristic impedance and 
coupling coefficient.

The model accounts for dispersion (frequency dependent propagation
velocity).


.NF



              |<--W-->|<-S->|<--W-->|
               _______       -------
              | metal |     | metal | <- rho,rough
    ----------------------------------------------
   (  dielectric                         /|\\     (
    )   er,tand                       H   |       )
   (                                     \\|/     (
    ----------------------------------------------
    XXXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXX



.FI

.SH EXAMPLE
.nf

* ze = 55.27, zo = 45.23, ke = 2.261, ko = 2.009
coupled_stripline_syn 50.000 0.1000 90 2.763e-3 1.213e-3 1e-3 1.0 0.0 1.72e-8 0.0 2.55 0.0 6e9 0
coupled_stripline_syn 55.277 45.227 90 2.763e-3 1.213e-3 1e-3 1.0 0.0 1.72e-8 0.0 2.55 0.0 6e9 1
*
  
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
