
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH coupled_microstrip_calc "n" "" "Wcalc" "Wcalc Commands"
.B coupled_microstrip_calc
- Coupled microstrip transmission line analysis

.SH SYNOPSIS
coupled_microstrip_calc w s h l tmet rho rough er tand f 

.SH INPUT PARAMETERS

.TP 10
w
: width of coupled microstrip lines (meters)
.TP 10
s
: spacing between coupled microstrip lines (meters)
.TP 10
h
: substrate thickness (meters)
.TP 10
l
: lentgh of coupled microstrip line (meters)
.TP 10
tmet
: metal thickness (meters)
.TP 10
rho
: resistivity of the metal (ohm-meters)
.TP 10
rough
: conductor surface roughness (meters-rms)
.TP 10
er
: substrate relative permitivitty
.TP 10
tand
: substrate loss tangent
.TP 10
f
: analysis frequency (Hz)

.SH OUTPUT VALUES

.TP 10
z0
: calculated characteristic impedance (Ohms)
.TP 10
k
: calculated coupling coefficient
.TP 10
z0e
: calculated even mode characteristic impedance (Ohms)
.TP 10
z0o
: calculated odd mode characteristic impedance (Ohms)
.TP 10
kev
: calculated even mode effective relative permitivitty
.TP 10
kev
: calculated odd mode effective relative permitivitty
.TP 10
loss
: calculated loss of the line (dB)
.TP 10
deltal
: calculated open circuit end correction (meters)
.SH DESCRIPTION

Function to analyze the electrical characteristics of a 
coupled microstrip transmission line. The physical
dimensions of the coupled microstrip line are given as inputs and the
characteristic impedance, effective dielectric constant, loss and
open circuit end correction are calculated.

The model accounts for dispersion (frequency dependent propagation
velocity).


.NF



              |<--W-->|<-S->|<--W-->|
               _______       -------
              | metal |     | metal | <- rho,rough
    ----------------------------------------------
   (  dielectric                         /|\\     (
    )   er,tand                       H   |       )
   (                                     \\|/     (
    ----------------------------------------------
    XXXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXX



.FI

.SH EXAMPLE
.nf

*
* ze = 55.27, zo = 45.23, ke = 2.261, ko = 2.009
coupled_microstrip_calc 2.763e-3 1.213e-3 1e-3 1.0 0.0 1.72e-8 0.0 2.55 0.0 6e9
* ze = 69.37, zo = 36.04, ke = 2.239, ko = 1.882
coupled_microstrip_calc 2.314e-3 0.123e-3 1e-3 1.0 0.0 1.72e-8 0.0 2.55 0.0 6e9
* ze = 86.74, zo = 28.82, ke = 2.180, ko = 1.833
coupled_microstrip_calc 1.744e-3 0.988e-5 1e-3 1.0 0.0 1.72e-8 0.0 2.55 0.0 6e9
*
  
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
