
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH bars_calc "n" "" "Wcalc" "Wcalc Commands"
.B bars_calc
- Self and mutual inductance of a pair of parallel rectangular bars

.SH SYNOPSIS
bars_calc a b l1 d c l2 E P l3 freq 

.SH INPUT PARAMETERS

.TP 10
a
: Width of bar 1 (meters)
.TP 10
b
: Thickness of bar 1 (meters)
.TP 10
l1
: Length of bar 1 (meters)
.TP 10
d
: Width of bar 2 (meters)
.TP 10
c
: Thickness of bar 2 (meters)
.TP 10
l2
: Length of bar 2 (meters)
.TP 10
E
: Position of bar 2 in the width direction (meters)
.TP 10
P
: Position of bar 2 in the thickness direction (meters)
.TP 10
l3
: Position of bar 2 in the length direction (meters)
.TP 10
freq
: analysis frequency (Hertz)

.SH OUTPUT VALUES

.TP 10
L1
: Bar 1 self inductance (Henries)
.TP 10
L2
: Bar 2 self inductance (Henries)
.TP 10
M
: Mutual inductance (Henries)
.TP 10
k
: Coupling coefficient
.SH DESCRIPTION

Function to analyze the self and mutual inductances of two parallel
rectanglar bars.

.SH EXAMPLE
.nf

*
* Bars calculation.  Two conductors, 1 um thick, 10 um wide, 1um gap, 1mmm long
*
bars_calc 10e-6 1e-6 1e-3 10e-6 1e-6 1e-3 12e-6 0 0 1e9
*
*
       
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), bars_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
