
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH parallel_rl_s2p "" "" "Wcalc" "Wcalc Commands"
.B parallel_rl_s2p
- Convert Series RL Network into Equivalent Parallel RL Network

.SH SYNOPSIS

[] = 
parallel_rl_s2p(Ls, Rs, Qs, freq, flag, Ls, Rs, Qs, Lp, Rp, Qp)


.SH INPUT PARAMETERS

.TP 10
Ls
: Series inductance (Farads)
.TP 10
Rs
: Series resistance (Ohms)
.TP 10
Qs
: Series quality factor
.TP 10
freq
: Analysis frequency (Hertz)
.TP 10
flag
: indicates if Qs or Rs should be used for the loss input
    
.RS
.TP 10
flag=0
: Qs will be calculated from Rs.
.TP 10
flag=1
: Rs will be calculated from Qs.
.RE

.TP 10
Ls
: Series inductance (Farads)
.TP 10
Rs
: Series resistance (Ohms)
.TP 10
Qs
: Series quality factor
.TP 10
Lp
: Parallel inductance (Farads)
.TP 10
Rp
: Parallel resistance (Ohms)
.TP 10
Qp
: Parallel quality factor

.SH OUTPUT VALUES

.SH DESCRIPTION

Function to calculate an equivalent parallel RL network from an input
series RL network.

.SH EXAMPLE
.nf

.TP
 // 10 nH
Ls=10e-9;
.TP
 // 0.5 Ohms
Rs=0.5;
.TP
 // This value will be replaced
Qs=100;
.TP
 // 100 MHz operation
f=100e6;
.TP
 // Use Rs (and calculate Qs)
flag=0;
[Ls, Rs, Qs, Lp, Rp, Qp] = parallel_rl_s2p(Ls, Rs,
  Qs, f, flag);
disp(sprintf('Equivalent parallel L = %g nH', Lp/1e-9));
disp(sprintf('Equivalent parallel R = %g kOhm', Rp/1e3));
disp(sprintf('Quality factor         =%g',Qp));
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(), air_coil_syn(), coax_calc(), bars_calc(), coax_syn(), coplanar_calc(), coplanar_syn(), coupled_microstrip_calc(), coupled_microstrip_syn(), coupled_stripline_calc(), coupled_stripline_syn(), ic_microstrip_calc(), ic_microstrip_syn(), microstrip_calc(), microstrip_syn(), parallel_rc_p2s(), parallel_rc_s2p(), parallel_rl_p2s(), parallel_rl_s2p(), stripline_calc(), stripline_syn()
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
