
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH coax_calc "" "" "Wcalc" "Wcalc Commands"
.B coax_calc
- Coaxial transmission line analysis

.SH SYNOPSIS

[L, R, C, G, lc, ld, fc, em] = 
coax_calc(a, b, c, t, rho_a, rho_b, er, tand, len, f)


.SH INPUT PARAMETERS

.TP 10
a
: radius of inner conductor (meters)
.TP 10
b
: inner radius of outer conductor (meters)
.TP 10
c
: offset of the inner conductor from the center (meters)
.TP 10
t
: thickness of shield (meters)
.TP 10
rho_a
: resistivity of inner conductor (ohms/meter)
.TP 10
rho_b
: resistivity of outer conductor (ohms/meter)
.TP 10
er
: relative permitivitty of dielectric
.TP 10
tand
: loss tangent of dielectric
.TP 10
len
: physical length of line (meters)
.TP 10
f
: analysis frequency (Hertz)

.SH OUTPUT VALUES

.TP 10
L
: calculated inductance per length (Henries/meter)
.TP 10
R
: calculated resistance per length (Ohms/meter)
.TP 10
C
: calculated capacitance per length (Farads/meter)
.TP 10
G
: calculated conductance per length (Siemens/meter)
.TP 10
lc
: conductor loss (dB/meter)
.TP 10
ld
: dielectric loss (dB/meter)
.TP 10
fc
: TE10 cutoff frequency (Hz)
.TP 10
em
: Max Electric Field (Volts/meter)
.SH DESCRIPTION

Function to analyze the electrical characteristics of a
coaxial transmission line.
The physical
dimensions of the line are given as inputs and the 
characteristic impedance and incremental circuit model
elements are calculated.

.SH EXAMPLE
.nf

.TP
 // mils to meters conversion factor
sf=25.4e-6;
.TP
 // radius of inner conductor
a=10.0*sf;
.TP
 // inner radius of outer conductor
b=100.0*sf;
.TP
 // offset of inner conductor
c=0*sf;
.TP
 // thickness of outer conductor
t=5.0*sf;
.TP
 // resistivity of inner conductor
rho_a=3.5e-8;
.TP
 // resistivity of outer conductor
rho_b=rho_a;
.TP
 // relative permitivitty of dielectric
er=9.5;
.TP
 // dielectric loss tangent
tand=0.01;
.TP
 // length of line
len=1.0;
.TP
 // 100 MHz operation
f=100e6;
[z0,elen,loss,L,R,C,G,lc,ld,fc,em] = coax_calc(a,b,c,t,rho_a,rho_b,er,tand,len,f);
disp(sprintf('z0   = %g Ohms',z0));
disp(sprintf('elen = %g degrees',elen));
disp(sprintf('loss = %g dB',loss));
disp(sprintf('L    = %g H/m',L));
disp(sprintf('R    = %g Ohms/m',R));
disp(sprintf('C    = %g F/m',C));
disp(sprintf('G    = %g S/m',G));
disp(sprintf('Conductor loss  = %g dB/m', lc));
disp(sprintf('Dielectric loss = %g dB/m', ld));
disp(sprintf('TE10 cutoff     = %g GHz', fc/1e9));
disp(sprintf('Max E field     = %g kV/m', em/1e3));
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(), air_coil_syn(), coax_calc(), coax_syn(), coplanar_calc(), coplanar_syn(), coupled_microstrip_calc(), coupled_microstrip_syn(), coupled_stripline_calc(), coupled_stripline_syn(), ic_microstrip_calc(), ic_microstrip_syn(), microstrip_calc(), microstrip_syn(), stripline_calc(), stripline_syn()
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
