
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH air_coil_syn "" "" "Wcalc" "Wcalc Commands"
.B air_coil_syn
- Single layer air core solenoid inductor synthesis

.SH SYNOPSIS

[N_out, len_out, fill_out] = 
air_coil_syn(L, len, fill, AWG, rho, dia, freq, flag)


.SH INPUT PARAMETERS

.TP 10
L
: Desired inductance (Henries)
.TP 10
len
: length of the coil (meters)
.TP 10
fill
: ratio of coil length to closewound length
.TP 10
AWG
: wire size (American Wire Gauge)
.TP 10
rho
: resistivity of wire (ohm-m)
.TP 10
dia
: inside diameter of coil (meters)
.TP 10
freq
: analysis frequency (Hertz)
.TP 10
flag
: indicates which parameters should be optimized
    
.RS
.TP 10
flag=0
: the minimum number of turns is calculated
	along with the corresponding required length/fill.  The diameter is
	held constant.
.TP 10
flag=1
: the number of turns is fixed at the value
        given and the required length/fill is calculated.  The
	diameter is held constant.
.RE


.SH OUTPUT VALUES

.TP 10
N_out
: calculated required number of turns
.TP 10
len_out
: calculated required length (meters)
.TP 10
fill_out
: calculated required fill
.SH DESCRIPTION

Function to synthesize the physical parameters of a single layer,
uniformly spaced, air core, solenoid inductor.  The physical
dimensions of the coil are synthesized from an inductance 
specification.

.SH EXAMPLE
.nf

.TP
 // we want 220 nH
L=220e-9;
.TP
 // we'll synthesize the number of turns
N=0;
.TP
 // we'll synthesize the length/fill
len=0;
.TP
 // we'll synthesize the length/fill
fill=0;
.TP
 // wire size
AWG=22;
.TP
 // Resistivity of copper (ohm-m)
rho=1.72e-8;
.TP
 // 0.25 inches inside diameter
dia=0.25*0.0254;
.TP
 // 10 MHz operation
f=10e6;
.TP
 // synthesize for minimum number of turns
flag=0;
[Nout,len_out,fill_out] = air_coil_syn(L,N,len,fill,AWG,rho,dia,f,flag);
disp(sprintf('Number of turns = %g ',Nout));
disp(sprintf('Length=%g inches',len_out/0.0254));
disp(sprintf('Fill=%g',fill_out));
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(), air_coil_syn(), coax_calc(), coax_syn(), coplanar_calc(), coplanar_syn(), coupled_microstrip_calc(), coupled_microstrip_syn(), coupled_stripline_calc(), coupled_stripline_syn(), ic_microstrip_calc(), ic_microstrip_syn(), microstrip_calc(), microstrip_syn(), stripline_calc(), stripline_syn()
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
