
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH air_coil_calc "" "" "Wcalc" "Wcalc Commands"
.B air_coil_calc
- Single layer air core solenoid inductor analysis

.SH SYNOPSIS

[L, Q, SRF, len_out, fill_out, lmax] = 
air_coil_calc(N, len, fill, AWG, rho, dia, freq, flag)


.SH INPUT PARAMETERS

.TP 10
N
: Number of turns
.TP 10
len
: length of the coil (meters)
.TP 10
fill
: ratio of coil length to closewound length
.TP 10
AWG
: wire size (American Wire Gauge)
.TP 10
rho
: resistivity of wire (ohm-m)
.TP 10
dia
: inside diameter of coil (meters)
.TP 10
freq
: analysis frequency (Hertz)
.TP 10
flag
: used to calculate coil length.
 
.RS
.TP 10
flag=0
: the length given by len is used.
.TP 10
flag=1
: the length is calculated from the wire size,
 number of turns and fill input.
.RE


.SH OUTPUT VALUES

.TP 10
L
: calculated inductance (Henries)
.TP 10
Q
: calculated quality factor
.TP 10
SRF
: calculated self resonant frequency (Hertz)
.TP 10
len_out
: length used for the analysis (meters)
.TP 10
fill_out
: fill used for the analysis
.TP 10
lmax
: maximum (closewound) inductance
.SH DESCRIPTION

Function to analyze the electrical characteristics of a single layer,
uniformly spaced, air core, solenoid inductor.  The physical
dimensions of the coil are given as inputs and the inductance, quality
factor, and self resonant frequency are calculated.

.SH EXAMPLE
.nf

.TP
 // number of turns
N=5;
.TP
 // we'll use the fill parameter instead
len=0;
.TP
 // the coil is 20% longer than the minimum
fill=1.2;
.TP
 // wire size
AWG=22;
.TP
 // resistivity of copper (ohm-m)
rho=1.72e-8;
.TP
 // 0.25 inches inside diameter
dia=0.25*0.0254;
.TP
 // 10 MHz operation
f=10e6;
.TP
 // use fill to calculate length
flag=1;
[L,Q,SRF,len_out,fill_out,Lmax] = air_coil_calc(N,len,fill,AWG,rho,dia,f,flag);
disp(sprintf('L=%g nH',L*1e9));
disp(sprintf('Q=%g at %g MHz',Q,f/1e6));
disp(sprintf('Self Resonant Freq=%g MHz',SRF/1e6));
disp(sprintf('Length=%g inches',len_out/0.0254));
disp(sprintf('Fill=%g',fill_out));
disp(sprintf('Lmax=%g nH',Lmax*1e9));
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(), air_coil_syn(), coax_calc(), coax_syn(), coplanar_calc(), coplanar_syn(), coupled_microstrip_calc(), coupled_microstrip_syn(), coupled_stripline_calc(), coupled_stripline_syn(), ic_microstrip_calc(), ic_microstrip_syn(), microstrip_calc(), microstrip_syn(), stripline_calc(), stripline_syn()
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
