import { schedule_wasm_task } from '../../..';

// The purpose of this file is two-fold:
// First: Expose a function to start a web worker. This function must
// not be inlined into the Rust lib, as otherwise bundlers could not
// bundle it -- huh.
export function startWorker(module, memory, state, opts, helper) {
    try {
        const worker = new Worker(new URL('./worker.js',
            import.meta.url), opts);

        // When the worker wants to schedule some work it will
        // post a message back to the main thread
        worker.onmessage = async ev => {
            let [task, module, memory] = ev.data;
            schedule_wasm_task(task, module, memory);
        };
        worker.postMessage([module, memory, state, helper.mainJS()]);
    } catch (err) {
        return new Promise((res, rej) => {
            rej(err);
        });
    }
    return new Promise((res, rej) => {
        res();
    });
}
export function startWasm(module, memory, ctx, opts, helper, wasm_module, wasm_memory) {
    try {
        const worker = new Worker(new URL('./worker.js',
            import.meta.url), opts);

        // When the worker wants to schedule some work it will
        // post a message back to the main thread
        worker.onmessage = async ev => {
            let [task, module, memory] = ev.data;
            schedule_wasm_task(task, module, memory);
        };
        worker.postMessage([module, memory, ctx, helper.mainJS(), wasm_module, wasm_memory]);
    } catch (err) {
        return new Promise((res, rej) => {
            rej(err);
        });
    }
    return new Promise((res, rej) => {
        res();
    });
}
export function scheduleTask(task, module, memory) {
    postMessage([task, module, memory]);
}

export function isWorker() {
    return 'WorkerGlobalScope' in self && self instanceof WorkerGlobalScope;
}

// Second: Entry script for the actual web worker.
if (isWorker()) {
    //console.log("pool::worker(entry) started");
    Error.stackTraceLimit = 50;

    // Initialize wasm module, and memory. `state` is the shared state,
    // to be used with `worker_entry_point`.
    self.onmessage = async ev => {
        // This crate only works with bundling via webpack or not
        // using a bundler at all:
        // When bundling with webpack, this file is relative to the wasm
        // module file (or package.json) located in `../../..` generated by
        // wasm-pack.
        // When using it without any bundlers, the module that
        // provided the `helper` object below is loaded; in other words
        // the main wasm module.
        if (ev.data.length == 4) {
            let [module, memory, state, mainJS] = ev.data;
            const importFrom = (typeof __webpack_require__ === 'function') ? import('../../..') : import(mainJS);
            const {
                default: init,
                worker_entry_point,
            } = await importFrom;
            await init(module, memory);

            worker_entry_point(state);
        } else {
            try {
                // There shouldn't be any additional messages after the first so we
                // need to unhook it
                self.onmessage = ev => {
                    console.error("wasm threads can only run a single process then exit", ev);
                }

                let [module, memory, ctx, mainJS, wasm_module, wasm_memory] = ev.data;
                const importFrom = (typeof __webpack_require__ === 'function') ? import('../../..') : import(mainJS);
                const {
                    default: init,
                    wasm_entry_point,
                } = await importFrom;
                await init(module, memory);

                wasm_entry_point(ctx, wasm_module, wasm_memory);
            } finally {
                //Terminate the worker
                close();
            }
        }
    }
}
