# WasmEdge Roadmap

## About this document

This document should serve as a reference point for WasmEdge users and contributors to understand where the project is heading, and help determine if a contribution could be conflicting with a longer term plan.

## How to help?

Discussion on the roadmap can take place in threads under [Issues](https://github.com/WasmEdge/WasmEdge/issues). Please open and comment on an issue if you want to give suggestions and feedback to items in the roadmap. Please review the roadmap to avoid potential duplicated efforts.

## How to add an item to the roadmap?

Please open an issue to track any initiative on the roadmap of WasmEdge (Usually driven by new feature requests). We will work with and rely on our community to focus our efforts to improve WasmEdge.

## Current Roadmap

The following table includes the current roadmap for WasmEdge. If you have any questions or would like to contribute to WasmEdge, please create an issue to discuss with our team. If you don't know where to start, we are always looking for contributors that will help us reduce technical, automation, and documentation debt. Please take the timelines & dates as proposals and goals. Priorities and requirements change based on community feedback, roadblocks encountered, community contributions, etc.

Last Updated: Sep 2022

| Theme                     | Description | Timeline |
| ---                       | --- |--- |
| Proposal                  | WASI signature proposal | Q1 / 2022 |
| Feature                   | Enhance info/debug logging, provide verbose mode (wasmedge a.wasm –verbose=3) | Q1 / 2022 |
| Feature                   | Apply WasmEdge-bindgen to Rust SDK | Q1 / 2022 |
| Host function             | Databse connetor | Q1 / 2022 |
| Languages Bindings        | Rust SDK | Q1 / 2022 |
| Languages Bindings        | Python SDK | Q1 / 2022 |
| Languages Bindings        | Update the Node.js SDK to make it compatible with C API | Q1 / 2022 |
| High-level Languages      | Enhance JavaScript, Python, Ruby support | Q1 / 2022 |
| Proposal                  | WASM C API proposal | Q2 / 2022 |
| Proposal                  | WASM memory64 proposal(interpreter) | Q2 / 2022 |
| Proposal                  | WASM typed function references proposal | Q2 / 2022 |
| Feature                   | plugin architecture(wasmedge +tf +image) | Q2 / 2022 |
| Feature                   | Apply WasmEdge-bindgen to Node.js SDK | Q1 / 2022 |
| Host function             | device driver | Q3 / 2022 |
| Languages Bindings        | Java SDK | Q2 / 2022 |
| Proposal                  | exception handling proposal | Q3 / 2022 |
| Proposal                  | WASM memory64 proposal(AOT) | Q3 / 2022 |
| Feature                   | WasmEdge debugging tools | Q3 / 2022 |
| Feature                   | Enable ONNX backend for WASI-NN | Q3 / 2022 |
| Feature                   | Apply WasmEdge-bindgen to Python and Java SDK| Q2 / 2022 |
| Host function             | UI library | Q3 / 2022 |
| Proposal                  | WASM GC proposal(AOT) | Q4 / 2022 |
| Feature                   | self update standalone binary | Q4 / 2022 |
| Feature                   | wasmedge update | Q4 / 2022 |
| Feature                   | aot to standalone binary+edge device(Cortex-M;esp32) support | Q4 / 2022 |
| Feature                   | DWARF symbol | Q4 / 2022 |
| Feature                   | Enable PaddlePaddle backend for WASI-NN | Q3 / 2022 |
| Docs                      | Multilingual support for the WasmEdge Book | long term work |
| Open Source Collaboration | Eventmesh, Krustlet, APISIX, Dapr, MOSN, KubeEdge, OpenYurt, Fedora, SuperEdge, UDF for SaaS and Databases, Substrate, ParaState, Filecoin | long term work |
