/***************************************************************************
                          wirelessstatsimp.h  -  description
                             -------------------
    begin                : Tue Jan 1 2002
    copyright            : (C) 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WIRELESSSTATSIMP_H
#define WIRELESSSTATSIMP_H

#include "wirelessstats.h"
#include "wap11config.h"

/**Logic for the wireless stats dialog
  *@author Ori Pessach
  */

class WirelessStatsImp : public WirelessStats  {
public:
  WirelessStatsImp(WAP11Config &w11);
  ~WirelessStatsImp();
  /** Retrieve wireless stats from the WAP11Config instance. */
  void Reload();
  /** Extract a 32 bit, small endian value from location i in v. */
  uint32_t ExtractValue(const WAP11Config::bytevector_t &v, int i);

private:
  WAP11Config &w11c;
public slots: // Public slots
  /** Invoked when the close button is clicked */
  void slotCloseButton();
  /** Sets up the dialog's periodic updates */
  virtual void polish();
  /** Invoked when the refresh button is clicked */
  void slotRefreshButton();
protected slots: // Protected slots
protected: // Protected methods
  /** Updates the dialog periodicallly. */
  virtual void timerEvent(QTimerEvent *);
};

#endif
