/***************************************************************************
                          wirelessstatsimp.cpp  -  description
                             -------------------
    begin                : Tue Jan 1 2002
    copyright            : (C) 2002, 2003 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include "wirelessstatsimp.h"

WirelessStatsImp::WirelessStatsImp(WAP11Config &w11): w11c(w11)
{
}
WirelessStatsImp::~WirelessStatsImp()
{
}

/** Retrieve wireless stats from the WAP11Config instance. */
void WirelessStatsImp::Reload()
{
  w11c.GetStats();
  WAP11Config::bytevector_t v;
  w11c.GetVariable("WLstatisticsGRP.wirelessStatistics.0", v);
  uint32_t rxtx;

  QLineEdit *widget[8]={
    TxUnicast,   TxBcast,
    TxMcast,     TxBeacon,
    RxUnicast,   RxBcast,
    RxMcast,     RxBeacon
    };

  for(int i=0; i<8; ++i)
  {
    char tmp[16];
    rxtx=ExtractValue(v, i*4);
    sprintf(tmp, "%d", rxtx);
    widget[i]->setText(tmp);
  }
}

/** Invoked when the refresh button is clicked */
void WirelessStatsImp::slotRefreshButton()
{
  Reload();
}

/** Invoked when the close button is clicked */
void WirelessStatsImp::slotCloseButton()
{
  accept();
}

/** Extract a 32 bit, small endian value from location i in v. */
uint32_t WirelessStatsImp::ExtractValue(const WAP11Config::bytevector_t &v, int i)
{
  uint32_t r=0;
  for(int j=i+3; j>=i; --j)
  {
    r<<=8;
    r+=(uint32_t)v[j];
  }
  return r;
}
/** Updates the dialog periodicallly. */
void WirelessStatsImp::timerEvent(QTimerEvent *)
{
	Reload();
}

/** Set up the dialog's periodic updates */
void WirelessStatsImp::polish()
{
	startTimer(1000);
}
