/***************************************************************************
                          wap11exception.h  -  description
                             -------------------
    begin                : Thu Mar 28 2002
    copyright            : (C) 2002, 2003 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WAP11EXCEPTION_H
#define WAP11EXCEPTION_H

#include <string>

/**A base exception class for the WAP11 GUI.
  *@author Ori Pessach
  */

class WAP11Exception {
public:
  enum PossibleCause { W11G_UNKNOWN, W11G_AP_DOESNT_LISTEN, W11G_AUTHORIZATION };
protected:
  static std::string cause_table[];
  
  WAP11Exception(const std::string &f, const int &n, const std::string &cn,
                 const std::string &err="", PossibleCause pc=W11G_UNKNOWN);
public:
  virtual ~WAP11Exception() {}
  std::string report();
  std::string cause();

  std::string classname;
  std::string file;
  int line;
  std::string error;
  PossibleCause possible_cause;
};

class WAP11SNMPAuthError: public WAP11Exception {
public:
  WAP11SNMPAuthError(const std::string &f, const int &n,
                     PossibleCause pc=WAP11Exception::W11G_AUTHORIZATION):
  WAP11Exception(f, n, "WAP11SNMPAuthError", "Authorization error", pc) {}
  virtual ~WAP11SNMPAuthError() {}
};

class WAP11SNMPException: public WAP11Exception {
public:
  WAP11SNMPException(const std::string &f, const int &n,
                     const std::string &err,
                     PossibleCause pc=WAP11Exception::W11G_UNKNOWN):
  WAP11Exception(f, n, "WAP11SNMPException", err, pc) {}
  virtual ~WAP11SNMPException() {}
};

class WAP11ParamException: public WAP11Exception
{
public:
  WAP11ParamException(const std::string &f, const int &n, const std::string &err):
    WAP11Exception(f, n, "WAP11ParamException", err) {}
  virtual ~WAP11ParamException() {}
};
/** A handy macro to create, initialize and throw an excpetion. */
#define THROW_WAP11_EXCEPTION( C ) throw C(__FILE__, __LINE__ );
#define THROW_WAP11_EXCEPTION2( C, arg ) throw C(__FILE__, __LINE__, arg );
#define THROW_WAP11_EXCEPTION3( C, arg, pc ) throw C(__FILE__, __LINE__, arg, pc );
#endif
