/***************************************************************************
                          passworddlgimp.cpp  -  description
                             -------------------
    begin                : Sun Dec 16 2001
    copyright            : (C) 2001 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qcombobox.h>
#include "passworddlgimp.h"

PasswordDlgImp::PasswordDlgImp():
  PasswordDialog(0, 0, true), password(0), ip_address(0)
{
}

PasswordDlgImp::~PasswordDlgImp()
{
}

/** Returns a pointer to a newly allocated buffer containing the IP address of the
access point. The caller must free the buffer. */
const char * PasswordDlgImp::GetIPAddress()
{
  return ip_address;
}
/** Returns a pointer to a newly allocated buffer, containing the password from the 
dialog's password field. The caller must free the buffer when it's done with it. */
const char * PasswordDlgImp::GetPassword()
{
  return password;
}
/** Called when the Cancel button on the dialog is pressed. */
void PasswordDlgImp::slotCancelButton()
{
  done(0);
}
/** Invoked when pressing the OK button on the password dialog */
void PasswordDlgImp::slotOKButton()
{
  delete [] password;
  delete [] ip_address;

  password=strdup(EditPassword->text());
  ip_address=strdup(ComboAddress->currentText().stripWhiteSpace());

  done(1);
}

/** Prepare the dialog for display */
void PasswordDlgImp::polish()
{
  setMaximumSize(size());
  setMinimumSize(size());
  ComboAddress->setFocus();
  if( ComboAddress->count() != 0 )
  {
    QLineEdit *le=ComboAddress->lineEdit();
    le->setSelection(0, le->text().length());
  }
}

void PasswordDlgImp::AddAddresses( const strvec_t &addresses )
{
  ComboAddress->clear();
  for( int i=0; i<(int)addresses.size(); ++i )
  {
    ComboAddress->insertItem(QString(addresses[i].c_str()));
  }
}
