/***************************************************************************
                          macauthimp.cpp  -  description
                             -------------------
    begin                : Fri Jul 19 2002
    copyright            : (C) 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qlistbox.h>
#include <vector>
#include <string>
#include "macauthimp.h"
#include "macvalidator.h"

MacAuthImp::MacAuthImp(WAP11Config &w): w11c(w)
{
  // The validator enables and disables the button:
  MACEdit->setValidator(new MACValidator(AddButton));
}

MacAuthImp::~MacAuthImp(){
}

/** Finish up the dialog's initialization. */
void MacAuthImp::polish()
{
  MACEdit->setFocus();
  MACEdit->clear();
  MACList->clear();
  AddButton->setEnabled(false);
  highlighted_item=-1;
  std::vector<std::string> ml=w11c.GetMACList();
  std::vector<std::string>::iterator i=ml.begin();
  while(i!=ml.end())
  {
    MACList->insertItem((*i).c_str());
    ++i;
  }
}

/** Invoked when clicking the Add button */
void MacAuthImp::slotAddMAC()
{
  MACList->insertItem(MACEdit->text());
  AddButton->setEnabled(false);
  MACEdit->clear();
}

/** Invoked when the OK button is clicked */
void MacAuthImp::slotOK()
{
  // Update the AP's MAC list:
  std::vector<std::string> addr(MACList->count());
  for(int i=0; i<(int)MACList->count(); ++i) 
  {
    addr[i]=(const char*)MACList->text(i);
  }
  w11c.SetMACList(addr);
  done(1);
}

/** Invoked when the Cancel button is clicked */
void MacAuthImp::slotCancel()
{
  done(0);
}

/** Invoked when a MAC address is selected from the list */
void MacAuthImp::slotMACSelected(int i)
{
  highlighted_item=i;
}

/** Invoked when the Delete button is pressed */
void MacAuthImp::slotDelete()
{
  if(highlighted_item!=-1)
  {
    MACList->removeItem(highlighted_item);
  }
}
