/***************************************************************************
                          hexvalidator.cpp  -  description
                             -------------------
    begin                : Mon Oct 7 2002
    copyright            : (C) 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ctype.h>
#include "hexvalidator.h"

/** Validate a HEX entry field, and correct its formatting. */
QValidator::State HEXValidator::validate( QString &s, int &pos ) const
{
  State retval=Acceptable;
  int len=0; // Here we keep the number of non-space characters entered
  QChar c;

  for( unsigned int i=0; i<s.length(); ++i )
  {
    c=s[i];
    if(i%3==2)
    {
      if(c!=' ')
      {
        s.insert(i, ' ');
        if(int(i)<=pos)
        {
          pos++;
        }
      }
    }
    else if( !isxdigit(c) )
    {
      s.remove(i, 1);
      if(int(i)<pos)
      {
        pos--;
      }
    }
    else
    {
      len++;
    }
  }

  // Check the key length entered against the required length:
  if( len==FieldLength() )
  {
    AcceptAction();
    retval=Acceptable;
  }
  else if( len>FieldLength() )
  {
    RejectAction();
    retval=Invalid;
  }
  else
  {
    RejectAction();
    retval=Intermediate;
  }

  return retval;
}
