/* $Id: wait_on.h,v 1.2 2002/05/28 14:28:38 andrew Exp $ */
#ifndef WAIT_ON_H
#define WAIT_ON_H

#include <sys/types.h>
#include <sys/event.h>

/* make us a teeny bit more portable */
#ifdef __GCC__
	#define ATTRIBUTE_NORETURN	__attribute__((__noreturn__))
#else
	#define ATTRIBUTE_NORETURN
#endif

/* option flags */
#define E_FLAG	0x01	/* exec a program instead of exiting */
#define H_FLAG	0x02	/* want output in human readable form as well */
#define I_FLAG	0x04	/* want to know which file the event occured to */
#define W_FLAG	0x08	/* only interested in writes */

/* return values for !-i */
#define EXIT_BASE		0
#define EXIT_TIMEOUT	0
#define EXIT_DELETE		1
#define EXIT_WRITE		2
#define EXIT_EXTEND		3
#define EXIT_ATTRIB		4
#define EXIT_LINK		5
#define EXIT_RENAME		6
#define EXIT_REVOKE		7

void display_human(struct kevent *event);
int what_happened(struct kevent *event);
int which_happened(struct kevent *event, int file_count, char *const filenames[]);

#endif
