#include "rgrl_object.h"
#include "rgrl_command.h"
#include "rgrl_event.h"

rgrl_object::rgrl_object()

    = default;

rgrl_object::
~rgrl_object() = default;

void
rgrl_object::
set_debug_flag(  unsigned int debugFlag ) const
{
  debug_flag_ = debugFlag;
}

unsigned int
rgrl_object::
debug_flag() const
{
  return debug_flag_;
}

void
rgrl_object::
set_warning( bool flag ) const
{
  warning_ = flag;
}

bool
rgrl_object::
warning() const
{
  return warning_;
}

unsigned int
rgrl_object::
add_observer( const rgrl_event_sptr& event, const rgrl_command_sptr& cmd )
{
  rgrl_object_observer new_observer( cmd, event );
  observers_[observer_count_] = new_observer;
  observer_count_++;
  return observer_count_ - 1;
}

rgrl_command_sptr
rgrl_object::
get_command(unsigned int tag)
{
  auto i =  observers_.find( tag );

  if ( i == observers_.end() )
    return nullptr;

  return i->second.command_;
}

void
rgrl_object::
invoke_event( const rgrl_event & event)
{
  typedef observer_map::iterator obs_itr;
  auto i = observers_.begin();
  for ( ; i != observers_.end(); ++i) {
    rgrl_event_sptr e =  i->second.event_;
    if (e->is_same_type(event)) {
      i->second.command_->execute(this, event);
    }
  }
}

void
rgrl_object::
invoke_event( const rgrl_event & event) const
{
  auto i = observers_.begin();
  for ( ; i != observers_.end(); ++i) {
    const rgrl_event_sptr e =  i->second.event_;
    if (e->is_same_type(event)) {
      i->second.command_->execute(this, event);
    }
  }
}

void
rgrl_object::
remove_observer(unsigned int tag)
{
  auto i =  observers_.find( tag );

  if ( i == observers_.end() ) return;
  observers_.erase(tag);
}

bool
rgrl_object::
has_observer( const rgrl_event & event ) const
{
  auto i = observers_.begin();
  for ( ; i != observers_.end(); ++i) {
    const rgrl_event_sptr e = i->second.event_;
    if ( e->is_same_type(event) ) {
      return true;
    }
  }
  return false;
}
