// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See error_location_helper_generator.py for modifications

/***************************************************************************
*
* Copyright (c) 2023 The Khronos Group Inc.
* Copyright (c) 2023 Valve Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
****************************************************************************/

// NOLINTBEGIN

#pragma once
#include <string_view>
#include <vulkan/vulkan.h>

// structure to track where a validation error occurs, and capture enough information
// to generate the start of a log message and find the correct VUID for many commonvalidity errors.
//
// usage example:
// Location outer(Func::vkCmdPipelineBarrier, Struct::VkImageMemoryBarrier);
//     auto struct_level = outer.dot(Field::pImageMemoryBarriers, i);
//        auto field_level = struct_level.dot(Field::srcAccessMask);
//        std::cout << field_level.Message() << std::endl;
// will print:
//        vkCmdPipelineBarrier(): pImageMemoryBarriers[42].srcAccessMask
// VUIDs can be found for an error in generic code using a combination of the
// function, structure, and fieldmembers.

namespace core_error {
enum class Func {
    Empty = 0,
    vkAcquireDrmDisplayEXT = 1,
    vkAcquireFullScreenExclusiveModeEXT = 2,
    vkAcquireNextImage2KHR = 3,
    vkAcquireNextImageKHR = 4,
    vkAcquirePerformanceConfigurationINTEL = 5,
    vkAcquireProfilingLockKHR = 6,
    vkAcquireWinrtDisplayNV = 7,
    vkAcquireXlibDisplayEXT = 8,
    vkAllocateCommandBuffers = 9,
    vkAllocateDescriptorSets = 10,
    vkAllocateMemory = 11,
    vkBeginCommandBuffer = 12,
    vkBindAccelerationStructureMemoryNV = 13,
    vkBindBufferMemory = 14,
    vkBindBufferMemory2 = 15,
    vkBindBufferMemory2KHR = 16,
    vkBindImageMemory = 17,
    vkBindImageMemory2 = 18,
    vkBindImageMemory2KHR = 19,
    vkBindOpticalFlowSessionImageNV = 20,
    vkBindVideoSessionMemoryKHR = 21,
    vkBuildAccelerationStructuresKHR = 22,
    vkBuildMicromapsEXT = 23,
    vkCmdBeginConditionalRenderingEXT = 24,
    vkCmdBeginDebugUtilsLabelEXT = 25,
    vkCmdBeginQuery = 26,
    vkCmdBeginQueryIndexedEXT = 27,
    vkCmdBeginRenderPass = 28,
    vkCmdBeginRenderPass2 = 29,
    vkCmdBeginRenderPass2KHR = 30,
    vkCmdBeginRendering = 31,
    vkCmdBeginRenderingKHR = 32,
    vkCmdBeginTransformFeedbackEXT = 33,
    vkCmdBeginVideoCodingKHR = 34,
    vkCmdBindDescriptorBufferEmbeddedSamplersEXT = 35,
    vkCmdBindDescriptorBuffersEXT = 36,
    vkCmdBindDescriptorSets = 37,
    vkCmdBindIndexBuffer = 38,
    vkCmdBindIndexBuffer2KHR = 39,
    vkCmdBindInvocationMaskHUAWEI = 40,
    vkCmdBindPipeline = 41,
    vkCmdBindPipelineShaderGroupNV = 42,
    vkCmdBindShadersEXT = 43,
    vkCmdBindShadingRateImageNV = 44,
    vkCmdBindTransformFeedbackBuffersEXT = 45,
    vkCmdBindVertexBuffers = 46,
    vkCmdBindVertexBuffers2 = 47,
    vkCmdBindVertexBuffers2EXT = 48,
    vkCmdBlitImage = 49,
    vkCmdBlitImage2 = 50,
    vkCmdBlitImage2KHR = 51,
    vkCmdBuildAccelerationStructureNV = 52,
    vkCmdBuildAccelerationStructuresIndirectKHR = 53,
    vkCmdBuildAccelerationStructuresKHR = 54,
    vkCmdBuildMicromapsEXT = 55,
    vkCmdClearAttachments = 56,
    vkCmdClearColorImage = 57,
    vkCmdClearDepthStencilImage = 58,
    vkCmdControlVideoCodingKHR = 59,
    vkCmdCopyAccelerationStructureKHR = 60,
    vkCmdCopyAccelerationStructureNV = 61,
    vkCmdCopyAccelerationStructureToMemoryKHR = 62,
    vkCmdCopyBuffer = 63,
    vkCmdCopyBuffer2 = 64,
    vkCmdCopyBuffer2KHR = 65,
    vkCmdCopyBufferToImage = 66,
    vkCmdCopyBufferToImage2 = 67,
    vkCmdCopyBufferToImage2KHR = 68,
    vkCmdCopyImage = 69,
    vkCmdCopyImage2 = 70,
    vkCmdCopyImage2KHR = 71,
    vkCmdCopyImageToBuffer = 72,
    vkCmdCopyImageToBuffer2 = 73,
    vkCmdCopyImageToBuffer2KHR = 74,
    vkCmdCopyMemoryIndirectNV = 75,
    vkCmdCopyMemoryToAccelerationStructureKHR = 76,
    vkCmdCopyMemoryToImageIndirectNV = 77,
    vkCmdCopyMemoryToMicromapEXT = 78,
    vkCmdCopyMicromapEXT = 79,
    vkCmdCopyMicromapToMemoryEXT = 80,
    vkCmdCopyQueryPoolResults = 81,
    vkCmdCuLaunchKernelNVX = 82,
    vkCmdDebugMarkerBeginEXT = 83,
    vkCmdDebugMarkerEndEXT = 84,
    vkCmdDebugMarkerInsertEXT = 85,
    vkCmdDecodeVideoKHR = 86,
    vkCmdDecompressMemoryIndirectCountNV = 87,
    vkCmdDecompressMemoryNV = 88,
    vkCmdDispatch = 89,
    vkCmdDispatchBase = 90,
    vkCmdDispatchBaseKHR = 91,
    vkCmdDispatchGraphAMDX = 92,
    vkCmdDispatchGraphIndirectAMDX = 93,
    vkCmdDispatchGraphIndirectCountAMDX = 94,
    vkCmdDispatchIndirect = 95,
    vkCmdDraw = 96,
    vkCmdDrawClusterHUAWEI = 97,
    vkCmdDrawClusterIndirectHUAWEI = 98,
    vkCmdDrawIndexed = 99,
    vkCmdDrawIndexedIndirect = 100,
    vkCmdDrawIndexedIndirectCount = 101,
    vkCmdDrawIndexedIndirectCountAMD = 102,
    vkCmdDrawIndexedIndirectCountKHR = 103,
    vkCmdDrawIndirect = 104,
    vkCmdDrawIndirectByteCountEXT = 105,
    vkCmdDrawIndirectCount = 106,
    vkCmdDrawIndirectCountAMD = 107,
    vkCmdDrawIndirectCountKHR = 108,
    vkCmdDrawMeshTasksEXT = 109,
    vkCmdDrawMeshTasksIndirectCountEXT = 110,
    vkCmdDrawMeshTasksIndirectCountNV = 111,
    vkCmdDrawMeshTasksIndirectEXT = 112,
    vkCmdDrawMeshTasksIndirectNV = 113,
    vkCmdDrawMeshTasksNV = 114,
    vkCmdDrawMultiEXT = 115,
    vkCmdDrawMultiIndexedEXT = 116,
    vkCmdEncodeVideoKHR = 117,
    vkCmdEndConditionalRenderingEXT = 118,
    vkCmdEndDebugUtilsLabelEXT = 119,
    vkCmdEndQuery = 120,
    vkCmdEndQueryIndexedEXT = 121,
    vkCmdEndRenderPass = 122,
    vkCmdEndRenderPass2 = 123,
    vkCmdEndRenderPass2KHR = 124,
    vkCmdEndRendering = 125,
    vkCmdEndRenderingKHR = 126,
    vkCmdEndTransformFeedbackEXT = 127,
    vkCmdEndVideoCodingKHR = 128,
    vkCmdExecuteCommands = 129,
    vkCmdExecuteGeneratedCommandsNV = 130,
    vkCmdFillBuffer = 131,
    vkCmdInitializeGraphScratchMemoryAMDX = 132,
    vkCmdInsertDebugUtilsLabelEXT = 133,
    vkCmdNextSubpass = 134,
    vkCmdNextSubpass2 = 135,
    vkCmdNextSubpass2KHR = 136,
    vkCmdOpticalFlowExecuteNV = 137,
    vkCmdPipelineBarrier = 138,
    vkCmdPipelineBarrier2 = 139,
    vkCmdPipelineBarrier2KHR = 140,
    vkCmdPreprocessGeneratedCommandsNV = 141,
    vkCmdPushConstants = 142,
    vkCmdPushDescriptorSetKHR = 143,
    vkCmdPushDescriptorSetWithTemplateKHR = 144,
    vkCmdResetEvent = 145,
    vkCmdResetEvent2 = 146,
    vkCmdResetEvent2KHR = 147,
    vkCmdResetQueryPool = 148,
    vkCmdResolveImage = 149,
    vkCmdResolveImage2 = 150,
    vkCmdResolveImage2KHR = 151,
    vkCmdSetAlphaToCoverageEnableEXT = 152,
    vkCmdSetAlphaToOneEnableEXT = 153,
    vkCmdSetAttachmentFeedbackLoopEnableEXT = 154,
    vkCmdSetBlendConstants = 155,
    vkCmdSetCheckpointNV = 156,
    vkCmdSetCoarseSampleOrderNV = 157,
    vkCmdSetColorBlendAdvancedEXT = 158,
    vkCmdSetColorBlendEnableEXT = 159,
    vkCmdSetColorBlendEquationEXT = 160,
    vkCmdSetColorWriteEnableEXT = 161,
    vkCmdSetColorWriteMaskEXT = 162,
    vkCmdSetConservativeRasterizationModeEXT = 163,
    vkCmdSetCoverageModulationModeNV = 164,
    vkCmdSetCoverageModulationTableEnableNV = 165,
    vkCmdSetCoverageModulationTableNV = 166,
    vkCmdSetCoverageReductionModeNV = 167,
    vkCmdSetCoverageToColorEnableNV = 168,
    vkCmdSetCoverageToColorLocationNV = 169,
    vkCmdSetCullMode = 170,
    vkCmdSetCullModeEXT = 171,
    vkCmdSetDepthBias = 172,
    vkCmdSetDepthBias2EXT = 173,
    vkCmdSetDepthBiasEnable = 174,
    vkCmdSetDepthBiasEnableEXT = 175,
    vkCmdSetDepthBounds = 176,
    vkCmdSetDepthBoundsTestEnable = 177,
    vkCmdSetDepthBoundsTestEnableEXT = 178,
    vkCmdSetDepthClampEnableEXT = 179,
    vkCmdSetDepthClipEnableEXT = 180,
    vkCmdSetDepthClipNegativeOneToOneEXT = 181,
    vkCmdSetDepthCompareOp = 182,
    vkCmdSetDepthCompareOpEXT = 183,
    vkCmdSetDepthTestEnable = 184,
    vkCmdSetDepthTestEnableEXT = 185,
    vkCmdSetDepthWriteEnable = 186,
    vkCmdSetDepthWriteEnableEXT = 187,
    vkCmdSetDescriptorBufferOffsetsEXT = 188,
    vkCmdSetDeviceMask = 189,
    vkCmdSetDeviceMaskKHR = 190,
    vkCmdSetDiscardRectangleEXT = 191,
    vkCmdSetDiscardRectangleEnableEXT = 192,
    vkCmdSetDiscardRectangleModeEXT = 193,
    vkCmdSetEvent = 194,
    vkCmdSetEvent2 = 195,
    vkCmdSetEvent2KHR = 196,
    vkCmdSetExclusiveScissorEnableNV = 197,
    vkCmdSetExclusiveScissorNV = 198,
    vkCmdSetExtraPrimitiveOverestimationSizeEXT = 199,
    vkCmdSetFragmentShadingRateEnumNV = 200,
    vkCmdSetFragmentShadingRateKHR = 201,
    vkCmdSetFrontFace = 202,
    vkCmdSetFrontFaceEXT = 203,
    vkCmdSetLineRasterizationModeEXT = 204,
    vkCmdSetLineStippleEXT = 205,
    vkCmdSetLineStippleEnableEXT = 206,
    vkCmdSetLineWidth = 207,
    vkCmdSetLogicOpEXT = 208,
    vkCmdSetLogicOpEnableEXT = 209,
    vkCmdSetPatchControlPointsEXT = 210,
    vkCmdSetPerformanceMarkerINTEL = 211,
    vkCmdSetPerformanceOverrideINTEL = 212,
    vkCmdSetPerformanceStreamMarkerINTEL = 213,
    vkCmdSetPolygonModeEXT = 214,
    vkCmdSetPrimitiveRestartEnable = 215,
    vkCmdSetPrimitiveRestartEnableEXT = 216,
    vkCmdSetPrimitiveTopology = 217,
    vkCmdSetPrimitiveTopologyEXT = 218,
    vkCmdSetProvokingVertexModeEXT = 219,
    vkCmdSetRasterizationSamplesEXT = 220,
    vkCmdSetRasterizationStreamEXT = 221,
    vkCmdSetRasterizerDiscardEnable = 222,
    vkCmdSetRasterizerDiscardEnableEXT = 223,
    vkCmdSetRayTracingPipelineStackSizeKHR = 224,
    vkCmdSetRepresentativeFragmentTestEnableNV = 225,
    vkCmdSetSampleLocationsEXT = 226,
    vkCmdSetSampleLocationsEnableEXT = 227,
    vkCmdSetSampleMaskEXT = 228,
    vkCmdSetScissor = 229,
    vkCmdSetScissorWithCount = 230,
    vkCmdSetScissorWithCountEXT = 231,
    vkCmdSetShadingRateImageEnableNV = 232,
    vkCmdSetStencilCompareMask = 233,
    vkCmdSetStencilOp = 234,
    vkCmdSetStencilOpEXT = 235,
    vkCmdSetStencilReference = 236,
    vkCmdSetStencilTestEnable = 237,
    vkCmdSetStencilTestEnableEXT = 238,
    vkCmdSetStencilWriteMask = 239,
    vkCmdSetTessellationDomainOriginEXT = 240,
    vkCmdSetVertexInputEXT = 241,
    vkCmdSetViewport = 242,
    vkCmdSetViewportShadingRatePaletteNV = 243,
    vkCmdSetViewportSwizzleNV = 244,
    vkCmdSetViewportWScalingEnableNV = 245,
    vkCmdSetViewportWScalingNV = 246,
    vkCmdSetViewportWithCount = 247,
    vkCmdSetViewportWithCountEXT = 248,
    vkCmdSubpassShadingHUAWEI = 249,
    vkCmdTraceRaysIndirect2KHR = 250,
    vkCmdTraceRaysIndirectKHR = 251,
    vkCmdTraceRaysKHR = 252,
    vkCmdTraceRaysNV = 253,
    vkCmdUpdateBuffer = 254,
    vkCmdUpdatePipelineIndirectBufferNV = 255,
    vkCmdWaitEvents = 256,
    vkCmdWaitEvents2 = 257,
    vkCmdWaitEvents2KHR = 258,
    vkCmdWriteAccelerationStructuresPropertiesKHR = 259,
    vkCmdWriteAccelerationStructuresPropertiesNV = 260,
    vkCmdWriteBufferMarker2AMD = 261,
    vkCmdWriteBufferMarkerAMD = 262,
    vkCmdWriteMicromapsPropertiesEXT = 263,
    vkCmdWriteTimestamp = 264,
    vkCmdWriteTimestamp2 = 265,
    vkCmdWriteTimestamp2KHR = 266,
    vkCompileDeferredNV = 267,
    vkCopyAccelerationStructureKHR = 268,
    vkCopyAccelerationStructureToMemoryKHR = 269,
    vkCopyImageToImageEXT = 270,
    vkCopyImageToMemoryEXT = 271,
    vkCopyMemoryToAccelerationStructureKHR = 272,
    vkCopyMemoryToImageEXT = 273,
    vkCopyMemoryToMicromapEXT = 274,
    vkCopyMicromapEXT = 275,
    vkCopyMicromapToMemoryEXT = 276,
    vkCreateAccelerationStructureKHR = 277,
    vkCreateAccelerationStructureNV = 278,
    vkCreateAndroidSurfaceKHR = 279,
    vkCreateBuffer = 280,
    vkCreateBufferCollectionFUCHSIA = 281,
    vkCreateBufferView = 282,
    vkCreateCommandPool = 283,
    vkCreateComputePipelines = 284,
    vkCreateCuFunctionNVX = 285,
    vkCreateCuModuleNVX = 286,
    vkCreateDebugReportCallbackEXT = 287,
    vkCreateDebugUtilsMessengerEXT = 288,
    vkCreateDeferredOperationKHR = 289,
    vkCreateDescriptorPool = 290,
    vkCreateDescriptorSetLayout = 291,
    vkCreateDescriptorUpdateTemplate = 292,
    vkCreateDescriptorUpdateTemplateKHR = 293,
    vkCreateDevice = 294,
    vkCreateDirectFBSurfaceEXT = 295,
    vkCreateDisplayModeKHR = 296,
    vkCreateDisplayPlaneSurfaceKHR = 297,
    vkCreateEvent = 298,
    vkCreateExecutionGraphPipelinesAMDX = 299,
    vkCreateFence = 300,
    vkCreateFramebuffer = 301,
    vkCreateGraphicsPipelines = 302,
    vkCreateHeadlessSurfaceEXT = 303,
    vkCreateIOSSurfaceMVK = 304,
    vkCreateImage = 305,
    vkCreateImagePipeSurfaceFUCHSIA = 306,
    vkCreateImageView = 307,
    vkCreateIndirectCommandsLayoutNV = 308,
    vkCreateInstance = 309,
    vkCreateMacOSSurfaceMVK = 310,
    vkCreateMetalSurfaceEXT = 311,
    vkCreateMicromapEXT = 312,
    vkCreateOpticalFlowSessionNV = 313,
    vkCreatePipelineCache = 314,
    vkCreatePipelineLayout = 315,
    vkCreatePrivateDataSlot = 316,
    vkCreatePrivateDataSlotEXT = 317,
    vkCreateQueryPool = 318,
    vkCreateRayTracingPipelinesKHR = 319,
    vkCreateRayTracingPipelinesNV = 320,
    vkCreateRenderPass = 321,
    vkCreateRenderPass2 = 322,
    vkCreateRenderPass2KHR = 323,
    vkCreateSampler = 324,
    vkCreateSamplerYcbcrConversion = 325,
    vkCreateSamplerYcbcrConversionKHR = 326,
    vkCreateScreenSurfaceQNX = 327,
    vkCreateSemaphore = 328,
    vkCreateShaderModule = 329,
    vkCreateShadersEXT = 330,
    vkCreateSharedSwapchainsKHR = 331,
    vkCreateStreamDescriptorSurfaceGGP = 332,
    vkCreateSwapchainKHR = 333,
    vkCreateValidationCacheEXT = 334,
    vkCreateViSurfaceNN = 335,
    vkCreateVideoSessionKHR = 336,
    vkCreateVideoSessionParametersKHR = 337,
    vkCreateWaylandSurfaceKHR = 338,
    vkCreateWin32SurfaceKHR = 339,
    vkCreateXcbSurfaceKHR = 340,
    vkCreateXlibSurfaceKHR = 341,
    vkDebugMarkerSetObjectNameEXT = 342,
    vkDebugMarkerSetObjectTagEXT = 343,
    vkDebugReportMessageEXT = 344,
    vkDeferredOperationJoinKHR = 345,
    vkDestroyAccelerationStructureKHR = 346,
    vkDestroyAccelerationStructureNV = 347,
    vkDestroyBuffer = 348,
    vkDestroyBufferCollectionFUCHSIA = 349,
    vkDestroyBufferView = 350,
    vkDestroyCommandPool = 351,
    vkDestroyCuFunctionNVX = 352,
    vkDestroyCuModuleNVX = 353,
    vkDestroyDebugReportCallbackEXT = 354,
    vkDestroyDebugUtilsMessengerEXT = 355,
    vkDestroyDeferredOperationKHR = 356,
    vkDestroyDescriptorPool = 357,
    vkDestroyDescriptorSetLayout = 358,
    vkDestroyDescriptorUpdateTemplate = 359,
    vkDestroyDescriptorUpdateTemplateKHR = 360,
    vkDestroyDevice = 361,
    vkDestroyEvent = 362,
    vkDestroyFence = 363,
    vkDestroyFramebuffer = 364,
    vkDestroyImage = 365,
    vkDestroyImageView = 366,
    vkDestroyIndirectCommandsLayoutNV = 367,
    vkDestroyInstance = 368,
    vkDestroyMicromapEXT = 369,
    vkDestroyOpticalFlowSessionNV = 370,
    vkDestroyPipeline = 371,
    vkDestroyPipelineCache = 372,
    vkDestroyPipelineLayout = 373,
    vkDestroyPrivateDataSlot = 374,
    vkDestroyPrivateDataSlotEXT = 375,
    vkDestroyQueryPool = 376,
    vkDestroyRenderPass = 377,
    vkDestroySampler = 378,
    vkDestroySamplerYcbcrConversion = 379,
    vkDestroySamplerYcbcrConversionKHR = 380,
    vkDestroySemaphore = 381,
    vkDestroyShaderEXT = 382,
    vkDestroyShaderModule = 383,
    vkDestroySurfaceKHR = 384,
    vkDestroySwapchainKHR = 385,
    vkDestroyValidationCacheEXT = 386,
    vkDestroyVideoSessionKHR = 387,
    vkDestroyVideoSessionParametersKHR = 388,
    vkDeviceWaitIdle = 389,
    vkDisplayPowerControlEXT = 390,
    vkEndCommandBuffer = 391,
    vkEnumerateDeviceExtensionProperties = 392,
    vkEnumerateDeviceLayerProperties = 393,
    vkEnumerateInstanceExtensionProperties = 394,
    vkEnumerateInstanceLayerProperties = 395,
    vkEnumerateInstanceVersion = 396,
    vkEnumeratePhysicalDeviceGroups = 397,
    vkEnumeratePhysicalDeviceGroupsKHR = 398,
    vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = 399,
    vkEnumeratePhysicalDevices = 400,
    vkExportMetalObjectsEXT = 401,
    vkFlushMappedMemoryRanges = 402,
    vkFreeCommandBuffers = 403,
    vkFreeDescriptorSets = 404,
    vkFreeMemory = 405,
    vkGetAccelerationStructureBuildSizesKHR = 406,
    vkGetAccelerationStructureDeviceAddressKHR = 407,
    vkGetAccelerationStructureHandleNV = 408,
    vkGetAccelerationStructureMemoryRequirementsNV = 409,
    vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT = 410,
    vkGetAndroidHardwareBufferPropertiesANDROID = 411,
    vkGetBufferCollectionPropertiesFUCHSIA = 412,
    vkGetBufferDeviceAddress = 413,
    vkGetBufferDeviceAddressEXT = 414,
    vkGetBufferDeviceAddressKHR = 415,
    vkGetBufferMemoryRequirements = 416,
    vkGetBufferMemoryRequirements2 = 417,
    vkGetBufferMemoryRequirements2KHR = 418,
    vkGetBufferOpaqueCaptureAddress = 419,
    vkGetBufferOpaqueCaptureAddressKHR = 420,
    vkGetBufferOpaqueCaptureDescriptorDataEXT = 421,
    vkGetCalibratedTimestampsEXT = 422,
    vkGetDeferredOperationMaxConcurrencyKHR = 423,
    vkGetDeferredOperationResultKHR = 424,
    vkGetDescriptorEXT = 425,
    vkGetDescriptorSetHostMappingVALVE = 426,
    vkGetDescriptorSetLayoutBindingOffsetEXT = 427,
    vkGetDescriptorSetLayoutHostMappingInfoVALVE = 428,
    vkGetDescriptorSetLayoutSizeEXT = 429,
    vkGetDescriptorSetLayoutSupport = 430,
    vkGetDescriptorSetLayoutSupportKHR = 431,
    vkGetDeviceAccelerationStructureCompatibilityKHR = 432,
    vkGetDeviceBufferMemoryRequirements = 433,
    vkGetDeviceBufferMemoryRequirementsKHR = 434,
    vkGetDeviceFaultInfoEXT = 435,
    vkGetDeviceGroupPeerMemoryFeatures = 436,
    vkGetDeviceGroupPeerMemoryFeaturesKHR = 437,
    vkGetDeviceGroupPresentCapabilitiesKHR = 438,
    vkGetDeviceGroupSurfacePresentModes2EXT = 439,
    vkGetDeviceGroupSurfacePresentModesKHR = 440,
    vkGetDeviceImageMemoryRequirements = 441,
    vkGetDeviceImageMemoryRequirementsKHR = 442,
    vkGetDeviceImageSparseMemoryRequirements = 443,
    vkGetDeviceImageSparseMemoryRequirementsKHR = 444,
    vkGetDeviceImageSubresourceLayoutKHR = 445,
    vkGetDeviceMemoryCommitment = 446,
    vkGetDeviceMemoryOpaqueCaptureAddress = 447,
    vkGetDeviceMemoryOpaqueCaptureAddressKHR = 448,
    vkGetDeviceMicromapCompatibilityEXT = 449,
    vkGetDeviceProcAddr = 450,
    vkGetDeviceQueue = 451,
    vkGetDeviceQueue2 = 452,
    vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI = 453,
    vkGetDisplayModeProperties2KHR = 454,
    vkGetDisplayModePropertiesKHR = 455,
    vkGetDisplayPlaneCapabilities2KHR = 456,
    vkGetDisplayPlaneCapabilitiesKHR = 457,
    vkGetDisplayPlaneSupportedDisplaysKHR = 458,
    vkGetDrmDisplayEXT = 459,
    vkGetDynamicRenderingTilePropertiesQCOM = 460,
    vkGetEncodedVideoSessionParametersKHR = 461,
    vkGetEventStatus = 462,
    vkGetExecutionGraphPipelineNodeIndexAMDX = 463,
    vkGetExecutionGraphPipelineScratchSizeAMDX = 464,
    vkGetFenceFdKHR = 465,
    vkGetFenceStatus = 466,
    vkGetFenceWin32HandleKHR = 467,
    vkGetFramebufferTilePropertiesQCOM = 468,
    vkGetGeneratedCommandsMemoryRequirementsNV = 469,
    vkGetImageDrmFormatModifierPropertiesEXT = 470,
    vkGetImageMemoryRequirements = 471,
    vkGetImageMemoryRequirements2 = 472,
    vkGetImageMemoryRequirements2KHR = 473,
    vkGetImageOpaqueCaptureDescriptorDataEXT = 474,
    vkGetImageSparseMemoryRequirements = 475,
    vkGetImageSparseMemoryRequirements2 = 476,
    vkGetImageSparseMemoryRequirements2KHR = 477,
    vkGetImageSubresourceLayout = 478,
    vkGetImageSubresourceLayout2EXT = 479,
    vkGetImageSubresourceLayout2KHR = 480,
    vkGetImageViewAddressNVX = 481,
    vkGetImageViewHandleNVX = 482,
    vkGetImageViewOpaqueCaptureDescriptorDataEXT = 483,
    vkGetInstanceProcAddr = 484,
    vkGetMemoryAndroidHardwareBufferANDROID = 485,
    vkGetMemoryFdKHR = 486,
    vkGetMemoryFdPropertiesKHR = 487,
    vkGetMemoryHostPointerPropertiesEXT = 488,
    vkGetMemoryRemoteAddressNV = 489,
    vkGetMemoryWin32HandleKHR = 490,
    vkGetMemoryWin32HandleNV = 491,
    vkGetMemoryWin32HandlePropertiesKHR = 492,
    vkGetMemoryZirconHandleFUCHSIA = 493,
    vkGetMemoryZirconHandlePropertiesFUCHSIA = 494,
    vkGetMicromapBuildSizesEXT = 495,
    vkGetPastPresentationTimingGOOGLE = 496,
    vkGetPerformanceParameterINTEL = 497,
    vkGetPhysicalDeviceCalibrateableTimeDomainsEXT = 498,
    vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR = 499,
    vkGetPhysicalDeviceCooperativeMatrixPropertiesNV = 500,
    vkGetPhysicalDeviceDirectFBPresentationSupportEXT = 501,
    vkGetPhysicalDeviceDisplayPlaneProperties2KHR = 502,
    vkGetPhysicalDeviceDisplayPlanePropertiesKHR = 503,
    vkGetPhysicalDeviceDisplayProperties2KHR = 504,
    vkGetPhysicalDeviceDisplayPropertiesKHR = 505,
    vkGetPhysicalDeviceExternalBufferProperties = 506,
    vkGetPhysicalDeviceExternalBufferPropertiesKHR = 507,
    vkGetPhysicalDeviceExternalFenceProperties = 508,
    vkGetPhysicalDeviceExternalFencePropertiesKHR = 509,
    vkGetPhysicalDeviceExternalImageFormatPropertiesNV = 510,
    vkGetPhysicalDeviceExternalSemaphoreProperties = 511,
    vkGetPhysicalDeviceExternalSemaphorePropertiesKHR = 512,
    vkGetPhysicalDeviceFeatures = 513,
    vkGetPhysicalDeviceFeatures2 = 514,
    vkGetPhysicalDeviceFeatures2KHR = 515,
    vkGetPhysicalDeviceFormatProperties = 516,
    vkGetPhysicalDeviceFormatProperties2 = 517,
    vkGetPhysicalDeviceFormatProperties2KHR = 518,
    vkGetPhysicalDeviceFragmentShadingRatesKHR = 519,
    vkGetPhysicalDeviceImageFormatProperties = 520,
    vkGetPhysicalDeviceImageFormatProperties2 = 521,
    vkGetPhysicalDeviceImageFormatProperties2KHR = 522,
    vkGetPhysicalDeviceMemoryProperties = 523,
    vkGetPhysicalDeviceMemoryProperties2 = 524,
    vkGetPhysicalDeviceMemoryProperties2KHR = 525,
    vkGetPhysicalDeviceMultisamplePropertiesEXT = 526,
    vkGetPhysicalDeviceOpticalFlowImageFormatsNV = 527,
    vkGetPhysicalDevicePresentRectanglesKHR = 528,
    vkGetPhysicalDeviceProperties = 529,
    vkGetPhysicalDeviceProperties2 = 530,
    vkGetPhysicalDeviceProperties2KHR = 531,
    vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = 532,
    vkGetPhysicalDeviceQueueFamilyProperties = 533,
    vkGetPhysicalDeviceQueueFamilyProperties2 = 534,
    vkGetPhysicalDeviceQueueFamilyProperties2KHR = 535,
    vkGetPhysicalDeviceScreenPresentationSupportQNX = 536,
    vkGetPhysicalDeviceSparseImageFormatProperties = 537,
    vkGetPhysicalDeviceSparseImageFormatProperties2 = 538,
    vkGetPhysicalDeviceSparseImageFormatProperties2KHR = 539,
    vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = 540,
    vkGetPhysicalDeviceSurfaceCapabilities2EXT = 541,
    vkGetPhysicalDeviceSurfaceCapabilities2KHR = 542,
    vkGetPhysicalDeviceSurfaceCapabilitiesKHR = 543,
    vkGetPhysicalDeviceSurfaceFormats2KHR = 544,
    vkGetPhysicalDeviceSurfaceFormatsKHR = 545,
    vkGetPhysicalDeviceSurfacePresentModes2EXT = 546,
    vkGetPhysicalDeviceSurfacePresentModesKHR = 547,
    vkGetPhysicalDeviceSurfaceSupportKHR = 548,
    vkGetPhysicalDeviceToolProperties = 549,
    vkGetPhysicalDeviceToolPropertiesEXT = 550,
    vkGetPhysicalDeviceVideoCapabilitiesKHR = 551,
    vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = 552,
    vkGetPhysicalDeviceVideoFormatPropertiesKHR = 553,
    vkGetPhysicalDeviceWaylandPresentationSupportKHR = 554,
    vkGetPhysicalDeviceWin32PresentationSupportKHR = 555,
    vkGetPhysicalDeviceXcbPresentationSupportKHR = 556,
    vkGetPhysicalDeviceXlibPresentationSupportKHR = 557,
    vkGetPipelineCacheData = 558,
    vkGetPipelineExecutableInternalRepresentationsKHR = 559,
    vkGetPipelineExecutablePropertiesKHR = 560,
    vkGetPipelineExecutableStatisticsKHR = 561,
    vkGetPipelineIndirectDeviceAddressNV = 562,
    vkGetPipelineIndirectMemoryRequirementsNV = 563,
    vkGetPipelinePropertiesEXT = 564,
    vkGetPrivateData = 565,
    vkGetPrivateDataEXT = 566,
    vkGetQueryPoolResults = 567,
    vkGetQueueCheckpointData2NV = 568,
    vkGetQueueCheckpointDataNV = 569,
    vkGetRandROutputDisplayEXT = 570,
    vkGetRayTracingCaptureReplayShaderGroupHandlesKHR = 571,
    vkGetRayTracingShaderGroupHandlesKHR = 572,
    vkGetRayTracingShaderGroupHandlesNV = 573,
    vkGetRayTracingShaderGroupStackSizeKHR = 574,
    vkGetRefreshCycleDurationGOOGLE = 575,
    vkGetRenderAreaGranularity = 576,
    vkGetRenderingAreaGranularityKHR = 577,
    vkGetSamplerOpaqueCaptureDescriptorDataEXT = 578,
    vkGetScreenBufferPropertiesQNX = 579,
    vkGetSemaphoreCounterValue = 580,
    vkGetSemaphoreCounterValueKHR = 581,
    vkGetSemaphoreFdKHR = 582,
    vkGetSemaphoreWin32HandleKHR = 583,
    vkGetSemaphoreZirconHandleFUCHSIA = 584,
    vkGetShaderBinaryDataEXT = 585,
    vkGetShaderInfoAMD = 586,
    vkGetShaderModuleCreateInfoIdentifierEXT = 587,
    vkGetShaderModuleIdentifierEXT = 588,
    vkGetSwapchainCounterEXT = 589,
    vkGetSwapchainImagesKHR = 590,
    vkGetSwapchainStatusKHR = 591,
    vkGetValidationCacheDataEXT = 592,
    vkGetVideoSessionMemoryRequirementsKHR = 593,
    vkGetWinrtDisplayNV = 594,
    vkImportFenceFdKHR = 595,
    vkImportFenceWin32HandleKHR = 596,
    vkImportSemaphoreFdKHR = 597,
    vkImportSemaphoreWin32HandleKHR = 598,
    vkImportSemaphoreZirconHandleFUCHSIA = 599,
    vkInitializePerformanceApiINTEL = 600,
    vkInvalidateMappedMemoryRanges = 601,
    vkMapMemory = 602,
    vkMapMemory2KHR = 603,
    vkMergePipelineCaches = 604,
    vkMergeValidationCachesEXT = 605,
    vkQueueBeginDebugUtilsLabelEXT = 606,
    vkQueueBindSparse = 607,
    vkQueueEndDebugUtilsLabelEXT = 608,
    vkQueueInsertDebugUtilsLabelEXT = 609,
    vkQueuePresentKHR = 610,
    vkQueueSetPerformanceConfigurationINTEL = 611,
    vkQueueSubmit = 612,
    vkQueueSubmit2 = 613,
    vkQueueSubmit2KHR = 614,
    vkQueueWaitIdle = 615,
    vkRegisterDeviceEventEXT = 616,
    vkRegisterDisplayEventEXT = 617,
    vkReleaseDisplayEXT = 618,
    vkReleaseFullScreenExclusiveModeEXT = 619,
    vkReleasePerformanceConfigurationINTEL = 620,
    vkReleaseProfilingLockKHR = 621,
    vkReleaseSwapchainImagesEXT = 622,
    vkResetCommandBuffer = 623,
    vkResetCommandPool = 624,
    vkResetDescriptorPool = 625,
    vkResetEvent = 626,
    vkResetFences = 627,
    vkResetQueryPool = 628,
    vkResetQueryPoolEXT = 629,
    vkSetBufferCollectionBufferConstraintsFUCHSIA = 630,
    vkSetBufferCollectionImageConstraintsFUCHSIA = 631,
    vkSetDebugUtilsObjectNameEXT = 632,
    vkSetDebugUtilsObjectTagEXT = 633,
    vkSetDeviceMemoryPriorityEXT = 634,
    vkSetEvent = 635,
    vkSetHdrMetadataEXT = 636,
    vkSetLocalDimmingAMD = 637,
    vkSetPrivateData = 638,
    vkSetPrivateDataEXT = 639,
    vkSignalSemaphore = 640,
    vkSignalSemaphoreKHR = 641,
    vkSubmitDebugUtilsMessageEXT = 642,
    vkTransitionImageLayoutEXT = 643,
    vkTrimCommandPool = 644,
    vkTrimCommandPoolKHR = 645,
    vkUninitializePerformanceApiINTEL = 646,
    vkUnmapMemory = 647,
    vkUnmapMemory2KHR = 648,
    vkUpdateDescriptorSetWithTemplate = 649,
    vkUpdateDescriptorSetWithTemplateKHR = 650,
    vkUpdateDescriptorSets = 651,
    vkUpdateVideoSessionParametersKHR = 652,
    vkWaitForFences = 653,
    vkWaitForPresentKHR = 654,
    vkWaitSemaphores = 655,
    vkWaitSemaphoresKHR = 656,
    vkWriteAccelerationStructuresPropertiesKHR = 657,
    vkWriteMicromapsPropertiesEXT = 658,
};

enum class Struct {
    Empty = 0,
    VkAabbPositionsKHR,
    VkAccelerationStructureBuildGeometryInfoKHR,
    VkAccelerationStructureBuildRangeInfoKHR,
    VkAccelerationStructureBuildSizesInfoKHR,
    VkAccelerationStructureCaptureDescriptorDataInfoEXT,
    VkAccelerationStructureCreateInfoKHR,
    VkAccelerationStructureCreateInfoNV,
    VkAccelerationStructureDeviceAddressInfoKHR,
    VkAccelerationStructureGeometryAabbsDataKHR,
    VkAccelerationStructureGeometryDataKHR,
    VkAccelerationStructureGeometryInstancesDataKHR,
    VkAccelerationStructureGeometryKHR,
    VkAccelerationStructureGeometryMotionTrianglesDataNV,
    VkAccelerationStructureGeometryTrianglesDataKHR,
    VkAccelerationStructureInfoNV,
    VkAccelerationStructureInstanceKHR,
    VkAccelerationStructureMatrixMotionInstanceNV,
    VkAccelerationStructureMemoryRequirementsInfoNV,
    VkAccelerationStructureMotionInfoNV,
    VkAccelerationStructureMotionInstanceDataNV,
    VkAccelerationStructureMotionInstanceNV,
    VkAccelerationStructureSRTMotionInstanceNV,
    VkAccelerationStructureTrianglesDisplacementMicromapNV,
    VkAccelerationStructureTrianglesOpacityMicromapEXT,
    VkAccelerationStructureVersionInfoKHR,
    VkAcquireNextImageInfoKHR,
    VkAcquireProfilingLockInfoKHR,
    VkAllocationCallbacks,
    VkAmigoProfilingSubmitInfoSEC,
    VkAndroidHardwareBufferFormatProperties2ANDROID,
    VkAndroidHardwareBufferFormatPropertiesANDROID,
    VkAndroidHardwareBufferPropertiesANDROID,
    VkAndroidHardwareBufferUsageANDROID,
    VkAndroidSurfaceCreateInfoKHR,
    VkApplicationInfo,
    VkAttachmentDescription,
    VkAttachmentDescription2,
    VkAttachmentDescriptionStencilLayout,
    VkAttachmentReference,
    VkAttachmentReference2,
    VkAttachmentReferenceStencilLayout,
    VkAttachmentSampleCountInfoAMD,
    VkAttachmentSampleLocationsEXT,
    VkBaseInStructure,
    VkBaseOutStructure,
    VkBindAccelerationStructureMemoryInfoNV,
    VkBindBufferMemoryDeviceGroupInfo,
    VkBindBufferMemoryInfo,
    VkBindImageMemoryDeviceGroupInfo,
    VkBindImageMemoryInfo,
    VkBindImageMemorySwapchainInfoKHR,
    VkBindImagePlaneMemoryInfo,
    VkBindIndexBufferIndirectCommandNV,
    VkBindPipelineIndirectCommandNV,
    VkBindShaderGroupIndirectCommandNV,
    VkBindSparseInfo,
    VkBindVertexBufferIndirectCommandNV,
    VkBindVideoSessionMemoryInfoKHR,
    VkBlitImageInfo2,
    VkBufferCaptureDescriptorDataInfoEXT,
    VkBufferCollectionBufferCreateInfoFUCHSIA,
    VkBufferCollectionConstraintsInfoFUCHSIA,
    VkBufferCollectionCreateInfoFUCHSIA,
    VkBufferCollectionImageCreateInfoFUCHSIA,
    VkBufferCollectionPropertiesFUCHSIA,
    VkBufferConstraintsInfoFUCHSIA,
    VkBufferCopy,
    VkBufferCopy2,
    VkBufferCreateInfo,
    VkBufferDeviceAddressCreateInfoEXT,
    VkBufferDeviceAddressInfo,
    VkBufferImageCopy,
    VkBufferImageCopy2,
    VkBufferMemoryBarrier,
    VkBufferMemoryBarrier2,
    VkBufferMemoryRequirementsInfo2,
    VkBufferOpaqueCaptureAddressCreateInfo,
    VkBufferUsageFlags2CreateInfoKHR,
    VkBufferViewCreateInfo,
    VkCalibratedTimestampInfoEXT,
    VkCheckpointData2NV,
    VkCheckpointDataNV,
    VkClearAttachment,
    VkClearColorValue,
    VkClearDepthStencilValue,
    VkClearRect,
    VkClearValue,
    VkCoarseSampleLocationNV,
    VkCoarseSampleOrderCustomNV,
    VkColorBlendAdvancedEXT,
    VkColorBlendEquationEXT,
    VkCommandBufferAllocateInfo,
    VkCommandBufferBeginInfo,
    VkCommandBufferInheritanceConditionalRenderingInfoEXT,
    VkCommandBufferInheritanceInfo,
    VkCommandBufferInheritanceRenderPassTransformInfoQCOM,
    VkCommandBufferInheritanceRenderingInfo,
    VkCommandBufferInheritanceViewportScissorInfoNV,
    VkCommandBufferSubmitInfo,
    VkCommandPoolCreateInfo,
    VkComponentMapping,
    VkComputePipelineCreateInfo,
    VkComputePipelineIndirectBufferInfoNV,
    VkConditionalRenderingBeginInfoEXT,
    VkConformanceVersion,
    VkCooperativeMatrixPropertiesKHR,
    VkCooperativeMatrixPropertiesNV,
    VkCopyAccelerationStructureInfoKHR,
    VkCopyAccelerationStructureToMemoryInfoKHR,
    VkCopyBufferInfo2,
    VkCopyBufferToImageInfo2,
    VkCopyCommandTransformInfoQCOM,
    VkCopyDescriptorSet,
    VkCopyImageInfo2,
    VkCopyImageToBufferInfo2,
    VkCopyImageToImageInfoEXT,
    VkCopyImageToMemoryInfoEXT,
    VkCopyMemoryIndirectCommandNV,
    VkCopyMemoryToAccelerationStructureInfoKHR,
    VkCopyMemoryToImageIndirectCommandNV,
    VkCopyMemoryToImageInfoEXT,
    VkCopyMemoryToMicromapInfoEXT,
    VkCopyMicromapInfoEXT,
    VkCopyMicromapToMemoryInfoEXT,
    VkCuFunctionCreateInfoNVX,
    VkCuLaunchInfoNVX,
    VkCuModuleCreateInfoNVX,
    VkD3D12FenceSubmitInfoKHR,
    VkDebugMarkerMarkerInfoEXT,
    VkDebugMarkerObjectNameInfoEXT,
    VkDebugMarkerObjectTagInfoEXT,
    VkDebugReportCallbackCreateInfoEXT,
    VkDebugUtilsLabelEXT,
    VkDebugUtilsMessengerCallbackDataEXT,
    VkDebugUtilsMessengerCreateInfoEXT,
    VkDebugUtilsObjectNameInfoEXT,
    VkDebugUtilsObjectTagInfoEXT,
    VkDecompressMemoryRegionNV,
    VkDedicatedAllocationBufferCreateInfoNV,
    VkDedicatedAllocationImageCreateInfoNV,
    VkDedicatedAllocationMemoryAllocateInfoNV,
    VkDependencyInfo,
    VkDepthBiasInfoEXT,
    VkDepthBiasRepresentationInfoEXT,
    VkDescriptorAddressInfoEXT,
    VkDescriptorBufferBindingInfoEXT,
    VkDescriptorBufferBindingPushDescriptorBufferHandleEXT,
    VkDescriptorBufferInfo,
    VkDescriptorDataEXT,
    VkDescriptorGetInfoEXT,
    VkDescriptorImageInfo,
    VkDescriptorPoolCreateInfo,
    VkDescriptorPoolInlineUniformBlockCreateInfo,
    VkDescriptorPoolSize,
    VkDescriptorSetAllocateInfo,
    VkDescriptorSetBindingReferenceVALVE,
    VkDescriptorSetLayoutBinding,
    VkDescriptorSetLayoutBindingFlagsCreateInfo,
    VkDescriptorSetLayoutCreateInfo,
    VkDescriptorSetLayoutHostMappingInfoVALVE,
    VkDescriptorSetLayoutSupport,
    VkDescriptorSetVariableDescriptorCountAllocateInfo,
    VkDescriptorSetVariableDescriptorCountLayoutSupport,
    VkDescriptorUpdateTemplateCreateInfo,
    VkDescriptorUpdateTemplateEntry,
    VkDeviceAddressBindingCallbackDataEXT,
    VkDeviceBufferMemoryRequirements,
    VkDeviceCreateInfo,
    VkDeviceDeviceMemoryReportCreateInfoEXT,
    VkDeviceDiagnosticsConfigCreateInfoNV,
    VkDeviceEventInfoEXT,
    VkDeviceFaultAddressInfoEXT,
    VkDeviceFaultCountsEXT,
    VkDeviceFaultInfoEXT,
    VkDeviceFaultVendorBinaryHeaderVersionOneEXT,
    VkDeviceFaultVendorInfoEXT,
    VkDeviceGroupBindSparseInfo,
    VkDeviceGroupCommandBufferBeginInfo,
    VkDeviceGroupDeviceCreateInfo,
    VkDeviceGroupPresentCapabilitiesKHR,
    VkDeviceGroupPresentInfoKHR,
    VkDeviceGroupRenderPassBeginInfo,
    VkDeviceGroupSubmitInfo,
    VkDeviceGroupSwapchainCreateInfoKHR,
    VkDeviceImageMemoryRequirements,
    VkDeviceImageSubresourceInfoKHR,
    VkDeviceMemoryOpaqueCaptureAddressInfo,
    VkDeviceMemoryOverallocationCreateInfoAMD,
    VkDeviceMemoryReportCallbackDataEXT,
    VkDeviceOrHostAddressConstAMDX,
    VkDeviceOrHostAddressConstKHR,
    VkDeviceOrHostAddressKHR,
    VkDevicePrivateDataCreateInfo,
    VkDeviceQueueCreateInfo,
    VkDeviceQueueGlobalPriorityCreateInfoKHR,
    VkDeviceQueueInfo2,
    VkDirectDriverLoadingInfoLUNARG,
    VkDirectDriverLoadingListLUNARG,
    VkDirectFBSurfaceCreateInfoEXT,
    VkDispatchGraphCountInfoAMDX,
    VkDispatchGraphInfoAMDX,
    VkDispatchIndirectCommand,
    VkDisplayEventInfoEXT,
    VkDisplayModeCreateInfoKHR,
    VkDisplayModeParametersKHR,
    VkDisplayModeProperties2KHR,
    VkDisplayModePropertiesKHR,
    VkDisplayNativeHdrSurfaceCapabilitiesAMD,
    VkDisplayPlaneCapabilities2KHR,
    VkDisplayPlaneCapabilitiesKHR,
    VkDisplayPlaneInfo2KHR,
    VkDisplayPlaneProperties2KHR,
    VkDisplayPlanePropertiesKHR,
    VkDisplayPowerInfoEXT,
    VkDisplayPresentInfoKHR,
    VkDisplayProperties2KHR,
    VkDisplayPropertiesKHR,
    VkDisplaySurfaceCreateInfoKHR,
    VkDrawIndexedIndirectCommand,
    VkDrawIndirectCommand,
    VkDrawMeshTasksIndirectCommandEXT,
    VkDrawMeshTasksIndirectCommandNV,
    VkDrmFormatModifierProperties2EXT,
    VkDrmFormatModifierPropertiesEXT,
    VkDrmFormatModifierPropertiesList2EXT,
    VkDrmFormatModifierPropertiesListEXT,
    VkEventCreateInfo,
    VkExecutionGraphPipelineCreateInfoAMDX,
    VkExecutionGraphPipelineScratchSizeAMDX,
    VkExportFenceCreateInfo,
    VkExportFenceWin32HandleInfoKHR,
    VkExportMemoryAllocateInfo,
    VkExportMemoryAllocateInfoNV,
    VkExportMemoryWin32HandleInfoKHR,
    VkExportMemoryWin32HandleInfoNV,
    VkExportMetalBufferInfoEXT,
    VkExportMetalCommandQueueInfoEXT,
    VkExportMetalDeviceInfoEXT,
    VkExportMetalIOSurfaceInfoEXT,
    VkExportMetalObjectCreateInfoEXT,
    VkExportMetalObjectsInfoEXT,
    VkExportMetalSharedEventInfoEXT,
    VkExportMetalTextureInfoEXT,
    VkExportSemaphoreCreateInfo,
    VkExportSemaphoreWin32HandleInfoKHR,
    VkExtensionProperties,
    VkExtent2D,
    VkExtent3D,
    VkExternalBufferProperties,
    VkExternalFenceProperties,
    VkExternalFormatANDROID,
    VkExternalFormatQNX,
    VkExternalImageFormatProperties,
    VkExternalImageFormatPropertiesNV,
    VkExternalMemoryAcquireUnmodifiedEXT,
    VkExternalMemoryBufferCreateInfo,
    VkExternalMemoryImageCreateInfo,
    VkExternalMemoryImageCreateInfoNV,
    VkExternalMemoryProperties,
    VkExternalSemaphoreProperties,
    VkFenceCreateInfo,
    VkFenceGetFdInfoKHR,
    VkFenceGetWin32HandleInfoKHR,
    VkFilterCubicImageViewImageFormatPropertiesEXT,
    VkFormatProperties,
    VkFormatProperties2,
    VkFormatProperties3,
    VkFragmentShadingRateAttachmentInfoKHR,
    VkFramebufferAttachmentImageInfo,
    VkFramebufferAttachmentsCreateInfo,
    VkFramebufferCreateInfo,
    VkFramebufferMixedSamplesCombinationNV,
    VkGeneratedCommandsInfoNV,
    VkGeneratedCommandsMemoryRequirementsInfoNV,
    VkGeometryAABBNV,
    VkGeometryDataNV,
    VkGeometryNV,
    VkGeometryTrianglesNV,
    VkGraphicsPipelineCreateInfo,
    VkGraphicsPipelineLibraryCreateInfoEXT,
    VkGraphicsPipelineShaderGroupsCreateInfoNV,
    VkGraphicsShaderGroupCreateInfoNV,
    VkHdrMetadataEXT,
    VkHeadlessSurfaceCreateInfoEXT,
    VkHostImageCopyDevicePerformanceQueryEXT,
    VkHostImageLayoutTransitionInfoEXT,
    VkIOSSurfaceCreateInfoMVK,
    VkImageBlit,
    VkImageBlit2,
    VkImageCaptureDescriptorDataInfoEXT,
    VkImageCompressionControlEXT,
    VkImageCompressionPropertiesEXT,
    VkImageConstraintsInfoFUCHSIA,
    VkImageCopy,
    VkImageCopy2,
    VkImageCreateInfo,
    VkImageDrmFormatModifierExplicitCreateInfoEXT,
    VkImageDrmFormatModifierListCreateInfoEXT,
    VkImageDrmFormatModifierPropertiesEXT,
    VkImageFormatConstraintsInfoFUCHSIA,
    VkImageFormatListCreateInfo,
    VkImageFormatProperties,
    VkImageFormatProperties2,
    VkImageMemoryBarrier,
    VkImageMemoryBarrier2,
    VkImageMemoryRequirementsInfo2,
    VkImagePipeSurfaceCreateInfoFUCHSIA,
    VkImagePlaneMemoryRequirementsInfo,
    VkImageResolve,
    VkImageResolve2,
    VkImageSparseMemoryRequirementsInfo2,
    VkImageStencilUsageCreateInfo,
    VkImageSubresource,
    VkImageSubresource2KHR,
    VkImageSubresourceLayers,
    VkImageSubresourceRange,
    VkImageSwapchainCreateInfoKHR,
    VkImageToMemoryCopyEXT,
    VkImageViewASTCDecodeModeEXT,
    VkImageViewAddressPropertiesNVX,
    VkImageViewCaptureDescriptorDataInfoEXT,
    VkImageViewCreateInfo,
    VkImageViewHandleInfoNVX,
    VkImageViewMinLodCreateInfoEXT,
    VkImageViewSampleWeightCreateInfoQCOM,
    VkImageViewSlicedCreateInfoEXT,
    VkImageViewUsageCreateInfo,
    VkImportAndroidHardwareBufferInfoANDROID,
    VkImportFenceFdInfoKHR,
    VkImportFenceWin32HandleInfoKHR,
    VkImportMemoryBufferCollectionFUCHSIA,
    VkImportMemoryFdInfoKHR,
    VkImportMemoryHostPointerInfoEXT,
    VkImportMemoryWin32HandleInfoKHR,
    VkImportMemoryWin32HandleInfoNV,
    VkImportMemoryZirconHandleInfoFUCHSIA,
    VkImportMetalBufferInfoEXT,
    VkImportMetalIOSurfaceInfoEXT,
    VkImportMetalSharedEventInfoEXT,
    VkImportMetalTextureInfoEXT,
    VkImportScreenBufferInfoQNX,
    VkImportSemaphoreFdInfoKHR,
    VkImportSemaphoreWin32HandleInfoKHR,
    VkImportSemaphoreZirconHandleInfoFUCHSIA,
    VkIndirectCommandsLayoutCreateInfoNV,
    VkIndirectCommandsLayoutTokenNV,
    VkIndirectCommandsStreamNV,
    VkInitializePerformanceApiInfoINTEL,
    VkInputAttachmentAspectReference,
    VkInstanceCreateInfo,
    VkLayerProperties,
    VkMacOSSurfaceCreateInfoMVK,
    VkMappedMemoryRange,
    VkMemoryAllocateFlagsInfo,
    VkMemoryAllocateInfo,
    VkMemoryBarrier,
    VkMemoryBarrier2,
    VkMemoryDedicatedAllocateInfo,
    VkMemoryDedicatedRequirements,
    VkMemoryFdPropertiesKHR,
    VkMemoryGetAndroidHardwareBufferInfoANDROID,
    VkMemoryGetFdInfoKHR,
    VkMemoryGetRemoteAddressInfoNV,
    VkMemoryGetWin32HandleInfoKHR,
    VkMemoryGetZirconHandleInfoFUCHSIA,
    VkMemoryHeap,
    VkMemoryHostPointerPropertiesEXT,
    VkMemoryMapInfoKHR,
    VkMemoryOpaqueCaptureAddressAllocateInfo,
    VkMemoryPriorityAllocateInfoEXT,
    VkMemoryRequirements,
    VkMemoryRequirements2,
    VkMemoryToImageCopyEXT,
    VkMemoryType,
    VkMemoryUnmapInfoKHR,
    VkMemoryWin32HandlePropertiesKHR,
    VkMemoryZirconHandlePropertiesFUCHSIA,
    VkMetalSurfaceCreateInfoEXT,
    VkMicromapBuildInfoEXT,
    VkMicromapBuildSizesInfoEXT,
    VkMicromapCreateInfoEXT,
    VkMicromapTriangleEXT,
    VkMicromapUsageEXT,
    VkMicromapVersionInfoEXT,
    VkMultiDrawIndexedInfoEXT,
    VkMultiDrawInfoEXT,
    VkMultisamplePropertiesEXT,
    VkMultisampledRenderToSingleSampledInfoEXT,
    VkMultiviewPerViewAttributesInfoNVX,
    VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM,
    VkMutableDescriptorTypeCreateInfoEXT,
    VkMutableDescriptorTypeListEXT,
    VkOffset2D,
    VkOffset3D,
    VkOpaqueCaptureDescriptorDataCreateInfoEXT,
    VkOpticalFlowExecuteInfoNV,
    VkOpticalFlowImageFormatInfoNV,
    VkOpticalFlowImageFormatPropertiesNV,
    VkOpticalFlowSessionCreateInfoNV,
    VkOpticalFlowSessionCreatePrivateDataInfoNV,
    VkPastPresentationTimingGOOGLE,
    VkPerformanceConfigurationAcquireInfoINTEL,
    VkPerformanceCounterDescriptionKHR,
    VkPerformanceCounterKHR,
    VkPerformanceCounterResultKHR,
    VkPerformanceMarkerInfoINTEL,
    VkPerformanceOverrideInfoINTEL,
    VkPerformanceQuerySubmitInfoKHR,
    VkPerformanceStreamMarkerInfoINTEL,
    VkPerformanceValueDataINTEL,
    VkPerformanceValueINTEL,
    VkPhysicalDevice16BitStorageFeatures,
    VkPhysicalDevice4444FormatsFeaturesEXT,
    VkPhysicalDevice8BitStorageFeatures,
    VkPhysicalDeviceASTCDecodeFeaturesEXT,
    VkPhysicalDeviceAccelerationStructureFeaturesKHR,
    VkPhysicalDeviceAccelerationStructurePropertiesKHR,
    VkPhysicalDeviceAddressBindingReportFeaturesEXT,
    VkPhysicalDeviceAmigoProfilingFeaturesSEC,
    VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT,
    VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT,
    VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT,
    VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT,
    VkPhysicalDeviceBorderColorSwizzleFeaturesEXT,
    VkPhysicalDeviceBufferDeviceAddressFeatures,
    VkPhysicalDeviceBufferDeviceAddressFeaturesEXT,
    VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI,
    VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI,
    VkPhysicalDeviceCoherentMemoryFeaturesAMD,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT,
    VkPhysicalDeviceComputeShaderDerivativesFeaturesNV,
    VkPhysicalDeviceConditionalRenderingFeaturesEXT,
    VkPhysicalDeviceConservativeRasterizationPropertiesEXT,
    VkPhysicalDeviceCooperativeMatrixFeaturesKHR,
    VkPhysicalDeviceCooperativeMatrixFeaturesNV,
    VkPhysicalDeviceCooperativeMatrixPropertiesKHR,
    VkPhysicalDeviceCooperativeMatrixPropertiesNV,
    VkPhysicalDeviceCopyMemoryIndirectFeaturesNV,
    VkPhysicalDeviceCopyMemoryIndirectPropertiesNV,
    VkPhysicalDeviceCornerSampledImageFeaturesNV,
    VkPhysicalDeviceCoverageReductionModeFeaturesNV,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT,
    VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV,
    VkPhysicalDeviceDepthBiasControlFeaturesEXT,
    VkPhysicalDeviceDepthClampZeroOneFeaturesEXT,
    VkPhysicalDeviceDepthClipControlFeaturesEXT,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT,
    VkPhysicalDeviceDepthStencilResolveProperties,
    VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT,
    VkPhysicalDeviceDescriptorBufferFeaturesEXT,
    VkPhysicalDeviceDescriptorBufferPropertiesEXT,
    VkPhysicalDeviceDescriptorIndexingFeatures,
    VkPhysicalDeviceDescriptorIndexingProperties,
    VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE,
    VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV,
    VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV,
    VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT,
    VkPhysicalDeviceDiagnosticsConfigFeaturesNV,
    VkPhysicalDeviceDiscardRectanglePropertiesEXT,
    VkPhysicalDeviceDisplacementMicromapFeaturesNV,
    VkPhysicalDeviceDisplacementMicromapPropertiesNV,
    VkPhysicalDeviceDriverProperties,
    VkPhysicalDeviceDrmPropertiesEXT,
    VkPhysicalDeviceDynamicRenderingFeatures,
    VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT,
    VkPhysicalDeviceExclusiveScissorFeaturesNV,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT,
    VkPhysicalDeviceExtendedDynamicState3FeaturesEXT,
    VkPhysicalDeviceExtendedDynamicState3PropertiesEXT,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT,
    VkPhysicalDeviceExternalBufferInfo,
    VkPhysicalDeviceExternalFenceInfo,
    VkPhysicalDeviceExternalImageFormatInfo,
    VkPhysicalDeviceExternalMemoryHostPropertiesEXT,
    VkPhysicalDeviceExternalMemoryRDMAFeaturesNV,
    VkPhysicalDeviceExternalMemoryScreenBufferFeaturesQNX,
    VkPhysicalDeviceExternalSemaphoreInfo,
    VkPhysicalDeviceFaultFeaturesEXT,
    VkPhysicalDeviceFeatures,
    VkPhysicalDeviceFeatures2,
    VkPhysicalDeviceFloatControlsProperties,
    VkPhysicalDeviceFragmentDensityMap2FeaturesEXT,
    VkPhysicalDeviceFragmentDensityMap2PropertiesEXT,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT,
    VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM,
    VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT,
    VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR,
    VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR,
    VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT,
    VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV,
    VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV,
    VkPhysicalDeviceFragmentShadingRateFeaturesKHR,
    VkPhysicalDeviceFragmentShadingRateKHR,
    VkPhysicalDeviceFragmentShadingRatePropertiesKHR,
    VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT,
    VkPhysicalDeviceGroupProperties,
    VkPhysicalDeviceHostImageCopyFeaturesEXT,
    VkPhysicalDeviceHostImageCopyPropertiesEXT,
    VkPhysicalDeviceHostQueryResetFeatures,
    VkPhysicalDeviceIDProperties,
    VkPhysicalDeviceImage2DViewOf3DFeaturesEXT,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT,
    VkPhysicalDeviceImageFormatInfo2,
    VkPhysicalDeviceImageProcessingFeaturesQCOM,
    VkPhysicalDeviceImageProcessingPropertiesQCOM,
    VkPhysicalDeviceImageRobustnessFeatures,
    VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT,
    VkPhysicalDeviceImageViewImageFormatInfoEXT,
    VkPhysicalDeviceImageViewMinLodFeaturesEXT,
    VkPhysicalDeviceImagelessFramebufferFeatures,
    VkPhysicalDeviceIndexTypeUint8FeaturesEXT,
    VkPhysicalDeviceInheritedViewportScissorFeaturesNV,
    VkPhysicalDeviceInlineUniformBlockFeatures,
    VkPhysicalDeviceInlineUniformBlockProperties,
    VkPhysicalDeviceInvocationMaskFeaturesHUAWEI,
    VkPhysicalDeviceLegacyDitheringFeaturesEXT,
    VkPhysicalDeviceLimits,
    VkPhysicalDeviceLineRasterizationFeaturesEXT,
    VkPhysicalDeviceLineRasterizationPropertiesEXT,
    VkPhysicalDeviceLinearColorAttachmentFeaturesNV,
    VkPhysicalDeviceMaintenance3Properties,
    VkPhysicalDeviceMaintenance4Features,
    VkPhysicalDeviceMaintenance4Properties,
    VkPhysicalDeviceMaintenance5FeaturesKHR,
    VkPhysicalDeviceMaintenance5PropertiesKHR,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT,
    VkPhysicalDeviceMemoryDecompressionFeaturesNV,
    VkPhysicalDeviceMemoryDecompressionPropertiesNV,
    VkPhysicalDeviceMemoryPriorityFeaturesEXT,
    VkPhysicalDeviceMemoryProperties,
    VkPhysicalDeviceMemoryProperties2,
    VkPhysicalDeviceMeshShaderFeaturesEXT,
    VkPhysicalDeviceMeshShaderFeaturesNV,
    VkPhysicalDeviceMeshShaderPropertiesEXT,
    VkPhysicalDeviceMeshShaderPropertiesNV,
    VkPhysicalDeviceMultiDrawFeaturesEXT,
    VkPhysicalDeviceMultiDrawPropertiesEXT,
    VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT,
    VkPhysicalDeviceMultiviewFeatures,
    VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX,
    VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM,
    VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM,
    VkPhysicalDeviceMultiviewProperties,
    VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT,
    VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT,
    VkPhysicalDeviceOpacityMicromapFeaturesEXT,
    VkPhysicalDeviceOpacityMicromapPropertiesEXT,
    VkPhysicalDeviceOpticalFlowFeaturesNV,
    VkPhysicalDeviceOpticalFlowPropertiesNV,
    VkPhysicalDevicePCIBusInfoPropertiesEXT,
    VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT,
    VkPhysicalDevicePerformanceQueryFeaturesKHR,
    VkPhysicalDevicePerformanceQueryPropertiesKHR,
    VkPhysicalDevicePipelineCreationCacheControlFeatures,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR,
    VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT,
    VkPhysicalDevicePipelinePropertiesFeaturesEXT,
    VkPhysicalDevicePipelineProtectedAccessFeaturesEXT,
    VkPhysicalDevicePipelineRobustnessFeaturesEXT,
    VkPhysicalDevicePipelineRobustnessPropertiesEXT,
    VkPhysicalDevicePointClippingProperties,
    VkPhysicalDevicePortabilitySubsetFeaturesKHR,
    VkPhysicalDevicePortabilitySubsetPropertiesKHR,
    VkPhysicalDevicePresentBarrierFeaturesNV,
    VkPhysicalDevicePresentIdFeaturesKHR,
    VkPhysicalDevicePresentWaitFeaturesKHR,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT,
    VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT,
    VkPhysicalDevicePrivateDataFeatures,
    VkPhysicalDeviceProperties,
    VkPhysicalDeviceProperties2,
    VkPhysicalDeviceProtectedMemoryFeatures,
    VkPhysicalDeviceProtectedMemoryProperties,
    VkPhysicalDeviceProvokingVertexFeaturesEXT,
    VkPhysicalDeviceProvokingVertexPropertiesEXT,
    VkPhysicalDevicePushDescriptorPropertiesKHR,
    VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT,
    VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT,
    VkPhysicalDeviceRayQueryFeaturesKHR,
    VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV,
    VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV,
    VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR,
    VkPhysicalDeviceRayTracingMotionBlurFeaturesNV,
    VkPhysicalDeviceRayTracingPipelineFeaturesKHR,
    VkPhysicalDeviceRayTracingPipelinePropertiesKHR,
    VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR,
    VkPhysicalDeviceRayTracingPropertiesNV,
    VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV,
    VkPhysicalDeviceRobustness2FeaturesEXT,
    VkPhysicalDeviceRobustness2PropertiesEXT,
    VkPhysicalDeviceSampleLocationsPropertiesEXT,
    VkPhysicalDeviceSamplerFilterMinmaxProperties,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures,
    VkPhysicalDeviceScalarBlockLayoutFeatures,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures,
    VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT,
    VkPhysicalDeviceShaderAtomicFloatFeaturesEXT,
    VkPhysicalDeviceShaderAtomicInt64Features,
    VkPhysicalDeviceShaderClockFeaturesKHR,
    VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM,
    VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM,
    VkPhysicalDeviceShaderCoreProperties2AMD,
    VkPhysicalDeviceShaderCorePropertiesAMD,
    VkPhysicalDeviceShaderCorePropertiesARM,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures,
    VkPhysicalDeviceShaderDrawParametersFeatures,
    VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD,
    VkPhysicalDeviceShaderEnqueueFeaturesAMDX,
    VkPhysicalDeviceShaderEnqueuePropertiesAMDX,
    VkPhysicalDeviceShaderFloat16Int8Features,
    VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT,
    VkPhysicalDeviceShaderImageFootprintFeaturesNV,
    VkPhysicalDeviceShaderIntegerDotProductFeatures,
    VkPhysicalDeviceShaderIntegerDotProductProperties,
    VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL,
    VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT,
    VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT,
    VkPhysicalDeviceShaderObjectFeaturesEXT,
    VkPhysicalDeviceShaderObjectPropertiesEXT,
    VkPhysicalDeviceShaderSMBuiltinsFeaturesNV,
    VkPhysicalDeviceShaderSMBuiltinsPropertiesNV,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures,
    VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR,
    VkPhysicalDeviceShaderTerminateInvocationFeatures,
    VkPhysicalDeviceShaderTileImageFeaturesEXT,
    VkPhysicalDeviceShaderTileImagePropertiesEXT,
    VkPhysicalDeviceShadingRateImageFeaturesNV,
    VkPhysicalDeviceShadingRateImagePropertiesNV,
    VkPhysicalDeviceSparseImageFormatInfo2,
    VkPhysicalDeviceSparseProperties,
    VkPhysicalDeviceSubgroupProperties,
    VkPhysicalDeviceSubgroupSizeControlFeatures,
    VkPhysicalDeviceSubgroupSizeControlProperties,
    VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT,
    VkPhysicalDeviceSubpassShadingFeaturesHUAWEI,
    VkPhysicalDeviceSubpassShadingPropertiesHUAWEI,
    VkPhysicalDeviceSurfaceInfo2KHR,
    VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT,
    VkPhysicalDeviceSynchronization2Features,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT,
    VkPhysicalDeviceTexelBufferAlignmentProperties,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures,
    VkPhysicalDeviceTilePropertiesFeaturesQCOM,
    VkPhysicalDeviceTimelineSemaphoreFeatures,
    VkPhysicalDeviceTimelineSemaphoreProperties,
    VkPhysicalDeviceToolProperties,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures,
    VkPhysicalDeviceVariablePointersFeatures,
    VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT,
    VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT,
    VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR,
    VkPhysicalDeviceVideoFormatInfoKHR,
    VkPhysicalDeviceVulkan11Features,
    VkPhysicalDeviceVulkan11Properties,
    VkPhysicalDeviceVulkan12Features,
    VkPhysicalDeviceVulkan12Properties,
    VkPhysicalDeviceVulkan13Features,
    VkPhysicalDeviceVulkan13Properties,
    VkPhysicalDeviceVulkanMemoryModelFeatures,
    VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT,
    VkPhysicalDeviceYcbcrImageArraysFeaturesEXT,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures,
    VkPipelineCacheCreateInfo,
    VkPipelineCacheHeaderVersionOne,
    VkPipelineColorBlendAdvancedStateCreateInfoEXT,
    VkPipelineColorBlendAttachmentState,
    VkPipelineColorBlendStateCreateInfo,
    VkPipelineColorWriteCreateInfoEXT,
    VkPipelineCompilerControlCreateInfoAMD,
    VkPipelineCoverageModulationStateCreateInfoNV,
    VkPipelineCoverageReductionStateCreateInfoNV,
    VkPipelineCoverageToColorStateCreateInfoNV,
    VkPipelineCreateFlags2CreateInfoKHR,
    VkPipelineCreationFeedback,
    VkPipelineCreationFeedbackCreateInfo,
    VkPipelineDepthStencilStateCreateInfo,
    VkPipelineDiscardRectangleStateCreateInfoEXT,
    VkPipelineDynamicStateCreateInfo,
    VkPipelineExecutableInfoKHR,
    VkPipelineExecutableInternalRepresentationKHR,
    VkPipelineExecutablePropertiesKHR,
    VkPipelineExecutableStatisticKHR,
    VkPipelineExecutableStatisticValueKHR,
    VkPipelineFragmentShadingRateEnumStateCreateInfoNV,
    VkPipelineFragmentShadingRateStateCreateInfoKHR,
    VkPipelineIndirectDeviceAddressInfoNV,
    VkPipelineInfoKHR,
    VkPipelineInputAssemblyStateCreateInfo,
    VkPipelineLayoutCreateInfo,
    VkPipelineLibraryCreateInfoKHR,
    VkPipelineMultisampleStateCreateInfo,
    VkPipelinePropertiesIdentifierEXT,
    VkPipelineRasterizationConservativeStateCreateInfoEXT,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT,
    VkPipelineRasterizationLineStateCreateInfoEXT,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT,
    VkPipelineRasterizationStateCreateInfo,
    VkPipelineRasterizationStateRasterizationOrderAMD,
    VkPipelineRasterizationStateStreamCreateInfoEXT,
    VkPipelineRenderingCreateInfo,
    VkPipelineRepresentativeFragmentTestStateCreateInfoNV,
    VkPipelineRobustnessCreateInfoEXT,
    VkPipelineSampleLocationsStateCreateInfoEXT,
    VkPipelineShaderStageCreateInfo,
    VkPipelineShaderStageModuleIdentifierCreateInfoEXT,
    VkPipelineShaderStageNodeCreateInfoAMDX,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo,
    VkPipelineTessellationDomainOriginStateCreateInfo,
    VkPipelineTessellationStateCreateInfo,
    VkPipelineVertexInputDivisorStateCreateInfoEXT,
    VkPipelineVertexInputStateCreateInfo,
    VkPipelineViewportCoarseSampleOrderStateCreateInfoNV,
    VkPipelineViewportDepthClipControlCreateInfoEXT,
    VkPipelineViewportExclusiveScissorStateCreateInfoNV,
    VkPipelineViewportShadingRateImageStateCreateInfoNV,
    VkPipelineViewportStateCreateInfo,
    VkPipelineViewportSwizzleStateCreateInfoNV,
    VkPipelineViewportWScalingStateCreateInfoNV,
    VkPresentFrameTokenGGP,
    VkPresentIdKHR,
    VkPresentInfoKHR,
    VkPresentRegionKHR,
    VkPresentRegionsKHR,
    VkPresentTimeGOOGLE,
    VkPresentTimesInfoGOOGLE,
    VkPrivateDataSlotCreateInfo,
    VkProtectedSubmitInfo,
    VkPushConstantRange,
    VkQueryLowLatencySupportNV,
    VkQueryPoolCreateInfo,
    VkQueryPoolPerformanceCreateInfoKHR,
    VkQueryPoolPerformanceQueryCreateInfoINTEL,
    VkQueryPoolVideoEncodeFeedbackCreateInfoKHR,
    VkQueueFamilyCheckpointProperties2NV,
    VkQueueFamilyCheckpointPropertiesNV,
    VkQueueFamilyGlobalPriorityPropertiesKHR,
    VkQueueFamilyProperties,
    VkQueueFamilyProperties2,
    VkQueueFamilyQueryResultStatusPropertiesKHR,
    VkQueueFamilyVideoPropertiesKHR,
    VkRayTracingPipelineCreateInfoKHR,
    VkRayTracingPipelineCreateInfoNV,
    VkRayTracingPipelineInterfaceCreateInfoKHR,
    VkRayTracingShaderGroupCreateInfoKHR,
    VkRayTracingShaderGroupCreateInfoNV,
    VkRect2D,
    VkRectLayerKHR,
    VkRefreshCycleDurationGOOGLE,
    VkReleaseSwapchainImagesInfoEXT,
    VkRenderPassAttachmentBeginInfo,
    VkRenderPassBeginInfo,
    VkRenderPassCreateInfo,
    VkRenderPassCreateInfo2,
    VkRenderPassCreationControlEXT,
    VkRenderPassCreationFeedbackCreateInfoEXT,
    VkRenderPassCreationFeedbackInfoEXT,
    VkRenderPassFragmentDensityMapCreateInfoEXT,
    VkRenderPassInputAttachmentAspectCreateInfo,
    VkRenderPassMultiviewCreateInfo,
    VkRenderPassSampleLocationsBeginInfoEXT,
    VkRenderPassSubpassFeedbackCreateInfoEXT,
    VkRenderPassSubpassFeedbackInfoEXT,
    VkRenderPassTransformBeginInfoQCOM,
    VkRenderingAreaInfoKHR,
    VkRenderingAttachmentInfo,
    VkRenderingFragmentDensityMapAttachmentInfoEXT,
    VkRenderingFragmentShadingRateAttachmentInfoKHR,
    VkRenderingInfo,
    VkResolveImageInfo2,
    VkSRTDataNV,
    VkSampleLocationEXT,
    VkSampleLocationsInfoEXT,
    VkSamplerBorderColorComponentMappingCreateInfoEXT,
    VkSamplerCaptureDescriptorDataInfoEXT,
    VkSamplerCreateInfo,
    VkSamplerCustomBorderColorCreateInfoEXT,
    VkSamplerReductionModeCreateInfo,
    VkSamplerYcbcrConversionCreateInfo,
    VkSamplerYcbcrConversionImageFormatProperties,
    VkSamplerYcbcrConversionInfo,
    VkScreenBufferFormatPropertiesQNX,
    VkScreenBufferPropertiesQNX,
    VkScreenSurfaceCreateInfoQNX,
    VkSemaphoreCreateInfo,
    VkSemaphoreGetFdInfoKHR,
    VkSemaphoreGetWin32HandleInfoKHR,
    VkSemaphoreGetZirconHandleInfoFUCHSIA,
    VkSemaphoreSignalInfo,
    VkSemaphoreSubmitInfo,
    VkSemaphoreTypeCreateInfo,
    VkSemaphoreWaitInfo,
    VkSetStateFlagsIndirectCommandNV,
    VkShaderCreateInfoEXT,
    VkShaderModuleCreateInfo,
    VkShaderModuleIdentifierEXT,
    VkShaderModuleValidationCacheCreateInfoEXT,
    VkShaderResourceUsageAMD,
    VkShaderStatisticsInfoAMD,
    VkShadingRatePaletteNV,
    VkSharedPresentSurfaceCapabilitiesKHR,
    VkSparseBufferMemoryBindInfo,
    VkSparseImageFormatProperties,
    VkSparseImageFormatProperties2,
    VkSparseImageMemoryBind,
    VkSparseImageMemoryBindInfo,
    VkSparseImageMemoryRequirements,
    VkSparseImageMemoryRequirements2,
    VkSparseImageOpaqueMemoryBindInfo,
    VkSparseMemoryBind,
    VkSpecializationInfo,
    VkSpecializationMapEntry,
    VkStencilOpState,
    VkStreamDescriptorSurfaceCreateInfoGGP,
    VkStridedDeviceAddressRegionKHR,
    VkSubmitInfo,
    VkSubmitInfo2,
    VkSubpassBeginInfo,
    VkSubpassDependency,
    VkSubpassDependency2,
    VkSubpassDescription,
    VkSubpassDescription2,
    VkSubpassDescriptionDepthStencilResolve,
    VkSubpassEndInfo,
    VkSubpassFragmentDensityMapOffsetEndInfoQCOM,
    VkSubpassResolvePerformanceQueryEXT,
    VkSubpassSampleLocationsEXT,
    VkSubpassShadingPipelineCreateInfoHUAWEI,
    VkSubresourceHostMemcpySizeEXT,
    VkSubresourceLayout,
    VkSubresourceLayout2KHR,
    VkSurfaceCapabilities2EXT,
    VkSurfaceCapabilities2KHR,
    VkSurfaceCapabilitiesFullScreenExclusiveEXT,
    VkSurfaceCapabilitiesKHR,
    VkSurfaceCapabilitiesPresentBarrierNV,
    VkSurfaceFormat2KHR,
    VkSurfaceFormatKHR,
    VkSurfaceFullScreenExclusiveInfoEXT,
    VkSurfaceFullScreenExclusiveWin32InfoEXT,
    VkSurfacePresentModeCompatibilityEXT,
    VkSurfacePresentModeEXT,
    VkSurfacePresentScalingCapabilitiesEXT,
    VkSurfaceProtectedCapabilitiesKHR,
    VkSwapchainCounterCreateInfoEXT,
    VkSwapchainCreateInfoKHR,
    VkSwapchainDisplayNativeHdrCreateInfoAMD,
    VkSwapchainPresentBarrierCreateInfoNV,
    VkSwapchainPresentFenceInfoEXT,
    VkSwapchainPresentModeInfoEXT,
    VkSwapchainPresentModesCreateInfoEXT,
    VkSwapchainPresentScalingCreateInfoEXT,
    VkSysmemColorSpaceFUCHSIA,
    VkTextureLODGatherFormatPropertiesAMD,
    VkTilePropertiesQCOM,
    VkTimelineSemaphoreSubmitInfo,
    VkTraceRaysIndirectCommand2KHR,
    VkTraceRaysIndirectCommandKHR,
    VkTransformMatrixKHR,
    VkValidationCacheCreateInfoEXT,
    VkValidationFeaturesEXT,
    VkValidationFlagsEXT,
    VkVertexInputAttributeDescription,
    VkVertexInputAttributeDescription2EXT,
    VkVertexInputBindingDescription,
    VkVertexInputBindingDescription2EXT,
    VkVertexInputBindingDivisorDescriptionEXT,
    VkViSurfaceCreateInfoNN,
    VkVideoBeginCodingInfoKHR,
    VkVideoCapabilitiesKHR,
    VkVideoCodingControlInfoKHR,
    VkVideoDecodeCapabilitiesKHR,
    VkVideoDecodeH264CapabilitiesKHR,
    VkVideoDecodeH264DpbSlotInfoKHR,
    VkVideoDecodeH264PictureInfoKHR,
    VkVideoDecodeH264ProfileInfoKHR,
    VkVideoDecodeH264SessionParametersAddInfoKHR,
    VkVideoDecodeH264SessionParametersCreateInfoKHR,
    VkVideoDecodeH265CapabilitiesKHR,
    VkVideoDecodeH265DpbSlotInfoKHR,
    VkVideoDecodeH265PictureInfoKHR,
    VkVideoDecodeH265ProfileInfoKHR,
    VkVideoDecodeH265SessionParametersAddInfoKHR,
    VkVideoDecodeH265SessionParametersCreateInfoKHR,
    VkVideoDecodeInfoKHR,
    VkVideoDecodeUsageInfoKHR,
    VkVideoEncodeCapabilitiesKHR,
    VkVideoEncodeH264CapabilitiesEXT,
    VkVideoEncodeH264DpbSlotInfoEXT,
    VkVideoEncodeH264FrameSizeEXT,
    VkVideoEncodeH264GopRemainingFrameInfoEXT,
    VkVideoEncodeH264NaluSliceInfoEXT,
    VkVideoEncodeH264PictureInfoEXT,
    VkVideoEncodeH264ProfileInfoEXT,
    VkVideoEncodeH264QpEXT,
    VkVideoEncodeH264QualityLevelPropertiesEXT,
    VkVideoEncodeH264RateControlInfoEXT,
    VkVideoEncodeH264RateControlLayerInfoEXT,
    VkVideoEncodeH264SessionCreateInfoEXT,
    VkVideoEncodeH264SessionParametersAddInfoEXT,
    VkVideoEncodeH264SessionParametersCreateInfoEXT,
    VkVideoEncodeH264SessionParametersFeedbackInfoEXT,
    VkVideoEncodeH264SessionParametersGetInfoEXT,
    VkVideoEncodeH265CapabilitiesEXT,
    VkVideoEncodeH265DpbSlotInfoEXT,
    VkVideoEncodeH265FrameSizeEXT,
    VkVideoEncodeH265GopRemainingFrameInfoEXT,
    VkVideoEncodeH265NaluSliceSegmentInfoEXT,
    VkVideoEncodeH265PictureInfoEXT,
    VkVideoEncodeH265ProfileInfoEXT,
    VkVideoEncodeH265QpEXT,
    VkVideoEncodeH265QualityLevelPropertiesEXT,
    VkVideoEncodeH265RateControlInfoEXT,
    VkVideoEncodeH265RateControlLayerInfoEXT,
    VkVideoEncodeH265SessionCreateInfoEXT,
    VkVideoEncodeH265SessionParametersAddInfoEXT,
    VkVideoEncodeH265SessionParametersCreateInfoEXT,
    VkVideoEncodeH265SessionParametersFeedbackInfoEXT,
    VkVideoEncodeH265SessionParametersGetInfoEXT,
    VkVideoEncodeInfoKHR,
    VkVideoEncodeQualityLevelInfoKHR,
    VkVideoEncodeQualityLevelPropertiesKHR,
    VkVideoEncodeRateControlInfoKHR,
    VkVideoEncodeRateControlLayerInfoKHR,
    VkVideoEncodeSessionParametersFeedbackInfoKHR,
    VkVideoEncodeSessionParametersGetInfoKHR,
    VkVideoEncodeUsageInfoKHR,
    VkVideoEndCodingInfoKHR,
    VkVideoFormatPropertiesKHR,
    VkVideoPictureResourceInfoKHR,
    VkVideoProfileInfoKHR,
    VkVideoProfileListInfoKHR,
    VkVideoReferenceSlotInfoKHR,
    VkVideoSessionCreateInfoKHR,
    VkVideoSessionMemoryRequirementsKHR,
    VkVideoSessionParametersCreateInfoKHR,
    VkVideoSessionParametersUpdateInfoKHR,
    VkViewport,
    VkViewportSwizzleNV,
    VkViewportWScalingNV,
    VkWaylandSurfaceCreateInfoKHR,
    VkWin32KeyedMutexAcquireReleaseInfoKHR,
    VkWin32KeyedMutexAcquireReleaseInfoNV,
    VkWin32SurfaceCreateInfoKHR,
    VkWriteDescriptorSet,
    VkWriteDescriptorSetAccelerationStructureKHR,
    VkWriteDescriptorSetAccelerationStructureNV,
    VkWriteDescriptorSetInlineUniformBlock,
    VkXYColorEXT,
    VkXcbSurfaceCreateInfoKHR,
    VkXlibSurfaceCreateInfoKHR,
};

enum class Field {
    Empty = 0,
    AType,
    BType,
    CType,
    DType,
    KSize,
    MSize,
    NSize,
    ResultType,
    a,
    aabbData,
    aabbs,
    accelerationStructure,
    accelerationStructureCaptureReplay,
    accelerationStructureCaptureReplayDescriptorDataSize,
    accelerationStructureCount,
    accelerationStructureDescriptorSize,
    accelerationStructureHostCommands,
    accelerationStructureIndirectBuild,
    accelerationStructureNV,
    accelerationStructureReference,
    accelerationStructureSize,
    acquireCount,
    acquireUnmodifiedMemory,
    activeComputeUnitCount,
    actualPresentTime,
    address,
    addressInfoCount,
    addressModeU,
    addressModeV,
    addressModeW,
    addressPrecision,
    addressType,
    advancedBlendAllOperations,
    advancedBlendCoherentOperations,
    advancedBlendCorrelatedOverlap,
    advancedBlendIndependentBlend,
    advancedBlendMaxColorAttachments,
    advancedBlendNonPremultipliedDstColor,
    advancedBlendNonPremultipliedSrcColor,
    advancedBlendOp,
    alignment,
    allocationSize,
    allowCommandBufferQueryCopies,
    allowSamplerImageViewPostSubmitCreation,
    alphaBlendOp,
    alphaMode,
    alphaToCoverageEnable,
    alphaToOne,
    alphaToOneEnable,
    amigoProfiling,
    androidHardwareBufferUsage,
    anisotropyEnable,
    anyHitShader,
    apiVersion,
    applicationNameOffset,
    applicationVersion,
    apronSize,
    arrayLayer,
    arrayLayers,
    arrayOfPointers,
    arrayPitch,
    aspectMask,
    aspectReferenceCount,
    attachment,
    attachmentCount,
    attachmentFeedbackLoopDynamicState,
    attachmentFeedbackLoopLayout,
    attachmentFragmentShadingRate,
    attachmentImageInfoCount,
    attachmentIndex,
    attachmentInitialSampleLocationsCount,
    averageBitrate,
    b,
    b32,
    back,
    baseAddress,
    baseArrayLayer,
    baseGroupX,
    baseGroupY,
    baseGroupZ,
    baseMipLevel,
    basePipelineHandle,
    basePipelineIndex,
    baseTriangle,
    bidirectionalFlowSupported,
    bindCount,
    bindInfoCount,
    bindSessionMemoryInfoCount,
    binding,
    bindingCount,
    bindingPoint,
    bindingType,
    blendConstants,
    blendEnable,
    blendOverlap,
    blockDimX,
    blockDimY,
    blockDimZ,
    borderColor,
    borderColorSwizzle,
    borderColorSwizzleFromImage,
    bresenhamLines,
    buffer,
    bufferAddress,
    bufferBindCount,
    bufferCaptureReplayDescriptorDataSize,
    bufferCollectionConstraints,
    bufferCount,
    bufferDeviceAddress,
    bufferDeviceAddressCaptureReplay,
    bufferDeviceAddressMultiDevice,
    bufferFeatures,
    bufferImageGranularity,
    bufferImageHeight,
    bufferMemoryBarrierCount,
    bufferOffset,
    bufferRowLength,
    bufferView,
    bufferlessPushDescriptors,
    buildScratchSize,
    buildType,
    c,
    callableShaderBindingOffset,
    callableShaderBindingStride,
    callableShaderBindingTableAddress,
    callableShaderBindingTableBuffer,
    callableShaderBindingTableSize,
    callableShaderBindingTableStride,
    callback,
    capabilities,
    category,
    checkpointExecutionStageMask,
    chromaBitDepth,
    chromaFilter,
    chromaSubsampling,
    clampResults,
    clearValue,
    clearValueCount,
    clipped,
    closestHitShader,
    clustercullingShader,
    cmdBufLabelCount,
    codeSize,
    codeType,
    codedExtent,
    codedOffset,
    collection,
    collectionToken,
    color,
    colorAttachment,
    colorAttachmentCount,
    colorBlendOp,
    colorSamples,
    colorSpace,
    colorSpaceCount,
    colorWriteEnable,
    colorWriteMask,
    combinedImageSamplerDensityMapDescriptorSize,
    combinedImageSamplerDescriptorCount,
    combinedImageSamplerDescriptorSingleArray,
    combinedImageSamplerDescriptorSize,
    combinerOps,
    commandBuffer,
    commandBufferCount,
    commandBufferInfoCount,
    commandPool,
    compactedSize,
    compareEnable,
    compareMask,
    compareOp,
    compatibleHandleTypes,
    compilerControlFlags,
    componentMapping,
    components,
    compositeAlpha,
    compressedSize,
    compressionControlPlaneCount,
    computeDerivativeGroupLinear,
    computeDerivativeGroupQuads,
    computeFullSubgroups,
    computeUnitsPerShaderArray,
    computeWorkGroupSize,
    conditionalRendering,
    conditionalRenderingEnable,
    configuration,
    conformanceVersion,
    connection,
    connectorId,
    consecutiveBFrameCount,
    conservativePointAndLineRasterization,
    conservativeRasterizationMode,
    conservativeRasterizationPostDepthCoverage,
    constantAlphaColorBlendFactors,
    constantID,
    constantQp,
    contents,
    context,
    conversion,
    cooperativeMatrix,
    cooperativeMatrixRobustBufferAccess,
    cooperativeMatrixSupportedStages,
    copyBufferAddress,
    copyCount,
    copyDstLayoutCount,
    copySrcLayoutCount,
    cornerSampledImage,
    correlatedViewMaskCount,
    correlationMaskCount,
    costFormat,
    costSupported,
    count,
    countBuffer,
    countBufferOffset,
    countInfo,
    counter,
    counterBuffer,
    counterBufferCount,
    counterBufferOffset,
    counterIndexCount,
    counterOffset,
    counterPassIndex,
    coverageModulationMode,
    coverageModulationTableCount,
    coverageModulationTableEnable,
    coverageReductionMode,
    coverageToColorEnable,
    coverageToColorLocation,
    createFlags,
    createInfo,
    createInfoCount,
    createInfoIndex,
    ctbSizes,
    cullMode,
    currentDisplay,
    currentExtent,
    currentStackIndex,
    currentTransform,
    customBorderColor,
    customBorderColorWithoutFormat,
    customBorderColors,
    customSampleOrderCount,
    data,
    dataOffset,
    dataSize,
    decodeMode,
    decodeModeSharedExponent,
    decompressRegionCount,
    decompressedSize,
    decompressionMethod,
    decompressionMethods,
    dedicatedAllocation,
    dedicatedAllocationImageAliasing,
    defaultRobustnessImages,
    defaultRobustnessStorageBuffers,
    defaultRobustnessUniformBuffers,
    defaultRobustnessVertexInputs,
    deferredOperation,
    degenerateLinesRasterized,
    degenerateTrianglesRasterized,
    denormBehaviorIndependence,
    dependencyCount,
    dependencyFlags,
    depth,
    depthAttachmentFormat,
    depthBiasClamp,
    depthBiasConstantFactor,
    depthBiasControl,
    depthBiasEnable,
    depthBiasExact,
    depthBiasRepresentation,
    depthBiasSlopeFactor,
    depthBounds,
    depthBoundsTestEnable,
    depthClamp,
    depthClampEnable,
    depthClampZeroOne,
    depthClipControl,
    depthClipEnable,
    depthCompareOp,
    depthFailOp,
    depthPitch,
    depthResolveMode,
    depthStencil,
    depthStencilAttachmentSamples,
    depthStencilSamples,
    depthStencilSwizzleOneSupport,
    depthTestEnable,
    depthWriteEnable,
    description,
    descriptorBindingAccelerationStructureUpdateAfterBind,
    descriptorBindingInlineUniformBlockUpdateAfterBind,
    descriptorBindingPartiallyBound,
    descriptorBindingSampledImageUpdateAfterBind,
    descriptorBindingStorageBufferUpdateAfterBind,
    descriptorBindingStorageImageUpdateAfterBind,
    descriptorBindingStorageTexelBufferUpdateAfterBind,
    descriptorBindingUniformBufferUpdateAfterBind,
    descriptorBindingUniformTexelBufferUpdateAfterBind,
    descriptorBindingUpdateUnusedWhilePending,
    descriptorBindingVariableDescriptorCount,
    descriptorBuffer,
    descriptorBufferAddressSpaceSize,
    descriptorBufferCaptureReplay,
    descriptorBufferImageLayoutIgnored,
    descriptorBufferOffsetAlignment,
    descriptorBufferPushDescriptors,
    descriptorCopyCount,
    descriptorCount,
    descriptorIndexing,
    descriptorOffset,
    descriptorPool,
    descriptorSet,
    descriptorSetCount,
    descriptorSetHostMapping,
    descriptorSetLayout,
    descriptorSize,
    descriptorType,
    descriptorTypeCount,
    descriptorUpdateEntryCount,
    descriptorUpdateTemplate,
    descriptorWriteCount,
    desiredPresentTime,
    device,
    deviceAddress,
    deviceCoherentMemory,
    deviceEvent,
    deviceFault,
    deviceFaultVendorBinary,
    deviceGeneratedCommands,
    deviceGeneratedCompute,
    deviceGeneratedComputeCaptureReplay,
    deviceGeneratedComputePipelines,
    deviceID,
    deviceIndex,
    deviceIndexCount,
    deviceLUID,
    deviceLUIDValid,
    deviceMask,
    deviceMemoryReport,
    deviceName,
    deviceNodeMask,
    deviceRelativeId,
    deviceRenderAreaCount,
    deviceType,
    deviceUUID,
    dfb,
    diagnosticsConfig,
    disabledValidationCheckCount,
    disabledValidationFeatureCount,
    disallowMerging,
    discardRectangleCount,
    discardRectangleEnable,
    discardRectangleMode,
    discardable,
    discreteQueuePriorities,
    displacedMicromapPrimitiveFlags,
    displacedMicromapPrimitiveFlagsStride,
    displacementBiasAndScaleBuffer,
    displacementBiasAndScaleFormat,
    displacementBiasAndScaleStride,
    displacementMicromap,
    displacementVectorBuffer,
    displacementVectorFormat,
    displacementVectorStride,
    display,
    displayEvent,
    displayMode,
    displayModeProperties,
    displayName,
    displayPlaneProperties,
    displayPrimaryBlue,
    displayPrimaryGreen,
    displayPrimaryRed,
    displayProperties,
    divisor,
    domainOrigin,
    dpy,
    drawCount,
    drawIndirectCount,
    drawIndirectFirstInstance,
    driverCount,
    driverID,
    driverInfo,
    driverName,
    driverUUID,
    driverVersion,
    drmFd,
    drmFormatModifier,
    drmFormatModifierCount,
    drmFormatModifierPlaneCount,
    drmFormatModifierTilingFeatures,
    dst,
    dstAccelerationStructure,
    dstAccessMask,
    dstAddress,
    dstAlphaBlendFactor,
    dstArrayElement,
    dstBinding,
    dstBuffer,
    dstBufferOffset,
    dstBufferRange,
    dstCache,
    dstColorBlendFactor,
    dstImage,
    dstImageLayout,
    dstMicromap,
    dstOffset,
    dstOffsets,
    dstPictureResource,
    dstPremultiplied,
    dstQueueFamilyIndex,
    dstRect,
    dstSet,
    dstStageMask,
    dstSubpass,
    dstSubresource,
    dualSrcBlend,
    duration,
    dwAccess,
    dynamicOffsetCount,
    dynamicPrimitiveTopologyUnrestricted,
    dynamicRendering,
    dynamicRenderingUnusedAttachments,
    dynamicStateCount,
    earliestPresentTime,
    earlyFragmentMultisampleCoverageAfterSampleCounting,
    earlyFragmentSampleMaskTestBeforeSampleCounting,
    enable,
    enabledExtensionCount,
    enabledLayerCount,
    enabledValidationFeatureCount,
    encodeFeedbackFlags,
    encodeInputPictureGranularity,
    engineNameOffset,
    engineVersion,
    event,
    eventCount,
    events,
    exclusiveScissor,
    exclusiveScissorCount,
    executableIndex,
    executionGraph,
    executionGraphDispatchAddressAlignment,
    expectDyadicTemporalLayerPattern,
    expectDyadicTemporalSubLayerPattern,
    exportFromImportedHandleTypes,
    exportObjectType,
    extendedDynamicState,
    extendedDynamicState2,
    extendedDynamicState2LogicOp,
    extendedDynamicState2PatchControlPoints,
    extendedDynamicState3AlphaToCoverageEnable,
    extendedDynamicState3AlphaToOneEnable,
    extendedDynamicState3ColorBlendAdvanced,
    extendedDynamicState3ColorBlendEnable,
    extendedDynamicState3ColorBlendEquation,
    extendedDynamicState3ColorWriteMask,
    extendedDynamicState3ConservativeRasterizationMode,
    extendedDynamicState3CoverageModulationMode,
    extendedDynamicState3CoverageModulationTable,
    extendedDynamicState3CoverageModulationTableEnable,
    extendedDynamicState3CoverageReductionMode,
    extendedDynamicState3CoverageToColorEnable,
    extendedDynamicState3CoverageToColorLocation,
    extendedDynamicState3DepthClampEnable,
    extendedDynamicState3DepthClipEnable,
    extendedDynamicState3DepthClipNegativeOneToOne,
    extendedDynamicState3ExtraPrimitiveOverestimationSize,
    extendedDynamicState3LineRasterizationMode,
    extendedDynamicState3LineStippleEnable,
    extendedDynamicState3LogicOpEnable,
    extendedDynamicState3PolygonMode,
    extendedDynamicState3ProvokingVertexMode,
    extendedDynamicState3RasterizationSamples,
    extendedDynamicState3RasterizationStream,
    extendedDynamicState3RepresentativeFragmentTestEnable,
    extendedDynamicState3SampleLocationsEnable,
    extendedDynamicState3SampleMask,
    extendedDynamicState3ShadingRateImageEnable,
    extendedDynamicState3TessellationDomainOrigin,
    extendedDynamicState3ViewportSwizzle,
    extendedDynamicState3ViewportWScalingEnable,
    extensionName,
    extent,
    externalFenceFeatures,
    externalFormat,
    externalHandleType,
    externalMemoryFeatures,
    externalMemoryProperties,
    externalMemoryRDMA,
    externalSemaphoreFeatures,
    extraCount,
    extraPrimitiveOverestimationSize,
    extraPrimitiveOverestimationSizeGranularity,
    f64,
    faceMask,
    failOp,
    fd,
    features,
    fence,
    fenceCount,
    fieldOffsetGranularity,
    fillModeNonSolid,
    filter,
    filterCenter,
    filterCubic,
    filterCubicMinmax,
    filterMinmaxImageComponentMapping,
    filterMinmaxSingleComponentFormats,
    filterSize,
    finalLayout,
    firstAttachment,
    firstBinding,
    firstCounterBuffer,
    firstDiscardRectangle,
    firstDrawTimestamp,
    firstExclusiveScissor,
    firstGroup,
    firstIndex,
    firstInstance,
    firstQuery,
    firstScissor,
    firstSet,
    firstTask,
    firstVertex,
    firstViewport,
    flags,
    float32,
    float64,
    floatRepresentation,
    flowVectorFormat,
    fmaRate,
    forceExplicitReconstruction,
    format,
    formatA4B4G4R4,
    formatA4R4G4B4,
    formatConstraintsCount,
    formatFeatures,
    formatProperties,
    formatRgba10x6WithoutYCbCrSampler,
    fragmentDensityInvocations,
    fragmentDensityMap,
    fragmentDensityMapAttachment,
    fragmentDensityMapDeferred,
    fragmentDensityMapDynamic,
    fragmentDensityMapNonSubsampledImages,
    fragmentDensityMapOffset,
    fragmentDensityOffsetCount,
    fragmentDensityOffsetGranularity,
    fragmentShaderBarycentric,
    fragmentShaderPixelInterlock,
    fragmentShaderSampleInterlock,
    fragmentShaderShadingRateInterlock,
    fragmentShadingRateEnums,
    fragmentShadingRateNonTrivialCombinerOps,
    fragmentShadingRateStrictMultiplyCombiner,
    fragmentShadingRateWithConservativeRasterization,
    fragmentShadingRateWithCustomSampleLocations,
    fragmentShadingRateWithFragmentShaderInterlock,
    fragmentShadingRateWithSampleMask,
    fragmentShadingRateWithShaderDepthStencilWrites,
    fragmentShadingRateWithShaderSampleMask,
    fragmentSize,
    fragmentStoresAndAtomics,
    frameBSize,
    frameISize,
    framePSize,
    frameRateDenominator,
    frameRateNumerator,
    frameToken,
    framebuffer,
    framebufferColorSampleCounts,
    framebufferDepthSampleCounts,
    framebufferIntegerColorSampleCounts,
    framebufferNoAttachmentsSampleCounts,
    framebufferStencilSampleCounts,
    front,
    frontFace,
    fullDrawIndexUint32,
    fullScreenExclusive,
    fullScreenExclusiveSupported,
    fullyCoveredFragmentShaderInputVariable,
    function,
    g,
    generalShader,
    generatePrefixNalu,
    geometry,
    geometryCount,
    geometryShader,
    geometryStreams,
    geometryType,
    globalAlpha,
    globalFlowSupported,
    globalPriority,
    globalPriorityQuery,
    gopFrameCount,
    gopRemainingB,
    gopRemainingI,
    gopRemainingP,
    graphicsPipelineLibrary,
    graphicsPipelineLibraryFastLinking,
    graphicsPipelineLibraryIndependentInterpolationDecoration,
    gridDimX,
    gridDimY,
    gridDimZ,
    group,
    groupCount,
    groupCountX,
    groupCountY,
    groupCountZ,
    groupIndex,
    groupShader,
    handle,
    handleType,
    handleTypes,
    hasOverrides,
    hasPrimary,
    hasRender,
    hasStdPPSOverrides,
    hasStdSPSOverrides,
    hasStdVPSOverrides,
    headerSize,
    headerVersion,
    heapBudget,
    heapIndex,
    heapUsage,
    height,
    hinstance,
    hintGridSize,
    hintSupported,
    hitShaderBindingOffset,
    hitShaderBindingStride,
    hitShaderBindingTableAddress,
    hitShaderBindingTableBuffer,
    hitShaderBindingTableSize,
    hitShaderBindingTableStride,
    hmonitor,
    hostAddress,
    hostImageCopy,
    hostQueryReset,
    hwnd,
    i64,
    id,
    identicalMemoryLayout,
    identicalMemoryTypeRequirements,
    identifier,
    identifierSize,
    idrPeriod,
    image,
    image2DViewOf3D,
    imageArrayLayers,
    imageBindCount,
    imageCaptureReplayDescriptorDataSize,
    imageColorSpace,
    imageCompressionControl,
    imageCompressionControlSwapchain,
    imageCompressionFixedRateFlags,
    imageCompressionFlags,
    imageCreateFlags,
    imageCreateInfo,
    imageCubeArray,
    imageExtent,
    imageFootprint,
    imageFormat,
    imageFormatProperties,
    imageGranularity,
    imageIndex,
    imageIndexCount,
    imageLayout,
    imageMemoryBarrierCount,
    imageMipTailFirstLod,
    imageMipTailOffset,
    imageMipTailSize,
    imageMipTailStride,
    imageOffset,
    imageOpaqueBindCount,
    imagePipeHandle,
    imageSharingMode,
    imageSlicedViewOf3D,
    imageSubresource,
    imageTiling,
    imageType,
    imageUsage,
    imageUsageFlags,
    imageView,
    imageView2DOn3DImage,
    imageViewBinding,
    imageViewCaptureReplayDescriptorDataSize,
    imageViewFormatReinterpretation,
    imageViewFormatSwizzle,
    imageViewType,
    imagelessFramebuffer,
    images,
    implementationVersion,
    independentBlend,
    independentResolve,
    independentResolveNone,
    index,
    indexBuffer,
    indexCount,
    indexData,
    indexOffset,
    indexStride,
    indexType,
    indexTypeCount,
    indexTypeUint8,
    indirectBufferOffsetAlignment,
    indirectCommandsAddress,
    indirectCommandsCountAddress,
    indirectCommandsLayout,
    indirectCopy,
    indirectDeviceAddress,
    indirectStateFlags,
    info,
    infoCount,
    infoType,
    infos,
    inheritedConditionalRendering,
    inheritedQueries,
    inheritedViewportScissor2D,
    initialDataSize,
    initialLayout,
    initialValue,
    initialVirtualBufferSizeInMs,
    inlineUniformBlock,
    inputAttachmentCount,
    inputAttachmentDescriptorSize,
    inputAttachmentIndex,
    inputRate,
    instance,
    instanceCount,
    instanceCustomIndex,
    instanceData,
    instanceOffset,
    instanceShaderBindingTableRecordOffset,
    instances,
    int32,
    int64,
    integerDotProduct16BitMixedSignednessAccelerated,
    integerDotProduct16BitSignedAccelerated,
    integerDotProduct16BitUnsignedAccelerated,
    integerDotProduct32BitMixedSignednessAccelerated,
    integerDotProduct32BitSignedAccelerated,
    integerDotProduct32BitUnsignedAccelerated,
    integerDotProduct4x8BitPackedMixedSignednessAccelerated,
    integerDotProduct4x8BitPackedSignedAccelerated,
    integerDotProduct4x8BitPackedUnsignedAccelerated,
    integerDotProduct64BitMixedSignednessAccelerated,
    integerDotProduct64BitSignedAccelerated,
    integerDotProduct64BitUnsignedAccelerated,
    integerDotProduct8BitMixedSignednessAccelerated,
    integerDotProduct8BitSignedAccelerated,
    integerDotProduct8BitUnsignedAccelerated,
    integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated,
    integerDotProductAccumulatingSaturating16BitSignedAccelerated,
    integerDotProductAccumulatingSaturating16BitUnsignedAccelerated,
    integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated,
    integerDotProductAccumulatingSaturating32BitSignedAccelerated,
    integerDotProductAccumulatingSaturating32BitUnsignedAccelerated,
    integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated,
    integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated,
    integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated,
    integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated,
    integerDotProductAccumulatingSaturating64BitSignedAccelerated,
    integerDotProductAccumulatingSaturating64BitUnsignedAccelerated,
    integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated,
    integerDotProductAccumulatingSaturating8BitSignedAccelerated,
    integerDotProductAccumulatingSaturating8BitUnsignedAccelerated,
    intersectionShader,
    invocationMask,
    ioSurface,
    isPreprocessed,
    isText,
    largePoints,
    layer,
    layerCount,
    layerName,
    layeredShadingRateAttachments,
    layers,
    layout,
    ldsSizePerLocalWorkGroup,
    ldsUsageSizeInBytes,
    leastRepresentableValueForceUnormRepresentation,
    legacyDithering,
    level,
    levelCount,
    libraryCount,
    limits,
    lineRasterizationMode,
    lineStippleFactor,
    lineStipplePattern,
    lineSubPixelPrecisionBits,
    lineWidth,
    lineWidthGranularity,
    lineWidthRange,
    linearColorAttachment,
    linearTilingFeatures,
    loadOp,
    localDeviceIndex,
    localDimmingEnable,
    localDimmingSupport,
    location,
    logicOp,
    logicOpEnable,
    lumaBitDepth,
    magFilter,
    maintenance4,
    maintenance5,
    major,
    mapEntryCount,
    marker,
    mask,
    matrix,
    matrixMotionInstance,
    maxActiveReferencePictures,
    maxAnisotropy,
    maxArrayLayers,
    maxBPictureL0ReferenceCount,
    maxBitrate,
    maxBlockMatchRegion,
    maxBoundDescriptorSets,
    maxBoxFilterBlockSize,
    maxBufferCount,
    maxBufferSize,
    maxClipDistances,
    maxCodedExtent,
    maxColorAttachments,
    maxCombinedClipAndCullDistances,
    maxComputeSharedMemorySize,
    maxComputeWorkGroupCount,
    maxComputeWorkGroupInvocations,
    maxComputeWorkGroupSize,
    maxComputeWorkgroupSubgroups,
    maxContentLightLevel,
    maxCullDistances,
    maxCustomBorderColorSamplers,
    maxDecompressionIndirectCount,
    maxDepth,
    maxDepthBounds,
    maxDescriptorBufferBindings,
    maxDescriptorSetAccelerationStructures,
    maxDescriptorSetInlineUniformBlocks,
    maxDescriptorSetInputAttachments,
    maxDescriptorSetSampledImages,
    maxDescriptorSetSamplers,
    maxDescriptorSetStorageBuffers,
    maxDescriptorSetStorageBuffersDynamic,
    maxDescriptorSetStorageImages,
    maxDescriptorSetSubsampledSamplers,
    maxDescriptorSetUniformBuffers,
    maxDescriptorSetUniformBuffersDynamic,
    maxDescriptorSetUpdateAfterBindAccelerationStructures,
    maxDescriptorSetUpdateAfterBindInlineUniformBlocks,
    maxDescriptorSetUpdateAfterBindInputAttachments,
    maxDescriptorSetUpdateAfterBindSampledImages,
    maxDescriptorSetUpdateAfterBindSamplers,
    maxDescriptorSetUpdateAfterBindStorageBuffers,
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic,
    maxDescriptorSetUpdateAfterBindStorageImages,
    maxDescriptorSetUpdateAfterBindUniformBuffers,
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic,
    maxDiscardRectangles,
    maxDisplacementMicromapSubdivisionLevel,
    maxDpbSlots,
    maxDrawCount,
    maxDrawIndexedIndexValue,
    maxDrawIndirectCount,
    maxDrawMeshTasksCount,
    maxDstExtent,
    maxDstPosition,
    maxEmbeddedImmutableSamplerBindings,
    maxEmbeddedImmutableSamplers,
    maxExecutionGraphDepth,
    maxExecutionGraphShaderOutputNodes,
    maxExecutionGraphShaderPayloadCount,
    maxExecutionGraphShaderPayloadSize,
    maxExtent,
    maxExtraPrimitiveOverestimationSize,
    maxFragmentCombinedOutputResources,
    maxFragmentDensityTexelSize,
    maxFragmentDualSrcAttachments,
    maxFragmentInputComponents,
    maxFragmentOutputAttachments,
    maxFragmentShadingRateAttachmentTexelSize,
    maxFragmentShadingRateAttachmentTexelSizeAspectRatio,
    maxFragmentShadingRateCoverageSamples,
    maxFragmentShadingRateInvocationCount,
    maxFragmentShadingRateRasterizationSamples,
    maxFragmentSize,
    maxFragmentSizeAspectRatio,
    maxFrameAverageLightLevel,
    maxFrameSize,
    maxFramebufferHeight,
    maxFramebufferLayers,
    maxFramebufferWidth,
    maxGeometryCount,
    maxGeometryInputComponents,
    maxGeometryOutputComponents,
    maxGeometryOutputVertices,
    maxGeometryShaderInvocations,
    maxGeometryTotalOutputComponents,
    maxGraphicsShaderGroupCount,
    maxHeight,
    maxImageArrayLayers,
    maxImageCount,
    maxImageDimension1D,
    maxImageDimension2D,
    maxImageDimension3D,
    maxImageDimensionCube,
    maxImageExtent,
    maxIndirectCommandsStreamCount,
    maxIndirectCommandsStreamStride,
    maxIndirectCommandsTokenCount,
    maxIndirectCommandsTokenOffset,
    maxIndirectSequenceCount,
    maxInlineUniformBlockBindings,
    maxInlineUniformBlockSize,
    maxInlineUniformTotalSize,
    maxInstanceCount,
    maxInstances,
    maxInterpolationOffset,
    maxL1ReferenceCount,
    maxLevelIdc,
    maxLod,
    maxLuminance,
    maxMemoryAllocationCount,
    maxMemoryAllocationSize,
    maxMeshMultiviewViewCount,
    maxMeshOutputComponents,
    maxMeshOutputLayers,
    maxMeshOutputMemorySize,
    maxMeshOutputPrimitives,
    maxMeshOutputVertices,
    maxMeshPayloadAndOutputMemorySize,
    maxMeshPayloadAndSharedMemorySize,
    maxMeshSharedMemorySize,
    maxMeshTotalMemorySize,
    maxMeshWorkGroupCount,
    maxMeshWorkGroupInvocations,
    maxMeshWorkGroupSize,
    maxMeshWorkGroupTotalCount,
    maxMipLevels,
    maxMultiDrawCount,
    maxMultiviewInstanceIndex,
    maxMultiviewViewCount,
    maxNumRegionsOfInterest,
    maxOpacity2StateSubdivisionLevel,
    maxOpacity4StateSubdivisionLevel,
    maxOutputClusterCount,
    maxPPictureL0ReferenceCount,
    maxPerSetDescriptors,
    maxPerStageDescriptorAccelerationStructures,
    maxPerStageDescriptorInlineUniformBlocks,
    maxPerStageDescriptorInputAttachments,
    maxPerStageDescriptorSampledImages,
    maxPerStageDescriptorSamplers,
    maxPerStageDescriptorStorageBuffers,
    maxPerStageDescriptorStorageImages,
    maxPerStageDescriptorUniformBuffers,
    maxPerStageDescriptorUpdateAfterBindAccelerationStructures,
    maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks,
    maxPerStageDescriptorUpdateAfterBindInputAttachments,
    maxPerStageDescriptorUpdateAfterBindSampledImages,
    maxPerStageDescriptorUpdateAfterBindSamplers,
    maxPerStageDescriptorUpdateAfterBindStorageBuffers,
    maxPerStageDescriptorUpdateAfterBindStorageImages,
    maxPerStageDescriptorUpdateAfterBindUniformBuffers,
    maxPerStageResources,
    maxPerStageUpdateAfterBindResources,
    maxPipelineRayHitAttributeSize,
    maxPipelineRayPayloadSize,
    maxPipelineRayRecursionDepth,
    maxPreferredMeshWorkGroupInvocations,
    maxPreferredTaskWorkGroupInvocations,
    maxPrimitiveCount,
    maxPushConstantsSize,
    maxPushDescriptors,
    maxQp,
    maxQualityLevels,
    maxRateControlLayers,
    maxRayDispatchInvocationCount,
    maxRayHitAttributeSize,
    maxRayRecursionDepth,
    maxRecursionDepth,
    maxResourceDescriptorBufferBindings,
    maxResourceDescriptorBufferRange,
    maxResourceSize,
    maxSampleLocationGridSize,
    maxSampleMaskWords,
    maxSamplerAllocationCount,
    maxSamplerAnisotropy,
    maxSamplerDescriptorBufferBindings,
    maxSamplerDescriptorBufferRange,
    maxSamplerLodBias,
    maxScaledImageExtent,
    maxSequencesCount,
    maxSets,
    maxSgprAllocation,
    maxShaderGroupStride,
    maxSliceCount,
    maxSliceSegmentCount,
    maxSrcExtent,
    maxSrcPosition,
    maxStdPPSCount,
    maxStdSPSCount,
    maxStdVPSCount,
    maxStorageBufferRange,
    maxSubLayerCount,
    maxSubgroupSize,
    maxSubpassShadingWorkgroupSizeAspectRatio,
    maxSubsampledArrayLayers,
    maxTaskOutputCount,
    maxTaskPayloadAndSharedMemorySize,
    maxTaskPayloadSize,
    maxTaskSharedMemorySize,
    maxTaskTotalMemorySize,
    maxTaskWorkGroupCount,
    maxTaskWorkGroupInvocations,
    maxTaskWorkGroupSize,
    maxTaskWorkGroupTotalCount,
    maxTemporalLayerCount,
    maxTessellationControlPerPatchOutputComponents,
    maxTessellationControlPerVertexInputComponents,
    maxTessellationControlPerVertexOutputComponents,
    maxTessellationControlTotalOutputComponents,
    maxTessellationEvaluationInputComponents,
    maxTessellationEvaluationOutputComponents,
    maxTessellationGenerationLevel,
    maxTessellationPatchSize,
    maxTexelBufferElements,
    maxTexelGatherOffset,
    maxTexelOffset,
    maxTiles,
    maxTimelineSemaphoreValueDifference,
    maxTransformFeedbackBufferDataSize,
    maxTransformFeedbackBufferDataStride,
    maxTransformFeedbackBufferSize,
    maxTransformFeedbackBuffers,
    maxTransformFeedbackStreamDataSize,
    maxTransformFeedbackStreams,
    maxTriangleCount,
    maxUniformBufferRange,
    maxUpdateAfterBindDescriptorsInAllPools,
    maxVariableDescriptorCount,
    maxVertex,
    maxVertexAttribDivisor,
    maxVertexInputAttributeOffset,
    maxVertexInputAttributes,
    maxVertexInputBindingStride,
    maxVertexInputBindings,
    maxVertexOutputComponents,
    maxVgprAllocation,
    maxViewportDimensions,
    maxViewports,
    maxWeightFilterDimension,
    maxWeightFilterPhases,
    maxWidth,
    maxWorkGroupCount,
    maxWorkGroupSize,
    maxX,
    maxY,
    maxZ,
    memory,
    memoryBarrierCount,
    memoryBindIndex,
    memoryDecompression,
    memoryDeviceIndex,
    memoryHeapCount,
    memoryHeaps,
    memoryImageHeight,
    memoryObjectId,
    memoryOffset,
    memoryPriority,
    memoryProperties,
    memoryRangeCount,
    memoryRequirements,
    memoryRowLength,
    memorySize,
    memoryTypeBits,
    memoryTypeCount,
    memoryTypeIndex,
    memoryTypes,
    meshOutputPerPrimitiveGranularity,
    meshOutputPerVertexGranularity,
    meshShader,
    meshShaderQueries,
    messageCode,
    messageIdNumber,
    messageSeverity,
    messageType,
    messageTypes,
    messenger,
    micromap,
    micromapCaptureReplay,
    micromapCount,
    micromapHostCommands,
    micromapSize,
    minAccelerationStructureScratchOffsetAlignment,
    minBitstreamBufferOffsetAlignment,
    minBitstreamBufferSizeAlignment,
    minBufferCount,
    minBufferCountForCamping,
    minBufferCountForDedicatedSlack,
    minBufferCountForSharedSlack,
    minCodedExtent,
    minDepth,
    minDepthBounds,
    minDstExtent,
    minDstPosition,
    minFilter,
    minFragmentDensityTexelSize,
    minFragmentShadingRateAttachmentTexelSize,
    minHeight,
    minImageCount,
    minImageExtent,
    minImageTransferGranularity,
    minImportedHostPointerAlignment,
    minIndirectCommandsBufferOffsetAlignment,
    minInterpolationOffset,
    minLod,
    minLuminance,
    minMemoryMapAlignment,
    minQp,
    minSampleShading,
    minScaledImageExtent,
    minSequencesCountBufferOffsetAlignment,
    minSequencesIndexBufferOffsetAlignment,
    minSgprAllocation,
    minSrcExtent,
    minSrcPosition,
    minStorageBufferOffsetAlignment,
    minSubgroupSize,
    minTexelBufferOffsetAlignment,
    minTexelGatherOffset,
    minTexelOffset,
    minUniformBufferOffsetAlignment,
    minVertexInputBindingStrideAlignment,
    minVgprAllocation,
    minWidth,
    minX,
    minY,
    minZ,
    minor,
    mipLevel,
    mipLevels,
    mipLodBias,
    mipmapMode,
    mipmapPrecisionBits,
    missShaderBindingOffset,
    missShaderBindingStride,
    missShaderBindingTableAddress,
    missShaderBindingTableBuffer,
    missShaderBindingTableSize,
    missShaderBindingTableStride,
    mode,
    modes,
    module,
    mtlBuffer,
    mtlCommandQueue,
    mtlDevice,
    mtlSharedEvent,
    mtlTexture,
    multiDraw,
    multiDrawIndirect,
    multiViewport,
    multisampleArrayImage,
    multisampledRenderToSingleSampled,
    multisampledRenderToSingleSampledEnable,
    multiview,
    multiviewClusterCullingShader,
    multiviewGeometryShader,
    multiviewMeshShader,
    multiviewPerViewRenderAreas,
    multiviewPerViewViewports,
    multiviewTessellationShader,
    mutableComparisonSamplers,
    mutableDescriptorType,
    mutableDescriptorTypeListCount,
    naluSliceEntryCount,
    naluSliceSegmentEntryCount,
    name,
    negativeOneToOne,
    newLayout,
    nextStage,
    noInvocationFragmentShadingRates,
    nodeIndex,
    nonCoherentAtomSize,
    nonSeamlessCubeMap,
    nonStrictSinglePixelWideLinesUseParallelogram,
    nonStrictWideLinesUseParallelogram,
    nullDescriptor,
    numAABBs,
    numAvailableSgprs,
    numAvailableVgprs,
    numPhases,
    numPhysicalSgprs,
    numPhysicalVgprs,
    numUsedSgprs,
    numUsedVgprs,
    object,
    objectCount,
    objectHandle,
    objectType,
    occlusionQueryEnable,
    occlusionQueryPrecise,
    offset,
    oldLayout,
    oldSwapchain,
    opaqueCaptureAddress,
    opaqueCaptureDescriptorData,
    operation,
    opticalFlow,
    optimal,
    optimalBufferCopyOffsetAlignment,
    optimalBufferCopyRowPitchAlignment,
    optimalDeviceAccess,
    optimalTilingFeatures,
    optimalTilingLayoutUUID,
    origin,
    outputGridSize,
    overallocationBehavior,
    pAccelerationStructure,
    pAccelerationStructures,
    pAcquireInfo,
    pAcquireKeys,
    pAcquireSyncs,
    pAcquireTimeoutMilliseconds,
    pAcquireTimeouts,
    pAddress,
    pAddressInfos,
    pAllocateInfo,
    pAllocator,
    pApiVersion,
    pApplicationInfo,
    pApplicationName,
    pAspectReferences,
    pAttachmentImageInfos,
    pAttachmentInitialSampleLocations,
    pAttachments,
    pAttributes,
    pBeginInfo,
    pBindInfo,
    pBindInfos,
    pBindSessionMemoryInfos,
    pBindingFlags,
    pBindingInfos,
    pBindingReference,
    pBindings,
    pBinds,
    pBlitImageInfo,
    pBuffer,
    pBufferBinds,
    pBufferConstraintsInfo,
    pBufferIndices,
    pBufferInfo,
    pBufferMemoryBarriers,
    pBuffers,
    pBuildInfo,
    pCallableShaderBindingTable,
    pCallback,
    pCallbackData,
    pCapabilities,
    pCheckpointData,
    pCheckpointDataCount,
    pCheckpointMarker,
    pClearValues,
    pCmdBufLabels,
    pCode,
    pCodingControlInfo,
    pCollection,
    pColor,
    pColorAttachmentFormats,
    pColorAttachmentSamples,
    pColorAttachments,
    pColorBlendAdvanced,
    pColorBlendEnables,
    pColorBlendEquations,
    pColorBlendState,
    pColorSpaces,
    pColorWriteEnables,
    pColorWriteMasks,
    pCombinationCount,
    pCombinations,
    pCombinedImageSampler,
    pCommandBufferDeviceMasks,
    pCommandBufferInfos,
    pCommandBuffers,
    pCommandPool,
    pCommittedMemoryInBytes,
    pCompatibility,
    pConditionalRenderingBegin,
    pConfiguration,
    pCopyBufferInfo,
    pCopyBufferToImageInfo,
    pCopyDstLayouts,
    pCopyImageInfo,
    pCopyImageToBufferInfo,
    pCopyImageToImageInfo,
    pCopyImageToMemoryInfo,
    pCopyMemoryToImageInfo,
    pCopySrcLayouts,
    pCorrelatedViewMasks,
    pCorrelationMasks,
    pCountInfo,
    pCounterBufferOffsets,
    pCounterBuffers,
    pCounterCount,
    pCounterDescriptions,
    pCounterIndices,
    pCounterValue,
    pCounters,
    pCoverageModulationTable,
    pCreateInfo,
    pCreateInfos,
    pCustomSampleOrders,
    pData,
    pDataSize,
    pDecodeInfo,
    pDecompressMemoryRegions,
    pDeferredOperation,
    pDependencies,
    pDependencyInfo,
    pDependencyInfos,
    pDepthAttachment,
    pDepthBiasInfo,
    pDepthStencil,
    pDepthStencilAttachment,
    pDepthStencilResolveAttachment,
    pDepthStencilState,
    pDescriptor,
    pDescriptorCopies,
    pDescriptorCounts,
    pDescriptorInfo,
    pDescriptorPool,
    pDescriptorSets,
    pDescriptorTypes,
    pDescriptorUpdateEntries,
    pDescriptorUpdateTemplate,
    pDescriptorWrites,
    pDevice,
    pDeviceEventInfo,
    pDeviceGroupPresentCapabilities,
    pDeviceIndices,
    pDeviceMasks,
    pDeviceRenderAreas,
    pDisabledValidationChecks,
    pDisabledValidationFeatures,
    pDiscardRectangles,
    pDisplay,
    pDisplayCount,
    pDisplayEventInfo,
    pDisplayPlaneInfo,
    pDisplayPowerInfo,
    pDisplayTimingProperties,
    pDisplays,
    pDrivers,
    pDrmFormatModifierProperties,
    pDrmFormatModifiers,
    pDynamicOffsets,
    pDynamicState,
    pDynamicStates,
    pEnabledFeatures,
    pEnabledValidationFeatures,
    pEncodeInfo,
    pEndCodingInfo,
    pEngineName,
    pEvent,
    pEvents,
    pExclusiveScissorEnables,
    pExclusiveScissors,
    pExecutableCount,
    pExecutableInfo,
    pExecuteInfo,
    pExternalBufferInfo,
    pExternalBufferProperties,
    pExternalFenceInfo,
    pExternalFenceProperties,
    pExternalImageFormatProperties,
    pExternalSemaphoreInfo,
    pExternalSemaphoreProperties,
    pExtras,
    pFaultCounts,
    pFaultInfo,
    pFd,
    pFeatures,
    pFeedbackInfo,
    pFence,
    pFences,
    pFixedRateFlags,
    pFormatConstraints,
    pFormatCount,
    pFormatInfo,
    pFormatProperties,
    pFragmentDensityOffsets,
    pFragmentShadingRateAttachment,
    pFragmentShadingRateCount,
    pFragmentShadingRates,
    pFragmentSize,
    pFramebuffer,
    pFunction,
    pGeneratedCommandsInfo,
    pGeometries,
    pGetFdInfo,
    pGetWin32HandleInfo,
    pGetZirconHandleInfo,
    pGranularity,
    pGroups,
    pHandle,
    pHitShaderBindingTable,
    pHostMapping,
    pHostPointer,
    pIdentifier,
    pImage,
    pImageBinds,
    pImageConstraintsInfo,
    pImageFormatInfo,
    pImageFormatProperties,
    pImageIndex,
    pImageIndices,
    pImageInfo,
    pImageMemoryBarriers,
    pImageOpaqueBinds,
    pImageSubresources,
    pImmutableSamplers,
    pImportFenceFdInfo,
    pImportFenceWin32HandleInfo,
    pImportSemaphoreFdInfo,
    pImportSemaphoreWin32HandleInfo,
    pImportSemaphoreZirconHandleInfo,
    pIndexInfo,
    pIndexTypeValues,
    pIndexTypes,
    pIndirectCommandsLayout,
    pIndirectDeviceAddresses,
    pIndirectStrides,
    pInfo,
    pInfoSize,
    pInfos,
    pInheritanceInfo,
    pInitialData,
    pInitializeInfo,
    pInputAssemblyState,
    pInputAttachmentImage,
    pInputAttachments,
    pInstance,
    pInternalRepresentationCount,
    pInternalRepresentations,
    pLabelInfo,
    pLabelName,
    pLaunchInfo,
    pLayer,
    pLayerName,
    pLayerPrefix,
    pLayers,
    pLayout,
    pLayoutSizeInBytes,
    pLibraries,
    pLibraryInfo,
    pLibraryInterface,
    pMapEntries,
    pMarkerInfo,
    pMarkerName,
    pMaxDeviation,
    pMaxPrimitiveCounts,
    pMaxWorkgroupSize,
    pMemory,
    pMemoryBarriers,
    pMemoryFdProperties,
    pMemoryGetRemoteAddressInfo,
    pMemoryHostPointerProperties,
    pMemoryMapInfo,
    pMemoryProperties,
    pMemoryRanges,
    pMemoryRequirements,
    pMemoryRequirementsCount,
    pMemoryUnmapInfo,
    pMemoryWin32HandleProperties,
    pMemoryZirconHandleProperties,
    pMessage,
    pMessageIdName,
    pMessenger,
    pMetadata,
    pMetalObjectsInfo,
    pMicromap,
    pMicromaps,
    pMissShaderBindingTable,
    pMode,
    pModes,
    pModule,
    pMultisampleProperties,
    pMultisampleState,
    pMutableDescriptorTypeLists,
    pNaluSliceEntries,
    pNaluSliceSegmentEntries,
    pName,
    pNameInfo,
    pNext,
    pNodeIndex,
    pNodeInfo,
    pNumPasses,
    pObjectName,
    pObjects,
    pOffset,
    pOffsets,
    pOpticalFlowImageFormatInfo,
    pOverrideInfo,
    pParametersAddInfo,
    pParams,
    pPeerMemoryFeatures,
    pPerViewRenderAreas,
    pPerformanceQueryCreateInfo,
    pPhysicalDeviceCount,
    pPhysicalDeviceGroupCount,
    pPhysicalDeviceGroupProperties,
    pPhysicalDevices,
    pPictureResource,
    pPipelineCache,
    pPipelineCreationFeedback,
    pPipelineInfo,
    pPipelineLayout,
    pPipelineProperties,
    pPipelineStageCreationFeedbacks,
    pPipelines,
    pPlaneLayouts,
    pPoolSizes,
    pPostSubpassSampleLocations,
    pPresentIds,
    pPresentInfo,
    pPresentModeCount,
    pPresentModes,
    pPresentationTimingCount,
    pPresentationTimings,
    pPreserveAttachments,
    pPrivateData,
    pPrivateDataSlot,
    pProfiles,
    pProperties,
    pPropertiesCount,
    pPropertyCount,
    pPushConstantRanges,
    pQualityLevelInfo,
    pQualityLevelProperties,
    pQueriedLowLatencyData,
    pQueryPool,
    pQueue,
    pQueueCreateInfos,
    pQueueFamilyIndices,
    pQueueFamilyProperties,
    pQueueFamilyPropertyCount,
    pQueueInfo,
    pQueueLabels,
    pQueuePriorities,
    pRanges,
    pRasterizationState,
    pRaygenShaderBindingTable,
    pRectCount,
    pRectangles,
    pRects,
    pReferenceSlots,
    pRegions,
    pReleaseInfo,
    pReleaseKeys,
    pReleaseSyncs,
    pRenderPass,
    pRenderPassBegin,
    pRenderPassFeedback,
    pRenderingAreaInfo,
    pRenderingInfo,
    pResolveAttachments,
    pResolveImageInfo,
    pResults,
    pSampleLocations,
    pSampleLocationsInfo,
    pSampleMask,
    pSampledImage,
    pSampler,
    pScissors,
    pSemaphore,
    pSemaphores,
    pSession,
    pSetLayout,
    pSetLayouts,
    pSetupReferenceSlot,
    pShaderGroupCaptureReplayHandle,
    pShaderModule,
    pShaders,
    pShadingRatePaletteEntries,
    pShadingRatePalettes,
    pSignalInfo,
    pSignalSemaphoreDeviceIndices,
    pSignalSemaphoreInfos,
    pSignalSemaphoreValues,
    pSignalSemaphores,
    pSizeInfo,
    pSizes,
    pSliceOffsets,
    pSliceSegmentOffsets,
    pSparseMemoryRequirementCount,
    pSparseMemoryRequirements,
    pSpecializationInfo,
    pSplitInstanceBindRegions,
    pSrcCaches,
    pStages,
    pStatisticCount,
    pStatistics,
    pStdHeaderVersion,
    pStdPPSs,
    pStdPictureInfo,
    pStdReferenceInfo,
    pStdSPSs,
    pStdSliceHeader,
    pStdSliceSegmentHeader,
    pStdVPSs,
    pStencilAttachment,
    pStorageBuffer,
    pStorageImage,
    pStorageTexelBuffer,
    pStreamStrides,
    pStreams,
    pStrides,
    pSubmits,
    pSubpassBeginInfo,
    pSubpassEndInfo,
    pSubpassFeedback,
    pSubpasses,
    pSubresource,
    pSupport,
    pSupported,
    pSurface,
    pSurfaceCapabilities,
    pSurfaceFormatCount,
    pSurfaceFormats,
    pSurfaceInfo,
    pSwapchain,
    pSwapchainImageCount,
    pSwapchainImages,
    pSwapchains,
    pTag,
    pTagInfo,
    pTessellationState,
    pTexelBufferView,
    pTimeDomainCount,
    pTimeDomains,
    pTimes,
    pTimestampInfos,
    pTimestamps,
    pTokens,
    pToolCount,
    pToolProperties,
    pTransitions,
    pUniformBuffer,
    pUniformTexelBuffer,
    pUpdateInfo,
    pUsageCounts,
    pUserData,
    pValidationCache,
    pValue,
    pValues,
    pVendorBinaryData,
    pVendorInfos,
    pVersionData,
    pVersionInfo,
    pVertexAttributeDescriptions,
    pVertexBindingDescriptions,
    pVertexBindingDivisors,
    pVertexInfo,
    pVertexInputState,
    pVertexOffset,
    pVideoFormatInfo,
    pVideoFormatProperties,
    pVideoFormatPropertyCount,
    pVideoProfile,
    pVideoSession,
    pVideoSessionParameters,
    pVideoSessionParametersInfo,
    pView,
    pViewFormats,
    pViewMasks,
    pViewOffsets,
    pViewportDepths,
    pViewportState,
    pViewportSwizzles,
    pViewportWScalings,
    pViewports,
    pWaitDstStageMask,
    pWaitInfo,
    pWaitSemaphoreDeviceIndices,
    pWaitSemaphoreInfos,
    pWaitSemaphoreValues,
    pWaitSemaphores,
    pYcbcrConversion,
    pZirconHandle,
    pageableDeviceLocalMemory,
    paramCount,
    parameter,
    parameters,
    passOp,
    patch,
    patchControlPoints,
    payloadCount,
    payloadStride,
    payloads,
    pciBus,
    pciDevice,
    pciDomain,
    pciFunction,
    perViewAttributes,
    perViewAttributesPositionXOnly,
    perViewPositionAllComponents,
    perViewRenderAreaCount,
    performanceCounterMultipleQueryPools,
    performanceCounterQueryPools,
    performanceCountersSampling,
    performanceLevel,
    persistent,
    persistentContent,
    pfnAllocation,
    pfnCallback,
    pfnFree,
    pfnGetInstanceProcAddr,
    pfnInternalAllocation,
    pfnInternalFree,
    pfnReallocation,
    pfnUserCallback,
    physicalDevice,
    physicalDeviceCount,
    physicalDevices,
    physicalDimensions,
    physicalResolution,
    pictureAccessGranularity,
    pictureFormat,
    pictureLayout,
    pipeline,
    pipelineAddress,
    pipelineBindPoint,
    pipelineCache,
    pipelineCacheUUID,
    pipelineCount,
    pipelineCreationCacheControl,
    pipelineDeviceAddressCaptureReplay,
    pipelineExecutableInfo,
    pipelineFragmentShadingRate,
    pipelineIdentifier,
    pipelineLayout,
    pipelineLibraryGroupHandles,
    pipelinePropertiesIdentifier,
    pipelineProtectedAccess,
    pipelineRobustness,
    pipelineStackSize,
    pipelineStage,
    pipelineStageCreationFeedbackCount,
    pipelineStatistics,
    pipelineStatisticsQuery,
    pixelRate,
    pixelX,
    pixelY,
    plane,
    planeAspect,
    planeIndex,
    planeReorderPossible,
    planeStackIndex,
    pointClippingBehavior,
    pointPolygons,
    pointSizeGranularity,
    pointSizeRange,
    polygonMode,
    polygonModePointSize,
    poolSizeCount,
    postMergeIndex,
    postMergeSubpassCount,
    postSubpassSampleLocationsCount,
    powerState,
    ppBuildRangeInfos,
    ppData,
    ppEnabledExtensionNames,
    ppEnabledLayerNames,
    ppGeometries,
    ppMaxPrimitiveCounts,
    ppUsageCounts,
    preTransform,
    precedingExternallyEncodedBytes,
    preferredConsecutiveBFrameCount,
    preferredConstantQp,
    preferredGopFrameCount,
    preferredIdrPeriod,
    preferredMaxL0ReferenceCount,
    preferredMaxL1ReferenceCount,
    preferredRateControlFlags,
    preferredRateControlLayerCount,
    preferredRateControlMode,
    preferredStdEntropyCodingModeFlag,
    preferredSubLayerCount,
    preferredTemporalLayerCount,
    prefersCompactPrimitiveOutput,
    prefersCompactVertexOutput,
    prefersDedicatedAllocation,
    prefersGopRemainingFrames,
    prefersLocalInvocationPrimitiveOutput,
    prefersLocalInvocationVertexOutput,
    preprocessBuffer,
    preprocessOffset,
    preprocessSize,
    presentBarrier,
    presentBarrierEnable,
    presentBarrierSupported,
    presentGravityX,
    presentGravityY,
    presentID,
    presentId,
    presentMargin,
    presentMask,
    presentMode,
    presentModeCount,
    presentWait,
    preserveAttachmentCount,
    primaryMajor,
    primaryMinor,
    primitiveCount,
    primitiveFragmentShadingRate,
    primitiveFragmentShadingRateMeshShader,
    primitiveFragmentShadingRateWithMultipleViewports,
    primitiveOffset,
    primitiveOverestimationSize,
    primitiveRestartEnable,
    primitiveTopology,
    primitiveTopologyListRestart,
    primitiveTopologyPatchListRestart,
    primitiveUnderestimation,
    primitivesGeneratedQuery,
    primitivesGeneratedQueryWithNonZeroStreams,
    primitivesGeneratedQueryWithRasterizerDiscard,
    priorities,
    priority,
    priorityCount,
    privateData,
    privateDataSlot,
    privateDataSlotRequestCount,
    profileCount,
    properties,
    propertyFlags,
    protectedMemory,
    protectedNoFault,
    protectedSubmit,
    provokingVertexLast,
    provokingVertexMode,
    provokingVertexModePerPipeline,
    purposes,
    pushConstantRangeCount,
    pushconstantOffset,
    pushconstantPipelineLayout,
    pushconstantShaderStageFlags,
    pushconstantSize,
    pvx,
    pvy,
    pvz,
    qpB,
    qpI,
    qpP,
    quadDivergentImplicitLod,
    quadOperationsInAllStages,
    qualityLevel,
    query,
    queryCount,
    queryFlags,
    queryPool,
    queryResultStatusSupport,
    queryType,
    queue,
    queueCount,
    queueCreateInfoCount,
    queueFamilyIndex,
    queueFamilyIndexCount,
    queueFamilyProperties,
    queueFlags,
    queueIndex,
    queueLabelCount,
    qw,
    qx,
    qy,
    qz,
    r,
    range,
    rangeCount,
    rasterizationOrder,
    rasterizationOrderColorAttachmentAccess,
    rasterizationOrderDepthAttachmentAccess,
    rasterizationOrderStencilAttachmentAccess,
    rasterizationSamples,
    rasterizationStream,
    rasterizerDiscardEnable,
    rateControlMode,
    rateControlModes,
    rayQuery,
    rayTracingInvocationReorder,
    rayTracingInvocationReorderReorderingHint,
    rayTracingMaintenance1,
    rayTracingMotionBlur,
    rayTracingMotionBlurPipelineTraceRaysIndirect,
    rayTracingPipeline,
    rayTracingPipelineShaderGroupHandleCaptureReplay,
    rayTracingPipelineShaderGroupHandleCaptureReplayMixed,
    rayTracingPipelineTraceRaysIndirect,
    rayTracingPipelineTraceRaysIndirect2,
    rayTracingPositionFetch,
    rayTraversalPrimitiveCulling,
    raygenShaderBindingOffset,
    raygenShaderBindingTableBuffer,
    raygenShaderRecordAddress,
    raygenShaderRecordSize,
    rect,
    rectCount,
    rectangleCount,
    rectangularLines,
    reductionMode,
    reference,
    referencePictureFormat,
    referenceSlotCount,
    refreshDuration,
    refreshRate,
    regionCount,
    releaseCount,
    remoteDeviceIndex,
    renderArea,
    renderMajor,
    renderMinor,
    renderPass,
    renderpass,
    reportAddressBinding,
    reportedAddress,
    representativeFragmentTest,
    representativeFragmentTestEnable,
    requiredFormatFeatures,
    requiredSubgroupSize,
    requiredSubgroupSizeStages,
    requiresDedicatedAllocation,
    requiresGopRemainingFrames,
    residencyAlignedMipSize,
    residencyNonResidentStrict,
    residencyStandard2DBlockShape,
    residencyStandard2DMultisampleBlockShape,
    residencyStandard3DBlockShape,
    resolveImageLayout,
    resolveImageView,
    resolveMode,
    resourceDescriptorBufferAddressSpaceSize,
    resourceDeviceIndex,
    resourceOffset,
    resourceUsage,
    robustBufferAccess,
    robustBufferAccess2,
    robustBufferAccessUpdateAfterBind,
    robustImageAccess,
    robustImageAccess2,
    robustStorageBufferAccessSizeAlignment,
    robustStorageBufferDescriptorSize,
    robustStorageTexelBufferDescriptorSize,
    robustUniformBufferAccessSizeAlignment,
    robustUniformBufferDescriptorSize,
    robustUniformTexelBufferDescriptorSize,
    roundingModeIndependence,
    rowPitch,
    rrOutput,
    runtimeDescriptorArray,
    sType,
    sample,
    sampleCount,
    sampleCounts,
    sampleLocationCoordinateRange,
    sampleLocationCount,
    sampleLocationGridSize,
    sampleLocationSampleCounts,
    sampleLocationSubPixelBits,
    sampleLocationsCount,
    sampleLocationsEnable,
    sampleLocationsInfo,
    sampleLocationsPerPixel,
    sampleOrderType,
    sampleRateShading,
    sampleShadingEnable,
    sampledImageColorSampleCounts,
    sampledImageDepthSampleCounts,
    sampledImageDescriptorSize,
    sampledImageIntegerSampleCounts,
    sampledImageStencilSampleCounts,
    sampler,
    sampler2DViewOf3D,
    samplerAnisotropy,
    samplerCaptureReplayDescriptorDataSize,
    samplerDescriptorBufferAddressSpaceSize,
    samplerDescriptorSize,
    samplerFilterMinmax,
    samplerMipLodBias,
    samplerMirrorClampToEdge,
    samplerYcbcrConversion,
    samplerYcbcrConversionComponents,
    samples,
    saturatingAccumulation,
    scalarBlockLayout,
    scalingBehavior,
    scissorCount,
    scope,
    scratch,
    scratchData,
    scratchMemUsageInBytes,
    scratchOffset,
    screenBufferImport,
    screenUsage,
    semaphore,
    semaphoreCount,
    semaphoreType,
    separateDepthStencilLayouts,
    separateStencilMaskRef,
    sequencesCount,
    sequencesCountBuffer,
    sequencesCountOffset,
    sequencesIndexBuffer,
    sequencesIndexOffset,
    session,
    set,
    setCount,
    setLayoutCount,
    sgprAllocationGranularity,
    sgprsPerSimd,
    shader,
    shaderArraysPerEngineCount,
    shaderBinaryUUID,
    shaderBinaryVersion,
    shaderBufferFloat16AtomicAdd,
    shaderBufferFloat16AtomicMinMax,
    shaderBufferFloat16Atomics,
    shaderBufferFloat32AtomicAdd,
    shaderBufferFloat32AtomicMinMax,
    shaderBufferFloat32Atomics,
    shaderBufferFloat64AtomicAdd,
    shaderBufferFloat64AtomicMinMax,
    shaderBufferFloat64Atomics,
    shaderBufferInt64Atomics,
    shaderClipDistance,
    shaderCoreBuiltins,
    shaderCoreCount,
    shaderCoreFeatures,
    shaderCoreMask,
    shaderCullDistance,
    shaderDemoteToHelperInvocation,
    shaderDenormFlushToZeroFloat16,
    shaderDenormFlushToZeroFloat32,
    shaderDenormFlushToZeroFloat64,
    shaderDenormPreserveFloat16,
    shaderDenormPreserveFloat32,
    shaderDenormPreserveFloat64,
    shaderDeviceClock,
    shaderDrawParameters,
    shaderEarlyAndLateFragmentTests,
    shaderEngineCount,
    shaderEnqueue,
    shaderFloat16,
    shaderFloat64,
    shaderGroupBaseAlignment,
    shaderGroupHandleAlignment,
    shaderGroupHandleCaptureReplaySize,
    shaderGroupHandleSize,
    shaderImageFloat32AtomicAdd,
    shaderImageFloat32AtomicMinMax,
    shaderImageFloat32Atomics,
    shaderImageGatherExtended,
    shaderImageInt64Atomics,
    shaderInputAttachmentArrayDynamicIndexing,
    shaderInputAttachmentArrayNonUniformIndexing,
    shaderInputAttachmentArrayNonUniformIndexingNative,
    shaderInt16,
    shaderInt64,
    shaderInt8,
    shaderIntegerDotProduct,
    shaderIntegerFunctions2,
    shaderModule,
    shaderModuleIdentifier,
    shaderModuleIdentifierAlgorithmUUID,
    shaderObject,
    shaderOutputLayer,
    shaderOutputViewportIndex,
    shaderResourceMinLod,
    shaderResourceResidency,
    shaderRoundingModeRTEFloat16,
    shaderRoundingModeRTEFloat32,
    shaderRoundingModeRTEFloat64,
    shaderRoundingModeRTZFloat16,
    shaderRoundingModeRTZFloat32,
    shaderRoundingModeRTZFloat64,
    shaderSMBuiltins,
    shaderSMCount,
    shaderSampleRateInterpolationFunctions,
    shaderSampledImageArrayDynamicIndexing,
    shaderSampledImageArrayNonUniformIndexing,
    shaderSampledImageArrayNonUniformIndexingNative,
    shaderSharedFloat16AtomicAdd,
    shaderSharedFloat16AtomicMinMax,
    shaderSharedFloat16Atomics,
    shaderSharedFloat32AtomicAdd,
    shaderSharedFloat32AtomicMinMax,
    shaderSharedFloat32Atomics,
    shaderSharedFloat64AtomicAdd,
    shaderSharedFloat64AtomicMinMax,
    shaderSharedFloat64Atomics,
    shaderSharedInt64Atomics,
    shaderSignedZeroInfNanPreserveFloat16,
    shaderSignedZeroInfNanPreserveFloat32,
    shaderSignedZeroInfNanPreserveFloat64,
    shaderStage,
    shaderStageMask,
    shaderStorageBufferArrayDynamicIndexing,
    shaderStorageBufferArrayNonUniformIndexing,
    shaderStorageBufferArrayNonUniformIndexingNative,
    shaderStorageImageArrayDynamicIndexing,
    shaderStorageImageArrayNonUniformIndexing,
    shaderStorageImageArrayNonUniformIndexingNative,
    shaderStorageImageExtendedFormats,
    shaderStorageImageMultisample,
    shaderStorageImageReadWithoutFormat,
    shaderStorageImageWriteWithoutFormat,
    shaderStorageTexelBufferArrayDynamicIndexing,
    shaderStorageTexelBufferArrayNonUniformIndexing,
    shaderSubgroupClock,
    shaderSubgroupExtendedTypes,
    shaderSubgroupUniformControlFlow,
    shaderTerminateInvocation,
    shaderTessellationAndGeometryPointSize,
    shaderTileImageCoherentReadAccelerated,
    shaderTileImageColorReadAccess,
    shaderTileImageDepthReadAccess,
    shaderTileImageReadFromHelperInvocation,
    shaderTileImageReadSampleFromPixelRateInvocation,
    shaderTileImageStencilReadAccess,
    shaderUniformBufferArrayDynamicIndexing,
    shaderUniformBufferArrayNonUniformIndexing,
    shaderUniformBufferArrayNonUniformIndexingNative,
    shaderUniformTexelBufferArrayDynamicIndexing,
    shaderUniformTexelBufferArrayNonUniformIndexing,
    shaderWarpsPerCore,
    shaderWarpsPerSM,
    shaderZeroInitializeWorkgroupMemory,
    shadingRate,
    shadingRateAttachmentTexelSize,
    shadingRateCoarseSampleOrder,
    shadingRateImage,
    shadingRateImageEnable,
    shadingRateMaxCoarseSamples,
    shadingRatePaletteEntryCount,
    shadingRatePaletteSize,
    shadingRateTexelSize,
    shadingRateType,
    sharedMemBytes,
    sharedPresentSupportedUsageFlags,
    sharingMode,
    signalSemaphoreCount,
    signalSemaphoreInfoCount,
    signalSemaphoreValueCount,
    signalSemaphoreValuesCount,
    simdPerComputeUnit,
    size,
    sliceCount,
    sliceOffset,
    sliceSegmentCount,
    slotIndex,
    smoothLines,
    sparseAddressSpaceSize,
    sparseBinding,
    sparseImageFloat32AtomicAdd,
    sparseImageFloat32AtomicMinMax,
    sparseImageFloat32Atomics,
    sparseImageInt64Atomics,
    sparseProperties,
    sparseResidency16Samples,
    sparseResidency2Samples,
    sparseResidency4Samples,
    sparseResidency8Samples,
    sparseResidencyAliased,
    sparseResidencyBuffer,
    sparseResidencyImage2D,
    sparseResidencyImage3D,
    specVersion,
    splitInstanceBindRegionCount,
    src,
    srcAccelerationStructure,
    srcAccessMask,
    srcAddress,
    srcAlphaBlendFactor,
    srcArrayElement,
    srcBinding,
    srcBuffer,
    srcBufferOffset,
    srcBufferRange,
    srcCacheCount,
    srcColorBlendFactor,
    srcImage,
    srcImageLayout,
    srcOffset,
    srcOffsets,
    srcPictureResource,
    srcPremultiplied,
    srcQueueFamilyIndex,
    srcRect,
    srcSet,
    srcStageMask,
    srcSubpass,
    srcSubresource,
    srgb,
    srtMotionInstance,
    stage,
    stageCount,
    stageFlags,
    stageMask,
    stages,
    standardSampleLocations,
    staticInstance,
    stdHeaderVersion,
    stdPPSCount,
    stdPPSId,
    stdProfileIdc,
    stdSPSCount,
    stdSPSId,
    stdSyntaxFlags,
    stdVPSCount,
    stdVPSId,
    stencil,
    stencilAttachmentFormat,
    stencilFinalLayout,
    stencilInitialLayout,
    stencilLayout,
    stencilLoadOp,
    stencilResolveMode,
    stencilStoreOp,
    stencilTestEnable,
    stencilUsage,
    stippledBresenhamLines,
    stippledLineEnable,
    stippledRectangularLines,
    stippledSmoothLines,
    storage,
    storageBuffer16BitAccess,
    storageBuffer8BitAccess,
    storageBufferDescriptorSize,
    storageBuffers,
    storageImageDescriptorSize,
    storageImageSampleCounts,
    storageInputOutput16,
    storagePushConstant16,
    storagePushConstant8,
    storageTexelBufferDescriptorSize,
    storageTexelBufferOffsetAlignmentBytes,
    storageTexelBufferOffsetSingleTexelAlignment,
    storeOp,
    stream,
    streamCount,
    streamDescriptor,
    strictLines,
    stride,
    subLayerCount,
    subPixelInterpolationOffsetBits,
    subPixelPrecisionBits,
    subTexelPrecisionBits,
    subdivisionLevel,
    subgroupBroadcastDynamicId,
    subgroupQuadOperationsInAllStages,
    subgroupSize,
    subgroupSizeControl,
    subgroupSupportedOperations,
    subgroupSupportedStages,
    subminor,
    submitCount,
    subpass,
    subpassCount,
    subpassIndex,
    subpassMergeFeedback,
    subpassMergeStatus,
    subpassShading,
    subresource,
    subresourceLayout,
    subresourceRange,
    subsampledCoarseReconstructionEarlyAccess,
    subsampledLoads,
    subsetAllocation,
    suggestedXChromaOffset,
    suggestedYChromaOffset,
    suggestedYcbcrModel,
    suggestedYcbcrRange,
    supersampleFragmentShadingRates,
    supported,
    supportedAlpha,
    supportedCompositeAlpha,
    supportedDepthResolveModes,
    supportedEncodeFeedbackFlags,
    supportedHintGridSizes,
    supportedOperations,
    supportedOutputGridSizes,
    supportedPresentGravityX,
    supportedPresentGravityY,
    supportedPresentScaling,
    supportedQueues,
    supportedStages,
    supportedStencilResolveModes,
    supportedSurfaceCounters,
    supportedTransforms,
    supportedUsageFlags,
    supportsProtected,
    supportsTextureGatherLODBiasAMD,
    surface,
    surfaceCapabilities,
    surfaceCounters,
    surfaceFormat,
    swapBufferTimestamp,
    swapChain,
    swapchain,
    swapchainCount,
    swapchainMaintenance1,
    sx,
    sy,
    synchronization2,
    sysmemColorSpaceIndex,
    sysmemPixelFormat,
    sz,
    tagName,
    tagSize,
    taskCount,
    taskShader,
    templateType,
    temporalLayerCount,
    tessellationIsolines,
    tessellationPointMode,
    tessellationShader,
    texelBufferAlignment,
    texelRate,
    textureBlockMatch,
    textureBoxFilter,
    textureCompressionASTC_HDR,
    textureCompressionASTC_LDR,
    textureCompressionBC,
    textureCompressionETC2,
    textureSampleWeighted,
    tileProperties,
    tileSize,
    tiling,
    timeDomain,
    timelineSemaphore,
    timeout,
    timestampComputeAndGraphics,
    timestampCount,
    timestampPeriod,
    timestampValidBits,
    tokenCount,
    tokenType,
    topology,
    transform,
    transformBlockSizes,
    transformData,
    transformFeedback,
    transformFeedbackDraw,
    transformFeedbackPreservesProvokingVertex,
    transformFeedbackPreservesTriangleFanProvokingVertex,
    transformFeedbackQueries,
    transformFeedbackRasterizationStreamSelect,
    transformFeedbackStreamsLinesTriangles,
    transformOffset,
    transformT0,
    transformT1,
    transitionCount,
    triStripVertexOrderIndependentOfProvokingVertex,
    triangleArray,
    triangleArrayStride,
    triangleFans,
    triangles,
    tuningMode,
    tx,
    ty,
    type,
    tz,
    u64,
    uint32,
    uint64,
    uniformAndStorageBuffer16BitAccess,
    uniformAndStorageBuffer8BitAccess,
    uniformBufferDescriptorSize,
    uniformBufferStandardLayout,
    uniformBuffers,
    uniformTexelBufferDescriptorSize,
    uniformTexelBufferOffsetAlignmentBytes,
    uniformTexelBufferOffsetSingleTexelAlignment,
    unit,
    unnormalizedCoordinates,
    update,
    updateScratchSize,
    updateSequenceCount,
    usage,
    usageCountsCount,
    useGopRemainingFrames,
    useMaxFrameSize,
    useMaxLevelIdc,
    useMaxQp,
    useMinQp,
    uuid,
    validationCache,
    value,
    value32,
    value64,
    valueBool,
    valueFloat,
    valueString,
    variableMultisampleRate,
    variablePointers,
    variablePointersStorageBuffer,
    variableSampleLocations,
    vendorBinarySize,
    vendorFaultCode,
    vendorFaultData,
    vendorID,
    vendorInfoCount,
    version,
    vertexAttributeAccessBeyondStride,
    vertexAttributeDescriptionCount,
    vertexAttributeInstanceRateDivisor,
    vertexAttributeInstanceRateZeroDivisor,
    vertexBindingDescriptionCount,
    vertexBindingDivisorCount,
    vertexBindingUnit,
    vertexCount,
    vertexData,
    vertexDynamicStride,
    vertexFormat,
    vertexInputDynamicState,
    vertexInputs,
    vertexOffset,
    vertexPipelineStoresAndAtomics,
    vertexStride,
    vgprAllocationGranularity,
    vgprsPerSimd,
    videoCodecOperation,
    videoCodecOperations,
    videoContentHints,
    videoSession,
    videoSessionParameters,
    videoSessionParametersTemplate,
    videoUsageHints,
    view,
    viewFormatCount,
    viewMask,
    viewOffset,
    viewType,
    viewportBoundsRange,
    viewportCount,
    viewportDepthCount,
    viewportScissor2D,
    viewportSubPixelBits,
    viewportWScalingEnable,
    virtualBufferSizeInMs,
    visibleRegion,
    visualID,
    visual_id,
    vulkanMemoryModel,
    vulkanMemoryModelAvailabilityVisibilityChains,
    vulkanMemoryModelDeviceScope,
    w,
    waitAll,
    waitSemaphoreCount,
    waitSemaphoreInfoCount,
    waitSemaphoreValueCount,
    waitSemaphoreValuesCount,
    wavefrontSize,
    wavefrontsPerSimd,
    whitePoint,
    wideLines,
    width,
    window,
    workgroupMemoryExplicitLayout,
    workgroupMemoryExplicitLayout16BitAccess,
    workgroupMemoryExplicitLayout8BitAccess,
    workgroupMemoryExplicitLayoutScalarBlockLayout,
    writeMask,
    writeStdPPS,
    writeStdSPS,
    writeStdVPS,
    x,
    xChromaOffset,
    xcoeff,
    y,
    yChromaOffset,
    ycbcr2plane444Formats,
    ycbcrConversion,
    ycbcrImageArrays,
    ycbcrModel,
    ycbcrRange,
    ycoeff,
    z,
    zirconHandle,
};

const char* String(Func func);
const char* String(Struct structure);
const char* String(Field field);
}  // namespace core_error

// NOLINTEND
