# Text-based Desktop Environment

## Desktop Objects / Built-in Applications

 Type      | Object                         | Description
-----------|--------------------------------|----------------------
`teletype` | `Teletype Console`             | A solid rectangular truecolor text canvas depicting a freely scrollable buffer of the text runs generated by an xterm-compatible parser from the standard output of an attached CUI application. It can be a very heavy object due to maintaining a scrollback buffer of arbitrary length. Not used directly in the desktop process's address space.
`terminal` | `Terminal Console`             | A derivative of `Teletype Console` with additional UI controls.
`dtvt`     | `DirectVT Gateway`             | A lightweight truecolor text canvas depicting content received from an external dtvt-aware process.
`vtty`     | `Teletype Console dtvt‑bridge` | A `DirectVT Gateway` hosting an external standalone `Teletype Console` process. It is designed to run a heavy `Teletype Console` object in the external process's address space to optimize desktop resource consumption.
`term`     | `Terminal Console dtvt‑bridge` | A `DirectVT Gateway` hosting an external standalone `Terminal Console` process. It is designed to run a heavy `Terminal Console` object in the external process's address space to optimize desktop resource consumption.
`dtty`     | `DirectVT Gateway with TTY`    | A derivative of `DirectVT Gateway` stacked with additional limited `Teletype Console` as a controlling terminal. It is used for CUI applications that redirect DirectVT traffic to standard output and require user input via platform's TTY. Depending on activity the corresponding console became active for the user.
`tile`     | `Tiling Window Manager`        | A window container with an organization of the hosting window area into mutually non-overlapping panes for nested windows.
`site`     | `Desktop Region Marker`        | A transparent resizable frame for marking the specific desktop region for quick navigation across the borderless workspace.

## Teletype / Terminal Console

### Features

- Horizontal scrolling.
- Configurable scrollback buffer size (40k lines by default, limited by `max_int32` and system RAM).
- Scrollback buffer lookup.
- Linear/box text selection:
  - Extending selection with `Ctrl` key pressed.
  - Changing selection mode (linear/box) with `Alt` key pressed.
  - Selecting a word/paragraph/entire scrollback buffer or a semantic block (when using OSC 133) by Double/Triple/Quadruple/Quintuple left clicking.
- Support multiple selection copy formats:
  - Plain text
  - RTF
  - HTML
  - ANSI/VT
  - Protected (MS Windows platform only: `ExcludeClipboardContentFromMonitorProcessing`, `CanIncludeInClipboardHistory`, `CanUploadToCloudClipboard`)
- Built-in MS Windows Console API server:
  - Legacy Win32 Console API support.
  - No MS Windows Console Host (conhost.exe) dependency.
  - Fullduplex pass-through VT input/output.
  - OEM/National, UTF-8 and UTF-16 encoding support.
  - Enforced ENABLE_WINDOW_INPUT mode.  
    Note: In fact it is a viewport resize event reporting. Viewport dimensions is always equal to the win32 console buffer dimensions.
  - Enforced ENABLE_PROCESSED_OUTPUT and ENABLE_VIRTUAL_TERMINAL_PROCESSING modes.
  - Disabled ENABLE_QUICK_EDIT_MODE mode.
  - Per process (not per process name) MS Windows Command Prompt (cmd.exe) input history, aka "line input"/"cooked read".
- Stdin/stdout logging.

### Private control sequences

Name         | Sequence                         | Description
-------------|----------------------------------|------------
`CCC_SBS`    | `CSI` 24 : n : m : q `p`         | Scrollback buffer configuration<br>`n` Initial buffer size<br>`m` Grow step<br>`q` Grow limit
`CCC_SGR`    | `CSI` 28 : Pm `p`                | Set terminal background using SGR attributes (one attribute at once)<br>`Pm` Colon-separated list of attributes, 0 — reset all attributes, _default is 0_
`CCC_SEL`    | `CSI` 29 : n `p`                 | Set selection mode<br>`n = 0` Selection is off (default)<br>`n = 1` Select and copy as plaintext<br>`n = 2` Select and copy as ANSI/VT text<br>`n = 3` Select and copy as RTF-document<br>`n = 4` Select and copy as HTML-code<br>`n = 5` Select and copy as protected plaintext (suppressed preview, [details](https://learn.microsoft.com/en-us/windows/win32/dataxchg/clipboard-formats#cloud-clipboard-and-clipboard-history-formats))
`CCC_PAD`    | `CSI` 30 : n `p`                 | Set scrollbuffer side padding<br>`n` Width in cells, _max = 255, default is 0_
`CCC_RST`    | `CSI` 1 `p`                      | Reset all parameters to default
`CCC_TBS`    | `CSI` 5 : n `p`                  | Set tab length<br>`n` Length in cells, _max = 256, default is 8_
`CCC_JET`    | `CSI` 11 : n `p`                 | Set text alignment, _default is Left_<br>`n = 0` default<br>`n = 1` Left<br>`n = 2` Right<br>`n = 3` Center
`CCC_WRP`    | `CSI` 12 : n `p`                 | Set text autowrap mode, _default is On_<br>`n = 0` default<br>`n = 1` On<br>`n = 2` Off (_enable horizontal scrolling_)
`CCC_RTL`    | `CSI` 13 : n `p`                 | Set text right-to-left mode, _default is Off_<br>`n = 0` default<br>`n = 1` On<br>`n = 2` Off

Note: It is possible to combine multiple command into a single sequence using a semicolon. For example, the following sequence disables wrapping, enables text selection, and sets background to blue: `CSI 12 : 2 ; 29 : 1 ; 28 : 44 p` or `CSI 12 : 2 ; 29 : 1 ; 28 : 48 : 2 : 0 : 0 : 255 p`.

### Custom menu configuration

It is possible to create your own terminal window menu from scratch by specifying a list of menu items in the `<config/terminal/menu/>` section of the configuration file.

#### Syntax

```xml
<config>
    <terminal>
        <menu>
            <item type="<menu_item_type>" action="<action>">
                <tooltip>
                    " Tooltip text.      \n"
                    " Can be multi-line. "
                </tooltip>
                <label="Content for label of index 0 (default)" data="<Argument_for_action_call_for_that_label.>"/>
                <label="Content for label of index 1"           data="<The required label will be selected automatically>"/>
                <label="Content for label of index 2"           data="< based on the argument if the action is performed by"/>
                <label="Content for label of index 3"           data="< someone outside the menu.>" tooltip="The label may have its own tooltip."/>
                ...
            </item>
            ...
        </menu>
    </terminal>
</config>
```

#### Attributes for the `<config/terminal/menu/item>` object

Attribute  | Description
-----------|------------
type       | Menu item type.
label      | Menu item label list. One or more textual representations selected by `data=` value.
tooltip    | Tooltip content.
action     | The action name which called on item activation.

#### Attributes for the `<config/terminal/menu/item/label>` sub-object

Attribute        | Description
-----------------|------------
_internal_value_ | Label content variation `label="_internal_value_"`.
data             | Textual argument for action call.
tooltip          | Tooltip content.

#### Attribute `type`

Value       | Description
------------|------------
`Command`   | Calls the action with the arguments from `data=`. This is the default value for the `type` attribute.
`Option`    | Cyclically selects the next label in the list and calls the action with the arguments from `data=`.
`Repeat`    | Selects the next label and calls the action repeatedly from the time it is pressed until it is released.

#### Attribute `action` (this will soon be replaced by Lua scripting)

`*` - Not implemented.

Value                        | Arguments (`data=`)           | Description
-----------------------------|-------------------------------|------------
ExclusiveKeyboardMode        |                               | Toggle exclusive keyboard mode.
TerminalCwdSync              |                               | Current working directory sync toggle. The command to send for synchronization is configurable via the `<config><terminal cwdsync=" cd $P\n"/></config>` setting's option. Where `$P` is a variable containing current path received via OSC 9;9 notification. <br>To enable OSC9;9 shell notifications:<br>- Windows Command Prompt:<br>  `setx PROMPT $e]9;9;$P$e\$P$G`<br>- PowerShell:<br>  `function prompt{ $e=[char]27; "$e]9;9;$(Convert-Path $pwd)$e\PS $pwd$('>' * ($nestedPromptLevel + 1)) " }`<br>- Bash:<br>  `export PS1='\[\033]9;9;\w\033\\\]${debian_chroot:+($debian_chroot)}\[\033[01;32m\]\u@\h\[\033[00m\]:\[\033[01;34m\]\w\[\033[00m\]\$ '`
TerminalWrapMode             | `on` \| `off`                 | Set terminal scrollback lines wrapping mode. Applied to the active selection if it is.
TerminalAlignMode            | `left` \| `right` \| `center` | Set terminal scrollback lines aligning mode. Applied to the active selection if it is.
TerminalFindNext             |                               | Highlight next match of selected text fragment. Clipboard content is used if no active selection.
TerminalFindPrev             |                               | Highlight previous match of selected text fragment. Clipboard content is used if no active selection.
TerminalOutput               | _`Text string`_               | Direct output the string to the terminal scrollback.
TerminalSendKey              | _`Text string`_               | Simulating keypresses using the specified string.
TerminalQuit                 |                               | Terminate runnning console apps and close terminal.
TerminalRestart              |                               | Terminate runnning console apps and restart current session.
TerminalFullscreen           |                               | Toggle fullscreen mode.
TerminalMaximize             |                               | Toggle between maximized and normal window size.
TerminalMinimize             |                               | Minimize window.
TerminalUndo                 |                               | (Win32 Cooked/ENABLE_LINE_INPUT mode only) Discard the last input.
TerminalRedo                 |                               | (Win32 Cooked/ENABLE_LINE_INPUT mode only) Discard the last Undo command.
TerminalClipboardCopy        |                               | Сopy selection to clipboard.
TerminalClipboardPaste       |                               | Paste from clipboard.
TerminalClipboardWipe        |                               | Reset clipboard.
TerminalClipboardFormat      | `none` \| `text` \| `ansi` \|<br>`rich` \| `html` \| `protected` | Set terminal text selection copy format.
TerminalSelectionRect        | `on` \| `off`                 | Set linear(off) or rectangular(on) selection form using boolean value.
TerminalSelectionCancel      |                               | Deselect a selection.
TerminalSelectionOneShot     | `none` \| `text` \| `ansi` \|<br>`rich` \| `html` \| `protected` | One-shot toggle to copy text while mouse tracking is active. Keep selection if `Ctrl` key is pressed.
TerminalViewportCopy         |                               | Сopy viewport to clipboard.
TerminalScrollViewportByPage | _`IntX, IntY`_                | Scroll viewport by _`IntX, IntY`_ pages.
TerminalScrollViewportByCell | _`IntX, IntY`_                | Scroll viewport by _`IntX, IntY`_ cells.
TerminalScrollViewportToTop  |                               | Scroll viewport to the scrollback top.
TerminalScrollViewportToEnd  |                               | Scroll viewport to the scrollback bottom (reset viewport position).
TerminalStdioLog             | `on` \| `off`                 | Toggle stdin/stdout logging to the specified state, or just toggle to another state if no arguments are specified.
*TerminalLogStart            |                               | Start logging to file.
*TerminalLogPause            |                               | Pause logging.
*TerminalLogStop             |                               | Stop logging.
*TerminalLogAbort            |                               | Abort logging.
*TerminalLogRestart          |                               | Restart logging to file.
*TerminalVideoRecStart       |                               | Start DirectVT(dtvt) video recording to file.
*TerminalVideoRecStop        |                               | Stop dtvt-video recording.
*TerminalVideoRecPause       |                               | Pause dtvt-video recording.
*TerminalVideoRecAbort       |                               | Abort dtvt-video recording.
*TerminalVideoRecRestart     |                               | Restart dtvt-video recording to file.
*TerminalVideoPlay           |                               | Play dtvt-video from file.
*TerminalVideoPause          |                               | Pause dtvt-video.
*TerminalVideoStop           |                               | Stop dtvt-video.
*TerminalVideoForward        |                               | Fast forward dtvt-video by N ms.
*TerminalVideoBackward       |                               | Rewind dtvt-video by N ms.
*TerminalVideoHome           |                               | Rewind dtvt-video to the beginning.
*TerminalVideoEnd            |                               | Rewind dtvt-video to the end.

### Default Hotkeys

List of hotkeys defined in the default configuration.

Hotkey                       | Description
-----------------------------|------------
`Ctrl-Alt \| Alt-Ctrl`       | Win32: Toggle exclusive keyboard mode.
`Alt+Shift+B`                | Unix: Toggle exclusive keyboard mode.
`Alt+RightArrow`             | Highlight next match of selected text fragment. Clipboard content is used if no active selection.
`Alt+LeftArrow`              | Highlight previous match of selected text fragment. Clipboard content is used if no active selection.
`Shift+Ctrl+PageUp`          | Scroll one page up.
`Shift+Ctrl+PageDown`        | Scroll one page down.
`Shift+Alt+LeftArrow`        | Scroll one page to the left.
`Shift+Alt+RightArrow`       | Scroll one page to the right.
`Shift+Ctrl+UpArrow`         | Scroll one line up.
`Shift+Ctrl+DownArrow`       | Scroll one line down.
`Shift+Ctrl+LeftArrow`       | Scroll one cell to the left.
`Shift+Ctrl+RightArrow`      | Scroll one cell to the right.
`Shift+Ctrl+Home`            | Scroll to the scrollback top.
`Shift+Ctrl+End`             | Scroll to the scrollback bottom (reset viewport position).
`Ctrl+Insert`                | Copy selection to clipboard if it is.
`Shift+Insert`               | Paste from clipboard.
`Esc`                        | Deselect a selection if it is.

### Configuration example

```xml
<config>
    <terminal>
        <menu item*>
            <item action=TerminalFindPrev>  <!-- type=Command is a default item's attribute. -->
                <tooltip>
                    " Previous match                                  \n"
                    "   LeftClick to jump to previous match or scroll \n"
                    "             one page up if nothing to search    \n"
                    "   Match clipboard data if no selection          \n"
                    "   Left+RightClick to clear clipboard            "
                </tooltip>
                <label="<"/>
                <label="\e[38:2:0:255:0m<\e[m"/>
            </item>
            <item action=TerminalFindNext>
                <tooltip>
                    " Next match                                     \n"
                    "   LeftClick to jump to next match or scroll    \n"
                    "             one page down if nothing to search \n"
                    "   Match clipboard data if no selection         \n"
                    "   Left+RightClick to clear clipboard           "
                </tooltip>
                <label=">"/>
                <label="\e[38:2:0:255:0m>\e[m"/>
            </item>
            <item type="Option" action=ExclusiveKeyboardMode>
                <tooltip>
                    " Toggle exclusive keyboard mode              \n"
                    "   Exclusive keyboard mode allows keystrokes \n"
                    "   to be passed through without processing   "
                </tooltip>
                <label=" Desktop "                                      data="off"/>
                <label="\e[48:2:0:128:128;38:2:0:255:0m Exclusive \e[m" data="on"/>
            </item>
            <item type="Option" action=TerminalWrapMode>
                <tooltip>
                    " Wrapping text lines on/off      \n"
                    " - applied to selection if it is "
                </tooltip>
                <label="Wrap"                     data="off"/>
                <label="\e[38:2:0:255:0mWrap\e[m" data="on"/>
            </item>
            <item type="Option" action=TerminalAlignMode>
                <tooltip>
                    " Align text lines left/right/center \n"
                    " - applied to selection if it is    "
                </tooltip>
                <label="\e[38:2:0:255:0mLeft\e[m"     data="left"/>
                <label="\e[38:2:0:255:255mRight\e[m"  data="right"/>
                <label="\e[38:2:255:255:0mCenter\e[m" data="center"/>
            </item>
            <item type="Option" action=TerminalClipboardFormat tooltip=" Text selection mode ">  <!-- type=Option means that the тext label will be selected when clicked.  -->
                <label="Selection"                       data="none"/>
                <label="\e[38:2:0:255:0mPlaintext\e[m"   data="text"/>
                <label="\e[38:2:255:255:0mANSI-text\e[m" data="ansi"/>
                <label data="rich">
                    "\e[38:2:109:231:237m""R"
                    "\e[38:2:109:237:186m""T"
                    "\e[38:2:60:255:60m"  "F"
                    "\e[38:2:189:255:53m" "-"
                    "\e[38:2:255:255:49m" "s"
                    "\e[38:2:255:189:79m" "t"
                    "\e[38:2:255:114:94m" "y"
                    "\e[38:2:255:60:157m" "l"
                    "\e[38:2:255:49:214m" "e" "\e[m"
                </label>
                <label="\e[38:2:0:255:255mHTML-code\e[m" data="html"/>
                <label="\e[38:2:0:255:255mProtected\e[m" data="protected"/>
            </item>
            <item type="Option" action=TerminalStdioLog tooltip=" Stdin/out logging is off ">
                <label="Log"                     data="off"/>
                <label="\e[38:2:0:255:0mLog\e[m" data="on" tooltip=" Stdin/out logging is on \n Run Logs to see output  "/>
            </item>
            <item label="  " tooltip=" just empty menu block/splitter "/>
            <item action=TerminalOutput tooltip=" Clear TTY viewport ">
                <label="Clear" data="\e[2J"/>
            </item>
            <item action=TerminalOutput tooltip=" Clear scrollback and SGR-attributes ">
                <label="Reset" data="\e[!p"/>
            </item>
            <item type="Command" action=TerminalRestart label="Restart"/>
            <item action=TerminalScrollViewportToTop    label="Top"/>
            <item action=TerminalScrollViewportToEnd    label="End"/>

            <item type="Repeat" action=TerminalScrollViewportByPage><label="PgLeft"    data=" 1, 0"/></item>
            <item type="Repeat" action=TerminalScrollViewportByPage><label="PgRight"   data="-1, 0"/></item>
            <item type="Repeat" action=TerminalScrollViewportByPage><label="PgUp"      data=" 0, 1"/></item>
            <item type="Repeat" action=TerminalScrollViewportByPage><label="PgDn"      data=" 0,-1"/></item>
            <item type="Repeat" action=TerminalScrollViewportByCell><label="CharLeft"  data=" 1, 0"/></item>
            <item type="Repeat" action=TerminalScrollViewportByCell><label="CharRight" data="-1, 0"/></item>
            <item type="Repeat" action=TerminalScrollViewportByCell><label="LineUp"    data=" 0, 1"/></item>
            <item type="Repeat" action=TerminalScrollViewportByCell><label="LineDn"    data=" 0,-1"/></item>

            <item action=TerminalViewportCopy    label="PrnScr"/>
            <item action=TerminalSelectionCancel label="Deselect"/>
            
            <item type="Option" action=TerminalSelectionRect>
                <label="Line" data="false"/>
                <label="Rect" data="true"/>
            </item>
            <item type="Repeat"  action=TerminalClipboardCopy  label="Copy"/>
            <item type="Repeat"  action=TerminalClipboardPaste label="Paste"/>
            <item type="Repeat"  action=TerminalClipboardWipe  label="Wipe"/>
            <item type="Command" action=TerminalUndo           label="Undo"/>
            <item type="Command" action=TerminalRedo           label="Redo"/>
            <item type="Command" action=TerminalQuit           label="Quit"/>
            <item type="Command" action=TerminalFullscreen     label="Fullscreen"/>
            <item type="Command" action=TerminalMaximize       label="Maximize"/>
            <item type="Command" action=TerminalMinimize       label="Minimize"/>
            <item type="Command" action=Noop                   label="Noop"/>

            <item type="Option" action=AlwaysOnTopApplet>
                <label="OnTop"                     data="off" tooltip=" AlwaysOnTop off "/>
                <label="\e[38:2:0:255:0mOnTop\e[m" data="on"  tooltip=" AlwaysOnTop on "/>
            </item>

            <item action=TerminalSendKey tooltip=" Simulate keypresses ">
                <label="Hello, World!" data="Hello World!"/>
            </item>
            <item type="Repeat" action=TerminalOutput tooltip=" test ">
                <label="Push Me" data="pressed"/>
                <label="\e[37mPush Me\e[m"/>
            </item>

            <item type="Option" action=TerminalSelectionOneShot>
                <tooltip>
                    " One-shot toggle to copy as HTML \n"
                    " while mouse tracking is active. "
                </tooltip>
                <label=" HTML "                                      data="none"/>
                <label="\e[48:2:0:128:128;38:2:0:255:255m HTML \e[m" data="html"/>
            </item>
            <item type="Option" action=TerminalSelectionOneShot>
                <tooltip>
                    " One-shot toggle to copy as Text \n"
                    " while mouse tracking is active. "
                </tooltip>
                <label=" Text "                                  data="none"/>
                <label="\e[48:2:0:128:0;38:2:0:255:0m Text \e[m" data="text"/>
            </item>
            <item type="Option" action=TerminalSelectionOneShot>
                <tooltip>
                    " One-shot toggle to copy as Text/HTML \n"
                    " while mouse tracking is active.      "
                </tooltip>
                <label="One-Shot"                                      data="none"/>
                <label="\e[48:2:0:128:0;38:2:0:255:0m  Text  \e[m"     data="text"/>
                <label="\e[48:2:0:128:128;38:2:0:255:255m  HTML  \e[m" data="html"/>
            </item>
        </menu>
    </terminal>
    <events>  <!-- The required key combination sequence can be generated on the Info page, accessible by clicking on the label in the lower right corner of the vtm desktop. The 'key*' statement here is to clear all previous bindings and start a new list. -->
        <terminal key*>  <!-- Terminal key bindings. -->
            <key="Esc"                   script="vtm.gear.SetHandled()"/> <!-- Do nothing. We use the Esc key as a modifier. Its press+release events will only be sent after the key is physically released, and only if no other keys were pressed along with Esc. -->
            <key="-Esc"                  script="vtm.terminal.ClearSelection(); vtm.terminal.KeyEvent({ virtcod=0x1b, scancod=1, keystat=1, cluster='\\u{1b}' }, { virtcod=0x1b, scancod=1, keystat=0 })"/> <!-- Clear selection if it is and send Esc press and release events. -->
            <key="Alt+Shift+B" preview   script=ExclusiveKeyboardMode/>
            <key="Alt+RightArrow"        script=TerminalFindNext/>
            <key="Alt+LeftArrow"         script=TerminalFindPrev/>
            <key="Shift+Ctrl+PageUp"     script=TerminalScrollViewportOnePageUp/>
            <key="Shift+Ctrl+PageDown"   script=TerminalScrollViewportOnePageDown/>
            <key="Shift+Alt+LeftArrow"   script=TerminalScrollViewportOnePageLeft/>
            <key="Shift+Alt+RightArrow"  script=TerminalScrollViewportOnePageRight/>
            <key="Shift+Ctrl+UpArrow"    script=TerminalScrollViewportOneLineUp/>
            <key="Shift+Ctrl+DownArrow"  script=TerminalScrollViewportOneLineDown/>
            <key="Shift+Ctrl+LeftArrow"  script=TerminalScrollViewportOneCellLeft/>
            <key="Shift+Ctrl+RightArrow" script=TerminalScrollViewportOneCellRight/>
            <key="Shift+Ctrl+Home"       script=TerminalScrollViewportToTop/>
            <key="Shift+Ctrl+End"        script=TerminalScrollViewportToEnd/>
            <key=""                      script=TerminalSendKey/>
            <key=""                      script=TerminalOutput/>
            <key=""                      script=TerminalCopyViewport/>
            <key="Ctrl+Insert"  preview  script=TerminalCopySelection/>
            <key="Shift+Insert" preview  script=TerminalClipboardPaste/>
            <key=""                      script=TerminalClipboardWipe/>
            <key=""                      script=TerminalClipboardFormat/>
            <key=""                      script=TerminalSelectionRect/>
            <key=""                      script=TerminalSelectionOneShot/>
            <key=""                      script=TerminalUndo/>
            <key=""                      script=TerminalRedo/>
            <key=""                      script=TerminalCwdSync/>
            <key=""                      script=TerminalWrapMode/>
            <key=""                      script=TerminalAlignMode/>
            <key=""                      script=TerminalStdioLog/>
            <key=""                      script=TerminalRestart/>
        </terminal>
    </events>
</config>
```

## DirectVT Gateway

DirectVT Gateway is used to attach DirectVT-aware sources. It is mainly used to receive DirectVT traffic from an external dtvt-endpoint.

## DirectVT Gateway with TTY

DirectVT Gateway with TTY is used when there is a need for interactive interaction with the user through the controlling terminal. For example, this is required when connecting via SSH with keyboard-interactive authentication or requesting a private key passphrase.

In case of running in standalone mode this window object type is used automatically if the first command line argument begins with `ssh` keyword.

The following commands are identical:
```
vtm -r dtty ssh user@host vtm
```
```
vtm ssh user@host vtm
```

## Desktop Region Marker

The Desktop Region Marker is used to quickly navigate the desktop by left-clicking on an instance in the taskbar. The region title can be set using the clipboard text data by right-clicking once on the region frame (swap clipboard text with title text).

## Tiling Window Manager

Tiling Window Manager is a window container that organizes the workspace into mutually non-overlapping panes for nested windows.

### Features

- Supports Drag and Drop for panes (like tabs in a browser).
- Use any modifier (`Ctrl` or `Alt`) while pane dragging to deactivate drag&drop mode.
- List of panes (outside the right side of the `Tile` window)
  - `LeftClick` -- Set exclusive focus
  - `Ctrl+LeftClick` -- Set/Unset group focus
  - `double LeftClick` -- Maxixmize/restore
- Configurable via settings (See configuration example in doc\settings.md`).

### Configuration example

```xml
<config>
    <tile>
        <menu item*>
            <autohide=menu/autohide/>
            <slim=menu/slim/>
            <item action=TileRunApplication label=" + ">
                <tooltip>
                    " Launch application instances in active empty slots.     \n"
                    " The app to run can be set by RightClick on the taskbar. "
                </tooltip>
            </item>
            <item action=TileSelectAllPanes     label=":::" tooltip=" Select all panes "/>
            <item action=TileSplitHorizontally  label=" │ " tooltip=" Split active panes horizontally "/>
            <item action=TileSplitVertically    label="──"  tooltip=" Split active panes vertically "/>
            <item action=TileSplitOrientation   label="┌┘"  tooltip=" Change split orientation "/>
            <item action=TileSwapPanes          label="<->" tooltip=" Swap two or more panes "/>
            <item action=TileEqualizeSplitRatio label=">|<" tooltip=" Equalize split ratio "/>
            <item action=TileSetManagerTitle    label='"…"' tooltip=" Set tiling window manager title using clipboard data "/>
            <item action=TileClosePane          label="×"   tooltip=" Close active application "/>
            <!-- <item action=TileFocusPrev      label="<"   tooltip=" Focus the previous pane or the split grip "/> -->
            <!-- <item action=TileFocusNext      label=">"   tooltip=" Focus the next pane or the split grip "/> -->
            <!-- <item action=TileFocusPrevPane  label="<-"  tooltip=" Focus the previous pane "/> -->
            <!-- <item action=TileFocusNextPane  label="->"  tooltip=" Focus the next pane "/> -->
        </menu>
    </tile>
    <events>
        <tile key*>
            <key="Ctrl+PageUp"     script=TileFocusPrev/>
            <key="Ctrl+PageDown"   script=TileFocusNext/>
            <key=""                script=TileFocusPrevPane/>
            <key=""                script=TileFocusNextPane/>
            <key="Alt+Shift+N"     script=TileRunApplication/>
            <key="Alt+Shift+A"     script=TileSelectAllPanes/>
            <key="Alt+Shift+'|'"   script=TileSplitHorizontally/>
            <key="Alt+Shift+Minus" script=TileSplitVertically/>
            <key="Alt+Shift+R"     script=TileSplitOrientation/>
            <key="Alt+Shift+S"     script=TileSwapPanes/>
            <key="Alt+Shift+E"     script=TileEqualizeSplitRatio/>
            <key="Alt+Shift+F2"    script=TileSetManagerTitle/>
            <key="Alt+Shift+W"     script=TileClosePane/>
            <grip key*>
                <key="LeftArrow"                          script=TileMoveGripLeft/>
                <key="RightArrow"                         script=TileMoveGripRight/>
                <key="UpArrow"                            script=TileMoveGripUp/>
                <key="DownArrow"                          script=TileMoveGripDown/>
                <key="'-'"                                script=TileDecreaseGripWidth/>
                <key="Shift+'+' | '+' | '=' | NumpadPlus" script=TileIncreaseGripWidth/>
                <key="Shift+Tab"                          script=TileFocusPrevGrip/>
                <key="Tab"                                script=TileFocusNextGrip/>
            </grip>
        </tile>
    </events>
</config>
```