// Copyright (c) NetXS Group.
// Licensed under the MIT license.

#ifndef NETXS_TREE_HPP
#define NETXS_TREE_HPP

#include <vector>

#ifndef faux
    #define faux (false)
#endif

namespace netxs::generics
{
    template<class IN, class OUT, class FUNC = void (*)(IN&, OUT&)>
    struct tree
        : public std::vector<tree<IN, OUT, FUNC>>
    {
        using bulk = std::vector<tree>;
        using hndl = FUNC;

        hndl proc = nullptr;
        bool sure = faux;
        bool stop = true;

        template<class F>
        void operator = (F func)
        {
            if constexpr (std::is_same_v<F, std::nullptr_t>) sure = faux;
            else                                             sure = true;
            proc = func;
        }
        auto& resize(size_t newsize)
        {
            proc = nullptr;
            sure = true;
            bulk::resize(newsize);
            return *this;
        }
        template<bool NOMULTIARG = faux>
        void enable_multi_arg()
        {
            for (auto& rec : *this) rec.stop = NOMULTIARG;
        }
        operator bool () const
        {
            return sure;
        }

        void execute(IN& queue, OUT& story) const
        {
            auto last = this;
            while (queue)
            {
                auto task = queue.front();
                if (task >= 0 && task < last->size())
                {
                    if (auto const& next = last->at(task))
                    {
                        queue.pop_front();
                        if (next.proc)
                        {
                            next.proc(queue, story);
                            if (next.stop) break;
                        }
                        else last = &next;
                    }
                    else
                    {
                        if (last->stop) break;
                        else queue.pop_front();
                    }
                }
                else
                {
                    if (last->stop) break;
                    else queue.pop_front();
                }
            }
        }

        void execute(size_t firstcmd, IN& queue, OUT& story) const
        {
            auto last = this;
            if (auto const& next = last->at(firstcmd))
            {
                if (next.proc)
                {
                    next.proc(queue, story);
                }
                else
                {
                    last = &next;
                    while (queue)
                    {
                        auto task = queue.front();
                        if (task >= 0 && task < last->size())
                        {
                            if (auto const& next = last->at(task))
                            {
                                queue.pop_front();
                                if (next.proc)
                                {
                                    next.proc(queue, story);
                                    break;
                                }
                                else last = &next;
                            }
                            else
                            {
                                if (last->stop) break;
                                else queue.pop_front();
                            }
                        }
                        else
                        {
                            if (last->stop) break;
                            else queue.pop_front();
                        }
                    }
                }
            }
        }
        // Exec without parameters.
        void execute(size_t alonecmd, OUT& story) const
        {
            auto& queue = IN::fake();
            if (alonecmd >= 0 && alonecmd < this->size())
            {
                if (auto const& next = this->at(alonecmd))
                {
                    if (next.proc)
                    {
                        next.proc(queue, story);
                    }
                    else
                    {
                        if (auto const& last = next[0])
                        {
                            if (last.proc)
                            {
                                last.proc(queue, story);
                            }
                        }
                    }
                }
            }
        }
    };
}

#endif // NETXS_TREE_HPP