
/* #line 1 "parser.rl" */
/* vim: set noet nosta sw=4 ts=4 ft=ragel : */
/*
Copyright (c) 2011, Mahlon E. Smith <mahlon@martini.nu>
All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

    * Neither the name of Mahlon E. Smith nor the names of his
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "volta.h"

#define MARK_S( LBL ) p_parsed->tokens.LBL ## _start = p;
#define MARK_E( LBL ) p_parsed->tokens.LBL ## _length = p - ( *pe + p_parsed->tokens.LBL ## _start );

#define COPY_STR( LBL ) copy_string_token( p_parsed->tokens.LBL ## _start, p_parsed->tokens.LBL ## _length )
/* #define COPY_IP4( LBL ) copy_ipv4_token(   p_request->tokens.LBL ## _start, p_request->tokens.LBL ## _length ) */

/* 
 * Tokenize an incoming line from squid, returning a parsed and populated
 * structure to make redirection decisions against.  This pointer should
 * be freed using finish_parsed() after use.
 * 
 * Squid documentation about redirectors:
 * ---------------------------------------------------------------------------
 * TAG: url_rewrite_program
 * Specify the location of the executable for the URL rewriter.
 * Since they can perform almost any function there isn't one included.
 * 
 * For each requested URL rewriter will receive on line with the format
 * 
 * URL <SP> client_ip "/" fqdn <SP> user <SP> method [<SP> kvpairs]<NL>
 * 
 * In the future, the rewriter interface will be extended with
 * key=value pairs ("kvpairs" shown above).  Rewriter programs
 * should be prepared to receive and possibly ignore additional
 * whitespace-separated tokens on each input line.
 * 
 * And the rewriter may return a rewritten URL. The other components of
 * the request line does not need to be returned (ignored if they are).
 * 
 * The rewriter can also indicate that a client-side redirect should
 * be performed to the new URL. This is done by prefixing the returned
 * URL with "301:" (moved permanently) or 302: (moved temporarily).
 * 
 * By default, a URL rewriter is not used.
 * ---------------------------------------------------------------------------
*/
parsed *
parse_request( char *line )
{
	/* machine required vars */
	unsigned short int cs = 1;
	char *p   = line;
	char *pe  = p + strlen(p);
	char *eof = pe;

	/* the client request pointer */
	parsed *p_parsed = init_parsed();
	p_parsed->type   = REQUEST;


/* #line 166 "parser.rl" */


	/* state machine */
	
/* #line 91 "parser.c" */
	{
	if ( p == pe )
		goto _test_eof;
	switch ( cs )
	{
case 1:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr1;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr2;
	} else
		goto tr2;
	goto tr0;
tr0:
/* #line 101 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request scheme.\n" ); }
/* #line 100 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request hostname.\n" ); }
	goto st0;
tr12:
/* #line 101 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request scheme.\n" ); }
/* #line 100 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request hostname.\n" ); }
/* #line 103 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the client IP address.\n" ); }
	goto st0;
tr15:
/* #line 103 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the client IP address.\n" ); }
	goto st0;
tr37:
/* #line 102 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request method.\n" ); }
	goto st0;
tr50:
/* #line 100 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request hostname.\n" ); }
	goto st0;
tr96:
/* #line 101 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request scheme.\n" ); }
	goto st0;
/* #line 137 "parser.c" */
st0:
cs = 0;
	goto _out;
tr1:
/* #line 85 "parser.rl" */
	{ MARK_S(chid) }
/* #line 89 "parser.rl" */
	{ MARK_S(host) }
	goto st2;
st2:
	if ( ++p == pe )
		goto _test_eof2;
case 2:
/* #line 151 "parser.c" */
	switch( (*p) ) {
		case 10: goto tr5;
		case 32: goto tr3;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr3;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st2;
	goto st0;
tr3:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st3;
st3:
	if ( ++p == pe )
		goto _test_eof3;
case 3:
/* #line 185 "parser.c" */
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr13;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr14;
	} else
		goto tr14;
	goto tr12;
tr13:
/* #line 86 "parser.rl" */
	{ MARK_E(chid) }
/* #line 89 "parser.rl" */
	{ MARK_S(host) }
/* #line 97 "parser.rl" */
	{ MARK_S(c_ip) }
	goto st4;
st4:
	if ( ++p == pe )
		goto _test_eof4;
case 4:
/* #line 207 "parser.c" */
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st42;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st75;
	goto tr15;
tr16:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st5;
tr52:
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st5;
tr55:
/* #line 92 "parser.rl" */
	{ MARK_E(port) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st5;
st5:
	if ( ++p == pe )
		goto _test_eof5;
case 5:
/* #line 253 "parser.c" */
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr20;
	goto tr15;
tr20:
/* #line 97 "parser.rl" */
	{ MARK_S(c_ip) }
	goto st6;
st6:
	if ( ++p == pe )
		goto _test_eof6;
case 6:
/* #line 265 "parser.c" */
	if ( (*p) == 46 )
		goto st7;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st30;
	goto tr15;
st7:
	if ( ++p == pe )
		goto _test_eof7;
case 7:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st8;
	goto tr15;
st8:
	if ( ++p == pe )
		goto _test_eof8;
case 8:
	if ( (*p) == 46 )
		goto st9;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st28;
	goto tr15;
st9:
	if ( ++p == pe )
		goto _test_eof9;
case 9:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st10;
	goto tr15;
st10:
	if ( ++p == pe )
		goto _test_eof10;
case 10:
	if ( (*p) == 46 )
		goto st11;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st26;
	goto tr15;
st11:
	if ( ++p == pe )
		goto _test_eof11;
case 11:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st12;
	goto tr15;
st12:
	if ( ++p == pe )
		goto _test_eof12;
case 12:
	if ( (*p) == 47 )
		goto tr30;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st24;
	goto st0;
tr30:
/* #line 98 "parser.rl" */
	{ MARK_E(c_ip) }
	goto st13;
st13:
	if ( ++p == pe )
		goto _test_eof13;
case 13:
/* #line 327 "parser.c" */
	if ( (*p) == 45 )
		goto st14;
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st21;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st21;
	} else
		goto st21;
	goto st0;
st14:
	if ( ++p == pe )
		goto _test_eof14;
case 14:
	if ( (*p) == 32 )
		goto st15;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st15;
	goto st0;
st15:
	if ( ++p == pe )
		goto _test_eof15;
case 15:
	switch( (*p) ) {
		case 33: goto st16;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( 36 <= (*p) && (*p) <= 46 )
			goto st16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st16;
	goto st0;
st16:
	if ( ++p == pe )
		goto _test_eof16;
case 16:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 46 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st16;
	goto st0;
st17:
	if ( ++p == pe )
		goto _test_eof17;
case 17:
	if ( 65 <= (*p) && (*p) <= 90 )
		goto tr38;
	goto tr37;
tr38:
/* #line 95 "parser.rl" */
	{ MARK_S(meth) }
	goto st18;
st18:
	if ( ++p == pe )
		goto _test_eof18;
case 18:
/* #line 413 "parser.c" */
	switch( (*p) ) {
		case 10: goto tr40;
		case 32: goto tr39;
	}
	if ( (*p) > 13 ) {
		if ( 65 <= (*p) && (*p) <= 90 )
			goto st18;
	} else if ( (*p) >= 9 )
		goto tr39;
	goto st0;
tr39:
/* #line 96 "parser.rl" */
	{ MARK_E(meth) }
	goto st19;
st19:
	if ( ++p == pe )
		goto _test_eof19;
case 19:
/* #line 432 "parser.c" */
	goto st20;
st20:
	if ( ++p == pe )
		goto _test_eof20;
case 20:
	if ( (*p) == 10 )
		goto st85;
	goto st20;
st85:
	if ( ++p == pe )
		goto _test_eof85;
case 85:
	if ( (*p) == 10 )
		goto st85;
	goto st20;
tr40:
/* #line 96 "parser.rl" */
	{ MARK_E(meth) }
	goto st86;
st86:
	if ( ++p == pe )
		goto _test_eof86;
case 86:
/* #line 456 "parser.c" */
	goto st20;
st21:
	if ( ++p == pe )
		goto _test_eof21;
case 21:
	switch( (*p) ) {
		case 32: goto st15;
		case 45: goto st22;
		case 46: goto st23;
		case 95: goto st22;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto st15;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st21;
		} else if ( (*p) >= 65 )
			goto st21;
	} else
		goto st21;
	goto st0;
st22:
	if ( ++p == pe )
		goto _test_eof22;
case 22:
	switch( (*p) ) {
		case 45: goto st22;
		case 95: goto st22;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st21;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st21;
	} else
		goto st21;
	goto st0;
st23:
	if ( ++p == pe )
		goto _test_eof23;
case 23:
	if ( (*p) == 32 )
		goto st15;
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto st15;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st21;
		} else if ( (*p) >= 65 )
			goto st21;
	} else
		goto st21;
	goto st0;
st24:
	if ( ++p == pe )
		goto _test_eof24;
case 24:
	if ( (*p) == 47 )
		goto tr30;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st25;
	goto st0;
st25:
	if ( ++p == pe )
		goto _test_eof25;
case 25:
	if ( (*p) == 47 )
		goto tr30;
	goto st0;
st26:
	if ( ++p == pe )
		goto _test_eof26;
case 26:
	if ( (*p) == 46 )
		goto st11;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st27;
	goto tr15;
st27:
	if ( ++p == pe )
		goto _test_eof27;
case 27:
	if ( (*p) == 46 )
		goto st11;
	goto tr15;
st28:
	if ( ++p == pe )
		goto _test_eof28;
case 28:
	if ( (*p) == 46 )
		goto st9;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st29;
	goto tr15;
st29:
	if ( ++p == pe )
		goto _test_eof29;
case 29:
	if ( (*p) == 46 )
		goto st9;
	goto tr15;
st30:
	if ( ++p == pe )
		goto _test_eof30;
case 30:
	if ( (*p) == 46 )
		goto st7;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st31;
	goto tr15;
st31:
	if ( ++p == pe )
		goto _test_eof31;
case 31:
	if ( (*p) == 46 )
		goto st7;
	goto tr15;
tr17:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st87;
tr53:
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st87;
tr56:
/* #line 92 "parser.rl" */
	{ MARK_E(port) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st87;
st87:
	if ( ++p == pe )
		goto _test_eof87;
case 87:
/* #line 603 "parser.c" */
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr20;
	goto tr15;
st32:
	if ( ++p == pe )
		goto _test_eof32;
case 32:
	switch( (*p) ) {
		case 45: goto st32;
		case 95: goto st32;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st33;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st33;
	} else
		goto st33;
	goto tr50;
tr103:
/* #line 88 "parser.rl" */
	{ MARK_E(scheme) }
/* #line 89 "parser.rl" */
	{ MARK_S(host) }
	goto st33;
st33:
	if ( ++p == pe )
		goto _test_eof33;
case 33:
/* #line 634 "parser.c" */
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st33;
	goto st0;
st34:
	if ( ++p == pe )
		goto _test_eof34;
case 34:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 47: goto tr8;
		case 58: goto tr10;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st33;
	goto st0;
tr8:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
	goto st35;
tr57:
/* #line 92 "parser.rl" */
	{ MARK_E(port) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
	goto st35;
st35:
	if ( ++p == pe )
		goto _test_eof35;
case 35:
/* #line 694 "parser.c" */
	switch( (*p) ) {
		case 10: goto tr53;
		case 32: goto tr52;
	}
	if ( 9 <= (*p) && (*p) <= 13 )
		goto tr52;
	goto st35;
tr10:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 91 "parser.rl" */
	{ p_parsed->tokens.port_start = p+1; }
	goto st36;
st36:
	if ( ++p == pe )
		goto _test_eof36;
case 36:
/* #line 712 "parser.c" */
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st37;
	goto st0;
st37:
	if ( ++p == pe )
		goto _test_eof37;
case 37:
	switch( (*p) ) {
		case 10: goto tr56;
		case 32: goto tr55;
		case 47: goto tr57;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st38;
	} else if ( (*p) >= 9 )
		goto tr55;
	goto st0;
st38:
	if ( ++p == pe )
		goto _test_eof38;
case 38:
	switch( (*p) ) {
		case 10: goto tr56;
		case 32: goto tr55;
		case 47: goto tr57;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st39;
	} else if ( (*p) >= 9 )
		goto tr55;
	goto st0;
st39:
	if ( ++p == pe )
		goto _test_eof39;
case 39:
	switch( (*p) ) {
		case 10: goto tr56;
		case 32: goto tr55;
		case 47: goto tr57;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st40;
	} else if ( (*p) >= 9 )
		goto tr55;
	goto st0;
st40:
	if ( ++p == pe )
		goto _test_eof40;
case 40:
	switch( (*p) ) {
		case 10: goto tr56;
		case 32: goto tr55;
		case 47: goto tr57;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st41;
	} else if ( (*p) >= 9 )
		goto tr55;
	goto st0;
st41:
	if ( ++p == pe )
		goto _test_eof41;
case 41:
	switch( (*p) ) {
		case 10: goto tr56;
		case 32: goto tr55;
		case 47: goto tr57;
	}
	if ( 9 <= (*p) && (*p) <= 13 )
		goto tr55;
	goto st0;
st42:
	if ( ++p == pe )
		goto _test_eof42;
case 42:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 47: goto tr8;
		case 58: goto tr10;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st43;
	goto tr15;
st43:
	if ( ++p == pe )
		goto _test_eof43;
case 43:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st44;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st73;
	goto tr15;
st44:
	if ( ++p == pe )
		goto _test_eof44;
case 44:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 47: goto tr8;
		case 58: goto tr10;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st45;
	goto tr15;
st45:
	if ( ++p == pe )
		goto _test_eof45;
case 45:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st46;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st71;
	goto tr15;
st46:
	if ( ++p == pe )
		goto _test_eof46;
case 46:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 47: goto tr8;
		case 58: goto tr10;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st47;
	goto tr15;
st47:
	if ( ++p == pe )
		goto _test_eof47;
case 47:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr69;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st69;
	goto st0;
tr69:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
/* #line 98 "parser.rl" */
	{ MARK_E(c_ip) }
	goto st48;
st48:
	if ( ++p == pe )
		goto _test_eof48;
case 48:
/* #line 941 "parser.c" */
	switch( (*p) ) {
		case 10: goto tr53;
		case 32: goto tr52;
		case 45: goto st49;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr52;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st66;
		} else if ( (*p) >= 65 )
			goto st66;
	} else
		goto st66;
	goto st35;
st49:
	if ( ++p == pe )
		goto _test_eof49;
case 49:
	switch( (*p) ) {
		case 10: goto tr74;
		case 32: goto tr73;
	}
	if ( 9 <= (*p) && (*p) <= 13 )
		goto tr73;
	goto st35;
tr73:
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st50;
st50:
	if ( ++p == pe )
		goto _test_eof50;
case 50:
/* #line 978 "parser.c" */
	switch( (*p) ) {
		case 33: goto st16;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( 36 <= (*p) && (*p) <= 46 )
			goto st16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto tr75;
	goto tr15;
tr75:
/* #line 97 "parser.rl" */
	{ MARK_S(c_ip) }
	goto st51;
st51:
	if ( ++p == pe )
		goto _test_eof51;
case 51:
/* #line 1006 "parser.c" */
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st52;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st64;
	goto tr15;
st52:
	if ( ++p == pe )
		goto _test_eof52;
case 52:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 46 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st53;
	goto tr15;
st53:
	if ( ++p == pe )
		goto _test_eof53;
case 53:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st54;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st62;
	goto tr15;
st54:
	if ( ++p == pe )
		goto _test_eof54;
case 54:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 46 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st55;
	goto tr15;
st55:
	if ( ++p == pe )
		goto _test_eof55;
case 55:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st56;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st60;
	goto tr15;
st56:
	if ( ++p == pe )
		goto _test_eof56;
case 56:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 46 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st57;
	goto tr15;
st57:
	if ( ++p == pe )
		goto _test_eof57;
case 57:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 47: goto tr30;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 46 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st58;
	goto st0;
st58:
	if ( ++p == pe )
		goto _test_eof58;
case 58:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 47: goto tr30;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 46 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st59;
	goto st0;
st59:
	if ( ++p == pe )
		goto _test_eof59;
case 59:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 47: goto tr30;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 36 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st16;
	goto st0;
st60:
	if ( ++p == pe )
		goto _test_eof60;
case 60:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st56;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st61;
	goto tr15;
st61:
	if ( ++p == pe )
		goto _test_eof61;
case 61:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st56;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st16;
	goto tr15;
st62:
	if ( ++p == pe )
		goto _test_eof62;
case 62:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st54;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st63;
	goto tr15;
st63:
	if ( ++p == pe )
		goto _test_eof63;
case 63:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st54;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st16;
	goto tr15;
st64:
	if ( ++p == pe )
		goto _test_eof64;
case 64:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st52;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st65;
	goto tr15;
st65:
	if ( ++p == pe )
		goto _test_eof65;
case 65:
	switch( (*p) ) {
		case 32: goto st17;
		case 33: goto st16;
		case 46: goto st52;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( (*p) > 13 ) {
			if ( 36 <= (*p) && (*p) <= 45 )
				goto st16;
		} else if ( (*p) >= 9 )
			goto st17;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto st16;
	goto tr15;
tr74:
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st88;
st88:
	if ( ++p == pe )
		goto _test_eof88;
case 88:
/* #line 1425 "parser.c" */
	switch( (*p) ) {
		case 33: goto st16;
		case 59: goto st16;
		case 61: goto st16;
		case 95: goto st16;
		case 126: goto st16;
	}
	if ( (*p) < 48 ) {
		if ( 36 <= (*p) && (*p) <= 46 )
			goto st16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st16;
		} else if ( (*p) >= 65 )
			goto st16;
	} else
		goto tr75;
	goto tr15;
st66:
	if ( ++p == pe )
		goto _test_eof66;
case 66:
	switch( (*p) ) {
		case 10: goto tr74;
		case 32: goto tr73;
		case 45: goto st67;
		case 46: goto st68;
		case 95: goto st67;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr73;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st66;
		} else if ( (*p) >= 65 )
			goto st66;
	} else
		goto st66;
	goto st35;
st67:
	if ( ++p == pe )
		goto _test_eof67;
case 67:
	switch( (*p) ) {
		case 10: goto tr53;
		case 32: goto tr52;
		case 45: goto st67;
		case 95: goto st67;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr52;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st66;
		} else if ( (*p) >= 65 )
			goto st66;
	} else
		goto st66;
	goto st35;
st68:
	if ( ++p == pe )
		goto _test_eof68;
case 68:
	switch( (*p) ) {
		case 10: goto tr74;
		case 32: goto tr73;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr73;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st66;
		} else if ( (*p) >= 65 )
			goto st66;
	} else
		goto st66;
	goto st35;
st69:
	if ( ++p == pe )
		goto _test_eof69;
case 69:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr69;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st70;
	goto st0;
st70:
	if ( ++p == pe )
		goto _test_eof70;
case 70:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr69;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st33;
	goto st0;
st71:
	if ( ++p == pe )
		goto _test_eof71;
case 71:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st46;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st72;
	goto tr15;
st72:
	if ( ++p == pe )
		goto _test_eof72;
case 72:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st46;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st33;
	goto tr15;
st73:
	if ( ++p == pe )
		goto _test_eof73;
case 73:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st44;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st74;
	goto tr15;
st74:
	if ( ++p == pe )
		goto _test_eof74;
case 74:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st44;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st33;
	goto tr15;
st75:
	if ( ++p == pe )
		goto _test_eof75;
case 75:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st42;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st76;
	goto tr15;
st76:
	if ( ++p == pe )
		goto _test_eof76;
case 76:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st42;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st33;
	goto tr15;
tr2:
/* #line 87 "parser.rl" */
	{ MARK_S(scheme) }
/* #line 89 "parser.rl" */
	{ MARK_S(host) }
	goto st77;
tr14:
/* #line 86 "parser.rl" */
	{ MARK_E(chid) }
/* #line 87 "parser.rl" */
	{ MARK_S(scheme) }
/* #line 89 "parser.rl" */
	{ MARK_S(host) }
	goto st77;
st77:
	if ( ++p == pe )
		goto _test_eof77;
case 77:
/* #line 1728 "parser.c" */
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st78;
		} else if ( (*p) >= 65 )
			goto st78;
	} else
		goto st33;
	goto tr96;
st78:
	if ( ++p == pe )
		goto _test_eof78;
case 78:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr8;
		case 58: goto tr10;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st79;
		} else if ( (*p) >= 65 )
			goto st79;
	} else
		goto st33;
	goto tr96;
st79:
	if ( ++p == pe )
		goto _test_eof79;
case 79:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr8;
		case 58: goto tr99;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st83;
		} else if ( (*p) >= 65 )
			goto st83;
	} else
		goto st33;
	goto tr96;
tr99:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 91 "parser.rl" */
	{ p_parsed->tokens.port_start = p+1; }
	goto st80;
st80:
	if ( ++p == pe )
		goto _test_eof80;
case 80:
/* #line 1810 "parser.c" */
	if ( (*p) == 47 )
		goto st81;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st37;
	goto tr96;
st81:
	if ( ++p == pe )
		goto _test_eof81;
case 81:
	if ( (*p) == 47 )
		goto st82;
	goto tr96;
st82:
	if ( ++p == pe )
		goto _test_eof82;
case 82:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr103;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr103;
	} else
		goto tr103;
	goto tr50;
st83:
	if ( ++p == pe )
		goto _test_eof83;
case 83:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr8;
		case 58: goto tr99;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st84;
		} else if ( (*p) >= 65 )
			goto st84;
	} else
		goto st33;
	goto tr96;
st84:
	if ( ++p == pe )
		goto _test_eof84;
case 84:
	switch( (*p) ) {
		case 10: goto tr17;
		case 32: goto tr16;
		case 45: goto st32;
		case 46: goto st34;
		case 47: goto tr8;
		case 58: goto tr99;
		case 95: goto st32;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr16;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st33;
		} else if ( (*p) >= 65 )
			goto st33;
	} else
		goto st33;
	goto tr96;
tr5:
/* #line 90 "parser.rl" */
	{ MARK_E(host) }
/* #line 93 "parser.rl" */
	{ MARK_S(path) }
/* #line 94 "parser.rl" */
	{ MARK_E(path) }
	goto st89;
st89:
	if ( ++p == pe )
		goto _test_eof89;
case 89:
/* #line 1898 "parser.c" */
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr13;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr14;
	} else
		goto tr14;
	goto tr12;
	}
	_test_eof2: cs = 2; goto _test_eof; 
	_test_eof3: cs = 3; goto _test_eof; 
	_test_eof4: cs = 4; goto _test_eof; 
	_test_eof5: cs = 5; goto _test_eof; 
	_test_eof6: cs = 6; goto _test_eof; 
	_test_eof7: cs = 7; goto _test_eof; 
	_test_eof8: cs = 8; goto _test_eof; 
	_test_eof9: cs = 9; goto _test_eof; 
	_test_eof10: cs = 10; goto _test_eof; 
	_test_eof11: cs = 11; goto _test_eof; 
	_test_eof12: cs = 12; goto _test_eof; 
	_test_eof13: cs = 13; goto _test_eof; 
	_test_eof14: cs = 14; goto _test_eof; 
	_test_eof15: cs = 15; goto _test_eof; 
	_test_eof16: cs = 16; goto _test_eof; 
	_test_eof17: cs = 17; goto _test_eof; 
	_test_eof18: cs = 18; goto _test_eof; 
	_test_eof19: cs = 19; goto _test_eof; 
	_test_eof20: cs = 20; goto _test_eof; 
	_test_eof85: cs = 85; goto _test_eof; 
	_test_eof86: cs = 86; goto _test_eof; 
	_test_eof21: cs = 21; goto _test_eof; 
	_test_eof22: cs = 22; goto _test_eof; 
	_test_eof23: cs = 23; goto _test_eof; 
	_test_eof24: cs = 24; goto _test_eof; 
	_test_eof25: cs = 25; goto _test_eof; 
	_test_eof26: cs = 26; goto _test_eof; 
	_test_eof27: cs = 27; goto _test_eof; 
	_test_eof28: cs = 28; goto _test_eof; 
	_test_eof29: cs = 29; goto _test_eof; 
	_test_eof30: cs = 30; goto _test_eof; 
	_test_eof31: cs = 31; goto _test_eof; 
	_test_eof87: cs = 87; goto _test_eof; 
	_test_eof32: cs = 32; goto _test_eof; 
	_test_eof33: cs = 33; goto _test_eof; 
	_test_eof34: cs = 34; goto _test_eof; 
	_test_eof35: cs = 35; goto _test_eof; 
	_test_eof36: cs = 36; goto _test_eof; 
	_test_eof37: cs = 37; goto _test_eof; 
	_test_eof38: cs = 38; goto _test_eof; 
	_test_eof39: cs = 39; goto _test_eof; 
	_test_eof40: cs = 40; goto _test_eof; 
	_test_eof41: cs = 41; goto _test_eof; 
	_test_eof42: cs = 42; goto _test_eof; 
	_test_eof43: cs = 43; goto _test_eof; 
	_test_eof44: cs = 44; goto _test_eof; 
	_test_eof45: cs = 45; goto _test_eof; 
	_test_eof46: cs = 46; goto _test_eof; 
	_test_eof47: cs = 47; goto _test_eof; 
	_test_eof48: cs = 48; goto _test_eof; 
	_test_eof49: cs = 49; goto _test_eof; 
	_test_eof50: cs = 50; goto _test_eof; 
	_test_eof51: cs = 51; goto _test_eof; 
	_test_eof52: cs = 52; goto _test_eof; 
	_test_eof53: cs = 53; goto _test_eof; 
	_test_eof54: cs = 54; goto _test_eof; 
	_test_eof55: cs = 55; goto _test_eof; 
	_test_eof56: cs = 56; goto _test_eof; 
	_test_eof57: cs = 57; goto _test_eof; 
	_test_eof58: cs = 58; goto _test_eof; 
	_test_eof59: cs = 59; goto _test_eof; 
	_test_eof60: cs = 60; goto _test_eof; 
	_test_eof61: cs = 61; goto _test_eof; 
	_test_eof62: cs = 62; goto _test_eof; 
	_test_eof63: cs = 63; goto _test_eof; 
	_test_eof64: cs = 64; goto _test_eof; 
	_test_eof65: cs = 65; goto _test_eof; 
	_test_eof88: cs = 88; goto _test_eof; 
	_test_eof66: cs = 66; goto _test_eof; 
	_test_eof67: cs = 67; goto _test_eof; 
	_test_eof68: cs = 68; goto _test_eof; 
	_test_eof69: cs = 69; goto _test_eof; 
	_test_eof70: cs = 70; goto _test_eof; 
	_test_eof71: cs = 71; goto _test_eof; 
	_test_eof72: cs = 72; goto _test_eof; 
	_test_eof73: cs = 73; goto _test_eof; 
	_test_eof74: cs = 74; goto _test_eof; 
	_test_eof75: cs = 75; goto _test_eof; 
	_test_eof76: cs = 76; goto _test_eof; 
	_test_eof77: cs = 77; goto _test_eof; 
	_test_eof78: cs = 78; goto _test_eof; 
	_test_eof79: cs = 79; goto _test_eof; 
	_test_eof80: cs = 80; goto _test_eof; 
	_test_eof81: cs = 81; goto _test_eof; 
	_test_eof82: cs = 82; goto _test_eof; 
	_test_eof83: cs = 83; goto _test_eof; 
	_test_eof84: cs = 84; goto _test_eof; 
	_test_eof89: cs = 89; goto _test_eof; 

	_test_eof: {}
	if ( p == eof )
	{
	switch ( cs ) {
	case 32: 
	case 82: 
/* #line 100 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request hostname.\n" ); }
	break;
	case 77: 
	case 78: 
	case 79: 
	case 80: 
	case 81: 
	case 83: 
	case 84: 
/* #line 101 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request scheme.\n" ); }
	break;
	case 17: 
/* #line 102 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request method.\n" ); }
	break;
	case 4: 
	case 5: 
	case 6: 
	case 7: 
	case 8: 
	case 9: 
	case 10: 
	case 11: 
	case 26: 
	case 27: 
	case 28: 
	case 29: 
	case 30: 
	case 31: 
	case 42: 
	case 43: 
	case 44: 
	case 45: 
	case 46: 
	case 50: 
	case 51: 
	case 52: 
	case 53: 
	case 54: 
	case 55: 
	case 56: 
	case 60: 
	case 61: 
	case 62: 
	case 63: 
	case 64: 
	case 65: 
	case 71: 
	case 72: 
	case 73: 
	case 74: 
	case 75: 
	case 76: 
/* #line 103 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the client IP address.\n" ); }
	break;
	case 1: 
/* #line 101 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request scheme.\n" ); }
/* #line 100 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request hostname.\n" ); }
	break;
	case 3: 
/* #line 101 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request scheme.\n" ); }
/* #line 100 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the request hostname.\n" ); }
/* #line 103 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the client IP address.\n" ); }
	break;
/* #line 2076 "parser.c" */
	}
	}

	_out: {}
	}

/* #line 170 "parser.rl" */

	/*
	 * If we were given an invalid line, bail early after remembering
	 * the channel ID.
	 *
	 */
	if ( cs < 
/* #line 2091 "parser.c" */
85
/* #line 176 "parser.rl" */
 ) {
		debug( 3, LOC, "Invalid request line (%d), skipped\n", v.timer.lines + 1 );
		debug( 4, LOC, "%s", line );
		p_parsed->chid = COPY_STR( chid );
		return( p_parsed );
	}

	debug( 6, LOC, "%s", line );
	(void)populate_parsed( p_parsed );
	return( p_parsed );
}


/*
 * Tokenize a value string from a successful database lookup, returning a parsed
 * and populated structure. This pointer should be freed using finish_parsed() after use.
 *
 */
parsed *
parse_rule( char *rewrite )
{
	/* machine required vars */
	unsigned short int cs = 1;
	char *p   = rewrite;
	char *pe  = p + strlen(p);
	char *eof = pe;

	/* the client rule pointer */
	parsed *p_parsed = init_parsed();
	p_parsed->type   = RULE;


/* #line 253 "parser.rl" */


	/* state machine */
	
/* #line 2131 "parser.c" */
	{
	if ( p == pe )
		goto _test_eof;
	switch ( cs )
	{
case 1:
	if ( (*p) == 32 )
		goto tr1;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto tr1;
	goto tr0;
tr0:
/* #line 210 "parser.rl" */
	{ MARK_S(path_re) }
	goto st2;
st2:
	if ( ++p == pe )
		goto _test_eof2;
case 2:
/* #line 2151 "parser.c" */
	if ( (*p) == 32 )
		goto tr3;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto tr3;
	goto st2;
tr3:
/* #line 211 "parser.rl" */
	{ MARK_E(path_re) }
	goto st3;
st3:
	if ( ++p == pe )
		goto _test_eof3;
case 3:
/* #line 2165 "parser.c" */
	switch( (*p) ) {
		case 32: goto st3;
		case 45: goto st11;
		case 51: goto tr8;
		case 108: goto tr10;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto st3;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto tr9;
		} else if ( (*p) >= 65 )
			goto tr9;
	} else
		goto tr7;
	goto tr4;
tr1:
/* #line 227 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the rule path matcher.\n" ); }
	goto st0;
tr4:
/* #line 228 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the rule hostname.\n" ); }
	goto st0;
tr21:
/* #line 229 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the lua path.\n" ); }
	goto st0;
/* #line 2196 "parser.c" */
st0:
cs = 0;
	goto _out;
st11:
	if ( ++p == pe )
		goto _test_eof11;
case 11:
	goto st0;
tr7:
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st12;
tr19:
/* #line 218 "parser.rl" */
	{ MARK_E(scheme) }
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st12;
st12:
	if ( ++p == pe )
		goto _test_eof12;
case 12:
/* #line 2219 "parser.c" */
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
st4:
	if ( ++p == pe )
		goto _test_eof4;
case 4:
	switch( (*p) ) {
		case 45: goto st4;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto tr4;
st13:
	if ( ++p == pe )
		goto _test_eof13;
case 13:
	switch( (*p) ) {
		case 47: goto tr25;
		case 58: goto tr26;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
tr25:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
	goto st14;
tr28:
/* #line 222 "parser.rl" */
	{ MARK_E(port) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
	goto st14;
tr36:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 222 "parser.rl" */
	{ MARK_E(port) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
	goto st14;
st14:
	if ( ++p == pe )
		goto _test_eof14;
case 14:
/* #line 2294 "parser.c" */
	if ( (*p) == 32 )
		goto st0;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st0;
	goto st14;
tr26:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 221 "parser.rl" */
	{ p_parsed->tokens.port_start = p+1; }
	goto st5;
st5:
	if ( ++p == pe )
		goto _test_eof5;
case 5:
/* #line 2310 "parser.c" */
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st15;
	goto st0;
st15:
	if ( ++p == pe )
		goto _test_eof15;
case 15:
	if ( (*p) == 47 )
		goto tr28;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st16;
	goto st0;
st16:
	if ( ++p == pe )
		goto _test_eof16;
case 16:
	if ( (*p) == 47 )
		goto tr28;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st17;
	goto st0;
st17:
	if ( ++p == pe )
		goto _test_eof17;
case 17:
	if ( (*p) == 47 )
		goto tr28;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st18;
	goto st0;
st18:
	if ( ++p == pe )
		goto _test_eof18;
case 18:
	if ( (*p) == 47 )
		goto tr28;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st19;
	goto st0;
st19:
	if ( ++p == pe )
		goto _test_eof19;
case 19:
	if ( (*p) == 47 )
		goto tr28;
	goto st0;
tr8:
/* #line 212 "parser.rl" */
	{ MARK_S(redir) }
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st20;
st20:
	if ( ++p == pe )
		goto _test_eof20;
case 20:
/* #line 2367 "parser.c" */
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 48: goto st21;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 49 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
st21:
	if ( ++p == pe )
		goto _test_eof21;
case 21:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 48: goto st12;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 51 ) {
		if ( 49 <= (*p) && (*p) <= 50 )
			goto st22;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st12;
		} else if ( (*p) >= 65 )
			goto st12;
	} else
		goto st12;
	goto st0;
st22:
	if ( ++p == pe )
		goto _test_eof22;
case 22:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr35;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
tr35:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 221 "parser.rl" */
	{ p_parsed->tokens.port_start = p+1; }
	goto st6;
st6:
	if ( ++p == pe )
		goto _test_eof6;
case 6:
/* #line 2439 "parser.c" */
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr15;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr16;
	} else
		goto tr16;
	goto tr4;
tr15:
/* #line 213 "parser.rl" */
	{ p_parsed->tokens.redir_length = 3; }
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st23;
st23:
	if ( ++p == pe )
		goto _test_eof23;
case 23:
/* #line 2459 "parser.c" */
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr36;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st24;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
st24:
	if ( ++p == pe )
		goto _test_eof24;
case 24:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr36;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st25;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
st25:
	if ( ++p == pe )
		goto _test_eof25;
case 25:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr36;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st26;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
st26:
	if ( ++p == pe )
		goto _test_eof26;
case 26:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr36;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st27;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
st27:
	if ( ++p == pe )
		goto _test_eof27;
case 27:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr36;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
tr9:
/* #line 217 "parser.rl" */
	{ MARK_S(scheme) }
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st28;
tr16:
/* #line 213 "parser.rl" */
	{ p_parsed->tokens.redir_length = 3; }
/* #line 217 "parser.rl" */
	{ MARK_S(scheme) }
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st28;
st28:
	if ( ++p == pe )
		goto _test_eof28;
case 28:
/* #line 2574 "parser.c" */
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st29;
	} else
		goto st29;
	goto st0;
st29:
	if ( ++p == pe )
		goto _test_eof29;
case 29:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr26;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st30;
	} else
		goto st30;
	goto st0;
st30:
	if ( ++p == pe )
		goto _test_eof30;
case 30:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr43;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st31;
	} else
		goto st31;
	goto st0;
tr43:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 221 "parser.rl" */
	{ p_parsed->tokens.port_start = p+1; }
	goto st7;
st7:
	if ( ++p == pe )
		goto _test_eof7;
case 7:
/* #line 2641 "parser.c" */
	if ( (*p) == 47 )
		goto st8;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st15;
	goto st0;
st8:
	if ( ++p == pe )
		goto _test_eof8;
case 8:
	if ( (*p) == 47 )
		goto st9;
	goto st0;
st9:
	if ( ++p == pe )
		goto _test_eof9;
case 9:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr19;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr19;
	} else
		goto tr19;
	goto tr4;
st31:
	if ( ++p == pe )
		goto _test_eof31;
case 31:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr43;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st32;
	} else
		goto st32;
	goto st0;
st32:
	if ( ++p == pe )
		goto _test_eof32;
case 32:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr43;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st12;
	} else
		goto st12;
	goto st0;
tr10:
/* #line 217 "parser.rl" */
	{ MARK_S(scheme) }
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st33;
st33:
	if ( ++p == pe )
		goto _test_eof33;
case 33:
/* #line 2717 "parser.c" */
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr26;
		case 95: goto st4;
		case 117: goto st34;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st29;
	} else
		goto st29;
	goto st0;
st34:
	if ( ++p == pe )
		goto _test_eof34;
case 34:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr26;
		case 95: goto st4;
		case 97: goto st35;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 98 <= (*p) && (*p) <= 122 )
			goto st30;
	} else
		goto st30;
	goto st0;
st35:
	if ( ++p == pe )
		goto _test_eof35;
case 35:
	switch( (*p) ) {
		case 45: goto st4;
		case 46: goto st13;
		case 47: goto tr25;
		case 58: goto tr48;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st12;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st31;
	} else
		goto st31;
	goto st0;
tr48:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 221 "parser.rl" */
	{ p_parsed->tokens.port_start = p+1; }
	goto st10;
st10:
	if ( ++p == pe )
		goto _test_eof10;
case 10:
/* #line 2786 "parser.c" */
	switch( (*p) ) {
		case 32: goto tr21;
		case 47: goto tr22;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr23;
	} else if ( (*p) >= 9 )
		goto tr21;
	goto tr20;
tr20:
/* #line 215 "parser.rl" */
	{ p_parsed->lua = 1; MARK_S(luapath) }
	goto st36;
st36:
	if ( ++p == pe )
		goto _test_eof36;
case 36:
/* #line 2805 "parser.c" */
	if ( (*p) == 32 )
		goto st0;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st0;
	goto st36;
tr22:
/* #line 215 "parser.rl" */
	{ p_parsed->lua = 1; MARK_S(luapath) }
	goto st37;
st37:
	if ( ++p == pe )
		goto _test_eof37;
case 37:
/* #line 2819 "parser.c" */
	switch( (*p) ) {
		case 32: goto st0;
		case 47: goto st38;
	}
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st0;
	goto st36;
st38:
	if ( ++p == pe )
		goto _test_eof38;
case 38:
	if ( (*p) == 32 )
		goto tr4;
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr4;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto tr51;
		} else if ( (*p) >= 65 )
			goto tr51;
	} else
		goto tr51;
	goto st36;
tr51:
/* #line 218 "parser.rl" */
	{ MARK_E(scheme) }
/* #line 219 "parser.rl" */
	{ MARK_S(host) }
	goto st39;
st39:
	if ( ++p == pe )
		goto _test_eof39;
case 39:
/* #line 2855 "parser.c" */
	switch( (*p) ) {
		case 32: goto st0;
		case 45: goto st40;
		case 46: goto st41;
		case 47: goto tr54;
		case 58: goto tr56;
		case 95: goto st40;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto st0;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st39;
		} else if ( (*p) >= 65 )
			goto st39;
	} else
		goto st39;
	goto st36;
st40:
	if ( ++p == pe )
		goto _test_eof40;
case 40:
	switch( (*p) ) {
		case 32: goto tr4;
		case 45: goto st40;
		case 95: goto st40;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr4;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st39;
		} else if ( (*p) >= 65 )
			goto st39;
	} else
		goto st39;
	goto st36;
st41:
	if ( ++p == pe )
		goto _test_eof41;
case 41:
	switch( (*p) ) {
		case 32: goto st0;
		case 47: goto tr54;
		case 58: goto tr56;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto st0;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st39;
		} else if ( (*p) >= 65 )
			goto st39;
	} else
		goto st39;
	goto st36;
tr54:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
	goto st42;
tr59:
/* #line 222 "parser.rl" */
	{ MARK_E(port) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
	goto st42;
st42:
	if ( ++p == pe )
		goto _test_eof42;
case 42:
/* #line 2934 "parser.c" */
	if ( (*p) == 32 )
		goto st0;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st0;
	goto st42;
tr56:
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 221 "parser.rl" */
	{ p_parsed->tokens.port_start = p+1; }
	goto st43;
st43:
	if ( ++p == pe )
		goto _test_eof43;
case 43:
/* #line 2950 "parser.c" */
	if ( (*p) == 32 )
		goto st0;
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st44;
	} else if ( (*p) >= 9 )
		goto st0;
	goto st36;
tr23:
/* #line 215 "parser.rl" */
	{ p_parsed->lua = 1; MARK_S(luapath) }
	goto st44;
st44:
	if ( ++p == pe )
		goto _test_eof44;
case 44:
/* #line 2967 "parser.c" */
	switch( (*p) ) {
		case 32: goto st0;
		case 47: goto tr59;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st45;
	} else if ( (*p) >= 9 )
		goto st0;
	goto st36;
st45:
	if ( ++p == pe )
		goto _test_eof45;
case 45:
	switch( (*p) ) {
		case 32: goto st0;
		case 47: goto tr59;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st46;
	} else if ( (*p) >= 9 )
		goto st0;
	goto st36;
st46:
	if ( ++p == pe )
		goto _test_eof46;
case 46:
	switch( (*p) ) {
		case 32: goto st0;
		case 47: goto tr59;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st47;
	} else if ( (*p) >= 9 )
		goto st0;
	goto st36;
st47:
	if ( ++p == pe )
		goto _test_eof47;
case 47:
	switch( (*p) ) {
		case 32: goto st0;
		case 47: goto tr59;
	}
	if ( (*p) > 13 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st48;
	} else if ( (*p) >= 9 )
		goto st0;
	goto st36;
st48:
	if ( ++p == pe )
		goto _test_eof48;
case 48:
	switch( (*p) ) {
		case 32: goto st0;
		case 47: goto tr59;
	}
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st0;
	goto st36;
	}
	_test_eof2: cs = 2; goto _test_eof; 
	_test_eof3: cs = 3; goto _test_eof; 
	_test_eof11: cs = 11; goto _test_eof; 
	_test_eof12: cs = 12; goto _test_eof; 
	_test_eof4: cs = 4; goto _test_eof; 
	_test_eof13: cs = 13; goto _test_eof; 
	_test_eof14: cs = 14; goto _test_eof; 
	_test_eof5: cs = 5; goto _test_eof; 
	_test_eof15: cs = 15; goto _test_eof; 
	_test_eof16: cs = 16; goto _test_eof; 
	_test_eof17: cs = 17; goto _test_eof; 
	_test_eof18: cs = 18; goto _test_eof; 
	_test_eof19: cs = 19; goto _test_eof; 
	_test_eof20: cs = 20; goto _test_eof; 
	_test_eof21: cs = 21; goto _test_eof; 
	_test_eof22: cs = 22; goto _test_eof; 
	_test_eof6: cs = 6; goto _test_eof; 
	_test_eof23: cs = 23; goto _test_eof; 
	_test_eof24: cs = 24; goto _test_eof; 
	_test_eof25: cs = 25; goto _test_eof; 
	_test_eof26: cs = 26; goto _test_eof; 
	_test_eof27: cs = 27; goto _test_eof; 
	_test_eof28: cs = 28; goto _test_eof; 
	_test_eof29: cs = 29; goto _test_eof; 
	_test_eof30: cs = 30; goto _test_eof; 
	_test_eof7: cs = 7; goto _test_eof; 
	_test_eof8: cs = 8; goto _test_eof; 
	_test_eof9: cs = 9; goto _test_eof; 
	_test_eof31: cs = 31; goto _test_eof; 
	_test_eof32: cs = 32; goto _test_eof; 
	_test_eof33: cs = 33; goto _test_eof; 
	_test_eof34: cs = 34; goto _test_eof; 
	_test_eof35: cs = 35; goto _test_eof; 
	_test_eof10: cs = 10; goto _test_eof; 
	_test_eof36: cs = 36; goto _test_eof; 
	_test_eof37: cs = 37; goto _test_eof; 
	_test_eof38: cs = 38; goto _test_eof; 
	_test_eof39: cs = 39; goto _test_eof; 
	_test_eof40: cs = 40; goto _test_eof; 
	_test_eof41: cs = 41; goto _test_eof; 
	_test_eof42: cs = 42; goto _test_eof; 
	_test_eof43: cs = 43; goto _test_eof; 
	_test_eof44: cs = 44; goto _test_eof; 
	_test_eof45: cs = 45; goto _test_eof; 
	_test_eof46: cs = 46; goto _test_eof; 
	_test_eof47: cs = 47; goto _test_eof; 
	_test_eof48: cs = 48; goto _test_eof; 

	_test_eof: {}
	if ( p == eof )
	{
	switch ( cs ) {
	case 11: 
/* #line 214 "parser.rl" */
	{ p_parsed->negate = 1; }
	break;
	case 14: 
/* #line 224 "parser.rl" */
	{ MARK_E(path) }
	break;
	case 36: 
	case 37: 
	case 38: 
	case 40: 
	case 43: 
/* #line 225 "parser.rl" */
	{ MARK_E(luapath) }
	break;
	case 1: 
/* #line 227 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the rule path matcher.\n" ); }
	break;
	case 3: 
	case 4: 
	case 6: 
	case 9: 
/* #line 228 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the rule hostname.\n" ); }
	break;
	case 10: 
/* #line 229 "parser.rl" */
	{ debug( 3, LOC, "Unable to parse the lua path.\n" ); }
	break;
	case 42: 
/* #line 224 "parser.rl" */
	{ MARK_E(path) }
/* #line 225 "parser.rl" */
	{ MARK_E(luapath) }
	break;
	case 12: 
	case 13: 
	case 20: 
	case 21: 
	case 22: 
	case 28: 
	case 29: 
	case 30: 
	case 31: 
	case 32: 
	case 33: 
	case 34: 
	case 35: 
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
/* #line 224 "parser.rl" */
	{ MARK_E(path) }
	break;
	case 15: 
	case 16: 
	case 17: 
	case 18: 
	case 19: 
/* #line 222 "parser.rl" */
	{ MARK_E(port) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
/* #line 224 "parser.rl" */
	{ MARK_E(path) }
	break;
	case 23: 
	case 24: 
	case 25: 
	case 26: 
	case 27: 
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 222 "parser.rl" */
	{ MARK_E(port) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
/* #line 224 "parser.rl" */
	{ MARK_E(path) }
	break;
	case 39: 
	case 41: 
/* #line 220 "parser.rl" */
	{ MARK_E(host) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
/* #line 224 "parser.rl" */
	{ MARK_E(path) }
/* #line 225 "parser.rl" */
	{ MARK_E(luapath) }
	break;
	case 44: 
	case 45: 
	case 46: 
	case 47: 
	case 48: 
/* #line 222 "parser.rl" */
	{ MARK_E(port) }
/* #line 223 "parser.rl" */
	{ MARK_S(path) }
/* #line 224 "parser.rl" */
	{ MARK_E(path) }
/* #line 225 "parser.rl" */
	{ MARK_E(luapath) }
	break;
/* #line 3192 "parser.c" */
	}
	}

	_out: {}
	}

/* #line 257 "parser.rl" */

	/* If we were given an invalid rule, bail early */
	if ( cs < 
/* #line 3203 "parser.c" */
11
/* #line 259 "parser.rl" */
 ) {
		free( p_parsed ), p_parsed = NULL;
		debug( 3, LOC, "Invalid rule\n" );
		debug( 4, LOC, "%s\n", rewrite );
		return( NULL );
	}

	(void)populate_parsed( p_parsed );
	return( p_parsed );
}


/*
 * Tokenize a line from an ascii representation of the database, returning
 * a pointer to a parsed struct.  Used for creation of a new cdb file,
 * validating data prior to use.
 *
 */
struct db_input *
parse_dbinput( char *line )
{
	/* machine required vars */
	unsigned short int cs = 1;
	char *p   = line;
	char *pe  = p + strlen(p);
	char *eof = pe;

	/* the db line input pointer */
	struct db_input *dbline = NULL;
	if ( (dbline = malloc( sizeof(struct db_input) )) == NULL ) {
		debug( 5, LOC, "Unable to allocate memory for db input: %s\n", strerror(errno) );
		return( NULL );
	}
	dbline->klen   = 0;
	dbline->vlen   = 0;
	dbline->kstart = NULL;
	dbline->key    = NULL;
	dbline->vstart = NULL;
	dbline->val    = NULL;


/* #line 320 "parser.rl" */


	/* state machine */
	
/* #line 3252 "parser.c" */
	{
	if ( p == pe )
		goto _test_eof;
	switch ( cs )
	{
case 1:
	if ( (*p) == 42 )
		goto tr1;
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr2;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr2;
	} else
		goto tr2;
	goto tr0;
tr0:
/* #line 304 "parser.rl" */
	{ debug( 0, LOC, "Invalid key format\n" ); }
	goto st0;
/* #line 3274 "parser.c" */
st0:
cs = 0;
	goto _out;
tr1:
/* #line 302 "parser.rl" */
	{ dbline->kstart = p; }
	goto st2;
st2:
	if ( ++p == pe )
		goto _test_eof2;
case 2:
/* #line 3286 "parser.c" */
	if ( (*p) == 32 )
		goto tr3;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto tr3;
	goto st0;
tr3:
/* #line 303 "parser.rl" */
	{ dbline->klen = p - ( *pe + dbline->kstart ); }
	goto st3;
st3:
	if ( ++p == pe )
		goto _test_eof3;
case 3:
/* #line 3300 "parser.c" */
	if ( (*p) == 32 )
		goto st3;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st3;
	goto tr5;
tr5:
/* #line 305 "parser.rl" */
	{ dbline->vstart = p; }
	goto st4;
st4:
	if ( ++p == pe )
		goto _test_eof4;
case 4:
/* #line 3314 "parser.c" */
	if ( (*p) == 32 )
		goto st5;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st5;
	goto st4;
st5:
	if ( ++p == pe )
		goto _test_eof5;
case 5:
	if ( (*p) == 32 )
		goto st5;
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st5;
	goto st6;
st6:
	if ( ++p == pe )
		goto _test_eof6;
case 6:
	switch( (*p) ) {
		case 10: goto tr10;
		case 32: goto st0;
	}
	if ( 9 <= (*p) && (*p) <= 13 )
		goto st0;
	goto st6;
tr10:
/* #line 306 "parser.rl" */
	{ dbline->vlen = p - ( *pe + dbline->vstart ); }
	goto st10;
st10:
	if ( ++p == pe )
		goto _test_eof10;
case 10:
/* #line 3348 "parser.c" */
	goto st0;
tr2:
/* #line 302 "parser.rl" */
	{ dbline->kstart = p; }
	goto st7;
st7:
	if ( ++p == pe )
		goto _test_eof7;
case 7:
/* #line 3358 "parser.c" */
	switch( (*p) ) {
		case 32: goto tr3;
		case 45: goto st8;
		case 46: goto st9;
		case 95: goto st8;
	}
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr3;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st7;
		} else if ( (*p) >= 65 )
			goto st7;
	} else
		goto st7;
	goto st0;
st8:
	if ( ++p == pe )
		goto _test_eof8;
case 8:
	switch( (*p) ) {
		case 45: goto st8;
		case 95: goto st8;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st7;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st7;
	} else
		goto st7;
	goto tr0;
st9:
	if ( ++p == pe )
		goto _test_eof9;
case 9:
	if ( (*p) == 32 )
		goto tr3;
	if ( (*p) < 48 ) {
		if ( 9 <= (*p) && (*p) <= 13 )
			goto tr3;
	} else if ( (*p) > 57 ) {
		if ( (*p) > 90 ) {
			if ( 97 <= (*p) && (*p) <= 122 )
				goto st7;
		} else if ( (*p) >= 65 )
			goto st7;
	} else
		goto st7;
	goto st0;
	}
	_test_eof2: cs = 2; goto _test_eof; 
	_test_eof3: cs = 3; goto _test_eof; 
	_test_eof4: cs = 4; goto _test_eof; 
	_test_eof5: cs = 5; goto _test_eof; 
	_test_eof6: cs = 6; goto _test_eof; 
	_test_eof10: cs = 10; goto _test_eof; 
	_test_eof7: cs = 7; goto _test_eof; 
	_test_eof8: cs = 8; goto _test_eof; 
	_test_eof9: cs = 9; goto _test_eof; 

	_test_eof: {}
	if ( p == eof )
	{
	switch ( cs ) {
	case 1: 
	case 8: 
/* #line 304 "parser.rl" */
	{ debug( 0, LOC, "Invalid key format\n" ); }
	break;
	case 3: 
	case 4: 
	case 5: 
/* #line 307 "parser.rl" */
	{ debug( 0, LOC, "Invalid rewrite value\n" ); }
	break;
/* #line 3438 "parser.c" */
	}
	}

	_out: {}
	}

/* #line 324 "parser.rl" */

	/* If the input line was invalid, bail early */
	if ( cs < 
/* #line 3449 "parser.c" */
10
/* #line 326 "parser.rl" */
 ) {
		free( dbline ), dbline = NULL;
		return( NULL );
	}

	/* populate struct */
	dbline->key = copy_string_token( dbline->kstart, dbline->klen );
	dbline->val = copy_string_token( dbline->vstart, dbline->vlen );

	/* check the val to make sure it is a valid rewrite rule */
	parsed *valstr = NULL;
	valstr = parse_rule( dbline->val );
	if ( valstr == NULL ) {
		free( dbline->key );
		free( dbline->val );
		free( dbline );
		return( NULL );
	}
	finish_parsed( valstr );

	return( dbline );
}



/*
 * Initialize and return a pointer to a new parser object.
 *
 */
parsed *
init_parsed( void )
{
	parsed *p_parsed = NULL;
	if ( (p_parsed = malloc( sizeof(parsed) )) == NULL ) {
		debug( 5, LOC, "Unable to allocate memory for parsed struct: %s\n", strerror(errno) );
		return( NULL );
	}

	p_parsed->valid     = 0;
	p_parsed->type      = 0;
	p_parsed->negate    = 0;
	p_parsed->lua       = 0;
	p_parsed->chid      = NULL;
	p_parsed->path_re   = NULL;
	p_parsed->redir     = NULL;
	p_parsed->scheme    = NULL;
	p_parsed->host      = NULL;
	p_parsed->tld       = NULL;
	p_parsed->port      = NULL;
	p_parsed->path      = NULL;
	p_parsed->user      = NULL;
	p_parsed->method    = NULL;
	p_parsed->client_ip = NULL;
	p_parsed->luapath   = NULL;

	p_parsed->tokens.chid_start     = NULL;
	p_parsed->tokens.path_re_start  = NULL;
	p_parsed->tokens.redir_start    = NULL;
	p_parsed->tokens.scheme_start   = NULL;
	p_parsed->tokens.host_start     = NULL;
	p_parsed->tokens.port_start     = NULL;
	p_parsed->tokens.path_start     = NULL;
	p_parsed->tokens.meth_start     = NULL;
	p_parsed->tokens.c_ip_start     = NULL;
	p_parsed->tokens.luapath_start  = NULL;
	p_parsed->tokens.chid_length    = 0;
	p_parsed->tokens.path_re_length = 0;
	p_parsed->tokens.redir_length   = 0;
	p_parsed->tokens.scheme_length  = 0;
	p_parsed->tokens.host_length    = 0;
	p_parsed->tokens.port_length    = 0;
	p_parsed->tokens.path_length    = 0;
	p_parsed->tokens.meth_length    = 0;
	p_parsed->tokens.c_ip_length    = 0;
	p_parsed->tokens.luapath_length = 0;

	return p_parsed;
}


/*
 * Release memory used by the parsed struct.
 *
 */
void
finish_parsed( parsed *p_parsed )
{
	if ( p_parsed == NULL ) return;

	free( p_parsed->scheme );
	free( p_parsed->host );
	free( p_parsed->path );
	free( p_parsed->port );

	if ( p_parsed->type == REQUEST ) {
		free( p_parsed->chid );
		free( p_parsed->tld );
		free( p_parsed->method );
		free( p_parsed->client_ip );
	}

	if ( p_parsed->type == RULE ) {
		free( p_parsed->path_re );
		free( p_parsed->redir );
		free( p_parsed->luapath );
	}

	free( p_parsed ), p_parsed = NULL;

	return;
}


/*
 * Take the previously parsed token locations and copy them into the request struct.
 *
 */
void
populate_parsed( parsed *p_parsed )
{
	p_parsed->scheme = COPY_STR( scheme );
	p_parsed->host   = COPY_STR( host );
	p_parsed->path   = COPY_STR( path );
	p_parsed->port   = COPY_STR( port );

	if ( p_parsed->type == REQUEST ) {
		p_parsed->valid     = 1;
		p_parsed->chid      = COPY_STR( chid );
		p_parsed->method    = COPY_STR( meth );
		p_parsed->client_ip = COPY_STR( c_ip );
		/* p_request->client_ip = COPY_IP4( c_ip ); */

		(void)lowercase_str( p_parsed->host, p_parsed->tokens.host_length );
		(void)parse_tld( p_parsed );
	}

	if ( p_parsed->type == RULE ) {
		p_parsed->path_re = COPY_STR( path_re );
		p_parsed->redir   = COPY_STR( redir );
		p_parsed->luapath = COPY_STR( luapath );
	}

	return;
}


/*
 * Pull the top level domain out of the requested hostname.
 *
 */
void
parse_tld( parsed *p_request )
{
	unsigned short int cs = 5, mark = 0;
	char *p  = p_request->host;
	char *pe = p + p_request->tokens.host_length;
	char *ts = 0, *te = 0, *eof = pe;


/* #line 493 "parser.rl" */


	/* It's far easier (and faster) to scan from left to right rather than
	   backtrack, so start by reversing the requested host string. */
	reverse_str( p_request->host );

	/* scanner */
	
/* #line 3620 "parser.c" */
	{
	if ( p == pe )
		goto _test_eof;
	switch ( cs )
	{
tr5:
/* #line 491 "parser.rl" */
	{{p = ((te))-1;}{ mark = ( p_request->tokens.host_length - (int)strlen(te) ); }}
	goto st5;
tr7:
/* #line 491 "parser.rl" */
	{te = p;p--;{ mark = ( p_request->tokens.host_length - (int)strlen(te) ); }}
	goto st5;
st5:
/* #line 1 "NONE" */
	{ts = 0;}
	if ( ++p == pe )
		goto _test_eof5;
case 5:
/* #line 1 "NONE" */
	{ts = p;}
/* #line 3642 "parser.c" */
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st1;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st1;
	} else
		goto st1;
	goto st0;
st0:
cs = 0;
	goto _out;
st1:
	if ( ++p == pe )
		goto _test_eof1;
case 1:
	switch( (*p) ) {
		case 45: goto st2;
		case 46: goto st3;
		case 95: goto st2;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st1;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st1;
	} else
		goto st1;
	goto st0;
st2:
	if ( ++p == pe )
		goto _test_eof2;
case 2:
	switch( (*p) ) {
		case 45: goto st2;
		case 95: goto st2;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st1;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st1;
	} else
		goto st1;
	goto st0;
st3:
	if ( ++p == pe )
		goto _test_eof3;
case 3:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr4;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr4;
	} else
		goto tr4;
	goto st0;
tr4:
/* #line 1 "NONE" */
	{te = p+1;}
	goto st6;
st6:
	if ( ++p == pe )
		goto _test_eof6;
case 6:
/* #line 3711 "parser.c" */
	switch( (*p) ) {
		case 45: goto st4;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr4;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr4;
	} else
		goto tr4;
	goto tr7;
st4:
	if ( ++p == pe )
		goto _test_eof4;
case 4:
	switch( (*p) ) {
		case 45: goto st4;
		case 95: goto st4;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr4;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr4;
	} else
		goto tr4;
	goto tr5;
	}
	_test_eof5: cs = 5; goto _test_eof; 
	_test_eof1: cs = 1; goto _test_eof; 
	_test_eof2: cs = 2; goto _test_eof; 
	_test_eof3: cs = 3; goto _test_eof; 
	_test_eof6: cs = 6; goto _test_eof; 
	_test_eof4: cs = 4; goto _test_eof; 

	_test_eof: {}
	if ( p == eof )
	{
	switch ( cs ) {
	case 6: goto tr7;
	case 4: goto tr5;
	}
	}

	_out: {}
	}

/* #line 501 "parser.rl" */

	/* If there was a mark, then allocate memory and copy. */
	if ( mark != 0 ) {
		if ( (p_request->tld = calloc( mark + 1, sizeof(char) )) == NULL ) {
			debug( 5, LOC, "Unable to allocate memory for tld token: %s\n", strerror(errno) );
			reverse_str( p_request->host );
			return;
		}

		memcpy( p_request->tld, p_request->host, mark );
		reverse_str( p_request->tld );
	}

	/* restore the hostname. */
	reverse_str( p_request->host );
	return;
}

