import os

fn testsuite_begin() {
	os.setenv('VCOLORS', 'never', true)
}

fn vroot_path(relpath string) string {
	return os.real_path(os.join_path(@VMODROOT, relpath))
}

fn vrun_ok(options string, path string) string {
	cmd := '${@VEXE} $options $path'
	res := os.execute(cmd)
	if res.exit_code != 0 {
		eprintln('> failing vrun cmd: $cmd')
		eprintln('> output:\n$res.output')
		assert res.exit_code == 0
	}
	return res.output
}

fn test_projects_should_run() {
	res := vrun_ok('run', vroot_path('vlib/v/tests/testdata/enum_in_builtin') + os.path_separator)
	assert res.trim_space() == 'v0'
}
