--
--  $Id$
--
--  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
--  project.
--
--  Copyright (C) 1998-2023 OpenLink Software
--
--  This project is free software; you can redistribute it and/or modify it
--  under the terms of the GNU General Public License as published by the
--  Free Software Foundation; only version 2 of the License, dated June 1991.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--  General Public License for more details.
--
--  You should have received a copy of the GNU General Public License along
--  with this program; if not, write to the Free Software Foundation, Inc.,
--  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
--
--
--
--  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
--  project.
--
--  Copyright (C) 1998-2023 OpenLink Software
--
--  This project is free software; you can redistribute it and/or modify it
--  under the terms of the GNU General Public License as published by the
--  Free Software Foundation; only version 2 of the License, dated June 1991.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--  General Public License for more details.
--
--  You should have received a copy of the GNU General Public License along
--  with this program; if not, write to the Free Software Foundation, Inc.,
--  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
--
--


;
;
;
;


-- Autogenerated test script




create procedure prop_set (in path varchar, in prop_assoc_set any, in prop_assoc_del any)
{
  declare idx int;
  for (idx := 0; idx < length (prop_assoc_set); idx := idx + 2)
   {
     if (DAV_HIDE_ERROR (DAV_PROP_SET (path, prop_assoc_set[idx], prop_assoc_set[idx+1], 'dav', 'dav')) is null)
 	return -1;
   }
  for (idx := 0; idx < length (prop_assoc_del); idx := idx + 1)
   {
     if (DAV_HIDE_ERROR (DAV_PROP_REMOVE (path, prop_assoc_del[idx], 'dav', 'dav')) is null)
 	return -1;
   }
  return 1;
}
;



create procedure upload_doc (in path varchar, in content any)
{
  return DAV_RES_UPLOAD (path, content,  'text/plain' , '110100100R', 'dav', 'administrators', 'dav', 'dav');
}
;

create procedure upload_docs (in path varchar, in num int := 10)
{
 declare idx int;
 idx := num;
 while (idx > 0)
  {
    declare res int;
    res := upload_doc (path || sprintf ('test%d.txt', idx), sprintf ('hello world! - %d', idx) );
    if (res < 0)
    	return res;
    idx := idx - 1;
  }
 return 1;
}
;

create procedure get_doc (in path varchar)
{
  declare content,id any;
  declare type varchar;
  id := DAV_SEARCH_ID (path, 'R');
  if ((DAV_HIDE_ERROR(id) is not null) and (DAV_RES_CONTENT_INT (id, content, type, 0, 0, null, null) > 0))
    {
      return content;
    }
  dbg_obj_princ ('id = ', id);
  if (DAV_HIDE_ERROR (id) is not null)
    dbg_obj_princ ('content_int = ', DAV_RES_CONTENT_INT (id, content, type, 0, 0, null, null));
  return NULL;
}
;

create procedure get_doc_v (in path varchar, in ver int)
{
  declare content,id, mode any;
  declare type varchar;
  id := DAV_SEARCH_ID (path, 'R');
  dbg_obj_princ ('id: ', id);
  if ((id>0) and (DAV_GET_VERSION_CONTENT (id, ver, content, type, mode) >= 0))
    {
      return content;
    }
  return NULL;
}
;

create procedure check_file (in path varchar, in _type varchar(1):= 'R')
{
  declare id any;
  id := DAV_SEARCH_ID (path, _type);
  if (isinteger (id) and (id < 0))
    return 'not found';
  return 'found';
}
;

create procedure select_from_dir (in base varchar, in file varchar)
{
  declare _dirl any;
  _dirl := DAV_DIR_LIST (base, 0, 'dav', 'dav');
  foreach (any f in _dirl) do {
    if (aref (f, 10) = file)
      return 'found';
  }
  return 'not found';
}
;



create procedure get_doc_v_2 (in det_path varchar, in filename varchar, in ver_or_hist any)
{
  declare content,id any;
  declare mode varchar;

  declare full_path varchar;
  full_path := sprintf ('%s/%s/%s', det_path, filename, cast (ver_or_hist as varchar));
  id := DAV_SEARCH_ID (full_path, 'R');
  dbg_obj_princ ('id: ', id);
  if (isarray (id) and (DAV_RES_CONTENT (full_path, content, mode,  'dav', 'dav') > 0))
    {
      return content;
    }
  return NULL;
}
;

create procedure get_prop (in path varchar, in prop varchar)
{
  return DB.DBA.DAV_PROP_GET(path, prop, 'dav', 'dav');
}
;

create procedure mv (in src varchar, in target varchar, in overwrt int:=0)
{
  return DAV_MOVE (src, target, overwrt, 'dav', 'dav');
}
;


create procedure lock_res (in path varchar)
{
  declare _token varchar;
  _token := DB.DBA.DAV_LOCK (path, 'R', 'R', null, 'dav', null, null, 3600, 'dav', 'dav');
  if (isstring (_token))
    {
	registry_set ('DETVerTest.LockToken', _token);
	return 1;
    }
  else
	return _token;
}
;

create procedure unlock_res (in path varchar)
{
  return DB.DBA.DAV_UNLOCK (path, registry_get ('DETVerTest.LockToken'), 'dav', 'dav');
}
;

create function get_res_prop (in coll varchar, in res varchar, in idx int)
{
  foreach (any prop_v in DAV_DIR_LIST (coll, 0, 'dav', 'dav'))
  do {
      if (prop_v[0] = coll || res)
        return prop_v[idx];
    }
   return NULL;
}
;

create function copy (in source varchar, in dest varchar)
{
  declare _rc int;
  _rc := DAV_COPY (source, dest, 1, '110100000RR', 'dav', 'administrators',
     'dav', 'dav');
  return _rc;
}



ECHO BOTH "Checking versioning, Pass 0 ...\n";

delete from WS.WS.SYS_DAV_LOCK;
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Clear all locks"  ": \"" $STATE "\"\t (must be OK)\n";
DB.DBA.DAV_DELETE ('/DAV/versioning/', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Deleting versioning collection"  ": \"" $STATE "\"\t (must be OK)\n";
DB.DBA.DAV_DELETE ('/DAV/vers/', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Deleting versioning collection"  ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/versioning/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING='A' where COL_ID = DAV_SEARCH_ID ('/DAV/versioning/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Set Versioning control on " ": \"" $STATE "\"\t (must be OK)\n";

select upload_docs ('/DAV/versioning/', 20);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/versioning/ " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/versioning/ " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_COL_CREATE ('/DAV/versioning/test_dir/',  '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir/ "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir/ "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_COL_CREATE ('/DAV/versioning/test_dir1/',  '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir1/ " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir1/ " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_COL_CREATE ('/DAV/versioning/test_dir2/',  '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir2/ " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir2/ " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select upload_docs ('/DAV/versioning/test_dir/', 5);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload docs to /DAV/versioning/test_dir/ "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload docs to /DAV/versioning/test_dir/ "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_COL_CREATE ('/DAV/versioning/test_dir/a2/',  '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir/a2/ "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Create /DAV/versioning/test_dir/a2/ "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select COL_AUTO_VERSIONING from WS.WS.SYS_DAV_COL where COL_ID = DAV_SEARCH_ID ('/DAV/versioning/test_dir/a2/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Check is test_dir/a2 under Versioning DET control " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " Check is test_dir/a2 under Versioning DET control " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";

select upload_docs ('/DAV/versioning/test_dir/a2/', 10);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to /DAV/versioning/test_dir/a2/ "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to /DAV/versioning/test_dir/a2/ "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DAV_SEARCH_ID ('/DAV/versioning/test_dir/test1.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Check /DAV/versioning/test_dir/test1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Check /DAV/versioning/test_dir/test1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DAV_SEARCH_ID ('/DAV/versioning/test1.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test1.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test1.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DAV_SEARCH_ID ('/DAV/versioning/test2.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test2.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test2.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DAV_SEARCH_ID ('/DAV/versioning/test_dir/a2/test1.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test_dir/a2/test1.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test_dir/a2/test1.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DAV_SEARCH_ID ('/DAV/versioning/test_dir/testXX.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test_dir/testXX.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " Check /DAV/versioning/test_dir/testXX.txt "  ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";

select upload_doc ('/DAV/versioning/test2-1.txt', 'hello');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload /DAV/versioning/test2-1.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload /DAV/versioning/test2-1.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/test2-1.txt', 'hello');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " second upload /DAV/versioning/test2-1.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " second upload /DAV/versioning/test2-1.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_SEARCH_ID ('/DAV/versioning/test2-1.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check /DAV/versioning/test2-1.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " check /DAV/versioning/test2-1.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

ECHO BOTH "Checking versioning, Pass 1 ...\n";
select upload_doc ('/DAV/versioning/file0.txt', 'content of file1.txt, version 1');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file0.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file0.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select RES_STATUS from WS.WS.SYS_DAV_RES where RES_FULL_PATH =  '/DAV/versioning/file0.txt';
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check status of file0.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'AV' "PASSED:" "***FAILED:";
ECHO BOTH  " check status of file0.txt " ": \"" $LAST[1] "\"\t (must be: " 'AV' ")\n";
select RV_ID from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = DAV_SEARCH_ID ('/DAV/versioning/file0.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check version of file0.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " check version of file0.txt " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";


ECHO BOTH "Checking versioning, Pass 2 ...\n";

select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 1');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 2');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 3');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 4');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 5');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning/file1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select get_doc_v ('/DAV/versioning/file1.txt', 5);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check 5th version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check 5th version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select get_doc_v ('/DAV/versioning/file1.txt', 4);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 4' "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 4' ")\n";
select get_doc_v ('/DAV/versioning/file1.txt', 3);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 3' "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 3' ")\n";
select get_doc_v ('/DAV/versioning/file1.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 2' "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 2' ")\n";
select get_doc_v ('/DAV/versioning/file1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 1' "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 1' ")\n";
select get_doc_v ('/DAV/versioning/file1.txt', 10);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning/file1.txt', -1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DB.DBA.DAV_DELETE ('/DAV/versioning/file1.txt', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " delete /DAV/versioning/file1.txt file " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " delete /DAV/versioning/file1.txt file " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select upload_doc ('/DAV/versioning/test_dir/a2/file1.txt', 'content of file1.txt, version 1');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/test_dir/a2/file1.txt', 'content of file1.txt, version 2');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/test_dir/a2/file1.txt', 'content of file1.txt, version 3');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/test_dir/a2/file1.txt', 'content of file1.txt, version 4');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/test_dir/a2/file1.txt', 'content of file1.txt, version 5');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select get_doc ('/DAV/versioning/test_dir/a2/file1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select get_doc_v ('/DAV/versioning/test_dir/a2/file1.txt', 5);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check 5th version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check 5th version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning/test_dir/a2/file1.txt', 4);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning/test_dir/a2/file1.txt', 3);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning/test_dir/a2/file1.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning/test_dir/a2/file1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning/test_dir/a2/file1.txt', 10);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning/test_dir/a2/file1.txt', -1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of test_dir/a2/file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existent version of test_dir/a2/file1.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";

ECHO BOTH "Checking versioning, Pass 3 ...\n";

select DB.DBA.DAV_COL_CREATE ('/DAV/vers/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " create folder for versions browsing "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " create folder for versions browsing "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
update WS.WS.SYS_DAV_COL set COL_DET = 'Versioning' where COL_ID = DAV_SEARCH_ID ('/DAV/vers/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set DET "  ": \"" $STATE "\"\t (must be OK)\n";
select count (*) from WS.WS.SYS_DAV_COL where COL_DET = 'Versioning' and COL_ID = DAV_SEARCH_ID ('/DAV/vers/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DET field " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " check DET field " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";

select DAV_PROP_SET ('/DAV/vers/', 'virt:Versioning-Collection', '/DAV/versioning/', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set virt:Version-Collection "  ": \"" $STATE "\"\t (must be OK)\n";
select DAV_PROP_SET ('/DAV/versioning/', 'virt:Versioning-History', '/DAV/vers/', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set virt:Version-History "  ": \"" $STATE "\"\t (must be OK)\n";

select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 1');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 2');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 3');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 4');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1.txt', 'content of file1.txt, version 5');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select get_doc_v_2 ('/DAV/vers', 'file1.txt', 5);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select get_doc_v_2 ('/DAV/vers', 'file1.txt', 4);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 4' "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 4' ")\n";
select get_doc_v_2 ('/DAV/vers', 'file1.txt', 3);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 3' "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 3' ")\n";
select get_doc_v_2 ('/DAV/vers', 'file1.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 2' "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 2' ")\n";
select get_doc_v_2 ('/DAV/vers', 'file1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 1' "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 1' ")\n";
select get_doc_v_2 ('/DAV/vers', 'file1.txt', 10);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existing version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existing version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";

select DB.DBA.DAV_COL_CREATE ('/DAV/versioning/VVC/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " create folder for versions browsing "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " create folder for versions browsing "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_PROP_REMOVE ('/DAV/versioning/', 'virt:Versioning-History', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " remove virt:Version-History "  ": \"" $STATE "\"\t (must be OK)\n";

select DB.DBA.DAV_SET_VERSIONING_CONTROL ('/DAV/versioning/', NULL, 'A', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select count (*) from WS.WS.SYS_DAV_COL where COL_DET = 'Versioning' and COL_ID = DAV_SEARCH_ID ('/DAV/versioning/VVC/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DET field " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " check DET field " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 5);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 4);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 4' "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 4' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 3);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 3' "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 3' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 2' "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 2' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 1' "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 1' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 10);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existing version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check non-existing version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";

select xpath_eval ('count (//version)', xtree_doc (get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 'history.xml')));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history " ": \"" $LAST[1] "\"\t (must be: " 5 ")\n";

select check_file ('/DAV/versioning/VVC/file1.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check of last version reference " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'found' "PASSED:" "***FAILED:";
ECHO BOTH  " check of last version reference " ": \"" $LAST[1] "\"\t (must be: " 'found' ")\n";
select check_file ('/DAV/versioning/VVC/file1.txt/100');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check of absent file " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check of absent file " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select select_from_dir ('/DAV/versioning/VVC/file1.txt/' , 'last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check of last version reference by DAV_DIR_LIST " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'found' "PASSED:" "***FAILED:";
ECHO BOTH  " check of last version reference by DAV_DIR_LIST " ": \"" $LAST[1] "\"\t (must be: " 'found' ")\n";
select select_from_dir ('/DAV/versioning/VVC/file1.txt/' , '100');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check of non-existing version reference by DAV_DIR_LIST " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check of non-existing version reference by DAV_DIR_LIST " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1.txt', 'last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select mv ('/DAV/versioning/VVC/file1.txt/last', '/DAV/versioning/VVC/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " move file file1 to file-mv1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " move file file1 to file-mv1.txt " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select get_doc ('/DAV/versioning/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 5);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 4);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 4' "PASSED:" "***FAILED:";
ECHO BOTH  " check 4th version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 4' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 3);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 3' "PASSED:" "***FAILED:";
ECHO BOTH  " check third version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 3' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 2' "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 2' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 1' "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 1' ")\n";
select check_file ('/DAV/versioning/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check file1-mv1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'found' "PASSED:" "***FAILED:";
ECHO BOTH  " check file1-mv1.txt " ": \"" $LAST[1] "\"\t (must be: " 'found' ")\n";
select check_file ('/DAV/versioning/file1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is file1.txt removed " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is file1.txt removed " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select mv ('/DAV/versioning/VVC/file2.txt/last', '/DAV/versioning/VVC/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " move file file2 to file1-mv1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 1 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " move file file2 to file1-mv1.txt " ": \"" $LAST[1] "\"\t (must be less than " 1 ")\n";
select mv ('/DAV/versioning/VVC/file2.txt/last', '/DAV/versioning/VVC/file1-mv1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " move file file2 to file1-mv1.txt (overwrt = 1) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 1 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " move file file2 to file1-mv1.txt (overwrt = 1) " ": \"" $LAST[1] "\"\t (must be less than " 1 ")\n";
select mv ('/DAV/versioning/VVC/test10.txt/last', '/DAV/versioning/VVC/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " move file test10 to file1-mv1.txt (overwrt = 0) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 1 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " move file test10 to file1-mv1.txt (overwrt = 0) " ": \"" $LAST[1] "\"\t (must be less than " 1 ")\n";
select mv ('/DAV/versioning/VVC/test10.txt/last', '/DAV/versioning/VVC/file1-mv1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " move file test10 to file1-mv1.txt (overwrt = 1) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " move file test10 to file1-mv1.txt (overwrt = 1) " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select get_doc ('/DAV/versioning/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check content of file1-mv1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 10' "PASSED:" "***FAILED:";
ECHO BOTH  " check content of file1-mv1.txt " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 10' ")\n";
select get_doc_v ('/DAV/versioning/file1-mv1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check content of file1-mv1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 10' "PASSED:" "***FAILED:";
ECHO BOTH  " check content of file1-mv1.txt " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 10' ")\n";
select upload_doc ('/DAV/versioning/file1-mv1.txt', 'content of file1-mv1.txt, version 2');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1-mv1.txt', 'content of file1-mv1.txt, version 3');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 3th version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 3th version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_COL_CREATE ('/DAV/versioning/Attic/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create Attic collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create Attic collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_PROP_SET ('/DAV/versioning/VVC/', 'virt:Versioning-Attic', '/DAV/versioning/Attic/', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set virt:Versioning-Attic for VVC folder "  ": \"" $STATE "\"\t (must be OK)\n";

select DAV_DELETE ('/DAV/versioning/VVC/file1-mv1.txt/last', 0, 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " delete resource file1-mv1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " delete resource file1-mv1.txt " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select check_file ('/DAV/versioning/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is file1-mv1.txt removed " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is file1-mv1.txt removed " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select check_file ('/DAV/versioning/Attic/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is file1-mv1.txt in Attic " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is file1-mv1.txt in Attic " ": \"" $LAST[1] "\"\t (must be: " 'found' ")\n";

select DAV_RES_RESTORE ('/DAV/versioning/VVC/', 'file1-mv1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " restoring from Attic "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " restoring from Attic "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning/file1-mv1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check current content of file1-mv1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1-mv1.txt, version 3' "PASSED:" "***FAILED:";
ECHO BOTH  " check current content of file1-mv1.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of file1-mv1.txt, version 3' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 3);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1-mv1.txt, version 3' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1-mv1.txt, version 3' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1-mv1.txt, version 2' "PASSED:" "***FAILED:";
ECHO BOTH  " check second version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'content of file1-mv1.txt, version 2' ")\n";
select get_doc_v_2 ('/DAV/versioning/VVC', 'file1-mv1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1-mv1.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 10' "PASSED:" "***FAILED:";
ECHO BOTH  " check first version of file1-mv1.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 10' ")\n";

select max (rd_from_id) from ws.ws.sys_dav_res_diff, (select rd_res_id, max (rd_to_id) as max_rd_res_id from ws.ws.sys_dav_res_diff group by rd_res_id) a where a.rd_res_id = rd_res_id and max_rd_res_id = rd_to_id and rd_res_id = DAV_SEARCH_ID ('/DAV/versioning/file1-mv1.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check from_id for latest version " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " check from_id for latest version " ": \"" $LAST[1] "\"\t (must be: " 0 ")\n";


select upload_doc ('/DAV/versioning/file1-mv1.txt', 'content of file1-mv1.txt, version 4, \n new line1\n new line2\n');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of file1.txt with several lines " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 4th version of file1.txt with several lines " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1-mv1.txt', 'content of file1-mv1.txt, version 5, \n new line1\n new line3\n');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of file1.txt with several lines " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 5th version of file1.txt with several lines " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/file1-mv1.txt', 'content of file1-mv1.txt, version 6, \n new line1\n new line3\n new line4\nnew line5');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload 6th version of file1.txt with several lines " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload 6th version of file1.txt with several lines " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc_v ('/DAV/versioning/file1-mv1.txt', 4);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " 4th version of file1.txt with several lines " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1-mv1.txt, version 4, \n new line1\n new line2\n' "PASSED:" "***FAILED:";
ECHO BOTH  " 4th version of file1.txt with several lines " ": \"" $LAST[1] "\"\t (must be: " 'content of file1-mv1.txt, version 4, \n new line1\n new line2\n' ")\n";
select get_doc_v ('/DAV/versioning/file1-mv1.txt', 5);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " 5th version of file1.txt with several lines " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1-mv1.txt, version 5, \n new line1\n new line3\n' "PASSED:" "***FAILED:";
ECHO BOTH  " 5th version of file1.txt with several lines " ": \"" $LAST[1] "\"\t (must be: " 'content of file1-mv1.txt, version 5, \n new line1\n new line3\n' ")\n";
select get_doc_v ('/DAV/versioning/file1-mv1.txt', 6);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " 6th version of file1.txt with several lines " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1-mv1.txt, version 6, \n new line1\n new line3\n new line4\nnew line5' "PASSED:" "***FAILED:";
ECHO BOTH  " 6th version of file1.txt with several lines " ": \"" $LAST[1] "\"\t (must be: " 'content of file1-mv1.txt, version 6, \n new line1\n new line3\n new line4\nnew line5' ")\n";

select get_prop('/DAV/versioning/file1-mv1.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-in property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] '/DAV/versioning/VVC/file1-mv1.txt/last' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-in property"  ": \"" $LAST[1] "\"\t (must be: " '/DAV/versioning/VVC/file1-mv1.txt/last' ")\n";

select DAV_HIDE_ERROR(get_prop('/DAV/versioning/file1-mv1.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-out property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-out property"  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop('/DAV/versioning/file1-mv1.txt', 'DAV:auto-version');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checkout-checkin property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'DAV:checkout-checkin' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checkout-checkin property"  ": \"" $LAST[1] "\"\t (must be: " 'DAV:checkout-checkin' ")\n";


create procedure make_long_doc (in n int:=10000)
{
  declare line varchar;
  declare ses any;
  ses := string_output();
  line := 'hell\n';
  while (n > 0)
    {
      http (line, ses);
      n := n - 1;
    }
  return string_output_string (ses);
}
;

select upload_doc ('/DAV/versioning/upload_test.txt', make_long_doc ());
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 1 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 1 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/upload_test.txt', make_long_doc ());
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 2 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 2 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/upload_test.txt', make_long_doc ());
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 3 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 3 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select upload_doc ('/DAV/versioning/upload_test2.txt', make_long_doc ());
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 1 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 1 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/upload_test2.txt', make_long_doc ());
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 2 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 2 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/upload_test2.txt', make_long_doc ());
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 3 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload long doc 3 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_prop('/DAV/versioning/upload_test.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-in property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] '/DAV/versioning/VVC/upload_test.txt/last' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-in property"  ": \"" $LAST[1] "\"\t (must be: " '/DAV/versioning/VVC/upload_test.txt/last' ")\n";

select DAV_HIDE_ERROR(get_prop('/DAV/versioning/upload_test.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-out property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-out property"  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";

select get_prop('/DAV/versioning/upload_test2.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-in property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] '/DAV/versioning/VVC/upload_test2.txt/last' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-in property"  ": \"" $LAST[1] "\"\t (must be: " '/DAV/versioning/VVC/upload_test2.txt/last' ")\n";

select  DAV_HIDE_ERROR(get_prop('/DAV/versioning/upload_test2.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-out property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checked-out property"  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop('/DAV/versioning/upload_test.txt', 'DAV:auto-version');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checkout-checkin property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'DAV:checkout-checkin' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checkout-checkin property"  ": \"" $LAST[1] "\"\t (must be: " 'DAV:checkout-checkin' ")\n";
select get_prop('/DAV/versioning/upload_test2.txt', 'DAV:auto-version');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checkout-checkin property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'DAV:checkout-checkin' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:checkout-checkin property"  ": \"" $LAST[1] "\"\t (must be: " 'DAV:checkout-checkin' ")\n";

select get_prop('/DAV/versioning/upload_test2.txt', 'DAV:version-history');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:version-history property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] '/DAV/versioning/VVC/upload_test2.txt/history.xml' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:version-history property"  ": \"" $LAST[1] "\"\t (must be: " '/DAV/versioning/VVC/upload_test2.txt/history.xml' ")\n";
select get_prop('/DAV/versioning/file1-mv1.txt', 'DAV:version-history');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:version-history property of file1-mv1.txt"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] '/DAV/versioning/VVC/file1-mv1.txt/history.xml' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:version-history property of file1-mv1.txt"  ": \"" $LAST[1] "\"\t (must be: " '/DAV/versioning/VVC/file1-mv1.txt/history.xml' ")\n";




select get_prop('/DAV/versioning/upload_test2.txt', 'DAV:author');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:author property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'dav' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:author property"  ": \"" $LAST[1] "\"\t (must be: " 'dav' ")\n";
select get_prop('/DAV/versioning/file1-mv1.txt', 'DAV:author');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:author of file1-mv1.txt"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'dav' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:author of file1-mv1.txt"  ": \"" $LAST[1] "\"\t (must be: " 'dav' ")\n";


-- history
select get_prop('/DAV/versioning/VVC/upload_test2.txt/history.xml', 'DAV:root-version');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:root-version property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] '<D:href>/DAV/versioning/VVC/upload_test2.txt/1</D:href>' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:root-version property"  ": \"" $LAST[1] "\"\t (must be: " '<D:href>/DAV/versioning/VVC/upload_test2.txt/1</D:href>' ")\n";
select get_prop('/DAV/versioning/VVC/file1-mv1.txt/history.xml', 'DAV:version-set');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:version-set property"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] '<D:href>/DAV/versioning/VVC/file1-mv1.txt/1</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/2</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/3</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/4</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/5</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/6</D:href>' "PASSED:" "***FAILED:";
ECHO BOTH  " DAV:version-set property"  ": \"" $LAST[1] "\"\t (must be: " '<D:href>/DAV/versioning/VVC/file1-mv1.txt/1</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/2</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/3</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/4</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/5</D:href><D:href>/DAV/versioning/VVC/file1-mv1.txt/6</D:href>' ")\n";





-- checkout, update, checkin
ECHO BOTH "Checking versioning, Pass 4 ... checkout, checkin\n";
select COL_AUTO_VERSIONING from WS.WS.SYS_DAV_COL where COL_ID = DAV_SEARCH_ID ('/DAV/versioning/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " COL_AUTO_VERSIONING is on, this must not spoil manual checkout and checkin " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] A "PASSED:" "***FAILED:";
ECHO BOTH " COL_AUTO_VERSIONING is on, this must not spoil manual checkout and checkin " ": \"" $LAST[1] "\"\t (must be: " A ")\n";
select DAV_CHECKOUT('/DAV/versioning/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt out" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt out" ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKOUT" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKOUT" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";

select upload_doc ('/DAV/versioning/test11.txt', 'content of test11.txt in workspace');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning/VVC/test11.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR before CHECKIN) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 11' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR before CHECKIN) " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 11' ")\n";
select DAV_CHECKIN('/DAV/versioning/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in" ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt in workspace' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt in workspace' ")\n";
select get_doc ('/DAV/versioning/VVC/test11.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR after CHECKIN) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt in workspace' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR after CHECKIN) " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt in workspace' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";
select check_file ('/DAV/versioning/workspace!/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check workspace copy " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "not found" "PASSED:" "***FAILED:";
ECHO BOTH " check workspace copy " ": \"" $LAST[1] "\"\t (must be: " "not found" ")\n";


-- checkin without checkout

select  DAV_HIDE_ERROR(DAV_CHECKIN('/DAV/versioning/test11.txt', 'dav', 'dav'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in with checkout" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in with checkout" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt in workspace' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt in workspace' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";

-- auto version:  DAV:checkout-unlocked-checkin
ECHO BOTH "Checking versioning, Pass 5... auto-version: DAV:checkout-unlocked-checkin\n";
update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING = 'B' where COL_ID = DAV_SEARCH_ID ('/DAV/versioning/' ,'C') ;
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " set COL_AUTO_VERSION = B " ": \"" $STATE "\"\t (must be OK)\n";
select DAV_PROP_SET_INT (RES_FULL_PATH, 'DAV:auto-version', 'DAV:checkout-unlocked-checkin', 'dav', 'dav', 1,1,1) from WS.WS.SYS_DAV_RES where RES_COL = DAV_SEARCH_ID ('/DAV/versioning/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " set DAV:auto-version to DAV:checkout-unlocked-checkin " ": \"" $STATE "\"\t (must be OK)\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:auto-version');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:auto-version prop for test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "DAV:checkout-unlocked-checkin" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:auto-version prop for test11.txt " ": \"" $LAST[1] "\"\t (must be: " "DAV:checkout-unlocked-checkin" ")\n";

-- without lock must be equal to DAV:checkout-checkin
select upload_doc ('/DAV/versioning/test11.txt', 'content of test11.txt #1013');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select get_doc ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1013' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1013' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after implicit CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after implicit CHECKIN" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after implicit CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after implicit CHECKIN" ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";


--with lock
select lock_res ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " lock test11.txt"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " lock test11.txt"  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/test11.txt', 'content of test11.txt #1014');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property test11.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";
select isstring (get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-in) after implicit CHECKOUT" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-in) after implicit CHECKOUT" ": \"" $LAST[1] "\"\t (must be: " 0 ")\n";
select get_doc ('/DAV/versioning/VVC/test11.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt VR before CHECKIN " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1013' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt VR before CHECKIN " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1013' ")\n";
select DAV_CHECKIN('/DAV/versioning/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in" ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1014' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1014' ")\n";
select get_doc ('/DAV/versioning/VVC/test11.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR after CHECKIN)" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1014' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR after CHECKIN)" ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1014' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";

select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning/test11.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 4 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 4 ")\n";

select unlock_res ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " unlock test11.txt"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " unlock test11.txt"  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

-- auto_version: DAV:checkout
ECHO BOTH "Checking versioning, Pass 6... auto-version: DAV:checkout\n";
update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING = 'C' where COL_ID = DAV_SEARCH_ID ('/DAV/versioning/' ,'C') ;
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " set COL_AUTO_VERSION = C " ": \"" $STATE "\"\t (must be OK)\n";
select DAV_PROP_SET_INT (RES_FULL_PATH, 'DAV:auto-version', 'DAV:checkout', 'dav', 'dav', 1,1,1) from WS.WS.SYS_DAV_RES where RES_COL = DAV_SEARCH_ID ('/DAV/versioning/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " set DAV:auto-version to DAV:checkout " ": \"" $STATE "\"\t (must be OK)\n";
select upload_doc ('/DAV/versioning/test11.txt', 'content of test11.txt #1015');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property test11.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";
select isstring (get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-in) after implicit CHECKOUT" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-in) after implicit CHECKOUT" ": \"" $LAST[1] "\"\t (must be: " 0 ")\n";
select get_doc ('/DAV/versioning/VVC/test11.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR before CHECKIN) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1014' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR before CHECKIN) " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1014' ")\n";
select DAV_CHECKIN('/DAV/versioning/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checking /DAV/versioning/test11.txt in" ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1015' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1015' ")\n";
select get_doc ('/DAV/versioning/VVC/test11.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR after CHECKIN) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1015' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt (last VR after CHECKIN) " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1015' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after CHECKIN" ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";

select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning/test11.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 5 ")\n";


-- auto_version: DAV:locked-checkout
ECHO BOTH "Checking versioning, Pass 7... auto-version: DAV:locked-checkout\n";
update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING = 'D' where COL_ID = DAV_SEARCH_ID ('/DAV/versioning/' ,'C') ;
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " set COL_AUTO_VERSION = D " ": \"" $STATE "\"\t (must be OK)\n";
select DAV_PROP_SET_INT (RES_FULL_PATH, 'DAV:auto-version', 'DAV:locked-checkout', 'dav', 'dav', 1,1,1) from WS.WS.SYS_DAV_RES where RES_COL = DAV_SEARCH_ID ('/DAV/versioning/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " set DAV:auto-version to DAV:locked-checkout " ": \"" $STATE "\"\t (must be OK)\n";

-- no lock
select upload_doc ('/DAV/versioning/test11.txt', 'content of test11.txt #1016');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";

select get_doc ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1015' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1015' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after implicit CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt after implicit CHECKIN" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after implicit CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after implicit CHECKIN" ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";
select check_file ('/DAV/versioning/workspace!/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check workspace copy " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "not found" "PASSED:" "***FAILED:";
ECHO BOTH " check workspace copy " ": \"" $LAST[1] "\"\t (must be: " "not found" ")\n";

select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning/test11.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 5 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 5 ")\n";


-- with lock
select lock_res ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " lock test11.txt"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " lock test11.txt"  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning/test11.txt', 'content of test11.txt #1017');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property test11.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";
select isstring (get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-in) after implicit CHECKOUT" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-in) after implicit CHECKOUT" ": \"" $LAST[1] "\"\t (must be: " 0 ")\n";
select unlock_res('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " unlock resource " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " unlock resource " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt after implicit CHECKIN " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1017' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt after implicit CHECKIN " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1017' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt  after implicit CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/test11.txt  after implicit CHECKIN" ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after implicit CHECKIN" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in after implicit CHECKIN" ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/test11.txt/last" ")\n";
select check_file ('/DAV/versioning/workspace!/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check workspace copy " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "not found" "PASSED:" "***FAILED:";
ECHO BOTH " check workspace copy " ": \"" $LAST[1] "\"\t (must be: " "not found" ")\n";

select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning/test11.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 6 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 6 ")\n";

-- no lock, new file
select upload_doc ('/DAV/versioning/newfile.txt', 'content of newfile.txt #1017');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file newfile.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file newfile.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_prop ('/DAV/versioning/newfile.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in property newfile.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning/VVC/newfile.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in property newfile.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning/VVC/newfile.txt/last" ")\n";
select isstring (get_prop ('/DAV/versioning/newfile.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-out) " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " isstring (DAV:checked-out) " ": \"" $LAST[1] "\"\t (must be: " 0 ")\n";
select get_doc ('/DAV/versioning/newfile.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of newfile.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of newfile.txt #1017' "PASSED:" "***FAILED:";
ECHO BOTH " check content of newfile.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of newfile.txt #1017' ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning/newfile.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/newfile.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-out property /DAV/versioning/newfile.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning/newfile.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";

DB.DBA.DAV_DELETE ('/DAV/versioning2/', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Deleting second versioning collection"  ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/versioning2/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_docs ('/DAV/versioning2/', 20);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/versioning2/ " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/versioning2/ " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_VERSION_CONTROL ('/DAV/versioning2/test12.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = DAV_SEARCH_ID ('/DAV/versioning2/VVC/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check COL_DET column " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] Versioning "PASSED:" "***FAILED:";
ECHO BOTH  " check COL_DET column " ": \"" $LAST[1] "\"\t (must be: " Versioning ")\n";
select get_prop ('/DAV/versioning2/test12.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test12.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning2/VVC/test12.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test12.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning2/VVC/test12.txt/last" ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test12.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test12.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test12.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc_v ('/DAV/versioning2/test12.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check first version of test12.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "hello world! - 12" "PASSED:" "***FAILED:";
ECHO BOTH " check first version of test12.txt " ": \"" $LAST[1] "\"\t (must be: " "hello world! - 12" ")\n";
select DB.DBA.DAV_VERSION_CONTROL ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning2/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning2/VVC/test11.txt/last" ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DB.DBA.DAV_VERSION_CONTROL ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt, second attempt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt, second attempt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc_v ('/DAV/versioning2/test11.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check first version of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "hello world! - 11" "PASSED:" "***FAILED:";
ECHO BOTH " check first version of test11.txt " ": \"" $LAST[1] "\"\t (must be: " "hello world! - 11" ")\n";


-- uncheckout
select DAV_CHECKOUT ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select  DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-out');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning2/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning2/VVC/test11.txt/last" ")\n";
select upload_doc ('/DAV/versioning2/test11.txt', 'content of test11.txt #1000');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_UNCHECKOUT ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-in');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "/DAV/versioning2/VVC/test11.txt/last" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " "/DAV/versioning2/VVC/test11.txt/last" ")\n";
select DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select get_doc ('/DAV/versioning2/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 11' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 11' ")\n";

select upload_doc ('/DAV/versioning2/test11.txt', 'content of test11.txt #1000');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt in checked-in file no auto-version" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt in checked-in file no auto-version" ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";
select DAV_PROP_SET ('/DAV/versioning2/test11.txt', 'DAV:auto-version', 'DAV:checkout-checkin', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set virt:Version-Collection "  ": \"" $STATE "\"\t (must be OK)\n";
select upload_doc ('/DAV/versioning2/test11.txt', 'content of test11.txt #1001');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt in checked-in file auto-version=DAV:checkout-checkin " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt in checked-in file auto-version=DAV:checkout-checkin " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/versioning2/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1001' "PASSED:" "***FAILED:";
ECHO BOTH " check content of test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1001' ")\n";
select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning2/test11.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 2 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 2 ")\n";
select get_doc_v ('/DAV/versioning2/test11.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of ver1 test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 11' "PASSED:" "***FAILED:";
ECHO BOTH " check content of ver1 test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 11' ")\n";
select get_doc_v ('/DAV/versioning2/test11.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check content of ver2 test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of test11.txt #1001' "PASSED:" "***FAILED:";
ECHO BOTH " check content of ver2 test11.txt " ": \"" $LAST[1] "\"\t (must be: " 'content of test11.txt #1001' ")\n";

select DAV_PROP_REMOVE ('/DAV/versioning2/test11.txt', 'DAV:auto-version', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " unset auto-version "  ": \"" $STATE "\"\t (must be OK)\n";
select prop_set ('/DAV/versioning2/test11.txt', vector ('my:prop1', 'prop1val', 'my:prop2', 'prop2val'), NULL);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set new properties to checked-in VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] -1 "PASSED:" "***FAILED:";
ECHO BOTH  " set new properties to checked-in VCR "  ": \"" $LAST[1] "\"\t (must be: " -1 ")\n";
select DAV_CHECKOUT ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select prop_set ('/DAV/versioning2/test11.txt', vector ('my:prop1', 'prop1val', 'my:prop2', 'prop2val'), NULL);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set new properties to checked-in VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " set new properties to checked-in VCR "  ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop1'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_CHECKIN ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkin test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkin test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning2/test11.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 3 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 3 ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'my:prop1'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "prop1val" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $LAST[1] "\"\t (must be: " "prop1val" ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "prop2val" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $LAST[1] "\"\t (must be: " "prop2val" ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop1'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "prop1val" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $LAST[1] "\"\t (must be: " "prop1val" ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "prop2val" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $LAST[1] "\"\t (must be: " "prop2val" ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop3'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_CHECKOUT ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select prop_set ('/DAV/versioning2/test11.txt', NULL, vector ('my:prop1'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " delete a property my:prop1 from VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " delete a property my:prop1 from VCR "  ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select DAV_CHECKIN ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkin test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkin test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'my:prop1'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "prop2val" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from checked-out VCR "  ": \"" $LAST[1] "\"\t (must be: " "prop2val" ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop1'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] "prop2val" "PASSED:" "***FAILED:";
ECHO BOTH  " get new property from last VR "  ": \"" $LAST[1] "\"\t (must be: " "prop2val" ")\n";


-- uncheckout properties
select DAV_CHECKOUT ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkout test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select prop_set ('/DAV/versioning2/test11.txt', vector ('my:prop3', 'prop3val', 'my:prop4', 'prop4val'), vector ('my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set new properties and delete my:prop2 to checked-in VCR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " set new properties and delete my:prop2 to checked-in VCR "  ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select DAV_UNCHECKOUT ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout test11.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop3'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop4'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/VVC/test11.txt/last', 'my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get existing property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] prop2val "PASSED:" "***FAILED:";
ECHO BOTH  " get existing property from last VR "  ": \"" $LAST[1] "\"\t (must be: " prop2val ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'my:prop3'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'my:prop4'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " get non-existing property from last VR "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'my:prop2'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " get existing property from last VR "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] prop2val "PASSED:" "***FAILED:";
ECHO BOTH  " get existing property from last VR "  ": \"" $LAST[1] "\"\t (must be: " prop2val ")\n";

select DAV_DELETE ('/DAV/versioning/VVC/test11.txt/4', 0, 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " old versions delete " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " old versions delete " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select xpath_eval ('count (//version)', xtree_doc (get_doc_v_2 ('/DAV/versioning/VVC', 'test11.txt', 'history.xml')));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 2 "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history " ": \"" $LAST[1] "\"\t (must be: " 2 ")\n";
select count (*) from ws.ws.sys_dav_res_version where rv_res_id = dav_search_id ('/DAV/versioning/test11.txt', 'R');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 2 "PASSED:" "***FAILED:";
ECHO BOTH " count of versions in ws.ws.sys_dav_res_version table " ": \"" $LAST[1] "\"\t (must be: " 2 ")\n";


-- implicit restore of the file not working

select DAV_DELETE ('/DAV/versioning2/VVC/test11.txt/last', 0, 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " delete resource test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " delete resource test11.txt " ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select check_file ('/DAV/versioning2/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt removed " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt removed " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select check_file ('/DAV/versioning2/Attic/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt in Attic " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt in Attic " ": \"" $LAST[1] "\"\t (must be: " 'found' ")\n";
select upload_doc ('/DAV/versioning2/test11.txt', 'content of test11.txt over delete file');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt over delete file " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file test11.txt over delete file " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DB.DBA.DAV_VERSION_CONTROL ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text11.txt, second attempt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text11.txt, second attempt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select xpath_eval ('number(count(/*/version))', xtree_doc (get_doc ('/DAV/versioning2/VVC/test11.txt/history.xml')));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " number of versions of implicitly restored file "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " number of versions of implicitly restored file "  ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select check_file ('/DAV/versioning2/Attic/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt in Attic " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt in Attic " ": \"" $LAST[1] "\"\t (must be: " 'found' ")\n";

select DB.DBA.DAV_REMOVE_VERSION_CONTROL ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text11.txt has been turned off "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text11.txt has been turned off "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-out'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-out property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop ('/DAV/versioning2/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " check DAV:checked-in property of test11.txt " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select check_file ('/DAV/versioning2/Attic/test11.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt in Attic " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is test11.txt in Attic " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select check_file ('/DAV/versioning2/VVC/test11.txt/1');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is first version test11.txt in VVC " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is first version test11.txt in VVC " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select check_file ('/DAV/versioning2/VVC/test11.txt/last');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is last version of test11.txt in VVC " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'not found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is last version of test11.txt in VVC " ": \"" $LAST[1] "\"\t (must be: " 'not found' ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'DAV:author'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:author property "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:author property "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/versioning2/test11.txt', 'DAV:version-history'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select check_file ('/DAV/versioning2/Attic/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check is last version of test11.txt in VVC " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'found' "PASSED:" "***FAILED:";
ECHO BOTH  " check is last version of test11.txt in VVC " ": \"" $LAST[1] "\"\t (must be: " 'found' ")\n";

select DB.DBA.DAV_REMOVE_VERSION_CONTROL ('/DAV/versioning2/test11.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " second attempt to turn off versioning  "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " second attempt to turn off versioning  "  ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";
select DB.DBA.DAV_REMOVE_VERSION_CONTROL ('/DAV/versioning2/', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " attempt to turn off versioning on wrong resource "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " attempt to turn off versioning on wrong resource "  ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";
select DB.DBA.DAV_REMOVE_VERSION_CONTROL ('/DAV/versioning2/dfgdfg', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " attempt to turn off versioning on wrong resource "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " attempt to turn off versioning on wrong resource "  ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";
select DB.DBA.DAV_REMOVE_VERSION_CONTROL ('/DAV/versioning2/test9.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " attempt to turn off versioning on wrong resource "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " attempt to turn off versioning on wrong resource "  ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";




-- reset versioning control
ECHO BOTH "Checking versioning, Pass 1R ... set version control\n";

DB.DBA.DAV_DELETE ('/DAV/vers_test/', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Deleting versioning collection"  ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/vers_test/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING='A' where COL_ID = DAV_SEARCH_ID ('/DAV/vers_test/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Set Versioning control on " ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/vers_test/VVC/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create VVC test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create VVC test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/vers_test/Attic/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create Attic test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create Attic test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DB.DBA.DAV_SET_VERSIONING_CONTROL ('/DAV/vers_test/', NULL, 'A', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_docs ('/DAV/vers_test/', 20);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/vers_test/ " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/vers_test/ " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DAV_REMOVE_VERSIONING_CONTROL_INT ('/DAV/vers_test/', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " unset auto-version "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " unset auto-version "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/vers_test/test11.txt', 'DAV:author'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:author property "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:author property "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/vers_test/test11.txt', 'DAV:version-history'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/vers_test/test11.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR(get_prop('/DAV/vers_test/test11.txt', 'DAV:auto-version'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH  " check DAV:version-history property "  ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";

select DB.DBA.DAV_SET_VERSIONING_CONTROL ('/DAV/vers_test/', NULL, 'A', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control again "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control again "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";


DB.DBA.DAV_DELETE ('/DAV/vers_test/', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Deleting versioning collection"  ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/vers_test/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING='A' where COL_ID = DAV_SEARCH_ID ('/DAV/vers_test/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Set Versioning control on " ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/vers_test/VVC/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create VVC test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create VVC test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/vers_test/Attic/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create Attic test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create Attic test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DB.DBA.DAV_SET_VERSIONING_CONTROL ('/DAV/vers_test/', NULL, 'A', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_docs ('/DAV/vers_test/', 20);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/vers_test/ " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/vers_test/ " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_SET_VERSIONING_CONTROL ('/DAV/vers_test/', NULL, 'A', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control again "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control again "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

ECHO BOTH "Bug 9958 check\n";

select upload_doc ('/DAV/versioning2/1.txt', 'content of test1.txt #1000');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DB.DBA.DAV_VERSION_CONTROL ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text1.txt, second attempt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text1.txt, second attempt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_PROP_SET ('/DAV/versioning2/1.txt', 'DAV:auto-version', 'DAV:checkout-checkin', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set DAV:auto-version "  ": \"" $STATE "\"\t (must be OK)\n";
select upload_doc ('/DAV/versioning2/1.txt', 'content of test1.txt #');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_DELETE ('/DAV/versioning2/VVC/1.txt/1', 0, 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " old versions delete " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " old versions delete " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_CHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_UNCHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_CHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_UNCHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_UNCHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";
select DAV_CHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_CHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH " checkout 1.txt " ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";
select DAV_UNCHECKOUT ('/DAV/versioning2/1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " uncheckout 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

ECHO BOTH "set wrong auto-version value\n";
select DAV_PROP_SET ('/DAV/versioning2/1.txt', 'DAV:auto-version', 'DAV:checkin-checkout', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set DAV:auto-version "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " set DAV:auto-version "  ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";

ECHO BOTH "Bug 9959\n";
select upload_doc ('/DAV/versioning2/1.txt', 'content of test1.txt #1');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file 1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " upload new content of file 1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_res_prop ('/DAV/versioning2/VVC/1.txt/', '2', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " size of 2nd version " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 22 "PASSED:" "***FAILED:";
ECHO BOTH " size of 2nd version " ": \"" $LAST[1] "\"\t (must be: " 22 ")\n";
select get_res_prop ('/DAV/versioning2/VVC/1.txt/', '3', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " size of 3d version " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 23 "PASSED:" "***FAILED:";
ECHO BOTH " size of 3d version " ": \"" $LAST[1] "\"\t (must be: " 23 ")\n";
select get_res_prop ('/DAV/versioning/VVC/test11.txt/', '6', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " size of /DAV/versioning/VVC/test11.txt/6 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 27 "PASSED:" "***FAILED:";
ECHO BOTH " size of /DAV/versioning/VVC/test11.txt/6 " ": \"" $LAST[1] "\"\t (must be: " 27 ")\n";



ECHO BOTH "deleting VVC folder, check consistency\n";
select DAV_DELETE ('/DAV/versioning2/VVC/', 0, 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " delete VVC folder " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " delete VVC folder " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select count(*) from WS.WS.SYS_DAV_RES_DIFF inner join WS.WS.SYS_DAV_RES on (RD_RES_ID = RES_ID) where RES_COL = DAV_SEARCH_ID ('/DAV/versioning2/', 'C');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " number of files under version control after VVC removed " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " number of files under version control after VVC removed " ": \"" $LAST[1] "\"\t (must be: " 0 ")\n";

select DAV_HIDE_ERROR (get_prop('/DAV/versioning2/1.txt', 'DAV:author'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:author property " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:author property " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR (get_prop('/DAV/versioning2/1.txt', 'DAV:auto-version'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:auto-version property " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:auto-version property " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR (get_prop('/DAV/versioning2/1.txt', 'DAV:checked-in'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in property " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:checked-in property " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";
select DAV_HIDE_ERROR (get_prop('/DAV/versioning2/1.txt', 'DAV:version-history'));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " DAV:version-history property " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] NULL "PASSED:" "***FAILED:";
ECHO BOTH " DAV:version-history property " ": \"" $LAST[1] "\"\t (must be: " NULL ")\n";


ECHO BOTH "wrapping several versions in one\n";
DB.DBA.DAV_DELETE ('/DAV/versioning3/', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Deleting second versioning collection"  ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/versioning3/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning3/file1.txt', 'content of file1.txt, version 1');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload initial version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DB.DBA.DAV_VERSION_CONTROL ('/DAV/versioning3/file1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_PROP_SET ('/DAV/versioning3/file1.txt', 'DAV:auto-version', 'DAV:checkout-checkin', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set DAV:auto-version "  ": \"" $STATE "\"\t (must be OK)\n";
select upload_doc ('/DAV/versioning3/file1.txt', 'content of file1.txt, version 2');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload second version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning3/file1.txt', 'content of file1.txt, version 3');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_doc ('/DAV/versioning3/file1.txt', 'content of file1.txt, version 4');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload fourth version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload fourth version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select xpath_eval ('count (//version)', xtree_doc (get_doc_v_2 ('/DAV/versioning3/VVC', 'file1.txt', 'history.xml')));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 4 "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history " ": \"" $LAST[1] "\"\t (must be: " 4 ")\n";
select DAV_VERSION_FOLD_INT ('/DAV/versioning3/file1.txt', 2, 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " folding versions to version 2 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " folding versions to version 2 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select xpath_eval ('count (//version)', xtree_doc (get_doc_v_2 ('/DAV/versioning3/VVC', 'file1.txt', 'history.xml')));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history after folding" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 2 "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history after folding" ": \"" $LAST[1] "\"\t (must be: " 2 ")\n";
select get_doc_v ('/DAV/versioning3/file1.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check the content of first version " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 1' "PASSED:" "***FAILED:";
ECHO BOTH  " check the content of first version " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 1' ")\n";
select get_doc ('/DAV/versioning3/file1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check the content of last version " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 4' "PASSED:" "***FAILED:";
ECHO BOTH  " check the content of last version " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 4' ")\n";
select upload_doc ('/DAV/versioning3/file1.txt', 'content of file1.txt, version 5');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " upload third version of file1.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_VERSION_FOLD_INT ('/DAV/versioning3/file1.txt', 1, 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " folding versions to version 1 " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " folding versions to version 1 " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select xpath_eval ('count (//version)', xtree_doc (get_doc_v_2 ('/DAV/versioning3/VVC', 'file1.txt', 'history.xml')));
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history after folding" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 1 "PASSED:" "***FAILED:";
ECHO BOTH  " check number of versions in history after folding" ": \"" $LAST[1] "\"\t (must be: " 1 ")\n";
select get_doc ('/DAV/versioning3/file1.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check the content of last version " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'content of file1.txt, version 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check the content of last version " ": \"" $LAST[1] "\"\t (must be: " 'content of file1.txt, version 5' ")\n";



-- DAV_COPY test

DB.DBA.DAV_DELETE ('/DAV/vers_copy/', 1, 'dav','dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Delete versioning collection"  ": \"" $STATE "\"\t (must be OK)\n";
select DB.DBA.DAV_COL_CREATE ('/DAV/vers_copy/', '110100000R', 'dav', 'administrators', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " Create test collection: " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select upload_docs ('/DAV/vers_copy/', 20);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/vers_copy/ " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " Upload docs to collection /DAV/vers_copy/ " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select DB.DBA.DAV_VERSION_CONTROL ('/DAV/vers_copy/test1.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text1.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text1.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_PROP_SET ('/DAV/vers_copy/test1.txt', 'DAV:auto-version', 'DAV:checkout-checkin', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set auto-version for test1.txt "  ": \"" $STATE "\"\t (must be OK)\n";

select DB.DBA.DAV_VERSION_CONTROL ('/DAV/vers_copy/test2.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text2.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_PROP_SET ('/DAV/vers_copy/test2.txt', 'DAV:auto-version', 'DAV:checkout-checkin', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set auto-version for test2.txt "  ": \"" $STATE "\"\t (must be OK)\n";

select copy ('/DAV/vers_copy/test3.txt', '/DAV/vers_copy/test2.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " copy test3.txt to test2.txtt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " copy test3.txt to test2.txtt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";

select get_doc_v_2 ('/DAV/vers_copy/VVC', 'test2.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file2.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 2' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file2.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 2' ")\n";
select get_doc_v_2 ('/DAV/vers_copy/VVC', 'test2.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file2.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 3' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file2.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 3' ")\n";


-- DAV_COPY test # 2

select DB.DBA.DAV_VERSION_CONTROL ('/DAV/vers_copy/test4.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text4.txt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " set versioning control on text4.txt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_PROP_SET ('/DAV/vers_copy/test4.txt', 'DAV:auto-version', 'DAV:locked-checkout', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " set auto-version for test4.txt "  ": \"" $STATE "\"\t (must be OK)\n";
select lock_res ('/DAV/vers_copy/test4.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " lock test4.txt"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " lock test4.txt"  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select copy ('/DAV/vers_copy/test5.txt', '/DAV/vers_copy/test4.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " copy test5.txt to test4.txtt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " copy test5.txt to test4.txtt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select DAV_CHECKIN ('/DAV/vers_copy/test4.txt', 'dav', 'dav');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH " checkin test4.txt " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH " checkin test4.txt " ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc_v_2 ('/DAV/vers_copy/VVC', 'test4.txt', 1);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check prev version of file4.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 4' "PASSED:" "***FAILED:";
ECHO BOTH  " check prev version of file4.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 4' ")\n";
select get_doc_v_2 ('/DAV/vers_copy/VVC', 'test4.txt', 2);
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file4.txt by DET " ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 5' "PASSED:" "***FAILED:";
ECHO BOTH  " check last version of file4.txt by DET " ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 5' ")\n";

select copy ('/DAV/vers_copy/test7.txt', '/DAV/vers_copy/test6.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " copy test7.txt to test6.txtt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " copy test7.txt to test6.txtt "  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select get_doc ('/DAV/vers_copy/test6.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check content of test6" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 7' "PASSED:" "***FAILED:";
ECHO BOTH  " check content of test6" ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 7' ")\n";
select lock_res ('/DAV/vers_copy/test6.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " lock test6.txt"  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT $LAST[1] 0 "PASSED:" "***FAILED:";
ECHO BOTH  " lock test6.txt"  ": \"" $LAST[1] "\"\t (must be greater than " 0 ")\n";
select copy ('/DAV/vers_copy/test8.txt', '/DAV/vers_copy/test6.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " copy test8.txt to test6.txtt "  ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $GT 0 $LAST[1] "PASSED:" "***FAILED:";
ECHO BOTH  " copy test8.txt to test6.txtt "  ": \"" $LAST[1] "\"\t (must be less than " 0 ")\n";
select get_doc ('/DAV/vers_copy/test6.txt');
ECHO BOTH $IF $EQU $STATE "OK" "PASSED:" "***FAILED:";
ECHO BOTH  " check content of test6" ": \"" $STATE "\"\t (must be OK)\n";
ECHO BOTH $IF $EQU $LAST[1] 'hello world! - 7' "PASSED:" "***FAILED:";
ECHO BOTH  " check content of test6" ": \"" $LAST[1] "\"\t (must be: " 'hello world! - 7' ")\n";
